// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Configuration information for Organizations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationConfiguration {
    /// <p>Enables Organizations integration.</p>
    pub enable_integration: bool,
}
impl OrganizationConfiguration {
    /// <p>Enables Organizations integration.</p>
    pub fn enable_integration(&self) -> bool {
        self.enable_integration
    }
}
impl std::fmt::Debug for OrganizationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationConfiguration");
        formatter.field("enable_integration", &self.enable_integration);
        formatter.finish()
    }
}
/// See [`OrganizationConfiguration`](crate::model::OrganizationConfiguration)
pub mod organization_configuration {
    /// A builder for [`OrganizationConfiguration`](crate::model::OrganizationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_integration: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables Organizations integration.</p>
        pub fn enable_integration(mut self, input: bool) -> Self {
            self.enable_integration = Some(input);
            self
        }
        /// <p>Enables Organizations integration.</p>
        pub fn set_enable_integration(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_integration = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationConfiguration`](crate::model::OrganizationConfiguration)
        pub fn build(self) -> crate::model::OrganizationConfiguration {
            crate::model::OrganizationConfiguration {
                enable_integration: self.enable_integration.unwrap_or_default(),
            }
        }
    }
}
impl OrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`OrganizationConfiguration`](crate::model::OrganizationConfiguration)
    pub fn builder() -> crate::model::organization_configuration::Builder {
        crate::model::organization_configuration::Builder::default()
    }
}

/// <p>Details for associating a license configuration with a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseSpecification {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
    pub ami_association_scope: std::option::Option<std::string::String>,
}
impl LicenseSpecification {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
    pub fn ami_association_scope(&self) -> std::option::Option<&str> {
        self.ami_association_scope.as_deref()
    }
}
impl std::fmt::Debug for LicenseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseSpecification");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field("ami_association_scope", &self.ami_association_scope);
        formatter.finish()
    }
}
/// See [`LicenseSpecification`](crate::model::LicenseSpecification)
pub mod license_specification {
    /// A builder for [`LicenseSpecification`](crate::model::LicenseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) ami_association_scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
        pub fn ami_association_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_association_scope = Some(input.into());
            self
        }
        /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
        pub fn set_ami_association_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ami_association_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseSpecification`](crate::model::LicenseSpecification)
        pub fn build(self) -> crate::model::LicenseSpecification {
            crate::model::LicenseSpecification {
                license_configuration_arn: self.license_configuration_arn,
                ami_association_scope: self.ami_association_scope,
            }
        }
    }
}
impl LicenseSpecification {
    /// Creates a new builder-style object to manufacture [`LicenseSpecification`](crate::model::LicenseSpecification)
    pub fn builder() -> crate::model::license_specification::Builder {
        crate::model::license_specification::Builder::default()
    }
}

/// <p>Details about how frequently reports are generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportFrequency {
    /// <p>Number of times within the frequency period that a report is generated.  
    /// The only supported value is <code>1</code>.</p>
    pub value: std::option::Option<i32>,
    /// <p>Time period between each report. The period can be daily, weekly, or monthly.</p>
    pub period: std::option::Option<crate::model::ReportFrequencyType>,
}
impl ReportFrequency {
    /// <p>Number of times within the frequency period that a report is generated.  
    /// The only supported value is <code>1</code>.</p>
    pub fn value(&self) -> std::option::Option<i32> {
        self.value
    }
    /// <p>Time period between each report. The period can be daily, weekly, or monthly.</p>
    pub fn period(&self) -> std::option::Option<&crate::model::ReportFrequencyType> {
        self.period.as_ref()
    }
}
impl std::fmt::Debug for ReportFrequency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportFrequency");
        formatter.field("value", &self.value);
        formatter.field("period", &self.period);
        formatter.finish()
    }
}
/// See [`ReportFrequency`](crate::model::ReportFrequency)
pub mod report_frequency {
    /// A builder for [`ReportFrequency`](crate::model::ReportFrequency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<i32>,
        pub(crate) period: std::option::Option<crate::model::ReportFrequencyType>,
    }
    impl Builder {
        /// <p>Number of times within the frequency period that a report is generated.  
        /// The only supported value is <code>1</code>.</p>
        pub fn value(mut self, input: i32) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>Number of times within the frequency period that a report is generated.  
        /// The only supported value is <code>1</code>.</p>
        pub fn set_value(mut self, input: std::option::Option<i32>) -> Self {
            self.value = input;
            self
        }
        /// <p>Time period between each report. The period can be daily, weekly, or monthly.</p>
        pub fn period(mut self, input: crate::model::ReportFrequencyType) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>Time period between each report. The period can be daily, weekly, or monthly.</p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::ReportFrequencyType>,
        ) -> Self {
            self.period = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportFrequency`](crate::model::ReportFrequency)
        pub fn build(self) -> crate::model::ReportFrequency {
            crate::model::ReportFrequency {
                value: self.value,
                period: self.period,
            }
        }
    }
}
impl ReportFrequency {
    /// Creates a new builder-style object to manufacture [`ReportFrequency`](crate::model::ReportFrequency)
    pub fn builder() -> crate::model::report_frequency::Builder {
        crate::model::report_frequency::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportFrequencyType {
    #[allow(missing_docs)] // documentation missing in model
    Day,
    #[allow(missing_docs)] // documentation missing in model
    Month,
    #[allow(missing_docs)] // documentation missing in model
    Week,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportFrequencyType {
    fn from(s: &str) -> Self {
        match s {
            "DAY" => ReportFrequencyType::Day,
            "MONTH" => ReportFrequencyType::Month,
            "WEEK" => ReportFrequencyType::Week,
            other => ReportFrequencyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportFrequencyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportFrequencyType::from(s))
    }
}
impl ReportFrequencyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportFrequencyType::Day => "DAY",
            ReportFrequencyType::Month => "MONTH",
            ReportFrequencyType::Week => "WEEK",
            ReportFrequencyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAY", "MONTH", "WEEK"]
    }
}
impl AsRef<str> for ReportFrequencyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of the license configuration that this generator reports on.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportContext {
    /// <p>Amazon Resource Name (ARN) of the license configuration that this generator reports on.</p>
    pub license_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReportContext {
    /// <p>Amazon Resource Name (ARN) of the license configuration that this generator reports on.</p>
    pub fn license_configuration_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.license_configuration_arns.as_deref()
    }
}
impl std::fmt::Debug for ReportContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportContext");
        formatter.field(
            "license_configuration_arns",
            &self.license_configuration_arns,
        );
        formatter.finish()
    }
}
/// See [`ReportContext`](crate::model::ReportContext)
pub mod report_context {
    /// A builder for [`ReportContext`](crate::model::ReportContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `license_configuration_arns`.
        ///
        /// To override the contents of this collection use [`set_license_configuration_arns`](Self::set_license_configuration_arns).
        ///
        /// <p>Amazon Resource Name (ARN) of the license configuration that this generator reports on.</p>
        pub fn license_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_configuration_arns.unwrap_or_default();
            v.push(input.into());
            self.license_configuration_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration that this generator reports on.</p>
        pub fn set_license_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_configuration_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportContext`](crate::model::ReportContext)
        pub fn build(self) -> crate::model::ReportContext {
            crate::model::ReportContext {
                license_configuration_arns: self.license_configuration_arns,
            }
        }
    }
}
impl ReportContext {
    /// Creates a new builder-style object to manufacture [`ReportContext`](crate::model::ReportContext)
    pub fn builder() -> crate::model::report_context::Builder {
        crate::model::report_context::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportType {
    #[allow(missing_docs)] // documentation missing in model
    LicenseConfigurationSummaryReport,
    #[allow(missing_docs)] // documentation missing in model
    LicenseConfigurationUsageReport,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportType {
    fn from(s: &str) -> Self {
        match s {
            "LicenseConfigurationSummaryReport" => ReportType::LicenseConfigurationSummaryReport,
            "LicenseConfigurationUsageReport" => ReportType::LicenseConfigurationUsageReport,
            other => ReportType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportType::from(s))
    }
}
impl ReportType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportType::LicenseConfigurationSummaryReport => "LicenseConfigurationSummaryReport",
            ReportType::LicenseConfigurationUsageReport => "LicenseConfigurationUsageReport",
            ReportType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LicenseConfigurationSummaryReport",
            "LicenseConfigurationUsageReport",
        ]
    }
}
impl AsRef<str> for ReportType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes product information for a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductInformation {
    /// <p>Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
    /// <p>Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid options for <code>ProductInformationFilterComparator</code>. </p>
    /// <p>The following filters and are supported when the resource type
    /// is <code>SSM_MANAGED</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Application Name</code> - The name of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Application Publisher</code> - The publisher of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Application Version</code> - The version of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Platform Name</code> - The name of the platform.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Platform Type</code> - The platform type.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>.  The key for your tag must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>. <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery.
    /// Logical operator is <code>NOT_EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>License Included</code> - The type of license included.
    /// Logical operators are <code>EQUALS</code> and <code>NOT_EQUALS</code>.
    /// Possible values are: <code>sql-server-enterprise</code> |
    /// <code>sql-server-standard</code> |
    /// <code>sql-server-web</code> |  
    /// <code>windows-server-datacenter</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The following filters and logical operators are supported when the resource type
    /// is <code>RDS</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Engine Edition</code> - The edition of the database engine.
    /// Logical operator is <code>EQUALS</code>.
    /// Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> | <code>oracle-se2</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>License Pack</code> - The license pack.
    /// Logical operator is <code>EQUALS</code>.
    /// Possible values are: <code>data guard</code> |
    /// <code>diagnostic pack sqlt</code> |
    /// <code>tuning pack sqlt</code> |
    /// <code>ols</code> |
    /// <code>olap</code>.</p>
    /// </li>
    /// </ul>
    pub product_information_filter_list:
        std::option::Option<std::vec::Vec<crate::model::ProductInformationFilter>>,
}
impl ProductInformation {
    /// <p>Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
    /// <p>Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid options for <code>ProductInformationFilterComparator</code>. </p>
    /// <p>The following filters and are supported when the resource type
    /// is <code>SSM_MANAGED</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Application Name</code> - The name of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Application Publisher</code> - The publisher of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Application Version</code> - The version of the application.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Platform Name</code> - The name of the platform.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Platform Type</code> - The platform type.
    /// Logical operator is <code>EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>.  The key for your tag must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>. <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery.
    /// Logical operator is <code>NOT_EQUALS</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>License Included</code> - The type of license included.
    /// Logical operators are <code>EQUALS</code> and <code>NOT_EQUALS</code>.
    /// Possible values are: <code>sql-server-enterprise</code> |
    /// <code>sql-server-standard</code> |
    /// <code>sql-server-web</code> |  
    /// <code>windows-server-datacenter</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The following filters and logical operators are supported when the resource type
    /// is <code>RDS</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Engine Edition</code> - The edition of the database engine.
    /// Logical operator is <code>EQUALS</code>.
    /// Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> | <code>oracle-se2</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>License Pack</code> - The license pack.
    /// Logical operator is <code>EQUALS</code>.
    /// Possible values are: <code>data guard</code> |
    /// <code>diagnostic pack sqlt</code> |
    /// <code>tuning pack sqlt</code> |
    /// <code>ols</code> |
    /// <code>olap</code>.</p>
    /// </li>
    /// </ul>
    pub fn product_information_filter_list(
        &self,
    ) -> std::option::Option<&[crate::model::ProductInformationFilter]> {
        self.product_information_filter_list.as_deref()
    }
}
impl std::fmt::Debug for ProductInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductInformation");
        formatter.field("resource_type", &self.resource_type);
        formatter.field(
            "product_information_filter_list",
            &self.product_information_filter_list,
        );
        formatter.finish()
    }
}
/// See [`ProductInformation`](crate::model::ProductInformation)
pub mod product_information {
    /// A builder for [`ProductInformation`](crate::model::ProductInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) product_information_filter_list:
            std::option::Option<std::vec::Vec<crate::model::ProductInformationFilter>>,
    }
    impl Builder {
        /// <p>Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>Resource type. The possible values are <code>SSM_MANAGED</code> | <code>RDS</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `product_information_filter_list`.
        ///
        /// To override the contents of this collection use [`set_product_information_filter_list`](Self::set_product_information_filter_list).
        ///
        /// <p>A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
        /// <p>Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid options for <code>ProductInformationFilterComparator</code>. </p>
        /// <p>The following filters and are supported when the resource type
        /// is <code>SSM_MANAGED</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Application Name</code> - The name of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Application Publisher</code> - The publisher of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Application Version</code> - The version of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Platform Name</code> - The name of the platform.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Platform Type</code> - The platform type.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>.  The key for your tag must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>. <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery.
        /// Logical operator is <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>License Included</code> - The type of license included.
        /// Logical operators are <code>EQUALS</code> and <code>NOT_EQUALS</code>.
        /// Possible values are: <code>sql-server-enterprise</code> |
        /// <code>sql-server-standard</code> |
        /// <code>sql-server-web</code> |  
        /// <code>windows-server-datacenter</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The following filters and logical operators are supported when the resource type
        /// is <code>RDS</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Engine Edition</code> - The edition of the database engine.
        /// Logical operator is <code>EQUALS</code>.
        /// Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> | <code>oracle-se2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>License Pack</code> - The license pack.
        /// Logical operator is <code>EQUALS</code>.
        /// Possible values are: <code>data guard</code> |
        /// <code>diagnostic pack sqlt</code> |
        /// <code>tuning pack sqlt</code> |
        /// <code>ols</code> |
        /// <code>olap</code>.</p>
        /// </li>
        /// </ul>
        pub fn product_information_filter_list(
            mut self,
            input: impl Into<crate::model::ProductInformationFilter>,
        ) -> Self {
            let mut v = self.product_information_filter_list.unwrap_or_default();
            v.push(input.into());
            self.product_information_filter_list = Some(v);
            self
        }
        /// <p>A Product information filter consists of a <code>ProductInformationFilterComparator</code> which is a logical operator, a <code>ProductInformationFilterName</code> which specifies the type of filter being declared, and a <code>ProductInformationFilterValue</code> that specifies the value to filter on. </p>
        /// <p>Accepted values for <code>ProductInformationFilterName</code> are listed here along with descriptions and valid options for <code>ProductInformationFilterComparator</code>. </p>
        /// <p>The following filters and are supported when the resource type
        /// is <code>SSM_MANAGED</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Application Name</code> - The name of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Application Publisher</code> - The publisher of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Application Version</code> - The version of the application.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Platform Name</code> - The name of the platform.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Platform Type</code> - The platform type.
        /// Logical operator is <code>EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Tag:key</code> - The key of a tag attached to an Amazon Web Services resource you wish to exclude from automated discovery. Logical operator is <code>NOT_EQUALS</code>.  The key for your tag must be appended to <code>Tag:</code> following the example: <code>Tag:name-of-your-key</code>. <code>ProductInformationFilterValue</code> is optional if you are not using values for the key.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AccountId</code> - The 12-digit ID of an Amazon Web Services account you wish to exclude from automated discovery.
        /// Logical operator is <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>License Included</code> - The type of license included.
        /// Logical operators are <code>EQUALS</code> and <code>NOT_EQUALS</code>.
        /// Possible values are: <code>sql-server-enterprise</code> |
        /// <code>sql-server-standard</code> |
        /// <code>sql-server-web</code> |  
        /// <code>windows-server-datacenter</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The following filters and logical operators are supported when the resource type
        /// is <code>RDS</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Engine Edition</code> - The edition of the database engine.
        /// Logical operator is <code>EQUALS</code>.
        /// Possible values are: <code>oracle-ee</code> | <code>oracle-se</code> | <code>oracle-se1</code> | <code>oracle-se2</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>License Pack</code> - The license pack.
        /// Logical operator is <code>EQUALS</code>.
        /// Possible values are: <code>data guard</code> |
        /// <code>diagnostic pack sqlt</code> |
        /// <code>tuning pack sqlt</code> |
        /// <code>ols</code> |
        /// <code>olap</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_product_information_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformationFilter>>,
        ) -> Self {
            self.product_information_filter_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductInformation`](crate::model::ProductInformation)
        pub fn build(self) -> crate::model::ProductInformation {
            crate::model::ProductInformation {
                resource_type: self.resource_type,
                product_information_filter_list: self.product_information_filter_list,
            }
        }
    }
}
impl ProductInformation {
    /// Creates a new builder-style object to manufacture [`ProductInformation`](crate::model::ProductInformation)
    pub fn builder() -> crate::model::product_information::Builder {
        crate::model::product_information::Builder::default()
    }
}

/// <p>Describes product information filters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProductInformationFilter {
    /// <p>Filter name.</p>
    pub product_information_filter_name: std::option::Option<std::string::String>,
    /// <p>Filter value.</p>
    pub product_information_filter_value: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Logical operator.</p>
    pub product_information_filter_comparator: std::option::Option<std::string::String>,
}
impl ProductInformationFilter {
    /// <p>Filter name.</p>
    pub fn product_information_filter_name(&self) -> std::option::Option<&str> {
        self.product_information_filter_name.as_deref()
    }
    /// <p>Filter value.</p>
    pub fn product_information_filter_value(&self) -> std::option::Option<&[std::string::String]> {
        self.product_information_filter_value.as_deref()
    }
    /// <p>Logical operator.</p>
    pub fn product_information_filter_comparator(&self) -> std::option::Option<&str> {
        self.product_information_filter_comparator.as_deref()
    }
}
impl std::fmt::Debug for ProductInformationFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProductInformationFilter");
        formatter.field(
            "product_information_filter_name",
            &self.product_information_filter_name,
        );
        formatter.field(
            "product_information_filter_value",
            &self.product_information_filter_value,
        );
        formatter.field(
            "product_information_filter_comparator",
            &self.product_information_filter_comparator,
        );
        formatter.finish()
    }
}
/// See [`ProductInformationFilter`](crate::model::ProductInformationFilter)
pub mod product_information_filter {
    /// A builder for [`ProductInformationFilter`](crate::model::ProductInformationFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_information_filter_name: std::option::Option<std::string::String>,
        pub(crate) product_information_filter_value:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) product_information_filter_comparator: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filter name.</p>
        pub fn product_information_filter_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.product_information_filter_name = Some(input.into());
            self
        }
        /// <p>Filter name.</p>
        pub fn set_product_information_filter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_information_filter_name = input;
            self
        }
        /// Appends an item to `product_information_filter_value`.
        ///
        /// To override the contents of this collection use [`set_product_information_filter_value`](Self::set_product_information_filter_value).
        ///
        /// <p>Filter value.</p>
        pub fn product_information_filter_value(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.product_information_filter_value.unwrap_or_default();
            v.push(input.into());
            self.product_information_filter_value = Some(v);
            self
        }
        /// <p>Filter value.</p>
        pub fn set_product_information_filter_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.product_information_filter_value = input;
            self
        }
        /// <p>Logical operator.</p>
        pub fn product_information_filter_comparator(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.product_information_filter_comparator = Some(input.into());
            self
        }
        /// <p>Logical operator.</p>
        pub fn set_product_information_filter_comparator(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_information_filter_comparator = input;
            self
        }
        /// Consumes the builder and constructs a [`ProductInformationFilter`](crate::model::ProductInformationFilter)
        pub fn build(self) -> crate::model::ProductInformationFilter {
            crate::model::ProductInformationFilter {
                product_information_filter_name: self.product_information_filter_name,
                product_information_filter_value: self.product_information_filter_value,
                product_information_filter_comparator: self.product_information_filter_comparator,
            }
        }
    }
}
impl ProductInformationFilter {
    /// Creates a new builder-style object to manufacture [`ProductInformationFilter`](crate::model::ProductInformationFilter)
    pub fn builder() -> crate::model::product_information_filter::Builder {
        crate::model::product_information_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LicenseConfigurationStatus::Available,
            "DISABLED" => LicenseConfigurationStatus::Disabled,
            other => LicenseConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseConfigurationStatus::from(s))
    }
}
impl LicenseConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseConfigurationStatus::Available => "AVAILABLE",
            LicenseConfigurationStatus::Disabled => "DISABLED",
            LicenseConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DISABLED"]
    }
}
impl AsRef<str> for LicenseConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about a tag for a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>Tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>Tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>Tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GrantStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    FailedWorkflow,
    #[allow(missing_docs)] // documentation missing in model
    PendingAccept,
    #[allow(missing_docs)] // documentation missing in model
    PendingDelete,
    #[allow(missing_docs)] // documentation missing in model
    PendingWorkflow,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowCompleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GrantStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => GrantStatus::Active,
            "DELETED" => GrantStatus::Deleted,
            "DISABLED" => GrantStatus::Disabled,
            "FAILED_WORKFLOW" => GrantStatus::FailedWorkflow,
            "PENDING_ACCEPT" => GrantStatus::PendingAccept,
            "PENDING_DELETE" => GrantStatus::PendingDelete,
            "PENDING_WORKFLOW" => GrantStatus::PendingWorkflow,
            "REJECTED" => GrantStatus::Rejected,
            "WORKFLOW_COMPLETED" => GrantStatus::WorkflowCompleted,
            other => GrantStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GrantStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GrantStatus::from(s))
    }
}
impl GrantStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GrantStatus::Active => "ACTIVE",
            GrantStatus::Deleted => "DELETED",
            GrantStatus::Disabled => "DISABLED",
            GrantStatus::FailedWorkflow => "FAILED_WORKFLOW",
            GrantStatus::PendingAccept => "PENDING_ACCEPT",
            GrantStatus::PendingDelete => "PENDING_DELETE",
            GrantStatus::PendingWorkflow => "PENDING_WORKFLOW",
            GrantStatus::Rejected => "REJECTED",
            GrantStatus::WorkflowCompleted => "WORKFLOW_COMPLETED",
            GrantStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DELETED",
            "DISABLED",
            "FAILED_WORKFLOW",
            "PENDING_ACCEPT",
            "PENDING_DELETE",
            "PENDING_WORKFLOW",
            "REJECTED",
            "WORKFLOW_COMPLETED",
        ]
    }
}
impl AsRef<str> for GrantStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the usage of a resource associated with a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConfigurationUsage {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Status of the resource.</p>
    pub resource_status: std::option::Option<std::string::String>,
    /// <p>ID of the account that owns the resource.</p>
    pub resource_owner_id: std::option::Option<std::string::String>,
    /// <p>Time when the license configuration was initially associated with the resource.</p>
    pub association_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Number of licenses consumed by the resource.</p>
    pub consumed_licenses: std::option::Option<i64>,
}
impl LicenseConfigurationUsage {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Status of the resource.</p>
    pub fn resource_status(&self) -> std::option::Option<&str> {
        self.resource_status.as_deref()
    }
    /// <p>ID of the account that owns the resource.</p>
    pub fn resource_owner_id(&self) -> std::option::Option<&str> {
        self.resource_owner_id.as_deref()
    }
    /// <p>Time when the license configuration was initially associated with the resource.</p>
    pub fn association_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.association_time.as_ref()
    }
    /// <p>Number of licenses consumed by the resource.</p>
    pub fn consumed_licenses(&self) -> std::option::Option<i64> {
        self.consumed_licenses
    }
}
impl std::fmt::Debug for LicenseConfigurationUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConfigurationUsage");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_status", &self.resource_status);
        formatter.field("resource_owner_id", &self.resource_owner_id);
        formatter.field("association_time", &self.association_time);
        formatter.field("consumed_licenses", &self.consumed_licenses);
        formatter.finish()
    }
}
/// See [`LicenseConfigurationUsage`](crate::model::LicenseConfigurationUsage)
pub mod license_configuration_usage {
    /// A builder for [`LicenseConfigurationUsage`](crate::model::LicenseConfigurationUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_status: std::option::Option<std::string::String>,
        pub(crate) resource_owner_id: std::option::Option<std::string::String>,
        pub(crate) association_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) consumed_licenses: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Status of the resource.</p>
        pub fn resource_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_status = Some(input.into());
            self
        }
        /// <p>Status of the resource.</p>
        pub fn set_resource_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_status = input;
            self
        }
        /// <p>ID of the account that owns the resource.</p>
        pub fn resource_owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_id = Some(input.into());
            self
        }
        /// <p>ID of the account that owns the resource.</p>
        pub fn set_resource_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_id = input;
            self
        }
        /// <p>Time when the license configuration was initially associated with the resource.</p>
        pub fn association_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.association_time = Some(input);
            self
        }
        /// <p>Time when the license configuration was initially associated with the resource.</p>
        pub fn set_association_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.association_time = input;
            self
        }
        /// <p>Number of licenses consumed by the resource.</p>
        pub fn consumed_licenses(mut self, input: i64) -> Self {
            self.consumed_licenses = Some(input);
            self
        }
        /// <p>Number of licenses consumed by the resource.</p>
        pub fn set_consumed_licenses(mut self, input: std::option::Option<i64>) -> Self {
            self.consumed_licenses = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConfigurationUsage`](crate::model::LicenseConfigurationUsage)
        pub fn build(self) -> crate::model::LicenseConfigurationUsage {
            crate::model::LicenseConfigurationUsage {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                resource_status: self.resource_status,
                resource_owner_id: self.resource_owner_id,
                association_time: self.association_time,
                consumed_licenses: self.consumed_licenses,
            }
        }
    }
}
impl LicenseConfigurationUsage {
    /// Creates a new builder-style object to manufacture [`LicenseConfigurationUsage`](crate::model::LicenseConfigurationUsage)
    pub fn builder() -> crate::model::license_configuration_usage::Builder {
        crate::model::license_configuration_usage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2Ami,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Host,
    #[allow(missing_docs)] // documentation missing in model
    Ec2Instance,
    #[allow(missing_docs)] // documentation missing in model
    Rds,
    #[allow(missing_docs)] // documentation missing in model
    SystemsManagerManagedInstance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "EC2_AMI" => ResourceType::Ec2Ami,
            "EC2_HOST" => ResourceType::Ec2Host,
            "EC2_INSTANCE" => ResourceType::Ec2Instance,
            "RDS" => ResourceType::Rds,
            "SYSTEMS_MANAGER_MANAGED_INSTANCE" => ResourceType::SystemsManagerManagedInstance,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Ec2Ami => "EC2_AMI",
            ResourceType::Ec2Host => "EC2_HOST",
            ResourceType::Ec2Instance => "EC2_INSTANCE",
            ResourceType::Rds => "RDS",
            ResourceType::SystemsManagerManagedInstance => "SYSTEMS_MANAGER_MANAGED_INSTANCE",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EC2_AMI",
            "EC2_HOST",
            "EC2_INSTANCE",
            "RDS",
            "SYSTEMS_MANAGER_MANAGED_INSTANCE",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter name and value pair that is used to return more specific results from a
/// describe operation. Filters can be used to match a set of resources by specific criteria,
/// such as tags, attributes, or IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>Name of the filter. Filter names are case-sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Filter values. Filter values are case-sensitive.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>Name of the filter. Filter names are case-sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Filter values. Filter values are case-sensitive.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Name of the filter. Filter names are case-sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the filter. Filter names are case-sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Filter values. Filter values are case-sensitive.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Filter values. Filter values are case-sensitive.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Describes a token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TokenData {
    /// <p>Token ID.</p>
    pub token_id: std::option::Option<std::string::String>,
    /// <p>Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.</p>
    pub token_type: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>Token expiration time, in ISO8601-UTC format.</p>
    pub expiration_time: std::option::Option<std::string::String>,
    /// <p>Data specified by the caller.</p>
    pub token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Amazon Resource Names (ARN) of the roles included in the token.</p>
    pub role_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.</p>
    pub status: std::option::Option<std::string::String>,
}
impl TokenData {
    /// <p>Token ID.</p>
    pub fn token_id(&self) -> std::option::Option<&str> {
        self.token_id.as_deref()
    }
    /// <p>Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.</p>
    pub fn token_type(&self) -> std::option::Option<&str> {
        self.token_type.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>Token expiration time, in ISO8601-UTC format.</p>
    pub fn expiration_time(&self) -> std::option::Option<&str> {
        self.expiration_time.as_deref()
    }
    /// <p>Data specified by the caller.</p>
    pub fn token_properties(&self) -> std::option::Option<&[std::string::String]> {
        self.token_properties.as_deref()
    }
    /// <p>Amazon Resource Names (ARN) of the roles included in the token.</p>
    pub fn role_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.role_arns.as_deref()
    }
    /// <p>Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for TokenData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TokenData");
        formatter.field("token_id", &self.token_id);
        formatter.field("token_type", &self.token_type);
        formatter.field("license_arn", &self.license_arn);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("token_properties", &self.token_properties);
        formatter.field("role_arns", &self.role_arns);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`TokenData`](crate::model::TokenData)
pub mod token_data {
    /// A builder for [`TokenData`](crate::model::TokenData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_id: std::option::Option<std::string::String>,
        pub(crate) token_type: std::option::Option<std::string::String>,
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<std::string::String>,
        pub(crate) token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) role_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Token ID.</p>
        pub fn token_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_id = Some(input.into());
            self
        }
        /// <p>Token ID.</p>
        pub fn set_token_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_id = input;
            self
        }
        /// <p>Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.</p>
        pub fn token_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_type = Some(input.into());
            self
        }
        /// <p>Type of token generated. The supported value is <code>REFRESH_TOKEN</code>.</p>
        pub fn set_token_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_type = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>Token expiration time, in ISO8601-UTC format.</p>
        pub fn expiration_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.expiration_time = Some(input.into());
            self
        }
        /// <p>Token expiration time, in ISO8601-UTC format.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// Appends an item to `token_properties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Data specified by the caller.</p>
        pub fn token_properties(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_properties.unwrap_or_default();
            v.push(input.into());
            self.token_properties = Some(v);
            self
        }
        /// <p>Data specified by the caller.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_properties = input;
            self
        }
        /// Appends an item to `role_arns`.
        ///
        /// To override the contents of this collection use [`set_role_arns`](Self::set_role_arns).
        ///
        /// <p>Amazon Resource Names (ARN) of the roles included in the token.</p>
        pub fn role_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.role_arns.unwrap_or_default();
            v.push(input.into());
            self.role_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARN) of the roles included in the token.</p>
        pub fn set_role_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.role_arns = input;
            self
        }
        /// <p>Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Token status. The possible values are <code>AVAILABLE</code> and <code>DELETED</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`TokenData`](crate::model::TokenData)
        pub fn build(self) -> crate::model::TokenData {
            crate::model::TokenData {
                token_id: self.token_id,
                token_type: self.token_type,
                license_arn: self.license_arn,
                expiration_time: self.expiration_time,
                token_properties: self.token_properties,
                role_arns: self.role_arns,
                status: self.status,
            }
        }
    }
}
impl TokenData {
    /// Creates a new builder-style object to manufacture [`TokenData`](crate::model::TokenData)
    pub fn builder() -> crate::model::token_data::Builder {
        crate::model::token_data::Builder::default()
    }
}

/// <p>Details about a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInventory {
    /// <p>ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>Type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Platform of the resource.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>Platform version of the resource in the inventory.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>ID of the account that owns the resource.</p>
    pub resource_owning_account_id: std::option::Option<std::string::String>,
}
impl ResourceInventory {
    /// <p>ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>Type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Platform of the resource.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>Platform version of the resource in the inventory.</p>
    pub fn platform_version(&self) -> std::option::Option<&str> {
        self.platform_version.as_deref()
    }
    /// <p>ID of the account that owns the resource.</p>
    pub fn resource_owning_account_id(&self) -> std::option::Option<&str> {
        self.resource_owning_account_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceInventory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInventory");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("platform", &self.platform);
        formatter.field("platform_version", &self.platform_version);
        formatter.field(
            "resource_owning_account_id",
            &self.resource_owning_account_id,
        );
        formatter.finish()
    }
}
/// See [`ResourceInventory`](crate::model::ResourceInventory)
pub mod resource_inventory {
    /// A builder for [`ResourceInventory`](crate::model::ResourceInventory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) resource_owning_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>Type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Platform of the resource.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>Platform of the resource.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>Platform version of the resource in the inventory.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>Platform version of the resource in the inventory.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>ID of the account that owns the resource.</p>
        pub fn resource_owning_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owning_account_id = Some(input.into());
            self
        }
        /// <p>ID of the account that owns the resource.</p>
        pub fn set_resource_owning_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owning_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInventory`](crate::model::ResourceInventory)
        pub fn build(self) -> crate::model::ResourceInventory {
            crate::model::ResourceInventory {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                resource_arn: self.resource_arn,
                platform: self.platform,
                platform_version: self.platform_version,
                resource_owning_account_id: self.resource_owning_account_id,
            }
        }
    }
}
impl ResourceInventory {
    /// Creates a new builder-style object to manufacture [`ResourceInventory`](crate::model::ResourceInventory)
    pub fn builder() -> crate::model::resource_inventory::Builder {
        crate::model::resource_inventory::Builder::default()
    }
}

/// <p>An inventory filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InventoryFilter {
    /// <p>Name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Condition of the filter.</p>
    pub condition: std::option::Option<crate::model::InventoryFilterCondition>,
    /// <p>Value of the filter.</p>
    pub value: std::option::Option<std::string::String>,
}
impl InventoryFilter {
    /// <p>Name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Condition of the filter.</p>
    pub fn condition(&self) -> std::option::Option<&crate::model::InventoryFilterCondition> {
        self.condition.as_ref()
    }
    /// <p>Value of the filter.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for InventoryFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InventoryFilter");
        formatter.field("name", &self.name);
        formatter.field("condition", &self.condition);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`InventoryFilter`](crate::model::InventoryFilter)
pub mod inventory_filter {
    /// A builder for [`InventoryFilter`](crate::model::InventoryFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) condition: std::option::Option<crate::model::InventoryFilterCondition>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Condition of the filter.</p>
        pub fn condition(mut self, input: crate::model::InventoryFilterCondition) -> Self {
            self.condition = Some(input);
            self
        }
        /// <p>Condition of the filter.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::InventoryFilterCondition>,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>Value of the filter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of the filter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`InventoryFilter`](crate::model::InventoryFilter)
        pub fn build(self) -> crate::model::InventoryFilter {
            crate::model::InventoryFilter {
                name: self.name,
                condition: self.condition,
                value: self.value,
            }
        }
    }
}
impl InventoryFilter {
    /// Creates a new builder-style object to manufacture [`InventoryFilter`](crate::model::InventoryFilter)
    pub fn builder() -> crate::model::inventory_filter::Builder {
        crate::model::inventory_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InventoryFilterCondition {
    #[allow(missing_docs)] // documentation missing in model
    BeginsWith,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    NotEquals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InventoryFilterCondition {
    fn from(s: &str) -> Self {
        match s {
            "BEGINS_WITH" => InventoryFilterCondition::BeginsWith,
            "CONTAINS" => InventoryFilterCondition::Contains,
            "EQUALS" => InventoryFilterCondition::Equals,
            "NOT_EQUALS" => InventoryFilterCondition::NotEquals,
            other => InventoryFilterCondition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InventoryFilterCondition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InventoryFilterCondition::from(s))
    }
}
impl InventoryFilterCondition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InventoryFilterCondition::BeginsWith => "BEGINS_WITH",
            InventoryFilterCondition::Contains => "CONTAINS",
            InventoryFilterCondition::Equals => "EQUALS",
            InventoryFilterCondition::NotEquals => "NOT_EQUALS",
            InventoryFilterCondition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BEGINS_WITH", "CONTAINS", "EQUALS", "NOT_EQUALS"]
    }
}
impl AsRef<str> for InventoryFilterCondition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a license that is granted to a grantee.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantedLicense {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>License name.</p>
    pub license_name: std::option::Option<std::string::String>,
    /// <p>Product name.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>Product SKU.</p>
    pub product_sku: std::option::Option<std::string::String>,
    /// <p>Granted license issuer.</p>
    pub issuer: std::option::Option<crate::model::IssuerDetails>,
    /// <p>Home Region of the granted license.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Granted license status.</p>
    pub status: std::option::Option<crate::model::LicenseStatus>,
    /// <p>Date and time range during which the granted license is valid, in ISO8601-UTC format.</p>
    pub validity: std::option::Option<crate::model::DatetimeRange>,
    /// <p>Granted license beneficiary.</p>
    pub beneficiary: std::option::Option<std::string::String>,
    /// <p>License entitlements.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// <p>Configuration for consumption of the license.</p>
    pub consumption_configuration: std::option::Option<crate::model::ConsumptionConfiguration>,
    /// <p>Granted license metadata.</p>
    pub license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    /// <p>Creation time of the granted license.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>Version of the granted license.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Granted license received metadata.</p>
    pub received_metadata: std::option::Option<crate::model::ReceivedMetadata>,
}
impl GrantedLicense {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>License name.</p>
    pub fn license_name(&self) -> std::option::Option<&str> {
        self.license_name.as_deref()
    }
    /// <p>Product name.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>Product SKU.</p>
    pub fn product_sku(&self) -> std::option::Option<&str> {
        self.product_sku.as_deref()
    }
    /// <p>Granted license issuer.</p>
    pub fn issuer(&self) -> std::option::Option<&crate::model::IssuerDetails> {
        self.issuer.as_ref()
    }
    /// <p>Home Region of the granted license.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Granted license status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LicenseStatus> {
        self.status.as_ref()
    }
    /// <p>Date and time range during which the granted license is valid, in ISO8601-UTC format.</p>
    pub fn validity(&self) -> std::option::Option<&crate::model::DatetimeRange> {
        self.validity.as_ref()
    }
    /// <p>Granted license beneficiary.</p>
    pub fn beneficiary(&self) -> std::option::Option<&str> {
        self.beneficiary.as_deref()
    }
    /// <p>License entitlements.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::Entitlement]> {
        self.entitlements.as_deref()
    }
    /// <p>Configuration for consumption of the license.</p>
    pub fn consumption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConsumptionConfiguration> {
        self.consumption_configuration.as_ref()
    }
    /// <p>Granted license metadata.</p>
    pub fn license_metadata(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.license_metadata.as_deref()
    }
    /// <p>Creation time of the granted license.</p>
    pub fn create_time(&self) -> std::option::Option<&str> {
        self.create_time.as_deref()
    }
    /// <p>Version of the granted license.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Granted license received metadata.</p>
    pub fn received_metadata(&self) -> std::option::Option<&crate::model::ReceivedMetadata> {
        self.received_metadata.as_ref()
    }
}
impl std::fmt::Debug for GrantedLicense {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantedLicense");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("license_name", &self.license_name);
        formatter.field("product_name", &self.product_name);
        formatter.field("product_sku", &self.product_sku);
        formatter.field("issuer", &self.issuer);
        formatter.field("home_region", &self.home_region);
        formatter.field("status", &self.status);
        formatter.field("validity", &self.validity);
        formatter.field("beneficiary", &self.beneficiary);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("consumption_configuration", &self.consumption_configuration);
        formatter.field("license_metadata", &self.license_metadata);
        formatter.field("create_time", &self.create_time);
        formatter.field("version", &self.version);
        formatter.field("received_metadata", &self.received_metadata);
        formatter.finish()
    }
}
/// See [`GrantedLicense`](crate::model::GrantedLicense)
pub mod granted_license {
    /// A builder for [`GrantedLicense`](crate::model::GrantedLicense)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) license_name: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) product_sku: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<crate::model::IssuerDetails>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LicenseStatus>,
        pub(crate) validity: std::option::Option<crate::model::DatetimeRange>,
        pub(crate) beneficiary: std::option::Option<std::string::String>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) consumption_configuration:
            std::option::Option<crate::model::ConsumptionConfiguration>,
        pub(crate) license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) received_metadata: std::option::Option<crate::model::ReceivedMetadata>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_name = Some(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_name = input;
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_sku = Some(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_sku = input;
            self
        }
        /// <p>Granted license issuer.</p>
        pub fn issuer(mut self, input: crate::model::IssuerDetails) -> Self {
            self.issuer = Some(input);
            self
        }
        /// <p>Granted license issuer.</p>
        pub fn set_issuer(
            mut self,
            input: std::option::Option<crate::model::IssuerDetails>,
        ) -> Self {
            self.issuer = input;
            self
        }
        /// <p>Home Region of the granted license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region of the granted license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>Granted license status.</p>
        pub fn status(mut self, input: crate::model::LicenseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Granted license status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Date and time range during which the granted license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>Date and time range during which the granted license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.validity = input;
            self
        }
        /// <p>Granted license beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.beneficiary = Some(input.into());
            self
        }
        /// <p>Granted license beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.beneficiary = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: impl Into<crate::model::Entitlement>) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>Configuration for consumption of the license.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.consumption_configuration = Some(input);
            self
        }
        /// <p>Configuration for consumption of the license.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.consumption_configuration = input;
            self
        }
        /// Appends an item to `license_metadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Granted license metadata.</p>
        pub fn license_metadata(mut self, input: impl Into<crate::model::Metadata>) -> Self {
            let mut v = self.license_metadata.unwrap_or_default();
            v.push(input.into());
            self.license_metadata = Some(v);
            self
        }
        /// <p>Granted license metadata.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.license_metadata = input;
            self
        }
        /// <p>Creation time of the granted license.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>Creation time of the granted license.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Version of the granted license.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Version of the granted license.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Granted license received metadata.</p>
        pub fn received_metadata(mut self, input: crate::model::ReceivedMetadata) -> Self {
            self.received_metadata = Some(input);
            self
        }
        /// <p>Granted license received metadata.</p>
        pub fn set_received_metadata(
            mut self,
            input: std::option::Option<crate::model::ReceivedMetadata>,
        ) -> Self {
            self.received_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantedLicense`](crate::model::GrantedLicense)
        pub fn build(self) -> crate::model::GrantedLicense {
            crate::model::GrantedLicense {
                license_arn: self.license_arn,
                license_name: self.license_name,
                product_name: self.product_name,
                product_sku: self.product_sku,
                issuer: self.issuer,
                home_region: self.home_region,
                status: self.status,
                validity: self.validity,
                beneficiary: self.beneficiary,
                entitlements: self.entitlements,
                consumption_configuration: self.consumption_configuration,
                license_metadata: self.license_metadata,
                create_time: self.create_time,
                version: self.version,
                received_metadata: self.received_metadata,
            }
        }
    }
}
impl GrantedLicense {
    /// Creates a new builder-style object to manufacture [`GrantedLicense`](crate::model::GrantedLicense)
    pub fn builder() -> crate::model::granted_license::Builder {
        crate::model::granted_license::Builder::default()
    }
}

/// <p>Metadata associated with received licenses and grants.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReceivedMetadata {
    /// <p>Received status.</p>
    pub received_status: std::option::Option<crate::model::ReceivedStatus>,
    /// <p>Received status reason.</p>
    pub received_status_reason: std::option::Option<std::string::String>,
    /// <p>Allowed operations.</p>
    pub allowed_operations: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
}
impl ReceivedMetadata {
    /// <p>Received status.</p>
    pub fn received_status(&self) -> std::option::Option<&crate::model::ReceivedStatus> {
        self.received_status.as_ref()
    }
    /// <p>Received status reason.</p>
    pub fn received_status_reason(&self) -> std::option::Option<&str> {
        self.received_status_reason.as_deref()
    }
    /// <p>Allowed operations.</p>
    pub fn allowed_operations(&self) -> std::option::Option<&[crate::model::AllowedOperation]> {
        self.allowed_operations.as_deref()
    }
}
impl std::fmt::Debug for ReceivedMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReceivedMetadata");
        formatter.field("received_status", &self.received_status);
        formatter.field("received_status_reason", &self.received_status_reason);
        formatter.field("allowed_operations", &self.allowed_operations);
        formatter.finish()
    }
}
/// See [`ReceivedMetadata`](crate::model::ReceivedMetadata)
pub mod received_metadata {
    /// A builder for [`ReceivedMetadata`](crate::model::ReceivedMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) received_status: std::option::Option<crate::model::ReceivedStatus>,
        pub(crate) received_status_reason: std::option::Option<std::string::String>,
        pub(crate) allowed_operations:
            std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
    }
    impl Builder {
        /// <p>Received status.</p>
        pub fn received_status(mut self, input: crate::model::ReceivedStatus) -> Self {
            self.received_status = Some(input);
            self
        }
        /// <p>Received status.</p>
        pub fn set_received_status(
            mut self,
            input: std::option::Option<crate::model::ReceivedStatus>,
        ) -> Self {
            self.received_status = input;
            self
        }
        /// <p>Received status reason.</p>
        pub fn received_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.received_status_reason = Some(input.into());
            self
        }
        /// <p>Received status reason.</p>
        pub fn set_received_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.received_status_reason = input;
            self
        }
        /// Appends an item to `allowed_operations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations.</p>
        pub fn allowed_operations(
            mut self,
            input: impl Into<crate::model::AllowedOperation>,
        ) -> Self {
            let mut v = self.allowed_operations.unwrap_or_default();
            v.push(input.into());
            self.allowed_operations = Some(v);
            self
        }
        /// <p>Allowed operations.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.allowed_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`ReceivedMetadata`](crate::model::ReceivedMetadata)
        pub fn build(self) -> crate::model::ReceivedMetadata {
            crate::model::ReceivedMetadata {
                received_status: self.received_status,
                received_status_reason: self.received_status_reason,
                allowed_operations: self.allowed_operations,
            }
        }
    }
}
impl ReceivedMetadata {
    /// Creates a new builder-style object to manufacture [`ReceivedMetadata`](crate::model::ReceivedMetadata)
    pub fn builder() -> crate::model::received_metadata::Builder {
        crate::model::received_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AllowedOperation {
    #[allow(missing_docs)] // documentation missing in model
    CheckInLicense,
    #[allow(missing_docs)] // documentation missing in model
    CheckoutBorrowLicense,
    #[allow(missing_docs)] // documentation missing in model
    CheckoutLicense,
    #[allow(missing_docs)] // documentation missing in model
    CreateGrant,
    #[allow(missing_docs)] // documentation missing in model
    CreateToken,
    #[allow(missing_docs)] // documentation missing in model
    ExtendConsumptionLicense,
    #[allow(missing_docs)] // documentation missing in model
    ListPurchasedLicenses,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AllowedOperation {
    fn from(s: &str) -> Self {
        match s {
            "CheckInLicense" => AllowedOperation::CheckInLicense,
            "CheckoutBorrowLicense" => AllowedOperation::CheckoutBorrowLicense,
            "CheckoutLicense" => AllowedOperation::CheckoutLicense,
            "CreateGrant" => AllowedOperation::CreateGrant,
            "CreateToken" => AllowedOperation::CreateToken,
            "ExtendConsumptionLicense" => AllowedOperation::ExtendConsumptionLicense,
            "ListPurchasedLicenses" => AllowedOperation::ListPurchasedLicenses,
            other => AllowedOperation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AllowedOperation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AllowedOperation::from(s))
    }
}
impl AllowedOperation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AllowedOperation::CheckInLicense => "CheckInLicense",
            AllowedOperation::CheckoutBorrowLicense => "CheckoutBorrowLicense",
            AllowedOperation::CheckoutLicense => "CheckoutLicense",
            AllowedOperation::CreateGrant => "CreateGrant",
            AllowedOperation::CreateToken => "CreateToken",
            AllowedOperation::ExtendConsumptionLicense => "ExtendConsumptionLicense",
            AllowedOperation::ListPurchasedLicenses => "ListPurchasedLicenses",
            AllowedOperation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CheckInLicense",
            "CheckoutBorrowLicense",
            "CheckoutLicense",
            "CreateGrant",
            "CreateToken",
            "ExtendConsumptionLicense",
            "ListPurchasedLicenses",
        ]
    }
}
impl AsRef<str> for AllowedOperation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReceivedStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    FailedWorkflow,
    #[allow(missing_docs)] // documentation missing in model
    PendingAccept,
    #[allow(missing_docs)] // documentation missing in model
    PendingWorkflow,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    #[allow(missing_docs)] // documentation missing in model
    WorkflowCompleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReceivedStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReceivedStatus::Active,
            "DELETED" => ReceivedStatus::Deleted,
            "DISABLED" => ReceivedStatus::Disabled,
            "FAILED_WORKFLOW" => ReceivedStatus::FailedWorkflow,
            "PENDING_ACCEPT" => ReceivedStatus::PendingAccept,
            "PENDING_WORKFLOW" => ReceivedStatus::PendingWorkflow,
            "REJECTED" => ReceivedStatus::Rejected,
            "WORKFLOW_COMPLETED" => ReceivedStatus::WorkflowCompleted,
            other => ReceivedStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReceivedStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReceivedStatus::from(s))
    }
}
impl ReceivedStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReceivedStatus::Active => "ACTIVE",
            ReceivedStatus::Deleted => "DELETED",
            ReceivedStatus::Disabled => "DISABLED",
            ReceivedStatus::FailedWorkflow => "FAILED_WORKFLOW",
            ReceivedStatus::PendingAccept => "PENDING_ACCEPT",
            ReceivedStatus::PendingWorkflow => "PENDING_WORKFLOW",
            ReceivedStatus::Rejected => "REJECTED",
            ReceivedStatus::WorkflowCompleted => "WORKFLOW_COMPLETED",
            ReceivedStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DELETED",
            "DISABLED",
            "FAILED_WORKFLOW",
            "PENDING_ACCEPT",
            "PENDING_WORKFLOW",
            "REJECTED",
            "WORKFLOW_COMPLETED",
        ]
    }
}
impl AsRef<str> for ReceivedStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes key/value pairs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metadata {
    /// <p>The key name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Metadata {
    /// <p>The key name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Metadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metadata");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Metadata`](crate::model::Metadata)
pub mod metadata {
    /// A builder for [`Metadata`](crate::model::Metadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The key name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Metadata`](crate::model::Metadata)
        pub fn build(self) -> crate::model::Metadata {
            crate::model::Metadata {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Metadata {
    /// Creates a new builder-style object to manufacture [`Metadata`](crate::model::Metadata)
    pub fn builder() -> crate::model::metadata::Builder {
        crate::model::metadata::Builder::default()
    }
}

/// <p>Details about a consumption configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConsumptionConfiguration {
    /// <p>Renewal frequency.</p>
    pub renew_type: std::option::Option<crate::model::RenewType>,
    /// <p>Details about a provisional configuration.</p>
    pub provisional_configuration: std::option::Option<crate::model::ProvisionalConfiguration>,
    /// <p>Details about a borrow configuration.</p>
    pub borrow_configuration: std::option::Option<crate::model::BorrowConfiguration>,
}
impl ConsumptionConfiguration {
    /// <p>Renewal frequency.</p>
    pub fn renew_type(&self) -> std::option::Option<&crate::model::RenewType> {
        self.renew_type.as_ref()
    }
    /// <p>Details about a provisional configuration.</p>
    pub fn provisional_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ProvisionalConfiguration> {
        self.provisional_configuration.as_ref()
    }
    /// <p>Details about a borrow configuration.</p>
    pub fn borrow_configuration(&self) -> std::option::Option<&crate::model::BorrowConfiguration> {
        self.borrow_configuration.as_ref()
    }
}
impl std::fmt::Debug for ConsumptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConsumptionConfiguration");
        formatter.field("renew_type", &self.renew_type);
        formatter.field("provisional_configuration", &self.provisional_configuration);
        formatter.field("borrow_configuration", &self.borrow_configuration);
        formatter.finish()
    }
}
/// See [`ConsumptionConfiguration`](crate::model::ConsumptionConfiguration)
pub mod consumption_configuration {
    /// A builder for [`ConsumptionConfiguration`](crate::model::ConsumptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) renew_type: std::option::Option<crate::model::RenewType>,
        pub(crate) provisional_configuration:
            std::option::Option<crate::model::ProvisionalConfiguration>,
        pub(crate) borrow_configuration: std::option::Option<crate::model::BorrowConfiguration>,
    }
    impl Builder {
        /// <p>Renewal frequency.</p>
        pub fn renew_type(mut self, input: crate::model::RenewType) -> Self {
            self.renew_type = Some(input);
            self
        }
        /// <p>Renewal frequency.</p>
        pub fn set_renew_type(
            mut self,
            input: std::option::Option<crate::model::RenewType>,
        ) -> Self {
            self.renew_type = input;
            self
        }
        /// <p>Details about a provisional configuration.</p>
        pub fn provisional_configuration(
            mut self,
            input: crate::model::ProvisionalConfiguration,
        ) -> Self {
            self.provisional_configuration = Some(input);
            self
        }
        /// <p>Details about a provisional configuration.</p>
        pub fn set_provisional_configuration(
            mut self,
            input: std::option::Option<crate::model::ProvisionalConfiguration>,
        ) -> Self {
            self.provisional_configuration = input;
            self
        }
        /// <p>Details about a borrow configuration.</p>
        pub fn borrow_configuration(mut self, input: crate::model::BorrowConfiguration) -> Self {
            self.borrow_configuration = Some(input);
            self
        }
        /// <p>Details about a borrow configuration.</p>
        pub fn set_borrow_configuration(
            mut self,
            input: std::option::Option<crate::model::BorrowConfiguration>,
        ) -> Self {
            self.borrow_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ConsumptionConfiguration`](crate::model::ConsumptionConfiguration)
        pub fn build(self) -> crate::model::ConsumptionConfiguration {
            crate::model::ConsumptionConfiguration {
                renew_type: self.renew_type,
                provisional_configuration: self.provisional_configuration,
                borrow_configuration: self.borrow_configuration,
            }
        }
    }
}
impl ConsumptionConfiguration {
    /// Creates a new builder-style object to manufacture [`ConsumptionConfiguration`](crate::model::ConsumptionConfiguration)
    pub fn builder() -> crate::model::consumption_configuration::Builder {
        crate::model::consumption_configuration::Builder::default()
    }
}

/// <p>Details about a borrow configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BorrowConfiguration {
    /// <p>Indicates whether early check-ins are allowed.</p>
    pub allow_early_check_in: std::option::Option<bool>,
    /// <p>Maximum time for the borrow configuration, in minutes.</p>
    pub max_time_to_live_in_minutes: std::option::Option<i32>,
}
impl BorrowConfiguration {
    /// <p>Indicates whether early check-ins are allowed.</p>
    pub fn allow_early_check_in(&self) -> std::option::Option<bool> {
        self.allow_early_check_in
    }
    /// <p>Maximum time for the borrow configuration, in minutes.</p>
    pub fn max_time_to_live_in_minutes(&self) -> std::option::Option<i32> {
        self.max_time_to_live_in_minutes
    }
}
impl std::fmt::Debug for BorrowConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BorrowConfiguration");
        formatter.field("allow_early_check_in", &self.allow_early_check_in);
        formatter.field(
            "max_time_to_live_in_minutes",
            &self.max_time_to_live_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`BorrowConfiguration`](crate::model::BorrowConfiguration)
pub mod borrow_configuration {
    /// A builder for [`BorrowConfiguration`](crate::model::BorrowConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_early_check_in: std::option::Option<bool>,
        pub(crate) max_time_to_live_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether early check-ins are allowed.</p>
        pub fn allow_early_check_in(mut self, input: bool) -> Self {
            self.allow_early_check_in = Some(input);
            self
        }
        /// <p>Indicates whether early check-ins are allowed.</p>
        pub fn set_allow_early_check_in(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_early_check_in = input;
            self
        }
        /// <p>Maximum time for the borrow configuration, in minutes.</p>
        pub fn max_time_to_live_in_minutes(mut self, input: i32) -> Self {
            self.max_time_to_live_in_minutes = Some(input);
            self
        }
        /// <p>Maximum time for the borrow configuration, in minutes.</p>
        pub fn set_max_time_to_live_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.max_time_to_live_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`BorrowConfiguration`](crate::model::BorrowConfiguration)
        pub fn build(self) -> crate::model::BorrowConfiguration {
            crate::model::BorrowConfiguration {
                allow_early_check_in: self.allow_early_check_in,
                max_time_to_live_in_minutes: self.max_time_to_live_in_minutes,
            }
        }
    }
}
impl BorrowConfiguration {
    /// Creates a new builder-style object to manufacture [`BorrowConfiguration`](crate::model::BorrowConfiguration)
    pub fn builder() -> crate::model::borrow_configuration::Builder {
        crate::model::borrow_configuration::Builder::default()
    }
}

/// <p>Details about a provisional configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionalConfiguration {
    /// <p>Maximum time for the provisional configuration, in minutes.</p>
    pub max_time_to_live_in_minutes: std::option::Option<i32>,
}
impl ProvisionalConfiguration {
    /// <p>Maximum time for the provisional configuration, in minutes.</p>
    pub fn max_time_to_live_in_minutes(&self) -> std::option::Option<i32> {
        self.max_time_to_live_in_minutes
    }
}
impl std::fmt::Debug for ProvisionalConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionalConfiguration");
        formatter.field(
            "max_time_to_live_in_minutes",
            &self.max_time_to_live_in_minutes,
        );
        formatter.finish()
    }
}
/// See [`ProvisionalConfiguration`](crate::model::ProvisionalConfiguration)
pub mod provisional_configuration {
    /// A builder for [`ProvisionalConfiguration`](crate::model::ProvisionalConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_time_to_live_in_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Maximum time for the provisional configuration, in minutes.</p>
        pub fn max_time_to_live_in_minutes(mut self, input: i32) -> Self {
            self.max_time_to_live_in_minutes = Some(input);
            self
        }
        /// <p>Maximum time for the provisional configuration, in minutes.</p>
        pub fn set_max_time_to_live_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.max_time_to_live_in_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionalConfiguration`](crate::model::ProvisionalConfiguration)
        pub fn build(self) -> crate::model::ProvisionalConfiguration {
            crate::model::ProvisionalConfiguration {
                max_time_to_live_in_minutes: self.max_time_to_live_in_minutes,
            }
        }
    }
}
impl ProvisionalConfiguration {
    /// Creates a new builder-style object to manufacture [`ProvisionalConfiguration`](crate::model::ProvisionalConfiguration)
    pub fn builder() -> crate::model::provisional_configuration::Builder {
        crate::model::provisional_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenewType {
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenewType {
    fn from(s: &str) -> Self {
        match s {
            "Monthly" => RenewType::Monthly,
            "None" => RenewType::None,
            "Weekly" => RenewType::Weekly,
            other => RenewType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenewType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenewType::from(s))
    }
}
impl RenewType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenewType::Monthly => "Monthly",
            RenewType::None => "None",
            RenewType::Weekly => "Weekly",
            RenewType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Monthly", "None", "Weekly"]
    }
}
impl AsRef<str> for RenewType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a resource entitled for use with a license.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entitlement {
    /// <p>Entitlement name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Entitlement resource. Use only if the unit is None.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Maximum entitlement count. Use if the unit is not None.</p>
    pub max_count: std::option::Option<i64>,
    /// <p>Indicates whether overages are allowed.</p>
    pub overage: std::option::Option<bool>,
    /// <p>Entitlement unit.</p>
    pub unit: std::option::Option<crate::model::EntitlementUnit>,
    /// <p>Indicates whether check-ins are allowed.</p>
    pub allow_check_in: std::option::Option<bool>,
}
impl Entitlement {
    /// <p>Entitlement name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Entitlement resource. Use only if the unit is None.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Maximum entitlement count. Use if the unit is not None.</p>
    pub fn max_count(&self) -> std::option::Option<i64> {
        self.max_count
    }
    /// <p>Indicates whether overages are allowed.</p>
    pub fn overage(&self) -> std::option::Option<bool> {
        self.overage
    }
    /// <p>Entitlement unit.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::EntitlementUnit> {
        self.unit.as_ref()
    }
    /// <p>Indicates whether check-ins are allowed.</p>
    pub fn allow_check_in(&self) -> std::option::Option<bool> {
        self.allow_check_in
    }
}
impl std::fmt::Debug for Entitlement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entitlement");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("max_count", &self.max_count);
        formatter.field("overage", &self.overage);
        formatter.field("unit", &self.unit);
        formatter.field("allow_check_in", &self.allow_check_in);
        formatter.finish()
    }
}
/// See [`Entitlement`](crate::model::Entitlement)
pub mod entitlement {
    /// A builder for [`Entitlement`](crate::model::Entitlement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) max_count: std::option::Option<i64>,
        pub(crate) overage: std::option::Option<bool>,
        pub(crate) unit: std::option::Option<crate::model::EntitlementUnit>,
        pub(crate) allow_check_in: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Entitlement name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Entitlement name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Entitlement resource. Use only if the unit is None.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Entitlement resource. Use only if the unit is None.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Maximum entitlement count. Use if the unit is not None.</p>
        pub fn max_count(mut self, input: i64) -> Self {
            self.max_count = Some(input);
            self
        }
        /// <p>Maximum entitlement count. Use if the unit is not None.</p>
        pub fn set_max_count(mut self, input: std::option::Option<i64>) -> Self {
            self.max_count = input;
            self
        }
        /// <p>Indicates whether overages are allowed.</p>
        pub fn overage(mut self, input: bool) -> Self {
            self.overage = Some(input);
            self
        }
        /// <p>Indicates whether overages are allowed.</p>
        pub fn set_overage(mut self, input: std::option::Option<bool>) -> Self {
            self.overage = input;
            self
        }
        /// <p>Entitlement unit.</p>
        pub fn unit(mut self, input: crate::model::EntitlementUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Entitlement unit.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::EntitlementUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// <p>Indicates whether check-ins are allowed.</p>
        pub fn allow_check_in(mut self, input: bool) -> Self {
            self.allow_check_in = Some(input);
            self
        }
        /// <p>Indicates whether check-ins are allowed.</p>
        pub fn set_allow_check_in(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_check_in = input;
            self
        }
        /// Consumes the builder and constructs a [`Entitlement`](crate::model::Entitlement)
        pub fn build(self) -> crate::model::Entitlement {
            crate::model::Entitlement {
                name: self.name,
                value: self.value,
                max_count: self.max_count,
                overage: self.overage,
                unit: self.unit,
                allow_check_in: self.allow_check_in,
            }
        }
    }
}
impl Entitlement {
    /// Creates a new builder-style object to manufacture [`Entitlement`](crate::model::Entitlement)
    pub fn builder() -> crate::model::entitlement::Builder {
        crate::model::entitlement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntitlementUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntitlementUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => EntitlementUnit::Bits,
            "Bits/Second" => EntitlementUnit::BitsPerSecond,
            "Bytes" => EntitlementUnit::Bytes,
            "Bytes/Second" => EntitlementUnit::BytesPerSecond,
            "Count" => EntitlementUnit::Count,
            "Count/Second" => EntitlementUnit::CountPerSecond,
            "Gigabits" => EntitlementUnit::Gigabits,
            "Gigabits/Second" => EntitlementUnit::GigabitsPerSecond,
            "Gigabytes" => EntitlementUnit::Gigabytes,
            "Gigabytes/Second" => EntitlementUnit::GigabytesPerSecond,
            "Kilobits" => EntitlementUnit::Kilobits,
            "Kilobits/Second" => EntitlementUnit::KilobitsPerSecond,
            "Kilobytes" => EntitlementUnit::Kilobytes,
            "Kilobytes/Second" => EntitlementUnit::KilobytesPerSecond,
            "Megabits" => EntitlementUnit::Megabits,
            "Megabits/Second" => EntitlementUnit::MegabitsPerSecond,
            "Megabytes" => EntitlementUnit::Megabytes,
            "Megabytes/Second" => EntitlementUnit::MegabytesPerSecond,
            "Microseconds" => EntitlementUnit::Microseconds,
            "Milliseconds" => EntitlementUnit::Milliseconds,
            "None" => EntitlementUnit::None,
            "Percent" => EntitlementUnit::Percent,
            "Seconds" => EntitlementUnit::Seconds,
            "Terabits" => EntitlementUnit::Terabits,
            "Terabits/Second" => EntitlementUnit::TerabitsPerSecond,
            "Terabytes" => EntitlementUnit::Terabytes,
            "Terabytes/Second" => EntitlementUnit::TerabytesPerSecond,
            other => EntitlementUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntitlementUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntitlementUnit::from(s))
    }
}
impl EntitlementUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntitlementUnit::Bits => "Bits",
            EntitlementUnit::BitsPerSecond => "Bits/Second",
            EntitlementUnit::Bytes => "Bytes",
            EntitlementUnit::BytesPerSecond => "Bytes/Second",
            EntitlementUnit::Count => "Count",
            EntitlementUnit::CountPerSecond => "Count/Second",
            EntitlementUnit::Gigabits => "Gigabits",
            EntitlementUnit::GigabitsPerSecond => "Gigabits/Second",
            EntitlementUnit::Gigabytes => "Gigabytes",
            EntitlementUnit::GigabytesPerSecond => "Gigabytes/Second",
            EntitlementUnit::Kilobits => "Kilobits",
            EntitlementUnit::KilobitsPerSecond => "Kilobits/Second",
            EntitlementUnit::Kilobytes => "Kilobytes",
            EntitlementUnit::KilobytesPerSecond => "Kilobytes/Second",
            EntitlementUnit::Megabits => "Megabits",
            EntitlementUnit::MegabitsPerSecond => "Megabits/Second",
            EntitlementUnit::Megabytes => "Megabytes",
            EntitlementUnit::MegabytesPerSecond => "Megabytes/Second",
            EntitlementUnit::Microseconds => "Microseconds",
            EntitlementUnit::Milliseconds => "Milliseconds",
            EntitlementUnit::None => "None",
            EntitlementUnit::Percent => "Percent",
            EntitlementUnit::Seconds => "Seconds",
            EntitlementUnit::Terabits => "Terabits",
            EntitlementUnit::TerabitsPerSecond => "Terabits/Second",
            EntitlementUnit::Terabytes => "Terabytes",
            EntitlementUnit::TerabytesPerSecond => "Terabytes/Second",
            EntitlementUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for EntitlementUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a time range, in ISO8601-UTC format.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatetimeRange {
    /// <p>Start of the time range.</p>
    pub begin: std::option::Option<std::string::String>,
    /// <p>End of the time range.</p>
    pub end: std::option::Option<std::string::String>,
}
impl DatetimeRange {
    /// <p>Start of the time range.</p>
    pub fn begin(&self) -> std::option::Option<&str> {
        self.begin.as_deref()
    }
    /// <p>End of the time range.</p>
    pub fn end(&self) -> std::option::Option<&str> {
        self.end.as_deref()
    }
}
impl std::fmt::Debug for DatetimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatetimeRange");
        formatter.field("begin", &self.begin);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`DatetimeRange`](crate::model::DatetimeRange)
pub mod datetime_range {
    /// A builder for [`DatetimeRange`](crate::model::DatetimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) begin: std::option::Option<std::string::String>,
        pub(crate) end: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Start of the time range.</p>
        pub fn begin(mut self, input: impl Into<std::string::String>) -> Self {
            self.begin = Some(input.into());
            self
        }
        /// <p>Start of the time range.</p>
        pub fn set_begin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.begin = input;
            self
        }
        /// <p>End of the time range.</p>
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// <p>End of the time range.</p>
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`DatetimeRange`](crate::model::DatetimeRange)
        pub fn build(self) -> crate::model::DatetimeRange {
            crate::model::DatetimeRange {
                begin: self.begin,
                end: self.end,
            }
        }
    }
}
impl DatetimeRange {
    /// Creates a new builder-style object to manufacture [`DatetimeRange`](crate::model::DatetimeRange)
    pub fn builder() -> crate::model::datetime_range::Builder {
        crate::model::datetime_range::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deactivated,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    PendingAvailable,
    #[allow(missing_docs)] // documentation missing in model
    PendingDelete,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => LicenseStatus::Available,
            "DEACTIVATED" => LicenseStatus::Deactivated,
            "DELETED" => LicenseStatus::Deleted,
            "EXPIRED" => LicenseStatus::Expired,
            "PENDING_AVAILABLE" => LicenseStatus::PendingAvailable,
            "PENDING_DELETE" => LicenseStatus::PendingDelete,
            "SUSPENDED" => LicenseStatus::Suspended,
            other => LicenseStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseStatus::from(s))
    }
}
impl LicenseStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseStatus::Available => "AVAILABLE",
            LicenseStatus::Deactivated => "DEACTIVATED",
            LicenseStatus::Deleted => "DELETED",
            LicenseStatus::Expired => "EXPIRED",
            LicenseStatus::PendingAvailable => "PENDING_AVAILABLE",
            LicenseStatus::PendingDelete => "PENDING_DELETE",
            LicenseStatus::Suspended => "SUSPENDED",
            LicenseStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "DEACTIVATED",
            "DELETED",
            "EXPIRED",
            "PENDING_AVAILABLE",
            "PENDING_DELETE",
            "SUSPENDED",
        ]
    }
}
impl AsRef<str> for LicenseStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details associated with the issuer of a license.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IssuerDetails {
    /// <p>Issuer name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
    /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
    pub sign_key: std::option::Option<std::string::String>,
    /// <p>Issuer key fingerprint.</p>
    pub key_fingerprint: std::option::Option<std::string::String>,
}
impl IssuerDetails {
    /// <p>Issuer name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
    /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
    pub fn sign_key(&self) -> std::option::Option<&str> {
        self.sign_key.as_deref()
    }
    /// <p>Issuer key fingerprint.</p>
    pub fn key_fingerprint(&self) -> std::option::Option<&str> {
        self.key_fingerprint.as_deref()
    }
}
impl std::fmt::Debug for IssuerDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IssuerDetails");
        formatter.field("name", &self.name);
        formatter.field("sign_key", &self.sign_key);
        formatter.field("key_fingerprint", &self.key_fingerprint);
        formatter.finish()
    }
}
/// See [`IssuerDetails`](crate::model::IssuerDetails)
pub mod issuer_details {
    /// A builder for [`IssuerDetails`](crate::model::IssuerDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sign_key: std::option::Option<std::string::String>,
        pub(crate) key_fingerprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Issuer name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Issuer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
        /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
        pub fn sign_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sign_key = Some(input.into());
            self
        }
        /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
        /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
        pub fn set_sign_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sign_key = input;
            self
        }
        /// <p>Issuer key fingerprint.</p>
        pub fn key_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_fingerprint = Some(input.into());
            self
        }
        /// <p>Issuer key fingerprint.</p>
        pub fn set_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_fingerprint = input;
            self
        }
        /// Consumes the builder and constructs a [`IssuerDetails`](crate::model::IssuerDetails)
        pub fn build(self) -> crate::model::IssuerDetails {
            crate::model::IssuerDetails {
                name: self.name,
                sign_key: self.sign_key,
                key_fingerprint: self.key_fingerprint,
            }
        }
    }
}
impl IssuerDetails {
    /// Creates a new builder-style object to manufacture [`IssuerDetails`](crate::model::IssuerDetails)
    pub fn builder() -> crate::model::issuer_details::Builder {
        crate::model::issuer_details::Builder::default()
    }
}

/// <p>Describes a grant.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Grant {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
    /// <p>Grant name.</p>
    pub grant_name: std::option::Option<std::string::String>,
    /// <p>Parent ARN.</p>
    pub parent_arn: std::option::Option<std::string::String>,
    /// <p>License ARN.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>The grantee principal ARN.</p>
    pub grantee_principal_arn: std::option::Option<std::string::String>,
    /// <p>Home Region of the grant.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Grant status.</p>
    pub grant_status: std::option::Option<crate::model::GrantStatus>,
    /// <p>Grant status reason.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Grant version.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Granted operations.</p>
    pub granted_operations: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
}
impl Grant {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
    /// <p>Grant name.</p>
    pub fn grant_name(&self) -> std::option::Option<&str> {
        self.grant_name.as_deref()
    }
    /// <p>Parent ARN.</p>
    pub fn parent_arn(&self) -> std::option::Option<&str> {
        self.parent_arn.as_deref()
    }
    /// <p>License ARN.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>The grantee principal ARN.</p>
    pub fn grantee_principal_arn(&self) -> std::option::Option<&str> {
        self.grantee_principal_arn.as_deref()
    }
    /// <p>Home Region of the grant.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Grant status.</p>
    pub fn grant_status(&self) -> std::option::Option<&crate::model::GrantStatus> {
        self.grant_status.as_ref()
    }
    /// <p>Grant status reason.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Grant version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Granted operations.</p>
    pub fn granted_operations(&self) -> std::option::Option<&[crate::model::AllowedOperation]> {
        self.granted_operations.as_deref()
    }
}
impl std::fmt::Debug for Grant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Grant");
        formatter.field("grant_arn", &self.grant_arn);
        formatter.field("grant_name", &self.grant_name);
        formatter.field("parent_arn", &self.parent_arn);
        formatter.field("license_arn", &self.license_arn);
        formatter.field("grantee_principal_arn", &self.grantee_principal_arn);
        formatter.field("home_region", &self.home_region);
        formatter.field("grant_status", &self.grant_status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("version", &self.version);
        formatter.field("granted_operations", &self.granted_operations);
        formatter.finish()
    }
}
/// See [`Grant`](crate::model::Grant)
pub mod grant {
    /// A builder for [`Grant`](crate::model::Grant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arn: std::option::Option<std::string::String>,
        pub(crate) grant_name: std::option::Option<std::string::String>,
        pub(crate) parent_arn: std::option::Option<std::string::String>,
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) grantee_principal_arn: std::option::Option<std::string::String>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) grant_status: std::option::Option<crate::model::GrantStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) granted_operations:
            std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_name = Some(input.into());
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_name = input;
            self
        }
        /// <p>Parent ARN.</p>
        pub fn parent_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_arn = Some(input.into());
            self
        }
        /// <p>Parent ARN.</p>
        pub fn set_parent_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_arn = input;
            self
        }
        /// <p>License ARN.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>License ARN.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>The grantee principal ARN.</p>
        pub fn grantee_principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee_principal_arn = Some(input.into());
            self
        }
        /// <p>The grantee principal ARN.</p>
        pub fn set_grantee_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.grantee_principal_arn = input;
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>Grant status.</p>
        pub fn grant_status(mut self, input: crate::model::GrantStatus) -> Self {
            self.grant_status = Some(input);
            self
        }
        /// <p>Grant status.</p>
        pub fn set_grant_status(
            mut self,
            input: std::option::Option<crate::model::GrantStatus>,
        ) -> Self {
            self.grant_status = input;
            self
        }
        /// <p>Grant status reason.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Grant status reason.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Grant version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Grant version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `granted_operations`.
        ///
        /// To override the contents of this collection use [`set_granted_operations`](Self::set_granted_operations).
        ///
        /// <p>Granted operations.</p>
        pub fn granted_operations(
            mut self,
            input: impl Into<crate::model::AllowedOperation>,
        ) -> Self {
            let mut v = self.granted_operations.unwrap_or_default();
            v.push(input.into());
            self.granted_operations = Some(v);
            self
        }
        /// <p>Granted operations.</p>
        pub fn set_granted_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.granted_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`Grant`](crate::model::Grant)
        pub fn build(self) -> crate::model::Grant {
            crate::model::Grant {
                grant_arn: self.grant_arn,
                grant_name: self.grant_name,
                parent_arn: self.parent_arn,
                license_arn: self.license_arn,
                grantee_principal_arn: self.grantee_principal_arn,
                home_region: self.home_region,
                grant_status: self.grant_status,
                status_reason: self.status_reason,
                version: self.version,
                granted_operations: self.granted_operations,
            }
        }
    }
}
impl Grant {
    /// Creates a new builder-style object to manufacture [`Grant`](crate::model::Grant)
    pub fn builder() -> crate::model::grant::Builder {
        crate::model::grant::Builder::default()
    }
}

/// <p>Software license that is managed in License Manager.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct License {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>License name.</p>
    pub license_name: std::option::Option<std::string::String>,
    /// <p>Product name.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>Product SKU.</p>
    pub product_sku: std::option::Option<std::string::String>,
    /// <p>License issuer.</p>
    pub issuer: std::option::Option<crate::model::IssuerDetails>,
    /// <p>Home Region of the license.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>License status.</p>
    pub status: std::option::Option<crate::model::LicenseStatus>,
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub validity: std::option::Option<crate::model::DatetimeRange>,
    /// <p>License beneficiary.</p>
    pub beneficiary: std::option::Option<std::string::String>,
    /// <p>License entitlements.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// <p>Configuration for consumption of the license.</p>
    pub consumption_configuration: std::option::Option<crate::model::ConsumptionConfiguration>,
    /// <p>License metadata.</p>
    pub license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    /// <p>License creation time.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>License version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl License {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>License name.</p>
    pub fn license_name(&self) -> std::option::Option<&str> {
        self.license_name.as_deref()
    }
    /// <p>Product name.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>Product SKU.</p>
    pub fn product_sku(&self) -> std::option::Option<&str> {
        self.product_sku.as_deref()
    }
    /// <p>License issuer.</p>
    pub fn issuer(&self) -> std::option::Option<&crate::model::IssuerDetails> {
        self.issuer.as_ref()
    }
    /// <p>Home Region of the license.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>License status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LicenseStatus> {
        self.status.as_ref()
    }
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub fn validity(&self) -> std::option::Option<&crate::model::DatetimeRange> {
        self.validity.as_ref()
    }
    /// <p>License beneficiary.</p>
    pub fn beneficiary(&self) -> std::option::Option<&str> {
        self.beneficiary.as_deref()
    }
    /// <p>License entitlements.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::Entitlement]> {
        self.entitlements.as_deref()
    }
    /// <p>Configuration for consumption of the license.</p>
    pub fn consumption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConsumptionConfiguration> {
        self.consumption_configuration.as_ref()
    }
    /// <p>License metadata.</p>
    pub fn license_metadata(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.license_metadata.as_deref()
    }
    /// <p>License creation time.</p>
    pub fn create_time(&self) -> std::option::Option<&str> {
        self.create_time.as_deref()
    }
    /// <p>License version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for License {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("License");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("license_name", &self.license_name);
        formatter.field("product_name", &self.product_name);
        formatter.field("product_sku", &self.product_sku);
        formatter.field("issuer", &self.issuer);
        formatter.field("home_region", &self.home_region);
        formatter.field("status", &self.status);
        formatter.field("validity", &self.validity);
        formatter.field("beneficiary", &self.beneficiary);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("consumption_configuration", &self.consumption_configuration);
        formatter.field("license_metadata", &self.license_metadata);
        formatter.field("create_time", &self.create_time);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`License`](crate::model::License)
pub mod license {
    /// A builder for [`License`](crate::model::License)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) license_name: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) product_sku: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<crate::model::IssuerDetails>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::LicenseStatus>,
        pub(crate) validity: std::option::Option<crate::model::DatetimeRange>,
        pub(crate) beneficiary: std::option::Option<std::string::String>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) consumption_configuration:
            std::option::Option<crate::model::ConsumptionConfiguration>,
        pub(crate) license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_name = Some(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_name = input;
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_sku = Some(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_sku = input;
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, input: crate::model::IssuerDetails) -> Self {
            self.issuer = Some(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(
            mut self,
            input: std::option::Option<crate::model::IssuerDetails>,
        ) -> Self {
            self.issuer = input;
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>License status.</p>
        pub fn status(mut self, input: crate::model::LicenseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>License status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.validity = input;
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.beneficiary = Some(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.beneficiary = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: impl Into<crate::model::Entitlement>) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>Configuration for consumption of the license.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.consumption_configuration = Some(input);
            self
        }
        /// <p>Configuration for consumption of the license.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.consumption_configuration = input;
            self
        }
        /// Appends an item to `license_metadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>License metadata.</p>
        pub fn license_metadata(mut self, input: impl Into<crate::model::Metadata>) -> Self {
            let mut v = self.license_metadata.unwrap_or_default();
            v.push(input.into());
            self.license_metadata = Some(v);
            self
        }
        /// <p>License metadata.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.license_metadata = input;
            self
        }
        /// <p>License creation time.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>License creation time.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>License version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>License version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`License`](crate::model::License)
        pub fn build(self) -> crate::model::License {
            crate::model::License {
                license_arn: self.license_arn,
                license_name: self.license_name,
                product_name: self.product_name,
                product_sku: self.product_sku,
                issuer: self.issuer,
                home_region: self.home_region,
                status: self.status,
                validity: self.validity,
                beneficiary: self.beneficiary,
                entitlements: self.entitlements,
                consumption_configuration: self.consumption_configuration,
                license_metadata: self.license_metadata,
                create_time: self.create_time,
                version: self.version,
            }
        }
    }
}
impl License {
    /// Creates a new builder-style object to manufacture [`License`](crate::model::License)
    pub fn builder() -> crate::model::license::Builder {
        crate::model::license::Builder::default()
    }
}

/// <p>Describe the details of a report generator.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportGenerator {
    /// <p>Name of the report generator.</p>
    pub report_generator_name: std::option::Option<std::string::String>,
    /// <p>Type of reports that are generated.</p>
    pub report_type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
    /// <p>License configuration type for this generator.</p>
    pub report_context: std::option::Option<crate::model::ReportContext>,
    /// <p>Details about how frequently reports are generated.</p>
    pub report_frequency: std::option::Option<crate::model::ReportFrequency>,
    /// <p>Amazon Resource Name (ARN) of the report generator.</p>
    pub license_manager_report_generator_arn: std::option::Option<std::string::String>,
    /// <p>Status of the last report generation attempt.</p>
    pub last_run_status: std::option::Option<std::string::String>,
    /// <p>Failure message for the last report generation attempt.</p>
    pub last_run_failure_reason: std::option::Option<std::string::String>,
    /// <p>Time the last report was generated at.</p>
    pub last_report_generation_time: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID used to create the report generator.</p>
    pub report_creator_account: std::option::Option<std::string::String>,
    /// <p>Description of the report generator.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Details of the S3 bucket that report generator reports are published to.</p>
    pub s3_location: std::option::Option<crate::model::S3Location>,
    /// <p>Time the report was created.</p>
    pub create_time: std::option::Option<std::string::String>,
    /// <p>Tags associated with the report generator.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ReportGenerator {
    /// <p>Name of the report generator.</p>
    pub fn report_generator_name(&self) -> std::option::Option<&str> {
        self.report_generator_name.as_deref()
    }
    /// <p>Type of reports that are generated.</p>
    pub fn report_type(&self) -> std::option::Option<&[crate::model::ReportType]> {
        self.report_type.as_deref()
    }
    /// <p>License configuration type for this generator.</p>
    pub fn report_context(&self) -> std::option::Option<&crate::model::ReportContext> {
        self.report_context.as_ref()
    }
    /// <p>Details about how frequently reports are generated.</p>
    pub fn report_frequency(&self) -> std::option::Option<&crate::model::ReportFrequency> {
        self.report_frequency.as_ref()
    }
    /// <p>Amazon Resource Name (ARN) of the report generator.</p>
    pub fn license_manager_report_generator_arn(&self) -> std::option::Option<&str> {
        self.license_manager_report_generator_arn.as_deref()
    }
    /// <p>Status of the last report generation attempt.</p>
    pub fn last_run_status(&self) -> std::option::Option<&str> {
        self.last_run_status.as_deref()
    }
    /// <p>Failure message for the last report generation attempt.</p>
    pub fn last_run_failure_reason(&self) -> std::option::Option<&str> {
        self.last_run_failure_reason.as_deref()
    }
    /// <p>Time the last report was generated at.</p>
    pub fn last_report_generation_time(&self) -> std::option::Option<&str> {
        self.last_report_generation_time.as_deref()
    }
    /// <p>The Amazon Web Services account ID used to create the report generator.</p>
    pub fn report_creator_account(&self) -> std::option::Option<&str> {
        self.report_creator_account.as_deref()
    }
    /// <p>Description of the report generator.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Details of the S3 bucket that report generator reports are published to.</p>
    pub fn s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.s3_location.as_ref()
    }
    /// <p>Time the report was created.</p>
    pub fn create_time(&self) -> std::option::Option<&str> {
        self.create_time.as_deref()
    }
    /// <p>Tags associated with the report generator.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ReportGenerator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportGenerator");
        formatter.field("report_generator_name", &self.report_generator_name);
        formatter.field("report_type", &self.report_type);
        formatter.field("report_context", &self.report_context);
        formatter.field("report_frequency", &self.report_frequency);
        formatter.field(
            "license_manager_report_generator_arn",
            &self.license_manager_report_generator_arn,
        );
        formatter.field("last_run_status", &self.last_run_status);
        formatter.field("last_run_failure_reason", &self.last_run_failure_reason);
        formatter.field(
            "last_report_generation_time",
            &self.last_report_generation_time,
        );
        formatter.field("report_creator_account", &self.report_creator_account);
        formatter.field("description", &self.description);
        formatter.field("s3_location", &self.s3_location);
        formatter.field("create_time", &self.create_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ReportGenerator`](crate::model::ReportGenerator)
pub mod report_generator {
    /// A builder for [`ReportGenerator`](crate::model::ReportGenerator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_generator_name: std::option::Option<std::string::String>,
        pub(crate) report_type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        pub(crate) report_context: std::option::Option<crate::model::ReportContext>,
        pub(crate) report_frequency: std::option::Option<crate::model::ReportFrequency>,
        pub(crate) license_manager_report_generator_arn: std::option::Option<std::string::String>,
        pub(crate) last_run_status: std::option::Option<std::string::String>,
        pub(crate) last_run_failure_reason: std::option::Option<std::string::String>,
        pub(crate) last_report_generation_time: std::option::Option<std::string::String>,
        pub(crate) report_creator_account: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) s3_location: std::option::Option<crate::model::S3Location>,
        pub(crate) create_time: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_generator_name = Some(input.into());
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_generator_name = input;
            self
        }
        /// Appends an item to `report_type`.
        ///
        /// To override the contents of this collection use [`set_report_type`](Self::set_report_type).
        ///
        /// <p>Type of reports that are generated.</p>
        pub fn report_type(mut self, input: impl Into<crate::model::ReportType>) -> Self {
            let mut v = self.report_type.unwrap_or_default();
            v.push(input.into());
            self.report_type = Some(v);
            self
        }
        /// <p>Type of reports that are generated.</p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.report_type = input;
            self
        }
        /// <p>License configuration type for this generator.</p>
        pub fn report_context(mut self, input: crate::model::ReportContext) -> Self {
            self.report_context = Some(input);
            self
        }
        /// <p>License configuration type for this generator.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.report_context = input;
            self
        }
        /// <p>Details about how frequently reports are generated.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.report_frequency = Some(input);
            self
        }
        /// <p>Details about how frequently reports are generated.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.report_frequency = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = input;
            self
        }
        /// <p>Status of the last report generation attempt.</p>
        pub fn last_run_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_run_status = Some(input.into());
            self
        }
        /// <p>Status of the last report generation attempt.</p>
        pub fn set_last_run_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_run_status = input;
            self
        }
        /// <p>Failure message for the last report generation attempt.</p>
        pub fn last_run_failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_run_failure_reason = Some(input.into());
            self
        }
        /// <p>Failure message for the last report generation attempt.</p>
        pub fn set_last_run_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_run_failure_reason = input;
            self
        }
        /// <p>Time the last report was generated at.</p>
        pub fn last_report_generation_time(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.last_report_generation_time = Some(input.into());
            self
        }
        /// <p>Time the last report was generated at.</p>
        pub fn set_last_report_generation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_report_generation_time = input;
            self
        }
        /// <p>The Amazon Web Services account ID used to create the report generator.</p>
        pub fn report_creator_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_creator_account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID used to create the report generator.</p>
        pub fn set_report_creator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_creator_account = input;
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Details of the S3 bucket that report generator reports are published to.</p>
        pub fn s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.s3_location = Some(input);
            self
        }
        /// <p>Details of the S3 bucket that report generator reports are published to.</p>
        pub fn set_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.s3_location = input;
            self
        }
        /// <p>Time the report was created.</p>
        pub fn create_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.create_time = Some(input.into());
            self
        }
        /// <p>Time the report was created.</p>
        pub fn set_create_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the report generator.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>Tags associated with the report generator.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportGenerator`](crate::model::ReportGenerator)
        pub fn build(self) -> crate::model::ReportGenerator {
            crate::model::ReportGenerator {
                report_generator_name: self.report_generator_name,
                report_type: self.report_type,
                report_context: self.report_context,
                report_frequency: self.report_frequency,
                license_manager_report_generator_arn: self.license_manager_report_generator_arn,
                last_run_status: self.last_run_status,
                last_run_failure_reason: self.last_run_failure_reason,
                last_report_generation_time: self.last_report_generation_time,
                report_creator_account: self.report_creator_account,
                description: self.description,
                s3_location: self.s3_location,
                create_time: self.create_time,
                tags: self.tags,
            }
        }
    }
}
impl ReportGenerator {
    /// Creates a new builder-style object to manufacture [`ReportGenerator`](crate::model::ReportGenerator)
    pub fn builder() -> crate::model::report_generator::Builder {
        crate::model::report_generator::Builder::default()
    }
}

/// <p>Details of the S3 bucket that report generator reports are published to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Location {
    /// <p>Name of the S3 bucket reports are published to.</p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>Prefix of the S3 bucket reports are published to.</p>
    pub key_prefix: std::option::Option<std::string::String>,
}
impl S3Location {
    /// <p>Name of the S3 bucket reports are published to.</p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>Prefix of the S3 bucket reports are published to.</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Location");
        formatter.field("bucket", &self.bucket);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.finish()
    }
}
/// See [`S3Location`](crate::model::S3Location)
pub mod s3_location {
    /// A builder for [`S3Location`](crate::model::S3Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the S3 bucket reports are published to.</p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p>Name of the S3 bucket reports are published to.</p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>Prefix of the S3 bucket reports are published to.</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>Prefix of the S3 bucket reports are published to.</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Location`](crate::model::S3Location)
        pub fn build(self) -> crate::model::S3Location {
            crate::model::S3Location {
                bucket: self.bucket,
                key_prefix: self.key_prefix,
            }
        }
    }
}
impl S3Location {
    /// Creates a new builder-style object to manufacture [`S3Location`](crate::model::S3Location)
    pub fn builder() -> crate::model::s3_location::Builder {
        crate::model::s3_location::Builder::default()
    }
}

/// <p>Information about a license type conversion task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConversionTask {
    /// <p>The ID of the license type conversion task.</p>
    pub license_conversion_task_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the license type
    /// conversion task.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Information about the license type this conversion task converted from.</p>
    pub source_license_context: std::option::Option<crate::model::LicenseConversionContext>,
    /// <p>Information about the license type this conversion task converted to.</p>
    pub destination_license_context: std::option::Option<crate::model::LicenseConversionContext>,
    /// <p>The status of the conversion task.</p>
    pub status: std::option::Option<crate::model::LicenseConversionTaskStatus>,
    /// <p>The status message for the conversion task.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The time the conversion task was started at.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the usage operation value of the resource was changed.</p>
    pub license_conversion_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time the conversion task was completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl LicenseConversionTask {
    /// <p>The ID of the license type conversion task.</p>
    pub fn license_conversion_task_id(&self) -> std::option::Option<&str> {
        self.license_conversion_task_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource associated with the license type
    /// conversion task.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Information about the license type this conversion task converted from.</p>
    pub fn source_license_context(
        &self,
    ) -> std::option::Option<&crate::model::LicenseConversionContext> {
        self.source_license_context.as_ref()
    }
    /// <p>Information about the license type this conversion task converted to.</p>
    pub fn destination_license_context(
        &self,
    ) -> std::option::Option<&crate::model::LicenseConversionContext> {
        self.destination_license_context.as_ref()
    }
    /// <p>The status of the conversion task.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LicenseConversionTaskStatus> {
        self.status.as_ref()
    }
    /// <p>The status message for the conversion task.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The time the conversion task was started at.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time the usage operation value of the resource was changed.</p>
    pub fn license_conversion_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.license_conversion_time.as_ref()
    }
    /// <p>The time the conversion task was completed.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for LicenseConversionTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConversionTask");
        formatter.field(
            "license_conversion_task_id",
            &self.license_conversion_task_id,
        );
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("source_license_context", &self.source_license_context);
        formatter.field(
            "destination_license_context",
            &self.destination_license_context,
        );
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("start_time", &self.start_time);
        formatter.field("license_conversion_time", &self.license_conversion_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`LicenseConversionTask`](crate::model::LicenseConversionTask)
pub mod license_conversion_task {
    /// A builder for [`LicenseConversionTask`](crate::model::LicenseConversionTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_conversion_task_id: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) source_license_context:
            std::option::Option<crate::model::LicenseConversionContext>,
        pub(crate) destination_license_context:
            std::option::Option<crate::model::LicenseConversionContext>,
        pub(crate) status: std::option::Option<crate::model::LicenseConversionTaskStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) license_conversion_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The ID of the license type conversion task.</p>
        pub fn license_conversion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_conversion_task_id = Some(input.into());
            self
        }
        /// <p>The ID of the license type conversion task.</p>
        pub fn set_license_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_conversion_task_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the license type
        /// conversion task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource associated with the license type
        /// conversion task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Information about the license type this conversion task converted from.</p>
        pub fn source_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.source_license_context = Some(input);
            self
        }
        /// <p>Information about the license type this conversion task converted from.</p>
        pub fn set_source_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.source_license_context = input;
            self
        }
        /// <p>Information about the license type this conversion task converted to.</p>
        pub fn destination_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.destination_license_context = Some(input);
            self
        }
        /// <p>Information about the license type this conversion task converted to.</p>
        pub fn set_destination_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.destination_license_context = input;
            self
        }
        /// <p>The status of the conversion task.</p>
        pub fn status(mut self, input: crate::model::LicenseConversionTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the conversion task.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message for the conversion task.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message for the conversion task.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The time the conversion task was started at.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the conversion task was started at.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time the usage operation value of the resource was changed.</p>
        pub fn license_conversion_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.license_conversion_time = Some(input);
            self
        }
        /// <p>The time the usage operation value of the resource was changed.</p>
        pub fn set_license_conversion_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.license_conversion_time = input;
            self
        }
        /// <p>The time the conversion task was completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time the conversion task was completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConversionTask`](crate::model::LicenseConversionTask)
        pub fn build(self) -> crate::model::LicenseConversionTask {
            crate::model::LicenseConversionTask {
                license_conversion_task_id: self.license_conversion_task_id,
                resource_arn: self.resource_arn,
                source_license_context: self.source_license_context,
                destination_license_context: self.destination_license_context,
                status: self.status,
                status_message: self.status_message,
                start_time: self.start_time,
                license_conversion_time: self.license_conversion_time,
                end_time: self.end_time,
            }
        }
    }
}
impl LicenseConversionTask {
    /// Creates a new builder-style object to manufacture [`LicenseConversionTask`](crate::model::LicenseConversionTask)
    pub fn builder() -> crate::model::license_conversion_task::Builder {
        crate::model::license_conversion_task::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseConversionTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseConversionTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LicenseConversionTaskStatus::Failed,
            "IN_PROGRESS" => LicenseConversionTaskStatus::InProgress,
            "SUCCEEDED" => LicenseConversionTaskStatus::Succeeded,
            other => LicenseConversionTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseConversionTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseConversionTaskStatus::from(s))
    }
}
impl LicenseConversionTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseConversionTaskStatus::Failed => "FAILED",
            LicenseConversionTaskStatus::InProgress => "IN_PROGRESS",
            LicenseConversionTaskStatus::Succeeded => "SUCCEEDED",
            LicenseConversionTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "SUCCEEDED"]
    }
}
impl AsRef<str> for LicenseConversionTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a license type conversion task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConversionContext {
    /// <p>The Usage operation value that corresponds to the license type you are converting your resource from.  For more information about which platforms correspond to which usage operation values see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data: usage operation by platform
    /// </a>
    /// </p>
    pub usage_operation: std::option::Option<std::string::String>,
}
impl LicenseConversionContext {
    /// <p>The Usage operation value that corresponds to the license type you are converting your resource from.  For more information about which platforms correspond to which usage operation values see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data: usage operation by platform
    /// </a>
    /// </p>
    pub fn usage_operation(&self) -> std::option::Option<&str> {
        self.usage_operation.as_deref()
    }
}
impl std::fmt::Debug for LicenseConversionContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConversionContext");
        formatter.field("usage_operation", &self.usage_operation);
        formatter.finish()
    }
}
/// See [`LicenseConversionContext`](crate::model::LicenseConversionContext)
pub mod license_conversion_context {
    /// A builder for [`LicenseConversionContext`](crate::model::LicenseConversionContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_operation: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Usage operation value that corresponds to the license type you are converting your resource from.  For more information about which platforms correspond to which usage operation values see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data: usage operation by platform
        /// </a>
        /// </p>
        pub fn usage_operation(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_operation = Some(input.into());
            self
        }
        /// <p>The Usage operation value that corresponds to the license type you are converting your resource from.  For more information about which platforms correspond to which usage operation values see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html#billing-info">Sample data: usage operation by platform
        /// </a>
        /// </p>
        pub fn set_usage_operation(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_operation = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConversionContext`](crate::model::LicenseConversionContext)
        pub fn build(self) -> crate::model::LicenseConversionContext {
            crate::model::LicenseConversionContext {
                usage_operation: self.usage_operation,
            }
        }
    }
}
impl LicenseConversionContext {
    /// Creates a new builder-style object to manufacture [`LicenseConversionContext`](crate::model::LicenseConversionContext)
    pub fn builder() -> crate::model::license_conversion_context::Builder {
        crate::model::license_conversion_context::Builder::default()
    }
}

/// <p>A license configuration is an abstraction of a customer license agreement that can be
/// consumed and enforced by License Manager. Components include specifications for the license
/// type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy,
/// Dedicated Instance, Dedicated Host, or all of these), host affinity (how long a VM
/// must be associated with a host), and the number of licenses purchased and used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConfiguration {
    /// <p>Unique ID of the license configuration.</p>
    pub license_configuration_id: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Name of the license configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Description of the license configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Dimension to use to track the license inventory.</p>
    pub license_counting_type: std::option::Option<crate::model::LicenseCountingType>,
    /// <p>License rules.</p>
    pub license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Number of licenses managed by the license configuration.</p>
    pub license_count: std::option::Option<i64>,
    /// <p>Number of available licenses as a hard limit.</p>
    pub license_count_hard_limit: std::option::Option<bool>,
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub disassociate_when_not_found: std::option::Option<bool>,
    /// <p>Number of licenses consumed. </p>
    pub consumed_licenses: std::option::Option<i64>,
    /// <p>Status of the license configuration.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Account ID of the license configuration's owner.</p>
    pub owner_account_id: std::option::Option<std::string::String>,
    /// <p>Summaries for licenses consumed by various resources.</p>
    pub consumed_license_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ConsumedLicenseSummary>>,
    /// <p>Summaries for managed resources.</p>
    pub managed_resource_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ManagedResourceSummary>>,
    /// <p>Product information.</p>
    pub product_information_list:
        std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
    /// <p>Automated discovery information.</p>
    pub automated_discovery_information:
        std::option::Option<crate::model::AutomatedDiscoveryInformation>,
}
impl LicenseConfiguration {
    /// <p>Unique ID of the license configuration.</p>
    pub fn license_configuration_id(&self) -> std::option::Option<&str> {
        self.license_configuration_id.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>Name of the license configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Description of the license configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Dimension to use to track the license inventory.</p>
    pub fn license_counting_type(&self) -> std::option::Option<&crate::model::LicenseCountingType> {
        self.license_counting_type.as_ref()
    }
    /// <p>License rules.</p>
    pub fn license_rules(&self) -> std::option::Option<&[std::string::String]> {
        self.license_rules.as_deref()
    }
    /// <p>Number of licenses managed by the license configuration.</p>
    pub fn license_count(&self) -> std::option::Option<i64> {
        self.license_count
    }
    /// <p>Number of available licenses as a hard limit.</p>
    pub fn license_count_hard_limit(&self) -> std::option::Option<bool> {
        self.license_count_hard_limit
    }
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub fn disassociate_when_not_found(&self) -> std::option::Option<bool> {
        self.disassociate_when_not_found
    }
    /// <p>Number of licenses consumed. </p>
    pub fn consumed_licenses(&self) -> std::option::Option<i64> {
        self.consumed_licenses
    }
    /// <p>Status of the license configuration.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Account ID of the license configuration's owner.</p>
    pub fn owner_account_id(&self) -> std::option::Option<&str> {
        self.owner_account_id.as_deref()
    }
    /// <p>Summaries for licenses consumed by various resources.</p>
    pub fn consumed_license_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ConsumedLicenseSummary]> {
        self.consumed_license_summary_list.as_deref()
    }
    /// <p>Summaries for managed resources.</p>
    pub fn managed_resource_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::ManagedResourceSummary]> {
        self.managed_resource_summary_list.as_deref()
    }
    /// <p>Product information.</p>
    pub fn product_information_list(
        &self,
    ) -> std::option::Option<&[crate::model::ProductInformation]> {
        self.product_information_list.as_deref()
    }
    /// <p>Automated discovery information.</p>
    pub fn automated_discovery_information(
        &self,
    ) -> std::option::Option<&crate::model::AutomatedDiscoveryInformation> {
        self.automated_discovery_information.as_ref()
    }
}
impl std::fmt::Debug for LicenseConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConfiguration");
        formatter.field("license_configuration_id", &self.license_configuration_id);
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("license_counting_type", &self.license_counting_type);
        formatter.field("license_rules", &self.license_rules);
        formatter.field("license_count", &self.license_count);
        formatter.field("license_count_hard_limit", &self.license_count_hard_limit);
        formatter.field(
            "disassociate_when_not_found",
            &self.disassociate_when_not_found,
        );
        formatter.field("consumed_licenses", &self.consumed_licenses);
        formatter.field("status", &self.status);
        formatter.field("owner_account_id", &self.owner_account_id);
        formatter.field(
            "consumed_license_summary_list",
            &self.consumed_license_summary_list,
        );
        formatter.field(
            "managed_resource_summary_list",
            &self.managed_resource_summary_list,
        );
        formatter.field("product_information_list", &self.product_information_list);
        formatter.field(
            "automated_discovery_information",
            &self.automated_discovery_information,
        );
        formatter.finish()
    }
}
/// See [`LicenseConfiguration`](crate::model::LicenseConfiguration)
pub mod license_configuration {
    /// A builder for [`LicenseConfiguration`](crate::model::LicenseConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_id: std::option::Option<std::string::String>,
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) license_counting_type: std::option::Option<crate::model::LicenseCountingType>,
        pub(crate) license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_count: std::option::Option<i64>,
        pub(crate) license_count_hard_limit: std::option::Option<bool>,
        pub(crate) disassociate_when_not_found: std::option::Option<bool>,
        pub(crate) consumed_licenses: std::option::Option<i64>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) owner_account_id: std::option::Option<std::string::String>,
        pub(crate) consumed_license_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ConsumedLicenseSummary>>,
        pub(crate) managed_resource_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ManagedResourceSummary>>,
        pub(crate) product_information_list:
            std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        pub(crate) automated_discovery_information:
            std::option::Option<crate::model::AutomatedDiscoveryInformation>,
    }
    impl Builder {
        /// <p>Unique ID of the license configuration.</p>
        pub fn license_configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_id = Some(input.into());
            self
        }
        /// <p>Unique ID of the license configuration.</p>
        pub fn set_license_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_id = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>Name of the license configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Dimension to use to track the license inventory.</p>
        pub fn license_counting_type(mut self, input: crate::model::LicenseCountingType) -> Self {
            self.license_counting_type = Some(input);
            self
        }
        /// <p>Dimension to use to track the license inventory.</p>
        pub fn set_license_counting_type(
            mut self,
            input: std::option::Option<crate::model::LicenseCountingType>,
        ) -> Self {
            self.license_counting_type = input;
            self
        }
        /// Appends an item to `license_rules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>License rules.</p>
        pub fn license_rules(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_rules.unwrap_or_default();
            v.push(input.into());
            self.license_rules = Some(v);
            self
        }
        /// <p>License rules.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_rules = input;
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, input: i64) -> Self {
            self.license_count = Some(input);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.license_count = input;
            self
        }
        /// <p>Number of available licenses as a hard limit.</p>
        pub fn license_count_hard_limit(mut self, input: bool) -> Self {
            self.license_count_hard_limit = Some(input);
            self
        }
        /// <p>Number of available licenses as a hard limit.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.license_count_hard_limit = input;
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, input: bool) -> Self {
            self.disassociate_when_not_found = Some(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.disassociate_when_not_found = input;
            self
        }
        /// <p>Number of licenses consumed. </p>
        pub fn consumed_licenses(mut self, input: i64) -> Self {
            self.consumed_licenses = Some(input);
            self
        }
        /// <p>Number of licenses consumed. </p>
        pub fn set_consumed_licenses(mut self, input: std::option::Option<i64>) -> Self {
            self.consumed_licenses = input;
            self
        }
        /// <p>Status of the license configuration.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Status of the license configuration.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Account ID of the license configuration's owner.</p>
        pub fn owner_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account_id = Some(input.into());
            self
        }
        /// <p>Account ID of the license configuration's owner.</p>
        pub fn set_owner_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account_id = input;
            self
        }
        /// Appends an item to `consumed_license_summary_list`.
        ///
        /// To override the contents of this collection use [`set_consumed_license_summary_list`](Self::set_consumed_license_summary_list).
        ///
        /// <p>Summaries for licenses consumed by various resources.</p>
        pub fn consumed_license_summary_list(
            mut self,
            input: impl Into<crate::model::ConsumedLicenseSummary>,
        ) -> Self {
            let mut v = self.consumed_license_summary_list.unwrap_or_default();
            v.push(input.into());
            self.consumed_license_summary_list = Some(v);
            self
        }
        /// <p>Summaries for licenses consumed by various resources.</p>
        pub fn set_consumed_license_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConsumedLicenseSummary>>,
        ) -> Self {
            self.consumed_license_summary_list = input;
            self
        }
        /// Appends an item to `managed_resource_summary_list`.
        ///
        /// To override the contents of this collection use [`set_managed_resource_summary_list`](Self::set_managed_resource_summary_list).
        ///
        /// <p>Summaries for managed resources.</p>
        pub fn managed_resource_summary_list(
            mut self,
            input: impl Into<crate::model::ManagedResourceSummary>,
        ) -> Self {
            let mut v = self.managed_resource_summary_list.unwrap_or_default();
            v.push(input.into());
            self.managed_resource_summary_list = Some(v);
            self
        }
        /// <p>Summaries for managed resources.</p>
        pub fn set_managed_resource_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedResourceSummary>>,
        ) -> Self {
            self.managed_resource_summary_list = input;
            self
        }
        /// Appends an item to `product_information_list`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>Product information.</p>
        pub fn product_information_list(
            mut self,
            input: impl Into<crate::model::ProductInformation>,
        ) -> Self {
            let mut v = self.product_information_list.unwrap_or_default();
            v.push(input.into());
            self.product_information_list = Some(v);
            self
        }
        /// <p>Product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.product_information_list = input;
            self
        }
        /// <p>Automated discovery information.</p>
        pub fn automated_discovery_information(
            mut self,
            input: crate::model::AutomatedDiscoveryInformation,
        ) -> Self {
            self.automated_discovery_information = Some(input);
            self
        }
        /// <p>Automated discovery information.</p>
        pub fn set_automated_discovery_information(
            mut self,
            input: std::option::Option<crate::model::AutomatedDiscoveryInformation>,
        ) -> Self {
            self.automated_discovery_information = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConfiguration`](crate::model::LicenseConfiguration)
        pub fn build(self) -> crate::model::LicenseConfiguration {
            crate::model::LicenseConfiguration {
                license_configuration_id: self.license_configuration_id,
                license_configuration_arn: self.license_configuration_arn,
                name: self.name,
                description: self.description,
                license_counting_type: self.license_counting_type,
                license_rules: self.license_rules,
                license_count: self.license_count,
                license_count_hard_limit: self.license_count_hard_limit,
                disassociate_when_not_found: self.disassociate_when_not_found,
                consumed_licenses: self.consumed_licenses,
                status: self.status,
                owner_account_id: self.owner_account_id,
                consumed_license_summary_list: self.consumed_license_summary_list,
                managed_resource_summary_list: self.managed_resource_summary_list,
                product_information_list: self.product_information_list,
                automated_discovery_information: self.automated_discovery_information,
            }
        }
    }
}
impl LicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`LicenseConfiguration`](crate::model::LicenseConfiguration)
    pub fn builder() -> crate::model::license_configuration::Builder {
        crate::model::license_configuration::Builder::default()
    }
}

/// <p>Describes automated discovery.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomatedDiscoveryInformation {
    /// <p>Time that automated discovery last ran.</p>
    pub last_run_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl AutomatedDiscoveryInformation {
    /// <p>Time that automated discovery last ran.</p>
    pub fn last_run_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_run_time.as_ref()
    }
}
impl std::fmt::Debug for AutomatedDiscoveryInformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomatedDiscoveryInformation");
        formatter.field("last_run_time", &self.last_run_time);
        formatter.finish()
    }
}
/// See [`AutomatedDiscoveryInformation`](crate::model::AutomatedDiscoveryInformation)
pub mod automated_discovery_information {
    /// A builder for [`AutomatedDiscoveryInformation`](crate::model::AutomatedDiscoveryInformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_run_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Time that automated discovery last ran.</p>
        pub fn last_run_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_run_time = Some(input);
            self
        }
        /// <p>Time that automated discovery last ran.</p>
        pub fn set_last_run_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_run_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomatedDiscoveryInformation`](crate::model::AutomatedDiscoveryInformation)
        pub fn build(self) -> crate::model::AutomatedDiscoveryInformation {
            crate::model::AutomatedDiscoveryInformation {
                last_run_time: self.last_run_time,
            }
        }
    }
}
impl AutomatedDiscoveryInformation {
    /// Creates a new builder-style object to manufacture [`AutomatedDiscoveryInformation`](crate::model::AutomatedDiscoveryInformation)
    pub fn builder() -> crate::model::automated_discovery_information::Builder {
        crate::model::automated_discovery_information::Builder::default()
    }
}

/// <p>Summary information about a managed resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedResourceSummary {
    /// <p>Type of resource associated with a license.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Number of resources associated with licenses.</p>
    pub association_count: std::option::Option<i64>,
}
impl ManagedResourceSummary {
    /// <p>Type of resource associated with a license.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Number of resources associated with licenses.</p>
    pub fn association_count(&self) -> std::option::Option<i64> {
        self.association_count
    }
}
impl std::fmt::Debug for ManagedResourceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedResourceSummary");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("association_count", &self.association_count);
        formatter.finish()
    }
}
/// See [`ManagedResourceSummary`](crate::model::ManagedResourceSummary)
pub mod managed_resource_summary {
    /// A builder for [`ManagedResourceSummary`](crate::model::ManagedResourceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) association_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Type of resource associated with a license.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Type of resource associated with a license.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Number of resources associated with licenses.</p>
        pub fn association_count(mut self, input: i64) -> Self {
            self.association_count = Some(input);
            self
        }
        /// <p>Number of resources associated with licenses.</p>
        pub fn set_association_count(mut self, input: std::option::Option<i64>) -> Self {
            self.association_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedResourceSummary`](crate::model::ManagedResourceSummary)
        pub fn build(self) -> crate::model::ManagedResourceSummary {
            crate::model::ManagedResourceSummary {
                resource_type: self.resource_type,
                association_count: self.association_count,
            }
        }
    }
}
impl ManagedResourceSummary {
    /// Creates a new builder-style object to manufacture [`ManagedResourceSummary`](crate::model::ManagedResourceSummary)
    pub fn builder() -> crate::model::managed_resource_summary::Builder {
        crate::model::managed_resource_summary::Builder::default()
    }
}

/// <p>Details about license consumption.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConsumedLicenseSummary {
    /// <p>Resource type of the resource consuming a license.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Number of licenses consumed by the resource.</p>
    pub consumed_licenses: std::option::Option<i64>,
}
impl ConsumedLicenseSummary {
    /// <p>Resource type of the resource consuming a license.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Number of licenses consumed by the resource.</p>
    pub fn consumed_licenses(&self) -> std::option::Option<i64> {
        self.consumed_licenses
    }
}
impl std::fmt::Debug for ConsumedLicenseSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConsumedLicenseSummary");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("consumed_licenses", &self.consumed_licenses);
        formatter.finish()
    }
}
/// See [`ConsumedLicenseSummary`](crate::model::ConsumedLicenseSummary)
pub mod consumed_license_summary {
    /// A builder for [`ConsumedLicenseSummary`](crate::model::ConsumedLicenseSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) consumed_licenses: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Resource type of the resource consuming a license.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Resource type of the resource consuming a license.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Number of licenses consumed by the resource.</p>
        pub fn consumed_licenses(mut self, input: i64) -> Self {
            self.consumed_licenses = Some(input);
            self
        }
        /// <p>Number of licenses consumed by the resource.</p>
        pub fn set_consumed_licenses(mut self, input: std::option::Option<i64>) -> Self {
            self.consumed_licenses = input;
            self
        }
        /// Consumes the builder and constructs a [`ConsumedLicenseSummary`](crate::model::ConsumedLicenseSummary)
        pub fn build(self) -> crate::model::ConsumedLicenseSummary {
            crate::model::ConsumedLicenseSummary {
                resource_type: self.resource_type,
                consumed_licenses: self.consumed_licenses,
            }
        }
    }
}
impl ConsumedLicenseSummary {
    /// Creates a new builder-style object to manufacture [`ConsumedLicenseSummary`](crate::model::ConsumedLicenseSummary)
    pub fn builder() -> crate::model::consumed_license_summary::Builder {
        crate::model::consumed_license_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseCountingType {
    #[allow(missing_docs)] // documentation missing in model
    Core,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    Socket,
    #[allow(missing_docs)] // documentation missing in model
    Vcpu,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseCountingType {
    fn from(s: &str) -> Self {
        match s {
            "Core" => LicenseCountingType::Core,
            "Instance" => LicenseCountingType::Instance,
            "Socket" => LicenseCountingType::Socket,
            "vCPU" => LicenseCountingType::Vcpu,
            other => LicenseCountingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseCountingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseCountingType::from(s))
    }
}
impl LicenseCountingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseCountingType::Core => "Core",
            LicenseCountingType::Instance => "Instance",
            LicenseCountingType::Socket => "Socket",
            LicenseCountingType::Vcpu => "vCPU",
            LicenseCountingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Core", "Instance", "Socket", "vCPU"]
    }
}
impl AsRef<str> for LicenseCountingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the failure of a license operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseOperationFailure {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Resource type.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Failure time.</p>
    pub failure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Name of the operation.</p>
    pub operation_name: std::option::Option<std::string::String>,
    /// <p>ID of the Amazon Web Services account that owns the resource.</p>
    pub resource_owner_id: std::option::Option<std::string::String>,
    /// <p>The requester is "License Manager Automated Discovery".</p>
    pub operation_requested_by: std::option::Option<std::string::String>,
    /// <p>Reserved.</p>
    pub metadata_list: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
}
impl LicenseOperationFailure {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Resource type.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Failure time.</p>
    pub fn failure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.failure_time.as_ref()
    }
    /// <p>Name of the operation.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
    /// <p>ID of the Amazon Web Services account that owns the resource.</p>
    pub fn resource_owner_id(&self) -> std::option::Option<&str> {
        self.resource_owner_id.as_deref()
    }
    /// <p>The requester is "License Manager Automated Discovery".</p>
    pub fn operation_requested_by(&self) -> std::option::Option<&str> {
        self.operation_requested_by.as_deref()
    }
    /// <p>Reserved.</p>
    pub fn metadata_list(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.metadata_list.as_deref()
    }
}
impl std::fmt::Debug for LicenseOperationFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseOperationFailure");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("error_message", &self.error_message);
        formatter.field("failure_time", &self.failure_time);
        formatter.field("operation_name", &self.operation_name);
        formatter.field("resource_owner_id", &self.resource_owner_id);
        formatter.field("operation_requested_by", &self.operation_requested_by);
        formatter.field("metadata_list", &self.metadata_list);
        formatter.finish()
    }
}
/// See [`LicenseOperationFailure`](crate::model::LicenseOperationFailure)
pub mod license_operation_failure {
    /// A builder for [`LicenseOperationFailure`](crate::model::LicenseOperationFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) failure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) operation_name: std::option::Option<std::string::String>,
        pub(crate) resource_owner_id: std::option::Option<std::string::String>,
        pub(crate) operation_requested_by: std::option::Option<std::string::String>,
        pub(crate) metadata_list: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>Error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Failure time.</p>
        pub fn failure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.failure_time = Some(input);
            self
        }
        /// <p>Failure time.</p>
        pub fn set_failure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.failure_time = input;
            self
        }
        /// <p>Name of the operation.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>Name of the operation.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// <p>ID of the Amazon Web Services account that owns the resource.</p>
        pub fn resource_owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_id = Some(input.into());
            self
        }
        /// <p>ID of the Amazon Web Services account that owns the resource.</p>
        pub fn set_resource_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_id = input;
            self
        }
        /// <p>The requester is "License Manager Automated Discovery".</p>
        pub fn operation_requested_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_requested_by = Some(input.into());
            self
        }
        /// <p>The requester is "License Manager Automated Discovery".</p>
        pub fn set_operation_requested_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_requested_by = input;
            self
        }
        /// Appends an item to `metadata_list`.
        ///
        /// To override the contents of this collection use [`set_metadata_list`](Self::set_metadata_list).
        ///
        /// <p>Reserved.</p>
        pub fn metadata_list(mut self, input: impl Into<crate::model::Metadata>) -> Self {
            let mut v = self.metadata_list.unwrap_or_default();
            v.push(input.into());
            self.metadata_list = Some(v);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.metadata_list = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseOperationFailure`](crate::model::LicenseOperationFailure)
        pub fn build(self) -> crate::model::LicenseOperationFailure {
            crate::model::LicenseOperationFailure {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                error_message: self.error_message,
                failure_time: self.failure_time,
                operation_name: self.operation_name,
                resource_owner_id: self.resource_owner_id,
                operation_requested_by: self.operation_requested_by,
                metadata_list: self.metadata_list,
            }
        }
    }
}
impl LicenseOperationFailure {
    /// Creates a new builder-style object to manufacture [`LicenseOperationFailure`](crate::model::LicenseOperationFailure)
    pub fn builder() -> crate::model::license_operation_failure::Builder {
        crate::model::license_operation_failure::Builder::default()
    }
}

/// <p>Describes an association with a license configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseConfigurationAssociation {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Type of server resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>ID of the Amazon Web Services account that owns the resource consuming licenses.</p>
    pub resource_owner_id: std::option::Option<std::string::String>,
    /// <p>Time when the license configuration was associated with the resource.</p>
    pub association_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
    pub ami_association_scope: std::option::Option<std::string::String>,
}
impl LicenseConfigurationAssociation {
    /// <p>Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Type of server resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>ID of the Amazon Web Services account that owns the resource consuming licenses.</p>
    pub fn resource_owner_id(&self) -> std::option::Option<&str> {
        self.resource_owner_id.as_deref()
    }
    /// <p>Time when the license configuration was associated with the resource.</p>
    pub fn association_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.association_time.as_ref()
    }
    /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
    pub fn ami_association_scope(&self) -> std::option::Option<&str> {
        self.ami_association_scope.as_deref()
    }
}
impl std::fmt::Debug for LicenseConfigurationAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseConfigurationAssociation");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_owner_id", &self.resource_owner_id);
        formatter.field("association_time", &self.association_time);
        formatter.field("ami_association_scope", &self.ami_association_scope);
        formatter.finish()
    }
}
/// See [`LicenseConfigurationAssociation`](crate::model::LicenseConfigurationAssociation)
pub mod license_configuration_association {
    /// A builder for [`LicenseConfigurationAssociation`](crate::model::LicenseConfigurationAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_owner_id: std::option::Option<std::string::String>,
        pub(crate) association_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ami_association_scope: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Type of server resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Type of server resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>ID of the Amazon Web Services account that owns the resource consuming licenses.</p>
        pub fn resource_owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner_id = Some(input.into());
            self
        }
        /// <p>ID of the Amazon Web Services account that owns the resource consuming licenses.</p>
        pub fn set_resource_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner_id = input;
            self
        }
        /// <p>Time when the license configuration was associated with the resource.</p>
        pub fn association_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.association_time = Some(input);
            self
        }
        /// <p>Time when the license configuration was associated with the resource.</p>
        pub fn set_association_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.association_time = input;
            self
        }
        /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
        pub fn ami_association_scope(mut self, input: impl Into<std::string::String>) -> Self {
            self.ami_association_scope = Some(input.into());
            self
        }
        /// <p>Scope of AMI associations. The possible value is <code>cross-account</code>.</p>
        pub fn set_ami_association_scope(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ami_association_scope = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseConfigurationAssociation`](crate::model::LicenseConfigurationAssociation)
        pub fn build(self) -> crate::model::LicenseConfigurationAssociation {
            crate::model::LicenseConfigurationAssociation {
                resource_arn: self.resource_arn,
                resource_type: self.resource_type,
                resource_owner_id: self.resource_owner_id,
                association_time: self.association_time,
                ami_association_scope: self.ami_association_scope,
            }
        }
    }
}
impl LicenseConfigurationAssociation {
    /// Creates a new builder-style object to manufacture [`LicenseConfigurationAssociation`](crate::model::LicenseConfigurationAssociation)
    pub fn builder() -> crate::model::license_configuration_association::Builder {
        crate::model::license_configuration_association::Builder::default()
    }
}

/// <p>Describes the entitlement usage associated with a license.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseUsage {
    /// <p>License entitlement usages.</p>
    pub entitlement_usages: std::option::Option<std::vec::Vec<crate::model::EntitlementUsage>>,
}
impl LicenseUsage {
    /// <p>License entitlement usages.</p>
    pub fn entitlement_usages(&self) -> std::option::Option<&[crate::model::EntitlementUsage]> {
        self.entitlement_usages.as_deref()
    }
}
impl std::fmt::Debug for LicenseUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseUsage");
        formatter.field("entitlement_usages", &self.entitlement_usages);
        formatter.finish()
    }
}
/// See [`LicenseUsage`](crate::model::LicenseUsage)
pub mod license_usage {
    /// A builder for [`LicenseUsage`](crate::model::LicenseUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlement_usages:
            std::option::Option<std::vec::Vec<crate::model::EntitlementUsage>>,
    }
    impl Builder {
        /// Appends an item to `entitlement_usages`.
        ///
        /// To override the contents of this collection use [`set_entitlement_usages`](Self::set_entitlement_usages).
        ///
        /// <p>License entitlement usages.</p>
        pub fn entitlement_usages(
            mut self,
            input: impl Into<crate::model::EntitlementUsage>,
        ) -> Self {
            let mut v = self.entitlement_usages.unwrap_or_default();
            v.push(input.into());
            self.entitlement_usages = Some(v);
            self
        }
        /// <p>License entitlement usages.</p>
        pub fn set_entitlement_usages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementUsage>>,
        ) -> Self {
            self.entitlement_usages = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseUsage`](crate::model::LicenseUsage)
        pub fn build(self) -> crate::model::LicenseUsage {
            crate::model::LicenseUsage {
                entitlement_usages: self.entitlement_usages,
            }
        }
    }
}
impl LicenseUsage {
    /// Creates a new builder-style object to manufacture [`LicenseUsage`](crate::model::LicenseUsage)
    pub fn builder() -> crate::model::license_usage::Builder {
        crate::model::license_usage::Builder::default()
    }
}

/// <p>Usage associated with an entitlement resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitlementUsage {
    /// <p>Entitlement usage name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Resource usage consumed.</p>
    pub consumed_value: std::option::Option<std::string::String>,
    /// <p>Maximum entitlement usage count.</p>
    pub max_count: std::option::Option<std::string::String>,
    /// <p>Entitlement usage unit.</p>
    pub unit: std::option::Option<crate::model::EntitlementDataUnit>,
}
impl EntitlementUsage {
    /// <p>Entitlement usage name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Resource usage consumed.</p>
    pub fn consumed_value(&self) -> std::option::Option<&str> {
        self.consumed_value.as_deref()
    }
    /// <p>Maximum entitlement usage count.</p>
    pub fn max_count(&self) -> std::option::Option<&str> {
        self.max_count.as_deref()
    }
    /// <p>Entitlement usage unit.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::EntitlementDataUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for EntitlementUsage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitlementUsage");
        formatter.field("name", &self.name);
        formatter.field("consumed_value", &self.consumed_value);
        formatter.field("max_count", &self.max_count);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`EntitlementUsage`](crate::model::EntitlementUsage)
pub mod entitlement_usage {
    /// A builder for [`EntitlementUsage`](crate::model::EntitlementUsage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) consumed_value: std::option::Option<std::string::String>,
        pub(crate) max_count: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<crate::model::EntitlementDataUnit>,
    }
    impl Builder {
        /// <p>Entitlement usage name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Entitlement usage name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Resource usage consumed.</p>
        pub fn consumed_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumed_value = Some(input.into());
            self
        }
        /// <p>Resource usage consumed.</p>
        pub fn set_consumed_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumed_value = input;
            self
        }
        /// <p>Maximum entitlement usage count.</p>
        pub fn max_count(mut self, input: impl Into<std::string::String>) -> Self {
            self.max_count = Some(input.into());
            self
        }
        /// <p>Maximum entitlement usage count.</p>
        pub fn set_max_count(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max_count = input;
            self
        }
        /// <p>Entitlement usage unit.</p>
        pub fn unit(mut self, input: crate::model::EntitlementDataUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Entitlement usage unit.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::EntitlementDataUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitlementUsage`](crate::model::EntitlementUsage)
        pub fn build(self) -> crate::model::EntitlementUsage {
            crate::model::EntitlementUsage {
                name: self.name,
                consumed_value: self.consumed_value,
                max_count: self.max_count,
                unit: self.unit,
            }
        }
    }
}
impl EntitlementUsage {
    /// Creates a new builder-style object to manufacture [`EntitlementUsage`](crate::model::EntitlementUsage)
    pub fn builder() -> crate::model::entitlement_usage::Builder {
        crate::model::entitlement_usage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntitlementDataUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsPerSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesPerSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntitlementDataUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => EntitlementDataUnit::Bits,
            "Bits/Second" => EntitlementDataUnit::BitsPerSecond,
            "Bytes" => EntitlementDataUnit::Bytes,
            "Bytes/Second" => EntitlementDataUnit::BytesPerSecond,
            "Count" => EntitlementDataUnit::Count,
            "Count/Second" => EntitlementDataUnit::CountPerSecond,
            "Gigabits" => EntitlementDataUnit::Gigabits,
            "Gigabits/Second" => EntitlementDataUnit::GigabitsPerSecond,
            "Gigabytes" => EntitlementDataUnit::Gigabytes,
            "Gigabytes/Second" => EntitlementDataUnit::GigabytesPerSecond,
            "Kilobits" => EntitlementDataUnit::Kilobits,
            "Kilobits/Second" => EntitlementDataUnit::KilobitsPerSecond,
            "Kilobytes" => EntitlementDataUnit::Kilobytes,
            "Kilobytes/Second" => EntitlementDataUnit::KilobytesPerSecond,
            "Megabits" => EntitlementDataUnit::Megabits,
            "Megabits/Second" => EntitlementDataUnit::MegabitsPerSecond,
            "Megabytes" => EntitlementDataUnit::Megabytes,
            "Megabytes/Second" => EntitlementDataUnit::MegabytesPerSecond,
            "Microseconds" => EntitlementDataUnit::Microseconds,
            "Milliseconds" => EntitlementDataUnit::Milliseconds,
            "None" => EntitlementDataUnit::None,
            "Percent" => EntitlementDataUnit::Percent,
            "Seconds" => EntitlementDataUnit::Seconds,
            "Terabits" => EntitlementDataUnit::Terabits,
            "Terabits/Second" => EntitlementDataUnit::TerabitsPerSecond,
            "Terabytes" => EntitlementDataUnit::Terabytes,
            "Terabytes/Second" => EntitlementDataUnit::TerabytesPerSecond,
            other => EntitlementDataUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntitlementDataUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntitlementDataUnit::from(s))
    }
}
impl EntitlementDataUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntitlementDataUnit::Bits => "Bits",
            EntitlementDataUnit::BitsPerSecond => "Bits/Second",
            EntitlementDataUnit::Bytes => "Bytes",
            EntitlementDataUnit::BytesPerSecond => "Bytes/Second",
            EntitlementDataUnit::Count => "Count",
            EntitlementDataUnit::CountPerSecond => "Count/Second",
            EntitlementDataUnit::Gigabits => "Gigabits",
            EntitlementDataUnit::GigabitsPerSecond => "Gigabits/Second",
            EntitlementDataUnit::Gigabytes => "Gigabytes",
            EntitlementDataUnit::GigabytesPerSecond => "Gigabytes/Second",
            EntitlementDataUnit::Kilobits => "Kilobits",
            EntitlementDataUnit::KilobitsPerSecond => "Kilobits/Second",
            EntitlementDataUnit::Kilobytes => "Kilobytes",
            EntitlementDataUnit::KilobytesPerSecond => "Kilobytes/Second",
            EntitlementDataUnit::Megabits => "Megabits",
            EntitlementDataUnit::MegabitsPerSecond => "Megabits/Second",
            EntitlementDataUnit::Megabytes => "Megabytes",
            EntitlementDataUnit::MegabytesPerSecond => "Megabytes/Second",
            EntitlementDataUnit::Microseconds => "Microseconds",
            EntitlementDataUnit::Milliseconds => "Milliseconds",
            EntitlementDataUnit::None => "None",
            EntitlementDataUnit::Percent => "Percent",
            EntitlementDataUnit::Seconds => "Seconds",
            EntitlementDataUnit::Terabits => "Terabits",
            EntitlementDataUnit::TerabitsPerSecond => "Terabits/Second",
            EntitlementDataUnit::Terabytes => "Terabytes",
            EntitlementDataUnit::TerabytesPerSecond => "Terabytes/Second",
            EntitlementDataUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for EntitlementDataUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LicenseDeletionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    PendingDelete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LicenseDeletionStatus {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => LicenseDeletionStatus::Deleted,
            "PENDING_DELETE" => LicenseDeletionStatus::PendingDelete,
            other => LicenseDeletionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LicenseDeletionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LicenseDeletionStatus::from(s))
    }
}
impl LicenseDeletionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LicenseDeletionStatus::Deleted => "DELETED",
            LicenseDeletionStatus::PendingDelete => "PENDING_DELETE",
            LicenseDeletionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "PENDING_DELETE"]
    }
}
impl AsRef<str> for LicenseDeletionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TokenType {
    #[allow(missing_docs)] // documentation missing in model
    RefreshToken,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TokenType {
    fn from(s: &str) -> Self {
        match s {
            "REFRESH_TOKEN" => TokenType::RefreshToken,
            other => TokenType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TokenType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TokenType::from(s))
    }
}
impl TokenType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TokenType::RefreshToken => "REFRESH_TOKEN",
            TokenType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REFRESH_TOKEN"]
    }
}
impl AsRef<str> for TokenType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details about the issuer of a license.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Issuer {
    /// <p>Issuer name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
    /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
    pub sign_key: std::option::Option<std::string::String>,
}
impl Issuer {
    /// <p>Issuer name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
    /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
    pub fn sign_key(&self) -> std::option::Option<&str> {
        self.sign_key.as_deref()
    }
}
impl std::fmt::Debug for Issuer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Issuer");
        formatter.field("name", &self.name);
        formatter.field("sign_key", &self.sign_key);
        formatter.finish()
    }
}
/// See [`Issuer`](crate::model::Issuer)
pub mod issuer {
    /// A builder for [`Issuer`](crate::model::Issuer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) sign_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Issuer name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Issuer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
        /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
        pub fn sign_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.sign_key = Some(input.into());
            self
        }
        /// <p>Asymmetric KMS key from Key Management Service. The KMS key must have a key usage of sign and verify,
        /// and support the RSASSA-PSS SHA-256 signing algorithm.</p>
        pub fn set_sign_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sign_key = input;
            self
        }
        /// Consumes the builder and constructs a [`Issuer`](crate::model::Issuer)
        pub fn build(self) -> crate::model::Issuer {
            crate::model::Issuer {
                name: self.name,
                sign_key: self.sign_key,
            }
        }
    }
}
impl Issuer {
    /// Creates a new builder-style object to manufacture [`Issuer`](crate::model::Issuer)
    pub fn builder() -> crate::model::issuer::Builder {
        crate::model::issuer::Builder::default()
    }
}

/// <p>Data associated with an entitlement resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitlementData {
    /// <p>Entitlement data name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Entitlement data value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Entitlement data unit.</p>
    pub unit: std::option::Option<crate::model::EntitlementDataUnit>,
}
impl EntitlementData {
    /// <p>Entitlement data name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Entitlement data value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Entitlement data unit.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::EntitlementDataUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for EntitlementData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitlementData");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`EntitlementData`](crate::model::EntitlementData)
pub mod entitlement_data {
    /// A builder for [`EntitlementData`](crate::model::EntitlementData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<crate::model::EntitlementDataUnit>,
    }
    impl Builder {
        /// <p>Entitlement data name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Entitlement data name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Entitlement data value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Entitlement data value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Entitlement data unit.</p>
        pub fn unit(mut self, input: crate::model::EntitlementDataUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>Entitlement data unit.</p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::EntitlementDataUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitlementData`](crate::model::EntitlementData)
        pub fn build(self) -> crate::model::EntitlementData {
            crate::model::EntitlementData {
                name: self.name,
                value: self.value,
                unit: self.unit,
            }
        }
    }
}
impl EntitlementData {
    /// Creates a new builder-style object to manufacture [`EntitlementData`](crate::model::EntitlementData)
    pub fn builder() -> crate::model::entitlement_data::Builder {
        crate::model::entitlement_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CheckoutType {
    #[allow(missing_docs)] // documentation missing in model
    Perpetual,
    #[allow(missing_docs)] // documentation missing in model
    Provisional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CheckoutType {
    fn from(s: &str) -> Self {
        match s {
            "PERPETUAL" => CheckoutType::Perpetual,
            "PROVISIONAL" => CheckoutType::Provisional,
            other => CheckoutType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CheckoutType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CheckoutType::from(s))
    }
}
impl CheckoutType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CheckoutType::Perpetual => "PERPETUAL",
            CheckoutType::Provisional => "PROVISIONAL",
            CheckoutType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PERPETUAL", "PROVISIONAL"]
    }
}
impl AsRef<str> for CheckoutType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DigitalSignatureMethod {
    #[allow(missing_docs)] // documentation missing in model
    JwtPs384,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DigitalSignatureMethod {
    fn from(s: &str) -> Self {
        match s {
            "JWT_PS384" => DigitalSignatureMethod::JwtPs384,
            other => DigitalSignatureMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DigitalSignatureMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DigitalSignatureMethod::from(s))
    }
}
impl DigitalSignatureMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DigitalSignatureMethod::JwtPs384 => "JWT_PS384",
            DigitalSignatureMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JWT_PS384"]
    }
}
impl AsRef<str> for DigitalSignatureMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
