// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The entitlement is not allowed.</p>
    EntitlementNotAllowedException(crate::error::EntitlementNotAllowedException),
    /// <p>A dependency required to run the API is missing.</p>
    FailedDependencyException(crate::error::FailedDependencyException),
    /// <p>The request uses too many filters or too many filter values.</p>
    FilterLimitExceededException(crate::error::FilterLimitExceededException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>License Manager cannot allocate a license to a resource because of its state. </p>
    /// <p>For example, you cannot allocate a license to an instance in the process of shutting
    /// down.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>You do not have enough licenses available to support a new resource launch.</p>
    LicenseUsageException(crate::error::LicenseUsageException),
    /// <p>There are no entitlements found for this license, or the entitlement maximum count is reached.</p>
    NoEntitlementsAllowedException(crate::error::NoEntitlementsAllowedException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The digital signature method is unsupported. Try your request again.</p>
    UnsupportedDigitalSignatureMethodException(
        crate::error::UnsupportedDigitalSignatureMethodException,
    ),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AuthorizationException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::EntitlementNotAllowedException(inner) => inner.fmt(f),
            Error::FailedDependencyException(inner) => inner.fmt(f),
            Error::FilterLimitExceededException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidResourceStateException(inner) => inner.fmt(f),
            Error::LicenseUsageException(inner) => inner.fmt(f),
            Error::NoEntitlementsAllowedException(inner) => inner.fmt(f),
            Error::RateLimitExceededException(inner) => inner.fmt(f),
            Error::RedirectException(inner) => inner.fmt(f),
            Error::ResourceLimitExceededException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServerInternalException(inner) => inner.fmt(f),
            Error::UnsupportedDigitalSignatureMethodException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AcceptGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AcceptGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AcceptGrantErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AcceptGrantErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::AcceptGrantErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::AcceptGrantErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::AcceptGrantErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::AcceptGrantErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::AcceptGrantErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::AcceptGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CheckInLicenseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CheckInLicenseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CheckInLicenseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CheckInLicenseErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CheckInLicenseErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CheckInLicenseErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CheckInLicenseErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CheckInLicenseErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CheckInLicenseErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CheckInLicenseErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CheckInLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CheckoutBorrowLicenseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CheckoutBorrowLicenseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CheckoutBorrowLicenseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::EntitlementNotAllowedException(inner) => Error::EntitlementNotAllowedException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::NoEntitlementsAllowedException(inner) => Error::NoEntitlementsAllowedException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::RedirectException(inner) => Error::RedirectException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::UnsupportedDigitalSignatureMethodException(inner) => Error::UnsupportedDigitalSignatureMethodException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CheckoutBorrowLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CheckoutLicenseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CheckoutLicenseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CheckoutLicenseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CheckoutLicenseErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::CheckoutLicenseErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CheckoutLicenseErrorKind::NoEntitlementsAllowedException(inner) => Error::NoEntitlementsAllowedException(inner),
                crate::error::CheckoutLicenseErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::CheckoutLicenseErrorKind::RedirectException(inner) => Error::RedirectException(inner),
                crate::error::CheckoutLicenseErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CheckoutLicenseErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CheckoutLicenseErrorKind::UnsupportedDigitalSignatureMethodException(inner) => Error::UnsupportedDigitalSignatureMethodException(inner),
                crate::error::CheckoutLicenseErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CheckoutLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGrantErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateGrantErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CreateGrantErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateGrantErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CreateGrantErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateGrantErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CreateGrantErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGrantVersionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateGrantVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGrantVersionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateGrantVersionErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CreateGrantVersionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::CreateGrantVersionErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CreateGrantVersionErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateGrantVersionErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CreateGrantVersionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateGrantVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLicenseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateLicenseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLicenseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateLicenseErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CreateLicenseErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::CreateLicenseErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CreateLicenseErrorKind::RedirectException(inner) => {
                    Error::RedirectException(inner)
                }
                crate::error::CreateLicenseErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CreateLicenseErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLicenseConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLicenseConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateLicenseConfigurationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CreateLicenseConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateLicenseConversionTaskForResourceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateLicenseConversionTaskForResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CreateLicenseConversionTaskForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateLicenseManagerReportGeneratorError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateLicenseManagerReportGeneratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::CreateLicenseManagerReportGeneratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLicenseVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLicenseVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLicenseVersionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::RedirectException(inner) => {
                    Error::RedirectException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateLicenseVersionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateTokenError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateTokenError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateTokenErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateTokenErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::CreateTokenErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::CreateTokenErrorKind::RedirectException(inner) => {
                    Error::RedirectException(inner)
                }
                crate::error::CreateTokenErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::CreateTokenErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::CreateTokenErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::CreateTokenErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::CreateTokenErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGrantErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteGrantErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::DeleteGrantErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteGrantErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::DeleteGrantErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::DeleteGrantErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::DeleteGrantErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLicenseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteLicenseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLicenseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteLicenseErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::DeleteLicenseErrorKind::ConflictException(inner) => {
                    Error::ConflictException(inner)
                }
                crate::error::DeleteLicenseErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::DeleteLicenseErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::DeleteLicenseErrorKind::RedirectException(inner) => {
                    Error::RedirectException(inner)
                }
                crate::error::DeleteLicenseErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::DeleteLicenseErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLicenseConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLicenseConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteLicenseConfigurationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteLicenseConfigurationErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::DeleteLicenseConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteLicenseConfigurationErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::DeleteLicenseConfigurationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::DeleteLicenseConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DeleteLicenseManagerReportGeneratorError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteLicenseManagerReportGeneratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::DeleteLicenseManagerReportGeneratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteTokenError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteTokenError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteTokenErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteTokenErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::DeleteTokenErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::DeleteTokenErrorKind::RedirectException(inner) => {
                    Error::RedirectException(inner)
                }
                crate::error::DeleteTokenErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::DeleteTokenErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::DeleteTokenErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::DeleteTokenErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExtendLicenseConsumptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ExtendLicenseConsumptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExtendLicenseConsumptionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ExtendLicenseConsumptionErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ExtendLicenseConsumptionErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ExtendLicenseConsumptionErrorKind::RateLimitExceededException(
                    inner,
                ) => Error::RateLimitExceededException(inner),
                crate::error::ExtendLicenseConsumptionErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ExtendLicenseConsumptionErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ExtendLicenseConsumptionErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ExtendLicenseConsumptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAccessTokenError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetAccessTokenError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAccessTokenErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetAccessTokenErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetAccessTokenErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::GetAccessTokenErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetAccessTokenErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetAccessTokenErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetGrantErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetGrantErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetGrantErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::GetGrantErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::GetGrantErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::GetGrantErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetGrantErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLicenseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetLicenseError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLicenseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLicenseErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetLicenseErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::GetLicenseErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::GetLicenseErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetLicenseErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetLicenseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLicenseConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLicenseConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLicenseConfigurationErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLicenseConfigurationErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetLicenseConfigurationErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::GetLicenseConfigurationErrorKind::RateLimitExceededException(
                    inner,
                ) => Error::RateLimitExceededException(inner),
                crate::error::GetLicenseConfigurationErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetLicenseConfigurationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLicenseConversionTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLicenseConversionTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLicenseConversionTaskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLicenseConversionTaskErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetLicenseConversionTaskErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::GetLicenseConversionTaskErrorKind::RateLimitExceededException(
                    inner,
                ) => Error::RateLimitExceededException(inner),
                crate::error::GetLicenseConversionTaskErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetLicenseConversionTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetLicenseManagerReportGeneratorError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetLicenseManagerReportGeneratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetLicenseManagerReportGeneratorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::GetLicenseManagerReportGeneratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLicenseUsageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetLicenseUsageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLicenseUsageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::GetLicenseUsageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetServiceSettingsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetServiceSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetServiceSettingsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetServiceSettingsErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::GetServiceSettingsErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::GetServiceSettingsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::GetServiceSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListAssociationsForLicenseConfigurationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAssociationsForLicenseConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::FilterLimitExceededException(inner) => Error::FilterLimitExceededException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListAssociationsForLicenseConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListDistributedGrantsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListDistributedGrantsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListDistributedGrantsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListDistributedGrantsErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListDistributedGrantsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListDistributedGrantsErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListDistributedGrantsErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::ListDistributedGrantsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListDistributedGrantsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListDistributedGrantsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListFailuresForLicenseConfigurationOperationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListFailuresForLicenseConfigurationOperationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListFailuresForLicenseConfigurationOperationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLicenseConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListLicenseConfigurationsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListLicenseConfigurationsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::FilterLimitExceededException(inner) => Error::FilterLimitExceededException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListLicenseConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLicenseConversionTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListLicenseConversionTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListLicenseConversionTasksErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListLicenseConversionTasksErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListLicenseConversionTasksErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListLicenseConversionTasksErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListLicenseConversionTasksErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListLicenseConversionTasksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::ListLicenseManagerReportGeneratorsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListLicenseManagerReportGeneratorsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::ListLicenseManagerReportGeneratorsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLicensesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListLicensesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListLicensesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListLicensesErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListLicensesErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::ListLicensesErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListLicensesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListLicensesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListLicensesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListLicenseSpecificationsForResourceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListLicenseSpecificationsForResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListLicenseSpecificationsForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListLicenseSpecificationsForResourceErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListLicenseSpecificationsForResourceErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListLicenseSpecificationsForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListLicenseVersionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListLicenseVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListLicenseVersionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListLicenseVersionsErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListLicenseVersionsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListLicenseVersionsErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListLicenseVersionsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListLicenseVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListReceivedGrantsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListReceivedGrantsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListReceivedGrantsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListReceivedGrantsErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListReceivedGrantsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListReceivedGrantsErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListReceivedGrantsErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::ListReceivedGrantsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListReceivedGrantsErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListReceivedGrantsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListReceivedLicensesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListReceivedLicensesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListReceivedLicensesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListReceivedLicensesErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListReceivedLicensesErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListReceivedLicensesErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListReceivedLicensesErrorKind::ResourceLimitExceededException(
                    inner,
                ) => Error::ResourceLimitExceededException(inner),
                crate::error::ListReceivedLicensesErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListReceivedLicensesErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListReceivedLicensesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListResourceInventoryError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListResourceInventoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListResourceInventoryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListResourceInventoryErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListResourceInventoryErrorKind::FailedDependencyException(inner) => {
                    Error::FailedDependencyException(inner)
                }
                crate::error::ListResourceInventoryErrorKind::FilterLimitExceededException(
                    inner,
                ) => Error::FilterLimitExceededException(inner),
                crate::error::ListResourceInventoryErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListResourceInventoryErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListResourceInventoryErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListResourceInventoryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::ListTagsForResourceErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTokensError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListTokensError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTokensErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ListTokensErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::ListTokensErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::ListTokensErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::ListTokensErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::ListTokensErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListUsageForLicenseConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListUsageForLicenseConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListUsageForLicenseConfigurationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::FilterLimitExceededException(inner) => Error::FilterLimitExceededException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::ListUsageForLicenseConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RejectGrantError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RejectGrantError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RejectGrantErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RejectGrantErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::RejectGrantErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::RejectGrantErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::RejectGrantErrorKind::ResourceLimitExceededException(inner) => {
                    Error::ResourceLimitExceededException(inner)
                }
                crate::error::RejectGrantErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::RejectGrantErrorKind::ValidationException(inner) => {
                    Error::ValidationException(inner)
                }
                crate::error::RejectGrantErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::TagResourceErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::TagResourceErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::TagResourceErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UntagResourceErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::UntagResourceErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::UntagResourceErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateLicenseConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateLicenseConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateLicenseConfigurationErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::UpdateLicenseConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateLicenseManagerReportGeneratorError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateLicenseManagerReportGeneratorError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(inner) => Error::ResourceLimitExceededException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::ValidationException(inner) => Error::ValidationException(inner),
                crate::error::UpdateLicenseManagerReportGeneratorErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateLicenseSpecificationsForResourceError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateLicenseSpecificationsForResourceError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::AuthorizationException(inner) => Error::AuthorizationException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(inner) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::InvalidResourceStateException(inner) => Error::InvalidResourceStateException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::LicenseUsageException(inner) => Error::LicenseUsageException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(inner) => Error::RateLimitExceededException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::ServerInternalException(inner) => Error::ServerInternalException(inner),
                crate::error::UpdateLicenseSpecificationsForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateServiceSettingsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateServiceSettingsErrorKind::AuthorizationException(inner) => {
                    Error::AuthorizationException(inner)
                }
                crate::error::UpdateServiceSettingsErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::UpdateServiceSettingsErrorKind::RateLimitExceededException(inner) => {
                    Error::RateLimitExceededException(inner)
                }
                crate::error::UpdateServiceSettingsErrorKind::ServerInternalException(inner) => {
                    Error::ServerInternalException(inner)
                }
                crate::error::UpdateServiceSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
