// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSessionOutput, crate::error::DeleteSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteSessionError {
                meta: generic,
                kind: crate::error::DeleteSessionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_session_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSessionOutput, crate::error::DeleteSessionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_session_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_session(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSessionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionOutput, crate::error::GetSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionOutput, crate::error::GetSessionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_session_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_session(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSessionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_session(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::PutSessionOutput, crate::error::PutSessionError> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_session_output::Builder::default();
        let _ = response;
        output = output.set_audio_stream(Some(
            crate::http_serde::deser_payload_put_session_put_session_output_audio_stream(
                response.body_mut(),
            )?,
        ));
        output = output.set_content_type(
            crate::http_serde::deser_header_put_session_put_session_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse contentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_messages(
            crate::http_serde::deser_header_put_session_put_session_output_messages(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse messages from header `x-amz-lex-messages",
                )
            })?,
        );
        output = output.set_request_attributes(
            crate::http_serde::deser_header_put_session_put_session_output_request_attributes(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse requestAttributes from header `x-amz-lex-request-attributes",
                )
            })?,
        );
        output = output.set_session_id(
            crate::http_serde::deser_header_put_session_put_session_output_session_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse sessionId from header `x-amz-lex-session-id",
                )
            })?,
        );
        output = output.set_session_state(
            crate::http_serde::deser_header_put_session_put_session_output_session_state(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse sessionState from header `x-amz-lex-session-state",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSessionOutput, crate::error::PutSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadGatewayException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyFailedException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::PutSessionError {
                meta: generic,
                kind: crate::error::PutSessionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_recognize_text_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RecognizeTextOutput, crate::error::RecognizeTextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RecognizeTextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RecognizeTextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadGatewayException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyFailedException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::RecognizeTextError {
            meta: generic,
            kind: crate::error::RecognizeTextErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::RecognizeTextError {
                meta: generic,
                kind: crate::error::RecognizeTextErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeTextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RecognizeTextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_recognize_text_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RecognizeTextOutput, crate::error::RecognizeTextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::recognize_text_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_recognize_text(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RecognizeTextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_recognize_utterance(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<
    crate::output::RecognizeUtteranceOutput,
    crate::error::RecognizeUtteranceError,
> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::recognize_utterance_output::Builder::default();
        let _ = response;
        output = output.set_audio_stream(
            Some(crate::http_serde::deser_payload_recognize_utterance_recognize_utterance_output_audio_stream(response.body_mut())?)
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_content_type(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse contentType from header `Content-Type"))?
        );
        output = output.set_input_mode(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_input_mode(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse inputMode from header `x-amz-lex-input-mode"))?
        );
        output = output.set_input_transcript(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_input_transcript(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse inputTranscript from header `x-amz-lex-input-transcript"))?
        );
        output = output.set_interpretations(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_interpretations(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse interpretations from header `x-amz-lex-interpretations"))?
        );
        output = output.set_messages(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_messages(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse messages from header `x-amz-lex-messages"))?
        );
        output = output.set_request_attributes(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_request_attributes(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse requestAttributes from header `x-amz-lex-request-attributes"))?
        );
        output = output.set_session_id(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_session_id(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse sessionId from header `x-amz-lex-session-id"))?
        );
        output = output.set_session_state(
            crate::http_serde::deser_header_recognize_utterance_recognize_utterance_output_session_state(response.headers())
                                    .map_err(|_|crate::error::RecognizeUtteranceError::unhandled("Failed to parse sessionState from header `x-amz-lex-session-state"))?
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_recognize_utterance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RecognizeUtteranceOutput,
    crate::error::RecognizeUtteranceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RecognizeUtteranceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RecognizeUtteranceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadGatewayException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DependencyFailedException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::RecognizeUtteranceError {
            meta: generic,
            kind: crate::error::RecognizeUtteranceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::RecognizeUtteranceError {
                meta: generic,
                kind: crate::error::RecognizeUtteranceErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RecognizeUtteranceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::RecognizeUtteranceError::generic(generic),
    })
}
