// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An intent that Amazon Lex V2 determined might satisfy the user's utterance.
/// The intents are ordered by the confidence score. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Interpretation {
    /// <p>Determines the threshold where Amazon Lex V2 will insert the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a response. <code>AMAZON.FallbackIntent</code>
    /// and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
    /// are configured for the bot.</p>
    pub nlu_confidence: std::option::Option<crate::model::ConfidenceScore>,
    /// <p>The sentiment expressed in an utterance. </p>
    /// <p>When the bot is configured to send utterances to Amazon Comprehend
    /// for sentiment analysis, this field contains the result of the
    /// analysis.</p>
    pub sentiment_response: std::option::Option<crate::model::SentimentResponse>,
    /// <p>A list of intents that might satisfy the user's utterance. The
    /// intents are ordered by the confidence score.</p>
    pub intent: std::option::Option<crate::model::Intent>,
}
impl std::fmt::Debug for Interpretation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Interpretation");
        formatter.field("nlu_confidence", &self.nlu_confidence);
        formatter.field("sentiment_response", &self.sentiment_response);
        formatter.field("intent", &self.intent);
        formatter.finish()
    }
}
/// See [`Interpretation`](crate::model::Interpretation)
pub mod interpretation {
    /// A builder for [`Interpretation`](crate::model::Interpretation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nlu_confidence: std::option::Option<crate::model::ConfidenceScore>,
        pub(crate) sentiment_response: std::option::Option<crate::model::SentimentResponse>,
        pub(crate) intent: std::option::Option<crate::model::Intent>,
    }
    impl Builder {
        /// <p>Determines the threshold where Amazon Lex V2 will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a response. <code>AMAZON.FallbackIntent</code>
        /// and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
        /// are configured for the bot.</p>
        pub fn nlu_confidence(mut self, input: crate::model::ConfidenceScore) -> Self {
            self.nlu_confidence = Some(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex V2 will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a response. <code>AMAZON.FallbackIntent</code>
        /// and <code>AMAZON.KendraSearchIntent</code> are only inserted if they
        /// are configured for the bot.</p>
        pub fn set_nlu_confidence(
            mut self,
            input: std::option::Option<crate::model::ConfidenceScore>,
        ) -> Self {
            self.nlu_confidence = input;
            self
        }
        /// <p>The sentiment expressed in an utterance. </p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend
        /// for sentiment analysis, this field contains the result of the
        /// analysis.</p>
        pub fn sentiment_response(mut self, input: crate::model::SentimentResponse) -> Self {
            self.sentiment_response = Some(input);
            self
        }
        /// <p>The sentiment expressed in an utterance. </p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend
        /// for sentiment analysis, this field contains the result of the
        /// analysis.</p>
        pub fn set_sentiment_response(
            mut self,
            input: std::option::Option<crate::model::SentimentResponse>,
        ) -> Self {
            self.sentiment_response = input;
            self
        }
        /// <p>A list of intents that might satisfy the user's utterance. The
        /// intents are ordered by the confidence score.</p>
        pub fn intent(mut self, input: crate::model::Intent) -> Self {
            self.intent = Some(input);
            self
        }
        /// <p>A list of intents that might satisfy the user's utterance. The
        /// intents are ordered by the confidence score.</p>
        pub fn set_intent(mut self, input: std::option::Option<crate::model::Intent>) -> Self {
            self.intent = input;
            self
        }
        /// Consumes the builder and constructs a [`Interpretation`](crate::model::Interpretation)
        pub fn build(self) -> crate::model::Interpretation {
            crate::model::Interpretation {
                nlu_confidence: self.nlu_confidence,
                sentiment_response: self.sentiment_response,
                intent: self.intent,
            }
        }
    }
}
impl Interpretation {
    /// Creates a new builder-style object to manufacture [`Interpretation`](crate::model::Interpretation)
    pub fn builder() -> crate::model::interpretation::Builder {
        crate::model::interpretation::Builder::default()
    }
}

/// <p>The current intent that Amazon Lex V2 is attempting to fulfill.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Intent {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map of all of the slots for the intent. The name of the slot maps
    /// to the value of the slot. If a slot has not been filled, the value is
    /// null.</p>
    pub slots:
        std::option::Option<std::collections::HashMap<std::string::String, crate::model::Slot>>,
    /// <p>Contains fulfillment information for the intent. </p>
    pub state: std::option::Option<crate::model::IntentState>,
    /// <p>Contains information about whether fulfillment of the intent has
    /// been confirmed.</p>
    pub confirmation_state: std::option::Option<crate::model::ConfirmationState>,
}
impl std::fmt::Debug for Intent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Intent");
        formatter.field("name", &self.name);
        formatter.field("slots", &self.slots);
        formatter.field("state", &self.state);
        formatter.field("confirmation_state", &self.confirmation_state);
        formatter.finish()
    }
}
/// See [`Intent`](crate::model::Intent)
pub mod intent {
    /// A builder for [`Intent`](crate::model::Intent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) slots:
            std::option::Option<std::collections::HashMap<std::string::String, crate::model::Slot>>,
        pub(crate) state: std::option::Option<crate::model::IntentState>,
        pub(crate) confirmation_state: std::option::Option<crate::model::ConfirmationState>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>A map of all of the slots for the intent. The name of the slot maps
        /// to the value of the slot. If a slot has not been filled, the value is
        /// null.</p>
        pub fn slots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Slot>,
        ) -> Self {
            let mut hash_map = self.slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.slots = Some(hash_map);
            self
        }
        /// <p>A map of all of the slots for the intent. The name of the slot maps
        /// to the value of the slot. If a slot has not been filled, the value is
        /// null.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Slot>,
            >,
        ) -> Self {
            self.slots = input;
            self
        }
        /// <p>Contains fulfillment information for the intent. </p>
        pub fn state(mut self, input: crate::model::IntentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Contains fulfillment information for the intent. </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::IntentState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Contains information about whether fulfillment of the intent has
        /// been confirmed.</p>
        pub fn confirmation_state(mut self, input: crate::model::ConfirmationState) -> Self {
            self.confirmation_state = Some(input);
            self
        }
        /// <p>Contains information about whether fulfillment of the intent has
        /// been confirmed.</p>
        pub fn set_confirmation_state(
            mut self,
            input: std::option::Option<crate::model::ConfirmationState>,
        ) -> Self {
            self.confirmation_state = input;
            self
        }
        /// Consumes the builder and constructs a [`Intent`](crate::model::Intent)
        pub fn build(self) -> crate::model::Intent {
            crate::model::Intent {
                name: self.name,
                slots: self.slots,
                state: self.state,
                confirmation_state: self.confirmation_state,
            }
        }
    }
}
impl Intent {
    /// Creates a new builder-style object to manufacture [`Intent`](crate::model::Intent)
    pub fn builder() -> crate::model::intent::Builder {
        crate::model::intent::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfirmationState {
    #[allow(missing_docs)] // documentation missing in model
    Confirmed,
    #[allow(missing_docs)] // documentation missing in model
    Denied,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfirmationState {
    fn from(s: &str) -> Self {
        match s {
            "Confirmed" => ConfirmationState::Confirmed,
            "Denied" => ConfirmationState::Denied,
            "None" => ConfirmationState::None,
            other => ConfirmationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfirmationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfirmationState::from(s))
    }
}
impl ConfirmationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfirmationState::Confirmed => "Confirmed",
            ConfirmationState::Denied => "Denied",
            ConfirmationState::None => "None",
            ConfirmationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Confirmed", "Denied", "None"]
    }
}
impl AsRef<str> for ConfirmationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntentState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    FulfillmentInProgress,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForFulfillment,
    #[allow(missing_docs)] // documentation missing in model
    Waiting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntentState {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => IntentState::Failed,
            "Fulfilled" => IntentState::Fulfilled,
            "FulfillmentInProgress" => IntentState::FulfillmentInProgress,
            "InProgress" => IntentState::InProgress,
            "ReadyForFulfillment" => IntentState::ReadyForFulfillment,
            "Waiting" => IntentState::Waiting,
            other => IntentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntentState::from(s))
    }
}
impl IntentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntentState::Failed => "Failed",
            IntentState::Fulfilled => "Fulfilled",
            IntentState::FulfillmentInProgress => "FulfillmentInProgress",
            IntentState::InProgress => "InProgress",
            IntentState::ReadyForFulfillment => "ReadyForFulfillment",
            IntentState::Waiting => "Waiting",
            IntentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "Fulfilled",
            "FulfillmentInProgress",
            "InProgress",
            "ReadyForFulfillment",
            "Waiting",
        ]
    }
}
impl AsRef<str> for IntentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A value that Amazon Lex V2 uses to fulfill an intent. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Slot {
    /// <p>The current value of the slot.</p>
    pub value: std::option::Option<crate::model::Value>,
    /// <p>When the <code>shape</code> value is <code>List</code>, it indicates
    /// that the <code>values</code> field contains a list of slot values. When
    /// the value is <code>Scalar</code>, it indicates that the
    /// <code>value</code> field contains a single value.</p>
    pub shape: std::option::Option<crate::model::Shape>,
    /// <p>A list of one or more values that the user provided for the slot.
    /// For example, if a for a slot that elicits pizza toppings, the values
    /// might be "pepperoni" and "pineapple." </p>
    pub values: std::option::Option<std::vec::Vec<crate::model::Slot>>,
}
impl std::fmt::Debug for Slot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Slot");
        formatter.field("value", &self.value);
        formatter.field("shape", &self.shape);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Slot`](crate::model::Slot)
pub mod slot {
    /// A builder for [`Slot`](crate::model::Slot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<crate::model::Value>,
        pub(crate) shape: std::option::Option<crate::model::Shape>,
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::Slot>>,
    }
    impl Builder {
        /// <p>The current value of the slot.</p>
        pub fn value(mut self, input: crate::model::Value) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The current value of the slot.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::Value>) -> Self {
            self.value = input;
            self
        }
        /// <p>When the <code>shape</code> value is <code>List</code>, it indicates
        /// that the <code>values</code> field contains a list of slot values. When
        /// the value is <code>Scalar</code>, it indicates that the
        /// <code>value</code> field contains a single value.</p>
        pub fn shape(mut self, input: crate::model::Shape) -> Self {
            self.shape = Some(input);
            self
        }
        /// <p>When the <code>shape</code> value is <code>List</code>, it indicates
        /// that the <code>values</code> field contains a list of slot values. When
        /// the value is <code>Scalar</code>, it indicates that the
        /// <code>value</code> field contains a single value.</p>
        pub fn set_shape(mut self, input: std::option::Option<crate::model::Shape>) -> Self {
            self.shape = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of one or more values that the user provided for the slot.
        /// For example, if a for a slot that elicits pizza toppings, the values
        /// might be "pepperoni" and "pineapple." </p>
        pub fn values(mut self, input: impl Into<crate::model::Slot>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of one or more values that the user provided for the slot.
        /// For example, if a for a slot that elicits pizza toppings, the values
        /// might be "pepperoni" and "pineapple." </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Slot`](crate::model::Slot)
        pub fn build(self) -> crate::model::Slot {
            crate::model::Slot {
                value: self.value,
                shape: self.shape,
                values: self.values,
            }
        }
    }
}
impl Slot {
    /// Creates a new builder-style object to manufacture [`Slot`](crate::model::Slot)
    pub fn builder() -> crate::model::slot::Builder {
        crate::model::slot::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Shape {
    #[allow(missing_docs)] // documentation missing in model
    List,
    #[allow(missing_docs)] // documentation missing in model
    Scalar,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Shape {
    fn from(s: &str) -> Self {
        match s {
            "List" => Shape::List,
            "Scalar" => Shape::Scalar,
            other => Shape::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Shape {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Shape::from(s))
    }
}
impl Shape {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Shape::List => "List",
            Shape::Scalar => "Scalar",
            Shape::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["List", "Scalar"]
    }
}
impl AsRef<str> for Shape {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The value of a slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Value {
    /// <p>The text of the utterance from the user that was entered for the
    /// slot.</p>
    pub original_value: std::option::Option<std::string::String>,
    /// <p>The value that Amazon Lex V2 determines for the slot. The actual value
    /// depends on the setting of the value selection strategy for the bot. You
    /// can choose to use the value entered by the user, or you can have Amazon Lex V2
    /// choose the first value in the <code>resolvedValues</code> list.</p>
    pub interpreted_value: std::option::Option<std::string::String>,
    /// <p>A list of additional values that have been recognized for the
    /// slot.</p>
    pub resolved_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Value {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Value");
        formatter.field("original_value", &self.original_value);
        formatter.field("interpreted_value", &self.interpreted_value);
        formatter.field("resolved_values", &self.resolved_values);
        formatter.finish()
    }
}
/// See [`Value`](crate::model::Value)
pub mod value {
    /// A builder for [`Value`](crate::model::Value)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) original_value: std::option::Option<std::string::String>,
        pub(crate) interpreted_value: std::option::Option<std::string::String>,
        pub(crate) resolved_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The text of the utterance from the user that was entered for the
        /// slot.</p>
        pub fn original_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.original_value = Some(input.into());
            self
        }
        /// <p>The text of the utterance from the user that was entered for the
        /// slot.</p>
        pub fn set_original_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.original_value = input;
            self
        }
        /// <p>The value that Amazon Lex V2 determines for the slot. The actual value
        /// depends on the setting of the value selection strategy for the bot. You
        /// can choose to use the value entered by the user, or you can have Amazon Lex V2
        /// choose the first value in the <code>resolvedValues</code> list.</p>
        pub fn interpreted_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.interpreted_value = Some(input.into());
            self
        }
        /// <p>The value that Amazon Lex V2 determines for the slot. The actual value
        /// depends on the setting of the value selection strategy for the bot. You
        /// can choose to use the value entered by the user, or you can have Amazon Lex V2
        /// choose the first value in the <code>resolvedValues</code> list.</p>
        pub fn set_interpreted_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.interpreted_value = input;
            self
        }
        /// Appends an item to `resolved_values`.
        ///
        /// To override the contents of this collection use [`set_resolved_values`](Self::set_resolved_values).
        ///
        /// <p>A list of additional values that have been recognized for the
        /// slot.</p>
        pub fn resolved_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resolved_values.unwrap_or_default();
            v.push(input.into());
            self.resolved_values = Some(v);
            self
        }
        /// <p>A list of additional values that have been recognized for the
        /// slot.</p>
        pub fn set_resolved_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resolved_values = input;
            self
        }
        /// Consumes the builder and constructs a [`Value`](crate::model::Value)
        pub fn build(self) -> crate::model::Value {
            crate::model::Value {
                original_value: self.original_value,
                interpreted_value: self.interpreted_value,
                resolved_values: self.resolved_values,
            }
        }
    }
}
impl Value {
    /// Creates a new builder-style object to manufacture [`Value`](crate::model::Value)
    pub fn builder() -> crate::model::value::Builder {
        crate::model::value::Builder::default()
    }
}

/// <p>Provides information about the sentiment expressed in a user's
/// response in a conversation. Sentiments are determined using Amazon
/// Comprehend. Sentiments are only returned if they are enabled for the
/// bot.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-sentiment.html">
/// Determine Sentiment </a> in the <i>Amazon Comprehend
/// developer guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentResponse {
    /// <p>The overall sentiment expressed in the user's response. This is the
    /// sentiment most likely expressed by the user based on the analysis by
    /// Amazon Comprehend.</p>
    pub sentiment: std::option::Option<crate::model::SentimentType>,
    /// <p>The individual sentiment responses for the utterance.</p>
    pub sentiment_score: std::option::Option<crate::model::SentimentScore>,
}
impl std::fmt::Debug for SentimentResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentResponse");
        formatter.field("sentiment", &self.sentiment);
        formatter.field("sentiment_score", &self.sentiment_score);
        formatter.finish()
    }
}
/// See [`SentimentResponse`](crate::model::SentimentResponse)
pub mod sentiment_response {
    /// A builder for [`SentimentResponse`](crate::model::SentimentResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sentiment: std::option::Option<crate::model::SentimentType>,
        pub(crate) sentiment_score: std::option::Option<crate::model::SentimentScore>,
    }
    impl Builder {
        /// <p>The overall sentiment expressed in the user's response. This is the
        /// sentiment most likely expressed by the user based on the analysis by
        /// Amazon Comprehend.</p>
        pub fn sentiment(mut self, input: crate::model::SentimentType) -> Self {
            self.sentiment = Some(input);
            self
        }
        /// <p>The overall sentiment expressed in the user's response. This is the
        /// sentiment most likely expressed by the user based on the analysis by
        /// Amazon Comprehend.</p>
        pub fn set_sentiment(
            mut self,
            input: std::option::Option<crate::model::SentimentType>,
        ) -> Self {
            self.sentiment = input;
            self
        }
        /// <p>The individual sentiment responses for the utterance.</p>
        pub fn sentiment_score(mut self, input: crate::model::SentimentScore) -> Self {
            self.sentiment_score = Some(input);
            self
        }
        /// <p>The individual sentiment responses for the utterance.</p>
        pub fn set_sentiment_score(
            mut self,
            input: std::option::Option<crate::model::SentimentScore>,
        ) -> Self {
            self.sentiment_score = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentResponse`](crate::model::SentimentResponse)
        pub fn build(self) -> crate::model::SentimentResponse {
            crate::model::SentimentResponse {
                sentiment: self.sentiment,
                sentiment_score: self.sentiment_score,
            }
        }
    }
}
impl SentimentResponse {
    /// Creates a new builder-style object to manufacture [`SentimentResponse`](crate::model::SentimentResponse)
    pub fn builder() -> crate::model::sentiment_response::Builder {
        crate::model::sentiment_response::Builder::default()
    }
}

/// <p>The individual sentiment responses for the utterance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentScore {
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy
    /// of its detection of the <code>POSITIVE</code> sentiment.</p>
    pub positive: f64,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy
    /// of its detection of the <code>NEGATIVE</code> sentiment.</p>
    pub negative: f64,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy
    /// of its detection of the <code>NEUTRAL</code> sentiment.</p>
    pub neutral: f64,
    /// <p>The level of confidence that Amazon Comprehend has in the accuracy
    /// of its detection of the <code>MIXED</code> sentiment.</p>
    pub mixed: f64,
}
impl std::fmt::Debug for SentimentScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentScore");
        formatter.field("positive", &self.positive);
        formatter.field("negative", &self.negative);
        formatter.field("neutral", &self.neutral);
        formatter.field("mixed", &self.mixed);
        formatter.finish()
    }
}
/// See [`SentimentScore`](crate::model::SentimentScore)
pub mod sentiment_score {
    /// A builder for [`SentimentScore`](crate::model::SentimentScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) positive: std::option::Option<f64>,
        pub(crate) negative: std::option::Option<f64>,
        pub(crate) neutral: std::option::Option<f64>,
        pub(crate) mixed: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>POSITIVE</code> sentiment.</p>
        pub fn positive(mut self, input: f64) -> Self {
            self.positive = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>POSITIVE</code> sentiment.</p>
        pub fn set_positive(mut self, input: std::option::Option<f64>) -> Self {
            self.positive = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>NEGATIVE</code> sentiment.</p>
        pub fn negative(mut self, input: f64) -> Self {
            self.negative = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>NEGATIVE</code> sentiment.</p>
        pub fn set_negative(mut self, input: std::option::Option<f64>) -> Self {
            self.negative = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>NEUTRAL</code> sentiment.</p>
        pub fn neutral(mut self, input: f64) -> Self {
            self.neutral = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>NEUTRAL</code> sentiment.</p>
        pub fn set_neutral(mut self, input: std::option::Option<f64>) -> Self {
            self.neutral = input;
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>MIXED</code> sentiment.</p>
        pub fn mixed(mut self, input: f64) -> Self {
            self.mixed = Some(input);
            self
        }
        /// <p>The level of confidence that Amazon Comprehend has in the accuracy
        /// of its detection of the <code>MIXED</code> sentiment.</p>
        pub fn set_mixed(mut self, input: std::option::Option<f64>) -> Self {
            self.mixed = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentScore`](crate::model::SentimentScore)
        pub fn build(self) -> crate::model::SentimentScore {
            crate::model::SentimentScore {
                positive: self.positive.unwrap_or_default(),
                negative: self.negative.unwrap_or_default(),
                neutral: self.neutral.unwrap_or_default(),
                mixed: self.mixed.unwrap_or_default(),
            }
        }
    }
}
impl SentimentScore {
    /// Creates a new builder-style object to manufacture [`SentimentScore`](crate::model::SentimentScore)
    pub fn builder() -> crate::model::sentiment_score::Builder {
        crate::model::sentiment_score::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SentimentType {
    #[allow(missing_docs)] // documentation missing in model
    Mixed,
    #[allow(missing_docs)] // documentation missing in model
    Negative,
    #[allow(missing_docs)] // documentation missing in model
    Neutral,
    #[allow(missing_docs)] // documentation missing in model
    Positive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SentimentType {
    fn from(s: &str) -> Self {
        match s {
            "MIXED" => SentimentType::Mixed,
            "NEGATIVE" => SentimentType::Negative,
            "NEUTRAL" => SentimentType::Neutral,
            "POSITIVE" => SentimentType::Positive,
            other => SentimentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SentimentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SentimentType::from(s))
    }
}
impl SentimentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SentimentType::Mixed => "MIXED",
            SentimentType::Negative => "NEGATIVE",
            SentimentType::Neutral => "NEUTRAL",
            SentimentType::Positive => "POSITIVE",
            SentimentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MIXED", "NEGATIVE", "NEUTRAL", "POSITIVE"]
    }
}
impl AsRef<str> for SentimentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a score that indicates the confidence that Amazon Lex V2 has that
/// an intent is the one that satisfies the user's intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConfidenceScore {
    /// <p>A score that indicates how confident Amazon Lex V2 is that an intent
    /// satisfies the user's intent. Ranges between 0.00 and 1.00. Higher
    /// scores indicate higher confidence.</p>
    pub score: f64,
}
impl std::fmt::Debug for ConfidenceScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConfidenceScore");
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`ConfidenceScore`](crate::model::ConfidenceScore)
pub mod confidence_score {
    /// A builder for [`ConfidenceScore`](crate::model::ConfidenceScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A score that indicates how confident Amazon Lex V2 is that an intent
        /// satisfies the user's intent. Ranges between 0.00 and 1.00. Higher
        /// scores indicate higher confidence.</p>
        pub fn score(mut self, input: f64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>A score that indicates how confident Amazon Lex V2 is that an intent
        /// satisfies the user's intent. Ranges between 0.00 and 1.00. Higher
        /// scores indicate higher confidence.</p>
        pub fn set_score(mut self, input: std::option::Option<f64>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`ConfidenceScore`](crate::model::ConfidenceScore)
        pub fn build(self) -> crate::model::ConfidenceScore {
            crate::model::ConfidenceScore {
                score: self.score.unwrap_or_default(),
            }
        }
    }
}
impl ConfidenceScore {
    /// Creates a new builder-style object to manufacture [`ConfidenceScore`](crate::model::ConfidenceScore)
    pub fn builder() -> crate::model::confidence_score::Builder {
        crate::model::confidence_score::Builder::default()
    }
}

/// <p>The state of the user's session with Amazon Lex V2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionState {
    /// <p>The next step that Amazon Lex V2 should take in the conversation with a
    /// user.</p>
    pub dialog_action: std::option::Option<crate::model::DialogAction>,
    /// <p>The active intent that Amazon Lex V2 is processing.</p>
    pub intent: std::option::Option<crate::model::Intent>,
    /// <p>One or more contexts that indicate to Amazon Lex V2 the context of a
    /// request. When a context is active, Amazon Lex V2 considers intents with the
    /// matching context as a trigger as the next intent in a session.</p>
    pub active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
    /// <p>Map of key/value pairs representing session-specific context
    /// information. It contains application information passed between Amazon Lex V2
    /// and a client application.</p>
    pub session_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p></p>
    pub originating_request_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SessionState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionState");
        formatter.field("dialog_action", &self.dialog_action);
        formatter.field("intent", &self.intent);
        formatter.field("active_contexts", &self.active_contexts);
        formatter.field("session_attributes", &self.session_attributes);
        formatter.field("originating_request_id", &self.originating_request_id);
        formatter.finish()
    }
}
/// See [`SessionState`](crate::model::SessionState)
pub mod session_state {
    /// A builder for [`SessionState`](crate::model::SessionState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dialog_action: std::option::Option<crate::model::DialogAction>,
        pub(crate) intent: std::option::Option<crate::model::Intent>,
        pub(crate) active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        pub(crate) session_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) originating_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The next step that Amazon Lex V2 should take in the conversation with a
        /// user.</p>
        pub fn dialog_action(mut self, input: crate::model::DialogAction) -> Self {
            self.dialog_action = Some(input);
            self
        }
        /// <p>The next step that Amazon Lex V2 should take in the conversation with a
        /// user.</p>
        pub fn set_dialog_action(
            mut self,
            input: std::option::Option<crate::model::DialogAction>,
        ) -> Self {
            self.dialog_action = input;
            self
        }
        /// <p>The active intent that Amazon Lex V2 is processing.</p>
        pub fn intent(mut self, input: crate::model::Intent) -> Self {
            self.intent = Some(input);
            self
        }
        /// <p>The active intent that Amazon Lex V2 is processing.</p>
        pub fn set_intent(mut self, input: std::option::Option<crate::model::Intent>) -> Self {
            self.intent = input;
            self
        }
        /// Appends an item to `active_contexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>One or more contexts that indicate to Amazon Lex V2 the context of a
        /// request. When a context is active, Amazon Lex V2 considers intents with the
        /// matching context as a trigger as the next intent in a session.</p>
        pub fn active_contexts(mut self, input: impl Into<crate::model::ActiveContext>) -> Self {
            let mut v = self.active_contexts.unwrap_or_default();
            v.push(input.into());
            self.active_contexts = Some(v);
            self
        }
        /// <p>One or more contexts that indicate to Amazon Lex V2 the context of a
        /// request. When a context is active, Amazon Lex V2 considers intents with the
        /// matching context as a trigger as the next intent in a session.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Adds a key-value pair to `session_attributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Map of key/value pairs representing session-specific context
        /// information. It contains application information passed between Amazon Lex V2
        /// and a client application.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.session_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.session_attributes = Some(hash_map);
            self
        }
        /// <p>Map of key/value pairs representing session-specific context
        /// information. It contains application information passed between Amazon Lex V2
        /// and a client application.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p></p>
        pub fn originating_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.originating_request_id = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_originating_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.originating_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionState`](crate::model::SessionState)
        pub fn build(self) -> crate::model::SessionState {
            crate::model::SessionState {
                dialog_action: self.dialog_action,
                intent: self.intent,
                active_contexts: self.active_contexts,
                session_attributes: self.session_attributes,
                originating_request_id: self.originating_request_id,
            }
        }
    }
}
impl SessionState {
    /// Creates a new builder-style object to manufacture [`SessionState`](crate::model::SessionState)
    pub fn builder() -> crate::model::session_state::Builder {
        crate::model::session_state::Builder::default()
    }
}

/// <p>Contains information about the contexts that a user is using in a
/// session. You can configure Amazon Lex V2 to set a context when an intent is
/// fulfilled, or you can set a context using the , , or  operations.</p>
/// <p>Use a context to indicate to Amazon Lex V2 intents that should be used as
/// follow-up intents. For example, if the active context is
/// <code>order-fulfilled</code>, only intents that have
/// <code>order-fulfilled</code> configured as a trigger are considered
/// for follow up.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveContext {
    /// <p>The name of the context.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates the number of turns or seconds that the context is active.
    /// Once the time to live expires, the context is no longer returned in a
    /// response.</p>
    pub time_to_live: std::option::Option<crate::model::ActiveContextTimeToLive>,
    /// <p>A list of contexts active for the request. A context can be
    /// activated when a previous intent is fulfilled, or by including the
    /// context in the request.</p>
    /// <p>If you don't specify a list of contexts, Amazon Lex V2 will use the current
    /// list of contexts for the session. If you specify an empty list, all
    /// contexts for the session are cleared. </p>
    pub context_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ActiveContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveContext");
        formatter.field("name", &self.name);
        formatter.field("time_to_live", &self.time_to_live);
        formatter.field("context_attributes", &self.context_attributes);
        formatter.finish()
    }
}
/// See [`ActiveContext`](crate::model::ActiveContext)
pub mod active_context {
    /// A builder for [`ActiveContext`](crate::model::ActiveContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) time_to_live: std::option::Option<crate::model::ActiveContextTimeToLive>,
        pub(crate) context_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates the number of turns or seconds that the context is active.
        /// Once the time to live expires, the context is no longer returned in a
        /// response.</p>
        pub fn time_to_live(mut self, input: crate::model::ActiveContextTimeToLive) -> Self {
            self.time_to_live = Some(input);
            self
        }
        /// <p>Indicates the number of turns or seconds that the context is active.
        /// Once the time to live expires, the context is no longer returned in a
        /// response.</p>
        pub fn set_time_to_live(
            mut self,
            input: std::option::Option<crate::model::ActiveContextTimeToLive>,
        ) -> Self {
            self.time_to_live = input;
            self
        }
        /// Adds a key-value pair to `context_attributes`.
        ///
        /// To override the contents of this collection use [`set_context_attributes`](Self::set_context_attributes).
        ///
        /// <p>A list of contexts active for the request. A context can be
        /// activated when a previous intent is fulfilled, or by including the
        /// context in the request.</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex V2 will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared. </p>
        pub fn context_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.context_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.context_attributes = Some(hash_map);
            self
        }
        /// <p>A list of contexts active for the request. A context can be
        /// activated when a previous intent is fulfilled, or by including the
        /// context in the request.</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex V2 will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared. </p>
        pub fn set_context_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.context_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveContext`](crate::model::ActiveContext)
        pub fn build(self) -> crate::model::ActiveContext {
            crate::model::ActiveContext {
                name: self.name,
                time_to_live: self.time_to_live,
                context_attributes: self.context_attributes,
            }
        }
    }
}
impl ActiveContext {
    /// Creates a new builder-style object to manufacture [`ActiveContext`](crate::model::ActiveContext)
    pub fn builder() -> crate::model::active_context::Builder {
        crate::model::active_context::Builder::default()
    }
}

/// <p>The time that a context is active. You can specify the time to live
/// in seconds or in conversation turns.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveContextTimeToLive {
    /// <p>The number of seconds that the context is active. You can specify
    /// between 5 and 86400 seconds (24 hours).</p>
    pub time_to_live_in_seconds: std::option::Option<i32>,
    /// <p>The number of turns that the context is active. You can specify up
    /// to 20 turns. Each request and response from the bot is a turn.</p>
    pub turns_to_live: std::option::Option<i32>,
}
impl std::fmt::Debug for ActiveContextTimeToLive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveContextTimeToLive");
        formatter.field("time_to_live_in_seconds", &self.time_to_live_in_seconds);
        formatter.field("turns_to_live", &self.turns_to_live);
        formatter.finish()
    }
}
/// See [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
pub mod active_context_time_to_live {
    /// A builder for [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live_in_seconds: std::option::Option<i32>,
        pub(crate) turns_to_live: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of seconds that the context is active. You can specify
        /// between 5 and 86400 seconds (24 hours).</p>
        pub fn time_to_live_in_seconds(mut self, input: i32) -> Self {
            self.time_to_live_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds that the context is active. You can specify
        /// between 5 and 86400 seconds (24 hours).</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live_in_seconds = input;
            self
        }
        /// <p>The number of turns that the context is active. You can specify up
        /// to 20 turns. Each request and response from the bot is a turn.</p>
        pub fn turns_to_live(mut self, input: i32) -> Self {
            self.turns_to_live = Some(input);
            self
        }
        /// <p>The number of turns that the context is active. You can specify up
        /// to 20 turns. Each request and response from the bot is a turn.</p>
        pub fn set_turns_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.turns_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
        pub fn build(self) -> crate::model::ActiveContextTimeToLive {
            crate::model::ActiveContextTimeToLive {
                time_to_live_in_seconds: self.time_to_live_in_seconds,
                turns_to_live: self.turns_to_live,
            }
        }
    }
}
impl ActiveContextTimeToLive {
    /// Creates a new builder-style object to manufacture [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
    pub fn builder() -> crate::model::active_context_time_to_live::Builder {
        crate::model::active_context_time_to_live::Builder::default()
    }
}

/// <p>The next action that Amazon Lex V2 should take.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DialogAction {
    /// <p>The next action that the bot should take in its interaction with the
    /// user. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Close</code> - Indicates that there will not be a
    /// response from the user. For example, the statement "Your order
    /// has been placed" does not require a response.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - The next action is asking the
    /// user if the intent is complete and ready to be fulfilled. This is
    /// a yes/no question such as "Place the order?"</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delegate</code> - The next action is determined by
    /// Amazon Lex V2.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - The next action is to elicit a slot
    /// value from the user.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DialogActionType>,
    /// <p>The name of the slot that should be elicited from the user.</p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DialogAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DialogAction");
        formatter.field("r#type", &self.r#type);
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.finish()
    }
}
/// See [`DialogAction`](crate::model::DialogAction)
pub mod dialog_action {
    /// A builder for [`DialogAction`](crate::model::DialogAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DialogActionType>,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that there will not be a
        /// response from the user. For example, the statement "Your order
        /// has been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the
        /// user if the intent is complete and ready to be fulfilled. This is
        /// a yes/no question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delegate</code> - The next action is determined by
        /// Amazon Lex V2.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DialogActionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that there will not be a
        /// response from the user. For example, the statement "Your order
        /// has been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the
        /// user if the intent is complete and ready to be fulfilled. This is
        /// a yes/no question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delegate</code> - The next action is determined by
        /// Amazon Lex V2.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DialogActionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the slot that should be elicited from the user.</p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p>The name of the slot that should be elicited from the user.</p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// Consumes the builder and constructs a [`DialogAction`](crate::model::DialogAction)
        pub fn build(self) -> crate::model::DialogAction {
            crate::model::DialogAction {
                r#type: self.r#type,
                slot_to_elicit: self.slot_to_elicit,
            }
        }
    }
}
impl DialogAction {
    /// Creates a new builder-style object to manufacture [`DialogAction`](crate::model::DialogAction)
    pub fn builder() -> crate::model::dialog_action::Builder {
        crate::model::dialog_action::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DialogActionType {
    #[allow(missing_docs)] // documentation missing in model
    Close,
    #[allow(missing_docs)] // documentation missing in model
    ConfirmIntent,
    #[allow(missing_docs)] // documentation missing in model
    Delegate,
    #[allow(missing_docs)] // documentation missing in model
    ElicitIntent,
    #[allow(missing_docs)] // documentation missing in model
    ElicitSlot,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DialogActionType {
    fn from(s: &str) -> Self {
        match s {
            "Close" => DialogActionType::Close,
            "ConfirmIntent" => DialogActionType::ConfirmIntent,
            "Delegate" => DialogActionType::Delegate,
            "ElicitIntent" => DialogActionType::ElicitIntent,
            "ElicitSlot" => DialogActionType::ElicitSlot,
            "None" => DialogActionType::None,
            other => DialogActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DialogActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DialogActionType::from(s))
    }
}
impl DialogActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DialogActionType::Close => "Close",
            DialogActionType::ConfirmIntent => "ConfirmIntent",
            DialogActionType::Delegate => "Delegate",
            DialogActionType::ElicitIntent => "ElicitIntent",
            DialogActionType::ElicitSlot => "ElicitSlot",
            DialogActionType::None => "None",
            DialogActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Close",
            "ConfirmIntent",
            "Delegate",
            "ElicitIntent",
            "ElicitSlot",
            "None",
        ]
    }
}
impl AsRef<str> for DialogActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Container for text that is returned to the customer..</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The text of the message.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>Indicates the type of response.</p>
    pub content_type: std::option::Option<crate::model::MessageContentType>,
    /// <p>A card that is shown to the user by a messaging platform. You define
    /// the contents of the card, the card is displayed by the platform. </p>
    /// <p>When you use a response card, the response from the user is
    /// constrained to the text associated with a button on the card.</p>
    pub image_response_card: std::option::Option<crate::model::ImageResponseCard>,
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("content", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("image_response_card", &self.image_response_card);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<crate::model::MessageContentType>,
        pub(crate) image_response_card: std::option::Option<crate::model::ImageResponseCard>,
    }
    impl Builder {
        /// <p>The text of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The text of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>Indicates the type of response.</p>
        pub fn content_type(mut self, input: crate::model::MessageContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>Indicates the type of response.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::MessageContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// <p>A card that is shown to the user by a messaging platform. You define
        /// the contents of the card, the card is displayed by the platform. </p>
        /// <p>When you use a response card, the response from the user is
        /// constrained to the text associated with a button on the card.</p>
        pub fn image_response_card(mut self, input: crate::model::ImageResponseCard) -> Self {
            self.image_response_card = Some(input);
            self
        }
        /// <p>A card that is shown to the user by a messaging platform. You define
        /// the contents of the card, the card is displayed by the platform. </p>
        /// <p>When you use a response card, the response from the user is
        /// constrained to the text associated with a button on the card.</p>
        pub fn set_image_response_card(
            mut self,
            input: std::option::Option<crate::model::ImageResponseCard>,
        ) -> Self {
            self.image_response_card = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                content: self.content,
                content_type: self.content_type,
                image_response_card: self.image_response_card,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>A card that is shown to the user by a messaging platform. You define
/// the contents of the card, the card is displayed by the platform. </p>
/// <p>When you use a response card, the response from the user is
/// constrained to the text associated with a button on the card.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageResponseCard {
    /// <p>The title to display on the response card. The format of the title
    /// is determined by the platform displaying the response card.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The subtitle to display on the response card. The format of the
    /// subtitle is determined by the platform displaying the response
    /// card.</p>
    pub subtitle: std::option::Option<std::string::String>,
    /// <p>The URL of an image to display on the response card. The image URL
    /// must be publicly available so that the platform displaying the response
    /// card has access to the image.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>A list of buttons that should be displayed on the response card. The
    /// arrangement of the buttons is determined by the platform that displays
    /// the button.</p>
    pub buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
}
impl std::fmt::Debug for ImageResponseCard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageResponseCard");
        formatter.field("title", &self.title);
        formatter.field("subtitle", &self.subtitle);
        formatter.field("image_url", &self.image_url);
        formatter.field("buttons", &self.buttons);
        formatter.finish()
    }
}
/// See [`ImageResponseCard`](crate::model::ImageResponseCard)
pub mod image_response_card {
    /// A builder for [`ImageResponseCard`](crate::model::ImageResponseCard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) subtitle: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
    }
    impl Builder {
        /// <p>The title to display on the response card. The format of the title
        /// is determined by the platform displaying the response card.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to display on the response card. The format of the title
        /// is determined by the platform displaying the response card.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The subtitle to display on the response card. The format of the
        /// subtitle is determined by the platform displaying the response
        /// card.</p>
        pub fn subtitle(mut self, input: impl Into<std::string::String>) -> Self {
            self.subtitle = Some(input.into());
            self
        }
        /// <p>The subtitle to display on the response card. The format of the
        /// subtitle is determined by the platform displaying the response
        /// card.</p>
        pub fn set_subtitle(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subtitle = input;
            self
        }
        /// <p>The URL of an image to display on the response card. The image URL
        /// must be publicly available so that the platform displaying the response
        /// card has access to the image.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image to display on the response card. The image URL
        /// must be publicly available so that the platform displaying the response
        /// card has access to the image.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// Appends an item to `buttons`.
        ///
        /// To override the contents of this collection use [`set_buttons`](Self::set_buttons).
        ///
        /// <p>A list of buttons that should be displayed on the response card. The
        /// arrangement of the buttons is determined by the platform that displays
        /// the button.</p>
        pub fn buttons(mut self, input: impl Into<crate::model::Button>) -> Self {
            let mut v = self.buttons.unwrap_or_default();
            v.push(input.into());
            self.buttons = Some(v);
            self
        }
        /// <p>A list of buttons that should be displayed on the response card. The
        /// arrangement of the buttons is determined by the platform that displays
        /// the button.</p>
        pub fn set_buttons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Button>>,
        ) -> Self {
            self.buttons = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageResponseCard`](crate::model::ImageResponseCard)
        pub fn build(self) -> crate::model::ImageResponseCard {
            crate::model::ImageResponseCard {
                title: self.title,
                subtitle: self.subtitle,
                image_url: self.image_url,
                buttons: self.buttons,
            }
        }
    }
}
impl ImageResponseCard {
    /// Creates a new builder-style object to manufacture [`ImageResponseCard`](crate::model::ImageResponseCard)
    pub fn builder() -> crate::model::image_response_card::Builder {
        crate::model::image_response_card::Builder::default()
    }
}

/// <p>A button that appears on a response card show to the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Button {
    /// <p>The text that is displayed on the button.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The value returned to Amazon Lex V2 when a user chooses the button.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Button {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Button");
        formatter.field("text", &self.text);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Button`](crate::model::Button)
pub mod button {
    /// A builder for [`Button`](crate::model::Button)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text that is displayed on the button.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text that is displayed on the button.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The value returned to Amazon Lex V2 when a user chooses the button.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value returned to Amazon Lex V2 when a user chooses the button.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Button`](crate::model::Button)
        pub fn build(self) -> crate::model::Button {
            crate::model::Button {
                text: self.text,
                value: self.value,
            }
        }
    }
}
impl Button {
    /// Creates a new builder-style object to manufacture [`Button`](crate::model::Button)
    pub fn builder() -> crate::model::button::Builder {
        crate::model::button::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageContentType {
    #[allow(missing_docs)] // documentation missing in model
    CustomPayload,
    #[allow(missing_docs)] // documentation missing in model
    ImageResponseCard,
    #[allow(missing_docs)] // documentation missing in model
    PlainText,
    #[allow(missing_docs)] // documentation missing in model
    Ssml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageContentType {
    fn from(s: &str) -> Self {
        match s {
            "CustomPayload" => MessageContentType::CustomPayload,
            "ImageResponseCard" => MessageContentType::ImageResponseCard,
            "PlainText" => MessageContentType::PlainText,
            "SSML" => MessageContentType::Ssml,
            other => MessageContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageContentType::from(s))
    }
}
impl MessageContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageContentType::CustomPayload => "CustomPayload",
            MessageContentType::ImageResponseCard => "ImageResponseCard",
            MessageContentType::PlainText => "PlainText",
            MessageContentType::Ssml => "SSML",
            MessageContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CustomPayload", "ImageResponseCard", "PlainText", "SSML"]
    }
}
impl AsRef<str> for MessageContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
