// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteSessionInput`](crate::input::DeleteSessionInput)
pub mod delete_session_input {
    /// A builder for [`DeleteSessionInput`](crate::input::DeleteSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the session to delete.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session to delete.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSessionInput`](crate::input::DeleteSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSessionInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSessionInputOperationOutputAlias = crate::operation::DeleteSession;
#[doc(hidden)]
pub type DeleteSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSessionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSession`](crate::operation::DeleteSession)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.bot_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_1, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.bot_alias_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_2, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.locale_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_3, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.session_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_4, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
                botId = bot_id,
                botAliasId = bot_alias_id,
                localeId = locale_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSession",
            "lexruntimev2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSessionInput`](crate::input::DeleteSessionInput)
    pub fn builder() -> crate::input::delete_session_input::Builder {
        crate::input::delete_session_input::Builder::default()
    }
}

/// See [`GetSessionInput`](crate::input::GetSessionInput)
pub mod get_session_input {
    /// A builder for [`GetSessionInput`](crate::input::GetSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the session to return.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session to return.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionInput`](crate::input::GetSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSessionInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSessionInputOperationOutputAlias = crate::operation::GetSession;
#[doc(hidden)]
pub type GetSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetSession`](crate::operation::GetSession)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.bot_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_5, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.bot_alias_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_6, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.locale_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_7, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.session_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_8, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
                botId = bot_id,
                botAliasId = bot_alias_id,
                localeId = locale_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSession",
            "lexruntimev2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSessionInput`](crate::input::GetSessionInput)
    pub fn builder() -> crate::input::get_session_input::Builder {
        crate::input::get_session_input::Builder::default()
    }
}

/// See [`PutSessionInput`](crate::input::PutSessionInput)
pub mod put_session_input {
    /// A builder for [`PutSessionInput`](crate::input::PutSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
        pub(crate) session_state: std::option::Option<crate::model::SessionState>,
        pub(crate) request_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) response_content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that receives the session data.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that receives the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The alias identifier of the bot that receives the session
        /// data.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The alias identifier of the bot that receives the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the session that receives the session data.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session that receives the session data.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A list of messages to send to the user. Messages are sent in the
        /// order that they are defined in the list.</p>
        pub fn messages(mut self, input: impl Into<crate::model::Message>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>A list of messages to send to the user. Messages are sent in the
        /// order that they are defined in the list.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        pub fn session_state(mut self, input: crate::model::SessionState) -> Self {
            self.session_state = Some(input);
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<crate::model::SessionState>,
        ) -> Self {
            self.session_state = input;
            self
        }
        /// Adds a key-value pair to `request_attributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between Amazon Lex V2 and the client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_attributes = Some(hash_map);
            self
        }
        /// <p>Request-specific information passed between Amazon Lex V2 and the client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_attributes = input;
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech depending on the value of this parameter. </p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// </ul>
        pub fn response_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_type = Some(input.into());
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech depending on the value of this parameter. </p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSessionInput`](crate::input::PutSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSessionInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
                messages: self.messages,
                session_state: self.session_state,
                request_attributes: self.request_attributes,
                response_content_type: self.response_content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSessionInputOperationOutputAlias = crate::operation::PutSession;
#[doc(hidden)]
pub type PutSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutSessionInput {
    /// Consumes the builder and constructs an Operation<[`PutSession`](crate::operation::PutSession)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.bot_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_9, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.bot_alias_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_10, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.locale_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_11, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_12 = &_input.session_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_12, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}",
                botId = bot_id,
                botAliasId = bot_alias_id,
                localeId = locale_id,
                sessionId = session_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutSessionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_13) = &_input.response_content_type {
                let formatted_14 = AsRef::<str>::as_ref(inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "response_content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("ResponseContentType", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_session(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSession",
            "lexruntimev2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSessionInput`](crate::input::PutSessionInput)
    pub fn builder() -> crate::input::put_session_input::Builder {
        crate::input::put_session_input::Builder::default()
    }
}

/// See [`RecognizeTextInput`](crate::input::RecognizeTextInput)
pub mod recognize_text_input {
    /// A builder for [`RecognizeTextInput`](crate::input::RecognizeTextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) session_state: std::option::Option<crate::model::SessionState>,
        pub(crate) request_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the bot that processes the request.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that processes the request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The alias identifier in use for the bot that processes the
        /// request.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The alias identifier in use for the bot that processes the
        /// request.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the user session that is having the
        /// conversation.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user session that is having the
        /// conversation.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The text that the user entered. Amazon Lex V2 interprets this text.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text that the user entered. Amazon Lex V2 interprets this text.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The current state of the dialog between the user and the bot.</p>
        pub fn session_state(mut self, input: crate::model::SessionState) -> Self {
            self.session_state = Some(input);
            self
        }
        /// <p>The current state of the dialog between the user and the bot.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<crate::model::SessionState>,
        ) -> Self {
            self.session_state = input;
            self
        }
        /// Adds a key-value pair to `request_attributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_attributes = Some(hash_map);
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`RecognizeTextInput`](crate::input::RecognizeTextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RecognizeTextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RecognizeTextInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
                text: self.text,
                session_state: self.session_state,
                request_attributes: self.request_attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type RecognizeTextInputOperationOutputAlias = crate::operation::RecognizeText;
#[doc(hidden)]
pub type RecognizeTextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RecognizeTextInput {
    /// Consumes the builder and constructs an Operation<[`RecognizeText`](crate::operation::RecognizeText)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RecognizeText,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RecognizeTextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.bot_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_15, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.bot_alias_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_16, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.locale_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_17, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_18 = &_input.session_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_18, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/text", botId = bot_id, botAliasId = bot_alias_id, localeId = locale_id, sessionId = session_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RecognizeTextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RecognizeTextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_recognize_text(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RecognizeText::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RecognizeText",
            "lexruntimev2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RecognizeTextInput`](crate::input::RecognizeTextInput)
    pub fn builder() -> crate::input::recognize_text_input::Builder {
        crate::input::recognize_text_input::Builder::default()
    }
}

/// See [`RecognizeUtteranceInput`](crate::input::RecognizeUtteranceInput)
pub mod recognize_utterance_input {
    /// A builder for [`RecognizeUtteranceInput`](crate::input::RecognizeUtteranceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) session_state: std::option::Option<std::string::String>,
        pub(crate) request_attributes: std::option::Option<std::string::String>,
        pub(crate) request_content_type: std::option::Option<std::string::String>,
        pub(crate) response_content_type: std::option::Option<std::string::String>,
        pub(crate) input_stream: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
    }
    impl Builder {
        /// <p>The identifier of the bot that should receive the request.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that should receive the request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The alias identifier in use for the bot that should receive the
        /// request.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The alias identifier in use for the bot that should receive the
        /// request.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the session in use.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the session in use.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        /// <p>The <code>sessionState</code> field must be compressed using gzip
        /// and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn session_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_state = Some(input.into());
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        /// <p>The <code>sessionState</code> field must be compressed using gzip
        /// and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_state = input;
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes for prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>The <code>requestAttributes</code> field must be compressed using
        /// gzip and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn request_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_attributes = Some(input.into());
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes for prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>The <code>requestAttributes</code> field must be compressed using
        /// gzip and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_attributes = input;
            self
        }
        /// <p>Indicates the format for audio input or that the content is text.
        /// The header must start with one of the following prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte
        /// order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn request_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_content_type = Some(input.into());
            self
        }
        /// <p>Indicates the format for audio input or that the content is text.
        /// The header must start with one of the following prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte
        /// order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_request_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_content_type = input;
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech based on the <code>responseContentType</code> value.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex V2 returns
        /// speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech
        /// using the configuration that you specified in the
        /// <code>requestContentType</code> parameter. For example, if you
        /// specify <code>audio/mpeg</code> as the value, Amazon Lex V2 returns
        /// speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> at 16 KHz in 16-bit, little-endian
        /// format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm (16 KHz)</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn response_content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_content_type = Some(input.into());
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech based on the <code>responseContentType</code> value.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex V2 returns
        /// speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech
        /// using the configuration that you specified in the
        /// <code>requestContentType</code> parameter. For example, if you
        /// specify <code>audio/mpeg</code> as the value, Amazon Lex V2 returns
        /// speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> at 16 KHz in 16-bit, little-endian
        /// format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm (16 KHz)</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_content_type = input;
            self
        }
        /// <p>User input in PCM or Opus audio format or text format as described
        /// in the <code>requestContentType</code> parameter.</p>
        pub fn input_stream(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.input_stream = Some(input);
            self
        }
        /// <p>User input in PCM or Opus audio format or text format as described
        /// in the <code>requestContentType</code> parameter.</p>
        pub fn set_input_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.input_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`RecognizeUtteranceInput`](crate::input::RecognizeUtteranceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RecognizeUtteranceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RecognizeUtteranceInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
                session_state: self.session_state,
                request_attributes: self.request_attributes,
                request_content_type: self.request_content_type,
                response_content_type: self.response_content_type,
                input_stream: self.input_stream.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type RecognizeUtteranceInputOperationOutputAlias = crate::operation::RecognizeUtterance;
#[doc(hidden)]
pub type RecognizeUtteranceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RecognizeUtteranceInput {
    /// Consumes the builder and constructs an Operation<[`RecognizeUtterance`](crate::operation::RecognizeUtterance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RecognizeUtterance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RecognizeUtteranceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.bot_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_19, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.bot_alias_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_20, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.locale_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_21, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.session_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "session_id",
                        details: "cannot be empty or unset",
                    })?;
            let session_id = aws_smithy_http::label::fmt_string(input_22, false);
            if session_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "session_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/utterance", botId = bot_id, botAliasId = bot_alias_id, localeId = locale_id, sessionId = session_id).expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::RecognizeUtteranceInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_23) = &_input.session_state {
                let formatted_24 = AsRef::<str>::as_ref(inner_23);
                if !formatted_24.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_24;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "session_state",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-lex-session-state", header_value);
                }
            }
            if let Some(inner_25) = &_input.request_attributes {
                let formatted_26 = AsRef::<str>::as_ref(inner_25);
                if !formatted_26.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_26;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_attributes",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-lex-request-attributes", header_value);
                }
            }
            if let Some(inner_27) = &_input.request_content_type {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_29) = &_input.response_content_type {
                let formatted_30 = AsRef::<str>::as_ref(inner_29);
                if !formatted_30.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_30;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "response_content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Response-Content-Type", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RecognizeUtteranceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RecognizeUtteranceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_recognize_utterance_input(self.input_stream)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::UnsignedPayload);
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RecognizeUtterance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RecognizeUtterance",
            "lexruntimev2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RecognizeUtteranceInput`](crate::input::RecognizeUtteranceInput)
    pub fn builder() -> crate::input::recognize_utterance_input::Builder {
        crate::input::recognize_utterance_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct RecognizeUtteranceInput {
    /// <p>The identifier of the bot that should receive the request.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The alias identifier in use for the bot that should receive the
    /// request.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The locale where the session is in use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session in use.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>Sets the state of the session with the user. You can use this to set
    /// the current intent, attributes, context, and dialog action. Use the
    /// dialog action to determine the next step that Amazon Lex V2 should use in the
    /// conversation with the user.</p>
    /// <p>The <code>sessionState</code> field must be compressed using gzip
    /// and then base64 encoded before sending to Amazon Lex V2.</p>
    pub session_state: std::option::Option<std::string::String>,
    /// <p>Request-specific information passed between the client application
    /// and Amazon Lex V2 </p>
    /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
    /// attributes. Don't create any request attributes for prefix
    /// <code>x-amz-lex:</code>.</p>
    /// <p>The <code>requestAttributes</code> field must be compressed using
    /// gzip and then base64 encoded before sending to Amazon Lex V2.</p>
    pub request_attributes: std::option::Option<std::string::String>,
    /// <p>Indicates the format for audio input or that the content is text.
    /// The header must start with one of the following prefixes:</p>
    /// <ul>
    /// <li>
    /// <p>PCM format, audio data must be in little-endian byte
    /// order.</p>
    /// <ul>
    /// <li>
    /// <p>audio/l16; rate=16000; channels=1</p>
    /// </li>
    /// <li>
    /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
    /// </li>
    /// <li>
    /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
    /// channel-count=1; is-big-endian=false</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Opus format</p>
    /// <ul>
    /// <li>
    /// <p>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Text format</p>
    /// <ul>
    /// <li>
    /// <p>text/plain; charset=utf-8</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub request_content_type: std::option::Option<std::string::String>,
    /// <p>The message that Amazon Lex V2 returns in the response can be either text or
    /// speech based on the <code>responseContentType</code> value.</p>
    /// <ul>
    /// <li>
    /// <p>If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2
    /// returns text in the response.</p>
    /// </li>
    /// <li>
    /// <p>If the value begins with <code>audio/</code>, Amazon Lex V2 returns
    /// speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech
    /// using the configuration that you specified in the
    /// <code>requestContentType</code> parameter. For example, if you
    /// specify <code>audio/mpeg</code> as the value, Amazon Lex V2 returns
    /// speech in the MPEG format.</p>
    /// </li>
    /// <li>
    /// <p>If the value is <code>audio/pcm</code>, the speech returned is
    /// <code>audio/pcm</code> at 16 KHz in 16-bit, little-endian
    /// format.</p>
    /// </li>
    /// <li>
    /// <p>The following are the accepted values:</p>
    /// <ul>
    /// <li>
    /// <p>audio/mpeg</p>
    /// </li>
    /// <li>
    /// <p>audio/ogg</p>
    /// </li>
    /// <li>
    /// <p>audio/pcm (16 KHz)</p>
    /// </li>
    /// <li>
    /// <p>audio/* (defaults to mpeg)</p>
    /// </li>
    /// <li>
    /// <p>text/plain; charset=utf-8</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub response_content_type: std::option::Option<std::string::String>,
    /// <p>User input in PCM or Opus audio format or text format as described
    /// in the <code>requestContentType</code> parameter.</p>
    pub input_stream: aws_smithy_http::byte_stream::ByteStream,
}
impl std::fmt::Debug for RecognizeUtteranceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecognizeUtteranceInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("session_state", &"*** Sensitive Data Redacted ***");
        formatter.field("request_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("request_content_type", &self.request_content_type);
        formatter.field("response_content_type", &self.response_content_type);
        formatter.field("input_stream", &self.input_stream);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecognizeTextInput {
    /// <p>The identifier of the bot that processes the request.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The alias identifier in use for the bot that processes the
    /// request.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The locale where the session is in use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user session that is having the
    /// conversation.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The text that the user entered. Amazon Lex V2 interprets this text.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The current state of the dialog between the user and the bot.</p>
    pub session_state: std::option::Option<crate::model::SessionState>,
    /// <p>Request-specific information passed between the client application
    /// and Amazon Lex V2 </p>
    /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
    /// attributes. Don't create any request attributes with the prefix
    /// <code>x-amz-lex:</code>.</p>
    pub request_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for RecognizeTextInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecognizeTextInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("session_state", &self.session_state);
        formatter.field("request_attributes", &self.request_attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSessionInput {
    /// <p>The identifier of the bot that receives the session data.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The alias identifier of the bot that receives the session
    /// data.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The locale where the session is in use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session that receives the session data.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>A list of messages to send to the user. Messages are sent in the
    /// order that they are defined in the list.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    /// <p>Sets the state of the session with the user. You can use this to set
    /// the current intent, attributes, context, and dialog action. Use the
    /// dialog action to determine the next step that Amazon Lex V2 should use in the
    /// conversation with the user.</p>
    pub session_state: std::option::Option<crate::model::SessionState>,
    /// <p>Request-specific information passed between Amazon Lex V2 and the client
    /// application.</p>
    /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
    /// attributes. Don't create any request attributes with the prefix
    /// <code>x-amz-lex:</code>.</p>
    pub request_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The message that Amazon Lex V2 returns in the response can be either text or
    /// speech depending on the value of this parameter. </p>
    /// <ul>
    /// <li>
    /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2
    /// returns text in the response.</p>
    /// </li>
    /// </ul>
    pub response_content_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSessionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.field("messages", &self.messages);
        formatter.field("session_state", &self.session_state);
        formatter.field("request_attributes", &self.request_attributes);
        formatter.field("response_content_type", &self.response_content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionInput {
    /// <p>The identifier of the bot that contains the session data.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The alias identifier in use for the bot that contains the session
    /// data.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The locale where the session is in use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session to return.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSessionInput {
    /// <p>The identifier of the bot that contains the session data.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The alias identifier in use for the bot that contains the session
    /// data.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The locale where the session is in use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the session to delete.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSessionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}
