// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSessionError {
    /// Kind of error that occurred.
    pub kind: DeleteSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSessionErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSessionError {
    fn code(&self) -> Option<&str> {
        DeleteSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSessionError {
    /// Creates a new `DeleteSessionError`.
    pub fn new(kind: DeleteSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::ValidationException(_))
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::ConflictException(_))
    }
}
impl std::error::Error for DeleteSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSessionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSessionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSessionError {
    /// Kind of error that occurred.
    pub kind: GetSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSessionErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSessionError {
    fn code(&self) -> Option<&str> {
        GetSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSessionError {
    /// Creates a new `GetSessionError`.
    pub fn new(kind: GetSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::ValidationException(_))
    }
    /// Returns `true` if the error kind is `GetSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::InternalServerException(_))
    }
}
impl std::error::Error for GetSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetSessionErrorKind::ValidationException(_inner) => Some(_inner),
            GetSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSessionError {
    /// Kind of error that occurred.
    pub kind: PutSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSessionErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// <p></p>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSessionError {
    fn code(&self) -> Option<&str> {
        PutSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSessionError {
    /// Creates a new `PutSessionError`.
    pub fn new(kind: PutSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::ValidationException(_))
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSessionErrorKind::DependencyFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `PutSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::ConflictException(_))
    }
}
impl std::error::Error for PutSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutSessionErrorKind::BadGatewayException(_inner) => Some(_inner),
            PutSessionErrorKind::ValidationException(_inner) => Some(_inner),
            PutSessionErrorKind::DependencyFailedException(_inner) => Some(_inner),
            PutSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            PutSessionErrorKind::ConflictException(_inner) => Some(_inner),
            PutSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RecognizeText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RecognizeTextError {
    /// Kind of error that occurred.
    pub kind: RecognizeTextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RecognizeText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RecognizeTextErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// <p></p>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RecognizeTextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RecognizeTextErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RecognizeTextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RecognizeTextError {
    fn code(&self) -> Option<&str> {
        RecognizeTextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RecognizeTextError {
    /// Creates a new `RecognizeTextError`.
    pub fn new(kind: RecognizeTextErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RecognizeTextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RecognizeTextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RecognizeTextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RecognizeTextErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RecognizeTextErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeTextErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, RecognizeTextErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, RecognizeTextErrorKind::BadGatewayException(_))
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RecognizeTextErrorKind::ValidationException(_))
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeTextErrorKind::DependencyFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeTextErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeTextErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, RecognizeTextErrorKind::ConflictException(_))
    }
}
impl std::error::Error for RecognizeTextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RecognizeTextErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RecognizeTextErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RecognizeTextErrorKind::ThrottlingException(_inner) => Some(_inner),
            RecognizeTextErrorKind::BadGatewayException(_inner) => Some(_inner),
            RecognizeTextErrorKind::ValidationException(_inner) => Some(_inner),
            RecognizeTextErrorKind::DependencyFailedException(_inner) => Some(_inner),
            RecognizeTextErrorKind::InternalServerException(_inner) => Some(_inner),
            RecognizeTextErrorKind::ConflictException(_inner) => Some(_inner),
            RecognizeTextErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RecognizeUtterance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RecognizeUtteranceError {
    /// Kind of error that occurred.
    pub kind: RecognizeUtteranceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RecognizeUtterance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RecognizeUtteranceErrorKind {
    /// <p></p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p></p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p></p>
    ValidationException(crate::error::ValidationException),
    /// <p></p>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p></p>
    InternalServerException(crate::error::InternalServerException),
    /// <p></p>
    ConflictException(crate::error::ConflictException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RecognizeUtteranceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RecognizeUtteranceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            RecognizeUtteranceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RecognizeUtteranceError {
    fn code(&self) -> Option<&str> {
        RecognizeUtteranceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RecognizeUtteranceError {
    /// Creates a new `RecognizeUtteranceError`.
    pub fn new(kind: RecognizeUtteranceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RecognizeUtteranceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RecognizeUtteranceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RecognizeUtteranceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RecognizeUtteranceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::BadGatewayException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::ValidationException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::DependencyFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RecognizeUtteranceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            RecognizeUtteranceErrorKind::ConflictException(_)
        )
    }
}
impl std::error::Error for RecognizeUtteranceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RecognizeUtteranceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::ThrottlingException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::BadGatewayException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::ValidationException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::DependencyFailedException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::InternalServerException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::ConflictException(_inner) => Some(_inner),
            RecognizeUtteranceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyFailedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyFailedException {}
/// See [`DependencyFailedException`](crate::error::DependencyFailedException)
pub mod dependency_failed_exception {
    /// A builder for [`DependencyFailedException`](crate::error::DependencyFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyFailedException`](crate::error::DependencyFailedException)
        pub fn build(self) -> crate::error::DependencyFailedException {
            crate::error::DependencyFailedException {
                message: self.message,
            }
        }
    }
}
impl DependencyFailedException {
    /// Creates a new builder-style object to manufacture [`DependencyFailedException`](crate::error::DependencyFailedException)
    pub fn builder() -> crate::error::dependency_failed_exception::Builder {
        crate::error::dependency_failed_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadGatewayException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadGatewayException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadGatewayException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadGatewayException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadGatewayException {}
/// See [`BadGatewayException`](crate::error::BadGatewayException)
pub mod bad_gateway_exception {
    /// A builder for [`BadGatewayException`](crate::error::BadGatewayException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadGatewayException`](crate::error::BadGatewayException)
        pub fn build(self) -> crate::error::BadGatewayException {
            crate::error::BadGatewayException {
                message: self.message,
            }
        }
    }
}
impl BadGatewayException {
    /// Creates a new builder-style object to manufacture [`BadGatewayException`](crate::error::BadGatewayException)
    pub fn builder() -> crate::error::bad_gateway_exception::Builder {
        crate::error::bad_gateway_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
