// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSDeepSenseRunTimeServiceApi2_0`.
///
/// This client allows ergonomic access to a `AWSDeepSenseRunTimeServiceApi2_0`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `DeleteSession` operation.
    ///
    /// See [`DeleteSession`](crate::client::fluent_builders::DeleteSession) for more information about the
    /// operation and its arguments.
    pub fn delete_session(&self) -> fluent_builders::DeleteSession<C, M, R> {
        fluent_builders::DeleteSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSession` operation.
    ///
    /// See [`GetSession`](crate::client::fluent_builders::GetSession) for more information about the
    /// operation and its arguments.
    pub fn get_session(&self) -> fluent_builders::GetSession<C, M, R> {
        fluent_builders::GetSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutSession` operation.
    ///
    /// See [`PutSession`](crate::client::fluent_builders::PutSession) for more information about the
    /// operation and its arguments.
    pub fn put_session(&self) -> fluent_builders::PutSession<C, M, R> {
        fluent_builders::PutSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RecognizeText` operation.
    ///
    /// See [`RecognizeText`](crate::client::fluent_builders::RecognizeText) for more information about the
    /// operation and its arguments.
    pub fn recognize_text(&self) -> fluent_builders::RecognizeText<C, M, R> {
        fluent_builders::RecognizeText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RecognizeUtterance` operation.
    ///
    /// See [`RecognizeUtterance`](crate::client::fluent_builders::RecognizeUtterance) for more information about the
    /// operation and its arguments.
    pub fn recognize_utterance(&self) -> fluent_builders::RecognizeUtterance<C, M, R> {
        fluent_builders::RecognizeUtterance::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteSession`.
    ///
    /// <p>Removes session information for a specified bot, alias, and user ID. </p>
    /// <p>You can use this operation to restart a conversation with a bot.
    /// When you remove a session, the entire history of the session is removed
    /// so that you can start again.</p>
    /// <p>You don't need to delete a session. Sessions have a time limit and
    /// will expire. Set the session time limit when you create the bot. The
    /// default is 5 minutes, but you can specify anything between 1 minute and
    /// 24 hours.</p>
    /// <p>If you specify a bot or alias ID that doesn't exist, you receive a
    /// <code>BadRequestException.</code>
    /// </p>
    /// <p>If the locale doesn't exist in the bot, or if the locale hasn't been
    /// enables for the alias, you receive a
    /// <code>BadRequestException</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_session_input::Builder,
    }
    impl<C, M, R> DeleteSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSessionInputOperationOutputAlias,
                crate::output::DeleteSessionOutput,
                crate::error::DeleteSessionError,
                crate::input::DeleteSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the session to delete.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the session to delete.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSession`.
    ///
    /// <p>Returns session information for a specified bot, alias, and
    /// user.</p>
    /// <p>For example, you can use this operation to retrieve session
    /// information for a user that has left a long-running session in
    /// use.</p>
    /// <p>If the bot, alias, or session identifier doesn't exist, Amazon Lex V2
    /// returns a <code>BadRequestException</code>. If the locale doesn't exist
    /// or is not enabled for the alias, you receive a
    /// <code>BadRequestException</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_session_input::Builder,
    }
    impl<C, M, R> GetSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSessionInputOperationOutputAlias,
                crate::output::GetSessionOutput,
                crate::error::GetSessionError,
                crate::input::GetSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The alias identifier in use for the bot that contains the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the session to return.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the session to return.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSession`.
    ///
    /// <p>Creates a new session or modifies an existing session with an Amazon Lex V2
    /// bot. Use this operation to enable your application to set the state of
    /// the bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_session_input::Builder,
    }
    impl<C, M, R> PutSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSessionInputOperationOutputAlias,
                crate::output::PutSessionOutput,
                crate::error::PutSessionError,
                crate::input::PutSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that receives the session data.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that receives the session data.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The alias identifier of the bot that receives the session
        /// data.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The alias identifier of the bot that receives the session
        /// data.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the session that receives the session data.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the session that receives the session data.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A list of messages to send to the user. Messages are sent in the
        /// order that they are defined in the list.</p>
        pub fn messages(mut self, inp: impl Into<crate::model::Message>) -> Self {
            self.inner = self.inner.messages(inp);
            self
        }
        /// <p>A list of messages to send to the user. Messages are sent in the
        /// order that they are defined in the list.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.inner = self.inner.set_messages(input);
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        pub fn session_state(mut self, inp: crate::model::SessionState) -> Self {
            self.inner = self.inner.session_state(inp);
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<crate::model::SessionState>,
        ) -> Self {
            self.inner = self.inner.set_session_state(input);
            self
        }
        /// Adds a key-value pair to `requestAttributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between Amazon Lex V2 and the client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_attributes(k, v);
            self
        }
        /// <p>Request-specific information passed between Amazon Lex V2 and the client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_attributes(input);
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech depending on the value of this parameter. </p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// </ul>
        pub fn response_content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_content_type(inp);
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech depending on the value of this parameter. </p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// </ul>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecognizeText`.
    ///
    /// <p>Sends user input to Amazon Lex V2. Client applications use this API to send
    /// requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user input
    /// using the machine learning model that it build for the bot.</p>
    /// <p>In response, Amazon Lex V2 returns the next message to convey to the user
    /// and an optional response card to display.</p>
    /// <p>If the optional post-fulfillment response is specified, the messages
    /// are returned as follows. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_PostFulfillmentStatusSpecification.html">PostFulfillmentStatusSpecification</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Success message</b> - Returned if
    /// the Lambda function completes successfully and the intent state is
    /// fulfilled or ready fulfillment if the message is present.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Failed message</b> - The failed
    /// message is returned if the Lambda function throws an exception or
    /// if the Lambda function returns a failed intent state without a
    /// message.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Timeout message</b> - If you
    /// don't configure a timeout message and a timeout, and the Lambda
    /// function doesn't return within 30 seconds, the timeout message is
    /// returned. If you configure a timeout, the timeout message is
    /// returned when the period times out. </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete.html">Completion message</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RecognizeText<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::recognize_text_input::Builder,
    }
    impl<C, M, R> RecognizeText<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RecognizeText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecognizeTextOutput,
            aws_smithy_http::result::SdkError<crate::error::RecognizeTextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RecognizeTextInputOperationOutputAlias,
                crate::output::RecognizeTextOutput,
                crate::error::RecognizeTextError,
                crate::input::RecognizeTextInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that processes the request.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that processes the request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The alias identifier in use for the bot that processes the
        /// request.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The alias identifier in use for the bot that processes the
        /// request.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the user session that is having the
        /// conversation.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the user session that is having the
        /// conversation.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>The text that the user entered. Amazon Lex V2 interprets this text.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>The text that the user entered. Amazon Lex V2 interprets this text.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// <p>The current state of the dialog between the user and the bot.</p>
        pub fn session_state(mut self, inp: crate::model::SessionState) -> Self {
            self.inner = self.inner.session_state(inp);
            self
        }
        /// <p>The current state of the dialog between the user and the bot.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<crate::model::SessionState>,
        ) -> Self {
            self.inner = self.inner.set_session_state(input);
            self
        }
        /// Adds a key-value pair to `requestAttributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_attributes(k, v);
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RecognizeUtterance`.
    ///
    /// <p>Sends user input to Amazon Lex V2. You can send text or speech. Clients use
    /// this API to send text and audio requests to Amazon Lex V2 at runtime. Amazon Lex V2
    /// interprets the user input using the machine learning model built for
    /// the bot.</p>
    /// <p>The following request fields must be compressed with gzip and then
    /// base64 encoded before you send them to Amazon Lex V2. </p>
    /// <ul>
    /// <li>
    /// <p>requestAttributes</p>
    /// </li>
    /// <li>
    /// <p>sessionState</p>
    /// </li>
    /// </ul>
    /// <p>The following response fields are compressed using gzip and then
    /// base64 encoded by Amazon Lex V2. Before you can use these fields, you must
    /// decode and decompress them. </p>
    /// <ul>
    /// <li>
    /// <p>inputTranscript</p>
    /// </li>
    /// <li>
    /// <p>interpretations</p>
    /// </li>
    /// <li>
    /// <p>messages</p>
    /// </li>
    /// <li>
    /// <p>requestAttributes</p>
    /// </li>
    /// <li>
    /// <p>sessionState</p>
    /// </li>
    /// </ul>
    /// <p>The example contains a Java application that compresses and encodes
    /// a Java object to send to Amazon Lex V2, and a second that decodes and
    /// decompresses a response from Amazon Lex V2.</p>
    /// <p>If the optional post-fulfillment response is specified, the messages
    /// are returned as follows. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_PostFulfillmentStatusSpecification.html">PostFulfillmentStatusSpecification</a>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Success message</b> - Returned if
    /// the Lambda function completes successfully and the intent state is
    /// fulfilled or ready fulfillment if the message is present.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Failed message</b> - The failed
    /// message is returned if the Lambda function throws an exception or
    /// if the Lambda function returns a failed intent state without a
    /// message.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Timeout message</b> - If you
    /// don't configure a timeout message and a timeout, and the Lambda
    /// function doesn't return within 30 seconds, the timeout message is
    /// returned. If you configure a timeout, the timeout message is
    /// returned when the period times out. </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete.html">Completion message</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RecognizeUtterance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::recognize_utterance_input::Builder,
    }
    impl<C, M, R> RecognizeUtterance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RecognizeUtterance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RecognizeUtteranceOutput,
            aws_smithy_http::result::SdkError<crate::error::RecognizeUtteranceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RecognizeUtteranceInputOperationOutputAlias,
                crate::output::RecognizeUtteranceOutput,
                crate::error::RecognizeUtteranceError,
                crate::input::RecognizeUtteranceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that should receive the request.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that should receive the request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The alias identifier in use for the bot that should receive the
        /// request.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The alias identifier in use for the bot that should receive the
        /// request.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The locale where the session is in use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the session in use.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the session in use.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        /// <p>The <code>sessionState</code> field must be compressed using gzip
        /// and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn session_state(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_state(inp);
            self
        }
        /// <p>Sets the state of the session with the user. You can use this to set
        /// the current intent, attributes, context, and dialog action. Use the
        /// dialog action to determine the next step that Amazon Lex V2 should use in the
        /// conversation with the user.</p>
        /// <p>The <code>sessionState</code> field must be compressed using gzip
        /// and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn set_session_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_state(input);
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes for prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>The <code>requestAttributes</code> field must be compressed using
        /// gzip and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn request_attributes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_attributes(inp);
            self
        }
        /// <p>Request-specific information passed between the client application
        /// and Amazon Lex V2 </p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes for prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>The <code>requestAttributes</code> field must be compressed using
        /// gzip and then base64 encoded before sending to Amazon Lex V2.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_attributes(input);
            self
        }
        /// <p>Indicates the format for audio input or that the content is text.
        /// The header must start with one of the following prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte
        /// order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn request_content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_content_type(inp);
            self
        }
        /// <p>Indicates the format for audio input or that the content is text.
        /// The header must start with one of the following prefixes:</p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte
        /// order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble;preamble-size=0;bit-rate=256000;frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_request_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_content_type(input);
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech based on the <code>responseContentType</code> value.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex V2 returns
        /// speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech
        /// using the configuration that you specified in the
        /// <code>requestContentType</code> parameter. For example, if you
        /// specify <code>audio/mpeg</code> as the value, Amazon Lex V2 returns
        /// speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> at 16 KHz in 16-bit, little-endian
        /// format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm (16 KHz)</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn response_content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_content_type(inp);
            self
        }
        /// <p>The message that Amazon Lex V2 returns in the response can be either text or
        /// speech based on the <code>responseContentType</code> value.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain;charset=utf-8</code>, Amazon Lex V2
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex V2 returns
        /// speech in the response. Amazon Lex V2 uses Amazon Polly to generate the speech
        /// using the configuration that you specified in the
        /// <code>requestContentType</code> parameter. For example, if you
        /// specify <code>audio/mpeg</code> as the value, Amazon Lex V2 returns
        /// speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> at 16 KHz in 16-bit, little-endian
        /// format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm (16 KHz)</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_response_content_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_content_type(input);
            self
        }
        /// <p>User input in PCM or Opus audio format or text format as described
        /// in the <code>requestContentType</code> parameter.</p>
        pub fn input_stream(mut self, inp: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.input_stream(inp);
            self
        }
        /// <p>User input in PCM or Opus audio format or text format as described
        /// in the <code>requestContentType</code> parameter.</p>
        pub fn set_input_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_input_stream(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
