// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Lex Runtime Service
///
/// Client for invoking operations on Amazon Lex Runtime Service. Each operation on Amazon Lex Runtime Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lexruntime::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_lexruntime::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_lexruntime::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`DeleteSession`](crate::client::fluent_builders::DeleteSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSession::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::DeleteSession::set_bot_name): <p>The name of the bot that contains the session data.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::DeleteSession::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::DeleteSession::set_bot_alias): <p>The alias in use for the bot that contains the session data.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSession::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteSession::set_user_id): <p>The identifier of the user associated with the session data.</p>
    /// - On success, responds with [`DeleteSessionOutput`](crate::output::DeleteSessionOutput) with field(s):
    ///   - [`bot_name(Option<String>)`](crate::output::DeleteSessionOutput::bot_name): <p>The name of the bot associated with the session data.</p>
    ///   - [`bot_alias(Option<String>)`](crate::output::DeleteSessionOutput::bot_alias): <p>The alias in use for the bot associated with the session data.</p>
    ///   - [`user_id(Option<String>)`](crate::output::DeleteSessionOutput::user_id): <p>The ID of the client application user.</p>
    ///   - [`session_id(Option<String>)`](crate::output::DeleteSessionOutput::session_id): <p>The unique identifier for the session.</p>
    /// - On failure, responds with [`SdkError<DeleteSessionError>`](crate::error::DeleteSessionError)
    pub fn delete_session(&self) -> fluent_builders::DeleteSession {
        fluent_builders::DeleteSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSession`](crate::client::fluent_builders::GetSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetSession::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetSession::set_bot_name): <p>The name of the bot that contains the session data.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::GetSession::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::GetSession::set_bot_alias): <p>The alias in use for the bot that contains the session data.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::GetSession::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::GetSession::set_user_id): <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
    ///   - [`checkpoint_label_filter(impl Into<String>)`](crate::client::fluent_builders::GetSession::checkpoint_label_filter) / [`set_checkpoint_label_filter(Option<String>)`](crate::client::fluent_builders::GetSession::set_checkpoint_label_filter): <p>A string used to filter the intents returned in the <code>recentIntentSummaryView</code> structure. </p>  <p>When you specify a filter, only intents with their <code>checkpointLabel</code> field set to that string are returned.</p>
    /// - On success, responds with [`GetSessionOutput`](crate::output::GetSessionOutput) with field(s):
    ///   - [`recent_intent_summary_view(Option<Vec<IntentSummary>>)`](crate::output::GetSessionOutput::recent_intent_summary_view): <p>An array of information about the intents used in the session. The array can contain a maximum of three summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code> operation contains information about the last three intents used.</p>  <p>If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the intents with the specified label.</p>
    ///   - [`session_attributes(Option<HashMap<String, String>>)`](crate::output::GetSessionOutput::session_attributes): <p>Map of key/value pairs representing the session-specific context information. It contains application information passed between Amazon Lex and a client application.</p>
    ///   - [`session_id(Option<String>)`](crate::output::GetSessionOutput::session_id): <p>A unique identifier for the session.</p>
    ///   - [`dialog_action(Option<DialogAction>)`](crate::output::GetSessionOutput::dialog_action): <p>Describes the current state of the bot.</p>
    ///   - [`active_contexts(Option<Vec<ActiveContext>>)`](crate::output::GetSessionOutput::active_contexts): <p>A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.</p>  <p>You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.</p>
    /// - On failure, responds with [`SdkError<GetSessionError>`](crate::error::GetSessionError)
    pub fn get_session(&self) -> fluent_builders::GetSession {
        fluent_builders::GetSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PostContent`](crate::client::fluent_builders::PostContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::PostContent::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::PostContent::set_bot_name): <p>Name of the Amazon Lex bot.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::PostContent::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::PostContent::set_bot_alias): <p>Alias of the Amazon Lex bot.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::PostContent::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::PostContent::set_user_id): <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>  <p>To decide the user ID to use for your application, consider the following factors.</p>  <ul>   <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>   <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>   <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>   <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>  </ul>
    ///   - [`session_attributes(impl Into<String>)`](crate::client::fluent_builders::PostContent::session_attributes) / [`set_session_attributes(Option<String>)`](crate::client::fluent_builders::PostContent::set_session_attributes): <p>You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.</p>  <p>Application-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
    ///   - [`request_attributes(impl Into<String>)`](crate::client::fluent_builders::PostContent::request_attributes) / [`set_request_attributes(Option<String>)`](crate::client::fluent_builders::PostContent::set_request_attributes): <p>You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.</p>  <p>Request-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.</p>  <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::PostContent::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::PostContent::set_content_type): <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>  <p> Indicates the audio format or text. The header value must start with one of the following prefixes: </p>  <ul>   <li> <p>PCM format, audio data must be in little-endian byte order.</p>    <ul>     <li> <p>audio/l16; rate=16000; channels=1</p> </li>     <li> <p>audio/x-l16; sample-rate=16000; channel-count=1</p> </li>     <li> <p>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false </p> </li>    </ul> </li>   <li> <p>Opus format</p>    <ul>     <li> <p>audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4</p> </li>    </ul> </li>   <li> <p>Text format</p>    <ul>     <li> <p>text/plain; charset=utf-8</p> </li>    </ul> </li>  </ul>
    ///   - [`accept(impl Into<String>)`](crate::client::fluent_builders::PostContent::accept) / [`set_accept(Option<String>)`](crate::client::fluent_builders::PostContent::set_accept): <p> You pass this value as the <code>Accept</code> HTTP header. </p>  <p> The message Amazon Lex returns in the response can be either text or speech based on the <code>Accept</code> HTTP header value in the request. </p>  <ul>   <li> <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response. </p> </li>   <li> <p> If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech (using the configuration you specified in the <code>Accept</code> header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>   <li> <p>If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little endian format. </p> </li>   <li> <p>The following are the accepted values:</p>    <ul>     <li> <p>audio/mpeg</p> </li>     <li> <p>audio/ogg</p> </li>     <li> <p>audio/pcm</p> </li>     <li> <p>text/plain; charset=utf-8</p> </li>     <li> <p>audio/* (defaults to mpeg)</p> </li>    </ul> </li>  </ul>
    ///   - [`input_stream(byte_stream::ByteStream)`](crate::client::fluent_builders::PostContent::input_stream) / [`set_input_stream(byte_stream::ByteStream)`](crate::client::fluent_builders::PostContent::set_input_stream): <p> User input in PCM or Opus audio format or text format as described in the <code>Content-Type</code> HTTP header. </p>  <p>You can stream audio data to Amazon Lex or you can create a local buffer that captures all of the audio data before sending. In general, you get better performance if you stream audio data rather than buffering the data locally.</p>
    ///   - [`active_contexts(impl Into<String>)`](crate::client::fluent_builders::PostContent::active_contexts) / [`set_active_contexts(Option<String>)`](crate::client::fluent_builders::PostContent::set_active_contexts): <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>  <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
    /// - On success, responds with [`PostContentOutput`](crate::output::PostContentOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::PostContentOutput::content_type): <p>Content type as specified in the <code>Accept</code> HTTP header in the request.</p>
    ///   - [`intent_name(Option<String>)`](crate::output::PostContentOutput::intent_name): <p>Current user intent that Amazon Lex is aware of.</p>
    ///   - [`nlu_intent_confidence(Option<String>)`](crate::output::PostContentOutput::nlu_intent_confidence): <p>Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0.</p>  <p>The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex. </p>
    ///   - [`alternative_intents(Option<String>)`](crate::output::PostContentOutput::alternative_intents): <p>One to four alternative intents that may be applicable to the user's intent.</p>  <p>Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.</p>
    ///   - [`slots(Option<String>)`](crate::output::PostContentOutput::slots): <p>Map of zero or more intent slots (name/value pairs) Amazon Lex detected from the user input during the conversation. The field is base-64 encoded.</p>  <p>Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>
    ///   - [`session_attributes(Option<String>)`](crate::output::PostContentOutput::session_attributes): <p> Map of key/value pairs representing the session-specific context information. </p>
    ///   - [`sentiment_response(Option<String>)`](crate::output::PostContentOutput::sentiment_response): <p>The sentiment expressed in an utterance.</p>  <p>When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.</p>
    ///   - [`message(Option<String>)`](crate::output::PostContentOutput::message): <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the <code>message</code> field is null. You should use the <code>encodedMessage</code> field instead.</p>  <p>The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.</p>  <p>If the intent is not configured with a Lambda function, or if the Lambda function returned <code>Delegate</code> as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.</p>  <p>When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see <code>msg-prompts-formats</code>.</p>  <p>If the Lambda function returns a message, Amazon Lex passes it to the client in its response.</p>
    ///   - [`encoded_message(Option<String>)`](crate::output::PostContentOutput::encoded_message): <p>The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.</p>  <p>If the intent is not configured with a Lambda function, or if the Lambda function returned <code>Delegate</code> as the <code>dialogAction.type</code> in its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.</p>  <p>When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see <code>msg-prompts-formats</code>.</p>  <p>If the Lambda function returns a message, Amazon Lex passes it to the client in its response.</p>  <p>The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use the value.</p>
    ///   - [`message_format(Option<MessageFormatType>)`](crate::output::PostContentOutput::message_format): <p>The format of the response message. One of the following values:</p>  <ul>   <li> <p> <code>PlainText</code> - The message contains plain UTF-8 text.</p> </li>   <li> <p> <code>CustomPayload</code> - The message is a custom format for the client.</p> </li>   <li> <p> <code>SSML</code> - The message contains text formatted for voice output.</p> </li>   <li> <p> <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.</p> </li>  </ul>
    ///   - [`dialog_state(Option<DialogState>)`](crate::output::PostContentOutput::dialog_state): <p>Identifies the current state of the user interaction. Amazon Lex returns one of the following values as <code>dialogState</code>. The client can optionally use this information to customize the user interface. </p>  <ul>   <li> <p> <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent. Consider the following examples: </p> <p> For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialog state. </p> </li>   <li> <p> <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response. </p> <p>For example, Amazon Lex wants user confirmation before fulfilling an intent. Instead of a simple "yes" or "no" response, a user might respond with additional information. For example, "yes, but make it a thick crust pizza" or "no, I want to order a drink." Amazon Lex can process such additional information (in these examples, update the crust type slot or change the intent from OrderPizza to OrderDrink). </p> </li>   <li> <p> <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent. </p> <p> For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately. </p> </li>   <li> <p> <code>Fulfilled</code> - Conveys that the Lambda function has successfully fulfilled the intent. </p> </li>   <li> <p> <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the request. </p> </li>   <li> <p> <code>Failed</code> - Conveys that the conversation with the user failed. </p> <p> This can happen for various reasons, including that the user does not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or if the Lambda function fails to fulfill the intent. </p> </li>  </ul>
    ///   - [`slot_to_elicit(Option<String>)`](crate::output::PostContentOutput::slot_to_elicit): <p> If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    ///   - [`input_transcript(Option<String>)`](crate::output::PostContentOutput::input_transcript): <p>The text used to process the request.</p>  <p>You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the <code>inputTranscript</code> field is null. You should use the <code>encodedInputTranscript</code> field instead.</p>  <p>If the input was an audio stream, the <code>inputTranscript</code> field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.</p>
    ///   - [`encoded_input_transcript(Option<String>)`](crate::output::PostContentOutput::encoded_input_transcript): <p>The text used to process the request.</p>  <p>If the input was an audio stream, the <code>encodedInputTranscript</code> field contains the text extracted from the audio stream. This is the text that is actually processed to recognize intents and slot values. You can use this information to determine if Amazon Lex is correctly processing the audio that you send.</p>  <p>The <code>encodedInputTranscript</code> field is base-64 encoded. You must decode the field before you can use the value.</p>
    ///   - [`audio_stream(byte_stream::ByteStream)`](crate::output::PostContentOutput::audio_stream): <p>The prompt (or statement) to convey to the user. This is based on the bot configuration and context. For example, if Amazon Lex did not understand the user intent, it sends the <code>clarificationPrompt</code> configured for the bot. If the intent requires confirmation before taking the fulfillment action, it sends the <code>confirmationPrompt</code>. Another example: Suppose that the Lambda function successfully fulfilled the intent, and sent a message to convey to the user. Then Amazon Lex sends that message in the response. </p>
    ///   - [`bot_version(Option<String>)`](crate::output::PostContentOutput::bot_version): <p>The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.</p>
    ///   - [`session_id(Option<String>)`](crate::output::PostContentOutput::session_id): <p>The unique identifier for the session.</p>
    ///   - [`active_contexts(Option<String>)`](crate::output::PostContentOutput::active_contexts): <p>A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.</p>  <p>You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.</p>
    /// - On failure, responds with [`SdkError<PostContentError>`](crate::error::PostContentError)
    pub fn post_content(&self) -> fluent_builders::PostContent {
        fluent_builders::PostContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PostText`](crate::client::fluent_builders::PostText) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::PostText::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::PostText::set_bot_name): <p>The name of the Amazon Lex bot.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::PostText::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::PostText::set_bot_alias): <p>The alias of the Amazon Lex bot.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::PostText::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::PostText::set_user_id): <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>  <p>To decide the user ID to use for your application, consider the following factors.</p>  <ul>   <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>   <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>   <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>   <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>  </ul>
    ///   - [`session_attributes(HashMap<String, String>)`](crate::client::fluent_builders::PostText::session_attributes) / [`set_session_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PostText::set_session_attributes): <p>Application-specific information passed between Amazon Lex and a client application.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
    ///   - [`request_attributes(HashMap<String, String>)`](crate::client::fluent_builders::PostText::request_attributes) / [`set_request_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PostText::set_request_attributes): <p>Request-specific information passed between Amazon Lex and a client application.</p>  <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
    ///   - [`input_text(impl Into<String>)`](crate::client::fluent_builders::PostText::input_text) / [`set_input_text(Option<String>)`](crate::client::fluent_builders::PostText::set_input_text): <p>The text that the user entered (Amazon Lex interprets this text).</p>
    ///   - [`active_contexts(Vec<ActiveContext>)`](crate::client::fluent_builders::PostText::active_contexts) / [`set_active_contexts(Option<Vec<ActiveContext>>)`](crate::client::fluent_builders::PostText::set_active_contexts): <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>  <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
    /// - On success, responds with [`PostTextOutput`](crate::output::PostTextOutput) with field(s):
    ///   - [`intent_name(Option<String>)`](crate::output::PostTextOutput::intent_name): <p>The current user intent that Amazon Lex is aware of.</p>
    ///   - [`nlu_intent_confidence(Option<IntentConfidence>)`](crate::output::PostTextOutput::nlu_intent_confidence): <p>Provides a score that indicates how confident Amazon Lex is that the returned intent is the one that matches the user's intent. The score is between 0.0 and 1.0. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>  <p>The score is a relative score, not an absolute score. The score may change based on improvements to Amazon Lex.</p>
    ///   - [`alternative_intents(Option<Vec<PredictedIntent>>)`](crate::output::PostTextOutput::alternative_intents): <p>One to four alternative intents that may be applicable to the user's intent.</p>  <p>Each alternative includes a score that indicates how confident Amazon Lex is that the intent matches the user's intent. The intents are sorted by the confidence score.</p>
    ///   - [`slots(Option<HashMap<String, String>>)`](crate::output::PostTextOutput::slots): <p> The intent slots that Amazon Lex detected from the user input in the conversation. </p>  <p>Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>
    ///   - [`session_attributes(Option<HashMap<String, String>>)`](crate::output::PostTextOutput::session_attributes): <p>A map of key-value pairs representing the session-specific context information.</p>
    ///   - [`message(Option<String>)`](crate::output::PostTextOutput::message): <p>The message to convey to the user. The message can come from the bot's configuration or from a Lambda function.</p>  <p>If the intent is not configured with a Lambda function, or if the Lambda function returned <code>Delegate</code> as the <code>dialogAction.type</code> its response, Amazon Lex decides on the next course of action and selects an appropriate message from the bot's configuration based on the current interaction context. For example, if Amazon Lex isn't able to understand user input, it uses a clarification prompt message.</p>  <p>When you create an intent you can assign messages to groups. When messages are assigned to groups Amazon Lex returns one message from each group in the response. The message field is an escaped JSON string containing the messages. For more information about the structure of the JSON string returned, see <code>msg-prompts-formats</code>.</p>  <p>If the Lambda function returns a message, Amazon Lex passes it to the client in its response.</p>
    ///   - [`sentiment_response(Option<SentimentResponse>)`](crate::output::PostTextOutput::sentiment_response): <p>The sentiment expressed in and utterance.</p>  <p>When the bot is configured to send utterances to Amazon Comprehend for sentiment analysis, this field contains the result of the analysis.</p>
    ///   - [`message_format(Option<MessageFormatType>)`](crate::output::PostTextOutput::message_format): <p>The format of the response message. One of the following values:</p>  <ul>   <li> <p> <code>PlainText</code> - The message contains plain UTF-8 text.</p> </li>   <li> <p> <code>CustomPayload</code> - The message is a custom format defined by the Lambda function.</p> </li>   <li> <p> <code>SSML</code> - The message contains text formatted for voice output.</p> </li>   <li> <p> <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.</p> </li>  </ul>
    ///   - [`dialog_state(Option<DialogState>)`](crate::output::PostTextOutput::dialog_state): <p> Identifies the current state of the user interaction. Amazon Lex returns one of the following values as <code>dialogState</code>. The client can optionally use this information to customize the user interface. </p>  <ul>   <li> <p> <code>ElicitIntent</code> - Amazon Lex wants to elicit user intent. </p> <p>For example, a user might utter an intent ("I want to order a pizza"). If Amazon Lex cannot infer the user intent from this utterance, it will return this dialogState.</p> </li>   <li> <p> <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response. </p> <p> For example, Amazon Lex wants user confirmation before fulfilling an intent. </p> <p>Instead of a simple "yes" or "no," a user might respond with additional information. For example, "yes, but make it thick crust pizza" or "no, I want to order a drink". Amazon Lex can process such additional information (in these examples, update the crust type slot value, or change intent from OrderPizza to OrderDrink).</p> </li>   <li> <p> <code>ElicitSlot</code> - Amazon Lex is expecting a slot value for the current intent. </p> <p>For example, suppose that in the response Amazon Lex sends this message: "What size pizza would you like?". A user might reply with the slot value (e.g., "medium"). The user might also provide additional information in the response (e.g., "medium thick crust pizza"). Amazon Lex can process such additional information appropriately. </p> </li>   <li> <p> <code>Fulfilled</code> - Conveys that the Lambda function configured for the intent has successfully fulfilled the intent. </p> </li>   <li> <p> <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent. </p> </li>   <li> <p> <code>Failed</code> - Conveys that the conversation with the user failed. </p> <p> This can happen for various reasons including that the user did not provide an appropriate response to prompts from the service (you can configure how many times Amazon Lex can prompt a user for specific information), or the Lambda function failed to fulfill the intent. </p> </li>  </ul>
    ///   - [`slot_to_elicit(Option<String>)`](crate::output::PostTextOutput::slot_to_elicit): <p>If the <code>dialogState</code> value is <code>ElicitSlot</code>, returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    ///   - [`response_card(Option<ResponseCard>)`](crate::output::PostTextOutput::response_card): <p>Represents the options that the user has to respond to the current prompt. Response Card can come from the bot configuration (in the Amazon Lex console, choose the settings button next to a slot) or from a code hook (Lambda function). </p>
    ///   - [`session_id(Option<String>)`](crate::output::PostTextOutput::session_id): <p>A unique identifier for the session.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::PostTextOutput::bot_version): <p>The version of the bot that responded to the conversation. You can use this information to help determine if one version of a bot is performing better than another version.</p>
    ///   - [`active_contexts(Option<Vec<ActiveContext>>)`](crate::output::PostTextOutput::active_contexts): <p>A list of active contexts for the session. A context can be set when an intent is fulfilled or by calling the <code>PostContent</code>, <code>PostText</code>, or <code>PutSession</code> operation.</p>  <p>You can use a context to control the intents that can follow up an intent, or to modify the operation of your application.</p>
    /// - On failure, responds with [`SdkError<PostTextError>`](crate::error::PostTextError)
    pub fn post_text(&self) -> fluent_builders::PostText {
        fluent_builders::PostText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSession`](crate::client::fluent_builders::PutSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::PutSession::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::PutSession::set_bot_name): <p>The name of the bot that contains the session data.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::PutSession::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::PutSession::set_bot_alias): <p>The alias in use for the bot that contains the session data.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::PutSession::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::PutSession::set_user_id): <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
    ///   - [`session_attributes(HashMap<String, String>)`](crate::client::fluent_builders::PutSession::session_attributes) / [`set_session_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutSession::set_session_attributes): <p>Map of key/value pairs representing the session-specific context information. It contains application information passed between Amazon Lex and a client application.</p>
    ///   - [`dialog_action(DialogAction)`](crate::client::fluent_builders::PutSession::dialog_action) / [`set_dialog_action(Option<DialogAction>)`](crate::client::fluent_builders::PutSession::set_dialog_action): <p>Sets the next action that the bot should take to fulfill the conversation.</p>
    ///   - [`recent_intent_summary_view(Vec<IntentSummary>)`](crate::client::fluent_builders::PutSession::recent_intent_summary_view) / [`set_recent_intent_summary_view(Option<Vec<IntentSummary>>)`](crate::client::fluent_builders::PutSession::set_recent_intent_summary_view): <p>A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to the list.</p>  <p>An intent that you modify or add to the list must make sense for the bot. For example, the intent name must be valid for the bot. You must provide valid values for:</p>  <ul>   <li> <p> <code>intentName</code> </p> </li>   <li> <p>slot names</p> </li>   <li> <p> <code>slotToElict</code> </p> </li>  </ul>  <p>If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code> request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the summary view, the next call to <code>GetSession</code> will only return one intent.</p>
    ///   - [`accept(impl Into<String>)`](crate::client::fluent_builders::PutSession::accept) / [`set_accept(Option<String>)`](crate::client::fluent_builders::PutSession::set_accept): <p>The message that Amazon Lex returns in the response can be either text or speech based depending on the value of this field.</p>  <ul>   <li> <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.</p> </li>   <li> <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech in the configuration that you specify. For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>   <li> <p>If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit, little endian format.</p> </li>   <li> <p>The following are the accepted values:</p>    <ul>     <li> <p> <code>audio/mpeg</code> </p> </li>     <li> <p> <code>audio/ogg</code> </p> </li>     <li> <p> <code>audio/pcm</code> </p> </li>     <li> <p> <code>audio/*</code> (defaults to mpeg)</p> </li>     <li> <p> <code>text/plain; charset=utf-8</code> </p> </li>    </ul> </li>  </ul>
    ///   - [`active_contexts(Vec<ActiveContext>)`](crate::client::fluent_builders::PutSession::active_contexts) / [`set_active_contexts(Option<Vec<ActiveContext>>)`](crate::client::fluent_builders::PutSession::set_active_contexts): <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>  <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
    /// - On success, responds with [`PutSessionOutput`](crate::output::PutSessionOutput) with field(s):
    ///   - [`content_type(Option<String>)`](crate::output::PutSessionOutput::content_type): <p>Content type as specified in the <code>Accept</code> HTTP header in the request.</p>
    ///   - [`intent_name(Option<String>)`](crate::output::PutSessionOutput::intent_name): <p>The name of the current intent.</p>
    ///   - [`slots(Option<String>)`](crate::output::PutSessionOutput::slots): <p>Map of zero or more intent slots Amazon Lex detected from the user input during the conversation.</p>  <p>Amazon Lex creates a resolution list containing likely values for a slot. The value that it returns is determined by the <code>valueSelectionStrategy</code> selected when the slot type was created or updated. If <code>valueSelectionStrategy</code> is set to <code>ORIGINAL_VALUE</code>, the value provided by the user is returned, if the user value is similar to the slot values. If <code>valueSelectionStrategy</code> is set to <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the resolution list or, if there is no resolution list, null. If you don't specify a <code>valueSelectionStrategy</code> the default is <code>ORIGINAL_VALUE</code>. </p>
    ///   - [`session_attributes(Option<String>)`](crate::output::PutSessionOutput::session_attributes): <p>Map of key/value pairs representing session-specific context information.</p>
    ///   - [`message(Option<String>)`](crate::output::PutSessionOutput::message): <p>The next message that should be presented to the user.</p>  <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419, es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the <code>message</code> field is null. You should use the <code>encodedMessage</code> field instead.</p>
    ///   - [`encoded_message(Option<String>)`](crate::output::PutSessionOutput::encoded_message): <p>The next message that should be presented to the user.</p>  <p>The <code>encodedMessage</code> field is base-64 encoded. You must decode the field before you can use the value.</p>
    ///   - [`message_format(Option<MessageFormatType>)`](crate::output::PutSessionOutput::message_format): <p>The format of the response message. One of the following values:</p>  <ul>   <li> <p> <code>PlainText</code> - The message contains plain UTF-8 text.</p> </li>   <li> <p> <code>CustomPayload</code> - The message is a custom format for the client.</p> </li>   <li> <p> <code>SSML</code> - The message contains text formatted for voice output.</p> </li>   <li> <p> <code>Composite</code> - The message contains an escaped JSON object containing one or more messages from the groups that messages were assigned to when the intent was created.</p> </li>  </ul>
    ///   - [`dialog_state(Option<DialogState>)`](crate::output::PutSessionOutput::dialog_state): <p></p>  <ul>   <li> <p> <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no" response to confirm the intent before fulfilling an intent.</p> </li>   <li> <p> <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.</p> </li>   <li> <p> <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for the current intent.</p> </li>   <li> <p> <code>Failed</code> - Conveys that the conversation with the user has failed. This can happen for various reasons, including the user does not provide an appropriate response to prompts from the service, or if the Lambda function fails to fulfill the intent.</p> </li>   <li> <p> <code>Fulfilled</code> - Conveys that the Lambda function has sucessfully fulfilled the intent.</p> </li>   <li> <p> <code>ReadyForFulfillment</code> - Conveys that the client has to fulfill the intent.</p> </li>  </ul>
    ///   - [`slot_to_elicit(Option<String>)`](crate::output::PutSessionOutput::slot_to_elicit): <p>If the <code>dialogState</code> is <code>ElicitSlot</code>, returns the name of the slot for which Amazon Lex is eliciting a value.</p>
    ///   - [`audio_stream(byte_stream::ByteStream)`](crate::output::PutSessionOutput::audio_stream): <p>The audio version of the message to convey to the user.</p>
    ///   - [`session_id(Option<String>)`](crate::output::PutSessionOutput::session_id): <p>A unique identifier for the session.</p>
    ///   - [`active_contexts(Option<String>)`](crate::output::PutSessionOutput::active_contexts): <p>A list of active contexts for the session.</p>
    /// - On failure, responds with [`SdkError<PutSessionError>`](crate::error::PutSessionError)
    pub fn put_session(&self) -> fluent_builders::PutSession {
        fluent_builders::PutSession::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DeleteSession`.
    ///
    /// <p>Removes session information for a specified bot, alias, and user ID. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_session_input::Builder,
    }
    impl DeleteSession {
        /// Creates a new `DeleteSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>The identifier of the user associated with the session data.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user associated with the session data.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSession`.
    ///
    /// <p>Returns session information for a specified bot, alias, and user ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_session_input::Builder,
    }
    impl GetSession {
        /// Creates a new `GetSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>A string used to filter the intents returned in the <code>recentIntentSummaryView</code> structure. </p>
        /// <p>When you specify a filter, only intents with their <code>checkpointLabel</code> field set to that string are returned.</p>
        pub fn checkpoint_label_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checkpoint_label_filter(input.into());
            self
        }
        /// <p>A string used to filter the intents returned in the <code>recentIntentSummaryView</code> structure. </p>
        /// <p>When you specify a filter, only intents with their <code>checkpointLabel</code> field set to that string are returned.</p>
        pub fn set_checkpoint_label_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_checkpoint_label_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostContent`.
    ///
    /// <p> Sends user input (text or speech) to Amazon Lex. Clients use this API to send text and audio requests to Amazon Lex at runtime. Amazon Lex interprets the user input using the machine learning model that it built for the bot. </p>
    /// <p>The <code>PostContent</code> operation supports audio input at 8kHz and 16kHz. You can use 8kHz audio to achieve higher speech recognition accuracy in telephone audio applications. </p>
    /// <p> In response, Amazon Lex returns the next message to convey to the user. Consider the following example messages: </p>
    /// <ul>
    /// <li> <p> For a user input "I would like a pizza," Amazon Lex might return a response with a message eliciting slot data (for example, <code>PizzaSize</code>): "What size pizza would you like?". </p> </li>
    /// <li> <p> After the user provides all of the pizza order information, Amazon Lex might return a response with a message to get user confirmation: "Order the pizza?". </p> </li>
    /// <li> <p> After the user replies "Yes" to the confirmation prompt, Amazon Lex might return a conclusion statement: "Thank you, your cheese pizza has been ordered.". </p> </li>
    /// </ul>
    /// <p> Not all Amazon Lex messages require a response from the user. For example, conclusion statements do not require a response. Some messages require only a yes or no response. In addition to the <code>message</code>, Amazon Lex provides additional context about the message in the response that you can use to enhance client behavior, such as displaying the appropriate client user interface. Consider the following examples: </p>
    /// <ul>
    /// <li> <p> If the message is to elicit slot data, Amazon Lex returns the following context information: </p>
    /// <ul>
    /// <li> <p> <code>x-amz-lex-dialog-state</code> header set to <code>ElicitSlot</code> </p> </li>
    /// <li> <p> <code>x-amz-lex-intent-name</code> header set to the intent name in the current context </p> </li>
    /// <li> <p> <code>x-amz-lex-slot-to-elicit</code> header set to the slot name for which the <code>message</code> is eliciting information </p> </li>
    /// <li> <p> <code>x-amz-lex-slots</code> header set to a map of slots configured for the intent with their current values </p> </li>
    /// </ul> </li>
    /// <li> <p> If the message is a confirmation prompt, the <code>x-amz-lex-dialog-state</code> header is set to <code>Confirmation</code> and the <code>x-amz-lex-slot-to-elicit</code> header is omitted. </p> </li>
    /// <li> <p> If the message is a clarification prompt configured for the intent, indicating that the user intent is not understood, the <code>x-amz-dialog-state</code> header is set to <code>ElicitIntent</code> and the <code>x-amz-slot-to-elicit</code> header is omitted. </p> </li>
    /// </ul>
    /// <p> In addition, Amazon Lex also returns your application-specific <code>sessionAttributes</code>. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html">Managing Conversation Context</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct PostContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::post_content_input::Builder,
    }
    impl PostContent {
        /// Creates a new `PostContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostContentOutput,
            aws_smithy_http::result::SdkError<crate::error::PostContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>Name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>Alias of the Amazon Lex bot.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>Alias of the Amazon Lex bot.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the following factors.</p>
        /// <ul>
        /// <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>
        /// <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>
        /// <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>
        /// <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the following factors.</p>
        /// <ul>
        /// <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>
        /// <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>
        /// <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>
        /// <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.</p>
        /// <p>Application-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn session_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_attributes(input.into());
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-session-attributes</code> HTTP header.</p>
        /// <p>Application-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>sessionAttributes</code> and <code>requestAttributes</code> headers is limited to 12 KB.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_attributes(input);
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.</p>
        /// <p>Request-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn request_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_attributes(input.into());
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-request-attributes</code> HTTP header.</p>
        /// <p>Request-specific information passed between Amazon Lex and a client application. The value must be a JSON serialized and base64 encoded map with string keys and values. The total size of the <code>requestAttributes</code> and <code>sessionAttributes</code> headers is limited to 12 KB.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_attributes(input);
            self
        }
        /// <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>
        /// <p> Indicates the audio format or text. The header value must start with one of the following prefixes: </p>
        /// <ul>
        /// <li> <p>PCM format, audio data must be in little-endian byte order.</p>
        /// <ul>
        /// <li> <p>audio/l16; rate=16000; channels=1</p> </li>
        /// <li> <p>audio/x-l16; sample-rate=16000; channel-count=1</p> </li>
        /// <li> <p>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false </p> </li>
        /// </ul> </li>
        /// <li> <p>Opus format</p>
        /// <ul>
        /// <li> <p>audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4</p> </li>
        /// </ul> </li>
        /// <li> <p>Text format</p>
        /// <ul>
        /// <li> <p>text/plain; charset=utf-8</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>
        /// <p> Indicates the audio format or text. The header value must start with one of the following prefixes: </p>
        /// <ul>
        /// <li> <p>PCM format, audio data must be in little-endian byte order.</p>
        /// <ul>
        /// <li> <p>audio/l16; rate=16000; channels=1</p> </li>
        /// <li> <p>audio/x-l16; sample-rate=16000; channel-count=1</p> </li>
        /// <li> <p>audio/lpcm; sample-rate=8000; sample-size-bits=16; channel-count=1; is-big-endian=false </p> </li>
        /// </ul> </li>
        /// <li> <p>Opus format</p>
        /// <ul>
        /// <li> <p>audio/x-cbr-opus-with-preamble; preamble-size=0; bit-rate=256000; frame-size-milliseconds=4</p> </li>
        /// </ul> </li>
        /// <li> <p>Text format</p>
        /// <ul>
        /// <li> <p>text/plain; charset=utf-8</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p> You pass this value as the <code>Accept</code> HTTP header. </p>
        /// <p> The message Amazon Lex returns in the response can be either text or speech based on the <code>Accept</code> HTTP header value in the request. </p>
        /// <ul>
        /// <li> <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response. </p> </li>
        /// <li> <p> If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech (using the configuration you specified in the <code>Accept</code> header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>
        /// <li> <p>If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little endian format. </p> </li>
        /// <li> <p>The following are the accepted values:</p>
        /// <ul>
        /// <li> <p>audio/mpeg</p> </li>
        /// <li> <p>audio/ogg</p> </li>
        /// <li> <p>audio/pcm</p> </li>
        /// <li> <p>text/plain; charset=utf-8</p> </li>
        /// <li> <p>audio/* (defaults to mpeg)</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept(input.into());
            self
        }
        /// <p> You pass this value as the <code>Accept</code> HTTP header. </p>
        /// <p> The message Amazon Lex returns in the response can be either text or speech based on the <code>Accept</code> HTTP header value in the request. </p>
        /// <ul>
        /// <li> <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response. </p> </li>
        /// <li> <p> If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech (using the configuration you specified in the <code>Accept</code> header). For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>
        /// <li> <p>If the value is <code>audio/pcm</code>, the speech returned is <code>audio/pcm</code> in 16-bit, little endian format. </p> </li>
        /// <li> <p>The following are the accepted values:</p>
        /// <ul>
        /// <li> <p>audio/mpeg</p> </li>
        /// <li> <p>audio/ogg</p> </li>
        /// <li> <p>audio/pcm</p> </li>
        /// <li> <p>text/plain; charset=utf-8</p> </li>
        /// <li> <p>audio/* (defaults to mpeg)</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accept(input);
            self
        }
        /// <p> User input in PCM or Opus audio format or text format as described in the <code>Content-Type</code> HTTP header. </p>
        /// <p>You can stream audio data to Amazon Lex or you can create a local buffer that captures all of the audio data before sending. In general, you get better performance if you stream audio data rather than buffering the data locally.</p>
        pub fn input_stream(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.input_stream(input);
            self
        }
        /// <p> User input in PCM or Opus audio format or text format as described in the <code>Content-Type</code> HTTP header. </p>
        /// <p>You can stream audio data to Amazon Lex or you can create a local buffer that captures all of the audio data before sending. In general, you get better performance if you stream audio data rather than buffering the data locally.</p>
        pub fn set_input_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_input_stream(input);
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.active_contexts(input.into());
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_active_contexts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostText`.
    ///
    /// <p>Sends user input to Amazon Lex. Client applications can use this API to send requests to Amazon Lex at runtime. Amazon Lex then interprets the user input using the machine learning model it built for the bot. </p>
    /// <p> In response, Amazon Lex returns the next <code>message</code> to convey to the user an optional <code>responseCard</code> to display. Consider the following example messages: </p>
    /// <ul>
    /// <li> <p> For a user input "I would like a pizza", Amazon Lex might return a response with a message eliciting slot data (for example, PizzaSize): "What size pizza would you like?" </p> </li>
    /// <li> <p> After the user provides all of the pizza order information, Amazon Lex might return a response with a message to obtain user confirmation "Proceed with the pizza order?". </p> </li>
    /// <li> <p> After the user replies to a confirmation prompt with a "yes", Amazon Lex might return a conclusion statement: "Thank you, your cheese pizza has been ordered.". </p> </li>
    /// </ul>
    /// <p> Not all Amazon Lex messages require a user response. For example, a conclusion statement does not require a response. Some messages require only a "yes" or "no" user response. In addition to the <code>message</code>, Amazon Lex provides additional context about the message in the response that you might use to enhance client behavior, for example, to display the appropriate client user interface. These are the <code>slotToElicit</code>, <code>dialogState</code>, <code>intentName</code>, and <code>slots</code> fields in the response. Consider the following examples: </p>
    /// <ul>
    /// <li> <p>If the message is to elicit slot data, Amazon Lex returns the following context information:</p>
    /// <ul>
    /// <li> <p> <code>dialogState</code> set to ElicitSlot </p> </li>
    /// <li> <p> <code>intentName</code> set to the intent name in the current context </p> </li>
    /// <li> <p> <code>slotToElicit</code> set to the slot name for which the <code>message</code> is eliciting information </p> </li>
    /// <li> <p> <code>slots</code> set to a map of slots, configured for the intent, with currently known values </p> </li>
    /// </ul> </li>
    /// <li> <p> If the message is a confirmation prompt, the <code>dialogState</code> is set to ConfirmIntent and <code>SlotToElicit</code> is set to null. </p> </li>
    /// <li> <p>If the message is a clarification prompt (configured for the intent) that indicates that user intent is not understood, the <code>dialogState</code> is set to ElicitIntent and <code>slotToElicit</code> is set to null. </p> </li>
    /// </ul>
    /// <p> In addition, Amazon Lex also returns your application-specific <code>sessionAttributes</code>. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html">Managing Conversation Context</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PostText {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::post_text_input::Builder,
    }
    impl PostText {
        /// Creates a new `PostText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostTextOutput,
            aws_smithy_http::result::SdkError<crate::error::PostTextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The alias of the Amazon Lex bot.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>The alias of the Amazon Lex bot.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the following factors.</p>
        /// <ul>
        /// <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>
        /// <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>
        /// <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>
        /// <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. At runtime, each request must contain the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the following factors.</p>
        /// <ul>
        /// <li> <p>The <code>userID</code> field must not contain any personally identifiable information of the user, for example, name, personal identification numbers, or other end user personal information.</p> </li>
        /// <li> <p>If you want a user to start a conversation on one device and continue on another device, use a user-specific identifier.</p> </li>
        /// <li> <p>If you want the same user to be able to have two independent conversations on two different devices, choose a device-specific identifier.</p> </li>
        /// <li> <p>A user can't have two independent conversations with two different versions of the same bot. For example, a user can't have a conversation with the PROD and BETA versions of the same bot. If you anticipate that a user will need to have conversation with two different versions, for example, while testing, include the bot alias in the user ID to separate the two conversations.</p> </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// Adds a key-value pair to `sessionAttributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Application-specific information passed between Amazon Lex and a client application.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.session_attributes(k.into(), v.into());
            self
        }
        /// <p>Application-specific information passed between Amazon Lex and a client application.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_session_attributes(input);
            self
        }
        /// Adds a key-value pair to `requestAttributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between Amazon Lex and a client application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.request_attributes(k.into(), v.into());
            self
        }
        /// <p>Request-specific information passed between Amazon Lex and a client application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special attributes. Don't create any request attributes with the prefix <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_request_attributes(input);
            self
        }
        /// <p>The text that the user entered (Amazon Lex interprets this text).</p>
        pub fn input_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.input_text(input.into());
            self
        }
        /// <p>The text that the user entered (Amazon Lex interprets this text).</p>
        pub fn set_input_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_input_text(input);
            self
        }
        /// Appends an item to `activeContexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: crate::model::ActiveContext) -> Self {
            self.inner = self.inner.active_contexts(input);
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.inner = self.inner.set_active_contexts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSession`.
    ///
    /// <p>Creates a new session or modifies an existing session with an Amazon Lex bot. Use this operation to enable your application to set the state of the bot.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-session-api.html">Managing Sessions</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSession {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_session_input::Builder,
    }
    impl PutSession {
        /// Creates a new `PutSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSessionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a user's conversation with your bot. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// Adds a key-value pair to `sessionAttributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Map of key/value pairs representing the session-specific context information. It contains application information passed between Amazon Lex and a client application.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.session_attributes(k.into(), v.into());
            self
        }
        /// <p>Map of key/value pairs representing the session-specific context information. It contains application information passed between Amazon Lex and a client application.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_session_attributes(input);
            self
        }
        /// <p>Sets the next action that the bot should take to fulfill the conversation.</p>
        pub fn dialog_action(mut self, input: crate::model::DialogAction) -> Self {
            self.inner = self.inner.dialog_action(input);
            self
        }
        /// <p>Sets the next action that the bot should take to fulfill the conversation.</p>
        pub fn set_dialog_action(
            mut self,
            input: std::option::Option<crate::model::DialogAction>,
        ) -> Self {
            self.inner = self.inner.set_dialog_action(input);
            self
        }
        /// Appends an item to `recentIntentSummaryView`.
        ///
        /// To override the contents of this collection use [`set_recent_intent_summary_view`](Self::set_recent_intent_summary_view).
        ///
        /// <p>A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to the list.</p>
        /// <p>An intent that you modify or add to the list must make sense for the bot. For example, the intent name must be valid for the bot. You must provide valid values for:</p>
        /// <ul>
        /// <li> <p> <code>intentName</code> </p> </li>
        /// <li> <p>slot names</p> </li>
        /// <li> <p> <code>slotToElict</code> </p> </li>
        /// </ul>
        /// <p>If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code> request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the summary view, the next call to <code>GetSession</code> will only return one intent.</p>
        pub fn recent_intent_summary_view(mut self, input: crate::model::IntentSummary) -> Self {
            self.inner = self.inner.recent_intent_summary_view(input);
            self
        }
        /// <p>A summary of the recent intents for the bot. You can use the intent summary view to set a checkpoint label on an intent and modify attributes of intents. You can also use it to remove or add intent summary objects to the list.</p>
        /// <p>An intent that you modify or add to the list must make sense for the bot. For example, the intent name must be valid for the bot. You must provide valid values for:</p>
        /// <ul>
        /// <li> <p> <code>intentName</code> </p> </li>
        /// <li> <p>slot names</p> </li>
        /// <li> <p> <code>slotToElict</code> </p> </li>
        /// </ul>
        /// <p>If you send the <code>recentIntentSummaryView</code> parameter in a <code>PutSession</code> request, the contents of the new summary view replaces the old summary view. For example, if a <code>GetSession</code> request returns three intents in the summary view and you call <code>PutSession</code> with one intent in the summary view, the next call to <code>GetSession</code> will only return one intent.</p>
        pub fn set_recent_intent_summary_view(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        ) -> Self {
            self.inner = self.inner.set_recent_intent_summary_view(input);
            self
        }
        /// <p>The message that Amazon Lex returns in the response can be either text or speech based depending on the value of this field.</p>
        /// <ul>
        /// <li> <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.</p> </li>
        /// <li> <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech in the configuration that you specify. For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>
        /// <li> <p>If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit, little endian format.</p> </li>
        /// <li> <p>The following are the accepted values:</p>
        /// <ul>
        /// <li> <p> <code>audio/mpeg</code> </p> </li>
        /// <li> <p> <code>audio/ogg</code> </p> </li>
        /// <li> <p> <code>audio/pcm</code> </p> </li>
        /// <li> <p> <code>audio/*</code> (defaults to mpeg)</p> </li>
        /// <li> <p> <code>text/plain; charset=utf-8</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.accept(input.into());
            self
        }
        /// <p>The message that Amazon Lex returns in the response can be either text or speech based depending on the value of this field.</p>
        /// <ul>
        /// <li> <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex returns text in the response.</p> </li>
        /// <li> <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech in the response. Amazon Lex uses Amazon Polly to generate the speech in the configuration that you specify. For example, if you specify <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the MPEG format.</p> </li>
        /// <li> <p>If the value is <code>audio/pcm</code>, the speech is returned as <code>audio/pcm</code> in 16-bit, little endian format.</p> </li>
        /// <li> <p>The following are the accepted values:</p>
        /// <ul>
        /// <li> <p> <code>audio/mpeg</code> </p> </li>
        /// <li> <p> <code>audio/ogg</code> </p> </li>
        /// <li> <p> <code>audio/pcm</code> </p> </li>
        /// <li> <p> <code>audio/*</code> (defaults to mpeg)</p> </li>
        /// <li> <p> <code>text/plain; charset=utf-8</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_accept(input);
            self
        }
        /// Appends an item to `activeContexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: crate::model::ActiveContext) -> Self {
            self.inner = self.inner.active_contexts(input);
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated when a previous intent is fulfilled, or by including the context in the request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current list of contexts for the session. If you specify an empty list, all contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.inner = self.inner.set_active_contexts(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
