// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct PutSessionOutput {
    /// <p>Content type as specified in the <code>Accept</code> HTTP header in
    /// the request.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>The name of the current intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>Map of zero or more intent slots Amazon Lex detected from the user input
    /// during the conversation.</p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code> the default is
    /// <code>ORIGINAL_VALUE</code>. </p>
    pub slots: std::option::Option<std::string::String>,
    /// <p>Map of key/value pairs representing session-specific context
    /// information.</p>
    pub session_attributes: std::option::Option<std::string::String>,
    /// <p>The next message that should be presented to the user.</p>
    /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>message</code> field is null. You should use the
    /// <code>encodedMessage</code> field instead.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The next message that should be presented to the user.</p>
    /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub encoded_message: std::option::Option<std::string::String>,
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format for
    /// the client.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub message_format: std::option::Option<crate::model::MessageFormatType>,
    /// <p></p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response to confirm the intent before fulfilling an intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's
    /// intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot
    /// for the current intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// has failed. This can happen for various reasons, including the user
    /// does not provide an appropriate response to prompts from the service,
    /// or if the Lambda function fails to fulfill the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function has
    /// sucessfully fulfilled the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the intent.</p>
    /// </li>
    /// </ul>
    pub dialog_state: std::option::Option<crate::model::DialogState>,
    /// <p>If the <code>dialogState</code> is <code>ElicitSlot</code>, returns
    /// the name of the slot for which Amazon Lex is eliciting a value.</p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
    /// <p>The audio version of the message to convey to the user.</p>
    pub audio_stream: aws_smithy_http::byte_stream::ByteStream,
    /// <p>A unique identifier for the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>A list of active contexts for the session.</p>
    pub active_contexts: std::option::Option<std::string::String>,
}
impl PutSessionOutput {
    /// <p>Content type as specified in the <code>Accept</code> HTTP header in
    /// the request.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The name of the current intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>Map of zero or more intent slots Amazon Lex detected from the user input
    /// during the conversation.</p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code> the default is
    /// <code>ORIGINAL_VALUE</code>. </p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p>Map of key/value pairs representing session-specific context
    /// information.</p>
    pub fn session_attributes(&self) -> std::option::Option<&str> {
        self.session_attributes.as_deref()
    }
    /// <p>The next message that should be presented to the user.</p>
    /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>message</code> field is null. You should use the
    /// <code>encodedMessage</code> field instead.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The next message that should be presented to the user.</p>
    /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub fn encoded_message(&self) -> std::option::Option<&str> {
        self.encoded_message.as_deref()
    }
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format for
    /// the client.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormatType> {
        self.message_format.as_ref()
    }
    /// <p></p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response to confirm the intent before fulfilling an intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's
    /// intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot
    /// for the current intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// has failed. This can happen for various reasons, including the user
    /// does not provide an appropriate response to prompts from the service,
    /// or if the Lambda function fails to fulfill the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function has
    /// sucessfully fulfilled the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the intent.</p>
    /// </li>
    /// </ul>
    pub fn dialog_state(&self) -> std::option::Option<&crate::model::DialogState> {
        self.dialog_state.as_ref()
    }
    /// <p>If the <code>dialogState</code> is <code>ElicitSlot</code>, returns
    /// the name of the slot for which Amazon Lex is eliciting a value.</p>
    pub fn slot_to_elicit(&self) -> std::option::Option<&str> {
        self.slot_to_elicit.as_deref()
    }
    /// <p>The audio version of the message to convey to the user.</p>
    pub fn audio_stream(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.audio_stream
    }
    /// <p>A unique identifier for the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>A list of active contexts for the session.</p>
    pub fn active_contexts(&self) -> std::option::Option<&str> {
        self.active_contexts.as_deref()
    }
}
impl std::fmt::Debug for PutSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSessionOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("slots", &self.slots);
        formatter.field("session_attributes", &self.session_attributes);
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.field("encoded_message", &"*** Sensitive Data Redacted ***");
        formatter.field("message_format", &self.message_format);
        formatter.field("dialog_state", &self.dialog_state);
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.field("audio_stream", &self.audio_stream);
        formatter.field("session_id", &self.session_id);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PutSessionOutput`](crate::output::PutSessionOutput)
pub mod put_session_output {
    /// A builder for [`PutSessionOutput`](crate::output::PutSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) session_attributes: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) encoded_message: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatType>,
        pub(crate) dialog_state: std::option::Option<crate::model::DialogState>,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
        pub(crate) audio_stream: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) active_contexts: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Content type as specified in the <code>Accept</code> HTTP header in
        /// the request.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>Content type as specified in the <code>Accept</code> HTTP header in
        /// the request.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The name of the current intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the current intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>Map of zero or more intent slots Amazon Lex detected from the user input
        /// during the conversation.</p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code> the default is
        /// <code>ORIGINAL_VALUE</code>. </p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>Map of zero or more intent slots Amazon Lex detected from the user input
        /// during the conversation.</p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code> the default is
        /// <code>ORIGINAL_VALUE</code>. </p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// <p>Map of key/value pairs representing session-specific context
        /// information.</p>
        pub fn session_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_attributes = Some(input.into());
            self
        }
        /// <p>Map of key/value pairs representing session-specific context
        /// information.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>The next message that should be presented to the user.</p>
        /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>message</code> field is null. You should use the
        /// <code>encodedMessage</code> field instead.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The next message that should be presented to the user.</p>
        /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>message</code> field is null. You should use the
        /// <code>encodedMessage</code> field instead.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The next message that should be presented to the user.</p>
        /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn encoded_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_message = Some(input.into());
            self
        }
        /// <p>The next message that should be presented to the user.</p>
        /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn set_encoded_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encoded_message = input;
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn message_format(mut self, input: crate::model::MessageFormatType) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatType>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// <p></p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response to confirm the intent before fulfilling an intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's
        /// intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot
        /// for the current intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// has failed. This can happen for various reasons, including the user
        /// does not provide an appropriate response to prompts from the service,
        /// or if the Lambda function fails to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function has
        /// sucessfully fulfilled the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the intent.</p>
        /// </li>
        /// </ul>
        pub fn dialog_state(mut self, input: crate::model::DialogState) -> Self {
            self.dialog_state = Some(input);
            self
        }
        /// <p></p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response to confirm the intent before fulfilling an intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's
        /// intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot
        /// for the current intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// has failed. This can happen for various reasons, including the user
        /// does not provide an appropriate response to prompts from the service,
        /// or if the Lambda function fails to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function has
        /// sucessfully fulfilled the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the intent.</p>
        /// </li>
        /// </ul>
        pub fn set_dialog_state(
            mut self,
            input: std::option::Option<crate::model::DialogState>,
        ) -> Self {
            self.dialog_state = input;
            self
        }
        /// <p>If the <code>dialogState</code> is <code>ElicitSlot</code>, returns
        /// the name of the slot for which Amazon Lex is eliciting a value.</p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p>If the <code>dialogState</code> is <code>ElicitSlot</code>, returns
        /// the name of the slot for which Amazon Lex is eliciting a value.</p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// <p>The audio version of the message to convey to the user.</p>
        pub fn audio_stream(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.audio_stream = Some(input);
            self
        }
        /// <p>The audio version of the message to convey to the user.</p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.audio_stream = input;
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>A list of active contexts for the session.</p>
        pub fn active_contexts(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_contexts = Some(input.into());
            self
        }
        /// <p>A list of active contexts for the session.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSessionOutput`](crate::output::PutSessionOutput)
        pub fn build(self) -> crate::output::PutSessionOutput {
            crate::output::PutSessionOutput {
                content_type: self.content_type,
                intent_name: self.intent_name,
                slots: self.slots,
                session_attributes: self.session_attributes,
                message: self.message,
                encoded_message: self.encoded_message,
                message_format: self.message_format,
                dialog_state: self.dialog_state,
                slot_to_elicit: self.slot_to_elicit,
                audio_stream: self.audio_stream.unwrap_or_default(),
                session_id: self.session_id,
                active_contexts: self.active_contexts,
            }
        }
    }
}
impl PutSessionOutput {
    /// Creates a new builder-style object to manufacture [`PutSessionOutput`](crate::output::PutSessionOutput)
    pub fn builder() -> crate::output::put_session_output::Builder {
        crate::output::put_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostTextOutput {
    /// <p>The current user intent that Amazon Lex is aware of.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>Provides a score that indicates how confident Amazon Lex is that the
    /// returned intent is the one that matches the user's intent. The score is
    /// between 0.0 and 1.0. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
    /// <p>The score is a relative score, not an absolute score. The score may
    /// change based on improvements to Amazon Lex.</p>
    pub nlu_intent_confidence: std::option::Option<crate::model::IntentConfidence>,
    /// <p>One to four alternative intents that may be applicable to the user's
    /// intent.</p>
    /// <p>Each alternative includes a score that indicates how confident Amazon Lex
    /// is that the intent matches the user's intent. The intents are sorted by
    /// the confidence score.</p>
    pub alternative_intents: std::option::Option<std::vec::Vec<crate::model::PredictedIntent>>,
    /// <p> The intent slots that Amazon Lex detected from the user input in the
    /// conversation. </p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code>, the default is
    /// <code>ORIGINAL_VALUE</code>.</p>
    pub slots:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A map of key-value pairs representing the session-specific context
    /// information.</p>
    pub session_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> its response, Amazon Lex decides on the next
    /// course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The sentiment expressed in and utterance.</p>
    /// <p>When the bot is configured to send utterances to Amazon Comprehend for
    /// sentiment analysis, this field contains the result of the analysis.</p>
    pub sentiment_response: std::option::Option<crate::model::SentimentResponse>,
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format
    /// defined by the Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub message_format: std::option::Option<crate::model::MessageFormatType>,
    /// <p> Identifies the current state of the user interaction. Amazon Lex returns
    /// one of the following values as <code>dialogState</code>. The client can
    /// optionally use this information to customize the user interface. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit user intent. </p>
    /// <p>For example, a user might utter an intent ("I want to order a
    /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
    /// will return this dialogState.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response. </p>
    /// <p> For example, Amazon Lex wants user confirmation before fulfilling an
    /// intent. </p>
    /// <p>Instead of a simple "yes" or "no," a user might respond with
    /// additional information. For example, "yes, but make it thick crust
    /// pizza" or "no, I want to order a drink". Amazon Lex can process such
    /// additional information (in these examples, update the crust type slot
    /// value, or change intent from OrderPizza to OrderDrink).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting a slot value for the
    /// current intent. </p>
    /// <p>For example, suppose that in the response Amazon Lex sends this
    /// message: "What size pizza would you like?". A user might reply with
    /// the slot value (e.g., "medium"). The user might also provide
    /// additional information in the response (e.g., "medium thick crust
    /// pizza"). Amazon Lex can process such additional information appropriately.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function configured
    /// for the intent has successfully fulfilled the intent. </p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// failed. </p>
    /// <p> This can happen for various reasons including that the user did
    /// not provide an appropriate response to prompts from the service (you
    /// can configure how many times Amazon Lex can prompt a user for specific
    /// information), or the Lambda function failed to fulfill the intent.
    /// </p>
    /// </li>
    /// </ul>
    pub dialog_state: std::option::Option<crate::model::DialogState>,
    /// <p>If the <code>dialogState</code> value is <code>ElicitSlot</code>,
    /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
    /// <p>Represents the options that the user has to respond to the current
    /// prompt. Response Card can come from the bot configuration (in the
    /// Amazon Lex console, choose the settings button next to a slot) or from a
    /// code hook (Lambda function). </p>
    pub response_card: std::option::Option<crate::model::ResponseCard>,
    /// <p>A unique identifier for the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that responded to the conversation. You can use
    /// this information to help determine if one version of a bot is performing
    /// better than another version.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
}
impl PostTextOutput {
    /// <p>The current user intent that Amazon Lex is aware of.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>Provides a score that indicates how confident Amazon Lex is that the
    /// returned intent is the one that matches the user's intent. The score is
    /// between 0.0 and 1.0. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
    /// <p>The score is a relative score, not an absolute score. The score may
    /// change based on improvements to Amazon Lex.</p>
    pub fn nlu_intent_confidence(&self) -> std::option::Option<&crate::model::IntentConfidence> {
        self.nlu_intent_confidence.as_ref()
    }
    /// <p>One to four alternative intents that may be applicable to the user's
    /// intent.</p>
    /// <p>Each alternative includes a score that indicates how confident Amazon Lex
    /// is that the intent matches the user's intent. The intents are sorted by
    /// the confidence score.</p>
    pub fn alternative_intents(&self) -> std::option::Option<&[crate::model::PredictedIntent]> {
        self.alternative_intents.as_deref()
    }
    /// <p> The intent slots that Amazon Lex detected from the user input in the
    /// conversation. </p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code>, the default is
    /// <code>ORIGINAL_VALUE</code>.</p>
    pub fn slots(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.slots.as_ref()
    }
    /// <p>A map of key-value pairs representing the session-specific context
    /// information.</p>
    pub fn session_attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.session_attributes.as_ref()
    }
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> its response, Amazon Lex decides on the next
    /// course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The sentiment expressed in and utterance.</p>
    /// <p>When the bot is configured to send utterances to Amazon Comprehend for
    /// sentiment analysis, this field contains the result of the analysis.</p>
    pub fn sentiment_response(&self) -> std::option::Option<&crate::model::SentimentResponse> {
        self.sentiment_response.as_ref()
    }
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format
    /// defined by the Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormatType> {
        self.message_format.as_ref()
    }
    /// <p> Identifies the current state of the user interaction. Amazon Lex returns
    /// one of the following values as <code>dialogState</code>. The client can
    /// optionally use this information to customize the user interface. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit user intent. </p>
    /// <p>For example, a user might utter an intent ("I want to order a
    /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
    /// will return this dialogState.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response. </p>
    /// <p> For example, Amazon Lex wants user confirmation before fulfilling an
    /// intent. </p>
    /// <p>Instead of a simple "yes" or "no," a user might respond with
    /// additional information. For example, "yes, but make it thick crust
    /// pizza" or "no, I want to order a drink". Amazon Lex can process such
    /// additional information (in these examples, update the crust type slot
    /// value, or change intent from OrderPizza to OrderDrink).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting a slot value for the
    /// current intent. </p>
    /// <p>For example, suppose that in the response Amazon Lex sends this
    /// message: "What size pizza would you like?". A user might reply with
    /// the slot value (e.g., "medium"). The user might also provide
    /// additional information in the response (e.g., "medium thick crust
    /// pizza"). Amazon Lex can process such additional information appropriately.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function configured
    /// for the intent has successfully fulfilled the intent. </p>
    ///
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// failed. </p>
    /// <p> This can happen for various reasons including that the user did
    /// not provide an appropriate response to prompts from the service (you
    /// can configure how many times Amazon Lex can prompt a user for specific
    /// information), or the Lambda function failed to fulfill the intent.
    /// </p>
    /// </li>
    /// </ul>
    pub fn dialog_state(&self) -> std::option::Option<&crate::model::DialogState> {
        self.dialog_state.as_ref()
    }
    /// <p>If the <code>dialogState</code> value is <code>ElicitSlot</code>,
    /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    pub fn slot_to_elicit(&self) -> std::option::Option<&str> {
        self.slot_to_elicit.as_deref()
    }
    /// <p>Represents the options that the user has to respond to the current
    /// prompt. Response Card can come from the bot configuration (in the
    /// Amazon Lex console, choose the settings button next to a slot) or from a
    /// code hook (Lambda function). </p>
    pub fn response_card(&self) -> std::option::Option<&crate::model::ResponseCard> {
        self.response_card.as_ref()
    }
    /// <p>A unique identifier for the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The version of the bot that responded to the conversation. You can use
    /// this information to help determine if one version of a bot is performing
    /// better than another version.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub fn active_contexts(&self) -> std::option::Option<&[crate::model::ActiveContext]> {
        self.active_contexts.as_deref()
    }
}
impl std::fmt::Debug for PostTextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostTextOutput");
        formatter.field("intent_name", &self.intent_name);
        formatter.field("nlu_intent_confidence", &self.nlu_intent_confidence);
        formatter.field("alternative_intents", &self.alternative_intents);
        formatter.field("slots", &"*** Sensitive Data Redacted ***");
        formatter.field("session_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.field("sentiment_response", &self.sentiment_response);
        formatter.field("message_format", &self.message_format);
        formatter.field("dialog_state", &self.dialog_state);
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.field("response_card", &self.response_card);
        formatter.field("session_id", &self.session_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PostTextOutput`](crate::output::PostTextOutput)
pub mod post_text_output {
    /// A builder for [`PostTextOutput`](crate::output::PostTextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence: std::option::Option<crate::model::IntentConfidence>,
        pub(crate) alternative_intents:
            std::option::Option<std::vec::Vec<crate::model::PredictedIntent>>,
        pub(crate) slots: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) session_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) sentiment_response: std::option::Option<crate::model::SentimentResponse>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatType>,
        pub(crate) dialog_state: std::option::Option<crate::model::DialogState>,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
        pub(crate) response_card: std::option::Option<crate::model::ResponseCard>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
    }
    impl Builder {
        /// <p>The current user intent that Amazon Lex is aware of.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The current user intent that Amazon Lex is aware of.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>Provides a score that indicates how confident Amazon Lex is that the
        /// returned intent is the one that matches the user's intent. The score is
        /// between 0.0 and 1.0. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>The score is a relative score, not an absolute score. The score may
        /// change based on improvements to Amazon Lex.</p>
        pub fn nlu_intent_confidence(mut self, input: crate::model::IntentConfidence) -> Self {
            self.nlu_intent_confidence = Some(input);
            self
        }
        /// <p>Provides a score that indicates how confident Amazon Lex is that the
        /// returned intent is the one that matches the user's intent. The score is
        /// between 0.0 and 1.0. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>The score is a relative score, not an absolute score. The score may
        /// change based on improvements to Amazon Lex.</p>
        pub fn set_nlu_intent_confidence(
            mut self,
            input: std::option::Option<crate::model::IntentConfidence>,
        ) -> Self {
            self.nlu_intent_confidence = input;
            self
        }
        /// Appends an item to `alternative_intents`.
        ///
        /// To override the contents of this collection use [`set_alternative_intents`](Self::set_alternative_intents).
        ///
        /// <p>One to four alternative intents that may be applicable to the user's
        /// intent.</p>
        /// <p>Each alternative includes a score that indicates how confident Amazon Lex
        /// is that the intent matches the user's intent. The intents are sorted by
        /// the confidence score.</p>
        pub fn alternative_intents(
            mut self,
            input: impl Into<crate::model::PredictedIntent>,
        ) -> Self {
            let mut v = self.alternative_intents.unwrap_or_default();
            v.push(input.into());
            self.alternative_intents = Some(v);
            self
        }
        /// <p>One to four alternative intents that may be applicable to the user's
        /// intent.</p>
        /// <p>Each alternative includes a score that indicates how confident Amazon Lex
        /// is that the intent matches the user's intent. The intents are sorted by
        /// the confidence score.</p>
        pub fn set_alternative_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PredictedIntent>>,
        ) -> Self {
            self.alternative_intents = input;
            self
        }
        /// Adds a key-value pair to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p> The intent slots that Amazon Lex detected from the user input in the
        /// conversation. </p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code>, the default is
        /// <code>ORIGINAL_VALUE</code>.</p>
        pub fn slots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.slots = Some(hash_map);
            self
        }
        /// <p> The intent slots that Amazon Lex detected from the user input in the
        /// conversation. </p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code>, the default is
        /// <code>ORIGINAL_VALUE</code>.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Adds a key-value pair to `session_attributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>A map of key-value pairs representing the session-specific context
        /// information.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.session_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.session_attributes = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs representing the session-specific context
        /// information.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> its response, Amazon Lex decides on the next
        /// course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> its response, Amazon Lex decides on the next
        /// course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The sentiment expressed in and utterance.</p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend for
        /// sentiment analysis, this field contains the result of the analysis.</p>
        pub fn sentiment_response(mut self, input: crate::model::SentimentResponse) -> Self {
            self.sentiment_response = Some(input);
            self
        }
        /// <p>The sentiment expressed in and utterance.</p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend for
        /// sentiment analysis, this field contains the result of the analysis.</p>
        pub fn set_sentiment_response(
            mut self,
            input: std::option::Option<crate::model::SentimentResponse>,
        ) -> Self {
            self.sentiment_response = input;
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format
        /// defined by the Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn message_format(mut self, input: crate::model::MessageFormatType) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format
        /// defined by the Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatType>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// <p> Identifies the current state of the user interaction. Amazon Lex returns
        /// one of the following values as <code>dialogState</code>. The client can
        /// optionally use this information to customize the user interface. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit user intent. </p>
        /// <p>For example, a user might utter an intent ("I want to order a
        /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
        /// will return this dialogState.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response. </p>
        /// <p> For example, Amazon Lex wants user confirmation before fulfilling an
        /// intent. </p>
        /// <p>Instead of a simple "yes" or "no," a user might respond with
        /// additional information. For example, "yes, but make it thick crust
        /// pizza" or "no, I want to order a drink". Amazon Lex can process such
        /// additional information (in these examples, update the crust type slot
        /// value, or change intent from OrderPizza to OrderDrink).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting a slot value for the
        /// current intent. </p>
        /// <p>For example, suppose that in the response Amazon Lex sends this
        /// message: "What size pizza would you like?". A user might reply with
        /// the slot value (e.g., "medium"). The user might also provide
        /// additional information in the response (e.g., "medium thick crust
        /// pizza"). Amazon Lex can process such additional information appropriately.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function configured
        /// for the intent has successfully fulfilled the intent. </p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// failed. </p>
        /// <p> This can happen for various reasons including that the user did
        /// not provide an appropriate response to prompts from the service (you
        /// can configure how many times Amazon Lex can prompt a user for specific
        /// information), or the Lambda function failed to fulfill the intent.
        /// </p>
        /// </li>
        /// </ul>
        pub fn dialog_state(mut self, input: crate::model::DialogState) -> Self {
            self.dialog_state = Some(input);
            self
        }
        /// <p> Identifies the current state of the user interaction. Amazon Lex returns
        /// one of the following values as <code>dialogState</code>. The client can
        /// optionally use this information to customize the user interface. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit user intent. </p>
        /// <p>For example, a user might utter an intent ("I want to order a
        /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
        /// will return this dialogState.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response. </p>
        /// <p> For example, Amazon Lex wants user confirmation before fulfilling an
        /// intent. </p>
        /// <p>Instead of a simple "yes" or "no," a user might respond with
        /// additional information. For example, "yes, but make it thick crust
        /// pizza" or "no, I want to order a drink". Amazon Lex can process such
        /// additional information (in these examples, update the crust type slot
        /// value, or change intent from OrderPizza to OrderDrink).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting a slot value for the
        /// current intent. </p>
        /// <p>For example, suppose that in the response Amazon Lex sends this
        /// message: "What size pizza would you like?". A user might reply with
        /// the slot value (e.g., "medium"). The user might also provide
        /// additional information in the response (e.g., "medium thick crust
        /// pizza"). Amazon Lex can process such additional information appropriately.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function configured
        /// for the intent has successfully fulfilled the intent. </p>
        ///
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// failed. </p>
        /// <p> This can happen for various reasons including that the user did
        /// not provide an appropriate response to prompts from the service (you
        /// can configure how many times Amazon Lex can prompt a user for specific
        /// information), or the Lambda function failed to fulfill the intent.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_dialog_state(
            mut self,
            input: std::option::Option<crate::model::DialogState>,
        ) -> Self {
            self.dialog_state = input;
            self
        }
        /// <p>If the <code>dialogState</code> value is <code>ElicitSlot</code>,
        /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p>If the <code>dialogState</code> value is <code>ElicitSlot</code>,
        /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// <p>Represents the options that the user has to respond to the current
        /// prompt. Response Card can come from the bot configuration (in the
        /// Amazon Lex console, choose the settings button next to a slot) or from a
        /// code hook (Lambda function). </p>
        pub fn response_card(mut self, input: crate::model::ResponseCard) -> Self {
            self.response_card = Some(input);
            self
        }
        /// <p>Represents the options that the user has to respond to the current
        /// prompt. Response Card can come from the bot configuration (in the
        /// Amazon Lex console, choose the settings button next to a slot) or from a
        /// code hook (Lambda function). </p>
        pub fn set_response_card(
            mut self,
            input: std::option::Option<crate::model::ResponseCard>,
        ) -> Self {
            self.response_card = input;
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>The version of the bot that responded to the conversation. You can use
        /// this information to help determine if one version of a bot is performing
        /// better than another version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that responded to the conversation. You can use
        /// this information to help determine if one version of a bot is performing
        /// better than another version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Appends an item to `active_contexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn active_contexts(mut self, input: impl Into<crate::model::ActiveContext>) -> Self {
            let mut v = self.active_contexts.unwrap_or_default();
            v.push(input.into());
            self.active_contexts = Some(v);
            self
        }
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PostTextOutput`](crate::output::PostTextOutput)
        pub fn build(self) -> crate::output::PostTextOutput {
            crate::output::PostTextOutput {
                intent_name: self.intent_name,
                nlu_intent_confidence: self.nlu_intent_confidence,
                alternative_intents: self.alternative_intents,
                slots: self.slots,
                session_attributes: self.session_attributes,
                message: self.message,
                sentiment_response: self.sentiment_response,
                message_format: self.message_format,
                dialog_state: self.dialog_state,
                slot_to_elicit: self.slot_to_elicit,
                response_card: self.response_card,
                session_id: self.session_id,
                bot_version: self.bot_version,
                active_contexts: self.active_contexts,
            }
        }
    }
}
impl PostTextOutput {
    /// Creates a new builder-style object to manufacture [`PostTextOutput`](crate::output::PostTextOutput)
    pub fn builder() -> crate::output::post_text_output::Builder {
        crate::output::post_text_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct PostContentOutput {
    /// <p>Content type as specified in the <code>Accept</code> HTTP header in
    /// the request.</p>
    pub content_type: std::option::Option<std::string::String>,
    /// <p>Current user intent that Amazon Lex is aware of.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>Provides a score that indicates how confident Amazon Lex is that the
    /// returned intent is the one that matches the user's intent. The score is
    /// between 0.0 and 1.0.</p>
    /// <p>The score is a relative score, not an absolute score. The score may
    /// change based on improvements to Amazon Lex. </p>
    pub nlu_intent_confidence: std::option::Option<std::string::String>,
    /// <p>One to four alternative intents that may be applicable to the user's
    /// intent.</p>
    /// <p>Each alternative includes a score that indicates how confident Amazon Lex
    /// is that the intent matches the user's intent. The intents are sorted by
    /// the confidence score.</p>
    pub alternative_intents: std::option::Option<std::string::String>,
    /// <p>Map of zero or more intent slots (name/value pairs) Amazon Lex detected
    /// from the user input during the conversation. The field is base-64
    /// encoded.</p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code>, the default is
    /// <code>ORIGINAL_VALUE</code>.</p>
    pub slots: std::option::Option<std::string::String>,
    /// <p> Map of key/value pairs representing the session-specific context
    /// information. </p>
    pub session_attributes: std::option::Option<std::string::String>,
    /// <p>The sentiment expressed in an utterance.</p>
    /// <p>When the bot is configured to send utterances to Amazon Comprehend for
    /// sentiment analysis, this field contains the result of the analysis.</p>
    pub sentiment_response: std::option::Option<std::string::String>,
    /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>message</code> field is null. You should use the
    /// <code>encodedMessage</code> field instead.</p>
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
    /// next course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
    /// next course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub encoded_message: std::option::Option<std::string::String>,
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format for
    /// the client.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub message_format: std::option::Option<crate::model::MessageFormatType>,
    /// <p>Identifies the current state of the user interaction. Amazon Lex returns
    /// one of the following values as <code>dialogState</code>. The client can
    /// optionally use this information to customize the user interface. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
    /// Consider the following examples: </p>
    /// <p> For example, a user might utter an intent ("I want to order a
    /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
    /// will return this dialog state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response. </p>
    /// <p>For example, Amazon Lex wants user confirmation before fulfilling an
    /// intent. Instead of a simple "yes" or "no" response, a user might
    /// respond with additional information. For example, "yes, but make it a
    /// thick crust pizza" or "no, I want to order a drink." Amazon Lex can process
    /// such additional information (in these examples, update the crust type
    /// slot or change the intent from OrderPizza to OrderDrink). </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for
    /// the current intent. </p>
    /// <p> For example, suppose that in the response Amazon Lex sends this
    /// message: "What size pizza would you like?". A user might reply with
    /// the slot value (e.g., "medium"). The user might also provide
    /// additional information in the response (e.g., "medium thick crust
    /// pizza"). Amazon Lex can process such additional information appropriately.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function has
    /// successfully fulfilled the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the request. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// failed. </p>
    /// <p> This can happen for various reasons, including that the user does
    /// not provide an appropriate response to prompts from the service (you
    /// can configure how many times Amazon Lex can prompt a user for specific
    /// information), or if the Lambda function fails to fulfill the intent.
    /// </p>
    /// </li>
    /// </ul>
    pub dialog_state: std::option::Option<crate::model::DialogState>,
    /// <p> If the <code>dialogState</code> value is <code>ElicitSlot</code>,
    /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
    /// <p>The text used to process the request.</p>
    /// <p>You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>inputTranscript</code> field is null. You should use the
    /// <code>encodedInputTranscript</code> field instead.</p>
    /// <p>If the input was an audio stream, the <code>inputTranscript</code>
    /// field contains the text extracted from the audio stream. This is the text
    /// that is actually processed to recognize intents and slot values. You can
    /// use this information to determine if Amazon Lex is correctly processing the
    /// audio that you send.</p>
    pub input_transcript: std::option::Option<std::string::String>,
    /// <p>The text used to process the request.</p>
    /// <p>If the input was an audio stream, the
    /// <code>encodedInputTranscript</code> field contains the text extracted
    /// from the audio stream. This is the text that is actually processed to
    /// recognize intents and slot values. You can use this information to
    /// determine if Amazon Lex is correctly processing the audio that you send.</p>
    /// <p>The <code>encodedInputTranscript</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub encoded_input_transcript: std::option::Option<std::string::String>,
    /// <p>The prompt (or statement) to convey to the user. This is based on the
    /// bot configuration and context. For example, if Amazon Lex did not understand
    /// the user intent, it sends the <code>clarificationPrompt</code> configured
    /// for the bot. If the intent requires confirmation before taking the
    /// fulfillment action, it sends the <code>confirmationPrompt</code>. Another
    /// example: Suppose that the Lambda function successfully fulfilled the
    /// intent, and sent a message to convey to the user. Then Amazon Lex sends that
    /// message in the response. </p>
    pub audio_stream: aws_smithy_http::byte_stream::ByteStream,
    /// <p>The version of the bot that responded to the conversation. You can use
    /// this information to help determine if one version of a bot is performing
    /// better than another version.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub active_contexts: std::option::Option<std::string::String>,
}
impl PostContentOutput {
    /// <p>Content type as specified in the <code>Accept</code> HTTP header in
    /// the request.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>Current user intent that Amazon Lex is aware of.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>Provides a score that indicates how confident Amazon Lex is that the
    /// returned intent is the one that matches the user's intent. The score is
    /// between 0.0 and 1.0.</p>
    /// <p>The score is a relative score, not an absolute score. The score may
    /// change based on improvements to Amazon Lex. </p>
    pub fn nlu_intent_confidence(&self) -> std::option::Option<&str> {
        self.nlu_intent_confidence.as_deref()
    }
    /// <p>One to four alternative intents that may be applicable to the user's
    /// intent.</p>
    /// <p>Each alternative includes a score that indicates how confident Amazon Lex
    /// is that the intent matches the user's intent. The intents are sorted by
    /// the confidence score.</p>
    pub fn alternative_intents(&self) -> std::option::Option<&str> {
        self.alternative_intents.as_deref()
    }
    /// <p>Map of zero or more intent slots (name/value pairs) Amazon Lex detected
    /// from the user input during the conversation. The field is base-64
    /// encoded.</p>
    /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
    /// The value that it returns is determined by the
    /// <code>valueSelectionStrategy</code> selected when the slot type was
    /// created or updated. If <code>valueSelectionStrategy</code> is set to
    /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
    /// if the user value is similar to the slot values. If
    /// <code>valueSelectionStrategy</code> is set to
    /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
    /// resolution list or, if there is no resolution list, null. If you don't
    /// specify a <code>valueSelectionStrategy</code>, the default is
    /// <code>ORIGINAL_VALUE</code>.</p>
    pub fn slots(&self) -> std::option::Option<&str> {
        self.slots.as_deref()
    }
    /// <p> Map of key/value pairs representing the session-specific context
    /// information. </p>
    pub fn session_attributes(&self) -> std::option::Option<&str> {
        self.session_attributes.as_deref()
    }
    /// <p>The sentiment expressed in an utterance.</p>
    /// <p>When the bot is configured to send utterances to Amazon Comprehend for
    /// sentiment analysis, this field contains the result of the analysis.</p>
    pub fn sentiment_response(&self) -> std::option::Option<&str> {
        self.sentiment_response.as_deref()
    }
    /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>message</code> field is null. You should use the
    /// <code>encodedMessage</code> field instead.</p>
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
    /// next course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The message to convey to the user. The message can come from the bot's
    /// configuration or from a Lambda function.</p>
    /// <p>If the intent is not configured with a Lambda function, or if the Lambda
    /// function returned <code>Delegate</code> as the
    /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
    /// next course of action and selects an appropriate message from the bot's
    /// configuration based on the current interaction context. For example, if
    /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
    /// message.</p>
    /// <p>When you create an intent you can assign messages to groups. When
    /// messages are assigned to groups Amazon Lex returns one message from each group
    /// in the response. The message field is an escaped JSON string containing
    /// the messages. For more information about the structure of the JSON string
    /// returned, see <a>msg-prompts-formats</a>.</p>
    /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
    /// in its response.</p>
    /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub fn encoded_message(&self) -> std::option::Option<&str> {
        self.encoded_message.as_deref()
    }
    /// <p>The format of the response message. One of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format for
    /// the client.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages from the groups that messages
    /// were assigned to when the intent was created.</p>
    /// </li>
    /// </ul>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormatType> {
        self.message_format.as_ref()
    }
    /// <p>Identifies the current state of the user interaction. Amazon Lex returns
    /// one of the following values as <code>dialogState</code>. The client can
    /// optionally use this information to customize the user interface. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
    /// Consider the following examples: </p>
    /// <p> For example, a user might utter an intent ("I want to order a
    /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
    /// will return this dialog state. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
    /// response. </p>
    /// <p>For example, Amazon Lex wants user confirmation before fulfilling an
    /// intent. Instead of a simple "yes" or "no" response, a user might
    /// respond with additional information. For example, "yes, but make it a
    /// thick crust pizza" or "no, I want to order a drink." Amazon Lex can process
    /// such additional information (in these examples, update the crust type
    /// slot or change the intent from OrderPizza to OrderDrink). </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for
    /// the current intent. </p>
    /// <p> For example, suppose that in the response Amazon Lex sends this
    /// message: "What size pizza would you like?". A user might reply with
    /// the slot value (e.g., "medium"). The user might also provide
    /// additional information in the response (e.g., "medium thick crust
    /// pizza"). Amazon Lex can process such additional information appropriately.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - Conveys that the Lambda function has
    /// successfully fulfilled the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - Conveys that the client has to
    /// fulfill the request. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - Conveys that the conversation with the user
    /// failed. </p>
    /// <p> This can happen for various reasons, including that the user does
    /// not provide an appropriate response to prompts from the service (you
    /// can configure how many times Amazon Lex can prompt a user for specific
    /// information), or if the Lambda function fails to fulfill the intent.
    /// </p>
    /// </li>
    /// </ul>
    pub fn dialog_state(&self) -> std::option::Option<&crate::model::DialogState> {
        self.dialog_state.as_ref()
    }
    /// <p> If the <code>dialogState</code> value is <code>ElicitSlot</code>,
    /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
    pub fn slot_to_elicit(&self) -> std::option::Option<&str> {
        self.slot_to_elicit.as_deref()
    }
    /// <p>The text used to process the request.</p>
    /// <p>You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419,
    /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
    /// <code>inputTranscript</code> field is null. You should use the
    /// <code>encodedInputTranscript</code> field instead.</p>
    /// <p>If the input was an audio stream, the <code>inputTranscript</code>
    /// field contains the text extracted from the audio stream. This is the text
    /// that is actually processed to recognize intents and slot values. You can
    /// use this information to determine if Amazon Lex is correctly processing the
    /// audio that you send.</p>
    pub fn input_transcript(&self) -> std::option::Option<&str> {
        self.input_transcript.as_deref()
    }
    /// <p>The text used to process the request.</p>
    /// <p>If the input was an audio stream, the
    /// <code>encodedInputTranscript</code> field contains the text extracted
    /// from the audio stream. This is the text that is actually processed to
    /// recognize intents and slot values. You can use this information to
    /// determine if Amazon Lex is correctly processing the audio that you send.</p>
    /// <p>The <code>encodedInputTranscript</code> field is base-64 encoded. You must
    /// decode the field before you can use the value.</p>
    pub fn encoded_input_transcript(&self) -> std::option::Option<&str> {
        self.encoded_input_transcript.as_deref()
    }
    /// <p>The prompt (or statement) to convey to the user. This is based on the
    /// bot configuration and context. For example, if Amazon Lex did not understand
    /// the user intent, it sends the <code>clarificationPrompt</code> configured
    /// for the bot. If the intent requires confirmation before taking the
    /// fulfillment action, it sends the <code>confirmationPrompt</code>. Another
    /// example: Suppose that the Lambda function successfully fulfilled the
    /// intent, and sent a message to convey to the user. Then Amazon Lex sends that
    /// message in the response. </p>
    pub fn audio_stream(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.audio_stream
    }
    /// <p>The version of the bot that responded to the conversation. You can use
    /// this information to help determine if one version of a bot is performing
    /// better than another version.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The unique identifier for the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub fn active_contexts(&self) -> std::option::Option<&str> {
        self.active_contexts.as_deref()
    }
}
impl std::fmt::Debug for PostContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostContentOutput");
        formatter.field("content_type", &self.content_type);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("nlu_intent_confidence", &self.nlu_intent_confidence);
        formatter.field("alternative_intents", &self.alternative_intents);
        formatter.field("slots", &self.slots);
        formatter.field("session_attributes", &self.session_attributes);
        formatter.field("sentiment_response", &self.sentiment_response);
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.field("encoded_message", &"*** Sensitive Data Redacted ***");
        formatter.field("message_format", &self.message_format);
        formatter.field("dialog_state", &self.dialog_state);
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.field("input_transcript", &self.input_transcript);
        formatter.field(
            "encoded_input_transcript",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("audio_stream", &self.audio_stream);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("session_id", &self.session_id);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PostContentOutput`](crate::output::PostContentOutput)
pub mod post_content_output {
    /// A builder for [`PostContentOutput`](crate::output::PostContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence: std::option::Option<std::string::String>,
        pub(crate) alternative_intents: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::string::String>,
        pub(crate) session_attributes: std::option::Option<std::string::String>,
        pub(crate) sentiment_response: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) encoded_message: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatType>,
        pub(crate) dialog_state: std::option::Option<crate::model::DialogState>,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
        pub(crate) input_transcript: std::option::Option<std::string::String>,
        pub(crate) encoded_input_transcript: std::option::Option<std::string::String>,
        pub(crate) audio_stream: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) active_contexts: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Content type as specified in the <code>Accept</code> HTTP header in
        /// the request.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>Content type as specified in the <code>Accept</code> HTTP header in
        /// the request.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p>Current user intent that Amazon Lex is aware of.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>Current user intent that Amazon Lex is aware of.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>Provides a score that indicates how confident Amazon Lex is that the
        /// returned intent is the one that matches the user's intent. The score is
        /// between 0.0 and 1.0.</p>
        /// <p>The score is a relative score, not an absolute score. The score may
        /// change based on improvements to Amazon Lex. </p>
        pub fn nlu_intent_confidence(mut self, input: impl Into<std::string::String>) -> Self {
            self.nlu_intent_confidence = Some(input.into());
            self
        }
        /// <p>Provides a score that indicates how confident Amazon Lex is that the
        /// returned intent is the one that matches the user's intent. The score is
        /// between 0.0 and 1.0.</p>
        /// <p>The score is a relative score, not an absolute score. The score may
        /// change based on improvements to Amazon Lex. </p>
        pub fn set_nlu_intent_confidence(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nlu_intent_confidence = input;
            self
        }
        /// <p>One to four alternative intents that may be applicable to the user's
        /// intent.</p>
        /// <p>Each alternative includes a score that indicates how confident Amazon Lex
        /// is that the intent matches the user's intent. The intents are sorted by
        /// the confidence score.</p>
        pub fn alternative_intents(mut self, input: impl Into<std::string::String>) -> Self {
            self.alternative_intents = Some(input.into());
            self
        }
        /// <p>One to four alternative intents that may be applicable to the user's
        /// intent.</p>
        /// <p>Each alternative includes a score that indicates how confident Amazon Lex
        /// is that the intent matches the user's intent. The intents are sorted by
        /// the confidence score.</p>
        pub fn set_alternative_intents(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alternative_intents = input;
            self
        }
        /// <p>Map of zero or more intent slots (name/value pairs) Amazon Lex detected
        /// from the user input during the conversation. The field is base-64
        /// encoded.</p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code>, the default is
        /// <code>ORIGINAL_VALUE</code>.</p>
        pub fn slots(mut self, input: impl Into<std::string::String>) -> Self {
            self.slots = Some(input.into());
            self
        }
        /// <p>Map of zero or more intent slots (name/value pairs) Amazon Lex detected
        /// from the user input during the conversation. The field is base-64
        /// encoded.</p>
        /// <p>Amazon Lex creates a resolution list containing likely values for a slot.
        /// The value that it returns is determined by the
        /// <code>valueSelectionStrategy</code> selected when the slot type was
        /// created or updated. If <code>valueSelectionStrategy</code> is set to
        /// <code>ORIGINAL_VALUE</code>, the value provided by the user is returned,
        /// if the user value is similar to the slot values. If
        /// <code>valueSelectionStrategy</code> is set to
        /// <code>TOP_RESOLUTION</code> Amazon Lex returns the first value in the
        /// resolution list or, if there is no resolution list, null. If you don't
        /// specify a <code>valueSelectionStrategy</code>, the default is
        /// <code>ORIGINAL_VALUE</code>.</p>
        pub fn set_slots(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slots = input;
            self
        }
        /// <p> Map of key/value pairs representing the session-specific context
        /// information. </p>
        pub fn session_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_attributes = Some(input.into());
            self
        }
        /// <p> Map of key/value pairs representing the session-specific context
        /// information. </p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>The sentiment expressed in an utterance.</p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend for
        /// sentiment analysis, this field contains the result of the analysis.</p>
        pub fn sentiment_response(mut self, input: impl Into<std::string::String>) -> Self {
            self.sentiment_response = Some(input.into());
            self
        }
        /// <p>The sentiment expressed in an utterance.</p>
        /// <p>When the bot is configured to send utterances to Amazon Comprehend for
        /// sentiment analysis, this field contains the result of the analysis.</p>
        pub fn set_sentiment_response(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sentiment_response = input;
            self
        }
        /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>message</code> field is null. You should use the
        /// <code>encodedMessage</code> field instead.</p>
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
        /// next course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>You can only use this field in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>message</code> field is null. You should use the
        /// <code>encodedMessage</code> field instead.</p>
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
        /// next course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
        /// next course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn encoded_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_message = Some(input.into());
            self
        }
        /// <p>The message to convey to the user. The message can come from the bot's
        /// configuration or from a Lambda function.</p>
        /// <p>If the intent is not configured with a Lambda function, or if the Lambda
        /// function returned <code>Delegate</code> as the
        /// <code>dialogAction.type</code> in its response, Amazon Lex decides on the
        /// next course of action and selects an appropriate message from the bot's
        /// configuration based on the current interaction context. For example, if
        /// Amazon Lex isn't able to understand user input, it uses a clarification prompt
        /// message.</p>
        /// <p>When you create an intent you can assign messages to groups. When
        /// messages are assigned to groups Amazon Lex returns one message from each group
        /// in the response. The message field is an escaped JSON string containing
        /// the messages. For more information about the structure of the JSON string
        /// returned, see <a>msg-prompts-formats</a>.</p>
        /// <p>If the Lambda function returns a message, Amazon Lex passes it to the client
        /// in its response.</p>
        /// <p>The <code>encodedMessage</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn set_encoded_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encoded_message = input;
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn message_format(mut self, input: crate::model::MessageFormatType) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>The format of the response message. One of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages from the groups that messages
        /// were assigned to when the intent was created.</p>
        /// </li>
        /// </ul>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatType>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// <p>Identifies the current state of the user interaction. Amazon Lex returns
        /// one of the following values as <code>dialogState</code>. The client can
        /// optionally use this information to customize the user interface. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
        /// Consider the following examples: </p>
        /// <p> For example, a user might utter an intent ("I want to order a
        /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
        /// will return this dialog state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response. </p>
        /// <p>For example, Amazon Lex wants user confirmation before fulfilling an
        /// intent. Instead of a simple "yes" or "no" response, a user might
        /// respond with additional information. For example, "yes, but make it a
        /// thick crust pizza" or "no, I want to order a drink." Amazon Lex can process
        /// such additional information (in these examples, update the crust type
        /// slot or change the intent from OrderPizza to OrderDrink). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for
        /// the current intent. </p>
        /// <p> For example, suppose that in the response Amazon Lex sends this
        /// message: "What size pizza would you like?". A user might reply with
        /// the slot value (e.g., "medium"). The user might also provide
        /// additional information in the response (e.g., "medium thick crust
        /// pizza"). Amazon Lex can process such additional information appropriately.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function has
        /// successfully fulfilled the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the request. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// failed. </p>
        /// <p> This can happen for various reasons, including that the user does
        /// not provide an appropriate response to prompts from the service (you
        /// can configure how many times Amazon Lex can prompt a user for specific
        /// information), or if the Lambda function fails to fulfill the intent.
        /// </p>
        /// </li>
        /// </ul>
        pub fn dialog_state(mut self, input: crate::model::DialogState) -> Self {
            self.dialog_state = Some(input);
            self
        }
        /// <p>Identifies the current state of the user interaction. Amazon Lex returns
        /// one of the following values as <code>dialogState</code>. The client can
        /// optionally use this information to customize the user interface. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - Amazon Lex wants to elicit the user's intent.
        /// Consider the following examples: </p>
        /// <p> For example, a user might utter an intent ("I want to order a
        /// pizza"). If Amazon Lex cannot infer the user intent from this utterance, it
        /// will return this dialog state. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - Amazon Lex is expecting a "yes" or "no"
        /// response. </p>
        /// <p>For example, Amazon Lex wants user confirmation before fulfilling an
        /// intent. Instead of a simple "yes" or "no" response, a user might
        /// respond with additional information. For example, "yes, but make it a
        /// thick crust pizza" or "no, I want to order a drink." Amazon Lex can process
        /// such additional information (in these examples, update the crust type
        /// slot or change the intent from OrderPizza to OrderDrink). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - Amazon Lex is expecting the value of a slot for
        /// the current intent. </p>
        /// <p> For example, suppose that in the response Amazon Lex sends this
        /// message: "What size pizza would you like?". A user might reply with
        /// the slot value (e.g., "medium"). The user might also provide
        /// additional information in the response (e.g., "medium thick crust
        /// pizza"). Amazon Lex can process such additional information appropriately.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - Conveys that the Lambda function has
        /// successfully fulfilled the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - Conveys that the client has to
        /// fulfill the request. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - Conveys that the conversation with the user
        /// failed. </p>
        /// <p> This can happen for various reasons, including that the user does
        /// not provide an appropriate response to prompts from the service (you
        /// can configure how many times Amazon Lex can prompt a user for specific
        /// information), or if the Lambda function fails to fulfill the intent.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_dialog_state(
            mut self,
            input: std::option::Option<crate::model::DialogState>,
        ) -> Self {
            self.dialog_state = input;
            self
        }
        /// <p> If the <code>dialogState</code> value is <code>ElicitSlot</code>,
        /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p> If the <code>dialogState</code> value is <code>ElicitSlot</code>,
        /// returns the name of the slot for which Amazon Lex is eliciting a value. </p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// <p>The text used to process the request.</p>
        /// <p>You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>inputTranscript</code> field is null. You should use the
        /// <code>encodedInputTranscript</code> field instead.</p>
        /// <p>If the input was an audio stream, the <code>inputTranscript</code>
        /// field contains the text extracted from the audio stream. This is the text
        /// that is actually processed to recognize intents and slot values. You can
        /// use this information to determine if Amazon Lex is correctly processing the
        /// audio that you send.</p>
        pub fn input_transcript(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_transcript = Some(input.into());
            self
        }
        /// <p>The text used to process the request.</p>
        /// <p>You can use this field only in the de-DE, en-AU, en-GB, en-US, es-419,
        /// es-ES, es-US, fr-CA, fr-FR, and it-IT locales. In all other locales, the
        /// <code>inputTranscript</code> field is null. You should use the
        /// <code>encodedInputTranscript</code> field instead.</p>
        /// <p>If the input was an audio stream, the <code>inputTranscript</code>
        /// field contains the text extracted from the audio stream. This is the text
        /// that is actually processed to recognize intents and slot values. You can
        /// use this information to determine if Amazon Lex is correctly processing the
        /// audio that you send.</p>
        pub fn set_input_transcript(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_transcript = input;
            self
        }
        /// <p>The text used to process the request.</p>
        /// <p>If the input was an audio stream, the
        /// <code>encodedInputTranscript</code> field contains the text extracted
        /// from the audio stream. This is the text that is actually processed to
        /// recognize intents and slot values. You can use this information to
        /// determine if Amazon Lex is correctly processing the audio that you send.</p>
        /// <p>The <code>encodedInputTranscript</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn encoded_input_transcript(mut self, input: impl Into<std::string::String>) -> Self {
            self.encoded_input_transcript = Some(input.into());
            self
        }
        /// <p>The text used to process the request.</p>
        /// <p>If the input was an audio stream, the
        /// <code>encodedInputTranscript</code> field contains the text extracted
        /// from the audio stream. This is the text that is actually processed to
        /// recognize intents and slot values. You can use this information to
        /// determine if Amazon Lex is correctly processing the audio that you send.</p>
        /// <p>The <code>encodedInputTranscript</code> field is base-64 encoded. You must
        /// decode the field before you can use the value.</p>
        pub fn set_encoded_input_transcript(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encoded_input_transcript = input;
            self
        }
        /// <p>The prompt (or statement) to convey to the user. This is based on the
        /// bot configuration and context. For example, if Amazon Lex did not understand
        /// the user intent, it sends the <code>clarificationPrompt</code> configured
        /// for the bot. If the intent requires confirmation before taking the
        /// fulfillment action, it sends the <code>confirmationPrompt</code>. Another
        /// example: Suppose that the Lambda function successfully fulfilled the
        /// intent, and sent a message to convey to the user. Then Amazon Lex sends that
        /// message in the response. </p>
        pub fn audio_stream(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.audio_stream = Some(input);
            self
        }
        /// <p>The prompt (or statement) to convey to the user. This is based on the
        /// bot configuration and context. For example, if Amazon Lex did not understand
        /// the user intent, it sends the <code>clarificationPrompt</code> configured
        /// for the bot. If the intent requires confirmation before taking the
        /// fulfillment action, it sends the <code>confirmationPrompt</code>. Another
        /// example: Suppose that the Lambda function successfully fulfilled the
        /// intent, and sent a message to convey to the user. Then Amazon Lex sends that
        /// message in the response. </p>
        pub fn set_audio_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.audio_stream = input;
            self
        }
        /// <p>The version of the bot that responded to the conversation. You can use
        /// this information to help determine if one version of a bot is performing
        /// better than another version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that responded to the conversation. You can use
        /// this information to help determine if one version of a bot is performing
        /// better than another version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The unique identifier for the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn active_contexts(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_contexts = Some(input.into());
            self
        }
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PostContentOutput`](crate::output::PostContentOutput)
        pub fn build(self) -> crate::output::PostContentOutput {
            crate::output::PostContentOutput {
                content_type: self.content_type,
                intent_name: self.intent_name,
                nlu_intent_confidence: self.nlu_intent_confidence,
                alternative_intents: self.alternative_intents,
                slots: self.slots,
                session_attributes: self.session_attributes,
                sentiment_response: self.sentiment_response,
                message: self.message,
                encoded_message: self.encoded_message,
                message_format: self.message_format,
                dialog_state: self.dialog_state,
                slot_to_elicit: self.slot_to_elicit,
                input_transcript: self.input_transcript,
                encoded_input_transcript: self.encoded_input_transcript,
                audio_stream: self.audio_stream.unwrap_or_default(),
                bot_version: self.bot_version,
                session_id: self.session_id,
                active_contexts: self.active_contexts,
            }
        }
    }
}
impl PostContentOutput {
    /// Creates a new builder-style object to manufacture [`PostContentOutput`](crate::output::PostContentOutput)
    pub fn builder() -> crate::output::post_content_output::Builder {
        crate::output::post_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionOutput {
    /// <p>An array of information about the intents used in the session. The
    /// array can contain a maximum of three summaries. If more than three intents
    /// are used in the session, the <code>recentIntentSummaryView</code>
    /// operation contains information about the last three intents used.</p>
    /// <p>If you set the <code>checkpointLabelFilter</code> parameter in the
    /// request, the array contains only the intents with the specified
    /// label.</p>
    pub recent_intent_summary_view: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
    /// <p>Map of key/value pairs representing the session-specific context
    /// information. It contains application information passed between Amazon Lex and
    /// a client application.</p>
    pub session_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A unique identifier for the session.</p>
    pub session_id: std::option::Option<std::string::String>,
    /// <p>Describes the current state of the bot.</p>
    pub dialog_action: std::option::Option<crate::model::DialogAction>,
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
}
impl GetSessionOutput {
    /// <p>An array of information about the intents used in the session. The
    /// array can contain a maximum of three summaries. If more than three intents
    /// are used in the session, the <code>recentIntentSummaryView</code>
    /// operation contains information about the last three intents used.</p>
    /// <p>If you set the <code>checkpointLabelFilter</code> parameter in the
    /// request, the array contains only the intents with the specified
    /// label.</p>
    pub fn recent_intent_summary_view(
        &self,
    ) -> std::option::Option<&[crate::model::IntentSummary]> {
        self.recent_intent_summary_view.as_deref()
    }
    /// <p>Map of key/value pairs representing the session-specific context
    /// information. It contains application information passed between Amazon Lex and
    /// a client application.</p>
    pub fn session_attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.session_attributes.as_ref()
    }
    /// <p>A unique identifier for the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Describes the current state of the bot.</p>
    pub fn dialog_action(&self) -> std::option::Option<&crate::model::DialogAction> {
        self.dialog_action.as_ref()
    }
    /// <p>A list of active contexts for the session. A context can be set when
    /// an intent is fulfilled or by calling the <code>PostContent</code>,
    /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
    /// <p>You can use a context to control the intents that can follow up an
    /// intent, or to modify the operation of your application.</p>
    pub fn active_contexts(&self) -> std::option::Option<&[crate::model::ActiveContext]> {
        self.active_contexts.as_deref()
    }
}
impl std::fmt::Debug for GetSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionOutput");
        formatter.field(
            "recent_intent_summary_view",
            &self.recent_intent_summary_view,
        );
        formatter.field("session_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("session_id", &self.session_id);
        formatter.field("dialog_action", &self.dialog_action);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetSessionOutput`](crate::output::GetSessionOutput)
pub mod get_session_output {
    /// A builder for [`GetSessionOutput`](crate::output::GetSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recent_intent_summary_view:
            std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        pub(crate) session_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) session_id: std::option::Option<std::string::String>,
        pub(crate) dialog_action: std::option::Option<crate::model::DialogAction>,
        pub(crate) active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
    }
    impl Builder {
        /// Appends an item to `recent_intent_summary_view`.
        ///
        /// To override the contents of this collection use [`set_recent_intent_summary_view`](Self::set_recent_intent_summary_view).
        ///
        /// <p>An array of information about the intents used in the session. The
        /// array can contain a maximum of three summaries. If more than three intents
        /// are used in the session, the <code>recentIntentSummaryView</code>
        /// operation contains information about the last three intents used.</p>
        /// <p>If you set the <code>checkpointLabelFilter</code> parameter in the
        /// request, the array contains only the intents with the specified
        /// label.</p>
        pub fn recent_intent_summary_view(
            mut self,
            input: impl Into<crate::model::IntentSummary>,
        ) -> Self {
            let mut v = self.recent_intent_summary_view.unwrap_or_default();
            v.push(input.into());
            self.recent_intent_summary_view = Some(v);
            self
        }
        /// <p>An array of information about the intents used in the session. The
        /// array can contain a maximum of three summaries. If more than three intents
        /// are used in the session, the <code>recentIntentSummaryView</code>
        /// operation contains information about the last three intents used.</p>
        /// <p>If you set the <code>checkpointLabelFilter</code> parameter in the
        /// request, the array contains only the intents with the specified
        /// label.</p>
        pub fn set_recent_intent_summary_view(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        ) -> Self {
            self.recent_intent_summary_view = input;
            self
        }
        /// Adds a key-value pair to `session_attributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Map of key/value pairs representing the session-specific context
        /// information. It contains application information passed between Amazon Lex and
        /// a client application.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.session_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.session_attributes = Some(hash_map);
            self
        }
        /// <p>Map of key/value pairs representing the session-specific context
        /// information. It contains application information passed between Amazon Lex and
        /// a client application.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// <p>Describes the current state of the bot.</p>
        pub fn dialog_action(mut self, input: crate::model::DialogAction) -> Self {
            self.dialog_action = Some(input);
            self
        }
        /// <p>Describes the current state of the bot.</p>
        pub fn set_dialog_action(
            mut self,
            input: std::option::Option<crate::model::DialogAction>,
        ) -> Self {
            self.dialog_action = input;
            self
        }
        /// Appends an item to `active_contexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn active_contexts(mut self, input: impl Into<crate::model::ActiveContext>) -> Self {
            let mut v = self.active_contexts.unwrap_or_default();
            v.push(input.into());
            self.active_contexts = Some(v);
            self
        }
        /// <p>A list of active contexts for the session. A context can be set when
        /// an intent is fulfilled or by calling the <code>PostContent</code>,
        /// <code>PostText</code>, or <code>PutSession</code> operation.</p>
        /// <p>You can use a context to control the intents that can follow up an
        /// intent, or to modify the operation of your application.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionOutput`](crate::output::GetSessionOutput)
        pub fn build(self) -> crate::output::GetSessionOutput {
            crate::output::GetSessionOutput {
                recent_intent_summary_view: self.recent_intent_summary_view,
                session_attributes: self.session_attributes,
                session_id: self.session_id,
                dialog_action: self.dialog_action,
                active_contexts: self.active_contexts,
            }
        }
    }
}
impl GetSessionOutput {
    /// Creates a new builder-style object to manufacture [`GetSessionOutput`](crate::output::GetSessionOutput)
    pub fn builder() -> crate::output::get_session_output::Builder {
        crate::output::get_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSessionOutput {
    /// <p>The name of the bot associated with the session data.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The alias in use for the bot associated with the session data.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the client application user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the session.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl DeleteSessionOutput {
    /// <p>The name of the bot associated with the session data.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The alias in use for the bot associated with the session data.</p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
    /// <p>The ID of the client application user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The unique identifier for the session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSessionOutput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}
/// See [`DeleteSessionOutput`](crate::output::DeleteSessionOutput)
pub mod delete_session_output {
    /// A builder for [`DeleteSessionOutput`](crate::output::DeleteSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot associated with the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot associated with the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The alias in use for the bot associated with the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>The alias in use for the bot associated with the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The ID of the client application user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the client application user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The unique identifier for the session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSessionOutput`](crate::output::DeleteSessionOutput)
        pub fn build(self) -> crate::output::DeleteSessionOutput {
            crate::output::DeleteSessionOutput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
                session_id: self.session_id,
            }
        }
    }
}
impl DeleteSessionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSessionOutput`](crate::output::DeleteSessionOutput)
    pub fn builder() -> crate::output::delete_session_output::Builder {
        crate::output::delete_session_output::Builder::default()
    }
}
