// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DialogState {
    #[allow(missing_docs)] // documentation missing in model
    ConfirmIntent,
    #[allow(missing_docs)] // documentation missing in model
    ElicitIntent,
    #[allow(missing_docs)] // documentation missing in model
    ElicitSlot,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForFulfillment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DialogState {
    fn from(s: &str) -> Self {
        match s {
            "ConfirmIntent" => DialogState::ConfirmIntent,
            "ElicitIntent" => DialogState::ElicitIntent,
            "ElicitSlot" => DialogState::ElicitSlot,
            "Failed" => DialogState::Failed,
            "Fulfilled" => DialogState::Fulfilled,
            "ReadyForFulfillment" => DialogState::ReadyForFulfillment,
            other => DialogState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DialogState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DialogState::from(s))
    }
}
impl DialogState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DialogState::ConfirmIntent => "ConfirmIntent",
            DialogState::ElicitIntent => "ElicitIntent",
            DialogState::ElicitSlot => "ElicitSlot",
            DialogState::Failed => "Failed",
            DialogState::Fulfilled => "Fulfilled",
            DialogState::ReadyForFulfillment => "ReadyForFulfillment",
            DialogState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ConfirmIntent",
            "ElicitIntent",
            "ElicitSlot",
            "Failed",
            "Fulfilled",
            "ReadyForFulfillment",
        ]
    }
}
impl AsRef<str> for DialogState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageFormatType {
    #[allow(missing_docs)] // documentation missing in model
    Composite,
    #[allow(missing_docs)] // documentation missing in model
    CustomPayload,
    #[allow(missing_docs)] // documentation missing in model
    PlainText,
    #[allow(missing_docs)] // documentation missing in model
    Ssml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageFormatType {
    fn from(s: &str) -> Self {
        match s {
            "Composite" => MessageFormatType::Composite,
            "CustomPayload" => MessageFormatType::CustomPayload,
            "PlainText" => MessageFormatType::PlainText,
            "SSML" => MessageFormatType::Ssml,
            other => MessageFormatType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageFormatType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageFormatType::from(s))
    }
}
impl MessageFormatType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageFormatType::Composite => "Composite",
            MessageFormatType::CustomPayload => "CustomPayload",
            MessageFormatType::PlainText => "PlainText",
            MessageFormatType::Ssml => "SSML",
            MessageFormatType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Composite", "CustomPayload", "PlainText", "SSML"]
    }
}
impl AsRef<str> for MessageFormatType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A context is a variable that contains information about the current
/// state of the conversation between a user and Amazon Lex. Context can be set
/// automatically by Amazon Lex when an intent is fulfilled, or it can be set at
/// runtime using the <code>PutContent</code>, <code>PutText</code>, or
/// <code>PutSession</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveContext {
    /// <p>The name of the context.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The length of time or number of turns that a context remains
    /// active.</p>
    pub time_to_live: std::option::Option<crate::model::ActiveContextTimeToLive>,
    /// <p>State variables for the current context. You can use these values as
    /// default values for slots in subsequent events.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ActiveContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveContext");
        formatter.field("name", &self.name);
        formatter.field("time_to_live", &self.time_to_live);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ActiveContext`](crate::model::ActiveContext)
pub mod active_context {
    /// A builder for [`ActiveContext`](crate::model::ActiveContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) time_to_live: std::option::Option<crate::model::ActiveContextTimeToLive>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The length of time or number of turns that a context remains
        /// active.</p>
        pub fn time_to_live(mut self, input: crate::model::ActiveContextTimeToLive) -> Self {
            self.time_to_live = Some(input);
            self
        }
        /// <p>The length of time or number of turns that a context remains
        /// active.</p>
        pub fn set_time_to_live(
            mut self,
            input: std::option::Option<crate::model::ActiveContextTimeToLive>,
        ) -> Self {
            self.time_to_live = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>State variables for the current context. You can use these values as
        /// default values for slots in subsequent events.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>State variables for the current context. You can use these values as
        /// default values for slots in subsequent events.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveContext`](crate::model::ActiveContext)
        pub fn build(self) -> crate::model::ActiveContext {
            crate::model::ActiveContext {
                name: self.name,
                time_to_live: self.time_to_live,
                parameters: self.parameters,
            }
        }
    }
}
impl ActiveContext {
    /// Creates a new builder-style object to manufacture [`ActiveContext`](crate::model::ActiveContext)
    pub fn builder() -> crate::model::active_context::Builder {
        crate::model::active_context::Builder::default()
    }
}

/// <p>The length of time or number of turns that a context remains
/// active.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActiveContextTimeToLive {
    /// <p>The number of seconds that the context should be active after it is
    /// first sent in a <code>PostContent</code> or <code>PostText</code>
    /// response. You can set the value between 5 and 86,400 seconds (24
    /// hours).</p>
    pub time_to_live_in_seconds: std::option::Option<i32>,
    /// <p>The number of conversation turns that the context should be active. A
    /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
    /// request and the corresponding response from Amazon Lex.</p>
    pub turns_to_live: std::option::Option<i32>,
}
impl std::fmt::Debug for ActiveContextTimeToLive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActiveContextTimeToLive");
        formatter.field("time_to_live_in_seconds", &self.time_to_live_in_seconds);
        formatter.field("turns_to_live", &self.turns_to_live);
        formatter.finish()
    }
}
/// See [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
pub mod active_context_time_to_live {
    /// A builder for [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_to_live_in_seconds: std::option::Option<i32>,
        pub(crate) turns_to_live: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of seconds that the context should be active after it is
        /// first sent in a <code>PostContent</code> or <code>PostText</code>
        /// response. You can set the value between 5 and 86,400 seconds (24
        /// hours).</p>
        pub fn time_to_live_in_seconds(mut self, input: i32) -> Self {
            self.time_to_live_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds that the context should be active after it is
        /// first sent in a <code>PostContent</code> or <code>PostText</code>
        /// response. You can set the value between 5 and 86,400 seconds (24
        /// hours).</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live_in_seconds = input;
            self
        }
        /// <p>The number of conversation turns that the context should be active. A
        /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
        /// request and the corresponding response from Amazon Lex.</p>
        pub fn turns_to_live(mut self, input: i32) -> Self {
            self.turns_to_live = Some(input);
            self
        }
        /// <p>The number of conversation turns that the context should be active. A
        /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
        /// request and the corresponding response from Amazon Lex.</p>
        pub fn set_turns_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.turns_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
        pub fn build(self) -> crate::model::ActiveContextTimeToLive {
            crate::model::ActiveContextTimeToLive {
                time_to_live_in_seconds: self.time_to_live_in_seconds,
                turns_to_live: self.turns_to_live,
            }
        }
    }
}
impl ActiveContextTimeToLive {
    /// Creates a new builder-style object to manufacture [`ActiveContextTimeToLive`](crate::model::ActiveContextTimeToLive)
    pub fn builder() -> crate::model::active_context_time_to_live::Builder {
        crate::model::active_context_time_to_live::Builder::default()
    }
}

/// <p>Provides information about the state of an intent. You can use this
/// information to get the current state of an intent so that you can process
/// the intent, or so that you can return the intent to its previous
/// state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentSummary {
    /// <p>The name of the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>A user-defined label that identifies a particular intent. You can use
    /// this label to return to a previous intent. </p>
    /// <p>Use the <code>checkpointLabelFilter</code> parameter of the
    /// <code>GetSessionRequest</code> operation to filter the intents returned
    /// by the operation to those with only the specified label.</p>
    pub checkpoint_label: std::option::Option<std::string::String>,
    /// <p>Map of the slots that have been gathered and their values. </p>
    pub slots:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the intent after the user responds to the confirmation
    /// prompt. If the user confirms the intent, Amazon Lex sets this field to
    /// <code>Confirmed</code>. If the user denies the intent, Amazon Lex sets this
    /// value to <code>Denied</code>. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Confirmed</code> - The user has responded "Yes" to the
    /// confirmation prompt, confirming that the intent is complete and that
    /// it is ready to be fulfilled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Denied</code> - The user has responded "No" to the
    /// confirmation prompt.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>None</code> - The user has never been prompted for
    /// confirmation; or, the user was prompted but did not confirm or deny
    /// the prompt.</p>
    /// </li>
    /// </ul>
    pub confirmation_status: std::option::Option<crate::model::ConfirmationStatus>,
    /// <p>The next action that the bot should take in its interaction with the
    /// user. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - The next action is asking the user if
    /// the intent is complete and ready to be fulfilled. This is a yes/no
    /// question such as "Place the order?"</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Close</code> - Indicates that the there will not be a
    /// response from the user. For example, the statement "Your order has
    /// been placed" does not require a response.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - The next action is to determine the
    /// intent that the user wants to fulfill.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - The next action is to elicit a slot
    /// value from the user.</p>
    /// </li>
    /// </ul>
    pub dialog_action_type: std::option::Option<crate::model::DialogActionType>,
    /// <p>The fulfillment state of the intent. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The Lambda function associated with the
    /// intent failed to fulfill the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
    /// function associated with the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - All of the information
    /// necessary for the intent is present and the intent ready to be
    /// fulfilled by the client application.</p>
    /// </li>
    /// </ul>
    pub fulfillment_state: std::option::Option<crate::model::FulfillmentState>,
    /// <p>The next slot to elicit from the user. If there is not slot to elicit,
    /// the field is blank.</p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IntentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentSummary");
        formatter.field("intent_name", &self.intent_name);
        formatter.field("checkpoint_label", &self.checkpoint_label);
        formatter.field("slots", &"*** Sensitive Data Redacted ***");
        formatter.field("confirmation_status", &self.confirmation_status);
        formatter.field("dialog_action_type", &self.dialog_action_type);
        formatter.field("fulfillment_state", &self.fulfillment_state);
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.finish()
    }
}
/// See [`IntentSummary`](crate::model::IntentSummary)
pub mod intent_summary {
    /// A builder for [`IntentSummary`](crate::model::IntentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) checkpoint_label: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) confirmation_status: std::option::Option<crate::model::ConfirmationStatus>,
        pub(crate) dialog_action_type: std::option::Option<crate::model::DialogActionType>,
        pub(crate) fulfillment_state: std::option::Option<crate::model::FulfillmentState>,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>A user-defined label that identifies a particular intent. You can use
        /// this label to return to a previous intent. </p>
        /// <p>Use the <code>checkpointLabelFilter</code> parameter of the
        /// <code>GetSessionRequest</code> operation to filter the intents returned
        /// by the operation to those with only the specified label.</p>
        pub fn checkpoint_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.checkpoint_label = Some(input.into());
            self
        }
        /// <p>A user-defined label that identifies a particular intent. You can use
        /// this label to return to a previous intent. </p>
        /// <p>Use the <code>checkpointLabelFilter</code> parameter of the
        /// <code>GetSessionRequest</code> operation to filter the intents returned
        /// by the operation to those with only the specified label.</p>
        pub fn set_checkpoint_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.checkpoint_label = input;
            self
        }
        /// Adds a key-value pair to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>Map of the slots that have been gathered and their values. </p>
        pub fn slots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.slots = Some(hash_map);
            self
        }
        /// <p>Map of the slots that have been gathered and their values. </p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.slots = input;
            self
        }
        /// <p>The status of the intent after the user responds to the confirmation
        /// prompt. If the user confirms the intent, Amazon Lex sets this field to
        /// <code>Confirmed</code>. If the user denies the intent, Amazon Lex sets this
        /// value to <code>Denied</code>. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Confirmed</code> - The user has responded "Yes" to the
        /// confirmation prompt, confirming that the intent is complete and that
        /// it is ready to be fulfilled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Denied</code> - The user has responded "No" to the
        /// confirmation prompt.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code> - The user has never been prompted for
        /// confirmation; or, the user was prompted but did not confirm or deny
        /// the prompt.</p>
        /// </li>
        /// </ul>
        pub fn confirmation_status(mut self, input: crate::model::ConfirmationStatus) -> Self {
            self.confirmation_status = Some(input);
            self
        }
        /// <p>The status of the intent after the user responds to the confirmation
        /// prompt. If the user confirms the intent, Amazon Lex sets this field to
        /// <code>Confirmed</code>. If the user denies the intent, Amazon Lex sets this
        /// value to <code>Denied</code>. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Confirmed</code> - The user has responded "Yes" to the
        /// confirmation prompt, confirming that the intent is complete and that
        /// it is ready to be fulfilled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Denied</code> - The user has responded "No" to the
        /// confirmation prompt.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>None</code> - The user has never been prompted for
        /// confirmation; or, the user was prompted but did not confirm or deny
        /// the prompt.</p>
        /// </li>
        /// </ul>
        pub fn set_confirmation_status(
            mut self,
            input: std::option::Option<crate::model::ConfirmationStatus>,
        ) -> Self {
            self.confirmation_status = input;
            self
        }
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the user if
        /// the intent is complete and ready to be fulfilled. This is a yes/no
        /// question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that the there will not be a
        /// response from the user. For example, the statement "Your order has
        /// been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - The next action is to determine the
        /// intent that the user wants to fulfill.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn dialog_action_type(mut self, input: crate::model::DialogActionType) -> Self {
            self.dialog_action_type = Some(input);
            self
        }
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the user if
        /// the intent is complete and ready to be fulfilled. This is a yes/no
        /// question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that the there will not be a
        /// response from the user. For example, the statement "Your order has
        /// been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - The next action is to determine the
        /// intent that the user wants to fulfill.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn set_dialog_action_type(
            mut self,
            input: std::option::Option<crate::model::DialogActionType>,
        ) -> Self {
            self.dialog_action_type = input;
            self
        }
        /// <p>The fulfillment state of the intent. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The Lambda function associated with the
        /// intent failed to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
        /// function associated with the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - All of the information
        /// necessary for the intent is present and the intent ready to be
        /// fulfilled by the client application.</p>
        /// </li>
        /// </ul>
        pub fn fulfillment_state(mut self, input: crate::model::FulfillmentState) -> Self {
            self.fulfillment_state = Some(input);
            self
        }
        /// <p>The fulfillment state of the intent. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The Lambda function associated with the
        /// intent failed to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
        /// function associated with the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - All of the information
        /// necessary for the intent is present and the intent ready to be
        /// fulfilled by the client application.</p>
        /// </li>
        /// </ul>
        pub fn set_fulfillment_state(
            mut self,
            input: std::option::Option<crate::model::FulfillmentState>,
        ) -> Self {
            self.fulfillment_state = input;
            self
        }
        /// <p>The next slot to elicit from the user. If there is not slot to elicit,
        /// the field is blank.</p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p>The next slot to elicit from the user. If there is not slot to elicit,
        /// the field is blank.</p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentSummary`](crate::model::IntentSummary)
        pub fn build(self) -> crate::model::IntentSummary {
            crate::model::IntentSummary {
                intent_name: self.intent_name,
                checkpoint_label: self.checkpoint_label,
                slots: self.slots,
                confirmation_status: self.confirmation_status,
                dialog_action_type: self.dialog_action_type,
                fulfillment_state: self.fulfillment_state,
                slot_to_elicit: self.slot_to_elicit,
            }
        }
    }
}
impl IntentSummary {
    /// Creates a new builder-style object to manufacture [`IntentSummary`](crate::model::IntentSummary)
    pub fn builder() -> crate::model::intent_summary::Builder {
        crate::model::intent_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FulfillmentState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Fulfilled,
    #[allow(missing_docs)] // documentation missing in model
    ReadyForFulfillment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FulfillmentState {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => FulfillmentState::Failed,
            "Fulfilled" => FulfillmentState::Fulfilled,
            "ReadyForFulfillment" => FulfillmentState::ReadyForFulfillment,
            other => FulfillmentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FulfillmentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FulfillmentState::from(s))
    }
}
impl FulfillmentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FulfillmentState::Failed => "Failed",
            FulfillmentState::Fulfilled => "Fulfilled",
            FulfillmentState::ReadyForFulfillment => "ReadyForFulfillment",
            FulfillmentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Fulfilled", "ReadyForFulfillment"]
    }
}
impl AsRef<str> for FulfillmentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DialogActionType {
    #[allow(missing_docs)] // documentation missing in model
    Close,
    #[allow(missing_docs)] // documentation missing in model
    ConfirmIntent,
    #[allow(missing_docs)] // documentation missing in model
    Delegate,
    #[allow(missing_docs)] // documentation missing in model
    ElicitIntent,
    #[allow(missing_docs)] // documentation missing in model
    ElicitSlot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DialogActionType {
    fn from(s: &str) -> Self {
        match s {
            "Close" => DialogActionType::Close,
            "ConfirmIntent" => DialogActionType::ConfirmIntent,
            "Delegate" => DialogActionType::Delegate,
            "ElicitIntent" => DialogActionType::ElicitIntent,
            "ElicitSlot" => DialogActionType::ElicitSlot,
            other => DialogActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DialogActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DialogActionType::from(s))
    }
}
impl DialogActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DialogActionType::Close => "Close",
            DialogActionType::ConfirmIntent => "ConfirmIntent",
            DialogActionType::Delegate => "Delegate",
            DialogActionType::ElicitIntent => "ElicitIntent",
            DialogActionType::ElicitSlot => "ElicitSlot",
            DialogActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Close",
            "ConfirmIntent",
            "Delegate",
            "ElicitIntent",
            "ElicitSlot",
        ]
    }
}
impl AsRef<str> for DialogActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfirmationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Confirmed,
    #[allow(missing_docs)] // documentation missing in model
    Denied,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfirmationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Confirmed" => ConfirmationStatus::Confirmed,
            "Denied" => ConfirmationStatus::Denied,
            "None" => ConfirmationStatus::None,
            other => ConfirmationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfirmationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfirmationStatus::from(s))
    }
}
impl ConfirmationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfirmationStatus::Confirmed => "Confirmed",
            ConfirmationStatus::Denied => "Denied",
            ConfirmationStatus::None => "None",
            ConfirmationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Confirmed", "Denied", "None"]
    }
}
impl AsRef<str> for ConfirmationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the next action that the bot should take in its interaction
/// with the user and provides information about the context in which the
/// action takes place. Use the <code>DialogAction</code> data type to set the
/// interaction to a specific state, or to return the interaction to a
/// previous state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DialogAction {
    /// <p>The next action that the bot should take in its interaction with the
    /// user. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ConfirmIntent</code> - The next action is asking the user if
    /// the intent is complete and ready to be fulfilled. This is a yes/no
    /// question such as "Place the order?"</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Close</code> - Indicates that the there will not be a
    /// response from the user. For example, the statement "Your order has
    /// been placed" does not require a response.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Delegate</code> - The next action is determined by
    /// Amazon Lex.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitIntent</code> - The next action is to determine the
    /// intent that the user wants to fulfill.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ElicitSlot</code> - The next action is to elicit a slot
    /// value from the user.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DialogActionType>,
    /// <p>The name of the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>Map of the slots that have been gathered and their values. </p>
    pub slots:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The name of the slot that should be elicited from the user.</p>
    pub slot_to_elicit: std::option::Option<std::string::String>,
    /// <p>The fulfillment state of the intent. The possible values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The Lambda function associated with the
    /// intent failed to fulfill the intent.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
    /// function associated with the intent. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReadyForFulfillment</code> - All of the information
    /// necessary for the intent is present and the intent ready to be
    /// fulfilled by the client application.</p>
    /// </li>
    /// </ul>
    pub fulfillment_state: std::option::Option<crate::model::FulfillmentState>,
    /// <p>The message that should be shown to the user. If you don't specify a
    /// message, Amazon Lex will use the message configured for the intent.</p>
    pub message: std::option::Option<std::string::String>,
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PlainText</code> - The message contains plain UTF-8
    /// text.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CustomPayload</code> - The message is a custom format for
    /// the client.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SSML</code> - The message contains text formatted for voice
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Composite</code> - The message contains an escaped JSON
    /// object containing one or more messages. For more information, see
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/howitworks-manage-prompts.html">Message Groups</a>. </p>
    /// </li>
    /// </ul>
    pub message_format: std::option::Option<crate::model::MessageFormatType>,
}
impl std::fmt::Debug for DialogAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DialogAction");
        formatter.field("r#type", &self.r#type);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("slots", &"*** Sensitive Data Redacted ***");
        formatter.field("slot_to_elicit", &self.slot_to_elicit);
        formatter.field("fulfillment_state", &self.fulfillment_state);
        formatter.field("message", &"*** Sensitive Data Redacted ***");
        formatter.field("message_format", &self.message_format);
        formatter.finish()
    }
}
/// See [`DialogAction`](crate::model::DialogAction)
pub mod dialog_action {
    /// A builder for [`DialogAction`](crate::model::DialogAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::DialogActionType>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) slot_to_elicit: std::option::Option<std::string::String>,
        pub(crate) fulfillment_state: std::option::Option<crate::model::FulfillmentState>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatType>,
    }
    impl Builder {
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the user if
        /// the intent is complete and ready to be fulfilled. This is a yes/no
        /// question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that the there will not be a
        /// response from the user. For example, the statement "Your order has
        /// been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delegate</code> - The next action is determined by
        /// Amazon Lex.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - The next action is to determine the
        /// intent that the user wants to fulfill.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DialogActionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The next action that the bot should take in its interaction with the
        /// user. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ConfirmIntent</code> - The next action is asking the user if
        /// the intent is complete and ready to be fulfilled. This is a yes/no
        /// question such as "Place the order?"</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Close</code> - Indicates that the there will not be a
        /// response from the user. For example, the statement "Your order has
        /// been placed" does not require a response.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Delegate</code> - The next action is determined by
        /// Amazon Lex.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitIntent</code> - The next action is to determine the
        /// intent that the user wants to fulfill.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ElicitSlot</code> - The next action is to elicit a slot
        /// value from the user.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DialogActionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// Adds a key-value pair to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>Map of the slots that have been gathered and their values. </p>
        pub fn slots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.slots = Some(hash_map);
            self
        }
        /// <p>Map of the slots that have been gathered and their values. </p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.slots = input;
            self
        }
        /// <p>The name of the slot that should be elicited from the user.</p>
        pub fn slot_to_elicit(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_to_elicit = Some(input.into());
            self
        }
        /// <p>The name of the slot that should be elicited from the user.</p>
        pub fn set_slot_to_elicit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_to_elicit = input;
            self
        }
        /// <p>The fulfillment state of the intent. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The Lambda function associated with the
        /// intent failed to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
        /// function associated with the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - All of the information
        /// necessary for the intent is present and the intent ready to be
        /// fulfilled by the client application.</p>
        /// </li>
        /// </ul>
        pub fn fulfillment_state(mut self, input: crate::model::FulfillmentState) -> Self {
            self.fulfillment_state = Some(input);
            self
        }
        /// <p>The fulfillment state of the intent. The possible values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The Lambda function associated with the
        /// intent failed to fulfill the intent.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fulfilled</code> - The intent has fulfilled by the Lambda
        /// function associated with the intent. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReadyForFulfillment</code> - All of the information
        /// necessary for the intent is present and the intent ready to be
        /// fulfilled by the client application.</p>
        /// </li>
        /// </ul>
        pub fn set_fulfillment_state(
            mut self,
            input: std::option::Option<crate::model::FulfillmentState>,
        ) -> Self {
            self.fulfillment_state = input;
            self
        }
        /// <p>The message that should be shown to the user. If you don't specify a
        /// message, Amazon Lex will use the message configured for the intent.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message that should be shown to the user. If you don't specify a
        /// message, Amazon Lex will use the message configured for the intent.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages. For more information, see
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/howitworks-manage-prompts.html">Message Groups</a>. </p>
        /// </li>
        /// </ul>
        pub fn message_format(mut self, input: crate::model::MessageFormatType) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PlainText</code> - The message contains plain UTF-8
        /// text.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CustomPayload</code> - The message is a custom format for
        /// the client.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SSML</code> - The message contains text formatted for voice
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Composite</code> - The message contains an escaped JSON
        /// object containing one or more messages. For more information, see
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/howitworks-manage-prompts.html">Message Groups</a>. </p>
        /// </li>
        /// </ul>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatType>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// Consumes the builder and constructs a [`DialogAction`](crate::model::DialogAction)
        pub fn build(self) -> crate::model::DialogAction {
            crate::model::DialogAction {
                r#type: self.r#type,
                intent_name: self.intent_name,
                slots: self.slots,
                slot_to_elicit: self.slot_to_elicit,
                fulfillment_state: self.fulfillment_state,
                message: self.message,
                message_format: self.message_format,
            }
        }
    }
}
impl DialogAction {
    /// Creates a new builder-style object to manufacture [`DialogAction`](crate::model::DialogAction)
    pub fn builder() -> crate::model::dialog_action::Builder {
        crate::model::dialog_action::Builder::default()
    }
}

/// <p>If you configure a response card when creating your bots, Amazon Lex
/// substitutes the session attributes and slot values that are available, and
/// then returns it. The response card can also come from a Lambda function (
/// <code>dialogCodeHook</code> and <code>fulfillmentActivity</code> on an
/// intent).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseCard {
    /// <p>The version of the response card format.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The content type of the response.</p>
    pub content_type: std::option::Option<crate::model::ContentType>,
    /// <p>An array of attachment objects representing options.</p>
    pub generic_attachments: std::option::Option<std::vec::Vec<crate::model::GenericAttachment>>,
}
impl std::fmt::Debug for ResponseCard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseCard");
        formatter.field("version", &self.version);
        formatter.field("content_type", &self.content_type);
        formatter.field("generic_attachments", &self.generic_attachments);
        formatter.finish()
    }
}
/// See [`ResponseCard`](crate::model::ResponseCard)
pub mod response_card {
    /// A builder for [`ResponseCard`](crate::model::ResponseCard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<crate::model::ContentType>,
        pub(crate) generic_attachments:
            std::option::Option<std::vec::Vec<crate::model::GenericAttachment>>,
    }
    impl Builder {
        /// <p>The version of the response card format.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the response card format.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The content type of the response.</p>
        pub fn content_type(mut self, input: crate::model::ContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The content type of the response.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::ContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// Appends an item to `generic_attachments`.
        ///
        /// To override the contents of this collection use [`set_generic_attachments`](Self::set_generic_attachments).
        ///
        /// <p>An array of attachment objects representing options.</p>
        pub fn generic_attachments(
            mut self,
            input: impl Into<crate::model::GenericAttachment>,
        ) -> Self {
            let mut v = self.generic_attachments.unwrap_or_default();
            v.push(input.into());
            self.generic_attachments = Some(v);
            self
        }
        /// <p>An array of attachment objects representing options.</p>
        pub fn set_generic_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GenericAttachment>>,
        ) -> Self {
            self.generic_attachments = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseCard`](crate::model::ResponseCard)
        pub fn build(self) -> crate::model::ResponseCard {
            crate::model::ResponseCard {
                version: self.version,
                content_type: self.content_type,
                generic_attachments: self.generic_attachments,
            }
        }
    }
}
impl ResponseCard {
    /// Creates a new builder-style object to manufacture [`ResponseCard`](crate::model::ResponseCard)
    pub fn builder() -> crate::model::response_card::Builder {
        crate::model::response_card::Builder::default()
    }
}

/// <p>Represents an option rendered to the user when a prompt is shown. It
/// could be an image, a button, a link, or text. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenericAttachment {
    /// <p>The title of the option.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The subtitle shown below the title.</p>
    pub sub_title: std::option::Option<std::string::String>,
    /// <p>The URL of an attachment to the response card.</p>
    pub attachment_link_url: std::option::Option<std::string::String>,
    /// <p>The URL of an image that is displayed to the user.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>The list of options to show to the user.</p>
    pub buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
}
impl std::fmt::Debug for GenericAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenericAttachment");
        formatter.field("title", &self.title);
        formatter.field("sub_title", &self.sub_title);
        formatter.field("attachment_link_url", &self.attachment_link_url);
        formatter.field("image_url", &self.image_url);
        formatter.field("buttons", &self.buttons);
        formatter.finish()
    }
}
/// See [`GenericAttachment`](crate::model::GenericAttachment)
pub mod generic_attachment {
    /// A builder for [`GenericAttachment`](crate::model::GenericAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) sub_title: std::option::Option<std::string::String>,
        pub(crate) attachment_link_url: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
    }
    impl Builder {
        /// <p>The title of the option.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the option.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The subtitle shown below the title.</p>
        pub fn sub_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.sub_title = Some(input.into());
            self
        }
        /// <p>The subtitle shown below the title.</p>
        pub fn set_sub_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sub_title = input;
            self
        }
        /// <p>The URL of an attachment to the response card.</p>
        pub fn attachment_link_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_link_url = Some(input.into());
            self
        }
        /// <p>The URL of an attachment to the response card.</p>
        pub fn set_attachment_link_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_link_url = input;
            self
        }
        /// <p>The URL of an image that is displayed to the user.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image that is displayed to the user.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// Appends an item to `buttons`.
        ///
        /// To override the contents of this collection use [`set_buttons`](Self::set_buttons).
        ///
        /// <p>The list of options to show to the user.</p>
        pub fn buttons(mut self, input: impl Into<crate::model::Button>) -> Self {
            let mut v = self.buttons.unwrap_or_default();
            v.push(input.into());
            self.buttons = Some(v);
            self
        }
        /// <p>The list of options to show to the user.</p>
        pub fn set_buttons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Button>>,
        ) -> Self {
            self.buttons = input;
            self
        }
        /// Consumes the builder and constructs a [`GenericAttachment`](crate::model::GenericAttachment)
        pub fn build(self) -> crate::model::GenericAttachment {
            crate::model::GenericAttachment {
                title: self.title,
                sub_title: self.sub_title,
                attachment_link_url: self.attachment_link_url,
                image_url: self.image_url,
                buttons: self.buttons,
            }
        }
    }
}
impl GenericAttachment {
    /// Creates a new builder-style object to manufacture [`GenericAttachment`](crate::model::GenericAttachment)
    pub fn builder() -> crate::model::generic_attachment::Builder {
        crate::model::generic_attachment::Builder::default()
    }
}

/// <p>Represents an option to be shown on the client platform (Facebook,
/// Slack, etc.)</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Button {
    /// <p>Text that is visible to the user on the button.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The value sent to Amazon Lex when a user chooses the button. For
    /// example, consider button text "NYC." When the user chooses the button, the
    /// value sent can be "New York City."</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Button {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Button");
        formatter.field("text", &self.text);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Button`](crate::model::Button)
pub mod button {
    /// A builder for [`Button`](crate::model::Button)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Text that is visible to the user on the button.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>Text that is visible to the user on the button.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The value sent to Amazon Lex when a user chooses the button. For
        /// example, consider button text "NYC." When the user chooses the button, the
        /// value sent can be "New York City."</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value sent to Amazon Lex when a user chooses the button. For
        /// example, consider button text "NYC." When the user chooses the button, the
        /// value sent can be "New York City."</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Button`](crate::model::Button)
        pub fn build(self) -> crate::model::Button {
            crate::model::Button {
                text: self.text,
                value: self.value,
            }
        }
    }
}
impl Button {
    /// Creates a new builder-style object to manufacture [`Button`](crate::model::Button)
    pub fn builder() -> crate::model::button::Builder {
        crate::model::button::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentType {
    #[allow(missing_docs)] // documentation missing in model
    Generic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentType {
    fn from(s: &str) -> Self {
        match s {
            "application/vnd.amazonaws.card.generic" => ContentType::Generic,
            other => ContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentType::from(s))
    }
}
impl ContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentType::Generic => "application/vnd.amazonaws.card.generic",
            ContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["application/vnd.amazonaws.card.generic"]
    }
}
impl AsRef<str> for ContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The sentiment expressed in an utterance.</p>
/// <p>When the bot is configured to send utterances to Amazon Comprehend for
/// sentiment analysis, this field structure contains the result of the
/// analysis.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentResponse {
    /// <p>The inferred sentiment that Amazon Comprehend has the highest
    /// confidence in.</p>
    pub sentiment_label: std::option::Option<std::string::String>,
    /// <p>The likelihood that the sentiment was correctly inferred.</p>
    pub sentiment_score: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SentimentResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentResponse");
        formatter.field("sentiment_label", &self.sentiment_label);
        formatter.field("sentiment_score", &self.sentiment_score);
        formatter.finish()
    }
}
/// See [`SentimentResponse`](crate::model::SentimentResponse)
pub mod sentiment_response {
    /// A builder for [`SentimentResponse`](crate::model::SentimentResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sentiment_label: std::option::Option<std::string::String>,
        pub(crate) sentiment_score: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The inferred sentiment that Amazon Comprehend has the highest
        /// confidence in.</p>
        pub fn sentiment_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.sentiment_label = Some(input.into());
            self
        }
        /// <p>The inferred sentiment that Amazon Comprehend has the highest
        /// confidence in.</p>
        pub fn set_sentiment_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sentiment_label = input;
            self
        }
        /// <p>The likelihood that the sentiment was correctly inferred.</p>
        pub fn sentiment_score(mut self, input: impl Into<std::string::String>) -> Self {
            self.sentiment_score = Some(input.into());
            self
        }
        /// <p>The likelihood that the sentiment was correctly inferred.</p>
        pub fn set_sentiment_score(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sentiment_score = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentResponse`](crate::model::SentimentResponse)
        pub fn build(self) -> crate::model::SentimentResponse {
            crate::model::SentimentResponse {
                sentiment_label: self.sentiment_label,
                sentiment_score: self.sentiment_score,
            }
        }
    }
}
impl SentimentResponse {
    /// Creates a new builder-style object to manufacture [`SentimentResponse`](crate::model::SentimentResponse)
    pub fn builder() -> crate::model::sentiment_response::Builder {
        crate::model::sentiment_response::Builder::default()
    }
}

/// <p>An intent that Amazon Lex suggests satisfies the user's intent. Includes
/// the name of the intent, the confidence that Amazon Lex has that the user's
/// intent is satisfied, and the slots defined for the intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictedIntent {
    /// <p>The name of the intent that Amazon Lex suggests satisfies the user's
    /// intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>Indicates how confident Amazon Lex is that an intent satisfies the user's
    /// intent.</p>
    pub nlu_intent_confidence: std::option::Option<crate::model::IntentConfidence>,
    /// <p>The slot and slot values associated with the predicted intent.</p>
    pub slots:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for PredictedIntent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictedIntent");
        formatter.field("intent_name", &self.intent_name);
        formatter.field("nlu_intent_confidence", &self.nlu_intent_confidence);
        formatter.field("slots", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PredictedIntent`](crate::model::PredictedIntent)
pub mod predicted_intent {
    /// A builder for [`PredictedIntent`](crate::model::PredictedIntent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence: std::option::Option<crate::model::IntentConfidence>,
        pub(crate) slots: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the intent that Amazon Lex suggests satisfies the user's
        /// intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent that Amazon Lex suggests satisfies the user's
        /// intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>Indicates how confident Amazon Lex is that an intent satisfies the user's
        /// intent.</p>
        pub fn nlu_intent_confidence(mut self, input: crate::model::IntentConfidence) -> Self {
            self.nlu_intent_confidence = Some(input);
            self
        }
        /// <p>Indicates how confident Amazon Lex is that an intent satisfies the user's
        /// intent.</p>
        pub fn set_nlu_intent_confidence(
            mut self,
            input: std::option::Option<crate::model::IntentConfidence>,
        ) -> Self {
            self.nlu_intent_confidence = input;
            self
        }
        /// Adds a key-value pair to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>The slot and slot values associated with the predicted intent.</p>
        pub fn slots(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.slots.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.slots = Some(hash_map);
            self
        }
        /// <p>The slot and slot values associated with the predicted intent.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictedIntent`](crate::model::PredictedIntent)
        pub fn build(self) -> crate::model::PredictedIntent {
            crate::model::PredictedIntent {
                intent_name: self.intent_name,
                nlu_intent_confidence: self.nlu_intent_confidence,
                slots: self.slots,
            }
        }
    }
}
impl PredictedIntent {
    /// Creates a new builder-style object to manufacture [`PredictedIntent`](crate::model::PredictedIntent)
    pub fn builder() -> crate::model::predicted_intent::Builder {
        crate::model::predicted_intent::Builder::default()
    }
}

/// <p>Provides a score that indicates the confidence that Amazon Lex has that an
/// intent is the one that satisfies the user's intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentConfidence {
    /// <p>A score that indicates how confident Amazon Lex is that an intent satisfies
    /// the user's intent. Ranges between 0.00 and 1.00. Higher scores indicate
    /// higher confidence.</p>
    pub score: f64,
}
impl std::fmt::Debug for IntentConfidence {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentConfidence");
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`IntentConfidence`](crate::model::IntentConfidence)
pub mod intent_confidence {
    /// A builder for [`IntentConfidence`](crate::model::IntentConfidence)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>A score that indicates how confident Amazon Lex is that an intent satisfies
        /// the user's intent. Ranges between 0.00 and 1.00. Higher scores indicate
        /// higher confidence.</p>
        pub fn score(mut self, input: f64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>A score that indicates how confident Amazon Lex is that an intent satisfies
        /// the user's intent. Ranges between 0.00 and 1.00. Higher scores indicate
        /// higher confidence.</p>
        pub fn set_score(mut self, input: std::option::Option<f64>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentConfidence`](crate::model::IntentConfidence)
        pub fn build(self) -> crate::model::IntentConfidence {
            crate::model::IntentConfidence {
                score: self.score.unwrap_or_default(),
            }
        }
    }
}
impl IntentConfidence {
    /// Creates a new builder-style object to manufacture [`IntentConfidence`](crate::model::IntentConfidence)
    pub fn builder() -> crate::model::intent_confidence::Builder {
        crate::model::intent_confidence::Builder::default()
    }
}
