// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSessionOutput, crate::error::DeleteSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::DeleteSessionError {
                meta: generic,
                kind: crate::error::DeleteSessionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalFailureException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::InternalFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_session_limit_exceeded_exception_retry_after_seconds(response.headers())
                                                    .map_err(|_|crate::error::DeleteSessionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteSessionError {
            meta: generic,
            kind: crate::error::DeleteSessionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_session_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteSessionOutput, crate::error::DeleteSessionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_session_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_session(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteSessionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionOutput, crate::error::GetSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadRequestException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalFailureException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::InternalFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_session_limit_exceeded_exception_retry_after_seconds(response.headers())
                                                    .map_err(|_|crate::error::GetSessionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetSessionError {
            meta: generic,
            kind: crate::error::GetSessionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSessionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_session_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSessionOutput, crate::error::GetSessionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_session_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_session(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSessionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_post_content(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::PostContentOutput, crate::error::PostContentError> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::post_content_output::Builder::default();
        let _ = response;
        output = output.set_active_contexts(
            crate::http_serde::deser_header_post_content_post_content_output_active_contexts(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse activeContexts from header `x-amz-lex-active-contexts",
                )
            })?,
        );
        output = output.set_alternative_intents(
            crate::http_serde::deser_header_post_content_post_content_output_alternative_intents(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse alternativeIntents from header `x-amz-lex-alternative-intents",
                )
            })?,
        );
        output = output.set_audio_stream(Some(
            crate::http_serde::deser_payload_post_content_post_content_output_audio_stream(
                response.body_mut(),
            )?,
        ));
        output = output.set_bot_version(
            crate::http_serde::deser_header_post_content_post_content_output_bot_version(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse botVersion from header `x-amz-lex-bot-version",
                )
            })?,
        );
        output = output.set_content_type(
            crate::http_serde::deser_header_post_content_post_content_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse contentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_dialog_state(
            crate::http_serde::deser_header_post_content_post_content_output_dialog_state(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse dialogState from header `x-amz-lex-dialog-state",
                )
            })?,
        );
        output = output.set_encoded_input_transcript(
            crate::http_serde::deser_header_post_content_post_content_output_encoded_input_transcript(response.headers())
                                        .map_err(|_|crate::error::PostContentError::unhandled("Failed to parse encodedInputTranscript from header `x-amz-lex-encoded-input-transcript"))?
        );
        output = output.set_encoded_message(
            crate::http_serde::deser_header_post_content_post_content_output_encoded_message(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse encodedMessage from header `x-amz-lex-encoded-message",
                )
            })?,
        );
        output = output.set_input_transcript(
            crate::http_serde::deser_header_post_content_post_content_output_input_transcript(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse inputTranscript from header `x-amz-lex-input-transcript",
                )
            })?,
        );
        output = output.set_intent_name(
            crate::http_serde::deser_header_post_content_post_content_output_intent_name(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse intentName from header `x-amz-lex-intent-name",
                )
            })?,
        );
        output = output.set_message(
            crate::http_serde::deser_header_post_content_post_content_output_message(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse message from header `x-amz-lex-message",
                )
            })?,
        );
        output = output.set_message_format(
            crate::http_serde::deser_header_post_content_post_content_output_message_format(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse messageFormat from header `x-amz-lex-message-format",
                )
            })?,
        );
        output = output.set_nlu_intent_confidence(
            crate::http_serde::deser_header_post_content_post_content_output_nlu_intent_confidence(response.headers())
                                        .map_err(|_|crate::error::PostContentError::unhandled("Failed to parse nluIntentConfidence from header `x-amz-lex-nlu-intent-confidence"))?
        );
        output = output.set_sentiment_response(
            crate::http_serde::deser_header_post_content_post_content_output_sentiment_response(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse sentimentResponse from header `x-amz-lex-sentiment",
                )
            })?,
        );
        output = output.set_session_attributes(
            crate::http_serde::deser_header_post_content_post_content_output_session_attributes(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse sessionAttributes from header `x-amz-lex-session-attributes",
                )
            })?,
        );
        output = output.set_session_id(
            crate::http_serde::deser_header_post_content_post_content_output_session_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse sessionId from header `x-amz-lex-session-id",
                )
            })?,
        );
        output = output.set_slot_to_elicit(
            crate::http_serde::deser_header_post_content_post_content_output_slot_to_elicit(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse slotToElicit from header `x-amz-lex-slot-to-elicit",
                )
            })?,
        );
        output = output.set_slots(
            crate::http_serde::deser_header_post_content_post_content_output_slots(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PostContentError::unhandled(
                    "Failed to parse slots from header `x-amz-lex-slots",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_post_content_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PostContentOutput, crate::error::PostContentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PostContentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PostContentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadGatewayException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequestException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::PostContentError {
                meta: generic,
                kind: crate::error::PostContentErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DependencyFailedException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalFailureException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::InternalFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_post_content_limit_exceeded_exception_retry_after_seconds(response.headers())
                                                    .map_err(|_|crate::error::PostContentError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoopDetectedException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::LoopDetectedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::loop_detected_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_loop_detected_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAcceptableException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::NotAcceptableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_acceptable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_acceptable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestTimeoutException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::RequestTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedMediaTypeException" => crate::error::PostContentError {
            meta: generic,
            kind: crate::error::PostContentErrorKind::UnsupportedMediaTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_media_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_media_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostContentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PostContentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_post_text_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PostTextOutput, crate::error::PostTextError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PostTextError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PostTextError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadGatewayException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequestException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::PostTextError {
                meta: generic,
                kind: crate::error::PostTextErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DependencyFailedException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalFailureException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::InternalFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_post_text_limit_exceeded_exception_retry_after_seconds(response.headers())
                                                    .map_err(|_|crate::error::PostTextError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LoopDetectedException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::LoopDetectedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::loop_detected_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_loop_detected_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PostTextError {
            meta: generic,
            kind: crate::error::PostTextErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PostTextError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PostTextError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_post_text_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PostTextOutput, crate::error::PostTextError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::post_text_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_post_text(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PostTextError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_session(
    op_response: &mut aws_smithy_http::operation::Response,
) -> std::result::Result<crate::output::PutSessionOutput, crate::error::PutSessionError> {
    let response = op_response.http_mut();
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_session_output::Builder::default();
        let _ = response;
        output = output.set_active_contexts(
            crate::http_serde::deser_header_put_session_put_session_output_active_contexts(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse activeContexts from header `x-amz-lex-active-contexts",
                )
            })?,
        );
        output = output.set_audio_stream(Some(
            crate::http_serde::deser_payload_put_session_put_session_output_audio_stream(
                response.body_mut(),
            )?,
        ));
        output = output.set_content_type(
            crate::http_serde::deser_header_put_session_put_session_output_content_type(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse contentType from header `Content-Type",
                )
            })?,
        );
        output = output.set_dialog_state(
            crate::http_serde::deser_header_put_session_put_session_output_dialog_state(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse dialogState from header `x-amz-lex-dialog-state",
                )
            })?,
        );
        output = output.set_encoded_message(
            crate::http_serde::deser_header_put_session_put_session_output_encoded_message(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse encodedMessage from header `x-amz-lex-encoded-message",
                )
            })?,
        );
        output = output.set_intent_name(
            crate::http_serde::deser_header_put_session_put_session_output_intent_name(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse intentName from header `x-amz-lex-intent-name",
                )
            })?,
        );
        output = output.set_message(
            crate::http_serde::deser_header_put_session_put_session_output_message(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse message from header `x-amz-lex-message",
                )
            })?,
        );
        output = output.set_message_format(
            crate::http_serde::deser_header_put_session_put_session_output_message_format(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse messageFormat from header `x-amz-lex-message-format",
                )
            })?,
        );
        output = output.set_session_attributes(
            crate::http_serde::deser_header_put_session_put_session_output_session_attributes(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse sessionAttributes from header `x-amz-lex-session-attributes",
                )
            })?,
        );
        output = output.set_session_id(
            crate::http_serde::deser_header_put_session_put_session_output_session_id(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse sessionId from header `x-amz-lex-session-id",
                )
            })?,
        );
        output = output.set_slot_to_elicit(
            crate::http_serde::deser_header_put_session_put_session_output_slot_to_elicit(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse slotToElicit from header `x-amz-lex-slot-to-elicit",
                )
            })?,
        );
        output = output.set_slots(
            crate::http_serde::deser_header_put_session_put_session_output_slots(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::PutSessionError::unhandled(
                    "Failed to parse slots from header `x-amz-lex-slots",
                )
            })?,
        );
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_session_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutSessionOutput, crate::error::PutSessionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutSessionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutSessionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BadGatewayException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::BadGatewayException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_gateway_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_gateway_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BadRequestException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::BadRequestException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bad_request_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bad_request_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::PutSessionError {
                meta: generic,
                kind: crate::error::PutSessionErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DependencyFailedException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::DependencyFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dependency_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_dependency_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalFailureException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::InternalFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_put_session_limit_exceeded_exception_retry_after_seconds(response.headers())
                                                    .map_err(|_|crate::error::PutSessionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotAcceptableException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::NotAcceptableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_acceptable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_acceptable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PutSessionError {
            meta: generic,
            kind: crate::error::PutSessionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutSessionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutSessionError::generic(generic),
    })
}
