// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DeleteSessionInput`](crate::input::DeleteSessionInput)
pub mod delete_session_input {
    /// A builder for [`DeleteSessionInput`](crate::input::DeleteSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The identifier of the user associated with the session data.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user associated with the session data.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSessionInput`](crate::input::DeleteSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSessionInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSessionInputOperationOutputAlias = crate::operation::DeleteSession;
#[doc(hidden)]
pub type DeleteSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSessionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSession`](crate::operation::DeleteSession)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.bot_name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_1, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.bot_alias;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_2, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.user_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_3, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bot/{botName}/alias/{botAlias}/user/{userId}/session",
                botName = bot_name,
                botAlias = bot_alias,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSession",
            "lexruntimeservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSessionInput`](crate::input::DeleteSessionInput)
    pub fn builder() -> crate::input::delete_session_input::Builder {
        crate::input::delete_session_input::Builder::default()
    }
}

/// See [`GetSessionInput`](crate::input::GetSessionInput)
pub mod get_session_input {
    /// A builder for [`GetSessionInput`](crate::input::GetSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) checkpoint_label_filter: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>A string used to filter the intents returned in the
        /// <code>recentIntentSummaryView</code> structure. </p>
        /// <p>When you specify a filter, only intents with their
        /// <code>checkpointLabel</code> field set to that string are
        /// returned.</p>
        pub fn checkpoint_label_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.checkpoint_label_filter = Some(input.into());
            self
        }
        /// <p>A string used to filter the intents returned in the
        /// <code>recentIntentSummaryView</code> structure. </p>
        /// <p>When you specify a filter, only intents with their
        /// <code>checkpointLabel</code> field set to that string are
        /// returned.</p>
        pub fn set_checkpoint_label_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.checkpoint_label_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSessionInput`](crate::input::GetSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSessionInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
                checkpoint_label_filter: self.checkpoint_label_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSessionInputOperationOutputAlias = crate::operation::GetSession;
#[doc(hidden)]
pub type GetSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetSession`](crate::operation::GetSession)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.bot_name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_4, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_5 = &_input.bot_alias;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_5, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.user_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_6, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bot/{botName}/alias/{botAlias}/user/{userId}/session",
                botName = bot_name,
                botAlias = bot_alias,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSessionInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_7) = &_input.checkpoint_label_filter {
                query.push_kv(
                    "checkpointLabelFilter",
                    &aws_smithy_http::query::fmt_string(&inner_7),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSession",
            "lexruntimeservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSessionInput`](crate::input::GetSessionInput)
    pub fn builder() -> crate::input::get_session_input::Builder {
        crate::input::get_session_input::Builder::default()
    }
}

/// See [`PostContentInput`](crate::input::PostContentInput)
pub mod post_content_input {
    /// A builder for [`PostContentInput`](crate::input::PostContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) session_attributes: std::option::Option<std::string::String>,
        pub(crate) request_attributes: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<std::string::String>,
        pub(crate) accept: std::option::Option<std::string::String>,
        pub(crate) input_stream: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) active_contexts: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>Name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>Alias of the Amazon Lex bot.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>Alias of the Amazon Lex bot.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. At runtime, each request must contain
        /// the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the
        /// following factors.</p>
        /// <ul>
        /// <li>
        /// <p>The <code>userID</code> field must not contain any personally
        /// identifiable information of the user, for example, name, personal
        /// identification numbers, or other end user personal information.</p>
        /// </li>
        /// <li>
        /// <p>If you want a user to start a conversation on one device and
        /// continue on another device, use a user-specific identifier.</p>
        /// </li>
        /// <li>
        /// <p>If you want the same user to be able to have two independent
        /// conversations on two different devices, choose a device-specific
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>A user can't have two independent conversations with two different
        /// versions of the same bot. For example, a user can't have a
        /// conversation with the PROD and BETA versions of the same bot. If you
        /// anticipate that a user will need to have conversation with two
        /// different versions, for example, while testing, include the bot alias
        /// in the user ID to separate the two conversations.</p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. At runtime, each request must contain
        /// the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the
        /// following factors.</p>
        /// <ul>
        /// <li>
        /// <p>The <code>userID</code> field must not contain any personally
        /// identifiable information of the user, for example, name, personal
        /// identification numbers, or other end user personal information.</p>
        /// </li>
        /// <li>
        /// <p>If you want a user to start a conversation on one device and
        /// continue on another device, use a user-specific identifier.</p>
        /// </li>
        /// <li>
        /// <p>If you want the same user to be able to have two independent
        /// conversations on two different devices, choose a device-specific
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>A user can't have two independent conversations with two different
        /// versions of the same bot. For example, a user can't have a
        /// conversation with the PROD and BETA versions of the same bot. If you
        /// anticipate that a user will need to have conversation with two
        /// different versions, for example, while testing, include the bot alias
        /// in the user ID to separate the two conversations.</p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-session-attributes</code>
        /// HTTP header.</p>
        /// <p>Application-specific information passed between Amazon Lex and a client
        /// application. The value must be a JSON serialized and base64 encoded map
        /// with string keys and values. The total size of the
        /// <code>sessionAttributes</code> and <code>requestAttributes</code>
        /// headers is limited to 12 KB.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn session_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_attributes = Some(input.into());
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-session-attributes</code>
        /// HTTP header.</p>
        /// <p>Application-specific information passed between Amazon Lex and a client
        /// application. The value must be a JSON serialized and base64 encoded map
        /// with string keys and values. The total size of the
        /// <code>sessionAttributes</code> and <code>requestAttributes</code>
        /// headers is limited to 12 KB.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-request-attributes</code>
        /// HTTP header.</p>
        /// <p>Request-specific information passed between Amazon Lex and a client
        /// application. The value must be a JSON serialized and base64 encoded map
        /// with string keys and values. The total size of the
        /// <code>requestAttributes</code> and <code>sessionAttributes</code>
        /// headers is limited to 12 KB.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn request_attributes(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_attributes = Some(input.into());
            self
        }
        /// <p>You pass this value as the <code>x-amz-lex-request-attributes</code>
        /// HTTP header.</p>
        /// <p>Request-specific information passed between Amazon Lex and a client
        /// application. The value must be a JSON serialized and base64 encoded map
        /// with string keys and values. The total size of the
        /// <code>requestAttributes</code> and <code>sessionAttributes</code>
        /// headers is limited to 12 KB.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_attributes = input;
            self
        }
        /// <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>
        /// <p> Indicates the audio format or text. The header value must start with
        /// one of the following prefixes: </p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble; preamble-size=0;
        /// bit-rate=256000; frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>
        /// <p> Indicates the audio format or text. The header value must start with
        /// one of the following prefixes: </p>
        /// <ul>
        /// <li>
        /// <p>PCM format, audio data must be in little-endian byte order.</p>
        /// <ul>
        /// <li>
        /// <p>audio/l16; rate=16000; channels=1</p>
        /// </li>
        /// <li>
        /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
        /// </li>
        /// <li>
        /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
        /// channel-count=1; is-big-endian=false </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Opus format</p>
        /// <ul>
        /// <li>
        /// <p>audio/x-cbr-opus-with-preamble; preamble-size=0;
        /// bit-rate=256000; frame-size-milliseconds=4</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>Text format</p>
        /// <ul>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// <p> You pass this value as the <code>Accept</code> HTTP header. </p>
        /// <p> The message Amazon Lex returns in the response can be either text or
        /// speech based on the <code>Accept</code> HTTP header value in the request. </p>
        /// <ul>
        /// <li>
        /// <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
        /// returns text in the response. </p>
        /// </li>
        /// <li>
        /// <p> If the value begins with <code>audio/</code>, Amazon Lex returns
        /// speech in the response. Amazon Lex uses Amazon Polly to generate the speech
        /// (using the configuration you specified in the <code>Accept</code>
        /// header). For example, if you specify <code>audio/mpeg</code> as the
        /// value, Amazon Lex returns speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> in 16-bit, little endian format.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p> You pass this value as the <code>Accept</code> HTTP header. </p>
        /// <p> The message Amazon Lex returns in the response can be either text or
        /// speech based on the <code>Accept</code> HTTP header value in the request. </p>
        /// <ul>
        /// <li>
        /// <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
        /// returns text in the response. </p>
        /// </li>
        /// <li>
        /// <p> If the value begins with <code>audio/</code>, Amazon Lex returns
        /// speech in the response. Amazon Lex uses Amazon Polly to generate the speech
        /// (using the configuration you specified in the <code>Accept</code>
        /// header). For example, if you specify <code>audio/mpeg</code> as the
        /// value, Amazon Lex returns speech in the MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech returned is
        /// <code>audio/pcm</code> in 16-bit, little endian format.
        /// </p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>audio/mpeg</p>
        /// </li>
        /// <li>
        /// <p>audio/ogg</p>
        /// </li>
        /// <li>
        /// <p>audio/pcm</p>
        /// </li>
        /// <li>
        /// <p>text/plain; charset=utf-8</p>
        /// </li>
        /// <li>
        /// <p>audio/* (defaults to mpeg)</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// <p> User input in PCM or Opus audio format or text format as described in
        /// the <code>Content-Type</code> HTTP header. </p>
        /// <p>You can stream audio data to Amazon Lex or you can create a local buffer
        /// that captures all of the audio data before sending. In general, you get
        /// better performance if you stream audio data rather than buffering the data
        /// locally.</p>
        pub fn input_stream(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.input_stream = Some(input);
            self
        }
        /// <p> User input in PCM or Opus audio format or text format as described in
        /// the <code>Content-Type</code> HTTP header. </p>
        /// <p>You can stream audio data to Amazon Lex or you can create a local buffer
        /// that captures all of the audio data before sending. In general, you get
        /// better performance if you stream audio data rather than buffering the data
        /// locally.</p>
        pub fn set_input_stream(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.input_stream = input;
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_contexts = Some(input.into());
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PostContentInput`](crate::input::PostContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PostContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PostContentInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
                session_attributes: self.session_attributes,
                request_attributes: self.request_attributes,
                content_type: self.content_type,
                accept: self.accept,
                input_stream: self.input_stream.unwrap_or_default(),
                active_contexts: self.active_contexts,
            })
        }
    }
}
#[doc(hidden)]
pub type PostContentInputOperationOutputAlias = crate::operation::PostContent;
#[doc(hidden)]
pub type PostContentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PostContentInput {
    /// Consumes the builder and constructs an Operation<[`PostContent`](crate::operation::PostContent)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostContent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.bot_name;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_8, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.bot_alias;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_9, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.user_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_10, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bot/{botName}/alias/{botAlias}/user/{userId}/content",
                botName = bot_name,
                botAlias = bot_alias,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PostContentInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_11) = &_input.session_attributes {
                let formatted_12 = aws_smithy_types::base64::encode(&inner_11);
                if !formatted_12.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_12;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "session_attributes",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-lex-session-attributes", header_value);
                }
            }
            if let Some(inner_13) = &_input.request_attributes {
                let formatted_14 = aws_smithy_types::base64::encode(&inner_13);
                if !formatted_14.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_14;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "request_attributes",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-lex-request-attributes", header_value);
                }
            }
            if let Some(inner_15) = &_input.content_type {
                let formatted_16 = AsRef::<str>::as_ref(inner_15);
                if !formatted_16.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_16;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "content_type",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Content-Type", header_value);
                }
            }
            if let Some(inner_17) = &_input.accept {
                let formatted_18 = AsRef::<str>::as_ref(inner_17);
                if !formatted_18.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_18;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Accept", header_value);
                }
            }
            if let Some(inner_19) = &_input.active_contexts {
                let formatted_20 = aws_smithy_types::base64::encode(&inner_19);
                if !formatted_20.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_20;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "active_contexts",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &"*** Sensitive Data Redacted ***", err
                            ),
                        })?;
                    builder = builder.header("x-amz-lex-active-contexts", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/octet-stream",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::ser_payload_post_content_input(self.input_stream)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        signing_config.signing_options.content_sha256_header = true;
        request
            .properties_mut()
            .insert(aws_sig_auth::signer::SignableBody::UnsignedPayload);
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PostContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PostContent",
            "lexruntimeservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostContentInput`](crate::input::PostContentInput)
    pub fn builder() -> crate::input::post_content_input::Builder {
        crate::input::post_content_input::Builder::default()
    }
}

/// See [`PostTextInput`](crate::input::PostTextInput)
pub mod post_text_input {
    /// A builder for [`PostTextInput`](crate::input::PostTextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) session_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) request_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) input_text: std::option::Option<std::string::String>,
        pub(crate) active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
    }
    impl Builder {
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The alias of the Amazon Lex bot.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>The alias of the Amazon Lex bot.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. At runtime, each request must contain
        /// the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the
        /// following factors.</p>
        /// <ul>
        /// <li>
        /// <p>The <code>userID</code> field must not contain any personally
        /// identifiable information of the user, for example, name, personal
        /// identification numbers, or other end user personal information.</p>
        /// </li>
        /// <li>
        /// <p>If you want a user to start a conversation on one device and
        /// continue on another device, use a user-specific identifier.</p>
        /// </li>
        /// <li>
        /// <p>If you want the same user to be able to have two independent
        /// conversations on two different devices, choose a device-specific
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>A user can't have two independent conversations with two different
        /// versions of the same bot. For example, a user can't have a
        /// conversation with the PROD and BETA versions of the same bot. If you
        /// anticipate that a user will need to have conversation with two
        /// different versions, for example, while testing, include the bot alias
        /// in the user ID to separate the two conversations.</p>
        /// </li>
        /// </ul>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. At runtime, each request must contain
        /// the <code>userID</code> field.</p>
        /// <p>To decide the user ID to use for your application, consider the
        /// following factors.</p>
        /// <ul>
        /// <li>
        /// <p>The <code>userID</code> field must not contain any personally
        /// identifiable information of the user, for example, name, personal
        /// identification numbers, or other end user personal information.</p>
        /// </li>
        /// <li>
        /// <p>If you want a user to start a conversation on one device and
        /// continue on another device, use a user-specific identifier.</p>
        /// </li>
        /// <li>
        /// <p>If you want the same user to be able to have two independent
        /// conversations on two different devices, choose a device-specific
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>A user can't have two independent conversations with two different
        /// versions of the same bot. For example, a user can't have a
        /// conversation with the PROD and BETA versions of the same bot. If you
        /// anticipate that a user will need to have conversation with two
        /// different versions, for example, while testing, include the bot alias
        /// in the user ID to separate the two conversations.</p>
        /// </li>
        /// </ul>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Adds a key-value pair to `session_attributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Application-specific information passed between Amazon Lex and a client
        /// application.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.session_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.session_attributes = Some(hash_map);
            self
        }
        /// <p>Application-specific information passed between Amazon Lex and a client
        /// application.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// Adds a key-value pair to `request_attributes`.
        ///
        /// To override the contents of this collection use [`set_request_attributes`](Self::set_request_attributes).
        ///
        /// <p>Request-specific information passed between Amazon Lex and a client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn request_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.request_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.request_attributes = Some(hash_map);
            self
        }
        /// <p>Request-specific information passed between Amazon Lex and a client
        /// application.</p>
        /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
        /// attributes. Don't create any request attributes with the prefix
        /// <code>x-amz-lex:</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
        pub fn set_request_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.request_attributes = input;
            self
        }
        /// <p>The text that the user entered (Amazon Lex interprets this text).</p>
        pub fn input_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_text = Some(input.into());
            self
        }
        /// <p>The text that the user entered (Amazon Lex interprets this text).</p>
        pub fn set_input_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_text = input;
            self
        }
        /// Appends an item to `active_contexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: impl Into<crate::model::ActiveContext>) -> Self {
            let mut v = self.active_contexts.unwrap_or_default();
            v.push(input.into());
            self.active_contexts = Some(v);
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PostTextInput`](crate::input::PostTextInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PostTextInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PostTextInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
                session_attributes: self.session_attributes,
                request_attributes: self.request_attributes,
                input_text: self.input_text,
                active_contexts: self.active_contexts,
            })
        }
    }
}
#[doc(hidden)]
pub type PostTextInputOperationOutputAlias = crate::operation::PostText;
#[doc(hidden)]
pub type PostTextInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PostTextInput {
    /// Consumes the builder and constructs an Operation<[`PostText`](crate::operation::PostText)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostText,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostTextInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.bot_name;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_21, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_22 = &_input.bot_alias;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_22, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.user_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_23, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bot/{botName}/alias/{botAlias}/user/{userId}/text",
                botName = bot_name,
                botAlias = bot_alias,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostTextInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostTextInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_post_text(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PostText::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PostText",
                    "lexruntimeservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostTextInput`](crate::input::PostTextInput)
    pub fn builder() -> crate::input::post_text_input::Builder {
        crate::input::post_text_input::Builder::default()
    }
}

/// See [`PutSessionInput`](crate::input::PutSessionInput)
pub mod put_session_input {
    /// A builder for [`PutSessionInput`](crate::input::PutSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) session_attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) dialog_action: std::option::Option<crate::model::DialogAction>,
        pub(crate) recent_intent_summary_view:
            std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        pub(crate) accept: std::option::Option<std::string::String>,
        pub(crate) active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
    }
    impl Builder {
        /// <p>The name of the bot that contains the session data.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that contains the session data.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>The alias in use for the bot that contains the session data.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. </p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The ID of the client application user. Amazon Lex uses this to identify a
        /// user's conversation with your bot. </p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Adds a key-value pair to `session_attributes`.
        ///
        /// To override the contents of this collection use [`set_session_attributes`](Self::set_session_attributes).
        ///
        /// <p>Map of key/value pairs representing the session-specific context
        /// information. It contains application information passed between Amazon Lex and
        /// a client application.</p>
        pub fn session_attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.session_attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.session_attributes = Some(hash_map);
            self
        }
        /// <p>Map of key/value pairs representing the session-specific context
        /// information. It contains application information passed between Amazon Lex and
        /// a client application.</p>
        pub fn set_session_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.session_attributes = input;
            self
        }
        /// <p>Sets the next action that the bot should take to fulfill the
        /// conversation.</p>
        pub fn dialog_action(mut self, input: crate::model::DialogAction) -> Self {
            self.dialog_action = Some(input);
            self
        }
        /// <p>Sets the next action that the bot should take to fulfill the
        /// conversation.</p>
        pub fn set_dialog_action(
            mut self,
            input: std::option::Option<crate::model::DialogAction>,
        ) -> Self {
            self.dialog_action = input;
            self
        }
        /// Appends an item to `recent_intent_summary_view`.
        ///
        /// To override the contents of this collection use [`set_recent_intent_summary_view`](Self::set_recent_intent_summary_view).
        ///
        /// <p>A summary of the recent intents for the bot. You can use the intent
        /// summary view to set a checkpoint label on an intent and modify attributes
        /// of intents. You can also use it to remove or add intent summary objects to
        /// the list.</p>
        /// <p>An intent that you modify or add to the list must make sense for the
        /// bot. For example, the intent name must be valid for the bot. You must
        /// provide valid values for:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>intentName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>slot names</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>slotToElict</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you send the <code>recentIntentSummaryView</code> parameter in a
        /// <code>PutSession</code> request, the contents of the new summary view
        /// replaces the old summary view. For example, if a <code>GetSession</code>
        /// request returns three intents in the summary view and you call
        /// <code>PutSession</code> with one intent in the summary view, the next
        /// call to <code>GetSession</code> will only return one intent.</p>
        pub fn recent_intent_summary_view(
            mut self,
            input: impl Into<crate::model::IntentSummary>,
        ) -> Self {
            let mut v = self.recent_intent_summary_view.unwrap_or_default();
            v.push(input.into());
            self.recent_intent_summary_view = Some(v);
            self
        }
        /// <p>A summary of the recent intents for the bot. You can use the intent
        /// summary view to set a checkpoint label on an intent and modify attributes
        /// of intents. You can also use it to remove or add intent summary objects to
        /// the list.</p>
        /// <p>An intent that you modify or add to the list must make sense for the
        /// bot. For example, the intent name must be valid for the bot. You must
        /// provide valid values for:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>intentName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>slot names</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>slotToElict</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>If you send the <code>recentIntentSummaryView</code> parameter in a
        /// <code>PutSession</code> request, the contents of the new summary view
        /// replaces the old summary view. For example, if a <code>GetSession</code>
        /// request returns three intents in the summary view and you call
        /// <code>PutSession</code> with one intent in the summary view, the next
        /// call to <code>GetSession</code> will only return one intent.</p>
        pub fn set_recent_intent_summary_view(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        ) -> Self {
            self.recent_intent_summary_view = input;
            self
        }
        /// <p>The message that Amazon Lex returns in the response can be either text or
        /// speech based depending on the value of this field.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech
        /// in the response. Amazon Lex uses Amazon Polly to generate the speech in the
        /// configuration that you specify. For example, if you specify
        /// <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the
        /// MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech is returned as
        /// <code>audio/pcm</code> in 16-bit, little endian format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>audio/mpeg</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/ogg</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/pcm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/*</code> (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>text/plain; charset=utf-8</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn accept(mut self, input: impl Into<std::string::String>) -> Self {
            self.accept = Some(input.into());
            self
        }
        /// <p>The message that Amazon Lex returns in the response can be either text or
        /// speech based depending on the value of this field.</p>
        /// <ul>
        /// <li>
        /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
        /// returns text in the response.</p>
        /// </li>
        /// <li>
        /// <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech
        /// in the response. Amazon Lex uses Amazon Polly to generate the speech in the
        /// configuration that you specify. For example, if you specify
        /// <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the
        /// MPEG format.</p>
        /// </li>
        /// <li>
        /// <p>If the value is <code>audio/pcm</code>, the speech is returned as
        /// <code>audio/pcm</code> in 16-bit, little endian format.</p>
        /// </li>
        /// <li>
        /// <p>The following are the accepted values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>audio/mpeg</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/ogg</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/pcm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>audio/*</code> (defaults to mpeg)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>text/plain; charset=utf-8</code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_accept(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.accept = input;
            self
        }
        /// Appends an item to `active_contexts`.
        ///
        /// To override the contents of this collection use [`set_active_contexts`](Self::set_active_contexts).
        ///
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn active_contexts(mut self, input: impl Into<crate::model::ActiveContext>) -> Self {
            let mut v = self.active_contexts.unwrap_or_default();
            v.push(input.into());
            self.active_contexts = Some(v);
            self
        }
        /// <p>A list of contexts active for the request. A context can be activated
        /// when a previous intent is fulfilled, or by including the context in the
        /// request,</p>
        /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
        /// list of contexts for the session. If you specify an empty list, all
        /// contexts for the session are cleared.</p>
        pub fn set_active_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
        ) -> Self {
            self.active_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSessionInput`](crate::input::PutSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSessionInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                user_id: self.user_id,
                session_attributes: self.session_attributes,
                dialog_action: self.dialog_action,
                recent_intent_summary_view: self.recent_intent_summary_view,
                accept: self.accept,
                active_contexts: self.active_contexts,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSessionInputOperationOutputAlias = crate::operation::PutSession;
#[doc(hidden)]
pub type PutSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutSessionInput {
    /// Consumes the builder and constructs an Operation<[`PutSession`](crate::operation::PutSession)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.bot_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_24, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.bot_alias;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_25, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.user_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_26, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bot/{botName}/alias/{botAlias}/user/{userId}/session",
                botName = bot_name,
                botAlias = bot_alias,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn add_headers(
            _input: &crate::input::PutSessionInput,
            mut builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            if let Some(inner_27) = &_input.accept {
                let formatted_28 = AsRef::<str>::as_ref(inner_27);
                if !formatted_28.is_empty() {
                    use std::convert::TryFrom;
                    let header_value = formatted_28;
                    let header_value = http::header::HeaderValue::try_from(&*header_value)
                        .map_err(|err| aws_smithy_http::operation::BuildError::InvalidField {
                            field: "accept",
                            details: format!(
                                "`{}` cannot be used as a header value: {}",
                                &header_value, err
                            ),
                        })?;
                    builder = builder.header("Accept", header_value);
                }
            }
            Ok(builder)
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            let builder = add_headers(input, builder)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_session(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSession",
            "lexruntimeservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSessionInput`](crate::input::PutSessionInput)
    pub fn builder() -> crate::input::put_session_input::Builder {
        crate::input::put_session_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSessionInput {
    /// <p>The name of the bot that contains the session data.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The alias in use for the bot that contains the session data.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the client application user. Amazon Lex uses this to identify a
    /// user's conversation with your bot. </p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Map of key/value pairs representing the session-specific context
    /// information. It contains application information passed between Amazon Lex and
    /// a client application.</p>
    pub session_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Sets the next action that the bot should take to fulfill the
    /// conversation.</p>
    pub dialog_action: std::option::Option<crate::model::DialogAction>,
    /// <p>A summary of the recent intents for the bot. You can use the intent
    /// summary view to set a checkpoint label on an intent and modify attributes
    /// of intents. You can also use it to remove or add intent summary objects to
    /// the list.</p>
    /// <p>An intent that you modify or add to the list must make sense for the
    /// bot. For example, the intent name must be valid for the bot. You must
    /// provide valid values for:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>intentName</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>slot names</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>slotToElict</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>If you send the <code>recentIntentSummaryView</code> parameter in a
    /// <code>PutSession</code> request, the contents of the new summary view
    /// replaces the old summary view. For example, if a <code>GetSession</code>
    /// request returns three intents in the summary view and you call
    /// <code>PutSession</code> with one intent in the summary view, the next
    /// call to <code>GetSession</code> will only return one intent.</p>
    pub recent_intent_summary_view: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
    /// <p>The message that Amazon Lex returns in the response can be either text or
    /// speech based depending on the value of this field.</p>
    /// <ul>
    /// <li>
    /// <p>If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
    /// returns text in the response.</p>
    /// </li>
    /// <li>
    /// <p>If the value begins with <code>audio/</code>, Amazon Lex returns speech
    /// in the response. Amazon Lex uses Amazon Polly to generate the speech in the
    /// configuration that you specify. For example, if you specify
    /// <code>audio/mpeg</code> as the value, Amazon Lex returns speech in the
    /// MPEG format.</p>
    /// </li>
    /// <li>
    /// <p>If the value is <code>audio/pcm</code>, the speech is returned as
    /// <code>audio/pcm</code> in 16-bit, little endian format.</p>
    /// </li>
    /// <li>
    /// <p>The following are the accepted values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>audio/mpeg</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>audio/ogg</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>audio/pcm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>audio/*</code> (defaults to mpeg)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>text/plain; charset=utf-8</code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub accept: std::option::Option<std::string::String>,
    /// <p>A list of contexts active for the request. A context can be activated
    /// when a previous intent is fulfilled, or by including the context in the
    /// request,</p>
    /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
    /// list of contexts for the session. If you specify an empty list, all
    /// contexts for the session are cleared.</p>
    pub active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
}
impl std::fmt::Debug for PutSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSessionInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.field("session_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("dialog_action", &self.dialog_action);
        formatter.field(
            "recent_intent_summary_view",
            &self.recent_intent_summary_view,
        );
        formatter.field("accept", &self.accept);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostTextInput {
    /// <p>The name of the Amazon Lex bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The alias of the Amazon Lex bot.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the client application user. Amazon Lex uses this to identify a
    /// user's conversation with your bot. At runtime, each request must contain
    /// the <code>userID</code> field.</p>
    /// <p>To decide the user ID to use for your application, consider the
    /// following factors.</p>
    /// <ul>
    /// <li>
    /// <p>The <code>userID</code> field must not contain any personally
    /// identifiable information of the user, for example, name, personal
    /// identification numbers, or other end user personal information.</p>
    /// </li>
    /// <li>
    /// <p>If you want a user to start a conversation on one device and
    /// continue on another device, use a user-specific identifier.</p>
    /// </li>
    /// <li>
    /// <p>If you want the same user to be able to have two independent
    /// conversations on two different devices, choose a device-specific
    /// identifier.</p>
    /// </li>
    /// <li>
    /// <p>A user can't have two independent conversations with two different
    /// versions of the same bot. For example, a user can't have a
    /// conversation with the PROD and BETA versions of the same bot. If you
    /// anticipate that a user will need to have conversation with two
    /// different versions, for example, while testing, include the bot alias
    /// in the user ID to separate the two conversations.</p>
    /// </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>Application-specific information passed between Amazon Lex and a client
    /// application.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
    pub session_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Request-specific information passed between Amazon Lex and a client
    /// application.</p>
    /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
    /// attributes. Don't create any request attributes with the prefix
    /// <code>x-amz-lex:</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
    pub request_attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The text that the user entered (Amazon Lex interprets this text).</p>
    pub input_text: std::option::Option<std::string::String>,
    /// <p>A list of contexts active for the request. A context can be activated
    /// when a previous intent is fulfilled, or by including the context in the
    /// request,</p>
    /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
    /// list of contexts for the session. If you specify an empty list, all
    /// contexts for the session are cleared.</p>
    pub active_contexts: std::option::Option<std::vec::Vec<crate::model::ActiveContext>>,
}
impl std::fmt::Debug for PostTextInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostTextInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.field("session_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("request_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("input_text", &"*** Sensitive Data Redacted ***");
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct PostContentInput {
    /// <p>Name of the Amazon Lex bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>Alias of the Amazon Lex bot.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the client application user. Amazon Lex uses this to identify a
    /// user's conversation with your bot. At runtime, each request must contain
    /// the <code>userID</code> field.</p>
    /// <p>To decide the user ID to use for your application, consider the
    /// following factors.</p>
    /// <ul>
    /// <li>
    /// <p>The <code>userID</code> field must not contain any personally
    /// identifiable information of the user, for example, name, personal
    /// identification numbers, or other end user personal information.</p>
    /// </li>
    /// <li>
    /// <p>If you want a user to start a conversation on one device and
    /// continue on another device, use a user-specific identifier.</p>
    /// </li>
    /// <li>
    /// <p>If you want the same user to be able to have two independent
    /// conversations on two different devices, choose a device-specific
    /// identifier.</p>
    /// </li>
    /// <li>
    /// <p>A user can't have two independent conversations with two different
    /// versions of the same bot. For example, a user can't have a
    /// conversation with the PROD and BETA versions of the same bot. If you
    /// anticipate that a user will need to have conversation with two
    /// different versions, for example, while testing, include the bot alias
    /// in the user ID to separate the two conversations.</p>
    /// </li>
    /// </ul>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>You pass this value as the <code>x-amz-lex-session-attributes</code>
    /// HTTP header.</p>
    /// <p>Application-specific information passed between Amazon Lex and a client
    /// application. The value must be a JSON serialized and base64 encoded map
    /// with string keys and values. The total size of the
    /// <code>sessionAttributes</code> and <code>requestAttributes</code>
    /// headers is limited to 12 KB.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs">Setting Session Attributes</a>.</p>
    pub session_attributes: std::option::Option<std::string::String>,
    /// <p>You pass this value as the <code>x-amz-lex-request-attributes</code>
    /// HTTP header.</p>
    /// <p>Request-specific information passed between Amazon Lex and a client
    /// application. The value must be a JSON serialized and base64 encoded map
    /// with string keys and values. The total size of the
    /// <code>requestAttributes</code> and <code>sessionAttributes</code>
    /// headers is limited to 12 KB.</p>
    /// <p>The namespace <code>x-amz-lex:</code> is reserved for special
    /// attributes. Don't create any request attributes with the prefix
    /// <code>x-amz-lex:</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs">Setting Request Attributes</a>.</p>
    pub request_attributes: std::option::Option<std::string::String>,
    /// <p> You pass this value as the <code>Content-Type</code> HTTP header. </p>
    /// <p> Indicates the audio format or text. The header value must start with
    /// one of the following prefixes: </p>
    /// <ul>
    /// <li>
    /// <p>PCM format, audio data must be in little-endian byte order.</p>
    /// <ul>
    /// <li>
    /// <p>audio/l16; rate=16000; channels=1</p>
    /// </li>
    /// <li>
    /// <p>audio/x-l16; sample-rate=16000; channel-count=1</p>
    /// </li>
    /// <li>
    /// <p>audio/lpcm; sample-rate=8000; sample-size-bits=16;
    /// channel-count=1; is-big-endian=false </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Opus format</p>
    /// <ul>
    /// <li>
    /// <p>audio/x-cbr-opus-with-preamble; preamble-size=0;
    /// bit-rate=256000; frame-size-milliseconds=4</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>Text format</p>
    /// <ul>
    /// <li>
    /// <p>text/plain; charset=utf-8</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub content_type: std::option::Option<std::string::String>,
    /// <p> You pass this value as the <code>Accept</code> HTTP header. </p>
    /// <p> The message Amazon Lex returns in the response can be either text or
    /// speech based on the <code>Accept</code> HTTP header value in the request. </p>
    /// <ul>
    /// <li>
    /// <p> If the value is <code>text/plain; charset=utf-8</code>, Amazon Lex
    /// returns text in the response. </p>
    /// </li>
    /// <li>
    /// <p> If the value begins with <code>audio/</code>, Amazon Lex returns
    /// speech in the response. Amazon Lex uses Amazon Polly to generate the speech
    /// (using the configuration you specified in the <code>Accept</code>
    /// header). For example, if you specify <code>audio/mpeg</code> as the
    /// value, Amazon Lex returns speech in the MPEG format.</p>
    /// </li>
    /// <li>
    /// <p>If the value is <code>audio/pcm</code>, the speech returned is
    /// <code>audio/pcm</code> in 16-bit, little endian format.
    /// </p>
    /// </li>
    /// <li>
    /// <p>The following are the accepted values:</p>
    /// <ul>
    /// <li>
    /// <p>audio/mpeg</p>
    /// </li>
    /// <li>
    /// <p>audio/ogg</p>
    /// </li>
    /// <li>
    /// <p>audio/pcm</p>
    /// </li>
    /// <li>
    /// <p>text/plain; charset=utf-8</p>
    /// </li>
    /// <li>
    /// <p>audio/* (defaults to mpeg)</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub accept: std::option::Option<std::string::String>,
    /// <p> User input in PCM or Opus audio format or text format as described in
    /// the <code>Content-Type</code> HTTP header. </p>
    /// <p>You can stream audio data to Amazon Lex or you can create a local buffer
    /// that captures all of the audio data before sending. In general, you get
    /// better performance if you stream audio data rather than buffering the data
    /// locally.</p>
    pub input_stream: aws_smithy_http::byte_stream::ByteStream,
    /// <p>A list of contexts active for the request. A context can be activated
    /// when a previous intent is fulfilled, or by including the context in the
    /// request,</p>
    /// <p>If you don't specify a list of contexts, Amazon Lex will use the current
    /// list of contexts for the session. If you specify an empty list, all
    /// contexts for the session are cleared.</p>
    pub active_contexts: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PostContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostContentInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.field("session_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("request_attributes", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("accept", &self.accept);
        formatter.field("input_stream", &self.input_stream);
        formatter.field("active_contexts", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSessionInput {
    /// <p>The name of the bot that contains the session data.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The alias in use for the bot that contains the session data.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The ID of the client application user. Amazon Lex uses this to identify a
    /// user's conversation with your bot. </p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>A string used to filter the intents returned in the
    /// <code>recentIntentSummaryView</code> structure. </p>
    /// <p>When you specify a filter, only intents with their
    /// <code>checkpointLabel</code> field set to that string are
    /// returned.</p>
    pub checkpoint_label_filter: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSessionInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.field("checkpoint_label_filter", &self.checkpoint_label_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSessionInput {
    /// <p>The name of the bot that contains the session data.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The alias in use for the bot that contains the session data.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The identifier of the user associated with the session data.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSessionInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
