// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSessionError {
    /// Kind of error that occurred.
    pub kind: DeleteSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSessionErrorKind {
    /// <p> Request validation failed, there is no usable message in the context,
    /// or the bot build failed, is still in progress, or contains unbuilt
    /// changes. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> Two clients are using the same AWS account, Amazon Lex bot, and user
    /// ID. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>Internal service error. Retry the call.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>Exceeded a limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
    /// to is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSessionError {
    fn code(&self) -> Option<&str> {
        DeleteSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSessionError {
    /// Creates a new `DeleteSessionError`.
    pub fn new(kind: DeleteSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteSessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteSessionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSessionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSessionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `DeleteSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSessionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSessionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSessionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSessionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSessionError {
    /// Kind of error that occurred.
    pub kind: GetSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSessionErrorKind {
    /// <p> Request validation failed, there is no usable message in the context,
    /// or the bot build failed, is still in progress, or contains unbuilt
    /// changes. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Internal service error. Retry the call.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>Exceeded a limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
    /// to is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSessionError {
    fn code(&self) -> Option<&str> {
        GetSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSessionError {
    /// Creates a new `GetSessionError`.
    pub fn new(kind: GetSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetSessionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `GetSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `GetSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSessionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSessionErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSessionErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PostContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostContentError {
    /// Kind of error that occurred.
    pub kind: PostContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostContentErrorKind {
    /// <p>Either the Amazon Lex bot is still building, or one of the dependent
    /// services (Amazon Polly, AWS Lambda) failed with an internal service
    /// error.</p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p> Request validation failed, there is no usable message in the context,
    /// or the bot build failed, is still in progress, or contains unbuilt
    /// changes. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> Two clients are using the same AWS account, Amazon Lex bot, and user
    /// ID. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> One of the dependencies, such as AWS Lambda or Amazon Polly, threw an
    /// exception. For example, </p>
    /// <ul>
    /// <li>
    /// <p>If Amazon Lex does not have sufficient permissions to call a Lambda
    /// function.</p>
    /// </li>
    /// <li>
    /// <p>If a Lambda function takes longer than 30 seconds to
    /// execute.</p>
    /// </li>
    /// <li>
    /// <p>If a fulfillment Lambda function returns a <code>Delegate</code>
    /// dialog action without removing any slot values.</p>
    /// </li>
    /// </ul>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p>Internal service error. Retry the call.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>Exceeded a limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is not used.</p>
    LoopDetectedException(crate::error::LoopDetectedException),
    /// <p>The accept header in the request does not have a valid value.</p>
    NotAcceptableException(crate::error::NotAcceptableException),
    /// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
    /// to is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The input speech is too long.</p>
    RequestTimeoutException(crate::error::RequestTimeoutException),
    /// <p>The Content-Type header (<code>PostContent</code> API) has an invalid
    /// value. </p>
    UnsupportedMediaTypeException(crate::error::UnsupportedMediaTypeException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostContentErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            PostContentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PostContentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PostContentErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            PostContentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PostContentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PostContentErrorKind::LoopDetectedException(_inner) => _inner.fmt(f),
            PostContentErrorKind::NotAcceptableException(_inner) => _inner.fmt(f),
            PostContentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PostContentErrorKind::RequestTimeoutException(_inner) => _inner.fmt(f),
            PostContentErrorKind::UnsupportedMediaTypeException(_inner) => _inner.fmt(f),
            PostContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostContentError {
    fn code(&self) -> Option<&str> {
        PostContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PostContentError {
    /// Creates a new `PostContentError`.
    pub fn new(kind: PostContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PostContentErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::BadGatewayException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostContentErrorKind::DependencyFailedException(_)
        )
    }
    /// Returns true if the error kind is `PostContentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostContentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `PostContentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::LoopDetectedException`.
    pub fn is_loop_detected_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::LoopDetectedException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::NotAcceptableException`.
    pub fn is_not_acceptable_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::NotAcceptableException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::RequestTimeoutException`.
    pub fn is_request_timeout_exception(&self) -> bool {
        matches!(&self.kind, PostContentErrorKind::RequestTimeoutException(_))
    }
    /// Returns true if the error kind is `PostContentErrorKind::UnsupportedMediaTypeException`.
    pub fn is_unsupported_media_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostContentErrorKind::UnsupportedMediaTypeException(_)
        )
    }
}
impl std::error::Error for PostContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostContentErrorKind::BadGatewayException(_inner) => Some(_inner),
            PostContentErrorKind::BadRequestException(_inner) => Some(_inner),
            PostContentErrorKind::ConflictException(_inner) => Some(_inner),
            PostContentErrorKind::DependencyFailedException(_inner) => Some(_inner),
            PostContentErrorKind::InternalFailureException(_inner) => Some(_inner),
            PostContentErrorKind::LimitExceededException(_inner) => Some(_inner),
            PostContentErrorKind::LoopDetectedException(_inner) => Some(_inner),
            PostContentErrorKind::NotAcceptableException(_inner) => Some(_inner),
            PostContentErrorKind::NotFoundException(_inner) => Some(_inner),
            PostContentErrorKind::RequestTimeoutException(_inner) => Some(_inner),
            PostContentErrorKind::UnsupportedMediaTypeException(_inner) => Some(_inner),
            PostContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PostText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostTextError {
    /// Kind of error that occurred.
    pub kind: PostTextErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostText` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostTextErrorKind {
    /// <p>Either the Amazon Lex bot is still building, or one of the dependent
    /// services (Amazon Polly, AWS Lambda) failed with an internal service
    /// error.</p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p> Request validation failed, there is no usable message in the context,
    /// or the bot build failed, is still in progress, or contains unbuilt
    /// changes. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> Two clients are using the same AWS account, Amazon Lex bot, and user
    /// ID. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> One of the dependencies, such as AWS Lambda or Amazon Polly, threw an
    /// exception. For example, </p>
    /// <ul>
    /// <li>
    /// <p>If Amazon Lex does not have sufficient permissions to call a Lambda
    /// function.</p>
    /// </li>
    /// <li>
    /// <p>If a Lambda function takes longer than 30 seconds to
    /// execute.</p>
    /// </li>
    /// <li>
    /// <p>If a fulfillment Lambda function returns a <code>Delegate</code>
    /// dialog action without removing any slot values.</p>
    /// </li>
    /// </ul>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p>Internal service error. Retry the call.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>Exceeded a limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This exception is not used.</p>
    LoopDetectedException(crate::error::LoopDetectedException),
    /// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
    /// to is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostTextError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostTextErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            PostTextErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PostTextErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PostTextErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            PostTextErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PostTextErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PostTextErrorKind::LoopDetectedException(_inner) => _inner.fmt(f),
            PostTextErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PostTextErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostTextError {
    fn code(&self) -> Option<&str> {
        PostTextError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PostTextError {
    /// Creates a new `PostTextError`.
    pub fn new(kind: PostTextErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostTextError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostTextErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostTextError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostTextErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PostTextErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::BadGatewayException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::DependencyFailedException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::LoopDetectedException`.
    pub fn is_loop_detected_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::LoopDetectedException(_))
    }
    /// Returns true if the error kind is `PostTextErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PostTextErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for PostTextError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostTextErrorKind::BadGatewayException(_inner) => Some(_inner),
            PostTextErrorKind::BadRequestException(_inner) => Some(_inner),
            PostTextErrorKind::ConflictException(_inner) => Some(_inner),
            PostTextErrorKind::DependencyFailedException(_inner) => Some(_inner),
            PostTextErrorKind::InternalFailureException(_inner) => Some(_inner),
            PostTextErrorKind::LimitExceededException(_inner) => Some(_inner),
            PostTextErrorKind::LoopDetectedException(_inner) => Some(_inner),
            PostTextErrorKind::NotFoundException(_inner) => Some(_inner),
            PostTextErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSessionError {
    /// Kind of error that occurred.
    pub kind: PutSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSessionErrorKind {
    /// <p>Either the Amazon Lex bot is still building, or one of the dependent
    /// services (Amazon Polly, AWS Lambda) failed with an internal service
    /// error.</p>
    BadGatewayException(crate::error::BadGatewayException),
    /// <p> Request validation failed, there is no usable message in the context,
    /// or the bot build failed, is still in progress, or contains unbuilt
    /// changes. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> Two clients are using the same AWS account, Amazon Lex bot, and user
    /// ID. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> One of the dependencies, such as AWS Lambda or Amazon Polly, threw an
    /// exception. For example, </p>
    /// <ul>
    /// <li>
    /// <p>If Amazon Lex does not have sufficient permissions to call a Lambda
    /// function.</p>
    /// </li>
    /// <li>
    /// <p>If a Lambda function takes longer than 30 seconds to
    /// execute.</p>
    /// </li>
    /// <li>
    /// <p>If a fulfillment Lambda function returns a <code>Delegate</code>
    /// dialog action without removing any slot values.</p>
    /// </li>
    /// </ul>
    DependencyFailedException(crate::error::DependencyFailedException),
    /// <p>Internal service error. Retry the call.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>Exceeded a limit.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The accept header in the request does not have a valid value.</p>
    NotAcceptableException(crate::error::NotAcceptableException),
    /// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
    /// to is not found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSessionErrorKind::BadGatewayException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::DependencyFailedException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::NotAcceptableException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSessionError {
    fn code(&self) -> Option<&str> {
        PutSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSessionError {
    /// Creates a new `PutSessionError`.
    pub fn new(kind: PutSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutSessionErrorKind::BadGatewayException`.
    pub fn is_bad_gateway_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::BadGatewayException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::DependencyFailedException`.
    pub fn is_dependency_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSessionErrorKind::DependencyFailedException(_)
        )
    }
    /// Returns true if the error kind is `PutSessionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::NotAcceptableException`.
    pub fn is_not_acceptable_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::NotAcceptableException(_))
    }
    /// Returns true if the error kind is `PutSessionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutSessionErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for PutSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSessionErrorKind::BadGatewayException(_inner) => Some(_inner),
            PutSessionErrorKind::BadRequestException(_inner) => Some(_inner),
            PutSessionErrorKind::ConflictException(_inner) => Some(_inner),
            PutSessionErrorKind::DependencyFailedException(_inner) => Some(_inner),
            PutSessionErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutSessionErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutSessionErrorKind::NotAcceptableException(_inner) => Some(_inner),
            PutSessionErrorKind::NotFoundException(_inner) => Some(_inner),
            PutSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The resource (such as the Amazon Lex bot or an alias) that is referred
/// to is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The accept header in the request does not have a valid value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotAcceptableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotAcceptableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotAcceptableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotAcceptableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotAcceptableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotAcceptableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotAcceptableException {}
/// See [`NotAcceptableException`](crate::error::NotAcceptableException)
pub mod not_acceptable_exception {
    /// A builder for [`NotAcceptableException`](crate::error::NotAcceptableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotAcceptableException`](crate::error::NotAcceptableException)
        pub fn build(self) -> crate::error::NotAcceptableException {
            crate::error::NotAcceptableException {
                message: self.message,
            }
        }
    }
}
impl NotAcceptableException {
    /// Creates a new builder-style object to manufacture [`NotAcceptableException`](crate::error::NotAcceptableException)
    pub fn builder() -> crate::error::not_acceptable_exception::Builder {
        crate::error::not_acceptable_exception::Builder::default()
    }
}

/// <p>Exceeded a limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Internal service error. Retry the call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p> One of the dependencies, such as AWS Lambda or Amazon Polly, threw an
/// exception. For example, </p>
/// <ul>
/// <li>
/// <p>If Amazon Lex does not have sufficient permissions to call a Lambda
/// function.</p>
/// </li>
/// <li>
/// <p>If a Lambda function takes longer than 30 seconds to
/// execute.</p>
/// </li>
/// <li>
/// <p>If a fulfillment Lambda function returns a <code>Delegate</code>
/// dialog action without removing any slot values.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependencyFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependencyFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependencyFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependencyFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependencyFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependencyFailedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependencyFailedException {}
/// See [`DependencyFailedException`](crate::error::DependencyFailedException)
pub mod dependency_failed_exception {
    /// A builder for [`DependencyFailedException`](crate::error::DependencyFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependencyFailedException`](crate::error::DependencyFailedException)
        pub fn build(self) -> crate::error::DependencyFailedException {
            crate::error::DependencyFailedException {
                message: self.message,
            }
        }
    }
}
impl DependencyFailedException {
    /// Creates a new builder-style object to manufacture [`DependencyFailedException`](crate::error::DependencyFailedException)
    pub fn builder() -> crate::error::dependency_failed_exception::Builder {
        crate::error::dependency_failed_exception::Builder::default()
    }
}

/// <p> Two clients are using the same AWS account, Amazon Lex bot, and user
/// ID. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p> Request validation failed, there is no usable message in the context,
/// or the bot build failed, is still in progress, or contains unbuilt
/// changes. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>Either the Amazon Lex bot is still building, or one of the dependent
/// services (Amazon Polly, AWS Lambda) failed with an internal service
/// error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadGatewayException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadGatewayException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadGatewayException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadGatewayException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadGatewayException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadGatewayException {}
/// See [`BadGatewayException`](crate::error::BadGatewayException)
pub mod bad_gateway_exception {
    /// A builder for [`BadGatewayException`](crate::error::BadGatewayException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadGatewayException`](crate::error::BadGatewayException)
        pub fn build(self) -> crate::error::BadGatewayException {
            crate::error::BadGatewayException {
                message: self.message,
            }
        }
    }
}
impl BadGatewayException {
    /// Creates a new builder-style object to manufacture [`BadGatewayException`](crate::error::BadGatewayException)
    pub fn builder() -> crate::error::bad_gateway_exception::Builder {
        crate::error::bad_gateway_exception::Builder::default()
    }
}

/// <p>This exception is not used.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoopDetectedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoopDetectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoopDetectedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LoopDetectedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LoopDetectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LoopDetectedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for LoopDetectedException {}
/// See [`LoopDetectedException`](crate::error::LoopDetectedException)
pub mod loop_detected_exception {
    /// A builder for [`LoopDetectedException`](crate::error::LoopDetectedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LoopDetectedException`](crate::error::LoopDetectedException)
        pub fn build(self) -> crate::error::LoopDetectedException {
            crate::error::LoopDetectedException {
                message: self.message,
            }
        }
    }
}
impl LoopDetectedException {
    /// Creates a new builder-style object to manufacture [`LoopDetectedException`](crate::error::LoopDetectedException)
    pub fn builder() -> crate::error::loop_detected_exception::Builder {
        crate::error::loop_detected_exception::Builder::default()
    }
}

/// <p>The Content-Type header (<code>PostContent</code> API) has an invalid
/// value. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedMediaTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedMediaTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedMediaTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedMediaTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedMediaTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedMediaTypeException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedMediaTypeException {}
/// See [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
pub mod unsupported_media_type_exception {
    /// A builder for [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
        pub fn build(self) -> crate::error::UnsupportedMediaTypeException {
            crate::error::UnsupportedMediaTypeException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedMediaTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
    pub fn builder() -> crate::error::unsupported_media_type_exception::Builder {
        crate::error::unsupported_media_type_exception::Builder::default()
    }
}

/// <p>The input speech is too long.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestTimeoutException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestTimeoutException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestTimeoutException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestTimeoutException {}
/// See [`RequestTimeoutException`](crate::error::RequestTimeoutException)
pub mod request_timeout_exception {
    /// A builder for [`RequestTimeoutException`](crate::error::RequestTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestTimeoutException`](crate::error::RequestTimeoutException)
        pub fn build(self) -> crate::error::RequestTimeoutException {
            crate::error::RequestTimeoutException {
                message: self.message,
            }
        }
    }
}
impl RequestTimeoutException {
    /// Creates a new builder-style object to manufacture [`RequestTimeoutException`](crate::error::RequestTimeoutException)
    pub fn builder() -> crate::error::request_timeout_exception::Builder {
        crate::error::request_timeout_exception::Builder::default()
    }
}
