// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BuildBotLocaleInput`](crate::input::BuildBotLocaleInput)
pub mod build_bot_locale_input {
    /// A builder for [`BuildBotLocaleInput`](crate::input::BuildBotLocaleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildBotLocaleInput`](crate::input::BuildBotLocaleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BuildBotLocaleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BuildBotLocaleInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type BuildBotLocaleInputOperationOutputAlias = crate::operation::BuildBotLocale;
#[doc(hidden)]
pub type BuildBotLocaleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BuildBotLocaleInput {
    /// Consumes the builder and constructs an Operation<[`BuildBotLocale`](crate::operation::BuildBotLocale)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BuildBotLocale,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BuildBotLocaleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.bot_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_1, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.bot_version;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_2, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_3 = &_input.locale_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_3, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BuildBotLocaleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BuildBotLocaleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BuildBotLocale::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BuildBotLocale",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BuildBotLocaleInput`](crate::input::BuildBotLocaleInput)
    pub fn builder() -> crate::input::build_bot_locale_input::Builder {
        crate::input::build_bot_locale_input::Builder::default()
    }
}

/// See [`CreateBotInput`](crate::input::CreateBotInput)
pub mod create_bot_input {
    /// A builder for [`CreateBotInput`](crate::input::CreateBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) test_bot_alias_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// Adds a key-value pair to `bot_tags`.
        ///
        /// To override the contents of this collection use [`set_bot_tags`](Self::set_bot_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn bot_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.bot_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.bot_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_bot_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.bot_tags = input;
            self
        }
        /// Adds a key-value pair to `test_bot_alias_tags`.
        ///
        /// To override the contents of this collection use [`set_test_bot_alias_tags`](Self::set_test_bot_alias_tags).
        ///
        /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
        pub fn test_bot_alias_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.test_bot_alias_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.test_bot_alias_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
        pub fn set_test_bot_alias_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.test_bot_alias_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotInput`](crate::input::CreateBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateBotInput {
                bot_name: self.bot_name,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_tags: self.bot_tags,
                test_bot_alias_tags: self.test_bot_alias_tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotInputOperationOutputAlias = crate::operation::CreateBot;
#[doc(hidden)]
pub type CreateBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBotInput {
    /// Consumes the builder and constructs an Operation<[`CreateBot`](crate::operation::CreateBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/bots").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateBot",
                    "lexmodelsv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotInput`](crate::input::CreateBotInput)
    pub fn builder() -> crate::input::create_bot_input::Builder {
        crate::input::create_bot_input::Builder::default()
    }
}

/// See [`CreateBotAliasInput`](crate::input::CreateBotAliasInput)
pub mod create_bot_alias_input {
    /// A builder for [`CreateBotAliasInput`](crate::input::CreateBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_locale_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
        >,
        pub(crate) conversation_log_settings:
            std::option::Option<crate::model::ConversationLogSettings>,
        pub(crate) sentiment_analysis_settings:
            std::option::Option<crate::model::SentimentAnalysisSettings>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>A description of the alias. Use this description to help identify the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias. Use this description to help identify the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_alias_locale_settings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            let mut hash_map = self.bot_alias_locale_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_alias_locale_settings = Some(hash_map);
            self
        }
        /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.bot_alias_locale_settings = input;
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.conversation_log_settings = Some(input);
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.conversation_log_settings = input;
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.sentiment_analysis_settings = Some(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.sentiment_analysis_settings = input;
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotAliasInput`](crate::input::CreateBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBotAliasInput {
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_locale_settings: self.bot_alias_locale_settings,
                conversation_log_settings: self.conversation_log_settings,
                sentiment_analysis_settings: self.sentiment_analysis_settings,
                bot_id: self.bot_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotAliasInputOperationOutputAlias = crate::operation::CreateBotAlias;
#[doc(hidden)]
pub type CreateBotAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateBotAlias`](crate::operation::CreateBotAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBotAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.bot_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_4, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botaliases", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bot_alias(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBotAlias",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotAliasInput`](crate::input::CreateBotAliasInput)
    pub fn builder() -> crate::input::create_bot_alias_input::Builder {
        crate::input::create_bot_alias_input::Builder::default()
    }
}

/// See [`CreateBotLocaleInput`](crate::input::CreateBotLocaleInput)
pub mod create_bot_locale_input {
    /// A builder for [`CreateBotLocaleInput`](crate::input::CreateBotLocaleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
    }
    impl Builder {
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotLocaleInput`](crate::input::CreateBotLocaleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBotLocaleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBotLocaleInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                description: self.description,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotLocaleInputOperationOutputAlias = crate::operation::CreateBotLocale;
#[doc(hidden)]
pub type CreateBotLocaleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBotLocaleInput {
    /// Consumes the builder and constructs an Operation<[`CreateBotLocale`](crate::operation::CreateBotLocale)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBotLocale,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotLocaleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.bot_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_5, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.bot_version;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_6, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales",
                botId = bot_id,
                botVersion = bot_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotLocaleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotLocaleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bot_locale(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBotLocale::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBotLocale",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotLocaleInput`](crate::input::CreateBotLocaleInput)
    pub fn builder() -> crate::input::create_bot_locale_input::Builder {
        crate::input::create_bot_locale_input::Builder::default()
    }
}

/// See [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
pub mod create_bot_version_input {
    /// A builder for [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version_locale_specification: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>A description of the version. Use the description to help identify the version in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the version. Use the description to help identify the version in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `bot_version_locale_specification`.
        ///
        /// To override the contents of this collection use [`set_bot_version_locale_specification`](Self::set_bot_version_locale_specification).
        ///
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
        pub fn bot_version_locale_specification(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotVersionLocaleDetails,
        ) -> Self {
            let mut hash_map = self.bot_version_locale_specification.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_version_locale_specification = Some(hash_map);
            self
        }
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
        pub fn set_bot_version_locale_specification(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotVersionLocaleDetails,
                >,
            >,
        ) -> Self {
            self.bot_version_locale_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBotVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBotVersionInput {
                bot_id: self.bot_id,
                description: self.description,
                bot_version_locale_specification: self.bot_version_locale_specification,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotVersionInputOperationOutputAlias = crate::operation::CreateBotVersion;
#[doc(hidden)]
pub type CreateBotVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBotVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateBotVersion`](crate::operation::CreateBotVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBotVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.bot_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_7, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bot_version(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBotVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBotVersion",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    pub fn builder() -> crate::input::create_bot_version_input::Builder {
        crate::input::create_bot_version_input::Builder::default()
    }
}

/// See [`CreateExportInput`](crate::input::CreateExportInput)
pub mod create_export_input {
    /// A builder for [`CreateExportInput`](crate::input::CreateExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_specification:
            std::option::Option<crate::model::ExportResourceSpecification>,
        pub(crate) file_format: std::option::Option<crate::model::ImportExportFileFormat>,
        pub(crate) file_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_password = Some(input.into());
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_password = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExportInput`](crate::input::CreateExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateExportInput {
                resource_specification: self.resource_specification,
                file_format: self.file_format,
                file_password: self.file_password,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateExportInputOperationOutputAlias = crate::operation::CreateExport;
#[doc(hidden)]
pub type CreateExportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateExportInput {
    /// Consumes the builder and constructs an Operation<[`CreateExport`](crate::operation::CreateExport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateExport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/exports").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_export(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateExport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateExport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateExportInput`](crate::input::CreateExportInput)
    pub fn builder() -> crate::input::create_export_input::Builder {
        crate::input::create_export_input::Builder::default()
    }
}

/// See [`CreateIntentInput`](crate::input::CreateIntentInput)
pub mod create_intent_input {
    /// A builder for [`CreateIntentInput`](crate::input::CreateIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
        pub(crate) fulfillment_code_hook:
            std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        pub(crate) intent_confirmation_setting:
            std::option::Option<crate::model::IntentConfirmationSetting>,
        pub(crate) intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input);
            self.sample_utterances = Some(v);
            self
        }
        /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.fulfillment_code_hook = Some(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.fulfillment_code_hook = input;
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.intent_confirmation_setting = Some(input);
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.intent_confirmation_setting = input;
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.intent_closing_setting = Some(input);
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.intent_closing_setting = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
        /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input);
            self.input_contexts = Some(v);
            self
        }
        /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
        /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input);
            self.output_contexts = Some(v);
            self
        }
        /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the version of the bot associated with this intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with this intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntentInput`](crate::input::CreateIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntentInput {
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                sample_utterances: self.sample_utterances,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_code_hook: self.fulfillment_code_hook,
                intent_confirmation_setting: self.intent_confirmation_setting,
                intent_closing_setting: self.intent_closing_setting,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                kendra_configuration: self.kendra_configuration,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntentInputOperationOutputAlias = crate::operation::CreateIntent;
#[doc(hidden)]
pub type CreateIntentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIntentInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntent`](crate::operation::CreateIntent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.bot_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_8, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.bot_version;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_9, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.locale_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_10, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_intent(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntent",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIntentInput`](crate::input::CreateIntentInput)
    pub fn builder() -> crate::input::create_intent_input::Builder {
        crate::input::create_intent_input::Builder::default()
    }
}

/// See [`CreateResourcePolicyInput`](crate::input::CreateResourcePolicyInput)
pub mod create_resource_policy_input {
    /// A builder for [`CreateResourcePolicyInput`](crate::input::CreateResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourcePolicyInput`](crate::input::CreateResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourcePolicyInput {
                resource_arn: self.resource_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourcePolicyInputOperationOutputAlias = crate::operation::CreateResourcePolicy;
#[doc(hidden)]
pub type CreateResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourcePolicy`](crate::operation::CreateResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.resource_arn;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_11, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_resource_policy(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourcePolicy",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyInput`](crate::input::CreateResourcePolicyInput)
    pub fn builder() -> crate::input::create_resource_policy_input::Builder {
        crate::input::create_resource_policy_input::Builder::default()
    }
}

/// See [`CreateResourcePolicyStatementInput`](crate::input::CreateResourcePolicyStatementInput)
pub mod create_resource_policy_statement_input {
    /// A builder for [`CreateResourcePolicyStatementInput`](crate::input::CreateResourcePolicyStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) effect: std::option::Option<crate::model::Effect>,
        pub(crate) principal: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        pub(crate) action: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) condition: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        >,
        pub(crate) expected_revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>Determines whether the statement allows or denies access to the resource.</p>
        pub fn effect(mut self, input: crate::model::Effect) -> Self {
            self.effect = Some(input);
            self
        }
        /// <p>Determines whether the statement allows or denies access to the resource.</p>
        pub fn set_effect(mut self, input: std::option::Option<crate::model::Effect>) -> Self {
            self.effect = input;
            self
        }
        /// Appends an item to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn principal(mut self, input: crate::model::Principal) -> Self {
            let mut v = self.principal.unwrap_or_default();
            v.push(input);
            self.principal = Some(v);
            self
        }
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.principal = input;
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.action.unwrap_or_default();
            v.push(input.into());
            self.action = Some(v);
            self
        }
        /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            let mut hash_map = self.condition.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.condition = Some(hash_map);
            self
        }
        /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.condition = input;
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourcePolicyStatementInput`](crate::input::CreateResourcePolicyStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResourcePolicyStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResourcePolicyStatementInput {
                resource_arn: self.resource_arn,
                statement_id: self.statement_id,
                effect: self.effect,
                principal: self.principal,
                action: self.action,
                condition: self.condition,
                expected_revision_id: self.expected_revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResourcePolicyStatementInputOperationOutputAlias =
    crate::operation::CreateResourcePolicyStatement;
#[doc(hidden)]
pub type CreateResourcePolicyStatementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateResourcePolicyStatementInput {
    /// Consumes the builder and constructs an Operation<[`CreateResourcePolicyStatement`](crate::operation::CreateResourcePolicyStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResourcePolicyStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateResourcePolicyStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.resource_arn;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_12, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/policy/{resourceArn}/statements",
                resourceArn = resource_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::CreateResourcePolicyStatementInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.expected_revision_id {
                query.push_kv(
                    "expectedRevisionId",
                    &aws_smithy_http::query::fmt_string(&inner_13),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateResourcePolicyStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateResourcePolicyStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_resource_policy_statement(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResourcePolicyStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResourcePolicyStatement",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyStatementInput`](crate::input::CreateResourcePolicyStatementInput)
    pub fn builder() -> crate::input::create_resource_policy_statement_input::Builder {
        crate::input::create_resource_policy_statement_input::Builder::default()
    }
}

/// See [`CreateSlotInput`](crate::input::CreateSlotInput)
pub mod create_slot_input {
    /// A builder for [`CreateSlotInput`](crate::input::CreateSlotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_setting:
            std::option::Option<crate::model::SlotValueElicitationSetting>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) multiple_values_setting:
            std::option::Option<crate::model::MultipleValuesSetting>,
    }
    impl Builder {
        /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.value_elicitation_setting = Some(input);
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.value_elicitation_setting = input;
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.multiple_values_setting = Some(input);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.multiple_values_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotInput`](crate::input::CreateSlotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSlotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSlotInput {
                slot_name: self.slot_name,
                description: self.description,
                slot_type_id: self.slot_type_id,
                value_elicitation_setting: self.value_elicitation_setting,
                obfuscation_setting: self.obfuscation_setting,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                multiple_values_setting: self.multiple_values_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSlotInputOperationOutputAlias = crate::operation::CreateSlot;
#[doc(hidden)]
pub type CreateSlotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSlotInput {
    /// Consumes the builder and constructs an Operation<[`CreateSlot`](crate::operation::CreateSlot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSlot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSlotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.bot_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_14, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.bot_version;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_15, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.locale_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_16, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.intent_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_17, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots", botId = bot_id, botVersion = bot_version, localeId = locale_id, intentId = intent_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSlotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSlotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_slot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSlot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSlot",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSlotInput`](crate::input::CreateSlotInput)
    pub fn builder() -> crate::input::create_slot_input::Builder {
        crate::input::create_slot_input::Builder::default()
    }
}

/// See [`CreateSlotTypeInput`](crate::input::CreateSlotTypeInput)
pub mod create_slot_type_input {
    /// A builder for [`CreateSlotTypeInput`](crate::input::CreateSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_values:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        pub(crate) value_selection_setting:
            std::option::Option<crate::model::SlotValueSelectionSetting>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) external_source_setting:
            std::option::Option<crate::model::ExternalSourceSetting>,
    }
    impl Builder {
        /// <p>The name for the slot. A slot type name must be unique within the account.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The name for the slot. A slot type name must be unique within the account.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slot_type_values`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            let mut v = self.slot_type_values.unwrap_or_default();
            v.push(input);
            self.slot_type_values = Some(v);
            self
        }
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.slot_type_values = input;
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.value_selection_setting = Some(input);
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.value_selection_setting = input;
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the bot version associated with this slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the bot version associated with this slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Sets the type of external information used to create the slot type.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.external_source_setting = Some(input);
            self
        }
        /// <p>Sets the type of external information used to create the slot type.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.external_source_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotTypeInput`](crate::input::CreateSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSlotTypeInput {
                slot_type_name: self.slot_type_name,
                description: self.description,
                slot_type_values: self.slot_type_values,
                value_selection_setting: self.value_selection_setting,
                parent_slot_type_signature: self.parent_slot_type_signature,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                external_source_setting: self.external_source_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSlotTypeInputOperationOutputAlias = crate::operation::CreateSlotType;
#[doc(hidden)]
pub type CreateSlotTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateSlotType`](crate::operation::CreateSlotType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSlotType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.bot_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_18, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.bot_version;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_19, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.locale_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_20, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_slot_type(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSlotType",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeInput`](crate::input::CreateSlotTypeInput)
    pub fn builder() -> crate::input::create_slot_type_input::Builder {
        crate::input::create_slot_type_input::Builder::default()
    }
}

/// See [`CreateUploadUrlInput`](crate::input::CreateUploadUrlInput)
pub mod create_upload_url_input {
    /// A builder for [`CreateUploadUrlInput`](crate::input::CreateUploadUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateUploadUrlInput`](crate::input::CreateUploadUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUploadUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUploadUrlInput {})
        }
    }
}
#[doc(hidden)]
pub type CreateUploadUrlInputOperationOutputAlias = crate::operation::CreateUploadUrl;
#[doc(hidden)]
pub type CreateUploadUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUploadUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreateUploadUrl`](crate::operation::CreateUploadUrl)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUploadUrl,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUploadUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/createuploadurl").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUploadUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUploadUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUploadUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUploadUrl",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUploadUrlInput`](crate::input::CreateUploadUrlInput)
    pub fn builder() -> crate::input::create_upload_url_input::Builder {
        crate::input::create_upload_url_input::Builder::default()
    }
}

/// See [`DeleteBotInput`](crate::input::DeleteBotInput)
pub mod delete_bot_input {
    /// A builder for [`DeleteBotInput`](crate::input::DeleteBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) skip_resource_in_use_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the bot to delete. </p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to delete. </p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.skip_resource_in_use_check = Some(input);
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_resource_in_use_check = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotInput`](crate::input::DeleteBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteBotInput {
                bot_id: self.bot_id,
                skip_resource_in_use_check: self.skip_resource_in_use_check.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotInputOperationOutputAlias = crate::operation::DeleteBot;
#[doc(hidden)]
pub type DeleteBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBot`](crate::operation::DeleteBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.bot_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_21, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}", botId = bot_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteBotInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.skip_resource_in_use_check {
                query.push_kv(
                    "skipResourceInUseCheck",
                    aws_smithy_types::primitive::Encoder::from(_input.skip_resource_in_use_check)
                        .encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteBot",
                    "lexmodelsv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotInput`](crate::input::DeleteBotInput)
    pub fn builder() -> crate::input::delete_bot_input::Builder {
        crate::input::delete_bot_input::Builder::default()
    }
}

/// See [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
pub mod delete_bot_alias_input {
    /// A builder for [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) skip_resource_in_use_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to delete.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.skip_resource_in_use_check = Some(input);
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_resource_in_use_check = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotAliasInput {
                bot_alias_id: self.bot_alias_id,
                bot_id: self.bot_id,
                skip_resource_in_use_check: self.skip_resource_in_use_check.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotAliasInputOperationOutputAlias = crate::operation::DeleteBotAlias;
#[doc(hidden)]
pub type DeleteBotAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotAlias`](crate::operation::DeleteBotAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.bot_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_22, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.bot_alias_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_23, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botaliases/{botAliasId}",
                botId = bot_id,
                botAliasId = bot_alias_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteBotAliasInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.skip_resource_in_use_check {
                query.push_kv(
                    "skipResourceInUseCheck",
                    aws_smithy_types::primitive::Encoder::from(_input.skip_resource_in_use_check)
                        .encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotAlias",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    pub fn builder() -> crate::input::delete_bot_alias_input::Builder {
        crate::input::delete_bot_alias_input::Builder::default()
    }
}

/// See [`DeleteBotLocaleInput`](crate::input::DeleteBotLocaleInput)
pub mod delete_bot_locale_input {
    /// A builder for [`DeleteBotLocaleInput`](crate::input::DeleteBotLocaleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotLocaleInput`](crate::input::DeleteBotLocaleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotLocaleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotLocaleInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotLocaleInputOperationOutputAlias = crate::operation::DeleteBotLocale;
#[doc(hidden)]
pub type DeleteBotLocaleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBotLocaleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotLocale`](crate::operation::DeleteBotLocale)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotLocale,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotLocaleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.bot_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_24, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.bot_version;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_25, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.locale_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_26, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotLocaleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotLocaleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotLocale::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotLocale",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotLocaleInput`](crate::input::DeleteBotLocaleInput)
    pub fn builder() -> crate::input::delete_bot_locale_input::Builder {
        crate::input::delete_bot_locale_input::Builder::default()
    }
}

/// See [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
pub mod delete_bot_version_input {
    /// A builder for [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) skip_resource_in_use_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.skip_resource_in_use_check = Some(input);
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_resource_in_use_check = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotVersionInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                skip_resource_in_use_check: self.skip_resource_in_use_check.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotVersionInputOperationOutputAlias = crate::operation::DeleteBotVersion;
#[doc(hidden)]
pub type DeleteBotVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBotVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotVersion`](crate::operation::DeleteBotVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.bot_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_27, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.bot_version;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_28, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}",
                botId = bot_id,
                botVersion = bot_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteBotVersionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.skip_resource_in_use_check {
                query.push_kv(
                    "skipResourceInUseCheck",
                    aws_smithy_types::primitive::Encoder::from(_input.skip_resource_in_use_check)
                        .encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotVersion",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    pub fn builder() -> crate::input::delete_bot_version_input::Builder {
        crate::input::delete_bot_version_input::Builder::default()
    }
}

/// See [`DeleteCustomVocabularyInput`](crate::input::DeleteCustomVocabularyInput)
pub mod delete_custom_vocabulary_input {
    /// A builder for [`DeleteCustomVocabularyInput`](crate::input::DeleteCustomVocabularyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to remove the custom vocabulary from.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to remove the custom vocabulary from.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomVocabularyInput`](crate::input::DeleteCustomVocabularyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomVocabularyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomVocabularyInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomVocabularyInputOperationOutputAlias = crate::operation::DeleteCustomVocabulary;
#[doc(hidden)]
pub type DeleteCustomVocabularyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomVocabularyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomVocabulary`](crate::operation::DeleteCustomVocabulary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomVocabulary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomVocabularyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.bot_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_29, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.bot_version;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_30, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.locale_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_31, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomVocabularyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomVocabularyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomVocabulary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomVocabulary",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomVocabularyInput`](crate::input::DeleteCustomVocabularyInput)
    pub fn builder() -> crate::input::delete_custom_vocabulary_input::Builder {
        crate::input::delete_custom_vocabulary_input::Builder::default()
    }
}

/// See [`DeleteExportInput`](crate::input::DeleteExportInput)
pub mod delete_export_input {
    /// A builder for [`DeleteExportInput`](crate::input::DeleteExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the export to delete.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the export to delete.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExportInput`](crate::input::DeleteExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteExportInput {
                export_id: self.export_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteExportInputOperationOutputAlias = crate::operation::DeleteExport;
#[doc(hidden)]
pub type DeleteExportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteExportInput {
    /// Consumes the builder and constructs an Operation<[`DeleteExport`](crate::operation::DeleteExport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteExport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.export_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "export_id",
                        details: "cannot be empty or unset",
                    })?;
            let export_id = aws_smithy_http::label::fmt_string(input_32, false);
            if export_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "export_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/exports/{exportId}", exportId = export_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteExport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteExport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteExportInput`](crate::input::DeleteExportInput)
    pub fn builder() -> crate::input::delete_export_input::Builder {
        crate::input::delete_export_input::Builder::default()
    }
}

/// See [`DeleteImportInput`](crate::input::DeleteImportInput)
pub mod delete_import_input {
    /// A builder for [`DeleteImportInput`](crate::input::DeleteImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the import to delete.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the import to delete.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImportInput`](crate::input::DeleteImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImportInput {
                import_id: self.import_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImportInputOperationOutputAlias = crate::operation::DeleteImport;
#[doc(hidden)]
pub type DeleteImportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImportInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImport`](crate::operation::DeleteImport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.import_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "import_id",
                        details: "cannot be empty or unset",
                    })?;
            let import_id = aws_smithy_http::label::fmt_string(input_33, false);
            if import_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "import_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/imports/{importId}", importId = import_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteImportInput`](crate::input::DeleteImportInput)
    pub fn builder() -> crate::input::delete_import_input::Builder {
        crate::input::delete_import_input::Builder::default()
    }
}

/// See [`DeleteIntentInput`](crate::input::DeleteIntentInput)
pub mod delete_intent_input {
    /// A builder for [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntentInput`](crate::input::DeleteIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntentInput {
                intent_id: self.intent_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntentInputOperationOutputAlias = crate::operation::DeleteIntent;
#[doc(hidden)]
pub type DeleteIntentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIntentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntent`](crate::operation::DeleteIntent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.bot_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_34, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.bot_version;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_35, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.locale_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_36, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_37 = &_input.intent_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_37, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id,
                intentId = intent_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntent",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    pub fn builder() -> crate::input::delete_intent_input::Builder {
        crate::input::delete_intent_input::Builder::default()
    }
}

/// See [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
pub mod delete_resource_policy_input {
    /// A builder for [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) expected_revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcePolicyInput {
                resource_arn: self.resource_arn,
                expected_revision_id: self.expected_revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationOutputAlias = crate::operation::DeleteResourcePolicy;
#[doc(hidden)]
pub type DeleteResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcePolicy`](crate::operation::DeleteResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.resource_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_38, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteResourcePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_39) = &_input.expected_revision_id {
                query.push_kv(
                    "expectedRevisionId",
                    &aws_smithy_http::query::fmt_string(&inner_39),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcePolicy",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
}

/// See [`DeleteResourcePolicyStatementInput`](crate::input::DeleteResourcePolicyStatementInput)
pub mod delete_resource_policy_statement_input {
    /// A builder for [`DeleteResourcePolicyStatementInput`](crate::input::DeleteResourcePolicyStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) expected_revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyStatementInput`](crate::input::DeleteResourcePolicyStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResourcePolicyStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResourcePolicyStatementInput {
                resource_arn: self.resource_arn,
                statement_id: self.statement_id,
                expected_revision_id: self.expected_revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResourcePolicyStatementInputOperationOutputAlias =
    crate::operation::DeleteResourcePolicyStatement;
#[doc(hidden)]
pub type DeleteResourcePolicyStatementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResourcePolicyStatementInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResourcePolicyStatement`](crate::operation::DeleteResourcePolicyStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResourcePolicyStatement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteResourcePolicyStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.resource_arn;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_40, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_41 = &_input.statement_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    })?;
            let statement_id = aws_smithy_http::label::fmt_string(input_41, false);
            if statement_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "statement_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/policy/{resourceArn}/statements/{statementId}",
                resourceArn = resource_arn,
                statementId = statement_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteResourcePolicyStatementInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_42) = &_input.expected_revision_id {
                query.push_kv(
                    "expectedRevisionId",
                    &aws_smithy_http::query::fmt_string(&inner_42),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteResourcePolicyStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteResourcePolicyStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResourcePolicyStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResourcePolicyStatement",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyStatementInput`](crate::input::DeleteResourcePolicyStatementInput)
    pub fn builder() -> crate::input::delete_resource_policy_statement_input::Builder {
        crate::input::delete_resource_policy_statement_input::Builder::default()
    }
}

/// See [`DeleteSlotInput`](crate::input::DeleteSlotInput)
pub mod delete_slot_input {
    /// A builder for [`DeleteSlotInput`](crate::input::DeleteSlotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the slot to delete. </p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the slot to delete. </p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSlotInput`](crate::input::DeleteSlotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSlotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSlotInput {
                slot_id: self.slot_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSlotInputOperationOutputAlias = crate::operation::DeleteSlot;
#[doc(hidden)]
pub type DeleteSlotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSlotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSlot`](crate::operation::DeleteSlot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSlot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSlotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.bot_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_43, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_44 = &_input.bot_version;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_44, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_45 = &_input.locale_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_45, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.intent_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_46, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_47 = &_input.slot_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_id = aws_smithy_http::label::fmt_string(input_47, false);
            if slot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, intentId = intent_id, slotId = slot_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSlotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSlotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSlot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSlot",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSlotInput`](crate::input::DeleteSlotInput)
    pub fn builder() -> crate::input::delete_slot_input::Builder {
        crate::input::delete_slot_input::Builder::default()
    }
}

/// See [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
pub mod delete_slot_type_input {
    /// A builder for [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) skip_resource_in_use_check: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the slot type to delete.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The identifier of the slot type to delete.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.skip_resource_in_use_check = Some(input);
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_resource_in_use_check = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSlotTypeInput {
                slot_type_id: self.slot_type_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                skip_resource_in_use_check: self.skip_resource_in_use_check.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSlotTypeInputOperationOutputAlias = crate::operation::DeleteSlotType;
#[doc(hidden)]
pub type DeleteSlotTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSlotType`](crate::operation::DeleteSlotType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSlotType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_48 = &_input.bot_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_48, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_49 = &_input.bot_version;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_49, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_50 = &_input.locale_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_50, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_51 = &_input.slot_type_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_type_id = aws_smithy_http::label::fmt_string(input_51, false);
            if slot_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, slotTypeId = slot_type_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteSlotTypeInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.skip_resource_in_use_check {
                query.push_kv(
                    "skipResourceInUseCheck",
                    aws_smithy_types::primitive::Encoder::from(_input.skip_resource_in_use_check)
                        .encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSlotType",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    pub fn builder() -> crate::input::delete_slot_type_input::Builder {
        crate::input::delete_slot_type_input::Builder::default()
    }
}

/// See [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
pub mod delete_utterances_input {
    /// A builder for [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the utterances.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the utterances.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUtterancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUtterancesInput {
                bot_id: self.bot_id,
                locale_id: self.locale_id,
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUtterancesInputOperationOutputAlias = crate::operation::DeleteUtterances;
#[doc(hidden)]
pub type DeleteUtterancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUtterancesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUtterances`](crate::operation::DeleteUtterances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUtterances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUtterancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.bot_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_52, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/utterances", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteUtterancesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_53) = &_input.locale_id {
                query.push_kv("localeId", &aws_smithy_http::query::fmt_string(&inner_53));
            }
            if let Some(inner_54) = &_input.session_id {
                query.push_kv("sessionId", &aws_smithy_http::query::fmt_string(&inner_54));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUtterancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUtterancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUtterances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUtterances",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    pub fn builder() -> crate::input::delete_utterances_input::Builder {
        crate::input::delete_utterances_input::Builder::default()
    }
}

/// See [`DescribeBotInput`](crate::input::DescribeBotInput)
pub mod describe_bot_input {
    /// A builder for [`DescribeBotInput`](crate::input::DescribeBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotInput`](crate::input::DescribeBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBotInput {
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBotInputOperationOutputAlias = crate::operation::DescribeBot;
#[doc(hidden)]
pub type DescribeBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBotInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBot`](crate::operation::DescribeBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.bot_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_55, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}", botId = bot_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBot",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBotInput`](crate::input::DescribeBotInput)
    pub fn builder() -> crate::input::describe_bot_input::Builder {
        crate::input::describe_bot_input::Builder::default()
    }
}

/// See [`DescribeBotAliasInput`](crate::input::DescribeBotAliasInput)
pub mod describe_bot_alias_input {
    /// A builder for [`DescribeBotAliasInput`](crate::input::DescribeBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to describe.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotAliasInput`](crate::input::DescribeBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBotAliasInput {
                bot_alias_id: self.bot_alias_id,
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBotAliasInputOperationOutputAlias = crate::operation::DescribeBotAlias;
#[doc(hidden)]
pub type DescribeBotAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBotAlias`](crate::operation::DescribeBotAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBotAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.bot_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_56, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_57 = &_input.bot_alias_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_57, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botaliases/{botAliasId}",
                botId = bot_id,
                botAliasId = bot_alias_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBotAlias",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBotAliasInput`](crate::input::DescribeBotAliasInput)
    pub fn builder() -> crate::input::describe_bot_alias_input::Builder {
        crate::input::describe_bot_alias_input::Builder::default()
    }
}

/// See [`DescribeBotLocaleInput`](crate::input::DescribeBotLocaleInput)
pub mod describe_bot_locale_input {
    /// A builder for [`DescribeBotLocaleInput`](crate::input::DescribeBotLocaleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotLocaleInput`](crate::input::DescribeBotLocaleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBotLocaleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBotLocaleInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBotLocaleInputOperationOutputAlias = crate::operation::DescribeBotLocale;
#[doc(hidden)]
pub type DescribeBotLocaleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBotLocaleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBotLocale`](crate::operation::DescribeBotLocale)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBotLocale,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBotLocaleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.bot_id;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_58, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_59 = &_input.bot_version;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_59, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_60 = &_input.locale_id;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_60, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBotLocaleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBotLocaleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBotLocale::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBotLocale",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBotLocaleInput`](crate::input::DescribeBotLocaleInput)
    pub fn builder() -> crate::input::describe_bot_locale_input::Builder {
        crate::input::describe_bot_locale_input::Builder::default()
    }
}

/// See [`DescribeBotRecommendationInput`](crate::input::DescribeBotRecommendationInput)
pub mod describe_bot_recommendation_input {
    /// A builder for [`DescribeBotRecommendationInput`](crate::input::DescribeBotRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the bot recommendation to describe.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation to describe.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotRecommendationInput`](crate::input::DescribeBotRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBotRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBotRecommendationInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBotRecommendationInputOperationOutputAlias =
    crate::operation::DescribeBotRecommendation;
#[doc(hidden)]
pub type DescribeBotRecommendationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBotRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBotRecommendation`](crate::operation::DescribeBotRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBotRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBotRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.bot_id;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_61, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_62 = &_input.bot_version;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_62, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_63 = &_input.locale_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_63, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_64 = &_input.bot_recommendation_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_recommendation_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_recommendation_id = aws_smithy_http::label::fmt_string(input_64, false);
            if bot_recommendation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_recommendation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, botRecommendationId = bot_recommendation_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBotRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBotRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBotRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBotRecommendation",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBotRecommendationInput`](crate::input::DescribeBotRecommendationInput)
    pub fn builder() -> crate::input::describe_bot_recommendation_input::Builder {
        crate::input::describe_bot_recommendation_input::Builder::default()
    }
}

/// See [`DescribeBotVersionInput`](crate::input::DescribeBotVersionInput)
pub mod describe_bot_version_input {
    /// A builder for [`DescribeBotVersionInput`](crate::input::DescribeBotVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot containing the version to return metadata for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot containing the version to return metadata for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotVersionInput`](crate::input::DescribeBotVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBotVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBotVersionInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBotVersionInputOperationOutputAlias = crate::operation::DescribeBotVersion;
#[doc(hidden)]
pub type DescribeBotVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeBotVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBotVersion`](crate::operation::DescribeBotVersion)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBotVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBotVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.bot_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_65, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_66 = &_input.bot_version;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_66, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}",
                botId = bot_id,
                botVersion = bot_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBotVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBotVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBotVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBotVersion",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBotVersionInput`](crate::input::DescribeBotVersionInput)
    pub fn builder() -> crate::input::describe_bot_version_input::Builder {
        crate::input::describe_bot_version_input::Builder::default()
    }
}

/// See [`DescribeCustomVocabularyMetadataInput`](crate::input::DescribeCustomVocabularyMetadataInput)
pub mod describe_custom_vocabulary_metadata_input {
    /// A builder for [`DescribeCustomVocabularyMetadataInput`](crate::input::DescribeCustomVocabularyMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The bot version of the bot to return metadata for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The bot version of the bot to return metadata for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomVocabularyMetadataInput`](crate::input::DescribeCustomVocabularyMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCustomVocabularyMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCustomVocabularyMetadataInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCustomVocabularyMetadataInputOperationOutputAlias =
    crate::operation::DescribeCustomVocabularyMetadata;
#[doc(hidden)]
pub type DescribeCustomVocabularyMetadataInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCustomVocabularyMetadataInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCustomVocabularyMetadata`](crate::operation::DescribeCustomVocabularyMetadata)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCustomVocabularyMetadata,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCustomVocabularyMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.bot_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_67, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_68 = &_input.bot_version;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_68, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_69 = &_input.locale_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_69, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata", botId = bot_id, botVersion = bot_version, localeId = locale_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCustomVocabularyMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCustomVocabularyMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCustomVocabularyMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCustomVocabularyMetadata",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCustomVocabularyMetadataInput`](crate::input::DescribeCustomVocabularyMetadataInput)
    pub fn builder() -> crate::input::describe_custom_vocabulary_metadata_input::Builder {
        crate::input::describe_custom_vocabulary_metadata_input::Builder::default()
    }
}

/// See [`DescribeExportInput`](crate::input::DescribeExportInput)
pub mod describe_export_input {
    /// A builder for [`DescribeExportInput`](crate::input::DescribeExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the export to describe.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the export to describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportInput`](crate::input::DescribeExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExportInput {
                export_id: self.export_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExportInputOperationOutputAlias = crate::operation::DescribeExport;
#[doc(hidden)]
pub type DescribeExportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeExportInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExport`](crate::operation::DescribeExport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.export_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "export_id",
                        details: "cannot be empty or unset",
                    })?;
            let export_id = aws_smithy_http::label::fmt_string(input_70, false);
            if export_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "export_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/exports/{exportId}", exportId = export_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeExport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeExport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeExportInput`](crate::input::DescribeExportInput)
    pub fn builder() -> crate::input::describe_export_input::Builder {
        crate::input::describe_export_input::Builder::default()
    }
}

/// See [`DescribeImportInput`](crate::input::DescribeImportInput)
pub mod describe_import_input {
    /// A builder for [`DescribeImportInput`](crate::input::DescribeImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the import to describe.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the import to describe.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImportInput`](crate::input::DescribeImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImportInput {
                import_id: self.import_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImportInputOperationOutputAlias = crate::operation::DescribeImport;
#[doc(hidden)]
pub type DescribeImportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeImportInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImport`](crate::operation::DescribeImport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.import_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "import_id",
                        details: "cannot be empty or unset",
                    })?;
            let import_id = aws_smithy_http::label::fmt_string(input_71, false);
            if import_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "import_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/imports/{importId}", importId = import_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeImportInput`](crate::input::DescribeImportInput)
    pub fn builder() -> crate::input::describe_import_input::Builder {
        crate::input::describe_import_input::Builder::default()
    }
}

/// See [`DescribeIntentInput`](crate::input::DescribeIntentInput)
pub mod describe_intent_input {
    /// A builder for [`DescribeIntentInput`](crate::input::DescribeIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the intent to describe.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent to describe.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIntentInput`](crate::input::DescribeIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeIntentInput {
                intent_id: self.intent_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeIntentInputOperationOutputAlias = crate::operation::DescribeIntent;
#[doc(hidden)]
pub type DescribeIntentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeIntentInput {
    /// Consumes the builder and constructs an Operation<[`DescribeIntent`](crate::operation::DescribeIntent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeIntent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.bot_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_72, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_73 = &_input.bot_version;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_73, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_74 = &_input.locale_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_74, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_75 = &_input.intent_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_75, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id,
                intentId = intent_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeIntent",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeIntentInput`](crate::input::DescribeIntentInput)
    pub fn builder() -> crate::input::describe_intent_input::Builder {
        crate::input::describe_intent_input::Builder::default()
    }
}

/// See [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
pub mod describe_resource_policy_input {
    /// A builder for [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeResourcePolicyInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeResourcePolicyInputOperationOutputAlias = crate::operation::DescribeResourcePolicy;
#[doc(hidden)]
pub type DescribeResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeResourcePolicy`](crate::operation::DescribeResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.resource_arn;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_76, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeResourcePolicy",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
    pub fn builder() -> crate::input::describe_resource_policy_input::Builder {
        crate::input::describe_resource_policy_input::Builder::default()
    }
}

/// See [`DescribeSlotInput`](crate::input::DescribeSlotInput)
pub mod describe_slot_input {
    /// A builder for [`DescribeSlotInput`](crate::input::DescribeSlotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the slot.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSlotInput`](crate::input::DescribeSlotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSlotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSlotInput {
                slot_id: self.slot_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSlotInputOperationOutputAlias = crate::operation::DescribeSlot;
#[doc(hidden)]
pub type DescribeSlotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSlotInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSlot`](crate::operation::DescribeSlot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSlot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSlotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.bot_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_77, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_78 = &_input.bot_version;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_78, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_79 = &_input.locale_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_79, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_80 = &_input.intent_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_80, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_81 = &_input.slot_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_id = aws_smithy_http::label::fmt_string(input_81, false);
            if slot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, intentId = intent_id, slotId = slot_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSlotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSlotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSlot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSlot",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSlotInput`](crate::input::DescribeSlotInput)
    pub fn builder() -> crate::input::describe_slot_input::Builder {
        crate::input::describe_slot_input::Builder::default()
    }
}

/// See [`DescribeSlotTypeInput`](crate::input::DescribeSlotTypeInput)
pub mod describe_slot_type_input {
    /// A builder for [`DescribeSlotTypeInput`](crate::input::DescribeSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the slot type.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The identifier of the slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSlotTypeInput`](crate::input::DescribeSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSlotTypeInput {
                slot_type_id: self.slot_type_id,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSlotTypeInputOperationOutputAlias = crate::operation::DescribeSlotType;
#[doc(hidden)]
pub type DescribeSlotTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSlotType`](crate::operation::DescribeSlotType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSlotType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.bot_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_82, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_83 = &_input.bot_version;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_83, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.locale_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_84, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_85 = &_input.slot_type_id;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_type_id = aws_smithy_http::label::fmt_string(input_85, false);
            if slot_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, slotTypeId = slot_type_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSlotType",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSlotTypeInput`](crate::input::DescribeSlotTypeInput)
    pub fn builder() -> crate::input::describe_slot_type_input::Builder {
        crate::input::describe_slot_type_input::Builder::default()
    }
}

/// See [`ListAggregatedUtterancesInput`](crate::input::ListAggregatedUtterancesInput)
pub mod list_aggregated_utterances_input {
    /// A builder for [`ListAggregatedUtterancesInput`](crate::input::ListAggregatedUtterancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) aggregation_duration:
            std::option::Option<crate::model::UtteranceAggregationDuration>,
        pub(crate) sort_by: std::option::Option<crate::model::AggregatedUtterancesSortBy>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with this request.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with this request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
        pub fn aggregation_duration(
            mut self,
            input: crate::model::UtteranceAggregationDuration,
        ) -> Self {
            self.aggregation_duration = Some(input);
            self
        }
        /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
        pub fn set_aggregation_duration(
            mut self,
            input: std::option::Option<crate::model::UtteranceAggregationDuration>,
        ) -> Self {
            self.aggregation_duration = input;
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
        pub fn sort_by(mut self, input: crate::model::AggregatedUtterancesSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::AggregatedUtterancesFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAggregatedUtterancesInput`](crate::input::ListAggregatedUtterancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAggregatedUtterancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAggregatedUtterancesInput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                aggregation_duration: self.aggregation_duration,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAggregatedUtterancesInputOperationOutputAlias =
    crate::operation::ListAggregatedUtterances;
#[doc(hidden)]
pub type ListAggregatedUtterancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAggregatedUtterancesInput {
    /// Consumes the builder and constructs an Operation<[`ListAggregatedUtterances`](crate::operation::ListAggregatedUtterances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAggregatedUtterances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAggregatedUtterancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.bot_id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_86, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/aggregatedutterances", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAggregatedUtterancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAggregatedUtterancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_aggregated_utterances(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAggregatedUtterances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAggregatedUtterances",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAggregatedUtterancesInput`](crate::input::ListAggregatedUtterancesInput)
    pub fn builder() -> crate::input::list_aggregated_utterances_input::Builder {
        crate::input::list_aggregated_utterances_input::Builder::default()
    }
}

/// See [`ListBotAliasesInput`](crate::input::ListBotAliasesInput)
pub mod list_bot_aliases_input {
    /// A builder for [`ListBotAliasesInput`](crate::input::ListBotAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotAliasesInput`](crate::input::ListBotAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBotAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBotAliasesInput {
                bot_id: self.bot_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotAliasesInputOperationOutputAlias = crate::operation::ListBotAliases;
#[doc(hidden)]
pub type ListBotAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListBotAliases`](crate::operation::ListBotAliases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBotAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_87 = &_input.bot_id;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_87, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botaliases", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_bot_aliases(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBotAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBotAliases",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotAliasesInput`](crate::input::ListBotAliasesInput)
    pub fn builder() -> crate::input::list_bot_aliases_input::Builder {
        crate::input::list_bot_aliases_input::Builder::default()
    }
}

/// See [`ListBotLocalesInput`](crate::input::ListBotLocalesInput)
pub mod list_bot_locales_input {
    /// A builder for [`ListBotLocalesInput`](crate::input::ListBotLocalesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::BotLocaleSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::BotLocaleFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotLocaleSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotLocaleSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
        pub fn filters(mut self, input: crate::model::BotLocaleFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotLocaleFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotLocalesInput`](crate::input::ListBotLocalesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBotLocalesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBotLocalesInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotLocalesInputOperationOutputAlias = crate::operation::ListBotLocales;
#[doc(hidden)]
pub type ListBotLocalesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotLocalesInput {
    /// Consumes the builder and constructs an Operation<[`ListBotLocales`](crate::operation::ListBotLocales)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBotLocales,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotLocalesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.bot_id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_88, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_89 = &_input.bot_version;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_89, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales",
                botId = bot_id,
                botVersion = bot_version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotLocalesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotLocalesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_bot_locales(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBotLocales::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBotLocales",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotLocalesInput`](crate::input::ListBotLocalesInput)
    pub fn builder() -> crate::input::list_bot_locales_input::Builder {
        crate::input::list_bot_locales_input::Builder::default()
    }
}

/// See [`ListBotRecommendationsInput`](crate::input::ListBotRecommendationsInput)
pub mod list_bot_recommendations_input {
    /// A builder for [`ListBotRecommendationsInput`](crate::input::ListBotRecommendationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotRecommendationsInput`](crate::input::ListBotRecommendationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBotRecommendationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBotRecommendationsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotRecommendationsInputOperationOutputAlias = crate::operation::ListBotRecommendations;
#[doc(hidden)]
pub type ListBotRecommendationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotRecommendationsInput {
    /// Consumes the builder and constructs an Operation<[`ListBotRecommendations`](crate::operation::ListBotRecommendations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBotRecommendations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotRecommendationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_90 = &_input.bot_id;
            let input_90 =
                input_90
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_90, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_91 = &_input.bot_version;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_91, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_92 = &_input.locale_id;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_92, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotRecommendationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotRecommendationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_bot_recommendations(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBotRecommendations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBotRecommendations",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotRecommendationsInput`](crate::input::ListBotRecommendationsInput)
    pub fn builder() -> crate::input::list_bot_recommendations_input::Builder {
        crate::input::list_bot_recommendations_input::Builder::default()
    }
}

/// See [`ListBotsInput`](crate::input::ListBotsInput)
pub mod list_bots_input {
    /// A builder for [`ListBotsInput`](crate::input::ListBotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sort_by: std::option::Option<crate::model::BotSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::BotFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::BotSortBy>) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::BotFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotsInput`](crate::input::ListBotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListBotsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListBotsInput {
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotsInputOperationOutputAlias = crate::operation::ListBots;
#[doc(hidden)]
pub type ListBotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotsInput {
    /// Consumes the builder and constructs an Operation<[`ListBots`](crate::operation::ListBots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/bots").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_bots(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListBots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListBots",
                    "lexmodelsv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
}

/// See [`ListBotVersionsInput`](crate::input::ListBotVersionsInput)
pub mod list_bot_versions_input {
    /// A builder for [`ListBotVersionsInput`](crate::input::ListBotVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::BotVersionSortBy>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotVersionSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotVersionSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotVersionsInput`](crate::input::ListBotVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBotVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBotVersionsInput {
                bot_id: self.bot_id,
                sort_by: self.sort_by,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotVersionsInputOperationOutputAlias = crate::operation::ListBotVersions;
#[doc(hidden)]
pub type ListBotVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListBotVersions`](crate::operation::ListBotVersions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBotVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_93 = &_input.bot_id;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_93, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions", botId = bot_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_bot_versions(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBotVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBotVersions",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotVersionsInput`](crate::input::ListBotVersionsInput)
    pub fn builder() -> crate::input::list_bot_versions_input::Builder {
        crate::input::list_bot_versions_input::Builder::default()
    }
}

/// See [`ListBuiltInIntentsInput`](crate::input::ListBuiltInIntentsInput)
pub mod list_built_in_intents_input {
    /// A builder for [`ListBuiltInIntentsInput`](crate::input::ListBuiltInIntentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::BuiltInIntentSortBy>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BuiltInIntentSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInIntentSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuiltInIntentsInput`](crate::input::ListBuiltInIntentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBuiltInIntentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBuiltInIntentsInput {
                locale_id: self.locale_id,
                sort_by: self.sort_by,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBuiltInIntentsInputOperationOutputAlias = crate::operation::ListBuiltInIntents;
#[doc(hidden)]
pub type ListBuiltInIntentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBuiltInIntentsInput {
    /// Consumes the builder and constructs an Operation<[`ListBuiltInIntents`](crate::operation::ListBuiltInIntents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBuiltInIntents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBuiltInIntentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_94 = &_input.locale_id;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_94, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/builtins/locales/{localeId}/intents",
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBuiltInIntentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBuiltInIntentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_built_in_intents(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBuiltInIntents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBuiltInIntents",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBuiltInIntentsInput`](crate::input::ListBuiltInIntentsInput)
    pub fn builder() -> crate::input::list_built_in_intents_input::Builder {
        crate::input::list_built_in_intents_input::Builder::default()
    }
}

/// See [`ListBuiltInSlotTypesInput`](crate::input::ListBuiltInSlotTypesInput)
pub mod list_built_in_slot_types_input {
    /// A builder for [`ListBuiltInSlotTypesInput`](crate::input::ListBuiltInSlotTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::BuiltInSlotTypeSortBy>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BuiltInSlotTypeSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInSlotTypeSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuiltInSlotTypesInput`](crate::input::ListBuiltInSlotTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBuiltInSlotTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBuiltInSlotTypesInput {
                locale_id: self.locale_id,
                sort_by: self.sort_by,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBuiltInSlotTypesInputOperationOutputAlias = crate::operation::ListBuiltInSlotTypes;
#[doc(hidden)]
pub type ListBuiltInSlotTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBuiltInSlotTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListBuiltInSlotTypes`](crate::operation::ListBuiltInSlotTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBuiltInSlotTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBuiltInSlotTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_95 = &_input.locale_id;
            let input_95 =
                input_95
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_95, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/builtins/locales/{localeId}/slottypes",
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBuiltInSlotTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBuiltInSlotTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_built_in_slot_types(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBuiltInSlotTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBuiltInSlotTypes",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBuiltInSlotTypesInput`](crate::input::ListBuiltInSlotTypesInput)
    pub fn builder() -> crate::input::list_built_in_slot_types_input::Builder {
        crate::input::list_built_in_slot_types_input::Builder::default()
    }
}

/// See [`ListExportsInput`](crate::input::ListExportsInput)
pub mod list_exports_input {
    /// A builder for [`ListExportsInput`](crate::input::ListExportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::ExportSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::ExportSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ExportSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::ExportFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExportsInput`](crate::input::ListExportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListExportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListExportsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListExportsInputOperationOutputAlias = crate::operation::ListExports;
#[doc(hidden)]
pub type ListExportsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListExportsInput {
    /// Consumes the builder and constructs an Operation<[`ListExports`](crate::operation::ListExports)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListExports,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListExportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/exports").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListExportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListExportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_exports(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListExports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListExports",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
}

/// See [`ListImportsInput`](crate::input::ListImportsInput)
pub mod list_imports_input {
    /// A builder for [`ListImportsInput`](crate::input::ListImportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::ImportSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::ImportFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::ImportSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ImportSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::ImportFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImportsInput`](crate::input::ListImportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImportsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImportsInputOperationOutputAlias = crate::operation::ListImports;
#[doc(hidden)]
pub type ListImportsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImportsInput {
    /// Consumes the builder and constructs an Operation<[`ListImports`](crate::operation::ListImports)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImports,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListImportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/imports").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListImportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListImportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_imports(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImports",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListImportsInput`](crate::input::ListImportsInput)
    pub fn builder() -> crate::input::list_imports_input::Builder {
        crate::input::list_imports_input::Builder::default()
    }
}

/// See [`ListIntentsInput`](crate::input::ListIntentsInput)
pub mod list_intents_input {
    /// A builder for [`ListIntentsInput`](crate::input::ListIntentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::IntentSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::IntentFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::IntentSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::IntentSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::IntentFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntentsInput`](crate::input::ListIntentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIntentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIntentsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIntentsInputOperationOutputAlias = crate::operation::ListIntents;
#[doc(hidden)]
pub type ListIntentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIntentsInput {
    /// Consumes the builder and constructs an Operation<[`ListIntents`](crate::operation::ListIntents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIntents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIntentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_96 = &_input.bot_id;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_96, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_97 = &_input.bot_version;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_97, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_98 = &_input.locale_id;
            let input_98 =
                input_98
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_98, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIntentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIntentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_intents(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIntents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIntents",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIntentsInput`](crate::input::ListIntentsInput)
    pub fn builder() -> crate::input::list_intents_input::Builder {
        crate::input::list_intents_input::Builder::default()
    }
}

/// See [`ListRecommendedIntentsInput`](crate::input::ListRecommendedIntentsInput)
pub mod list_recommended_intents_input {
    /// A builder for [`ListRecommendedIntentsInput`](crate::input::ListRecommendedIntentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with the recommended intents.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the recommended intents.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the recommended intents.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the recommended intents.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the recommended intents.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the recommended intents.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendedIntentsInput`](crate::input::ListRecommendedIntentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRecommendedIntentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRecommendedIntentsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRecommendedIntentsInputOperationOutputAlias = crate::operation::ListRecommendedIntents;
#[doc(hidden)]
pub type ListRecommendedIntentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRecommendedIntentsInput {
    /// Consumes the builder and constructs an Operation<[`ListRecommendedIntents`](crate::operation::ListRecommendedIntents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRecommendedIntents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRecommendedIntentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_99 = &_input.bot_id;
            let input_99 =
                input_99
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_99, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_100 = &_input.bot_version;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_100, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_101 = &_input.locale_id;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_101, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_102 = &_input.bot_recommendation_id;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_recommendation_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_recommendation_id = aws_smithy_http::label::fmt_string(input_102, false);
            if bot_recommendation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_recommendation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents", botId = bot_id, botVersion = bot_version, localeId = locale_id, botRecommendationId = bot_recommendation_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRecommendedIntentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRecommendedIntentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_recommended_intents(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRecommendedIntents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRecommendedIntents",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRecommendedIntentsInput`](crate::input::ListRecommendedIntentsInput)
    pub fn builder() -> crate::input::list_recommended_intents_input::Builder {
        crate::input::list_recommended_intents_input::Builder::default()
    }
}

/// See [`ListSlotsInput`](crate::input::ListSlotsInput)
pub mod list_slots_input {
    /// A builder for [`ListSlotsInput`](crate::input::ListSlotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::SlotSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SlotFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::SlotSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SlotSortBy>) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::SlotFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSlotsInput`](crate::input::ListSlotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListSlotsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListSlotsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSlotsInputOperationOutputAlias = crate::operation::ListSlots;
#[doc(hidden)]
pub type ListSlotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSlotsInput {
    /// Consumes the builder and constructs an Operation<[`ListSlots`](crate::operation::ListSlots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSlots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSlotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_103 = &_input.bot_id;
            let input_103 =
                input_103
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_103, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_104 = &_input.bot_version;
            let input_104 =
                input_104
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_104, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_105 = &_input.locale_id;
            let input_105 =
                input_105
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_105, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_106 = &_input.intent_id;
            let input_106 =
                input_106
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_106, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots", botId = bot_id, botVersion = bot_version, localeId = locale_id, intentId = intent_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSlotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSlotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_slots(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListSlots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListSlots",
                    "lexmodelsv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSlotsInput`](crate::input::ListSlotsInput)
    pub fn builder() -> crate::input::list_slots_input::Builder {
        crate::input::list_slots_input::Builder::default()
    }
}

/// See [`ListSlotTypesInput`](crate::input::ListSlotTypesInput)
pub mod list_slot_types_input {
    /// A builder for [`ListSlotTypesInput`](crate::input::ListSlotTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::SlotTypeSortBy>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::SlotTypeFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the slot types.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the slot types.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::SlotTypeSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SlotTypeSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::SlotTypeFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSlotTypesInput`](crate::input::ListSlotTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSlotTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSlotTypesInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                sort_by: self.sort_by,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSlotTypesInputOperationOutputAlias = crate::operation::ListSlotTypes;
#[doc(hidden)]
pub type ListSlotTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSlotTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListSlotTypes`](crate::operation::ListSlotTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSlotTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSlotTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.bot_id;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_107, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_108 = &_input.bot_version;
            let input_108 =
                input_108
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_108, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_109 = &_input.locale_id;
            let input_109 =
                input_109
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_109, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSlotTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSlotTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_slot_types(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSlotTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSlotTypes",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSlotTypesInput`](crate::input::ListSlotTypesInput)
    pub fn builder() -> crate::input::list_slot_types_input::Builder {
        crate::input::list_slot_types_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_110 = &_input.resource_arn;
            let input_110 =
                input_110
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_110, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceARN}", resourceARN = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`SearchAssociatedTranscriptsInput`](crate::input::SearchAssociatedTranscriptsInput)
pub mod search_associated_transcripts_input {
    /// A builder for [`SearchAssociatedTranscriptsInput`](crate::input::SearchAssociatedTranscriptsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) search_order: std::option::Option<crate::model::SearchOrder>,
        pub(crate) filters:
            std::option::Option<std::vec::Vec<crate::model::AssociatedTranscriptFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
        pub fn search_order(mut self, input: crate::model::SearchOrder) -> Self {
            self.search_order = Some(input);
            self
        }
        /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
        pub fn set_search_order(
            mut self,
            input: std::option::Option<crate::model::SearchOrder>,
        ) -> Self {
            self.search_order = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of filter objects.</p>
        pub fn filters(mut self, input: crate::model::AssociatedTranscriptFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A list of filter objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociatedTranscriptFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
        pub fn next_index(mut self, input: i32) -> Self {
            self.next_index = Some(input);
            self
        }
        /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
        pub fn set_next_index(mut self, input: std::option::Option<i32>) -> Self {
            self.next_index = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchAssociatedTranscriptsInput`](crate::input::SearchAssociatedTranscriptsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchAssociatedTranscriptsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchAssociatedTranscriptsInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
                search_order: self.search_order,
                filters: self.filters,
                max_results: self.max_results,
                next_index: self.next_index,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchAssociatedTranscriptsInputOperationOutputAlias =
    crate::operation::SearchAssociatedTranscripts;
#[doc(hidden)]
pub type SearchAssociatedTranscriptsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchAssociatedTranscriptsInput {
    /// Consumes the builder and constructs an Operation<[`SearchAssociatedTranscripts`](crate::operation::SearchAssociatedTranscripts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchAssociatedTranscripts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchAssociatedTranscriptsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_111 = &_input.bot_id;
            let input_111 =
                input_111
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_111, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_112 = &_input.bot_version;
            let input_112 =
                input_112
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_112, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_113 = &_input.locale_id;
            let input_113 =
                input_113
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_113, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_114 = &_input.bot_recommendation_id;
            let input_114 =
                input_114
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_recommendation_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_recommendation_id = aws_smithy_http::label::fmt_string(input_114, false);
            if bot_recommendation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_recommendation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts", botId = bot_id, botVersion = bot_version, localeId = locale_id, botRecommendationId = bot_recommendation_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchAssociatedTranscriptsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchAssociatedTranscriptsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_associated_transcripts(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchAssociatedTranscripts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchAssociatedTranscripts",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchAssociatedTranscriptsInput`](crate::input::SearchAssociatedTranscriptsInput)
    pub fn builder() -> crate::input::search_associated_transcripts_input::Builder {
        crate::input::search_associated_transcripts_input::Builder::default()
    }
}

/// See [`StartBotRecommendationInput`](crate::input::StartBotRecommendationInput)
pub mod start_bot_recommendation_input {
    /// A builder for [`StartBotRecommendationInput`](crate::input::StartBotRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) transcript_source_setting:
            std::option::Option<crate::model::TranscriptSourceSetting>,
        pub(crate) encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn transcript_source_setting(
            mut self,
            input: crate::model::TranscriptSourceSetting,
        ) -> Self {
            self.transcript_source_setting = Some(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn set_transcript_source_setting(
            mut self,
            input: std::option::Option<crate::model::TranscriptSourceSetting>,
        ) -> Self {
            self.transcript_source_setting = input;
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.encryption_setting = Some(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.encryption_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBotRecommendationInput`](crate::input::StartBotRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartBotRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartBotRecommendationInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                transcript_source_setting: self.transcript_source_setting,
                encryption_setting: self.encryption_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type StartBotRecommendationInputOperationOutputAlias = crate::operation::StartBotRecommendation;
#[doc(hidden)]
pub type StartBotRecommendationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartBotRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`StartBotRecommendation`](crate::operation::StartBotRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartBotRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartBotRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_115 = &_input.bot_id;
            let input_115 =
                input_115
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_115, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_116 = &_input.bot_version;
            let input_116 =
                input_116
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_116, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_117 = &_input.locale_id;
            let input_117 =
                input_117
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_117, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartBotRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartBotRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_bot_recommendation(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartBotRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartBotRecommendation",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartBotRecommendationInput`](crate::input::StartBotRecommendationInput)
    pub fn builder() -> crate::input::start_bot_recommendation_input::Builder {
        crate::input::start_bot_recommendation_input::Builder::default()
    }
}

/// See [`StartImportInput`](crate::input::StartImportInput)
pub mod start_import_input {
    /// A builder for [`StartImportInput`](crate::input::StartImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ImportResourceSpecification>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) file_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ImportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ImportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_password = Some(input.into());
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_password = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportInput`](crate::input::StartImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartImportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartImportInput {
                import_id: self.import_id,
                resource_specification: self.resource_specification,
                merge_strategy: self.merge_strategy,
                file_password: self.file_password,
            })
        }
    }
}
#[doc(hidden)]
pub type StartImportInputOperationOutputAlias = crate::operation::StartImport;
#[doc(hidden)]
pub type StartImportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartImportInput {
    /// Consumes the builder and constructs an Operation<[`StartImport`](crate::operation::StartImport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartImport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/imports").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_import(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartImport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartImport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartImportInput`](crate::input::StartImportInput)
    pub fn builder() -> crate::input::start_import_input::Builder {
        crate::input::start_import_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_118 = &_input.resource_arn;
            let input_118 =
                input_118
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_118, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceARN}", resourceARN = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_119 = &_input.resource_arn;
            let input_119 =
                input_119
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_119, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceARN}", resourceARN = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_120) = &_input.tag_keys {
                for inner_121 in inner_120 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_121));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateBotInput`](crate::input::UpdateBotInput)
pub mod update_bot_input {
    /// A builder for [`UpdateBotInput`](crate::input::UpdateBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotInput`](crate::input::UpdateBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateBotInput {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBotInputOperationOutputAlias = crate::operation::UpdateBot;
#[doc(hidden)]
pub type UpdateBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBotInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBot`](crate::operation::UpdateBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_122 = &_input.bot_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_122, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}", botId = bot_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_bot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateBot",
                    "lexmodelsv2",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBotInput`](crate::input::UpdateBotInput)
    pub fn builder() -> crate::input::update_bot_input::Builder {
        crate::input::update_bot_input::Builder::default()
    }
}

/// See [`UpdateBotAliasInput`](crate::input::UpdateBotAliasInput)
pub mod update_bot_alias_input {
    /// A builder for [`UpdateBotAliasInput`](crate::input::UpdateBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_locale_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
        >,
        pub(crate) conversation_log_settings:
            std::option::Option<crate::model::ConversationLogSettings>,
        pub(crate) sentiment_analysis_settings:
            std::option::Option<crate::model::SentimentAnalysisSettings>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot alias.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_alias_locale_settings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            let mut hash_map = self.bot_alias_locale_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_alias_locale_settings = Some(hash_map);
            self
        }
        /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.bot_alias_locale_settings = input;
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.conversation_log_settings = Some(input);
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.conversation_log_settings = input;
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.sentiment_analysis_settings = Some(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.sentiment_analysis_settings = input;
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotAliasInput`](crate::input::UpdateBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBotAliasInput {
                bot_alias_id: self.bot_alias_id,
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_locale_settings: self.bot_alias_locale_settings,
                conversation_log_settings: self.conversation_log_settings,
                sentiment_analysis_settings: self.sentiment_analysis_settings,
                bot_id: self.bot_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBotAliasInputOperationOutputAlias = crate::operation::UpdateBotAlias;
#[doc(hidden)]
pub type UpdateBotAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBotAlias`](crate::operation::UpdateBotAlias)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBotAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_123 = &_input.bot_id;
            let input_123 =
                input_123
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_123, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_124 = &_input.bot_alias_id;
            let input_124 =
                input_124
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias_id = aws_smithy_http::label::fmt_string(input_124, false);
            if bot_alias_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botaliases/{botAliasId}",
                botId = bot_id,
                botAliasId = bot_alias_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_bot_alias(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBotAlias",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBotAliasInput`](crate::input::UpdateBotAliasInput)
    pub fn builder() -> crate::input::update_bot_alias_input::Builder {
        crate::input::update_bot_alias_input::Builder::default()
    }
}

/// See [`UpdateBotLocaleInput`](crate::input::UpdateBotLocaleInput)
pub mod update_bot_locale_input {
    /// A builder for [`UpdateBotLocaleInput`](crate::input::UpdateBotLocaleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotLocaleInput`](crate::input::UpdateBotLocaleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBotLocaleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBotLocaleInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                description: self.description,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBotLocaleInputOperationOutputAlias = crate::operation::UpdateBotLocale;
#[doc(hidden)]
pub type UpdateBotLocaleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBotLocaleInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBotLocale`](crate::operation::UpdateBotLocale)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBotLocale,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBotLocaleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_125 = &_input.bot_id;
            let input_125 =
                input_125
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_125, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_126 = &_input.bot_version;
            let input_126 =
                input_126
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_126, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_127 = &_input.locale_id;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_127, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBotLocaleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBotLocaleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_bot_locale(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBotLocale::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBotLocale",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBotLocaleInput`](crate::input::UpdateBotLocaleInput)
    pub fn builder() -> crate::input::update_bot_locale_input::Builder {
        crate::input::update_bot_locale_input::Builder::default()
    }
}

/// See [`UpdateBotRecommendationInput`](crate::input::UpdateBotRecommendationInput)
pub mod update_bot_recommendation_input {
    /// A builder for [`UpdateBotRecommendationInput`](crate::input::UpdateBotRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the bot recommendation to be updated.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation to be updated.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.encryption_setting = Some(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.encryption_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotRecommendationInput`](crate::input::UpdateBotRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBotRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBotRecommendationInput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
                encryption_setting: self.encryption_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBotRecommendationInputOperationOutputAlias =
    crate::operation::UpdateBotRecommendation;
#[doc(hidden)]
pub type UpdateBotRecommendationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateBotRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBotRecommendation`](crate::operation::UpdateBotRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBotRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBotRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_128 = &_input.bot_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_128, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_129 = &_input.bot_version;
            let input_129 =
                input_129
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_129, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_130 = &_input.locale_id;
            let input_130 =
                input_130
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_130, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_131 = &_input.bot_recommendation_id;
            let input_131 =
                input_131
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_recommendation_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_recommendation_id = aws_smithy_http::label::fmt_string(input_131, false);
            if bot_recommendation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_recommendation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, botRecommendationId = bot_recommendation_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBotRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBotRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_bot_recommendation(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBotRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBotRecommendation",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBotRecommendationInput`](crate::input::UpdateBotRecommendationInput)
    pub fn builder() -> crate::input::update_bot_recommendation_input::Builder {
        crate::input::update_bot_recommendation_input::Builder::default()
    }
}

/// See [`UpdateExportInput`](crate::input::UpdateExportInput)
pub mod update_export_input {
    /// A builder for [`UpdateExportInput`](crate::input::UpdateExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) file_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_password = Some(input.into());
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.file_password = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExportInput`](crate::input::UpdateExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateExportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateExportInput {
                export_id: self.export_id,
                file_password: self.file_password,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateExportInputOperationOutputAlias = crate::operation::UpdateExport;
#[doc(hidden)]
pub type UpdateExportInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateExportInput {
    /// Consumes the builder and constructs an Operation<[`UpdateExport`](crate::operation::UpdateExport)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateExport,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_132 = &_input.export_id;
            let input_132 =
                input_132
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "export_id",
                        details: "cannot be empty or unset",
                    })?;
            let export_id = aws_smithy_http::label::fmt_string(input_132, false);
            if export_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "export_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/exports/{exportId}", exportId = export_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_export(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateExport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateExport",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateExportInput`](crate::input::UpdateExportInput)
    pub fn builder() -> crate::input::update_export_input::Builder {
        crate::input::update_export_input::Builder::default()
    }
}

/// See [`UpdateIntentInput`](crate::input::UpdateIntentInput)
pub mod update_intent_input {
    /// A builder for [`UpdateIntentInput`](crate::input::UpdateIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
        pub(crate) fulfillment_code_hook:
            std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        pub(crate) slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        pub(crate) intent_confirmation_setting:
            std::option::Option<crate::model::IntentConfirmationSetting>,
        pub(crate) intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the intent to update.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the intent to update.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>New utterances used to invoke the intent.</p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input);
            self.sample_utterances = Some(v);
            self
        }
        /// <p>New utterances used to invoke the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.fulfillment_code_hook = Some(input);
            self
        }
        /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.fulfillment_code_hook = input;
            self
        }
        /// Appends an item to `slot_priorities`.
        ///
        /// To override the contents of this collection use [`set_slot_priorities`](Self::set_slot_priorities).
        ///
        /// <p>A new list of slots and their priorities that are contained by the intent.</p>
        pub fn slot_priorities(mut self, input: crate::model::SlotPriority) -> Self {
            let mut v = self.slot_priorities.unwrap_or_default();
            v.push(input);
            self.slot_priorities = Some(v);
            self
        }
        /// <p>A new list of slots and their priorities that are contained by the intent.</p>
        pub fn set_slot_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        ) -> Self {
            self.slot_priorities = input;
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.intent_confirmation_setting = Some(input);
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.intent_confirmation_setting = input;
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.intent_closing_setting = Some(input);
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.intent_closing_setting = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input);
            self.input_contexts = Some(v);
            self
        }
        /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input);
            self.output_contexts = Some(v);
            self
        }
        /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntentInput`](crate::input::UpdateIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIntentInput {
                intent_id: self.intent_id,
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                sample_utterances: self.sample_utterances,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_code_hook: self.fulfillment_code_hook,
                slot_priorities: self.slot_priorities,
                intent_confirmation_setting: self.intent_confirmation_setting,
                intent_closing_setting: self.intent_closing_setting,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                kendra_configuration: self.kendra_configuration,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIntentInputOperationOutputAlias = crate::operation::UpdateIntent;
#[doc(hidden)]
pub type UpdateIntentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIntentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIntent`](crate::operation::UpdateIntent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIntent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_133 = &_input.bot_id;
            let input_133 =
                input_133
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_133, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_134 = &_input.bot_version;
            let input_134 =
                input_134
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_134, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_135 = &_input.locale_id;
            let input_135 =
                input_135
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_135, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_136 = &_input.intent_id;
            let input_136 =
                input_136
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_136, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}",
                botId = bot_id,
                botVersion = bot_version,
                localeId = locale_id,
                intentId = intent_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_intent(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIntent",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIntentInput`](crate::input::UpdateIntentInput)
    pub fn builder() -> crate::input::update_intent_input::Builder {
        crate::input::update_intent_input::Builder::default()
    }
}

/// See [`UpdateResourcePolicyInput`](crate::input::UpdateResourcePolicyInput)
pub mod update_resource_policy_input {
    /// A builder for [`UpdateResourcePolicyInput`](crate::input::UpdateResourcePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) expected_revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_revision_id = Some(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourcePolicyInput`](crate::input::UpdateResourcePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResourcePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResourcePolicyInput {
                resource_arn: self.resource_arn,
                policy: self.policy,
                expected_revision_id: self.expected_revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResourcePolicyInputOperationOutputAlias = crate::operation::UpdateResourcePolicy;
#[doc(hidden)]
pub type UpdateResourcePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResourcePolicyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResourcePolicy`](crate::operation::UpdateResourcePolicy)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResourcePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateResourcePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_137 = &_input.resource_arn;
            let input_137 =
                input_137
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_137, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/policy/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdateResourcePolicyInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_138) = &_input.expected_revision_id {
                query.push_kv(
                    "expectedRevisionId",
                    &aws_smithy_http::query::fmt_string(&inner_138),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateResourcePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateResourcePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resource_policy(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResourcePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResourcePolicy",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateResourcePolicyInput`](crate::input::UpdateResourcePolicyInput)
    pub fn builder() -> crate::input::update_resource_policy_input::Builder {
        crate::input::update_resource_policy_input::Builder::default()
    }
}

/// See [`UpdateSlotInput`](crate::input::UpdateSlotInput)
pub mod update_slot_input {
    /// A builder for [`UpdateSlotInput`](crate::input::UpdateSlotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_setting:
            std::option::Option<crate::model::SlotValueElicitationSetting>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) multiple_values_setting:
            std::option::Option<crate::model::MultipleValuesSetting>,
    }
    impl Builder {
        /// <p>The unique identifier for the slot to update.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the slot to update.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this slot. </p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this slot. </p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.value_elicitation_setting = Some(input);
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.value_elicitation_setting = input;
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.multiple_values_setting = Some(input);
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.multiple_values_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSlotInput`](crate::input::UpdateSlotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSlotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSlotInput {
                slot_id: self.slot_id,
                slot_name: self.slot_name,
                description: self.description,
                slot_type_id: self.slot_type_id,
                value_elicitation_setting: self.value_elicitation_setting,
                obfuscation_setting: self.obfuscation_setting,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                multiple_values_setting: self.multiple_values_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSlotInputOperationOutputAlias = crate::operation::UpdateSlot;
#[doc(hidden)]
pub type UpdateSlotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSlotInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSlot`](crate::operation::UpdateSlot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSlot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSlotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_139 = &_input.bot_id;
            let input_139 =
                input_139
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_139, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_140 = &_input.bot_version;
            let input_140 =
                input_140
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_140, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_141 = &_input.locale_id;
            let input_141 =
                input_141
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_141, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_142 = &_input.intent_id;
            let input_142 =
                input_142
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "intent_id",
                        details: "cannot be empty or unset",
                    })?;
            let intent_id = aws_smithy_http::label::fmt_string(input_142, false);
            if intent_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "intent_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_143 = &_input.slot_id;
            let input_143 =
                input_143
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_id = aws_smithy_http::label::fmt_string(input_143, false);
            if slot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, intentId = intent_id, slotId = slot_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSlotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSlotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_slot(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSlot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSlot",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSlotInput`](crate::input::UpdateSlotInput)
    pub fn builder() -> crate::input::update_slot_input::Builder {
        crate::input::update_slot_input::Builder::default()
    }
}

/// See [`UpdateSlotTypeInput`](crate::input::UpdateSlotTypeInput)
pub mod update_slot_type_input {
    /// A builder for [`UpdateSlotTypeInput`](crate::input::UpdateSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_values:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        pub(crate) value_selection_setting:
            std::option::Option<crate::model::SlotValueSelectionSetting>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) external_source_setting:
            std::option::Option<crate::model::ExternalSourceSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slot_type_values`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            let mut v = self.slot_type_values.unwrap_or_default();
            v.push(input);
            self.slot_type_values = Some(v);
            self
        }
        /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.slot_type_values = input;
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.value_selection_setting = Some(input);
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.value_selection_setting = input;
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.external_source_setting = Some(input);
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.external_source_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSlotTypeInput`](crate::input::UpdateSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSlotTypeInput {
                slot_type_id: self.slot_type_id,
                slot_type_name: self.slot_type_name,
                description: self.description,
                slot_type_values: self.slot_type_values,
                value_selection_setting: self.value_selection_setting,
                parent_slot_type_signature: self.parent_slot_type_signature,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                external_source_setting: self.external_source_setting,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSlotTypeInputOperationOutputAlias = crate::operation::UpdateSlotType;
#[doc(hidden)]
pub type UpdateSlotTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSlotType`](crate::operation::UpdateSlotType)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSlotType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_144 = &_input.bot_id;
            let input_144 =
                input_144
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_id",
                        details: "cannot be empty or unset",
                    })?;
            let bot_id = aws_smithy_http::label::fmt_string(input_144, false);
            if bot_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_145 = &_input.bot_version;
            let input_145 =
                input_145
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_version",
                        details: "cannot be empty or unset",
                    })?;
            let bot_version = aws_smithy_http::label::fmt_string(input_145, false);
            if bot_version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_version",
                    details: "cannot be empty or unset",
                });
            }
            let input_146 = &_input.locale_id;
            let input_146 =
                input_146
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "locale_id",
                        details: "cannot be empty or unset",
                    })?;
            let locale_id = aws_smithy_http::label::fmt_string(input_146, false);
            if locale_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "locale_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_147 = &_input.slot_type_id;
            let input_147 =
                input_147
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "slot_type_id",
                        details: "cannot be empty or unset",
                    })?;
            let slot_type_id = aws_smithy_http::label::fmt_string(input_147, false);
            if slot_type_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "slot_type_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}", botId = bot_id, botVersion = bot_version, localeId = locale_id, slotTypeId = slot_type_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_slot_type(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSlotType",
            "lexmodelsv2",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSlotTypeInput`](crate::input::UpdateSlotTypeInput)
    pub fn builder() -> crate::input::update_slot_type_input::Builder {
        crate::input::update_slot_type_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSlotTypeInput {
    /// <p>The unique identifier of the slot type to update.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The new name of the slot type.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>The new description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
    pub slot_type_values: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
    /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
    pub value_selection_setting: std::option::Option<crate::model::SlotValueSelectionSetting>,
    /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot that contains the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub external_source_setting: std::option::Option<crate::model::ExternalSourceSetting>,
}
impl UpdateSlotTypeInput {
    /// <p>The unique identifier of the slot type to update.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The new name of the slot type.</p>
    pub fn slot_type_name(&self) -> std::option::Option<&str> {
        self.slot_type_name.as_deref()
    }
    /// <p>The new description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
    pub fn slot_type_values(&self) -> std::option::Option<&[crate::model::SlotTypeValue]> {
        self.slot_type_values.as_deref()
    }
    /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
    pub fn value_selection_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionSetting> {
        self.value_selection_setting.as_ref()
    }
    /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>The identifier of the bot that contains the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub fn external_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::ExternalSourceSetting> {
        self.external_source_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSlotTypeInput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_values", &self.slot_type_values);
        formatter.field("value_selection_setting", &self.value_selection_setting);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("external_source_setting", &self.external_source_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSlotInput {
    /// <p>The unique identifier for the slot to update.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The new name for the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>The new description for the slot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the new slot type to associate with this slot. </p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
    pub value_elicitation_setting: std::option::Option<crate::model::SlotValueElicitationSetting>,
    /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>The unique identifier of the bot that contains the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent that contains the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub multiple_values_setting: std::option::Option<crate::model::MultipleValuesSetting>,
}
impl UpdateSlotInput {
    /// <p>The unique identifier for the slot to update.</p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The new name for the slot.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>The new description for the slot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the new slot type to associate with this slot. </p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
    pub fn value_elicitation_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueElicitationSetting> {
        self.value_elicitation_setting.as_ref()
    }
    /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>The unique identifier of the bot that contains the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent that contains the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub fn multiple_values_setting(
        &self,
    ) -> std::option::Option<&crate::model::MultipleValuesSetting> {
        self.multiple_values_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateSlotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSlotInput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("value_elicitation_setting", &self.value_elicitation_setting);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("multiple_values_setting", &self.multiple_values_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
    /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    pub expected_revision_id: std::option::Option<std::string::String>,
}
impl UpdateResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
    /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    pub fn expected_revision_id(&self) -> std::option::Option<&str> {
        self.expected_revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.field("expected_revision_id", &self.expected_revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntentInput {
    /// <p>The unique identifier of the intent to update.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The new name for the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The new description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>New utterances used to invoke the intent.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
    pub dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
    /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
    pub fulfillment_code_hook: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
    /// <p>A new list of slots and their priorities that are contained by the intent.</p>
    pub slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
    /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    pub intent_confirmation_setting: std::option::Option<crate::model::IntentConfirmationSetting>,
    /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
    pub intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
    /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>The identifier of the bot that contains the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl UpdateIntentInput {
    /// <p>The unique identifier of the intent to update.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The new name for the intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>The new description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>New utterances used to invoke the intent.</p>
    pub fn sample_utterances(&self) -> std::option::Option<&[crate::model::SampleUtterance]> {
        self.sample_utterances.as_deref()
    }
    /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::DialogCodeHookSettings> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
    pub fn fulfillment_code_hook(
        &self,
    ) -> std::option::Option<&crate::model::FulfillmentCodeHookSettings> {
        self.fulfillment_code_hook.as_ref()
    }
    /// <p>A new list of slots and their priorities that are contained by the intent.</p>
    pub fn slot_priorities(&self) -> std::option::Option<&[crate::model::SlotPriority]> {
        self.slot_priorities.as_deref()
    }
    /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    pub fn intent_confirmation_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentConfirmationSetting> {
        self.intent_confirmation_setting.as_ref()
    }
    /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
    pub fn intent_closing_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentClosingSetting> {
        self.intent_closing_setting.as_ref()
    }
    /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
    /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>The identifier of the bot that contains the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntentInput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_code_hook", &self.fulfillment_code_hook);
        formatter.field("slot_priorities", &self.slot_priorities);
        formatter.field(
            "intent_confirmation_setting",
            &self.intent_confirmation_setting,
        );
        formatter.field("intent_closing_setting", &self.intent_closing_setting);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExportInput {
    /// <p>The unique identifier Amazon Lex assigned to the export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The new password to use to encrypt the export zip archive.</p>
    pub file_password: std::option::Option<std::string::String>,
}
impl UpdateExportInput {
    /// <p>The unique identifier Amazon Lex assigned to the export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>The new password to use to encrypt the export zip archive.</p>
    pub fn file_password(&self) -> std::option::Option<&str> {
        self.file_password.as_deref()
    }
}
impl std::fmt::Debug for UpdateExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExportInput");
        formatter.field("export_id", &self.export_id);
        formatter.field("file_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotRecommendationInput {
    /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the bot recommendation to be updated.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the bot recommendation to be updated.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
}
impl UpdateBotRecommendationInput {
    /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the bot recommendation to be updated.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The unique identifier of the bot recommendation to be updated.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub fn encryption_setting(&self) -> std::option::Option<&crate::model::EncryptionSetting> {
        self.encryption_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateBotRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotRecommendationInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("encryption_setting", &self.encryption_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotLocaleInput {
    /// <p>The unique identifier of the bot that contains the locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The new description of the locale.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
}
impl UpdateBotLocaleInput {
    /// <p>The unique identifier of the bot that contains the locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The new description of the locale.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
    pub fn voice_settings(&self) -> std::option::Option<&crate::model::VoiceSettings> {
        self.voice_settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateBotLocaleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotLocaleInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("description", &self.description);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotAliasInput {
    /// <p>The unique identifier of the bot alias.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The new name to assign to the bot alias.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>The new description to assign to the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The new bot version to assign to the bot alias.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
    pub bot_alias_locale_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    >,
    /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    pub conversation_log_settings: std::option::Option<crate::model::ConversationLogSettings>,
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub sentiment_analysis_settings: std::option::Option<crate::model::SentimentAnalysisSettings>,
    /// <p>The identifier of the bot with the updated alias.</p>
    pub bot_id: std::option::Option<std::string::String>,
}
impl UpdateBotAliasInput {
    /// <p>The unique identifier of the bot alias.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The new name to assign to the bot alias.</p>
    pub fn bot_alias_name(&self) -> std::option::Option<&str> {
        self.bot_alias_name.as_deref()
    }
    /// <p>The new description to assign to the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The new bot version to assign to the bot alias.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
    pub fn bot_alias_locale_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    > {
        self.bot_alias_locale_settings.as_ref()
    }
    /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    pub fn conversation_log_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogSettings> {
        self.conversation_log_settings.as_ref()
    }
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub fn sentiment_analysis_settings(
        &self,
    ) -> std::option::Option<&crate::model::SentimentAnalysisSettings> {
        self.sentiment_analysis_settings.as_ref()
    }
    /// <p>The identifier of the bot with the updated alias.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotAliasInput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_locale_settings", &self.bot_alias_locale_settings);
        formatter.field("conversation_log_settings", &self.conversation_log_settings);
        formatter.field(
            "sentiment_analysis_settings",
            &self.sentiment_analysis_settings,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotInput {
    /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
    /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
}
impl UpdateBotInput {
    /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
    /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
}
impl std::fmt::Debug for UpdateBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportInput {
    /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
    pub resource_specification: std::option::Option<crate::model::ImportResourceSpecification>,
    /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
    pub file_password: std::option::Option<std::string::String>,
}
impl StartImportInput {
    /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ImportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
    pub fn file_password(&self) -> std::option::Option<&str> {
        self.file_password.as_deref()
    }
}
impl std::fmt::Debug for StartImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportInput");
        formatter.field("import_id", &self.import_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("file_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBotRecommendationInput {
    /// <p>The unique identifier of the bot containing the bot recommendation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the bot recommendation.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub transcript_source_setting: std::option::Option<crate::model::TranscriptSourceSetting>,
    /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
}
impl StartBotRecommendationInput {
    /// <p>The unique identifier of the bot containing the bot recommendation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the bot recommendation.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub fn transcript_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::TranscriptSourceSetting> {
        self.transcript_source_setting.as_ref()
    }
    /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub fn encryption_setting(&self) -> std::option::Option<&crate::model::EncryptionSetting> {
        self.encryption_setting.as_ref()
    }
}
impl std::fmt::Debug for StartBotRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBotRecommendationInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("transcript_source_setting", &self.transcript_source_setting);
        formatter.field("encryption_setting", &self.encryption_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchAssociatedTranscriptsInput {
    /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the transcripts that you are searching.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
    pub search_order: std::option::Option<crate::model::SearchOrder>,
    /// <p>A list of filter objects.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::AssociatedTranscriptFilter>>,
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
    pub next_index: std::option::Option<i32>,
}
impl SearchAssociatedTranscriptsInput {
    /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the transcripts that you are searching.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
    pub fn search_order(&self) -> std::option::Option<&crate::model::SearchOrder> {
        self.search_order.as_ref()
    }
    /// <p>A list of filter objects.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::AssociatedTranscriptFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
    pub fn next_index(&self) -> std::option::Option<i32> {
        self.next_index
    }
}
impl std::fmt::Debug for SearchAssociatedTranscriptsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchAssociatedTranscriptsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("search_order", &self.search_order);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_index", &self.next_index);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSlotTypesInput {
    /// <p>The unique identifier of the bot that contains the slot types.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::SlotTypeSortBy>,
    /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SlotTypeFilter>>,
    /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSlotTypesInput {
    /// <p>The unique identifier of the bot that contains the slot types.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SlotTypeSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SlotTypeFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSlotTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSlotTypesInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSlotsInput {
    /// <p>The identifier of the bot that contains the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the intent that contains the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::SlotSortBy>,
    /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::SlotFilter>>,
    /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSlotsInput {
    /// <p>The identifier of the bot that contains the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The unique identifier of the intent that contains the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SlotSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::SlotFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSlotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSlotsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendedIntentsInput {
    /// <p>The unique identifier of the bot associated with the recommended intents.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the recommended intents.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the recommended intents.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRecommendedIntentsInput {
    /// <p>The unique identifier of the bot associated with the recommended intents.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the recommended intents.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the recommended intents.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRecommendedIntentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendedIntentsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIntentsInput {
    /// <p>The unique identifier of the bot that contains the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::IntentSortBy>,
    /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::IntentFilter>>,
    /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIntentsInput {
    /// <p>The unique identifier of the bot that contains the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::IntentSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::IntentFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIntentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIntentsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImportsInput {
    /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to list imports for.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::ImportSortBy>,
    /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ImportFilter>>,
    /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListImportsInput {
    /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to list imports for.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ImportSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ImportFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListImportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImportsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExportsInput {
    /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to list exports for. </p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::ExportSortBy>,
    /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
    /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListExportsInput {
    /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to list exports for. </p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::ExportSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::ExportFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListExportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExportsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuiltInSlotTypesInput {
    /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::BuiltInSlotTypeSortBy>,
    /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBuiltInSlotTypesInput {
    /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::BuiltInSlotTypeSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBuiltInSlotTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuiltInSlotTypesInput");
        formatter.field("locale_id", &self.locale_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuiltInIntentsInput {
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::BuiltInIntentSortBy>,
    /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBuiltInIntentsInput {
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::BuiltInIntentSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBuiltInIntentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuiltInIntentsInput");
        formatter.field("locale_id", &self.locale_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotVersionsInput {
    /// <p>The identifier of the bot to list versions for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::BotVersionSortBy>,
    /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotVersionsInput {
    /// <p>The identifier of the bot to list versions for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::BotVersionSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotVersionsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotsInput {
    /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::BotSortBy>,
    /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::BotFilter>>,
    /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotsInput {
    /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::BotSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::BotFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
    /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotsInput");
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotRecommendationsInput {
    /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the bot recommendation list.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation list.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotRecommendationsInput {
    /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the bot recommendation list.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotRecommendationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotRecommendationsInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotLocalesInput {
    /// <p>The identifier of the bot to list locales for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to list locales for.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
    pub sort_by: std::option::Option<crate::model::BotLocaleSortBy>,
    /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::BotLocaleFilter>>,
    /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotLocalesInput {
    /// <p>The identifier of the bot to list locales for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to list locales for.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::BotLocaleSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::BotLocaleFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotLocalesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotLocalesInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotAliasesInput {
    /// <p>The identifier of the bot to list aliases for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotAliasesInput {
    /// <p>The identifier of the bot to list aliases for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotAliasesInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAggregatedUtterancesInput {
    /// <p>The unique identifier of the bot associated with this request.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
    pub aggregation_duration: std::option::Option<crate::model::UtteranceAggregationDuration>,
    /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
    pub sort_by: std::option::Option<crate::model::AggregatedUtterancesSortBy>,
    /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesFilter>>,
    /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAggregatedUtterancesInput {
    /// <p>The unique identifier of the bot associated with this request.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
    pub fn aggregation_duration(
        &self,
    ) -> std::option::Option<&crate::model::UtteranceAggregationDuration> {
        self.aggregation_duration.as_ref()
    }
    /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::AggregatedUtterancesSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::AggregatedUtterancesFilter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAggregatedUtterancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAggregatedUtterancesInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("aggregation_duration", &self.aggregation_duration);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSlotTypeInput {
    /// <p>The identifier of the slot type.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DescribeSlotTypeInput {
    /// <p>The identifier of the slot type.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSlotTypeInput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSlotInput {
    /// <p>The unique identifier for the slot.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent that contains the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
}
impl DescribeSlotInput {
    /// <p>The unique identifier for the slot.</p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent that contains the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeSlotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSlotInput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl DescribeResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIntentInput {
    /// <p>The identifier of the intent to describe.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DescribeIntentInput {
    /// <p>The identifier of the intent to describe.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIntentInput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImportInput {
    /// <p>The unique identifier of the import to describe.</p>
    pub import_id: std::option::Option<std::string::String>,
}
impl DescribeImportInput {
    /// <p>The unique identifier of the import to describe.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImportInput");
        formatter.field("import_id", &self.import_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportInput {
    /// <p>The unique identifier of the export to describe.</p>
    pub export_id: std::option::Option<std::string::String>,
}
impl DescribeExportInput {
    /// <p>The unique identifier of the export to describe.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportInput");
        formatter.field("export_id", &self.export_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomVocabularyMetadataInput {
    /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The bot version of the bot to return metadata for.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DescribeCustomVocabularyMetadataInput {
    /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The bot version of the bot to return metadata for.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomVocabularyMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomVocabularyMetadataInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotVersionInput {
    /// <p>The identifier of the bot containing the version to return metadata for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to return metadata for.</p>
    pub bot_version: std::option::Option<std::string::String>,
}
impl DescribeBotVersionInput {
    /// <p>The identifier of the bot containing the version to return metadata for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to return metadata for.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotVersionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotRecommendationInput {
    /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the bot recommendation.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot recommendation to describe.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
}
impl DescribeBotRecommendationInput {
    /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the bot recommendation.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the bot recommendation to describe.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotRecommendationInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotLocaleInput {
    /// <p>The identifier of the bot associated with the locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the version of the bot associated with the locale.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DescribeBotLocaleInput {
    /// <p>The identifier of the bot associated with the locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the version of the bot associated with the locale.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotLocaleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotLocaleInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotAliasInput {
    /// <p>The identifier of the bot alias to describe.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the bot alias to describe.</p>
    pub bot_id: std::option::Option<std::string::String>,
}
impl DescribeBotAliasInput {
    /// <p>The identifier of the bot alias to describe.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the bot alias to describe.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotAliasInput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotInput {
    /// <p>The unique identifier of the bot to describe.</p>
    pub bot_id: std::option::Option<std::string::String>,
}
impl DescribeBotInput {
    /// <p>The unique identifier of the bot to describe.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUtterancesInput {
    /// <p>The unique identifier of the bot that contains the utterances.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl DeleteUtterancesInput {
    /// <p>The unique identifier of the bot that contains the utterances.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUtterancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUtterancesInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeInput {
    /// <p>The identifier of the slot type to delete.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
    pub skip_resource_in_use_check: bool,
}
impl DeleteSlotTypeInput {
    /// <p>The identifier of the slot type to delete.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
    pub fn skip_resource_in_use_check(&self) -> bool {
        self.skip_resource_in_use_check
    }
}
impl std::fmt::Debug for DeleteSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeInput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field(
            "skip_resource_in_use_check",
            &self.skip_resource_in_use_check,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotInput {
    /// <p>The identifier of the slot to delete. </p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the slot to delete.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot to delete.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent associated with the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
}
impl DeleteSlotInput {
    /// <p>The identifier of the slot to delete. </p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the slot to delete.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot to delete.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent associated with the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteSlotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotInput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name of the statement (SID) to delete from the policy.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
    pub expected_revision_id: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name of the statement (SID) to delete from the policy.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
    pub fn expected_revision_id(&self) -> std::option::Option<&str> {
        self.expected_revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyStatementInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("expected_revision_id", &self.expected_revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
    /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
    pub expected_revision_id: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
    /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
    pub fn expected_revision_id(&self) -> std::option::Option<&str> {
        self.expected_revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("expected_revision_id", &self.expected_revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentInput {
    /// <p>The unique identifier of the intent to delete.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DeleteIntentInput {
    /// <p>The unique identifier of the intent to delete.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The identifier of the bot associated with the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentInput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImportInput {
    /// <p>The unique identifier of the import to delete.</p>
    pub import_id: std::option::Option<std::string::String>,
}
impl DeleteImportInput {
    /// <p>The unique identifier of the import to delete.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImportInput");
        formatter.field("import_id", &self.import_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExportInput {
    /// <p>The unique identifier of the export to delete.</p>
    pub export_id: std::option::Option<std::string::String>,
}
impl DeleteExportInput {
    /// <p>The unique identifier of the export to delete.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExportInput");
        formatter.field("export_id", &self.export_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomVocabularyInput {
    /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to remove the custom vocabulary from.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DeleteCustomVocabularyInput {
    /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to remove the custom vocabulary from.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomVocabularyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomVocabularyInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotVersionInput {
    /// <p>The identifier of the bot that contains the version.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to delete.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
    pub skip_resource_in_use_check: bool,
}
impl DeleteBotVersionInput {
    /// <p>The identifier of the bot that contains the version.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to delete.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
    pub fn skip_resource_in_use_check(&self) -> bool {
        self.skip_resource_in_use_check
    }
}
impl std::fmt::Debug for DeleteBotVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotVersionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field(
            "skip_resource_in_use_check",
            &self.skip_resource_in_use_check,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotLocaleInput {
    /// <p>The unique identifier of the bot that contains the locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the locale. </p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl DeleteBotLocaleInput {
    /// <p>The unique identifier of the bot that contains the locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the locale. </p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBotLocaleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotLocaleInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotAliasInput {
    /// <p>The unique identifier of the bot alias to delete.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the bot associated with the alias to delete.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
    pub skip_resource_in_use_check: bool,
}
impl DeleteBotAliasInput {
    /// <p>The unique identifier of the bot alias to delete.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The unique identifier of the bot associated with the alias to delete.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
    pub fn skip_resource_in_use_check(&self) -> bool {
        self.skip_resource_in_use_check
    }
}
impl std::fmt::Debug for DeleteBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotAliasInput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field(
            "skip_resource_in_use_check",
            &self.skip_resource_in_use_check,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotInput {
    /// <p>The identifier of the bot to delete. </p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
    pub skip_resource_in_use_check: bool,
}
impl DeleteBotInput {
    /// <p>The identifier of the bot to delete. </p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
    pub fn skip_resource_in_use_check(&self) -> bool {
        self.skip_resource_in_use_check
    }
}
impl std::fmt::Debug for DeleteBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field(
            "skip_resource_in_use_check",
            &self.skip_resource_in_use_check,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUploadUrlInput {}
impl std::fmt::Debug for CreateUploadUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUploadUrlInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotTypeInput {
    /// <p>The name for the slot. A slot type name must be unique within the account.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
    pub slot_type_values: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
    /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
    /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
    /// </ul>
    /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
    pub value_selection_setting: std::option::Option<crate::model::SlotValueSelectionSetting>,
    /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
    /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with this slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot version associated with this slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Sets the type of external information used to create the slot type.</p>
    pub external_source_setting: std::option::Option<crate::model::ExternalSourceSetting>,
}
impl CreateSlotTypeInput {
    /// <p>The name for the slot. A slot type name must be unique within the account.</p>
    pub fn slot_type_name(&self) -> std::option::Option<&str> {
        self.slot_type_name.as_deref()
    }
    /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
    pub fn slot_type_values(&self) -> std::option::Option<&[crate::model::SlotTypeValue]> {
        self.slot_type_values.as_deref()
    }
    /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
    /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
    /// </ul>
    /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
    pub fn value_selection_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionSetting> {
        self.value_selection_setting.as_ref()
    }
    /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
    /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>The identifier of the bot associated with this slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the bot version associated with this slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Sets the type of external information used to create the slot type.</p>
    pub fn external_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::ExternalSourceSetting> {
        self.external_source_setting.as_ref()
    }
}
impl std::fmt::Debug for CreateSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotTypeInput");
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_values", &self.slot_type_values);
        formatter.field("value_selection_setting", &self.value_selection_setting);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("external_source_setting", &self.external_source_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotInput {
    /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
    pub value_elicitation_setting: std::option::Option<crate::model::SlotValueElicitationSetting>,
    /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
    /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>The identifier of the bot associated with the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent that contains the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub multiple_values_setting: std::option::Option<crate::model::MultipleValuesSetting>,
}
impl CreateSlotInput {
    /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
    pub fn value_elicitation_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueElicitationSetting> {
        self.value_elicitation_setting.as_ref()
    }
    /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
    /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>The identifier of the bot associated with the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent that contains the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub fn multiple_values_setting(
        &self,
    ) -> std::option::Option<&crate::model::MultipleValuesSetting> {
        self.multiple_values_setting.as_ref()
    }
}
impl std::fmt::Debug for CreateSlotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotInput");
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("value_elicitation_setting", &self.value_elicitation_setting);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("multiple_values_setting", &self.multiple_values_setting);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourcePolicyStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>Determines whether the statement allows or denies access to the resource.</p>
    pub effect: std::option::Option<crate::model::Effect>,
    /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
    pub principal: std::option::Option<std::vec::Vec<crate::model::Principal>>,
    /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
    pub action: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
    pub condition: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    >,
    /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    pub expected_revision_id: std::option::Option<std::string::String>,
}
impl CreateResourcePolicyStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>Determines whether the statement allows or denies access to the resource.</p>
    pub fn effect(&self) -> std::option::Option<&crate::model::Effect> {
        self.effect.as_ref()
    }
    /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
    pub fn principal(&self) -> std::option::Option<&[crate::model::Principal]> {
        self.principal.as_deref()
    }
    /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
    pub fn action(&self) -> std::option::Option<&[std::string::String]> {
        self.action.as_deref()
    }
    /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
    pub fn condition(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    > {
        self.condition.as_ref()
    }
    /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
    /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    pub fn expected_revision_id(&self) -> std::option::Option<&str> {
        self.expected_revision_id.as_deref()
    }
}
impl std::fmt::Debug for CreateResourcePolicyStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourcePolicyStatementInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("effect", &self.effect);
        formatter.field("principal", &self.principal);
        formatter.field("action", &self.action);
        formatter.field("condition", &self.condition);
        formatter.field("expected_revision_id", &self.expected_revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
    /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl CreateResourcePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
    /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for CreateResourcePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourcePolicyInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntentInput {
    /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the built-in intent to base this intent on.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
    /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
    /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
    pub dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
    /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
    /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
    pub fulfillment_code_hook: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
    /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
    pub intent_confirmation_setting: std::option::Option<crate::model::IntentConfirmationSetting>,
    /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
    pub intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
    /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
    /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
    /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
    /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
    /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
    /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
    /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>The identifier of the bot associated with this intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the version of the bot associated with this intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl CreateIntentInput {
    /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique identifier for the built-in intent to base this intent on.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
    /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
    pub fn sample_utterances(&self) -> std::option::Option<&[crate::model::SampleUtterance]> {
        self.sample_utterances.as_deref()
    }
    /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
    /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::DialogCodeHookSettings> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
    /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
    pub fn fulfillment_code_hook(
        &self,
    ) -> std::option::Option<&crate::model::FulfillmentCodeHookSettings> {
        self.fulfillment_code_hook.as_ref()
    }
    /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
    pub fn intent_confirmation_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentConfirmationSetting> {
        self.intent_confirmation_setting.as_ref()
    }
    /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
    pub fn intent_closing_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentClosingSetting> {
        self.intent_closing_setting.as_ref()
    }
    /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
    /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
    /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
    /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
    /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
    /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
    /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
    /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>The identifier of the bot associated with this intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the version of the bot associated with this intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for CreateIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntentInput");
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_code_hook", &self.fulfillment_code_hook);
        formatter.field(
            "intent_confirmation_setting",
            &self.intent_confirmation_setting,
        );
        formatter.field("intent_closing_setting", &self.intent_closing_setting);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExportInput {
    /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
    pub resource_specification: std::option::Option<crate::model::ExportResourceSpecification>,
    /// <p>The file format of the bot or bot locale definition files.</p>
    pub file_format: std::option::Option<crate::model::ImportExportFileFormat>,
    /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
    pub file_password: std::option::Option<std::string::String>,
}
impl CreateExportInput {
    /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ExportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The file format of the bot or bot locale definition files.</p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::ImportExportFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
    pub fn file_password(&self) -> std::option::Option<&str> {
        self.file_password.as_deref()
    }
}
impl std::fmt::Debug for CreateExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExportInput");
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("file_format", &self.file_format);
        formatter.field("file_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotVersionInput {
    /// <p>The identifier of the bot to create the version for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>A description of the version. Use the description to help identify the version in lists.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
    pub bot_version_locale_specification: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
    >,
}
impl CreateBotVersionInput {
    /// <p>The identifier of the bot to create the version for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>A description of the version. Use the description to help identify the version in lists.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
    pub fn bot_version_locale_specification(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
    > {
        self.bot_version_locale_specification.as_ref()
    }
}
impl std::fmt::Debug for CreateBotVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotVersionInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("description", &self.description);
        formatter.field(
            "bot_version_locale_specification",
            &self.bot_version_locale_specification,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotLocaleInput {
    /// <p>The identifier of the bot to create the locale for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
    /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
    /// <ul>
    /// <li> <p>AMAZON.FallbackIntent</p> </li>
    /// <li> <p>IntentA</p> </li>
    /// <li> <p>IntentB</p> </li>
    /// <li> <p>IntentC</p> </li>
    /// </ul>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
}
impl CreateBotLocaleInput {
    /// <p>The identifier of the bot to create the locale for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
    /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
    /// <ul>
    /// <li> <p>AMAZON.FallbackIntent</p> </li>
    /// <li> <p>IntentA</p> </li>
    /// <li> <p>IntentB</p> </li>
    /// <li> <p>IntentC</p> </li>
    /// </ul>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    pub fn voice_settings(&self) -> std::option::Option<&crate::model::VoiceSettings> {
        self.voice_settings.as_ref()
    }
}
impl std::fmt::Debug for CreateBotLocaleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotLocaleInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("description", &self.description);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotAliasInput {
    /// <p>The alias to create. The name must be unique for the bot.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>A description of the alias. Use this description to help identify the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
    pub bot_alias_locale_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    >,
    /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
    pub conversation_log_settings: std::option::Option<crate::model::ConversationLogSettings>,
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub sentiment_analysis_settings: std::option::Option<crate::model::SentimentAnalysisSettings>,
    /// <p>The unique identifier of the bot that the alias applies to.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateBotAliasInput {
    /// <p>The alias to create. The name must be unique for the bot.</p>
    pub fn bot_alias_name(&self) -> std::option::Option<&str> {
        self.bot_alias_name.as_deref()
    }
    /// <p>A description of the alias. Use this description to help identify the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
    pub fn bot_alias_locale_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    > {
        self.bot_alias_locale_settings.as_ref()
    }
    /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
    pub fn conversation_log_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogSettings> {
        self.conversation_log_settings.as_ref()
    }
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub fn sentiment_analysis_settings(
        &self,
    ) -> std::option::Option<&crate::model::SentimentAnalysisSettings> {
        self.sentiment_analysis_settings.as_ref()
    }
    /// <p>The unique identifier of the bot that the alias applies to.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotAliasInput");
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_locale_settings", &self.bot_alias_locale_settings);
        formatter.field("conversation_log_settings", &self.conversation_log_settings);
        formatter.field(
            "sentiment_analysis_settings",
            &self.sentiment_analysis_settings,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotInput {
    /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
    /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
    pub bot_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
    pub test_bot_alias_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateBotInput {
    /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
    /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
    pub fn bot_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.bot_tags.as_ref()
    }
    /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
    pub fn test_bot_alias_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.test_bot_alias_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_tags", &self.bot_tags);
        formatter.field("test_bot_alias_tags", &self.test_bot_alias_tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildBotLocaleInput {
    /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl BuildBotLocaleInput {
    /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for BuildBotLocaleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildBotLocaleInput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
