// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Lex Model Building V2
///
/// Client for invoking operations on Amazon Lex Model Building V2. Each operation on Amazon Lex Model Building V2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lexmodelsv2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lexmodelsv2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lexmodelsv2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BuildBotLocale`](crate::client::fluent_builders::BuildBotLocale) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::BuildBotLocale::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::BuildBotLocale::set_bot_id): <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::BuildBotLocale::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::BuildBotLocale::set_bot_version): <p>The version of the bot to build. This can only be the draft version of the bot.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::BuildBotLocale::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::BuildBotLocale::set_locale_id): <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`BuildBotLocaleOutput`](crate::output::BuildBotLocaleOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::BuildBotLocaleOutput::bot_id): <p>The identifier of the specified bot.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::BuildBotLocaleOutput::bot_version): <p>The version of the bot that was built. This is only the draft version of the bot.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::BuildBotLocaleOutput::locale_id): <p>The language and locale specified of where the bot can be used.</p>
    ///   - [`bot_locale_status(Option<BotLocaleStatus>)`](crate::output::BuildBotLocaleOutput::bot_locale_status): <p>The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>
    ///   - [`last_build_submitted_date_time(Option<DateTime>)`](crate::output::BuildBotLocaleOutput::last_build_submitted_date_time): <p>A timestamp indicating the date and time that the bot was last built for this locale.</p>
    /// - On failure, responds with [`SdkError<BuildBotLocaleError>`](crate::error::BuildBotLocaleError)
    pub fn build_bot_locale(&self) -> fluent_builders::BuildBotLocale {
        fluent_builders::BuildBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBot`](crate::client::fluent_builders::CreateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::CreateBot::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::CreateBot::set_bot_name): <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBot::set_description): <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateBot::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateBot::set_role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    ///   - [`data_privacy(DataPrivacy)`](crate::client::fluent_builders::CreateBot::data_privacy) / [`set_data_privacy(Option<DataPrivacy>)`](crate::client::fluent_builders::CreateBot::set_data_privacy): <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    ///   - [`idle_session_ttl_in_seconds(i32)`](crate::client::fluent_builders::CreateBot::idle_session_ttl_in_seconds) / [`set_idle_session_ttl_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateBot::set_idle_session_ttl_in_seconds): <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>  <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>  <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    ///   - [`bot_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBot::bot_tags) / [`set_bot_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBot::set_bot_tags): <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
    ///   - [`test_bot_alias_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBot::test_bot_alias_tags) / [`set_test_bot_alias_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBot::set_test_bot_alias_tags): <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
    /// - On success, responds with [`CreateBotOutput`](crate::output::CreateBotOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::CreateBotOutput::bot_id): <p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::CreateBotOutput::bot_name): <p>The name specified for the bot.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateBotOutput::description): <p>The description specified for the bot.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::CreateBotOutput::role_arn): <p>The IAM role specified for the bot.</p>
    ///   - [`data_privacy(Option<DataPrivacy>)`](crate::output::CreateBotOutput::data_privacy): <p>The data privacy settings specified for the bot.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::CreateBotOutput::idle_session_ttl_in_seconds): <p>The session idle time specified for the bot.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::CreateBotOutput::bot_status): <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateBotOutput::creation_date_time): <p>A timestamp indicating the date and time that the bot was created.</p>
    ///   - [`bot_tags(Option<HashMap<String, String>>)`](crate::output::CreateBotOutput::bot_tags): <p>A list of tags associated with the bot.</p>
    ///   - [`test_bot_alias_tags(Option<HashMap<String, String>>)`](crate::output::CreateBotOutput::test_bot_alias_tags): <p>A list of tags associated with the test alias for the bot.</p>
    /// - On failure, responds with [`SdkError<CreateBotError>`](crate::error::CreateBotError)
    pub fn create_bot(&self) -> fluent_builders::CreateBot {
        fluent_builders::CreateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBotAlias`](crate::client::fluent_builders::CreateBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_alias_name(impl Into<String>)`](crate::client::fluent_builders::CreateBotAlias::bot_alias_name) / [`set_bot_alias_name(Option<String>)`](crate::client::fluent_builders::CreateBotAlias::set_bot_alias_name): <p>The alias to create. The name must be unique for the bot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBotAlias::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBotAlias::set_description): <p>A description of the alias. Use this description to help identify the alias.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::CreateBotAlias::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::CreateBotAlias::set_bot_version): <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
    ///   - [`bot_alias_locale_settings(HashMap<String, BotAliasLocaleSettings>)`](crate::client::fluent_builders::CreateBotAlias::bot_alias_locale_settings) / [`set_bot_alias_locale_settings(Option<HashMap<String, BotAliasLocaleSettings>>)`](crate::client::fluent_builders::CreateBotAlias::set_bot_alias_locale_settings): <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
    ///   - [`conversation_log_settings(ConversationLogSettings)`](crate::client::fluent_builders::CreateBotAlias::conversation_log_settings) / [`set_conversation_log_settings(Option<ConversationLogSettings>)`](crate::client::fluent_builders::CreateBotAlias::set_conversation_log_settings): <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
    ///   - [`sentiment_analysis_settings(SentimentAnalysisSettings)`](crate::client::fluent_builders::CreateBotAlias::sentiment_analysis_settings) / [`set_sentiment_analysis_settings(Option<SentimentAnalysisSettings>)`](crate::client::fluent_builders::CreateBotAlias::set_sentiment_analysis_settings): <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateBotAlias::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateBotAlias::set_bot_id): <p>The unique identifier of the bot that the alias applies to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateBotAlias::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateBotAlias::set_tags): <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
    /// - On success, responds with [`CreateBotAliasOutput`](crate::output::CreateBotAliasOutput) with field(s):
    ///   - [`bot_alias_id(Option<String>)`](crate::output::CreateBotAliasOutput::bot_alias_id): <p>The unique identifier of the bot alias.</p>
    ///   - [`bot_alias_name(Option<String>)`](crate::output::CreateBotAliasOutput::bot_alias_name): <p>The name specified for the bot alias.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateBotAliasOutput::description): <p>The description specified for the bot alias.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateBotAliasOutput::bot_version): <p>The version of the bot associated with this alias.</p>
    ///   - [`bot_alias_locale_settings(Option<HashMap<String, BotAliasLocaleSettings>>)`](crate::output::CreateBotAliasOutput::bot_alias_locale_settings): <p>Configuration information for a specific locale.</p>
    ///   - [`conversation_log_settings(Option<ConversationLogSettings>)`](crate::output::CreateBotAliasOutput::conversation_log_settings): <p>The conversation log settings specified for the alias.</p>
    ///   - [`sentiment_analysis_settings(Option<SentimentAnalysisSettings>)`](crate::output::CreateBotAliasOutput::sentiment_analysis_settings): <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    ///   - [`bot_alias_status(Option<BotAliasStatus>)`](crate::output::CreateBotAliasOutput::bot_alias_status): <p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::CreateBotAliasOutput::bot_id): <p>The unique identifier of the bot that this alias applies to.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateBotAliasOutput::creation_date_time): <p>A Unix timestamp indicating the date and time that the bot alias was created.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateBotAliasOutput::tags): <p>A list of tags associated with the bot alias.</p>
    /// - On failure, responds with [`SdkError<CreateBotAliasError>`](crate::error::CreateBotAliasError)
    pub fn create_bot_alias(&self) -> fluent_builders::CreateBotAlias {
        fluent_builders::CreateBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBotLocale`](crate::client::fluent_builders::CreateBotLocale) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateBotLocale::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateBotLocale::set_bot_id): <p>The identifier of the bot to create the locale for.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::CreateBotLocale::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::CreateBotLocale::set_bot_version): <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::CreateBotLocale::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::CreateBotLocale::set_locale_id): <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBotLocale::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBotLocale::set_description): <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
    ///   - [`nlu_intent_confidence_threshold(f64)`](crate::client::fluent_builders::CreateBotLocale::nlu_intent_confidence_threshold) / [`set_nlu_intent_confidence_threshold(Option<f64>)`](crate::client::fluent_builders::CreateBotLocale::set_nlu_intent_confidence_threshold): <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>  <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>  <ul>   <li> <p>AMAZON.FallbackIntent</p> </li>   <li> <p>IntentA</p> </li>   <li> <p>IntentB</p> </li>   <li> <p>IntentC</p> </li>  </ul>
    ///   - [`voice_settings(VoiceSettings)`](crate::client::fluent_builders::CreateBotLocale::voice_settings) / [`set_voice_settings(Option<VoiceSettings>)`](crate::client::fluent_builders::CreateBotLocale::set_voice_settings): <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    /// - On success, responds with [`CreateBotLocaleOutput`](crate::output::CreateBotLocaleOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::CreateBotLocaleOutput::bot_id): <p>The specified bot identifier.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateBotLocaleOutput::bot_version): <p>The specified bot version.</p>
    ///   - [`locale_name(Option<String>)`](crate::output::CreateBotLocaleOutput::locale_name): <p>The specified locale name.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::CreateBotLocaleOutput::locale_id): <p>The specified locale identifier.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateBotLocaleOutput::description): <p>The specified description of the bot locale.</p>
    ///   - [`nlu_intent_confidence_threshold(Option<f64>)`](crate::output::CreateBotLocaleOutput::nlu_intent_confidence_threshold): <p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>
    ///   - [`voice_settings(Option<VoiceSettings>)`](crate::output::CreateBotLocaleOutput::voice_settings): <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    ///   - [`bot_locale_status(Option<BotLocaleStatus>)`](crate::output::CreateBotLocaleOutput::bot_locale_status): <p>The status of the bot.</p>  <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p>  <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p>  <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateBotLocaleOutput::creation_date_time): <p>A timestamp specifying the date and time that the bot locale was created.</p>
    /// - On failure, responds with [`SdkError<CreateBotLocaleError>`](crate::error::CreateBotLocaleError)
    pub fn create_bot_locale(&self) -> fluent_builders::CreateBotLocale {
        fluent_builders::CreateBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBotVersion`](crate::client::fluent_builders::CreateBotVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateBotVersion::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateBotVersion::set_bot_id): <p>The identifier of the bot to create the version for.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateBotVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateBotVersion::set_description): <p>A description of the version. Use the description to help identify the version in lists.</p>
    ///   - [`bot_version_locale_specification(HashMap<String, BotVersionLocaleDetails>)`](crate::client::fluent_builders::CreateBotVersion::bot_version_locale_specification) / [`set_bot_version_locale_specification(Option<HashMap<String, BotVersionLocaleDetails>>)`](crate::client::fluent_builders::CreateBotVersion::set_bot_version_locale_specification): <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
    /// - On success, responds with [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::CreateBotVersionOutput::bot_id): <p>The bot identifier specified in the request.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateBotVersionOutput::description): <p>The description of the version specified in the request.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateBotVersionOutput::bot_version): <p>The version number assigned to the version.</p>
    ///   - [`bot_version_locale_specification(Option<HashMap<String, BotVersionLocaleDetails>>)`](crate::output::CreateBotVersionOutput::bot_version_locale_specification): <p>The source versions used for each locale in the new version.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::CreateBotVersionOutput::bot_status): <p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can't build the bot, it sets status to <code>Failed</code>.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateBotVersionOutput::creation_date_time): <p>A timestamp of the date and time that the version was created.</p>
    /// - On failure, responds with [`SdkError<CreateBotVersionError>`](crate::error::CreateBotVersionError)
    pub fn create_bot_version(&self) -> fluent_builders::CreateBotVersion {
        fluent_builders::CreateBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateExport`](crate::client::fluent_builders::CreateExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_specification(ExportResourceSpecification)`](crate::client::fluent_builders::CreateExport::resource_specification) / [`set_resource_specification(Option<ExportResourceSpecification>)`](crate::client::fluent_builders::CreateExport::set_resource_specification): <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
    ///   - [`file_format(ImportExportFileFormat)`](crate::client::fluent_builders::CreateExport::file_format) / [`set_file_format(Option<ImportExportFileFormat>)`](crate::client::fluent_builders::CreateExport::set_file_format): <p>The file format of the bot or bot locale definition files.</p>
    ///   - [`file_password(impl Into<String>)`](crate::client::fluent_builders::CreateExport::file_password) / [`set_file_password(Option<String>)`](crate::client::fluent_builders::CreateExport::set_file_password): <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
    /// - On success, responds with [`CreateExportOutput`](crate::output::CreateExportOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::CreateExportOutput::export_id): <p>An identifier for a specific request to create an export.</p>
    ///   - [`resource_specification(Option<ExportResourceSpecification>)`](crate::output::CreateExportOutput::resource_specification): <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    ///   - [`file_format(Option<ImportExportFileFormat>)`](crate::output::CreateExportOutput::file_format): <p>The file format used for the bot or bot locale definition files.</p>
    ///   - [`export_status(Option<ExportStatus>)`](crate::output::CreateExportOutput::export_status): <p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateExportOutput::creation_date_time): <p>The date and time that the request to export a bot was created.</p>
    /// - On failure, responds with [`SdkError<CreateExportError>`](crate::error::CreateExportError)
    pub fn create_export(&self) -> fluent_builders::CreateExport {
        fluent_builders::CreateExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntent`](crate::client::fluent_builders::CreateIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`intent_name(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::intent_name) / [`set_intent_name(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_intent_name): <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_description): <p>A description of the intent. Use the description to help identify the intent in lists.</p>
    ///   - [`parent_intent_signature(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::parent_intent_signature) / [`set_parent_intent_signature(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_parent_intent_signature): <p>A unique identifier for the built-in intent to base this intent on.</p>
    ///   - [`sample_utterances(Vec<SampleUtterance>)`](crate::client::fluent_builders::CreateIntent::sample_utterances) / [`set_sample_utterances(Option<Vec<SampleUtterance>>)`](crate::client::fluent_builders::CreateIntent::set_sample_utterances): <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>  <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
    ///   - [`dialog_code_hook(DialogCodeHookSettings)`](crate::client::fluent_builders::CreateIntent::dialog_code_hook) / [`set_dialog_code_hook(Option<DialogCodeHookSettings>)`](crate::client::fluent_builders::CreateIntent::set_dialog_code_hook): <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>  <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
    ///   - [`fulfillment_code_hook(FulfillmentCodeHookSettings)`](crate::client::fluent_builders::CreateIntent::fulfillment_code_hook) / [`set_fulfillment_code_hook(Option<FulfillmentCodeHookSettings>)`](crate::client::fluent_builders::CreateIntent::set_fulfillment_code_hook): <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>  <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
    ///   - [`intent_confirmation_setting(IntentConfirmationSetting)`](crate::client::fluent_builders::CreateIntent::intent_confirmation_setting) / [`set_intent_confirmation_setting(Option<IntentConfirmationSetting>)`](crate::client::fluent_builders::CreateIntent::set_intent_confirmation_setting): <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
    ///   - [`intent_closing_setting(IntentClosingSetting)`](crate::client::fluent_builders::CreateIntent::intent_closing_setting) / [`set_intent_closing_setting(Option<IntentClosingSetting>)`](crate::client::fluent_builders::CreateIntent::set_intent_closing_setting): <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
    ///   - [`input_contexts(Vec<InputContext>)`](crate::client::fluent_builders::CreateIntent::input_contexts) / [`set_input_contexts(Option<Vec<InputContext>>)`](crate::client::fluent_builders::CreateIntent::set_input_contexts): <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>  <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>  <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>  <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>  <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
    ///   - [`output_contexts(Vec<OutputContext>)`](crate::client::fluent_builders::CreateIntent::output_contexts) / [`set_output_contexts(Option<Vec<OutputContext>>)`](crate::client::fluent_builders::CreateIntent::set_output_contexts): <p>A lists of contexts that the intent activates when it is fulfilled.</p>  <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>  <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
    ///   - [`kendra_configuration(KendraConfiguration)`](crate::client::fluent_builders::CreateIntent::kendra_configuration) / [`set_kendra_configuration(Option<KendraConfiguration>)`](crate::client::fluent_builders::CreateIntent::set_kendra_configuration): <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_bot_id): <p>The identifier of the bot associated with this intent.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_bot_version): <p>The identifier of the version of the bot associated with this intent.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntent::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::CreateIntent::set_locale_id): <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`CreateIntentOutput`](crate::output::CreateIntentOutput) with field(s):
    ///   - [`intent_id(Option<String>)`](crate::output::CreateIntentOutput::intent_id): <p>A unique identifier for the intent.</p>
    ///   - [`intent_name(Option<String>)`](crate::output::CreateIntentOutput::intent_name): <p>The name specified for the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateIntentOutput::description): <p>The description specified for the intent.</p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::CreateIntentOutput::parent_intent_signature): <p>The signature of the parent intent specified for the intent.</p>
    ///   - [`sample_utterances(Option<Vec<SampleUtterance>>)`](crate::output::CreateIntentOutput::sample_utterances): <p>The sample utterances specified for the intent.</p>
    ///   - [`dialog_code_hook(Option<DialogCodeHookSettings>)`](crate::output::CreateIntentOutput::dialog_code_hook): <p>The dialog Lambda function specified for the intent.</p>
    ///   - [`fulfillment_code_hook(Option<FulfillmentCodeHookSettings>)`](crate::output::CreateIntentOutput::fulfillment_code_hook): <p>The fulfillment Lambda function specified for the intent.</p>
    ///   - [`intent_confirmation_setting(Option<IntentConfirmationSetting>)`](crate::output::CreateIntentOutput::intent_confirmation_setting): <p>The confirmation setting specified for the intent.</p>
    ///   - [`intent_closing_setting(Option<IntentClosingSetting>)`](crate::output::CreateIntentOutput::intent_closing_setting): <p>The closing setting specified for the intent.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::CreateIntentOutput::input_contexts): <p>The list of input contexts specified for the intent.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::CreateIntentOutput::output_contexts): <p>The list of output contexts specified for the intent.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::CreateIntentOutput::kendra_configuration): <p>Configuration for searching a Amazon Kendra index specified for the intent.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::CreateIntentOutput::bot_id): <p>The identifier of the bot associated with the intent.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateIntentOutput::bot_version): <p>The identifier of the version of the bot associated with the intent.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::CreateIntentOutput::locale_id): <p>The locale that the intent is specified to use.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateIntentOutput::creation_date_time): <p>A timestamp of the date and time that the intent was created.</p>
    /// - On failure, responds with [`SdkError<CreateIntentError>`](crate::error::CreateIntentError)
    pub fn create_intent(&self) -> fluent_builders::CreateIntent {
        fluent_builders::CreateIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourcePolicy`](crate::client::fluent_builders::CreateResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CreateResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CreateResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::CreateResourcePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::CreateResourcePolicy::set_policy): <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>  <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    /// - On success, responds with [`CreateResourcePolicyOutput`](crate::output::CreateResourcePolicyOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::CreateResourcePolicyOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::CreateResourcePolicyOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<CreateResourcePolicyError>`](crate::error::CreateResourcePolicyError)
    pub fn create_resource_policy(&self) -> fluent_builders::CreateResourcePolicy {
        fluent_builders::CreateResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourcePolicyStatement`](crate::client::fluent_builders::CreateResourcePolicyStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_statement_id): <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
    ///   - [`effect(Effect)`](crate::client::fluent_builders::CreateResourcePolicyStatement::effect) / [`set_effect(Option<Effect>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_effect): <p>Determines whether the statement allows or denies access to the resource.</p>
    ///   - [`principal(Vec<Principal>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::principal) / [`set_principal(Option<Vec<Principal>>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_principal): <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
    ///   - [`action(Vec<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::action) / [`set_action(Option<Vec<String>>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_action): <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
    ///   - [`condition(HashMap<String, HashMap<String, String>>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::condition) / [`set_condition(Option<HashMap<String, HashMap<String, String>>>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_condition): <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
    ///   - [`expected_revision_id(impl Into<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::expected_revision_id) / [`set_expected_revision_id(Option<String>)`](crate::client::fluent_builders::CreateResourcePolicyStatement::set_expected_revision_id): <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>  <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    /// - On success, responds with [`CreateResourcePolicyStatementOutput`](crate::output::CreateResourcePolicyStatementOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::CreateResourcePolicyStatementOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::CreateResourcePolicyStatementOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<CreateResourcePolicyStatementError>`](crate::error::CreateResourcePolicyStatementError)
    pub fn create_resource_policy_statement(
        &self,
    ) -> fluent_builders::CreateResourcePolicyStatement {
        fluent_builders::CreateResourcePolicyStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSlot`](crate::client::fluent_builders::CreateSlot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_name(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::slot_name) / [`set_slot_name(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_slot_name): <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_description): <p>A description of the slot. Use this to help identify the slot in lists.</p>
    ///   - [`slot_type_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::slot_type_id) / [`set_slot_type_id(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_slot_type_id): <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
    ///   - [`value_elicitation_setting(SlotValueElicitationSetting)`](crate::client::fluent_builders::CreateSlot::value_elicitation_setting) / [`set_value_elicitation_setting(Option<SlotValueElicitationSetting>)`](crate::client::fluent_builders::CreateSlot::set_value_elicitation_setting): <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
    ///   - [`obfuscation_setting(ObfuscationSetting)`](crate::client::fluent_builders::CreateSlot::obfuscation_setting) / [`set_obfuscation_setting(Option<ObfuscationSetting>)`](crate::client::fluent_builders::CreateSlot::set_obfuscation_setting): <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>  <p>The default is to obfuscate values in the CloudWatch logs.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_bot_id): <p>The identifier of the bot associated with the slot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_bot_version): <p>The version of the bot associated with the slot.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_locale_id): <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlot::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::CreateSlot::set_intent_id): <p>The identifier of the intent that contains the slot.</p>
    ///   - [`multiple_values_setting(MultipleValuesSetting)`](crate::client::fluent_builders::CreateSlot::multiple_values_setting) / [`set_multiple_values_setting(Option<MultipleValuesSetting>)`](crate::client::fluent_builders::CreateSlot::set_multiple_values_setting): <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>  <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    /// - On success, responds with [`CreateSlotOutput`](crate::output::CreateSlotOutput) with field(s):
    ///   - [`slot_id(Option<String>)`](crate::output::CreateSlotOutput::slot_id): <p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>
    ///   - [`slot_name(Option<String>)`](crate::output::CreateSlotOutput::slot_name): <p>The name specified for the slot.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateSlotOutput::description): <p>The description associated with the slot.</p>
    ///   - [`slot_type_id(Option<String>)`](crate::output::CreateSlotOutput::slot_type_id): <p>The unique identifier of the slot type associated with this slot.</p>
    ///   - [`value_elicitation_setting(Option<SlotValueElicitationSetting>)`](crate::output::CreateSlotOutput::value_elicitation_setting): <p>The value elicitation settings specified for the slot.</p>
    ///   - [`obfuscation_setting(Option<ObfuscationSetting>)`](crate::output::CreateSlotOutput::obfuscation_setting): <p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::CreateSlotOutput::bot_id): <p>The unique identifier of the bot associated with the slot.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateSlotOutput::bot_version): <p>The version of the bot associated with the slot.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::CreateSlotOutput::locale_id): <p>The language and local specified for the slot.</p>
    ///   - [`intent_id(Option<String>)`](crate::output::CreateSlotOutput::intent_id): <p>The unique identifier of the intent associated with the slot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateSlotOutput::creation_date_time): <p>The timestamp of the date and time that the slot was created.</p>
    ///   - [`multiple_values_setting(Option<MultipleValuesSetting>)`](crate::output::CreateSlotOutput::multiple_values_setting): <p>Indicates whether the slot returns multiple values in one response.</p>
    /// - On failure, responds with [`SdkError<CreateSlotError>`](crate::error::CreateSlotError)
    pub fn create_slot(&self) -> fluent_builders::CreateSlot {
        fluent_builders::CreateSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSlotType`](crate::client::fluent_builders::CreateSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::slot_type_name) / [`set_slot_type_name(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_slot_type_name): <p>The name for the slot. A slot type name must be unique within the account.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_description): <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
    ///   - [`slot_type_values(Vec<SlotTypeValue>)`](crate::client::fluent_builders::CreateSlotType::slot_type_values) / [`set_slot_type_values(Option<Vec<SlotTypeValue>>)`](crate::client::fluent_builders::CreateSlotType::set_slot_type_values): <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
    ///   - [`value_selection_setting(SlotValueSelectionSetting)`](crate::client::fluent_builders::CreateSlotType::value_selection_setting) / [`set_value_selection_setting(Option<SlotValueSelectionSetting>)`](crate::client::fluent_builders::CreateSlotType::set_value_selection_setting): <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>  <ul>   <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>   <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>  </ul>  <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
    ///   - [`parent_slot_type_signature(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::parent_slot_type_signature) / [`set_parent_slot_type_signature(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_parent_slot_type_signature): <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>  <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_bot_id): <p>The identifier of the bot associated with this slot type.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_bot_version): <p>The identifier of the bot version associated with this slot type.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::CreateSlotType::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::CreateSlotType::set_locale_id): <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`external_source_setting(ExternalSourceSetting)`](crate::client::fluent_builders::CreateSlotType::external_source_setting) / [`set_external_source_setting(Option<ExternalSourceSetting>)`](crate::client::fluent_builders::CreateSlotType::set_external_source_setting): <p>Sets the type of external information used to create the slot type.</p>
    /// - On success, responds with [`CreateSlotTypeOutput`](crate::output::CreateSlotTypeOutput) with field(s):
    ///   - [`slot_type_id(Option<String>)`](crate::output::CreateSlotTypeOutput::slot_type_id): <p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>
    ///   - [`slot_type_name(Option<String>)`](crate::output::CreateSlotTypeOutput::slot_type_name): <p>The name specified for the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateSlotTypeOutput::description): <p>The description specified for the slot type.</p>
    ///   - [`slot_type_values(Option<Vec<SlotTypeValue>>)`](crate::output::CreateSlotTypeOutput::slot_type_values): <p>The list of values that the slot type can assume.</p>
    ///   - [`value_selection_setting(Option<SlotValueSelectionSetting>)`](crate::output::CreateSlotTypeOutput::value_selection_setting): <p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::CreateSlotTypeOutput::parent_slot_type_signature): <p>The signature of the base slot type specified for the slot type.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::CreateSlotTypeOutput::bot_id): <p>The identifier for the bot associated with the slot type.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::CreateSlotTypeOutput::bot_version): <p>The version of the bot associated with the slot type.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::CreateSlotTypeOutput::locale_id): <p>The specified language and local specified for the slot type.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::CreateSlotTypeOutput::creation_date_time): <p>A timestamp of the date and time that the slot type was created.</p>
    ///   - [`external_source_setting(Option<ExternalSourceSetting>)`](crate::output::CreateSlotTypeOutput::external_source_setting): <p>The type of external information used to create the slot type.</p>
    /// - On failure, responds with [`SdkError<CreateSlotTypeError>`](crate::error::CreateSlotTypeError)
    pub fn create_slot_type(&self) -> fluent_builders::CreateSlotType {
        fluent_builders::CreateSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUploadUrl`](crate::client::fluent_builders::CreateUploadUrl) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::CreateUploadUrl::send) it.

    /// - On success, responds with [`CreateUploadUrlOutput`](crate::output::CreateUploadUrlOutput) with field(s):
    ///   - [`import_id(Option<String>)`](crate::output::CreateUploadUrlOutput::import_id): <p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>
    ///   - [`upload_url(Option<String>)`](crate::output::CreateUploadUrlOutput::upload_url): <p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>
    /// - On failure, responds with [`SdkError<CreateUploadUrlError>`](crate::error::CreateUploadUrlError)
    pub fn create_upload_url(&self) -> fluent_builders::CreateUploadUrl {
        fluent_builders::CreateUploadUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBot`](crate::client::fluent_builders::DeleteBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteBot::set_bot_id): <p>The identifier of the bot to delete. </p>
    ///   - [`skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBot::skip_resource_in_use_check) / [`set_skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBot::set_skip_resource_in_use_check): <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
    /// - On success, responds with [`DeleteBotOutput`](crate::output::DeleteBotOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DeleteBotOutput::bot_id): <p>The unique identifier of the bot that Amazon Lex is deleting.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::DeleteBotOutput::bot_status): <p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteBotError>`](crate::error::DeleteBotError)
    pub fn delete_bot(&self) -> fluent_builders::DeleteBot {
        fluent_builders::DeleteBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotAlias`](crate::client::fluent_builders::DeleteBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_alias_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBotAlias::bot_alias_id) / [`set_bot_alias_id(Option<String>)`](crate::client::fluent_builders::DeleteBotAlias::set_bot_alias_id): <p>The unique identifier of the bot alias to delete.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBotAlias::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteBotAlias::set_bot_id): <p>The unique identifier of the bot associated with the alias to delete.</p>
    ///   - [`skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBotAlias::skip_resource_in_use_check) / [`set_skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBotAlias::set_skip_resource_in_use_check): <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
    /// - On success, responds with [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput) with field(s):
    ///   - [`bot_alias_id(Option<String>)`](crate::output::DeleteBotAliasOutput::bot_alias_id): <p>The unique identifier of the bot alias to delete.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::DeleteBotAliasOutput::bot_id): <p>The unique identifier of the bot that contains the alias to delete.</p>
    ///   - [`bot_alias_status(Option<BotAliasStatus>)`](crate::output::DeleteBotAliasOutput::bot_alias_status): <p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>
    /// - On failure, responds with [`SdkError<DeleteBotAliasError>`](crate::error::DeleteBotAliasError)
    pub fn delete_bot_alias(&self) -> fluent_builders::DeleteBotAlias {
        fluent_builders::DeleteBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotLocale`](crate::client::fluent_builders::DeleteBotLocale) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBotLocale::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteBotLocale::set_bot_id): <p>The unique identifier of the bot that contains the locale.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteBotLocale::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteBotLocale::set_bot_version): <p>The version of the bot that contains the locale. </p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBotLocale::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteBotLocale::set_locale_id): <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`DeleteBotLocaleOutput`](crate::output::DeleteBotLocaleOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DeleteBotLocaleOutput::bot_id): <p>The identifier of the bot that contained the deleted locale.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DeleteBotLocaleOutput::bot_version): <p>The version of the bot that contained the deleted locale.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DeleteBotLocaleOutput::locale_id): <p>The language and locale of the deleted locale.</p>
    ///   - [`bot_locale_status(Option<BotLocaleStatus>)`](crate::output::DeleteBotLocaleOutput::bot_locale_status): <p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>
    /// - On failure, responds with [`SdkError<DeleteBotLocaleError>`](crate::error::DeleteBotLocaleError)
    pub fn delete_bot_locale(&self) -> fluent_builders::DeleteBotLocale {
        fluent_builders::DeleteBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotVersion`](crate::client::fluent_builders::DeleteBotVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBotVersion::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteBotVersion::set_bot_id): <p>The identifier of the bot that contains the version.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteBotVersion::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteBotVersion::set_bot_version): <p>The version of the bot to delete.</p>
    ///   - [`skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBotVersion::skip_resource_in_use_check) / [`set_skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteBotVersion::set_skip_resource_in_use_check): <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
    /// - On success, responds with [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DeleteBotVersionOutput::bot_id): <p>The identifier of the bot that is being deleted.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DeleteBotVersionOutput::bot_version): <p>The version of the bot that is being deleted.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::DeleteBotVersionOutput::bot_status): <p>The current status of the bot. </p>
    /// - On failure, responds with [`SdkError<DeleteBotVersionError>`](crate::error::DeleteBotVersionError)
    pub fn delete_bot_version(&self) -> fluent_builders::DeleteBotVersion {
        fluent_builders::DeleteBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomVocabulary`](crate::client::fluent_builders::DeleteCustomVocabulary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::set_bot_id): <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::set_bot_version): <p>The version of the bot to remove the custom vocabulary from.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomVocabulary::set_locale_id): <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
    /// - On success, responds with [`DeleteCustomVocabularyOutput`](crate::output::DeleteCustomVocabularyOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DeleteCustomVocabularyOutput::bot_id): <p>The identifier of the bot that the custom vocabulary was removed from.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DeleteCustomVocabularyOutput::bot_version): <p>The version of the bot that the custom vocabulary was removed from.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DeleteCustomVocabularyOutput::locale_id): <p>The locale identifier for the locale that the custom vocabulary was removed from.</p>
    ///   - [`custom_vocabulary_status(Option<CustomVocabularyStatus>)`](crate::output::DeleteCustomVocabularyOutput::custom_vocabulary_status): <p>The status of removing the custom vocabulary.</p>
    /// - On failure, responds with [`SdkError<DeleteCustomVocabularyError>`](crate::error::DeleteCustomVocabularyError)
    pub fn delete_custom_vocabulary(&self) -> fluent_builders::DeleteCustomVocabulary {
        fluent_builders::DeleteCustomVocabulary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteExport`](crate::client::fluent_builders::DeleteExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_id(impl Into<String>)`](crate::client::fluent_builders::DeleteExport::export_id) / [`set_export_id(Option<String>)`](crate::client::fluent_builders::DeleteExport::set_export_id): <p>The unique identifier of the export to delete.</p>
    /// - On success, responds with [`DeleteExportOutput`](crate::output::DeleteExportOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::DeleteExportOutput::export_id): <p>The unique identifier of the deleted export.</p>
    ///   - [`export_status(Option<ExportStatus>)`](crate::output::DeleteExportOutput::export_status): <p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>
    /// - On failure, responds with [`SdkError<DeleteExportError>`](crate::error::DeleteExportError)
    pub fn delete_export(&self) -> fluent_builders::DeleteExport {
        fluent_builders::DeleteExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImport`](crate::client::fluent_builders::DeleteImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_id(impl Into<String>)`](crate::client::fluent_builders::DeleteImport::import_id) / [`set_import_id(Option<String>)`](crate::client::fluent_builders::DeleteImport::set_import_id): <p>The unique identifier of the import to delete.</p>
    /// - On success, responds with [`DeleteImportOutput`](crate::output::DeleteImportOutput) with field(s):
    ///   - [`import_id(Option<String>)`](crate::output::DeleteImportOutput::import_id): <p>The unique identifier of the deleted import.</p>
    ///   - [`import_status(Option<ImportStatus>)`](crate::output::DeleteImportOutput::import_status): <p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>
    /// - On failure, responds with [`SdkError<DeleteImportError>`](crate::error::DeleteImportError)
    pub fn delete_import(&self) -> fluent_builders::DeleteImport {
        fluent_builders::DeleteImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntent`](crate::client::fluent_builders::DeleteIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntent::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::DeleteIntent::set_intent_id): <p>The unique identifier of the intent to delete.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntent::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteIntent::set_bot_id): <p>The identifier of the bot associated with the intent.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteIntent::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteIntent::set_bot_version): <p>The version of the bot associated with the intent.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntent::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteIntent::set_locale_id): <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)

    /// - On failure, responds with [`SdkError<DeleteIntentError>`](crate::error::DeleteIntentError)
    pub fn delete_intent(&self) -> fluent_builders::DeleteIntent {
        fluent_builders::DeleteIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
    ///   - [`expected_revision_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::expected_revision_id) / [`set_expected_revision_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_expected_revision_id): <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>  <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::DeleteResourcePolicyOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::DeleteResourcePolicyOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicyStatement`](crate::client::fluent_builders::DeleteResourcePolicyStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::set_statement_id): <p>The name of the statement (SID) to delete from the policy.</p>
    ///   - [`expected_revision_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::expected_revision_id) / [`set_expected_revision_id(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicyStatement::set_expected_revision_id): <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>  <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
    /// - On success, responds with [`DeleteResourcePolicyStatementOutput`](crate::output::DeleteResourcePolicyStatementOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::DeleteResourcePolicyStatementOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::DeleteResourcePolicyStatementOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<DeleteResourcePolicyStatementError>`](crate::error::DeleteResourcePolicyStatementError)
    pub fn delete_resource_policy_statement(
        &self,
    ) -> fluent_builders::DeleteResourcePolicyStatement {
        fluent_builders::DeleteResourcePolicyStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSlot`](crate::client::fluent_builders::DeleteSlot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlot::slot_id) / [`set_slot_id(Option<String>)`](crate::client::fluent_builders::DeleteSlot::set_slot_id): <p>The identifier of the slot to delete. </p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteSlot::set_bot_id): <p>The identifier of the bot associated with the slot to delete.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteSlot::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteSlot::set_bot_version): <p>The version of the bot associated with the slot to delete.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlot::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteSlot::set_locale_id): <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlot::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::DeleteSlot::set_intent_id): <p>The identifier of the intent associated with the slot.</p>
    /// - On success, responds with [`DeleteSlotOutput`](crate::output::DeleteSlotOutput)

    /// - On failure, responds with [`SdkError<DeleteSlotError>`](crate::error::DeleteSlotError)
    pub fn delete_slot(&self) -> fluent_builders::DeleteSlot {
        fluent_builders::DeleteSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSlotType`](crate::client::fluent_builders::DeleteSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_type_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotType::slot_type_id) / [`set_slot_type_id(Option<String>)`](crate::client::fluent_builders::DeleteSlotType::set_slot_type_id): <p>The identifier of the slot type to delete.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotType::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteSlotType::set_bot_id): <p>The identifier of the bot associated with the slot type.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotType::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DeleteSlotType::set_bot_version): <p>The version of the bot associated with the slot type.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotType::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteSlotType::set_locale_id): <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteSlotType::skip_resource_in_use_check) / [`set_skip_resource_in_use_check(bool)`](crate::client::fluent_builders::DeleteSlotType::set_skip_resource_in_use_check): <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
    /// - On success, responds with [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteSlotTypeError>`](crate::error::DeleteSlotTypeError)
    pub fn delete_slot_type(&self) -> fluent_builders::DeleteSlotType {
        fluent_builders::DeleteSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUtterances`](crate::client::fluent_builders::DeleteUtterances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUtterances::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DeleteUtterances::set_bot_id): <p>The unique identifier of the bot that contains the utterances.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUtterances::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DeleteUtterances::set_locale_id): <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUtterances::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::DeleteUtterances::set_session_id): <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
    /// - On success, responds with [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)

    /// - On failure, responds with [`SdkError<DeleteUtterancesError>`](crate::error::DeleteUtterancesError)
    pub fn delete_utterances(&self) -> fluent_builders::DeleteUtterances {
        fluent_builders::DeleteUtterances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBot`](crate::client::fluent_builders::DescribeBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeBot::set_bot_id): <p>The unique identifier of the bot to describe.</p>
    /// - On success, responds with [`DescribeBotOutput`](crate::output::DescribeBotOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeBotOutput::bot_id): <p>The unique identifier of the bot.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::DescribeBotOutput::bot_name): <p>The name of the bot.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeBotOutput::description): <p>The description of the bot. </p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeBotOutput::role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    ///   - [`data_privacy(Option<DataPrivacy>)`](crate::output::DescribeBotOutput::data_privacy): <p>Settings for managing data privacy of the bot and its conversations with users.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::DescribeBotOutput::idle_session_ttl_in_seconds): <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::DescribeBotOutput::bot_status): <p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeBotOutput::creation_date_time): <p>A timestamp of the date and time that the bot was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeBotOutput::last_updated_date_time): <p>A timestamp of the date and time that the bot was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeBotError>`](crate::error::DescribeBotError)
    pub fn describe_bot(&self) -> fluent_builders::DescribeBot {
        fluent_builders::DescribeBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBotAlias`](crate::client::fluent_builders::DescribeBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_alias_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotAlias::bot_alias_id) / [`set_bot_alias_id(Option<String>)`](crate::client::fluent_builders::DescribeBotAlias::set_bot_alias_id): <p>The identifier of the bot alias to describe.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotAlias::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeBotAlias::set_bot_id): <p>The identifier of the bot associated with the bot alias to describe.</p>
    /// - On success, responds with [`DescribeBotAliasOutput`](crate::output::DescribeBotAliasOutput) with field(s):
    ///   - [`bot_alias_id(Option<String>)`](crate::output::DescribeBotAliasOutput::bot_alias_id): <p>The identifier of the bot alias.</p>
    ///   - [`bot_alias_name(Option<String>)`](crate::output::DescribeBotAliasOutput::bot_alias_name): <p>The name of the bot alias.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeBotAliasOutput::description): <p>The description of the bot alias.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeBotAliasOutput::bot_version): <p>The version of the bot associated with the bot alias.</p>
    ///   - [`bot_alias_locale_settings(Option<HashMap<String, BotAliasLocaleSettings>>)`](crate::output::DescribeBotAliasOutput::bot_alias_locale_settings): <p>The locale settings that are unique to the alias.</p>
    ///   - [`conversation_log_settings(Option<ConversationLogSettings>)`](crate::output::DescribeBotAliasOutput::conversation_log_settings): <p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>
    ///   - [`sentiment_analysis_settings(Option<SentimentAnalysisSettings>)`](crate::output::DescribeBotAliasOutput::sentiment_analysis_settings): <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    ///   - [`bot_alias_history_events(Option<Vec<BotAliasHistoryEvent>>)`](crate::output::DescribeBotAliasOutput::bot_alias_history_events): <p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>
    ///   - [`bot_alias_status(Option<BotAliasStatus>)`](crate::output::DescribeBotAliasOutput::bot_alias_status): <p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeBotAliasOutput::bot_id): <p>The identifier of the bot associated with the bot alias.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeBotAliasOutput::creation_date_time): <p>A timestamp of the date and time that the alias was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeBotAliasOutput::last_updated_date_time): <p>A timestamp of the date and time that the alias was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeBotAliasError>`](crate::error::DescribeBotAliasError)
    pub fn describe_bot_alias(&self) -> fluent_builders::DescribeBotAlias {
        fluent_builders::DescribeBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBotLocale`](crate::client::fluent_builders::DescribeBotLocale) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotLocale::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeBotLocale::set_bot_id): <p>The identifier of the bot associated with the locale.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeBotLocale::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeBotLocale::set_bot_version): <p>The identifier of the version of the bot associated with the locale.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotLocale::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeBotLocale::set_locale_id): <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
    /// - On success, responds with [`DescribeBotLocaleOutput`](crate::output::DescribeBotLocaleOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeBotLocaleOutput::bot_id): <p>The identifier of the bot associated with the locale.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeBotLocaleOutput::bot_version): <p>The identifier of the version of the bot associated with the locale.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeBotLocaleOutput::locale_id): <p>The unique identifier of the described locale.</p>
    ///   - [`locale_name(Option<String>)`](crate::output::DescribeBotLocaleOutput::locale_name): <p>The name of the locale.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeBotLocaleOutput::description): <p>The description of the locale.</p>
    ///   - [`nlu_intent_confidence_threshold(Option<f64>)`](crate::output::DescribeBotLocaleOutput::nlu_intent_confidence_threshold): <p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    ///   - [`voice_settings(Option<VoiceSettings>)`](crate::output::DescribeBotLocaleOutput::voice_settings): <p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>
    ///   - [`intents_count(Option<i32>)`](crate::output::DescribeBotLocaleOutput::intents_count): <p>The number of intents defined for the locale.</p>
    ///   - [`slot_types_count(Option<i32>)`](crate::output::DescribeBotLocaleOutput::slot_types_count): <p>The number of slot types defined for the locale.</p>
    ///   - [`bot_locale_status(Option<BotLocaleStatus>)`](crate::output::DescribeBotLocaleOutput::bot_locale_status): <p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::DescribeBotLocaleOutput::failure_reasons): <p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeBotLocaleOutput::creation_date_time): <p>The date and time that the locale was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeBotLocaleOutput::last_updated_date_time): <p>The date and time that the locale was last updated.</p>
    ///   - [`last_build_submitted_date_time(Option<DateTime>)`](crate::output::DescribeBotLocaleOutput::last_build_submitted_date_time): <p>The date and time that the locale was last submitted for building.</p>
    ///   - [`bot_locale_history_events(Option<Vec<BotLocaleHistoryEvent>>)`](crate::output::DescribeBotLocaleOutput::bot_locale_history_events): <p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>
    ///   - [`recommended_actions(Option<Vec<String>>)`](crate::output::DescribeBotLocaleOutput::recommended_actions): <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    /// - On failure, responds with [`SdkError<DescribeBotLocaleError>`](crate::error::DescribeBotLocaleError)
    pub fn describe_bot_locale(&self) -> fluent_builders::DescribeBotLocale {
        fluent_builders::DescribeBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBotRecommendation`](crate::client::fluent_builders::DescribeBotRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::set_bot_id): <p>The unique identifier of the bot associated with the bot recommendation.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::set_bot_version): <p>The version of the bot associated with the bot recommendation.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::set_locale_id): <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`bot_recommendation_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::bot_recommendation_id) / [`set_bot_recommendation_id(Option<String>)`](crate::client::fluent_builders::DescribeBotRecommendation::set_bot_recommendation_id): <p>The identifier of the bot recommendation to describe.</p>
    /// - On success, responds with [`DescribeBotRecommendationOutput`](crate::output::DescribeBotRecommendationOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeBotRecommendationOutput::bot_id): <p>The identifier of the bot associated with the bot recommendation.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeBotRecommendationOutput::bot_version): <p>The version of the bot associated with the bot recommendation.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeBotRecommendationOutput::locale_id): <p>The identifier of the language and locale of the bot recommendation to describe.</p>
    ///   - [`bot_recommendation_status(Option<BotRecommendationStatus>)`](crate::output::DescribeBotRecommendationOutput::bot_recommendation_status): <p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    ///   - [`bot_recommendation_id(Option<String>)`](crate::output::DescribeBotRecommendationOutput::bot_recommendation_id): <p>The identifier of the bot recommendation being described.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::DescribeBotRecommendationOutput::failure_reasons): <p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeBotRecommendationOutput::creation_date_time): <p>The date and time that the bot recommendation was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeBotRecommendationOutput::last_updated_date_time): <p>The date and time that the bot recommendation was last updated.</p>
    ///   - [`transcript_source_setting(Option<TranscriptSourceSetting>)`](crate::output::DescribeBotRecommendationOutput::transcript_source_setting): <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    ///   - [`encryption_setting(Option<EncryptionSetting>)`](crate::output::DescribeBotRecommendationOutput::encryption_setting): <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    ///   - [`bot_recommendation_results(Option<BotRecommendationResults>)`](crate::output::DescribeBotRecommendationOutput::bot_recommendation_results): <p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>
    /// - On failure, responds with [`SdkError<DescribeBotRecommendationError>`](crate::error::DescribeBotRecommendationError)
    pub fn describe_bot_recommendation(&self) -> fluent_builders::DescribeBotRecommendation {
        fluent_builders::DescribeBotRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBotVersion`](crate::client::fluent_builders::DescribeBotVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeBotVersion::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeBotVersion::set_bot_id): <p>The identifier of the bot containing the version to return metadata for.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeBotVersion::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeBotVersion::set_bot_version): <p>The version of the bot to return metadata for.</p>
    /// - On success, responds with [`DescribeBotVersionOutput`](crate::output::DescribeBotVersionOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeBotVersionOutput::bot_id): <p>The identifier of the bot that contains the version.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::DescribeBotVersionOutput::bot_name): <p>The name of the bot that contains the version.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeBotVersionOutput::bot_version): <p>The version of the bot to describe.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeBotVersionOutput::description): <p>The description specified for the bot.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeBotVersionOutput::role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>
    ///   - [`data_privacy(Option<DataPrivacy>)`](crate::output::DescribeBotVersionOutput::data_privacy): <p>Data privacy settings for the bot version.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::DescribeBotVersionOutput::idle_session_ttl_in_seconds): <p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::DescribeBotVersionOutput::bot_status): <p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::DescribeBotVersionOutput::failure_reasons): <p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't be built.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeBotVersionOutput::creation_date_time): <p>A timestamp of the date and time that the bot version was created.</p>
    /// - On failure, responds with [`SdkError<DescribeBotVersionError>`](crate::error::DescribeBotVersionError)
    pub fn describe_bot_version(&self) -> fluent_builders::DescribeBotVersion {
        fluent_builders::DescribeBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCustomVocabularyMetadata`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::set_bot_id): <p>The unique identifier of the bot that contains the custom vocabulary.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::set_bot_version): <p>The bot version of the bot to return metadata for.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeCustomVocabularyMetadata::set_locale_id): <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
    /// - On success, responds with [`DescribeCustomVocabularyMetadataOutput`](crate::output::DescribeCustomVocabularyMetadataOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeCustomVocabularyMetadataOutput::bot_id): <p>The identifier of the bot that contains the custom vocabulary.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeCustomVocabularyMetadataOutput::bot_version): <p>The version of the bot that contains the custom vocabulary to describe.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeCustomVocabularyMetadataOutput::locale_id): <p>The locale that contains the custom vocabulary to describe.</p>
    ///   - [`custom_vocabulary_status(Option<CustomVocabularyStatus>)`](crate::output::DescribeCustomVocabularyMetadataOutput::custom_vocabulary_status): <p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeCustomVocabularyMetadataOutput::creation_date_time): <p>The date and time that the custom vocabulary was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeCustomVocabularyMetadataOutput::last_updated_date_time): <p>The date and time that the custom vocabulary was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeCustomVocabularyMetadataError>`](crate::error::DescribeCustomVocabularyMetadataError)
    pub fn describe_custom_vocabulary_metadata(
        &self,
    ) -> fluent_builders::DescribeCustomVocabularyMetadata {
        fluent_builders::DescribeCustomVocabularyMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExport`](crate::client::fluent_builders::DescribeExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExport::export_id) / [`set_export_id(Option<String>)`](crate::client::fluent_builders::DescribeExport::set_export_id): <p>The unique identifier of the export to describe.</p>
    /// - On success, responds with [`DescribeExportOutput`](crate::output::DescribeExportOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::DescribeExportOutput::export_id): <p>The unique identifier of the described export.</p>
    ///   - [`resource_specification(Option<ExportResourceSpecification>)`](crate::output::DescribeExportOutput::resource_specification): <p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>
    ///   - [`file_format(Option<ImportExportFileFormat>)`](crate::output::DescribeExportOutput::file_format): <p>The file format used in the files that describe the resource. </p>
    ///   - [`export_status(Option<ExportStatus>)`](crate::output::DescribeExportOutput::export_status): <p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::DescribeExportOutput::failure_reasons): <p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>
    ///   - [`download_url(Option<String>)`](crate::output::DescribeExportOutput::download_url): <p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeExportOutput::creation_date_time): <p>The date and time that the export was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeExportOutput::last_updated_date_time): <p>The last date and time that the export was updated.</p>
    /// - On failure, responds with [`SdkError<DescribeExportError>`](crate::error::DescribeExportError)
    pub fn describe_export(&self) -> fluent_builders::DescribeExport {
        fluent_builders::DescribeExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImport`](crate::client::fluent_builders::DescribeImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_id(impl Into<String>)`](crate::client::fluent_builders::DescribeImport::import_id) / [`set_import_id(Option<String>)`](crate::client::fluent_builders::DescribeImport::set_import_id): <p>The unique identifier of the import to describe.</p>
    /// - On success, responds with [`DescribeImportOutput`](crate::output::DescribeImportOutput) with field(s):
    ///   - [`import_id(Option<String>)`](crate::output::DescribeImportOutput::import_id): <p>The unique identifier of the described import.</p>
    ///   - [`resource_specification(Option<ImportResourceSpecification>)`](crate::output::DescribeImportOutput::resource_specification): <p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>
    ///   - [`imported_resource_id(Option<String>)`](crate::output::DescribeImportOutput::imported_resource_id): <p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>
    ///   - [`imported_resource_name(Option<String>)`](crate::output::DescribeImportOutput::imported_resource_name): <p>The name of the imported resource.</p>
    ///   - [`merge_strategy(Option<MergeStrategy>)`](crate::output::DescribeImportOutput::merge_strategy): <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    ///   - [`import_status(Option<ImportStatus>)`](crate::output::DescribeImportOutput::import_status): <p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::DescribeImportOutput::failure_reasons): <p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeImportOutput::creation_date_time): <p>The date and time that the import was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeImportOutput::last_updated_date_time): <p>The date and time that the import was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeImportError>`](crate::error::DescribeImportError)
    pub fn describe_import(&self) -> fluent_builders::DescribeImport {
        fluent_builders::DescribeImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeIntent`](crate::client::fluent_builders::DescribeIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIntent::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::DescribeIntent::set_intent_id): <p>The identifier of the intent to describe.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIntent::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeIntent::set_bot_id): <p>The identifier of the bot associated with the intent.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeIntent::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeIntent::set_bot_version): <p>The version of the bot associated with the intent.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeIntent::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeIntent::set_locale_id): <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`DescribeIntentOutput`](crate::output::DescribeIntentOutput) with field(s):
    ///   - [`intent_id(Option<String>)`](crate::output::DescribeIntentOutput::intent_id): <p>The unique identifier assigned to the intent when it was created.</p>
    ///   - [`intent_name(Option<String>)`](crate::output::DescribeIntentOutput::intent_name): <p>The name specified for the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeIntentOutput::description): <p>The description of the intent.</p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::DescribeIntentOutput::parent_intent_signature): <p>The identifier of the built-in intent that this intent is derived from, if any.</p>
    ///   - [`sample_utterances(Option<Vec<SampleUtterance>>)`](crate::output::DescribeIntentOutput::sample_utterances): <p>User utterances that trigger this intent.</p>
    ///   - [`dialog_code_hook(Option<DialogCodeHookSettings>)`](crate::output::DescribeIntentOutput::dialog_code_hook): <p>The Lambda function called during each turn of a conversation with the intent.</p>
    ///   - [`fulfillment_code_hook(Option<FulfillmentCodeHookSettings>)`](crate::output::DescribeIntentOutput::fulfillment_code_hook): <p>The Lambda function called when the intent is complete and ready for fulfillment.</p>
    ///   - [`slot_priorities(Option<Vec<SlotPriority>>)`](crate::output::DescribeIntentOutput::slot_priorities): <p>The list that determines the priority that slots should be elicited from the user.</p>
    ///   - [`intent_confirmation_setting(Option<IntentConfirmationSetting>)`](crate::output::DescribeIntentOutput::intent_confirmation_setting): <p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>
    ///   - [`intent_closing_setting(Option<IntentClosingSetting>)`](crate::output::DescribeIntentOutput::intent_closing_setting): <p>The response that Amazon Lex sends to when the intent is closed.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::DescribeIntentOutput::input_contexts): <p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::DescribeIntentOutput::output_contexts): <p>A list of contexts that are activated when the intent is fulfilled.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::DescribeIntentOutput::kendra_configuration): <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeIntentOutput::bot_id): <p>The identifier of the bot associated with the intent.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeIntentOutput::bot_version): <p>The version of the bot associated with the intent.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeIntentOutput::locale_id): <p>The language and locale specified for the intent.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeIntentOutput::creation_date_time): <p>A timestamp of the date and time that the intent was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeIntentOutput::last_updated_date_time): <p>A timestamp of the date and time that the intent was last updated.</p>
    /// - On failure, responds with [`SdkError<DescribeIntentError>`](crate::error::DescribeIntentError)
    pub fn describe_intent(&self) -> fluent_builders::DescribeIntent {
        fluent_builders::DescribeIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourcePolicy`](crate::client::fluent_builders::DescribeResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DescribeResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    /// - On success, responds with [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::DescribeResourcePolicyOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`policy(Option<String>)`](crate::output::DescribeResourcePolicyOutput::policy): <p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::DescribeResourcePolicyOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<DescribeResourcePolicyError>`](crate::error::DescribeResourcePolicyError)
    pub fn describe_resource_policy(&self) -> fluent_builders::DescribeResourcePolicy {
        fluent_builders::DescribeResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSlot`](crate::client::fluent_builders::DescribeSlot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlot::slot_id) / [`set_slot_id(Option<String>)`](crate::client::fluent_builders::DescribeSlot::set_slot_id): <p>The unique identifier for the slot.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeSlot::set_bot_id): <p>The identifier of the bot associated with the slot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeSlot::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeSlot::set_bot_version): <p>The version of the bot associated with the slot.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlot::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeSlot::set_locale_id): <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlot::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::DescribeSlot::set_intent_id): <p>The identifier of the intent that contains the slot.</p>
    /// - On success, responds with [`DescribeSlotOutput`](crate::output::DescribeSlotOutput) with field(s):
    ///   - [`slot_id(Option<String>)`](crate::output::DescribeSlotOutput::slot_id): <p>The unique identifier generated for the slot.</p>
    ///   - [`slot_name(Option<String>)`](crate::output::DescribeSlotOutput::slot_name): <p>The name specified for the slot.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeSlotOutput::description): <p>The description specified for the slot.</p>
    ///   - [`slot_type_id(Option<String>)`](crate::output::DescribeSlotOutput::slot_type_id): <p>The identifier of the slot type that determines the values entered into the slot.</p>
    ///   - [`value_elicitation_setting(Option<SlotValueElicitationSetting>)`](crate::output::DescribeSlotOutput::value_elicitation_setting): <p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>
    ///   - [`obfuscation_setting(Option<ObfuscationSetting>)`](crate::output::DescribeSlotOutput::obfuscation_setting): <p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeSlotOutput::bot_id): <p>The identifier of the bot associated with the slot.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeSlotOutput::bot_version): <p>The version of the bot associated with the slot.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeSlotOutput::locale_id): <p>The language and locale specified for the slot.</p>
    ///   - [`intent_id(Option<String>)`](crate::output::DescribeSlotOutput::intent_id): <p>The identifier of the intent associated with the slot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeSlotOutput::creation_date_time): <p>A timestamp of the date and time that the slot was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeSlotOutput::last_updated_date_time): <p>A timestamp of the date and time that the slot was last updated.</p>
    ///   - [`multiple_values_setting(Option<MultipleValuesSetting>)`](crate::output::DescribeSlotOutput::multiple_values_setting): <p>Indicates whether the slot accepts multiple values in a single utterance.</p>  <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeSlotError>`](crate::error::DescribeSlotError)
    pub fn describe_slot(&self) -> fluent_builders::DescribeSlot {
        fluent_builders::DescribeSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSlotType`](crate::client::fluent_builders::DescribeSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_type_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlotType::slot_type_id) / [`set_slot_type_id(Option<String>)`](crate::client::fluent_builders::DescribeSlotType::set_slot_type_id): <p>The identifier of the slot type.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlotType::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::DescribeSlotType::set_bot_id): <p>The identifier of the bot associated with the slot type.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::DescribeSlotType::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::DescribeSlotType::set_bot_version): <p>The version of the bot associated with the slot type.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSlotType::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::DescribeSlotType::set_locale_id): <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`DescribeSlotTypeOutput`](crate::output::DescribeSlotTypeOutput) with field(s):
    ///   - [`slot_type_id(Option<String>)`](crate::output::DescribeSlotTypeOutput::slot_type_id): <p>The unique identifier for the slot type.</p>
    ///   - [`slot_type_name(Option<String>)`](crate::output::DescribeSlotTypeOutput::slot_type_name): <p>The name specified for the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeSlotTypeOutput::description): <p>The description specified for the slot type.</p>
    ///   - [`slot_type_values(Option<Vec<SlotTypeValue>>)`](crate::output::DescribeSlotTypeOutput::slot_type_values): <p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>
    ///   - [`value_selection_setting(Option<SlotValueSelectionSetting>)`](crate::output::DescribeSlotTypeOutput::value_selection_setting): <p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::DescribeSlotTypeOutput::parent_slot_type_signature): <p>The built in slot type used as a parent to this slot type.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::DescribeSlotTypeOutput::bot_id): <p>The identifier of the bot associated with the slot type.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::DescribeSlotTypeOutput::bot_version): <p>The version of the bot associated with the slot type.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::DescribeSlotTypeOutput::locale_id): <p>The language and locale specified for the slot type.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::DescribeSlotTypeOutput::creation_date_time): <p>A timestamp of the date and time that the slot type was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::DescribeSlotTypeOutput::last_updated_date_time): <p>A timestamp of the date and time that the slot type was last updated.</p>
    ///   - [`external_source_setting(Option<ExternalSourceSetting>)`](crate::output::DescribeSlotTypeOutput::external_source_setting): <p>Provides information about the external source of the slot type's definition.</p>
    /// - On failure, responds with [`SdkError<DescribeSlotTypeError>`](crate::error::DescribeSlotTypeError)
    pub fn describe_slot_type(&self) -> fluent_builders::DescribeSlotType {
        fluent_builders::DescribeSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAggregatedUtterances`](crate::client::fluent_builders::ListAggregatedUtterances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAggregatedUtterances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_bot_id): <p>The unique identifier of the bot associated with this request.</p>
    ///   - [`bot_alias_id(impl Into<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::bot_alias_id) / [`set_bot_alias_id(Option<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_bot_alias_id): <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_bot_version): <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_locale_id): <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`aggregation_duration(UtteranceAggregationDuration)`](crate::client::fluent_builders::ListAggregatedUtterances::aggregation_duration) / [`set_aggregation_duration(Option<UtteranceAggregationDuration>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_aggregation_duration): <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
    ///   - [`sort_by(AggregatedUtterancesSortBy)`](crate::client::fluent_builders::ListAggregatedUtterances::sort_by) / [`set_sort_by(Option<AggregatedUtterancesSortBy>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_sort_by): <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
    ///   - [`filters(Vec<AggregatedUtterancesFilter>)`](crate::client::fluent_builders::ListAggregatedUtterances::filters) / [`set_filters(Option<Vec<AggregatedUtterancesFilter>>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_filters): <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAggregatedUtterances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_max_results): <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAggregatedUtterances::set_next_token): <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListAggregatedUtterancesOutput`](crate::output::ListAggregatedUtterancesOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListAggregatedUtterancesOutput::bot_id): <p>The identifier of the bot that contains the utterances.</p>
    ///   - [`bot_alias_id(Option<String>)`](crate::output::ListAggregatedUtterancesOutput::bot_alias_id): <p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn't returned.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListAggregatedUtterancesOutput::bot_version): <p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn't returned.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListAggregatedUtterancesOutput::locale_id): <p>The identifier of the language and locale that the utterances are in.</p>
    ///   - [`aggregation_duration(Option<UtteranceAggregationDuration>)`](crate::output::ListAggregatedUtterancesOutput::aggregation_duration): <p>The time period used to aggregate the utterance data.</p>
    ///   - [`aggregation_window_start_time(Option<DateTime>)`](crate::output::ListAggregatedUtterancesOutput::aggregation_window_start_time): <p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>
    ///   - [`aggregation_window_end_time(Option<DateTime>)`](crate::output::ListAggregatedUtterancesOutput::aggregation_window_end_time): <p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>
    ///   - [`aggregation_last_refreshed_date_time(Option<DateTime>)`](crate::output::ListAggregatedUtterancesOutput::aggregation_last_refreshed_date_time): <p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p>  <ul>   <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li>   <li> <p> <b>Days</b> - every 6 hours</p> </li>   <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li>  </ul>
    ///   - [`aggregated_utterances_summaries(Option<Vec<AggregatedUtterancesSummary>>)`](crate::output::ListAggregatedUtterancesOutput::aggregated_utterances_summaries): <p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAggregatedUtterancesOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListAggregatedUtterancesError>`](crate::error::ListAggregatedUtterancesError)
    pub fn list_aggregated_utterances(&self) -> fluent_builders::ListAggregatedUtterances {
        fluent_builders::ListAggregatedUtterances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBotAliases`](crate::client::fluent_builders::ListBotAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBotAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListBotAliases::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListBotAliases::set_bot_id): <p>The identifier of the bot to list aliases for.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBotAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBotAliases::set_max_results): <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBotAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBotAliases::set_next_token): <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListBotAliasesOutput`](crate::output::ListBotAliasesOutput) with field(s):
    ///   - [`bot_alias_summaries(Option<Vec<BotAliasSummary>>)`](crate::output::ListBotAliasesOutput::bot_alias_summaries): <p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotAliasesOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::ListBotAliasesOutput::bot_id): <p>The identifier of the bot associated with the aliases.</p>
    /// - On failure, responds with [`SdkError<ListBotAliasesError>`](crate::error::ListBotAliasesError)
    pub fn list_bot_aliases(&self) -> fluent_builders::ListBotAliases {
        fluent_builders::ListBotAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBotLocales`](crate::client::fluent_builders::ListBotLocales) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBotLocales::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListBotLocales::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListBotLocales::set_bot_id): <p>The identifier of the bot to list locales for.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListBotLocales::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListBotLocales::set_bot_version): <p>The version of the bot to list locales for.</p>
    ///   - [`sort_by(BotLocaleSortBy)`](crate::client::fluent_builders::ListBotLocales::sort_by) / [`set_sort_by(Option<BotLocaleSortBy>)`](crate::client::fluent_builders::ListBotLocales::set_sort_by): <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
    ///   - [`filters(Vec<BotLocaleFilter>)`](crate::client::fluent_builders::ListBotLocales::filters) / [`set_filters(Option<Vec<BotLocaleFilter>>)`](crate::client::fluent_builders::ListBotLocales::set_filters): <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBotLocales::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBotLocales::set_max_results): <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBotLocales::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBotLocales::set_next_token): <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
    /// - On success, responds with [`ListBotLocalesOutput`](crate::output::ListBotLocalesOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListBotLocalesOutput::bot_id): <p>The identifier of the bot to list locales for.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListBotLocalesOutput::bot_version): <p>The version of the bot.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotLocalesOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>
    ///   - [`bot_locale_summaries(Option<Vec<BotLocaleSummary>>)`](crate::output::ListBotLocalesOutput::bot_locale_summaries): <p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListBotLocalesError>`](crate::error::ListBotLocalesError)
    pub fn list_bot_locales(&self) -> fluent_builders::ListBotLocales {
        fluent_builders::ListBotLocales::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBotRecommendations`](crate::client::fluent_builders::ListBotRecommendations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBotRecommendations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListBotRecommendations::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListBotRecommendations::set_bot_id): <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListBotRecommendations::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListBotRecommendations::set_bot_version): <p>The version of the bot that contains the bot recommendation list.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListBotRecommendations::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListBotRecommendations::set_locale_id): <p>The identifier of the language and locale of the bot recommendation list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBotRecommendations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBotRecommendations::set_max_results): <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBotRecommendations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBotRecommendations::set_next_token): <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    /// - On success, responds with [`ListBotRecommendationsOutput`](crate::output::ListBotRecommendationsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListBotRecommendationsOutput::bot_id): <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListBotRecommendationsOutput::bot_version): <p>The version of the bot that contains the bot recommendation list.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListBotRecommendationsOutput::locale_id): <p>The identifier of the language and locale of the bot recommendation list.</p>
    ///   - [`bot_recommendation_summaries(Option<Vec<BotRecommendationSummary>>)`](crate::output::ListBotRecommendationsOutput::bot_recommendation_summaries): <p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotRecommendationsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>
    /// - On failure, responds with [`SdkError<ListBotRecommendationsError>`](crate::error::ListBotRecommendationsError)
    pub fn list_bot_recommendations(&self) -> fluent_builders::ListBotRecommendations {
        fluent_builders::ListBotRecommendations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBots`](crate::client::fluent_builders::ListBots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_by(BotSortBy)`](crate::client::fluent_builders::ListBots::sort_by) / [`set_sort_by(Option<BotSortBy>)`](crate::client::fluent_builders::ListBots::set_sort_by): <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
    ///   - [`filters(Vec<BotFilter>)`](crate::client::fluent_builders::ListBots::filters) / [`set_filters(Option<Vec<BotFilter>>)`](crate::client::fluent_builders::ListBots::set_filters): <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBots::set_max_results): <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBots::set_next_token): <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>  <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    /// - On success, responds with [`ListBotsOutput`](crate::output::ListBotsOutput) with field(s):
    ///   - [`bot_summaries(Option<Vec<BotSummary>>)`](crate::output::ListBotsOutput::bot_summaries): <p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListBotsError>`](crate::error::ListBotsError)
    pub fn list_bots(&self) -> fluent_builders::ListBots {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBotVersions`](crate::client::fluent_builders::ListBotVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBotVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListBotVersions::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListBotVersions::set_bot_id): <p>The identifier of the bot to list versions for.</p>
    ///   - [`sort_by(BotVersionSortBy)`](crate::client::fluent_builders::ListBotVersions::sort_by) / [`set_sort_by(Option<BotVersionSortBy>)`](crate::client::fluent_builders::ListBotVersions::set_sort_by): <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBotVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBotVersions::set_max_results): <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBotVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBotVersions::set_next_token): <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListBotVersionsOutput`](crate::output::ListBotVersionsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListBotVersionsOutput::bot_id): <p>The identifier of the bot to list versions for.</p>
    ///   - [`bot_version_summaries(Option<Vec<BotVersionSummary>>)`](crate::output::ListBotVersionsOutput::bot_version_summaries): <p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotVersionsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListBotVersionsError>`](crate::error::ListBotVersionsError)
    pub fn list_bot_versions(&self) -> fluent_builders::ListBotVersions {
        fluent_builders::ListBotVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuiltInIntents`](crate::client::fluent_builders::ListBuiltInIntents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuiltInIntents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListBuiltInIntents::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListBuiltInIntents::set_locale_id): <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`sort_by(BuiltInIntentSortBy)`](crate::client::fluent_builders::ListBuiltInIntents::sort_by) / [`set_sort_by(Option<BuiltInIntentSortBy>)`](crate::client::fluent_builders::ListBuiltInIntents::set_sort_by): <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBuiltInIntents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBuiltInIntents::set_max_results): <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuiltInIntents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuiltInIntents::set_next_token): <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListBuiltInIntentsOutput`](crate::output::ListBuiltInIntentsOutput) with field(s):
    ///   - [`built_in_intent_summaries(Option<Vec<BuiltInIntentSummary>>)`](crate::output::ListBuiltInIntentsOutput::built_in_intent_summaries): <p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuiltInIntentsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListBuiltInIntentsOutput::locale_id): <p>The language and locale of the intents in the list.</p>
    /// - On failure, responds with [`SdkError<ListBuiltInIntentsError>`](crate::error::ListBuiltInIntentsError)
    pub fn list_built_in_intents(&self) -> fluent_builders::ListBuiltInIntents {
        fluent_builders::ListBuiltInIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuiltInSlotTypes`](crate::client::fluent_builders::ListBuiltInSlotTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuiltInSlotTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::set_locale_id): <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`sort_by(BuiltInSlotTypeSortBy)`](crate::client::fluent_builders::ListBuiltInSlotTypes::sort_by) / [`set_sort_by(Option<BuiltInSlotTypeSortBy>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::set_sort_by): <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBuiltInSlotTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::set_max_results): <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuiltInSlotTypes::set_next_token): <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListBuiltInSlotTypesOutput`](crate::output::ListBuiltInSlotTypesOutput) with field(s):
    ///   - [`built_in_slot_type_summaries(Option<Vec<BuiltInSlotTypeSummary>>)`](crate::output::ListBuiltInSlotTypesOutput::built_in_slot_type_summaries): <p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuiltInSlotTypesOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListBuiltInSlotTypesOutput::locale_id): <p>The language and locale of the slot types in the list.</p>
    /// - On failure, responds with [`SdkError<ListBuiltInSlotTypesError>`](crate::error::ListBuiltInSlotTypesError)
    pub fn list_built_in_slot_types(&self) -> fluent_builders::ListBuiltInSlotTypes {
        fluent_builders::ListBuiltInSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExports`](crate::client::fluent_builders::ListExports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListExports::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListExports::set_bot_id): <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListExports::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListExports::set_bot_version): <p>The version of the bot to list exports for. </p>
    ///   - [`sort_by(ExportSortBy)`](crate::client::fluent_builders::ListExports::sort_by) / [`set_sort_by(Option<ExportSortBy>)`](crate::client::fluent_builders::ListExports::set_sort_by): <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    ///   - [`filters(Vec<ExportFilter>)`](crate::client::fluent_builders::ListExports::filters) / [`set_filters(Option<Vec<ExportFilter>>)`](crate::client::fluent_builders::ListExports::set_filters): <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExports::set_max_results): <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExports::set_next_token): <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>  <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListExports::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListExports::set_locale_id): <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
    /// - On success, responds with [`ListExportsOutput`](crate::output::ListExportsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListExportsOutput::bot_id): <p>The unique identifier assigned to the bot by Amazon Lex.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListExportsOutput::bot_version): <p>The version of the bot that was exported.</p>
    ///   - [`export_summaries(Option<Vec<ExportSummary>>)`](crate::output::ListExportsOutput::export_summaries): <p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExportsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListExportsOutput::locale_id): <p>The locale specified in the request.</p>
    /// - On failure, responds with [`SdkError<ListExportsError>`](crate::error::ListExportsError)
    pub fn list_exports(&self) -> fluent_builders::ListExports {
        fluent_builders::ListExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImports`](crate::client::fluent_builders::ListImports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListImports::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListImports::set_bot_id): <p>The unique identifier that Amazon Lex assigned to the bot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListImports::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListImports::set_bot_version): <p>The version of the bot to list imports for.</p>
    ///   - [`sort_by(ImportSortBy)`](crate::client::fluent_builders::ListImports::sort_by) / [`set_sort_by(Option<ImportSortBy>)`](crate::client::fluent_builders::ListImports::set_sort_by): <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
    ///   - [`filters(Vec<ImportFilter>)`](crate::client::fluent_builders::ListImports::filters) / [`set_filters(Option<Vec<ImportFilter>>)`](crate::client::fluent_builders::ListImports::set_filters): <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImports::set_max_results): <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImports::set_next_token): <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>  <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListImports::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListImports::set_locale_id): <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
    /// - On success, responds with [`ListImportsOutput`](crate::output::ListImportsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListImportsOutput::bot_id): <p>The unique identifier assigned by Amazon Lex to the bot.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListImportsOutput::bot_version): <p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>
    ///   - [`import_summaries(Option<Vec<ImportSummary>>)`](crate::output::ListImportsOutput::import_summaries): <p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImportsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListImportsOutput::locale_id): <p>The locale specified in the request.</p>
    /// - On failure, responds with [`SdkError<ListImportsError>`](crate::error::ListImportsError)
    pub fn list_imports(&self) -> fluent_builders::ListImports {
        fluent_builders::ListImports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIntents`](crate::client::fluent_builders::ListIntents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIntents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListIntents::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListIntents::set_bot_id): <p>The unique identifier of the bot that contains the intent.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListIntents::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListIntents::set_bot_version): <p>The version of the bot that contains the intent.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListIntents::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListIntents::set_locale_id): <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`sort_by(IntentSortBy)`](crate::client::fluent_builders::ListIntents::sort_by) / [`set_sort_by(Option<IntentSortBy>)`](crate::client::fluent_builders::ListIntents::set_sort_by): <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
    ///   - [`filters(Vec<IntentFilter>)`](crate::client::fluent_builders::ListIntents::filters) / [`set_filters(Option<Vec<IntentFilter>>)`](crate::client::fluent_builders::ListIntents::set_filters): <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIntents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIntents::set_max_results): <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIntents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIntents::set_next_token): <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>  <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
    /// - On success, responds with [`ListIntentsOutput`](crate::output::ListIntentsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListIntentsOutput::bot_id): <p>The identifier of the bot that contains the intent.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListIntentsOutput::bot_version): <p>The version of the bot that contains the intent.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListIntentsOutput::locale_id): <p>The language and locale of the intents in the list.</p>
    ///   - [`intent_summaries(Option<Vec<IntentSummary>>)`](crate::output::ListIntentsOutput::intent_summaries): <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIntentsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListIntentsError>`](crate::error::ListIntentsError)
    pub fn list_intents(&self) -> fluent_builders::ListIntents {
        fluent_builders::ListIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRecommendedIntents`](crate::client::fluent_builders::ListRecommendedIntents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRecommendedIntents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListRecommendedIntents::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListRecommendedIntents::set_bot_id): <p>The unique identifier of the bot associated with the recommended intents.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListRecommendedIntents::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListRecommendedIntents::set_bot_version): <p>The version of the bot that contains the recommended intents.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListRecommendedIntents::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListRecommendedIntents::set_locale_id): <p>The identifier of the language and locale of the recommended intents.</p>
    ///   - [`bot_recommendation_id(impl Into<String>)`](crate::client::fluent_builders::ListRecommendedIntents::bot_recommendation_id) / [`set_bot_recommendation_id(Option<String>)`](crate::client::fluent_builders::ListRecommendedIntents::set_bot_recommendation_id): <p>The identifier of the bot recommendation that contains the recommended intents.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRecommendedIntents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRecommendedIntents::set_next_token): <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRecommendedIntents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRecommendedIntents::set_max_results): <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    /// - On success, responds with [`ListRecommendedIntentsOutput`](crate::output::ListRecommendedIntentsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListRecommendedIntentsOutput::bot_id): <p>The unique identifier of the bot associated with the recommended intent.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListRecommendedIntentsOutput::bot_version): <p>The version of the bot that contains the intent.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListRecommendedIntentsOutput::locale_id): <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`bot_recommendation_id(Option<String>)`](crate::output::ListRecommendedIntentsOutput::bot_recommendation_id): <p>The identifier of the bot recommendation that contains the recommended intent.</p>
    ///   - [`summary_list(Option<Vec<RecommendedIntentSummary>>)`](crate::output::ListRecommendedIntentsOutput::summary_list): <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRecommendedIntentsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListRecommendedIntentsError>`](crate::error::ListRecommendedIntentsError)
    pub fn list_recommended_intents(&self) -> fluent_builders::ListRecommendedIntents {
        fluent_builders::ListRecommendedIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSlots`](crate::client::fluent_builders::ListSlots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSlots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListSlots::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListSlots::set_bot_id): <p>The identifier of the bot that contains the slot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListSlots::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListSlots::set_bot_version): <p>The version of the bot that contains the slot.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListSlots::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListSlots::set_locale_id): <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::ListSlots::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::ListSlots::set_intent_id): <p>The unique identifier of the intent that contains the slot.</p>
    ///   - [`sort_by(SlotSortBy)`](crate::client::fluent_builders::ListSlots::sort_by) / [`set_sort_by(Option<SlotSortBy>)`](crate::client::fluent_builders::ListSlots::set_sort_by): <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
    ///   - [`filters(Vec<SlotFilter>)`](crate::client::fluent_builders::ListSlots::filters) / [`set_filters(Option<Vec<SlotFilter>>)`](crate::client::fluent_builders::ListSlots::set_filters): <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSlots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSlots::set_max_results): <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSlots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSlots::set_next_token): <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListSlotsOutput`](crate::output::ListSlotsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListSlotsOutput::bot_id): <p>The identifier of the bot that contains the slots.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListSlotsOutput::bot_version): <p>The version of the bot that contains the slots.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListSlotsOutput::locale_id): <p>The language and locale of the slots in the list.</p>
    ///   - [`intent_id(Option<String>)`](crate::output::ListSlotsOutput::intent_id): <p>The identifier of the intent that contains the slots.</p>
    ///   - [`slot_summaries(Option<Vec<SlotSummary>>)`](crate::output::ListSlotsOutput::slot_summaries): <p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSlotsOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListSlotsError>`](crate::error::ListSlotsError)
    pub fn list_slots(&self) -> fluent_builders::ListSlots {
        fluent_builders::ListSlots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSlotTypes`](crate::client::fluent_builders::ListSlotTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSlotTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::ListSlotTypes::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::ListSlotTypes::set_bot_id): <p>The unique identifier of the bot that contains the slot types.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::ListSlotTypes::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::ListSlotTypes::set_bot_version): <p>The version of the bot that contains the slot type.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::ListSlotTypes::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::ListSlotTypes::set_locale_id): <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`sort_by(SlotTypeSortBy)`](crate::client::fluent_builders::ListSlotTypes::sort_by) / [`set_sort_by(Option<SlotTypeSortBy>)`](crate::client::fluent_builders::ListSlotTypes::set_sort_by): <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
    ///   - [`filters(Vec<SlotTypeFilter>)`](crate::client::fluent_builders::ListSlotTypes::filters) / [`set_filters(Option<Vec<SlotTypeFilter>>)`](crate::client::fluent_builders::ListSlotTypes::set_filters): <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSlotTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSlotTypes::set_max_results): <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSlotTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSlotTypes::set_next_token): <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
    /// - On success, responds with [`ListSlotTypesOutput`](crate::output::ListSlotTypesOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::ListSlotTypesOutput::bot_id): <p>The identifier of the bot that contains the slot types.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::ListSlotTypesOutput::bot_version): <p>The version of the bot that contains the slot types.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::ListSlotTypesOutput::locale_id): <p>The language and local of the slot types in the list.</p>
    ///   - [`slot_type_summaries(Option<Vec<SlotTypeSummary>>)`](crate::output::ListSlotTypesOutput::slot_type_summaries): <p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSlotTypesOutput::next_token): <p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListSlotTypesError>`](crate::error::ListSlotTypesError)
    pub fn list_slot_types(&self) -> fluent_builders::ListSlotTypes {
        fluent_builders::ListSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchAssociatedTranscripts`](crate::client::fluent_builders::SearchAssociatedTranscripts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_bot_id): <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_bot_version): <p>The version of the bot containing the transcripts that you are searching.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_locale_id): <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`bot_recommendation_id(impl Into<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::bot_recommendation_id) / [`set_bot_recommendation_id(Option<String>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_bot_recommendation_id): <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    ///   - [`search_order(SearchOrder)`](crate::client::fluent_builders::SearchAssociatedTranscripts::search_order) / [`set_search_order(Option<SearchOrder>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_search_order): <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
    ///   - [`filters(Vec<AssociatedTranscriptFilter>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::filters) / [`set_filters(Option<Vec<AssociatedTranscriptFilter>>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_filters): <p>A list of filter objects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchAssociatedTranscripts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_max_results): <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
    ///   - [`next_index(i32)`](crate::client::fluent_builders::SearchAssociatedTranscripts::next_index) / [`set_next_index(Option<i32>)`](crate::client::fluent_builders::SearchAssociatedTranscripts::set_next_index): <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
    /// - On success, responds with [`SearchAssociatedTranscriptsOutput`](crate::output::SearchAssociatedTranscriptsOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::SearchAssociatedTranscriptsOutput::bot_id): <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::SearchAssociatedTranscriptsOutput::bot_version): <p>The version of the bot containing the transcripts that you are searching.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::SearchAssociatedTranscriptsOutput::locale_id): <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`bot_recommendation_id(Option<String>)`](crate::output::SearchAssociatedTranscriptsOutput::bot_recommendation_id): <p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    ///   - [`next_index(Option<i32>)`](crate::output::SearchAssociatedTranscriptsOutput::next_index): <p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>
    ///   - [`associated_transcripts(Option<Vec<AssociatedTranscript>>)`](crate::output::SearchAssociatedTranscriptsOutput::associated_transcripts): <p>The object that contains the associated transcript that meet the criteria you specified.</p>
    ///   - [`total_results(Option<i32>)`](crate::output::SearchAssociatedTranscriptsOutput::total_results): <p>The total number of transcripts returned by the search.</p>
    /// - On failure, responds with [`SdkError<SearchAssociatedTranscriptsError>`](crate::error::SearchAssociatedTranscriptsError)
    pub fn search_associated_transcripts(&self) -> fluent_builders::SearchAssociatedTranscripts {
        fluent_builders::SearchAssociatedTranscripts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartBotRecommendation`](crate::client::fluent_builders::StartBotRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::StartBotRecommendation::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::StartBotRecommendation::set_bot_id): <p>The unique identifier of the bot containing the bot recommendation.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::StartBotRecommendation::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::StartBotRecommendation::set_bot_version): <p>The version of the bot containing the bot recommendation.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::StartBotRecommendation::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::StartBotRecommendation::set_locale_id): <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`transcript_source_setting(TranscriptSourceSetting)`](crate::client::fluent_builders::StartBotRecommendation::transcript_source_setting) / [`set_transcript_source_setting(Option<TranscriptSourceSetting>)`](crate::client::fluent_builders::StartBotRecommendation::set_transcript_source_setting): <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    ///   - [`encryption_setting(EncryptionSetting)`](crate::client::fluent_builders::StartBotRecommendation::encryption_setting) / [`set_encryption_setting(Option<EncryptionSetting>)`](crate::client::fluent_builders::StartBotRecommendation::set_encryption_setting): <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    /// - On success, responds with [`StartBotRecommendationOutput`](crate::output::StartBotRecommendationOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::StartBotRecommendationOutput::bot_id): <p>The unique identifier of the bot containing the bot recommendation.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::StartBotRecommendationOutput::bot_version): <p>The version of the bot containing the bot recommendation.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::StartBotRecommendationOutput::locale_id): <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`bot_recommendation_status(Option<BotRecommendationStatus>)`](crate::output::StartBotRecommendationOutput::bot_recommendation_status): <p>The status of the bot recommendation.</p>  <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    ///   - [`bot_recommendation_id(Option<String>)`](crate::output::StartBotRecommendationOutput::bot_recommendation_id): <p>The identifier of the bot recommendation that you have created.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::StartBotRecommendationOutput::creation_date_time): <p>A timestamp of the date and time that the bot recommendation was created.</p>
    ///   - [`transcript_source_setting(Option<TranscriptSourceSetting>)`](crate::output::StartBotRecommendationOutput::transcript_source_setting): <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    ///   - [`encryption_setting(Option<EncryptionSetting>)`](crate::output::StartBotRecommendationOutput::encryption_setting): <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    /// - On failure, responds with [`SdkError<StartBotRecommendationError>`](crate::error::StartBotRecommendationError)
    pub fn start_bot_recommendation(&self) -> fluent_builders::StartBotRecommendation {
        fluent_builders::StartBotRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImport`](crate::client::fluent_builders::StartImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_id(impl Into<String>)`](crate::client::fluent_builders::StartImport::import_id) / [`set_import_id(Option<String>)`](crate::client::fluent_builders::StartImport::set_import_id): <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
    ///   - [`resource_specification(ImportResourceSpecification)`](crate::client::fluent_builders::StartImport::resource_specification) / [`set_resource_specification(Option<ImportResourceSpecification>)`](crate::client::fluent_builders::StartImport::set_resource_specification): <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
    ///   - [`merge_strategy(MergeStrategy)`](crate::client::fluent_builders::StartImport::merge_strategy) / [`set_merge_strategy(Option<MergeStrategy>)`](crate::client::fluent_builders::StartImport::set_merge_strategy): <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    ///   - [`file_password(impl Into<String>)`](crate::client::fluent_builders::StartImport::file_password) / [`set_file_password(Option<String>)`](crate::client::fluent_builders::StartImport::set_file_password): <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
    /// - On success, responds with [`StartImportOutput`](crate::output::StartImportOutput) with field(s):
    ///   - [`import_id(Option<String>)`](crate::output::StartImportOutput::import_id): <p>A unique identifier for the import.</p>
    ///   - [`resource_specification(Option<ImportResourceSpecification>)`](crate::output::StartImportOutput::resource_specification): <p>The parameters used when importing the resource.</p>
    ///   - [`merge_strategy(Option<MergeStrategy>)`](crate::output::StartImportOutput::merge_strategy): <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    ///   - [`import_status(Option<ImportStatus>)`](crate::output::StartImportOutput::import_status): <p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::StartImportOutput::creation_date_time): <p>The date and time that the import request was created.</p>
    /// - On failure, responds with [`SdkError<StartImportError>`](crate::error::StartImportError)
    pub fn start_import(&self) -> fluent_builders::StartImport {
        fluent_builders::StartImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBot`](crate::client::fluent_builders::UpdateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_bot_id): <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_bot_name): <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_description): <p>A description of the bot.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateBot::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateBot::set_role_arn): <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
    ///   - [`data_privacy(DataPrivacy)`](crate::client::fluent_builders::UpdateBot::data_privacy) / [`set_data_privacy(Option<DataPrivacy>)`](crate::client::fluent_builders::UpdateBot::set_data_privacy): <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
    ///   - [`idle_session_ttl_in_seconds(i32)`](crate::client::fluent_builders::UpdateBot::idle_session_ttl_in_seconds) / [`set_idle_session_ttl_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateBot::set_idle_session_ttl_in_seconds): <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>  <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>  <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
    /// - On success, responds with [`UpdateBotOutput`](crate::output::UpdateBotOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateBotOutput::bot_id): <p>The unique identifier of the bot that was updated.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::UpdateBotOutput::bot_name): <p>The name of the bot after the update.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateBotOutput::description): <p>The description of the bot after the update.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::UpdateBotOutput::role_arn): <p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>
    ///   - [`data_privacy(Option<DataPrivacy>)`](crate::output::UpdateBotOutput::data_privacy): <p>The data privacy settings for the bot after the update.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::UpdateBotOutput::idle_session_ttl_in_seconds): <p>The session timeout, in seconds, for the bot after the update.</p>
    ///   - [`bot_status(Option<BotStatus>)`](crate::output::UpdateBotOutput::bot_status): <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateBotOutput::creation_date_time): <p>A timestamp of the date and time that the bot was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateBotOutput::last_updated_date_time): <p>A timestamp of the date and time that the bot was last updated.</p>
    /// - On failure, responds with [`SdkError<UpdateBotError>`](crate::error::UpdateBotError)
    pub fn update_bot(&self) -> fluent_builders::UpdateBot {
        fluent_builders::UpdateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBotAlias`](crate::client::fluent_builders::UpdateBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_alias_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotAlias::bot_alias_id) / [`set_bot_alias_id(Option<String>)`](crate::client::fluent_builders::UpdateBotAlias::set_bot_alias_id): <p>The unique identifier of the bot alias.</p>
    ///   - [`bot_alias_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBotAlias::bot_alias_name) / [`set_bot_alias_name(Option<String>)`](crate::client::fluent_builders::UpdateBotAlias::set_bot_alias_name): <p>The new name to assign to the bot alias.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateBotAlias::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateBotAlias::set_description): <p>The new description to assign to the bot alias.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateBotAlias::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateBotAlias::set_bot_version): <p>The new bot version to assign to the bot alias.</p>
    ///   - [`bot_alias_locale_settings(HashMap<String, BotAliasLocaleSettings>)`](crate::client::fluent_builders::UpdateBotAlias::bot_alias_locale_settings) / [`set_bot_alias_locale_settings(Option<HashMap<String, BotAliasLocaleSettings>>)`](crate::client::fluent_builders::UpdateBotAlias::set_bot_alias_locale_settings): <p>The new Lambda functions to use in each locale for the bot alias.</p>
    ///   - [`conversation_log_settings(ConversationLogSettings)`](crate::client::fluent_builders::UpdateBotAlias::conversation_log_settings) / [`set_conversation_log_settings(Option<ConversationLogSettings>)`](crate::client::fluent_builders::UpdateBotAlias::set_conversation_log_settings): <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    ///   - [`sentiment_analysis_settings(SentimentAnalysisSettings)`](crate::client::fluent_builders::UpdateBotAlias::sentiment_analysis_settings) / [`set_sentiment_analysis_settings(Option<SentimentAnalysisSettings>)`](crate::client::fluent_builders::UpdateBotAlias::set_sentiment_analysis_settings): <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotAlias::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateBotAlias::set_bot_id): <p>The identifier of the bot with the updated alias.</p>
    /// - On success, responds with [`UpdateBotAliasOutput`](crate::output::UpdateBotAliasOutput) with field(s):
    ///   - [`bot_alias_id(Option<String>)`](crate::output::UpdateBotAliasOutput::bot_alias_id): <p>The identifier of the updated bot alias.</p>
    ///   - [`bot_alias_name(Option<String>)`](crate::output::UpdateBotAliasOutput::bot_alias_name): <p>The updated name of the bot alias.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateBotAliasOutput::description): <p>The updated description of the bot alias.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateBotAliasOutput::bot_version): <p>The updated version of the bot that the alias points to.</p>
    ///   - [`bot_alias_locale_settings(Option<HashMap<String, BotAliasLocaleSettings>>)`](crate::output::UpdateBotAliasOutput::bot_alias_locale_settings): <p>The updated Lambda functions to use in each locale for the bot alias.</p>
    ///   - [`conversation_log_settings(Option<ConversationLogSettings>)`](crate::output::UpdateBotAliasOutput::conversation_log_settings): <p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    ///   - [`sentiment_analysis_settings(Option<SentimentAnalysisSettings>)`](crate::output::UpdateBotAliasOutput::sentiment_analysis_settings): <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    ///   - [`bot_alias_status(Option<BotAliasStatus>)`](crate::output::UpdateBotAliasOutput::bot_alias_status): <p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateBotAliasOutput::bot_id): <p>The identifier of the bot with the updated alias.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateBotAliasOutput::creation_date_time): <p>A timestamp of the date and time that the bot was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateBotAliasOutput::last_updated_date_time): <p>A timestamp of the date and time that the bot was last updated.</p>
    /// - On failure, responds with [`SdkError<UpdateBotAliasError>`](crate::error::UpdateBotAliasError)
    pub fn update_bot_alias(&self) -> fluent_builders::UpdateBotAlias {
        fluent_builders::UpdateBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBotLocale`](crate::client::fluent_builders::UpdateBotLocale) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotLocale::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateBotLocale::set_bot_id): <p>The unique identifier of the bot that contains the locale.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateBotLocale::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateBotLocale::set_bot_version): <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotLocale::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::UpdateBotLocale::set_locale_id): <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateBotLocale::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateBotLocale::set_description): <p>The new description of the locale.</p>
    ///   - [`nlu_intent_confidence_threshold(f64)`](crate::client::fluent_builders::UpdateBotLocale::nlu_intent_confidence_threshold) / [`set_nlu_intent_confidence_threshold(Option<f64>)`](crate::client::fluent_builders::UpdateBotLocale::set_nlu_intent_confidence_threshold): <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    ///   - [`voice_settings(VoiceSettings)`](crate::client::fluent_builders::UpdateBotLocale::voice_settings) / [`set_voice_settings(Option<VoiceSettings>)`](crate::client::fluent_builders::UpdateBotLocale::set_voice_settings): <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
    /// - On success, responds with [`UpdateBotLocaleOutput`](crate::output::UpdateBotLocaleOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateBotLocaleOutput::bot_id): <p>The identifier of the bot that contains the updated locale.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateBotLocaleOutput::bot_version): <p>The version of the bot that contains the updated locale.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::UpdateBotLocaleOutput::locale_id): <p>The language and locale of the updated bot locale.</p>
    ///   - [`locale_name(Option<String>)`](crate::output::UpdateBotLocaleOutput::locale_name): <p>The updated locale name for the locale.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateBotLocaleOutput::description): <p>The updated description of the locale.</p>
    ///   - [`nlu_intent_confidence_threshold(Option<f64>)`](crate::output::UpdateBotLocaleOutput::nlu_intent_confidence_threshold): <p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    ///   - [`voice_settings(Option<VoiceSettings>)`](crate::output::UpdateBotLocaleOutput::voice_settings): <p>The updated Amazon Polly voice to use for voice interaction with the user.</p>
    ///   - [`bot_locale_status(Option<BotLocaleStatus>)`](crate::output::UpdateBotLocaleOutput::bot_locale_status): <p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>
    ///   - [`failure_reasons(Option<Vec<String>>)`](crate::output::UpdateBotLocaleOutput::failure_reasons): <p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateBotLocaleOutput::creation_date_time): <p>A timestamp of the date and time that the locale was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateBotLocaleOutput::last_updated_date_time): <p>A timestamp of the date and time that the locale was last updated.</p>
    ///   - [`recommended_actions(Option<Vec<String>>)`](crate::output::UpdateBotLocaleOutput::recommended_actions): <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    /// - On failure, responds with [`SdkError<UpdateBotLocaleError>`](crate::error::UpdateBotLocaleError)
    pub fn update_bot_locale(&self) -> fluent_builders::UpdateBotLocale {
        fluent_builders::UpdateBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBotRecommendation`](crate::client::fluent_builders::UpdateBotRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::set_bot_id): <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::set_bot_version): <p>The version of the bot containing the bot recommendation to be updated.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::set_locale_id): <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`bot_recommendation_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::bot_recommendation_id) / [`set_bot_recommendation_id(Option<String>)`](crate::client::fluent_builders::UpdateBotRecommendation::set_bot_recommendation_id): <p>The unique identifier of the bot recommendation to be updated.</p>
    ///   - [`encryption_setting(EncryptionSetting)`](crate::client::fluent_builders::UpdateBotRecommendation::encryption_setting) / [`set_encryption_setting(Option<EncryptionSetting>)`](crate::client::fluent_builders::UpdateBotRecommendation::set_encryption_setting): <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    /// - On success, responds with [`UpdateBotRecommendationOutput`](crate::output::UpdateBotRecommendationOutput) with field(s):
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateBotRecommendationOutput::bot_id): <p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateBotRecommendationOutput::bot_version): <p>The version of the bot containing the bot recommendation that has been updated.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::UpdateBotRecommendationOutput::locale_id): <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    ///   - [`bot_recommendation_status(Option<BotRecommendationStatus>)`](crate::output::UpdateBotRecommendationOutput::bot_recommendation_status): <p>The status of the bot recommendation.</p>  <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    ///   - [`bot_recommendation_id(Option<String>)`](crate::output::UpdateBotRecommendationOutput::bot_recommendation_id): <p>The unique identifier of the bot recommendation to be updated.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateBotRecommendationOutput::creation_date_time): <p>A timestamp of the date and time that the bot recommendation was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateBotRecommendationOutput::last_updated_date_time): <p>A timestamp of the date and time that the bot recommendation was last updated.</p>
    ///   - [`transcript_source_setting(Option<TranscriptSourceSetting>)`](crate::output::UpdateBotRecommendationOutput::transcript_source_setting): <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    ///   - [`encryption_setting(Option<EncryptionSetting>)`](crate::output::UpdateBotRecommendationOutput::encryption_setting): <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    /// - On failure, responds with [`SdkError<UpdateBotRecommendationError>`](crate::error::UpdateBotRecommendationError)
    pub fn update_bot_recommendation(&self) -> fluent_builders::UpdateBotRecommendation {
        fluent_builders::UpdateBotRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateExport`](crate::client::fluent_builders::UpdateExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_id(impl Into<String>)`](crate::client::fluent_builders::UpdateExport::export_id) / [`set_export_id(Option<String>)`](crate::client::fluent_builders::UpdateExport::set_export_id): <p>The unique identifier Amazon Lex assigned to the export.</p>
    ///   - [`file_password(impl Into<String>)`](crate::client::fluent_builders::UpdateExport::file_password) / [`set_file_password(Option<String>)`](crate::client::fluent_builders::UpdateExport::set_file_password): <p>The new password to use to encrypt the export zip archive.</p>
    /// - On success, responds with [`UpdateExportOutput`](crate::output::UpdateExportOutput) with field(s):
    ///   - [`export_id(Option<String>)`](crate::output::UpdateExportOutput::export_id): <p>The unique identifier Amazon Lex assigned to the export.</p>
    ///   - [`resource_specification(Option<ExportResourceSpecification>)`](crate::output::UpdateExportOutput::resource_specification): <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    ///   - [`file_format(Option<ImportExportFileFormat>)`](crate::output::UpdateExportOutput::file_format): <p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>
    ///   - [`export_status(Option<ExportStatus>)`](crate::output::UpdateExportOutput::export_status): <p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateExportOutput::creation_date_time): <p>The date and time that the export was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateExportOutput::last_updated_date_time): <p>The date and time that the export was last updated.</p>
    /// - On failure, responds with [`SdkError<UpdateExportError>`](crate::error::UpdateExportError)
    pub fn update_export(&self) -> fluent_builders::UpdateExport {
        fluent_builders::UpdateExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateIntent`](crate::client::fluent_builders::UpdateIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_intent_id): <p>The unique identifier of the intent to update.</p>
    ///   - [`intent_name(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::intent_name) / [`set_intent_name(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_intent_name): <p>The new name for the intent.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_description): <p>The new description of the intent.</p>
    ///   - [`parent_intent_signature(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::parent_intent_signature) / [`set_parent_intent_signature(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_parent_intent_signature): <p>The signature of the new built-in intent to use as the parent of this intent.</p>
    ///   - [`sample_utterances(Vec<SampleUtterance>)`](crate::client::fluent_builders::UpdateIntent::sample_utterances) / [`set_sample_utterances(Option<Vec<SampleUtterance>>)`](crate::client::fluent_builders::UpdateIntent::set_sample_utterances): <p>New utterances used to invoke the intent.</p>
    ///   - [`dialog_code_hook(DialogCodeHookSettings)`](crate::client::fluent_builders::UpdateIntent::dialog_code_hook) / [`set_dialog_code_hook(Option<DialogCodeHookSettings>)`](crate::client::fluent_builders::UpdateIntent::set_dialog_code_hook): <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
    ///   - [`fulfillment_code_hook(FulfillmentCodeHookSettings)`](crate::client::fluent_builders::UpdateIntent::fulfillment_code_hook) / [`set_fulfillment_code_hook(Option<FulfillmentCodeHookSettings>)`](crate::client::fluent_builders::UpdateIntent::set_fulfillment_code_hook): <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
    ///   - [`slot_priorities(Vec<SlotPriority>)`](crate::client::fluent_builders::UpdateIntent::slot_priorities) / [`set_slot_priorities(Option<Vec<SlotPriority>>)`](crate::client::fluent_builders::UpdateIntent::set_slot_priorities): <p>A new list of slots and their priorities that are contained by the intent.</p>
    ///   - [`intent_confirmation_setting(IntentConfirmationSetting)`](crate::client::fluent_builders::UpdateIntent::intent_confirmation_setting) / [`set_intent_confirmation_setting(Option<IntentConfirmationSetting>)`](crate::client::fluent_builders::UpdateIntent::set_intent_confirmation_setting): <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    ///   - [`intent_closing_setting(IntentClosingSetting)`](crate::client::fluent_builders::UpdateIntent::intent_closing_setting) / [`set_intent_closing_setting(Option<IntentClosingSetting>)`](crate::client::fluent_builders::UpdateIntent::set_intent_closing_setting): <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
    ///   - [`input_contexts(Vec<InputContext>)`](crate::client::fluent_builders::UpdateIntent::input_contexts) / [`set_input_contexts(Option<Vec<InputContext>>)`](crate::client::fluent_builders::UpdateIntent::set_input_contexts): <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
    ///   - [`output_contexts(Vec<OutputContext>)`](crate::client::fluent_builders::UpdateIntent::output_contexts) / [`set_output_contexts(Option<Vec<OutputContext>>)`](crate::client::fluent_builders::UpdateIntent::set_output_contexts): <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    ///   - [`kendra_configuration(KendraConfiguration)`](crate::client::fluent_builders::UpdateIntent::kendra_configuration) / [`set_kendra_configuration(Option<KendraConfiguration>)`](crate::client::fluent_builders::UpdateIntent::set_kendra_configuration): <p>New configuration settings for connecting to an Amazon Kendra index.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_bot_id): <p>The identifier of the bot that contains the intent.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_bot_version): <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::UpdateIntent::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::UpdateIntent::set_locale_id): <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    /// - On success, responds with [`UpdateIntentOutput`](crate::output::UpdateIntentOutput) with field(s):
    ///   - [`intent_id(Option<String>)`](crate::output::UpdateIntentOutput::intent_id): <p>The identifier of the intent that was updated.</p>
    ///   - [`intent_name(Option<String>)`](crate::output::UpdateIntentOutput::intent_name): <p>The updated name of the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateIntentOutput::description): <p>The updated description of the intent.</p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::UpdateIntentOutput::parent_intent_signature): <p>The updated built-in intent that is the parent of this intent.</p>
    ///   - [`sample_utterances(Option<Vec<SampleUtterance>>)`](crate::output::UpdateIntentOutput::sample_utterances): <p>The updated list of sample utterances for the intent.</p>
    ///   - [`dialog_code_hook(Option<DialogCodeHookSettings>)`](crate::output::UpdateIntentOutput::dialog_code_hook): <p>The updated Lambda function called during each turn of the conversation with the user.</p>
    ///   - [`fulfillment_code_hook(Option<FulfillmentCodeHookSettings>)`](crate::output::UpdateIntentOutput::fulfillment_code_hook): <p>The updated Lambda function called when the intent is ready for fulfillment.</p>
    ///   - [`slot_priorities(Option<Vec<SlotPriority>>)`](crate::output::UpdateIntentOutput::slot_priorities): <p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>
    ///   - [`intent_confirmation_setting(Option<IntentConfirmationSetting>)`](crate::output::UpdateIntentOutput::intent_confirmation_setting): <p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    ///   - [`intent_closing_setting(Option<IntentClosingSetting>)`](crate::output::UpdateIntentOutput::intent_closing_setting): <p>The updated response that Amazon Lex sends the user when the intent is closed.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::UpdateIntentOutput::input_contexts): <p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::UpdateIntentOutput::output_contexts): <p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::UpdateIntentOutput::kendra_configuration): <p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateIntentOutput::bot_id): <p>The identifier of the bot that contains the intent.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateIntentOutput::bot_version): <p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::UpdateIntentOutput::locale_id): <p>The updated language and locale of the intent.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateIntentOutput::creation_date_time): <p>A timestamp of when the intent was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateIntentOutput::last_updated_date_time): <p>A timestamp of the last time that the intent was modified.</p>
    /// - On failure, responds with [`SdkError<UpdateIntentError>`](crate::error::UpdateIntentError)
    pub fn update_intent(&self) -> fluent_builders::UpdateIntent {
        fluent_builders::UpdateIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResourcePolicy`](crate::client::fluent_builders::UpdateResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::set_policy): <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>  <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
    ///   - [`expected_revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::expected_revision_id) / [`set_expected_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateResourcePolicy::set_expected_revision_id): <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>  <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
    /// - On success, responds with [`UpdateResourcePolicyOutput`](crate::output::UpdateResourcePolicyOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::UpdateResourcePolicyOutput::resource_arn): <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::UpdateResourcePolicyOutput::revision_id): <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    /// - On failure, responds with [`SdkError<UpdateResourcePolicyError>`](crate::error::UpdateResourcePolicyError)
    pub fn update_resource_policy(&self) -> fluent_builders::UpdateResourcePolicy {
        fluent_builders::UpdateResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSlot`](crate::client::fluent_builders::UpdateSlot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::slot_id) / [`set_slot_id(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_slot_id): <p>The unique identifier for the slot to update.</p>
    ///   - [`slot_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::slot_name) / [`set_slot_name(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_slot_name): <p>The new name for the slot.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_description): <p>The new description for the slot.</p>
    ///   - [`slot_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::slot_type_id) / [`set_slot_type_id(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_slot_type_id): <p>The unique identifier of the new slot type to associate with this slot. </p>
    ///   - [`value_elicitation_setting(SlotValueElicitationSetting)`](crate::client::fluent_builders::UpdateSlot::value_elicitation_setting) / [`set_value_elicitation_setting(Option<SlotValueElicitationSetting>)`](crate::client::fluent_builders::UpdateSlot::set_value_elicitation_setting): <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
    ///   - [`obfuscation_setting(ObfuscationSetting)`](crate::client::fluent_builders::UpdateSlot::obfuscation_setting) / [`set_obfuscation_setting(Option<ObfuscationSetting>)`](crate::client::fluent_builders::UpdateSlot::set_obfuscation_setting): <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_bot_id): <p>The unique identifier of the bot that contains the slot.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_bot_version): <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_locale_id): <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`intent_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlot::intent_id) / [`set_intent_id(Option<String>)`](crate::client::fluent_builders::UpdateSlot::set_intent_id): <p>The identifier of the intent that contains the slot.</p>
    ///   - [`multiple_values_setting(MultipleValuesSetting)`](crate::client::fluent_builders::UpdateSlot::multiple_values_setting) / [`set_multiple_values_setting(Option<MultipleValuesSetting>)`](crate::client::fluent_builders::UpdateSlot::set_multiple_values_setting): <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>  <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    /// - On success, responds with [`UpdateSlotOutput`](crate::output::UpdateSlotOutput) with field(s):
    ///   - [`slot_id(Option<String>)`](crate::output::UpdateSlotOutput::slot_id): <p>The unique identifier of the slot that was updated.</p>
    ///   - [`slot_name(Option<String>)`](crate::output::UpdateSlotOutput::slot_name): <p>The updated name of the slot.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateSlotOutput::description): <p>The updated description of the bot.</p>
    ///   - [`slot_type_id(Option<String>)`](crate::output::UpdateSlotOutput::slot_type_id): <p>The updated identifier of the slot type that provides values for the slot.</p>
    ///   - [`value_elicitation_setting(Option<SlotValueElicitationSetting>)`](crate::output::UpdateSlotOutput::value_elicitation_setting): <p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>
    ///   - [`obfuscation_setting(Option<ObfuscationSetting>)`](crate::output::UpdateSlotOutput::obfuscation_setting): <p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateSlotOutput::bot_id): <p>The identifier of the bot that contains the slot.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateSlotOutput::bot_version): <p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::UpdateSlotOutput::locale_id): <p>The locale that contains the slot.</p>
    ///   - [`intent_id(Option<String>)`](crate::output::UpdateSlotOutput::intent_id): <p>The intent that contains the slot.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateSlotOutput::creation_date_time): <p>The timestamp of the date and time that the slot was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateSlotOutput::last_updated_date_time): <p>The timestamp of the date and time that the slot was last updated.</p>
    ///   - [`multiple_values_setting(Option<MultipleValuesSetting>)`](crate::output::UpdateSlotOutput::multiple_values_setting): <p>Indicates whether the slot accepts multiple values in one response.</p>
    /// - On failure, responds with [`SdkError<UpdateSlotError>`](crate::error::UpdateSlotError)
    pub fn update_slot(&self) -> fluent_builders::UpdateSlot {
        fluent_builders::UpdateSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSlotType`](crate::client::fluent_builders::UpdateSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`slot_type_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::slot_type_id) / [`set_slot_type_id(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_slot_type_id): <p>The unique identifier of the slot type to update.</p>
    ///   - [`slot_type_name(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::slot_type_name) / [`set_slot_type_name(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_slot_type_name): <p>The new name of the slot type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_description): <p>The new description of the slot type.</p>
    ///   - [`slot_type_values(Vec<SlotTypeValue>)`](crate::client::fluent_builders::UpdateSlotType::slot_type_values) / [`set_slot_type_values(Option<Vec<SlotTypeValue>>)`](crate::client::fluent_builders::UpdateSlotType::set_slot_type_values): <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
    ///   - [`value_selection_setting(SlotValueSelectionSetting)`](crate::client::fluent_builders::UpdateSlotType::value_selection_setting) / [`set_value_selection_setting(Option<SlotValueSelectionSetting>)`](crate::client::fluent_builders::UpdateSlotType::set_value_selection_setting): <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
    ///   - [`parent_slot_type_signature(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::parent_slot_type_signature) / [`set_parent_slot_type_signature(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_parent_slot_type_signature): <p>The new built-in slot type that should be used as the parent of this slot type.</p>
    ///   - [`bot_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::bot_id) / [`set_bot_id(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_bot_id): <p>The identifier of the bot that contains the slot type.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_bot_version): <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
    ///   - [`locale_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSlotType::locale_id) / [`set_locale_id(Option<String>)`](crate::client::fluent_builders::UpdateSlotType::set_locale_id): <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    ///   - [`external_source_setting(ExternalSourceSetting)`](crate::client::fluent_builders::UpdateSlotType::external_source_setting) / [`set_external_source_setting(Option<ExternalSourceSetting>)`](crate::client::fluent_builders::UpdateSlotType::set_external_source_setting): <p>Provides information about the external source of the slot type's definition.</p>
    /// - On success, responds with [`UpdateSlotTypeOutput`](crate::output::UpdateSlotTypeOutput) with field(s):
    ///   - [`slot_type_id(Option<String>)`](crate::output::UpdateSlotTypeOutput::slot_type_id): <p>The unique identifier of the updated slot type.</p>
    ///   - [`slot_type_name(Option<String>)`](crate::output::UpdateSlotTypeOutput::slot_type_name): <p>The updated name of the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateSlotTypeOutput::description): <p>The updated description of the slot type.</p>
    ///   - [`slot_type_values(Option<Vec<SlotTypeValue>>)`](crate::output::UpdateSlotTypeOutput::slot_type_values): <p>The updated values that the slot type provides.</p>
    ///   - [`value_selection_setting(Option<SlotValueSelectionSetting>)`](crate::output::UpdateSlotTypeOutput::value_selection_setting): <p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::UpdateSlotTypeOutput::parent_slot_type_signature): <p>The updated signature of the built-in slot type that is the parent of this slot type.</p>
    ///   - [`bot_id(Option<String>)`](crate::output::UpdateSlotTypeOutput::bot_id): <p>The identifier of the bot that contains the slot type.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::UpdateSlotTypeOutput::bot_version): <p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>
    ///   - [`locale_id(Option<String>)`](crate::output::UpdateSlotTypeOutput::locale_id): <p>The language and locale of the updated slot type.</p>
    ///   - [`creation_date_time(Option<DateTime>)`](crate::output::UpdateSlotTypeOutput::creation_date_time): <p>The timestamp of the date and time that the slot type was created.</p>
    ///   - [`last_updated_date_time(Option<DateTime>)`](crate::output::UpdateSlotTypeOutput::last_updated_date_time): <p>A timestamp of the date and time that the slot type was last updated.</p>
    ///   - [`external_source_setting(Option<ExternalSourceSetting>)`](crate::output::UpdateSlotTypeOutput::external_source_setting): <p>Provides information about the external source of the slot type's definition.</p>
    /// - On failure, responds with [`SdkError<UpdateSlotTypeError>`](crate::error::UpdateSlotTypeError)
    pub fn update_slot_type(&self) -> fluent_builders::UpdateSlotType {
        fluent_builders::UpdateSlotType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BuildBotLocale`.
    ///
    /// <p>Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BuildBotLocale {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::build_bot_locale_input::Builder,
    }
    impl BuildBotLocale {
        /// Creates a new `BuildBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BuildBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::BuildBotLocaleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to build. The identifier is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBot`.
    ///
    /// <p>Creates an Amazon Lex conversational bot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bot_input::Builder,
    }
    impl CreateBot {
        /// Creates a new `CreateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot. The bot name must be unique in the account that creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a particular bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.inner = self.inner.data_privacy(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_data_privacy(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.idle_session_ttl_in_seconds(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_session_ttl_in_seconds(input);
            self
        }
        /// Adds a key-value pair to `botTags`.
        ///
        /// To override the contents of this collection use [`set_bot_tags`](Self::set_bot_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn bot_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.bot_tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_bot_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_tags(input);
            self
        }
        /// Adds a key-value pair to `testBotAliasTags`.
        ///
        /// To override the contents of this collection use [`set_test_bot_alias_tags`](Self::set_test_bot_alias_tags).
        ///
        /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
        pub fn test_bot_alias_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.test_bot_alias_tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to add to the test alias for a bot. You can only add tags when you create a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.</p>
        pub fn set_test_bot_alias_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_test_bot_alias_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotAlias`.
    ///
    /// <p>Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.</p>
    /// <p>For example, you can create an alias called "PROD" that your applications use to call the Amazon Lex bot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBotAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bot_alias_input::Builder,
    }
    impl CreateBotAlias {
        /// Creates a new `CreateBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_name(input.into());
            self
        }
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_name(input);
            self
        }
        /// <p>A description of the alias. Use this description to help identify the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the alias. Use this description to help identify the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the bot version associated with the alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// Adds a key-value pair to `botAliasLocaleSettings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            self.inner = self.inner.bot_alias_locale_settings(k.into(), v);
            self
        }
        /// <p>Maps configuration information to a specific locale. You can use this parameter to specify a specific Lambda function to run different functions in different locales.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_locale_settings(input);
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.inner = self.inner.conversation_log_settings(input);
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with the bot. When you enable conversation logs, text logs store text input, transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio logs store audio input in Amazon S3.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_conversation_log_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.inner = self.inner.sentiment_analysis_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.inner = self.inner.set_sentiment_analysis_settings(input);
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>UpdateBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotLocale`.
    ///
    /// <p>Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBotLocale {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bot_locale_input::Builder,
    }
    impl CreateBotLocale {
        /// Creates a new `CreateBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotLocaleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used in. The string must match one of the supported locales. All of the intents, slot types, and slots used in the bot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot locale in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.inner = self.inner.nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.inner = self.inner.voice_settings(input);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.inner = self.inner.set_voice_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotVersion`.
    ///
    /// <p>Creates a new version of the bot based on the <code>DRAFT</code> version. If the <code>DRAFT</code> version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.</p>
    /// <p>When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBotVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_bot_version_input::Builder,
    }
    impl CreateBotVersion {
        /// Creates a new `CreateBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>A description of the version. Use the description to help identify the version in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the version. Use the description to help identify the version in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `botVersionLocaleSpecification`.
        ///
        /// To override the contents of this collection use [`set_bot_version_locale_specification`](Self::set_bot_version_locale_specification).
        ///
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
        pub fn bot_version_locale_specification(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotVersionLocaleDetails,
        ) -> Self {
            self.inner = self.inner.bot_version_locale_specification(k.into(), v);
            self
        }
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.</p>
        pub fn set_bot_version_locale_specification(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotVersionLocaleDetails,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_version_locale_specification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExport`.
    ///
    /// <p>Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.</p>
    /// <p>You can create an archive that contains the complete definition of a bot, or you can specify that the archive contain only the definition of a single bot locale.</p>
    /// <p>For more information about exporting bots, and about the structure of the export archive, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and exporting bots </a> </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_export_input::Builder,
    }
    impl CreateExport {
        /// Creates a new `CreateExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.inner = self.inner.resource_specification(input);
            self
        }
        /// <p>Specifies the type of resource to export, either a bot or a bot locale. You can only specify one type of resource to export.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_resource_specification(input);
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.inner = self.inner.file_format(input);
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.inner = self.inner.set_file_format(input);
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(input.into());
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password is optional, but you should encrypt the archive to protect the data in transit between Amazon Lex and your local computer.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntent`.
    ///
    /// <p>Creates an intent.</p>
    /// <p>To define the interaction between the user and your bot, you define one or more intents. For example, for a pizza ordering bot you would create an <code>OrderPizza</code> intent.</p>
    /// <p>When you create an intent, you must provide a name. You can optionally provide the following:</p>
    /// <ul>
    /// <li> <p>Sample utterances. For example, "I want to order a pizza" and "Can I order a pizza." You can't provide utterances for built-in intents.</p> </li>
    /// <li> <p>Information to be gathered. You specify slots for the information that you bot requests from the user. You can specify standard slot types, such as date and time, or custom slot types for your application.</p> </li>
    /// <li> <p>How the intent is fulfilled. You can provide a Lambda function or configure the intent to return the intent information to your client application. If you use a Lambda function, Amazon Lex invokes the function when all of the intent information is available.</p> </li>
    /// <li> <p>A confirmation prompt to send to the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li>
    /// <li> <p>A conclusion statement to send to the user after the intent is fulfilled. For example, "I ordered your pizza."</p> </li>
    /// <li> <p>A follow-up prompt that asks the user for additional activity. For example, "Do you want a drink with your pizza?"</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_intent_input::Builder,
    }
    impl CreateIntent {
        /// Creates a new `CreateIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_name(input.into());
            self
        }
        /// <p>The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_name(input);
            self
        }
        /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the intent. Use the description to help identify the intent in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_intent_signature(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_intent_signature(input);
            self
        }
        /// Appends an item to `sampleUtterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            self.inner = self.inner.sample_utterances(input);
            self
        }
        /// <p>An array of strings that a user might say to signal the intent. For example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in the utterance shown to the user.. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.inner = self.inner.set_sample_utterances(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.inner = self.inner.dialog_code_hook(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the corresponding session attribute.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_dialog_code_hook(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.inner = self.inner.fulfillment_code_hook(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the customer's location and then place an order on the customer's behalf.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_fulfillment_code_hook(input);
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.inner = self.inner.intent_confirmation_setting(input);
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers "no," the settings contain a statement that is sent to the user to end the intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_confirmation_setting(input);
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.inner = self.inner.intent_closing_setting(input);
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_closing_setting(input);
            self
        }
        /// Appends an item to `inputContexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
        /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            self.inner = self.inner.input_contexts(input);
            self
        }
        /// <p>A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the <code>outputContexts</code> property or it can be set at runtime.</p>
        /// <p> For example, if there are two intents with different input contexts that respond to the same utterances, only the intent with the active context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be active to consider the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.inner = self.inner.set_input_contexts(input);
            self
        }
        /// Appends an item to `outputContexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            self.inner = self.inner.output_contexts(input);
            self
        }
        /// <p>A lists of contexts that the intent activates when it is fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.inner = self.inner.set_output_contexts(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.inner = self.inner.kendra_configuration(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kendra_configuration(input);
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the version of the bot associated with this intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with this intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourcePolicy`.
    ///
    /// <p>Creates a new resource policy with the specified policy statements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_policy_input::Builder,
    }
    impl CreateResourcePolicy {
        /// Creates a new `CreateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourcePolicyStatement`.
    ///
    /// <p>Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.</p>
    /// <p>You can't create a resource policy statement that allows cross-account access.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourcePolicyStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_policy_statement_input::Builder,
    }
    impl CreateResourcePolicyStatement {
        /// Creates a new `CreateResourcePolicyStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourcePolicyStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourcePolicyStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>The name of the statement. The ID is the same as the <code>Sid</code> IAM property. The statement name must be unique within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM JSON policy elements: Sid</a>. </p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Determines whether the statement allows or denies access to the resource.</p>
        pub fn effect(mut self, input: crate::model::Effect) -> Self {
            self.inner = self.inner.effect(input);
            self
        }
        /// <p>Determines whether the statement allows or denies access to the resource.</p>
        pub fn set_effect(mut self, input: std::option::Option<crate::model::Effect>) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn principal(mut self, input: crate::model::Principal) -> Self {
            self.inner = self.inner.principal(input);
            self
        }
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services that is allowed or denied access to a resource. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The Amazon Lex action that this policy either allows or denies. The action must apply to the resource type of the specified ARN. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html"> Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: std::collections::HashMap<std::string::String, std::string::String>,
        ) -> Self {
            self.inner = self.inner.condition(k.into(), v);
            self
        }
        /// <p>Specifies a condition when the policy is in effect. If the principal of the policy is a service principal, you must provide two condition blocks, one with a SourceAccount global condition key and one with a SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_condition(input);
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSlot`.
    ///
    /// <p>Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an <code>OrderPizza</code> intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSlot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_slot_input::Builder,
    }
    impl CreateSlot {
        /// Creates a new `CreateSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSlotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_name(input.into());
            self
        }
        /// <p>The name of the slot. Slot names must be unique within the bot that contains the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_name(input);
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(input.into());
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot. The slot type determines the values that can be entered into the slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.inner = self.inner.value_elicitation_setting(input);
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot. </p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_elicitation_setting(input);
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.inner = self.inner.obfuscation_setting(input);
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of the <code>obfuscationSetting</code> parameter is <code>DefaultObfuscation</code>, slot values are obfuscated in the log output. If the value is <code>None</code>, the actual value is present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.inner = self.inner.set_obfuscation_setting(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used in. The string must match one of the supported locales. All of the bots, intents, slot types used by the slot must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.inner = self.inner.multiple_values_setting(input);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response. Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.inner = self.inner.set_multiple_values_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSlotType`.
    ///
    /// <p>Creates a custom slot type</p>
    /// <p> To create a custom slot type, specify a name for the slot type and a set of enumeration values, the values that a slot of this type can assume. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSlotType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_slot_type_input::Builder,
    }
    impl CreateSlotType {
        /// Creates a new `CreateSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSlotTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the slot. A slot type name must be unique within the account.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_name(input.into());
            self
        }
        /// <p>The name for the slot. A slot type name must be unique within the account.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_name(input);
            self
        }
        /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the slot type. Use the description to help identify the slot type in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `slotTypeValues`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            self.inner = self.inner.slot_type_values(input);
            self
        }
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_values(input);
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.inner = self.inner.value_selection_setting(input);
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>OriginalValue</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TopResolution</code> - If there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code> parameter, the default is <code>OriginalValue</code>.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_selection_setting(input);
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_slot_type_signature(input.into());
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_slot_type_signature(input);
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the bot version associated with this slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The identifier of the bot version associated with this slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be used in. The string must match one of the supported locales. All of the bots, intents, and slots used by the slot type must have the same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Sets the type of external information used to create the slot type.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.inner = self.inner.external_source_setting(input);
            self
        }
        /// <p>Sets the type of external information used to create the slot type.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.inner = self.inner.set_external_source_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUploadUrl`.
    ///
    /// <p>Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUploadUrl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_upload_url_input::Builder,
    }
    impl CreateUploadUrl {
        /// Creates a new `CreateUploadUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUploadUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUploadUrlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteBot`.
    ///
    /// <p>Deletes all versions of a bot, including the <code>Draft</code> version. To delete a specific version, use the <code>DeleteBotVersion</code> operation.</p>
    /// <p>When you delete a bot, all of the resources contained in the bot are also deleted. Deleting a bot removes all locales, intents, slot, and slot types defined for the bot.</p>
    /// <p>If a bot has an alias, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception. If you want to delete the bot and the alias, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bot_input::Builder,
    }
    impl DeleteBot {
        /// Creates a new `DeleteBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to delete. </p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to delete. </p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(input);
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another resource, such as an alias, is using the bot before it is deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotAlias`.
    ///
    /// <p>Deletes the specified bot alias.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bot_alias_input::Builder,
    }
    impl DeleteBotAlias {
        /// Creates a new `DeleteBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to delete.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(input);
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other resource is using the alias before it is deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotLocale`.
    ///
    /// <p>Removes a locale from a bot.</p>
    /// <p>When you delete a locale, all intents, slots, and slot types defined for the locale are also deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotLocale {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bot_locale_input::Builder,
    }
    impl DeleteBotLocale {
        /// Creates a new `DeleteBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotLocaleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotVersion`.
    ///
    /// <p>Deletes a specific version of a bot. To delete all version of a bot, use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html">DeleteBot</a> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_bot_version_input::Builder,
    }
    impl DeleteBotVersion {
        /// Creates a new `DeleteBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(input);
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a bot version that has an alias pointing at it. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the version even if an alias points to it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomVocabulary`.
    ///
    /// <p>Removes a custom vocabulary from the specified locale in the specified bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomVocabulary {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_custom_vocabulary_input::Builder,
    }
    impl DeleteCustomVocabulary {
        /// Creates a new `DeleteCustomVocabulary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomVocabularyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomVocabularyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot to remove the custom vocabulary from.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to remove the custom vocabulary from.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to remove the custom vocabulary from.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The locale identifier for the locale that contains the custom vocabulary to remove.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExport`.
    ///
    /// <p>Removes a previous export and the associated files stored in an S3 bucket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_export_input::Builder,
    }
    impl DeleteExport {
        /// Creates a new `DeleteExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the export to delete.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(input.into());
            self
        }
        /// <p>The unique identifier of the export to delete.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImport`.
    ///
    /// <p>Removes a previous import and the associated file stored in an S3 bucket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_import_input::Builder,
    }
    impl DeleteImport {
        /// Creates a new `DeleteImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the import to delete.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(input.into());
            self
        }
        /// <p>The unique identifier of the import to delete.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntent`.
    ///
    /// <p>Removes the specified intent.</p>
    /// <p>Deleting an intent also deletes the slots associated with the intent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_intent_input::Builder,
    }
    impl DeleteIntent {
        /// Creates a new `DeleteIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the bot will be deleted. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the resource policy attached.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(input.into());
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current policy.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicyStatement`.
    ///
    /// <p>Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicyStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_statement_input::Builder,
    }
    impl DeleteResourcePolicyStatement {
        /// Creates a new `DeleteResourcePolicyStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents of the statement. </p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlot`.
    ///
    /// <p>Deletes the specified slot from an intent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSlot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_slot_input::Builder,
    }
    impl DeleteSlot {
        /// Creates a new `DeleteSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot to delete. </p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(input.into());
            self
        }
        /// <p>The identifier of the slot to delete. </p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlotType`.
    ///
    /// <p>Deletes a slot type from a bot locale.</p>
    /// <p>If a slot is using the slot type, Amazon Lex throws a <code>ResourceInUseException</code> exception. To avoid the exception, set the <code>skipResourceInUseCheck</code> parameter to <code>true</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSlotType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_slot_type_input::Builder,
    }
    impl DeleteSlotType {
        /// Creates a new `DeleteSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot type to delete.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(input.into());
            self
        }
        /// <p>The identifier of the slot type to delete.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be deleted from. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
        pub fn skip_resource_in_use_check(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(input);
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a <code>ResourceInUseException</code> exception if you try to delete a slot type used by a slot. Set the <code>skipResourceInUseCheck</code> parameter to <code>true</code> to skip this check and remove the slot type even if a slot uses it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUtterances`.
    ///
    /// <p>Deletes stored utterances.</p>
    /// <p>Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input..</p>
    /// <p>Use the <code>DeleteUtterances</code> operation to manually delete utterances for a specific session. When you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the <code>ListAggregatedUtterances</code> operation are deleted after 15 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUtterances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_utterances_input::Builder,
    }
    impl DeleteUtterances {
        /// Creates a new `DeleteUtterances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUtterancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUtterancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the utterances.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the utterances.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBot`.
    ///
    /// <p>Provides metadata information about a bot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bot_input::Builder,
    }
    impl DescribeBot {
        /// Creates a new `DescribeBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotAlias`.
    ///
    /// <p>Get information about a specific bot alias.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBotAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bot_alias_input::Builder,
    }
    impl DescribeBotAlias {
        /// Creates a new `DescribeBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(input.into());
            self
        }
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to describe.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotLocale`.
    ///
    /// <p>Describes the settings that a bot has for a specific locale. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBotLocale {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bot_locale_input::Builder,
    }
    impl DescribeBotLocale {
        /// Creates a new `DescribeBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotLocaleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotRecommendation`.
    ///
    /// <p>Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBotRecommendation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bot_recommendation_input::Builder,
    }
    impl DescribeBotRecommendation {
        /// Creates a new `DescribeBotRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotRecommendationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotRecommendationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the bot recommendation to describe.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_recommendation_id(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation to describe.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_recommendation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotVersion`.
    ///
    /// <p>Provides metadata about a version of a bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBotVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_bot_version_input::Builder,
    }
    impl DescribeBotVersion {
        /// Creates a new `DescribeBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot containing the version to return metadata for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot containing the version to return metadata for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomVocabularyMetadata`.
    ///
    /// <p>Provides metadata information about a custom vocabulary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCustomVocabularyMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_custom_vocabulary_metadata_input::Builder,
    }
    impl DescribeCustomVocabularyMetadata {
        /// Creates a new `DescribeCustomVocabularyMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomVocabularyMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomVocabularyMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the custom vocabulary.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The bot version of the bot to return metadata for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The bot version of the bot to return metadata for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The locale to return the custom vocabulary information for. The locale must be <code>en_GB</code>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExport`.
    ///
    /// <p>Gets information about a specific export.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_export_input::Builder,
    }
    impl DescribeExport {
        /// Creates a new `DescribeExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the export to describe.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(input.into());
            self
        }
        /// <p>The unique identifier of the export to describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImport`.
    ///
    /// <p>Gets information about a specific import.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_import_input::Builder,
    }
    impl DescribeImport {
        /// Creates a new `DescribeImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the import to describe.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(input.into());
            self
        }
        /// <p>The unique identifier of the import to describe.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIntent`.
    ///
    /// <p>Returns metadata about an intent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeIntent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_intent_input::Builder,
    }
    impl DescribeIntent {
        /// Creates a new `DescribeIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIntentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the intent to describe.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The identifier of the intent to describe.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicy`.
    ///
    /// <p>Gets the resource policy and policy revision for a bot or bot alias.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_policy_input::Builder,
    }
    impl DescribeResourcePolicy {
        /// Creates a new `DescribeResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSlot`.
    ///
    /// <p>Gets metadata information about a slot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSlot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_slot_input::Builder,
    }
    impl DescribeSlot {
        /// Creates a new `DescribeSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSlotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the slot.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(input.into());
            self
        }
        /// <p>The unique identifier for the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSlotType`.
    ///
    /// <p>Gets metadata information about a slot type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSlotType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_slot_type_input::Builder,
    }
    impl DescribeSlotType {
        /// Creates a new `DescribeSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSlotTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot type.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(input.into());
            self
        }
        /// <p>The identifier of the slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot type to describe. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAggregatedUtterances`.
    ///
    /// <p>Provides a list of utterances that users have sent to the bot.</p>
    /// <p>Utterances are aggregated by the text of the utterance. For example, all instances where customers used the phrase "I want to order pizza" are aggregated into the same line in the response.</p>
    /// <p>You can see both detected utterances and missed utterances. A detected utterance is where the bot properly recognized the utterance and activated the associated intent. A missed utterance was not recognized by the bot and didn't activate an intent.</p>
    /// <p>Utterances can be aggregated for a bot alias or for a bot version, but not both at the same time.</p>
    /// <p>Utterances statistics are not generated under the following conditions:</p>
    /// <ul>
    /// <li> <p>The <code>childDirected</code> field was set to true when the bot was created.</p> </li>
    /// <li> <p>You are using slot obfuscation with one or more slots.</p> </li>
    /// <li> <p>You opted out of participating in improving Amazon Lex.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAggregatedUtterances {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aggregated_utterances_input::Builder,
    }
    impl ListAggregatedUtterances {
        /// Creates a new `ListAggregatedUtterances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAggregatedUtterancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAggregatedUtterancesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAggregatedUtterancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAggregatedUtterancesPaginator {
            crate::paginator::ListAggregatedUtterancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the bot associated with this request.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with this request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(input.into());
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you specify the bot alias, you can't specify the bot version.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The identifier of the bot version associated with this request. If you specify the bot version, you can't specify the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale where the utterances were collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
        pub fn aggregation_duration(
            mut self,
            input: crate::model::UtteranceAggregationDuration,
        ) -> Self {
            self.inner = self.inner.aggregation_duration(input);
            self
        }
        /// <p>The time window for aggregating the utterance information. You can specify a time between one hour and two weeks.</p>
        pub fn set_aggregation_duration(
            mut self,
            input: std::option::Option<crate::model::UtteranceAggregationDuration>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_duration(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
        pub fn sort_by(mut self, input: crate::model::AggregatedUtterancesSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can sort by the hit count, the missed count, or the number of distinct sessions the utterance appeared in.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::AggregatedUtterancesFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the utterances in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of utterances to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned. If you don't specify the <code>maxResults</code> parameter, 1,000 results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotAliases`.
    ///
    /// <p>Gets a list of aliases for the specified bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBotAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bot_aliases_input::Builder,
    }
    impl ListBotAliases {
        /// Creates a new `ListBotAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotAliasesPaginator {
            crate::paginator::ListBotAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotLocales`.
    ///
    /// <p>Gets a list of locales for the specified bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBotLocales {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bot_locales_input::Builder,
    }
    impl ListBotLocales {
        /// Creates a new `ListBotLocales`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotLocalesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotLocalesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotLocalesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotLocalesPaginator {
            crate::paginator::ListBotLocalesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotLocaleSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort by locale name in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotLocaleSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
        pub fn filters(mut self, input: crate::model::BotLocaleFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification for a filter used to limit the response to only those locales that match the filter specification. You can only specify one filter and one value to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotLocaleFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token as the <code>nextToken</code> parameter to return the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotRecommendations`.
    ///
    /// <p>Get a list of bot recommendations that meet the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBotRecommendations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bot_recommendations_input::Builder,
    }
    impl ListBotRecommendations {
        /// Creates a new `ListBotRecommendations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotRecommendationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotRecommendationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotRecommendationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotRecommendationsPaginator {
            crate::paginator::ListBotRecommendationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the ListBotRecommendation operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>Gets a list of available bots.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl ListBots {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotsPaginator {
            crate::paginator::ListBotsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in ascending or descending order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::BotSortBy>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::BotFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If there are fewer results than the maximum page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotVersions`.
    ///
    /// <p>Gets information about all of the versions of a bot.</p>
    /// <p>The <code>ListBotVersions</code> operation returns a summary of each version of a bot. For example, if a bot has three numbered versions, the <code>ListBotVersions</code> operation returns for summaries, one for each numbered version and one for the <code>DRAFT</code> version.</p>
    /// <p>The <code>ListBotVersions</code> operation always returns at least one version, the <code>DRAFT</code> version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBotVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_bot_versions_input::Builder,
    }
    impl ListBotVersions {
        /// Creates a new `ListBotVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotVersionsPaginator {
            crate::paginator::ListBotVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BotVersionSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can specify that the list be sorted by version name in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotVersionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuiltInIntents`.
    ///
    /// <p>Gets a list of built-in intents provided by Amazon Lex that you can use in your bot. </p>
    /// <p>To use a built-in intent as a the base for your own intent, include the built-in intent signature in the <code>parentIntentSignature</code> parameter when you call the <code>CreateIntent</code> operation. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html">CreateIntent</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuiltInIntents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_built_in_intents_input::Builder,
    }
    impl ListBuiltInIntents {
        /// Creates a new `ListBuiltInIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuiltInIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuiltInIntentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuiltInIntentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuiltInIntentsPaginator {
            crate::paginator::ListBuiltInIntentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BuiltInIntentSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You can specify that the list be sorted by the built-in intent signature in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInIntentSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuiltInSlotTypes`.
    ///
    /// <p>Gets a list of built-in slot types that meet the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuiltInSlotTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_built_in_slot_types_input::Builder,
    }
    impl ListBuiltInSlotTypes {
        /// Creates a new `ListBuiltInSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuiltInSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuiltInSlotTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuiltInSlotTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuiltInSlotTypesPaginator {
            crate::paginator::ListBuiltInSlotTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::BuiltInSlotTypeSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListBuiltInSlotTypes</code> operation. You can choose to sort by the slot type signature in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInSlotTypeSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExports`.
    ///
    /// <p>Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_exports_input::Builder,
    }
    impl ListExports {
        /// Creates a new `ListExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExportsPaginator {
            crate::paginator::ListExportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::ExportSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ExportSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::ExportFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the exports in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains more results that specified in the <code>maxResults</code> parameter, a token is returned in the response. </p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListExports</code> request to return the next page of results. For a complete set of results, call the <code>ListExports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>Specifies the resources that should be exported. If you don't specify a resource type in the <code>filters</code> parameter, both bot locales and custom vocabularies are exported.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImports`.
    ///
    /// <p>Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_imports_input::Builder,
    }
    impl ListImports {
        /// Creates a new `ListImports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImportsPaginator {
            crate::paginator::ListImportsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::ImportSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can sort by the <code>LastUpdatedDateTime</code> field in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ImportSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::ImportFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the response to only those that match the filter specification. You can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListImports</code> request to return the next page of results. For a complete set of results, call the <code>ListImports</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>Specifies the locale that should be present in the list. If you don't specify a resource type in the <code>filters</code> parameter, the list contains both bot locales and custom vocabularies.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntents`.
    ///
    /// <p>Get a list of intents that meet the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIntents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_intents_input::Builder,
    }
    impl ListIntents {
        /// Creates a new `ListIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIntentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListIntentsPaginator {
            crate::paginator::ListIntentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::IntentSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListIntents</code> operation. You can choose to sort by the intent name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::IntentSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::IntentFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the intents in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response.</p>
        /// <p>Use the returned token in the <code>nextToken</code> parameter of a <code>ListIntents</code> request to return the next page of results. For a complete set of results, call the <code>ListIntents</code> operation until the <code>nextToken</code> returned in the response is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRecommendedIntents`.
    ///
    /// <p>Gets a list of recommended intents provided by the bot recommendation that you can use in your bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRecommendedIntents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_recommended_intents_input::Builder,
    }
    impl ListRecommendedIntents {
        /// Creates a new `ListRecommendedIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRecommendedIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRecommendedIntentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRecommendedIntentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRecommendedIntentsPaginator {
            crate::paginator::ListRecommendedIntentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the bot associated with the recommended intents.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the recommended intents.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the recommended intents.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the recommended intents.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the recommended intents.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the recommended intents.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_recommendation_id(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intents.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_recommendation_id(input);
            self
        }
        /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the ListRecommendedIntents operation contains more results than specified in the maxResults parameter, a token is returned in the response. Use that token in the nextToken parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSlots`.
    ///
    /// <p>Gets a list of slots that match the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSlots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_slots_input::Builder,
    }
    impl ListSlots {
        /// Creates a new `ListSlots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSlotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSlotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSlotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSlotsPaginator {
            crate::paginator::ListSlotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::SlotSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlots</code> operation. You can choose to sort by the slot name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SlotSortBy>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::SlotFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slots in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSlotTypes`.
    ///
    /// <p>Gets a list of slot types that match the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSlotTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_slot_types_input::Builder,
    }
    impl ListSlotTypes {
        /// Creates a new `ListSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSlotTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSlotTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSlotTypesPaginator {
            crate::paginator::ListSlotTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the bot that contains the slot types.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the slot types.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
        pub fn sort_by(mut self, input: crate::model::SlotTypeSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Determines the sort order for the response from the <code>ListSlotTypes</code> operation. You can choose to sort by the slot type name or last updated date in either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SlotTypeSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, input: crate::model::SlotTypeFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slot types in the response to only those that match the filter specification. You can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of slot types to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation contains more results than specified in the <code>maxResults</code> parameter, a token is returned in the response. Use that token in the <code>nextToken</code> parameter to return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchAssociatedTranscripts`.
    ///
    /// <p>Search for associated transcripts that meet the specified criteria.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchAssociatedTranscripts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_associated_transcripts_input::Builder,
    }
    impl SearchAssociatedTranscripts {
        /// Creates a new `SearchAssociatedTranscripts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchAssociatedTranscriptsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchAssociatedTranscriptsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_recommendation_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_recommendation_id(input);
            self
        }
        /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
        pub fn search_order(mut self, input: crate::model::SearchOrder) -> Self {
            self.inner = self.inner.search_order(input);
            self
        }
        /// <p>How SearchResults are ordered. Valid values are Ascending or Descending. The default is Descending.</p>
        pub fn set_search_order(
            mut self,
            input: std::option::Option<crate::model::SearchOrder>,
        ) -> Self {
            self.inner = self.inner.set_search_order(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A list of filter objects.</p>
        pub fn filters(mut self, input: crate::model::AssociatedTranscriptFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A list of filter objects.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociatedTranscriptFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bot recommendations to return in each page of results. If there are fewer results than the max page size, only the actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
        pub fn next_index(mut self, input: i32) -> Self {
            self.inner = self.inner.next_index(input);
            self
        }
        /// <p>If the response from the SearchAssociatedTranscriptsRequest operation contains more results than specified in the maxResults parameter, an index is returned in the response. Use that index in the nextIndex parameter to return the next page of results.</p>
        pub fn set_next_index(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_next_index(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBotRecommendation`.
    ///
    /// <p>Use this to provide your transcript data, and to start the bot recommendation process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBotRecommendation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_bot_recommendation_input::Builder,
    }
    impl StartBotRecommendation {
        /// Creates a new `StartBotRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBotRecommendationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBotRecommendationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn transcript_source_setting(
            mut self,
            input: crate::model::TranscriptSourceSetting,
        ) -> Self {
            self.inner = self.inner.transcript_source_setting(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn set_transcript_source_setting(
            mut self,
            input: std::option::Option<crate::model::TranscriptSourceSetting>,
        ) -> Self {
            self.inner = self.inner.set_transcript_source_setting(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.inner = self.inner.encryption_setting(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.inner = self.inner.set_encryption_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImport`.
    ///
    /// <p>Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_import_input::Builder,
    }
    impl StartImport {
        /// Creates a new `StartImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(input.into());
            self
        }
        /// <p>The unique identifier for the import. It is included in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
        /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ImportResourceSpecification,
        ) -> Self {
            self.inner = self.inner.resource_specification(input);
            self
        }
        /// <p>Parameters for creating the bot, bot locale or custom vocabulary.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ImportResourceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_resource_specification(input);
            self
        }
        /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.inner = self.inner.merge_strategy(input);
            self
        }
        /// <p>The strategy to use when there is a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.inner = self.inner.set_merge_strategy(input);
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(input.into());
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the resource definition. You should always encrypt the zip archive to protect it during transit between your site and Amazon Lex.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a bot, bot alias, or bot channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBot`.
    ///
    /// <p>Updates the configuration of an existing bot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bot_input::Builder,
    }
    impl UpdateBot {
        /// Creates a new `UpdateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot to update. This identifier is returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.inner = self.inner.data_privacy(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_data_privacy(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.idle_session_ttl_in_seconds(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_session_ttl_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBotAlias`.
    ///
    /// <p>Updates the configuration of an existing bot alias.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBotAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bot_alias_input::Builder,
    }
    impl UpdateBotAlias {
        /// Creates a new `UpdateBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_name(input.into());
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_name(input);
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// Adds a key-value pair to `botAliasLocaleSettings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            self.inner = self.inner.bot_alias_locale_settings(k.into(), v);
            self
        }
        /// <p>The new Lambda functions to use in each locale for the bot alias.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_locale_settings(input);
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.inner = self.inner.conversation_log_settings(input);
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_conversation_log_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.inner = self.inner.sentiment_analysis_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.inner = self.inner.set_sentiment_analysis_settings(input);
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBotLocale`.
    ///
    /// <p>Updates the settings that a bot has for a specific locale.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBotLocale {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bot_locale_input::Builder,
    }
    impl UpdateBotLocale {
        /// Creates a new `UpdateBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotLocaleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The version can only be the <code>DRAFT</code> version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.inner = self.inner.nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.inner = self.inner.voice_settings(input);
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.inner = self.inner.set_voice_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBotRecommendation`.
    ///
    /// <p>Updates an existing bot recommendation request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBotRecommendation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_bot_recommendation_input::Builder,
    }
    impl UpdateBotRecommendation {
        /// Creates a new `UpdateBotRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotRecommendationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotRecommendationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation to be updated.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot containing the bot recommendation to be updated.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation to be updated.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_recommendation_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_recommendation_id(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.inner = self.inner.encryption_setting(input);
            self
        }
        /// <p>The object representing the passwords that will be used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.inner = self.inner.set_encryption_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExport`.
    ///
    /// <p>Updates the password used to protect an export zip archive.</p>
    /// <p>The password is not required. If you don't supply a password, Amazon Lex generates a zip file that is not protected by a password. This is the archive that is available at the pre-signed S3 URL provided by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateExport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_export_input::Builder,
    }
    impl UpdateExport {
        /// Creates a new `UpdateExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExportOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(input.into());
            self
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn file_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(input.into());
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntent`.
    ///
    /// <p>Updates the settings for an intent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateIntent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_intent_input::Builder,
    }
    impl UpdateIntent {
        /// Creates a new `UpdateIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the intent to update.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The unique identifier of the intent to update.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_name(input.into());
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_name(input);
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_intent_signature(input.into());
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of this intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_intent_signature(input);
            self
        }
        /// Appends an item to `sampleUtterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>New utterances used to invoke the intent.</p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            self.inner = self.inner.sample_utterances(input);
            self
        }
        /// <p>New utterances used to invoke the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.inner = self.inner.set_sample_utterances(input);
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.inner = self.inner.dialog_code_hook(input);
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation with the bot.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_dialog_code_hook(input);
            self
        }
        /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.inner = self.inner.fulfillment_code_hook(input);
            self
        }
        /// <p>The new Lambda function to call when all of the intents required slots are provided and the intent is ready for fulfillment.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_fulfillment_code_hook(input);
            self
        }
        /// Appends an item to `slotPriorities`.
        ///
        /// To override the contents of this collection use [`set_slot_priorities`](Self::set_slot_priorities).
        ///
        /// <p>A new list of slots and their priorities that are contained by the intent.</p>
        pub fn slot_priorities(mut self, input: crate::model::SlotPriority) -> Self {
            self.inner = self.inner.slot_priorities(input);
            self
        }
        /// <p>A new list of slots and their priorities that are contained by the intent.</p>
        pub fn set_slot_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        ) -> Self {
            self.inner = self.inner.set_slot_priorities(input);
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.inner = self.inner.intent_confirmation_setting(input);
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_confirmation_setting(input);
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.inner = self.inner.intent_closing_setting(input);
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_closing_setting(input);
            self
        }
        /// Appends an item to `inputContexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            self.inner = self.inner.input_contexts(input);
            self
        }
        /// <p>A new list of contexts that must be active in order for Amazon Lex to consider the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.inner = self.inner.set_input_contexts(input);
            self
        }
        /// Appends an item to `outputContexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            self.inner = self.inner.output_contexts(input);
            self
        }
        /// <p>A new list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.inner = self.inner.set_output_contexts(input);
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.inner = self.inner.kendra_configuration(input);
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kendra_configuration(input);
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent. Must be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale where this intent is used. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourcePolicy`.
    ///
    /// <p>Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resource_policy_input::Builder,
    }
    impl UpdateResourcePolicy {
        /// Creates a new `UpdateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON structure that contains one or more statements that define the policy. The policy must follow the IAM syntax. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn expected_revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(input.into());
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this revision ID doesn't match the current revision ID, Amazon Lex throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSlot`.
    ///
    /// <p>Updates the settings for a slot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSlot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_slot_input::Builder,
    }
    impl UpdateSlot {
        /// Creates a new `UpdateSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSlotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the slot to update.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(input.into());
            self
        }
        /// <p>The unique identifier for the slot to update.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_name(input.into());
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_name(input);
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this slot. </p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(input.into());
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this slot. </p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.inner = self.inner.value_elicitation_setting(input);
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a response the provides a value for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_elicitation_setting(input);
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.inner = self.inner.obfuscation_setting(input);
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch logs. </p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.inner = self.inner.set_obfuscation_setting(input);
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that contains the slot. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.inner = self.inner.multiple_values_setting(input);
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response. Multiple value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other locale, Amazon Lex throws a <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.inner = self.inner.set_multiple_values_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSlotType`.
    ///
    /// <p>Updates the configuration of an existing slot type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSlotType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_slot_type_input::Builder,
    }
    impl UpdateSlotType {
        /// Creates a new `UpdateSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSlotTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(input.into());
            self
        }
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_name(input.into());
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_name(input);
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `slotTypeValues`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            self.inner = self.inner.slot_type_values(input);
            self
        }
        /// <p>A new list of values and their optional synonyms that define the values that the slot type can take.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_values(input);
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.inner = self.inner.value_selection_setting(input);
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the list of slot type values.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_selection_setting(input);
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_slot_type_signature(input.into());
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_slot_type_signature(input);
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(input.into());
            self
        }
        /// <p>The identifier of the language and locale that contains the slot type. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.inner = self.inner.external_source_setting(input);
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.inner = self.inner.set_external_source_setting(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
