// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSlotTypeOutput {
    /// <p>The unique identifier of the updated slot type.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The updated name of the slot type.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated values that the slot type provides.</p>
    pub slot_type_values: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
    /// <p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>
    pub value_selection_setting: std::option::Option<crate::model::SlotValueSelectionSetting>,
    /// <p>The updated signature of the built-in slot type that is the parent of this slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot that contains the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale of the updated slot type.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The timestamp of the date and time that the slot type was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the slot type was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub external_source_setting: std::option::Option<crate::model::ExternalSourceSetting>,
}
impl UpdateSlotTypeOutput {
    /// <p>The unique identifier of the updated slot type.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The updated name of the slot type.</p>
    pub fn slot_type_name(&self) -> std::option::Option<&str> {
        self.slot_type_name.as_deref()
    }
    /// <p>The updated description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated values that the slot type provides.</p>
    pub fn slot_type_values(&self) -> std::option::Option<&[crate::model::SlotTypeValue]> {
        self.slot_type_values.as_deref()
    }
    /// <p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>
    pub fn value_selection_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionSetting> {
        self.value_selection_setting.as_ref()
    }
    /// <p>The updated signature of the built-in slot type that is the parent of this slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>The identifier of the bot that contains the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale of the updated slot type.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The timestamp of the date and time that the slot type was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the slot type was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub fn external_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::ExternalSourceSetting> {
        self.external_source_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSlotTypeOutput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_values", &self.slot_type_values);
        formatter.field("value_selection_setting", &self.value_selection_setting);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("external_source_setting", &self.external_source_setting);
        formatter.finish()
    }
}
/// See [`UpdateSlotTypeOutput`](crate::output::UpdateSlotTypeOutput)
pub mod update_slot_type_output {
    /// A builder for [`UpdateSlotTypeOutput`](crate::output::UpdateSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_values:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        pub(crate) value_selection_setting:
            std::option::Option<crate::model::SlotValueSelectionSetting>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) external_source_setting:
            std::option::Option<crate::model::ExternalSourceSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the updated slot type.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the updated slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The updated name of the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The updated name of the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>The updated description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slot_type_values`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>The updated values that the slot type provides.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            let mut v = self.slot_type_values.unwrap_or_default();
            v.push(input);
            self.slot_type_values = Some(v);
            self
        }
        /// <p>The updated values that the slot type provides.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.slot_type_values = input;
            self
        }
        /// <p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.value_selection_setting = Some(input);
            self
        }
        /// <p>The updated strategy that Amazon Lex uses to determine which value to select from the slot type.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.value_selection_setting = input;
            self
        }
        /// <p>The updated signature of the built-in slot type that is the parent of this slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The updated signature of the built-in slot type that is the parent of this slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot type. This is always <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale of the updated slot type.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the updated slot type.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The timestamp of the date and time that the slot type was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the date and time that the slot type was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.external_source_setting = Some(input);
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.external_source_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSlotTypeOutput`](crate::output::UpdateSlotTypeOutput)
        pub fn build(self) -> crate::output::UpdateSlotTypeOutput {
            crate::output::UpdateSlotTypeOutput {
                slot_type_id: self.slot_type_id,
                slot_type_name: self.slot_type_name,
                description: self.description,
                slot_type_values: self.slot_type_values,
                value_selection_setting: self.value_selection_setting,
                parent_slot_type_signature: self.parent_slot_type_signature,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                external_source_setting: self.external_source_setting,
            }
        }
    }
}
impl UpdateSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSlotTypeOutput`](crate::output::UpdateSlotTypeOutput)
    pub fn builder() -> crate::output::update_slot_type_output::Builder {
        crate::output::update_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSlotOutput {
    /// <p>The unique identifier of the slot that was updated.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The updated name of the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated identifier of the slot type that provides values for the slot.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>
    pub value_elicitation_setting: std::option::Option<crate::model::SlotValueElicitationSetting>,
    /// <p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>The identifier of the bot that contains the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale that contains the slot.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The intent that contains the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The timestamp of the date and time that the slot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp of the date and time that the slot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the slot accepts multiple values in one response.</p>
    pub multiple_values_setting: std::option::Option<crate::model::MultipleValuesSetting>,
}
impl UpdateSlotOutput {
    /// <p>The unique identifier of the slot that was updated.</p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The updated name of the slot.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>The updated description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated identifier of the slot type that provides values for the slot.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>
    pub fn value_elicitation_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueElicitationSetting> {
        self.value_elicitation_setting.as_ref()
    }
    /// <p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>The identifier of the bot that contains the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale that contains the slot.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The intent that contains the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The timestamp of the date and time that the slot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The timestamp of the date and time that the slot was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Indicates whether the slot accepts multiple values in one response.</p>
    pub fn multiple_values_setting(
        &self,
    ) -> std::option::Option<&crate::model::MultipleValuesSetting> {
        self.multiple_values_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateSlotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSlotOutput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("value_elicitation_setting", &self.value_elicitation_setting);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("multiple_values_setting", &self.multiple_values_setting);
        formatter.finish()
    }
}
/// See [`UpdateSlotOutput`](crate::output::UpdateSlotOutput)
pub mod update_slot_output {
    /// A builder for [`UpdateSlotOutput`](crate::output::UpdateSlotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_setting:
            std::option::Option<crate::model::SlotValueElicitationSetting>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) multiple_values_setting:
            std::option::Option<crate::model::MultipleValuesSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the slot that was updated.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the slot that was updated.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The updated name of the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The updated name of the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>The updated description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated identifier of the slot type that provides values for the slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The updated identifier of the slot type that provides values for the slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.value_elicitation_setting = Some(input);
            self
        }
        /// <p>The updated prompts that Amazon Lex sends to the user to elicit a response that provides a value for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.value_elicitation_setting = input;
            self
        }
        /// <p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>The updated setting that determines whether the slot value is obfuscated in the Amazon CloudWatch logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the slot version that contains the slot. Will always be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale that contains the slot.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale that contains the slot.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The intent that contains the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The timestamp of the date and time that the slot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the date and time that the slot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The timestamp of the date and time that the slot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the date and time that the slot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Indicates whether the slot accepts multiple values in one response.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.multiple_values_setting = Some(input);
            self
        }
        /// <p>Indicates whether the slot accepts multiple values in one response.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.multiple_values_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSlotOutput`](crate::output::UpdateSlotOutput)
        pub fn build(self) -> crate::output::UpdateSlotOutput {
            crate::output::UpdateSlotOutput {
                slot_id: self.slot_id,
                slot_name: self.slot_name,
                description: self.description,
                slot_type_id: self.slot_type_id,
                value_elicitation_setting: self.value_elicitation_setting,
                obfuscation_setting: self.obfuscation_setting,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                multiple_values_setting: self.multiple_values_setting,
            }
        }
    }
}
impl UpdateSlotOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSlotOutput`](crate::output::UpdateSlotOutput)
    pub fn builder() -> crate::output::update_slot_output::Builder {
        crate::output::update_slot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl UpdateResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResourcePolicyOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`UpdateResourcePolicyOutput`](crate::output::UpdateResourcePolicyOutput)
pub mod update_resource_policy_output {
    /// A builder for [`UpdateResourcePolicyOutput`](crate::output::UpdateResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResourcePolicyOutput`](crate::output::UpdateResourcePolicyOutput)
        pub fn build(self) -> crate::output::UpdateResourcePolicyOutput {
            crate::output::UpdateResourcePolicyOutput {
                resource_arn: self.resource_arn,
                revision_id: self.revision_id,
            }
        }
    }
}
impl UpdateResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateResourcePolicyOutput`](crate::output::UpdateResourcePolicyOutput)
    pub fn builder() -> crate::output::update_resource_policy_output::Builder {
        crate::output::update_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIntentOutput {
    /// <p>The identifier of the intent that was updated.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The updated name of the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated built-in intent that is the parent of this intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The updated list of sample utterances for the intent.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>The updated Lambda function called during each turn of the conversation with the user.</p>
    pub dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
    /// <p>The updated Lambda function called when the intent is ready for fulfillment.</p>
    pub fulfillment_code_hook: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
    /// <p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>
    pub slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
    /// <p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    pub intent_confirmation_setting: std::option::Option<crate::model::IntentConfirmationSetting>,
    /// <p>The updated response that Amazon Lex sends the user when the intent is closed.</p>
    pub intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
    /// <p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>The identifier of the bot that contains the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The updated language and locale of the intent.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of when the intent was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the last time that the intent was modified.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateIntentOutput {
    /// <p>The identifier of the intent that was updated.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The updated name of the intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>The updated description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated built-in intent that is the parent of this intent.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>The updated list of sample utterances for the intent.</p>
    pub fn sample_utterances(&self) -> std::option::Option<&[crate::model::SampleUtterance]> {
        self.sample_utterances.as_deref()
    }
    /// <p>The updated Lambda function called during each turn of the conversation with the user.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::DialogCodeHookSettings> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>The updated Lambda function called when the intent is ready for fulfillment.</p>
    pub fn fulfillment_code_hook(
        &self,
    ) -> std::option::Option<&crate::model::FulfillmentCodeHookSettings> {
        self.fulfillment_code_hook.as_ref()
    }
    /// <p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>
    pub fn slot_priorities(&self) -> std::option::Option<&[crate::model::SlotPriority]> {
        self.slot_priorities.as_deref()
    }
    /// <p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
    pub fn intent_confirmation_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentConfirmationSetting> {
        self.intent_confirmation_setting.as_ref()
    }
    /// <p>The updated response that Amazon Lex sends the user when the intent is closed.</p>
    pub fn intent_closing_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentClosingSetting> {
        self.intent_closing_setting.as_ref()
    }
    /// <p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
    /// <p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>The identifier of the bot that contains the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The updated language and locale of the intent.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A timestamp of when the intent was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the last time that the intent was modified.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIntentOutput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_code_hook", &self.fulfillment_code_hook);
        formatter.field("slot_priorities", &self.slot_priorities);
        formatter.field(
            "intent_confirmation_setting",
            &self.intent_confirmation_setting,
        );
        formatter.field("intent_closing_setting", &self.intent_closing_setting);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`UpdateIntentOutput`](crate::output::UpdateIntentOutput)
pub mod update_intent_output {
    /// A builder for [`UpdateIntentOutput`](crate::output::UpdateIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
        pub(crate) fulfillment_code_hook:
            std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        pub(crate) slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        pub(crate) intent_confirmation_setting:
            std::option::Option<crate::model::IntentConfirmationSetting>,
        pub(crate) intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the intent that was updated.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent that was updated.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The updated name of the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The updated name of the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The updated description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated built-in intent that is the parent of this intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>The updated built-in intent that is the parent of this intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>The updated list of sample utterances for the intent.</p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input);
            self.sample_utterances = Some(v);
            self
        }
        /// <p>The updated list of sample utterances for the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>The updated Lambda function called during each turn of the conversation with the user.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>The updated Lambda function called during each turn of the conversation with the user.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>The updated Lambda function called when the intent is ready for fulfillment.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.fulfillment_code_hook = Some(input);
            self
        }
        /// <p>The updated Lambda function called when the intent is ready for fulfillment.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.fulfillment_code_hook = input;
            self
        }
        /// Appends an item to `slot_priorities`.
        ///
        /// To override the contents of this collection use [`set_slot_priorities`](Self::set_slot_priorities).
        ///
        /// <p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>
        pub fn slot_priorities(mut self, input: crate::model::SlotPriority) -> Self {
            let mut v = self.slot_priorities.unwrap_or_default();
            v.push(input);
            self.slot_priorities = Some(v);
            self
        }
        /// <p>The updated list of slots and their priorities that are elicited from the user for the intent.</p>
        pub fn set_slot_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        ) -> Self {
            self.slot_priorities = input;
            self
        }
        /// <p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.intent_confirmation_setting = Some(input);
            self
        }
        /// <p>The updated prompts that Amazon Lex sends to the user to confirm the completion of an intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.intent_confirmation_setting = input;
            self
        }
        /// <p>The updated response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.intent_closing_setting = Some(input);
            self
        }
        /// <p>The updated response that Amazon Lex sends the user when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.intent_closing_setting = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input);
            self.input_contexts = Some(v);
            self
        }
        /// <p>The updated list of contexts that must be active for the intent to be considered by Amazon Lex.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input);
            self.output_contexts = Some(v);
            self
        }
        /// <p>The updated list of contexts that Amazon Lex activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>The updated configuration for connecting to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent. Will always be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The updated language and locale of the intent.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The updated language and locale of the intent.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A timestamp of when the intent was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of when the intent was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the last time that the intent was modified.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the last time that the intent was modified.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIntentOutput`](crate::output::UpdateIntentOutput)
        pub fn build(self) -> crate::output::UpdateIntentOutput {
            crate::output::UpdateIntentOutput {
                intent_id: self.intent_id,
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                sample_utterances: self.sample_utterances,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_code_hook: self.fulfillment_code_hook,
                slot_priorities: self.slot_priorities,
                intent_confirmation_setting: self.intent_confirmation_setting,
                intent_closing_setting: self.intent_closing_setting,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                kendra_configuration: self.kendra_configuration,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl UpdateIntentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateIntentOutput`](crate::output::UpdateIntentOutput)
    pub fn builder() -> crate::output::update_intent_output::Builder {
        crate::output::update_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateExportOutput {
    /// <p>The unique identifier Amazon Lex assigned to the export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    pub resource_specification: std::option::Option<crate::model::ExportResourceSpecification>,
    /// <p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>
    pub file_format: std::option::Option<crate::model::ImportExportFileFormat>,
    /// <p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>The date and time that the export was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the export was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateExportOutput {
    /// <p>The unique identifier Amazon Lex assigned to the export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ExportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::ImportExportFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>The date and time that the export was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time that the export was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateExportOutput");
        formatter.field("export_id", &self.export_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("file_format", &self.file_format);
        formatter.field("export_status", &self.export_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`UpdateExportOutput`](crate::output::UpdateExportOutput)
pub mod update_export_output {
    /// A builder for [`UpdateExportOutput`](crate::output::UpdateExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ExportResourceSpecification>,
        pub(crate) file_format: std::option::Option<crate::model::ImportExportFileFormat>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file format used for the files that define the resource. The <code>TSV</code> format is required to export a custom vocabulary only; otherwise use <code>LexJson</code> format.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code> the export archive is available for download.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the export was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the export was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateExportOutput`](crate::output::UpdateExportOutput)
        pub fn build(self) -> crate::output::UpdateExportOutput {
            crate::output::UpdateExportOutput {
                export_id: self.export_id,
                resource_specification: self.resource_specification,
                file_format: self.file_format,
                export_status: self.export_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl UpdateExportOutput {
    /// Creates a new builder-style object to manufacture [`UpdateExportOutput`](crate::output::UpdateExportOutput)
    pub fn builder() -> crate::output::update_export_output::Builder {
        crate::output::update_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotRecommendationOutput {
    /// <p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the bot recommendation that has been updated.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of the bot recommendation.</p>
    /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub bot_recommendation_status: std::option::Option<crate::model::BotRecommendationStatus>,
    /// <p>The unique identifier of the bot recommendation to be updated.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the bot recommendation was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub transcript_source_setting: std::option::Option<crate::model::TranscriptSourceSetting>,
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
}
impl UpdateBotRecommendationOutput {
    /// <p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the bot recommendation that has been updated.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of the bot recommendation.</p>
    /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub fn bot_recommendation_status(
        &self,
    ) -> std::option::Option<&crate::model::BotRecommendationStatus> {
        self.bot_recommendation_status.as_ref()
    }
    /// <p>The unique identifier of the bot recommendation to be updated.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot recommendation was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub fn transcript_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::TranscriptSourceSetting> {
        self.transcript_source_setting.as_ref()
    }
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub fn encryption_setting(&self) -> std::option::Option<&crate::model::EncryptionSetting> {
        self.encryption_setting.as_ref()
    }
}
impl std::fmt::Debug for UpdateBotRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotRecommendationOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_status", &self.bot_recommendation_status);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("transcript_source_setting", &self.transcript_source_setting);
        formatter.field("encryption_setting", &self.encryption_setting);
        formatter.finish()
    }
}
/// See [`UpdateBotRecommendationOutput`](crate::output::UpdateBotRecommendationOutput)
pub mod update_bot_recommendation_output {
    /// A builder for [`UpdateBotRecommendationOutput`](crate::output::UpdateBotRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_status:
            std::option::Option<crate::model::BotRecommendationStatus>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transcript_source_setting:
            std::option::Option<crate::model::TranscriptSourceSetting>,
        pub(crate) encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation that has been updated.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the bot recommendation that has been updated.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation that has been updated.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to update. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of the bot recommendation.</p>
        /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn bot_recommendation_status(
            mut self,
            input: crate::model::BotRecommendationStatus,
        ) -> Self {
            self.bot_recommendation_status = Some(input);
            self
        }
        /// <p>The status of the bot recommendation.</p>
        /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn set_bot_recommendation_status(
            mut self,
            input: std::option::Option<crate::model::BotRecommendationStatus>,
        ) -> Self {
            self.bot_recommendation_status = input;
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot recommendation to be updated.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn transcript_source_setting(
            mut self,
            input: crate::model::TranscriptSourceSetting,
        ) -> Self {
            self.transcript_source_setting = Some(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn set_transcript_source_setting(
            mut self,
            input: std::option::Option<crate::model::TranscriptSourceSetting>,
        ) -> Self {
            self.transcript_source_setting = input;
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.encryption_setting = Some(input);
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.encryption_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotRecommendationOutput`](crate::output::UpdateBotRecommendationOutput)
        pub fn build(self) -> crate::output::UpdateBotRecommendationOutput {
            crate::output::UpdateBotRecommendationOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_status: self.bot_recommendation_status,
                bot_recommendation_id: self.bot_recommendation_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                transcript_source_setting: self.transcript_source_setting,
                encryption_setting: self.encryption_setting,
            }
        }
    }
}
impl UpdateBotRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBotRecommendationOutput`](crate::output::UpdateBotRecommendationOutput)
    pub fn builder() -> crate::output::update_bot_recommendation_output::Builder {
        crate::output::update_bot_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotLocaleOutput {
    /// <p>The identifier of the bot that contains the updated locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the updated locale.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale of the updated bot locale.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The updated locale name for the locale.</p>
    pub locale_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the locale.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The updated Amazon Polly voice to use for voice interaction with the user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
    /// <p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    /// <p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A timestamp of the date and time that the locale was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the locale was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    pub recommended_actions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateBotLocaleOutput {
    /// <p>The identifier of the bot that contains the updated locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the updated locale.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale of the updated bot locale.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The updated locale name for the locale.</p>
    pub fn locale_name(&self) -> std::option::Option<&str> {
        self.locale_name.as_deref()
    }
    /// <p>The updated description of the locale.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The updated Amazon Polly voice to use for voice interaction with the user.</p>
    pub fn voice_settings(&self) -> std::option::Option<&crate::model::VoiceSettings> {
        self.voice_settings.as_ref()
    }
    /// <p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>
    pub fn bot_locale_status(&self) -> std::option::Option<&crate::model::BotLocaleStatus> {
        self.bot_locale_status.as_ref()
    }
    /// <p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>A timestamp of the date and time that the locale was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the locale was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    pub fn recommended_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.recommended_actions.as_deref()
    }
}
impl std::fmt::Debug for UpdateBotLocaleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotLocaleOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("locale_name", &self.locale_name);
        formatter.field("description", &self.description);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("recommended_actions", &self.recommended_actions);
        formatter.finish()
    }
}
/// See [`UpdateBotLocaleOutput`](crate::output::UpdateBotLocaleOutput)
pub mod update_bot_locale_output {
    /// A builder for [`UpdateBotLocaleOutput`](crate::output::UpdateBotLocaleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) locale_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) recommended_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the updated locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the updated locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the updated locale.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the updated locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale of the updated bot locale.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the updated bot locale.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The updated locale name for the locale.</p>
        pub fn locale_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_name = Some(input.into());
            self
        }
        /// <p>The updated locale name for the locale.</p>
        pub fn set_locale_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_name = input;
            self
        }
        /// <p>The updated description of the locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The updated confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The updated Amazon Polly voice to use for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>The updated Amazon Polly voice to use for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// <p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The current status of the locale. When the bot status is <code>Built</code> the locale is ready for use.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If the <code>botLocaleStatus</code> is <code>Failed</code>, the <code>failureReasons</code> field lists the errors that occurred while building the bot.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>A timestamp of the date and time that the locale was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the locale was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the locale was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the locale was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Appends an item to `recommended_actions`.
        ///
        /// To override the contents of this collection use [`set_recommended_actions`](Self::set_recommended_actions).
        ///
        /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
        pub fn recommended_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommended_actions.unwrap_or_default();
            v.push(input.into());
            self.recommended_actions = Some(v);
            self
        }
        /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
        pub fn set_recommended_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommended_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotLocaleOutput`](crate::output::UpdateBotLocaleOutput)
        pub fn build(self) -> crate::output::UpdateBotLocaleOutput {
            crate::output::UpdateBotLocaleOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                locale_name: self.locale_name,
                description: self.description,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
                bot_locale_status: self.bot_locale_status,
                failure_reasons: self.failure_reasons,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                recommended_actions: self.recommended_actions,
            }
        }
    }
}
impl UpdateBotLocaleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBotLocaleOutput`](crate::output::UpdateBotLocaleOutput)
    pub fn builder() -> crate::output::update_bot_locale_output::Builder {
        crate::output::update_bot_locale_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotAliasOutput {
    /// <p>The identifier of the updated bot alias.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The updated name of the bot alias.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The updated version of the bot that the alias points to.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The updated Lambda functions to use in each locale for the bot alias.</p>
    pub bot_alias_locale_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    >,
    /// <p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    pub conversation_log_settings: std::option::Option<crate::model::ConversationLogSettings>,
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub sentiment_analysis_settings: std::option::Option<crate::model::SentimentAnalysisSettings>,
    /// <p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>
    pub bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
    /// <p>The identifier of the bot with the updated alias.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateBotAliasOutput {
    /// <p>The identifier of the updated bot alias.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The updated name of the bot alias.</p>
    pub fn bot_alias_name(&self) -> std::option::Option<&str> {
        self.bot_alias_name.as_deref()
    }
    /// <p>The updated description of the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The updated version of the bot that the alias points to.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The updated Lambda functions to use in each locale for the bot alias.</p>
    pub fn bot_alias_locale_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    > {
        self.bot_alias_locale_settings.as_ref()
    }
    /// <p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
    pub fn conversation_log_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogSettings> {
        self.conversation_log_settings.as_ref()
    }
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub fn sentiment_analysis_settings(
        &self,
    ) -> std::option::Option<&crate::model::SentimentAnalysisSettings> {
        self.sentiment_analysis_settings.as_ref()
    }
    /// <p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>
    pub fn bot_alias_status(&self) -> std::option::Option<&crate::model::BotAliasStatus> {
        self.bot_alias_status.as_ref()
    }
    /// <p>The identifier of the bot with the updated alias.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotAliasOutput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_locale_settings", &self.bot_alias_locale_settings);
        formatter.field("conversation_log_settings", &self.conversation_log_settings);
        formatter.field(
            "sentiment_analysis_settings",
            &self.sentiment_analysis_settings,
        );
        formatter.field("bot_alias_status", &self.bot_alias_status);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`UpdateBotAliasOutput`](crate::output::UpdateBotAliasOutput)
pub mod update_bot_alias_output {
    /// A builder for [`UpdateBotAliasOutput`](crate::output::UpdateBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_locale_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
        >,
        pub(crate) conversation_log_settings:
            std::option::Option<crate::model::ConversationLogSettings>,
        pub(crate) sentiment_analysis_settings:
            std::option::Option<crate::model::SentimentAnalysisSettings>,
        pub(crate) bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the updated bot alias.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the updated bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The updated name of the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The updated name of the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>The updated description of the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated description of the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The updated version of the bot that the alias points to.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The updated version of the bot that the alias points to.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_alias_locale_settings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>The updated Lambda functions to use in each locale for the bot alias.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            let mut hash_map = self.bot_alias_locale_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_alias_locale_settings = Some(hash_map);
            self
        }
        /// <p>The updated Lambda functions to use in each locale for the bot alias.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.bot_alias_locale_settings = input;
            self
        }
        /// <p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.conversation_log_settings = Some(input);
            self
        }
        /// <p>The updated settings for storing conversation logs in Amazon CloudWatch Logs and Amazon S3 buckets.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.conversation_log_settings = input;
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.sentiment_analysis_settings = Some(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.sentiment_analysis_settings = input;
            self
        }
        /// <p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>
        pub fn bot_alias_status(mut self, input: crate::model::BotAliasStatus) -> Self {
            self.bot_alias_status = Some(input);
            self
        }
        /// <p>The current status of the bot alias. When the status is <code>Available</code> the alias is ready for use.</p>
        pub fn set_bot_alias_status(
            mut self,
            input: std::option::Option<crate::model::BotAliasStatus>,
        ) -> Self {
            self.bot_alias_status = input;
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotAliasOutput`](crate::output::UpdateBotAliasOutput)
        pub fn build(self) -> crate::output::UpdateBotAliasOutput {
            crate::output::UpdateBotAliasOutput {
                bot_alias_id: self.bot_alias_id,
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_locale_settings: self.bot_alias_locale_settings,
                conversation_log_settings: self.conversation_log_settings,
                sentiment_analysis_settings: self.sentiment_analysis_settings,
                bot_alias_status: self.bot_alias_status,
                bot_id: self.bot_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl UpdateBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBotAliasOutput`](crate::output::UpdateBotAliasOutput)
    pub fn builder() -> crate::output::update_bot_alias_output::Builder {
        crate::output::update_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBotOutput {
    /// <p>The unique identifier of the bot that was updated.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot after the update.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot after the update.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The data privacy settings for the bot after the update.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The session timeout, in seconds, for the bot after the update.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateBotOutput {
    /// <p>The unique identifier of the bot that was updated.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The name of the bot after the update.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The description of the bot after the update.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The data privacy settings for the bot after the update.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The session timeout, in seconds, for the bot after the update.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBotOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_status", &self.bot_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`UpdateBotOutput`](crate::output::UpdateBotOutput)
pub mod update_bot_output {
    /// A builder for [`UpdateBotOutput`](crate::output::UpdateBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that was updated.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that was updated.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The name of the bot after the update.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot after the update.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The description of the bot after the update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot after the update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used by the bot after the update.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The data privacy settings for the bot after the update.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>The data privacy settings for the bot after the update.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The session timeout, in seconds, for the bot after the update.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The session timeout, in seconds, for the bot after the update.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>DRAFT</code> version of the bot.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBotOutput`](crate::output::UpdateBotOutput)
        pub fn build(self) -> crate::output::UpdateBotOutput {
            crate::output::UpdateBotOutput {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_status: self.bot_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl UpdateBotOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBotOutput`](crate::output::UpdateBotOutput)
    pub fn builder() -> crate::output::update_bot_output::Builder {
        crate::output::update_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportOutput {
    /// <p>A unique identifier for the import.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The parameters used when importing the resource.</p>
    pub resource_specification: std::option::Option<crate::model::ImportResourceSpecification>,
    /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
    /// <p>The date and time that the import request was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl StartImportOutput {
    /// <p>A unique identifier for the import.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>The parameters used when importing the resource.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ImportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>
    pub fn import_status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.import_status.as_ref()
    }
    /// <p>The date and time that the import request was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for StartImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportOutput");
        formatter.field("import_id", &self.import_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("import_status", &self.import_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`StartImportOutput`](crate::output::StartImportOutput)
pub mod start_import_output {
    /// A builder for [`StartImportOutput`](crate::output::StartImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ImportResourceSpecification>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the import.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the import.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The parameters used when importing the resource.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ImportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>The parameters used when importing the resource.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ImportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The current status of the import. When the status is <code>Complete</code> the bot, bot alias, or custom vocabulary is ready to use.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// <p>The date and time that the import request was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the import request was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportOutput`](crate::output::StartImportOutput)
        pub fn build(self) -> crate::output::StartImportOutput {
            crate::output::StartImportOutput {
                import_id: self.import_id,
                resource_specification: self.resource_specification,
                merge_strategy: self.merge_strategy,
                import_status: self.import_status,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl StartImportOutput {
    /// Creates a new builder-style object to manufacture [`StartImportOutput`](crate::output::StartImportOutput)
    pub fn builder() -> crate::output::start_import_output::Builder {
        crate::output::start_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBotRecommendationOutput {
    /// <p>The unique identifier of the bot containing the bot recommendation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the bot recommendation.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of the bot recommendation.</p>
    /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub bot_recommendation_status: std::option::Option<crate::model::BotRecommendationStatus>,
    /// <p>The identifier of the bot recommendation that you have created.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub transcript_source_setting: std::option::Option<crate::model::TranscriptSourceSetting>,
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
}
impl StartBotRecommendationOutput {
    /// <p>The unique identifier of the bot containing the bot recommendation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the bot recommendation.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of the bot recommendation.</p>
    /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub fn bot_recommendation_status(
        &self,
    ) -> std::option::Option<&crate::model::BotRecommendationStatus> {
        self.bot_recommendation_status.as_ref()
    }
    /// <p>The identifier of the bot recommendation that you have created.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub fn transcript_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::TranscriptSourceSetting> {
        self.transcript_source_setting.as_ref()
    }
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub fn encryption_setting(&self) -> std::option::Option<&crate::model::EncryptionSetting> {
        self.encryption_setting.as_ref()
    }
}
impl std::fmt::Debug for StartBotRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBotRecommendationOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_status", &self.bot_recommendation_status);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("transcript_source_setting", &self.transcript_source_setting);
        formatter.field("encryption_setting", &self.encryption_setting);
        formatter.finish()
    }
}
/// See [`StartBotRecommendationOutput`](crate::output::StartBotRecommendationOutput)
pub mod start_bot_recommendation_output {
    /// A builder for [`StartBotRecommendationOutput`](crate::output::StartBotRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_status:
            std::option::Option<crate::model::BotRecommendationStatus>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transcript_source_setting:
            std::option::Option<crate::model::TranscriptSourceSetting>,
        pub(crate) encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot containing the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to start. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of the bot recommendation.</p>
        /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn bot_recommendation_status(
            mut self,
            input: crate::model::BotRecommendationStatus,
        ) -> Self {
            self.bot_recommendation_status = Some(input);
            self
        }
        /// <p>The status of the bot recommendation.</p>
        /// <p>If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn set_bot_recommendation_status(
            mut self,
            input: std::option::Option<crate::model::BotRecommendationStatus>,
        ) -> Self {
            self.bot_recommendation_status = input;
            self
        }
        /// <p>The identifier of the bot recommendation that you have created.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation that you have created.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot recommendation was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn transcript_source_setting(
            mut self,
            input: crate::model::TranscriptSourceSetting,
        ) -> Self {
            self.transcript_source_setting = Some(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn set_transcript_source_setting(
            mut self,
            input: std::option::Option<crate::model::TranscriptSourceSetting>,
        ) -> Self {
            self.transcript_source_setting = input;
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.encryption_setting = Some(input);
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.encryption_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBotRecommendationOutput`](crate::output::StartBotRecommendationOutput)
        pub fn build(self) -> crate::output::StartBotRecommendationOutput {
            crate::output::StartBotRecommendationOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_status: self.bot_recommendation_status,
                bot_recommendation_id: self.bot_recommendation_id,
                creation_date_time: self.creation_date_time,
                transcript_source_setting: self.transcript_source_setting,
                encryption_setting: self.encryption_setting,
            }
        }
    }
}
impl StartBotRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`StartBotRecommendationOutput`](crate::output::StartBotRecommendationOutput)
    pub fn builder() -> crate::output::start_bot_recommendation_output::Builder {
        crate::output::start_bot_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchAssociatedTranscriptsOutput {
    /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot containing the transcripts that you are searching.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>
    pub next_index: std::option::Option<i32>,
    /// <p>The object that contains the associated transcript that meet the criteria you specified.</p>
    pub associated_transcripts:
        std::option::Option<std::vec::Vec<crate::model::AssociatedTranscript>>,
    /// <p>The total number of transcripts returned by the search.</p>
    pub total_results: std::option::Option<i32>,
}
impl SearchAssociatedTranscriptsOutput {
    /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot containing the transcripts that you are searching.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>
    pub fn next_index(&self) -> std::option::Option<i32> {
        self.next_index
    }
    /// <p>The object that contains the associated transcript that meet the criteria you specified.</p>
    pub fn associated_transcripts(
        &self,
    ) -> std::option::Option<&[crate::model::AssociatedTranscript]> {
        self.associated_transcripts.as_deref()
    }
    /// <p>The total number of transcripts returned by the search.</p>
    pub fn total_results(&self) -> std::option::Option<i32> {
        self.total_results
    }
}
impl std::fmt::Debug for SearchAssociatedTranscriptsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchAssociatedTranscriptsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("next_index", &self.next_index);
        formatter.field("associated_transcripts", &self.associated_transcripts);
        formatter.field("total_results", &self.total_results);
        formatter.finish()
    }
}
/// See [`SearchAssociatedTranscriptsOutput`](crate::output::SearchAssociatedTranscriptsOutput)
pub mod search_associated_transcripts_output {
    /// A builder for [`SearchAssociatedTranscriptsOutput`](crate::output::SearchAssociatedTranscriptsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) next_index: std::option::Option<i32>,
        pub(crate) associated_transcripts:
            std::option::Option<std::vec::Vec<crate::model::AssociatedTranscript>>,
        pub(crate) total_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the transcripts that you are searching.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot containing the transcripts that you are searching.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the transcripts to search. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the bot recommendation associated with the transcripts to search.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// <p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>
        pub fn next_index(mut self, input: i32) -> Self {
            self.next_index = Some(input);
            self
        }
        /// <p>A index that indicates whether there are more results to return in a response to the SearchAssociatedTranscripts operation. If the nextIndex field is present, you send the contents as the nextIndex parameter of a SearchAssociatedTranscriptsRequest operation to get the next page of results.</p>
        pub fn set_next_index(mut self, input: std::option::Option<i32>) -> Self {
            self.next_index = input;
            self
        }
        /// Appends an item to `associated_transcripts`.
        ///
        /// To override the contents of this collection use [`set_associated_transcripts`](Self::set_associated_transcripts).
        ///
        /// <p>The object that contains the associated transcript that meet the criteria you specified.</p>
        pub fn associated_transcripts(mut self, input: crate::model::AssociatedTranscript) -> Self {
            let mut v = self.associated_transcripts.unwrap_or_default();
            v.push(input);
            self.associated_transcripts = Some(v);
            self
        }
        /// <p>The object that contains the associated transcript that meet the criteria you specified.</p>
        pub fn set_associated_transcripts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssociatedTranscript>>,
        ) -> Self {
            self.associated_transcripts = input;
            self
        }
        /// <p>The total number of transcripts returned by the search.</p>
        pub fn total_results(mut self, input: i32) -> Self {
            self.total_results = Some(input);
            self
        }
        /// <p>The total number of transcripts returned by the search.</p>
        pub fn set_total_results(mut self, input: std::option::Option<i32>) -> Self {
            self.total_results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchAssociatedTranscriptsOutput`](crate::output::SearchAssociatedTranscriptsOutput)
        pub fn build(self) -> crate::output::SearchAssociatedTranscriptsOutput {
            crate::output::SearchAssociatedTranscriptsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
                next_index: self.next_index,
                associated_transcripts: self.associated_transcripts,
                total_results: self.total_results,
            }
        }
    }
}
impl SearchAssociatedTranscriptsOutput {
    /// Creates a new builder-style object to manufacture [`SearchAssociatedTranscriptsOutput`](crate::output::SearchAssociatedTranscriptsOutput)
    pub fn builder() -> crate::output::search_associated_transcripts_output::Builder {
        crate::output::search_associated_transcripts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags associated with a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags associated with a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSlotTypesOutput {
    /// <p>The identifier of the bot that contains the slot types.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slot types.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and local of the slot types in the list.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub slot_type_summaries: std::option::Option<std::vec::Vec<crate::model::SlotTypeSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSlotTypesOutput {
    /// <p>The identifier of the bot that contains the slot types.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slot types.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and local of the slot types in the list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn slot_type_summaries(&self) -> std::option::Option<&[crate::model::SlotTypeSummary]> {
        self.slot_type_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSlotTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSlotTypesOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("slot_type_summaries", &self.slot_type_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSlotTypesOutput`](crate::output::ListSlotTypesOutput)
pub mod list_slot_types_output {
    /// A builder for [`ListSlotTypesOutput`](crate::output::ListSlotTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_summaries:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the slot types.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slot types.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slot types.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slot types.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and local of the slot types in the list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and local of the slot types in the list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Appends an item to `slot_type_summaries`.
        ///
        /// To override the contents of this collection use [`set_slot_type_summaries`](Self::set_slot_type_summaries).
        ///
        /// <p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn slot_type_summaries(mut self, input: crate::model::SlotTypeSummary) -> Self {
            let mut v = self.slot_type_summaries.unwrap_or_default();
            v.push(input);
            self.slot_type_summaries = Some(v);
            self
        }
        /// <p>Summary information for the slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_slot_type_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeSummary>>,
        ) -> Self {
            self.slot_type_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlotTypes</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSlotTypesOutput`](crate::output::ListSlotTypesOutput)
        pub fn build(self) -> crate::output::ListSlotTypesOutput {
            crate::output::ListSlotTypesOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                slot_type_summaries: self.slot_type_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSlotTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListSlotTypesOutput`](crate::output::ListSlotTypesOutput)
    pub fn builder() -> crate::output::list_slot_types_output::Builder {
        crate::output::list_slot_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSlotsOutput {
    /// <p>The identifier of the bot that contains the slots.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the slots.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale of the slots in the list.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent that contains the slots.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub slot_summaries: std::option::Option<std::vec::Vec<crate::model::SlotSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListSlotsOutput {
    /// <p>The identifier of the bot that contains the slots.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the slots.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale of the slots in the list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent that contains the slots.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn slot_summaries(&self) -> std::option::Option<&[crate::model::SlotSummary]> {
        self.slot_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListSlotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSlotsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("slot_summaries", &self.slot_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListSlotsOutput`](crate::output::ListSlotsOutput)
pub mod list_slots_output {
    /// A builder for [`ListSlotsOutput`](crate::output::ListSlotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) slot_summaries: std::option::Option<std::vec::Vec<crate::model::SlotSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the slots.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the slots.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the slots.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the slots.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale of the slots in the list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the slots in the list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent that contains the slots.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent that contains the slots.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// Appends an item to `slot_summaries`.
        ///
        /// To override the contents of this collection use [`set_slot_summaries`](Self::set_slot_summaries).
        ///
        /// <p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn slot_summaries(mut self, input: crate::model::SlotSummary) -> Self {
            let mut v = self.slot_summaries.unwrap_or_default();
            v.push(input);
            self.slot_summaries = Some(v);
            self
        }
        /// <p>Summary information for the slots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slots available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_slot_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotSummary>>,
        ) -> Self {
            self.slot_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListSlots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListSlots</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSlotsOutput`](crate::output::ListSlotsOutput)
        pub fn build(self) -> crate::output::ListSlotsOutput {
            crate::output::ListSlotsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                slot_summaries: self.slot_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListSlotsOutput {
    /// Creates a new builder-style object to manufacture [`ListSlotsOutput`](crate::output::ListSlotsOutput)
    pub fn builder() -> crate::output::list_slots_output::Builder {
        crate::output::list_slots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRecommendedIntentsOutput {
    /// <p>The unique identifier of the bot associated with the recommended intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot recommendation that contains the recommended intent.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>
    pub summary_list: std::option::Option<std::vec::Vec<crate::model::RecommendedIntentSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRecommendedIntentsOutput {
    /// <p>The unique identifier of the bot associated with the recommended intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the bot recommendation that contains the recommended intent.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>
    pub fn summary_list(&self) -> std::option::Option<&[crate::model::RecommendedIntentSummary]> {
        self.summary_list.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRecommendedIntentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRecommendedIntentsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("summary_list", &self.summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRecommendedIntentsOutput`](crate::output::ListRecommendedIntentsOutput)
pub mod list_recommended_intents_output {
    /// A builder for [`ListRecommendedIntentsOutput`](crate::output::ListRecommendedIntentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) summary_list:
            std::option::Option<std::vec::Vec<crate::model::RecommendedIntentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot associated with the recommended intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the recommended intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the intents to list. The string must match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intent.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation that contains the recommended intent.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// Appends an item to `summary_list`.
        ///
        /// To override the contents of this collection use [`set_summary_list`](Self::set_summary_list).
        ///
        /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>
        pub fn summary_list(mut self, input: crate::model::RecommendedIntentSummary) -> Self {
            let mut v = self.summary_list.unwrap_or_default();
            v.push(input);
            self.summary_list = Some(v);
            self
        }
        /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the maxResults parameter of the request. If there are more intents available, the nextToken field contains a token to get the next page of results.</p>
        pub fn set_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecommendedIntentSummary>>,
        ) -> Self {
            self.summary_list = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the ListRecommendedIntents operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListRecommendedIntents operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRecommendedIntentsOutput`](crate::output::ListRecommendedIntentsOutput)
        pub fn build(self) -> crate::output::ListRecommendedIntentsOutput {
            crate::output::ListRecommendedIntentsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_id: self.bot_recommendation_id,
                summary_list: self.summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRecommendedIntentsOutput {
    /// Creates a new builder-style object to manufacture [`ListRecommendedIntentsOutput`](crate::output::ListRecommendedIntentsOutput)
    pub fn builder() -> crate::output::list_recommended_intents_output::Builder {
        crate::output::list_recommended_intents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIntentsOutput {
    /// <p>The identifier of the bot that contains the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale of the intents in the list.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub intent_summaries: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIntentsOutput {
    /// <p>The identifier of the bot that contains the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale of the intents in the list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn intent_summaries(&self) -> std::option::Option<&[crate::model::IntentSummary]> {
        self.intent_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIntentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIntentsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_summaries", &self.intent_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIntentsOutput`](crate::output::ListIntentsOutput)
pub mod list_intents_output {
    /// A builder for [`ListIntentsOutput`](crate::output::ListIntentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_summaries:
            std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale of the intents in the list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the intents in the list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Appends an item to `intent_summaries`.
        ///
        /// To override the contents of this collection use [`set_intent_summaries`](Self::set_intent_summaries).
        ///
        /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn intent_summaries(mut self, input: crate::model::IntentSummary) -> Self {
            let mut v = self.intent_summaries.unwrap_or_default();
            v.push(input);
            self.intent_summaries = Some(v);
            self
        }
        /// <p>Summary information for the intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_intent_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentSummary>>,
        ) -> Self {
            self.intent_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListIntents</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntentsOutput`](crate::output::ListIntentsOutput)
        pub fn build(self) -> crate::output::ListIntentsOutput {
            crate::output::ListIntentsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_summaries: self.intent_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIntentsOutput {
    /// Creates a new builder-style object to manufacture [`ListIntentsOutput`](crate::output::ListIntentsOutput)
    pub fn builder() -> crate::output::list_intents_output::Builder {
        crate::output::list_intents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImportsOutput {
    /// <p>The unique identifier assigned by Amazon Lex to the bot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub import_summaries: std::option::Option<std::vec::Vec<crate::model::ImportSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The locale specified in the request.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListImportsOutput {
    /// <p>The unique identifier assigned by Amazon Lex to the bot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn import_summaries(&self) -> std::option::Option<&[crate::model::ImportSummary]> {
        self.import_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The locale specified in the request.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListImportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImportsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("import_summaries", &self.import_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
/// See [`ListImportsOutput`](crate::output::ListImportsOutput)
pub mod list_imports_output {
    /// A builder for [`ListImportsOutput`](crate::output::ListImportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) import_summaries:
            std::option::Option<std::vec::Vec<crate::model::ImportSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier assigned by Amazon Lex to the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned by Amazon Lex to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that was imported. It will always be <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Appends an item to `import_summaries`.
        ///
        /// To override the contents of this collection use [`set_import_summaries`](Self::set_import_summaries).
        ///
        /// <p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn import_summaries(mut self, input: crate::model::ImportSummary) -> Self {
            let mut v = self.import_summaries.unwrap_or_default();
            v.push(input);
            self.import_summaries = Some(v);
            self
        }
        /// <p>Summary information for the imports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more imports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_import_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportSummary>>,
        ) -> Self {
            self.import_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListImports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListImports</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The locale specified in the request.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale specified in the request.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImportsOutput`](crate::output::ListImportsOutput)
        pub fn build(self) -> crate::output::ListImportsOutput {
            crate::output::ListImportsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                import_summaries: self.import_summaries,
                next_token: self.next_token,
                locale_id: self.locale_id,
            }
        }
    }
}
impl ListImportsOutput {
    /// Creates a new builder-style object to manufacture [`ListImportsOutput`](crate::output::ListImportsOutput)
    pub fn builder() -> crate::output::list_imports_output::Builder {
        crate::output::list_imports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListExportsOutput {
    /// <p>The unique identifier assigned to the bot by Amazon Lex.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that was exported.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub export_summaries: std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The locale specified in the request.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListExportsOutput {
    /// <p>The unique identifier assigned to the bot by Amazon Lex.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that was exported.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn export_summaries(&self) -> std::option::Option<&[crate::model::ExportSummary]> {
        self.export_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The locale specified in the request.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListExportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListExportsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("export_summaries", &self.export_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
/// See [`ListExportsOutput`](crate::output::ListExportsOutput)
pub mod list_exports_output {
    /// A builder for [`ListExportsOutput`](crate::output::ListExportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) export_summaries:
            std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the bot by Amazon Lex.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the bot by Amazon Lex.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that was exported.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that was exported.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Appends an item to `export_summaries`.
        ///
        /// To override the contents of this collection use [`set_export_summaries`](Self::set_export_summaries).
        ///
        /// <p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn export_summaries(mut self, input: crate::model::ExportSummary) -> Self {
            let mut v = self.export_summaries.unwrap_or_default();
            v.push(input);
            self.export_summaries = Some(v);
            self
        }
        /// <p>Summary information for the exports that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter. If there are more exports available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_export_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportSummary>>,
        ) -> Self {
            self.export_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListExports</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListExports</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The locale specified in the request.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale specified in the request.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListExportsOutput`](crate::output::ListExportsOutput)
        pub fn build(self) -> crate::output::ListExportsOutput {
            crate::output::ListExportsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                export_summaries: self.export_summaries,
                next_token: self.next_token,
                locale_id: self.locale_id,
            }
        }
    }
}
impl ListExportsOutput {
    /// Creates a new builder-style object to manufacture [`ListExportsOutput`](crate::output::ListExportsOutput)
    pub fn builder() -> crate::output::list_exports_output::Builder {
        crate::output::list_exports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuiltInSlotTypesOutput {
    /// <p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub built_in_slot_type_summaries:
        std::option::Option<std::vec::Vec<crate::model::BuiltInSlotTypeSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The language and locale of the slot types in the list.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListBuiltInSlotTypesOutput {
    /// <p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn built_in_slot_type_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::BuiltInSlotTypeSummary]> {
        self.built_in_slot_type_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The language and locale of the slot types in the list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListBuiltInSlotTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuiltInSlotTypesOutput");
        formatter.field(
            "built_in_slot_type_summaries",
            &self.built_in_slot_type_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
/// See [`ListBuiltInSlotTypesOutput`](crate::output::ListBuiltInSlotTypesOutput)
pub mod list_built_in_slot_types_output {
    /// A builder for [`ListBuiltInSlotTypesOutput`](crate::output::ListBuiltInSlotTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) built_in_slot_type_summaries:
            std::option::Option<std::vec::Vec<crate::model::BuiltInSlotTypeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `built_in_slot_type_summaries`.
        ///
        /// To override the contents of this collection use [`set_built_in_slot_type_summaries`](Self::set_built_in_slot_type_summaries).
        ///
        /// <p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn built_in_slot_type_summaries(
            mut self,
            input: crate::model::BuiltInSlotTypeSummary,
        ) -> Self {
            let mut v = self.built_in_slot_type_summaries.unwrap_or_default();
            v.push(input);
            self.built_in_slot_type_summaries = Some(v);
            self
        }
        /// <p>Summary information for the built-in slot types that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more slot types available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_built_in_slot_type_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuiltInSlotTypeSummary>>,
        ) -> Self {
            self.built_in_slot_type_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInSlotTypes</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>LIstBuiltInSlotTypes</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The language and locale of the slot types in the list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the slot types in the list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuiltInSlotTypesOutput`](crate::output::ListBuiltInSlotTypesOutput)
        pub fn build(self) -> crate::output::ListBuiltInSlotTypesOutput {
            crate::output::ListBuiltInSlotTypesOutput {
                built_in_slot_type_summaries: self.built_in_slot_type_summaries,
                next_token: self.next_token,
                locale_id: self.locale_id,
            }
        }
    }
}
impl ListBuiltInSlotTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListBuiltInSlotTypesOutput`](crate::output::ListBuiltInSlotTypesOutput)
    pub fn builder() -> crate::output::list_built_in_slot_types_output::Builder {
        crate::output::list_built_in_slot_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuiltInIntentsOutput {
    /// <p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub built_in_intent_summaries:
        std::option::Option<std::vec::Vec<crate::model::BuiltInIntentSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The language and locale of the intents in the list.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl ListBuiltInIntentsOutput {
    /// <p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn built_in_intent_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::BuiltInIntentSummary]> {
        self.built_in_intent_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The language and locale of the intents in the list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
}
impl std::fmt::Debug for ListBuiltInIntentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuiltInIntentsOutput");
        formatter.field("built_in_intent_summaries", &self.built_in_intent_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
/// See [`ListBuiltInIntentsOutput`](crate::output::ListBuiltInIntentsOutput)
pub mod list_built_in_intents_output {
    /// A builder for [`ListBuiltInIntentsOutput`](crate::output::ListBuiltInIntentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) built_in_intent_summaries:
            std::option::Option<std::vec::Vec<crate::model::BuiltInIntentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `built_in_intent_summaries`.
        ///
        /// To override the contents of this collection use [`set_built_in_intent_summaries`](Self::set_built_in_intent_summaries).
        ///
        /// <p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn built_in_intent_summaries(
            mut self,
            input: crate::model::BuiltInIntentSummary,
        ) -> Self {
            let mut v = self.built_in_intent_summaries.unwrap_or_default();
            v.push(input);
            self.built_in_intent_summaries = Some(v);
            self
        }
        /// <p>Summary information for the built-in intents that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more intents available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_built_in_intent_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuiltInIntentSummary>>,
        ) -> Self {
            self.built_in_intent_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBuiltInIntents</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The language and locale of the intents in the list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the intents in the list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuiltInIntentsOutput`](crate::output::ListBuiltInIntentsOutput)
        pub fn build(self) -> crate::output::ListBuiltInIntentsOutput {
            crate::output::ListBuiltInIntentsOutput {
                built_in_intent_summaries: self.built_in_intent_summaries,
                next_token: self.next_token,
                locale_id: self.locale_id,
            }
        }
    }
}
impl ListBuiltInIntentsOutput {
    /// Creates a new builder-style object to manufacture [`ListBuiltInIntentsOutput`](crate::output::ListBuiltInIntentsOutput)
    pub fn builder() -> crate::output::list_built_in_intents_output::Builder {
        crate::output::list_built_in_intents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotVersionsOutput {
    /// <p>The identifier of the bot to list versions for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub bot_version_summaries: std::option::Option<std::vec::Vec<crate::model::BotVersionSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotVersionsOutput {
    /// <p>The identifier of the bot to list versions for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn bot_version_summaries(&self) -> std::option::Option<&[crate::model::BotVersionSummary]> {
        self.bot_version_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotVersionsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version_summaries", &self.bot_version_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBotVersionsOutput`](crate::output::ListBotVersionsOutput)
pub mod list_bot_versions_output {
    /// A builder for [`ListBotVersionsOutput`](crate::output::ListBotVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version_summaries:
            std::option::Option<std::vec::Vec<crate::model::BotVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Appends an item to `bot_version_summaries`.
        ///
        /// To override the contents of this collection use [`set_bot_version_summaries`](Self::set_bot_version_summaries).
        ///
        /// <p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn bot_version_summaries(mut self, input: crate::model::BotVersionSummary) -> Self {
            let mut v = self.bot_version_summaries.unwrap_or_default();
            v.push(input);
            self.bot_version_summaries = Some(v);
            self
        }
        /// <p>Summary information for the bot versions that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more versions available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_bot_version_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotVersionSummary>>,
        ) -> Self {
            self.bot_version_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotVersions</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotVersionsOutput`](crate::output::ListBotVersionsOutput)
        pub fn build(self) -> crate::output::ListBotVersionsOutput {
            crate::output::ListBotVersionsOutput {
                bot_id: self.bot_id,
                bot_version_summaries: self.bot_version_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBotVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListBotVersionsOutput`](crate::output::ListBotVersionsOutput)
    pub fn builder() -> crate::output::list_bot_versions_output::Builder {
        crate::output::list_bot_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotsOutput {
    /// <p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>
    pub bot_summaries: std::option::Option<std::vec::Vec<crate::model::BotSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotsOutput {
    /// <p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>
    pub fn bot_summaries(&self) -> std::option::Option<&[crate::model::BotSummary]> {
        self.bot_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotsOutput");
        formatter.field("bot_summaries", &self.bot_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBotsOutput`](crate::output::ListBotsOutput)
pub mod list_bots_output {
    /// A builder for [`ListBotsOutput`](crate::output::ListBotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_summaries: std::option::Option<std::vec::Vec<crate::model::BotSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bot_summaries`.
        ///
        /// To override the contents of this collection use [`set_bot_summaries`](Self::set_bot_summaries).
        ///
        /// <p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>
        pub fn bot_summaries(mut self, input: crate::model::BotSummary) -> Self {
            let mut v = self.bot_summaries.unwrap_or_default();
            v.push(input);
            self.bot_summaries = Some(v);
            self
        }
        /// <p>Summary information for the bots that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more bots available, the <code>nextToken</code> field contains a token to the next page of results.</p>
        pub fn set_bot_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotSummary>>,
        ) -> Self {
            self.bot_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBots</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBots</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotsOutput`](crate::output::ListBotsOutput)
        pub fn build(self) -> crate::output::ListBotsOutput {
            crate::output::ListBotsOutput {
                bot_summaries: self.bot_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBotsOutput {
    /// Creates a new builder-style object to manufacture [`ListBotsOutput`](crate::output::ListBotsOutput)
    pub fn builder() -> crate::output::list_bots_output::Builder {
        crate::output::list_bots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotRecommendationsOutput {
    /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the bot recommendation list.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation list.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>
    pub bot_recommendation_summaries:
        std::option::Option<std::vec::Vec<crate::model::BotRecommendationSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBotRecommendationsOutput {
    /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the bot recommendation list.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation list.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>
    pub fn bot_recommendation_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::BotRecommendationSummary]> {
        self.bot_recommendation_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBotRecommendationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotRecommendationsOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field(
            "bot_recommendation_summaries",
            &self.bot_recommendation_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBotRecommendationsOutput`](crate::output::ListBotRecommendationsOutput)
pub mod list_bot_recommendations_output {
    /// A builder for [`ListBotRecommendationsOutput`](crate::output::ListBotRecommendationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_summaries:
            std::option::Option<std::vec::Vec<crate::model::BotRecommendationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the bot recommendation list.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation list.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Appends an item to `bot_recommendation_summaries`.
        ///
        /// To override the contents of this collection use [`set_bot_recommendation_summaries`](Self::set_bot_recommendation_summaries).
        ///
        /// <p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>
        pub fn bot_recommendation_summaries(
            mut self,
            input: crate::model::BotRecommendationSummary,
        ) -> Self {
            let mut v = self.bot_recommendation_summaries.unwrap_or_default();
            v.push(input);
            self.bot_recommendation_summaries = Some(v);
            self
        }
        /// <p>Summary information for the bot recommendations that meet the filter specified in this request. The length of the list is specified in the maxResults parameter of the request. If there are more bot recommendations available, the nextToken field contains a token to get the next page of results.</p>
        pub fn set_bot_recommendation_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotRecommendationSummary>>,
        ) -> Self {
            self.bot_recommendation_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the ListBotRecommendations operation. If the nextToken field is present, you send the contents as the nextToken parameter of a ListBotRecommendations operation request to get the next page of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotRecommendationsOutput`](crate::output::ListBotRecommendationsOutput)
        pub fn build(self) -> crate::output::ListBotRecommendationsOutput {
            crate::output::ListBotRecommendationsOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_summaries: self.bot_recommendation_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBotRecommendationsOutput {
    /// Creates a new builder-style object to manufacture [`ListBotRecommendationsOutput`](crate::output::ListBotRecommendationsOutput)
    pub fn builder() -> crate::output::list_bot_recommendations_output::Builder {
        crate::output::list_bot_recommendations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotLocalesOutput {
    /// <p>The identifier of the bot to list locales for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub bot_locale_summaries: std::option::Option<std::vec::Vec<crate::model::BotLocaleSummary>>,
}
impl ListBotLocalesOutput {
    /// <p>The identifier of the bot to list locales for.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn bot_locale_summaries(&self) -> std::option::Option<&[crate::model::BotLocaleSummary]> {
        self.bot_locale_summaries.as_deref()
    }
}
impl std::fmt::Debug for ListBotLocalesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotLocalesOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("next_token", &self.next_token);
        formatter.field("bot_locale_summaries", &self.bot_locale_summaries);
        formatter.finish()
    }
}
/// See [`ListBotLocalesOutput`](crate::output::ListBotLocalesOutput)
pub mod list_bot_locales_output {
    /// A builder for [`ListBotLocalesOutput`](crate::output::ListBotLocalesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) bot_locale_summaries:
            std::option::Option<std::vec::Vec<crate::model::BotLocaleSummary>>,
    }
    impl Builder {
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotLocales</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotLocales</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `bot_locale_summaries`.
        ///
        /// To override the contents of this collection use [`set_bot_locale_summaries`](Self::set_bot_locale_summaries).
        ///
        /// <p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn bot_locale_summaries(mut self, input: crate::model::BotLocaleSummary) -> Self {
            let mut v = self.bot_locale_summaries.unwrap_or_default();
            v.push(input);
            self.bot_locale_summaries = Some(v);
            self
        }
        /// <p>Summary information for the locales that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more locales available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_bot_locale_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotLocaleSummary>>,
        ) -> Self {
            self.bot_locale_summaries = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotLocalesOutput`](crate::output::ListBotLocalesOutput)
        pub fn build(self) -> crate::output::ListBotLocalesOutput {
            crate::output::ListBotLocalesOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                next_token: self.next_token,
                bot_locale_summaries: self.bot_locale_summaries,
            }
        }
    }
}
impl ListBotLocalesOutput {
    /// Creates a new builder-style object to manufacture [`ListBotLocalesOutput`](crate::output::ListBotLocalesOutput)
    pub fn builder() -> crate::output::list_bot_locales_output::Builder {
        crate::output::list_bot_locales_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBotAliasesOutput {
    /// <p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub bot_alias_summaries: std::option::Option<std::vec::Vec<crate::model::BotAliasSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the aliases.</p>
    pub bot_id: std::option::Option<std::string::String>,
}
impl ListBotAliasesOutput {
    /// <p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
    pub fn bot_alias_summaries(&self) -> std::option::Option<&[crate::model::BotAliasSummary]> {
        self.bot_alias_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The identifier of the bot associated with the aliases.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
}
impl std::fmt::Debug for ListBotAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBotAliasesOutput");
        formatter.field("bot_alias_summaries", &self.bot_alias_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.field("bot_id", &self.bot_id);
        formatter.finish()
    }
}
/// See [`ListBotAliasesOutput`](crate::output::ListBotAliasesOutput)
pub mod list_bot_aliases_output {
    /// A builder for [`ListBotAliasesOutput`](crate::output::ListBotAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_summaries:
            std::option::Option<std::vec::Vec<crate::model::BotAliasSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bot_alias_summaries`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_summaries`](Self::set_bot_alias_summaries).
        ///
        /// <p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn bot_alias_summaries(mut self, input: crate::model::BotAliasSummary) -> Self {
            let mut v = self.bot_alias_summaries.unwrap_or_default();
            v.push(input);
            self.bot_alias_summaries = Some(v);
            self
        }
        /// <p>Summary information for the bot aliases that meet the filter criteria specified in the request. The length of the list is specified in the <code>maxResults</code> parameter of the request. If there are more aliases available, the <code>nextToken</code> field contains a token to get the next page of results.</p>
        pub fn set_bot_alias_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotAliasSummary>>,
        ) -> Self {
            self.bot_alias_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListBotAliases</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListBotAliases</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The identifier of the bot associated with the aliases.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the aliases.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotAliasesOutput`](crate::output::ListBotAliasesOutput)
        pub fn build(self) -> crate::output::ListBotAliasesOutput {
            crate::output::ListBotAliasesOutput {
                bot_alias_summaries: self.bot_alias_summaries,
                next_token: self.next_token,
                bot_id: self.bot_id,
            }
        }
    }
}
impl ListBotAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListBotAliasesOutput`](crate::output::ListBotAliasesOutput)
    pub fn builder() -> crate::output::list_bot_aliases_output::Builder {
        crate::output::list_bot_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAggregatedUtterancesOutput {
    /// <p>The identifier of the bot that contains the utterances.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn't returned.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn't returned.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the utterances are in.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The time period used to aggregate the utterance data.</p>
    pub aggregation_duration: std::option::Option<crate::model::UtteranceAggregationDuration>,
    /// <p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>
    pub aggregation_window_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>
    pub aggregation_window_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p>
    /// <ul>
    /// <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li>
    /// <li> <p> <b>Days</b> - every 6 hours</p> </li>
    /// <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li>
    /// </ul>
    pub aggregation_last_refreshed_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>
    pub aggregated_utterances_summaries:
        std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesSummary>>,
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAggregatedUtterancesOutput {
    /// <p>The identifier of the bot that contains the utterances.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn't returned.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn't returned.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale that the utterances are in.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The time period used to aggregate the utterance data.</p>
    pub fn aggregation_duration(
        &self,
    ) -> std::option::Option<&crate::model::UtteranceAggregationDuration> {
        self.aggregation_duration.as_ref()
    }
    /// <p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>
    pub fn aggregation_window_start_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.aggregation_window_start_time.as_ref()
    }
    /// <p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>
    pub fn aggregation_window_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.aggregation_window_end_time.as_ref()
    }
    /// <p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p>
    /// <ul>
    /// <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li>
    /// <li> <p> <b>Days</b> - every 6 hours</p> </li>
    /// <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li>
    /// </ul>
    pub fn aggregation_last_refreshed_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.aggregation_last_refreshed_date_time.as_ref()
    }
    /// <p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>
    pub fn aggregated_utterances_summaries(
        &self,
    ) -> std::option::Option<&[crate::model::AggregatedUtterancesSummary]> {
        self.aggregated_utterances_summaries.as_deref()
    }
    /// <p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAggregatedUtterancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAggregatedUtterancesOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("aggregation_duration", &self.aggregation_duration);
        formatter.field(
            "aggregation_window_start_time",
            &self.aggregation_window_start_time,
        );
        formatter.field(
            "aggregation_window_end_time",
            &self.aggregation_window_end_time,
        );
        formatter.field(
            "aggregation_last_refreshed_date_time",
            &self.aggregation_last_refreshed_date_time,
        );
        formatter.field(
            "aggregated_utterances_summaries",
            &self.aggregated_utterances_summaries,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAggregatedUtterancesOutput`](crate::output::ListAggregatedUtterancesOutput)
pub mod list_aggregated_utterances_output {
    /// A builder for [`ListAggregatedUtterancesOutput`](crate::output::ListAggregatedUtterancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) aggregation_duration:
            std::option::Option<crate::model::UtteranceAggregationDuration>,
        pub(crate) aggregation_window_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) aggregation_window_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) aggregation_last_refreshed_date_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) aggregated_utterances_summaries:
            std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the utterances.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the utterances.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn't returned.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot alias that contains the utterances. If you specified the bot version, the bot alias ID isn't returned.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn't returned.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the bot version that contains the utterances. If you specified the bot alias, the bot version isn't returned.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the utterances are in.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the utterances are in.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The time period used to aggregate the utterance data.</p>
        pub fn aggregation_duration(
            mut self,
            input: crate::model::UtteranceAggregationDuration,
        ) -> Self {
            self.aggregation_duration = Some(input);
            self
        }
        /// <p>The time period used to aggregate the utterance data.</p>
        pub fn set_aggregation_duration(
            mut self,
            input: std::option::Option<crate::model::UtteranceAggregationDuration>,
        ) -> Self {
            self.aggregation_duration = input;
            self
        }
        /// <p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>
        pub fn aggregation_window_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.aggregation_window_start_time = Some(input);
            self
        }
        /// <p>The date and time that the aggregation window begins. Only data collected after this time is returned in the results.</p>
        pub fn set_aggregation_window_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.aggregation_window_start_time = input;
            self
        }
        /// <p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>
        pub fn aggregation_window_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.aggregation_window_end_time = Some(input);
            self
        }
        /// <p>The date and time that the aggregation window ends. Only data collected between the start time and the end time are returned in the results. </p>
        pub fn set_aggregation_window_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.aggregation_window_end_time = input;
            self
        }
        /// <p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p>
        /// <ul>
        /// <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li>
        /// <li> <p> <b>Days</b> - every 6 hours</p> </li>
        /// <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li>
        /// </ul>
        pub fn aggregation_last_refreshed_date_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.aggregation_last_refreshed_date_time = Some(input);
            self
        }
        /// <p>The last date and time that the aggregated data was collected. The time period depends on the length of the aggregation window.</p>
        /// <ul>
        /// <li> <p> <b>Hours</b> - for 1 hour time window, every half hour; otherwise every hour.</p> </li>
        /// <li> <p> <b>Days</b> - every 6 hours</p> </li>
        /// <li> <p> <b>Weeks</b> - for a one week time window, every 12 hours; otherwise, every day</p> </li>
        /// </ul>
        pub fn set_aggregation_last_refreshed_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.aggregation_last_refreshed_date_time = input;
            self
        }
        /// Appends an item to `aggregated_utterances_summaries`.
        ///
        /// To override the contents of this collection use [`set_aggregated_utterances_summaries`](Self::set_aggregated_utterances_summaries).
        ///
        /// <p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>
        pub fn aggregated_utterances_summaries(
            mut self,
            input: crate::model::AggregatedUtterancesSummary,
        ) -> Self {
            let mut v = self.aggregated_utterances_summaries.unwrap_or_default();
            v.push(input);
            self.aggregated_utterances_summaries = Some(v);
            self
        }
        /// <p>Summaries of the aggregated utterance data. Each response contains information about the number of times that the utterance was seen during the time period, whether it was detected or missed, and when it was seen during the time period.</p>
        pub fn set_aggregated_utterances_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesSummary>>,
        ) -> Self {
            self.aggregated_utterances_summaries = input;
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token that indicates whether there are more results to return in a response to the <code>ListAggregatedUtterances</code> operation. If the <code>nextToken</code> field is present, you send the contents as the <code>nextToken</code> parameter of a <code>ListAggregatedUtterances</code> operation request to get the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAggregatedUtterancesOutput`](crate::output::ListAggregatedUtterancesOutput)
        pub fn build(self) -> crate::output::ListAggregatedUtterancesOutput {
            crate::output::ListAggregatedUtterancesOutput {
                bot_id: self.bot_id,
                bot_alias_id: self.bot_alias_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                aggregation_duration: self.aggregation_duration,
                aggregation_window_start_time: self.aggregation_window_start_time,
                aggregation_window_end_time: self.aggregation_window_end_time,
                aggregation_last_refreshed_date_time: self.aggregation_last_refreshed_date_time,
                aggregated_utterances_summaries: self.aggregated_utterances_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAggregatedUtterancesOutput {
    /// Creates a new builder-style object to manufacture [`ListAggregatedUtterancesOutput`](crate::output::ListAggregatedUtterancesOutput)
    pub fn builder() -> crate::output::list_aggregated_utterances_output::Builder {
        crate::output::list_aggregated_utterances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSlotTypeOutput {
    /// <p>The unique identifier for the slot type.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the slot type.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>
    pub slot_type_values: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
    /// <p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>
    pub value_selection_setting: std::option::Option<crate::model::SlotValueSelectionSetting>,
    /// <p>The built in slot type used as a parent to this slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale specified for the slot type.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the slot type was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the slot type was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub external_source_setting: std::option::Option<crate::model::ExternalSourceSetting>,
}
impl DescribeSlotTypeOutput {
    /// <p>The unique identifier for the slot type.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The name specified for the slot type.</p>
    pub fn slot_type_name(&self) -> std::option::Option<&str> {
        self.slot_type_name.as_deref()
    }
    /// <p>The description specified for the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>
    pub fn slot_type_values(&self) -> std::option::Option<&[crate::model::SlotTypeValue]> {
        self.slot_type_values.as_deref()
    }
    /// <p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>
    pub fn value_selection_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionSetting> {
        self.value_selection_setting.as_ref()
    }
    /// <p>The built in slot type used as a parent to this slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>The identifier of the bot associated with the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale specified for the slot type.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the slot type was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the slot type was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Provides information about the external source of the slot type's definition.</p>
    pub fn external_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::ExternalSourceSetting> {
        self.external_source_setting.as_ref()
    }
}
impl std::fmt::Debug for DescribeSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSlotTypeOutput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_values", &self.slot_type_values);
        formatter.field("value_selection_setting", &self.value_selection_setting);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("external_source_setting", &self.external_source_setting);
        formatter.finish()
    }
}
/// See [`DescribeSlotTypeOutput`](crate::output::DescribeSlotTypeOutput)
pub mod describe_slot_type_output {
    /// A builder for [`DescribeSlotTypeOutput`](crate::output::DescribeSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_values:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        pub(crate) value_selection_setting:
            std::option::Option<crate::model::SlotValueSelectionSetting>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) external_source_setting:
            std::option::Option<crate::model::ExternalSourceSetting>,
    }
    impl Builder {
        /// <p>The unique identifier for the slot type.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The name specified for the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The name specified for the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>The description specified for the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slot_type_values`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            let mut v = self.slot_type_values.unwrap_or_default();
            v.push(input);
            self.slot_type_values = Some(v);
            self
        }
        /// <p>The values that the slot type can take. Includes any synonyms for the slot type values.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.slot_type_values = input;
            self
        }
        /// <p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.value_selection_setting = Some(input);
            self
        }
        /// <p>The strategy that Amazon Lex uses to choose a value from a list of possible values.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.value_selection_setting = input;
            self
        }
        /// <p>The built in slot type used as a parent to this slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built in slot type used as a parent to this slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale specified for the slot type.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale specified for the slot type.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot type was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot type was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.external_source_setting = Some(input);
            self
        }
        /// <p>Provides information about the external source of the slot type's definition.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.external_source_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSlotTypeOutput`](crate::output::DescribeSlotTypeOutput)
        pub fn build(self) -> crate::output::DescribeSlotTypeOutput {
            crate::output::DescribeSlotTypeOutput {
                slot_type_id: self.slot_type_id,
                slot_type_name: self.slot_type_name,
                description: self.description,
                slot_type_values: self.slot_type_values,
                value_selection_setting: self.value_selection_setting,
                parent_slot_type_signature: self.parent_slot_type_signature,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                external_source_setting: self.external_source_setting,
            }
        }
    }
}
impl DescribeSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSlotTypeOutput`](crate::output::DescribeSlotTypeOutput)
    pub fn builder() -> crate::output::describe_slot_type_output::Builder {
        crate::output::describe_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSlotOutput {
    /// <p>The unique identifier generated for the slot.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the slot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The identifier of the slot type that determines the values entered into the slot.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>
    pub value_elicitation_setting: std::option::Option<crate::model::SlotValueElicitationSetting>,
    /// <p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>The identifier of the bot associated with the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale specified for the slot.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the intent associated with the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the slot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the slot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the slot accepts multiple values in a single utterance.</p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub multiple_values_setting: std::option::Option<crate::model::MultipleValuesSetting>,
}
impl DescribeSlotOutput {
    /// <p>The unique identifier generated for the slot.</p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The name specified for the slot.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>The description specified for the slot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The identifier of the slot type that determines the values entered into the slot.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>
    pub fn value_elicitation_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueElicitationSetting> {
        self.value_elicitation_setting.as_ref()
    }
    /// <p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>The identifier of the bot associated with the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale specified for the slot.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The identifier of the intent associated with the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the slot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the slot was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>Indicates whether the slot accepts multiple values in a single utterance.</p>
    /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
    pub fn multiple_values_setting(
        &self,
    ) -> std::option::Option<&crate::model::MultipleValuesSetting> {
        self.multiple_values_setting.as_ref()
    }
}
impl std::fmt::Debug for DescribeSlotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSlotOutput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("value_elicitation_setting", &self.value_elicitation_setting);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("multiple_values_setting", &self.multiple_values_setting);
        formatter.finish()
    }
}
/// See [`DescribeSlotOutput`](crate::output::DescribeSlotOutput)
pub mod describe_slot_output {
    /// A builder for [`DescribeSlotOutput`](crate::output::DescribeSlotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_setting:
            std::option::Option<crate::model::SlotValueElicitationSetting>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) multiple_values_setting:
            std::option::Option<crate::model::MultipleValuesSetting>,
    }
    impl Builder {
        /// <p>The unique identifier generated for the slot.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier generated for the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The name specified for the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The name specified for the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>The description specified for the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The identifier of the slot type that determines the values entered into the slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The identifier of the slot type that determines the values entered into the slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.value_elicitation_setting = Some(input);
            self
        }
        /// <p>Prompts that Amazon Lex uses to elicit a value for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.value_elicitation_setting = input;
            self
        }
        /// <p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>Whether slot values are shown in Amazon CloudWatch logs. If the value is <code>None</code>, the actual value of the slot is shown in logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale specified for the slot.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale specified for the slot.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>Indicates whether the slot accepts multiple values in a single utterance.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.multiple_values_setting = Some(input);
            self
        }
        /// <p>Indicates whether the slot accepts multiple values in a single utterance.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.multiple_values_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSlotOutput`](crate::output::DescribeSlotOutput)
        pub fn build(self) -> crate::output::DescribeSlotOutput {
            crate::output::DescribeSlotOutput {
                slot_id: self.slot_id,
                slot_name: self.slot_name,
                description: self.description,
                slot_type_id: self.slot_type_id,
                value_elicitation_setting: self.value_elicitation_setting,
                obfuscation_setting: self.obfuscation_setting,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                multiple_values_setting: self.multiple_values_setting,
            }
        }
    }
}
impl DescribeSlotOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSlotOutput`](crate::output::DescribeSlotOutput)
    pub fn builder() -> crate::output::describe_slot_output::Builder {
        crate::output::describe_slot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl DescribeResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResourcePolicyOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
pub mod describe_resource_policy_output {
    /// A builder for [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The JSON structure that contains the resource policy. For more information about the contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy reference </a>.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
        pub fn build(self) -> crate::output::DescribeResourcePolicyOutput {
            crate::output::DescribeResourcePolicyOutput {
                resource_arn: self.resource_arn,
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl DescribeResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePolicyOutput`](crate::output::DescribeResourcePolicyOutput)
    pub fn builder() -> crate::output::describe_resource_policy_output::Builder {
        crate::output::describe_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeIntentOutput {
    /// <p>The unique identifier assigned to the intent when it was created.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The identifier of the built-in intent that this intent is derived from, if any.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>User utterances that trigger this intent.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>The Lambda function called during each turn of a conversation with the intent.</p>
    pub dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
    /// <p>The Lambda function called when the intent is complete and ready for fulfillment.</p>
    pub fulfillment_code_hook: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
    /// <p>The list that determines the priority that slots should be elicited from the user.</p>
    pub slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
    /// <p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>
    pub intent_confirmation_setting: std::option::Option<crate::model::IntentConfirmationSetting>,
    /// <p>The response that Amazon Lex sends to when the intent is closed.</p>
    pub intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
    /// <p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>A list of contexts that are activated when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>The identifier of the bot associated with the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale specified for the intent.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the intent was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the intent was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeIntentOutput {
    /// <p>The unique identifier assigned to the intent when it was created.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The name specified for the intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>The description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The identifier of the built-in intent that this intent is derived from, if any.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>User utterances that trigger this intent.</p>
    pub fn sample_utterances(&self) -> std::option::Option<&[crate::model::SampleUtterance]> {
        self.sample_utterances.as_deref()
    }
    /// <p>The Lambda function called during each turn of a conversation with the intent.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::DialogCodeHookSettings> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>The Lambda function called when the intent is complete and ready for fulfillment.</p>
    pub fn fulfillment_code_hook(
        &self,
    ) -> std::option::Option<&crate::model::FulfillmentCodeHookSettings> {
        self.fulfillment_code_hook.as_ref()
    }
    /// <p>The list that determines the priority that slots should be elicited from the user.</p>
    pub fn slot_priorities(&self) -> std::option::Option<&[crate::model::SlotPriority]> {
        self.slot_priorities.as_deref()
    }
    /// <p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>
    pub fn intent_confirmation_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentConfirmationSetting> {
        self.intent_confirmation_setting.as_ref()
    }
    /// <p>The response that Amazon Lex sends to when the intent is closed.</p>
    pub fn intent_closing_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentClosingSetting> {
        self.intent_closing_setting.as_ref()
    }
    /// <p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>A list of contexts that are activated when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
    /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>The identifier of the bot associated with the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale specified for the intent.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the intent was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the intent was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeIntentOutput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_code_hook", &self.fulfillment_code_hook);
        formatter.field("slot_priorities", &self.slot_priorities);
        formatter.field(
            "intent_confirmation_setting",
            &self.intent_confirmation_setting,
        );
        formatter.field("intent_closing_setting", &self.intent_closing_setting);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeIntentOutput`](crate::output::DescribeIntentOutput)
pub mod describe_intent_output {
    /// A builder for [`DescribeIntentOutput`](crate::output::DescribeIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
        pub(crate) fulfillment_code_hook:
            std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        pub(crate) slot_priorities: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        pub(crate) intent_confirmation_setting:
            std::option::Option<crate::model::IntentConfirmationSetting>,
        pub(crate) intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the intent when it was created.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the intent when it was created.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The name specified for the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name specified for the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The identifier of the built-in intent that this intent is derived from, if any.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>The identifier of the built-in intent that this intent is derived from, if any.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>User utterances that trigger this intent.</p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input);
            self.sample_utterances = Some(v);
            self
        }
        /// <p>User utterances that trigger this intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>The Lambda function called during each turn of a conversation with the intent.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>The Lambda function called during each turn of a conversation with the intent.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>The Lambda function called when the intent is complete and ready for fulfillment.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.fulfillment_code_hook = Some(input);
            self
        }
        /// <p>The Lambda function called when the intent is complete and ready for fulfillment.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.fulfillment_code_hook = input;
            self
        }
        /// Appends an item to `slot_priorities`.
        ///
        /// To override the contents of this collection use [`set_slot_priorities`](Self::set_slot_priorities).
        ///
        /// <p>The list that determines the priority that slots should be elicited from the user.</p>
        pub fn slot_priorities(mut self, input: crate::model::SlotPriority) -> Self {
            let mut v = self.slot_priorities.unwrap_or_default();
            v.push(input);
            self.slot_priorities = Some(v);
            self
        }
        /// <p>The list that determines the priority that slots should be elicited from the user.</p>
        pub fn set_slot_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        ) -> Self {
            self.slot_priorities = input;
            self
        }
        /// <p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.intent_confirmation_setting = Some(input);
            self
        }
        /// <p>Prompts that Amazon Lex sends to the user to confirm completion of an intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.intent_confirmation_setting = input;
            self
        }
        /// <p>The response that Amazon Lex sends to when the intent is closed.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.intent_closing_setting = Some(input);
            self
        }
        /// <p>The response that Amazon Lex sends to when the intent is closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.intent_closing_setting = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input);
            self.input_contexts = Some(v);
            self
        }
        /// <p>A list of contexts that must be active for the intent to be considered for sending to the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A list of contexts that are activated when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input);
            self.output_contexts = Some(v);
            self
        }
        /// <p>A list of contexts that are activated when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale specified for the intent.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale specified for the intent.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the intent was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the intent was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the intent was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the intent was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeIntentOutput`](crate::output::DescribeIntentOutput)
        pub fn build(self) -> crate::output::DescribeIntentOutput {
            crate::output::DescribeIntentOutput {
                intent_id: self.intent_id,
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                sample_utterances: self.sample_utterances,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_code_hook: self.fulfillment_code_hook,
                slot_priorities: self.slot_priorities,
                intent_confirmation_setting: self.intent_confirmation_setting,
                intent_closing_setting: self.intent_closing_setting,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                kendra_configuration: self.kendra_configuration,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeIntentOutput {
    /// Creates a new builder-style object to manufacture [`DescribeIntentOutput`](crate::output::DescribeIntentOutput)
    pub fn builder() -> crate::output::describe_intent_output::Builder {
        crate::output::describe_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImportOutput {
    /// <p>The unique identifier of the described import.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>
    pub resource_specification: std::option::Option<crate::model::ImportResourceSpecification>,
    /// <p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>
    pub imported_resource_id: std::option::Option<std::string::String>,
    /// <p>The name of the imported resource.</p>
    pub imported_resource_name: std::option::Option<std::string::String>,
    /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
    /// <p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time that the import was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the import was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeImportOutput {
    /// <p>The unique identifier of the described import.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ImportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>
    pub fn imported_resource_id(&self) -> std::option::Option<&str> {
        self.imported_resource_id.as_deref()
    }
    /// <p>The name of the imported resource.</p>
    pub fn imported_resource_name(&self) -> std::option::Option<&str> {
        self.imported_resource_name.as_deref()
    }
    /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>
    pub fn import_status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.import_status.as_ref()
    }
    /// <p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>The date and time that the import was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time that the import was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImportOutput");
        formatter.field("import_id", &self.import_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("imported_resource_id", &self.imported_resource_id);
        formatter.field("imported_resource_name", &self.imported_resource_name);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("import_status", &self.import_status);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeImportOutput`](crate::output::DescribeImportOutput)
pub mod describe_import_output {
    /// A builder for [`DescribeImportOutput`](crate::output::DescribeImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ImportResourceSpecification>,
        pub(crate) imported_resource_id: std::option::Option<std::string::String>,
        pub(crate) imported_resource_name: std::option::Option<std::string::String>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the described import.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the described import.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ImportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>The specifications of the imported bot, bot locale, or custom vocabulary.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ImportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>
        pub fn imported_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the resource created by the import.</p>
        pub fn set_imported_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_resource_id = input;
            self
        }
        /// <p>The name of the imported resource.</p>
        pub fn imported_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the imported resource.</p>
        pub fn set_imported_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_resource_name = input;
            self
        }
        /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The strategy used when there was a name conflict between the imported resource and an existing resource. When the merge strategy is <code>FailOnConflict</code> existing resources are not overwritten and the import fails.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The status of the import process. When the status is <code>Completed</code> the resource is imported and ready for use.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If the <code>importStatus</code> field is <code>Failed</code>, this provides one or more reasons for the failure.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>The date and time that the import was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the import was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the import was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the import was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImportOutput`](crate::output::DescribeImportOutput)
        pub fn build(self) -> crate::output::DescribeImportOutput {
            crate::output::DescribeImportOutput {
                import_id: self.import_id,
                resource_specification: self.resource_specification,
                imported_resource_id: self.imported_resource_id,
                imported_resource_name: self.imported_resource_name,
                merge_strategy: self.merge_strategy,
                import_status: self.import_status,
                failure_reasons: self.failure_reasons,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeImportOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImportOutput`](crate::output::DescribeImportOutput)
    pub fn builder() -> crate::output::describe_import_output::Builder {
        crate::output::describe_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportOutput {
    /// <p>The unique identifier of the described export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>
    pub resource_specification: std::option::Option<crate::model::ExportResourceSpecification>,
    /// <p>The file format used in the files that describe the resource. </p>
    pub file_format: std::option::Option<crate::model::ImportExportFileFormat>,
    /// <p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>
    pub download_url: std::option::Option<std::string::String>,
    /// <p>The date and time that the export was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last date and time that the export was updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeExportOutput {
    /// <p>The unique identifier of the described export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ExportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The file format used in the files that describe the resource. </p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::ImportExportFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>
    pub fn download_url(&self) -> std::option::Option<&str> {
        self.download_url.as_deref()
    }
    /// <p>The date and time that the export was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The last date and time that the export was updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportOutput");
        formatter.field("export_id", &self.export_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("file_format", &self.file_format);
        formatter.field("export_status", &self.export_status);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("download_url", &self.download_url);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeExportOutput`](crate::output::DescribeExportOutput)
pub mod describe_export_output {
    /// A builder for [`DescribeExportOutput`](crate::output::DescribeExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ExportResourceSpecification>,
        pub(crate) file_format: std::option::Option<crate::model::ImportExportFileFormat>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) download_url: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the described export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the described export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>The bot, bot ID, and optional locale ID of the exported bot or bot locale.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The file format used in the files that describe the resource. </p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file format used in the files that describe the resource. </p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the export. When the status is <code>Complete</code> the export archive file is available for download.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If the <code>exportStatus</code> is failed, contains one or more reasons why the export could not be completed.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>
        pub fn download_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.download_url = Some(input.into());
            self
        }
        /// <p>A pre-signed S3 URL that points to the bot or bot locale archive. The URL is only available for 5 minutes after calling the <code>DescribeExport</code> operation.</p>
        pub fn set_download_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.download_url = input;
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The last date and time that the export was updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The last date and time that the export was updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportOutput`](crate::output::DescribeExportOutput)
        pub fn build(self) -> crate::output::DescribeExportOutput {
            crate::output::DescribeExportOutput {
                export_id: self.export_id,
                resource_specification: self.resource_specification,
                file_format: self.file_format,
                export_status: self.export_status,
                failure_reasons: self.failure_reasons,
                download_url: self.download_url,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeExportOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExportOutput`](crate::output::DescribeExportOutput)
    pub fn builder() -> crate::output::describe_export_output::Builder {
        crate::output::describe_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomVocabularyMetadataOutput {
    /// <p>The identifier of the bot that contains the custom vocabulary.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contains the custom vocabulary to describe.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale that contains the custom vocabulary to describe.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>
    pub custom_vocabulary_status: std::option::Option<crate::model::CustomVocabularyStatus>,
    /// <p>The date and time that the custom vocabulary was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the custom vocabulary was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeCustomVocabularyMetadataOutput {
    /// <p>The identifier of the bot that contains the custom vocabulary.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contains the custom vocabulary to describe.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale that contains the custom vocabulary to describe.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>
    pub fn custom_vocabulary_status(
        &self,
    ) -> std::option::Option<&crate::model::CustomVocabularyStatus> {
        self.custom_vocabulary_status.as_ref()
    }
    /// <p>The date and time that the custom vocabulary was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time that the custom vocabulary was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeCustomVocabularyMetadataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomVocabularyMetadataOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("custom_vocabulary_status", &self.custom_vocabulary_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeCustomVocabularyMetadataOutput`](crate::output::DescribeCustomVocabularyMetadataOutput)
pub mod describe_custom_vocabulary_metadata_output {
    /// A builder for [`DescribeCustomVocabularyMetadataOutput`](crate::output::DescribeCustomVocabularyMetadataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) custom_vocabulary_status:
            std::option::Option<crate::model::CustomVocabularyStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the custom vocabulary.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the custom vocabulary.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contains the custom vocabulary to describe.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contains the custom vocabulary to describe.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale that contains the custom vocabulary to describe.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale that contains the custom vocabulary to describe.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>
        pub fn custom_vocabulary_status(
            mut self,
            input: crate::model::CustomVocabularyStatus,
        ) -> Self {
            self.custom_vocabulary_status = Some(input);
            self
        }
        /// <p>The status of the custom vocabulary. If the status is <code>Ready</code> the custom vocabulary is ready to use.</p>
        pub fn set_custom_vocabulary_status(
            mut self,
            input: std::option::Option<crate::model::CustomVocabularyStatus>,
        ) -> Self {
            self.custom_vocabulary_status = input;
            self
        }
        /// <p>The date and time that the custom vocabulary was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the custom vocabulary was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the custom vocabulary was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the custom vocabulary was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomVocabularyMetadataOutput`](crate::output::DescribeCustomVocabularyMetadataOutput)
        pub fn build(self) -> crate::output::DescribeCustomVocabularyMetadataOutput {
            crate::output::DescribeCustomVocabularyMetadataOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                custom_vocabulary_status: self.custom_vocabulary_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeCustomVocabularyMetadataOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomVocabularyMetadataOutput`](crate::output::DescribeCustomVocabularyMetadataOutput)
    pub fn builder() -> crate::output::describe_custom_vocabulary_metadata_output::Builder {
        crate::output::describe_custom_vocabulary_metadata_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotVersionOutput {
    /// <p>The identifier of the bot that contains the version.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot that contains the version.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The version of the bot to describe.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The description specified for the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Data privacy settings for the bot version.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't be built.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A timestamp of the date and time that the bot version was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeBotVersionOutput {
    /// <p>The identifier of the bot that contains the version.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The name of the bot that contains the version.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The version of the bot to describe.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The description specified for the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Data privacy settings for the bot version.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
    /// <p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't be built.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>A timestamp of the date and time that the bot version was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeBotVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotVersionOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_status", &self.bot_status);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`DescribeBotVersionOutput`](crate::output::DescribeBotVersionOutput)
pub mod describe_bot_version_output {
    /// A builder for [`DescribeBotVersionOutput`](crate::output::DescribeBotVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The name of the bot that contains the version.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that contains the version.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The version of the bot to describe.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to describe.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The description specified for the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot version.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Data privacy settings for the bot version.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>Data privacy settings for the bot version.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds that a session with the bot remains active before it is discarded by Amazon Lex.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The current status of the bot. When the status is <code>Available</code>, the bot version is ready for use.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't be built.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If the <code>botStatus</code> is <code>Failed</code>, this contains a list of reasons that the version couldn't be built.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot version was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot version was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotVersionOutput`](crate::output::DescribeBotVersionOutput)
        pub fn build(self) -> crate::output::DescribeBotVersionOutput {
            crate::output::DescribeBotVersionOutput {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                bot_version: self.bot_version,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_status: self.bot_status,
                failure_reasons: self.failure_reasons,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl DescribeBotVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBotVersionOutput`](crate::output::DescribeBotVersionOutput)
    pub fn builder() -> crate::output::describe_bot_version_output::Builder {
        crate::output::describe_bot_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotRecommendationOutput {
    /// <p>The identifier of the bot associated with the bot recommendation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the bot recommendation.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale of the bot recommendation to describe.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub bot_recommendation_status: std::option::Option<crate::model::BotRecommendationStatus>,
    /// <p>The identifier of the bot recommendation being described.</p>
    pub bot_recommendation_id: std::option::Option<std::string::String>,
    /// <p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time that the bot recommendation was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the bot recommendation was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub transcript_source_setting: std::option::Option<crate::model::TranscriptSourceSetting>,
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
    /// <p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>
    pub bot_recommendation_results: std::option::Option<crate::model::BotRecommendationResults>,
}
impl DescribeBotRecommendationOutput {
    /// <p>The identifier of the bot associated with the bot recommendation.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the bot recommendation.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The identifier of the language and locale of the bot recommendation to describe.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
    pub fn bot_recommendation_status(
        &self,
    ) -> std::option::Option<&crate::model::BotRecommendationStatus> {
        self.bot_recommendation_status.as_ref()
    }
    /// <p>The identifier of the bot recommendation being described.</p>
    pub fn bot_recommendation_id(&self) -> std::option::Option<&str> {
        self.bot_recommendation_id.as_deref()
    }
    /// <p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>The date and time that the bot recommendation was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time that the bot recommendation was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
    pub fn transcript_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::TranscriptSourceSetting> {
        self.transcript_source_setting.as_ref()
    }
    /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
    pub fn encryption_setting(&self) -> std::option::Option<&crate::model::EncryptionSetting> {
        self.encryption_setting.as_ref()
    }
    /// <p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>
    pub fn bot_recommendation_results(
        &self,
    ) -> std::option::Option<&crate::model::BotRecommendationResults> {
        self.bot_recommendation_results.as_ref()
    }
}
impl std::fmt::Debug for DescribeBotRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotRecommendationOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_recommendation_status", &self.bot_recommendation_status);
        formatter.field("bot_recommendation_id", &self.bot_recommendation_id);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field("transcript_source_setting", &self.transcript_source_setting);
        formatter.field("encryption_setting", &self.encryption_setting);
        formatter.field(
            "bot_recommendation_results",
            &self.bot_recommendation_results,
        );
        formatter.finish()
    }
}
/// See [`DescribeBotRecommendationOutput`](crate::output::DescribeBotRecommendationOutput)
pub mod describe_bot_recommendation_output {
    /// A builder for [`DescribeBotRecommendationOutput`](crate::output::DescribeBotRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_recommendation_status:
            std::option::Option<crate::model::BotRecommendationStatus>,
        pub(crate) bot_recommendation_id: std::option::Option<std::string::String>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) transcript_source_setting:
            std::option::Option<crate::model::TranscriptSourceSetting>,
        pub(crate) encryption_setting: std::option::Option<crate::model::EncryptionSetting>,
        pub(crate) bot_recommendation_results:
            std::option::Option<crate::model::BotRecommendationResults>,
    }
    impl Builder {
        /// <p>The identifier of the bot associated with the bot recommendation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the bot recommendation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the bot recommendation.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale of the bot recommendation to describe.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn bot_recommendation_status(
            mut self,
            input: crate::model::BotRecommendationStatus,
        ) -> Self {
            self.bot_recommendation_status = Some(input);
            self
        }
        /// <p>The status of the bot recommendation. If the status is Failed, then the reasons for the failure are listed in the failureReasons field. </p>
        pub fn set_bot_recommendation_status(
            mut self,
            input: std::option::Option<crate::model::BotRecommendationStatus>,
        ) -> Self {
            self.bot_recommendation_status = input;
            self
        }
        /// <p>The identifier of the bot recommendation being described.</p>
        pub fn bot_recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_recommendation_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot recommendation being described.</p>
        pub fn set_bot_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_recommendation_id = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>If botRecommendationStatus is Failed, Amazon Lex explains why.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>The date and time that the bot recommendation was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the bot recommendation was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the bot recommendation was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the bot recommendation was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn transcript_source_setting(
            mut self,
            input: crate::model::TranscriptSourceSetting,
        ) -> Self {
            self.transcript_source_setting = Some(input);
            self
        }
        /// <p>The object representing the Amazon S3 bucket containing the transcript, as well as the associated metadata.</p>
        pub fn set_transcript_source_setting(
            mut self,
            input: std::option::Option<crate::model::TranscriptSourceSetting>,
        ) -> Self {
            self.transcript_source_setting = input;
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn encryption_setting(mut self, input: crate::model::EncryptionSetting) -> Self {
            self.encryption_setting = Some(input);
            self
        }
        /// <p>The object representing the passwords that were used to encrypt the data related to the bot recommendation results, as well as the KMS key ARN used to encrypt the associated metadata.</p>
        pub fn set_encryption_setting(
            mut self,
            input: std::option::Option<crate::model::EncryptionSetting>,
        ) -> Self {
            self.encryption_setting = input;
            self
        }
        /// <p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>
        pub fn bot_recommendation_results(
            mut self,
            input: crate::model::BotRecommendationResults,
        ) -> Self {
            self.bot_recommendation_results = Some(input);
            self
        }
        /// <p>The object representing the URL of the bot definition, the URL of the associated transcript and a statistical summary of the bot recommendation results.</p>
        pub fn set_bot_recommendation_results(
            mut self,
            input: std::option::Option<crate::model::BotRecommendationResults>,
        ) -> Self {
            self.bot_recommendation_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotRecommendationOutput`](crate::output::DescribeBotRecommendationOutput)
        pub fn build(self) -> crate::output::DescribeBotRecommendationOutput {
            crate::output::DescribeBotRecommendationOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_recommendation_status: self.bot_recommendation_status,
                bot_recommendation_id: self.bot_recommendation_id,
                failure_reasons: self.failure_reasons,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                transcript_source_setting: self.transcript_source_setting,
                encryption_setting: self.encryption_setting,
                bot_recommendation_results: self.bot_recommendation_results,
            }
        }
    }
}
impl DescribeBotRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBotRecommendationOutput`](crate::output::DescribeBotRecommendationOutput)
    pub fn builder() -> crate::output::describe_bot_recommendation_output::Builder {
        crate::output::describe_bot_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotLocaleOutput {
    /// <p>The identifier of the bot associated with the locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the version of the bot associated with the locale.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the described locale.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The name of the locale.</p>
    pub locale_name: std::option::Option<std::string::String>,
    /// <p>The description of the locale.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
    /// <p>The number of intents defined for the locale.</p>
    pub intents_count: std::option::Option<i32>,
    /// <p>The number of slot types defined for the locale.</p>
    pub slot_types_count: std::option::Option<i32>,
    /// <p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    /// <p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>
    pub failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time that the locale was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the locale was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the locale was last submitted for building.</p>
    pub last_build_submitted_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>
    pub bot_locale_history_events:
        std::option::Option<std::vec::Vec<crate::model::BotLocaleHistoryEvent>>,
    /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    pub recommended_actions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeBotLocaleOutput {
    /// <p>The identifier of the bot associated with the locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the version of the bot associated with the locale.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The unique identifier of the described locale.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The name of the locale.</p>
    pub fn locale_name(&self) -> std::option::Option<&str> {
        self.locale_name.as_deref()
    }
    /// <p>The description of the locale.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>
    pub fn voice_settings(&self) -> std::option::Option<&crate::model::VoiceSettings> {
        self.voice_settings.as_ref()
    }
    /// <p>The number of intents defined for the locale.</p>
    pub fn intents_count(&self) -> std::option::Option<i32> {
        self.intents_count
    }
    /// <p>The number of slot types defined for the locale.</p>
    pub fn slot_types_count(&self) -> std::option::Option<i32> {
        self.slot_types_count
    }
    /// <p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>
    pub fn bot_locale_status(&self) -> std::option::Option<&crate::model::BotLocaleStatus> {
        self.bot_locale_status.as_ref()
    }
    /// <p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>
    pub fn failure_reasons(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reasons.as_deref()
    }
    /// <p>The date and time that the locale was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The date and time that the locale was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
    /// <p>The date and time that the locale was last submitted for building.</p>
    pub fn last_build_submitted_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_build_submitted_date_time.as_ref()
    }
    /// <p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>
    pub fn bot_locale_history_events(
        &self,
    ) -> std::option::Option<&[crate::model::BotLocaleHistoryEvent]> {
        self.bot_locale_history_events.as_deref()
    }
    /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
    pub fn recommended_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.recommended_actions.as_deref()
    }
}
impl std::fmt::Debug for DescribeBotLocaleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotLocaleOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("locale_name", &self.locale_name);
        formatter.field("description", &self.description);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.field("intents_count", &self.intents_count);
        formatter.field("slot_types_count", &self.slot_types_count);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.field("failure_reasons", &self.failure_reasons);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field(
            "last_build_submitted_date_time",
            &self.last_build_submitted_date_time,
        );
        formatter.field("bot_locale_history_events", &self.bot_locale_history_events);
        formatter.field("recommended_actions", &self.recommended_actions);
        formatter.finish()
    }
}
/// See [`DescribeBotLocaleOutput`](crate::output::DescribeBotLocaleOutput)
pub mod describe_bot_locale_output {
    /// A builder for [`DescribeBotLocaleOutput`](crate::output::DescribeBotLocaleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) locale_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
        pub(crate) intents_count: std::option::Option<i32>,
        pub(crate) slot_types_count: std::option::Option<i32>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
        pub(crate) failure_reasons: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_build_submitted_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bot_locale_history_events:
            std::option::Option<std::vec::Vec<crate::model::BotLocaleHistoryEvent>>,
        pub(crate) recommended_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with the locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The unique identifier of the described locale.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the described locale.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The name of the locale.</p>
        pub fn locale_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_name = Some(input.into());
            self
        }
        /// <p>The name of the locale.</p>
        pub fn set_locale_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_name = input;
            self
        }
        /// <p>The description of the locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The confidence threshold where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents in the list of possible intents for an utterance.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>The Amazon Polly voice Amazon Lex uses for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// <p>The number of intents defined for the locale.</p>
        pub fn intents_count(mut self, input: i32) -> Self {
            self.intents_count = Some(input);
            self
        }
        /// <p>The number of intents defined for the locale.</p>
        pub fn set_intents_count(mut self, input: std::option::Option<i32>) -> Self {
            self.intents_count = input;
            self
        }
        /// <p>The number of slot types defined for the locale.</p>
        pub fn slot_types_count(mut self, input: i32) -> Self {
            self.slot_types_count = Some(input);
            self
        }
        /// <p>The number of slot types defined for the locale.</p>
        pub fn set_slot_types_count(mut self, input: std::option::Option<i32>) -> Self {
            self.slot_types_count = input;
            self
        }
        /// <p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The status of the bot. If the status is <code>Failed</code>, the reasons for the failure are listed in the <code>failureReasons</code> field.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// Appends an item to `failure_reasons`.
        ///
        /// To override the contents of this collection use [`set_failure_reasons`](Self::set_failure_reasons).
        ///
        /// <p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>
        pub fn failure_reasons(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reasons.unwrap_or_default();
            v.push(input.into());
            self.failure_reasons = Some(v);
            self
        }
        /// <p>if <code>botLocaleStatus</code> is <code>Failed</code>, Amazon Lex explains why it failed to build the bot.</p>
        pub fn set_failure_reasons(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reasons = input;
            self
        }
        /// <p>The date and time that the locale was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the locale was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the locale was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the locale was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>The date and time that the locale was last submitted for building.</p>
        pub fn last_build_submitted_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_build_submitted_date_time = Some(input);
            self
        }
        /// <p>The date and time that the locale was last submitted for building.</p>
        pub fn set_last_build_submitted_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_build_submitted_date_time = input;
            self
        }
        /// Appends an item to `bot_locale_history_events`.
        ///
        /// To override the contents of this collection use [`set_bot_locale_history_events`](Self::set_bot_locale_history_events).
        ///
        /// <p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>
        pub fn bot_locale_history_events(
            mut self,
            input: crate::model::BotLocaleHistoryEvent,
        ) -> Self {
            let mut v = self.bot_locale_history_events.unwrap_or_default();
            v.push(input);
            self.bot_locale_history_events = Some(v);
            self
        }
        /// <p>History of changes, such as when a locale is used in an alias, that have taken place for the locale.</p>
        pub fn set_bot_locale_history_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotLocaleHistoryEvent>>,
        ) -> Self {
            self.bot_locale_history_events = input;
            self
        }
        /// Appends an item to `recommended_actions`.
        ///
        /// To override the contents of this collection use [`set_recommended_actions`](Self::set_recommended_actions).
        ///
        /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
        pub fn recommended_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.recommended_actions.unwrap_or_default();
            v.push(input.into());
            self.recommended_actions = Some(v);
            self
        }
        /// <p>Recommended actions to take to resolve an error in the <code>failureReasons</code> field.</p>
        pub fn set_recommended_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.recommended_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotLocaleOutput`](crate::output::DescribeBotLocaleOutput)
        pub fn build(self) -> crate::output::DescribeBotLocaleOutput {
            crate::output::DescribeBotLocaleOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                locale_name: self.locale_name,
                description: self.description,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
                intents_count: self.intents_count,
                slot_types_count: self.slot_types_count,
                bot_locale_status: self.bot_locale_status,
                failure_reasons: self.failure_reasons,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
                last_build_submitted_date_time: self.last_build_submitted_date_time,
                bot_locale_history_events: self.bot_locale_history_events,
                recommended_actions: self.recommended_actions,
            }
        }
    }
}
impl DescribeBotLocaleOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBotLocaleOutput`](crate::output::DescribeBotLocaleOutput)
    pub fn builder() -> crate::output::describe_bot_locale_output::Builder {
        crate::output::describe_bot_locale_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotAliasOutput {
    /// <p>The identifier of the bot alias.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot alias.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the bot alias.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale settings that are unique to the alias.</p>
    pub bot_alias_locale_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    >,
    /// <p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>
    pub conversation_log_settings: std::option::Option<crate::model::ConversationLogSettings>,
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub sentiment_analysis_settings: std::option::Option<crate::model::SentimentAnalysisSettings>,
    /// <p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>
    pub bot_alias_history_events:
        std::option::Option<std::vec::Vec<crate::model::BotAliasHistoryEvent>>,
    /// <p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>
    pub bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
    /// <p>The identifier of the bot associated with the bot alias.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the alias was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the alias was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeBotAliasOutput {
    /// <p>The identifier of the bot alias.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The name of the bot alias.</p>
    pub fn bot_alias_name(&self) -> std::option::Option<&str> {
        self.bot_alias_name.as_deref()
    }
    /// <p>The description of the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot associated with the bot alias.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale settings that are unique to the alias.</p>
    pub fn bot_alias_locale_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    > {
        self.bot_alias_locale_settings.as_ref()
    }
    /// <p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>
    pub fn conversation_log_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogSettings> {
        self.conversation_log_settings.as_ref()
    }
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub fn sentiment_analysis_settings(
        &self,
    ) -> std::option::Option<&crate::model::SentimentAnalysisSettings> {
        self.sentiment_analysis_settings.as_ref()
    }
    /// <p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>
    pub fn bot_alias_history_events(
        &self,
    ) -> std::option::Option<&[crate::model::BotAliasHistoryEvent]> {
        self.bot_alias_history_events.as_deref()
    }
    /// <p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>
    pub fn bot_alias_status(&self) -> std::option::Option<&crate::model::BotAliasStatus> {
        self.bot_alias_status.as_ref()
    }
    /// <p>The identifier of the bot associated with the bot alias.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the alias was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the alias was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotAliasOutput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_locale_settings", &self.bot_alias_locale_settings);
        formatter.field("conversation_log_settings", &self.conversation_log_settings);
        formatter.field(
            "sentiment_analysis_settings",
            &self.sentiment_analysis_settings,
        );
        formatter.field("bot_alias_history_events", &self.bot_alias_history_events);
        formatter.field("bot_alias_status", &self.bot_alias_status);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeBotAliasOutput`](crate::output::DescribeBotAliasOutput)
pub mod describe_bot_alias_output {
    /// A builder for [`DescribeBotAliasOutput`](crate::output::DescribeBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_locale_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
        >,
        pub(crate) conversation_log_settings:
            std::option::Option<crate::model::ConversationLogSettings>,
        pub(crate) sentiment_analysis_settings:
            std::option::Option<crate::model::SentimentAnalysisSettings>,
        pub(crate) bot_alias_history_events:
            std::option::Option<std::vec::Vec<crate::model::BotAliasHistoryEvent>>,
        pub(crate) bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the bot alias.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>The description of the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot associated with the bot alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_alias_locale_settings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>The locale settings that are unique to the alias.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            let mut hash_map = self.bot_alias_locale_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_alias_locale_settings = Some(hash_map);
            self
        }
        /// <p>The locale settings that are unique to the alias.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.bot_alias_locale_settings = input;
            self
        }
        /// <p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.conversation_log_settings = Some(input);
            self
        }
        /// <p>Specifics of how Amazon Lex logs text and audio conversations with the bot associated with the alias.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.conversation_log_settings = input;
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.sentiment_analysis_settings = Some(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.sentiment_analysis_settings = input;
            self
        }
        /// Appends an item to `bot_alias_history_events`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_history_events`](Self::set_bot_alias_history_events).
        ///
        /// <p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>
        pub fn bot_alias_history_events(
            mut self,
            input: crate::model::BotAliasHistoryEvent,
        ) -> Self {
            let mut v = self.bot_alias_history_events.unwrap_or_default();
            v.push(input);
            self.bot_alias_history_events = Some(v);
            self
        }
        /// <p>A list of events that affect a bot alias. For example, an event is recorded when the version that the alias points to changes.</p>
        pub fn set_bot_alias_history_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotAliasHistoryEvent>>,
        ) -> Self {
            self.bot_alias_history_events = input;
            self
        }
        /// <p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>
        pub fn bot_alias_status(mut self, input: crate::model::BotAliasStatus) -> Self {
            self.bot_alias_status = Some(input);
            self
        }
        /// <p>The current status of the alias. When the alias is <code>Available</code>, the alias is ready for use with your bot.</p>
        pub fn set_bot_alias_status(
            mut self,
            input: std::option::Option<crate::model::BotAliasStatus>,
        ) -> Self {
            self.bot_alias_status = input;
            self
        }
        /// <p>The identifier of the bot associated with the bot alias.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the bot alias.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the alias was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the alias was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the alias was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the alias was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotAliasOutput`](crate::output::DescribeBotAliasOutput)
        pub fn build(self) -> crate::output::DescribeBotAliasOutput {
            crate::output::DescribeBotAliasOutput {
                bot_alias_id: self.bot_alias_id,
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_locale_settings: self.bot_alias_locale_settings,
                conversation_log_settings: self.conversation_log_settings,
                sentiment_analysis_settings: self.sentiment_analysis_settings,
                bot_alias_history_events: self.bot_alias_history_events,
                bot_alias_status: self.bot_alias_status,
                bot_id: self.bot_id,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBotAliasOutput`](crate::output::DescribeBotAliasOutput)
    pub fn builder() -> crate::output::describe_bot_alias_output::Builder {
        crate::output::describe_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBotOutput {
    /// <p>The unique identifier of the bot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Settings for managing data privacy of the bot and its conversations with users.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeBotOutput {
    /// <p>The unique identifier of the bot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The name of the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The description of the bot. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Settings for managing data privacy of the bot and its conversations with users.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A timestamp of the date and time that the bot was last updated.</p>
    pub fn last_updated_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBotOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_status", &self.bot_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`DescribeBotOutput`](crate::output::DescribeBotOutput)
pub mod describe_bot_output {
    /// A builder for [`DescribeBotOutput`](crate::output::DescribeBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The description of the bot. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Settings for managing data privacy of the bot and its conversations with users.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>Settings for managing data privacy of the bot and its conversations with users.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The current status of the bot. When the status is <code>Available</code> the bot is ready to be used in conversations with users.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBotOutput`](crate::output::DescribeBotOutput)
        pub fn build(self) -> crate::output::DescribeBotOutput {
            crate::output::DescribeBotOutput {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_status: self.bot_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl DescribeBotOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBotOutput`](crate::output::DescribeBotOutput)
    pub fn builder() -> crate::output::describe_bot_output::Builder {
        crate::output::describe_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUtterancesOutput {}
impl std::fmt::Debug for DeleteUtterancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUtterancesOutput");
        formatter.finish()
    }
}
/// See [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
pub mod delete_utterances_output {
    /// A builder for [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
        pub fn build(self) -> crate::output::DeleteUtterancesOutput {
            crate::output::DeleteUtterancesOutput {}
        }
    }
}
impl DeleteUtterancesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
    pub fn builder() -> crate::output::delete_utterances_output::Builder {
        crate::output::delete_utterances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeOutput {}
impl std::fmt::Debug for DeleteSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
pub mod delete_slot_type_output {
    /// A builder for [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
        pub fn build(self) -> crate::output::DeleteSlotTypeOutput {
            crate::output::DeleteSlotTypeOutput {}
        }
    }
}
impl DeleteSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
    pub fn builder() -> crate::output::delete_slot_type_output::Builder {
        crate::output::delete_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotOutput {}
impl std::fmt::Debug for DeleteSlotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotOutput");
        formatter.finish()
    }
}
/// See [`DeleteSlotOutput`](crate::output::DeleteSlotOutput)
pub mod delete_slot_output {
    /// A builder for [`DeleteSlotOutput`](crate::output::DeleteSlotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSlotOutput`](crate::output::DeleteSlotOutput)
        pub fn build(self) -> crate::output::DeleteSlotOutput {
            crate::output::DeleteSlotOutput {}
        }
    }
}
impl DeleteSlotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSlotOutput`](crate::output::DeleteSlotOutput)
    pub fn builder() -> crate::output::delete_slot_output::Builder {
        crate::output::delete_slot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyStatementOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyStatementOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyStatementOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyStatementOutput`](crate::output::DeleteResourcePolicyStatementOutput)
pub mod delete_resource_policy_statement_output {
    /// A builder for [`DeleteResourcePolicyStatementOutput`](crate::output::DeleteResourcePolicyStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy statement was removed from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyStatementOutput`](crate::output::DeleteResourcePolicyStatementOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyStatementOutput {
            crate::output::DeleteResourcePolicyStatementOutput {
                resource_arn: self.resource_arn,
                revision_id: self.revision_id,
            }
        }
    }
}
impl DeleteResourcePolicyStatementOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyStatementOutput`](crate::output::DeleteResourcePolicyStatementOutput)
    pub fn builder() -> crate::output::delete_resource_policy_statement_output::Builder {
        crate::output::delete_resource_policy_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl DeleteResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was deleted from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {
                resource_arn: self.resource_arn,
                revision_id: self.revision_id,
            }
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentOutput {}
impl std::fmt::Debug for DeleteIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentOutput");
        formatter.finish()
    }
}
/// See [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
pub mod delete_intent_output {
    /// A builder for [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
        pub fn build(self) -> crate::output::DeleteIntentOutput {
            crate::output::DeleteIntentOutput {}
        }
    }
}
impl DeleteIntentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
    pub fn builder() -> crate::output::delete_intent_output::Builder {
        crate::output::delete_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImportOutput {
    /// <p>The unique identifier of the deleted import.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
}
impl DeleteImportOutput {
    /// <p>The unique identifier of the deleted import.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>
    pub fn import_status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.import_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImportOutput");
        formatter.field("import_id", &self.import_id);
        formatter.field("import_status", &self.import_status);
        formatter.finish()
    }
}
/// See [`DeleteImportOutput`](crate::output::DeleteImportOutput)
pub mod delete_import_output {
    /// A builder for [`DeleteImportOutput`](crate::output::DeleteImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the deleted import.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the deleted import.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The current status of the deletion. When the deletion is complete, the import will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html">ListImports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html">DescribeImport</a> operation with the import identifier will fail.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImportOutput`](crate::output::DeleteImportOutput)
        pub fn build(self) -> crate::output::DeleteImportOutput {
            crate::output::DeleteImportOutput {
                import_id: self.import_id,
                import_status: self.import_status,
            }
        }
    }
}
impl DeleteImportOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImportOutput`](crate::output::DeleteImportOutput)
    pub fn builder() -> crate::output::delete_import_output::Builder {
        crate::output::delete_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteExportOutput {
    /// <p>The unique identifier of the deleted export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
}
impl DeleteExportOutput {
    /// <p>The unique identifier of the deleted export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteExportOutput");
        formatter.field("export_id", &self.export_id);
        formatter.field("export_status", &self.export_status);
        formatter.finish()
    }
}
/// See [`DeleteExportOutput`](crate::output::DeleteExportOutput)
pub mod delete_export_output {
    /// A builder for [`DeleteExportOutput`](crate::output::DeleteExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the deleted export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the deleted export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The current status of the deletion. When the deletion is complete, the export will no longer be returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html">ListExports</a> operation and calls to the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html"> DescribeExport</a> operation with the export identifier will fail.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteExportOutput`](crate::output::DeleteExportOutput)
        pub fn build(self) -> crate::output::DeleteExportOutput {
            crate::output::DeleteExportOutput {
                export_id: self.export_id,
                export_status: self.export_status,
            }
        }
    }
}
impl DeleteExportOutput {
    /// Creates a new builder-style object to manufacture [`DeleteExportOutput`](crate::output::DeleteExportOutput)
    pub fn builder() -> crate::output::delete_export_output::Builder {
        crate::output::delete_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomVocabularyOutput {
    /// <p>The identifier of the bot that the custom vocabulary was removed from.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that the custom vocabulary was removed from.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale identifier for the locale that the custom vocabulary was removed from.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of removing the custom vocabulary.</p>
    pub custom_vocabulary_status: std::option::Option<crate::model::CustomVocabularyStatus>,
}
impl DeleteCustomVocabularyOutput {
    /// <p>The identifier of the bot that the custom vocabulary was removed from.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that the custom vocabulary was removed from.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale identifier for the locale that the custom vocabulary was removed from.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of removing the custom vocabulary.</p>
    pub fn custom_vocabulary_status(
        &self,
    ) -> std::option::Option<&crate::model::CustomVocabularyStatus> {
        self.custom_vocabulary_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteCustomVocabularyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomVocabularyOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("custom_vocabulary_status", &self.custom_vocabulary_status);
        formatter.finish()
    }
}
/// See [`DeleteCustomVocabularyOutput`](crate::output::DeleteCustomVocabularyOutput)
pub mod delete_custom_vocabulary_output {
    /// A builder for [`DeleteCustomVocabularyOutput`](crate::output::DeleteCustomVocabularyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) custom_vocabulary_status:
            std::option::Option<crate::model::CustomVocabularyStatus>,
    }
    impl Builder {
        /// <p>The identifier of the bot that the custom vocabulary was removed from.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that the custom vocabulary was removed from.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that the custom vocabulary was removed from.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that the custom vocabulary was removed from.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale identifier for the locale that the custom vocabulary was removed from.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale identifier for the locale that the custom vocabulary was removed from.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of removing the custom vocabulary.</p>
        pub fn custom_vocabulary_status(
            mut self,
            input: crate::model::CustomVocabularyStatus,
        ) -> Self {
            self.custom_vocabulary_status = Some(input);
            self
        }
        /// <p>The status of removing the custom vocabulary.</p>
        pub fn set_custom_vocabulary_status(
            mut self,
            input: std::option::Option<crate::model::CustomVocabularyStatus>,
        ) -> Self {
            self.custom_vocabulary_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomVocabularyOutput`](crate::output::DeleteCustomVocabularyOutput)
        pub fn build(self) -> crate::output::DeleteCustomVocabularyOutput {
            crate::output::DeleteCustomVocabularyOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                custom_vocabulary_status: self.custom_vocabulary_status,
            }
        }
    }
}
impl DeleteCustomVocabularyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomVocabularyOutput`](crate::output::DeleteCustomVocabularyOutput)
    pub fn builder() -> crate::output::delete_custom_vocabulary_output::Builder {
        crate::output::delete_custom_vocabulary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotVersionOutput {
    /// <p>The identifier of the bot that is being deleted.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that is being deleted.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The current status of the bot. </p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
}
impl DeleteBotVersionOutput {
    /// <p>The identifier of the bot that is being deleted.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that is being deleted.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The current status of the bot. </p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteBotVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotVersionOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_status", &self.bot_status);
        formatter.finish()
    }
}
/// See [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
pub mod delete_bot_version_output {
    /// A builder for [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
    }
    impl Builder {
        /// <p>The identifier of the bot that is being deleted.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that is being deleted.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that is being deleted.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that is being deleted.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The current status of the bot. </p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The current status of the bot. </p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
        pub fn build(self) -> crate::output::DeleteBotVersionOutput {
            crate::output::DeleteBotVersionOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                bot_status: self.bot_status,
            }
        }
    }
}
impl DeleteBotVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
    pub fn builder() -> crate::output::delete_bot_version_output::Builder {
        crate::output::delete_bot_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotLocaleOutput {
    /// <p>The identifier of the bot that contained the deleted locale.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that contained the deleted locale.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale of the deleted locale.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
}
impl DeleteBotLocaleOutput {
    /// <p>The identifier of the bot that contained the deleted locale.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that contained the deleted locale.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale of the deleted locale.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>
    pub fn bot_locale_status(&self) -> std::option::Option<&crate::model::BotLocaleStatus> {
        self.bot_locale_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteBotLocaleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotLocaleOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.finish()
    }
}
/// See [`DeleteBotLocaleOutput`](crate::output::DeleteBotLocaleOutput)
pub mod delete_bot_locale_output {
    /// A builder for [`DeleteBotLocaleOutput`](crate::output::DeleteBotLocaleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    }
    impl Builder {
        /// <p>The identifier of the bot that contained the deleted locale.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot that contained the deleted locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that contained the deleted locale.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that contained the deleted locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale of the deleted locale.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the deleted locale.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The status of deleting the bot locale. The locale first enters the <code>Deleting</code> status. Once the locale is deleted it no longer appears in the list of locales for the bot.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotLocaleOutput`](crate::output::DeleteBotLocaleOutput)
        pub fn build(self) -> crate::output::DeleteBotLocaleOutput {
            crate::output::DeleteBotLocaleOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_locale_status: self.bot_locale_status,
            }
        }
    }
}
impl DeleteBotLocaleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotLocaleOutput`](crate::output::DeleteBotLocaleOutput)
    pub fn builder() -> crate::output::delete_bot_locale_output::Builder {
        crate::output::delete_bot_locale_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotAliasOutput {
    /// <p>The unique identifier of the bot alias to delete.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the bot that contains the alias to delete.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>
    pub bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
}
impl DeleteBotAliasOutput {
    /// <p>The unique identifier of the bot alias to delete.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The unique identifier of the bot that contains the alias to delete.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>
    pub fn bot_alias_status(&self) -> std::option::Option<&crate::model::BotAliasStatus> {
        self.bot_alias_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotAliasOutput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_alias_status", &self.bot_alias_status);
        formatter.finish()
    }
}
/// See [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
pub mod delete_bot_alias_output {
    /// A builder for [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The unique identifier of the bot that contains the alias to delete.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that contains the alias to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>
        pub fn bot_alias_status(mut self, input: crate::model::BotAliasStatus) -> Self {
            self.bot_alias_status = Some(input);
            self
        }
        /// <p>The current status of the alias. The status is <code>Deleting</code> while the alias is in the process of being deleted. Once the alias is deleted, it will no longer appear in the list of aliases returned by the <code>ListBotAliases</code> operation.</p>
        pub fn set_bot_alias_status(
            mut self,
            input: std::option::Option<crate::model::BotAliasStatus>,
        ) -> Self {
            self.bot_alias_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
        pub fn build(self) -> crate::output::DeleteBotAliasOutput {
            crate::output::DeleteBotAliasOutput {
                bot_alias_id: self.bot_alias_id,
                bot_id: self.bot_id,
                bot_alias_status: self.bot_alias_status,
            }
        }
    }
}
impl DeleteBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
    pub fn builder() -> crate::output::delete_bot_alias_output::Builder {
        crate::output::delete_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotOutput {
    /// <p>The unique identifier of the bot that Amazon Lex is deleting.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
}
impl DeleteBotOutput {
    /// <p>The unique identifier of the bot that Amazon Lex is deleting.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
}
impl std::fmt::Debug for DeleteBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_status", &self.bot_status);
        formatter.finish()
    }
}
/// See [`DeleteBotOutput`](crate::output::DeleteBotOutput)
pub mod delete_bot_output {
    /// A builder for [`DeleteBotOutput`](crate::output::DeleteBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the bot that Amazon Lex is deleting.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that Amazon Lex is deleting.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are being deleted.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotOutput`](crate::output::DeleteBotOutput)
        pub fn build(self) -> crate::output::DeleteBotOutput {
            crate::output::DeleteBotOutput {
                bot_id: self.bot_id,
                bot_status: self.bot_status,
            }
        }
    }
}
impl DeleteBotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotOutput`](crate::output::DeleteBotOutput)
    pub fn builder() -> crate::output::delete_bot_output::Builder {
        crate::output::delete_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUploadUrlOutput {
    /// <p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>
    pub upload_url: std::option::Option<std::string::String>,
}
impl CreateUploadUrlOutput {
    /// <p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>
    pub fn upload_url(&self) -> std::option::Option<&str> {
        self.upload_url.as_deref()
    }
}
impl std::fmt::Debug for CreateUploadUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUploadUrlOutput");
        formatter.field("import_id", &self.import_id);
        formatter.field("upload_url", &self.upload_url);
        formatter.finish()
    }
}
/// See [`CreateUploadUrlOutput`](crate::output::CreateUploadUrlOutput)
pub mod create_upload_url_output {
    /// A builder for [`CreateUploadUrlOutput`](crate::output::CreateUploadUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) upload_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>An identifier for a unique import job. Use it when you call the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html">StartImport</a> operation.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>
        pub fn upload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_url = Some(input.into());
            self
        }
        /// <p>A pre-signed S3 write URL. Upload the zip archive file that contains the definition of your bot or bot locale.</p>
        pub fn set_upload_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upload_url = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUploadUrlOutput`](crate::output::CreateUploadUrlOutput)
        pub fn build(self) -> crate::output::CreateUploadUrlOutput {
            crate::output::CreateUploadUrlOutput {
                import_id: self.import_id,
                upload_url: self.upload_url,
            }
        }
    }
}
impl CreateUploadUrlOutput {
    /// Creates a new builder-style object to manufacture [`CreateUploadUrlOutput`](crate::output::CreateUploadUrlOutput)
    pub fn builder() -> crate::output::create_upload_url_output::Builder {
        crate::output::create_upload_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotTypeOutput {
    /// <p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the slot type.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The list of values that the slot type can assume.</p>
    pub slot_type_values: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
    /// <p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>
    pub value_selection_setting: std::option::Option<crate::model::SlotValueSelectionSetting>,
    /// <p>The signature of the base slot type specified for the slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The identifier for the bot associated with the slot type.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot type.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The specified language and local specified for the slot type.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the slot type was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of external information used to create the slot type.</p>
    pub external_source_setting: std::option::Option<crate::model::ExternalSourceSetting>,
}
impl CreateSlotTypeOutput {
    /// <p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The name specified for the slot type.</p>
    pub fn slot_type_name(&self) -> std::option::Option<&str> {
        self.slot_type_name.as_deref()
    }
    /// <p>The description specified for the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The list of values that the slot type can assume.</p>
    pub fn slot_type_values(&self) -> std::option::Option<&[crate::model::SlotTypeValue]> {
        self.slot_type_values.as_deref()
    }
    /// <p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>
    pub fn value_selection_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionSetting> {
        self.value_selection_setting.as_ref()
    }
    /// <p>The signature of the base slot type specified for the slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>The identifier for the bot associated with the slot type.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot type.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The specified language and local specified for the slot type.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the slot type was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>The type of external information used to create the slot type.</p>
    pub fn external_source_setting(
        &self,
    ) -> std::option::Option<&crate::model::ExternalSourceSetting> {
        self.external_source_setting.as_ref()
    }
}
impl std::fmt::Debug for CreateSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotTypeOutput");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_values", &self.slot_type_values);
        formatter.field("value_selection_setting", &self.value_selection_setting);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("external_source_setting", &self.external_source_setting);
        formatter.finish()
    }
}
/// See [`CreateSlotTypeOutput`](crate::output::CreateSlotTypeOutput)
pub mod create_slot_type_output {
    /// A builder for [`CreateSlotTypeOutput`](crate::output::CreateSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_values:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        pub(crate) value_selection_setting:
            std::option::Option<crate::model::SlotValueSelectionSetting>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) external_source_setting:
            std::option::Option<crate::model::ExternalSourceSetting>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the slot type. Use this to identify the slot type in the <code>UpdateSlotType</code> and <code>DeleteSlotType</code> operations.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The name specified for the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The name specified for the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>The description specified for the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slot_type_values`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>The list of values that the slot type can assume.</p>
        pub fn slot_type_values(mut self, input: crate::model::SlotTypeValue) -> Self {
            let mut v = self.slot_type_values.unwrap_or_default();
            v.push(input);
            self.slot_type_values = Some(v);
            self
        }
        /// <p>The list of values that the slot type can assume.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.slot_type_values = input;
            self
        }
        /// <p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>
        pub fn value_selection_setting(
            mut self,
            input: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.value_selection_setting = Some(input);
            self
        }
        /// <p>The strategy that Amazon Lex uses to select a value from the list of possible values.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.value_selection_setting = input;
            self
        }
        /// <p>The signature of the base slot type specified for the slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The signature of the base slot type specified for the slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>The identifier for the bot associated with the slot type.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier for the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The specified language and local specified for the slot type.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The specified language and local specified for the slot type.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot type was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot type was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The type of external information used to create the slot type.</p>
        pub fn external_source_setting(
            mut self,
            input: crate::model::ExternalSourceSetting,
        ) -> Self {
            self.external_source_setting = Some(input);
            self
        }
        /// <p>The type of external information used to create the slot type.</p>
        pub fn set_external_source_setting(
            mut self,
            input: std::option::Option<crate::model::ExternalSourceSetting>,
        ) -> Self {
            self.external_source_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotTypeOutput`](crate::output::CreateSlotTypeOutput)
        pub fn build(self) -> crate::output::CreateSlotTypeOutput {
            crate::output::CreateSlotTypeOutput {
                slot_type_id: self.slot_type_id,
                slot_type_name: self.slot_type_name,
                description: self.description,
                slot_type_values: self.slot_type_values,
                value_selection_setting: self.value_selection_setting,
                parent_slot_type_signature: self.parent_slot_type_signature,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
                external_source_setting: self.external_source_setting,
            }
        }
    }
}
impl CreateSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeOutput`](crate::output::CreateSlotTypeOutput)
    pub fn builder() -> crate::output::create_slot_type_output::Builder {
        crate::output::create_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotOutput {
    /// <p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>The description associated with the slot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the slot type associated with this slot.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The value elicitation settings specified for the slot.</p>
    pub value_elicitation_setting: std::option::Option<crate::model::SlotValueElicitationSetting>,
    /// <p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>The unique identifier of the bot associated with the slot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with the slot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and local specified for the slot.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the intent associated with the slot.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The timestamp of the date and time that the slot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates whether the slot returns multiple values in one response.</p>
    pub multiple_values_setting: std::option::Option<crate::model::MultipleValuesSetting>,
}
impl CreateSlotOutput {
    /// <p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>
    pub fn slot_id(&self) -> std::option::Option<&str> {
        self.slot_id.as_deref()
    }
    /// <p>The name specified for the slot.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>The description associated with the slot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier of the slot type associated with this slot.</p>
    pub fn slot_type_id(&self) -> std::option::Option<&str> {
        self.slot_type_id.as_deref()
    }
    /// <p>The value elicitation settings specified for the slot.</p>
    pub fn value_elicitation_setting(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueElicitationSetting> {
        self.value_elicitation_setting.as_ref()
    }
    /// <p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>The unique identifier of the bot associated with the slot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot associated with the slot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and local specified for the slot.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The unique identifier of the intent associated with the slot.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The timestamp of the date and time that the slot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>Indicates whether the slot returns multiple values in one response.</p>
    pub fn multiple_values_setting(
        &self,
    ) -> std::option::Option<&crate::model::MultipleValuesSetting> {
        self.multiple_values_setting.as_ref()
    }
}
impl std::fmt::Debug for CreateSlotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotOutput");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("value_elicitation_setting", &self.value_elicitation_setting);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("intent_id", &self.intent_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("multiple_values_setting", &self.multiple_values_setting);
        formatter.finish()
    }
}
/// See [`CreateSlotOutput`](crate::output::CreateSlotOutput)
pub mod create_slot_output {
    /// A builder for [`CreateSlotOutput`](crate::output::CreateSlotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_setting:
            std::option::Option<crate::model::SlotValueElicitationSetting>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) multiple_values_setting:
            std::option::Option<crate::model::MultipleValuesSetting>,
    }
    impl Builder {
        /// <p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier associated with the slot. Use this to identify the slot when you update or delete it.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The name specified for the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The name specified for the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>The description associated with the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description associated with the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier of the slot type associated with this slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the slot type associated with this slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The value elicitation settings specified for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            input: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.value_elicitation_setting = Some(input);
            self
        }
        /// <p>The value elicitation settings specified for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.value_elicitation_setting = input;
            self
        }
        /// <p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>Indicates whether the slot is configured to obfuscate values in Amazon CloudWatch logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>The unique identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and local specified for the slot.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and local specified for the slot.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The unique identifier of the intent associated with the slot.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the intent associated with the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The timestamp of the date and time that the slot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the date and time that the slot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response.</p>
        pub fn multiple_values_setting(
            mut self,
            input: crate::model::MultipleValuesSetting,
        ) -> Self {
            self.multiple_values_setting = Some(input);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.multiple_values_setting = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotOutput`](crate::output::CreateSlotOutput)
        pub fn build(self) -> crate::output::CreateSlotOutput {
            crate::output::CreateSlotOutput {
                slot_id: self.slot_id,
                slot_name: self.slot_name,
                description: self.description,
                slot_type_id: self.slot_type_id,
                value_elicitation_setting: self.value_elicitation_setting,
                obfuscation_setting: self.obfuscation_setting,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                intent_id: self.intent_id,
                creation_date_time: self.creation_date_time,
                multiple_values_setting: self.multiple_values_setting,
            }
        }
    }
}
impl CreateSlotOutput {
    /// Creates a new builder-style object to manufacture [`CreateSlotOutput`](crate::output::CreateSlotOutput)
    pub fn builder() -> crate::output::create_slot_output::Builder {
        crate::output::create_slot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourcePolicyStatementOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl CreateResourcePolicyStatementOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for CreateResourcePolicyStatementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourcePolicyStatementOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`CreateResourcePolicyStatementOutput`](crate::output::CreateResourcePolicyStatementOutput)
pub mod create_resource_policy_statement_output {
    /// A builder for [`CreateResourcePolicyStatementOutput`](crate::output::CreateResourcePolicyStatementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourcePolicyStatementOutput`](crate::output::CreateResourcePolicyStatementOutput)
        pub fn build(self) -> crate::output::CreateResourcePolicyStatementOutput {
            crate::output::CreateResourcePolicyStatementOutput {
                resource_arn: self.resource_arn,
                revision_id: self.revision_id,
            }
        }
    }
}
impl CreateResourcePolicyStatementOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyStatementOutput`](crate::output::CreateResourcePolicyStatementOutput)
    pub fn builder() -> crate::output::create_resource_policy_statement_output::Builder {
        crate::output::create_resource_policy_statement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl CreateResourcePolicyOutput {
    /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for CreateResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResourcePolicyOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`CreateResourcePolicyOutput`](crate::output::CreateResourcePolicyOutput)
pub mod create_resource_policy_output {
    /// A builder for [`CreateResourcePolicyOutput`](crate::output::CreateResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy was attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The current revision of the resource policy. Use the revision ID to make sure that you are updating the most current version of a resource policy when you add a policy statement to a resource, delete a resource, or update a resource.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResourcePolicyOutput`](crate::output::CreateResourcePolicyOutput)
        pub fn build(self) -> crate::output::CreateResourcePolicyOutput {
            crate::output::CreateResourcePolicyOutput {
                resource_arn: self.resource_arn,
                revision_id: self.revision_id,
            }
        }
    }
}
impl CreateResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyOutput`](crate::output::CreateResourcePolicyOutput)
    pub fn builder() -> crate::output::create_resource_policy_output::Builder {
        crate::output::create_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntentOutput {
    /// <p>A unique identifier for the intent.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The signature of the parent intent specified for the intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The sample utterances specified for the intent.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>The dialog Lambda function specified for the intent.</p>
    pub dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
    /// <p>The fulfillment Lambda function specified for the intent.</p>
    pub fulfillment_code_hook: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
    /// <p>The confirmation setting specified for the intent.</p>
    pub intent_confirmation_setting: std::option::Option<crate::model::IntentConfirmationSetting>,
    /// <p>The closing setting specified for the intent.</p>
    pub intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
    /// <p>The list of input contexts specified for the intent.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>The list of output contexts specified for the intent.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>Configuration for searching a Amazon Kendra index specified for the intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>The identifier of the bot associated with the intent.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the version of the bot associated with the intent.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The locale that the intent is specified to use.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the intent was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateIntentOutput {
    /// <p>A unique identifier for the intent.</p>
    pub fn intent_id(&self) -> std::option::Option<&str> {
        self.intent_id.as_deref()
    }
    /// <p>The name specified for the intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>The description specified for the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The signature of the parent intent specified for the intent.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>The sample utterances specified for the intent.</p>
    pub fn sample_utterances(&self) -> std::option::Option<&[crate::model::SampleUtterance]> {
        self.sample_utterances.as_deref()
    }
    /// <p>The dialog Lambda function specified for the intent.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::DialogCodeHookSettings> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>The fulfillment Lambda function specified for the intent.</p>
    pub fn fulfillment_code_hook(
        &self,
    ) -> std::option::Option<&crate::model::FulfillmentCodeHookSettings> {
        self.fulfillment_code_hook.as_ref()
    }
    /// <p>The confirmation setting specified for the intent.</p>
    pub fn intent_confirmation_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentConfirmationSetting> {
        self.intent_confirmation_setting.as_ref()
    }
    /// <p>The closing setting specified for the intent.</p>
    pub fn intent_closing_setting(
        &self,
    ) -> std::option::Option<&crate::model::IntentClosingSetting> {
        self.intent_closing_setting.as_ref()
    }
    /// <p>The list of input contexts specified for the intent.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>The list of output contexts specified for the intent.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
    /// <p>Configuration for searching a Amazon Kendra index specified for the intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>The identifier of the bot associated with the intent.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The identifier of the version of the bot associated with the intent.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The locale that the intent is specified to use.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>A timestamp of the date and time that the intent was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntentOutput");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_code_hook", &self.fulfillment_code_hook);
        formatter.field(
            "intent_confirmation_setting",
            &self.intent_confirmation_setting,
        );
        formatter.field("intent_closing_setting", &self.intent_closing_setting);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateIntentOutput`](crate::output::CreateIntentOutput)
pub mod create_intent_output {
    /// A builder for [`CreateIntentOutput`](crate::output::CreateIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::DialogCodeHookSettings>,
        pub(crate) fulfillment_code_hook:
            std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        pub(crate) intent_confirmation_setting:
            std::option::Option<crate::model::IntentConfirmationSetting>,
        pub(crate) intent_closing_setting: std::option::Option<crate::model::IntentClosingSetting>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the intent.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the intent.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The name specified for the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name specified for the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The description specified for the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The signature of the parent intent specified for the intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>The signature of the parent intent specified for the intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>The sample utterances specified for the intent.</p>
        pub fn sample_utterances(mut self, input: crate::model::SampleUtterance) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input);
            self.sample_utterances = Some(v);
            self
        }
        /// <p>The sample utterances specified for the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>The dialog Lambda function specified for the intent.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::DialogCodeHookSettings) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>The dialog Lambda function specified for the intent.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>The fulfillment Lambda function specified for the intent.</p>
        pub fn fulfillment_code_hook(
            mut self,
            input: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.fulfillment_code_hook = Some(input);
            self
        }
        /// <p>The fulfillment Lambda function specified for the intent.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.fulfillment_code_hook = input;
            self
        }
        /// <p>The confirmation setting specified for the intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            input: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.intent_confirmation_setting = Some(input);
            self
        }
        /// <p>The confirmation setting specified for the intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.intent_confirmation_setting = input;
            self
        }
        /// <p>The closing setting specified for the intent.</p>
        pub fn intent_closing_setting(mut self, input: crate::model::IntentClosingSetting) -> Self {
            self.intent_closing_setting = Some(input);
            self
        }
        /// <p>The closing setting specified for the intent.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.intent_closing_setting = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>The list of input contexts specified for the intent.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input);
            self.input_contexts = Some(v);
            self
        }
        /// <p>The list of input contexts specified for the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>The list of output contexts specified for the intent.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input);
            self.output_contexts = Some(v);
            self
        }
        /// <p>The list of output contexts specified for the intent.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>Configuration for searching a Amazon Kendra index specified for the intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration for searching a Amazon Kendra index specified for the intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The identifier of the version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The identifier of the version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The locale that the intent is specified to use.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The locale that the intent is specified to use.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>A timestamp of the date and time that the intent was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the intent was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntentOutput`](crate::output::CreateIntentOutput)
        pub fn build(self) -> crate::output::CreateIntentOutput {
            crate::output::CreateIntentOutput {
                intent_id: self.intent_id,
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                sample_utterances: self.sample_utterances,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_code_hook: self.fulfillment_code_hook,
                intent_confirmation_setting: self.intent_confirmation_setting,
                intent_closing_setting: self.intent_closing_setting,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                kendra_configuration: self.kendra_configuration,
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateIntentOutput {
    /// Creates a new builder-style object to manufacture [`CreateIntentOutput`](crate::output::CreateIntentOutput)
    pub fn builder() -> crate::output::create_intent_output::Builder {
        crate::output::create_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateExportOutput {
    /// <p>An identifier for a specific request to create an export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    pub resource_specification: std::option::Option<crate::model::ExportResourceSpecification>,
    /// <p>The file format used for the bot or bot locale definition files.</p>
    pub file_format: std::option::Option<crate::model::ImportExportFileFormat>,
    /// <p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>The date and time that the request to export a bot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateExportOutput {
    /// <p>An identifier for a specific request to create an export.</p>
    pub fn export_id(&self) -> std::option::Option<&str> {
        self.export_id.as_deref()
    }
    /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
    pub fn resource_specification(
        &self,
    ) -> std::option::Option<&crate::model::ExportResourceSpecification> {
        self.resource_specification.as_ref()
    }
    /// <p>The file format used for the bot or bot locale definition files.</p>
    pub fn file_format(&self) -> std::option::Option<&crate::model::ImportExportFileFormat> {
        self.file_format.as_ref()
    }
    /// <p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>The date and time that the request to export a bot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateExportOutput");
        formatter.field("export_id", &self.export_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("file_format", &self.file_format);
        formatter.field("export_status", &self.export_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateExportOutput`](crate::output::CreateExportOutput)
pub mod create_export_output {
    /// A builder for [`CreateExportOutput`](crate::output::CreateExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ExportResourceSpecification>,
        pub(crate) file_format: std::option::Option<crate::model::ImportExportFileFormat>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>An identifier for a specific request to create an export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>An identifier for a specific request to create an export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>A description of the type of resource that was exported, either a bot or a bot locale.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The file format used for the bot or bot locale definition files.</p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file format used for the bot or bot locale definition files.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code>, you can use the <a href="https://docs.aws.amazon.com/latest/dg/API_DescribeExport.html">DescribeExport</a> operation to get the pre-signed S3 URL link to your exported bot or bot locale.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>The date and time that the request to export a bot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the request to export a bot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateExportOutput`](crate::output::CreateExportOutput)
        pub fn build(self) -> crate::output::CreateExportOutput {
            crate::output::CreateExportOutput {
                export_id: self.export_id,
                resource_specification: self.resource_specification,
                file_format: self.file_format,
                export_status: self.export_status,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateExportOutput {
    /// Creates a new builder-style object to manufacture [`CreateExportOutput`](crate::output::CreateExportOutput)
    pub fn builder() -> crate::output::create_export_output::Builder {
        crate::output::create_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotVersionOutput {
    /// <p>The bot identifier specified in the request.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The description of the version specified in the request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version number assigned to the version.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The source versions used for each locale in the new version.</p>
    pub bot_version_locale_specification: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
    >,
    /// <p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can't build the bot, it sets status to <code>Failed</code>.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>A timestamp of the date and time that the version was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateBotVersionOutput {
    /// <p>The bot identifier specified in the request.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The description of the version specified in the request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version number assigned to the version.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The source versions used for each locale in the new version.</p>
    pub fn bot_version_locale_specification(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
    > {
        self.bot_version_locale_specification.as_ref()
    }
    /// <p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can't build the bot, it sets status to <code>Failed</code>.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
    /// <p>A timestamp of the date and time that the version was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateBotVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotVersionOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field(
            "bot_version_locale_specification",
            &self.bot_version_locale_specification,
        );
        formatter.field("bot_status", &self.bot_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
pub mod create_bot_version_output {
    /// A builder for [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_version_locale_specification: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotVersionLocaleDetails>,
        >,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The bot identifier specified in the request.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The bot identifier specified in the request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The description of the version specified in the request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version specified in the request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version number assigned to the version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version number assigned to the version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_version_locale_specification`.
        ///
        /// To override the contents of this collection use [`set_bot_version_locale_specification`](Self::set_bot_version_locale_specification).
        ///
        /// <p>The source versions used for each locale in the new version.</p>
        pub fn bot_version_locale_specification(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotVersionLocaleDetails,
        ) -> Self {
            let mut hash_map = self.bot_version_locale_specification.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_version_locale_specification = Some(hash_map);
            self
        }
        /// <p>The source versions used for each locale in the new version.</p>
        pub fn set_bot_version_locale_specification(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotVersionLocaleDetails,
                >,
            >,
        ) -> Self {
            self.bot_version_locale_specification = input;
            self
        }
        /// <p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can't build the bot, it sets status to <code>Failed</code>.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>When you send a request to create or update a bot, Amazon Lex sets the status response element to <code>Creating</code>. After Amazon Lex builds the bot, it sets status to <code>Available</code>. If Amazon Lex can't build the bot, it sets status to <code>Failed</code>.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the version was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the version was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
        pub fn build(self) -> crate::output::CreateBotVersionOutput {
            crate::output::CreateBotVersionOutput {
                bot_id: self.bot_id,
                description: self.description,
                bot_version: self.bot_version,
                bot_version_locale_specification: self.bot_version_locale_specification,
                bot_status: self.bot_status,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateBotVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
    pub fn builder() -> crate::output::create_bot_version_output::Builder {
        crate::output::create_bot_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotLocaleOutput {
    /// <p>The specified bot identifier.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The specified bot version.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The specified locale name.</p>
    pub locale_name: std::option::Option<std::string::String>,
    /// <p>The specified locale identifier.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The specified description of the bot locale.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
    /// <p>The status of the bot.</p>
    /// <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p>
    /// <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p>
    /// <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    /// <p>A timestamp specifying the date and time that the bot locale was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateBotLocaleOutput {
    /// <p>The specified bot identifier.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The specified bot version.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The specified locale name.</p>
    pub fn locale_name(&self) -> std::option::Option<&str> {
        self.locale_name.as_deref()
    }
    /// <p>The specified locale identifier.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The specified description of the bot locale.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
    pub fn voice_settings(&self) -> std::option::Option<&crate::model::VoiceSettings> {
        self.voice_settings.as_ref()
    }
    /// <p>The status of the bot.</p>
    /// <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p>
    /// <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p>
    /// <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>
    pub fn bot_locale_status(&self) -> std::option::Option<&crate::model::BotLocaleStatus> {
        self.bot_locale_status.as_ref()
    }
    /// <p>A timestamp specifying the date and time that the bot locale was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
}
impl std::fmt::Debug for CreateBotLocaleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotLocaleOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_name", &self.locale_name);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("description", &self.description);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`CreateBotLocaleOutput`](crate::output::CreateBotLocaleOutput)
pub mod create_bot_locale_output {
    /// A builder for [`CreateBotLocaleOutput`](crate::output::CreateBotLocaleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_name: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The specified bot identifier.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The specified bot identifier.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The specified bot version.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The specified bot version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The specified locale name.</p>
        pub fn locale_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_name = Some(input.into());
            self
        }
        /// <p>The specified locale name.</p>
        pub fn set_locale_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_name = input;
            self
        }
        /// <p>The specified locale identifier.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The specified locale identifier.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The specified description of the bot locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The specified description of the bot locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> intents.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// <p>The status of the bot.</p>
        /// <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p>
        /// <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p>
        /// <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The status of the bot.</p>
        /// <p>When the status is <code>Creating</code> the bot locale is being configured. When the status is <code>Building</code> Amazon Lex is building the bot for testing and use.</p>
        /// <p>If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status is <code>Built</code>.</p>
        /// <p>If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not built, the status is <code>NotBuilt</code>.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// <p>A timestamp specifying the date and time that the bot locale was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp specifying the date and time that the bot locale was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotLocaleOutput`](crate::output::CreateBotLocaleOutput)
        pub fn build(self) -> crate::output::CreateBotLocaleOutput {
            crate::output::CreateBotLocaleOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_name: self.locale_name,
                locale_id: self.locale_id,
                description: self.description,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
                bot_locale_status: self.bot_locale_status,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl CreateBotLocaleOutput {
    /// Creates a new builder-style object to manufacture [`CreateBotLocaleOutput`](crate::output::CreateBotLocaleOutput)
    pub fn builder() -> crate::output::create_bot_locale_output::Builder {
        crate::output::create_bot_locale_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotAliasOutput {
    /// <p>The unique identifier of the bot alias.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the bot alias.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot associated with this alias.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>Configuration information for a specific locale.</p>
    pub bot_alias_locale_settings: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    >,
    /// <p>The conversation log settings specified for the alias.</p>
    pub conversation_log_settings: std::option::Option<crate::model::ConversationLogSettings>,
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub sentiment_analysis_settings: std::option::Option<crate::model::SentimentAnalysisSettings>,
    /// <p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>
    pub bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
    /// <p>The unique identifier of the bot that this alias applies to.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>A Unix timestamp indicating the date and time that the bot alias was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of tags associated with the bot alias.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateBotAliasOutput {
    /// <p>The unique identifier of the bot alias.</p>
    pub fn bot_alias_id(&self) -> std::option::Option<&str> {
        self.bot_alias_id.as_deref()
    }
    /// <p>The name specified for the bot alias.</p>
    pub fn bot_alias_name(&self) -> std::option::Option<&str> {
        self.bot_alias_name.as_deref()
    }
    /// <p>The description specified for the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot associated with this alias.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>Configuration information for a specific locale.</p>
    pub fn bot_alias_locale_settings(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
    > {
        self.bot_alias_locale_settings.as_ref()
    }
    /// <p>The conversation log settings specified for the alias.</p>
    pub fn conversation_log_settings(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogSettings> {
        self.conversation_log_settings.as_ref()
    }
    /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
    pub fn sentiment_analysis_settings(
        &self,
    ) -> std::option::Option<&crate::model::SentimentAnalysisSettings> {
        self.sentiment_analysis_settings.as_ref()
    }
    /// <p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>
    pub fn bot_alias_status(&self) -> std::option::Option<&crate::model::BotAliasStatus> {
        self.bot_alias_status.as_ref()
    }
    /// <p>The unique identifier of the bot that this alias applies to.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>A Unix timestamp indicating the date and time that the bot alias was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A list of tags associated with the bot alias.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotAliasOutput");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_locale_settings", &self.bot_alias_locale_settings);
        formatter.field("conversation_log_settings", &self.conversation_log_settings);
        formatter.field(
            "sentiment_analysis_settings",
            &self.sentiment_analysis_settings,
        );
        formatter.field("bot_alias_status", &self.bot_alias_status);
        formatter.field("bot_id", &self.bot_id);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateBotAliasOutput`](crate::output::CreateBotAliasOutput)
pub mod create_bot_alias_output {
    /// A builder for [`CreateBotAliasOutput`](crate::output::CreateBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_locale_settings: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::BotAliasLocaleSettings>,
        >,
        pub(crate) conversation_log_settings:
            std::option::Option<crate::model::ConversationLogSettings>,
        pub(crate) sentiment_analysis_settings:
            std::option::Option<crate::model::SentimentAnalysisSettings>,
        pub(crate) bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique identifier of the bot alias.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The name specified for the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The name specified for the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>The description specified for the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot associated with this alias.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot associated with this alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Adds a key-value pair to `bot_alias_locale_settings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>Configuration information for a specific locale.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BotAliasLocaleSettings,
        ) -> Self {
            let mut hash_map = self.bot_alias_locale_settings.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.bot_alias_locale_settings = Some(hash_map);
            self
        }
        /// <p>Configuration information for a specific locale.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.bot_alias_locale_settings = input;
            self
        }
        /// <p>The conversation log settings specified for the alias.</p>
        pub fn conversation_log_settings(
            mut self,
            input: crate::model::ConversationLogSettings,
        ) -> Self {
            self.conversation_log_settings = Some(input);
            self
        }
        /// <p>The conversation log settings specified for the alias.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.conversation_log_settings = input;
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            input: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.sentiment_analysis_settings = Some(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.sentiment_analysis_settings = input;
            self
        }
        /// <p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>
        pub fn bot_alias_status(mut self, input: crate::model::BotAliasStatus) -> Self {
            self.bot_alias_status = Some(input);
            self
        }
        /// <p>The current status of the alias. The alias is first put into the <code>Creating</code> state. When the alias is ready to be used, it is put into the <code>Available</code> state. You can use the <code>DescribeBotAlias</code> operation to get the current state of an alias.</p>
        pub fn set_bot_alias_status(
            mut self,
            input: std::option::Option<crate::model::BotAliasStatus>,
        ) -> Self {
            self.bot_alias_status = input;
            self
        }
        /// <p>The unique identifier of the bot that this alias applies to.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the bot that this alias applies to.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>A Unix timestamp indicating the date and time that the bot alias was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A Unix timestamp indicating the date and time that the bot alias was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the bot alias.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the bot alias.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotAliasOutput`](crate::output::CreateBotAliasOutput)
        pub fn build(self) -> crate::output::CreateBotAliasOutput {
            crate::output::CreateBotAliasOutput {
                bot_alias_id: self.bot_alias_id,
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_locale_settings: self.bot_alias_locale_settings,
                conversation_log_settings: self.conversation_log_settings,
                sentiment_analysis_settings: self.sentiment_analysis_settings,
                bot_alias_status: self.bot_alias_status,
                bot_id: self.bot_id,
                creation_date_time: self.creation_date_time,
                tags: self.tags,
            }
        }
    }
}
impl CreateBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateBotAliasOutput`](crate::output::CreateBotAliasOutput)
    pub fn builder() -> crate::output::create_bot_alias_output::Builder {
        crate::output::create_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotOutput {
    /// <p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The name specified for the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The description specified for the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The IAM role specified for the bot.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The data privacy settings specified for the bot.</p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The session idle time specified for the bot.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>A timestamp indicating the date and time that the bot was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of tags associated with the bot.</p>
    pub bot_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of tags associated with the test alias for the bot.</p>
    pub test_bot_alias_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateBotOutput {
    /// <p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The name specified for the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The description specified for the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The IAM role specified for the bot.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The data privacy settings specified for the bot.</p>
    pub fn data_privacy(&self) -> std::option::Option<&crate::model::DataPrivacy> {
        self.data_privacy.as_ref()
    }
    /// <p>The session idle time specified for the bot.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>
    pub fn bot_status(&self) -> std::option::Option<&crate::model::BotStatus> {
        self.bot_status.as_ref()
    }
    /// <p>A timestamp indicating the date and time that the bot was created.</p>
    pub fn creation_date_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date_time.as_ref()
    }
    /// <p>A list of tags associated with the bot.</p>
    pub fn bot_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.bot_tags.as_ref()
    }
    /// <p>A list of tags associated with the test alias for the bot.</p>
    pub fn test_bot_alias_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.test_bot_alias_tags.as_ref()
    }
}
impl std::fmt::Debug for CreateBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_status", &self.bot_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("bot_tags", &self.bot_tags);
        formatter.field("test_bot_alias_tags", &self.test_bot_alias_tags);
        formatter.finish()
    }
}
/// See [`CreateBotOutput`](crate::output::CreateBotOutput)
pub mod create_bot_output {
    /// A builder for [`CreateBotOutput`](crate::output::CreateBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bot_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) test_bot_alias_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for a particular bot. You use this to identify the bot when you call other Amazon Lex API operations.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The name specified for the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name specified for the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The description specified for the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description specified for the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The IAM role specified for the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The IAM role specified for the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The data privacy settings specified for the bot.</p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>The data privacy settings specified for the bot.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The session idle time specified for the bot.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The session idle time specified for the bot.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>Shows the current status of the bot. The bot is first in the <code>Creating</code> status. Once the bot is read for use, it changes to the <code>Available</code> status. After the bot is created, you can use the <code>Draft</code> version of the bot.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>A timestamp indicating the date and time that the bot was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp indicating the date and time that the bot was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Adds a key-value pair to `bot_tags`.
        ///
        /// To override the contents of this collection use [`set_bot_tags`](Self::set_bot_tags).
        ///
        /// <p>A list of tags associated with the bot.</p>
        pub fn bot_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.bot_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.bot_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the bot.</p>
        pub fn set_bot_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.bot_tags = input;
            self
        }
        /// Adds a key-value pair to `test_bot_alias_tags`.
        ///
        /// To override the contents of this collection use [`set_test_bot_alias_tags`](Self::set_test_bot_alias_tags).
        ///
        /// <p>A list of tags associated with the test alias for the bot.</p>
        pub fn test_bot_alias_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.test_bot_alias_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.test_bot_alias_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags associated with the test alias for the bot.</p>
        pub fn set_test_bot_alias_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.test_bot_alias_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotOutput`](crate::output::CreateBotOutput)
        pub fn build(self) -> crate::output::CreateBotOutput {
            crate::output::CreateBotOutput {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                description: self.description,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_status: self.bot_status,
                creation_date_time: self.creation_date_time,
                bot_tags: self.bot_tags,
                test_bot_alias_tags: self.test_bot_alias_tags,
            }
        }
    }
}
impl CreateBotOutput {
    /// Creates a new builder-style object to manufacture [`CreateBotOutput`](crate::output::CreateBotOutput)
    pub fn builder() -> crate::output::create_bot_output::Builder {
        crate::output::create_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildBotLocaleOutput {
    /// <p>The identifier of the specified bot.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that was built. This is only the draft version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The language and locale specified of where the bot can be used.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    /// <p>A timestamp indicating the date and time that the bot was last built for this locale.</p>
    pub last_build_submitted_date_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BuildBotLocaleOutput {
    /// <p>The identifier of the specified bot.</p>
    pub fn bot_id(&self) -> std::option::Option<&str> {
        self.bot_id.as_deref()
    }
    /// <p>The version of the bot that was built. This is only the draft version of the bot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The language and locale specified of where the bot can be used.</p>
    pub fn locale_id(&self) -> std::option::Option<&str> {
        self.locale_id.as_deref()
    }
    /// <p>The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>
    pub fn bot_locale_status(&self) -> std::option::Option<&crate::model::BotLocaleStatus> {
        self.bot_locale_status.as_ref()
    }
    /// <p>A timestamp indicating the date and time that the bot was last built for this locale.</p>
    pub fn last_build_submitted_date_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_build_submitted_date_time.as_ref()
    }
}
impl std::fmt::Debug for BuildBotLocaleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildBotLocaleOutput");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.field(
            "last_build_submitted_date_time",
            &self.last_build_submitted_date_time,
        );
        formatter.finish()
    }
}
/// See [`BuildBotLocaleOutput`](crate::output::BuildBotLocaleOutput)
pub mod build_bot_locale_output {
    /// A builder for [`BuildBotLocaleOutput`](crate::output::BuildBotLocaleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
        pub(crate) last_build_submitted_date_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the specified bot.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the specified bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that was built. This is only the draft version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that was built. This is only the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The language and locale specified of where the bot can be used.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale specified of where the bot can be used.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The bot's build status. When the status is <code>ReadyExpressTesting</code> you can test the bot using the utterances defined for the intents and slot types. When the status is <code>Built</code>, the bot is ready for use and can be tested using any utterance.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// <p>A timestamp indicating the date and time that the bot was last built for this locale.</p>
        pub fn last_build_submitted_date_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_build_submitted_date_time = Some(input);
            self
        }
        /// <p>A timestamp indicating the date and time that the bot was last built for this locale.</p>
        pub fn set_last_build_submitted_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_build_submitted_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildBotLocaleOutput`](crate::output::BuildBotLocaleOutput)
        pub fn build(self) -> crate::output::BuildBotLocaleOutput {
            crate::output::BuildBotLocaleOutput {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                bot_locale_status: self.bot_locale_status,
                last_build_submitted_date_time: self.last_build_submitted_date_time,
            }
        }
    }
}
impl BuildBotLocaleOutput {
    /// Creates a new builder-style object to manufacture [`BuildBotLocaleOutput`](crate::output::BuildBotLocaleOutput)
    pub fn builder() -> crate::output::build_bot_locale_output::Builder {
        crate::output::build_bot_locale_output::Builder::default()
    }
}
