// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BuildBotLocale`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`build_bot_locale`](crate::client::Client::build_bot_locale).
///
/// See [`crate::client::fluent_builders::BuildBotLocale`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BuildBotLocale {
    _private: (),
}
impl BuildBotLocale {
    /// Creates a new builder-style object to manufacture [`BuildBotLocaleInput`](crate::input::BuildBotLocaleInput)
    pub fn builder() -> crate::input::build_bot_locale_input::Builder {
        crate::input::build_bot_locale_input::Builder::default()
    }
    /// Creates a new `BuildBotLocale` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BuildBotLocale {
    type Output =
        std::result::Result<crate::output::BuildBotLocaleOutput, crate::error::BuildBotLocaleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_build_bot_locale_error(response)
        } else {
            crate::operation_deser::parse_build_bot_locale_response(response)
        }
    }
}

/// Operation shape for `CreateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot`](crate::client::Client::create_bot).
///
/// See [`crate::client::fluent_builders::CreateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBot {
    _private: (),
}
impl CreateBot {
    /// Creates a new builder-style object to manufacture [`CreateBotInput`](crate::input::CreateBotInput)
    pub fn builder() -> crate::input::create_bot_input::Builder {
        crate::input::create_bot_input::Builder::default()
    }
    /// Creates a new `CreateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBot {
    type Output = std::result::Result<crate::output::CreateBotOutput, crate::error::CreateBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_bot_error(response)
        } else {
            crate::operation_deser::parse_create_bot_response(response)
        }
    }
}

/// Operation shape for `CreateBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot_alias`](crate::client::Client::create_bot_alias).
///
/// See [`crate::client::fluent_builders::CreateBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBotAlias {
    _private: (),
}
impl CreateBotAlias {
    /// Creates a new builder-style object to manufacture [`CreateBotAliasInput`](crate::input::CreateBotAliasInput)
    pub fn builder() -> crate::input::create_bot_alias_input::Builder {
        crate::input::create_bot_alias_input::Builder::default()
    }
    /// Creates a new `CreateBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBotAlias {
    type Output =
        std::result::Result<crate::output::CreateBotAliasOutput, crate::error::CreateBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_create_bot_alias_response(response)
        }
    }
}

/// Operation shape for `CreateBotLocale`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot_locale`](crate::client::Client::create_bot_locale).
///
/// See [`crate::client::fluent_builders::CreateBotLocale`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBotLocale {
    _private: (),
}
impl CreateBotLocale {
    /// Creates a new builder-style object to manufacture [`CreateBotLocaleInput`](crate::input::CreateBotLocaleInput)
    pub fn builder() -> crate::input::create_bot_locale_input::Builder {
        crate::input::create_bot_locale_input::Builder::default()
    }
    /// Creates a new `CreateBotLocale` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBotLocale {
    type Output = std::result::Result<
        crate::output::CreateBotLocaleOutput,
        crate::error::CreateBotLocaleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_bot_locale_error(response)
        } else {
            crate::operation_deser::parse_create_bot_locale_response(response)
        }
    }
}

/// Operation shape for `CreateBotVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot_version`](crate::client::Client::create_bot_version).
///
/// See [`crate::client::fluent_builders::CreateBotVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBotVersion {
    _private: (),
}
impl CreateBotVersion {
    /// Creates a new builder-style object to manufacture [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    pub fn builder() -> crate::input::create_bot_version_input::Builder {
        crate::input::create_bot_version_input::Builder::default()
    }
    /// Creates a new `CreateBotVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBotVersion {
    type Output = std::result::Result<
        crate::output::CreateBotVersionOutput,
        crate::error::CreateBotVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_bot_version_error(response)
        } else {
            crate::operation_deser::parse_create_bot_version_response(response)
        }
    }
}

/// Operation shape for `CreateExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_export`](crate::client::Client::create_export).
///
/// See [`crate::client::fluent_builders::CreateExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExport {
    _private: (),
}
impl CreateExport {
    /// Creates a new builder-style object to manufacture [`CreateExportInput`](crate::input::CreateExportInput)
    pub fn builder() -> crate::input::create_export_input::Builder {
        crate::input::create_export_input::Builder::default()
    }
    /// Creates a new `CreateExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExport {
    type Output =
        std::result::Result<crate::output::CreateExportOutput, crate::error::CreateExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_export_error(response)
        } else {
            crate::operation_deser::parse_create_export_response(response)
        }
    }
}

/// Operation shape for `CreateIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_intent`](crate::client::Client::create_intent).
///
/// See [`crate::client::fluent_builders::CreateIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIntent {
    _private: (),
}
impl CreateIntent {
    /// Creates a new builder-style object to manufacture [`CreateIntentInput`](crate::input::CreateIntentInput)
    pub fn builder() -> crate::input::create_intent_input::Builder {
        crate::input::create_intent_input::Builder::default()
    }
    /// Creates a new `CreateIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIntent {
    type Output =
        std::result::Result<crate::output::CreateIntentOutput, crate::error::CreateIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_intent_error(response)
        } else {
            crate::operation_deser::parse_create_intent_response(response)
        }
    }
}

/// Operation shape for `CreateResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_policy`](crate::client::Client::create_resource_policy).
///
/// See [`crate::client::fluent_builders::CreateResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourcePolicy {
    _private: (),
}
impl CreateResourcePolicy {
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyInput`](crate::input::CreateResourcePolicyInput)
    pub fn builder() -> crate::input::create_resource_policy_input::Builder {
        crate::input::create_resource_policy_input::Builder::default()
    }
    /// Creates a new `CreateResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourcePolicy {
    type Output = std::result::Result<
        crate::output::CreateResourcePolicyOutput,
        crate::error::CreateResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_create_resource_policy_response(response)
        }
    }
}

/// Operation shape for `CreateResourcePolicyStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resource_policy_statement`](crate::client::Client::create_resource_policy_statement).
///
/// See [`crate::client::fluent_builders::CreateResourcePolicyStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResourcePolicyStatement {
    _private: (),
}
impl CreateResourcePolicyStatement {
    /// Creates a new builder-style object to manufacture [`CreateResourcePolicyStatementInput`](crate::input::CreateResourcePolicyStatementInput)
    pub fn builder() -> crate::input::create_resource_policy_statement_input::Builder {
        crate::input::create_resource_policy_statement_input::Builder::default()
    }
    /// Creates a new `CreateResourcePolicyStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResourcePolicyStatement {
    type Output = std::result::Result<
        crate::output::CreateResourcePolicyStatementOutput,
        crate::error::CreateResourcePolicyStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resource_policy_statement_error(response)
        } else {
            crate::operation_deser::parse_create_resource_policy_statement_response(response)
        }
    }
}

/// Operation shape for `CreateSlot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_slot`](crate::client::Client::create_slot).
///
/// See [`crate::client::fluent_builders::CreateSlot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSlot {
    _private: (),
}
impl CreateSlot {
    /// Creates a new builder-style object to manufacture [`CreateSlotInput`](crate::input::CreateSlotInput)
    pub fn builder() -> crate::input::create_slot_input::Builder {
        crate::input::create_slot_input::Builder::default()
    }
    /// Creates a new `CreateSlot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSlot {
    type Output =
        std::result::Result<crate::output::CreateSlotOutput, crate::error::CreateSlotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_slot_error(response)
        } else {
            crate::operation_deser::parse_create_slot_response(response)
        }
    }
}

/// Operation shape for `CreateSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_slot_type`](crate::client::Client::create_slot_type).
///
/// See [`crate::client::fluent_builders::CreateSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSlotType {
    _private: (),
}
impl CreateSlotType {
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeInput`](crate::input::CreateSlotTypeInput)
    pub fn builder() -> crate::input::create_slot_type_input::Builder {
        crate::input::create_slot_type_input::Builder::default()
    }
    /// Creates a new `CreateSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSlotType {
    type Output =
        std::result::Result<crate::output::CreateSlotTypeOutput, crate::error::CreateSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_slot_type_error(response)
        } else {
            crate::operation_deser::parse_create_slot_type_response(response)
        }
    }
}

/// Operation shape for `CreateUploadUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_upload_url`](crate::client::Client::create_upload_url).
///
/// See [`crate::client::fluent_builders::CreateUploadUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUploadUrl {
    _private: (),
}
impl CreateUploadUrl {
    /// Creates a new builder-style object to manufacture [`CreateUploadUrlInput`](crate::input::CreateUploadUrlInput)
    pub fn builder() -> crate::input::create_upload_url_input::Builder {
        crate::input::create_upload_url_input::Builder::default()
    }
    /// Creates a new `CreateUploadUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUploadUrl {
    type Output = std::result::Result<
        crate::output::CreateUploadUrlOutput,
        crate::error::CreateUploadUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_upload_url_error(response)
        } else {
            crate::operation_deser::parse_create_upload_url_response(response)
        }
    }
}

/// Operation shape for `DeleteBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot`](crate::client::Client::delete_bot).
///
/// See [`crate::client::fluent_builders::DeleteBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBot {
    _private: (),
}
impl DeleteBot {
    /// Creates a new builder-style object to manufacture [`DeleteBotInput`](crate::input::DeleteBotInput)
    pub fn builder() -> crate::input::delete_bot_input::Builder {
        crate::input::delete_bot_input::Builder::default()
    }
    /// Creates a new `DeleteBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBot {
    type Output = std::result::Result<crate::output::DeleteBotOutput, crate::error::DeleteBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_bot_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_response(response)
        }
    }
}

/// Operation shape for `DeleteBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_alias`](crate::client::Client::delete_bot_alias).
///
/// See [`crate::client::fluent_builders::DeleteBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotAlias {
    _private: (),
}
impl DeleteBotAlias {
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    pub fn builder() -> crate::input::delete_bot_alias_input::Builder {
        crate::input::delete_bot_alias_input::Builder::default()
    }
    /// Creates a new `DeleteBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotAlias {
    type Output =
        std::result::Result<crate::output::DeleteBotAliasOutput, crate::error::DeleteBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteBotLocale`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_locale`](crate::client::Client::delete_bot_locale).
///
/// See [`crate::client::fluent_builders::DeleteBotLocale`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotLocale {
    _private: (),
}
impl DeleteBotLocale {
    /// Creates a new builder-style object to manufacture [`DeleteBotLocaleInput`](crate::input::DeleteBotLocaleInput)
    pub fn builder() -> crate::input::delete_bot_locale_input::Builder {
        crate::input::delete_bot_locale_input::Builder::default()
    }
    /// Creates a new `DeleteBotLocale` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotLocale {
    type Output = std::result::Result<
        crate::output::DeleteBotLocaleOutput,
        crate::error::DeleteBotLocaleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_bot_locale_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_locale_response(response)
        }
    }
}

/// Operation shape for `DeleteBotVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_version`](crate::client::Client::delete_bot_version).
///
/// See [`crate::client::fluent_builders::DeleteBotVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotVersion {
    _private: (),
}
impl DeleteBotVersion {
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    pub fn builder() -> crate::input::delete_bot_version_input::Builder {
        crate::input::delete_bot_version_input::Builder::default()
    }
    /// Creates a new `DeleteBotVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotVersion {
    type Output = std::result::Result<
        crate::output::DeleteBotVersionOutput,
        crate::error::DeleteBotVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_bot_version_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_version_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomVocabulary`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_vocabulary`](crate::client::Client::delete_custom_vocabulary).
///
/// See [`crate::client::fluent_builders::DeleteCustomVocabulary`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomVocabulary {
    _private: (),
}
impl DeleteCustomVocabulary {
    /// Creates a new builder-style object to manufacture [`DeleteCustomVocabularyInput`](crate::input::DeleteCustomVocabularyInput)
    pub fn builder() -> crate::input::delete_custom_vocabulary_input::Builder {
        crate::input::delete_custom_vocabulary_input::Builder::default()
    }
    /// Creates a new `DeleteCustomVocabulary` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomVocabulary {
    type Output = std::result::Result<
        crate::output::DeleteCustomVocabularyOutput,
        crate::error::DeleteCustomVocabularyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_custom_vocabulary_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_vocabulary_response(response)
        }
    }
}

/// Operation shape for `DeleteExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_export`](crate::client::Client::delete_export).
///
/// See [`crate::client::fluent_builders::DeleteExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteExport {
    _private: (),
}
impl DeleteExport {
    /// Creates a new builder-style object to manufacture [`DeleteExportInput`](crate::input::DeleteExportInput)
    pub fn builder() -> crate::input::delete_export_input::Builder {
        crate::input::delete_export_input::Builder::default()
    }
    /// Creates a new `DeleteExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteExport {
    type Output =
        std::result::Result<crate::output::DeleteExportOutput, crate::error::DeleteExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_export_error(response)
        } else {
            crate::operation_deser::parse_delete_export_response(response)
        }
    }
}

/// Operation shape for `DeleteImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_import`](crate::client::Client::delete_import).
///
/// See [`crate::client::fluent_builders::DeleteImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImport {
    _private: (),
}
impl DeleteImport {
    /// Creates a new builder-style object to manufacture [`DeleteImportInput`](crate::input::DeleteImportInput)
    pub fn builder() -> crate::input::delete_import_input::Builder {
        crate::input::delete_import_input::Builder::default()
    }
    /// Creates a new `DeleteImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImport {
    type Output =
        std::result::Result<crate::output::DeleteImportOutput, crate::error::DeleteImportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_import_error(response)
        } else {
            crate::operation_deser::parse_delete_import_response(response)
        }
    }
}

/// Operation shape for `DeleteIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_intent`](crate::client::Client::delete_intent).
///
/// See [`crate::client::fluent_builders::DeleteIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntent {
    _private: (),
}
impl DeleteIntent {
    /// Creates a new builder-style object to manufacture [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    pub fn builder() -> crate::input::delete_intent_input::Builder {
        crate::input::delete_intent_input::Builder::default()
    }
    /// Creates a new `DeleteIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntent {
    type Output =
        std::result::Result<crate::output::DeleteIntentOutput, crate::error::DeleteIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_intent_error(response)
        } else {
            crate::operation_deser::parse_delete_intent_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicyStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy_statement`](crate::client::Client::delete_resource_policy_statement).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicyStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicyStatement {
    _private: (),
}
impl DeleteResourcePolicyStatement {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyStatementInput`](crate::input::DeleteResourcePolicyStatementInput)
    pub fn builder() -> crate::input::delete_resource_policy_statement_input::Builder {
        crate::input::delete_resource_policy_statement_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicyStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicyStatement {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyStatementOutput,
        crate::error::DeleteResourcePolicyStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_resource_policy_statement_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_statement_response(response)
        }
    }
}

/// Operation shape for `DeleteSlot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_slot`](crate::client::Client::delete_slot).
///
/// See [`crate::client::fluent_builders::DeleteSlot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSlot {
    _private: (),
}
impl DeleteSlot {
    /// Creates a new builder-style object to manufacture [`DeleteSlotInput`](crate::input::DeleteSlotInput)
    pub fn builder() -> crate::input::delete_slot_input::Builder {
        crate::input::delete_slot_input::Builder::default()
    }
    /// Creates a new `DeleteSlot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSlot {
    type Output =
        std::result::Result<crate::output::DeleteSlotOutput, crate::error::DeleteSlotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_slot_error(response)
        } else {
            crate::operation_deser::parse_delete_slot_response(response)
        }
    }
}

/// Operation shape for `DeleteSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_slot_type`](crate::client::Client::delete_slot_type).
///
/// See [`crate::client::fluent_builders::DeleteSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSlotType {
    _private: (),
}
impl DeleteSlotType {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    pub fn builder() -> crate::input::delete_slot_type_input::Builder {
        crate::input::delete_slot_type_input::Builder::default()
    }
    /// Creates a new `DeleteSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSlotType {
    type Output =
        std::result::Result<crate::output::DeleteSlotTypeOutput, crate::error::DeleteSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_slot_type_error(response)
        } else {
            crate::operation_deser::parse_delete_slot_type_response(response)
        }
    }
}

/// Operation shape for `DeleteUtterances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_utterances`](crate::client::Client::delete_utterances).
///
/// See [`crate::client::fluent_builders::DeleteUtterances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUtterances {
    _private: (),
}
impl DeleteUtterances {
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    pub fn builder() -> crate::input::delete_utterances_input::Builder {
        crate::input::delete_utterances_input::Builder::default()
    }
    /// Creates a new `DeleteUtterances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUtterances {
    type Output = std::result::Result<
        crate::output::DeleteUtterancesOutput,
        crate::error::DeleteUtterancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_utterances_error(response)
        } else {
            crate::operation_deser::parse_delete_utterances_response(response)
        }
    }
}

/// Operation shape for `DescribeBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bot`](crate::client::Client::describe_bot).
///
/// See [`crate::client::fluent_builders::DescribeBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBot {
    _private: (),
}
impl DescribeBot {
    /// Creates a new builder-style object to manufacture [`DescribeBotInput`](crate::input::DescribeBotInput)
    pub fn builder() -> crate::input::describe_bot_input::Builder {
        crate::input::describe_bot_input::Builder::default()
    }
    /// Creates a new `DescribeBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBot {
    type Output =
        std::result::Result<crate::output::DescribeBotOutput, crate::error::DescribeBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bot_error(response)
        } else {
            crate::operation_deser::parse_describe_bot_response(response)
        }
    }
}

/// Operation shape for `DescribeBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bot_alias`](crate::client::Client::describe_bot_alias).
///
/// See [`crate::client::fluent_builders::DescribeBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBotAlias {
    _private: (),
}
impl DescribeBotAlias {
    /// Creates a new builder-style object to manufacture [`DescribeBotAliasInput`](crate::input::DescribeBotAliasInput)
    pub fn builder() -> crate::input::describe_bot_alias_input::Builder {
        crate::input::describe_bot_alias_input::Builder::default()
    }
    /// Creates a new `DescribeBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBotAlias {
    type Output = std::result::Result<
        crate::output::DescribeBotAliasOutput,
        crate::error::DescribeBotAliasError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_describe_bot_alias_response(response)
        }
    }
}

/// Operation shape for `DescribeBotLocale`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bot_locale`](crate::client::Client::describe_bot_locale).
///
/// See [`crate::client::fluent_builders::DescribeBotLocale`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBotLocale {
    _private: (),
}
impl DescribeBotLocale {
    /// Creates a new builder-style object to manufacture [`DescribeBotLocaleInput`](crate::input::DescribeBotLocaleInput)
    pub fn builder() -> crate::input::describe_bot_locale_input::Builder {
        crate::input::describe_bot_locale_input::Builder::default()
    }
    /// Creates a new `DescribeBotLocale` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBotLocale {
    type Output = std::result::Result<
        crate::output::DescribeBotLocaleOutput,
        crate::error::DescribeBotLocaleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bot_locale_error(response)
        } else {
            crate::operation_deser::parse_describe_bot_locale_response(response)
        }
    }
}

/// Operation shape for `DescribeBotRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bot_recommendation`](crate::client::Client::describe_bot_recommendation).
///
/// See [`crate::client::fluent_builders::DescribeBotRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBotRecommendation {
    _private: (),
}
impl DescribeBotRecommendation {
    /// Creates a new builder-style object to manufacture [`DescribeBotRecommendationInput`](crate::input::DescribeBotRecommendationInput)
    pub fn builder() -> crate::input::describe_bot_recommendation_input::Builder {
        crate::input::describe_bot_recommendation_input::Builder::default()
    }
    /// Creates a new `DescribeBotRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBotRecommendation {
    type Output = std::result::Result<
        crate::output::DescribeBotRecommendationOutput,
        crate::error::DescribeBotRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bot_recommendation_error(response)
        } else {
            crate::operation_deser::parse_describe_bot_recommendation_response(response)
        }
    }
}

/// Operation shape for `DescribeBotVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_bot_version`](crate::client::Client::describe_bot_version).
///
/// See [`crate::client::fluent_builders::DescribeBotVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBotVersion {
    _private: (),
}
impl DescribeBotVersion {
    /// Creates a new builder-style object to manufacture [`DescribeBotVersionInput`](crate::input::DescribeBotVersionInput)
    pub fn builder() -> crate::input::describe_bot_version_input::Builder {
        crate::input::describe_bot_version_input::Builder::default()
    }
    /// Creates a new `DescribeBotVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBotVersion {
    type Output = std::result::Result<
        crate::output::DescribeBotVersionOutput,
        crate::error::DescribeBotVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_bot_version_error(response)
        } else {
            crate::operation_deser::parse_describe_bot_version_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomVocabularyMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_vocabulary_metadata`](crate::client::Client::describe_custom_vocabulary_metadata).
///
/// See [`crate::client::fluent_builders::DescribeCustomVocabularyMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomVocabularyMetadata {
    _private: (),
}
impl DescribeCustomVocabularyMetadata {
    /// Creates a new builder-style object to manufacture [`DescribeCustomVocabularyMetadataInput`](crate::input::DescribeCustomVocabularyMetadataInput)
    pub fn builder() -> crate::input::describe_custom_vocabulary_metadata_input::Builder {
        crate::input::describe_custom_vocabulary_metadata_input::Builder::default()
    }
    /// Creates a new `DescribeCustomVocabularyMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomVocabularyMetadata {
    type Output = std::result::Result<
        crate::output::DescribeCustomVocabularyMetadataOutput,
        crate::error::DescribeCustomVocabularyMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_vocabulary_metadata_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_vocabulary_metadata_response(response)
        }
    }
}

/// Operation shape for `DescribeExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export`](crate::client::Client::describe_export).
///
/// See [`crate::client::fluent_builders::DescribeExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExport {
    _private: (),
}
impl DescribeExport {
    /// Creates a new builder-style object to manufacture [`DescribeExportInput`](crate::input::DescribeExportInput)
    pub fn builder() -> crate::input::describe_export_input::Builder {
        crate::input::describe_export_input::Builder::default()
    }
    /// Creates a new `DescribeExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExport {
    type Output =
        std::result::Result<crate::output::DescribeExportOutput, crate::error::DescribeExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_error(response)
        } else {
            crate::operation_deser::parse_describe_export_response(response)
        }
    }
}

/// Operation shape for `DescribeImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_import`](crate::client::Client::describe_import).
///
/// See [`crate::client::fluent_builders::DescribeImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImport {
    _private: (),
}
impl DescribeImport {
    /// Creates a new builder-style object to manufacture [`DescribeImportInput`](crate::input::DescribeImportInput)
    pub fn builder() -> crate::input::describe_import_input::Builder {
        crate::input::describe_import_input::Builder::default()
    }
    /// Creates a new `DescribeImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImport {
    type Output =
        std::result::Result<crate::output::DescribeImportOutput, crate::error::DescribeImportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_import_error(response)
        } else {
            crate::operation_deser::parse_describe_import_response(response)
        }
    }
}

/// Operation shape for `DescribeIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_intent`](crate::client::Client::describe_intent).
///
/// See [`crate::client::fluent_builders::DescribeIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeIntent {
    _private: (),
}
impl DescribeIntent {
    /// Creates a new builder-style object to manufacture [`DescribeIntentInput`](crate::input::DescribeIntentInput)
    pub fn builder() -> crate::input::describe_intent_input::Builder {
        crate::input::describe_intent_input::Builder::default()
    }
    /// Creates a new `DescribeIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeIntent {
    type Output =
        std::result::Result<crate::output::DescribeIntentOutput, crate::error::DescribeIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_intent_error(response)
        } else {
            crate::operation_deser::parse_describe_intent_response(response)
        }
    }
}

/// Operation shape for `DescribeResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_policy`](crate::client::Client::describe_resource_policy).
///
/// See [`crate::client::fluent_builders::DescribeResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourcePolicy {
    _private: (),
}
impl DescribeResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePolicyInput`](crate::input::DescribeResourcePolicyInput)
    pub fn builder() -> crate::input::describe_resource_policy_input::Builder {
        crate::input::describe_resource_policy_input::Builder::default()
    }
    /// Creates a new `DescribeResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourcePolicy {
    type Output = std::result::Result<
        crate::output::DescribeResourcePolicyOutput,
        crate::error::DescribeResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeSlot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_slot`](crate::client::Client::describe_slot).
///
/// See [`crate::client::fluent_builders::DescribeSlot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSlot {
    _private: (),
}
impl DescribeSlot {
    /// Creates a new builder-style object to manufacture [`DescribeSlotInput`](crate::input::DescribeSlotInput)
    pub fn builder() -> crate::input::describe_slot_input::Builder {
        crate::input::describe_slot_input::Builder::default()
    }
    /// Creates a new `DescribeSlot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSlot {
    type Output =
        std::result::Result<crate::output::DescribeSlotOutput, crate::error::DescribeSlotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_slot_error(response)
        } else {
            crate::operation_deser::parse_describe_slot_response(response)
        }
    }
}

/// Operation shape for `DescribeSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_slot_type`](crate::client::Client::describe_slot_type).
///
/// See [`crate::client::fluent_builders::DescribeSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSlotType {
    _private: (),
}
impl DescribeSlotType {
    /// Creates a new builder-style object to manufacture [`DescribeSlotTypeInput`](crate::input::DescribeSlotTypeInput)
    pub fn builder() -> crate::input::describe_slot_type_input::Builder {
        crate::input::describe_slot_type_input::Builder::default()
    }
    /// Creates a new `DescribeSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSlotType {
    type Output = std::result::Result<
        crate::output::DescribeSlotTypeOutput,
        crate::error::DescribeSlotTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_slot_type_error(response)
        } else {
            crate::operation_deser::parse_describe_slot_type_response(response)
        }
    }
}

/// Operation shape for `ListAggregatedUtterances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aggregated_utterances`](crate::client::Client::list_aggregated_utterances).
///
/// See [`crate::client::fluent_builders::ListAggregatedUtterances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAggregatedUtterances {
    _private: (),
}
impl ListAggregatedUtterances {
    /// Creates a new builder-style object to manufacture [`ListAggregatedUtterancesInput`](crate::input::ListAggregatedUtterancesInput)
    pub fn builder() -> crate::input::list_aggregated_utterances_input::Builder {
        crate::input::list_aggregated_utterances_input::Builder::default()
    }
    /// Creates a new `ListAggregatedUtterances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAggregatedUtterances {
    type Output = std::result::Result<
        crate::output::ListAggregatedUtterancesOutput,
        crate::error::ListAggregatedUtterancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aggregated_utterances_error(response)
        } else {
            crate::operation_deser::parse_list_aggregated_utterances_response(response)
        }
    }
}

/// Operation shape for `ListBotAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bot_aliases`](crate::client::Client::list_bot_aliases).
///
/// See [`crate::client::fluent_builders::ListBotAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBotAliases {
    _private: (),
}
impl ListBotAliases {
    /// Creates a new builder-style object to manufacture [`ListBotAliasesInput`](crate::input::ListBotAliasesInput)
    pub fn builder() -> crate::input::list_bot_aliases_input::Builder {
        crate::input::list_bot_aliases_input::Builder::default()
    }
    /// Creates a new `ListBotAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBotAliases {
    type Output =
        std::result::Result<crate::output::ListBotAliasesOutput, crate::error::ListBotAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bot_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_bot_aliases_response(response)
        }
    }
}

/// Operation shape for `ListBotLocales`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bot_locales`](crate::client::Client::list_bot_locales).
///
/// See [`crate::client::fluent_builders::ListBotLocales`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBotLocales {
    _private: (),
}
impl ListBotLocales {
    /// Creates a new builder-style object to manufacture [`ListBotLocalesInput`](crate::input::ListBotLocalesInput)
    pub fn builder() -> crate::input::list_bot_locales_input::Builder {
        crate::input::list_bot_locales_input::Builder::default()
    }
    /// Creates a new `ListBotLocales` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBotLocales {
    type Output =
        std::result::Result<crate::output::ListBotLocalesOutput, crate::error::ListBotLocalesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bot_locales_error(response)
        } else {
            crate::operation_deser::parse_list_bot_locales_response(response)
        }
    }
}

/// Operation shape for `ListBotRecommendations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bot_recommendations`](crate::client::Client::list_bot_recommendations).
///
/// See [`crate::client::fluent_builders::ListBotRecommendations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBotRecommendations {
    _private: (),
}
impl ListBotRecommendations {
    /// Creates a new builder-style object to manufacture [`ListBotRecommendationsInput`](crate::input::ListBotRecommendationsInput)
    pub fn builder() -> crate::input::list_bot_recommendations_input::Builder {
        crate::input::list_bot_recommendations_input::Builder::default()
    }
    /// Creates a new `ListBotRecommendations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBotRecommendations {
    type Output = std::result::Result<
        crate::output::ListBotRecommendationsOutput,
        crate::error::ListBotRecommendationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bot_recommendations_error(response)
        } else {
            crate::operation_deser::parse_list_bot_recommendations_response(response)
        }
    }
}

/// Operation shape for `ListBots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bots`](crate::client::Client::list_bots).
///
/// See [`crate::client::fluent_builders::ListBots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBots {
    _private: (),
}
impl ListBots {
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
    /// Creates a new `ListBots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBots {
    type Output = std::result::Result<crate::output::ListBotsOutput, crate::error::ListBotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bots_error(response)
        } else {
            crate::operation_deser::parse_list_bots_response(response)
        }
    }
}

/// Operation shape for `ListBotVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_bot_versions`](crate::client::Client::list_bot_versions).
///
/// See [`crate::client::fluent_builders::ListBotVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBotVersions {
    _private: (),
}
impl ListBotVersions {
    /// Creates a new builder-style object to manufacture [`ListBotVersionsInput`](crate::input::ListBotVersionsInput)
    pub fn builder() -> crate::input::list_bot_versions_input::Builder {
        crate::input::list_bot_versions_input::Builder::default()
    }
    /// Creates a new `ListBotVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBotVersions {
    type Output = std::result::Result<
        crate::output::ListBotVersionsOutput,
        crate::error::ListBotVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_bot_versions_error(response)
        } else {
            crate::operation_deser::parse_list_bot_versions_response(response)
        }
    }
}

/// Operation shape for `ListBuiltInIntents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_built_in_intents`](crate::client::Client::list_built_in_intents).
///
/// See [`crate::client::fluent_builders::ListBuiltInIntents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuiltInIntents {
    _private: (),
}
impl ListBuiltInIntents {
    /// Creates a new builder-style object to manufacture [`ListBuiltInIntentsInput`](crate::input::ListBuiltInIntentsInput)
    pub fn builder() -> crate::input::list_built_in_intents_input::Builder {
        crate::input::list_built_in_intents_input::Builder::default()
    }
    /// Creates a new `ListBuiltInIntents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuiltInIntents {
    type Output = std::result::Result<
        crate::output::ListBuiltInIntentsOutput,
        crate::error::ListBuiltInIntentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_built_in_intents_error(response)
        } else {
            crate::operation_deser::parse_list_built_in_intents_response(response)
        }
    }
}

/// Operation shape for `ListBuiltInSlotTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_built_in_slot_types`](crate::client::Client::list_built_in_slot_types).
///
/// See [`crate::client::fluent_builders::ListBuiltInSlotTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuiltInSlotTypes {
    _private: (),
}
impl ListBuiltInSlotTypes {
    /// Creates a new builder-style object to manufacture [`ListBuiltInSlotTypesInput`](crate::input::ListBuiltInSlotTypesInput)
    pub fn builder() -> crate::input::list_built_in_slot_types_input::Builder {
        crate::input::list_built_in_slot_types_input::Builder::default()
    }
    /// Creates a new `ListBuiltInSlotTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuiltInSlotTypes {
    type Output = std::result::Result<
        crate::output::ListBuiltInSlotTypesOutput,
        crate::error::ListBuiltInSlotTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_built_in_slot_types_error(response)
        } else {
            crate::operation_deser::parse_list_built_in_slot_types_response(response)
        }
    }
}

/// Operation shape for `ListExports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_exports`](crate::client::Client::list_exports).
///
/// See [`crate::client::fluent_builders::ListExports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListExports {
    _private: (),
}
impl ListExports {
    /// Creates a new builder-style object to manufacture [`ListExportsInput`](crate::input::ListExportsInput)
    pub fn builder() -> crate::input::list_exports_input::Builder {
        crate::input::list_exports_input::Builder::default()
    }
    /// Creates a new `ListExports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListExports {
    type Output =
        std::result::Result<crate::output::ListExportsOutput, crate::error::ListExportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_exports_error(response)
        } else {
            crate::operation_deser::parse_list_exports_response(response)
        }
    }
}

/// Operation shape for `ListImports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_imports`](crate::client::Client::list_imports).
///
/// See [`crate::client::fluent_builders::ListImports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImports {
    _private: (),
}
impl ListImports {
    /// Creates a new builder-style object to manufacture [`ListImportsInput`](crate::input::ListImportsInput)
    pub fn builder() -> crate::input::list_imports_input::Builder {
        crate::input::list_imports_input::Builder::default()
    }
    /// Creates a new `ListImports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImports {
    type Output =
        std::result::Result<crate::output::ListImportsOutput, crate::error::ListImportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_imports_error(response)
        } else {
            crate::operation_deser::parse_list_imports_response(response)
        }
    }
}

/// Operation shape for `ListIntents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_intents`](crate::client::Client::list_intents).
///
/// See [`crate::client::fluent_builders::ListIntents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIntents {
    _private: (),
}
impl ListIntents {
    /// Creates a new builder-style object to manufacture [`ListIntentsInput`](crate::input::ListIntentsInput)
    pub fn builder() -> crate::input::list_intents_input::Builder {
        crate::input::list_intents_input::Builder::default()
    }
    /// Creates a new `ListIntents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIntents {
    type Output =
        std::result::Result<crate::output::ListIntentsOutput, crate::error::ListIntentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_intents_error(response)
        } else {
            crate::operation_deser::parse_list_intents_response(response)
        }
    }
}

/// Operation shape for `ListRecommendedIntents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_recommended_intents`](crate::client::Client::list_recommended_intents).
///
/// See [`crate::client::fluent_builders::ListRecommendedIntents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRecommendedIntents {
    _private: (),
}
impl ListRecommendedIntents {
    /// Creates a new builder-style object to manufacture [`ListRecommendedIntentsInput`](crate::input::ListRecommendedIntentsInput)
    pub fn builder() -> crate::input::list_recommended_intents_input::Builder {
        crate::input::list_recommended_intents_input::Builder::default()
    }
    /// Creates a new `ListRecommendedIntents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRecommendedIntents {
    type Output = std::result::Result<
        crate::output::ListRecommendedIntentsOutput,
        crate::error::ListRecommendedIntentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_recommended_intents_error(response)
        } else {
            crate::operation_deser::parse_list_recommended_intents_response(response)
        }
    }
}

/// Operation shape for `ListSlots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_slots`](crate::client::Client::list_slots).
///
/// See [`crate::client::fluent_builders::ListSlots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSlots {
    _private: (),
}
impl ListSlots {
    /// Creates a new builder-style object to manufacture [`ListSlotsInput`](crate::input::ListSlotsInput)
    pub fn builder() -> crate::input::list_slots_input::Builder {
        crate::input::list_slots_input::Builder::default()
    }
    /// Creates a new `ListSlots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSlots {
    type Output = std::result::Result<crate::output::ListSlotsOutput, crate::error::ListSlotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_slots_error(response)
        } else {
            crate::operation_deser::parse_list_slots_response(response)
        }
    }
}

/// Operation shape for `ListSlotTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_slot_types`](crate::client::Client::list_slot_types).
///
/// See [`crate::client::fluent_builders::ListSlotTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSlotTypes {
    _private: (),
}
impl ListSlotTypes {
    /// Creates a new builder-style object to manufacture [`ListSlotTypesInput`](crate::input::ListSlotTypesInput)
    pub fn builder() -> crate::input::list_slot_types_input::Builder {
        crate::input::list_slot_types_input::Builder::default()
    }
    /// Creates a new `ListSlotTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSlotTypes {
    type Output =
        std::result::Result<crate::output::ListSlotTypesOutput, crate::error::ListSlotTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_slot_types_error(response)
        } else {
            crate::operation_deser::parse_list_slot_types_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `SearchAssociatedTranscripts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_associated_transcripts`](crate::client::Client::search_associated_transcripts).
///
/// See [`crate::client::fluent_builders::SearchAssociatedTranscripts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchAssociatedTranscripts {
    _private: (),
}
impl SearchAssociatedTranscripts {
    /// Creates a new builder-style object to manufacture [`SearchAssociatedTranscriptsInput`](crate::input::SearchAssociatedTranscriptsInput)
    pub fn builder() -> crate::input::search_associated_transcripts_input::Builder {
        crate::input::search_associated_transcripts_input::Builder::default()
    }
    /// Creates a new `SearchAssociatedTranscripts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchAssociatedTranscripts {
    type Output = std::result::Result<
        crate::output::SearchAssociatedTranscriptsOutput,
        crate::error::SearchAssociatedTranscriptsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_associated_transcripts_error(response)
        } else {
            crate::operation_deser::parse_search_associated_transcripts_response(response)
        }
    }
}

/// Operation shape for `StartBotRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_bot_recommendation`](crate::client::Client::start_bot_recommendation).
///
/// See [`crate::client::fluent_builders::StartBotRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBotRecommendation {
    _private: (),
}
impl StartBotRecommendation {
    /// Creates a new builder-style object to manufacture [`StartBotRecommendationInput`](crate::input::StartBotRecommendationInput)
    pub fn builder() -> crate::input::start_bot_recommendation_input::Builder {
        crate::input::start_bot_recommendation_input::Builder::default()
    }
    /// Creates a new `StartBotRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBotRecommendation {
    type Output = std::result::Result<
        crate::output::StartBotRecommendationOutput,
        crate::error::StartBotRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_bot_recommendation_error(response)
        } else {
            crate::operation_deser::parse_start_bot_recommendation_response(response)
        }
    }
}

/// Operation shape for `StartImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_import`](crate::client::Client::start_import).
///
/// See [`crate::client::fluent_builders::StartImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImport {
    _private: (),
}
impl StartImport {
    /// Creates a new builder-style object to manufacture [`StartImportInput`](crate::input::StartImportInput)
    pub fn builder() -> crate::input::start_import_input::Builder {
        crate::input::start_import_input::Builder::default()
    }
    /// Creates a new `StartImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImport {
    type Output =
        std::result::Result<crate::output::StartImportOutput, crate::error::StartImportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_import_error(response)
        } else {
            crate::operation_deser::parse_start_import_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bot`](crate::client::Client::update_bot).
///
/// See [`crate::client::fluent_builders::UpdateBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBot {
    _private: (),
}
impl UpdateBot {
    /// Creates a new builder-style object to manufacture [`UpdateBotInput`](crate::input::UpdateBotInput)
    pub fn builder() -> crate::input::update_bot_input::Builder {
        crate::input::update_bot_input::Builder::default()
    }
    /// Creates a new `UpdateBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBot {
    type Output = std::result::Result<crate::output::UpdateBotOutput, crate::error::UpdateBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_bot_error(response)
        } else {
            crate::operation_deser::parse_update_bot_response(response)
        }
    }
}

/// Operation shape for `UpdateBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bot_alias`](crate::client::Client::update_bot_alias).
///
/// See [`crate::client::fluent_builders::UpdateBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBotAlias {
    _private: (),
}
impl UpdateBotAlias {
    /// Creates a new builder-style object to manufacture [`UpdateBotAliasInput`](crate::input::UpdateBotAliasInput)
    pub fn builder() -> crate::input::update_bot_alias_input::Builder {
        crate::input::update_bot_alias_input::Builder::default()
    }
    /// Creates a new `UpdateBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBotAlias {
    type Output =
        std::result::Result<crate::output::UpdateBotAliasOutput, crate::error::UpdateBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_update_bot_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateBotLocale`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bot_locale`](crate::client::Client::update_bot_locale).
///
/// See [`crate::client::fluent_builders::UpdateBotLocale`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBotLocale {
    _private: (),
}
impl UpdateBotLocale {
    /// Creates a new builder-style object to manufacture [`UpdateBotLocaleInput`](crate::input::UpdateBotLocaleInput)
    pub fn builder() -> crate::input::update_bot_locale_input::Builder {
        crate::input::update_bot_locale_input::Builder::default()
    }
    /// Creates a new `UpdateBotLocale` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBotLocale {
    type Output = std::result::Result<
        crate::output::UpdateBotLocaleOutput,
        crate::error::UpdateBotLocaleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_bot_locale_error(response)
        } else {
            crate::operation_deser::parse_update_bot_locale_response(response)
        }
    }
}

/// Operation shape for `UpdateBotRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bot_recommendation`](crate::client::Client::update_bot_recommendation).
///
/// See [`crate::client::fluent_builders::UpdateBotRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBotRecommendation {
    _private: (),
}
impl UpdateBotRecommendation {
    /// Creates a new builder-style object to manufacture [`UpdateBotRecommendationInput`](crate::input::UpdateBotRecommendationInput)
    pub fn builder() -> crate::input::update_bot_recommendation_input::Builder {
        crate::input::update_bot_recommendation_input::Builder::default()
    }
    /// Creates a new `UpdateBotRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBotRecommendation {
    type Output = std::result::Result<
        crate::output::UpdateBotRecommendationOutput,
        crate::error::UpdateBotRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_bot_recommendation_error(response)
        } else {
            crate::operation_deser::parse_update_bot_recommendation_response(response)
        }
    }
}

/// Operation shape for `UpdateExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_export`](crate::client::Client::update_export).
///
/// See [`crate::client::fluent_builders::UpdateExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateExport {
    _private: (),
}
impl UpdateExport {
    /// Creates a new builder-style object to manufacture [`UpdateExportInput`](crate::input::UpdateExportInput)
    pub fn builder() -> crate::input::update_export_input::Builder {
        crate::input::update_export_input::Builder::default()
    }
    /// Creates a new `UpdateExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateExport {
    type Output =
        std::result::Result<crate::output::UpdateExportOutput, crate::error::UpdateExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_export_error(response)
        } else {
            crate::operation_deser::parse_update_export_response(response)
        }
    }
}

/// Operation shape for `UpdateIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_intent`](crate::client::Client::update_intent).
///
/// See [`crate::client::fluent_builders::UpdateIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIntent {
    _private: (),
}
impl UpdateIntent {
    /// Creates a new builder-style object to manufacture [`UpdateIntentInput`](crate::input::UpdateIntentInput)
    pub fn builder() -> crate::input::update_intent_input::Builder {
        crate::input::update_intent_input::Builder::default()
    }
    /// Creates a new `UpdateIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIntent {
    type Output =
        std::result::Result<crate::output::UpdateIntentOutput, crate::error::UpdateIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_intent_error(response)
        } else {
            crate::operation_deser::parse_update_intent_response(response)
        }
    }
}

/// Operation shape for `UpdateResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resource_policy`](crate::client::Client::update_resource_policy).
///
/// See [`crate::client::fluent_builders::UpdateResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResourcePolicy {
    _private: (),
}
impl UpdateResourcePolicy {
    /// Creates a new builder-style object to manufacture [`UpdateResourcePolicyInput`](crate::input::UpdateResourcePolicyInput)
    pub fn builder() -> crate::input::update_resource_policy_input::Builder {
        crate::input::update_resource_policy_input::Builder::default()
    }
    /// Creates a new `UpdateResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResourcePolicy {
    type Output = std::result::Result<
        crate::output::UpdateResourcePolicyOutput,
        crate::error::UpdateResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_update_resource_policy_response(response)
        }
    }
}

/// Operation shape for `UpdateSlot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_slot`](crate::client::Client::update_slot).
///
/// See [`crate::client::fluent_builders::UpdateSlot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSlot {
    _private: (),
}
impl UpdateSlot {
    /// Creates a new builder-style object to manufacture [`UpdateSlotInput`](crate::input::UpdateSlotInput)
    pub fn builder() -> crate::input::update_slot_input::Builder {
        crate::input::update_slot_input::Builder::default()
    }
    /// Creates a new `UpdateSlot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSlot {
    type Output =
        std::result::Result<crate::output::UpdateSlotOutput, crate::error::UpdateSlotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_slot_error(response)
        } else {
            crate::operation_deser::parse_update_slot_response(response)
        }
    }
}

/// Operation shape for `UpdateSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_slot_type`](crate::client::Client::update_slot_type).
///
/// See [`crate::client::fluent_builders::UpdateSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSlotType {
    _private: (),
}
impl UpdateSlotType {
    /// Creates a new builder-style object to manufacture [`UpdateSlotTypeInput`](crate::input::UpdateSlotTypeInput)
    pub fn builder() -> crate::input::update_slot_type_input::Builder {
        crate::input::update_slot_type_input::Builder::default()
    }
    /// Creates a new `UpdateSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSlotType {
    type Output =
        std::result::Result<crate::output::UpdateSlotTypeOutput, crate::error::UpdateSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_slot_type_error(response)
        } else {
            crate::operation_deser::parse_update_slot_type_response(response)
        }
    }
}
