// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BuildBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BuildBotLocaleError {
    /// Kind of error that occurred.
    pub kind: BuildBotLocaleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BuildBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BuildBotLocaleErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BuildBotLocaleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BuildBotLocaleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BuildBotLocaleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BuildBotLocaleError {
    fn code(&self) -> Option<&str> {
        BuildBotLocaleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BuildBotLocaleError {
    /// Creates a new `BuildBotLocaleError`.
    pub fn new(kind: BuildBotLocaleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BuildBotLocaleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BuildBotLocaleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BuildBotLocaleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BuildBotLocaleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, BuildBotLocaleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BuildBotLocaleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            BuildBotLocaleErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BuildBotLocaleErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, BuildBotLocaleErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `BuildBotLocaleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, BuildBotLocaleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for BuildBotLocaleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BuildBotLocaleErrorKind::ConflictException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::InternalServerException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::ThrottlingException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::ValidationException(_inner) => Some(_inner),
            BuildBotLocaleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotError {
    /// Kind of error that occurred.
    pub kind: CreateBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotError {
    fn code(&self) -> Option<&str> {
        CreateBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotError {
    /// Creates a new `CreateBotError`.
    pub fn new(kind: CreateBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateBotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateBotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBotErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBotErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotAliasError {
    /// Kind of error that occurred.
    pub kind: CreateBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotAliasErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotAliasError {
    fn code(&self) -> Option<&str> {
        CreateBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotAliasError {
    /// Creates a new `CreateBotAliasError`.
    pub fn new(kind: CreateBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBotAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotAliasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotAliasErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotAliasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateBotAliasErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateBotAliasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateBotAliasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotAliasErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotLocaleError {
    /// Kind of error that occurred.
    pub kind: CreateBotLocaleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotLocaleErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotLocaleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotLocaleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBotLocaleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotLocaleError {
    fn code(&self) -> Option<&str> {
        CreateBotLocaleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotLocaleError {
    /// Creates a new `CreateBotLocaleError`.
    pub fn new(kind: CreateBotLocaleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotLocaleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotLocaleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotLocaleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotLocaleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBotLocaleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotLocaleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotLocaleErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotLocaleErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateBotLocaleErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateBotLocaleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateBotLocaleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateBotLocaleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotLocaleErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBotLocaleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotVersionError {
    /// Kind of error that occurred.
    pub kind: CreateBotVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotVersionErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotVersionError {
    fn code(&self) -> Option<&str> {
        CreateBotVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotVersionError {
    /// Creates a new `CreateBotVersionError`.
    pub fn new(kind: CreateBotVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBotVersionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateBotVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExportError {
    /// Kind of error that occurred.
    pub kind: CreateExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExportErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExportErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExportError {
    fn code(&self) -> Option<&str> {
        CreateExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExportError {
    /// Creates a new `CreateExportError`.
    pub fn new(kind: CreateExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateExportErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateExportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateExportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateExportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExportErrorKind::ConflictException(_inner) => Some(_inner),
            CreateExportErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateExportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExportErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateExportErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateExportErrorKind::ValidationException(_inner) => Some(_inner),
            CreateExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIntentError {
    /// Kind of error that occurred.
    pub kind: CreateIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIntentErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIntentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIntentError {
    fn code(&self) -> Option<&str> {
        CreateIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIntentError {
    /// Creates a new `CreateIntentError`.
    pub fn new(kind: CreateIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIntentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateIntentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateIntentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateIntentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateIntentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIntentErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIntentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateIntentErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateIntentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateIntentErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIntentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: CreateResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourcePolicyErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourcePolicyError {
    fn code(&self) -> Option<&str> {
        CreateResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourcePolicyError {
    /// Creates a new `CreateResourcePolicyError`.
    pub fn new(kind: CreateResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            CreateResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResourcePolicyStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResourcePolicyStatementError {
    /// Kind of error that occurred.
    pub kind: CreateResourcePolicyStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResourcePolicyStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResourcePolicyStatementErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResourcePolicyStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResourcePolicyStatementErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateResourcePolicyStatementErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourcePolicyStatementErrorKind::PreconditionFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourcePolicyStatementErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourcePolicyStatementErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateResourcePolicyStatementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateResourcePolicyStatementErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateResourcePolicyStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResourcePolicyStatementError {
    fn code(&self) -> Option<&str> {
        CreateResourcePolicyStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResourcePolicyStatementError {
    /// Creates a new `CreateResourcePolicyStatementError`.
    pub fn new(
        kind: CreateResourcePolicyStatementErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResourcePolicyStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResourcePolicyStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResourcePolicyStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResourcePolicyStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateResourcePolicyStatementErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResourcePolicyStatementErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateResourcePolicyStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResourcePolicyStatementErrorKind::ConflictException(_inner) => Some(_inner),
            CreateResourcePolicyStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateResourcePolicyStatementErrorKind::PreconditionFailedException(_inner) => {
                Some(_inner)
            }
            CreateResourcePolicyStatementErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateResourcePolicyStatementErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateResourcePolicyStatementErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateResourcePolicyStatementErrorKind::ValidationException(_inner) => Some(_inner),
            CreateResourcePolicyStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSlotError {
    /// Kind of error that occurred.
    pub kind: CreateSlotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSlotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSlotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSlotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSlotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSlotError {
    fn code(&self) -> Option<&str> {
        CreateSlotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSlotError {
    /// Creates a new `CreateSlotError`.
    pub fn new(kind: CreateSlotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSlotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSlotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSlotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSlotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateSlotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSlotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSlotErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSlotErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSlotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateSlotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateSlotErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSlotErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSlotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSlotTypeError {
    /// Kind of error that occurred.
    pub kind: CreateSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSlotTypeErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSlotTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSlotTypeError {
    fn code(&self) -> Option<&str> {
        CreateSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSlotTypeError {
    /// Creates a new `CreateSlotTypeError`.
    pub fn new(kind: CreateSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotTypeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotTypeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateSlotTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateSlotTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSlotTypeErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUploadUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUploadUrlError {
    /// Kind of error that occurred.
    pub kind: CreateUploadUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUploadUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUploadUrlErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUploadUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUploadUrlErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateUploadUrlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateUploadUrlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUploadUrlErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUploadUrlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateUploadUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUploadUrlError {
    fn code(&self) -> Option<&str> {
        CreateUploadUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUploadUrlError {
    /// Creates a new `CreateUploadUrlError`.
    pub fn new(kind: CreateUploadUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUploadUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUploadUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUploadUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUploadUrlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUploadUrlErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadUrlErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateUploadUrlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUploadUrlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUploadUrlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUploadUrlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUploadUrlErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadUrlErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateUploadUrlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateUploadUrlErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateUploadUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUploadUrlErrorKind::ConflictException(_inner) => Some(_inner),
            CreateUploadUrlErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateUploadUrlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUploadUrlErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUploadUrlErrorKind::ValidationException(_inner) => Some(_inner),
            CreateUploadUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotError {
    /// Kind of error that occurred.
    pub kind: DeleteBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotError {
    fn code(&self) -> Option<&str> {
        DeleteBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotError {
    /// Creates a new `DeleteBotError`.
    pub fn new(kind: DeleteBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBotErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotAliasErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotAliasError {
    fn code(&self) -> Option<&str> {
        DeleteBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotAliasError {
    /// Creates a new `DeleteBotAliasError`.
    pub fn new(kind: DeleteBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotAliasErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotLocaleError {
    /// Kind of error that occurred.
    pub kind: DeleteBotLocaleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotLocaleErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotLocaleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotLocaleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBotLocaleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotLocaleError {
    fn code(&self) -> Option<&str> {
        DeleteBotLocaleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotLocaleError {
    /// Creates a new `DeleteBotLocaleError`.
    pub fn new(kind: DeleteBotLocaleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotLocaleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotLocaleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotLocaleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotLocaleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotLocaleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotLocaleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotLocaleErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotLocaleErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotLocaleErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotLocaleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotLocaleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteBotLocaleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotLocaleErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBotLocaleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteBotVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotVersionErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotVersionError {
    fn code(&self) -> Option<&str> {
        DeleteBotVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotVersionError {
    /// Creates a new `DeleteBotVersionError`.
    pub fn new(kind: DeleteBotVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotVersionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteBotVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteExportError {
    /// Kind of error that occurred.
    pub kind: DeleteExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteExportErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteExportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteExportErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteExportErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteExportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteExportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteExportError {
    fn code(&self) -> Option<&str> {
        DeleteExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteExportError {
    /// Creates a new `DeleteExportError`.
    pub fn new(kind: DeleteExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteExportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteExportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExportErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExportErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExportErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteExportErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteExportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteExportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteExportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteExportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteExportErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteExportErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteExportErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteExportErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteExportErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteImportError {
    /// Kind of error that occurred.
    pub kind: DeleteImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteImportErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteImportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteImportErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteImportErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteImportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteImportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteImportError {
    fn code(&self) -> Option<&str> {
        DeleteImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteImportError {
    /// Creates a new `DeleteImportError`.
    pub fn new(kind: DeleteImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteImportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteImportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImportErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteImportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteImportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteImportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteImportErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteImportErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteImportErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteImportErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteImportErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntentError {
    /// Kind of error that occurred.
    pub kind: DeleteIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntentErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntentError {
    fn code(&self) -> Option<&str> {
        DeleteIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntentError {
    /// Creates a new `DeleteIntentError`.
    pub fn new(kind: DeleteIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIntentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteIntentErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteIntentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteIntentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIntentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicyStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyStatementError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicyStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyStatementErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyStatementErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourcePolicyStatementErrorKind::PreconditionFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourcePolicyStatementErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteResourcePolicyStatementErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyStatementError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyStatementError {
    /// Creates a new `DeleteResourcePolicyStatementError`.
    pub fn new(
        kind: DeleteResourcePolicyStatementErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyStatementErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyStatementErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyStatementErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyStatementErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyStatementErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteResourcePolicyStatementErrorKind::PreconditionFailedException(_inner) => {
                Some(_inner)
            }
            DeleteResourcePolicyStatementErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteResourcePolicyStatementErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteResourcePolicyStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSlotError {
    /// Kind of error that occurred.
    pub kind: DeleteSlotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSlotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSlotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSlotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSlotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSlotError {
    fn code(&self) -> Option<&str> {
        DeleteSlotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSlotError {
    /// Creates a new `DeleteSlotError`.
    pub fn new(kind: DeleteSlotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSlotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSlotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSlotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSlotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSlotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSlotErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSlotErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSlotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteSlotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteSlotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSlotErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSlotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSlotTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSlotTypeErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSlotTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSlotTypeError {
    fn code(&self) -> Option<&str> {
        DeleteSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSlotTypeError {
    /// Creates a new `DeleteSlotTypeError`.
    pub fn new(kind: DeleteSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSlotTypeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUtterancesError {
    /// Kind of error that occurred.
    pub kind: DeleteUtterancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUtterancesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUtterancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUtterancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUtterancesError {
    fn code(&self) -> Option<&str> {
        DeleteUtterancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUtterancesError {
    /// Creates a new `DeleteUtterancesError`.
    pub fn new(kind: DeleteUtterancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUtterancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUtterancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUtterancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUtterancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteUtterancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUtterancesErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBotError {
    /// Kind of error that occurred.
    pub kind: DescribeBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBotErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBotError {
    fn code(&self) -> Option<&str> {
        DescribeBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBotError {
    /// Creates a new `DescribeBotError`.
    pub fn new(kind: DescribeBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DescribeBotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DescribeBotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeBotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeBotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeBotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBotErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBotErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBotAliasError {
    /// Kind of error that occurred.
    pub kind: DescribeBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBotAliasErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBotAliasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBotAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBotAliasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeBotAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBotAliasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBotAliasError {
    fn code(&self) -> Option<&str> {
        DescribeBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBotAliasError {
    /// Creates a new `DescribeBotAliasError`.
    pub fn new(kind: DescribeBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBotAliasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotAliasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotAliasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotAliasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotAliasErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotAliasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotAliasErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBotAliasErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBotAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBotAliasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeBotAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBotAliasErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBotLocaleError {
    /// Kind of error that occurred.
    pub kind: DescribeBotLocaleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBotLocaleErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBotLocaleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBotLocaleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBotLocaleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeBotLocaleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBotLocaleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBotLocaleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBotLocaleError {
    fn code(&self) -> Option<&str> {
        DescribeBotLocaleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBotLocaleError {
    /// Creates a new `DescribeBotLocaleError`.
    pub fn new(kind: DescribeBotLocaleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBotLocaleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBotLocaleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBotLocaleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBotLocaleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBotLocaleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotLocaleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotLocaleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotLocaleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotLocaleErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotLocaleErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotLocaleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotLocaleErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotLocaleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotLocaleErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeBotLocaleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBotLocaleErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBotLocaleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeBotLocaleErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBotLocaleErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBotLocaleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBotVersionError {
    /// Kind of error that occurred.
    pub kind: DescribeBotVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBotVersionErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBotVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBotVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBotVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBotVersionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeBotVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBotVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBotVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBotVersionError {
    fn code(&self) -> Option<&str> {
        DescribeBotVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBotVersionError {
    /// Creates a new `DescribeBotVersionError`.
    pub fn new(kind: DescribeBotVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBotVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBotVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBotVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBotVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBotVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotVersionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotVersionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBotVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBotVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeBotVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBotVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBotVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBotVersionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeBotVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBotVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBotVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExportError {
    /// Kind of error that occurred.
    pub kind: DescribeExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExportErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExportError {
    fn code(&self) -> Option<&str> {
        DescribeExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExportError {
    /// Creates a new `DescribeExportError`.
    pub fn new(kind: DescribeExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeExportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeExportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeExportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExportErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeExportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeExportErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeExportErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImportError {
    /// Kind of error that occurred.
    pub kind: DescribeImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImportErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeImportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeImportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeImportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImportError {
    fn code(&self) -> Option<&str> {
        DescribeImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImportError {
    /// Creates a new `DescribeImportError`.
    pub fn new(kind: DescribeImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeImportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeImportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeImportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImportErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeImportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeImportErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeImportErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeIntentError {
    /// Kind of error that occurred.
    pub kind: DescribeIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeIntentErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeIntentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeIntentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeIntentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeIntentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeIntentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeIntentError {
    fn code(&self) -> Option<&str> {
        DescribeIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeIntentError {
    /// Creates a new `DescribeIntentError`.
    pub fn new(kind: DescribeIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeIntentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeIntentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIntentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIntentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIntentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIntentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeIntentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeIntentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeIntentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeIntentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeIntentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeIntentErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeIntentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeIntentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeIntentErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeIntentErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DescribeResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourcePolicyErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DescribeResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourcePolicyError {
    /// Creates a new `DescribeResourcePolicyError`.
    pub fn new(kind: DescribeResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSlotError {
    /// Kind of error that occurred.
    pub kind: DescribeSlotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSlotErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSlotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSlotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSlotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSlotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeSlotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSlotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSlotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSlotError {
    fn code(&self) -> Option<&str> {
        DescribeSlotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSlotError {
    /// Creates a new `DescribeSlotError`.
    pub fn new(kind: DescribeSlotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSlotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSlotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSlotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSlotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSlotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeSlotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeSlotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeSlotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeSlotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSlotErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSlotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSlotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeSlotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSlotErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSlotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSlotTypeError {
    /// Kind of error that occurred.
    pub kind: DescribeSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSlotTypeErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSlotTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeSlotTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeSlotTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSlotTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSlotTypeError {
    fn code(&self) -> Option<&str> {
        DescribeSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSlotTypeError {
    /// Creates a new `DescribeSlotTypeError`.
    pub fn new(kind: DescribeSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSlotTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotTypeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSlotTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSlotTypeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSlotTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeSlotTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeSlotTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSlotTypeErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAggregatedUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAggregatedUtterancesError {
    /// Kind of error that occurred.
    pub kind: ListAggregatedUtterancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAggregatedUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAggregatedUtterancesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAggregatedUtterancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAggregatedUtterancesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAggregatedUtterancesErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            ListAggregatedUtterancesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAggregatedUtterancesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAggregatedUtterancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAggregatedUtterancesError {
    fn code(&self) -> Option<&str> {
        ListAggregatedUtterancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAggregatedUtterancesError {
    /// Creates a new `ListAggregatedUtterancesError`.
    pub fn new(kind: ListAggregatedUtterancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAggregatedUtterancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAggregatedUtterancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAggregatedUtterancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAggregatedUtterancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAggregatedUtterancesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregatedUtterancesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregatedUtterancesErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregatedUtterancesErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregatedUtterancesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregatedUtterancesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAggregatedUtterancesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAggregatedUtterancesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAggregatedUtterancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAggregatedUtterancesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAggregatedUtterancesErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            ListAggregatedUtterancesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAggregatedUtterancesErrorKind::ValidationException(_inner) => Some(_inner),
            ListAggregatedUtterancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBotAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotAliasesError {
    /// Kind of error that occurred.
    pub kind: ListBotAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBotAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotAliasesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotAliasesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBotAliasesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBotAliasesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBotAliasesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBotAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotAliasesError {
    fn code(&self) -> Option<&str> {
        ListBotAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotAliasesError {
    /// Creates a new `ListBotAliasesError`.
    pub fn new(kind: ListBotAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotAliasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotAliasesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotAliasesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotAliasesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotAliasesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotAliasesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListBotAliasesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListBotAliasesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListBotAliasesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListBotAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotAliasesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBotAliasesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBotAliasesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBotAliasesErrorKind::ValidationException(_inner) => Some(_inner),
            ListBotAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBotLocales` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotLocalesError {
    /// Kind of error that occurred.
    pub kind: ListBotLocalesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBotLocales` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotLocalesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotLocalesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotLocalesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBotLocalesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBotLocalesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBotLocalesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBotLocalesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotLocalesError {
    fn code(&self) -> Option<&str> {
        ListBotLocalesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotLocalesError {
    /// Creates a new `ListBotLocalesError`.
    pub fn new(kind: ListBotLocalesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotLocalesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotLocalesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotLocalesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotLocalesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotLocalesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotLocalesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotLocalesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotLocalesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotLocalesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListBotLocalesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListBotLocalesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListBotLocalesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListBotLocalesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotLocalesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBotLocalesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBotLocalesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBotLocalesErrorKind::ValidationException(_inner) => Some(_inner),
            ListBotLocalesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotsError {
    /// Kind of error that occurred.
    pub kind: ListBotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotsError {
    fn code(&self) -> Option<&str> {
        ListBotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotsError {
    /// Creates a new `ListBotsError`.
    pub fn new(kind: ListBotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListBotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBotsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBotsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBotVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotVersionsError {
    /// Kind of error that occurred.
    pub kind: ListBotVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBotVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotVersionsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBotVersionsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBotVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBotVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBotVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotVersionsError {
    fn code(&self) -> Option<&str> {
        ListBotVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotVersionsError {
    /// Creates a new `ListBotVersionsError`.
    pub fn new(kind: ListBotVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotVersionsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBotVersionsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBotVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListBotVersionsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListBotVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListBotVersionsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListBotVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBotVersionsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBotVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBotVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBotVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuiltInIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuiltInIntentsError {
    /// Kind of error that occurred.
    pub kind: ListBuiltInIntentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuiltInIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuiltInIntentsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuiltInIntentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuiltInIntentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBuiltInIntentsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBuiltInIntentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBuiltInIntentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBuiltInIntentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuiltInIntentsError {
    fn code(&self) -> Option<&str> {
        ListBuiltInIntentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuiltInIntentsError {
    /// Creates a new `ListBuiltInIntentsError`.
    pub fn new(kind: ListBuiltInIntentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuiltInIntentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuiltInIntentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuiltInIntentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuiltInIntentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuiltInIntentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInIntentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInIntentsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInIntentsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInIntentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInIntentsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInIntentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInIntentsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListBuiltInIntentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuiltInIntentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBuiltInIntentsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBuiltInIntentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBuiltInIntentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListBuiltInIntentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuiltInSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuiltInSlotTypesError {
    /// Kind of error that occurred.
    pub kind: ListBuiltInSlotTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuiltInSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuiltInSlotTypesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuiltInSlotTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuiltInSlotTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListBuiltInSlotTypesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListBuiltInSlotTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBuiltInSlotTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListBuiltInSlotTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuiltInSlotTypesError {
    fn code(&self) -> Option<&str> {
        ListBuiltInSlotTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuiltInSlotTypesError {
    /// Creates a new `ListBuiltInSlotTypesError`.
    pub fn new(kind: ListBuiltInSlotTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuiltInSlotTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuiltInSlotTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuiltInSlotTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuiltInSlotTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuiltInSlotTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInSlotTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInSlotTypesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInSlotTypesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInSlotTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInSlotTypesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuiltInSlotTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuiltInSlotTypesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListBuiltInSlotTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuiltInSlotTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListBuiltInSlotTypesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListBuiltInSlotTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBuiltInSlotTypesErrorKind::ValidationException(_inner) => Some(_inner),
            ListBuiltInSlotTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListExportsError {
    /// Kind of error that occurred.
    pub kind: ListExportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListExports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListExportsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListExportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListExportsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListExportsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListExportsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListExportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListExportsError {
    fn code(&self) -> Option<&str> {
        ListExportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListExportsError {
    /// Creates a new `ListExportsError`.
    pub fn new(kind: ListExportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListExportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListExportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListExportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListExportsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListExportsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListExportsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListExportsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListExportsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListExportsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListExportsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListExportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListExportsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListExportsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListExportsErrorKind::ValidationException(_inner) => Some(_inner),
            ListExportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListImports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListImportsError {
    /// Kind of error that occurred.
    pub kind: ListImportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListImports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListImportsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListImportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListImportsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListImportsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListImportsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListImportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListImportsError {
    fn code(&self) -> Option<&str> {
        ListImportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListImportsError {
    /// Creates a new `ListImportsError`.
    pub fn new(kind: ListImportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListImportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListImportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListImportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListImportsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListImportsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListImportsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListImportsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListImportsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListImportsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListImportsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListImportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListImportsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListImportsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListImportsErrorKind::ValidationException(_inner) => Some(_inner),
            ListImportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIntentsError {
    /// Kind of error that occurred.
    pub kind: ListIntentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIntentsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIntentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIntentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListIntentsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListIntentsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIntentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListIntentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIntentsError {
    fn code(&self) -> Option<&str> {
        ListIntentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIntentsError {
    /// Creates a new `ListIntentsError`.
    pub fn new(kind: ListIntentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIntentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIntentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIntentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIntentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIntentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListIntentsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListIntentsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntentsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIntentsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListIntentsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListIntentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListIntentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListIntentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIntentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListIntentsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListIntentsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIntentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListIntentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSlots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSlotsError {
    /// Kind of error that occurred.
    pub kind: ListSlotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSlots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSlotsErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSlotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSlotsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSlotsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListSlotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSlotsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSlotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSlotsError {
    fn code(&self) -> Option<&str> {
        ListSlotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSlotsError {
    /// Creates a new `ListSlotsError`.
    pub fn new(kind: ListSlotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSlotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSlotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSlotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSlotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSlotsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListSlotsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListSlotsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSlotsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSlotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListSlotsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListSlotsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSlotsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSlotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSlotsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSlotsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListSlotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSlotsErrorKind::ValidationException(_inner) => Some(_inner),
            ListSlotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSlotTypesError {
    /// Kind of error that occurred.
    pub kind: ListSlotTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSlotTypesErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSlotTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSlotTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListSlotTypesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListSlotTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSlotTypesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListSlotTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSlotTypesError {
    fn code(&self) -> Option<&str> {
        ListSlotTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSlotTypesError {
    /// Creates a new `ListSlotTypesError`.
    pub fn new(kind: ListSlotTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSlotTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSlotTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSlotTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSlotTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSlotTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSlotTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSlotTypesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSlotTypesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSlotTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListSlotTypesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListSlotTypesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListSlotTypesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListSlotTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSlotTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListSlotTypesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListSlotTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSlotTypesErrorKind::ValidationException(_inner) => Some(_inner),
            ListSlotTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImportError {
    /// Kind of error that occurred.
    pub kind: StartImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImportErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImportErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartImportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartImportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartImportErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartImportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartImportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImportError {
    fn code(&self) -> Option<&str> {
        StartImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImportError {
    /// Creates a new `StartImportError`.
    pub fn new(kind: StartImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImportErrorKind::ConflictException(_inner) => Some(_inner),
            StartImportErrorKind::InternalServerException(_inner) => Some(_inner),
            StartImportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartImportErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartImportErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartImportErrorKind::ValidationException(_inner) => Some(_inner),
            StartImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBotError {
    /// Kind of error that occurred.
    pub kind: UpdateBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBotError {
    fn code(&self) -> Option<&str> {
        UpdateBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBotError {
    /// Creates a new `UpdateBotError`.
    pub fn new(kind: UpdateBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBotErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBotErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateBotErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBotAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBotAliasErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBotAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBotAliasError {
    fn code(&self) -> Option<&str> {
        UpdateBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBotAliasError {
    /// Creates a new `UpdateBotAliasError`.
    pub fn new(kind: UpdateBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotAliasErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotAliasErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotAliasErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotAliasErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotAliasErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotAliasErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBotAliasErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBotLocaleError {
    /// Kind of error that occurred.
    pub kind: UpdateBotLocaleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBotLocale` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBotLocaleErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBotLocaleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBotLocaleErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateBotLocaleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBotLocaleError {
    fn code(&self) -> Option<&str> {
        UpdateBotLocaleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBotLocaleError {
    /// Creates a new `UpdateBotLocaleError`.
    pub fn new(kind: UpdateBotLocaleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBotLocaleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBotLocaleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBotLocaleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBotLocaleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotLocaleErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotLocaleErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotLocaleErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBotLocaleErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotLocaleErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateBotLocaleErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateBotLocaleErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateBotLocaleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBotLocaleErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateBotLocaleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateExportError {
    /// Kind of error that occurred.
    pub kind: UpdateExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateExportErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateExportErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateExportError {
    fn code(&self) -> Option<&str> {
        UpdateExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateExportError {
    /// Creates a new `UpdateExportError`.
    pub fn new(kind: UpdateExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateExportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateExportErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateExportErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateExportErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateExportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateExportErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateExportErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateExportErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateExportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateExportErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateExportErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateExportErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateIntentError {
    /// Kind of error that occurred.
    pub kind: UpdateIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateIntentErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateIntentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateIntentError {
    fn code(&self) -> Option<&str> {
        UpdateIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateIntentError {
    /// Creates a new `UpdateIntentError`.
    pub fn new(kind: UpdateIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateIntentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntentErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateIntentErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntentErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateIntentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateIntentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateIntentErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateIntentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateIntentErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateIntentErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateIntentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateIntentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResourcePolicyErrorKind {
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You asked to describe a resource that doesn't exist. Check the
    /// resource that you are requesting and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResourcePolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResourcePolicyError {
    fn code(&self) -> Option<&str> {
        UpdateResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResourcePolicyError {
    /// Creates a new `UpdateResourcePolicyError`.
    pub fn new(kind: UpdateResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateResourcePolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResourcePolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResourcePolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSlotError {
    /// Kind of error that occurred.
    pub kind: UpdateSlotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSlot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSlotErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSlotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSlotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSlotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSlotError {
    fn code(&self) -> Option<&str> {
        UpdateSlotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSlotError {
    /// Creates a new `UpdateSlotError`.
    pub fn new(kind: UpdateSlotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSlotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSlotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSlotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSlotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSlotErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSlotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateSlotErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSlotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSlotErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateSlotErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSlotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateSlotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateSlotErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSlotErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSlotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSlotTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSlotTypeErrorKind {
    /// <p>The action that you tried to perform couldn't be completed because
    /// the resource is in a conflicting state. For example, deleting a bot
    /// that is in the CREATING state. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>The service encountered an unexpected condition. Try your request
    /// again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Your request couldn't be completed because one or more request
    /// fields aren't valid. Check the fields in your request and try
    /// again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>You have reached a quota for your bot. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Your request rate is too high. Reduce the frequency of
    /// requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>One of the input parameters in your request isn't valid. Check the
    /// parameters and try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSlotTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSlotTypeError {
    fn code(&self) -> Option<&str> {
        UpdateSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSlotTypeError {
    /// Creates a new `UpdateSlotTypeError`.
    pub fn new(kind: UpdateSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotTypeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSlotTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSlotTypeErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSlotTypeErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotTypeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UpdateSlotTypeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSlotTypeErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSlotTypeErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>One of the input parameters in your request isn't valid. Check the
/// parameters and try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Your request rate is too high. Reduce the frequency of
/// requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: i32,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_after_seconds(&self) -> i32 {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<i32>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>You have reached a quota for your bot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>Your request couldn't be completed because one or more request
/// fields aren't valid. Check the fields in your request and try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailedException {}
/// See [`PreconditionFailedException`](crate::error::PreconditionFailedException)
pub mod precondition_failed_exception {
    /// A builder for [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailedException`](crate::error::PreconditionFailedException)
        pub fn build(self) -> crate::error::PreconditionFailedException {
            crate::error::PreconditionFailedException {
                message: self.message,
            }
        }
    }
}
impl PreconditionFailedException {
    /// Creates a new builder-style object to manufacture [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    pub fn builder() -> crate::error::precondition_failed_exception::Builder {
        crate::error::precondition_failed_exception::Builder::default()
    }
}

/// <p>The service encountered an unexpected condition. Try your request
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The action that you tried to perform couldn't be completed because
/// the resource is in a conflicting state. For example, deleting a bot
/// that is in the CREATING state. Try your request again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You asked to describe a resource that doesn't exist. Check the
/// resource that you are requesting and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}
