// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `LexModelBuildingServiceV2`.
///
/// This client allows ergonomic access to a `LexModelBuildingServiceV2`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BuildBotLocale` operation.
    ///
    /// See [`BuildBotLocale`](crate::client::fluent_builders::BuildBotLocale) for more information about the
    /// operation and its arguments.
    pub fn build_bot_locale(&self) -> fluent_builders::BuildBotLocale<C, M, R> {
        fluent_builders::BuildBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBot` operation.
    ///
    /// See [`CreateBot`](crate::client::fluent_builders::CreateBot) for more information about the
    /// operation and its arguments.
    pub fn create_bot(&self) -> fluent_builders::CreateBot<C, M, R> {
        fluent_builders::CreateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBotAlias` operation.
    ///
    /// See [`CreateBotAlias`](crate::client::fluent_builders::CreateBotAlias) for more information about the
    /// operation and its arguments.
    pub fn create_bot_alias(&self) -> fluent_builders::CreateBotAlias<C, M, R> {
        fluent_builders::CreateBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBotLocale` operation.
    ///
    /// See [`CreateBotLocale`](crate::client::fluent_builders::CreateBotLocale) for more information about the
    /// operation and its arguments.
    pub fn create_bot_locale(&self) -> fluent_builders::CreateBotLocale<C, M, R> {
        fluent_builders::CreateBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBotVersion` operation.
    ///
    /// See [`CreateBotVersion`](crate::client::fluent_builders::CreateBotVersion) for more information about the
    /// operation and its arguments.
    pub fn create_bot_version(&self) -> fluent_builders::CreateBotVersion<C, M, R> {
        fluent_builders::CreateBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateExport` operation.
    ///
    /// See [`CreateExport`](crate::client::fluent_builders::CreateExport) for more information about the
    /// operation and its arguments.
    pub fn create_export(&self) -> fluent_builders::CreateExport<C, M, R> {
        fluent_builders::CreateExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIntent` operation.
    ///
    /// See [`CreateIntent`](crate::client::fluent_builders::CreateIntent) for more information about the
    /// operation and its arguments.
    pub fn create_intent(&self) -> fluent_builders::CreateIntent<C, M, R> {
        fluent_builders::CreateIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourcePolicy` operation.
    ///
    /// See [`CreateResourcePolicy`](crate::client::fluent_builders::CreateResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn create_resource_policy(&self) -> fluent_builders::CreateResourcePolicy<C, M, R> {
        fluent_builders::CreateResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourcePolicyStatement` operation.
    ///
    /// See [`CreateResourcePolicyStatement`](crate::client::fluent_builders::CreateResourcePolicyStatement) for more information about the
    /// operation and its arguments.
    pub fn create_resource_policy_statement(
        &self,
    ) -> fluent_builders::CreateResourcePolicyStatement<C, M, R> {
        fluent_builders::CreateResourcePolicyStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSlot` operation.
    ///
    /// See [`CreateSlot`](crate::client::fluent_builders::CreateSlot) for more information about the
    /// operation and its arguments.
    pub fn create_slot(&self) -> fluent_builders::CreateSlot<C, M, R> {
        fluent_builders::CreateSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSlotType` operation.
    ///
    /// See [`CreateSlotType`](crate::client::fluent_builders::CreateSlotType) for more information about the
    /// operation and its arguments.
    pub fn create_slot_type(&self) -> fluent_builders::CreateSlotType<C, M, R> {
        fluent_builders::CreateSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUploadUrl` operation.
    ///
    /// See [`CreateUploadUrl`](crate::client::fluent_builders::CreateUploadUrl) for more information about the
    /// operation and its arguments.
    pub fn create_upload_url(&self) -> fluent_builders::CreateUploadUrl<C, M, R> {
        fluent_builders::CreateUploadUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBot` operation.
    ///
    /// See [`DeleteBot`](crate::client::fluent_builders::DeleteBot) for more information about the
    /// operation and its arguments.
    pub fn delete_bot(&self) -> fluent_builders::DeleteBot<C, M, R> {
        fluent_builders::DeleteBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBotAlias` operation.
    ///
    /// See [`DeleteBotAlias`](crate::client::fluent_builders::DeleteBotAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_bot_alias(&self) -> fluent_builders::DeleteBotAlias<C, M, R> {
        fluent_builders::DeleteBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBotLocale` operation.
    ///
    /// See [`DeleteBotLocale`](crate::client::fluent_builders::DeleteBotLocale) for more information about the
    /// operation and its arguments.
    pub fn delete_bot_locale(&self) -> fluent_builders::DeleteBotLocale<C, M, R> {
        fluent_builders::DeleteBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBotVersion` operation.
    ///
    /// See [`DeleteBotVersion`](crate::client::fluent_builders::DeleteBotVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_bot_version(&self) -> fluent_builders::DeleteBotVersion<C, M, R> {
        fluent_builders::DeleteBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteExport` operation.
    ///
    /// See [`DeleteExport`](crate::client::fluent_builders::DeleteExport) for more information about the
    /// operation and its arguments.
    pub fn delete_export(&self) -> fluent_builders::DeleteExport<C, M, R> {
        fluent_builders::DeleteExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImport` operation.
    ///
    /// See [`DeleteImport`](crate::client::fluent_builders::DeleteImport) for more information about the
    /// operation and its arguments.
    pub fn delete_import(&self) -> fluent_builders::DeleteImport<C, M, R> {
        fluent_builders::DeleteImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntent` operation.
    ///
    /// See [`DeleteIntent`](crate::client::fluent_builders::DeleteIntent) for more information about the
    /// operation and its arguments.
    pub fn delete_intent(&self) -> fluent_builders::DeleteIntent<C, M, R> {
        fluent_builders::DeleteIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicyStatement` operation.
    ///
    /// See [`DeleteResourcePolicyStatement`](crate::client::fluent_builders::DeleteResourcePolicyStatement) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy_statement(
        &self,
    ) -> fluent_builders::DeleteResourcePolicyStatement<C, M, R> {
        fluent_builders::DeleteResourcePolicyStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSlot` operation.
    ///
    /// See [`DeleteSlot`](crate::client::fluent_builders::DeleteSlot) for more information about the
    /// operation and its arguments.
    pub fn delete_slot(&self) -> fluent_builders::DeleteSlot<C, M, R> {
        fluent_builders::DeleteSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSlotType` operation.
    ///
    /// See [`DeleteSlotType`](crate::client::fluent_builders::DeleteSlotType) for more information about the
    /// operation and its arguments.
    pub fn delete_slot_type(&self) -> fluent_builders::DeleteSlotType<C, M, R> {
        fluent_builders::DeleteSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUtterances` operation.
    ///
    /// See [`DeleteUtterances`](crate::client::fluent_builders::DeleteUtterances) for more information about the
    /// operation and its arguments.
    pub fn delete_utterances(&self) -> fluent_builders::DeleteUtterances<C, M, R> {
        fluent_builders::DeleteUtterances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBot` operation.
    ///
    /// See [`DescribeBot`](crate::client::fluent_builders::DescribeBot) for more information about the
    /// operation and its arguments.
    pub fn describe_bot(&self) -> fluent_builders::DescribeBot<C, M, R> {
        fluent_builders::DescribeBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBotAlias` operation.
    ///
    /// See [`DescribeBotAlias`](crate::client::fluent_builders::DescribeBotAlias) for more information about the
    /// operation and its arguments.
    pub fn describe_bot_alias(&self) -> fluent_builders::DescribeBotAlias<C, M, R> {
        fluent_builders::DescribeBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBotLocale` operation.
    ///
    /// See [`DescribeBotLocale`](crate::client::fluent_builders::DescribeBotLocale) for more information about the
    /// operation and its arguments.
    pub fn describe_bot_locale(&self) -> fluent_builders::DescribeBotLocale<C, M, R> {
        fluent_builders::DescribeBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBotVersion` operation.
    ///
    /// See [`DescribeBotVersion`](crate::client::fluent_builders::DescribeBotVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_bot_version(&self) -> fluent_builders::DescribeBotVersion<C, M, R> {
        fluent_builders::DescribeBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExport` operation.
    ///
    /// See [`DescribeExport`](crate::client::fluent_builders::DescribeExport) for more information about the
    /// operation and its arguments.
    pub fn describe_export(&self) -> fluent_builders::DescribeExport<C, M, R> {
        fluent_builders::DescribeExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImport` operation.
    ///
    /// See [`DescribeImport`](crate::client::fluent_builders::DescribeImport) for more information about the
    /// operation and its arguments.
    pub fn describe_import(&self) -> fluent_builders::DescribeImport<C, M, R> {
        fluent_builders::DescribeImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeIntent` operation.
    ///
    /// See [`DescribeIntent`](crate::client::fluent_builders::DescribeIntent) for more information about the
    /// operation and its arguments.
    pub fn describe_intent(&self) -> fluent_builders::DescribeIntent<C, M, R> {
        fluent_builders::DescribeIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResourcePolicy` operation.
    ///
    /// See [`DescribeResourcePolicy`](crate::client::fluent_builders::DescribeResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn describe_resource_policy(&self) -> fluent_builders::DescribeResourcePolicy<C, M, R> {
        fluent_builders::DescribeResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSlot` operation.
    ///
    /// See [`DescribeSlot`](crate::client::fluent_builders::DescribeSlot) for more information about the
    /// operation and its arguments.
    pub fn describe_slot(&self) -> fluent_builders::DescribeSlot<C, M, R> {
        fluent_builders::DescribeSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSlotType` operation.
    ///
    /// See [`DescribeSlotType`](crate::client::fluent_builders::DescribeSlotType) for more information about the
    /// operation and its arguments.
    pub fn describe_slot_type(&self) -> fluent_builders::DescribeSlotType<C, M, R> {
        fluent_builders::DescribeSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAggregatedUtterances` operation.
    ///
    /// See [`ListAggregatedUtterances`](crate::client::fluent_builders::ListAggregatedUtterances) for more information about the
    /// operation and its arguments.
    pub fn list_aggregated_utterances(&self) -> fluent_builders::ListAggregatedUtterances<C, M, R> {
        fluent_builders::ListAggregatedUtterances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBotAliases` operation.
    ///
    /// See [`ListBotAliases`](crate::client::fluent_builders::ListBotAliases) for more information about the
    /// operation and its arguments.
    pub fn list_bot_aliases(&self) -> fluent_builders::ListBotAliases<C, M, R> {
        fluent_builders::ListBotAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBotLocales` operation.
    ///
    /// See [`ListBotLocales`](crate::client::fluent_builders::ListBotLocales) for more information about the
    /// operation and its arguments.
    pub fn list_bot_locales(&self) -> fluent_builders::ListBotLocales<C, M, R> {
        fluent_builders::ListBotLocales::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBots` operation.
    ///
    /// See [`ListBots`](crate::client::fluent_builders::ListBots) for more information about the
    /// operation and its arguments.
    pub fn list_bots(&self) -> fluent_builders::ListBots<C, M, R> {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBotVersions` operation.
    ///
    /// See [`ListBotVersions`](crate::client::fluent_builders::ListBotVersions) for more information about the
    /// operation and its arguments.
    pub fn list_bot_versions(&self) -> fluent_builders::ListBotVersions<C, M, R> {
        fluent_builders::ListBotVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuiltInIntents` operation.
    ///
    /// See [`ListBuiltInIntents`](crate::client::fluent_builders::ListBuiltInIntents) for more information about the
    /// operation and its arguments.
    pub fn list_built_in_intents(&self) -> fluent_builders::ListBuiltInIntents<C, M, R> {
        fluent_builders::ListBuiltInIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuiltInSlotTypes` operation.
    ///
    /// See [`ListBuiltInSlotTypes`](crate::client::fluent_builders::ListBuiltInSlotTypes) for more information about the
    /// operation and its arguments.
    pub fn list_built_in_slot_types(&self) -> fluent_builders::ListBuiltInSlotTypes<C, M, R> {
        fluent_builders::ListBuiltInSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExports` operation.
    ///
    /// See [`ListExports`](crate::client::fluent_builders::ListExports) for more information about the
    /// operation and its arguments.
    pub fn list_exports(&self) -> fluent_builders::ListExports<C, M, R> {
        fluent_builders::ListExports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImports` operation.
    ///
    /// See [`ListImports`](crate::client::fluent_builders::ListImports) for more information about the
    /// operation and its arguments.
    pub fn list_imports(&self) -> fluent_builders::ListImports<C, M, R> {
        fluent_builders::ListImports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIntents` operation.
    ///
    /// See [`ListIntents`](crate::client::fluent_builders::ListIntents) for more information about the
    /// operation and its arguments.
    pub fn list_intents(&self) -> fluent_builders::ListIntents<C, M, R> {
        fluent_builders::ListIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSlots` operation.
    ///
    /// See [`ListSlots`](crate::client::fluent_builders::ListSlots) for more information about the
    /// operation and its arguments.
    pub fn list_slots(&self) -> fluent_builders::ListSlots<C, M, R> {
        fluent_builders::ListSlots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSlotTypes` operation.
    ///
    /// See [`ListSlotTypes`](crate::client::fluent_builders::ListSlotTypes) for more information about the
    /// operation and its arguments.
    pub fn list_slot_types(&self) -> fluent_builders::ListSlotTypes<C, M, R> {
        fluent_builders::ListSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImport` operation.
    ///
    /// See [`StartImport`](crate::client::fluent_builders::StartImport) for more information about the
    /// operation and its arguments.
    pub fn start_import(&self) -> fluent_builders::StartImport<C, M, R> {
        fluent_builders::StartImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBot` operation.
    ///
    /// See [`UpdateBot`](crate::client::fluent_builders::UpdateBot) for more information about the
    /// operation and its arguments.
    pub fn update_bot(&self) -> fluent_builders::UpdateBot<C, M, R> {
        fluent_builders::UpdateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBotAlias` operation.
    ///
    /// See [`UpdateBotAlias`](crate::client::fluent_builders::UpdateBotAlias) for more information about the
    /// operation and its arguments.
    pub fn update_bot_alias(&self) -> fluent_builders::UpdateBotAlias<C, M, R> {
        fluent_builders::UpdateBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBotLocale` operation.
    ///
    /// See [`UpdateBotLocale`](crate::client::fluent_builders::UpdateBotLocale) for more information about the
    /// operation and its arguments.
    pub fn update_bot_locale(&self) -> fluent_builders::UpdateBotLocale<C, M, R> {
        fluent_builders::UpdateBotLocale::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateExport` operation.
    ///
    /// See [`UpdateExport`](crate::client::fluent_builders::UpdateExport) for more information about the
    /// operation and its arguments.
    pub fn update_export(&self) -> fluent_builders::UpdateExport<C, M, R> {
        fluent_builders::UpdateExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIntent` operation.
    ///
    /// See [`UpdateIntent`](crate::client::fluent_builders::UpdateIntent) for more information about the
    /// operation and its arguments.
    pub fn update_intent(&self) -> fluent_builders::UpdateIntent<C, M, R> {
        fluent_builders::UpdateIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResourcePolicy` operation.
    ///
    /// See [`UpdateResourcePolicy`](crate::client::fluent_builders::UpdateResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn update_resource_policy(&self) -> fluent_builders::UpdateResourcePolicy<C, M, R> {
        fluent_builders::UpdateResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSlot` operation.
    ///
    /// See [`UpdateSlot`](crate::client::fluent_builders::UpdateSlot) for more information about the
    /// operation and its arguments.
    pub fn update_slot(&self) -> fluent_builders::UpdateSlot<C, M, R> {
        fluent_builders::UpdateSlot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSlotType` operation.
    ///
    /// See [`UpdateSlotType`](crate::client::fluent_builders::UpdateSlotType) for more information about the
    /// operation and its arguments.
    pub fn update_slot_type(&self) -> fluent_builders::UpdateSlotType<C, M, R> {
        fluent_builders::UpdateSlotType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BuildBotLocale`.
    ///
    /// <p>Builds a bot, its intents, and its slot types into a specific
    /// locale. A bot can be built into multiple locales. At runtime the locale
    /// is used to choose a specific build of the bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct BuildBotLocale<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::build_bot_locale_input::Builder,
    }
    impl<C, M, R> BuildBotLocale<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BuildBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BuildBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::BuildBotLocaleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BuildBotLocaleInputOperationOutputAlias,
                crate::output::BuildBotLocaleOutput,
                crate::error::BuildBotLocaleError,
                crate::input::BuildBotLocaleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to build. The identifier is returned in
        /// the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to build. The identifier is returned in
        /// the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version
        /// of the bot.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to build. This can only be the draft version
        /// of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBot`.
    ///
    /// <p>Creates an Amazon Lex conversational bot. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_input::Builder,
    }
    impl<C, M, R> CreateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotInputOperationOutputAlias,
                crate::output::CreateBotOutput,
                crate::error::CreateBotError,
                crate::input::CreateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot. The bot name must be unique in the account that
        /// creates the bot.</p>
        pub fn bot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(inp);
            self
        }
        /// <p>The name of the bot. The bot name must be unique in the account that
        /// creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a
        /// particular bot.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the bot. It appears in lists to help you identify a
        /// particular bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
        /// access the bot.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
        /// access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should
        /// use with the bot's data.</p>
        pub fn data_privacy(mut self, inp: crate::model::DataPrivacy) -> Self {
            self.inner = self.inner.data_privacy(inp);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should
        /// use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_data_privacy(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.idle_session_ttl_in_seconds(inp);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_session_ttl_in_seconds(input);
            self
        }
        /// Adds a key-value pair to `botTags`.
        ///
        /// To override the contents of this collection use [`set_bot_tags`](Self::set_bot_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// create a bot. You can't use the <code>UpdateBot</code> operation to
        /// update tags. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn bot_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.bot_tags(k, v);
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// create a bot. You can't use the <code>UpdateBot</code> operation to
        /// update tags. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn set_bot_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_tags(input);
            self
        }
        /// Adds a key-value pair to `testBotAliasTags`.
        ///
        /// To override the contents of this collection use [`set_test_bot_alias_tags`](Self::set_test_bot_alias_tags).
        ///
        /// <p>A list of tags to add to the test alias for a bot. You can only add
        /// tags when you create a bot. You can't use the <code>UpdateAlias</code>
        /// operation to update tags. To update tags on the test alias, use the
        /// <code>TagResource</code> operation.</p>
        pub fn test_bot_alias_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.test_bot_alias_tags(k, v);
            self
        }
        /// <p>A list of tags to add to the test alias for a bot. You can only add
        /// tags when you create a bot. You can't use the <code>UpdateAlias</code>
        /// operation to update tags. To update tags on the test alias, use the
        /// <code>TagResource</code> operation.</p>
        pub fn set_test_bot_alias_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_test_bot_alias_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotAlias`.
    ///
    /// <p>Creates an alias for the specified version of a bot. Use an alias to
    /// enable you to change the version of a bot without updating applications
    /// that use the bot.</p>
    /// <p>For example, you can create an alias called "PROD" that your
    /// applications use to call the Amazon Lex bot. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_alias_input::Builder,
    }
    impl<C, M, R> CreateBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotAliasInputOperationOutputAlias,
                crate::output::CreateBotAliasOutput,
                crate::error::CreateBotAliasError,
                crate::input::CreateBotAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn bot_alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_name(inp);
            self
        }
        /// <p>The alias to create. The name must be unique for the bot.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_name(input);
            self
        }
        /// <p>A description of the alias. Use this description to help identify
        /// the alias.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the alias. Use this description to help identify
        /// the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the
        /// <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the
        /// bot version associated with the alias.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that this alias points to. You can use the
        /// <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html">UpdateBotAlias</a> operation to change the
        /// bot version associated with the alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// Adds a key-value pair to `botAliasLocaleSettings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>Maps configuration information to a specific locale. You can use
        /// this parameter to specify a specific Lambda function to run different
        /// functions in different locales.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::BotAliasLocaleSettings>,
        ) -> Self {
            self.inner = self.inner.bot_alias_locale_settings(k, v);
            self
        }
        /// <p>Maps configuration information to a specific locale. You can use
        /// this parameter to specify a specific Lambda function to run different
        /// functions in different locales.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_locale_settings(input);
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with
        /// the bot. When you enable conversation logs, text logs store text input,
        /// transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio
        /// logs store audio input in Amazon S3.</p>
        pub fn conversation_log_settings(
            mut self,
            inp: crate::model::ConversationLogSettings,
        ) -> Self {
            self.inner = self.inner.conversation_log_settings(inp);
            self
        }
        /// <p>Specifies whether Amazon Lex logs text and audio for a conversation with
        /// the bot. When you enable conversation logs, text logs store text input,
        /// transcripts of audio input, and associated metadata in Amazon CloudWatch Logs. Audio
        /// logs store audio input in Amazon S3.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_conversation_log_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of
        /// user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            inp: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.inner = self.inner.sentiment_analysis_settings(inp);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of
        /// user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.inner = self.inner.set_sentiment_analysis_settings(input);
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that the alias applies to.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot alias. You can only add tags when
        /// you create an alias, you can't use the <code>UpdateBotAlias</code>
        /// operation to update the tags on a bot alias. To update tags, use the
        /// <code>TagResource</code> operation.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tags to add to the bot alias. You can only add tags when
        /// you create an alias, you can't use the <code>UpdateBotAlias</code>
        /// operation to update the tags on a bot alias. To update tags, use the
        /// <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotLocale`.
    ///
    /// <p>Creates a locale in the bot. The locale contains the intents and
    /// slot types that the bot uses in conversations with users in the
    /// specified language and locale. You must add a locale to a bot before
    /// you can add intents and slot types to the bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBotLocale<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_locale_input::Builder,
    }
    impl<C, M, R> CreateBotLocale<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotLocaleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotLocaleInputOperationOutputAlias,
                crate::output::CreateBotLocaleOutput,
                crate::error::CreateBotLocaleError,
                crate::input::CreateBotLocaleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be
        /// the draft version of the bot.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to create the locale for. This can only be
        /// the draft version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot
        /// locale in lists.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the bot locale. Use this to help identify the bot
        /// locale in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents. <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence
        /// threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex
        /// returns three alternative intents with the following confidence scores:
        /// IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
        /// <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>AMAZON.FallbackIntent</p>
        /// </li>
        /// <li>
        /// <p>IntentA</p>
        /// </li>
        /// <li>
        /// <p>IntentB</p>
        /// </li>
        /// <li>
        /// <p>IntentC</p>
        /// </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, inp: f64) -> Self {
            self.inner = self.inner.nlu_intent_confidence_threshold(inp);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents. <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot.</p>
        /// <p>For example, suppose a bot is configured with the confidence
        /// threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex
        /// returns three alternative intents with the following confidence scores:
        /// IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the
        /// <code>RecognizeText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>AMAZON.FallbackIntent</p>
        /// </li>
        /// <li>
        /// <p>IntentA</p>
        /// </li>
        /// <li>
        /// <p>IntentB</p>
        /// </li>
        /// <li>
        /// <p>IntentC</p>
        /// </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the
        /// user.</p>
        pub fn voice_settings(mut self, inp: crate::model::VoiceSettings) -> Self {
            self.inner = self.inner.voice_settings(inp);
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the
        /// user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.inner = self.inner.set_voice_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBotVersion`.
    ///
    /// <p>Creates a new version of the bot based on the <code>DRAFT</code>
    /// version. If the <code>DRAFT</code> version of this resource hasn't
    /// changed since you created the last version, Amazon Lex doesn't create a new
    /// version, it returns the last created version.</p>
    /// <p>When you create the first version of a bot, Amazon Lex sets the version
    /// to 1. Subsequent versions increment by 1.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBotVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_version_input::Builder,
    }
    impl<C, M, R> CreateBotVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotVersionInputOperationOutputAlias,
                crate::output::CreateBotVersionOutput,
                crate::error::CreateBotVersionError,
                crate::input::CreateBotVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to create the version for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>A description of the version. Use the description to help identify
        /// the version in lists.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the version. Use the description to help identify
        /// the version in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `botVersionLocaleSpecification`.
        ///
        /// To override the contents of this collection use [`set_bot_version_locale_specification`](Self::set_bot_version_locale_specification).
        ///
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can
        /// choose the <code>Draft</code> version or any other previously published
        /// version for each locale. When you specify a source version, the locale
        /// data is copied from the source version to the new version.</p>
        pub fn bot_version_locale_specification(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::BotVersionLocaleDetails>,
        ) -> Self {
            self.inner = self.inner.bot_version_locale_specification(k, v);
            self
        }
        /// <p>Specifies the locales that Amazon Lex adds to this version. You can
        /// choose the <code>Draft</code> version or any other previously published
        /// version for each locale. When you specify a source version, the locale
        /// data is copied from the source version to the new version.</p>
        pub fn set_bot_version_locale_specification(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotVersionLocaleDetails,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_version_locale_specification(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExport`.
    ///
    /// <p>Creates a zip archive containing the contents of a bot or a bot
    /// locale. The archive contains a directory structure that contains JSON
    /// files that define the bot.</p>
    /// <p>You can create an archive that contains the complete definition of a
    /// bot, or you can specify that the archive contain only the definition of
    /// a single bot locale.</p>
    /// <p>For more information about exporting bots, and about the structure
    /// of the export archive, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/importing-exporting.html"> Importing and
    /// exporting bots </a>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_export_input::Builder,
    }
    impl<C, M, R> CreateExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExportInputOperationOutputAlias,
                crate::output::CreateExportOutput,
                crate::error::CreateExportError,
                crate::input::CreateExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the type of resource to export, either a bot or a bot
        /// locale. You can only specify one type of resource to export.</p>
        pub fn resource_specification(
            mut self,
            inp: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.inner = self.inner.resource_specification(inp);
            self
        }
        /// <p>Specifies the type of resource to export, either a bot or a bot
        /// locale. You can only specify one type of resource to export.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_resource_specification(input);
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn file_format(mut self, inp: crate::model::ImportExportFileFormat) -> Self {
            self.inner = self.inner.file_format(inp);
            self
        }
        /// <p>The file format of the bot or bot locale definition files.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.inner = self.inner.set_file_format(input);
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password
        /// is optional, but you should encrypt the archive to protect the data in
        /// transit between Amazon Lex and your local computer.</p>
        pub fn file_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(inp);
            self
        }
        /// <p>An password to use to encrypt the exported archive. Using a password
        /// is optional, but you should encrypt the archive to protect the data in
        /// transit between Amazon Lex and your local computer.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntent`.
    ///
    /// <p>Creates an intent.</p>
    /// <p>To define the interaction between the user and your bot, you define
    /// one or more intents. For example, for a pizza ordering bot you would
    /// create an <code>OrderPizza</code> intent.</p>
    /// <p>When you create an intent, you must provide a name. You can
    /// optionally provide the following:</p>
    /// <ul>
    /// <li>
    /// <p>Sample utterances. For example, "I want to order a pizza" and
    /// "Can I order a pizza." You can't provide utterances for built-in
    /// intents.</p>
    /// </li>
    /// <li>
    /// <p>Information to be gathered. You specify slots for the
    /// information that you bot requests from the user. You can specify
    /// standard slot types, such as date and time, or custom slot types
    /// for your application.</p>
    /// </li>
    /// <li>
    /// <p>How the intent is fulfilled. You can provide a Lambda function
    /// or configure the intent to return the intent information to your
    /// client application. If you use a Lambda function, Amazon Lex invokes
    /// the function when all of the intent information is
    /// available.</p>
    /// </li>
    /// <li>
    /// <p>A confirmation prompt to send to the user to confirm an
    /// intent. For example, "Shall I order your pizza?"</p>
    /// </li>
    /// <li>
    /// <p>A conclusion statement to send to the user after the intent is
    /// fulfilled. For example, "I ordered your pizza."</p>
    /// </li>
    /// <li>
    /// <p>A follow-up prompt that asks the user for additional activity.
    /// For example, "Do you want a drink with your pizza?"</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_intent_input::Builder,
    }
    impl<C, M, R> CreateIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntentInputOperationOutputAlias,
                crate::output::CreateIntentOutput,
                crate::error::CreateIntentError,
                crate::input::CreateIntentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent. Intent names must be unique in the locale
        /// that contains the intent and cannot match the name of any built-in
        /// intent.</p>
        pub fn intent_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_name(inp);
            self
        }
        /// <p>The name of the intent. Intent names must be unique in the locale
        /// that contains the intent and cannot match the name of any built-in
        /// intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_name(input);
            self
        }
        /// <p>A description of the intent. Use the description to help identify
        /// the intent in lists.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the intent. Use the description to help identify
        /// the intent in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent
        /// on.</p>
        pub fn parent_intent_signature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_intent_signature(inp);
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent
        /// on.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_intent_signature(input);
            self
        }
        /// Appends an item to `sampleUtterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of strings that a user might say to signal the intent. For
        /// example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}")
        /// to indicate where they should be displayed in the utterance shown to
        /// the user.. </p>
        pub fn sample_utterances(mut self, inp: impl Into<crate::model::SampleUtterance>) -> Self {
            self.inner = self.inner.sample_utterances(inp);
            self
        }
        /// <p>An array of strings that a user might say to signal the intent. For
        /// example, "I want a pizza", or "I want a {PizzaSize} pizza". </p>
        /// <p>In an utterance, slot names are enclosed in curly braces ("{", "}")
        /// to indicate where they should be displayed in the utterance shown to
        /// the user.. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.inner = self.inner.set_sample_utterances(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user
        /// input. You can invoke this Lambda function to personalize user
        /// interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name
        /// is John. You Lambda function might retrieve John's information from a
        /// backend database and prepopulate some of the values. For example, if
        /// you find that John is gluten intolerant, you might set the
        /// corresponding intent slot, <code>glutenIntolerant</code> to
        /// <code>true</code>. You might find John's phone number and set the
        /// corresponding session attribute.</p>
        pub fn dialog_code_hook(mut self, inp: crate::model::DialogCodeHookSettings) -> Self {
            self.inner = self.inner.dialog_code_hook(inp);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function for each user
        /// input. You can invoke this Lambda function to personalize user
        /// interaction.</p>
        /// <p>For example, suppose that your bot determines that the user's name
        /// is John. You Lambda function might retrieve John's information from a
        /// backend database and prepopulate some of the values. For example, if
        /// you find that John is gluten intolerant, you might set the
        /// corresponding intent slot, <code>glutenIntolerant</code> to
        /// <code>true</code>. You might find John's phone number and set the
        /// corresponding session attribute.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_dialog_code_hook(input);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the
        /// intent is ready for fulfillment. You can invoke this function to
        /// complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up
        /// the closest pizza restaurant to the customer's location and then place
        /// an order on the customer's behalf.</p>
        pub fn fulfillment_code_hook(
            mut self,
            inp: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.inner = self.inner.fulfillment_code_hook(inp);
            self
        }
        /// <p>Specifies that Amazon Lex invokes the alias Lambda function when the
        /// intent is ready for fulfillment. You can invoke this function to
        /// complete the bot's transaction with the user.</p>
        /// <p>For example, in a pizza ordering bot, the Lambda function can look up
        /// the closest pizza restaurant to the customer's location and then place
        /// an order on the customer's behalf.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_fulfillment_code_hook(input);
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the
        /// completion of an intent. If the user answers "no," the settings contain
        /// a statement that is sent to the user to end the intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            inp: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.inner = self.inner.intent_confirmation_setting(inp);
            self
        }
        /// <p>Provides prompts that Amazon Lex sends to the user to confirm the
        /// completion of an intent. If the user answers "no," the settings contain
        /// a statement that is sent to the user to end the intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_confirmation_setting(input);
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is
        /// closed.</p>
        pub fn intent_closing_setting(mut self, inp: crate::model::IntentClosingSetting) -> Self {
            self.inner = self.inner.intent_closing_setting(inp);
            self
        }
        /// <p>Sets the response that Amazon Lex sends to the user when the intent is
        /// closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_closing_setting(input);
            self
        }
        /// Appends an item to `inputContexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A list of contexts that must be active for this intent to be
        /// considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using
        /// the intent in an interaction with the user when the specified contexts
        /// are included in the active context list for the session. If the
        /// contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the
        /// <code>outputContexts</code> property or it can be set at
        /// runtime.</p>
        /// <p> For example, if there are two intents with different input contexts
        /// that respond to the same utterances, only the intent with the active
        /// context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple
        /// input contexts, all of the contexts must be active to consider the
        /// intent.</p>
        pub fn input_contexts(mut self, inp: impl Into<crate::model::InputContext>) -> Self {
            self.inner = self.inner.input_contexts(inp);
            self
        }
        /// <p>A list of contexts that must be active for this intent to be
        /// considered by Amazon Lex.</p>
        /// <p>When an intent has an input context list, Amazon Lex only considers using
        /// the intent in an interaction with the user when the specified contexts
        /// are included in the active context list for the session. If the
        /// contexts are not active, then Amazon Lex will not use the intent.</p>
        /// <p>A context can be automatically activated using the
        /// <code>outputContexts</code> property or it can be set at
        /// runtime.</p>
        /// <p> For example, if there are two intents with different input contexts
        /// that respond to the same utterances, only the intent with the active
        /// context will respond.</p>
        /// <p>An intent may have up to 5 input contexts. If an intent has multiple
        /// input contexts, all of the contexts must be active to consider the
        /// intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.inner = self.inner.set_input_contexts(input);
            self
        }
        /// Appends an item to `outputContexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A lists of contexts that the intent activates when it is
        /// fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex
        /// should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of
        /// the contexts specified in the list are activated when the intent is
        /// fulfilled. You can set up to 10 output contexts. You can also set the
        /// number of conversation turns that the context should be active, or the
        /// length of time that the context should be active.</p>
        pub fn output_contexts(mut self, inp: impl Into<crate::model::OutputContext>) -> Self {
            self.inner = self.inner.output_contexts(inp);
            self
        }
        /// <p>A lists of contexts that the intent activates when it is
        /// fulfilled.</p>
        /// <p>You can use an output context to indicate the intents that Amazon Lex
        /// should consider for the next turn of the conversation with a customer. </p>
        /// <p>When you use the <code>outputContextsList</code> property, all of
        /// the contexts specified in the list are activated when the intent is
        /// fulfilled. You can set up to 10 output contexts. You can also set the
        /// number of conversation turns that the context should be active, or the
        /// length of time that the context should be active.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.inner = self.inner.set_output_contexts(input);
            self
        }
        /// <p>Configuration information required to use the
        /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra
        /// index. The <code>AMAZON.KendraSearchIntent</code> intent is called when
        /// Amazon Lex can't determine another intent to invoke.</p>
        pub fn kendra_configuration(mut self, inp: crate::model::KendraConfiguration) -> Self {
            self.inner = self.inner.kendra_configuration(inp);
            self
        }
        /// <p>Configuration information required to use the
        /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra
        /// index. The <code>AMAZON.KendraSearchIntent</code> intent is called when
        /// Amazon Lex can't determine another intent to invoke.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kendra_configuration(input);
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with this intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the version of the bot associated with this
        /// intent.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The identifier of the version of the bot associated with this
        /// intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used.
        /// All of the bots, slot types, and slots used by the intent must have the
        /// same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used.
        /// All of the bots, slot types, and slots used by the intent must have the
        /// same locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourcePolicy`.
    ///
    /// <p>Creates a new resource policy with the specified policy
    /// statements.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_policy_input::Builder,
    }
    impl<C, M, R> CreateResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourcePolicyInputOperationOutputAlias,
                crate::output::CreateResourcePolicyOutput,
                crate::error::CreateResourcePolicyError,
                crate::input::CreateResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON
        /// structure that contains one or more statements that define the policy.
        /// The policy must follow the IAM syntax. For more information about the
        /// contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy
        /// reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation
        /// exception.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON
        /// structure that contains one or more statements that define the policy.
        /// The policy must follow the IAM syntax. For more information about the
        /// contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy
        /// reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation
        /// exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourcePolicyStatement`.
    ///
    /// <p>Adds a new resource policy statement to a bot or bot alias. If a
    /// resource policy exists, the statement is added to the current resource
    /// policy. If a policy doesn't exist, a new policy is created.</p>
    /// <p>You can't create a resource policy statement that allows
    /// cross-account access.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResourcePolicyStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_policy_statement_input::Builder,
    }
    impl<C, M, R> CreateResourcePolicyStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourcePolicyStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourcePolicyStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourcePolicyStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourcePolicyStatementInputOperationOutputAlias,
                crate::output::CreateResourcePolicyStatementOutput,
                crate::error::CreateResourcePolicyStatementError,
                crate::input::CreateResourcePolicyStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name of the statement. The ID is the same as the
        /// <code>Sid</code> IAM property. The statement name must be unique
        /// within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM
        /// JSON policy elements: Sid</a>. </p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>The name of the statement. The ID is the same as the
        /// <code>Sid</code> IAM property. The statement name must be unique
        /// within the policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html">IAM
        /// JSON policy elements: Sid</a>. </p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Determines whether the statement allows or denies access to the
        /// resource.</p>
        pub fn effect(mut self, inp: crate::model::Effect) -> Self {
            self.inner = self.inner.effect(inp);
            self
        }
        /// <p>Determines whether the statement allows or denies access to the
        /// resource.</p>
        pub fn set_effect(mut self, input: std::option::Option<crate::model::Effect>) -> Self {
            self.inner = self.inner.set_effect(input);
            self
        }
        /// Appends an item to `principal`.
        ///
        /// To override the contents of this collection use [`set_principal`](Self::set_principal).
        ///
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services
        /// that is allowed or denied access to a resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn principal(mut self, inp: impl Into<crate::model::Principal>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>An IAM principal, such as an IAM users, IAM roles, or AWS services
        /// that is allowed or denied access to a resource. For more information,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">AWS JSON policy elements: Principal</a>.</p>
        pub fn set_principal(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Principal>>,
        ) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// Appends an item to `action`.
        ///
        /// To override the contents of this collection use [`set_action`](Self::set_action).
        ///
        /// <p>The Amazon Lex action that this policy either allows or denies. The
        /// action must apply to the resource type of the specified ARN. For more
        /// information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html">
        /// Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The Amazon Lex action that this policy either allows or denies. The
        /// action must apply to the resource type of the specified ARN. For more
        /// information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html">
        /// Actions, resources, and condition keys for Amazon Lex V2</a>.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// Adds a key-value pair to `condition`.
        ///
        /// To override the contents of this collection use [`set_condition`](Self::set_condition).
        ///
        /// <p>Specifies a condition when the policy is in effect. If the principal
        /// of the policy is a service principal, you must provide two condition
        /// blocks, one with a SourceAccount global condition key and one with a
        /// SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn condition(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            self.inner = self.inner.condition(k, v);
            self
        }
        /// <p>Specifies a condition when the policy is in effect. If the principal
        /// of the policy is a service principal, you must provide two condition
        /// blocks, one with a SourceAccount global condition key and one with a
        /// SourceArn global condition key.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html">IAM JSON policy elements: Condition </a>.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::collections::HashMap<std::string::String, std::string::String>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_condition(input);
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this
        /// revision ID doesn't match the current revision ID, Amazon Lex throws an
        /// exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of
        /// the policy with the new values.</p>
        pub fn expected_revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(inp);
            self
        }
        /// <p>The identifier of the revision of the policy to edit. If this
        /// revision ID doesn't match the current revision ID, Amazon Lex throws an
        /// exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of
        /// the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSlot`.
    ///
    /// <p>Creates a slot in an intent. A slot is a variable needed to fulfill
    /// an intent. For example, an <code>OrderPizza</code> intent might need
    /// slots for size, crust, and number of pizzas. For each slot, you define
    /// one or more utterances that Amazon Lex uses to elicit a response from the
    /// user. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSlot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_slot_input::Builder,
    }
    impl<C, M, R> CreateSlot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSlotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSlotInputOperationOutputAlias,
                crate::output::CreateSlotOutput,
                crate::error::CreateSlotError,
                crate::input::CreateSlotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot. Slot names must be unique within the bot that
        /// contains the slot.</p>
        pub fn slot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_name(inp);
            self
        }
        /// <p>The name of the slot. Slot names must be unique within the bot that
        /// contains the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_name(input);
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in
        /// lists.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the slot. Use this to help identify the slot in
        /// lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot.
        /// The slot type determines the values that can be entered into the
        /// slot.</p>
        pub fn slot_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(inp);
            self
        }
        /// <p>The unique identifier for the slot type associated with this slot.
        /// The slot type determines the values that can be entered into the
        /// slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response
        /// that provides the value for the slot. </p>
        pub fn value_elicitation_setting(
            mut self,
            inp: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.inner = self.inner.value_elicitation_setting(inp);
            self
        }
        /// <p>Specifies prompts that Amazon Lex sends to the user to elicit a response
        /// that provides the value for the slot. </p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_elicitation_setting(input);
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of
        /// the <code>obfuscationSetting</code> parameter is
        /// <code>DefaultObfuscation</code>, slot values are obfuscated in the
        /// log output. If the value is <code>None</code>, the actual value is
        /// present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn obfuscation_setting(mut self, inp: crate::model::ObfuscationSetting) -> Self {
            self.inner = self.inner.obfuscation_setting(inp);
            self
        }
        /// <p>Determines how slot values are used in Amazon CloudWatch logs. If the value of
        /// the <code>obfuscationSetting</code> parameter is
        /// <code>DefaultObfuscation</code>, slot values are obfuscated in the
        /// log output. If the value is <code>None</code>, the actual value is
        /// present in the log output.</p>
        /// <p>The default is to obfuscate values in the CloudWatch logs.</p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.inner = self.inner.set_obfuscation_setting(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used
        /// in. The string must match one of the supported locales. All of the
        /// bots, intents, slot types used by the slot must have the same locale.
        /// For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be used
        /// in. The string must match one of the supported locales. All of the
        /// bots, intents, slot types used by the slot must have the same locale.
        /// For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response.
        /// Multi-value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn multiple_values_setting(mut self, inp: crate::model::MultipleValuesSetting) -> Self {
            self.inner = self.inner.multiple_values_setting(inp);
            self
        }
        /// <p>Indicates whether the slot returns multiple values in one response.
        /// Multi-value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>. </p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.inner = self.inner.set_multiple_values_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSlotType`.
    ///
    /// <p>Creates a custom slot type</p>
    /// <p> To create a custom slot type, specify a name for the slot type and
    /// a set of enumeration values, the values that a slot of this type can
    /// assume. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_slot_type_input::Builder,
    }
    impl<C, M, R> CreateSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSlotTypeInputOperationOutputAlias,
                crate::output::CreateSlotTypeOutput,
                crate::error::CreateSlotTypeError,
                crate::input::CreateSlotTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the slot. A slot type name must be unique within the
        /// account.</p>
        pub fn slot_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_name(inp);
            self
        }
        /// <p>The name for the slot. A slot type name must be unique within the
        /// account.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_name(input);
            self
        }
        /// <p>A description of the slot type. Use the description to help identify
        /// the slot type in lists.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the slot type. Use the description to help identify
        /// the slot type in lists.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `slotTypeValues`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values
        /// that the slot type can take. Each value can have a list of synonyms,
        /// additional values that help train the machine learning model about the
        /// values that it resolves for a slot.</p>
        pub fn slot_type_values(mut self, inp: impl Into<crate::model::SlotTypeValue>) -> Self {
            self.inner = self.inner.slot_type_values(inp);
            self
        }
        /// <p>A list of <code>SlotTypeValue</code> objects that defines the values
        /// that the slot type can take. Each value can have a list of synonyms,
        /// additional values that help train the machine learning model about the
        /// values that it resolves for a slot.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_values(input);
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the
        /// list of possible values. The field can be set to one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>OriginalValue</code> - Returns the value entered by the
        /// user, if the user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TopResolution</code> - If there is a resolution list for
        /// the slot, return the first value in the resolution list. If there
        /// is no resolution list, return null.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code>
        /// parameter, the default is <code>OriginalValue</code>.</p>
        pub fn value_selection_setting(
            mut self,
            inp: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.inner = self.inner.value_selection_setting(inp);
            self
        }
        /// <p>Determines the strategy that Amazon Lex uses to select a value from the
        /// list of possible values. The field can be set to one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>OriginalValue</code> - Returns the value entered by the
        /// user, if the user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TopResolution</code> - If there is a resolution list for
        /// the slot, return the first value in the resolution list. If there
        /// is no resolution list, return null.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionSetting</code>
        /// parameter, the default is <code>OriginalValue</code>.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_selection_setting(input);
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you
        /// define a parent slot type, the new slot type has the configuration of
        /// the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn parent_slot_type_signature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_slot_type_signature(inp);
            self
        }
        /// <p>The built-in slot type used as a parent of this slot type. When you
        /// define a parent slot type, the new slot type has the configuration of
        /// the parent slot type.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_slot_type_signature(input);
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with this slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the bot version associated with this slot
        /// type.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The identifier of the bot version associated with this slot
        /// type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be
        /// used in. The string must match one of the supported locales. All of the
        /// bots, intents, and slots used by the slot type must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be
        /// used in. The string must match one of the supported locales. All of the
        /// bots, intents, and slots used by the slot type must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUploadUrl`.
    ///
    /// <p>Gets a pre-signed S3 write URL that you use to upload the zip
    /// archive when importing a bot or a bot locale. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUploadUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_upload_url_input::Builder,
    }
    impl<C, M, R> CreateUploadUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUploadUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUploadUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUploadUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUploadUrlInputOperationOutputAlias,
                crate::output::CreateUploadUrlOutput,
                crate::error::CreateUploadUrlError,
                crate::input::CreateUploadUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteBot`.
    ///
    /// <p>Deletes all versions of a bot, including the <code>Draft</code>
    /// version. To delete a specific version, use the
    /// <code>DeleteBotVersion</code> operation.</p>
    /// <p>When you delete a bot, all of the resources contained in the bot are
    /// also deleted. Deleting a bot removes all locales, intents, slot, and
    /// slot types defined for the bot.</p>
    /// <p>If a bot has an alias, the <code>DeleteBot</code> operation returns
    /// a <code>ResourceInUseException</code> exception. If you want to delete
    /// the bot and the alias, set the <code>skipResourceInUseCheck</code>
    /// parameter to <code>true</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_input::Builder,
    }
    impl<C, M, R> DeleteBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotInputOperationOutputAlias,
                crate::output::DeleteBotOutput,
                crate::error::DeleteBotError,
                crate::input::DeleteBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to delete. </p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to delete. </p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another
        /// resource, such as an alias, is using the bot before it is
        /// deleted.</p>
        pub fn skip_resource_in_use_check(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(inp);
            self
        }
        /// <p>When <code>true</code>, Amazon Lex doesn't check to see if another
        /// resource, such as an alias, is using the bot before it is
        /// deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotAlias`.
    ///
    /// <p>Deletes the specified bot alias.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_alias_input::Builder,
    }
    impl<C, M, R> DeleteBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotAliasInputOperationOutputAlias,
                crate::output::DeleteBotAliasOutput,
                crate::error::DeleteBotAliasError,
                crate::input::DeleteBotAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The unique identifier of the bot alias to delete.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to
        /// delete.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot associated with the alias to
        /// delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other
        /// resource is using the alias before it is deleted.</p>
        pub fn skip_resource_in_use_check(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(inp);
            self
        }
        /// <p>When this parameter is true, Amazon Lex doesn't check to see if any other
        /// resource is using the alias before it is deleted.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotLocale`.
    ///
    /// <p>Removes a locale from a bot.</p>
    /// <p>When you delete a locale, all intents, slots, and slot types defined
    /// for the locale are also deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBotLocale<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_locale_input::Builder,
    }
    impl<C, M, R> DeleteBotLocale<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotLocaleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotLocaleInputOperationOutputAlias,
                crate::output::DeleteBotLocaleOutput,
                crate::error::DeleteBotLocaleError,
                crate::input::DeleteBotLocaleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the locale. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The
        /// string must match one of the supported locales. For more information,
        /// see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that will be deleted. The
        /// string must match one of the supported locales. For more information,
        /// see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotVersion`.
    ///
    /// <p>Deletes a specific version of a bot. To delete all version of a bot,
    /// use the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html">DeleteBot</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBotVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_version_input::Builder,
    }
    impl<C, M, R> DeleteBotVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotVersionInputOperationOutputAlias,
                crate::output::DeleteBotVersionOutput,
                crate::error::DeleteBotVersionError,
                crate::input::DeleteBotVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the version.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a
        /// <code>ResourceInUseException</code> exception if you try to delete a
        /// bot version that has an alias pointing at it. Set the
        /// <code>skipResourceInUseCheck</code> parameter to <code>true</code>
        /// to skip this check and remove the version even if an alias points to
        /// it.</p>
        pub fn skip_resource_in_use_check(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(inp);
            self
        }
        /// <p>By default, the <code>DeleteBotVersion</code> operations throws a
        /// <code>ResourceInUseException</code> exception if you try to delete a
        /// bot version that has an alias pointing at it. Set the
        /// <code>skipResourceInUseCheck</code> parameter to <code>true</code>
        /// to skip this check and remove the version even if an alias points to
        /// it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteExport`.
    ///
    /// <p>Removes a previous export and the associated files stored in an S3
    /// bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_export_input::Builder,
    }
    impl<C, M, R> DeleteExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteExportInputOperationOutputAlias,
                crate::output::DeleteExportOutput,
                crate::error::DeleteExportError,
                crate::input::DeleteExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the export to delete.</p>
        pub fn export_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(inp);
            self
        }
        /// <p>The unique identifier of the export to delete.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImport`.
    ///
    /// <p>Removes a previous import and the associated file stored in an S3
    /// bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_import_input::Builder,
    }
    impl<C, M, R> DeleteImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImportInputOperationOutputAlias,
                crate::output::DeleteImportOutput,
                crate::error::DeleteImportError,
                crate::input::DeleteImportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the import to delete.</p>
        pub fn import_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(inp);
            self
        }
        /// <p>The unique identifier of the import to delete.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntent`.
    ///
    /// <p>Removes the specified intent.</p>
    /// <p>Deleting an intent also deletes the slots associated with the
    /// intent.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_intent_input::Builder,
    }
    impl<C, M, R> DeleteIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntentInputOperationOutputAlias,
                crate::output::DeleteIntentOutput,
                crate::error::DeleteIntentError,
                crate::input::DeleteIntentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The unique identifier of the intent to delete.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where the bot will be
        /// deleted. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale where the bot will be
        /// deleted. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Removes an existing policy from a bot or bot alias. If the resource
    /// doesn't have a policy attached, Amazon Lex returns an exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the
        /// resource policy attached.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that has the
        /// resource policy attached.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the
        /// current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current
        /// policy.</p>
        pub fn expected_revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(inp);
            self
        }
        /// <p>The identifier of the revision to edit. If this ID doesn't match the
        /// current revision number, Amazon Lex returns an exception</p>
        /// <p>If you don't specify a revision ID, Amazon Lex will delete the current
        /// policy.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicyStatement`.
    ///
    /// <p>Deletes a policy statement from a resource policy. If you delete the
    /// last statement from a policy, the policy is deleted. If you specify a
    /// statement ID that doesn't exist in the policy, or if the bot or bot
    /// alias doesn't have a policy attached, Amazon Lex returns an
    /// exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicyStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_statement_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicyStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicyStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyStatementInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyStatementOutput,
                crate::error::DeleteResourcePolicyStatementError,
                crate::input::DeleteResourcePolicyStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>The name of the statement (SID) to delete from the policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement
        /// from. If this revision ID doesn't match the current revision ID, Amazon Lex
        /// throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents
        /// of the statement. </p>
        pub fn expected_revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(inp);
            self
        }
        /// <p>The identifier of the revision of the policy to delete the statement
        /// from. If this revision ID doesn't match the current revision ID, Amazon Lex
        /// throws an exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex removes the current contents
        /// of the statement. </p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlot`.
    ///
    /// <p>Deletes the specified slot from an intent.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSlot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_slot_input::Builder,
    }
    impl<C, M, R> DeleteSlot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSlotInputOperationOutputAlias,
                crate::output::DeleteSlotOutput,
                crate::error::DeleteSlotError,
                crate::input::DeleteSlotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot to delete. </p>
        pub fn slot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(inp);
            self
        }
        /// <p>The identifier of the slot to delete. </p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the slot to delete.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the slot to delete.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be
        /// deleted from. The string must match one of the supported locales. For
        /// more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the slot will be
        /// deleted from. The string must match one of the supported locales. For
        /// more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The identifier of the intent associated with the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlotType`.
    ///
    /// <p>Deletes a slot type from a bot locale.</p>
    /// <p>If a slot is using the slot type, Amazon Lex throws a
    /// <code>ResourceInUseException</code> exception. To avoid the
    /// exception, set the <code>skipResourceInUseCheck</code> parameter to
    /// <code>true</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_slot_type_input::Builder,
    }
    impl<C, M, R> DeleteSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSlotTypeInputOperationOutputAlias,
                crate::output::DeleteSlotTypeOutput,
                crate::error::DeleteSlotTypeError,
                crate::input::DeleteSlotTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot type to delete.</p>
        pub fn slot_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(inp);
            self
        }
        /// <p>The identifier of the slot type to delete.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be
        /// deleted from. The string must match one of the supported locales. For
        /// more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that the slot type will be
        /// deleted from. The string must match one of the supported locales. For
        /// more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a
        /// <code>ResourceInUseException</code> exception if you try to delete a
        /// slot type used by a slot. Set the <code>skipResourceInUseCheck</code>
        /// parameter to <code>true</code> to skip this check and remove the slot
        /// type even if a slot uses it.</p>
        pub fn skip_resource_in_use_check(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_resource_in_use_check(inp);
            self
        }
        /// <p>By default, the <code>DeleteSlotType</code> operations throws a
        /// <code>ResourceInUseException</code> exception if you try to delete a
        /// slot type used by a slot. Set the <code>skipResourceInUseCheck</code>
        /// parameter to <code>true</code> to skip this check and remove the slot
        /// type even if a slot uses it.</p>
        pub fn set_skip_resource_in_use_check(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_resource_in_use_check(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUtterances`.
    ///
    /// <p>Deletes stored utterances.</p>
    /// <p>Amazon Lex stores the utterances that users send to your bot. Utterances
    /// are stored for 15 days for use with the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html">ListAggregatedUtterances</a> operation, and
    /// then stored indefinitely for use in improving the ability of your bot
    /// to respond to user input..</p>
    /// <p>Use the <code>DeleteUtterances</code> operation to manually delete
    /// utterances for a specific session. When you use the
    /// <code>DeleteUtterances</code> operation, utterances stored for
    /// improving your bot's ability to respond to user input are deleted
    /// immediately. Utterances stored for use with the
    /// <code>ListAggregatedUtterances</code> operation are deleted after 15
    /// days.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUtterances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_utterances_input::Builder,
    }
    impl<C, M, R> DeleteUtterances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUtterances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUtterancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUtterancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUtterancesInputOperationOutputAlias,
                crate::output::DeleteUtterancesOutput,
                crate::error::DeleteUtterancesError,
                crate::input::DeleteUtterancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the
        /// utterances.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the
        /// utterances.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were
        /// collected. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were
        /// collected. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is
        /// returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The unique identifier of the session with the user. The ID is
        /// returned in the response from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html">RecognizeText</a> and <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html">RecognizeUtterance</a> operations.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBot`.
    ///
    /// <p>Provides metadata information about a bot. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bot_input::Builder,
    }
    impl<C, M, R> DescribeBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBotInputOperationOutputAlias,
                crate::output::DescribeBotOutput,
                crate::error::DescribeBotError,
                crate::input::DescribeBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot to describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotAlias`.
    ///
    /// <p>Get information about a specific bot alias.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bot_alias_input::Builder,
    }
    impl<C, M, R> DescribeBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBotAliasInputOperationOutputAlias,
                crate::output::DescribeBotAliasOutput,
                crate::error::DescribeBotAliasError,
                crate::input::DescribeBotAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The identifier of the bot alias to describe.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to
        /// describe.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the bot alias to
        /// describe.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotLocale`.
    ///
    /// <p>Describes the settings that a bot has for a specific locale. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBotLocale<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bot_locale_input::Builder,
    }
    impl<C, M, R> DescribeBotLocale<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotLocaleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBotLocaleInputOperationOutputAlias,
                crate::output::DescribeBotLocaleOutput,
                crate::error::DescribeBotLocaleError,
                crate::input::DescribeBotLocaleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the version of the bot associated with the
        /// locale.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The identifier of the version of the bot associated with the
        /// locale.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must
        /// match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The unique identifier of the locale to describe. The string must
        /// match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>. </p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBotVersion`.
    ///
    /// <p>Provides metadata about a version of a bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBotVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_bot_version_input::Builder,
    }
    impl<C, M, R> DescribeBotVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBotVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBotVersionInputOperationOutputAlias,
                crate::output::DescribeBotVersionOutput,
                crate::error::DescribeBotVersionError,
                crate::input::DescribeBotVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot containing the version to return metadata
        /// for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot containing the version to return metadata
        /// for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to return metadata for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExport`.
    ///
    /// <p>Gets information about a specific export.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_export_input::Builder,
    }
    impl<C, M, R> DescribeExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExportInputOperationOutputAlias,
                crate::output::DescribeExportOutput,
                crate::error::DescribeExportError,
                crate::input::DescribeExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the export to describe.</p>
        pub fn export_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(inp);
            self
        }
        /// <p>The unique identifier of the export to describe.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImport`.
    ///
    /// <p>Gets information about a specific import.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_import_input::Builder,
    }
    impl<C, M, R> DescribeImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImportOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImportInputOperationOutputAlias,
                crate::output::DescribeImportOutput,
                crate::error::DescribeImportError,
                crate::input::DescribeImportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the import to describe.</p>
        pub fn import_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(inp);
            self
        }
        /// <p>The unique identifier of the import to describe.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeIntent`.
    ///
    /// <p>Returns metadata about an intent.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_intent_input::Builder,
    }
    impl<C, M, R> DescribeIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeIntentInputOperationOutputAlias,
                crate::output::DescribeIntentOutput,
                crate::error::DescribeIntentError,
                crate::input::DescribeIntentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the intent to describe.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The identifier of the intent to describe.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the intent to describe.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicy`.
    ///
    /// <p>Gets the resource policy and policy revision for a bot or bot
    /// alias.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_policy_input::Builder,
    }
    impl<C, M, R> DescribeResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourcePolicyInputOperationOutputAlias,
                crate::output::DescribeResourcePolicyOutput,
                crate::error::DescribeResourcePolicyError,
                crate::input::DescribeResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSlot`.
    ///
    /// <p>Gets metadata information about a slot.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSlot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_slot_input::Builder,
    }
    impl<C, M, R> DescribeSlot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSlotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSlotInputOperationOutputAlias,
                crate::output::DescribeSlotOutput,
                crate::error::DescribeSlotError,
                crate::input::DescribeSlotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the slot.</p>
        pub fn slot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(inp);
            self
        }
        /// <p>The unique identifier for the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the slot to describe.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSlotType`.
    ///
    /// <p>Gets metadata information about a slot type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_slot_type_input::Builder,
    }
    impl<C, M, R> DescribeSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSlotTypeInputOperationOutputAlias,
                crate::output::DescribeSlotTypeOutput,
                crate::error::DescribeSlotTypeError,
                crate::input::DescribeSlotTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the slot type.</p>
        pub fn slot_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(inp);
            self
        }
        /// <p>The identifier of the slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot associated with the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot associated with the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot type to
        /// describe. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the slot type to
        /// describe. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAggregatedUtterances`.
    ///
    /// <p>Provides a list of utterances that users have sent to the
    /// bot.</p>
    /// <p>Utterances are aggregated by the text of the utterance. For example,
    /// all instances where customers used the phrase "I want to order pizza"
    /// are aggregated into the same line in the response.</p>
    /// <p>You can see both detected utterances and missed utterances. A
    /// detected utterance is where the bot properly recognized the utterance
    /// and activated the associated intent. A missed utterance was not
    /// recognized by the bot and didn't activate an intent.</p>
    /// <p>Utterances can be aggregated for a bot alias or for a bot version,
    /// but not both at the same time.</p>
    /// <p>Utterances statistics are not generated under the following
    /// conditions:</p>
    /// <ul>
    /// <li>
    /// <p>The <code>childDirected</code> field was set to true when the
    /// bot was created.</p>
    /// </li>
    /// <li>
    /// <p>You are using slot obfuscation with one or more slots.</p>
    /// </li>
    /// <li>
    /// <p>You opted out of participating in improving Amazon Lex.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ListAggregatedUtterances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aggregated_utterances_input::Builder,
    }
    impl<C, M, R> ListAggregatedUtterances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAggregatedUtterances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAggregatedUtterancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAggregatedUtterancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAggregatedUtterancesInputOperationOutputAlias,
                crate::output::ListAggregatedUtterancesOutput,
                crate::error::ListAggregatedUtterancesError,
                crate::input::ListAggregatedUtterancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot associated with this
        /// request.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot associated with this
        /// request.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you
        /// specify the bot alias, you can't specify the bot version.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The identifier of the bot alias associated with this request. If you
        /// specify the bot alias, you can't specify the bot version.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The identifier of the bot version associated with this request. If
        /// you specify the bot version, you can't specify the bot alias.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The identifier of the bot version associated with this request. If
        /// you specify the bot version, you can't specify the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were
        /// collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale where the utterances were
        /// collected. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The time window for aggregating the utterance information. You can
        /// specify a time between one hour and two weeks.</p>
        pub fn aggregation_duration(
            mut self,
            inp: crate::model::UtteranceAggregationDuration,
        ) -> Self {
            self.inner = self.inner.aggregation_duration(inp);
            self
        }
        /// <p>The time window for aggregating the utterance information. You can
        /// specify a time between one hour and two weeks.</p>
        pub fn set_aggregation_duration(
            mut self,
            input: std::option::Option<crate::model::UtteranceAggregationDuration>,
        ) -> Self {
            self.inner = self.inner.set_aggregation_duration(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can
        /// sort by the hit count, the missed count, or the number of distinct
        /// sessions the utterance appeared in.</p>
        pub fn sort_by(mut self, inp: crate::model::AggregatedUtterancesSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies sorting parameters for the list of utterances. You can
        /// sort by the hit count, the missed count, or the number of distinct
        /// sessions the utterance appeared in.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the utterances
        /// in the response to only those that match the filter specification. You
        /// can only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::AggregatedUtterancesFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the utterances
        /// in the response to only those that match the filter specification. You
        /// can only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AggregatedUtterancesFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of utterances to return in each page of results.
        /// If there are fewer results than the maximum page size, only the actual
        /// number of results are returned. If you don't specify the
        /// <code>maxResults</code> parameter, 1,000 results are
        /// returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of utterances to return in each page of results.
        /// If there are fewer results than the maximum page size, only the actual
        /// number of results are returned. If you don't specify the
        /// <code>maxResults</code> parameter, 1,000 results are
        /// returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code>
        /// operation contains more results that specified in the
        /// <code>maxResults</code> parameter, a token is returned in the
        /// response. Use that token in the <code>nextToken</code> parameter to
        /// return the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListAggregatedUtterances</code>
        /// operation contains more results that specified in the
        /// <code>maxResults</code> parameter, a token is returned in the
        /// response. Use that token in the <code>nextToken</code> parameter to
        /// return the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotAliases`.
    ///
    /// <p>Gets a list of aliases for the specified bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBotAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bot_aliases_input::Builder,
    }
    impl<C, M, R> ListBotAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBotAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotAliasesInputOperationOutputAlias,
                crate::output::ListBotAliasesOutput,
                crate::error::ListBotAliasesError,
                crate::input::ListBotAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to list aliases for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListBotAliases</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotLocales`.
    ///
    /// <p>Gets a list of locales for the specified bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBotLocales<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bot_locales_input::Builder,
    }
    impl<C, M, R> ListBotLocales<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBotLocales`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotLocalesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotLocalesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotLocalesInputOperationOutputAlias,
                crate::output::ListBotLocalesOutput,
                crate::error::ListBotLocalesError,
                crate::input::ListBotLocalesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to list locales for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to list locales for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort
        /// by locale name in ascending or descending order.</p>
        pub fn sort_by(mut self, inp: crate::model::BotLocaleSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies sorting parameters for the list of locales. You can sort
        /// by locale name in ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotLocaleSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification for a filter used to limit the response
        /// to only those locales that match the filter specification. You can only
        /// specify one filter and one value to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::BotLocaleFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification for a filter used to limit the response
        /// to only those locales that match the filter specification. You can only
        /// specify one filter and one value to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotLocaleFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of aliases to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token as the
        /// <code>nextToken</code> parameter to return the next page of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListBotLocales</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token as the
        /// <code>nextToken</code> parameter to return the next page of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>Gets a list of available bots.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl<C, M, R> ListBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotsInputOperationOutputAlias,
                crate::output::ListBotsOutput,
                crate::error::ListBotsError,
                crate::input::ListBotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies sorting parameters for the list of bots. You can specify
        /// that the list be sorted by bot name in ascending or descending
        /// order.</p>
        pub fn sort_by(mut self, inp: crate::model::BotSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies sorting parameters for the list of bots. You can specify
        /// that the list be sorted by bot name in ascending or descending
        /// order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::BotSortBy>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the
        /// response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::BotFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the
        /// response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If
        /// there are fewer results than the maximum page size, only the actual
        /// number of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of bots to return in each page of results. If
        /// there are fewer results than the maximum page size, only the actual
        /// number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListBots</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBotVersions`.
    ///
    /// <p>Gets information about all of the versions of a bot.</p>
    /// <p>The <code>ListBotVersions</code> operation returns a summary of each
    /// version of a bot. For example, if a bot has three numbered versions,
    /// the <code>ListBotVersions</code> operation returns for summaries, one
    /// for each numbered version and one for the <code>DRAFT</code>
    /// version.</p>
    /// <p>The <code>ListBotVersions</code> operation always returns at least
    /// one version, the <code>DRAFT</code> version.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBotVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bot_versions_input::Builder,
    }
    impl<C, M, R> ListBotVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBotVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotVersionsInputOperationOutputAlias,
                crate::output::ListBotVersionsOutput,
                crate::error::ListBotVersionsError,
                crate::input::ListBotVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot to list versions for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can
        /// specify that the list be sorted by version name in either ascending or
        /// descending order.</p>
        pub fn sort_by(mut self, inp: crate::model::BotVersionSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies sorting parameters for the list of versions. You can
        /// specify that the list be sorted by version name in either ascending or
        /// descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BotVersionSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of versions to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response to the <code>ListBotVersion</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuiltInIntents`.
    ///
    /// <p>Gets a list of built-in intents provided by Amazon Lex that you can use
    /// in your bot. </p>
    /// <p>To use a built-in intent as a the base for your own intent, include
    /// the built-in intent signature in the <code>parentIntentSignature</code>
    /// parameter when you call the <code>CreateIntent</code> operation. For
    /// more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html">CreateIntent</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuiltInIntents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_built_in_intents_input::Builder,
    }
    impl<C, M, R> ListBuiltInIntents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuiltInIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuiltInIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuiltInIntentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuiltInIntentsInputOperationOutputAlias,
                crate::output::ListBuiltInIntentsOutput,
                crate::error::ListBuiltInIntentsError,
                crate::input::ListBuiltInIntentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the language and locale of the intents to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the intents to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You
        /// can specify that the list be sorted by the built-in intent signature in
        /// either ascending or descending order.</p>
        pub fn sort_by(mut self, inp: crate::model::BuiltInIntentSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies sorting parameters for the list of built-in intents. You
        /// can specify that the list be sorted by the built-in intent signature in
        /// either ascending or descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInIntentSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of
        /// results. If there are fewer results than the max page size, only the
        /// actual number of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of built-in intents to return in each page of
        /// results. If there are fewer results than the max page size, only the
        /// actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListBuiltInIntents</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuiltInSlotTypes`.
    ///
    /// <p>Gets a list of built-in slot types that meet the specified
    /// criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuiltInSlotTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_built_in_slot_types_input::Builder,
    }
    impl<C, M, R> ListBuiltInSlotTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuiltInSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuiltInSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuiltInSlotTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuiltInSlotTypesInputOperationOutputAlias,
                crate::output::ListBuiltInSlotTypesOutput,
                crate::error::ListBuiltInSlotTypesError,
                crate::input::ListBuiltInSlotTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the language and locale of the slot types to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListBuiltInSlotTypes</code> operation. You can choose to sort
        /// by the slot type signature in either ascending or descending
        /// order.</p>
        pub fn sort_by(mut self, inp: crate::model::BuiltInSlotTypeSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListBuiltInSlotTypes</code> operation. You can choose to sort
        /// by the slot type signature in either ascending or descending
        /// order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::BuiltInSlotTypeSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of
        /// results. If there are fewer results than the max page size, only the
        /// actual number of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of built-in slot types to return in each page of
        /// results. If there are fewer results than the max page size, only the
        /// actual number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListBuiltInSlotTypes</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExports`.
    ///
    /// <p>Lists the exports for a bot or bot locale. Exports are kept in the
    /// list for 7 days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListExports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_exports_input::Builder,
    }
    impl<C, M, R> ListExports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExportsInputOperationOutputAlias,
                crate::output::ListExportsOutput,
                crate::error::ListExportsError,
                crate::input::ListExportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to list exports for. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can
        /// sort by the <code>LastUpdatedDateTime</code> field in ascending or
        /// descending order.</p>
        pub fn sort_by(mut self, inp: crate::model::ExportSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the field that the list of exports is sorted by. You can
        /// sort by the <code>LastUpdatedDateTime</code> field in ascending or
        /// descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ExportSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the exports in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ExportFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the exports in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of exports to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains
        /// more results that specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListExports</code> operation contains
        /// more results that specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImports`.
    ///
    /// <p>Lists the imports for a bot or bot locale. Imports are kept in the
    /// list for 7 days.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_imports_input::Builder,
    }
    impl<C, M, R> ListImports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImportsInputOperationOutputAlias,
                crate::output::ListImportsOutput,
                crate::error::ListImportsError,
                crate::input::ListImportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the bot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot to list imports for.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can
        /// sort by the <code>LastUpdatedDateTime</code> field in ascending or
        /// descending order.</p>
        pub fn sort_by(mut self, inp: crate::model::ImportSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the field that the list of imports is sorted by. You can
        /// sort by the <code>LastUpdatedDateTime</code> field in ascending or
        /// descending order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ImportSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the bots in the
        /// response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::ImportFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the bots in the
        /// response to only those that match the filter specification. You can
        /// only specify one filter and one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of imports to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListImports</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntents`.
    ///
    /// <p>Get a list of intents that meet the specified criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIntents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_intents_input::Builder,
    }
    impl<C, M, R> ListIntents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIntentsInputOperationOutputAlias,
                crate::output::ListIntentsOutput,
                crate::error::ListIntentsError,
                crate::input::ListIntentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the intent.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the intents to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the intents to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListIntents</code> operation. You can choose to sort by the
        /// intent name or last updated date in either ascending or descending
        /// order.</p>
        pub fn sort_by(mut self, inp: crate::model::IntentSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListIntents</code> operation. You can choose to sort by the
        /// intent name or last updated date in either ascending or descending
        /// order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::IntentSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the intents in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::IntentFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the intents in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of intents to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListIntents</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSlots`.
    ///
    /// <p>Gets a list of slots that match the specified criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSlots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_slots_input::Builder,
    }
    impl<C, M, R> ListSlots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSlots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSlotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSlotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSlotsInputOperationOutputAlias,
                crate::output::ListSlotsOutput,
                crate::error::ListSlotsError,
                crate::input::ListSlotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the slot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The
        /// string must match one of the supported locales. For more information,
        /// see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the slots to list. The
        /// string must match one of the supported locales. For more information,
        /// see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The unique identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListSlots</code> operation. You can choose to sort by the slot
        /// name or last updated date in either ascending or descending
        /// order.</p>
        pub fn sort_by(mut self, inp: crate::model::SlotSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListSlots</code> operation. You can choose to sort by the slot
        /// name or last updated date in either ascending or descending
        /// order.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SlotSortBy>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slots in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SlotFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slots in
        /// the response to only those that match the filter specification. You can
        /// only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of slots to return in each page of results. If
        /// there are fewer results than the max page size, only the actual number
        /// of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListSlots</code> operation contains
        /// more results than specified in the <code>maxResults</code> parameter, a
        /// token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSlotTypes`.
    ///
    /// <p>Gets a list of slot types that match the specified criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSlotTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_slot_types_input::Builder,
    }
    impl<C, M, R> ListSlotTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSlotTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSlotTypesInputOperationOutputAlias,
                crate::output::ListSlotTypesOutput,
                crate::error::ListSlotTypesError,
                crate::input::ListSlotTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the slot
        /// types.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the slot
        /// types.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the slot type.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale of the slot types to list.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListSlotTypes</code> operation. You can choose to sort by the
        /// slot type name or last updated date in either ascending or descending
        /// order.</p>
        pub fn sort_by(mut self, inp: crate::model::SlotTypeSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Determines the sort order for the response from the
        /// <code>ListSlotTypes</code> operation. You can choose to sort by the
        /// slot type name or last updated date in either ascending or descending
        /// order.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SlotTypeSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Provides the specification of a filter used to limit the slot types
        /// in the response to only those that match the filter specification. You
        /// can only specify one filter and only one string to filter on.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::SlotTypeFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Provides the specification of a filter used to limit the slot types
        /// in the response to only those that match the filter specification. You
        /// can only specify one filter and only one string to filter on.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of slot types to return in each page of results.
        /// If there are fewer results than the max page size, only the actual
        /// number of results are returned.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of slot types to return in each page of results.
        /// If there are fewer results than the max page size, only the actual
        /// number of results are returned.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the response from the <code>ListSlotTypes</code> operation
        /// contains more results than specified in the <code>maxResults</code>
        /// parameter, a token is returned in the response. Use that token in the
        /// <code>nextToken</code> parameter to return the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of tags associated with a resource. Only bots, bot
    /// aliases, and bot channels can have tags associated with them.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
        /// for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
        /// for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImport`.
    ///
    /// <p>Starts importing a bot or bot locale from a zip archive that you
    /// uploaded to an S3 bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartImport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_import_input::Builder,
    }
    impl<C, M, R> StartImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImportInputOperationOutputAlias,
                crate::output::StartImportOutput,
                crate::error::StartImportError,
                crate::input::StartImportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the import. It is included in the response
        /// from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn import_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(inp);
            self
        }
        /// <p>The unique identifier for the import. It is included in the response
        /// from the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html">CreateUploadUrl</a> operation.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
        /// <p>Parameters for creating the bot or bot locale.</p>
        pub fn resource_specification(
            mut self,
            inp: crate::model::ImportResourceSpecification,
        ) -> Self {
            self.inner = self.inner.resource_specification(inp);
            self
        }
        /// <p>Parameters for creating the bot or bot locale.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ImportResourceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_resource_specification(input);
            self
        }
        /// <p>The strategy to use when there is a name conflict between the
        /// imported resource and an existing resource. When the merge strategy is
        /// <code>FailOnConflict</code> existing resources are not overwritten
        /// and the import fails.</p>
        pub fn merge_strategy(mut self, inp: crate::model::MergeStrategy) -> Self {
            self.inner = self.inner.merge_strategy(inp);
            self
        }
        /// <p>The strategy to use when there is a name conflict between the
        /// imported resource and an existing resource. When the merge strategy is
        /// <code>FailOnConflict</code> existing resources are not overwritten
        /// and the import fails.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.inner = self.inner.set_merge_strategy(input);
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the bot
        /// or bot locale definition. You should always encrypt the zip archive to
        /// protect it during transit between your site and Amazon Lex.</p>
        pub fn file_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(inp);
            self
        }
        /// <p>The password used to encrypt the zip archive that contains the bot
        /// or bot locale definition. You should always encrypt the zip archive to
        /// protect it during transit between your site and Amazon Lex.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource. If a tag key
    /// already exists, the existing value is replaced with the new
    /// value.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
        /// to tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
        /// to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the resource. If a tag key already
        /// exists, the existing value is replaced with the new value.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tag keys to add to the resource. If a tag key already
        /// exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a bot, bot alias, or bot channel.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
        /// from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
        /// from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource. If a tag key does
        /// not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys to remove from the resource. If a tag key does
        /// not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBot`.
    ///
    /// <p>Updates the configuration of an existing bot. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bot_input::Builder,
    }
    impl<C, M, R> UpdateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBotInputOperationOutputAlias,
                crate::output::UpdateBotOutput,
                crate::error::UpdateBotError,
                crate::input::UpdateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot to update. This identifier is
        /// returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot to update. This identifier is
        /// returned by the <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html">CreateBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that
        /// creates the bot.</p>
        pub fn bot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(inp);
            self
        }
        /// <p>The new name of the bot. The name must be unique in the account that
        /// creates the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions
        /// to access the bot.</p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permissions
        /// to access the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should
        /// use with the bot's data.</p>
        pub fn data_privacy(mut self, inp: crate::model::DataPrivacy) -> Self {
            self.inner = self.inner.data_privacy(inp);
            self
        }
        /// <p>Provides information on additional privacy protections Amazon Lex should
        /// use with the bot's data.</p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.inner = self.inner.set_data_privacy(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.idle_session_ttl_in_seconds(inp);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot.</p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_session_ttl_in_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBotAlias`.
    ///
    /// <p>Updates the configuration of an existing bot alias.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bot_alias_input::Builder,
    }
    impl<C, M, R> UpdateBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBotAliasInputOperationOutputAlias,
                crate::output::UpdateBotAliasOutput,
                crate::error::UpdateBotAliasError,
                crate::input::UpdateBotAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn bot_alias_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_id(inp);
            self
        }
        /// <p>The unique identifier of the bot alias.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias_id(input);
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn bot_alias_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias_name(inp);
            self
        }
        /// <p>The new name to assign to the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_name(input);
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description to assign to the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The new bot version to assign to the bot alias.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// Adds a key-value pair to `botAliasLocaleSettings`.
        ///
        /// To override the contents of this collection use [`set_bot_alias_locale_settings`](Self::set_bot_alias_locale_settings).
        ///
        /// <p>The new Lambda functions to use in each locale for the bot
        /// alias.</p>
        pub fn bot_alias_locale_settings(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::BotAliasLocaleSettings>,
        ) -> Self {
            self.inner = self.inner.bot_alias_locale_settings(k, v);
            self
        }
        /// <p>The new Lambda functions to use in each locale for the bot
        /// alias.</p>
        pub fn set_bot_alias_locale_settings(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BotAliasLocaleSettings,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_bot_alias_locale_settings(input);
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and
        /// Amazon S3 buckets.</p>
        pub fn conversation_log_settings(
            mut self,
            inp: crate::model::ConversationLogSettings,
        ) -> Self {
            self.inner = self.inner.conversation_log_settings(inp);
            self
        }
        /// <p>The new settings for storing conversation logs in Amazon CloudWatch Logs and
        /// Amazon S3 buckets.</p>
        pub fn set_conversation_log_settings(
            mut self,
            input: std::option::Option<crate::model::ConversationLogSettings>,
        ) -> Self {
            self.inner = self.inner.set_conversation_log_settings(input);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of
        /// user utterances.</p>
        pub fn sentiment_analysis_settings(
            mut self,
            inp: crate::model::SentimentAnalysisSettings,
        ) -> Self {
            self.inner = self.inner.sentiment_analysis_settings(inp);
            self
        }
        /// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of
        /// user utterances.</p>
        pub fn set_sentiment_analysis_settings(
            mut self,
            input: std::option::Option<crate::model::SentimentAnalysisSettings>,
        ) -> Self {
            self.inner = self.inner.set_sentiment_analysis_settings(input);
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot with the updated alias.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBotLocale`.
    ///
    /// <p>Updates the settings that a bot has for a specific locale.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBotLocale<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bot_locale_input::Builder,
    }
    impl<C, M, R> UpdateBotLocale<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBotLocale`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBotLocaleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBotLocaleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBotLocaleInputOperationOutputAlias,
                crate::output::UpdateBotLocaleOutput,
                crate::error::UpdateBotLocaleError,
                crate::input::UpdateBotLocaleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the locale.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The
        /// version can only be the <code>DRAFT</code> version.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the locale to be updated. The
        /// version can only be the <code>DRAFT</code> version.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale to update. The string must
        /// match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale to update. The string must
        /// match one of the supported locales. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description of the locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> intents in the list of
        /// possible intents for an utterance.</p>
        pub fn nlu_intent_confidence_threshold(mut self, inp: f64) -> Self {
            self.inner = self.inner.nlu_intent_confidence_threshold(inp);
            self
        }
        /// <p>The new confidence threshold where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> intents in the list of
        /// possible intents for an utterance.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the
        /// user.</p>
        pub fn voice_settings(mut self, inp: crate::model::VoiceSettings) -> Self {
            self.inner = self.inner.voice_settings(inp);
            self
        }
        /// <p>The new Amazon Polly voice Amazon Lex should use for voice interaction with the
        /// user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.inner = self.inner.set_voice_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateExport`.
    ///
    /// <p>Updates the password used to protect an export zip archive.</p>
    /// <p>The password is not required. If you don't supply a password, Amazon Lex
    /// generates a zip file that is not protected by a password. This is the
    /// archive that is available at the pre-signed S3 URL provided by the
    /// <a href="https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html">DescribeExport</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateExport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_export_input::Builder,
    }
    impl<C, M, R> UpdateExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateExportOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateExportInputOperationOutputAlias,
                crate::output::UpdateExportOutput,
                crate::error::UpdateExportError,
                crate::input::UpdateExportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn export_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_id(inp);
            self
        }
        /// <p>The unique identifier Amazon Lex assigned to the export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_export_id(input);
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn file_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_password(inp);
            self
        }
        /// <p>The new password to use to encrypt the export zip archive.</p>
        pub fn set_file_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_file_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIntent`.
    ///
    /// <p>Updates the settings for an intent.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_intent_input::Builder,
    }
    impl<C, M, R> UpdateIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIntentInputOperationOutputAlias,
                crate::output::UpdateIntentOutput,
                crate::error::UpdateIntentError,
                crate::input::UpdateIntentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the intent to update.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The unique identifier of the intent to update.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn intent_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_name(inp);
            self
        }
        /// <p>The new name for the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_name(input);
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of
        /// this intent.</p>
        pub fn parent_intent_signature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_intent_signature(inp);
            self
        }
        /// <p>The signature of the new built-in intent to use as the parent of
        /// this intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_intent_signature(input);
            self
        }
        /// Appends an item to `sampleUtterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>New utterances used to invoke the intent.</p>
        pub fn sample_utterances(mut self, inp: impl Into<crate::model::SampleUtterance>) -> Self {
            self.inner = self.inner.sample_utterances(inp);
            self
        }
        /// <p>New utterances used to invoke the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.inner = self.inner.set_sample_utterances(input);
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation
        /// with the bot.</p>
        pub fn dialog_code_hook(mut self, inp: crate::model::DialogCodeHookSettings) -> Self {
            self.inner = self.inner.dialog_code_hook(inp);
            self
        }
        /// <p>The new Lambda function to use between each turn of the conversation
        /// with the bot.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::DialogCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_dialog_code_hook(input);
            self
        }
        /// <p>The new Lambda function to call when all of the intents required
        /// slots are provided and the intent is ready for fulfillment.</p>
        pub fn fulfillment_code_hook(
            mut self,
            inp: crate::model::FulfillmentCodeHookSettings,
        ) -> Self {
            self.inner = self.inner.fulfillment_code_hook(inp);
            self
        }
        /// <p>The new Lambda function to call when all of the intents required
        /// slots are provided and the intent is ready for fulfillment.</p>
        pub fn set_fulfillment_code_hook(
            mut self,
            input: std::option::Option<crate::model::FulfillmentCodeHookSettings>,
        ) -> Self {
            self.inner = self.inner.set_fulfillment_code_hook(input);
            self
        }
        /// Appends an item to `slotPriorities`.
        ///
        /// To override the contents of this collection use [`set_slot_priorities`](Self::set_slot_priorities).
        ///
        /// <p>A new list of slots and their priorities that are contained by the
        /// intent.</p>
        pub fn slot_priorities(mut self, inp: impl Into<crate::model::SlotPriority>) -> Self {
            self.inner = self.inner.slot_priorities(inp);
            self
        }
        /// <p>A new list of slots and their priorities that are contained by the
        /// intent.</p>
        pub fn set_slot_priorities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotPriority>>,
        ) -> Self {
            self.inner = self.inner.set_slot_priorities(input);
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion
        /// of an intent.</p>
        pub fn intent_confirmation_setting(
            mut self,
            inp: crate::model::IntentConfirmationSetting,
        ) -> Self {
            self.inner = self.inner.intent_confirmation_setting(inp);
            self
        }
        /// <p>New prompts that Amazon Lex sends to the user to confirm the completion
        /// of an intent.</p>
        pub fn set_intent_confirmation_setting(
            mut self,
            input: std::option::Option<crate::model::IntentConfirmationSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_confirmation_setting(input);
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is
        /// closed.</p>
        pub fn intent_closing_setting(mut self, inp: crate::model::IntentClosingSetting) -> Self {
            self.inner = self.inner.intent_closing_setting(inp);
            self
        }
        /// <p>The new response that Amazon Lex sends the user when the intent is
        /// closed.</p>
        pub fn set_intent_closing_setting(
            mut self,
            input: std::option::Option<crate::model::IntentClosingSetting>,
        ) -> Self {
            self.inner = self.inner.set_intent_closing_setting(input);
            self
        }
        /// Appends an item to `inputContexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>A new list of contexts that must be active in order for Amazon Lex to
        /// consider the intent.</p>
        pub fn input_contexts(mut self, inp: impl Into<crate::model::InputContext>) -> Self {
            self.inner = self.inner.input_contexts(inp);
            self
        }
        /// <p>A new list of contexts that must be active in order for Amazon Lex to
        /// consider the intent.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.inner = self.inner.set_input_contexts(input);
            self
        }
        /// Appends an item to `outputContexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>A new list of contexts that Amazon Lex activates when the intent is
        /// fulfilled.</p>
        pub fn output_contexts(mut self, inp: impl Into<crate::model::OutputContext>) -> Self {
            self.inner = self.inner.output_contexts(inp);
            self
        }
        /// <p>A new list of contexts that Amazon Lex activates when the intent is
        /// fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.inner = self.inner.set_output_contexts(input);
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn kendra_configuration(mut self, inp: crate::model::KendraConfiguration) -> Self {
            self.inner = self.inner.kendra_configuration(inp);
            self
        }
        /// <p>New configuration settings for connecting to an Amazon Kendra index.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kendra_configuration(input);
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the intent.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the intent. Must be
        /// <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the intent. Must be
        /// <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale where this intent is used.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResourcePolicy`.
    ///
    /// <p>Replaces the existing resource policy for a bot or bot alias with a
    /// new one. If the policy doesn't exist, Amazon Lex returns an
    /// exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resource_policy_input::Builder,
    }
    impl<C, M, R> UpdateResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResourcePolicyInputOperationOutputAlias,
                crate::output::UpdateResourcePolicyOutput,
                crate::error::UpdateResourcePolicyError,
                crate::input::UpdateResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot or bot alias that the
        /// resource policy is attached to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON
        /// structure that contains one or more statements that define the policy.
        /// The policy must follow the IAM syntax. For more information about the
        /// contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy
        /// reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation
        /// exception.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>A resource policy to add to the resource. The policy is a JSON
        /// structure that contains one or more statements that define the policy.
        /// The policy must follow the IAM syntax. For more information about the
        /// contents of a JSON policy document, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html"> IAM JSON policy
        /// reference </a>. </p>
        /// <p>If the policy isn't valid, Amazon Lex returns a validation
        /// exception.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this
        /// revision ID doesn't match the current revision ID, Amazon Lex throws an
        /// exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of
        /// the policy with the new values.</p>
        pub fn expected_revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expected_revision_id(inp);
            self
        }
        /// <p>The identifier of the revision of the policy to update. If this
        /// revision ID doesn't match the current revision ID, Amazon Lex throws an
        /// exception.</p>
        /// <p>If you don't specify a revision, Amazon Lex overwrites the contents of
        /// the policy with the new values.</p>
        pub fn set_expected_revision_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_expected_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSlot`.
    ///
    /// <p>Updates the settings for a slot.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSlot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_slot_input::Builder,
    }
    impl<C, M, R> UpdateSlot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSlot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSlotOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSlotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSlotInputOperationOutputAlias,
                crate::output::UpdateSlotOutput,
                crate::error::UpdateSlotError,
                crate::input::UpdateSlotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the slot to update.</p>
        pub fn slot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_id(inp);
            self
        }
        /// <p>The unique identifier for the slot to update.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_id(input);
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn slot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_name(inp);
            self
        }
        /// <p>The new name for the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_name(input);
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description for the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this
        /// slot. </p>
        pub fn slot_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(inp);
            self
        }
        /// <p>The unique identifier of the new slot type to associate with this
        /// slot. </p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a
        /// response the provides a value for the slot.</p>
        pub fn value_elicitation_setting(
            mut self,
            inp: crate::model::SlotValueElicitationSetting,
        ) -> Self {
            self.inner = self.inner.value_elicitation_setting(inp);
            self
        }
        /// <p>A new set of prompts that Amazon Lex sends to the user to elicit a
        /// response the provides a value for the slot.</p>
        pub fn set_value_elicitation_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueElicitationSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_elicitation_setting(input);
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch
        /// logs. </p>
        pub fn obfuscation_setting(mut self, inp: crate::model::ObfuscationSetting) -> Self {
            self.inner = self.inner.obfuscation_setting(inp);
            self
        }
        /// <p>New settings that determine how slot values are formatted in Amazon CloudWatch
        /// logs. </p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.inner = self.inner.set_obfuscation_setting(input);
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The unique identifier of the bot that contains the slot.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be
        /// <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the slot. Must always be
        /// <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot.
        /// The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn intent_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.intent_id(inp);
            self
        }
        /// <p>The identifier of the intent that contains the slot.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_intent_id(input);
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response.
        /// Multiple value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn multiple_values_setting(mut self, inp: crate::model::MultipleValuesSetting) -> Self {
            self.inner = self.inner.multiple_values_setting(inp);
            self
        }
        /// <p>Determines whether the slot accepts multiple values in one response.
        /// Multiple value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>.</p>
        /// <p>If the <code>multipleValuesSetting</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn set_multiple_values_setting(
            mut self,
            input: std::option::Option<crate::model::MultipleValuesSetting>,
        ) -> Self {
            self.inner = self.inner.set_multiple_values_setting(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSlotType`.
    ///
    /// <p>Updates the configuration of an existing slot type.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_slot_type_input::Builder,
    }
    impl<C, M, R> UpdateSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSlotTypeInputOperationOutputAlias,
                crate::output::UpdateSlotTypeOutput,
                crate::error::UpdateSlotTypeError,
                crate::input::UpdateSlotTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn slot_type_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_id(inp);
            self
        }
        /// <p>The unique identifier of the slot type to update.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_slot_type_id(input);
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn slot_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.slot_type_name(inp);
            self
        }
        /// <p>The new name of the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_name(input);
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `slotTypeValues`.
        ///
        /// To override the contents of this collection use [`set_slot_type_values`](Self::set_slot_type_values).
        ///
        /// <p>A new list of values and their optional synonyms that define the
        /// values that the slot type can take.</p>
        pub fn slot_type_values(mut self, inp: impl Into<crate::model::SlotTypeValue>) -> Self {
            self.inner = self.inner.slot_type_values(inp);
            self
        }
        /// <p>A new list of values and their optional synonyms that define the
        /// values that the slot type can take.</p>
        pub fn set_slot_type_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeValue>>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_values(input);
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the
        /// list of slot type values.</p>
        pub fn value_selection_setting(
            mut self,
            inp: crate::model::SlotValueSelectionSetting,
        ) -> Self {
            self.inner = self.inner.value_selection_setting(inp);
            self
        }
        /// <p>The strategy that Amazon Lex should use when deciding on a value from the
        /// list of slot type values.</p>
        pub fn set_value_selection_setting(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionSetting>,
        ) -> Self {
            self.inner = self.inner.set_value_selection_setting(input);
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this
        /// slot type.</p>
        pub fn parent_slot_type_signature(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_slot_type_signature(inp);
            self
        }
        /// <p>The new built-in slot type that should be used as the parent of this
        /// slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_slot_type_signature(input);
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn bot_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_id(inp);
            self
        }
        /// <p>The identifier of the bot that contains the slot type.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_id(input);
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be
        /// <code>DRAFT</code>.</p>
        pub fn bot_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(inp);
            self
        }
        /// <p>The version of the bot that contains the slot type. Must be
        /// <code>DRAFT</code>.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot
        /// type. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn locale_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale_id(inp);
            self
        }
        /// <p>The identifier of the language and locale that contains the slot
        /// type. The string must match one of the supported locales. For more
        /// information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale_id(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
