// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains settings used by Amazon Lex to select a slot value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotValueSelectionSetting {
    /// <p>Determines the slot resolution strategy that Amazon Lex uses to
    /// return slot type values. The field can be set to one of the following
    /// values:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>OriginalValue - Returns the value entered by the user, if the
    /// user value is similar to the slot value.</p>
    /// </li>
    /// <li>
    /// <p>TopResolution - If there is a resolution list for the slot,
    /// return the first value in the resolution list as the slot type
    /// value. If there is no resolution list, null is returned.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>If you don't specify the valueSelectionStrategy, the default is
    /// OriginalValue. </p>
    pub resolution_strategy: std::option::Option<crate::model::SlotValueResolutionStrategy>,
    /// <p>A regular expression used to validate the value of a slot.</p>
    pub regex_filter: std::option::Option<crate::model::SlotValueRegexFilter>,
}
impl std::fmt::Debug for SlotValueSelectionSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotValueSelectionSetting");
        formatter.field("resolution_strategy", &self.resolution_strategy);
        formatter.field("regex_filter", &self.regex_filter);
        formatter.finish()
    }
}
/// See [`SlotValueSelectionSetting`](crate::model::SlotValueSelectionSetting)
pub mod slot_value_selection_setting {
    /// A builder for [`SlotValueSelectionSetting`](crate::model::SlotValueSelectionSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resolution_strategy:
            std::option::Option<crate::model::SlotValueResolutionStrategy>,
        pub(crate) regex_filter: std::option::Option<crate::model::SlotValueRegexFilter>,
    }
    impl Builder {
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to
        /// return slot type values. The field can be set to one of the following
        /// values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OriginalValue - Returns the value entered by the user, if the
        /// user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>TopResolution - If there is a resolution list for the slot,
        /// return the first value in the resolution list as the slot type
        /// value. If there is no resolution list, null is returned.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify the valueSelectionStrategy, the default is
        /// OriginalValue. </p>
        pub fn resolution_strategy(
            mut self,
            input: crate::model::SlotValueResolutionStrategy,
        ) -> Self {
            self.resolution_strategy = Some(input);
            self
        }
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to
        /// return slot type values. The field can be set to one of the following
        /// values:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>OriginalValue - Returns the value entered by the user, if the
        /// user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>TopResolution - If there is a resolution list for the slot,
        /// return the first value in the resolution list as the slot type
        /// value. If there is no resolution list, null is returned.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>If you don't specify the valueSelectionStrategy, the default is
        /// OriginalValue. </p>
        pub fn set_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueResolutionStrategy>,
        ) -> Self {
            self.resolution_strategy = input;
            self
        }
        /// <p>A regular expression used to validate the value of a slot.</p>
        pub fn regex_filter(mut self, input: crate::model::SlotValueRegexFilter) -> Self {
            self.regex_filter = Some(input);
            self
        }
        /// <p>A regular expression used to validate the value of a slot.</p>
        pub fn set_regex_filter(
            mut self,
            input: std::option::Option<crate::model::SlotValueRegexFilter>,
        ) -> Self {
            self.regex_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotValueSelectionSetting`](crate::model::SlotValueSelectionSetting)
        pub fn build(self) -> crate::model::SlotValueSelectionSetting {
            crate::model::SlotValueSelectionSetting {
                resolution_strategy: self.resolution_strategy,
                regex_filter: self.regex_filter,
            }
        }
    }
}
impl SlotValueSelectionSetting {
    /// Creates a new builder-style object to manufacture [`SlotValueSelectionSetting`](crate::model::SlotValueSelectionSetting)
    pub fn builder() -> crate::model::slot_value_selection_setting::Builder {
        crate::model::slot_value_selection_setting::Builder::default()
    }
}

/// <p>Provides a regular expression used to validate the value of a
/// slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotValueRegexFilter {
    /// <p>A regular expression used to validate the value of a slot.</p>
    /// <p> Use a standard regular expression. Amazon Lex supports the following
    /// characters in the regular expression: </p>
    /// <ul>
    /// <li>
    /// <p>A-Z, a-z</p>
    /// </li>
    /// <li>
    /// <p>0-9</p>
    /// </li>
    /// <li>
    /// <p>Unicode characters ("\ u<Unicode>")</p>
    /// </li>
    /// </ul>
    /// <p> Represent Unicode characters with four digits, for example "\u0041"
    /// or "\u005A". </p>
    /// <p> The following regular expression operators are not supported: </p>
    /// <ul>
    /// <li>
    /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
    /// </li>
    /// <li>
    /// <p>Wild card (.)</p>
    /// </li>
    /// </ul>
    pub pattern: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SlotValueRegexFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotValueRegexFilter");
        formatter.field("pattern", &self.pattern);
        formatter.finish()
    }
}
/// See [`SlotValueRegexFilter`](crate::model::SlotValueRegexFilter)
pub mod slot_value_regex_filter {
    /// A builder for [`SlotValueRegexFilter`](crate::model::SlotValueRegexFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pattern: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A regular expression used to validate the value of a slot.</p>
        /// <p> Use a standard regular expression. Amazon Lex supports the following
        /// characters in the regular expression: </p>
        /// <ul>
        /// <li>
        /// <p>A-Z, a-z</p>
        /// </li>
        /// <li>
        /// <p>0-9</p>
        /// </li>
        /// <li>
        /// <p>Unicode characters ("\ u<Unicode>")</p>
        /// </li>
        /// </ul>
        /// <p> Represent Unicode characters with four digits, for example "\u0041"
        /// or "\u005A". </p>
        /// <p> The following regular expression operators are not supported: </p>
        /// <ul>
        /// <li>
        /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
        /// </li>
        /// <li>
        /// <p>Wild card (.)</p>
        /// </li>
        /// </ul>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>A regular expression used to validate the value of a slot.</p>
        /// <p> Use a standard regular expression. Amazon Lex supports the following
        /// characters in the regular expression: </p>
        /// <ul>
        /// <li>
        /// <p>A-Z, a-z</p>
        /// </li>
        /// <li>
        /// <p>0-9</p>
        /// </li>
        /// <li>
        /// <p>Unicode characters ("\ u<Unicode>")</p>
        /// </li>
        /// </ul>
        /// <p> Represent Unicode characters with four digits, for example "\u0041"
        /// or "\u005A". </p>
        /// <p> The following regular expression operators are not supported: </p>
        /// <ul>
        /// <li>
        /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
        /// </li>
        /// <li>
        /// <p>Wild card (.)</p>
        /// </li>
        /// </ul>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotValueRegexFilter`](crate::model::SlotValueRegexFilter)
        pub fn build(self) -> crate::model::SlotValueRegexFilter {
            crate::model::SlotValueRegexFilter {
                pattern: self.pattern,
            }
        }
    }
}
impl SlotValueRegexFilter {
    /// Creates a new builder-style object to manufacture [`SlotValueRegexFilter`](crate::model::SlotValueRegexFilter)
    pub fn builder() -> crate::model::slot_value_regex_filter::Builder {
        crate::model::slot_value_regex_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotValueResolutionStrategy {
    #[allow(missing_docs)] // documentation missing in model
    OriginalValue,
    #[allow(missing_docs)] // documentation missing in model
    TopResolution,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotValueResolutionStrategy {
    fn from(s: &str) -> Self {
        match s {
            "OriginalValue" => SlotValueResolutionStrategy::OriginalValue,
            "TopResolution" => SlotValueResolutionStrategy::TopResolution,
            other => SlotValueResolutionStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotValueResolutionStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotValueResolutionStrategy::from(s))
    }
}
impl SlotValueResolutionStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotValueResolutionStrategy::OriginalValue => "OriginalValue",
            SlotValueResolutionStrategy::TopResolution => "TopResolution",
            SlotValueResolutionStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OriginalValue", "TopResolution"]
    }
}
impl AsRef<str> for SlotValueResolutionStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Each slot type can have a set of values. Each
/// <code>SlotTypeValue</code> represents a value that the slot type can
/// take.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeValue {
    /// <p>The value of the slot type entry.</p>
    pub sample_value: std::option::Option<crate::model::SampleValue>,
    /// <p>Additional values related to the slot type entry.</p>
    pub synonyms: std::option::Option<std::vec::Vec<crate::model::SampleValue>>,
}
impl std::fmt::Debug for SlotTypeValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeValue");
        formatter.field("sample_value", &self.sample_value);
        formatter.field("synonyms", &self.synonyms);
        formatter.finish()
    }
}
/// See [`SlotTypeValue`](crate::model::SlotTypeValue)
pub mod slot_type_value {
    /// A builder for [`SlotTypeValue`](crate::model::SlotTypeValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sample_value: std::option::Option<crate::model::SampleValue>,
        pub(crate) synonyms: std::option::Option<std::vec::Vec<crate::model::SampleValue>>,
    }
    impl Builder {
        /// <p>The value of the slot type entry.</p>
        pub fn sample_value(mut self, input: crate::model::SampleValue) -> Self {
            self.sample_value = Some(input);
            self
        }
        /// <p>The value of the slot type entry.</p>
        pub fn set_sample_value(
            mut self,
            input: std::option::Option<crate::model::SampleValue>,
        ) -> Self {
            self.sample_value = input;
            self
        }
        /// Appends an item to `synonyms`.
        ///
        /// To override the contents of this collection use [`set_synonyms`](Self::set_synonyms).
        ///
        /// <p>Additional values related to the slot type entry.</p>
        pub fn synonyms(mut self, input: impl Into<crate::model::SampleValue>) -> Self {
            let mut v = self.synonyms.unwrap_or_default();
            v.push(input.into());
            self.synonyms = Some(v);
            self
        }
        /// <p>Additional values related to the slot type entry.</p>
        pub fn set_synonyms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleValue>>,
        ) -> Self {
            self.synonyms = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeValue`](crate::model::SlotTypeValue)
        pub fn build(self) -> crate::model::SlotTypeValue {
            crate::model::SlotTypeValue {
                sample_value: self.sample_value,
                synonyms: self.synonyms,
            }
        }
    }
}
impl SlotTypeValue {
    /// Creates a new builder-style object to manufacture [`SlotTypeValue`](crate::model::SlotTypeValue)
    pub fn builder() -> crate::model::slot_type_value::Builder {
        crate::model::slot_type_value::Builder::default()
    }
}

/// <p>Defines one of the values for a slot type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SampleValue {
    /// <p>The value that can be used for a slot type.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SampleValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SampleValue");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SampleValue`](crate::model::SampleValue)
pub mod sample_value {
    /// A builder for [`SampleValue`](crate::model::SampleValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value that can be used for a slot type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value that can be used for a slot type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SampleValue`](crate::model::SampleValue)
        pub fn build(self) -> crate::model::SampleValue {
            crate::model::SampleValue { value: self.value }
        }
    }
}
impl SampleValue {
    /// Creates a new builder-style object to manufacture [`SampleValue`](crate::model::SampleValue)
    pub fn builder() -> crate::model::sample_value::Builder {
        crate::model::sample_value::Builder::default()
    }
}

/// <p>Indicates whether a slot can return multiple values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultipleValuesSetting {
    /// <p>Indicates whether a slot can return multiple values. When
    /// <code>true</code>, the slot may return more than one value in a
    /// response. When <code>false</code>, the slot returns only a single
    /// value.</p>
    /// <p>Multi-value slots are only available in the en-US locale. If you set
    /// this value to <code>true</code> in any other locale, Amazon Lex throws a
    /// <code>ValidationException</code>.</p>
    /// <p>If the <code>allowMutlipleValues</code> is not set, the default
    /// value is <code>false</code>.</p>
    pub allow_multiple_values: bool,
}
impl std::fmt::Debug for MultipleValuesSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultipleValuesSetting");
        formatter.field("allow_multiple_values", &self.allow_multiple_values);
        formatter.finish()
    }
}
/// See [`MultipleValuesSetting`](crate::model::MultipleValuesSetting)
pub mod multiple_values_setting {
    /// A builder for [`MultipleValuesSetting`](crate::model::MultipleValuesSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_multiple_values: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether a slot can return multiple values. When
        /// <code>true</code>, the slot may return more than one value in a
        /// response. When <code>false</code>, the slot returns only a single
        /// value.</p>
        /// <p>Multi-value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>.</p>
        /// <p>If the <code>allowMutlipleValues</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn allow_multiple_values(mut self, input: bool) -> Self {
            self.allow_multiple_values = Some(input);
            self
        }
        /// <p>Indicates whether a slot can return multiple values. When
        /// <code>true</code>, the slot may return more than one value in a
        /// response. When <code>false</code>, the slot returns only a single
        /// value.</p>
        /// <p>Multi-value slots are only available in the en-US locale. If you set
        /// this value to <code>true</code> in any other locale, Amazon Lex throws a
        /// <code>ValidationException</code>.</p>
        /// <p>If the <code>allowMutlipleValues</code> is not set, the default
        /// value is <code>false</code>.</p>
        pub fn set_allow_multiple_values(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_multiple_values = input;
            self
        }
        /// Consumes the builder and constructs a [`MultipleValuesSetting`](crate::model::MultipleValuesSetting)
        pub fn build(self) -> crate::model::MultipleValuesSetting {
            crate::model::MultipleValuesSetting {
                allow_multiple_values: self.allow_multiple_values.unwrap_or_default(),
            }
        }
    }
}
impl MultipleValuesSetting {
    /// Creates a new builder-style object to manufacture [`MultipleValuesSetting`](crate::model::MultipleValuesSetting)
    pub fn builder() -> crate::model::multiple_values_setting::Builder {
        crate::model::multiple_values_setting::Builder::default()
    }
}

/// <p>Determines whether Amazon Lex obscures slot values in conversation logs.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObfuscationSetting {
    /// <p>Value that determines whether Amazon Lex obscures slot values in
    /// conversation logs. The default is to obscure the values.</p>
    pub obfuscation_setting_type: std::option::Option<crate::model::ObfuscationSettingType>,
}
impl std::fmt::Debug for ObfuscationSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObfuscationSetting");
        formatter.field("obfuscation_setting_type", &self.obfuscation_setting_type);
        formatter.finish()
    }
}
/// See [`ObfuscationSetting`](crate::model::ObfuscationSetting)
pub mod obfuscation_setting {
    /// A builder for [`ObfuscationSetting`](crate::model::ObfuscationSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) obfuscation_setting_type:
            std::option::Option<crate::model::ObfuscationSettingType>,
    }
    impl Builder {
        /// <p>Value that determines whether Amazon Lex obscures slot values in
        /// conversation logs. The default is to obscure the values.</p>
        pub fn obfuscation_setting_type(
            mut self,
            input: crate::model::ObfuscationSettingType,
        ) -> Self {
            self.obfuscation_setting_type = Some(input);
            self
        }
        /// <p>Value that determines whether Amazon Lex obscures slot values in
        /// conversation logs. The default is to obscure the values.</p>
        pub fn set_obfuscation_setting_type(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSettingType>,
        ) -> Self {
            self.obfuscation_setting_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ObfuscationSetting`](crate::model::ObfuscationSetting)
        pub fn build(self) -> crate::model::ObfuscationSetting {
            crate::model::ObfuscationSetting {
                obfuscation_setting_type: self.obfuscation_setting_type,
            }
        }
    }
}
impl ObfuscationSetting {
    /// Creates a new builder-style object to manufacture [`ObfuscationSetting`](crate::model::ObfuscationSetting)
    pub fn builder() -> crate::model::obfuscation_setting::Builder {
        crate::model::obfuscation_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObfuscationSettingType {
    #[allow(missing_docs)] // documentation missing in model
    DefaultObfuscation,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObfuscationSettingType {
    fn from(s: &str) -> Self {
        match s {
            "DefaultObfuscation" => ObfuscationSettingType::DefaultObfuscation,
            "None" => ObfuscationSettingType::None,
            other => ObfuscationSettingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObfuscationSettingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObfuscationSettingType::from(s))
    }
}
impl ObfuscationSettingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObfuscationSettingType::DefaultObfuscation => "DefaultObfuscation",
            ObfuscationSettingType::None => "None",
            ObfuscationSettingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DefaultObfuscation", "None"]
    }
}
impl AsRef<str> for ObfuscationSettingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Settings that you can use for eliciting a slot value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotValueElicitationSetting {
    /// <p>A list of default values for a slot. Default values are used when
    /// Amazon Lex hasn't determined a value for a slot. You can specify default
    /// values from context variables, session attributes, and defined
    /// values.</p>
    pub default_value_specification:
        std::option::Option<crate::model::SlotDefaultValueSpecification>,
    /// <p>Specifies whether the slot is required or optional.</p>
    pub slot_constraint: std::option::Option<crate::model::SlotConstraint>,
    /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
    /// user.</p>
    pub prompt_specification: std::option::Option<crate::model::PromptSpecification>,
    /// <p>If you know a specific pattern that users might respond to an Amazon Lex
    /// request for a slot value, you can provide those utterances to improve
    /// accuracy. This is optional. In most cases, Amazon Lex is capable of
    /// understanding user utterances.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
    /// <p>Specifies the prompts that Amazon Lex uses while a bot is waiting for
    /// customer input. </p>
    pub wait_and_continue_specification:
        std::option::Option<crate::model::WaitAndContinueSpecification>,
}
impl std::fmt::Debug for SlotValueElicitationSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotValueElicitationSetting");
        formatter.field(
            "default_value_specification",
            &self.default_value_specification,
        );
        formatter.field("slot_constraint", &self.slot_constraint);
        formatter.field("prompt_specification", &self.prompt_specification);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field(
            "wait_and_continue_specification",
            &self.wait_and_continue_specification,
        );
        formatter.finish()
    }
}
/// See [`SlotValueElicitationSetting`](crate::model::SlotValueElicitationSetting)
pub mod slot_value_elicitation_setting {
    /// A builder for [`SlotValueElicitationSetting`](crate::model::SlotValueElicitationSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value_specification:
            std::option::Option<crate::model::SlotDefaultValueSpecification>,
        pub(crate) slot_constraint: std::option::Option<crate::model::SlotConstraint>,
        pub(crate) prompt_specification: std::option::Option<crate::model::PromptSpecification>,
        pub(crate) sample_utterances:
            std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        pub(crate) wait_and_continue_specification:
            std::option::Option<crate::model::WaitAndContinueSpecification>,
    }
    impl Builder {
        /// <p>A list of default values for a slot. Default values are used when
        /// Amazon Lex hasn't determined a value for a slot. You can specify default
        /// values from context variables, session attributes, and defined
        /// values.</p>
        pub fn default_value_specification(
            mut self,
            input: crate::model::SlotDefaultValueSpecification,
        ) -> Self {
            self.default_value_specification = Some(input);
            self
        }
        /// <p>A list of default values for a slot. Default values are used when
        /// Amazon Lex hasn't determined a value for a slot. You can specify default
        /// values from context variables, session attributes, and defined
        /// values.</p>
        pub fn set_default_value_specification(
            mut self,
            input: std::option::Option<crate::model::SlotDefaultValueSpecification>,
        ) -> Self {
            self.default_value_specification = input;
            self
        }
        /// <p>Specifies whether the slot is required or optional.</p>
        pub fn slot_constraint(mut self, input: crate::model::SlotConstraint) -> Self {
            self.slot_constraint = Some(input);
            self
        }
        /// <p>Specifies whether the slot is required or optional.</p>
        pub fn set_slot_constraint(
            mut self,
            input: std::option::Option<crate::model::SlotConstraint>,
        ) -> Self {
            self.slot_constraint = input;
            self
        }
        /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
        /// user.</p>
        pub fn prompt_specification(mut self, input: crate::model::PromptSpecification) -> Self {
            self.prompt_specification = Some(input);
            self
        }
        /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
        /// user.</p>
        pub fn set_prompt_specification(
            mut self,
            input: std::option::Option<crate::model::PromptSpecification>,
        ) -> Self {
            self.prompt_specification = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>If you know a specific pattern that users might respond to an Amazon Lex
        /// request for a slot value, you can provide those utterances to improve
        /// accuracy. This is optional. In most cases, Amazon Lex is capable of
        /// understanding user utterances.</p>
        pub fn sample_utterances(
            mut self,
            input: impl Into<crate::model::SampleUtterance>,
        ) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p>If you know a specific pattern that users might respond to an Amazon Lex
        /// request for a slot value, you can provide those utterances to improve
        /// accuracy. This is optional. In most cases, Amazon Lex is capable of
        /// understanding user utterances.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SampleUtterance>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>Specifies the prompts that Amazon Lex uses while a bot is waiting for
        /// customer input. </p>
        pub fn wait_and_continue_specification(
            mut self,
            input: crate::model::WaitAndContinueSpecification,
        ) -> Self {
            self.wait_and_continue_specification = Some(input);
            self
        }
        /// <p>Specifies the prompts that Amazon Lex uses while a bot is waiting for
        /// customer input. </p>
        pub fn set_wait_and_continue_specification(
            mut self,
            input: std::option::Option<crate::model::WaitAndContinueSpecification>,
        ) -> Self {
            self.wait_and_continue_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotValueElicitationSetting`](crate::model::SlotValueElicitationSetting)
        pub fn build(self) -> crate::model::SlotValueElicitationSetting {
            crate::model::SlotValueElicitationSetting {
                default_value_specification: self.default_value_specification,
                slot_constraint: self.slot_constraint,
                prompt_specification: self.prompt_specification,
                sample_utterances: self.sample_utterances,
                wait_and_continue_specification: self.wait_and_continue_specification,
            }
        }
    }
}
impl SlotValueElicitationSetting {
    /// Creates a new builder-style object to manufacture [`SlotValueElicitationSetting`](crate::model::SlotValueElicitationSetting)
    pub fn builder() -> crate::model::slot_value_elicitation_setting::Builder {
        crate::model::slot_value_elicitation_setting::Builder::default()
    }
}

/// <p>Specifies the prompts that Amazon Lex uses while a bot is waiting for
/// customer input. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WaitAndContinueSpecification {
    /// <p>The response that Amazon Lex sends to indicate that the bot is waiting
    /// for the conversation to continue.</p>
    pub waiting_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>The response that Amazon Lex sends to indicate that the bot is ready to
    /// continue the conversation.</p>
    pub continue_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>A response that Amazon Lex sends periodically to the user to indicate
    /// that the bot is still waiting for input from the user.</p>
    pub still_waiting_response:
        std::option::Option<crate::model::StillWaitingResponseSpecification>,
    /// <p>Specifies whether the bot will wait for a user to respond. When this
    /// field is false, wait and continue responses for a slot aren't used. If
    /// the <code>active</code> field isn't specified, the default is
    /// true.</p>
    pub active: std::option::Option<bool>,
}
impl std::fmt::Debug for WaitAndContinueSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WaitAndContinueSpecification");
        formatter.field("waiting_response", &self.waiting_response);
        formatter.field("continue_response", &self.continue_response);
        formatter.field("still_waiting_response", &self.still_waiting_response);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}
/// See [`WaitAndContinueSpecification`](crate::model::WaitAndContinueSpecification)
pub mod wait_and_continue_specification {
    /// A builder for [`WaitAndContinueSpecification`](crate::model::WaitAndContinueSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) waiting_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) continue_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) still_waiting_response:
            std::option::Option<crate::model::StillWaitingResponseSpecification>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response that Amazon Lex sends to indicate that the bot is waiting
        /// for the conversation to continue.</p>
        pub fn waiting_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.waiting_response = Some(input);
            self
        }
        /// <p>The response that Amazon Lex sends to indicate that the bot is waiting
        /// for the conversation to continue.</p>
        pub fn set_waiting_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.waiting_response = input;
            self
        }
        /// <p>The response that Amazon Lex sends to indicate that the bot is ready to
        /// continue the conversation.</p>
        pub fn continue_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.continue_response = Some(input);
            self
        }
        /// <p>The response that Amazon Lex sends to indicate that the bot is ready to
        /// continue the conversation.</p>
        pub fn set_continue_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.continue_response = input;
            self
        }
        /// <p>A response that Amazon Lex sends periodically to the user to indicate
        /// that the bot is still waiting for input from the user.</p>
        pub fn still_waiting_response(
            mut self,
            input: crate::model::StillWaitingResponseSpecification,
        ) -> Self {
            self.still_waiting_response = Some(input);
            self
        }
        /// <p>A response that Amazon Lex sends periodically to the user to indicate
        /// that the bot is still waiting for input from the user.</p>
        pub fn set_still_waiting_response(
            mut self,
            input: std::option::Option<crate::model::StillWaitingResponseSpecification>,
        ) -> Self {
            self.still_waiting_response = input;
            self
        }
        /// <p>Specifies whether the bot will wait for a user to respond. When this
        /// field is false, wait and continue responses for a slot aren't used. If
        /// the <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Specifies whether the bot will wait for a user to respond. When this
        /// field is false, wait and continue responses for a slot aren't used. If
        /// the <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`WaitAndContinueSpecification`](crate::model::WaitAndContinueSpecification)
        pub fn build(self) -> crate::model::WaitAndContinueSpecification {
            crate::model::WaitAndContinueSpecification {
                waiting_response: self.waiting_response,
                continue_response: self.continue_response,
                still_waiting_response: self.still_waiting_response,
                active: self.active,
            }
        }
    }
}
impl WaitAndContinueSpecification {
    /// Creates a new builder-style object to manufacture [`WaitAndContinueSpecification`](crate::model::WaitAndContinueSpecification)
    pub fn builder() -> crate::model::wait_and_continue_specification::Builder {
        crate::model::wait_and_continue_specification::Builder::default()
    }
}

/// <p>Defines the messages that Amazon Lex sends to a user to remind them that
/// the bot is waiting for a response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StillWaitingResponseSpecification {
    /// <p>One or more message groups, each containing one or more messages,
    /// that define the prompts that Amazon Lex sends to the user.</p>
    pub message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
    /// <p>How often a message should be sent to the user. Minimum of 1 second,
    /// maximum of 5 minutes.</p>
    pub frequency_in_seconds: std::option::Option<i32>,
    /// <p>If Amazon Lex waits longer than this length of time for a response, it
    /// will stop sending messages.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
    /// <p>Indicates that the user can interrupt the response by speaking while
    /// the message is being played.</p>
    pub allow_interrupt: std::option::Option<bool>,
}
impl std::fmt::Debug for StillWaitingResponseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StillWaitingResponseSpecification");
        formatter.field("message_groups", &self.message_groups);
        formatter.field("frequency_in_seconds", &self.frequency_in_seconds);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.field("allow_interrupt", &self.allow_interrupt);
        formatter.finish()
    }
}
/// See [`StillWaitingResponseSpecification`](crate::model::StillWaitingResponseSpecification)
pub mod still_waiting_response_specification {
    /// A builder for [`StillWaitingResponseSpecification`](crate::model::StillWaitingResponseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        pub(crate) frequency_in_seconds: std::option::Option<i32>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
        pub(crate) allow_interrupt: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `message_groups`.
        ///
        /// To override the contents of this collection use [`set_message_groups`](Self::set_message_groups).
        ///
        /// <p>One or more message groups, each containing one or more messages,
        /// that define the prompts that Amazon Lex sends to the user.</p>
        pub fn message_groups(mut self, input: impl Into<crate::model::MessageGroup>) -> Self {
            let mut v = self.message_groups.unwrap_or_default();
            v.push(input.into());
            self.message_groups = Some(v);
            self
        }
        /// <p>One or more message groups, each containing one or more messages,
        /// that define the prompts that Amazon Lex sends to the user.</p>
        pub fn set_message_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        ) -> Self {
            self.message_groups = input;
            self
        }
        /// <p>How often a message should be sent to the user. Minimum of 1 second,
        /// maximum of 5 minutes.</p>
        pub fn frequency_in_seconds(mut self, input: i32) -> Self {
            self.frequency_in_seconds = Some(input);
            self
        }
        /// <p>How often a message should be sent to the user. Minimum of 1 second,
        /// maximum of 5 minutes.</p>
        pub fn set_frequency_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency_in_seconds = input;
            self
        }
        /// <p>If Amazon Lex waits longer than this length of time for a response, it
        /// will stop sending messages.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>If Amazon Lex waits longer than this length of time for a response, it
        /// will stop sending messages.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// <p>Indicates that the user can interrupt the response by speaking while
        /// the message is being played.</p>
        pub fn allow_interrupt(mut self, input: bool) -> Self {
            self.allow_interrupt = Some(input);
            self
        }
        /// <p>Indicates that the user can interrupt the response by speaking while
        /// the message is being played.</p>
        pub fn set_allow_interrupt(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_interrupt = input;
            self
        }
        /// Consumes the builder and constructs a [`StillWaitingResponseSpecification`](crate::model::StillWaitingResponseSpecification)
        pub fn build(self) -> crate::model::StillWaitingResponseSpecification {
            crate::model::StillWaitingResponseSpecification {
                message_groups: self.message_groups,
                frequency_in_seconds: self.frequency_in_seconds,
                timeout_in_seconds: self.timeout_in_seconds,
                allow_interrupt: self.allow_interrupt,
            }
        }
    }
}
impl StillWaitingResponseSpecification {
    /// Creates a new builder-style object to manufacture [`StillWaitingResponseSpecification`](crate::model::StillWaitingResponseSpecification)
    pub fn builder() -> crate::model::still_waiting_response_specification::Builder {
        crate::model::still_waiting_response_specification::Builder::default()
    }
}

/// <p>Provides one or more messages that Amazon Lex should send to the
/// user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageGroup {
    /// <p>The primary message that Amazon Lex should send to the user.</p>
    pub message: std::option::Option<crate::model::Message>,
    /// <p>Message variations to send to the user. When variations are defined,
    /// Amazon Lex chooses the primary message or one of the variations to send to
    /// the user.</p>
    pub variations: std::option::Option<std::vec::Vec<crate::model::Message>>,
}
impl std::fmt::Debug for MessageGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageGroup");
        formatter.field("message", &self.message);
        formatter.field("variations", &self.variations);
        formatter.finish()
    }
}
/// See [`MessageGroup`](crate::model::MessageGroup)
pub mod message_group {
    /// A builder for [`MessageGroup`](crate::model::MessageGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<crate::model::Message>,
        pub(crate) variations: std::option::Option<std::vec::Vec<crate::model::Message>>,
    }
    impl Builder {
        /// <p>The primary message that Amazon Lex should send to the user.</p>
        pub fn message(mut self, input: crate::model::Message) -> Self {
            self.message = Some(input);
            self
        }
        /// <p>The primary message that Amazon Lex should send to the user.</p>
        pub fn set_message(mut self, input: std::option::Option<crate::model::Message>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `variations`.
        ///
        /// To override the contents of this collection use [`set_variations`](Self::set_variations).
        ///
        /// <p>Message variations to send to the user. When variations are defined,
        /// Amazon Lex chooses the primary message or one of the variations to send to
        /// the user.</p>
        pub fn variations(mut self, input: impl Into<crate::model::Message>) -> Self {
            let mut v = self.variations.unwrap_or_default();
            v.push(input.into());
            self.variations = Some(v);
            self
        }
        /// <p>Message variations to send to the user. When variations are defined,
        /// Amazon Lex chooses the primary message or one of the variations to send to
        /// the user.</p>
        pub fn set_variations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.variations = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageGroup`](crate::model::MessageGroup)
        pub fn build(self) -> crate::model::MessageGroup {
            crate::model::MessageGroup {
                message: self.message,
                variations: self.variations,
            }
        }
    }
}
impl MessageGroup {
    /// Creates a new builder-style object to manufacture [`MessageGroup`](crate::model::MessageGroup)
    pub fn builder() -> crate::model::message_group::Builder {
        crate::model::message_group::Builder::default()
    }
}

/// <p>The object that provides message text and it's type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>A message in plain text format.</p>
    pub plain_text_message: std::option::Option<crate::model::PlainTextMessage>,
    /// <p>A message in a custom format defined by the client
    /// application.</p>
    pub custom_payload: std::option::Option<crate::model::CustomPayload>,
    /// <p>A message in Speech Synthesis Markup Language (SSML).</p>
    pub ssml_message: std::option::Option<crate::model::SsmlMessage>,
    /// <p>A message that defines a response card that the client application
    /// can show to the user.</p>
    pub image_response_card: std::option::Option<crate::model::ImageResponseCard>,
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("plain_text_message", &self.plain_text_message);
        formatter.field("custom_payload", &self.custom_payload);
        formatter.field("ssml_message", &self.ssml_message);
        formatter.field("image_response_card", &self.image_response_card);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) plain_text_message: std::option::Option<crate::model::PlainTextMessage>,
        pub(crate) custom_payload: std::option::Option<crate::model::CustomPayload>,
        pub(crate) ssml_message: std::option::Option<crate::model::SsmlMessage>,
        pub(crate) image_response_card: std::option::Option<crate::model::ImageResponseCard>,
    }
    impl Builder {
        /// <p>A message in plain text format.</p>
        pub fn plain_text_message(mut self, input: crate::model::PlainTextMessage) -> Self {
            self.plain_text_message = Some(input);
            self
        }
        /// <p>A message in plain text format.</p>
        pub fn set_plain_text_message(
            mut self,
            input: std::option::Option<crate::model::PlainTextMessage>,
        ) -> Self {
            self.plain_text_message = input;
            self
        }
        /// <p>A message in a custom format defined by the client
        /// application.</p>
        pub fn custom_payload(mut self, input: crate::model::CustomPayload) -> Self {
            self.custom_payload = Some(input);
            self
        }
        /// <p>A message in a custom format defined by the client
        /// application.</p>
        pub fn set_custom_payload(
            mut self,
            input: std::option::Option<crate::model::CustomPayload>,
        ) -> Self {
            self.custom_payload = input;
            self
        }
        /// <p>A message in Speech Synthesis Markup Language (SSML).</p>
        pub fn ssml_message(mut self, input: crate::model::SsmlMessage) -> Self {
            self.ssml_message = Some(input);
            self
        }
        /// <p>A message in Speech Synthesis Markup Language (SSML).</p>
        pub fn set_ssml_message(
            mut self,
            input: std::option::Option<crate::model::SsmlMessage>,
        ) -> Self {
            self.ssml_message = input;
            self
        }
        /// <p>A message that defines a response card that the client application
        /// can show to the user.</p>
        pub fn image_response_card(mut self, input: crate::model::ImageResponseCard) -> Self {
            self.image_response_card = Some(input);
            self
        }
        /// <p>A message that defines a response card that the client application
        /// can show to the user.</p>
        pub fn set_image_response_card(
            mut self,
            input: std::option::Option<crate::model::ImageResponseCard>,
        ) -> Self {
            self.image_response_card = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                plain_text_message: self.plain_text_message,
                custom_payload: self.custom_payload,
                ssml_message: self.ssml_message,
                image_response_card: self.image_response_card,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

/// <p>A card that is shown to the user by a messaging platform. You define
/// the contents of the card, the card is displayed by the platform. </p>
/// <p>When you use a response card, the response from the user is
/// constrained to the text associated with a button on the card.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageResponseCard {
    /// <p>The title to display on the response card. The format of the title
    /// is determined by the platform displaying the response card.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The subtitle to display on the response card. The format of the
    /// subtitle is determined by the platform displaying the response
    /// card.</p>
    pub subtitle: std::option::Option<std::string::String>,
    /// <p>The URL of an image to display on the response card. The image URL
    /// must be publicly available so that the platform displaying the response
    /// card has access to the image.</p>
    pub image_url: std::option::Option<std::string::String>,
    /// <p>A list of buttons that should be displayed on the response card. The
    /// arrangement of the buttons is determined by the platform that displays
    /// the button.</p>
    pub buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
}
impl std::fmt::Debug for ImageResponseCard {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageResponseCard");
        formatter.field("title", &self.title);
        formatter.field("subtitle", &self.subtitle);
        formatter.field("image_url", &self.image_url);
        formatter.field("buttons", &self.buttons);
        formatter.finish()
    }
}
/// See [`ImageResponseCard`](crate::model::ImageResponseCard)
pub mod image_response_card {
    /// A builder for [`ImageResponseCard`](crate::model::ImageResponseCard)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) subtitle: std::option::Option<std::string::String>,
        pub(crate) image_url: std::option::Option<std::string::String>,
        pub(crate) buttons: std::option::Option<std::vec::Vec<crate::model::Button>>,
    }
    impl Builder {
        /// <p>The title to display on the response card. The format of the title
        /// is determined by the platform displaying the response card.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title to display on the response card. The format of the title
        /// is determined by the platform displaying the response card.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The subtitle to display on the response card. The format of the
        /// subtitle is determined by the platform displaying the response
        /// card.</p>
        pub fn subtitle(mut self, input: impl Into<std::string::String>) -> Self {
            self.subtitle = Some(input.into());
            self
        }
        /// <p>The subtitle to display on the response card. The format of the
        /// subtitle is determined by the platform displaying the response
        /// card.</p>
        pub fn set_subtitle(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subtitle = input;
            self
        }
        /// <p>The URL of an image to display on the response card. The image URL
        /// must be publicly available so that the platform displaying the response
        /// card has access to the image.</p>
        pub fn image_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_url = Some(input.into());
            self
        }
        /// <p>The URL of an image to display on the response card. The image URL
        /// must be publicly available so that the platform displaying the response
        /// card has access to the image.</p>
        pub fn set_image_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_url = input;
            self
        }
        /// Appends an item to `buttons`.
        ///
        /// To override the contents of this collection use [`set_buttons`](Self::set_buttons).
        ///
        /// <p>A list of buttons that should be displayed on the response card. The
        /// arrangement of the buttons is determined by the platform that displays
        /// the button.</p>
        pub fn buttons(mut self, input: impl Into<crate::model::Button>) -> Self {
            let mut v = self.buttons.unwrap_or_default();
            v.push(input.into());
            self.buttons = Some(v);
            self
        }
        /// <p>A list of buttons that should be displayed on the response card. The
        /// arrangement of the buttons is determined by the platform that displays
        /// the button.</p>
        pub fn set_buttons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Button>>,
        ) -> Self {
            self.buttons = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageResponseCard`](crate::model::ImageResponseCard)
        pub fn build(self) -> crate::model::ImageResponseCard {
            crate::model::ImageResponseCard {
                title: self.title,
                subtitle: self.subtitle,
                image_url: self.image_url,
                buttons: self.buttons,
            }
        }
    }
}
impl ImageResponseCard {
    /// Creates a new builder-style object to manufacture [`ImageResponseCard`](crate::model::ImageResponseCard)
    pub fn builder() -> crate::model::image_response_card::Builder {
        crate::model::image_response_card::Builder::default()
    }
}

/// <p>Describes a button to use on a response card used to gather slot
/// values from a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Button {
    /// <p>The text that appears on the button. Use this to tell the user what
    /// value is returned when they choose this button.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>The value returned to Amazon Lex when the user chooses this button. This
    /// must be one of the slot values configured for the slot.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Button {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Button");
        formatter.field("text", &self.text);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Button`](crate::model::Button)
pub mod button {
    /// A builder for [`Button`](crate::model::Button)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text that appears on the button. Use this to tell the user what
        /// value is returned when they choose this button.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text that appears on the button. Use this to tell the user what
        /// value is returned when they choose this button.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// <p>The value returned to Amazon Lex when the user chooses this button. This
        /// must be one of the slot values configured for the slot.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value returned to Amazon Lex when the user chooses this button. This
        /// must be one of the slot values configured for the slot.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Button`](crate::model::Button)
        pub fn build(self) -> crate::model::Button {
            crate::model::Button {
                text: self.text,
                value: self.value,
            }
        }
    }
}
impl Button {
    /// Creates a new builder-style object to manufacture [`Button`](crate::model::Button)
    pub fn builder() -> crate::model::button::Builder {
        crate::model::button::Builder::default()
    }
}

/// <p>Defines a Speech Synthesis Markup Language (SSML) prompt.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SsmlMessage {
    /// <p>The SSML text that defines the prompt.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SsmlMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SsmlMessage");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SsmlMessage`](crate::model::SsmlMessage)
pub mod ssml_message {
    /// A builder for [`SsmlMessage`](crate::model::SsmlMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SSML text that defines the prompt.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The SSML text that defines the prompt.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SsmlMessage`](crate::model::SsmlMessage)
        pub fn build(self) -> crate::model::SsmlMessage {
            crate::model::SsmlMessage { value: self.value }
        }
    }
}
impl SsmlMessage {
    /// Creates a new builder-style object to manufacture [`SsmlMessage`](crate::model::SsmlMessage)
    pub fn builder() -> crate::model::ssml_message::Builder {
        crate::model::ssml_message::Builder::default()
    }
}

/// <p>A custom response string that Amazon Lex sends to your application. You
/// define the content and structure the string.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomPayload {
    /// <p>The string that is sent to your application.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CustomPayload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomPayload");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`CustomPayload`](crate::model::CustomPayload)
pub mod custom_payload {
    /// A builder for [`CustomPayload`](crate::model::CustomPayload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string that is sent to your application.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The string that is sent to your application.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomPayload`](crate::model::CustomPayload)
        pub fn build(self) -> crate::model::CustomPayload {
            crate::model::CustomPayload { value: self.value }
        }
    }
}
impl CustomPayload {
    /// Creates a new builder-style object to manufacture [`CustomPayload`](crate::model::CustomPayload)
    pub fn builder() -> crate::model::custom_payload::Builder {
        crate::model::custom_payload::Builder::default()
    }
}

/// <p>Defines an ASCII text message to send to the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlainTextMessage {
    /// <p>The message to send to the user.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlainTextMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlainTextMessage");
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`PlainTextMessage`](crate::model::PlainTextMessage)
pub mod plain_text_message {
    /// A builder for [`PlainTextMessage`](crate::model::PlainTextMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message to send to the user.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The message to send to the user.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`PlainTextMessage`](crate::model::PlainTextMessage)
        pub fn build(self) -> crate::model::PlainTextMessage {
            crate::model::PlainTextMessage { value: self.value }
        }
    }
}
impl PlainTextMessage {
    /// Creates a new builder-style object to manufacture [`PlainTextMessage`](crate::model::PlainTextMessage)
    pub fn builder() -> crate::model::plain_text_message::Builder {
        crate::model::plain_text_message::Builder::default()
    }
}

/// <p>Specifies a list of message groups that Amazon Lex uses to respond the
/// user input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResponseSpecification {
    /// <p>A collection of responses that Amazon Lex can send to the user. Amazon Lex
    /// chooses the actual response to send at runtime.</p>
    pub message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
    /// <p>Indicates whether the user can interrupt a speech response from
    /// Amazon Lex.</p>
    pub allow_interrupt: std::option::Option<bool>,
}
impl std::fmt::Debug for ResponseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResponseSpecification");
        formatter.field("message_groups", &self.message_groups);
        formatter.field("allow_interrupt", &self.allow_interrupt);
        formatter.finish()
    }
}
/// See [`ResponseSpecification`](crate::model::ResponseSpecification)
pub mod response_specification {
    /// A builder for [`ResponseSpecification`](crate::model::ResponseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        pub(crate) allow_interrupt: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `message_groups`.
        ///
        /// To override the contents of this collection use [`set_message_groups`](Self::set_message_groups).
        ///
        /// <p>A collection of responses that Amazon Lex can send to the user. Amazon Lex
        /// chooses the actual response to send at runtime.</p>
        pub fn message_groups(mut self, input: impl Into<crate::model::MessageGroup>) -> Self {
            let mut v = self.message_groups.unwrap_or_default();
            v.push(input.into());
            self.message_groups = Some(v);
            self
        }
        /// <p>A collection of responses that Amazon Lex can send to the user. Amazon Lex
        /// chooses the actual response to send at runtime.</p>
        pub fn set_message_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        ) -> Self {
            self.message_groups = input;
            self
        }
        /// <p>Indicates whether the user can interrupt a speech response from
        /// Amazon Lex.</p>
        pub fn allow_interrupt(mut self, input: bool) -> Self {
            self.allow_interrupt = Some(input);
            self
        }
        /// <p>Indicates whether the user can interrupt a speech response from
        /// Amazon Lex.</p>
        pub fn set_allow_interrupt(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_interrupt = input;
            self
        }
        /// Consumes the builder and constructs a [`ResponseSpecification`](crate::model::ResponseSpecification)
        pub fn build(self) -> crate::model::ResponseSpecification {
            crate::model::ResponseSpecification {
                message_groups: self.message_groups,
                allow_interrupt: self.allow_interrupt,
            }
        }
    }
}
impl ResponseSpecification {
    /// Creates a new builder-style object to manufacture [`ResponseSpecification`](crate::model::ResponseSpecification)
    pub fn builder() -> crate::model::response_specification::Builder {
        crate::model::response_specification::Builder::default()
    }
}

/// <p>A sample utterance that invokes an intent or respond to a slot
/// elicitation prompt.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SampleUtterance {
    /// <p>The sample utterance that Amazon Lex uses to build its machine-learning
    /// model to recognize intents.</p>
    pub utterance: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SampleUtterance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SampleUtterance");
        formatter.field("utterance", &self.utterance);
        formatter.finish()
    }
}
/// See [`SampleUtterance`](crate::model::SampleUtterance)
pub mod sample_utterance {
    /// A builder for [`SampleUtterance`](crate::model::SampleUtterance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utterance: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The sample utterance that Amazon Lex uses to build its machine-learning
        /// model to recognize intents.</p>
        pub fn utterance(mut self, input: impl Into<std::string::String>) -> Self {
            self.utterance = Some(input.into());
            self
        }
        /// <p>The sample utterance that Amazon Lex uses to build its machine-learning
        /// model to recognize intents.</p>
        pub fn set_utterance(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.utterance = input;
            self
        }
        /// Consumes the builder and constructs a [`SampleUtterance`](crate::model::SampleUtterance)
        pub fn build(self) -> crate::model::SampleUtterance {
            crate::model::SampleUtterance {
                utterance: self.utterance,
            }
        }
    }
}
impl SampleUtterance {
    /// Creates a new builder-style object to manufacture [`SampleUtterance`](crate::model::SampleUtterance)
    pub fn builder() -> crate::model::sample_utterance::Builder {
        crate::model::sample_utterance::Builder::default()
    }
}

/// <p>Specifies a list of message groups that Amazon Lex sends to a user to
/// elicit a response.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromptSpecification {
    /// <p>A collection of messages that Amazon Lex can send to the user. Amazon Lex
    /// chooses the actual message to send at runtime.</p>
    pub message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
    /// <p>The maximum number of times the bot tries to elicit a response from
    /// the user using this prompt.</p>
    pub max_retries: std::option::Option<i32>,
    /// <p>Indicates whether the user can interrupt a speech prompt from the
    /// bot.</p>
    pub allow_interrupt: std::option::Option<bool>,
}
impl std::fmt::Debug for PromptSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromptSpecification");
        formatter.field("message_groups", &self.message_groups);
        formatter.field("max_retries", &self.max_retries);
        formatter.field("allow_interrupt", &self.allow_interrupt);
        formatter.finish()
    }
}
/// See [`PromptSpecification`](crate::model::PromptSpecification)
pub mod prompt_specification {
    /// A builder for [`PromptSpecification`](crate::model::PromptSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        pub(crate) max_retries: std::option::Option<i32>,
        pub(crate) allow_interrupt: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `message_groups`.
        ///
        /// To override the contents of this collection use [`set_message_groups`](Self::set_message_groups).
        ///
        /// <p>A collection of messages that Amazon Lex can send to the user. Amazon Lex
        /// chooses the actual message to send at runtime.</p>
        pub fn message_groups(mut self, input: impl Into<crate::model::MessageGroup>) -> Self {
            let mut v = self.message_groups.unwrap_or_default();
            v.push(input.into());
            self.message_groups = Some(v);
            self
        }
        /// <p>A collection of messages that Amazon Lex can send to the user. Amazon Lex
        /// chooses the actual message to send at runtime.</p>
        pub fn set_message_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        ) -> Self {
            self.message_groups = input;
            self
        }
        /// <p>The maximum number of times the bot tries to elicit a response from
        /// the user using this prompt.</p>
        pub fn max_retries(mut self, input: i32) -> Self {
            self.max_retries = Some(input);
            self
        }
        /// <p>The maximum number of times the bot tries to elicit a response from
        /// the user using this prompt.</p>
        pub fn set_max_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retries = input;
            self
        }
        /// <p>Indicates whether the user can interrupt a speech prompt from the
        /// bot.</p>
        pub fn allow_interrupt(mut self, input: bool) -> Self {
            self.allow_interrupt = Some(input);
            self
        }
        /// <p>Indicates whether the user can interrupt a speech prompt from the
        /// bot.</p>
        pub fn set_allow_interrupt(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_interrupt = input;
            self
        }
        /// Consumes the builder and constructs a [`PromptSpecification`](crate::model::PromptSpecification)
        pub fn build(self) -> crate::model::PromptSpecification {
            crate::model::PromptSpecification {
                message_groups: self.message_groups,
                max_retries: self.max_retries,
                allow_interrupt: self.allow_interrupt,
            }
        }
    }
}
impl PromptSpecification {
    /// Creates a new builder-style object to manufacture [`PromptSpecification`](crate::model::PromptSpecification)
    pub fn builder() -> crate::model::prompt_specification::Builder {
        crate::model::prompt_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotConstraint {
    fn from(s: &str) -> Self {
        match s {
            "Optional" => SlotConstraint::Optional,
            "Required" => SlotConstraint::Required,
            other => SlotConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotConstraint::from(s))
    }
}
impl SlotConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotConstraint::Optional => "Optional",
            SlotConstraint::Required => "Required",
            SlotConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Optional", "Required"]
    }
}
impl AsRef<str> for SlotConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines a list of values that Amazon Lex should use as the default value
/// for a slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotDefaultValueSpecification {
    /// <p>A list of default values. Amazon Lex chooses the default value to use in
    /// the order that they are presented in the list.</p>
    pub default_value_list: std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
}
impl std::fmt::Debug for SlotDefaultValueSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotDefaultValueSpecification");
        formatter.field("default_value_list", &self.default_value_list);
        formatter.finish()
    }
}
/// See [`SlotDefaultValueSpecification`](crate::model::SlotDefaultValueSpecification)
pub mod slot_default_value_specification {
    /// A builder for [`SlotDefaultValueSpecification`](crate::model::SlotDefaultValueSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value_list:
            std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
    }
    impl Builder {
        /// Appends an item to `default_value_list`.
        ///
        /// To override the contents of this collection use [`set_default_value_list`](Self::set_default_value_list).
        ///
        /// <p>A list of default values. Amazon Lex chooses the default value to use in
        /// the order that they are presented in the list.</p>
        pub fn default_value_list(
            mut self,
            input: impl Into<crate::model::SlotDefaultValue>,
        ) -> Self {
            let mut v = self.default_value_list.unwrap_or_default();
            v.push(input.into());
            self.default_value_list = Some(v);
            self
        }
        /// <p>A list of default values. Amazon Lex chooses the default value to use in
        /// the order that they are presented in the list.</p>
        pub fn set_default_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
        ) -> Self {
            self.default_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotDefaultValueSpecification`](crate::model::SlotDefaultValueSpecification)
        pub fn build(self) -> crate::model::SlotDefaultValueSpecification {
            crate::model::SlotDefaultValueSpecification {
                default_value_list: self.default_value_list,
            }
        }
    }
}
impl SlotDefaultValueSpecification {
    /// Creates a new builder-style object to manufacture [`SlotDefaultValueSpecification`](crate::model::SlotDefaultValueSpecification)
    pub fn builder() -> crate::model::slot_default_value_specification::Builder {
        crate::model::slot_default_value_specification::Builder::default()
    }
}

/// <p>Specifies the default value to use when a user doesn't provide a
/// value for a slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotDefaultValue {
    /// <p>The default value to use when a user doesn't provide a value for a
    /// slot.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SlotDefaultValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotDefaultValue");
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`SlotDefaultValue`](crate::model::SlotDefaultValue)
pub mod slot_default_value {
    /// A builder for [`SlotDefaultValue`](crate::model::SlotDefaultValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default value to use when a user doesn't provide a value for a
        /// slot.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value to use when a user doesn't provide a value for a
        /// slot.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotDefaultValue`](crate::model::SlotDefaultValue)
        pub fn build(self) -> crate::model::SlotDefaultValue {
            crate::model::SlotDefaultValue {
                default_value: self.default_value,
            }
        }
    }
}
impl SlotDefaultValue {
    /// Creates a new builder-style object to manufacture [`SlotDefaultValue`](crate::model::SlotDefaultValue)
    pub fn builder() -> crate::model::slot_default_value::Builder {
        crate::model::slot_default_value::Builder::default()
    }
}

/// <p>Provides configuration information for the AMAZON.KendraSearchIntent
/// intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra
/// index and returns documents from the index that match the user's
/// utterance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KendraConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the
    /// AMAZON.KendraSearchIntent intent to search. The index must be in the
    /// same account and Region as the Amazon Lex bot.</p>
    pub kendra_index: std::option::Option<std::string::String>,
    /// <p>Determines whether the AMAZON.KendraSearchIntent intent uses a
    /// custom query string to query the Amazon Kendra index.</p>
    pub query_filter_string_enabled: bool,
    /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from
    /// a query. The filter is in the format defined by Amazon Kendra. For more
    /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
    /// queries</a>.</p>
    pub query_filter_string: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KendraConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KendraConfiguration");
        formatter.field("kendra_index", &self.kendra_index);
        formatter.field(
            "query_filter_string_enabled",
            &self.query_filter_string_enabled,
        );
        formatter.field("query_filter_string", &self.query_filter_string);
        formatter.finish()
    }
}
/// See [`KendraConfiguration`](crate::model::KendraConfiguration)
pub mod kendra_configuration {
    /// A builder for [`KendraConfiguration`](crate::model::KendraConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kendra_index: std::option::Option<std::string::String>,
        pub(crate) query_filter_string_enabled: std::option::Option<bool>,
        pub(crate) query_filter_string: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the
        /// AMAZON.KendraSearchIntent intent to search. The index must be in the
        /// same account and Region as the Amazon Lex bot.</p>
        pub fn kendra_index(mut self, input: impl Into<std::string::String>) -> Self {
            self.kendra_index = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the
        /// AMAZON.KendraSearchIntent intent to search. The index must be in the
        /// same account and Region as the Amazon Lex bot.</p>
        pub fn set_kendra_index(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kendra_index = input;
            self
        }
        /// <p>Determines whether the AMAZON.KendraSearchIntent intent uses a
        /// custom query string to query the Amazon Kendra index.</p>
        pub fn query_filter_string_enabled(mut self, input: bool) -> Self {
            self.query_filter_string_enabled = Some(input);
            self
        }
        /// <p>Determines whether the AMAZON.KendraSearchIntent intent uses a
        /// custom query string to query the Amazon Kendra index.</p>
        pub fn set_query_filter_string_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.query_filter_string_enabled = input;
            self
        }
        /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from
        /// a query. The filter is in the format defined by Amazon Kendra. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
        /// queries</a>.</p>
        pub fn query_filter_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_filter_string = Some(input.into());
            self
        }
        /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the response from
        /// a query. The filter is in the format defined by Amazon Kendra. For more
        /// information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
        /// queries</a>.</p>
        pub fn set_query_filter_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_filter_string = input;
            self
        }
        /// Consumes the builder and constructs a [`KendraConfiguration`](crate::model::KendraConfiguration)
        pub fn build(self) -> crate::model::KendraConfiguration {
            crate::model::KendraConfiguration {
                kendra_index: self.kendra_index,
                query_filter_string_enabled: self.query_filter_string_enabled.unwrap_or_default(),
                query_filter_string: self.query_filter_string,
            }
        }
    }
}
impl KendraConfiguration {
    /// Creates a new builder-style object to manufacture [`KendraConfiguration`](crate::model::KendraConfiguration)
    pub fn builder() -> crate::model::kendra_configuration::Builder {
        crate::model::kendra_configuration::Builder::default()
    }
}

/// <p>Describes a session context that is activated when an intent is
/// fulfilled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputContext {
    /// <p>The name of the output context.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, that the output context should
    /// remain active. The time is figured from the first time the context is
    /// sent to the user.</p>
    pub time_to_live_in_seconds: std::option::Option<i32>,
    /// <p>The number of conversation turns that the output context should
    /// remain active. The number of turns is counted from the first time that
    /// the context is sent to the user.</p>
    pub turns_to_live: std::option::Option<i32>,
}
impl std::fmt::Debug for OutputContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputContext");
        formatter.field("name", &self.name);
        formatter.field("time_to_live_in_seconds", &self.time_to_live_in_seconds);
        formatter.field("turns_to_live", &self.turns_to_live);
        formatter.finish()
    }
}
/// See [`OutputContext`](crate::model::OutputContext)
pub mod output_context {
    /// A builder for [`OutputContext`](crate::model::OutputContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) time_to_live_in_seconds: std::option::Option<i32>,
        pub(crate) turns_to_live: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the output context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the output context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The amount of time, in seconds, that the output context should
        /// remain active. The time is figured from the first time the context is
        /// sent to the user.</p>
        pub fn time_to_live_in_seconds(mut self, input: i32) -> Self {
            self.time_to_live_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that the output context should
        /// remain active. The time is figured from the first time the context is
        /// sent to the user.</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live_in_seconds = input;
            self
        }
        /// <p>The number of conversation turns that the output context should
        /// remain active. The number of turns is counted from the first time that
        /// the context is sent to the user.</p>
        pub fn turns_to_live(mut self, input: i32) -> Self {
            self.turns_to_live = Some(input);
            self
        }
        /// <p>The number of conversation turns that the output context should
        /// remain active. The number of turns is counted from the first time that
        /// the context is sent to the user.</p>
        pub fn set_turns_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.turns_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputContext`](crate::model::OutputContext)
        pub fn build(self) -> crate::model::OutputContext {
            crate::model::OutputContext {
                name: self.name,
                time_to_live_in_seconds: self.time_to_live_in_seconds,
                turns_to_live: self.turns_to_live,
            }
        }
    }
}
impl OutputContext {
    /// Creates a new builder-style object to manufacture [`OutputContext`](crate::model::OutputContext)
    pub fn builder() -> crate::model::output_context::Builder {
        crate::model::output_context::Builder::default()
    }
}

/// <p>The name of a context that must be active for an intent to be
/// selected by Amazon Lex.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputContext {
    /// <p>The name of the context.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputContext");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InputContext`](crate::model::InputContext)
pub mod input_context {
    /// A builder for [`InputContext`](crate::model::InputContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InputContext`](crate::model::InputContext)
        pub fn build(self) -> crate::model::InputContext {
            crate::model::InputContext { name: self.name }
        }
    }
}
impl InputContext {
    /// Creates a new builder-style object to manufacture [`InputContext`](crate::model::InputContext)
    pub fn builder() -> crate::model::input_context::Builder {
        crate::model::input_context::Builder::default()
    }
}

/// <p>Provides a statement the Amazon Lex conveys to the user when the intent
/// is successfully fulfilled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentClosingSetting {
    /// <p>The response that Amazon Lex sends to the user when the intent is
    /// complete.</p>
    pub closing_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>Specifies whether an intent's closing response is used. When this
    /// field is false, the closing response isn't sent to the user. If the
    /// <code>active</code> field isn't specified, the default is
    /// true.</p>
    pub active: std::option::Option<bool>,
}
impl std::fmt::Debug for IntentClosingSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentClosingSetting");
        formatter.field("closing_response", &self.closing_response);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}
/// See [`IntentClosingSetting`](crate::model::IntentClosingSetting)
pub mod intent_closing_setting {
    /// A builder for [`IntentClosingSetting`](crate::model::IntentClosingSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) closing_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The response that Amazon Lex sends to the user when the intent is
        /// complete.</p>
        pub fn closing_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.closing_response = Some(input);
            self
        }
        /// <p>The response that Amazon Lex sends to the user when the intent is
        /// complete.</p>
        pub fn set_closing_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.closing_response = input;
            self
        }
        /// <p>Specifies whether an intent's closing response is used. When this
        /// field is false, the closing response isn't sent to the user. If the
        /// <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Specifies whether an intent's closing response is used. When this
        /// field is false, the closing response isn't sent to the user. If the
        /// <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentClosingSetting`](crate::model::IntentClosingSetting)
        pub fn build(self) -> crate::model::IntentClosingSetting {
            crate::model::IntentClosingSetting {
                closing_response: self.closing_response,
                active: self.active,
            }
        }
    }
}
impl IntentClosingSetting {
    /// Creates a new builder-style object to manufacture [`IntentClosingSetting`](crate::model::IntentClosingSetting)
    pub fn builder() -> crate::model::intent_closing_setting::Builder {
        crate::model::intent_closing_setting::Builder::default()
    }
}

/// <p>Provides a prompt for making sure that the user is ready for the
/// intent to be fulfilled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentConfirmationSetting {
    /// <p>Prompts the user to confirm the intent. This question should have a
    /// yes or no answer.</p>
    /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the
    /// intent is ready for fulfillment. For example, with the
    /// <code>OrderPizza</code> intent, you might want to confirm that the
    /// order is correct before placing it. For other intents, such as intents
    /// that simply respond to user questions, you might not need to ask the
    /// user for confirmation before providing the information. </p>
    pub prompt_specification: std::option::Option<crate::model::PromptSpecification>,
    /// <p>When the user answers "no" to the question defined in
    /// <code>promptSpecification</code>, Amazon Lex responds with this response
    /// to acknowledge that the intent was canceled. </p>
    pub declination_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>Specifies whether the intent's confirmation is sent to the user.
    /// When this field is false, confirmation and declination responses aren't
    /// sent. If the <code>active</code> field isn't specified, the default is
    /// true.</p>
    pub active: std::option::Option<bool>,
}
impl std::fmt::Debug for IntentConfirmationSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentConfirmationSetting");
        formatter.field("prompt_specification", &self.prompt_specification);
        formatter.field("declination_response", &self.declination_response);
        formatter.field("active", &self.active);
        formatter.finish()
    }
}
/// See [`IntentConfirmationSetting`](crate::model::IntentConfirmationSetting)
pub mod intent_confirmation_setting {
    /// A builder for [`IntentConfirmationSetting`](crate::model::IntentConfirmationSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prompt_specification: std::option::Option<crate::model::PromptSpecification>,
        pub(crate) declination_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Prompts the user to confirm the intent. This question should have a
        /// yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the
        /// intent is ready for fulfillment. For example, with the
        /// <code>OrderPizza</code> intent, you might want to confirm that the
        /// order is correct before placing it. For other intents, such as intents
        /// that simply respond to user questions, you might not need to ask the
        /// user for confirmation before providing the information. </p>
        pub fn prompt_specification(mut self, input: crate::model::PromptSpecification) -> Self {
            self.prompt_specification = Some(input);
            self
        }
        /// <p>Prompts the user to confirm the intent. This question should have a
        /// yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the
        /// intent is ready for fulfillment. For example, with the
        /// <code>OrderPizza</code> intent, you might want to confirm that the
        /// order is correct before placing it. For other intents, such as intents
        /// that simply respond to user questions, you might not need to ask the
        /// user for confirmation before providing the information. </p>
        pub fn set_prompt_specification(
            mut self,
            input: std::option::Option<crate::model::PromptSpecification>,
        ) -> Self {
            self.prompt_specification = input;
            self
        }
        /// <p>When the user answers "no" to the question defined in
        /// <code>promptSpecification</code>, Amazon Lex responds with this response
        /// to acknowledge that the intent was canceled. </p>
        pub fn declination_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.declination_response = Some(input);
            self
        }
        /// <p>When the user answers "no" to the question defined in
        /// <code>promptSpecification</code>, Amazon Lex responds with this response
        /// to acknowledge that the intent was canceled. </p>
        pub fn set_declination_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.declination_response = input;
            self
        }
        /// <p>Specifies whether the intent's confirmation is sent to the user.
        /// When this field is false, confirmation and declination responses aren't
        /// sent. If the <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Specifies whether the intent's confirmation is sent to the user.
        /// When this field is false, confirmation and declination responses aren't
        /// sent. If the <code>active</code> field isn't specified, the default is
        /// true.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentConfirmationSetting`](crate::model::IntentConfirmationSetting)
        pub fn build(self) -> crate::model::IntentConfirmationSetting {
            crate::model::IntentConfirmationSetting {
                prompt_specification: self.prompt_specification,
                declination_response: self.declination_response,
                active: self.active,
            }
        }
    }
}
impl IntentConfirmationSetting {
    /// Creates a new builder-style object to manufacture [`IntentConfirmationSetting`](crate::model::IntentConfirmationSetting)
    pub fn builder() -> crate::model::intent_confirmation_setting::Builder {
        crate::model::intent_confirmation_setting::Builder::default()
    }
}

/// <p>Sets the priority that Amazon Lex should use when eliciting slot values
/// from a user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotPriority {
    /// <p>The priority that a slot should be elicited.</p>
    pub priority: std::option::Option<i32>,
    /// <p>The unique identifier of the slot.</p>
    pub slot_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SlotPriority {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotPriority");
        formatter.field("priority", &self.priority);
        formatter.field("slot_id", &self.slot_id);
        formatter.finish()
    }
}
/// See [`SlotPriority`](crate::model::SlotPriority)
pub mod slot_priority {
    /// A builder for [`SlotPriority`](crate::model::SlotPriority)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) slot_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The priority that a slot should be elicited.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p>The priority that a slot should be elicited.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// <p>The unique identifier of the slot.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotPriority`](crate::model::SlotPriority)
        pub fn build(self) -> crate::model::SlotPriority {
            crate::model::SlotPriority {
                priority: self.priority,
                slot_id: self.slot_id,
            }
        }
    }
}
impl SlotPriority {
    /// Creates a new builder-style object to manufacture [`SlotPriority`](crate::model::SlotPriority)
    pub fn builder() -> crate::model::slot_priority::Builder {
        crate::model::slot_priority::Builder::default()
    }
}

/// <p>Determines if a Lambda function should be invoked for a specific
/// intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FulfillmentCodeHookSettings {
    /// <p>Indicates whether a Lambda function should be invoked to fulfill a
    /// specific intent.</p>
    pub enabled: bool,
    /// <p>Provides settings for messages sent to the user for after the Lambda
    /// fulfillment function completes. Post-fulfillment messages can be sent
    /// for both streaming and non-streaming conversations.</p>
    pub post_fulfillment_status_specification:
        std::option::Option<crate::model::PostFulfillmentStatusSpecification>,
    /// <p>Provides settings for update messages sent to the user for
    /// long-running Lambda fulfillment functions. Fulfillment updates can be
    /// used only with streaming conversations.</p>
    pub fulfillment_updates_specification:
        std::option::Option<crate::model::FulfillmentUpdatesSpecification>,
}
impl std::fmt::Debug for FulfillmentCodeHookSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FulfillmentCodeHookSettings");
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "post_fulfillment_status_specification",
            &self.post_fulfillment_status_specification,
        );
        formatter.field(
            "fulfillment_updates_specification",
            &self.fulfillment_updates_specification,
        );
        formatter.finish()
    }
}
/// See [`FulfillmentCodeHookSettings`](crate::model::FulfillmentCodeHookSettings)
pub mod fulfillment_code_hook_settings {
    /// A builder for [`FulfillmentCodeHookSettings`](crate::model::FulfillmentCodeHookSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) post_fulfillment_status_specification:
            std::option::Option<crate::model::PostFulfillmentStatusSpecification>,
        pub(crate) fulfillment_updates_specification:
            std::option::Option<crate::model::FulfillmentUpdatesSpecification>,
    }
    impl Builder {
        /// <p>Indicates whether a Lambda function should be invoked to fulfill a
        /// specific intent.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether a Lambda function should be invoked to fulfill a
        /// specific intent.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Provides settings for messages sent to the user for after the Lambda
        /// fulfillment function completes. Post-fulfillment messages can be sent
        /// for both streaming and non-streaming conversations.</p>
        pub fn post_fulfillment_status_specification(
            mut self,
            input: crate::model::PostFulfillmentStatusSpecification,
        ) -> Self {
            self.post_fulfillment_status_specification = Some(input);
            self
        }
        /// <p>Provides settings for messages sent to the user for after the Lambda
        /// fulfillment function completes. Post-fulfillment messages can be sent
        /// for both streaming and non-streaming conversations.</p>
        pub fn set_post_fulfillment_status_specification(
            mut self,
            input: std::option::Option<crate::model::PostFulfillmentStatusSpecification>,
        ) -> Self {
            self.post_fulfillment_status_specification = input;
            self
        }
        /// <p>Provides settings for update messages sent to the user for
        /// long-running Lambda fulfillment functions. Fulfillment updates can be
        /// used only with streaming conversations.</p>
        pub fn fulfillment_updates_specification(
            mut self,
            input: crate::model::FulfillmentUpdatesSpecification,
        ) -> Self {
            self.fulfillment_updates_specification = Some(input);
            self
        }
        /// <p>Provides settings for update messages sent to the user for
        /// long-running Lambda fulfillment functions. Fulfillment updates can be
        /// used only with streaming conversations.</p>
        pub fn set_fulfillment_updates_specification(
            mut self,
            input: std::option::Option<crate::model::FulfillmentUpdatesSpecification>,
        ) -> Self {
            self.fulfillment_updates_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`FulfillmentCodeHookSettings`](crate::model::FulfillmentCodeHookSettings)
        pub fn build(self) -> crate::model::FulfillmentCodeHookSettings {
            crate::model::FulfillmentCodeHookSettings {
                enabled: self.enabled.unwrap_or_default(),
                post_fulfillment_status_specification: self.post_fulfillment_status_specification,
                fulfillment_updates_specification: self.fulfillment_updates_specification,
            }
        }
    }
}
impl FulfillmentCodeHookSettings {
    /// Creates a new builder-style object to manufacture [`FulfillmentCodeHookSettings`](crate::model::FulfillmentCodeHookSettings)
    pub fn builder() -> crate::model::fulfillment_code_hook_settings::Builder {
        crate::model::fulfillment_code_hook_settings::Builder::default()
    }
}

/// <p>Provides information for updating the user on the progress of
/// fulfilling an intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FulfillmentUpdatesSpecification {
    /// <p>Determines whether fulfillment updates are sent to the user. When
    /// this field is true, updates are sent.</p>
    /// <p>If the <code>active</code> field is set to true, the
    /// <code>startResponse</code>, <code>updateResponse</code>, and
    /// <code>timeoutInSeconds</code> fields are required.</p>
    pub active: std::option::Option<bool>,
    /// <p>Provides configuration information for the message sent to users
    /// when the fulfillment Lambda functions starts running.</p>
    pub start_response: std::option::Option<crate::model::FulfillmentStartResponseSpecification>,
    /// <p>Provides configuration information for messages sent periodically to
    /// the user while the fulfillment Lambda function is running.</p>
    pub update_response: std::option::Option<crate::model::FulfillmentUpdateResponseSpecification>,
    /// <p>The length of time that the fulfillment Lambda function should run
    /// before it times out.</p>
    pub timeout_in_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for FulfillmentUpdatesSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FulfillmentUpdatesSpecification");
        formatter.field("active", &self.active);
        formatter.field("start_response", &self.start_response);
        formatter.field("update_response", &self.update_response);
        formatter.field("timeout_in_seconds", &self.timeout_in_seconds);
        formatter.finish()
    }
}
/// See [`FulfillmentUpdatesSpecification`](crate::model::FulfillmentUpdatesSpecification)
pub mod fulfillment_updates_specification {
    /// A builder for [`FulfillmentUpdatesSpecification`](crate::model::FulfillmentUpdatesSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active: std::option::Option<bool>,
        pub(crate) start_response:
            std::option::Option<crate::model::FulfillmentStartResponseSpecification>,
        pub(crate) update_response:
            std::option::Option<crate::model::FulfillmentUpdateResponseSpecification>,
        pub(crate) timeout_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Determines whether fulfillment updates are sent to the user. When
        /// this field is true, updates are sent.</p>
        /// <p>If the <code>active</code> field is set to true, the
        /// <code>startResponse</code>, <code>updateResponse</code>, and
        /// <code>timeoutInSeconds</code> fields are required.</p>
        pub fn active(mut self, input: bool) -> Self {
            self.active = Some(input);
            self
        }
        /// <p>Determines whether fulfillment updates are sent to the user. When
        /// this field is true, updates are sent.</p>
        /// <p>If the <code>active</code> field is set to true, the
        /// <code>startResponse</code>, <code>updateResponse</code>, and
        /// <code>timeoutInSeconds</code> fields are required.</p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.active = input;
            self
        }
        /// <p>Provides configuration information for the message sent to users
        /// when the fulfillment Lambda functions starts running.</p>
        pub fn start_response(
            mut self,
            input: crate::model::FulfillmentStartResponseSpecification,
        ) -> Self {
            self.start_response = Some(input);
            self
        }
        /// <p>Provides configuration information for the message sent to users
        /// when the fulfillment Lambda functions starts running.</p>
        pub fn set_start_response(
            mut self,
            input: std::option::Option<crate::model::FulfillmentStartResponseSpecification>,
        ) -> Self {
            self.start_response = input;
            self
        }
        /// <p>Provides configuration information for messages sent periodically to
        /// the user while the fulfillment Lambda function is running.</p>
        pub fn update_response(
            mut self,
            input: crate::model::FulfillmentUpdateResponseSpecification,
        ) -> Self {
            self.update_response = Some(input);
            self
        }
        /// <p>Provides configuration information for messages sent periodically to
        /// the user while the fulfillment Lambda function is running.</p>
        pub fn set_update_response(
            mut self,
            input: std::option::Option<crate::model::FulfillmentUpdateResponseSpecification>,
        ) -> Self {
            self.update_response = input;
            self
        }
        /// <p>The length of time that the fulfillment Lambda function should run
        /// before it times out.</p>
        pub fn timeout_in_seconds(mut self, input: i32) -> Self {
            self.timeout_in_seconds = Some(input);
            self
        }
        /// <p>The length of time that the fulfillment Lambda function should run
        /// before it times out.</p>
        pub fn set_timeout_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`FulfillmentUpdatesSpecification`](crate::model::FulfillmentUpdatesSpecification)
        pub fn build(self) -> crate::model::FulfillmentUpdatesSpecification {
            crate::model::FulfillmentUpdatesSpecification {
                active: self.active,
                start_response: self.start_response,
                update_response: self.update_response,
                timeout_in_seconds: self.timeout_in_seconds,
            }
        }
    }
}
impl FulfillmentUpdatesSpecification {
    /// Creates a new builder-style object to manufacture [`FulfillmentUpdatesSpecification`](crate::model::FulfillmentUpdatesSpecification)
    pub fn builder() -> crate::model::fulfillment_updates_specification::Builder {
        crate::model::fulfillment_updates_specification::Builder::default()
    }
}

/// <p>Provides settings for a message that is sent periodically to the
/// user while a fulfillment Lambda function is running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FulfillmentUpdateResponseSpecification {
    /// <p>The frequency that a message is sent to the user. When the period
    /// ends, Amazon Lex chooses a message from the message groups and plays it to
    /// the user. If the fulfillment Lambda returns before the first period
    /// ends, an update message is not played to the user.</p>
    pub frequency_in_seconds: std::option::Option<i32>,
    /// <p>One to 5 message groups that contain update messages. Amazon Lex chooses
    /// one of the messages to play to the user.</p>
    pub message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
    /// <p>Determines whether the user can interrupt an update message while it
    /// is playing.</p>
    pub allow_interrupt: std::option::Option<bool>,
}
impl std::fmt::Debug for FulfillmentUpdateResponseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FulfillmentUpdateResponseSpecification");
        formatter.field("frequency_in_seconds", &self.frequency_in_seconds);
        formatter.field("message_groups", &self.message_groups);
        formatter.field("allow_interrupt", &self.allow_interrupt);
        formatter.finish()
    }
}
/// See [`FulfillmentUpdateResponseSpecification`](crate::model::FulfillmentUpdateResponseSpecification)
pub mod fulfillment_update_response_specification {
    /// A builder for [`FulfillmentUpdateResponseSpecification`](crate::model::FulfillmentUpdateResponseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frequency_in_seconds: std::option::Option<i32>,
        pub(crate) message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        pub(crate) allow_interrupt: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The frequency that a message is sent to the user. When the period
        /// ends, Amazon Lex chooses a message from the message groups and plays it to
        /// the user. If the fulfillment Lambda returns before the first period
        /// ends, an update message is not played to the user.</p>
        pub fn frequency_in_seconds(mut self, input: i32) -> Self {
            self.frequency_in_seconds = Some(input);
            self
        }
        /// <p>The frequency that a message is sent to the user. When the period
        /// ends, Amazon Lex chooses a message from the message groups and plays it to
        /// the user. If the fulfillment Lambda returns before the first period
        /// ends, an update message is not played to the user.</p>
        pub fn set_frequency_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.frequency_in_seconds = input;
            self
        }
        /// Appends an item to `message_groups`.
        ///
        /// To override the contents of this collection use [`set_message_groups`](Self::set_message_groups).
        ///
        /// <p>One to 5 message groups that contain update messages. Amazon Lex chooses
        /// one of the messages to play to the user.</p>
        pub fn message_groups(mut self, input: impl Into<crate::model::MessageGroup>) -> Self {
            let mut v = self.message_groups.unwrap_or_default();
            v.push(input.into());
            self.message_groups = Some(v);
            self
        }
        /// <p>One to 5 message groups that contain update messages. Amazon Lex chooses
        /// one of the messages to play to the user.</p>
        pub fn set_message_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        ) -> Self {
            self.message_groups = input;
            self
        }
        /// <p>Determines whether the user can interrupt an update message while it
        /// is playing.</p>
        pub fn allow_interrupt(mut self, input: bool) -> Self {
            self.allow_interrupt = Some(input);
            self
        }
        /// <p>Determines whether the user can interrupt an update message while it
        /// is playing.</p>
        pub fn set_allow_interrupt(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_interrupt = input;
            self
        }
        /// Consumes the builder and constructs a [`FulfillmentUpdateResponseSpecification`](crate::model::FulfillmentUpdateResponseSpecification)
        pub fn build(self) -> crate::model::FulfillmentUpdateResponseSpecification {
            crate::model::FulfillmentUpdateResponseSpecification {
                frequency_in_seconds: self.frequency_in_seconds,
                message_groups: self.message_groups,
                allow_interrupt: self.allow_interrupt,
            }
        }
    }
}
impl FulfillmentUpdateResponseSpecification {
    /// Creates a new builder-style object to manufacture [`FulfillmentUpdateResponseSpecification`](crate::model::FulfillmentUpdateResponseSpecification)
    pub fn builder() -> crate::model::fulfillment_update_response_specification::Builder {
        crate::model::fulfillment_update_response_specification::Builder::default()
    }
}

/// <p>Provides settings for a message that is sent to the user when a
/// fulfillment Lambda function starts running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FulfillmentStartResponseSpecification {
    /// <p>The delay between when the Lambda fulfillment function starts running
    /// and the start message is played. If the Lambda function returns before
    /// the delay is over, the start message isn't played.</p>
    pub delay_in_seconds: std::option::Option<i32>,
    /// <p>One to 5 message groups that contain start messages. Amazon Lex chooses
    /// one of the messages to play to the user.</p>
    pub message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
    /// <p>Determines whether the user can interrupt the start message while it
    /// is playing.</p>
    pub allow_interrupt: std::option::Option<bool>,
}
impl std::fmt::Debug for FulfillmentStartResponseSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FulfillmentStartResponseSpecification");
        formatter.field("delay_in_seconds", &self.delay_in_seconds);
        formatter.field("message_groups", &self.message_groups);
        formatter.field("allow_interrupt", &self.allow_interrupt);
        formatter.finish()
    }
}
/// See [`FulfillmentStartResponseSpecification`](crate::model::FulfillmentStartResponseSpecification)
pub mod fulfillment_start_response_specification {
    /// A builder for [`FulfillmentStartResponseSpecification`](crate::model::FulfillmentStartResponseSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delay_in_seconds: std::option::Option<i32>,
        pub(crate) message_groups: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        pub(crate) allow_interrupt: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The delay between when the Lambda fulfillment function starts running
        /// and the start message is played. If the Lambda function returns before
        /// the delay is over, the start message isn't played.</p>
        pub fn delay_in_seconds(mut self, input: i32) -> Self {
            self.delay_in_seconds = Some(input);
            self
        }
        /// <p>The delay between when the Lambda fulfillment function starts running
        /// and the start message is played. If the Lambda function returns before
        /// the delay is over, the start message isn't played.</p>
        pub fn set_delay_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.delay_in_seconds = input;
            self
        }
        /// Appends an item to `message_groups`.
        ///
        /// To override the contents of this collection use [`set_message_groups`](Self::set_message_groups).
        ///
        /// <p>One to 5 message groups that contain start messages. Amazon Lex chooses
        /// one of the messages to play to the user.</p>
        pub fn message_groups(mut self, input: impl Into<crate::model::MessageGroup>) -> Self {
            let mut v = self.message_groups.unwrap_or_default();
            v.push(input.into());
            self.message_groups = Some(v);
            self
        }
        /// <p>One to 5 message groups that contain start messages. Amazon Lex chooses
        /// one of the messages to play to the user.</p>
        pub fn set_message_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageGroup>>,
        ) -> Self {
            self.message_groups = input;
            self
        }
        /// <p>Determines whether the user can interrupt the start message while it
        /// is playing.</p>
        pub fn allow_interrupt(mut self, input: bool) -> Self {
            self.allow_interrupt = Some(input);
            self
        }
        /// <p>Determines whether the user can interrupt the start message while it
        /// is playing.</p>
        pub fn set_allow_interrupt(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_interrupt = input;
            self
        }
        /// Consumes the builder and constructs a [`FulfillmentStartResponseSpecification`](crate::model::FulfillmentStartResponseSpecification)
        pub fn build(self) -> crate::model::FulfillmentStartResponseSpecification {
            crate::model::FulfillmentStartResponseSpecification {
                delay_in_seconds: self.delay_in_seconds,
                message_groups: self.message_groups,
                allow_interrupt: self.allow_interrupt,
            }
        }
    }
}
impl FulfillmentStartResponseSpecification {
    /// Creates a new builder-style object to manufacture [`FulfillmentStartResponseSpecification`](crate::model::FulfillmentStartResponseSpecification)
    pub fn builder() -> crate::model::fulfillment_start_response_specification::Builder {
        crate::model::fulfillment_start_response_specification::Builder::default()
    }
}

/// <p>Provides a setting that determines whether the post-fulfillment
/// response is sent to the user. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete">https://docs.aws.amazon.com/lexv2/latest/dg/streaming-progress.html#progress-complete</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostFulfillmentStatusSpecification {
    /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
    /// user input.</p>
    pub success_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
    /// user input.</p>
    pub failure_response: std::option::Option<crate::model::ResponseSpecification>,
    /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
    /// user input.</p>
    pub timeout_response: std::option::Option<crate::model::ResponseSpecification>,
}
impl std::fmt::Debug for PostFulfillmentStatusSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostFulfillmentStatusSpecification");
        formatter.field("success_response", &self.success_response);
        formatter.field("failure_response", &self.failure_response);
        formatter.field("timeout_response", &self.timeout_response);
        formatter.finish()
    }
}
/// See [`PostFulfillmentStatusSpecification`](crate::model::PostFulfillmentStatusSpecification)
pub mod post_fulfillment_status_specification {
    /// A builder for [`PostFulfillmentStatusSpecification`](crate::model::PostFulfillmentStatusSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) success_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) failure_response: std::option::Option<crate::model::ResponseSpecification>,
        pub(crate) timeout_response: std::option::Option<crate::model::ResponseSpecification>,
    }
    impl Builder {
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn success_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.success_response = Some(input);
            self
        }
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn set_success_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.success_response = input;
            self
        }
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn failure_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.failure_response = Some(input);
            self
        }
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn set_failure_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.failure_response = input;
            self
        }
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn timeout_response(mut self, input: crate::model::ResponseSpecification) -> Self {
            self.timeout_response = Some(input);
            self
        }
        /// <p>Specifies a list of message groups that Amazon Lex uses to respond the
        /// user input.</p>
        pub fn set_timeout_response(
            mut self,
            input: std::option::Option<crate::model::ResponseSpecification>,
        ) -> Self {
            self.timeout_response = input;
            self
        }
        /// Consumes the builder and constructs a [`PostFulfillmentStatusSpecification`](crate::model::PostFulfillmentStatusSpecification)
        pub fn build(self) -> crate::model::PostFulfillmentStatusSpecification {
            crate::model::PostFulfillmentStatusSpecification {
                success_response: self.success_response,
                failure_response: self.failure_response,
                timeout_response: self.timeout_response,
            }
        }
    }
}
impl PostFulfillmentStatusSpecification {
    /// Creates a new builder-style object to manufacture [`PostFulfillmentStatusSpecification`](crate::model::PostFulfillmentStatusSpecification)
    pub fn builder() -> crate::model::post_fulfillment_status_specification::Builder {
        crate::model::post_fulfillment_status_specification::Builder::default()
    }
}

/// <p>Settings that determine the Lambda function that Amazon Lex uses for
/// processing user responses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DialogCodeHookSettings {
    /// <p>Enables the dialog code hook so that it processes user
    /// requests.</p>
    pub enabled: bool,
}
impl std::fmt::Debug for DialogCodeHookSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DialogCodeHookSettings");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`DialogCodeHookSettings`](crate::model::DialogCodeHookSettings)
pub mod dialog_code_hook_settings {
    /// A builder for [`DialogCodeHookSettings`](crate::model::DialogCodeHookSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Enables the dialog code hook so that it processes user
        /// requests.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Enables the dialog code hook so that it processes user
        /// requests.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`DialogCodeHookSettings`](crate::model::DialogCodeHookSettings)
        pub fn build(self) -> crate::model::DialogCodeHookSettings {
            crate::model::DialogCodeHookSettings {
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl DialogCodeHookSettings {
    /// Creates a new builder-style object to manufacture [`DialogCodeHookSettings`](crate::model::DialogCodeHookSettings)
    pub fn builder() -> crate::model::dialog_code_hook_settings::Builder {
        crate::model::dialog_code_hook_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ExportStatus::Completed,
            "Deleting" => ExportStatus::Deleting,
            "Failed" => ExportStatus::Failed,
            "InProgress" => ExportStatus::InProgress,
            other => ExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportStatus::from(s))
    }
}
impl ExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportStatus::Completed => "Completed",
            ExportStatus::Deleting => "Deleting",
            ExportStatus::Failed => "Failed",
            ExportStatus::InProgress => "InProgress",
            ExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Deleting", "Failed", "InProgress"]
    }
}
impl AsRef<str> for ExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportExportFileFormat {
    #[allow(missing_docs)] // documentation missing in model
    LexJson,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportExportFileFormat {
    fn from(s: &str) -> Self {
        match s {
            "LexJson" => ImportExportFileFormat::LexJson,
            other => ImportExportFileFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportExportFileFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportExportFileFormat::from(s))
    }
}
impl ImportExportFileFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportExportFileFormat::LexJson => "LexJson",
            ImportExportFileFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LexJson"]
    }
}
impl AsRef<str> for ImportExportFileFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the bot or bot locale that you want to
/// export. You can specify the <code>botExportSpecification</code> or the
/// <code>botLocaleExportSpecification</code>, but not both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportResourceSpecification {
    /// <p>Parameters for exporting a bot.</p>
    pub bot_export_specification: std::option::Option<crate::model::BotExportSpecification>,
    /// <p>Parameters for exporting a bot locale.</p>
    pub bot_locale_export_specification:
        std::option::Option<crate::model::BotLocaleExportSpecification>,
}
impl std::fmt::Debug for ExportResourceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportResourceSpecification");
        formatter.field("bot_export_specification", &self.bot_export_specification);
        formatter.field(
            "bot_locale_export_specification",
            &self.bot_locale_export_specification,
        );
        formatter.finish()
    }
}
/// See [`ExportResourceSpecification`](crate::model::ExportResourceSpecification)
pub mod export_resource_specification {
    /// A builder for [`ExportResourceSpecification`](crate::model::ExportResourceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_export_specification:
            std::option::Option<crate::model::BotExportSpecification>,
        pub(crate) bot_locale_export_specification:
            std::option::Option<crate::model::BotLocaleExportSpecification>,
    }
    impl Builder {
        /// <p>Parameters for exporting a bot.</p>
        pub fn bot_export_specification(
            mut self,
            input: crate::model::BotExportSpecification,
        ) -> Self {
            self.bot_export_specification = Some(input);
            self
        }
        /// <p>Parameters for exporting a bot.</p>
        pub fn set_bot_export_specification(
            mut self,
            input: std::option::Option<crate::model::BotExportSpecification>,
        ) -> Self {
            self.bot_export_specification = input;
            self
        }
        /// <p>Parameters for exporting a bot locale.</p>
        pub fn bot_locale_export_specification(
            mut self,
            input: crate::model::BotLocaleExportSpecification,
        ) -> Self {
            self.bot_locale_export_specification = Some(input);
            self
        }
        /// <p>Parameters for exporting a bot locale.</p>
        pub fn set_bot_locale_export_specification(
            mut self,
            input: std::option::Option<crate::model::BotLocaleExportSpecification>,
        ) -> Self {
            self.bot_locale_export_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportResourceSpecification`](crate::model::ExportResourceSpecification)
        pub fn build(self) -> crate::model::ExportResourceSpecification {
            crate::model::ExportResourceSpecification {
                bot_export_specification: self.bot_export_specification,
                bot_locale_export_specification: self.bot_locale_export_specification,
            }
        }
    }
}
impl ExportResourceSpecification {
    /// Creates a new builder-style object to manufacture [`ExportResourceSpecification`](crate::model::ExportResourceSpecification)
    pub fn builder() -> crate::model::export_resource_specification::Builder {
        crate::model::export_resource_specification::Builder::default()
    }
}

/// <p>Provides the bot locale parameters required for exporting a bot
/// locale.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleExportSpecification {
    /// <p>The identifier of the bot to create the locale for.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to export.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale to export. The string must
    /// match one of the locales in the bot.</p>
    pub locale_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BotLocaleExportSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleExportSpecification");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.finish()
    }
}
/// See [`BotLocaleExportSpecification`](crate::model::BotLocaleExportSpecification)
pub mod bot_locale_export_specification {
    /// A builder for [`BotLocaleExportSpecification`](crate::model::BotLocaleExportSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to create the locale for.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale to export. The string must
        /// match one of the locales in the bot.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale to export. The string must
        /// match one of the locales in the bot.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleExportSpecification`](crate::model::BotLocaleExportSpecification)
        pub fn build(self) -> crate::model::BotLocaleExportSpecification {
            crate::model::BotLocaleExportSpecification {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
            }
        }
    }
}
impl BotLocaleExportSpecification {
    /// Creates a new builder-style object to manufacture [`BotLocaleExportSpecification`](crate::model::BotLocaleExportSpecification)
    pub fn builder() -> crate::model::bot_locale_export_specification::Builder {
        crate::model::bot_locale_export_specification::Builder::default()
    }
}

/// <p>Provides the identity of a the bot that was exported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotExportSpecification {
    /// <p>The identifier of the bot assigned by Amazon Lex.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot that was exported. This will be either
    /// <code>DRAFT</code> or the version number.</p>
    pub bot_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BotExportSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotExportSpecification");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.finish()
    }
}
/// See [`BotExportSpecification`](crate::model::BotExportSpecification)
pub mod bot_export_specification {
    /// A builder for [`BotExportSpecification`](crate::model::BotExportSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the bot assigned by Amazon Lex.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot assigned by Amazon Lex.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot that was exported. This will be either
        /// <code>DRAFT</code> or the version number.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that was exported. This will be either
        /// <code>DRAFT</code> or the version number.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Consumes the builder and constructs a [`BotExportSpecification`](crate::model::BotExportSpecification)
        pub fn build(self) -> crate::model::BotExportSpecification {
            crate::model::BotExportSpecification {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
            }
        }
    }
}
impl BotExportSpecification {
    /// Creates a new builder-style object to manufacture [`BotExportSpecification`](crate::model::BotExportSpecification)
    pub fn builder() -> crate::model::bot_export_specification::Builder {
        crate::model::bot_export_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotLocaleStatus {
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Built,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Importing,
    #[allow(missing_docs)] // documentation missing in model
    NotBuilt,
    #[allow(missing_docs)] // documentation missing in model
    ReadyExpressTesting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotLocaleStatus {
    fn from(s: &str) -> Self {
        match s {
            "Building" => BotLocaleStatus::Building,
            "Built" => BotLocaleStatus::Built,
            "Creating" => BotLocaleStatus::Creating,
            "Deleting" => BotLocaleStatus::Deleting,
            "Failed" => BotLocaleStatus::Failed,
            "Importing" => BotLocaleStatus::Importing,
            "NotBuilt" => BotLocaleStatus::NotBuilt,
            "ReadyExpressTesting" => BotLocaleStatus::ReadyExpressTesting,
            other => BotLocaleStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotLocaleStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotLocaleStatus::from(s))
    }
}
impl BotLocaleStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotLocaleStatus::Building => "Building",
            BotLocaleStatus::Built => "Built",
            BotLocaleStatus::Creating => "Creating",
            BotLocaleStatus::Deleting => "Deleting",
            BotLocaleStatus::Failed => "Failed",
            BotLocaleStatus::Importing => "Importing",
            BotLocaleStatus::NotBuilt => "NotBuilt",
            BotLocaleStatus::ReadyExpressTesting => "ReadyExpressTesting",
            BotLocaleStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Building",
            "Built",
            "Creating",
            "Deleting",
            "Failed",
            "Importing",
            "NotBuilt",
            "ReadyExpressTesting",
        ]
    }
}
impl AsRef<str> for BotLocaleStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Defines settings for using an Amazon Polly voice to communicate with a
/// user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoiceSettings {
    /// <p>The identifier of the Amazon Polly voice to use.</p>
    pub voice_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VoiceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoiceSettings");
        formatter.field("voice_id", &self.voice_id);
        formatter.finish()
    }
}
/// See [`VoiceSettings`](crate::model::VoiceSettings)
pub mod voice_settings {
    /// A builder for [`VoiceSettings`](crate::model::VoiceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) voice_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Polly voice to use.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Polly voice to use.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VoiceSettings`](crate::model::VoiceSettings)
        pub fn build(self) -> crate::model::VoiceSettings {
            crate::model::VoiceSettings {
                voice_id: self.voice_id,
            }
        }
    }
}
impl VoiceSettings {
    /// Creates a new builder-style object to manufacture [`VoiceSettings`](crate::model::VoiceSettings)
    pub fn builder() -> crate::model::voice_settings::Builder {
        crate::model::voice_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotAliasStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotAliasStatus {
    fn from(s: &str) -> Self {
        match s {
            "Available" => BotAliasStatus::Available,
            "Creating" => BotAliasStatus::Creating,
            "Deleting" => BotAliasStatus::Deleting,
            "Failed" => BotAliasStatus::Failed,
            other => BotAliasStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotAliasStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotAliasStatus::from(s))
    }
}
impl BotAliasStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotAliasStatus::Available => "Available",
            BotAliasStatus::Creating => "Creating",
            BotAliasStatus::Deleting => "Deleting",
            BotAliasStatus::Failed => "Failed",
            BotAliasStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Available", "Creating", "Deleting", "Failed"]
    }
}
impl AsRef<str> for BotAliasStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Determines whether Amazon Lex will use Amazon Comprehend to detect the sentiment of
/// user utterances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SentimentAnalysisSettings {
    /// <p>Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user
    /// utterances.</p>
    pub detect_sentiment: bool,
}
impl std::fmt::Debug for SentimentAnalysisSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SentimentAnalysisSettings");
        formatter.field("detect_sentiment", &self.detect_sentiment);
        formatter.finish()
    }
}
/// See [`SentimentAnalysisSettings`](crate::model::SentimentAnalysisSettings)
pub mod sentiment_analysis_settings {
    /// A builder for [`SentimentAnalysisSettings`](crate::model::SentimentAnalysisSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detect_sentiment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user
        /// utterances.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.detect_sentiment = Some(input);
            self
        }
        /// <p>Sets whether Amazon Lex uses Amazon Comprehend to detect the sentiment of user
        /// utterances.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.detect_sentiment = input;
            self
        }
        /// Consumes the builder and constructs a [`SentimentAnalysisSettings`](crate::model::SentimentAnalysisSettings)
        pub fn build(self) -> crate::model::SentimentAnalysisSettings {
            crate::model::SentimentAnalysisSettings {
                detect_sentiment: self.detect_sentiment.unwrap_or_default(),
            }
        }
    }
}
impl SentimentAnalysisSettings {
    /// Creates a new builder-style object to manufacture [`SentimentAnalysisSettings`](crate::model::SentimentAnalysisSettings)
    pub fn builder() -> crate::model::sentiment_analysis_settings::Builder {
        crate::model::sentiment_analysis_settings::Builder::default()
    }
}

/// <p>Configures conversation logging that saves audio, text, and metadata
/// for the conversations with your users.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConversationLogSettings {
    /// <p>The Amazon CloudWatch Logs settings for logging text and metadata.</p>
    pub text_log_settings: std::option::Option<std::vec::Vec<crate::model::TextLogSetting>>,
    /// <p>The Amazon S3 settings for logging audio to an S3 bucket.</p>
    pub audio_log_settings: std::option::Option<std::vec::Vec<crate::model::AudioLogSetting>>,
}
impl std::fmt::Debug for ConversationLogSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConversationLogSettings");
        formatter.field("text_log_settings", &self.text_log_settings);
        formatter.field("audio_log_settings", &self.audio_log_settings);
        formatter.finish()
    }
}
/// See [`ConversationLogSettings`](crate::model::ConversationLogSettings)
pub mod conversation_log_settings {
    /// A builder for [`ConversationLogSettings`](crate::model::ConversationLogSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text_log_settings:
            std::option::Option<std::vec::Vec<crate::model::TextLogSetting>>,
        pub(crate) audio_log_settings:
            std::option::Option<std::vec::Vec<crate::model::AudioLogSetting>>,
    }
    impl Builder {
        /// Appends an item to `text_log_settings`.
        ///
        /// To override the contents of this collection use [`set_text_log_settings`](Self::set_text_log_settings).
        ///
        /// <p>The Amazon CloudWatch Logs settings for logging text and metadata.</p>
        pub fn text_log_settings(mut self, input: impl Into<crate::model::TextLogSetting>) -> Self {
            let mut v = self.text_log_settings.unwrap_or_default();
            v.push(input.into());
            self.text_log_settings = Some(v);
            self
        }
        /// <p>The Amazon CloudWatch Logs settings for logging text and metadata.</p>
        pub fn set_text_log_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TextLogSetting>>,
        ) -> Self {
            self.text_log_settings = input;
            self
        }
        /// Appends an item to `audio_log_settings`.
        ///
        /// To override the contents of this collection use [`set_audio_log_settings`](Self::set_audio_log_settings).
        ///
        /// <p>The Amazon S3 settings for logging audio to an S3 bucket.</p>
        pub fn audio_log_settings(
            mut self,
            input: impl Into<crate::model::AudioLogSetting>,
        ) -> Self {
            let mut v = self.audio_log_settings.unwrap_or_default();
            v.push(input.into());
            self.audio_log_settings = Some(v);
            self
        }
        /// <p>The Amazon S3 settings for logging audio to an S3 bucket.</p>
        pub fn set_audio_log_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AudioLogSetting>>,
        ) -> Self {
            self.audio_log_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ConversationLogSettings`](crate::model::ConversationLogSettings)
        pub fn build(self) -> crate::model::ConversationLogSettings {
            crate::model::ConversationLogSettings {
                text_log_settings: self.text_log_settings,
                audio_log_settings: self.audio_log_settings,
            }
        }
    }
}
impl ConversationLogSettings {
    /// Creates a new builder-style object to manufacture [`ConversationLogSettings`](crate::model::ConversationLogSettings)
    pub fn builder() -> crate::model::conversation_log_settings::Builder {
        crate::model::conversation_log_settings::Builder::default()
    }
}

/// <p>Settings for logging audio of conversations between Amazon Lex and a
/// user. You specify whether to log audio and the Amazon S3 bucket where
/// the audio file is stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioLogSetting {
    /// <p>Determines whether audio logging in enabled for the bot.</p>
    pub enabled: bool,
    /// <p>The location of audio log files collected when conversation logging
    /// is enabled for a bot.</p>
    pub destination: std::option::Option<crate::model::AudioLogDestination>,
}
impl std::fmt::Debug for AudioLogSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioLogSetting");
        formatter.field("enabled", &self.enabled);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`AudioLogSetting`](crate::model::AudioLogSetting)
pub mod audio_log_setting {
    /// A builder for [`AudioLogSetting`](crate::model::AudioLogSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) destination: std::option::Option<crate::model::AudioLogDestination>,
    }
    impl Builder {
        /// <p>Determines whether audio logging in enabled for the bot.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Determines whether audio logging in enabled for the bot.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The location of audio log files collected when conversation logging
        /// is enabled for a bot.</p>
        pub fn destination(mut self, input: crate::model::AudioLogDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The location of audio log files collected when conversation logging
        /// is enabled for a bot.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::AudioLogDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioLogSetting`](crate::model::AudioLogSetting)
        pub fn build(self) -> crate::model::AudioLogSetting {
            crate::model::AudioLogSetting {
                enabled: self.enabled.unwrap_or_default(),
                destination: self.destination,
            }
        }
    }
}
impl AudioLogSetting {
    /// Creates a new builder-style object to manufacture [`AudioLogSetting`](crate::model::AudioLogSetting)
    pub fn builder() -> crate::model::audio_log_setting::Builder {
        crate::model::audio_log_setting::Builder::default()
    }
}

/// <p>The location of audio log files collected when conversation logging
/// is enabled for a bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioLogDestination {
    /// <p>The Amazon S3 bucket where the audio log files are stored. The IAM
    /// role specified in the <code>roleArn</code> parameter of the <a>CreateBot</a> operation must have permission to write to
    /// this bucket.</p>
    pub s3_bucket: std::option::Option<crate::model::S3BucketLogDestination>,
}
impl std::fmt::Debug for AudioLogDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioLogDestination");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.finish()
    }
}
/// See [`AudioLogDestination`](crate::model::AudioLogDestination)
pub mod audio_log_destination {
    /// A builder for [`AudioLogDestination`](crate::model::AudioLogDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<crate::model::S3BucketLogDestination>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket where the audio log files are stored. The IAM
        /// role specified in the <code>roleArn</code> parameter of the <a>CreateBot</a> operation must have permission to write to
        /// this bucket.</p>
        pub fn s3_bucket(mut self, input: crate::model::S3BucketLogDestination) -> Self {
            self.s3_bucket = Some(input);
            self
        }
        /// <p>The Amazon S3 bucket where the audio log files are stored. The IAM
        /// role specified in the <code>roleArn</code> parameter of the <a>CreateBot</a> operation must have permission to write to
        /// this bucket.</p>
        pub fn set_s3_bucket(
            mut self,
            input: std::option::Option<crate::model::S3BucketLogDestination>,
        ) -> Self {
            self.s3_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioLogDestination`](crate::model::AudioLogDestination)
        pub fn build(self) -> crate::model::AudioLogDestination {
            crate::model::AudioLogDestination {
                s3_bucket: self.s3_bucket,
            }
        }
    }
}
impl AudioLogDestination {
    /// Creates a new builder-style object to manufacture [`AudioLogDestination`](crate::model::AudioLogDestination)
    pub fn builder() -> crate::model::audio_log_destination::Builder {
        crate::model::audio_log_destination::Builder::default()
    }
}

/// <p>Specifies an Amazon S3 bucket for logging audio conversations</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketLogDestination {
    /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service
    /// (KMS) key for encrypting audio log files stored in an S3 bucket.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio
    /// log files are stored.</p>
    pub s3_bucket_arn: std::option::Option<std::string::String>,
    /// <p>The S3 prefix to assign to audio log files.</p>
    pub log_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3BucketLogDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketLogDestination");
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("s3_bucket_arn", &self.s3_bucket_arn);
        formatter.field("log_prefix", &self.log_prefix);
        formatter.finish()
    }
}
/// See [`S3BucketLogDestination`](crate::model::S3BucketLogDestination)
pub mod s3_bucket_log_destination {
    /// A builder for [`S3BucketLogDestination`](crate::model::S3BucketLogDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_arn: std::option::Option<std::string::String>,
        pub(crate) log_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service
        /// (KMS) key for encrypting audio log files stored in an S3 bucket.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS Key Management Service
        /// (KMS) key for encrypting audio log files stored in an S3 bucket.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio
        /// log files are stored.</p>
        pub fn s3_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio
        /// log files are stored.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_arn = input;
            self
        }
        /// <p>The S3 prefix to assign to audio log files.</p>
        pub fn log_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_prefix = Some(input.into());
            self
        }
        /// <p>The S3 prefix to assign to audio log files.</p>
        pub fn set_log_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketLogDestination`](crate::model::S3BucketLogDestination)
        pub fn build(self) -> crate::model::S3BucketLogDestination {
            crate::model::S3BucketLogDestination {
                kms_key_arn: self.kms_key_arn,
                s3_bucket_arn: self.s3_bucket_arn,
                log_prefix: self.log_prefix,
            }
        }
    }
}
impl S3BucketLogDestination {
    /// Creates a new builder-style object to manufacture [`S3BucketLogDestination`](crate::model::S3BucketLogDestination)
    pub fn builder() -> crate::model::s3_bucket_log_destination::Builder {
        crate::model::s3_bucket_log_destination::Builder::default()
    }
}

/// <p>Defines settings to enable text conversation logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextLogSetting {
    /// <p>Determines whether conversation logs should be stored for an
    /// alias.</p>
    pub enabled: bool,
    /// <p>Defines the Amazon CloudWatch Logs destination log group for
    /// conversation text logs.</p>
    pub destination: std::option::Option<crate::model::TextLogDestination>,
}
impl std::fmt::Debug for TextLogSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextLogSetting");
        formatter.field("enabled", &self.enabled);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`TextLogSetting`](crate::model::TextLogSetting)
pub mod text_log_setting {
    /// A builder for [`TextLogSetting`](crate::model::TextLogSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) destination: std::option::Option<crate::model::TextLogDestination>,
    }
    impl Builder {
        /// <p>Determines whether conversation logs should be stored for an
        /// alias.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Determines whether conversation logs should be stored for an
        /// alias.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Defines the Amazon CloudWatch Logs destination log group for
        /// conversation text logs.</p>
        pub fn destination(mut self, input: crate::model::TextLogDestination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Defines the Amazon CloudWatch Logs destination log group for
        /// conversation text logs.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::TextLogDestination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`TextLogSetting`](crate::model::TextLogSetting)
        pub fn build(self) -> crate::model::TextLogSetting {
            crate::model::TextLogSetting {
                enabled: self.enabled.unwrap_or_default(),
                destination: self.destination,
            }
        }
    }
}
impl TextLogSetting {
    /// Creates a new builder-style object to manufacture [`TextLogSetting`](crate::model::TextLogSetting)
    pub fn builder() -> crate::model::text_log_setting::Builder {
        crate::model::text_log_setting::Builder::default()
    }
}

/// <p>Defines the Amazon CloudWatch Logs destination log group for
/// conversation text logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TextLogDestination {
    /// <p>Defines the Amazon CloudWatch Logs log group where text and metadata logs are
    /// delivered.</p>
    pub cloud_watch: std::option::Option<crate::model::CloudWatchLogGroupLogDestination>,
}
impl std::fmt::Debug for TextLogDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TextLogDestination");
        formatter.field("cloud_watch", &self.cloud_watch);
        formatter.finish()
    }
}
/// See [`TextLogDestination`](crate::model::TextLogDestination)
pub mod text_log_destination {
    /// A builder for [`TextLogDestination`](crate::model::TextLogDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch: std::option::Option<crate::model::CloudWatchLogGroupLogDestination>,
    }
    impl Builder {
        /// <p>Defines the Amazon CloudWatch Logs log group where text and metadata logs are
        /// delivered.</p>
        pub fn cloud_watch(
            mut self,
            input: crate::model::CloudWatchLogGroupLogDestination,
        ) -> Self {
            self.cloud_watch = Some(input);
            self
        }
        /// <p>Defines the Amazon CloudWatch Logs log group where text and metadata logs are
        /// delivered.</p>
        pub fn set_cloud_watch(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogGroupLogDestination>,
        ) -> Self {
            self.cloud_watch = input;
            self
        }
        /// Consumes the builder and constructs a [`TextLogDestination`](crate::model::TextLogDestination)
        pub fn build(self) -> crate::model::TextLogDestination {
            crate::model::TextLogDestination {
                cloud_watch: self.cloud_watch,
            }
        }
    }
}
impl TextLogDestination {
    /// Creates a new builder-style object to manufacture [`TextLogDestination`](crate::model::TextLogDestination)
    pub fn builder() -> crate::model::text_log_destination::Builder {
        crate::model::text_log_destination::Builder::default()
    }
}

/// <p>The Amazon CloudWatch Logs log group where the text and metadata logs are
/// delivered. The log group must exist before you enable logging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogGroupLogDestination {
    /// <p>The Amazon Resource Name (ARN) of the log group where text and
    /// metadata logs are delivered.</p>
    pub cloud_watch_log_group_arn: std::option::Option<std::string::String>,
    /// <p>The prefix of the log stream name within the log group that you
    /// specified </p>
    pub log_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudWatchLogGroupLogDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogGroupLogDestination");
        formatter.field("cloud_watch_log_group_arn", &self.cloud_watch_log_group_arn);
        formatter.field("log_prefix", &self.log_prefix);
        formatter.finish()
    }
}
/// See [`CloudWatchLogGroupLogDestination`](crate::model::CloudWatchLogGroupLogDestination)
pub mod cloud_watch_log_group_log_destination {
    /// A builder for [`CloudWatchLogGroupLogDestination`](crate::model::CloudWatchLogGroupLogDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_log_group_arn: std::option::Option<std::string::String>,
        pub(crate) log_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the log group where text and
        /// metadata logs are delivered.</p>
        pub fn cloud_watch_log_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_log_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the log group where text and
        /// metadata logs are delivered.</p>
        pub fn set_cloud_watch_log_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_log_group_arn = input;
            self
        }
        /// <p>The prefix of the log stream name within the log group that you
        /// specified </p>
        pub fn log_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the log stream name within the log group that you
        /// specified </p>
        pub fn set_log_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogGroupLogDestination`](crate::model::CloudWatchLogGroupLogDestination)
        pub fn build(self) -> crate::model::CloudWatchLogGroupLogDestination {
            crate::model::CloudWatchLogGroupLogDestination {
                cloud_watch_log_group_arn: self.cloud_watch_log_group_arn,
                log_prefix: self.log_prefix,
            }
        }
    }
}
impl CloudWatchLogGroupLogDestination {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogGroupLogDestination`](crate::model::CloudWatchLogGroupLogDestination)
    pub fn builder() -> crate::model::cloud_watch_log_group_log_destination::Builder {
        crate::model::cloud_watch_log_group_log_destination::Builder::default()
    }
}

/// <p>Specifies settings that are unique to a locale. For example, you can
/// use different Lambda function depending on the bot's locale.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotAliasLocaleSettings {
    /// <p>Determines whether the locale is enabled for the bot. If the value
    /// is <code>false</code>, the locale isn't available for use.</p>
    pub enabled: bool,
    /// <p>Specifies the Lambda function that should be used in the
    /// locale.</p>
    pub code_hook_specification: std::option::Option<crate::model::CodeHookSpecification>,
}
impl std::fmt::Debug for BotAliasLocaleSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotAliasLocaleSettings");
        formatter.field("enabled", &self.enabled);
        formatter.field("code_hook_specification", &self.code_hook_specification);
        formatter.finish()
    }
}
/// See [`BotAliasLocaleSettings`](crate::model::BotAliasLocaleSettings)
pub mod bot_alias_locale_settings {
    /// A builder for [`BotAliasLocaleSettings`](crate::model::BotAliasLocaleSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) code_hook_specification:
            std::option::Option<crate::model::CodeHookSpecification>,
    }
    impl Builder {
        /// <p>Determines whether the locale is enabled for the bot. If the value
        /// is <code>false</code>, the locale isn't available for use.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Determines whether the locale is enabled for the bot. If the value
        /// is <code>false</code>, the locale isn't available for use.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>Specifies the Lambda function that should be used in the
        /// locale.</p>
        pub fn code_hook_specification(
            mut self,
            input: crate::model::CodeHookSpecification,
        ) -> Self {
            self.code_hook_specification = Some(input);
            self
        }
        /// <p>Specifies the Lambda function that should be used in the
        /// locale.</p>
        pub fn set_code_hook_specification(
            mut self,
            input: std::option::Option<crate::model::CodeHookSpecification>,
        ) -> Self {
            self.code_hook_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`BotAliasLocaleSettings`](crate::model::BotAliasLocaleSettings)
        pub fn build(self) -> crate::model::BotAliasLocaleSettings {
            crate::model::BotAliasLocaleSettings {
                enabled: self.enabled.unwrap_or_default(),
                code_hook_specification: self.code_hook_specification,
            }
        }
    }
}
impl BotAliasLocaleSettings {
    /// Creates a new builder-style object to manufacture [`BotAliasLocaleSettings`](crate::model::BotAliasLocaleSettings)
    pub fn builder() -> crate::model::bot_alias_locale_settings::Builder {
        crate::model::bot_alias_locale_settings::Builder::default()
    }
}

/// <p>Contains information about code hooks that Amazon Lex calls during a
/// conversation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeHookSpecification {
    /// <p>Specifies a Lambda function that verifies requests to a bot or
    /// fulfills the user's request to a bot.</p>
    pub lambda_code_hook: std::option::Option<crate::model::LambdaCodeHook>,
}
impl std::fmt::Debug for CodeHookSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeHookSpecification");
        formatter.field("lambda_code_hook", &self.lambda_code_hook);
        formatter.finish()
    }
}
/// See [`CodeHookSpecification`](crate::model::CodeHookSpecification)
pub mod code_hook_specification {
    /// A builder for [`CodeHookSpecification`](crate::model::CodeHookSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_code_hook: std::option::Option<crate::model::LambdaCodeHook>,
    }
    impl Builder {
        /// <p>Specifies a Lambda function that verifies requests to a bot or
        /// fulfills the user's request to a bot.</p>
        pub fn lambda_code_hook(mut self, input: crate::model::LambdaCodeHook) -> Self {
            self.lambda_code_hook = Some(input);
            self
        }
        /// <p>Specifies a Lambda function that verifies requests to a bot or
        /// fulfills the user's request to a bot.</p>
        pub fn set_lambda_code_hook(
            mut self,
            input: std::option::Option<crate::model::LambdaCodeHook>,
        ) -> Self {
            self.lambda_code_hook = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeHookSpecification`](crate::model::CodeHookSpecification)
        pub fn build(self) -> crate::model::CodeHookSpecification {
            crate::model::CodeHookSpecification {
                lambda_code_hook: self.lambda_code_hook,
            }
        }
    }
}
impl CodeHookSpecification {
    /// Creates a new builder-style object to manufacture [`CodeHookSpecification`](crate::model::CodeHookSpecification)
    pub fn builder() -> crate::model::code_hook_specification::Builder {
        crate::model::code_hook_specification::Builder::default()
    }
}

/// <p>Specifies a Lambda function that verifies requests to a bot or
/// fulfills the user's request to a bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaCodeHook {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
    /// <p>The version of the request-response that you want Amazon Lex to use to
    /// invoke your Lambda function.</p>
    pub code_hook_interface_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LambdaCodeHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaCodeHook");
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.field(
            "code_hook_interface_version",
            &self.code_hook_interface_version,
        );
        formatter.finish()
    }
}
/// See [`LambdaCodeHook`](crate::model::LambdaCodeHook)
pub mod lambda_code_hook {
    /// A builder for [`LambdaCodeHook`](crate::model::LambdaCodeHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
        pub(crate) code_hook_interface_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// <p>The version of the request-response that you want Amazon Lex to use to
        /// invoke your Lambda function.</p>
        pub fn code_hook_interface_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.code_hook_interface_version = Some(input.into());
            self
        }
        /// <p>The version of the request-response that you want Amazon Lex to use to
        /// invoke your Lambda function.</p>
        pub fn set_code_hook_interface_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_hook_interface_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaCodeHook`](crate::model::LambdaCodeHook)
        pub fn build(self) -> crate::model::LambdaCodeHook {
            crate::model::LambdaCodeHook {
                lambda_arn: self.lambda_arn,
                code_hook_interface_version: self.code_hook_interface_version,
            }
        }
    }
}
impl LambdaCodeHook {
    /// Creates a new builder-style object to manufacture [`LambdaCodeHook`](crate::model::LambdaCodeHook)
    pub fn builder() -> crate::model::lambda_code_hook::Builder {
        crate::model::lambda_code_hook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Importing,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Versioning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotStatus {
    fn from(s: &str) -> Self {
        match s {
            "Available" => BotStatus::Available,
            "Creating" => BotStatus::Creating,
            "Deleting" => BotStatus::Deleting,
            "Failed" => BotStatus::Failed,
            "Importing" => BotStatus::Importing,
            "Inactive" => BotStatus::Inactive,
            "Versioning" => BotStatus::Versioning,
            other => BotStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotStatus::from(s))
    }
}
impl BotStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotStatus::Available => "Available",
            BotStatus::Creating => "Creating",
            BotStatus::Deleting => "Deleting",
            BotStatus::Failed => "Failed",
            BotStatus::Importing => "Importing",
            BotStatus::Inactive => "Inactive",
            BotStatus::Versioning => "Versioning",
            BotStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Available",
            "Creating",
            "Deleting",
            "Failed",
            "Importing",
            "Inactive",
            "Versioning",
        ]
    }
}
impl AsRef<str> for BotStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>By default, data stored by Amazon Lex is encrypted. The
/// <code>DataPrivacy</code> structure provides settings that determine
/// how Amazon Lex handles special cases of securing the data for your bot.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataPrivacy {
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or
    /// in part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field,
    /// you confirm that your use of Amazon Lex <b>is</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. By specifying <code>false</code> in the
    /// <code>childDirected</code> field, you confirm that your use of Amazon Lex
    /// <b>is not</b> related to a website,
    /// program, or other application that is directed or targeted, in whole or
    /// in part, to children under age 13 and subject to COPPA. You may not
    /// specify a default value for the <code>childDirected</code> field that
    /// does not accurately reflect whether your use of Amazon Lex is related to a
    /// website, program, or other application that is directed or targeted, in
    /// whole or in part, to children under age 13 and subject to COPPA. If
    /// your use of Amazon Lex relates to a website, program, or other application
    /// that is directed in whole or in part, to children under age 13, you
    /// must obtain any required verifiable parental consent under COPPA. For
    /// information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole
    /// or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex
    /// FAQ</a>.</p>
    pub child_directed: bool,
}
impl std::fmt::Debug for DataPrivacy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataPrivacy");
        formatter.field("child_directed", &self.child_directed);
        formatter.finish()
    }
}
/// See [`DataPrivacy`](crate::model::DataPrivacy)
pub mod data_privacy {
    /// A builder for [`DataPrivacy`](crate::model::DataPrivacy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) child_directed: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or
        /// in part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field,
        /// you confirm that your use of Amazon Lex <b>is</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. By specifying <code>false</code> in the
        /// <code>childDirected</code> field, you confirm that your use of Amazon Lex
        /// <b>is not</b> related to a website,
        /// program, or other application that is directed or targeted, in whole or
        /// in part, to children under age 13 and subject to COPPA. You may not
        /// specify a default value for the <code>childDirected</code> field that
        /// does not accurately reflect whether your use of Amazon Lex is related to a
        /// website, program, or other application that is directed or targeted, in
        /// whole or in part, to children under age 13 and subject to COPPA. If
        /// your use of Amazon Lex relates to a website, program, or other application
        /// that is directed in whole or in part, to children under age 13, you
        /// must obtain any required verifiable parental consent under COPPA. For
        /// information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole
        /// or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex
        /// FAQ</a>.</p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.child_directed = Some(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or
        /// in part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field,
        /// you confirm that your use of Amazon Lex <b>is</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. By specifying <code>false</code> in the
        /// <code>childDirected</code> field, you confirm that your use of Amazon Lex
        /// <b>is not</b> related to a website,
        /// program, or other application that is directed or targeted, in whole or
        /// in part, to children under age 13 and subject to COPPA. You may not
        /// specify a default value for the <code>childDirected</code> field that
        /// does not accurately reflect whether your use of Amazon Lex is related to a
        /// website, program, or other application that is directed or targeted, in
        /// whole or in part, to children under age 13 and subject to COPPA. If
        /// your use of Amazon Lex relates to a website, program, or other application
        /// that is directed in whole or in part, to children under age 13, you
        /// must obtain any required verifiable parental consent under COPPA. For
        /// information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole
        /// or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex
        /// FAQ</a>.</p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.child_directed = input;
            self
        }
        /// Consumes the builder and constructs a [`DataPrivacy`](crate::model::DataPrivacy)
        pub fn build(self) -> crate::model::DataPrivacy {
            crate::model::DataPrivacy {
                child_directed: self.child_directed.unwrap_or_default(),
            }
        }
    }
}
impl DataPrivacy {
    /// Creates a new builder-style object to manufacture [`DataPrivacy`](crate::model::DataPrivacy)
    pub fn builder() -> crate::model::data_privacy::Builder {
        crate::model::data_privacy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => ImportStatus::Completed,
            "Deleting" => ImportStatus::Deleting,
            "Failed" => ImportStatus::Failed,
            "InProgress" => ImportStatus::InProgress,
            other => ImportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportStatus::from(s))
    }
}
impl ImportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportStatus::Completed => "Completed",
            ImportStatus::Deleting => "Deleting",
            ImportStatus::Failed => "Failed",
            ImportStatus::InProgress => "InProgress",
            ImportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Deleting", "Failed", "InProgress"]
    }
}
impl AsRef<str> for ImportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MergeStrategy {
    #[allow(missing_docs)] // documentation missing in model
    FailOnConflict,
    #[allow(missing_docs)] // documentation missing in model
    Overwrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MergeStrategy {
    fn from(s: &str) -> Self {
        match s {
            "FailOnConflict" => MergeStrategy::FailOnConflict,
            "Overwrite" => MergeStrategy::Overwrite,
            other => MergeStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MergeStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MergeStrategy::from(s))
    }
}
impl MergeStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MergeStrategy::FailOnConflict => "FailOnConflict",
            MergeStrategy::Overwrite => "Overwrite",
            MergeStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FailOnConflict", "Overwrite"]
    }
}
impl AsRef<str> for MergeStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the bot or bot locale that you want to
/// import. You can specify the <code>botImportSpecification</code> or the
/// <code>botLocaleImportSpecification</code>, but not both.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportResourceSpecification {
    /// <p>Parameters for importing a bot.</p>
    pub bot_import_specification: std::option::Option<crate::model::BotImportSpecification>,
    /// <p>Parameters for importing a bot locale.</p>
    pub bot_locale_import_specification:
        std::option::Option<crate::model::BotLocaleImportSpecification>,
}
impl std::fmt::Debug for ImportResourceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportResourceSpecification");
        formatter.field("bot_import_specification", &self.bot_import_specification);
        formatter.field(
            "bot_locale_import_specification",
            &self.bot_locale_import_specification,
        );
        formatter.finish()
    }
}
/// See [`ImportResourceSpecification`](crate::model::ImportResourceSpecification)
pub mod import_resource_specification {
    /// A builder for [`ImportResourceSpecification`](crate::model::ImportResourceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_import_specification:
            std::option::Option<crate::model::BotImportSpecification>,
        pub(crate) bot_locale_import_specification:
            std::option::Option<crate::model::BotLocaleImportSpecification>,
    }
    impl Builder {
        /// <p>Parameters for importing a bot.</p>
        pub fn bot_import_specification(
            mut self,
            input: crate::model::BotImportSpecification,
        ) -> Self {
            self.bot_import_specification = Some(input);
            self
        }
        /// <p>Parameters for importing a bot.</p>
        pub fn set_bot_import_specification(
            mut self,
            input: std::option::Option<crate::model::BotImportSpecification>,
        ) -> Self {
            self.bot_import_specification = input;
            self
        }
        /// <p>Parameters for importing a bot locale.</p>
        pub fn bot_locale_import_specification(
            mut self,
            input: crate::model::BotLocaleImportSpecification,
        ) -> Self {
            self.bot_locale_import_specification = Some(input);
            self
        }
        /// <p>Parameters for importing a bot locale.</p>
        pub fn set_bot_locale_import_specification(
            mut self,
            input: std::option::Option<crate::model::BotLocaleImportSpecification>,
        ) -> Self {
            self.bot_locale_import_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportResourceSpecification`](crate::model::ImportResourceSpecification)
        pub fn build(self) -> crate::model::ImportResourceSpecification {
            crate::model::ImportResourceSpecification {
                bot_import_specification: self.bot_import_specification,
                bot_locale_import_specification: self.bot_locale_import_specification,
            }
        }
    }
}
impl ImportResourceSpecification {
    /// Creates a new builder-style object to manufacture [`ImportResourceSpecification`](crate::model::ImportResourceSpecification)
    pub fn builder() -> crate::model::import_resource_specification::Builder {
        crate::model::import_resource_specification::Builder::default()
    }
}

/// <p>Provides the bot locale parameters required for importing a bot
/// locale.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleImportSpecification {
    /// <p>The identifier of the bot to import the locale to.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The version of the bot to import the locale to. This can only be the
    /// <code>DRAFT</code> version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the language and locale that the bot will be used
    /// in. The string must match one of the supported locales. All of the
    /// intents, slot types, and slots used in the bot must have the same
    /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
    /// languages</a>.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>Determines the threshold where Amazon Lex will insert the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents. <code>AMAZON.FallbackIntent</code> and
    /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
    /// configured for the bot. </p>
    /// <p>For example, suppose a bot is configured with the confidence
    /// threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon
    /// Lex returns three alternative intents with the following confidence
    /// scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response
    /// from the <code>PostText</code> operation would be:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>AMAZON.FallbackIntent</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IntentA</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IntentB</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IntentC</code>
    /// </p>
    /// </li>
    /// </ul>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>Defines settings for using an Amazon Polly voice to communicate with a
    /// user.</p>
    pub voice_settings: std::option::Option<crate::model::VoiceSettings>,
}
impl std::fmt::Debug for BotLocaleImportSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleImportSpecification");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("locale_id", &self.locale_id);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("voice_settings", &self.voice_settings);
        formatter.finish()
    }
}
/// See [`BotLocaleImportSpecification`](crate::model::BotLocaleImportSpecification)
pub mod bot_locale_import_specification {
    /// A builder for [`BotLocaleImportSpecification`](crate::model::BotLocaleImportSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) voice_settings: std::option::Option<crate::model::VoiceSettings>,
    }
    impl Builder {
        /// <p>The identifier of the bot to import the locale to.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The identifier of the bot to import the locale to.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The version of the bot to import the locale to. This can only be the
        /// <code>DRAFT</code> version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to import the locale to. This can only be the
        /// <code>DRAFT</code> version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The identifier of the language and locale that the bot will be used
        /// in. The string must match one of the supported locales. All of the
        /// intents, slot types, and slots used in the bot must have the same
        /// locale. For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
        /// languages</a>.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents. <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot. </p>
        /// <p>For example, suppose a bot is configured with the confidence
        /// threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon
        /// Lex returns three alternative intents with the following confidence
        /// scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response
        /// from the <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AMAZON.FallbackIntent</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentB</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentC</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents. <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot. </p>
        /// <p>For example, suppose a bot is configured with the confidence
        /// threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon
        /// Lex returns three alternative intents with the following confidence
        /// scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response
        /// from the <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>AMAZON.FallbackIntent</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentB</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IntentC</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>Defines settings for using an Amazon Polly voice to communicate with a
        /// user.</p>
        pub fn voice_settings(mut self, input: crate::model::VoiceSettings) -> Self {
            self.voice_settings = Some(input);
            self
        }
        /// <p>Defines settings for using an Amazon Polly voice to communicate with a
        /// user.</p>
        pub fn set_voice_settings(
            mut self,
            input: std::option::Option<crate::model::VoiceSettings>,
        ) -> Self {
            self.voice_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleImportSpecification`](crate::model::BotLocaleImportSpecification)
        pub fn build(self) -> crate::model::BotLocaleImportSpecification {
            crate::model::BotLocaleImportSpecification {
                bot_id: self.bot_id,
                bot_version: self.bot_version,
                locale_id: self.locale_id,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                voice_settings: self.voice_settings,
            }
        }
    }
}
impl BotLocaleImportSpecification {
    /// Creates a new builder-style object to manufacture [`BotLocaleImportSpecification`](crate::model::BotLocaleImportSpecification)
    pub fn builder() -> crate::model::bot_locale_import_specification::Builder {
        crate::model::bot_locale_import_specification::Builder::default()
    }
}

/// <p>Provides the bot parameters required for importing a bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotImportSpecification {
    /// <p>The name that Amazon Lex should use for the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used to build and run
    /// the bot.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>By default, data stored by Amazon Lex is encrypted. The
    /// <code>DataPrivacy</code> structure provides settings that determine
    /// how Amazon Lex handles special cases of securing the data for your bot.
    /// </p>
    pub data_privacy: std::option::Option<crate::model::DataPrivacy>,
    /// <p>The time, in seconds, that Amazon Lex should keep information about a
    /// user's conversation with the bot. </p>
    /// <p>A user interaction remains active for the amount of time specified.
    /// If no conversation occurs during this time, the session expires and
    /// Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
    /// seconds.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>A list of tags to add to the bot. You can only add tags when you
    /// import a bot. You can't use the <code>UpdateBot</code> operation to
    /// update tags. To update tags, use the <code>TagResource</code>
    /// operation.</p>
    pub bot_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of tags to add to the test alias for a bot. You can only add
    /// tags when you import a bot. You can't use the <code>UpdateAlias</code>
    /// operation to update tags. To update tags on the test alias, use the
    /// <code>TagResource</code> operation.</p>
    pub test_bot_alias_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for BotImportSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotImportSpecification");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("data_privacy", &self.data_privacy);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("bot_tags", &self.bot_tags);
        formatter.field("test_bot_alias_tags", &self.test_bot_alias_tags);
        formatter.finish()
    }
}
/// See [`BotImportSpecification`](crate::model::BotImportSpecification)
pub mod bot_import_specification {
    /// A builder for [`BotImportSpecification`](crate::model::BotImportSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) data_privacy: std::option::Option<crate::model::DataPrivacy>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) bot_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) test_bot_alias_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name that Amazon Lex should use for the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name that Amazon Lex should use for the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to build and run
        /// the bot.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to build and run
        /// the bot.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>By default, data stored by Amazon Lex is encrypted. The
        /// <code>DataPrivacy</code> structure provides settings that determine
        /// how Amazon Lex handles special cases of securing the data for your bot.
        /// </p>
        pub fn data_privacy(mut self, input: crate::model::DataPrivacy) -> Self {
            self.data_privacy = Some(input);
            self
        }
        /// <p>By default, data stored by Amazon Lex is encrypted. The
        /// <code>DataPrivacy</code> structure provides settings that determine
        /// how Amazon Lex handles special cases of securing the data for your bot.
        /// </p>
        pub fn set_data_privacy(
            mut self,
            input: std::option::Option<crate::model::DataPrivacy>,
        ) -> Self {
            self.data_privacy = input;
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The time, in seconds, that Amazon Lex should keep information about a
        /// user's conversation with the bot. </p>
        /// <p>A user interaction remains active for the amount of time specified.
        /// If no conversation occurs during this time, the session expires and
        /// Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>You can specify between 60 (1 minute) and 86,400 (24 hours)
        /// seconds.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// Adds a key-value pair to `bot_tags`.
        ///
        /// To override the contents of this collection use [`set_bot_tags`](Self::set_bot_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// import a bot. You can't use the <code>UpdateBot</code> operation to
        /// update tags. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn bot_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.bot_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.bot_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// import a bot. You can't use the <code>UpdateBot</code> operation to
        /// update tags. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn set_bot_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.bot_tags = input;
            self
        }
        /// Adds a key-value pair to `test_bot_alias_tags`.
        ///
        /// To override the contents of this collection use [`set_test_bot_alias_tags`](Self::set_test_bot_alias_tags).
        ///
        /// <p>A list of tags to add to the test alias for a bot. You can only add
        /// tags when you import a bot. You can't use the <code>UpdateAlias</code>
        /// operation to update tags. To update tags on the test alias, use the
        /// <code>TagResource</code> operation.</p>
        pub fn test_bot_alias_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.test_bot_alias_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.test_bot_alias_tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to add to the test alias for a bot. You can only add
        /// tags when you import a bot. You can't use the <code>UpdateAlias</code>
        /// operation to update tags. To update tags on the test alias, use the
        /// <code>TagResource</code> operation.</p>
        pub fn set_test_bot_alias_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.test_bot_alias_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`BotImportSpecification`](crate::model::BotImportSpecification)
        pub fn build(self) -> crate::model::BotImportSpecification {
            crate::model::BotImportSpecification {
                bot_name: self.bot_name,
                role_arn: self.role_arn,
                data_privacy: self.data_privacy,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                bot_tags: self.bot_tags,
                test_bot_alias_tags: self.test_bot_alias_tags,
            }
        }
    }
}
impl BotImportSpecification {
    /// Creates a new builder-style object to manufacture [`BotImportSpecification`](crate::model::BotImportSpecification)
    pub fn builder() -> crate::model::bot_import_specification::Builder {
        crate::model::bot_import_specification::Builder::default()
    }
}

/// <p>Provides summary information about a slot type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeSummary {
    /// <p>The unique identifier assigned to the slot type.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>The name of the slot type.</p>
    pub slot_type_name: std::option::Option<std::string::String>,
    /// <p>The description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If the slot type is derived from a built-on slot type, the name of
    /// the parent slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the slot type was last
    /// updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SlotTypeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeSummary");
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field("slot_type_name", &self.slot_type_name);
        formatter.field("description", &self.description);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`SlotTypeSummary`](crate::model::SlotTypeSummary)
pub mod slot_type_summary {
    /// A builder for [`SlotTypeSummary`](crate::model::SlotTypeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) slot_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the slot type.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the slot type.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn slot_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_slot_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_name = input;
            self
        }
        /// <p>The description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If the slot type is derived from a built-on slot type, the name of
        /// the parent slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>If the slot type is derived from a built-on slot type, the name of
        /// the parent slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last
        /// updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the slot type was last
        /// updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeSummary`](crate::model::SlotTypeSummary)
        pub fn build(self) -> crate::model::SlotTypeSummary {
            crate::model::SlotTypeSummary {
                slot_type_id: self.slot_type_id,
                slot_type_name: self.slot_type_name,
                description: self.description,
                parent_slot_type_signature: self.parent_slot_type_signature,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl SlotTypeSummary {
    /// Creates a new builder-style object to manufacture [`SlotTypeSummary`](crate::model::SlotTypeSummary)
    pub fn builder() -> crate::model::slot_type_summary::Builder {
        crate::model::slot_type_summary::Builder::default()
    }
}

/// <p>Filters the response from the <code>ListSlotTypes</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeFilter {
    /// <p>The name of the field to use for filtering.</p>
    pub name: std::option::Option<crate::model::SlotTypeFilterName>,
    /// <p>The value to use to filter the response.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListSlotTypes</code> operation should return only aliases that
    /// equal the specified value. Specify <code>CO</code> when the
    /// <code>ListSlotTypes</code> operation should return aliases that
    /// contain the specified value.</p>
    pub operator: std::option::Option<crate::model::SlotTypeFilterOperator>,
}
impl std::fmt::Debug for SlotTypeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`SlotTypeFilter`](crate::model::SlotTypeFilter)
pub mod slot_type_filter {
    /// A builder for [`SlotTypeFilter`](crate::model::SlotTypeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SlotTypeFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::SlotTypeFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to use for filtering.</p>
        pub fn name(mut self, input: crate::model::SlotTypeFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to use for filtering.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SlotTypeFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use to filter the response.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use to filter the response.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListSlotTypes</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListSlotTypes</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::SlotTypeFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListSlotTypes</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListSlotTypes</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::SlotTypeFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeFilter`](crate::model::SlotTypeFilter)
        pub fn build(self) -> crate::model::SlotTypeFilter {
            crate::model::SlotTypeFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl SlotTypeFilter {
    /// Creates a new builder-style object to manufacture [`SlotTypeFilter`](crate::model::SlotTypeFilter)
    pub fn builder() -> crate::model::slot_type_filter::Builder {
        crate::model::slot_type_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotTypeFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotTypeFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => SlotTypeFilterOperator::Contains,
            "EQ" => SlotTypeFilterOperator::Equals,
            other => SlotTypeFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotTypeFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotTypeFilterOperator::from(s))
    }
}
impl SlotTypeFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotTypeFilterOperator::Contains => "CO",
            SlotTypeFilterOperator::Equals => "EQ",
            SlotTypeFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for SlotTypeFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotTypeFilterName {
    #[allow(missing_docs)] // documentation missing in model
    SlotTypeName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotTypeFilterName {
    fn from(s: &str) -> Self {
        match s {
            "SlotTypeName" => SlotTypeFilterName::SlotTypeName,
            other => SlotTypeFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotTypeFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotTypeFilterName::from(s))
    }
}
impl SlotTypeFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotTypeFilterName::SlotTypeName => "SlotTypeName",
            SlotTypeFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SlotTypeName"]
    }
}
impl AsRef<str> for SlotTypeFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of slot types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeSortBy {
    /// <p>The attribute to use to sort the list of slot types.</p>
    pub attribute: std::option::Option<crate::model::SlotTypeSortAttribute>,
    /// <p>The order to sort the list. You can say ascending or
    /// descending.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for SlotTypeSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`SlotTypeSortBy`](crate::model::SlotTypeSortBy)
pub mod slot_type_sort_by {
    /// A builder for [`SlotTypeSortBy`](crate::model::SlotTypeSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::SlotTypeSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of slot types.</p>
        pub fn attribute(mut self, input: crate::model::SlotTypeSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of slot types.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SlotTypeSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can say ascending or
        /// descending.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can say ascending or
        /// descending.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeSortBy`](crate::model::SlotTypeSortBy)
        pub fn build(self) -> crate::model::SlotTypeSortBy {
            crate::model::SlotTypeSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl SlotTypeSortBy {
    /// Creates a new builder-style object to manufacture [`SlotTypeSortBy`](crate::model::SlotTypeSortBy)
    pub fn builder() -> crate::model::slot_type_sort_by::Builder {
        crate::model::slot_type_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "Ascending" => SortOrder::Ascending,
            "Descending" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "Ascending",
            SortOrder::Descending => "Descending",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Ascending", "Descending"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotTypeSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    LastUpdatedDateTime,
    #[allow(missing_docs)] // documentation missing in model
    SlotTypeName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotTypeSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "LastUpdatedDateTime" => SlotTypeSortAttribute::LastUpdatedDateTime,
            "SlotTypeName" => SlotTypeSortAttribute::SlotTypeName,
            other => SlotTypeSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotTypeSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotTypeSortAttribute::from(s))
    }
}
impl SlotTypeSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotTypeSortAttribute::LastUpdatedDateTime => "LastUpdatedDateTime",
            SlotTypeSortAttribute::SlotTypeName => "SlotTypeName",
            SlotTypeSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LastUpdatedDateTime", "SlotTypeName"]
    }
}
impl AsRef<str> for SlotTypeSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a slot, a value that the bot elicits from
/// the user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotSummary {
    /// <p>The unique identifier of the slot.</p>
    pub slot_id: std::option::Option<std::string::String>,
    /// <p>The name given to the slot.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>The description of the slot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Whether the slot is required or optional. An intent is complete when
    /// all required slots are filled.</p>
    pub slot_constraint: std::option::Option<crate::model::SlotConstraint>,
    /// <p>The unique identifier for the slot type that defines the values for
    /// the slot.</p>
    pub slot_type_id: std::option::Option<std::string::String>,
    /// <p>Prompts that are sent to the user to elicit a value for the
    /// slot.</p>
    pub value_elicitation_prompt_specification:
        std::option::Option<crate::model::PromptSpecification>,
    /// <p>The timestamp of the last date and time that the slot was
    /// updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for SlotSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotSummary");
        formatter.field("slot_id", &self.slot_id);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("description", &self.description);
        formatter.field("slot_constraint", &self.slot_constraint);
        formatter.field("slot_type_id", &self.slot_type_id);
        formatter.field(
            "value_elicitation_prompt_specification",
            &self.value_elicitation_prompt_specification,
        );
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`SlotSummary`](crate::model::SlotSummary)
pub mod slot_summary {
    /// A builder for [`SlotSummary`](crate::model::SlotSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_id: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_constraint: std::option::Option<crate::model::SlotConstraint>,
        pub(crate) slot_type_id: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_prompt_specification:
            std::option::Option<crate::model::PromptSpecification>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier of the slot.</p>
        pub fn slot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the slot.</p>
        pub fn set_slot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_id = input;
            self
        }
        /// <p>The name given to the slot.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>The name given to the slot.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>The description of the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Whether the slot is required or optional. An intent is complete when
        /// all required slots are filled.</p>
        pub fn slot_constraint(mut self, input: crate::model::SlotConstraint) -> Self {
            self.slot_constraint = Some(input);
            self
        }
        /// <p>Whether the slot is required or optional. An intent is complete when
        /// all required slots are filled.</p>
        pub fn set_slot_constraint(
            mut self,
            input: std::option::Option<crate::model::SlotConstraint>,
        ) -> Self {
            self.slot_constraint = input;
            self
        }
        /// <p>The unique identifier for the slot type that defines the values for
        /// the slot.</p>
        pub fn slot_type_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the slot type that defines the values for
        /// the slot.</p>
        pub fn set_slot_type_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type_id = input;
            self
        }
        /// <p>Prompts that are sent to the user to elicit a value for the
        /// slot.</p>
        pub fn value_elicitation_prompt_specification(
            mut self,
            input: crate::model::PromptSpecification,
        ) -> Self {
            self.value_elicitation_prompt_specification = Some(input);
            self
        }
        /// <p>Prompts that are sent to the user to elicit a value for the
        /// slot.</p>
        pub fn set_value_elicitation_prompt_specification(
            mut self,
            input: std::option::Option<crate::model::PromptSpecification>,
        ) -> Self {
            self.value_elicitation_prompt_specification = input;
            self
        }
        /// <p>The timestamp of the last date and time that the slot was
        /// updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the last date and time that the slot was
        /// updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotSummary`](crate::model::SlotSummary)
        pub fn build(self) -> crate::model::SlotSummary {
            crate::model::SlotSummary {
                slot_id: self.slot_id,
                slot_name: self.slot_name,
                description: self.description,
                slot_constraint: self.slot_constraint,
                slot_type_id: self.slot_type_id,
                value_elicitation_prompt_specification: self.value_elicitation_prompt_specification,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl SlotSummary {
    /// Creates a new builder-style object to manufacture [`SlotSummary`](crate::model::SlotSummary)
    pub fn builder() -> crate::model::slot_summary::Builder {
        crate::model::slot_summary::Builder::default()
    }
}

/// <p>Filters the response from the <code>ListSlots</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotFilter {
    /// <p>The name of the field to use for filtering.</p>
    pub name: std::option::Option<crate::model::SlotFilterName>,
    /// <p>The value to use to filter the response.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListSlots</code> operation should return only aliases that
    /// equal the specified value. Specify <code>CO</code> when the
    /// <code>ListSlots</code> operation should return aliases that contain
    /// the specified value.</p>
    pub operator: std::option::Option<crate::model::SlotFilterOperator>,
}
impl std::fmt::Debug for SlotFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`SlotFilter`](crate::model::SlotFilter)
pub mod slot_filter {
    /// A builder for [`SlotFilter`](crate::model::SlotFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::SlotFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::SlotFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to use for filtering.</p>
        pub fn name(mut self, input: crate::model::SlotFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to use for filtering.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::SlotFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use to filter the response.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use to filter the response.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListSlots</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListSlots</code> operation should return aliases that contain
        /// the specified value.</p>
        pub fn operator(mut self, input: crate::model::SlotFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListSlots</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListSlots</code> operation should return aliases that contain
        /// the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::SlotFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotFilter`](crate::model::SlotFilter)
        pub fn build(self) -> crate::model::SlotFilter {
            crate::model::SlotFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl SlotFilter {
    /// Creates a new builder-style object to manufacture [`SlotFilter`](crate::model::SlotFilter)
    pub fn builder() -> crate::model::slot_filter::Builder {
        crate::model::slot_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => SlotFilterOperator::Contains,
            "EQ" => SlotFilterOperator::Equals,
            other => SlotFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotFilterOperator::from(s))
    }
}
impl SlotFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotFilterOperator::Contains => "CO",
            SlotFilterOperator::Equals => "EQ",
            SlotFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for SlotFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotFilterName {
    #[allow(missing_docs)] // documentation missing in model
    SlotName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotFilterName {
    fn from(s: &str) -> Self {
        match s {
            "SlotName" => SlotFilterName::SlotName,
            other => SlotFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotFilterName::from(s))
    }
}
impl SlotFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotFilterName::SlotName => "SlotName",
            SlotFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SlotName"]
    }
}
impl AsRef<str> for SlotFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of bots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotSortBy {
    /// <p>The attribute to use to sort the list.</p>
    pub attribute: std::option::Option<crate::model::SlotSortAttribute>,
    /// <p>The order to sort the list. You can choose ascending or
    /// descending.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for SlotSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`SlotSortBy`](crate::model::SlotSortBy)
pub mod slot_sort_by {
    /// A builder for [`SlotSortBy`](crate::model::SlotSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::SlotSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list.</p>
        pub fn attribute(mut self, input: crate::model::SlotSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SlotSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotSortBy`](crate::model::SlotSortBy)
        pub fn build(self) -> crate::model::SlotSortBy {
            crate::model::SlotSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl SlotSortBy {
    /// Creates a new builder-style object to manufacture [`SlotSortBy`](crate::model::SlotSortBy)
    pub fn builder() -> crate::model::slot_sort_by::Builder {
        crate::model::slot_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    LastUpdatedDateTime,
    #[allow(missing_docs)] // documentation missing in model
    SlotName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "LastUpdatedDateTime" => SlotSortAttribute::LastUpdatedDateTime,
            "SlotName" => SlotSortAttribute::SlotName,
            other => SlotSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotSortAttribute::from(s))
    }
}
impl SlotSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotSortAttribute::LastUpdatedDateTime => "LastUpdatedDateTime",
            SlotSortAttribute::SlotName => "SlotName",
            SlotSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LastUpdatedDateTime", "SlotName"]
    }
}
impl AsRef<str> for SlotSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about an intent returned by the
/// <code>ListIntents</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentSummary {
    /// <p>The unique identifier assigned to the intent. Use this ID to get
    /// detailed information about the intent with the
    /// <code>DescribeIntent</code> operation.</p>
    pub intent_id: std::option::Option<std::string::String>,
    /// <p>The name of the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>If this intent is derived from a built-in intent, the name of the
    /// parent intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The input contexts that must be active for this intent to be
    /// considered for recognition.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>The output contexts that are activated when this intent is
    /// fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    /// <p>The timestamp of the date and time that the intent was last
    /// updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for IntentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentSummary");
        formatter.field("intent_id", &self.intent_id);
        formatter.field("intent_name", &self.intent_name);
        formatter.field("description", &self.description);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`IntentSummary`](crate::model::IntentSummary)
pub mod intent_summary {
    /// A builder for [`IntentSummary`](crate::model::IntentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_id: std::option::Option<std::string::String>,
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the intent. Use this ID to get
        /// detailed information about the intent with the
        /// <code>DescribeIntent</code> operation.</p>
        pub fn intent_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the intent. Use this ID to get
        /// detailed information about the intent with the
        /// <code>DescribeIntent</code> operation.</p>
        pub fn set_intent_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_id = input;
            self
        }
        /// <p>The name of the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>If this intent is derived from a built-in intent, the name of the
        /// parent intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>If this intent is derived from a built-in intent, the name of the
        /// parent intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>The input contexts that must be active for this intent to be
        /// considered for recognition.</p>
        pub fn input_contexts(mut self, input: impl Into<crate::model::InputContext>) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input.into());
            self.input_contexts = Some(v);
            self
        }
        /// <p>The input contexts that must be active for this intent to be
        /// considered for recognition.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>The output contexts that are activated when this intent is
        /// fulfilled.</p>
        pub fn output_contexts(mut self, input: impl Into<crate::model::OutputContext>) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input.into());
            self.output_contexts = Some(v);
            self
        }
        /// <p>The output contexts that are activated when this intent is
        /// fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// <p>The timestamp of the date and time that the intent was last
        /// updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The timestamp of the date and time that the intent was last
        /// updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentSummary`](crate::model::IntentSummary)
        pub fn build(self) -> crate::model::IntentSummary {
            crate::model::IntentSummary {
                intent_id: self.intent_id,
                intent_name: self.intent_name,
                description: self.description,
                parent_intent_signature: self.parent_intent_signature,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl IntentSummary {
    /// Creates a new builder-style object to manufacture [`IntentSummary`](crate::model::IntentSummary)
    pub fn builder() -> crate::model::intent_summary::Builder {
        crate::model::intent_summary::Builder::default()
    }
}

/// <p>Filters the response from the <code>ListIntents</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentFilter {
    /// <p>The name of the field to use for the filter.</p>
    pub name: std::option::Option<crate::model::IntentFilterName>,
    /// <p>The value to use for the filter.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListIntents</code> operation should return only aliases that
    /// equal the specified value. Specify <code>CO</code> when the
    /// <code>ListIntents</code> operation should return aliases that
    /// contain the specified value.</p>
    pub operator: std::option::Option<crate::model::IntentFilterOperator>,
}
impl std::fmt::Debug for IntentFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`IntentFilter`](crate::model::IntentFilter)
pub mod intent_filter {
    /// A builder for [`IntentFilter`](crate::model::IntentFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::IntentFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::IntentFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to use for the filter.</p>
        pub fn name(mut self, input: crate::model::IntentFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to use for the filter.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::IntentFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use for the filter.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use for the filter.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListIntents</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListIntents</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::IntentFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListIntents</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListIntents</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::IntentFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentFilter`](crate::model::IntentFilter)
        pub fn build(self) -> crate::model::IntentFilter {
            crate::model::IntentFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl IntentFilter {
    /// Creates a new builder-style object to manufacture [`IntentFilter`](crate::model::IntentFilter)
    pub fn builder() -> crate::model::intent_filter::Builder {
        crate::model::intent_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntentFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntentFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => IntentFilterOperator::Contains,
            "EQ" => IntentFilterOperator::Equals,
            other => IntentFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntentFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntentFilterOperator::from(s))
    }
}
impl IntentFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntentFilterOperator::Contains => "CO",
            IntentFilterOperator::Equals => "EQ",
            IntentFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for IntentFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntentFilterName {
    #[allow(missing_docs)] // documentation missing in model
    IntentName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntentFilterName {
    fn from(s: &str) -> Self {
        match s {
            "IntentName" => IntentFilterName::IntentName,
            other => IntentFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntentFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntentFilterName::from(s))
    }
}
impl IntentFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntentFilterName::IntentName => "IntentName",
            IntentFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IntentName"]
    }
}
impl AsRef<str> for IntentFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of intents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentSortBy {
    /// <p>The attribute to use to sort the list of intents.</p>
    pub attribute: std::option::Option<crate::model::IntentSortAttribute>,
    /// <p>The order to sort the list. You can choose ascending or
    /// descending.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for IntentSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`IntentSortBy`](crate::model::IntentSortBy)
pub mod intent_sort_by {
    /// A builder for [`IntentSortBy`](crate::model::IntentSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::IntentSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of intents.</p>
        pub fn attribute(mut self, input: crate::model::IntentSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of intents.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::IntentSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentSortBy`](crate::model::IntentSortBy)
        pub fn build(self) -> crate::model::IntentSortBy {
            crate::model::IntentSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl IntentSortBy {
    /// Creates a new builder-style object to manufacture [`IntentSortBy`](crate::model::IntentSortBy)
    pub fn builder() -> crate::model::intent_sort_by::Builder {
        crate::model::intent_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IntentSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    IntentName,
    #[allow(missing_docs)] // documentation missing in model
    LastUpdatedDateTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IntentSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "IntentName" => IntentSortAttribute::IntentName,
            "LastUpdatedDateTime" => IntentSortAttribute::LastUpdatedDateTime,
            other => IntentSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IntentSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IntentSortAttribute::from(s))
    }
}
impl IntentSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IntentSortAttribute::IntentName => "IntentName",
            IntentSortAttribute::LastUpdatedDateTime => "LastUpdatedDateTime",
            IntentSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IntentName", "LastUpdatedDateTime"]
    }
}
impl AsRef<str> for IntentSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about an import in an import
/// list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportSummary {
    /// <p>The unique identifier that Amazon Lex assigned to the import.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier that Amazon Lex assigned to the imported
    /// resource.</p>
    pub imported_resource_id: std::option::Option<std::string::String>,
    /// <p>The name that you gave the imported resource.</p>
    pub imported_resource_name: std::option::Option<std::string::String>,
    /// <p>The status of the resource. When the status is
    /// <code>Completed</code> the resource is ready to build.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
    /// <p>The strategy used to merge existing bot or bot locale definitions
    /// with the imported definition.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The date and time that the import was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the import was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ImportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportSummary");
        formatter.field("import_id", &self.import_id);
        formatter.field("imported_resource_id", &self.imported_resource_id);
        formatter.field("imported_resource_name", &self.imported_resource_name);
        formatter.field("import_status", &self.import_status);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`ImportSummary`](crate::model::ImportSummary)
pub mod import_summary {
    /// A builder for [`ImportSummary`](crate::model::ImportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) imported_resource_id: std::option::Option<std::string::String>,
        pub(crate) imported_resource_name: std::option::Option<std::string::String>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier that Amazon Lex assigned to the import.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the import.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the imported
        /// resource.</p>
        pub fn imported_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_resource_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the imported
        /// resource.</p>
        pub fn set_imported_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_resource_id = input;
            self
        }
        /// <p>The name that you gave the imported resource.</p>
        pub fn imported_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.imported_resource_name = Some(input.into());
            self
        }
        /// <p>The name that you gave the imported resource.</p>
        pub fn set_imported_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.imported_resource_name = input;
            self
        }
        /// <p>The status of the resource. When the status is
        /// <code>Completed</code> the resource is ready to build.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The status of the resource. When the status is
        /// <code>Completed</code> the resource is ready to build.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// <p>The strategy used to merge existing bot or bot locale definitions
        /// with the imported definition.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The strategy used to merge existing bot or bot locale definitions
        /// with the imported definition.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The date and time that the import was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the import was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the import was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the import was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportSummary`](crate::model::ImportSummary)
        pub fn build(self) -> crate::model::ImportSummary {
            crate::model::ImportSummary {
                import_id: self.import_id,
                imported_resource_id: self.imported_resource_id,
                imported_resource_name: self.imported_resource_name,
                import_status: self.import_status,
                merge_strategy: self.merge_strategy,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl ImportSummary {
    /// Creates a new builder-style object to manufacture [`ImportSummary`](crate::model::ImportSummary)
    pub fn builder() -> crate::model::import_summary::Builder {
        crate::model::import_summary::Builder::default()
    }
}

/// <p>Filters the response from the
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportFilter {
    /// <p>The name of the field to use for filtering.</p>
    pub name: std::option::Option<crate::model::ImportFilterName>,
    /// <p>The values to use to filter the response.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify EQ when the
    /// <code>ListImports</code> operation should return only resource types
    /// that equal the specified value. Specify CO when the
    /// <code>ListImports</code> operation should return resource types that
    /// contain the specified value.</p>
    pub operator: std::option::Option<crate::model::ImportFilterOperator>,
}
impl std::fmt::Debug for ImportFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`ImportFilter`](crate::model::ImportFilter)
pub mod import_filter {
    /// A builder for [`ImportFilter`](crate::model::ImportFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ImportFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::ImportFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to use for filtering.</p>
        pub fn name(mut self, input: crate::model::ImportFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to use for filtering.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ImportFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values to use to filter the response.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values to use to filter the response.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify EQ when the
        /// <code>ListImports</code> operation should return only resource types
        /// that equal the specified value. Specify CO when the
        /// <code>ListImports</code> operation should return resource types that
        /// contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::ImportFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify EQ when the
        /// <code>ListImports</code> operation should return only resource types
        /// that equal the specified value. Specify CO when the
        /// <code>ListImports</code> operation should return resource types that
        /// contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::ImportFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportFilter`](crate::model::ImportFilter)
        pub fn build(self) -> crate::model::ImportFilter {
            crate::model::ImportFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl ImportFilter {
    /// Creates a new builder-style object to manufacture [`ImportFilter`](crate::model::ImportFilter)
    pub fn builder() -> crate::model::import_filter::Builder {
        crate::model::import_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => ImportFilterOperator::Contains,
            "EQ" => ImportFilterOperator::Equals,
            other => ImportFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportFilterOperator::from(s))
    }
}
impl ImportFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportFilterOperator::Contains => "CO",
            ImportFilterOperator::Equals => "EQ",
            ImportFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for ImportFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportFilterName {
    #[allow(missing_docs)] // documentation missing in model
    ImportResourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportFilterName {
    fn from(s: &str) -> Self {
        match s {
            "ImportResourceType" => ImportFilterName::ImportResourceType,
            other => ImportFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportFilterName::from(s))
    }
}
impl ImportFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportFilterName::ImportResourceType => "ImportResourceType",
            ImportFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ImportResourceType"]
    }
}
impl AsRef<str> for ImportFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information for sorting a list of imports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportSortBy {
    /// <p>The export field to use for sorting.</p>
    pub attribute: std::option::Option<crate::model::ImportSortAttribute>,
    /// <p>The order to sort the list.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for ImportSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`ImportSortBy`](crate::model::ImportSortBy)
pub mod import_sort_by {
    /// A builder for [`ImportSortBy`](crate::model::ImportSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::ImportSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The export field to use for sorting.</p>
        pub fn attribute(mut self, input: crate::model::ImportSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The export field to use for sorting.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::ImportSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportSortBy`](crate::model::ImportSortBy)
        pub fn build(self) -> crate::model::ImportSortBy {
            crate::model::ImportSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl ImportSortBy {
    /// Creates a new builder-style object to manufacture [`ImportSortBy`](crate::model::ImportSortBy)
    pub fn builder() -> crate::model::import_sort_by::Builder {
        crate::model::import_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    LastUpdatedDateTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "LastUpdatedDateTime" => ImportSortAttribute::LastUpdatedDateTime,
            other => ImportSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportSortAttribute::from(s))
    }
}
impl ImportSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportSortAttribute::LastUpdatedDateTime => "LastUpdatedDateTime",
            ImportSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LastUpdatedDateTime"]
    }
}
impl AsRef<str> for ImportSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about an export in an export list.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSummary {
    /// <p>The unique identifier that Amazon Lex assigned to the export.</p>
    pub export_id: std::option::Option<std::string::String>,
    /// <p>Information about the bot or bot locale that was exported.</p>
    pub resource_specification: std::option::Option<crate::model::ExportResourceSpecification>,
    /// <p>The file format used in the export files.</p>
    pub file_format: std::option::Option<crate::model::ImportExportFileFormat>,
    /// <p>The status of the export. When the status is <code>Completed</code>
    /// the export is ready to download.</p>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>The date and time that the export was created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the export was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ExportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSummary");
        formatter.field("export_id", &self.export_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("file_format", &self.file_format);
        formatter.field("export_status", &self.export_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`ExportSummary`](crate::model::ExportSummary)
pub mod export_summary {
    /// A builder for [`ExportSummary`](crate::model::ExportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ExportResourceSpecification>,
        pub(crate) file_format: std::option::Option<crate::model::ImportExportFileFormat>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier that Amazon Lex assigned to the export.</p>
        pub fn export_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the export.</p>
        pub fn set_export_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.export_id = input;
            self
        }
        /// <p>Information about the bot or bot locale that was exported.</p>
        pub fn resource_specification(
            mut self,
            input: crate::model::ExportResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// <p>Information about the bot or bot locale that was exported.</p>
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ExportResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// <p>The file format used in the export files.</p>
        pub fn file_format(mut self, input: crate::model::ImportExportFileFormat) -> Self {
            self.file_format = Some(input);
            self
        }
        /// <p>The file format used in the export files.</p>
        pub fn set_file_format(
            mut self,
            input: std::option::Option<crate::model::ImportExportFileFormat>,
        ) -> Self {
            self.file_format = input;
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code>
        /// the export is ready to download.</p>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the export. When the status is <code>Completed</code>
        /// the export is ready to download.</p>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>The date and time that the export was created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>The date and time that the export was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the export was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSummary`](crate::model::ExportSummary)
        pub fn build(self) -> crate::model::ExportSummary {
            crate::model::ExportSummary {
                export_id: self.export_id,
                resource_specification: self.resource_specification,
                file_format: self.file_format,
                export_status: self.export_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl ExportSummary {
    /// Creates a new builder-style object to manufacture [`ExportSummary`](crate::model::ExportSummary)
    pub fn builder() -> crate::model::export_summary::Builder {
        crate::model::export_summary::Builder::default()
    }
}

/// <p>Filters the response form the
/// operation</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportFilter {
    /// <p>The name of the field to use for filtering.</p>
    pub name: std::option::Option<crate::model::ExportFilterName>,
    /// <p>The values to use to filter the response.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify EQ when the
    /// <code>ListExports</code> operation should return only resource types
    /// that equal the specified value. Specify CO when the
    /// <code>ListExports</code> operation should return resource types that
    /// contain the specified value.</p>
    pub operator: std::option::Option<crate::model::ExportFilterOperator>,
}
impl std::fmt::Debug for ExportFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`ExportFilter`](crate::model::ExportFilter)
pub mod export_filter {
    /// A builder for [`ExportFilter`](crate::model::ExportFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ExportFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::ExportFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to use for filtering.</p>
        pub fn name(mut self, input: crate::model::ExportFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to use for filtering.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ExportFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values to use to filter the response.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values to use to filter the response.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify EQ when the
        /// <code>ListExports</code> operation should return only resource types
        /// that equal the specified value. Specify CO when the
        /// <code>ListExports</code> operation should return resource types that
        /// contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::ExportFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify EQ when the
        /// <code>ListExports</code> operation should return only resource types
        /// that equal the specified value. Specify CO when the
        /// <code>ListExports</code> operation should return resource types that
        /// contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::ExportFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportFilter`](crate::model::ExportFilter)
        pub fn build(self) -> crate::model::ExportFilter {
            crate::model::ExportFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl ExportFilter {
    /// Creates a new builder-style object to manufacture [`ExportFilter`](crate::model::ExportFilter)
    pub fn builder() -> crate::model::export_filter::Builder {
        crate::model::export_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => ExportFilterOperator::Contains,
            "EQ" => ExportFilterOperator::Equals,
            other => ExportFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportFilterOperator::from(s))
    }
}
impl ExportFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportFilterOperator::Contains => "CO",
            ExportFilterOperator::Equals => "EQ",
            ExportFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for ExportFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportFilterName {
    #[allow(missing_docs)] // documentation missing in model
    ExportResourceType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportFilterName {
    fn from(s: &str) -> Self {
        match s {
            "ExportResourceType" => ExportFilterName::ExportResourceType,
            other => ExportFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportFilterName::from(s))
    }
}
impl ExportFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportFilterName::ExportResourceType => "ExportResourceType",
            ExportFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ExportResourceType"]
    }
}
impl AsRef<str> for ExportFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about sorting a list of exports.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSortBy {
    /// <p>The export field to use for sorting.</p>
    pub attribute: std::option::Option<crate::model::ExportSortAttribute>,
    /// <p>The order to sort the list.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for ExportSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`ExportSortBy`](crate::model::ExportSortBy)
pub mod export_sort_by {
    /// A builder for [`ExportSortBy`](crate::model::ExportSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::ExportSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The export field to use for sorting.</p>
        pub fn attribute(mut self, input: crate::model::ExportSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The export field to use for sorting.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::ExportSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSortBy`](crate::model::ExportSortBy)
        pub fn build(self) -> crate::model::ExportSortBy {
            crate::model::ExportSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl ExportSortBy {
    /// Creates a new builder-style object to manufacture [`ExportSortBy`](crate::model::ExportSortBy)
    pub fn builder() -> crate::model::export_sort_by::Builder {
        crate::model::export_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    LastUpdatedDateTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "LastUpdatedDateTime" => ExportSortAttribute::LastUpdatedDateTime,
            other => ExportSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportSortAttribute::from(s))
    }
}
impl ExportSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportSortAttribute::LastUpdatedDateTime => "LastUpdatedDateTime",
            ExportSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LastUpdatedDateTime"]
    }
}
impl AsRef<str> for ExportSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about a built-in slot type for the
/// <a>ListBuiltInSlotTypes</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltInSlotTypeSummary {
    /// <p>The signature of the built-in slot type. Use this to specify the
    /// parent slot type of a derived slot type.</p>
    pub slot_type_signature: std::option::Option<std::string::String>,
    /// <p>The description of the built-in slot type.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BuiltInSlotTypeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltInSlotTypeSummary");
        formatter.field("slot_type_signature", &self.slot_type_signature);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`BuiltInSlotTypeSummary`](crate::model::BuiltInSlotTypeSummary)
pub mod built_in_slot_type_summary {
    /// A builder for [`BuiltInSlotTypeSummary`](crate::model::BuiltInSlotTypeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signature of the built-in slot type. Use this to specify the
        /// parent slot type of a derived slot type.</p>
        pub fn slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_signature = Some(input.into());
            self
        }
        /// <p>The signature of the built-in slot type. Use this to specify the
        /// parent slot type of a derived slot type.</p>
        pub fn set_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_signature = input;
            self
        }
        /// <p>The description of the built-in slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the built-in slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltInSlotTypeSummary`](crate::model::BuiltInSlotTypeSummary)
        pub fn build(self) -> crate::model::BuiltInSlotTypeSummary {
            crate::model::BuiltInSlotTypeSummary {
                slot_type_signature: self.slot_type_signature,
                description: self.description,
            }
        }
    }
}
impl BuiltInSlotTypeSummary {
    /// Creates a new builder-style object to manufacture [`BuiltInSlotTypeSummary`](crate::model::BuiltInSlotTypeSummary)
    pub fn builder() -> crate::model::built_in_slot_type_summary::Builder {
        crate::model::built_in_slot_type_summary::Builder::default()
    }
}

/// <p>Specifies attributes for sorting a list of built-in slot
/// types.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltInSlotTypeSortBy {
    /// <p>The attribute to use to sort the list of built-in intents.</p>
    pub attribute: std::option::Option<crate::model::BuiltInSlotTypeSortAttribute>,
    /// <p>The order to sort the list. You can choose ascending or
    /// descending.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for BuiltInSlotTypeSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltInSlotTypeSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`BuiltInSlotTypeSortBy`](crate::model::BuiltInSlotTypeSortBy)
pub mod built_in_slot_type_sort_by {
    /// A builder for [`BuiltInSlotTypeSortBy`](crate::model::BuiltInSlotTypeSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::BuiltInSlotTypeSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of built-in intents.</p>
        pub fn attribute(mut self, input: crate::model::BuiltInSlotTypeSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of built-in intents.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::BuiltInSlotTypeSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltInSlotTypeSortBy`](crate::model::BuiltInSlotTypeSortBy)
        pub fn build(self) -> crate::model::BuiltInSlotTypeSortBy {
            crate::model::BuiltInSlotTypeSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl BuiltInSlotTypeSortBy {
    /// Creates a new builder-style object to manufacture [`BuiltInSlotTypeSortBy`](crate::model::BuiltInSlotTypeSortBy)
    pub fn builder() -> crate::model::built_in_slot_type_sort_by::Builder {
        crate::model::built_in_slot_type_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BuiltInSlotTypeSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    SlotTypeSignature,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BuiltInSlotTypeSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "SlotTypeSignature" => BuiltInSlotTypeSortAttribute::SlotTypeSignature,
            other => BuiltInSlotTypeSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BuiltInSlotTypeSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BuiltInSlotTypeSortAttribute::from(s))
    }
}
impl BuiltInSlotTypeSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BuiltInSlotTypeSortAttribute::SlotTypeSignature => "SlotTypeSignature",
            BuiltInSlotTypeSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SlotTypeSignature"]
    }
}
impl AsRef<str> for BuiltInSlotTypeSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about a built-in intent for the <a>ListBuiltInIntents</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltInIntentSummary {
    /// <p>The signature of the built-in intent. Use this to specify the parent
    /// intent of a derived intent.</p>
    pub intent_signature: std::option::Option<std::string::String>,
    /// <p>The description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BuiltInIntentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltInIntentSummary");
        formatter.field("intent_signature", &self.intent_signature);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`BuiltInIntentSummary`](crate::model::BuiltInIntentSummary)
pub mod built_in_intent_summary {
    /// A builder for [`BuiltInIntentSummary`](crate::model::BuiltInIntentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_signature: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signature of the built-in intent. Use this to specify the parent
        /// intent of a derived intent.</p>
        pub fn intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_signature = Some(input.into());
            self
        }
        /// <p>The signature of the built-in intent. Use this to specify the parent
        /// intent of a derived intent.</p>
        pub fn set_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.intent_signature = input;
            self
        }
        /// <p>The description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltInIntentSummary`](crate::model::BuiltInIntentSummary)
        pub fn build(self) -> crate::model::BuiltInIntentSummary {
            crate::model::BuiltInIntentSummary {
                intent_signature: self.intent_signature,
                description: self.description,
            }
        }
    }
}
impl BuiltInIntentSummary {
    /// Creates a new builder-style object to manufacture [`BuiltInIntentSummary`](crate::model::BuiltInIntentSummary)
    pub fn builder() -> crate::model::built_in_intent_summary::Builder {
        crate::model::built_in_intent_summary::Builder::default()
    }
}

/// <p>Specifies attributes for sorting a list of built-in intents.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltInIntentSortBy {
    /// <p>The attribute to use to sort the list of built-in intents.</p>
    pub attribute: std::option::Option<crate::model::BuiltInIntentSortAttribute>,
    /// <p>The order to sort the list. You can specify ascending or descending
    /// order.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for BuiltInIntentSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltInIntentSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`BuiltInIntentSortBy`](crate::model::BuiltInIntentSortBy)
pub mod built_in_intent_sort_by {
    /// A builder for [`BuiltInIntentSortBy`](crate::model::BuiltInIntentSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::BuiltInIntentSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of built-in intents.</p>
        pub fn attribute(mut self, input: crate::model::BuiltInIntentSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of built-in intents.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::BuiltInIntentSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can specify ascending or descending
        /// order.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can specify ascending or descending
        /// order.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltInIntentSortBy`](crate::model::BuiltInIntentSortBy)
        pub fn build(self) -> crate::model::BuiltInIntentSortBy {
            crate::model::BuiltInIntentSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl BuiltInIntentSortBy {
    /// Creates a new builder-style object to manufacture [`BuiltInIntentSortBy`](crate::model::BuiltInIntentSortBy)
    pub fn builder() -> crate::model::built_in_intent_sort_by::Builder {
        crate::model::built_in_intent_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BuiltInIntentSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    IntentSignature,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BuiltInIntentSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "IntentSignature" => BuiltInIntentSortAttribute::IntentSignature,
            other => BuiltInIntentSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BuiltInIntentSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BuiltInIntentSortAttribute::from(s))
    }
}
impl BuiltInIntentSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BuiltInIntentSortAttribute::IntentSignature => "IntentSignature",
            BuiltInIntentSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IntentSignature"]
    }
}
impl AsRef<str> for BuiltInIntentSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a bot version returned by the <a>ListBotVersions</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotVersionSummary {
    /// <p>The name of the bot associated with the version.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The numeric version of the bot, or <code>DRAFT</code> to indicate
    /// that this is the version of the bot that can be updated..</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the bot. When the status is available, the version of
    /// the bot is ready for use.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>A timestamp of the date and time that the version was
    /// created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotVersionSummary");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("description", &self.description);
        formatter.field("bot_status", &self.bot_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.finish()
    }
}
/// See [`BotVersionSummary`](crate::model::BotVersionSummary)
pub mod bot_version_summary {
    /// A builder for [`BotVersionSummary`](crate::model::BotVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the bot associated with the version.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot associated with the version.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The numeric version of the bot, or <code>DRAFT</code> to indicate
        /// that this is the version of the bot that can be updated..</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The numeric version of the bot, or <code>DRAFT</code> to indicate
        /// that this is the version of the bot that can be updated..</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the bot. When the status is available, the version of
        /// the bot is ready for use.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The status of the bot. When the status is available, the version of
        /// the bot is ready for use.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the version was
        /// created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the version was
        /// created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BotVersionSummary`](crate::model::BotVersionSummary)
        pub fn build(self) -> crate::model::BotVersionSummary {
            crate::model::BotVersionSummary {
                bot_name: self.bot_name,
                bot_version: self.bot_version,
                description: self.description,
                bot_status: self.bot_status,
                creation_date_time: self.creation_date_time,
            }
        }
    }
}
impl BotVersionSummary {
    /// Creates a new builder-style object to manufacture [`BotVersionSummary`](crate::model::BotVersionSummary)
    pub fn builder() -> crate::model::bot_version_summary::Builder {
        crate::model::bot_version_summary::Builder::default()
    }
}

/// <p>Specifies attributes for sorting a list of bot versions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotVersionSortBy {
    /// <p>The attribute to use to sort the list of versions.</p>
    pub attribute: std::option::Option<crate::model::BotVersionSortAttribute>,
    /// <p>The order to sort the list. You can specify ascending or descending
    /// order.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for BotVersionSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotVersionSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`BotVersionSortBy`](crate::model::BotVersionSortBy)
pub mod bot_version_sort_by {
    /// A builder for [`BotVersionSortBy`](crate::model::BotVersionSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::BotVersionSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of versions.</p>
        pub fn attribute(mut self, input: crate::model::BotVersionSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of versions.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::BotVersionSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can specify ascending or descending
        /// order.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can specify ascending or descending
        /// order.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`BotVersionSortBy`](crate::model::BotVersionSortBy)
        pub fn build(self) -> crate::model::BotVersionSortBy {
            crate::model::BotVersionSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl BotVersionSortBy {
    /// Creates a new builder-style object to manufacture [`BotVersionSortBy`](crate::model::BotVersionSortBy)
    pub fn builder() -> crate::model::bot_version_sort_by::Builder {
        crate::model::bot_version_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotVersionSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    BotVersion,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotVersionSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "BotVersion" => BotVersionSortAttribute::BotVersion,
            other => BotVersionSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotVersionSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotVersionSortAttribute::from(s))
    }
}
impl BotVersionSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotVersionSortAttribute::BotVersion => "BotVersion",
            BotVersionSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BotVersion"]
    }
}
impl AsRef<str> for BotVersionSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about a bot returned by the <a>ListBots</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotSummary {
    /// <p>The unique identifier assigned to the bot. Use this ID to get
    /// detailed information about the bot with the <a>DescribeBot</a> operation.</p>
    pub bot_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the bot. When the status is
    /// <code>Available</code> the bot is ready for use.</p>
    pub bot_status: std::option::Option<crate::model::BotStatus>,
    /// <p>The latest numerical version in use for the bot.</p>
    pub latest_bot_version: std::option::Option<std::string::String>,
    /// <p>The date and time that the bot was last updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotSummary");
        formatter.field("bot_id", &self.bot_id);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("description", &self.description);
        formatter.field("bot_status", &self.bot_status);
        formatter.field("latest_bot_version", &self.latest_bot_version);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`BotSummary`](crate::model::BotSummary)
pub mod bot_summary {
    /// A builder for [`BotSummary`](crate::model::BotSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_status: std::option::Option<crate::model::BotStatus>,
        pub(crate) latest_bot_version: std::option::Option<std::string::String>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the bot. Use this ID to get
        /// detailed information about the bot with the <a>DescribeBot</a> operation.</p>
        pub fn bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the bot. Use this ID to get
        /// detailed information about the bot with the <a>DescribeBot</a> operation.</p>
        pub fn set_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_id = input;
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the bot. When the status is
        /// <code>Available</code> the bot is ready for use.</p>
        pub fn bot_status(mut self, input: crate::model::BotStatus) -> Self {
            self.bot_status = Some(input);
            self
        }
        /// <p>The current status of the bot. When the status is
        /// <code>Available</code> the bot is ready for use.</p>
        pub fn set_bot_status(
            mut self,
            input: std::option::Option<crate::model::BotStatus>,
        ) -> Self {
            self.bot_status = input;
            self
        }
        /// <p>The latest numerical version in use for the bot.</p>
        pub fn latest_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_bot_version = Some(input.into());
            self
        }
        /// <p>The latest numerical version in use for the bot.</p>
        pub fn set_latest_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_bot_version = input;
            self
        }
        /// <p>The date and time that the bot was last updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>The date and time that the bot was last updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BotSummary`](crate::model::BotSummary)
        pub fn build(self) -> crate::model::BotSummary {
            crate::model::BotSummary {
                bot_id: self.bot_id,
                bot_name: self.bot_name,
                description: self.description,
                bot_status: self.bot_status,
                latest_bot_version: self.latest_bot_version,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl BotSummary {
    /// Creates a new builder-style object to manufacture [`BotSummary`](crate::model::BotSummary)
    pub fn builder() -> crate::model::bot_summary::Builder {
        crate::model::bot_summary::Builder::default()
    }
}

/// <p>Filters the responses returned by the <code>ListBots</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotFilter {
    /// <p>The name of the field to filter the list of bots.</p>
    pub name: std::option::Option<crate::model::BotFilterName>,
    /// <p>The value to use for filtering the list of bots.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListBots</code> operation should return only aliases that
    /// equal the specified value. Specify <code>CO</code> when the
    /// <code>ListBots</code> operation should return aliases that contain
    /// the specified value.</p>
    pub operator: std::option::Option<crate::model::BotFilterOperator>,
}
impl std::fmt::Debug for BotFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`BotFilter`](crate::model::BotFilter)
pub mod bot_filter {
    /// A builder for [`BotFilter`](crate::model::BotFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::BotFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::BotFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to filter the list of bots.</p>
        pub fn name(mut self, input: crate::model::BotFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to filter the list of bots.</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::BotFilterName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListBots</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListBots</code> operation should return aliases that contain
        /// the specified value.</p>
        pub fn operator(mut self, input: crate::model::BotFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListBots</code> operation should return only aliases that
        /// equal the specified value. Specify <code>CO</code> when the
        /// <code>ListBots</code> operation should return aliases that contain
        /// the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::BotFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`BotFilter`](crate::model::BotFilter)
        pub fn build(self) -> crate::model::BotFilter {
            crate::model::BotFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl BotFilter {
    /// Creates a new builder-style object to manufacture [`BotFilter`](crate::model::BotFilter)
    pub fn builder() -> crate::model::bot_filter::Builder {
        crate::model::bot_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => BotFilterOperator::Contains,
            "EQ" => BotFilterOperator::Equals,
            other => BotFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotFilterOperator::from(s))
    }
}
impl BotFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotFilterOperator::Contains => "CO",
            BotFilterOperator::Equals => "EQ",
            BotFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for BotFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotFilterName {
    #[allow(missing_docs)] // documentation missing in model
    BotName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotFilterName {
    fn from(s: &str) -> Self {
        match s {
            "BotName" => BotFilterName::BotName,
            other => BotFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotFilterName::from(s))
    }
}
impl BotFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotFilterName::BotName => "BotName",
            BotFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BotName"]
    }
}
impl AsRef<str> for BotFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of bots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotSortBy {
    /// <p>The attribute to use to sort the list of bots.</p>
    pub attribute: std::option::Option<crate::model::BotSortAttribute>,
    /// <p>The order to sort the list. You can choose ascending or
    /// descending.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for BotSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`BotSortBy`](crate::model::BotSortBy)
pub mod bot_sort_by {
    /// A builder for [`BotSortBy`](crate::model::BotSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::BotSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The attribute to use to sort the list of bots.</p>
        pub fn attribute(mut self, input: crate::model::BotSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The attribute to use to sort the list of bots.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::BotSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order to sort the list. You can choose ascending or
        /// descending.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`BotSortBy`](crate::model::BotSortBy)
        pub fn build(self) -> crate::model::BotSortBy {
            crate::model::BotSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl BotSortBy {
    /// Creates a new builder-style object to manufacture [`BotSortBy`](crate::model::BotSortBy)
    pub fn builder() -> crate::model::bot_sort_by::Builder {
        crate::model::bot_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    BotName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "BotName" => BotSortAttribute::BotName,
            other => BotSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotSortAttribute::from(s))
    }
}
impl BotSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotSortAttribute::BotName => "BotName",
            BotSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BotName"]
    }
}
impl AsRef<str> for BotSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about bot locales returned by the <a>ListBotLocales</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleSummary {
    /// <p>The language and locale of the bot locale.</p>
    pub locale_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot locale.</p>
    pub locale_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot locale.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The current status of the bot locale. When the status is
    /// <code>Built</code> the locale is ready for use.</p>
    pub bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
    /// <p>A timestamp of the date and time that the bot locale was last
    /// updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp of the date and time that the bot locale was last
    /// built.</p>
    pub last_build_submitted_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotLocaleSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleSummary");
        formatter.field("locale_id", &self.locale_id);
        formatter.field("locale_name", &self.locale_name);
        formatter.field("description", &self.description);
        formatter.field("bot_locale_status", &self.bot_locale_status);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.field(
            "last_build_submitted_date_time",
            &self.last_build_submitted_date_time,
        );
        formatter.finish()
    }
}
/// See [`BotLocaleSummary`](crate::model::BotLocaleSummary)
pub mod bot_locale_summary {
    /// A builder for [`BotLocaleSummary`](crate::model::BotLocaleSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale_id: std::option::Option<std::string::String>,
        pub(crate) locale_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_locale_status: std::option::Option<crate::model::BotLocaleStatus>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_build_submitted_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The language and locale of the bot locale.</p>
        pub fn locale_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_id = Some(input.into());
            self
        }
        /// <p>The language and locale of the bot locale.</p>
        pub fn set_locale_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_id = input;
            self
        }
        /// <p>The name of the bot locale.</p>
        pub fn locale_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale_name = Some(input.into());
            self
        }
        /// <p>The name of the bot locale.</p>
        pub fn set_locale_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale_name = input;
            self
        }
        /// <p>The description of the bot locale.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot locale.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The current status of the bot locale. When the status is
        /// <code>Built</code> the locale is ready for use.</p>
        pub fn bot_locale_status(mut self, input: crate::model::BotLocaleStatus) -> Self {
            self.bot_locale_status = Some(input);
            self
        }
        /// <p>The current status of the bot locale. When the status is
        /// <code>Built</code> the locale is ready for use.</p>
        pub fn set_bot_locale_status(
            mut self,
            input: std::option::Option<crate::model::BotLocaleStatus>,
        ) -> Self {
            self.bot_locale_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot locale was last
        /// updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot locale was last
        /// updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot locale was last
        /// built.</p>
        pub fn last_build_submitted_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_build_submitted_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot locale was last
        /// built.</p>
        pub fn set_last_build_submitted_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_build_submitted_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleSummary`](crate::model::BotLocaleSummary)
        pub fn build(self) -> crate::model::BotLocaleSummary {
            crate::model::BotLocaleSummary {
                locale_id: self.locale_id,
                locale_name: self.locale_name,
                description: self.description,
                bot_locale_status: self.bot_locale_status,
                last_updated_date_time: self.last_updated_date_time,
                last_build_submitted_date_time: self.last_build_submitted_date_time,
            }
        }
    }
}
impl BotLocaleSummary {
    /// Creates a new builder-style object to manufacture [`BotLocaleSummary`](crate::model::BotLocaleSummary)
    pub fn builder() -> crate::model::bot_locale_summary::Builder {
        crate::model::bot_locale_summary::Builder::default()
    }
}

/// <p>Filters responses returned by the <code>ListBotLocales</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleFilter {
    /// <p>The name of the field to filter the list of bots.</p>
    pub name: std::option::Option<crate::model::BotLocaleFilterName>,
    /// <p>The value to use for filtering the list of bots.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListBotLocales</code> operation should return only aliases
    /// that equal the specified value. Specify <code>CO</code> when the
    /// <code>ListBotLocales</code> operation should return aliases that
    /// contain the specified value.</p>
    pub operator: std::option::Option<crate::model::BotLocaleFilterOperator>,
}
impl std::fmt::Debug for BotLocaleFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`BotLocaleFilter`](crate::model::BotLocaleFilter)
pub mod bot_locale_filter {
    /// A builder for [`BotLocaleFilter`](crate::model::BotLocaleFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::BotLocaleFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::BotLocaleFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to filter the list of bots.</p>
        pub fn name(mut self, input: crate::model::BotLocaleFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to filter the list of bots.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::BotLocaleFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListBotLocales</code> operation should return only aliases
        /// that equal the specified value. Specify <code>CO</code> when the
        /// <code>ListBotLocales</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::BotLocaleFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListBotLocales</code> operation should return only aliases
        /// that equal the specified value. Specify <code>CO</code> when the
        /// <code>ListBotLocales</code> operation should return aliases that
        /// contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::BotLocaleFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleFilter`](crate::model::BotLocaleFilter)
        pub fn build(self) -> crate::model::BotLocaleFilter {
            crate::model::BotLocaleFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl BotLocaleFilter {
    /// Creates a new builder-style object to manufacture [`BotLocaleFilter`](crate::model::BotLocaleFilter)
    pub fn builder() -> crate::model::bot_locale_filter::Builder {
        crate::model::bot_locale_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotLocaleFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotLocaleFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => BotLocaleFilterOperator::Contains,
            "EQ" => BotLocaleFilterOperator::Equals,
            other => BotLocaleFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotLocaleFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotLocaleFilterOperator::from(s))
    }
}
impl BotLocaleFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotLocaleFilterOperator::Contains => "CO",
            BotLocaleFilterOperator::Equals => "EQ",
            BotLocaleFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for BotLocaleFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotLocaleFilterName {
    #[allow(missing_docs)] // documentation missing in model
    BotLocaleName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotLocaleFilterName {
    fn from(s: &str) -> Self {
        match s {
            "BotLocaleName" => BotLocaleFilterName::BotLocaleName,
            other => BotLocaleFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotLocaleFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotLocaleFilterName::from(s))
    }
}
impl BotLocaleFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotLocaleFilterName::BotLocaleName => "BotLocaleName",
            BotLocaleFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BotLocaleName"]
    }
}
impl AsRef<str> for BotLocaleFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of bot locales.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleSortBy {
    /// <p>The bot locale attribute to sort by.</p>
    pub attribute: std::option::Option<crate::model::BotLocaleSortAttribute>,
    /// <p>Specifies whether to sort the bot locales in ascending or descending
    /// order.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for BotLocaleSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`BotLocaleSortBy`](crate::model::BotLocaleSortBy)
pub mod bot_locale_sort_by {
    /// A builder for [`BotLocaleSortBy`](crate::model::BotLocaleSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::BotLocaleSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The bot locale attribute to sort by.</p>
        pub fn attribute(mut self, input: crate::model::BotLocaleSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The bot locale attribute to sort by.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::BotLocaleSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>Specifies whether to sort the bot locales in ascending or descending
        /// order.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>Specifies whether to sort the bot locales in ascending or descending
        /// order.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleSortBy`](crate::model::BotLocaleSortBy)
        pub fn build(self) -> crate::model::BotLocaleSortBy {
            crate::model::BotLocaleSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl BotLocaleSortBy {
    /// Creates a new builder-style object to manufacture [`BotLocaleSortBy`](crate::model::BotLocaleSortBy)
    pub fn builder() -> crate::model::bot_locale_sort_by::Builder {
        crate::model::bot_locale_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BotLocaleSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    BotLocaleName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BotLocaleSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "BotLocaleName" => BotLocaleSortAttribute::BotLocaleName,
            other => BotLocaleSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BotLocaleSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BotLocaleSortAttribute::from(s))
    }
}
impl BotLocaleSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BotLocaleSortAttribute::BotLocaleName => "BotLocaleName",
            BotLocaleSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BotLocaleName"]
    }
}
impl AsRef<str> for BotLocaleSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Summary information about bot aliases returned from the <a>ListBotAliases</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotAliasSummary {
    /// <p>The unique identifier assigned to the bot alias. You can use this ID
    /// to get detailed information about the alias using the <a>DescribeBotAlias</a> operation.</p>
    pub bot_alias_id: std::option::Option<std::string::String>,
    /// <p>The name of the bot alias.</p>
    pub bot_alias_name: std::option::Option<std::string::String>,
    /// <p>The description of the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot that the bot alias references.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The current state of the bot alias. If the status is
    /// <code>Available</code>, the alias is ready for use.</p>
    pub bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
    /// <p>A timestamp of the date and time that the bot alias was
    /// created.</p>
    pub creation_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A timestamp of the date and time that the bot alias was last
    /// updated.</p>
    pub last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotAliasSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotAliasSummary");
        formatter.field("bot_alias_id", &self.bot_alias_id);
        formatter.field("bot_alias_name", &self.bot_alias_name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_alias_status", &self.bot_alias_status);
        formatter.field("creation_date_time", &self.creation_date_time);
        formatter.field("last_updated_date_time", &self.last_updated_date_time);
        formatter.finish()
    }
}
/// See [`BotAliasSummary`](crate::model::BotAliasSummary)
pub mod bot_alias_summary {
    /// A builder for [`BotAliasSummary`](crate::model::BotAliasSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_alias_id: std::option::Option<std::string::String>,
        pub(crate) bot_alias_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_alias_status: std::option::Option<crate::model::BotAliasStatus>,
        pub(crate) creation_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The unique identifier assigned to the bot alias. You can use this ID
        /// to get detailed information about the alias using the <a>DescribeBotAlias</a> operation.</p>
        pub fn bot_alias_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_id = Some(input.into());
            self
        }
        /// <p>The unique identifier assigned to the bot alias. You can use this ID
        /// to get detailed information about the alias using the <a>DescribeBotAlias</a> operation.</p>
        pub fn set_bot_alias_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias_id = input;
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn bot_alias_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias_name = Some(input.into());
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn set_bot_alias_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bot_alias_name = input;
            self
        }
        /// <p>The description of the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot that the bot alias references.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that the bot alias references.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The current state of the bot alias. If the status is
        /// <code>Available</code>, the alias is ready for use.</p>
        pub fn bot_alias_status(mut self, input: crate::model::BotAliasStatus) -> Self {
            self.bot_alias_status = Some(input);
            self
        }
        /// <p>The current state of the bot alias. If the status is
        /// <code>Available</code>, the alias is ready for use.</p>
        pub fn set_bot_alias_status(
            mut self,
            input: std::option::Option<crate::model::BotAliasStatus>,
        ) -> Self {
            self.bot_alias_status = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot alias was
        /// created.</p>
        pub fn creation_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot alias was
        /// created.</p>
        pub fn set_creation_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date_time = input;
            self
        }
        /// <p>A timestamp of the date and time that the bot alias was last
        /// updated.</p>
        pub fn last_updated_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date_time = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the bot alias was last
        /// updated.</p>
        pub fn set_last_updated_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BotAliasSummary`](crate::model::BotAliasSummary)
        pub fn build(self) -> crate::model::BotAliasSummary {
            crate::model::BotAliasSummary {
                bot_alias_id: self.bot_alias_id,
                bot_alias_name: self.bot_alias_name,
                description: self.description,
                bot_version: self.bot_version,
                bot_alias_status: self.bot_alias_status,
                creation_date_time: self.creation_date_time,
                last_updated_date_time: self.last_updated_date_time,
            }
        }
    }
}
impl BotAliasSummary {
    /// Creates a new builder-style object to manufacture [`BotAliasSummary`](crate::model::BotAliasSummary)
    pub fn builder() -> crate::model::bot_alias_summary::Builder {
        crate::model::bot_alias_summary::Builder::default()
    }
}

/// <p>Provides summary information for aggregated utterances. The
/// <code>ListAggregatedUtterances</code> operations combines all
/// instances of the same utterance into a single aggregated
/// summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedUtterancesSummary {
    /// <p>The text of the utterance. If the utterance was used with the
    /// <code>RecognizeUtterance</code> operation, the text is the
    /// transcription of the audio utterance.</p>
    pub utterance: std::option::Option<std::string::String>,
    /// <p>The number of times that the utterance was detected by Amazon Lex during
    /// the time period. When an utterance is detected, it activates an intent
    /// or a slot.</p>
    pub hit_count: std::option::Option<i32>,
    /// <p>The number of times that the utterance was missed by Amazon Lex An
    /// utterance is missed when it doesn't activate an intent or slot.</p>
    pub missed_count: std::option::Option<i32>,
    /// <p>The date and time that the utterance was first recorded in the time
    /// window for aggregation. An utterance may have been sent to Amazon Lex before
    /// that time, but only utterances within the time window are
    /// counted.</p>
    pub utterance_first_recorded_in_aggregation_duration:
        std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last date and time that an utterance was recorded in the time
    /// window for aggregation. An utterance may be sent to Amazon Lex after that
    /// time, but only utterances within the time window are counted.</p>
    pub utterance_last_recorded_in_aggregation_duration:
        std::option::Option<aws_smithy_types::Instant>,
    /// <p>Aggregated utterance data may contain utterances from versions of
    /// your bot that have since been deleted. When the aggregated contains
    /// this kind of data, this field is set to true.</p>
    pub contains_data_from_deleted_resources: std::option::Option<bool>,
}
impl std::fmt::Debug for AggregatedUtterancesSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedUtterancesSummary");
        formatter.field("utterance", &self.utterance);
        formatter.field("hit_count", &self.hit_count);
        formatter.field("missed_count", &self.missed_count);
        formatter.field(
            "utterance_first_recorded_in_aggregation_duration",
            &self.utterance_first_recorded_in_aggregation_duration,
        );
        formatter.field(
            "utterance_last_recorded_in_aggregation_duration",
            &self.utterance_last_recorded_in_aggregation_duration,
        );
        formatter.field(
            "contains_data_from_deleted_resources",
            &self.contains_data_from_deleted_resources,
        );
        formatter.finish()
    }
}
/// See [`AggregatedUtterancesSummary`](crate::model::AggregatedUtterancesSummary)
pub mod aggregated_utterances_summary {
    /// A builder for [`AggregatedUtterancesSummary`](crate::model::AggregatedUtterancesSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utterance: std::option::Option<std::string::String>,
        pub(crate) hit_count: std::option::Option<i32>,
        pub(crate) missed_count: std::option::Option<i32>,
        pub(crate) utterance_first_recorded_in_aggregation_duration:
            std::option::Option<aws_smithy_types::Instant>,
        pub(crate) utterance_last_recorded_in_aggregation_duration:
            std::option::Option<aws_smithy_types::Instant>,
        pub(crate) contains_data_from_deleted_resources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The text of the utterance. If the utterance was used with the
        /// <code>RecognizeUtterance</code> operation, the text is the
        /// transcription of the audio utterance.</p>
        pub fn utterance(mut self, input: impl Into<std::string::String>) -> Self {
            self.utterance = Some(input.into());
            self
        }
        /// <p>The text of the utterance. If the utterance was used with the
        /// <code>RecognizeUtterance</code> operation, the text is the
        /// transcription of the audio utterance.</p>
        pub fn set_utterance(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.utterance = input;
            self
        }
        /// <p>The number of times that the utterance was detected by Amazon Lex during
        /// the time period. When an utterance is detected, it activates an intent
        /// or a slot.</p>
        pub fn hit_count(mut self, input: i32) -> Self {
            self.hit_count = Some(input);
            self
        }
        /// <p>The number of times that the utterance was detected by Amazon Lex during
        /// the time period. When an utterance is detected, it activates an intent
        /// or a slot.</p>
        pub fn set_hit_count(mut self, input: std::option::Option<i32>) -> Self {
            self.hit_count = input;
            self
        }
        /// <p>The number of times that the utterance was missed by Amazon Lex An
        /// utterance is missed when it doesn't activate an intent or slot.</p>
        pub fn missed_count(mut self, input: i32) -> Self {
            self.missed_count = Some(input);
            self
        }
        /// <p>The number of times that the utterance was missed by Amazon Lex An
        /// utterance is missed when it doesn't activate an intent or slot.</p>
        pub fn set_missed_count(mut self, input: std::option::Option<i32>) -> Self {
            self.missed_count = input;
            self
        }
        /// <p>The date and time that the utterance was first recorded in the time
        /// window for aggregation. An utterance may have been sent to Amazon Lex before
        /// that time, but only utterances within the time window are
        /// counted.</p>
        pub fn utterance_first_recorded_in_aggregation_duration(
            mut self,
            input: aws_smithy_types::Instant,
        ) -> Self {
            self.utterance_first_recorded_in_aggregation_duration = Some(input);
            self
        }
        /// <p>The date and time that the utterance was first recorded in the time
        /// window for aggregation. An utterance may have been sent to Amazon Lex before
        /// that time, but only utterances within the time window are
        /// counted.</p>
        pub fn set_utterance_first_recorded_in_aggregation_duration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.utterance_first_recorded_in_aggregation_duration = input;
            self
        }
        /// <p>The last date and time that an utterance was recorded in the time
        /// window for aggregation. An utterance may be sent to Amazon Lex after that
        /// time, but only utterances within the time window are counted.</p>
        pub fn utterance_last_recorded_in_aggregation_duration(
            mut self,
            input: aws_smithy_types::Instant,
        ) -> Self {
            self.utterance_last_recorded_in_aggregation_duration = Some(input);
            self
        }
        /// <p>The last date and time that an utterance was recorded in the time
        /// window for aggregation. An utterance may be sent to Amazon Lex after that
        /// time, but only utterances within the time window are counted.</p>
        pub fn set_utterance_last_recorded_in_aggregation_duration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.utterance_last_recorded_in_aggregation_duration = input;
            self
        }
        /// <p>Aggregated utterance data may contain utterances from versions of
        /// your bot that have since been deleted. When the aggregated contains
        /// this kind of data, this field is set to true.</p>
        pub fn contains_data_from_deleted_resources(mut self, input: bool) -> Self {
            self.contains_data_from_deleted_resources = Some(input);
            self
        }
        /// <p>Aggregated utterance data may contain utterances from versions of
        /// your bot that have since been deleted. When the aggregated contains
        /// this kind of data, this field is set to true.</p>
        pub fn set_contains_data_from_deleted_resources(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.contains_data_from_deleted_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedUtterancesSummary`](crate::model::AggregatedUtterancesSummary)
        pub fn build(self) -> crate::model::AggregatedUtterancesSummary {
            crate::model::AggregatedUtterancesSummary {
                utterance: self.utterance,
                hit_count: self.hit_count,
                missed_count: self.missed_count,
                utterance_first_recorded_in_aggregation_duration: self
                    .utterance_first_recorded_in_aggregation_duration,
                utterance_last_recorded_in_aggregation_duration: self
                    .utterance_last_recorded_in_aggregation_duration,
                contains_data_from_deleted_resources: self.contains_data_from_deleted_resources,
            }
        }
    }
}
impl AggregatedUtterancesSummary {
    /// Creates a new builder-style object to manufacture [`AggregatedUtterancesSummary`](crate::model::AggregatedUtterancesSummary)
    pub fn builder() -> crate::model::aggregated_utterances_summary::Builder {
        crate::model::aggregated_utterances_summary::Builder::default()
    }
}

/// <p>Provides parameters for setting the time window and duration for
/// aggregating utterance data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UtteranceAggregationDuration {
    /// <p>The desired time window for aggregating utterances. </p>
    pub relative_aggregation_duration:
        std::option::Option<crate::model::RelativeAggregationDuration>,
}
impl std::fmt::Debug for UtteranceAggregationDuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UtteranceAggregationDuration");
        formatter.field(
            "relative_aggregation_duration",
            &self.relative_aggregation_duration,
        );
        formatter.finish()
    }
}
/// See [`UtteranceAggregationDuration`](crate::model::UtteranceAggregationDuration)
pub mod utterance_aggregation_duration {
    /// A builder for [`UtteranceAggregationDuration`](crate::model::UtteranceAggregationDuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relative_aggregation_duration:
            std::option::Option<crate::model::RelativeAggregationDuration>,
    }
    impl Builder {
        /// <p>The desired time window for aggregating utterances. </p>
        pub fn relative_aggregation_duration(
            mut self,
            input: crate::model::RelativeAggregationDuration,
        ) -> Self {
            self.relative_aggregation_duration = Some(input);
            self
        }
        /// <p>The desired time window for aggregating utterances. </p>
        pub fn set_relative_aggregation_duration(
            mut self,
            input: std::option::Option<crate::model::RelativeAggregationDuration>,
        ) -> Self {
            self.relative_aggregation_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`UtteranceAggregationDuration`](crate::model::UtteranceAggregationDuration)
        pub fn build(self) -> crate::model::UtteranceAggregationDuration {
            crate::model::UtteranceAggregationDuration {
                relative_aggregation_duration: self.relative_aggregation_duration,
            }
        }
    }
}
impl UtteranceAggregationDuration {
    /// Creates a new builder-style object to manufacture [`UtteranceAggregationDuration`](crate::model::UtteranceAggregationDuration)
    pub fn builder() -> crate::model::utterance_aggregation_duration::Builder {
        crate::model::utterance_aggregation_duration::Builder::default()
    }
}

/// <p>Specifies the time window that utterance statistics are returned
/// for. The time window is always relative to the last time that the that
/// utterances were aggregated. For example, if the
/// <code>ListAggregatedUtterances</code> operation is called at 1600,
/// the time window is set to 1 hour, and the last refresh time was 1530,
/// only utterances made between 1430 and 1530 are returned.</p>
/// <p>You can choose the time window that statistics should be returned
/// for.</p>
/// <ul>
/// <li>
/// <p>
/// <b>Hours</b> - You can request
/// utterance statistics for 1, 3, 6, 12, or 24 hour time windows.
/// Statistics are refreshed every half hour for 1 hour time windows,
/// and hourly for the other time windows.</p>
/// </li>
/// <li>
/// <p>
/// <b>Days</b> - You can request
/// utterance statistics for 3 days. Statistics are refreshed every 6
/// hours.</p>
/// </li>
/// <li>
/// <p>
/// <b>Weeks</b> - You can see
/// statistics for one or two weeks. Statistics are refreshed every
/// 12 hours for one week time windows, and once per day for two week
/// time windows.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelativeAggregationDuration {
    /// <p>The type of time period that the <code>timeValue</code> field
    /// represents. </p>
    pub time_dimension: std::option::Option<crate::model::TimeDimension>,
    /// <p>The period of the time window to gather statistics for. The valid
    /// value depends on the setting of the <code>timeDimension</code>
    /// field.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Hours</code> - 1/3/6/12/24</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Days</code> - 3</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Weeks</code> - 1/2</p>
    /// </li>
    /// </ul>
    pub time_value: i32,
}
impl std::fmt::Debug for RelativeAggregationDuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelativeAggregationDuration");
        formatter.field("time_dimension", &self.time_dimension);
        formatter.field("time_value", &self.time_value);
        formatter.finish()
    }
}
/// See [`RelativeAggregationDuration`](crate::model::RelativeAggregationDuration)
pub mod relative_aggregation_duration {
    /// A builder for [`RelativeAggregationDuration`](crate::model::RelativeAggregationDuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_dimension: std::option::Option<crate::model::TimeDimension>,
        pub(crate) time_value: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The type of time period that the <code>timeValue</code> field
        /// represents. </p>
        pub fn time_dimension(mut self, input: crate::model::TimeDimension) -> Self {
            self.time_dimension = Some(input);
            self
        }
        /// <p>The type of time period that the <code>timeValue</code> field
        /// represents. </p>
        pub fn set_time_dimension(
            mut self,
            input: std::option::Option<crate::model::TimeDimension>,
        ) -> Self {
            self.time_dimension = input;
            self
        }
        /// <p>The period of the time window to gather statistics for. The valid
        /// value depends on the setting of the <code>timeDimension</code>
        /// field.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Hours</code> - 1/3/6/12/24</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Days</code> - 3</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Weeks</code> - 1/2</p>
        /// </li>
        /// </ul>
        pub fn time_value(mut self, input: i32) -> Self {
            self.time_value = Some(input);
            self
        }
        /// <p>The period of the time window to gather statistics for. The valid
        /// value depends on the setting of the <code>timeDimension</code>
        /// field.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Hours</code> - 1/3/6/12/24</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Days</code> - 3</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Weeks</code> - 1/2</p>
        /// </li>
        /// </ul>
        pub fn set_time_value(mut self, input: std::option::Option<i32>) -> Self {
            self.time_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RelativeAggregationDuration`](crate::model::RelativeAggregationDuration)
        pub fn build(self) -> crate::model::RelativeAggregationDuration {
            crate::model::RelativeAggregationDuration {
                time_dimension: self.time_dimension,
                time_value: self.time_value.unwrap_or_default(),
            }
        }
    }
}
impl RelativeAggregationDuration {
    /// Creates a new builder-style object to manufacture [`RelativeAggregationDuration`](crate::model::RelativeAggregationDuration)
    pub fn builder() -> crate::model::relative_aggregation_duration::Builder {
        crate::model::relative_aggregation_duration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeDimension {
    #[allow(missing_docs)] // documentation missing in model
    Days,
    #[allow(missing_docs)] // documentation missing in model
    Hours,
    #[allow(missing_docs)] // documentation missing in model
    Weeks,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeDimension {
    fn from(s: &str) -> Self {
        match s {
            "Days" => TimeDimension::Days,
            "Hours" => TimeDimension::Hours,
            "Weeks" => TimeDimension::Weeks,
            other => TimeDimension::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeDimension {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeDimension::from(s))
    }
}
impl TimeDimension {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeDimension::Days => "Days",
            TimeDimension::Hours => "Hours",
            TimeDimension::Weeks => "Weeks",
            TimeDimension::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Days", "Hours", "Weeks"]
    }
}
impl AsRef<str> for TimeDimension {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Filters responses returned by the
/// <code>ListAggregatedUtterances</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedUtterancesFilter {
    /// <p>The name of the field to filter the utterance list.</p>
    pub name: std::option::Option<crate::model::AggregatedUtterancesFilterName>,
    /// <p>The value to use for filtering the list of bots.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
    /// <code>ListAggregatedUtterances</code> operation should return only
    /// utterances that equal the specified value. Specify <code>CO</code> when
    /// the <code>ListAggregatedUtterances</code> operation should return
    /// utterances that contain the specified value.</p>
    pub operator: std::option::Option<crate::model::AggregatedUtterancesFilterOperator>,
}
impl std::fmt::Debug for AggregatedUtterancesFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedUtterancesFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.field("operator", &self.operator);
        formatter.finish()
    }
}
/// See [`AggregatedUtterancesFilter`](crate::model::AggregatedUtterancesFilter)
pub mod aggregated_utterances_filter {
    /// A builder for [`AggregatedUtterancesFilter`](crate::model::AggregatedUtterancesFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::AggregatedUtterancesFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) operator: std::option::Option<crate::model::AggregatedUtterancesFilterOperator>,
    }
    impl Builder {
        /// <p>The name of the field to filter the utterance list.</p>
        pub fn name(mut self, input: crate::model::AggregatedUtterancesFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the field to filter the utterance list.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The value to use for filtering the list of bots.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListAggregatedUtterances</code> operation should return only
        /// utterances that equal the specified value. Specify <code>CO</code> when
        /// the <code>ListAggregatedUtterances</code> operation should return
        /// utterances that contain the specified value.</p>
        pub fn operator(mut self, input: crate::model::AggregatedUtterancesFilterOperator) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The operator to use for the filter. Specify <code>EQ</code> when the
        /// <code>ListAggregatedUtterances</code> operation should return only
        /// utterances that equal the specified value. Specify <code>CO</code> when
        /// the <code>ListAggregatedUtterances</code> operation should return
        /// utterances that contain the specified value.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesFilterOperator>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedUtterancesFilter`](crate::model::AggregatedUtterancesFilter)
        pub fn build(self) -> crate::model::AggregatedUtterancesFilter {
            crate::model::AggregatedUtterancesFilter {
                name: self.name,
                values: self.values,
                operator: self.operator,
            }
        }
    }
}
impl AggregatedUtterancesFilter {
    /// Creates a new builder-style object to manufacture [`AggregatedUtterancesFilter`](crate::model::AggregatedUtterancesFilter)
    pub fn builder() -> crate::model::aggregated_utterances_filter::Builder {
        crate::model::aggregated_utterances_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregatedUtterancesFilterOperator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregatedUtterancesFilterOperator {
    fn from(s: &str) -> Self {
        match s {
            "CO" => AggregatedUtterancesFilterOperator::Contains,
            "EQ" => AggregatedUtterancesFilterOperator::Equals,
            other => AggregatedUtterancesFilterOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregatedUtterancesFilterOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregatedUtterancesFilterOperator::from(s))
    }
}
impl AggregatedUtterancesFilterOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregatedUtterancesFilterOperator::Contains => "CO",
            AggregatedUtterancesFilterOperator::Equals => "EQ",
            AggregatedUtterancesFilterOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CO", "EQ"]
    }
}
impl AsRef<str> for AggregatedUtterancesFilterOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregatedUtterancesFilterName {
    #[allow(missing_docs)] // documentation missing in model
    Utterance,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregatedUtterancesFilterName {
    fn from(s: &str) -> Self {
        match s {
            "Utterance" => AggregatedUtterancesFilterName::Utterance,
            other => AggregatedUtterancesFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregatedUtterancesFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregatedUtterancesFilterName::from(s))
    }
}
impl AggregatedUtterancesFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregatedUtterancesFilterName::Utterance => "Utterance",
            AggregatedUtterancesFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Utterance"]
    }
}
impl AsRef<str> for AggregatedUtterancesFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies attributes for sorting a list of utterances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AggregatedUtterancesSortBy {
    /// <p>The utterance attribute to sort by.</p>
    pub attribute: std::option::Option<crate::model::AggregatedUtterancesSortAttribute>,
    /// <p>Specifies whether to sort the aggregated utterances in ascending or
    /// descending order.</p>
    pub order: std::option::Option<crate::model::SortOrder>,
}
impl std::fmt::Debug for AggregatedUtterancesSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AggregatedUtterancesSortBy");
        formatter.field("attribute", &self.attribute);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}
/// See [`AggregatedUtterancesSortBy`](crate::model::AggregatedUtterancesSortBy)
pub mod aggregated_utterances_sort_by {
    /// A builder for [`AggregatedUtterancesSortBy`](crate::model::AggregatedUtterancesSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::AggregatedUtterancesSortAttribute>,
        pub(crate) order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The utterance attribute to sort by.</p>
        pub fn attribute(mut self, input: crate::model::AggregatedUtterancesSortAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The utterance attribute to sort by.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::AggregatedUtterancesSortAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>Specifies whether to sort the aggregated utterances in ascending or
        /// descending order.</p>
        pub fn order(mut self, input: crate::model::SortOrder) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>Specifies whether to sort the aggregated utterances in ascending or
        /// descending order.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::SortOrder>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`AggregatedUtterancesSortBy`](crate::model::AggregatedUtterancesSortBy)
        pub fn build(self) -> crate::model::AggregatedUtterancesSortBy {
            crate::model::AggregatedUtterancesSortBy {
                attribute: self.attribute,
                order: self.order,
            }
        }
    }
}
impl AggregatedUtterancesSortBy {
    /// Creates a new builder-style object to manufacture [`AggregatedUtterancesSortBy`](crate::model::AggregatedUtterancesSortBy)
    pub fn builder() -> crate::model::aggregated_utterances_sort_by::Builder {
        crate::model::aggregated_utterances_sort_by::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregatedUtterancesSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    HitCount,
    #[allow(missing_docs)] // documentation missing in model
    MissedCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregatedUtterancesSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "HitCount" => AggregatedUtterancesSortAttribute::HitCount,
            "MissedCount" => AggregatedUtterancesSortAttribute::MissedCount,
            other => AggregatedUtterancesSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregatedUtterancesSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregatedUtterancesSortAttribute::from(s))
    }
}
impl AggregatedUtterancesSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregatedUtterancesSortAttribute::HitCount => "HitCount",
            AggregatedUtterancesSortAttribute::MissedCount => "MissedCount",
            AggregatedUtterancesSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HitCount", "MissedCount"]
    }
}
impl AsRef<str> for AggregatedUtterancesSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about an event that occurred affecting the bot
/// locale.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotLocaleHistoryEvent {
    /// <p>A description of the event that occurred.</p>
    pub event: std::option::Option<std::string::String>,
    /// <p>A timestamp of the date and time that the event occurred.</p>
    pub event_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotLocaleHistoryEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotLocaleHistoryEvent");
        formatter.field("event", &self.event);
        formatter.field("event_date", &self.event_date);
        formatter.finish()
    }
}
/// See [`BotLocaleHistoryEvent`](crate::model::BotLocaleHistoryEvent)
pub mod bot_locale_history_event {
    /// A builder for [`BotLocaleHistoryEvent`](crate::model::BotLocaleHistoryEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<std::string::String>,
        pub(crate) event_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>A description of the event that occurred.</p>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.event = Some(input.into());
            self
        }
        /// <p>A description of the event that occurred.</p>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event = input;
            self
        }
        /// <p>A timestamp of the date and time that the event occurred.</p>
        pub fn event_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_date = Some(input);
            self
        }
        /// <p>A timestamp of the date and time that the event occurred.</p>
        pub fn set_event_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_date = input;
            self
        }
        /// Consumes the builder and constructs a [`BotLocaleHistoryEvent`](crate::model::BotLocaleHistoryEvent)
        pub fn build(self) -> crate::model::BotLocaleHistoryEvent {
            crate::model::BotLocaleHistoryEvent {
                event: self.event,
                event_date: self.event_date,
            }
        }
    }
}
impl BotLocaleHistoryEvent {
    /// Creates a new builder-style object to manufacture [`BotLocaleHistoryEvent`](crate::model::BotLocaleHistoryEvent)
    pub fn builder() -> crate::model::bot_locale_history_event::Builder {
        crate::model::bot_locale_history_event::Builder::default()
    }
}

/// <p>Provides a record of an event that affects a bot alias. For example,
/// when the version of a bot that the alias points to changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotAliasHistoryEvent {
    /// <p>The version of the bot that was used in the event. </p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The date and time that the event started.</p>
    pub start_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event ended.</p>
    pub end_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for BotAliasHistoryEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotAliasHistoryEvent");
        formatter.field("bot_version", &self.bot_version);
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.finish()
    }
}
/// See [`BotAliasHistoryEvent`](crate::model::BotAliasHistoryEvent)
pub mod bot_alias_history_event {
    /// A builder for [`BotAliasHistoryEvent`](crate::model::BotAliasHistoryEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The version of the bot that was used in the event. </p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that was used in the event. </p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The date and time that the event started.</p>
        pub fn start_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date and time that the event started.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn end_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_date = Some(input);
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn set_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_date = input;
            self
        }
        /// Consumes the builder and constructs a [`BotAliasHistoryEvent`](crate::model::BotAliasHistoryEvent)
        pub fn build(self) -> crate::model::BotAliasHistoryEvent {
            crate::model::BotAliasHistoryEvent {
                bot_version: self.bot_version,
                start_date: self.start_date,
                end_date: self.end_date,
            }
        }
    }
}
impl BotAliasHistoryEvent {
    /// Creates a new builder-style object to manufacture [`BotAliasHistoryEvent`](crate::model::BotAliasHistoryEvent)
    pub fn builder() -> crate::model::bot_alias_history_event::Builder {
        crate::model::bot_alias_history_event::Builder::default()
    }
}

/// <p>The IAM principal that you allowing or denying access to an Amazon Lex
/// action. You must provide a <code>service</code> or an <code>arn</code>,
/// but not both in the same statement. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html"> AWS JSON policy elements: Principal </a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Principal {
    /// <p>The name of the AWS service that should allowed or denied access to
    /// an Amazon Lex action.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the principal.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Principal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Principal");
        formatter.field("service", &self.service);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Principal`](crate::model::Principal)
pub mod principal {
    /// A builder for [`Principal`](crate::model::Principal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the AWS service that should allowed or denied access to
        /// an Amazon Lex action.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The name of the AWS service that should allowed or denied access to
        /// an Amazon Lex action.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Principal`](crate::model::Principal)
        pub fn build(self) -> crate::model::Principal {
            crate::model::Principal {
                service: self.service,
                arn: self.arn,
            }
        }
    }
}
impl Principal {
    /// Creates a new builder-style object to manufacture [`Principal`](crate::model::Principal)
    pub fn builder() -> crate::model::principal::Builder {
        crate::model::principal::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Effect {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Effect {
    fn from(s: &str) -> Self {
        match s {
            "Allow" => Effect::Allow,
            "Deny" => Effect::Deny,
            other => Effect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Effect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Effect::from(s))
    }
}
impl Effect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Effect::Allow => "Allow",
            Effect::Deny => "Deny",
            Effect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Allow", "Deny"]
    }
}
impl AsRef<str> for Effect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The version of a bot used for a bot locale.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotVersionLocaleDetails {
    /// <p>The version of a bot used for a bot locale.</p>
    pub source_bot_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BotVersionLocaleDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotVersionLocaleDetails");
        formatter.field("source_bot_version", &self.source_bot_version);
        formatter.finish()
    }
}
/// See [`BotVersionLocaleDetails`](crate::model::BotVersionLocaleDetails)
pub mod bot_version_locale_details {
    /// A builder for [`BotVersionLocaleDetails`](crate::model::BotVersionLocaleDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_bot_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version of a bot used for a bot locale.</p>
        pub fn source_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_bot_version = Some(input.into());
            self
        }
        /// <p>The version of a bot used for a bot locale.</p>
        pub fn set_source_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_bot_version = input;
            self
        }
        /// Consumes the builder and constructs a [`BotVersionLocaleDetails`](crate::model::BotVersionLocaleDetails)
        pub fn build(self) -> crate::model::BotVersionLocaleDetails {
            crate::model::BotVersionLocaleDetails {
                source_bot_version: self.source_bot_version,
            }
        }
    }
}
impl BotVersionLocaleDetails {
    /// Creates a new builder-style object to manufacture [`BotVersionLocaleDetails`](crate::model::BotVersionLocaleDetails)
    pub fn builder() -> crate::model::bot_version_locale_details::Builder {
        crate::model::bot_version_locale_details::Builder::default()
    }
}
