// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Lex Model Building Service
///
/// Client for invoking operations on Amazon Lex Model Building Service. Each operation on Amazon Lex Model Building Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lexmodelbuilding::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lexmodelbuilding::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lexmodelbuilding::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateBotVersion`](crate::client::fluent_builders::CreateBotVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateBotVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateBotVersion::set_name): <p>The name of the bot that you want to create a new version of. The name is case sensitive. </p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::CreateBotVersion::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::CreateBotVersion::set_checksum): <p>Identifies a specific revision of the <code>$LATEST</code> version of the bot. If you specify a checksum and the <code>$LATEST</code> version of the bot has a different checksum, a <code>PreconditionFailedException</code> exception is returned and Amazon Lex doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
    /// - On success, responds with [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateBotVersionOutput::name): <p>The name of the bot.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateBotVersionOutput::description): <p>A description of the bot.</p>
    ///   - [`intents(Option<Vec<Intent>>)`](crate::output::CreateBotVersionOutput::intents): <p>An array of <code>Intent</code> objects. For more information, see <code>PutBot</code>.</p>
    ///   - [`clarification_prompt(Option<Prompt>)`](crate::output::CreateBotVersionOutput::clarification_prompt): <p>The message that Amazon Lex uses when it doesn't understand the user's request. For more information, see <code>PutBot</code>. </p>
    ///   - [`abort_statement(Option<Statement>)`](crate::output::CreateBotVersionOutput::abort_statement): <p>The message that Amazon Lex uses to cancel a conversation. For more information, see <code>PutBot</code>.</p>
    ///   - [`status(Option<Status>)`](crate::output::CreateBotVersionOutput::status): <p> When you send a request to create or update a bot, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>. After Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>. If Amazon Lex can't build the bot, it sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p>
    ///   - [`failure_reason(Option<String>)`](crate::output::CreateBotVersionOutput::failure_reason): <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateBotVersionOutput::last_updated_date): <p>The date when the <code>$LATEST</code> version of this bot was updated. </p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateBotVersionOutput::created_date): <p>The date when the bot version was created.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::CreateBotVersionOutput::idle_session_ttl_in_seconds): <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <code>PutBot</code>.</p>
    ///   - [`voice_id(Option<String>)`](crate::output::CreateBotVersionOutput::voice_id): <p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions with the user.</p>
    ///   - [`checksum(Option<String>)`](crate::output::CreateBotVersionOutput::checksum): <p>Checksum identifying the version of the bot that was created.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateBotVersionOutput::version): <p>The version of the bot. </p>
    ///   - [`locale(Option<Locale>)`](crate::output::CreateBotVersionOutput::locale): <p> Specifies the target locale for the bot. </p>
    ///   - [`child_directed(Option<bool>)`](crate::output::CreateBotVersionOutput::child_directed): <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>  <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
    ///   - [`enable_model_improvements(Option<bool>)`](crate::output::CreateBotVersionOutput::enable_model_improvements): <p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>
    ///   - [`detect_sentiment(Option<bool>)`](crate::output::CreateBotVersionOutput::detect_sentiment): <p>Indicates whether utterances entered by the user should be sent to Amazon Comprehend for sentiment analysis.</p>
    /// - On failure, responds with [`SdkError<CreateBotVersionError>`](crate::error::CreateBotVersionError)
    pub fn create_bot_version(&self) -> fluent_builders::CreateBotVersion<C, M, R> {
        fluent_builders::CreateBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntentVersion`](crate::client::fluent_builders::CreateIntentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateIntentVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateIntentVersion::set_name): <p>The name of the intent that you want to create a new version of. The name is case sensitive. </p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::CreateIntentVersion::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::CreateIntentVersion::set_checksum): <p>Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
    /// - On success, responds with [`CreateIntentVersionOutput`](crate::output::CreateIntentVersionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateIntentVersionOutput::name): <p>The name of the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateIntentVersionOutput::description): <p>A description of the intent.</p>
    ///   - [`slots(Option<Vec<Slot>>)`](crate::output::CreateIntentVersionOutput::slots): <p>An array of slot types that defines the information required to fulfill the intent.</p>
    ///   - [`sample_utterances(Option<Vec<String>>)`](crate::output::CreateIntentVersionOutput::sample_utterances): <p>An array of sample utterances configured for the intent. </p>
    ///   - [`confirmation_prompt(Option<Prompt>)`](crate::output::CreateIntentVersionOutput::confirmation_prompt): <p>If defined, the prompt that Amazon Lex uses to confirm the user's intent before fulfilling it. </p>
    ///   - [`rejection_statement(Option<Statement>)`](crate::output::CreateIntentVersionOutput::rejection_statement): <p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>
    ///   - [`follow_up_prompt(Option<FollowUpPrompt>)`](crate::output::CreateIntentVersionOutput::follow_up_prompt): <p>If defined, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. </p>
    ///   - [`conclusion_statement(Option<Statement>)`](crate::output::CreateIntentVersionOutput::conclusion_statement): <p>After the Lambda function specified in the <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex conveys this statement to the user. </p>
    ///   - [`dialog_code_hook(Option<CodeHook>)`](crate::output::CreateIntentVersionOutput::dialog_code_hook): <p>If defined, Amazon Lex invokes this Lambda function for each user input.</p>
    ///   - [`fulfillment_activity(Option<FulfillmentActivity>)`](crate::output::CreateIntentVersionOutput::fulfillment_activity): <p> Describes how the intent is fulfilled. </p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::CreateIntentVersionOutput::parent_intent_signature): <p>A unique identifier for a built-in intent.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateIntentVersionOutput::last_updated_date): <p>The date that the intent was updated. </p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateIntentVersionOutput::created_date): <p>The date that the intent was created.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateIntentVersionOutput::version): <p>The version number assigned to the new version of the intent.</p>
    ///   - [`checksum(Option<String>)`](crate::output::CreateIntentVersionOutput::checksum): <p>Checksum of the intent version created.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::CreateIntentVersionOutput::kendra_configuration): <p>Configuration information, if any, for connecting an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::CreateIntentVersionOutput::input_contexts): <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::CreateIntentVersionOutput::output_contexts): <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
    /// - On failure, responds with [`SdkError<CreateIntentVersionError>`](crate::error::CreateIntentVersionError)
    pub fn create_intent_version(&self) -> fluent_builders::CreateIntentVersion<C, M, R> {
        fluent_builders::CreateIntentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSlotTypeVersion`](crate::client::fluent_builders::CreateSlotTypeVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateSlotTypeVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateSlotTypeVersion::set_name): <p>The name of the slot type that you want to create a new version for. The name is case sensitive. </p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::CreateSlotTypeVersion::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::CreateSlotTypeVersion::set_checksum): <p>Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
    /// - On success, responds with [`CreateSlotTypeVersionOutput`](crate::output::CreateSlotTypeVersionOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::CreateSlotTypeVersionOutput::name): <p>The name of the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateSlotTypeVersionOutput::description): <p>A description of the slot type.</p>
    ///   - [`enumeration_values(Option<Vec<EnumerationValue>>)`](crate::output::CreateSlotTypeVersionOutput::enumeration_values): <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::CreateSlotTypeVersionOutput::last_updated_date): <p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::CreateSlotTypeVersionOutput::created_date): <p>The date that the slot type was created.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateSlotTypeVersionOutput::version): <p>The version assigned to the new slot type version. </p>
    ///   - [`checksum(Option<String>)`](crate::output::CreateSlotTypeVersionOutput::checksum): <p>Checksum of the <code>$LATEST</code> version of the slot type.</p>
    ///   - [`value_selection_strategy(Option<SlotValueSelectionStrategy>)`](crate::output::CreateSlotTypeVersionOutput::value_selection_strategy): <p>The strategy that Amazon Lex uses to determine the value of the slot. For more information, see <code>PutSlotType</code>.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::CreateSlotTypeVersionOutput::parent_slot_type_signature): <p>The built-in slot type used a the parent of the slot type.</p>
    ///   - [`slot_type_configurations(Option<Vec<SlotTypeConfiguration>>)`](crate::output::CreateSlotTypeVersionOutput::slot_type_configurations): <p>Configuration information that extends the parent built-in slot type.</p>
    /// - On failure, responds with [`SdkError<CreateSlotTypeVersionError>`](crate::error::CreateSlotTypeVersionError)
    pub fn create_slot_type_version(&self) -> fluent_builders::CreateSlotTypeVersion<C, M, R> {
        fluent_builders::CreateSlotTypeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBot`](crate::client::fluent_builders::DeleteBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteBot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteBot::set_name): <p>The name of the bot. The name is case sensitive. </p>
    /// - On success, responds with [`DeleteBotOutput`](crate::output::DeleteBotOutput)

    /// - On failure, responds with [`SdkError<DeleteBotError>`](crate::error::DeleteBotError)
    pub fn delete_bot(&self) -> fluent_builders::DeleteBot<C, M, R> {
        fluent_builders::DeleteBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotAlias`](crate::client::fluent_builders::DeleteBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteBotAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteBotAlias::set_name): <p>The name of the alias to delete. The name is case sensitive. </p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBotAlias::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::DeleteBotAlias::set_bot_name): <p>The name of the bot that the alias points to.</p>
    /// - On success, responds with [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteBotAliasError>`](crate::error::DeleteBotAliasError)
    pub fn delete_bot_alias(&self) -> fluent_builders::DeleteBotAlias<C, M, R> {
        fluent_builders::DeleteBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotChannelAssociation`](crate::client::fluent_builders::DeleteBotChannelAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::set_name): <p>The name of the association. The name is case sensitive. </p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::set_bot_name): <p>The name of the Amazon Lex bot.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::DeleteBotChannelAssociation::set_bot_alias): <p>An alias that points to the specific version of the Amazon Lex bot to which this association is being made.</p>
    /// - On success, responds with [`DeleteBotChannelAssociationOutput`](crate::output::DeleteBotChannelAssociationOutput)

    /// - On failure, responds with [`SdkError<DeleteBotChannelAssociationError>`](crate::error::DeleteBotChannelAssociationError)
    pub fn delete_bot_channel_association(
        &self,
    ) -> fluent_builders::DeleteBotChannelAssociation<C, M, R> {
        fluent_builders::DeleteBotChannelAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBotVersion`](crate::client::fluent_builders::DeleteBotVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteBotVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteBotVersion::set_name): <p>The name of the bot.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteBotVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteBotVersion::set_version): <p>The version of the bot to delete. You cannot delete the <code>$LATEST</code> version of the bot. To delete the <code>$LATEST</code> version, use the <code>DeleteBot</code> operation.</p>
    /// - On success, responds with [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteBotVersionError>`](crate::error::DeleteBotVersionError)
    pub fn delete_bot_version(&self) -> fluent_builders::DeleteBotVersion<C, M, R> {
        fluent_builders::DeleteBotVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntent`](crate::client::fluent_builders::DeleteIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteIntent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteIntent::set_name): <p>The name of the intent. The name is case sensitive. </p>
    /// - On success, responds with [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)

    /// - On failure, responds with [`SdkError<DeleteIntentError>`](crate::error::DeleteIntentError)
    pub fn delete_intent(&self) -> fluent_builders::DeleteIntent<C, M, R> {
        fluent_builders::DeleteIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntentVersion`](crate::client::fluent_builders::DeleteIntentVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteIntentVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteIntentVersion::set_name): <p>The name of the intent.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteIntentVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteIntentVersion::set_version): <p>The version of the intent to delete. You cannot delete the <code>$LATEST</code> version of the intent. To delete the <code>$LATEST</code> version, use the <code>DeleteIntent</code> operation.</p>
    /// - On success, responds with [`DeleteIntentVersionOutput`](crate::output::DeleteIntentVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteIntentVersionError>`](crate::error::DeleteIntentVersionError)
    pub fn delete_intent_version(&self) -> fluent_builders::DeleteIntentVersion<C, M, R> {
        fluent_builders::DeleteIntentVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSlotType`](crate::client::fluent_builders::DeleteSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteSlotType::set_name): <p>The name of the slot type. The name is case sensitive. </p>
    /// - On success, responds with [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteSlotTypeError>`](crate::error::DeleteSlotTypeError)
    pub fn delete_slot_type(&self) -> fluent_builders::DeleteSlotType<C, M, R> {
        fluent_builders::DeleteSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSlotTypeVersion`](crate::client::fluent_builders::DeleteSlotTypeVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotTypeVersion::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteSlotTypeVersion::set_name): <p>The name of the slot type.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteSlotTypeVersion::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteSlotTypeVersion::set_version): <p>The version of the slot type to delete. You cannot delete the <code>$LATEST</code> version of the slot type. To delete the <code>$LATEST</code> version, use the <code>DeleteSlotType</code> operation.</p>
    /// - On success, responds with [`DeleteSlotTypeVersionOutput`](crate::output::DeleteSlotTypeVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteSlotTypeVersionError>`](crate::error::DeleteSlotTypeVersionError)
    pub fn delete_slot_type_version(&self) -> fluent_builders::DeleteSlotTypeVersion<C, M, R> {
        fluent_builders::DeleteSlotTypeVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUtterances`](crate::client::fluent_builders::DeleteUtterances) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::DeleteUtterances::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::DeleteUtterances::set_bot_name): <p>The name of the bot that stored the utterances.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUtterances::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUtterances::set_user_id): <p> The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the utterance.</p>
    /// - On success, responds with [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)

    /// - On failure, responds with [`SdkError<DeleteUtterancesError>`](crate::error::DeleteUtterancesError)
    pub fn delete_utterances(&self) -> fluent_builders::DeleteUtterances<C, M, R> {
        fluent_builders::DeleteUtterances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBot`](crate::client::fluent_builders::GetBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetBot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetBot::set_name): <p>The name of the bot. The name is case sensitive. </p>
    ///   - [`version_or_alias(impl Into<String>)`](crate::client::fluent_builders::GetBot::version_or_alias) / [`set_version_or_alias(Option<String>)`](crate::client::fluent_builders::GetBot::set_version_or_alias): <p>The version or alias of the bot.</p>
    /// - On success, responds with [`GetBotOutput`](crate::output::GetBotOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetBotOutput::name): <p>The name of the bot.</p>
    ///   - [`description(Option<String>)`](crate::output::GetBotOutput::description): <p>A description of the bot.</p>
    ///   - [`intents(Option<Vec<Intent>>)`](crate::output::GetBotOutput::intents): <p>An array of <code>intent</code> objects. For more information, see <code>PutBot</code>.</p>
    ///   - [`enable_model_improvements(Option<bool>)`](crate::output::GetBotOutput::enable_model_improvements): <p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>
    ///   - [`nlu_intent_confidence_threshold(Option<f64>)`](crate::output::GetBotOutput::nlu_intent_confidence_threshold): <p>The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.</p>
    ///   - [`clarification_prompt(Option<Prompt>)`](crate::output::GetBotOutput::clarification_prompt): <p>The message Amazon Lex uses when it doesn't understand the user's request. For more information, see <code>PutBot</code>. </p>
    ///   - [`abort_statement(Option<Statement>)`](crate::output::GetBotOutput::abort_statement): <p>The message that Amazon Lex returns when the user elects to end the conversation without completing it. For more information, see <code>PutBot</code>.</p>
    ///   - [`status(Option<Status>)`](crate::output::GetBotOutput::status): <p>The status of the bot. </p>  <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot for testing and use.</p>  <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you can test the bot using the exact utterances specified in the bot's intents. When the bot is ready for full testing or to run, the status is <code>READY</code>.</p>  <p>If there was a problem with building the bot, the status is <code>FAILED</code> and the <code>failureReason</code> field explains why the bot did not build.</p>  <p>If the bot was saved but not built, the status is <code>NOT_BUILT</code>.</p>
    ///   - [`failure_reason(Option<String>)`](crate::output::GetBotOutput::failure_reason): <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why it failed to build the bot.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetBotOutput::last_updated_date): <p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same. </p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetBotOutput::created_date): <p>The date that the bot was created.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::GetBotOutput::idle_session_ttl_in_seconds): <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. For more information, see <code>PutBot</code>.</p>
    ///   - [`voice_id(Option<String>)`](crate::output::GetBotOutput::voice_id): <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <code>PutBot</code>.</p>
    ///   - [`checksum(Option<String>)`](crate::output::GetBotOutput::checksum): <p>Checksum of the bot used to identify a specific revision of the bot's <code>$LATEST</code> version.</p>
    ///   - [`version(Option<String>)`](crate::output::GetBotOutput::version): <p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>
    ///   - [`locale(Option<Locale>)`](crate::output::GetBotOutput::locale): <p> The target locale for the bot. </p>
    ///   - [`child_directed(Option<bool>)`](crate::output::GetBotOutput::child_directed): <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>  <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
    ///   - [`detect_sentiment(Option<bool>)`](crate::output::GetBotOutput::detect_sentiment): <p>Indicates whether user utterances should be sent to Amazon Comprehend for sentiment analysis.</p>
    /// - On failure, responds with [`SdkError<GetBotError>`](crate::error::GetBotError)
    pub fn get_bot(&self) -> fluent_builders::GetBot<C, M, R> {
        fluent_builders::GetBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBotAlias`](crate::client::fluent_builders::GetBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetBotAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetBotAlias::set_name): <p>The name of the bot alias. The name is case sensitive.</p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetBotAlias::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetBotAlias::set_bot_name): <p>The name of the bot.</p>
    /// - On success, responds with [`GetBotAliasOutput`](crate::output::GetBotAliasOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetBotAliasOutput::name): <p>The name of the bot alias.</p>
    ///   - [`description(Option<String>)`](crate::output::GetBotAliasOutput::description): <p>A description of the bot alias.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::GetBotAliasOutput::bot_version): <p>The version of the bot that the alias points to.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::GetBotAliasOutput::bot_name): <p>The name of the bot that the alias points to.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetBotAliasOutput::last_updated_date): <p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetBotAliasOutput::created_date): <p>The date that the bot alias was created.</p>
    ///   - [`checksum(Option<String>)`](crate::output::GetBotAliasOutput::checksum): <p>Checksum of the bot alias.</p>
    ///   - [`conversation_logs(Option<ConversationLogsResponse>)`](crate::output::GetBotAliasOutput::conversation_logs): <p>The settings that determine how Amazon Lex uses conversation logs for the alias.</p>
    /// - On failure, responds with [`SdkError<GetBotAliasError>`](crate::error::GetBotAliasError)
    pub fn get_bot_alias(&self) -> fluent_builders::GetBotAlias<C, M, R> {
        fluent_builders::GetBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBotAliases`](crate::client::fluent_builders::GetBotAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBotAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetBotAliases::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetBotAliases::set_bot_name): <p>The name of the bot.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBotAliases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBotAliases::set_next_token): <p>A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBotAliases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBotAliases::set_max_results): <p>The maximum number of aliases to return in the response. The default is 50. . </p>
    ///   - [`name_contains(impl Into<String>)`](crate::client::fluent_builders::GetBotAliases::name_contains) / [`set_name_contains(Option<String>)`](crate::client::fluent_builders::GetBotAliases::set_name_contains): <p>Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    /// - On success, responds with [`GetBotAliasesOutput`](crate::output::GetBotAliasesOutput) with field(s):
    ///   - [`bot_aliases(Option<Vec<BotAliasMetadata>>)`](crate::output::GetBotAliasesOutput::bot_aliases): <p>An array of <code>BotAliasMetadata</code> objects, each describing a bot alias.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBotAliasesOutput::next_token): <p>A pagination token for fetching next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>
    /// - On failure, responds with [`SdkError<GetBotAliasesError>`](crate::error::GetBotAliasesError)
    pub fn get_bot_aliases(&self) -> fluent_builders::GetBotAliases<C, M, R> {
        fluent_builders::GetBotAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBotChannelAssociation`](crate::client::fluent_builders::GetBotChannelAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::set_name): <p>The name of the association between the bot and the channel. The name is case sensitive. </p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::set_bot_name): <p>The name of the Amazon Lex bot.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociation::set_bot_alias): <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
    /// - On success, responds with [`GetBotChannelAssociationOutput`](crate::output::GetBotChannelAssociationOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetBotChannelAssociationOutput::name): <p>The name of the association between the bot and the channel.</p>
    ///   - [`description(Option<String>)`](crate::output::GetBotChannelAssociationOutput::description): <p>A description of the association between the bot and the channel.</p>
    ///   - [`bot_alias(Option<String>)`](crate::output::GetBotChannelAssociationOutput::bot_alias): <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::GetBotChannelAssociationOutput::bot_name): <p>The name of the Amazon Lex bot.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetBotChannelAssociationOutput::created_date): <p>The date that the association between the bot and the channel was created.</p>
    ///   - [`r#type(Option<ChannelType>)`](crate::output::GetBotChannelAssociationOutput::type): <p>The type of the messaging platform.</p>
    ///   - [`bot_configuration(Option<HashMap<String, String>>)`](crate::output::GetBotChannelAssociationOutput::bot_configuration): <p>Provides information that the messaging platform needs to communicate with the Amazon Lex bot.</p>
    ///   - [`status(Option<ChannelStatus>)`](crate::output::GetBotChannelAssociationOutput::status): <p>The status of the bot channel. </p>  <ul>   <li> <p> <code>CREATED</code> - The channel has been created and is ready for use.</p> </li>   <li> <p> <code>IN_PROGRESS</code> - Channel creation is in progress.</p> </li>   <li> <p> <code>FAILED</code> - There was an error creating the channel. For information about the reason for the failure, see the <code>failureReason</code> field.</p> </li>  </ul>
    ///   - [`failure_reason(Option<String>)`](crate::output::GetBotChannelAssociationOutput::failure_reason): <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to create the association.</p>
    /// - On failure, responds with [`SdkError<GetBotChannelAssociationError>`](crate::error::GetBotChannelAssociationError)
    pub fn get_bot_channel_association(
        &self,
    ) -> fluent_builders::GetBotChannelAssociation<C, M, R> {
        fluent_builders::GetBotChannelAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBotChannelAssociations`](crate::client::fluent_builders::GetBotChannelAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBotChannelAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::set_bot_name): <p>The name of the Amazon Lex bot in the association.</p>
    ///   - [`bot_alias(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::bot_alias) / [`set_bot_alias(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::set_bot_alias): <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::set_next_token): <p>A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBotChannelAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBotChannelAssociations::set_max_results): <p>The maximum number of associations to return in the response. The default is 50. </p>
    ///   - [`name_contains(impl Into<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::name_contains) / [`set_name_contains(Option<String>)`](crate::client::fluent_builders::GetBotChannelAssociations::set_name_contains): <p>Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the <code>nameContains</code> parameter.</p>
    /// - On success, responds with [`GetBotChannelAssociationsOutput`](crate::output::GetBotChannelAssociationsOutput) with field(s):
    ///   - [`bot_channel_associations(Option<Vec<BotChannelAssociation>>)`](crate::output::GetBotChannelAssociationsOutput::bot_channel_associations): <p>An array of objects, one for each association, that provides information about the Amazon Lex bot and its association with the channel. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBotChannelAssociationsOutput::next_token): <p>A pagination token that fetches the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>
    /// - On failure, responds with [`SdkError<GetBotChannelAssociationsError>`](crate::error::GetBotChannelAssociationsError)
    pub fn get_bot_channel_associations(
        &self,
    ) -> fluent_builders::GetBotChannelAssociations<C, M, R> {
        fluent_builders::GetBotChannelAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBots`](crate::client::fluent_builders::GetBots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBots::set_next_token): <p>A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBots::set_max_results): <p>The maximum number of bots to return in the response that the request will return. The default is 10.</p>
    ///   - [`name_contains(impl Into<String>)`](crate::client::fluent_builders::GetBots::name_contains) / [`set_name_contains(Option<String>)`](crate::client::fluent_builders::GetBots::set_name_contains): <p>Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    /// - On success, responds with [`GetBotsOutput`](crate::output::GetBotsOutput) with field(s):
    ///   - [`bots(Option<Vec<BotMetadata>>)`](crate::output::GetBotsOutput::bots): <p>An array of <code>botMetadata</code> objects, with one entry for each bot. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBotsOutput::next_token): <p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of bots. </p>
    /// - On failure, responds with [`SdkError<GetBotsError>`](crate::error::GetBotsError)
    pub fn get_bots(&self) -> fluent_builders::GetBots<C, M, R> {
        fluent_builders::GetBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBotVersions`](crate::client::fluent_builders::GetBotVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBotVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetBotVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetBotVersions::set_name): <p>The name of the bot for which versions should be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBotVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBotVersions::set_next_token): <p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBotVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBotVersions::set_max_results): <p>The maximum number of bot versions to return in the response. The default is 10.</p>
    /// - On success, responds with [`GetBotVersionsOutput`](crate::output::GetBotVersionsOutput) with field(s):
    ///   - [`bots(Option<Vec<BotMetadata>>)`](crate::output::GetBotVersionsOutput::bots): <p>An array of <code>BotMetadata</code> objects, one for each numbered version of the bot plus one for the <code>$LATEST</code> version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBotVersionsOutput::next_token): <p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    /// - On failure, responds with [`SdkError<GetBotVersionsError>`](crate::error::GetBotVersionsError)
    pub fn get_bot_versions(&self) -> fluent_builders::GetBotVersions<C, M, R> {
        fluent_builders::GetBotVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBuiltinIntent`](crate::client::fluent_builders::GetBuiltinIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`signature(impl Into<String>)`](crate::client::fluent_builders::GetBuiltinIntent::signature) / [`set_signature(Option<String>)`](crate::client::fluent_builders::GetBuiltinIntent::set_signature): <p>The unique identifier for a built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
    /// - On success, responds with [`GetBuiltinIntentOutput`](crate::output::GetBuiltinIntentOutput) with field(s):
    ///   - [`signature(Option<String>)`](crate::output::GetBuiltinIntentOutput::signature): <p>The unique identifier for a built-in intent.</p>
    ///   - [`supported_locales(Option<Vec<Locale>>)`](crate::output::GetBuiltinIntentOutput::supported_locales): <p>A list of locales that the intent supports.</p>
    ///   - [`slots(Option<Vec<BuiltinIntentSlot>>)`](crate::output::GetBuiltinIntentOutput::slots): <p>An array of <code>BuiltinIntentSlot</code> objects, one entry for each slot type in the intent.</p>
    /// - On failure, responds with [`SdkError<GetBuiltinIntentError>`](crate::error::GetBuiltinIntentError)
    pub fn get_builtin_intent(&self) -> fluent_builders::GetBuiltinIntent<C, M, R> {
        fluent_builders::GetBuiltinIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBuiltinIntents`](crate::client::fluent_builders::GetBuiltinIntents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBuiltinIntents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`locale(Locale)`](crate::client::fluent_builders::GetBuiltinIntents::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::GetBuiltinIntents::set_locale): <p>A list of locales that the intent supports.</p>
    ///   - [`signature_contains(impl Into<String>)`](crate::client::fluent_builders::GetBuiltinIntents::signature_contains) / [`set_signature_contains(Option<String>)`](crate::client::fluent_builders::GetBuiltinIntents::set_signature_contains): <p>Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBuiltinIntents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBuiltinIntents::set_next_token): <p>A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBuiltinIntents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBuiltinIntents::set_max_results): <p>The maximum number of intents to return in the response. The default is 10.</p>
    /// - On success, responds with [`GetBuiltinIntentsOutput`](crate::output::GetBuiltinIntentsOutput) with field(s):
    ///   - [`intents(Option<Vec<BuiltinIntentMetadata>>)`](crate::output::GetBuiltinIntentsOutput::intents): <p>An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBuiltinIntentsOutput::next_token): <p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request.</p>
    /// - On failure, responds with [`SdkError<GetBuiltinIntentsError>`](crate::error::GetBuiltinIntentsError)
    pub fn get_builtin_intents(&self) -> fluent_builders::GetBuiltinIntents<C, M, R> {
        fluent_builders::GetBuiltinIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBuiltinSlotTypes`](crate::client::fluent_builders::GetBuiltinSlotTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetBuiltinSlotTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`locale(Locale)`](crate::client::fluent_builders::GetBuiltinSlotTypes::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::set_locale): <p>A list of locales that the slot type supports.</p>
    ///   - [`signature_contains(impl Into<String>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::signature_contains) / [`set_signature_contains(Option<String>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::set_signature_contains): <p>Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::set_next_token): <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetBuiltinSlotTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetBuiltinSlotTypes::set_max_results): <p>The maximum number of slot types to return in the response. The default is 10.</p>
    /// - On success, responds with [`GetBuiltinSlotTypesOutput`](crate::output::GetBuiltinSlotTypesOutput) with field(s):
    ///   - [`slot_types(Option<Vec<BuiltinSlotTypeMetadata>>)`](crate::output::GetBuiltinSlotTypesOutput::slot_types): <p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetBuiltinSlotTypesOutput::next_token): <p>If the response is truncated, the response includes a pagination token that you can use in your next request to fetch the next page of slot types.</p>
    /// - On failure, responds with [`SdkError<GetBuiltinSlotTypesError>`](crate::error::GetBuiltinSlotTypesError)
    pub fn get_builtin_slot_types(&self) -> fluent_builders::GetBuiltinSlotTypes<C, M, R> {
        fluent_builders::GetBuiltinSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExport`](crate::client::fluent_builders::GetExport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetExport::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetExport::set_name): <p>The name of the bot to export.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetExport::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetExport::set_version): <p>The version of the bot to export.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::GetExport::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::GetExport::set_resource_type): <p>The type of resource to export. </p>
    ///   - [`export_type(ExportType)`](crate::client::fluent_builders::GetExport::export_type) / [`set_export_type(Option<ExportType>)`](crate::client::fluent_builders::GetExport::set_export_type): <p>The format of the exported data.</p>
    /// - On success, responds with [`GetExportOutput`](crate::output::GetExportOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetExportOutput::name): <p>The name of the bot being exported.</p>
    ///   - [`version(Option<String>)`](crate::output::GetExportOutput::version): <p>The version of the bot being exported.</p>
    ///   - [`resource_type(Option<ResourceType>)`](crate::output::GetExportOutput::resource_type): <p>The type of the exported resource.</p>
    ///   - [`export_type(Option<ExportType>)`](crate::output::GetExportOutput::export_type): <p>The format of the exported data.</p>
    ///   - [`export_status(Option<ExportStatus>)`](crate::output::GetExportOutput::export_status): <p>The status of the export. </p>  <ul>   <li> <p> <code>IN_PROGRESS</code> - The export is in progress.</p> </li>   <li> <p> <code>READY</code> - The export is complete.</p> </li>   <li> <p> <code>FAILED</code> - The export could not be completed.</p> </li>  </ul>
    ///   - [`failure_reason(Option<String>)`](crate::output::GetExportOutput::failure_reason): <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to export the resource.</p>
    ///   - [`url(Option<String>)`](crate::output::GetExportOutput::url): <p>An S3 pre-signed URL that provides the location of the exported resource. The exported resource is a ZIP archive that contains the exported resource in JSON format. The structure of the archive may change. Your code should not rely on the archive structure.</p>
    /// - On failure, responds with [`SdkError<GetExportError>`](crate::error::GetExportError)
    pub fn get_export(&self) -> fluent_builders::GetExport<C, M, R> {
        fluent_builders::GetExport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImport`](crate::client::fluent_builders::GetImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`import_id(impl Into<String>)`](crate::client::fluent_builders::GetImport::import_id) / [`set_import_id(Option<String>)`](crate::client::fluent_builders::GetImport::set_import_id): <p>The identifier of the import job information to return.</p>
    /// - On success, responds with [`GetImportOutput`](crate::output::GetImportOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetImportOutput::name): <p>The name given to the import job.</p>
    ///   - [`resource_type(Option<ResourceType>)`](crate::output::GetImportOutput::resource_type): <p>The type of resource imported.</p>
    ///   - [`merge_strategy(Option<MergeStrategy>)`](crate::output::GetImportOutput::merge_strategy): <p>The action taken when there was a conflict between an existing resource and a resource in the import file.</p>
    ///   - [`import_id(Option<String>)`](crate::output::GetImportOutput::import_id): <p>The identifier for the specific import job.</p>
    ///   - [`import_status(Option<ImportStatus>)`](crate::output::GetImportOutput::import_status): <p>The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure from the <code>failureReason</code> field.</p>
    ///   - [`failure_reason(Option<Vec<String>>)`](crate::output::GetImportOutput::failure_reason): <p>A string that describes why an import job failed to complete.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetImportOutput::created_date): <p>A timestamp for the date and time that the import job was created.</p>
    /// - On failure, responds with [`SdkError<GetImportError>`](crate::error::GetImportError)
    pub fn get_import(&self) -> fluent_builders::GetImport<C, M, R> {
        fluent_builders::GetImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntent`](crate::client::fluent_builders::GetIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetIntent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetIntent::set_name): <p>The name of the intent. The name is case sensitive. </p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetIntent::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetIntent::set_version): <p>The version of the intent.</p>
    /// - On success, responds with [`GetIntentOutput`](crate::output::GetIntentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetIntentOutput::name): <p>The name of the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::GetIntentOutput::description): <p>A description of the intent.</p>
    ///   - [`slots(Option<Vec<Slot>>)`](crate::output::GetIntentOutput::slots): <p>An array of intent slots configured for the intent.</p>
    ///   - [`sample_utterances(Option<Vec<String>>)`](crate::output::GetIntentOutput::sample_utterances): <p>An array of sample utterances configured for the intent.</p>
    ///   - [`confirmation_prompt(Option<Prompt>)`](crate::output::GetIntentOutput::confirmation_prompt): <p>If defined in the bot, Amazon Lex uses prompt to confirm the intent before fulfilling the user's request. For more information, see <code>PutIntent</code>. </p>
    ///   - [`rejection_statement(Option<Statement>)`](crate::output::GetIntentOutput::rejection_statement): <p>If the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>
    ///   - [`follow_up_prompt(Option<FollowUpPrompt>)`](crate::output::GetIntentOutput::follow_up_prompt): <p>If defined in the bot, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled. For more information, see <code>PutIntent</code>.</p>
    ///   - [`conclusion_statement(Option<Statement>)`](crate::output::GetIntentOutput::conclusion_statement): <p>After the Lambda function specified in the <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex conveys this statement to the user.</p>
    ///   - [`dialog_code_hook(Option<CodeHook>)`](crate::output::GetIntentOutput::dialog_code_hook): <p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function for each user input. For more information, see <code>PutIntent</code>. </p>
    ///   - [`fulfillment_activity(Option<FulfillmentActivity>)`](crate::output::GetIntentOutput::fulfillment_activity): <p>Describes how the intent is fulfilled. For more information, see <code>PutIntent</code>. </p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::GetIntentOutput::parent_intent_signature): <p>A unique identifier for a built-in intent.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetIntentOutput::last_updated_date): <p>The date that the intent was updated. When you create a resource, the creation date and the last updated date are the same. </p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetIntentOutput::created_date): <p>The date that the intent was created.</p>
    ///   - [`version(Option<String>)`](crate::output::GetIntentOutput::version): <p>The version of the intent.</p>
    ///   - [`checksum(Option<String>)`](crate::output::GetIntentOutput::checksum): <p>Checksum of the intent.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::GetIntentOutput::kendra_configuration): <p>Configuration information, if any, to connect to an Amazon Kendra index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::GetIntentOutput::input_contexts): <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::GetIntentOutput::output_contexts): <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
    /// - On failure, responds with [`SdkError<GetIntentError>`](crate::error::GetIntentError)
    pub fn get_intent(&self) -> fluent_builders::GetIntent<C, M, R> {
        fluent_builders::GetIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntents`](crate::client::fluent_builders::GetIntents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetIntents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetIntents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetIntents::set_next_token): <p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetIntents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetIntents::set_max_results): <p>The maximum number of intents to return in the response. The default is 10.</p>
    ///   - [`name_contains(impl Into<String>)`](crate::client::fluent_builders::GetIntents::name_contains) / [`set_name_contains(Option<String>)`](crate::client::fluent_builders::GetIntents::set_name_contains): <p>Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    /// - On success, responds with [`GetIntentsOutput`](crate::output::GetIntentsOutput) with field(s):
    ///   - [`intents(Option<Vec<IntentMetadata>>)`](crate::output::GetIntentsOutput::intents): <p>An array of <code>Intent</code> objects. For more information, see <code>PutBot</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetIntentsOutput::next_token): <p>If the response is truncated, the response includes a pagination token that you can specify in your next request to fetch the next page of intents. </p>
    /// - On failure, responds with [`SdkError<GetIntentsError>`](crate::error::GetIntentsError)
    pub fn get_intents(&self) -> fluent_builders::GetIntents<C, M, R> {
        fluent_builders::GetIntents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntentVersions`](crate::client::fluent_builders::GetIntentVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetIntentVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetIntentVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetIntentVersions::set_name): <p>The name of the intent for which versions should be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetIntentVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetIntentVersions::set_next_token): <p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetIntentVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetIntentVersions::set_max_results): <p>The maximum number of intent versions to return in the response. The default is 10.</p>
    /// - On success, responds with [`GetIntentVersionsOutput`](crate::output::GetIntentVersionsOutput) with field(s):
    ///   - [`intents(Option<Vec<IntentMetadata>>)`](crate::output::GetIntentVersionsOutput::intents): <p>An array of <code>IntentMetadata</code> objects, one for each numbered version of the intent plus one for the <code>$LATEST</code> version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetIntentVersionsOutput::next_token): <p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    /// - On failure, responds with [`SdkError<GetIntentVersionsError>`](crate::error::GetIntentVersionsError)
    pub fn get_intent_versions(&self) -> fluent_builders::GetIntentVersions<C, M, R> {
        fluent_builders::GetIntentVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMigration`](crate::client::fluent_builders::GetMigration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`migration_id(impl Into<String>)`](crate::client::fluent_builders::GetMigration::migration_id) / [`set_migration_id(Option<String>)`](crate::client::fluent_builders::GetMigration::set_migration_id): <p>The unique identifier of the migration to view. The <code>migrationID</code> is returned by the operation.</p>
    /// - On success, responds with [`GetMigrationOutput`](crate::output::GetMigrationOutput) with field(s):
    ///   - [`migration_id(Option<String>)`](crate::output::GetMigrationOutput::migration_id): <p>The unique identifier of the migration. This is the same as the identifier used when calling the <code>GetMigration</code> operation.</p>
    ///   - [`v1_bot_name(Option<String>)`](crate::output::GetMigrationOutput::v1_bot_name): <p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    ///   - [`v1_bot_version(Option<String>)`](crate::output::GetMigrationOutput::v1_bot_version): <p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    ///   - [`v1_bot_locale(Option<Locale>)`](crate::output::GetMigrationOutput::v1_bot_locale): <p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    ///   - [`v2_bot_id(Option<String>)`](crate::output::GetMigrationOutput::v2_bot_id): <p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being migrated to.</p>
    ///   - [`v2_bot_role(Option<String>)`](crate::output::GetMigrationOutput::v2_bot_role): <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    ///   - [`migration_status(Option<MigrationStatus>)`](crate::output::GetMigrationOutput::migration_status): <p>Indicates the status of the migration. When the status is <code>COMPLETE</code> the migration is finished and the bot is available in Amazon Lex V2. There may be alerts and warnings that need to be resolved to complete the migration.</p>
    ///   - [`migration_strategy(Option<MigrationStrategy>)`](crate::output::GetMigrationOutput::migration_strategy): <p>The strategy used to conduct the migration.</p>  <ul>   <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li>   <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is created in the Amazon Lex V2 bot.</p> </li>  </ul>
    ///   - [`migration_timestamp(Option<DateTime>)`](crate::output::GetMigrationOutput::migration_timestamp): <p>The date and time that the migration started.</p>
    ///   - [`alerts(Option<Vec<MigrationAlert>>)`](crate::output::GetMigrationOutput::alerts): <p>A list of alerts and warnings that indicate issues with the migration for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1 feature has a different implementation if Amazon Lex V2.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2 developer guide</i>.</p>
    /// - On failure, responds with [`SdkError<GetMigrationError>`](crate::error::GetMigrationError)
    pub fn get_migration(&self) -> fluent_builders::GetMigration<C, M, R> {
        fluent_builders::GetMigration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMigrations`](crate::client::fluent_builders::GetMigrations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetMigrations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_by_attribute(MigrationSortAttribute)`](crate::client::fluent_builders::GetMigrations::sort_by_attribute) / [`set_sort_by_attribute(Option<MigrationSortAttribute>)`](crate::client::fluent_builders::GetMigrations::set_sort_by_attribute): <p>The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that the migration was started.</p>
    ///   - [`sort_by_order(SortOrder)`](crate::client::fluent_builders::GetMigrations::sort_by_order) / [`set_sort_by_order(Option<SortOrder>)`](crate::client::fluent_builders::GetMigrations::set_sort_by_order): <p>The order so sort the list.</p>
    ///   - [`v1_bot_name_contains(impl Into<String>)`](crate::client::fluent_builders::GetMigrations::v1_bot_name_contains) / [`set_v1_bot_name_contains(Option<String>)`](crate::client::fluent_builders::GetMigrations::set_v1_bot_name_contains): <p>Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in bot name.</p>
    ///   - [`migration_status_equals(MigrationStatus)`](crate::client::fluent_builders::GetMigrations::migration_status_equals) / [`set_migration_status_equals(Option<MigrationStatus>)`](crate::client::fluent_builders::GetMigrations::set_migration_status_equals): <p>Filters the list to contain only migrations in the specified state.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetMigrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetMigrations::set_max_results): <p>The maximum number of migrations to return in the response. The default is 10.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetMigrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetMigrations::set_next_token): <p>A pagination token that fetches the next page of migrations. If the response to this operation is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the pagination token in the request.</p>
    /// - On success, responds with [`GetMigrationsOutput`](crate::output::GetMigrationsOutput) with field(s):
    ///   - [`migration_summaries(Option<Vec<MigrationSummary>>)`](crate::output::GetMigrationsOutput::migration_summaries): <p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see details of the migration, use the <code>migrationId</code> from the summary in a call to the operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetMigrationsOutput::next_token): <p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of migrations.</p>
    /// - On failure, responds with [`SdkError<GetMigrationsError>`](crate::error::GetMigrationsError)
    pub fn get_migrations(&self) -> fluent_builders::GetMigrations<C, M, R> {
        fluent_builders::GetMigrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSlotType`](crate::client::fluent_builders::GetSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetSlotType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetSlotType::set_name): <p>The name of the slot type. The name is case sensitive. </p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetSlotType::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetSlotType::set_version): <p>The version of the slot type. </p>
    /// - On success, responds with [`GetSlotTypeOutput`](crate::output::GetSlotTypeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::GetSlotTypeOutput::name): <p>The name of the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::GetSlotTypeOutput::description): <p>A description of the slot type.</p>
    ///   - [`enumeration_values(Option<Vec<EnumerationValue>>)`](crate::output::GetSlotTypeOutput::enumeration_values): <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::GetSlotTypeOutput::last_updated_date): <p>The date that the slot type was updated. When you create a resource, the creation date and last update date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::GetSlotTypeOutput::created_date): <p>The date that the slot type was created.</p>
    ///   - [`version(Option<String>)`](crate::output::GetSlotTypeOutput::version): <p>The version of the slot type.</p>
    ///   - [`checksum(Option<String>)`](crate::output::GetSlotTypeOutput::checksum): <p>Checksum of the <code>$LATEST</code> version of the slot type.</p>
    ///   - [`value_selection_strategy(Option<SlotValueSelectionStrategy>)`](crate::output::GetSlotTypeOutput::value_selection_strategy): <p>The strategy that Amazon Lex uses to determine the value of the slot. For more information, see <code>PutSlotType</code>.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::GetSlotTypeOutput::parent_slot_type_signature): <p>The built-in slot type used as a parent for the slot type.</p>
    ///   - [`slot_type_configurations(Option<Vec<SlotTypeConfiguration>>)`](crate::output::GetSlotTypeOutput::slot_type_configurations): <p>Configuration information that extends the parent built-in slot type.</p>
    /// - On failure, responds with [`SdkError<GetSlotTypeError>`](crate::error::GetSlotTypeError)
    pub fn get_slot_type(&self) -> fluent_builders::GetSlotType<C, M, R> {
        fluent_builders::GetSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSlotTypes`](crate::client::fluent_builders::GetSlotTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSlotTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSlotTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSlotTypes::set_next_token): <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSlotTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSlotTypes::set_max_results): <p>The maximum number of slot types to return in the response. The default is 10.</p>
    ///   - [`name_contains(impl Into<String>)`](crate::client::fluent_builders::GetSlotTypes::name_contains) / [`set_name_contains(Option<String>)`](crate::client::fluent_builders::GetSlotTypes::set_name_contains): <p>Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    /// - On success, responds with [`GetSlotTypesOutput`](crate::output::GetSlotTypesOutput) with field(s):
    ///   - [`slot_types(Option<Vec<SlotTypeMetadata>>)`](crate::output::GetSlotTypesOutput::slot_types): <p>An array of objects, one for each slot type, that provides information such as the name of the slot type, the version, and a description.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSlotTypesOutput::next_token): <p>If the response is truncated, it includes a pagination token that you can specify in your next request to fetch the next page of slot types.</p>
    /// - On failure, responds with [`SdkError<GetSlotTypesError>`](crate::error::GetSlotTypesError)
    pub fn get_slot_types(&self) -> fluent_builders::GetSlotTypes<C, M, R> {
        fluent_builders::GetSlotTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSlotTypeVersions`](crate::client::fluent_builders::GetSlotTypeVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSlotTypeVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetSlotTypeVersions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetSlotTypeVersions::set_name): <p>The name of the slot type for which versions should be returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSlotTypeVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSlotTypeVersions::set_next_token): <p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSlotTypeVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSlotTypeVersions::set_max_results): <p>The maximum number of slot type versions to return in the response. The default is 10.</p>
    /// - On success, responds with [`GetSlotTypeVersionsOutput`](crate::output::GetSlotTypeVersionsOutput) with field(s):
    ///   - [`slot_types(Option<Vec<SlotTypeMetadata>>)`](crate::output::GetSlotTypeVersionsOutput::slot_types): <p>An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one for the <code>$LATEST</code> version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSlotTypeVersionsOutput::next_token): <p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
    /// - On failure, responds with [`SdkError<GetSlotTypeVersionsError>`](crate::error::GetSlotTypeVersionsError)
    pub fn get_slot_type_versions(&self) -> fluent_builders::GetSlotTypeVersions<C, M, R> {
        fluent_builders::GetSlotTypeVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUtterancesView`](crate::client::fluent_builders::GetUtterancesView) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::GetUtterancesView::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::GetUtterancesView::set_bot_name): <p>The name of the bot for which utterance information should be returned.</p>
    ///   - [`bot_versions(Vec<String>)`](crate::client::fluent_builders::GetUtterancesView::bot_versions) / [`set_bot_versions(Option<Vec<String>>)`](crate::client::fluent_builders::GetUtterancesView::set_bot_versions): <p>An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.</p>
    ///   - [`status_type(StatusType)`](crate::client::fluent_builders::GetUtterancesView::status_type) / [`set_status_type(Option<StatusType>)`](crate::client::fluent_builders::GetUtterancesView::set_status_type): <p>To return utterances that were recognized and handled, use <code>Detected</code>. To return utterances that were not recognized, use <code>Missed</code>.</p>
    /// - On success, responds with [`GetUtterancesViewOutput`](crate::output::GetUtterancesViewOutput) with field(s):
    ///   - [`bot_name(Option<String>)`](crate::output::GetUtterancesViewOutput::bot_name): <p>The name of the bot for which utterance information was returned.</p>
    ///   - [`utterances(Option<Vec<UtteranceList>>)`](crate::output::GetUtterancesViewOutput::utterances): <p>An array of <code>UtteranceList</code> objects, each containing a list of <code>UtteranceData</code> objects describing the utterances that were processed by your bot. The response contains a maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex returns the most frequent utterances received by the bot in the last 15 days.</p>
    /// - On failure, responds with [`SdkError<GetUtterancesViewError>`](crate::error::GetUtterancesViewError)
    pub fn get_utterances_view(&self) -> fluent_builders::GetUtterancesView<C, M, R> {
        fluent_builders::GetUtterancesView::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags associated with a resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBot`](crate::client::fluent_builders::PutBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutBot::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutBot::set_name): <p>The name of the bot. The name is <i>not</i> case sensitive. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutBot::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutBot::set_description): <p>A description of the bot.</p>
    ///   - [`intents(Vec<Intent>)`](crate::client::fluent_builders::PutBot::intents) / [`set_intents(Option<Vec<Intent>>)`](crate::client::fluent_builders::PutBot::set_intents): <p>An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a pizza ordering bot might support an OrderPizza intent. For more information, see <code>how-it-works</code>.</p>
    ///   - [`enable_model_improvements(bool)`](crate::client::fluent_builders::PutBot::enable_model_improvements) / [`set_enable_model_improvements(Option<bool>)`](crate::client::fluent_builders::PutBot::set_enable_model_improvements): <p>Set to <code>true</code> to enable access to natural language understanding improvements. </p>  <p>When you set the <code>enableModelImprovements</code> parameter to <code>true</code> you can use the <code>nluIntentConfidenceThreshold</code> parameter to configure confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>  <p>You can only set the <code>enableModelImprovements</code> parameter in certain Regions. If you set the parameter to <code>true</code>, your bot has access to accuracy improvements.</p>  <p>The Regions where you can set the <code>enableModelImprovements</code> parameter to <code>true</code> are:</p>  <ul>   <li> <p>US East (N. Virginia) (us-east-1)</p> </li>   <li> <p>US West (Oregon) (us-west-2)</p> </li>   <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>   <li> <p>EU (Ireland) (eu-west-1)</p> </li>  </ul>  <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default. In these Regions setting the parameter to <code>false</code> throws a <code>ValidationException</code> exception.</p>
    ///   - [`nlu_intent_confidence_threshold(f64)`](crate::client::fluent_builders::PutBot::nlu_intent_confidence_threshold) / [`set_nlu_intent_confidence_threshold(Option<f64>)`](crate::client::fluent_builders::PutBot::set_nlu_intent_confidence_threshold): <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>  <p>You must set the <code>enableModelImprovements</code> parameter to <code>true</code> to use confidence scores in the following regions.</p>  <ul>   <li> <p>US East (N. Virginia) (us-east-1)</p> </li>   <li> <p>US West (Oregon) (us-west-2)</p> </li>   <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>   <li> <p>EU (Ireland) (eu-west-1)</p> </li>  </ul>  <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default.</p>  <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p>  <ul>   <li> <p>AMAZON.FallbackIntent</p> </li>   <li> <p>IntentA</p> </li>   <li> <p>IntentB</p> </li>   <li> <p>IntentC</p> </li>  </ul>
    ///   - [`clarification_prompt(Prompt)`](crate::client::fluent_builders::PutBot::clarification_prompt) / [`set_clarification_prompt(Option<Prompt>)`](crate::client::fluent_builders::PutBot::set_clarification_prompt): <p>When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If Amazon Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field. </p>  <p>When you create a clarification prompt, make sure that it suggests the correct response from the user. for example, for a bot that orders pizza and drinks, you might create this clarification prompt: "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>  <p>If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number of times defined in the <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>  <p>If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in three cases: </p>  <ul>   <li> <p>Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example, in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the user to get an intent.</p> </li>   <li> <p>Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>   <li> <p>PutSession operation - When using the <code>PutSession</code> operation, you send an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>  </ul>
    ///   - [`abort_statement(Statement)`](crate::client::fluent_builders::PutBot::abort_statement) / [`set_abort_statement(Option<Statement>)`](crate::client::fluent_builders::PutBot::set_abort_statement): <p>When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then cancels the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type. </p>  <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries to elicit a correct response a few more times. </p>  <p>For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.</p>  <p>If you have defined a fallback intent the cancel statement will not be sent to the user, the fallback intent is used instead. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>
    ///   - [`idle_session_ttl_in_seconds(i32)`](crate::client::fluent_builders::PutBot::idle_session_ttl_in_seconds) / [`set_idle_session_ttl_in_seconds(Option<i32>)`](crate::client::fluent_builders::PutBot::set_idle_session_ttl_in_seconds): <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>  <p>A user interaction session remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>  <p>For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user doesn't complete the order within the specified time, Amazon Lex discards the slot information that it gathered, and the user must start over.</p>  <p>If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.</p>  <p>The default is 300 seconds (5 minutes).</p>
    ///   - [`voice_id(impl Into<String>)`](crate::client::fluent_builders::PutBot::voice_id) / [`set_voice_id(Option<String>)`](crate::client::fluent_builders::PutBot::set_voice_id): <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon Polly Developer Guide</i>.</p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::PutBot::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::PutBot::set_checksum): <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>  <p>When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>  <p>When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
    ///   - [`process_behavior(ProcessBehavior)`](crate::client::fluent_builders::PutBot::process_behavior) / [`set_process_behavior(Option<ProcessBehavior>)`](crate::client::fluent_builders::PutBot::set_process_behavior): <p>If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it. </p>  <p>If you don't specify this value, the default value is <code>BUILD</code>.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::PutBot::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::PutBot::set_locale): <p> Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. </p>  <p>The default is <code>en-US</code>.</p>
    ///   - [`child_directed(bool)`](crate::client::fluent_builders::PutBot::child_directed) / [`set_child_directed(Option<bool>)`](crate::client::fluent_builders::PutBot::set_child_directed): <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>  <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
    ///   - [`detect_sentiment(bool)`](crate::client::fluent_builders::PutBot::detect_sentiment) / [`set_detect_sentiment(Option<bool>)`](crate::client::fluent_builders::PutBot::set_detect_sentiment): <p>When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify <code>detectSentiment</code>, the default is <code>false</code>.</p>
    ///   - [`create_version(bool)`](crate::client::fluent_builders::PutBot::create_version) / [`set_create_version(Option<bool>)`](crate::client::fluent_builders::PutBot::set_create_version): <p>When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default is <code>false</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutBot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutBot::set_tags): <p>A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code> operation.</p>
    /// - On success, responds with [`PutBotOutput`](crate::output::PutBotOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PutBotOutput::name): <p>The name of the bot.</p>
    ///   - [`description(Option<String>)`](crate::output::PutBotOutput::description): <p>A description of the bot.</p>
    ///   - [`intents(Option<Vec<Intent>>)`](crate::output::PutBotOutput::intents): <p>An array of <code>Intent</code> objects. For more information, see <code>PutBot</code>.</p>
    ///   - [`enable_model_improvements(Option<bool>)`](crate::output::PutBotOutput::enable_model_improvements): <p>Indicates whether the bot uses accuracy improvements. <code>true</code> indicates that the bot is using the improvements, otherwise, <code>false</code>.</p>
    ///   - [`nlu_intent_confidence_threshold(Option<f64>)`](crate::output::PutBotOutput::nlu_intent_confidence_threshold): <p>The score that determines where Amazon Lex inserts the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> is inserted if the confidence score for all intents is below this value. <code>AMAZON.KendraSearchIntent</code> is only inserted if it is configured for the bot.</p>
    ///   - [`clarification_prompt(Option<Prompt>)`](crate::output::PutBotOutput::clarification_prompt): <p> The prompts that Amazon Lex uses when it doesn't understand the user's intent. For more information, see <code>PutBot</code>. </p>
    ///   - [`abort_statement(Option<Statement>)`](crate::output::PutBotOutput::abort_statement): <p>The message that Amazon Lex uses to cancel a conversation. For more information, see <code>PutBot</code>.</p>
    ///   - [`status(Option<Status>)`](crate::output::PutBotOutput::status): <p> When you send a request to create a bot with <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the <code>status</code> response element to <code>BUILDING</code>.</p>  <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot with user inputs that exactly match the utterances configured for the bot's intents and values in the slot types.</p>  <p>If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to <code>FAILED</code>. Amazon Lex returns the reason for the failure in the <code>failureReason</code> response element. </p>  <p>When you set <code>processBehavior</code> to <code>SAVE</code>, Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>  <p>When the bot is in the <code>READY</code> state you can test and publish the bot.</p>
    ///   - [`failure_reason(Option<String>)`](crate::output::PutBotOutput::failure_reason): <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the reason that it failed to build the bot.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::PutBotOutput::last_updated_date): <p>The date that the bot was updated. When you create a resource, the creation date and last updated date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::PutBotOutput::created_date): <p>The date that the bot was created.</p>
    ///   - [`idle_session_ttl_in_seconds(Option<i32>)`](crate::output::PutBotOutput::idle_session_ttl_in_seconds): <p>The maximum length of time that Amazon Lex retains the data gathered in a conversation. For more information, see <code>PutBot</code>.</p>
    ///   - [`voice_id(Option<String>)`](crate::output::PutBotOutput::voice_id): <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user. For more information, see <code>PutBot</code>.</p>
    ///   - [`checksum(Option<String>)`](crate::output::PutBotOutput::checksum): <p>Checksum of the bot that you created.</p>
    ///   - [`version(Option<String>)`](crate::output::PutBotOutput::version): <p>The version of the bot. For a new bot, the version is always <code>$LATEST</code>.</p>
    ///   - [`locale(Option<Locale>)`](crate::output::PutBotOutput::locale): <p> The target locale for the bot. </p>
    ///   - [`child_directed(Option<bool>)`](crate::output::PutBotOutput::child_directed): <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>  <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
    ///   - [`create_version(Option<bool>)`](crate::output::PutBotOutput::create_version): <p> <code>True</code> if a new version of the bot was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>
    ///   - [`detect_sentiment(Option<bool>)`](crate::output::PutBotOutput::detect_sentiment): <p> <code>true</code> if the bot is configured to send user utterances to Amazon Comprehend for sentiment analysis. If the <code>detectSentiment</code> field was not specified in the request, the <code>detectSentiment</code> field is <code>false</code> in the response.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::PutBotOutput::tags): <p>A list of tags associated with the bot.</p>
    /// - On failure, responds with [`SdkError<PutBotError>`](crate::error::PutBotError)
    pub fn put_bot(&self) -> fluent_builders::PutBot<C, M, R> {
        fluent_builders::PutBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutBotAlias`](crate::client::fluent_builders::PutBotAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutBotAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutBotAlias::set_name): <p>The name of the alias. The name is <i>not</i> case sensitive.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutBotAlias::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutBotAlias::set_description): <p>A description of the alias.</p>
    ///   - [`bot_version(impl Into<String>)`](crate::client::fluent_builders::PutBotAlias::bot_version) / [`set_bot_version(Option<String>)`](crate::client::fluent_builders::PutBotAlias::set_bot_version): <p>The version of the bot.</p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::PutBotAlias::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::PutBotAlias::set_bot_name): <p>The name of the bot.</p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::PutBotAlias::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::PutBotAlias::set_checksum): <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>  <p>When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>  <p>When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
    ///   - [`conversation_logs(ConversationLogsRequest)`](crate::client::fluent_builders::PutBotAlias::conversation_logs) / [`set_conversation_logs(Option<ConversationLogsRequest>)`](crate::client::fluent_builders::PutBotAlias::set_conversation_logs): <p>Settings for conversation logs for the alias.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PutBotAlias::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PutBotAlias::set_tags): <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
    /// - On success, responds with [`PutBotAliasOutput`](crate::output::PutBotAliasOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PutBotAliasOutput::name): <p>The name of the alias.</p>
    ///   - [`description(Option<String>)`](crate::output::PutBotAliasOutput::description): <p>A description of the alias.</p>
    ///   - [`bot_version(Option<String>)`](crate::output::PutBotAliasOutput::bot_version): <p>The version of the bot that the alias points to.</p>
    ///   - [`bot_name(Option<String>)`](crate::output::PutBotAliasOutput::bot_name): <p>The name of the bot that the alias points to.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::PutBotAliasOutput::last_updated_date): <p>The date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::PutBotAliasOutput::created_date): <p>The date that the bot alias was created.</p>
    ///   - [`checksum(Option<String>)`](crate::output::PutBotAliasOutput::checksum): <p>The checksum for the current version of the alias.</p>
    ///   - [`conversation_logs(Option<ConversationLogsResponse>)`](crate::output::PutBotAliasOutput::conversation_logs): <p>The settings that determine how Amazon Lex uses conversation logs for the alias.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::PutBotAliasOutput::tags): <p>A list of tags associated with a bot.</p>
    /// - On failure, responds with [`SdkError<PutBotAliasError>`](crate::error::PutBotAliasError)
    pub fn put_bot_alias(&self) -> fluent_builders::PutBotAlias<C, M, R> {
        fluent_builders::PutBotAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutIntent`](crate::client::fluent_builders::PutIntent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutIntent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutIntent::set_name): <p>The name of the intent. The name is <i>not</i> case sensitive. </p>  <p>The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent called <code>HelpIntent</code>.</p>  <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutIntent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutIntent::set_description): <p>A description of the intent.</p>
    ///   - [`slots(Vec<Slot>)`](crate::client::fluent_builders::PutIntent::slots) / [`set_slots(Option<Vec<Slot>>)`](crate::client::fluent_builders::PutIntent::set_slots): <p>An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined in the slots. For more information, see <code>how-it-works</code>. </p>
    ///   - [`sample_utterances(Vec<String>)`](crate::client::fluent_builders::PutIntent::sample_utterances) / [`set_sample_utterances(Option<Vec<String>>)`](crate::client::fluent_builders::PutIntent::set_sample_utterances): <p>An array of utterances (strings) that a user might say to signal the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>  <p>In each utterance, a slot name is enclosed in curly braces. </p>
    ///   - [`confirmation_prompt(Prompt)`](crate::client::fluent_builders::PutIntent::confirmation_prompt) / [`set_confirmation_prompt(Option<Prompt>)`](crate::client::fluent_builders::PutIntent::set_confirmation_prompt): <p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p>  <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p> <note>   <p>You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>  </note>
    ///   - [`rejection_statement(Statement)`](crate::client::fluent_builders::PutIntent::rejection_statement) / [`set_rejection_statement(Option<Statement>)`](crate::client::fluent_builders::PutIntent::set_rejection_statement): <p>When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p> <note>   <p>You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>  </note>
    ///   - [`follow_up_prompt(FollowUpPrompt)`](crate::client::fluent_builders::PutIntent::follow_up_prompt) / [`set_follow_up_prompt(Option<FollowUpPrompt>)`](crate::client::fluent_builders::PutIntent::set_follow_up_prompt): <p>Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p>  <p>The action that Amazon Lex takes depends on the user's response, as follows:</p>  <ul>   <li> <p>If the user says "Yes" it responds with the clarification prompt that is configured for the bot.</p> </li>   <li> <p>if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the intent.</p> </li>   <li> <p>If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.</p> </li>   <li> <p>If it doesn't recognize the utterance it repeats the follow-up prompt again.</p> </li>  </ul>  <p>The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You can specify only one. </p>
    ///   - [`conclusion_statement(Statement)`](crate::client::fluent_builders::PutIntent::conclusion_statement) / [`set_conclusion_statement(Option<Statement>)`](crate::client::fluent_builders::PutIntent::set_conclusion_statement): <p> The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the Lambda function. </p>  <p>This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you return the intent to the client application, you can't specify this element.</p> <note>   <p>The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only one.</p>  </note>
    ///   - [`dialog_code_hook(CodeHook)`](crate::client::fluent_builders::PutIntent::dialog_code_hook) / [`set_dialog_code_hook(Option<CodeHook>)`](crate::client::fluent_builders::PutIntent::set_dialog_code_hook): <p> Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize user interaction. </p>  <p>For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding session attribute. </p>
    ///   - [`fulfillment_activity(FulfillmentActivity)`](crate::client::fluent_builders::PutIntent::fulfillment_activity) / [`set_fulfillment_activity(Option<FulfillmentActivity>)`](crate::client::fluent_builders::PutIntent::set_fulfillment_activity): <p>Required. Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store. </p>  <p> You might configure Amazon Lex to return all of the intent information to the client application, or direct it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria). </p>
    ///   - [`parent_intent_signature(impl Into<String>)`](crate::client::fluent_builders::PutIntent::parent_intent_signature) / [`set_parent_intent_signature(Option<String>)`](crate::client::fluent_builders::PutIntent::set_parent_intent_signature): <p>A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::PutIntent::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::PutIntent::set_checksum): <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>  <p>When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>  <p>When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
    ///   - [`create_version(bool)`](crate::client::fluent_builders::PutIntent::create_version) / [`set_create_version(Option<bool>)`](crate::client::fluent_builders::PutIntent::set_create_version): <p>When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
    ///   - [`kendra_configuration(KendraConfiguration)`](crate::client::fluent_builders::PutIntent::kendra_configuration) / [`set_kendra_configuration(Option<KendraConfiguration>)`](crate::client::fluent_builders::PutIntent::set_kendra_configuration): <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html"> AMAZON.KendraSearchIntent</a>.</p>
    ///   - [`input_contexts(Vec<InputContext>)`](crate::client::fluent_builders::PutIntent::input_contexts) / [`set_input_contexts(Option<Vec<InputContext>>)`](crate::client::fluent_builders::PutIntent::set_input_contexts): <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
    ///   - [`output_contexts(Vec<OutputContext>)`](crate::client::fluent_builders::PutIntent::output_contexts) / [`set_output_contexts(Option<Vec<OutputContext>>)`](crate::client::fluent_builders::PutIntent::set_output_contexts): <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
    /// - On success, responds with [`PutIntentOutput`](crate::output::PutIntentOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PutIntentOutput::name): <p>The name of the intent.</p>
    ///   - [`description(Option<String>)`](crate::output::PutIntentOutput::description): <p>A description of the intent.</p>
    ///   - [`slots(Option<Vec<Slot>>)`](crate::output::PutIntentOutput::slots): <p>An array of intent slots that are configured for the intent.</p>
    ///   - [`sample_utterances(Option<Vec<String>>)`](crate::output::PutIntentOutput::sample_utterances): <p> An array of sample utterances that are configured for the intent. </p>
    ///   - [`confirmation_prompt(Option<Prompt>)`](crate::output::PutIntentOutput::confirmation_prompt): <p>If defined in the intent, Amazon Lex prompts the user to confirm the intent before fulfilling it.</p>
    ///   - [`rejection_statement(Option<Statement>)`](crate::output::PutIntentOutput::rejection_statement): <p>If the user answers "no" to the question defined in <code>confirmationPrompt</code> Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p>
    ///   - [`follow_up_prompt(Option<FollowUpPrompt>)`](crate::output::PutIntentOutput::follow_up_prompt): <p>If defined in the intent, Amazon Lex uses this prompt to solicit additional user activity after the intent is fulfilled.</p>
    ///   - [`conclusion_statement(Option<Statement>)`](crate::output::PutIntentOutput::conclusion_statement): <p>After the Lambda function specified in the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex conveys this statement to the user.</p>
    ///   - [`dialog_code_hook(Option<CodeHook>)`](crate::output::PutIntentOutput::dialog_code_hook): <p>If defined in the intent, Amazon Lex invokes this Lambda function for each user input.</p>
    ///   - [`fulfillment_activity(Option<FulfillmentActivity>)`](crate::output::PutIntentOutput::fulfillment_activity): <p>If defined in the intent, Amazon Lex invokes this Lambda function to fulfill the intent after the user provides all of the information required by the intent.</p>
    ///   - [`parent_intent_signature(Option<String>)`](crate::output::PutIntentOutput::parent_intent_signature): <p>A unique identifier for the built-in intent that this intent is based on.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::PutIntentOutput::last_updated_date): <p>The date that the intent was updated. When you create a resource, the creation date and last update dates are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::PutIntentOutput::created_date): <p>The date that the intent was created.</p>
    ///   - [`version(Option<String>)`](crate::output::PutIntentOutput::version): <p>The version of the intent. For a new intent, the version is always <code>$LATEST</code>.</p>
    ///   - [`checksum(Option<String>)`](crate::output::PutIntentOutput::checksum): <p>Checksum of the <code>$LATEST</code>version of the intent created or updated.</p>
    ///   - [`create_version(Option<bool>)`](crate::output::PutIntentOutput::create_version): <p> <code>True</code> if a new version of the intent was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>
    ///   - [`kendra_configuration(Option<KendraConfiguration>)`](crate::output::PutIntentOutput::kendra_configuration): <p>Configuration information, if any, required to connect to an Amazon Kendra index and use the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    ///   - [`input_contexts(Option<Vec<InputContext>>)`](crate::output::PutIntentOutput::input_contexts): <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
    ///   - [`output_contexts(Option<Vec<OutputContext>>)`](crate::output::PutIntentOutput::output_contexts): <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
    /// - On failure, responds with [`SdkError<PutIntentError>`](crate::error::PutIntentError)
    pub fn put_intent(&self) -> fluent_builders::PutIntent<C, M, R> {
        fluent_builders::PutIntent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSlotType`](crate::client::fluent_builders::PutSlotType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutSlotType::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutSlotType::set_name): <p>The name of the slot type. The name is <i>not</i> case sensitive. </p>  <p>The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called <code>DATE</code>.</p>  <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutSlotType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutSlotType::set_description): <p>A description of the slot type.</p>
    ///   - [`enumeration_values(Vec<EnumerationValue>)`](crate::client::fluent_builders::PutSlotType::enumeration_values) / [`set_enumeration_values(Option<Vec<EnumerationValue>>)`](crate::client::fluent_builders::PutSlotType::set_enumeration_values): <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model about the values that it resolves for a slot. </p>  <p>A regular expression slot type doesn't require enumeration values. All other slot types require a list of enumeration values.</p>  <p>When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not using a Lambda function you can choose to return the value that the user entered or the first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use. </p>
    ///   - [`checksum(impl Into<String>)`](crate::client::fluent_builders::PutSlotType::checksum) / [`set_checksum(Option<String>)`](crate::client::fluent_builders::PutSlotType::set_checksum): <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>  <p>When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>  <p>When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
    ///   - [`value_selection_strategy(SlotValueSelectionStrategy)`](crate::client::fluent_builders::PutSlotType::value_selection_strategy) / [`set_value_selection_strategy(Option<SlotValueSelectionStrategy>)`](crate::client::fluent_builders::PutSlotType::set_value_selection_strategy): <p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p>  <ul>   <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>   <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li>  </ul>  <p>If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>
    ///   - [`create_version(bool)`](crate::client::fluent_builders::PutSlotType::create_version) / [`set_create_version(Option<bool>)`](crate::client::fluent_builders::PutSlotType::set_create_version): <p>When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
    ///   - [`parent_slot_type_signature(impl Into<String>)`](crate::client::fluent_builders::PutSlotType::parent_slot_type_signature) / [`set_parent_slot_type_signature(Option<String>)`](crate::client::fluent_builders::PutSlotType::set_parent_slot_type_signature): <p>The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type has all of the same configuration as the parent.</p>  <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    ///   - [`slot_type_configurations(Vec<SlotTypeConfiguration>)`](crate::client::fluent_builders::PutSlotType::slot_type_configurations) / [`set_slot_type_configurations(Option<Vec<SlotTypeConfiguration>>)`](crate::client::fluent_builders::PutSlotType::set_slot_type_configurations): <p>Configuration information that extends the parent built-in slot type. The configuration is added to the settings for the parent slot type.</p>
    /// - On success, responds with [`PutSlotTypeOutput`](crate::output::PutSlotTypeOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::PutSlotTypeOutput::name): <p>The name of the slot type.</p>
    ///   - [`description(Option<String>)`](crate::output::PutSlotTypeOutput::description): <p>A description of the slot type.</p>
    ///   - [`enumeration_values(Option<Vec<EnumerationValue>>)`](crate::output::PutSlotTypeOutput::enumeration_values): <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.</p>
    ///   - [`last_updated_date(Option<DateTime>)`](crate::output::PutSlotTypeOutput::last_updated_date): <p>The date that the slot type was updated. When you create a slot type, the creation date and last update date are the same.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::PutSlotTypeOutput::created_date): <p>The date that the slot type was created.</p>
    ///   - [`version(Option<String>)`](crate::output::PutSlotTypeOutput::version): <p>The version of the slot type. For a new slot type, the version is always <code>$LATEST</code>. </p>
    ///   - [`checksum(Option<String>)`](crate::output::PutSlotTypeOutput::checksum): <p>Checksum of the <code>$LATEST</code> version of the slot type.</p>
    ///   - [`value_selection_strategy(Option<SlotValueSelectionStrategy>)`](crate::output::PutSlotTypeOutput::value_selection_strategy): <p>The slot resolution strategy that Amazon Lex uses to determine the value of the slot. For more information, see <code>PutSlotType</code>.</p>
    ///   - [`create_version(Option<bool>)`](crate::output::PutSlotTypeOutput::create_version): <p> <code>True</code> if a new version of the slot type was created. If the <code>createVersion</code> field was not specified in the request, the <code>createVersion</code> field is set to false in the response.</p>
    ///   - [`parent_slot_type_signature(Option<String>)`](crate::output::PutSlotTypeOutput::parent_slot_type_signature): <p>The built-in slot type used as the parent of the slot type.</p>
    ///   - [`slot_type_configurations(Option<Vec<SlotTypeConfiguration>>)`](crate::output::PutSlotTypeOutput::slot_type_configurations): <p>Configuration information that extends the parent built-in slot type.</p>
    /// - On failure, responds with [`SdkError<PutSlotTypeError>`](crate::error::PutSlotTypeError)
    pub fn put_slot_type(&self) -> fluent_builders::PutSlotType<C, M, R> {
        fluent_builders::PutSlotType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImport`](crate::client::fluent_builders::StartImport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`payload(Blob)`](crate::client::fluent_builders::StartImport::payload) / [`set_payload(Option<Blob>)`](crate::client::fluent_builders::StartImport::set_payload): <p>A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to import. The resource should match the type specified in the <code>resourceType</code> field.</p>
    ///   - [`resource_type(ResourceType)`](crate::client::fluent_builders::StartImport::resource_type) / [`set_resource_type(Option<ResourceType>)`](crate::client::fluent_builders::StartImport::set_resource_type): <p>Specifies the type of resource to export. Each resource also exports any resources that it depends on. </p>  <ul>   <li> <p>A bot exports dependent intents.</p> </li>   <li> <p>An intent exports dependent slot types.</p> </li>  </ul>
    ///   - [`merge_strategy(MergeStrategy)`](crate::client::fluent_builders::StartImport::merge_strategy) / [`set_merge_strategy(Option<MergeStrategy>)`](crate::client::fluent_builders::StartImport::set_merge_strategy): <p>Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource with the same name.</p>  <ul>   <li> <p>FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code> field of the response to the <code>GetImport</code> operation.</p> <p>OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The $LASTEST version of the existing resource is overwritten with the data from the import file.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::StartImport::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::StartImport::set_tags): <p>A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to an intent or slot type.</p>
    /// - On success, responds with [`StartImportOutput`](crate::output::StartImportOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::StartImportOutput::name): <p>The name given to the import job.</p>
    ///   - [`resource_type(Option<ResourceType>)`](crate::output::StartImportOutput::resource_type): <p>The type of resource to import.</p>
    ///   - [`merge_strategy(Option<MergeStrategy>)`](crate::output::StartImportOutput::merge_strategy): <p>The action to take when there is a merge conflict.</p>
    ///   - [`import_id(Option<String>)`](crate::output::StartImportOutput::import_id): <p>The identifier for the specific import job.</p>
    ///   - [`import_status(Option<ImportStatus>)`](crate::output::StartImportOutput::import_status): <p>The status of the import job. If the status is <code>FAILED</code>, you can get the reason for the failure using the <code>GetImport</code> operation.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::StartImportOutput::tags): <p>A list of tags added to the imported bot.</p>
    ///   - [`created_date(Option<DateTime>)`](crate::output::StartImportOutput::created_date): <p>A timestamp for the date and time that the import job was requested.</p>
    /// - On failure, responds with [`SdkError<StartImportError>`](crate::error::StartImportError)
    pub fn start_import(&self) -> fluent_builders::StartImport<C, M, R> {
        fluent_builders::StartImport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartMigration`](crate::client::fluent_builders::StartMigration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`v1_bot_name(impl Into<String>)`](crate::client::fluent_builders::StartMigration::v1_bot_name) / [`set_v1_bot_name(Option<String>)`](crate::client::fluent_builders::StartMigration::set_v1_bot_name): <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    ///   - [`v1_bot_version(impl Into<String>)`](crate::client::fluent_builders::StartMigration::v1_bot_version) / [`set_v1_bot_version(Option<String>)`](crate::client::fluent_builders::StartMigration::set_v1_bot_version): <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well as any numbered version.</p>
    ///   - [`v2_bot_name(impl Into<String>)`](crate::client::fluent_builders::StartMigration::v2_bot_name) / [`set_v2_bot_name(Option<String>)`](crate::client::fluent_builders::StartMigration::set_v2_bot_name): <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>  <ul>   <li> <p>If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.</p> </li>   <li> <p>If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change the contents of the Amazon Lex V2 bot.</p> </li>  </ul>
    ///   - [`v2_bot_role(impl Into<String>)`](crate::client::fluent_builders::StartMigration::v2_bot_role) / [`set_v2_bot_role(Option<String>)`](crate::client::fluent_builders::StartMigration::set_v2_bot_role): <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    ///   - [`migration_strategy(MigrationStrategy)`](crate::client::fluent_builders::StartMigration::migration_strategy) / [`set_migration_strategy(Option<MigrationStrategy>)`](crate::client::fluent_builders::StartMigration::set_migration_strategy): <p>The strategy used to conduct the migration.</p>  <ul>   <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li>   <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is created in the Amazon Lex V2 bot.</p> </li>  </ul>
    /// - On success, responds with [`StartMigrationOutput`](crate::output::StartMigrationOutput) with field(s):
    ///   - [`v1_bot_name(Option<String>)`](crate::output::StartMigrationOutput::v1_bot_name): <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    ///   - [`v1_bot_version(Option<String>)`](crate::output::StartMigrationOutput::v1_bot_version): <p>The version of the bot to migrate to Amazon Lex V2. </p>
    ///   - [`v1_bot_locale(Option<Locale>)`](crate::output::StartMigrationOutput::v1_bot_locale): <p>The locale used for the Amazon Lex V1 bot. </p>
    ///   - [`v2_bot_id(Option<String>)`](crate::output::StartMigrationOutput::v2_bot_id): <p>The unique identifier for the Amazon Lex V2 bot. </p>
    ///   - [`v2_bot_role(Option<String>)`](crate::output::StartMigrationOutput::v2_bot_role): <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    ///   - [`migration_id(Option<String>)`](crate::output::StartMigrationOutput::migration_id): <p>The unique identifier that Amazon Lex assigned to the migration.</p>
    ///   - [`migration_strategy(Option<MigrationStrategy>)`](crate::output::StartMigrationOutput::migration_strategy): <p>The strategy used to conduct the migration.</p>
    ///   - [`migration_timestamp(Option<DateTime>)`](crate::output::StartMigrationOutput::migration_timestamp): <p>The date and time that the migration started.</p>
    /// - On failure, responds with [`SdkError<StartMigrationError>`](crate::error::StartMigrationError)
    pub fn start_migration(&self) -> fluent_builders::StartMigration<C, M, R> {
        fluent_builders::StartMigration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateBotVersion`.
    ///
    /// <p>Creates a new version of the bot based on the <code>$LATEST</code> version. If the <code>$LATEST</code> version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version. It returns the last created version.</p> <note>
    /// <p>You can update only the <code>$LATEST</code> version of the bot. You can't update the numbered versions that you create with the <code>CreateBotVersion</code> operation.</p>
    /// </note>
    /// <p> When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <code>versioning-intro</code>. </p>
    /// <p> This operation requires permission for the <code>lex:CreateBotVersion</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBotVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bot_version_input::Builder,
    }
    impl<C, M, R> CreateBotVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBotVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBotVersionInputOperationOutputAlias,
                crate::output::CreateBotVersionOutput,
                crate::error::CreateBotVersionError,
                crate::input::CreateBotVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot that you want to create a new version of. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot that you want to create a new version of. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version of the bot. If you specify a checksum and the <code>$LATEST</code> version of the bot has a different checksum, a <code>PreconditionFailedException</code> exception is returned and Amazon Lex doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version of the bot. If you specify a checksum and the <code>$LATEST</code> version of the bot has a different checksum, a <code>PreconditionFailedException</code> exception is returned and Amazon Lex doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntentVersion`.
    ///
    /// <p>Creates a new version of an intent based on the <code>$LATEST</code> version of the intent. If the <code>$LATEST</code> version of this intent hasn't changed since you last updated it, Amazon Lex doesn't create a new version. It returns the last version you created.</p> <note>
    /// <p>You can update only the <code>$LATEST</code> version of the intent. You can't update the numbered versions that you create with the <code>CreateIntentVersion</code> operation.</p>
    /// </note>
    /// <p> When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <code>versioning-intro</code>. </p>
    /// <p>This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_intent_version_input::Builder,
    }
    impl<C, M, R> CreateIntentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntentVersionInputOperationOutputAlias,
                crate::output::CreateIntentVersionOutput,
                crate::error::CreateIntentVersionError,
                crate::input::CreateIntentVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent that you want to create a new version of. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent that you want to create a new version of. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the intent that should be used to create the new version. If you specify a checksum and the <code>$LATEST</code> version of the intent has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish a new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSlotTypeVersion`.
    ///
    /// <p>Creates a new version of a slot type based on the <code>$LATEST</code> version of the specified slot type. If the <code>$LATEST</code> version of this resource has not changed since the last version that you created, Amazon Lex doesn't create a new version. It returns the last version that you created. </p> <note>
    /// <p>You can update only the <code>$LATEST</code> version of a slot type. You can't update the numbered versions that you create with the <code>CreateSlotTypeVersion</code> operation.</p>
    /// </note>
    /// <p>When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For more information, see <code>versioning-intro</code>. </p>
    /// <p>This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSlotTypeVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_slot_type_version_input::Builder,
    }
    impl<C, M, R> CreateSlotTypeVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSlotTypeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSlotTypeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSlotTypeVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSlotTypeVersionInputOperationOutputAlias,
                crate::output::CreateSlotTypeVersionOutput,
                crate::error::CreateSlotTypeVersionError,
                crate::input::CreateSlotTypeVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot type that you want to create a new version for. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type that you want to create a new version for. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Checksum for the <code>$LATEST</code> version of the slot type that you want to publish. If you specify a checksum and the <code>$LATEST</code> version of the slot type has a different checksum, Amazon Lex returns a <code>PreconditionFailedException</code> exception and doesn't publish the new version. If you don't specify a checksum, Amazon Lex publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBot`.
    ///
    /// <p>Deletes all versions of the bot, including the <code>$LATEST</code> version. To delete a specific version of the bot, use the <code>DeleteBotVersion</code> operation. The <code>DeleteBot</code> operation doesn't immediately remove the bot schema. Instead, it is marked for deletion and removed later.</p>
    /// <p>Amazon Lex stores utterances indefinitely for improving the ability of your bot to respond to user inputs. These utterances are not removed when the bot is deleted. To remove the utterances, use the <code>DeleteUtterances</code> operation.</p>
    /// <p>If a bot has an alias, you can't delete it. Instead, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring alias until the <code>DeleteBot</code> operation is successful.</p>
    /// <p>This operation requires permissions for the <code>lex:DeleteBot</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_input::Builder,
    }
    impl<C, M, R> DeleteBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotInputOperationOutputAlias,
                crate::output::DeleteBotOutput,
                crate::error::DeleteBotError,
                crate::input::DeleteBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotAlias`.
    ///
    /// <p>Deletes an alias for the specified bot. </p>
    /// <p>You can't delete an alias that is used in the association between a bot and a messaging channel. If an alias is used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code> exception that includes a reference to the channel association that refers to the bot. You can remove the reference to the alias by deleting the channel association. If you get the same exception again, delete the referring association until the <code>DeleteBotAlias</code> operation is successful.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_alias_input::Builder,
    }
    impl<C, M, R> DeleteBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotAliasInputOperationOutputAlias,
                crate::output::DeleteBotAliasOutput,
                crate::error::DeleteBotAliasError,
                crate::input::DeleteBotAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alias to delete. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias to delete. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotChannelAssociation`.
    ///
    /// <p>Deletes the association between an Amazon Lex bot and a messaging platform.</p>
    /// <p>This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotChannelAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_channel_association_input::Builder,
    }
    impl<C, M, R> DeleteBotChannelAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotChannelAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotChannelAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotChannelAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotChannelAssociationInputOperationOutputAlias,
                crate::output::DeleteBotChannelAssociationOutput,
                crate::error::DeleteBotChannelAssociationError,
                crate::input::DeleteBotChannelAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the association. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the association. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>An alias that points to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>An alias that points to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBotVersion`.
    ///
    /// <p>Deletes a specific version of a bot. To delete all versions of a bot, use the <code>DeleteBot</code> operation. </p>
    /// <p>This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBotVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bot_version_input::Builder,
    }
    impl<C, M, R> DeleteBotVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBotVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBotVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBotVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBotVersionInputOperationOutputAlias,
                crate::output::DeleteBotVersionOutput,
                crate::error::DeleteBotVersionError,
                crate::input::DeleteBotVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the bot to delete. You cannot delete the <code>$LATEST</code> version of the bot. To delete the <code>$LATEST</code> version, use the <code>DeleteBot</code> operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the bot to delete. You cannot delete the <code>$LATEST</code> version of the bot. To delete the <code>$LATEST</code> version, use the <code>DeleteBot</code> operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntent`.
    ///
    /// <p>Deletes all versions of the intent, including the <code>$LATEST</code> version. To delete a specific version of the intent, use the <code>DeleteIntentVersion</code> operation.</p>
    /// <p> You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in one or more bots (see <code>how-it-works</code>), you must remove those references first. </p> <note>
    /// <p> If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get the same exception when you attempt to delete the intent again, repeat until the intent has no references and the call to <code>DeleteIntent</code> is successful. </p>
    /// </note>
    /// <p> This operation requires permission for the <code>lex:DeleteIntent</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_intent_input::Builder,
    }
    impl<C, M, R> DeleteIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntentInputOperationOutputAlias,
                crate::output::DeleteIntentOutput,
                crate::error::DeleteIntentError,
                crate::input::DeleteIntentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntentVersion`.
    ///
    /// <p>Deletes a specific version of an intent. To delete all versions of a intent, use the <code>DeleteIntent</code> operation. </p>
    /// <p>This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntentVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_intent_version_input::Builder,
    }
    impl<C, M, R> DeleteIntentVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntentVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntentVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntentVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntentVersionInputOperationOutputAlias,
                crate::output::DeleteIntentVersionOutput,
                crate::error::DeleteIntentVersionError,
                crate::input::DeleteIntentVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the intent to delete. You cannot delete the <code>$LATEST</code> version of the intent. To delete the <code>$LATEST</code> version, use the <code>DeleteIntent</code> operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the intent to delete. You cannot delete the <code>$LATEST</code> version of the intent. To delete the <code>$LATEST</code> version, use the <code>DeleteIntent</code> operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlotType`.
    ///
    /// <p>Deletes all versions of the slot type, including the <code>$LATEST</code> version. To delete a specific version of the slot type, use the <code>DeleteSlotTypeVersion</code> operation.</p>
    /// <p> You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to in one or more intents, you must remove those references first. </p> <note>
    /// <p> If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until the slot type has no references and the <code>DeleteSlotType</code> call is successful. </p>
    /// </note>
    /// <p>This operation requires permission for the <code>lex:DeleteSlotType</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_slot_type_input::Builder,
    }
    impl<C, M, R> DeleteSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSlotTypeInputOperationOutputAlias,
                crate::output::DeleteSlotTypeOutput,
                crate::error::DeleteSlotTypeError,
                crate::input::DeleteSlotTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSlotTypeVersion`.
    ///
    /// <p>Deletes a specific version of a slot type. To delete all versions of a slot type, use the <code>DeleteSlotType</code> operation. </p>
    /// <p>This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSlotTypeVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_slot_type_version_input::Builder,
    }
    impl<C, M, R> DeleteSlotTypeVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSlotTypeVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSlotTypeVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSlotTypeVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSlotTypeVersionInputOperationOutputAlias,
                crate::output::DeleteSlotTypeVersionOutput,
                crate::error::DeleteSlotTypeVersionError,
                crate::input::DeleteSlotTypeVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the slot type to delete. You cannot delete the <code>$LATEST</code> version of the slot type. To delete the <code>$LATEST</code> version, use the <code>DeleteSlotType</code> operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the slot type to delete. You cannot delete the <code>$LATEST</code> version of the slot type. To delete the <code>$LATEST</code> version, use the <code>DeleteSlotType</code> operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUtterances`.
    ///
    /// <p>Deletes stored utterances.</p>
    /// <p>Amazon Lex stores the utterances that users send to your bot. Utterances are stored for 15 days for use with the <code>GetUtterancesView</code> operation, and then stored indefinitely for use in improving the ability of your bot to respond to user input.</p>
    /// <p>Use the <code>DeleteUtterances</code> operation to manually delete stored utterances for a specific user. When you use the <code>DeleteUtterances</code> operation, utterances stored for improving your bot's ability to respond to user input are deleted immediately. Utterances stored for use with the <code>GetUtterancesView</code> operation are deleted after 15 days.</p>
    /// <p>This operation requires permissions for the <code>lex:DeleteUtterances</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUtterances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_utterances_input::Builder,
    }
    impl<C, M, R> DeleteUtterances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUtterances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUtterancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUtterancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUtterancesInputOperationOutputAlias,
                crate::output::DeleteUtterancesOutput,
                crate::error::DeleteUtterancesError,
                crate::input::DeleteUtterancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot that stored the utterances.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot that stored the utterances.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p> The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the utterance.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p> The unique identifier for the user that made the utterances. This is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the utterance.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBot`.
    ///
    /// <p>Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias. </p>
    /// <p> This operation requires permissions for the <code>lex:GetBot</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_input::Builder,
    }
    impl<C, M, R> GetBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotInputOperationOutputAlias,
                crate::output::GetBotOutput,
                crate::error::GetBotError,
                crate::input::GetBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version or alias of the bot.</p>
        pub fn version_or_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_or_alias(input.into());
            self
        }
        /// <p>The version or alias of the bot.</p>
        pub fn set_version_or_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_version_or_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBotAlias`.
    ///
    /// <p>Returns information about an Amazon Lex bot alias. For more information about aliases, see <code>versioning-aliases</code>.</p>
    /// <p>This operation requires permissions for the <code>lex:GetBotAlias</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_alias_input::Builder,
    }
    impl<C, M, R> GetBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotAliasInputOperationOutputAlias,
                crate::output::GetBotAliasOutput,
                crate::error::GetBotAliasError,
                crate::input::GetBotAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot alias. The name is case sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot alias. The name is case sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBotAliases`.
    ///
    /// <p>Returns a list of aliases for a specified Amazon Lex bot.</p>
    /// <p>This operation requires permissions for the <code>lex:GetBotAliases</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBotAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_aliases_input::Builder,
    }
    impl<C, M, R> GetBotAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBotAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotAliasesInputOperationOutputAlias,
                crate::output::GetBotAliasesOutput,
                crate::error::GetBotAliasesError,
                crate::input::GetBotAliasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBotAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBotAliasesPaginator<C, M, R> {
            crate::paginator::GetBotAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of aliases. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of aliases, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of aliases to return in the response. The default is 50. . </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of aliases to return in the response. The default is 50. . </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Substring to match in bot alias names. An alias will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBotChannelAssociation`.
    ///
    /// <p>Returns information about the association between an Amazon Lex bot and a messaging platform.</p>
    /// <p>This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBotChannelAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_channel_association_input::Builder,
    }
    impl<C, M, R> GetBotChannelAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBotChannelAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotChannelAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotChannelAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotChannelAssociationInputOperationOutputAlias,
                crate::output::GetBotChannelAssociationOutput,
                crate::error::GetBotChannelAssociationError,
                crate::input::GetBotChannelAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the association between the bot and the channel. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the association between the bot and the channel. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBotChannelAssociations`.
    ///
    /// <p> Returns a list of all of the channels associated with the specified bot. </p>
    /// <p>The <code>GetBotChannelAssociations</code> operation requires permissions for the <code>lex:GetBotChannelAssociations</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBotChannelAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_channel_associations_input::Builder,
    }
    impl<C, M, R> GetBotChannelAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBotChannelAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotChannelAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotChannelAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotChannelAssociationsInputOperationOutputAlias,
                crate::output::GetBotChannelAssociationsOutput,
                crate::error::GetBotChannelAssociationsError,
                crate::input::GetBotChannelAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBotChannelAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetBotChannelAssociationsPaginator<C, M, R> {
            crate::paginator::GetBotChannelAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Amazon Lex bot in the association.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot in the association.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_alias(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_alias(input);
            self
        }
        /// <p>A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of associations. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of associations, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of associations to return in the response. The default is 50. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of associations to return in the response. The default is 50. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the <code>nameContains</code> parameter.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Substring to match in channel association names. An association will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot channel associations, use a hyphen ("-") as the <code>nameContains</code> parameter.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBots`.
    ///
    /// <p>Returns bot information as follows: </p>
    /// <ul>
    /// <li> <p>If you provide the <code>nameContains</code> field, the response includes information for the <code>$LATEST</code> version of all bots whose name contains the specified string.</p> </li>
    /// <li> <p>If you don't specify the <code>nameContains</code> field, the operation returns information about the <code>$LATEST</code> version of all of your bots.</p> </li>
    /// </ul>
    /// <p>This operation requires permission for the <code>lex:GetBots</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bots_input::Builder,
    }
    impl<C, M, R> GetBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotsInputOperationOutputAlias,
                crate::output::GetBotsOutput,
                crate::error::GetBotsError,
                crate::input::GetBotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBotsPaginator<C, M, R> {
            crate::paginator::GetBotsPaginator::new(self.handle, self.inner)
        }
        /// <p>A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of bots. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of bots, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of bots to return in the response that the request will return. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bots to return in the response that the request will return. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Substring to match in bot names. A bot will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBotVersions`.
    ///
    /// <p>Gets information about all of the versions of a bot.</p>
    /// <p>The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot. For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four <code>BotMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p>
    /// <p>The <code>GetBotVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p>
    /// <p>This operation requires permissions for the <code>lex:GetBotVersions</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBotVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bot_versions_input::Builder,
    }
    impl<C, M, R> GetBotVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBotVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBotVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBotVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBotVersionsInputOperationOutputAlias,
                crate::output::GetBotVersionsOutput,
                crate::error::GetBotVersionsError,
                crate::input::GetBotVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBotVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBotVersionsPaginator<C, M, R> {
            crate::paginator::GetBotVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the bot for which versions should be returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot for which versions should be returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of bot versions to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of bot versions to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBuiltinIntent`.
    ///
    /// <p>Returns information about a built-in intent.</p>
    /// <p>This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBuiltinIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_builtin_intent_input::Builder,
    }
    impl<C, M, R> GetBuiltinIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBuiltinIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBuiltinIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBuiltinIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBuiltinIntentInputOperationOutputAlias,
                crate::output::GetBuiltinIntentOutput,
                crate::error::GetBuiltinIntentError,
                crate::input::GetBuiltinIntentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for a built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signature(input.into());
            self
        }
        /// <p>The unique identifier for a built-in intent. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_signature(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBuiltinIntents`.
    ///
    /// <p>Gets a list of built-in intents that meet the specified criteria.</p>
    /// <p>This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBuiltinIntents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_builtin_intents_input::Builder,
    }
    impl<C, M, R> GetBuiltinIntents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBuiltinIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBuiltinIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBuiltinIntentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBuiltinIntentsInputOperationOutputAlias,
                crate::output::GetBuiltinIntentsOutput,
                crate::error::GetBuiltinIntentsError,
                crate::input::GetBuiltinIntentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBuiltinIntentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBuiltinIntentsPaginator<C, M, R> {
            crate::paginator::GetBuiltinIntentsPaginator::new(self.handle, self.inner)
        }
        /// <p>A list of locales that the intent supports.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>A list of locales that the intent supports.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn signature_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signature_contains(input.into());
            self
        }
        /// <p>Substring to match in built-in intent signatures. An intent will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn set_signature_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_signature_contains(input);
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, use the pagination token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBuiltinSlotTypes`.
    ///
    /// <p>Gets a list of built-in slot types that meet the specified criteria.</p>
    /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>
    /// <p>This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBuiltinSlotTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_builtin_slot_types_input::Builder,
    }
    impl<C, M, R> GetBuiltinSlotTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBuiltinSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBuiltinSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBuiltinSlotTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBuiltinSlotTypesInputOperationOutputAlias,
                crate::output::GetBuiltinSlotTypesOutput,
                crate::error::GetBuiltinSlotTypesError,
                crate::input::GetBuiltinSlotTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetBuiltinSlotTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetBuiltinSlotTypesPaginator<C, M, R> {
            crate::paginator::GetBuiltinSlotTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>A list of locales that the slot type supports.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>A list of locales that the slot type supports.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn signature_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.signature_contains(input.into());
            self
        }
        /// <p>Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_signature_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_signature_contains(input);
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the pagination token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExport`.
    ///
    /// <p>Exports the contents of a Amazon Lex resource in a specified format. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_input::Builder,
    }
    impl<C, M, R> GetExport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportInputOperationOutputAlias,
                crate::output::GetExportOutput,
                crate::error::GetExportError,
                crate::input::GetExportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot to export.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot to export.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
        /// <p>The type of resource to export. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of resource to export. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn export_type(mut self, input: crate::model::ExportType) -> Self {
            self.inner = self.inner.export_type(input);
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn set_export_type(
            mut self,
            input: std::option::Option<crate::model::ExportType>,
        ) -> Self {
            self.inner = self.inner.set_export_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImport`.
    ///
    /// <p>Gets information about an import job started with the <code>StartImport</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_import_input::Builder,
    }
    impl<C, M, R> GetImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImportInputOperationOutputAlias,
                crate::output::GetImportOutput,
                crate::error::GetImportError,
                crate::input::GetImportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the import job information to return.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.import_id(input.into());
            self
        }
        /// <p>The identifier of the import job information to return.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_import_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntent`.
    ///
    /// <p> Returns information about an intent. In addition to the intent name, you must specify the intent version. </p>
    /// <p> This operation requires permissions to perform the <code>lex:GetIntent</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_intent_input::Builder,
    }
    impl<C, M, R> GetIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntentInputOperationOutputAlias,
                crate::output::GetIntentOutput,
                crate::error::GetIntentError,
                crate::input::GetIntentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the intent.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the intent.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntents`.
    ///
    /// <p>Returns intent information as follows: </p>
    /// <ul>
    /// <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all intents that contain the specified string.</p> </li>
    /// <li> <p> If you don't specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all intents. </p> </li>
    /// </ul>
    /// <p> The operation requires permission for the <code>lex:GetIntents</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_intents_input::Builder,
    }
    impl<C, M, R> GetIntents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntentsInputOperationOutputAlias,
                crate::output::GetIntentsOutput,
                crate::error::GetIntentsError,
                crate::input::GetIntentsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetIntentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetIntentsPaginator<C, M, R> {
            crate::paginator::GetIntentsPaginator::new(self.handle, self.inner)
        }
        /// <p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Substring to match in intent names. An intent will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntentVersions`.
    ///
    /// <p>Gets information about all of the versions of an intent.</p>
    /// <p>The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p>
    /// <p>The <code>GetIntentVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p>
    /// <p>This operation requires permissions for the <code>lex:GetIntentVersions</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntentVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_intent_versions_input::Builder,
    }
    impl<C, M, R> GetIntentVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntentVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntentVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntentVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntentVersionsInputOperationOutputAlias,
                crate::output::GetIntentVersionsOutput,
                crate::error::GetIntentVersionsError,
                crate::input::GetIntentVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetIntentVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetIntentVersionsPaginator<C, M, R> {
            crate::paginator::GetIntentVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the intent for which versions should be returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent for which versions should be returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of intent versions to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of intent versions to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMigration`.
    ///
    /// <p>Provides details about an ongoing or complete migration from an Amazon Lex V1 bot to an Amazon Lex V2 bot. Use this operation to view the migration alerts and warnings related to the migration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMigration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_migration_input::Builder,
    }
    impl<C, M, R> GetMigration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMigration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMigrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMigrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMigrationInputOperationOutputAlias,
                crate::output::GetMigrationOutput,
                crate::error::GetMigrationError,
                crate::input::GetMigrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the migration to view. The <code>migrationID</code> is returned by the operation.</p>
        pub fn migration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.migration_id(input.into());
            self
        }
        /// <p>The unique identifier of the migration to view. The <code>migrationID</code> is returned by the operation.</p>
        pub fn set_migration_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_migration_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMigrations`.
    ///
    /// <p>Gets a list of migrations between Amazon Lex V1 and Amazon Lex V2.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMigrations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_migrations_input::Builder,
    }
    impl<C, M, R> GetMigrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMigrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMigrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMigrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMigrationsInputOperationOutputAlias,
                crate::output::GetMigrationsOutput,
                crate::error::GetMigrationsError,
                crate::input::GetMigrationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetMigrationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetMigrationsPaginator<C, M, R> {
            crate::paginator::GetMigrationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that the migration was started.</p>
        pub fn sort_by_attribute(mut self, input: crate::model::MigrationSortAttribute) -> Self {
            self.inner = self.inner.sort_by_attribute(input);
            self
        }
        /// <p>The field to sort the list of migrations by. You can sort by the Amazon Lex V1 bot name or the date and time that the migration was started.</p>
        pub fn set_sort_by_attribute(
            mut self,
            input: std::option::Option<crate::model::MigrationSortAttribute>,
        ) -> Self {
            self.inner = self.inner.set_sort_by_attribute(input);
            self
        }
        /// <p>The order so sort the list.</p>
        pub fn sort_by_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_by_order(input);
            self
        }
        /// <p>The order so sort the list.</p>
        pub fn set_sort_by_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_by_order(input);
            self
        }
        /// <p>Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in bot name.</p>
        pub fn v1_bot_name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.v1_bot_name_contains(input.into());
            self
        }
        /// <p>Filters the list to contain only bots whose name contains the specified string. The string is matched anywhere in bot name.</p>
        pub fn set_v1_bot_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_v1_bot_name_contains(input);
            self
        }
        /// <p>Filters the list to contain only migrations in the specified state.</p>
        pub fn migration_status_equals(mut self, input: crate::model::MigrationStatus) -> Self {
            self.inner = self.inner.migration_status_equals(input);
            self
        }
        /// <p>Filters the list to contain only migrations in the specified state.</p>
        pub fn set_migration_status_equals(
            mut self,
            input: std::option::Option<crate::model::MigrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_migration_status_equals(input);
            self
        }
        /// <p>The maximum number of migrations to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of migrations to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A pagination token that fetches the next page of migrations. If the response to this operation is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the pagination token in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of migrations. If the response to this operation is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of migrations, specify the pagination token in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSlotType`.
    ///
    /// <p>Returns information about a specific version of a slot type. In addition to specifying the slot type name, you must specify the slot type version.</p>
    /// <p>This operation requires permissions for the <code>lex:GetSlotType</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_slot_type_input::Builder,
    }
    impl<C, M, R> GetSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSlotTypeInputOperationOutputAlias,
                crate::output::GetSlotTypeOutput,
                crate::error::GetSlotTypeError,
                crate::input::GetSlotTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the slot type. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>The version of the slot type. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSlotTypes`.
    ///
    /// <p>Returns slot type information as follows: </p>
    /// <ul>
    /// <li> <p>If you specify the <code>nameContains</code> field, returns the <code>$LATEST</code> version of all slot types that contain the specified string.</p> </li>
    /// <li> <p> If you don't specify the <code>nameContains</code> field, returns information about the <code>$LATEST</code> version of all slot types. </p> </li>
    /// </ul>
    /// <p> The operation requires permission for the <code>lex:GetSlotTypes</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSlotTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_slot_types_input::Builder,
    }
    impl<C, M, R> GetSlotTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSlotTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSlotTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSlotTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSlotTypesInputOperationOutputAlias,
                crate::output::GetSlotTypesOutput,
                crate::error::GetSlotTypesError,
                crate::input::GetSlotTypesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSlotTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSlotTypesPaginator<C, M, R> {
            crate::paginator::GetSlotTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the response to this API call is truncated, Amazon Lex returns a pagination token in the response. To fetch next page of slot types, specify the pagination token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_contains(input.into());
            self
        }
        /// <p>Substring to match in slot type names. A slot type will be returned if any part of its name matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSlotTypeVersions`.
    ///
    /// <p>Gets information about all versions of a slot type.</p>
    /// <p>The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code> operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and one for the <code>$LATEST</code> version. </p>
    /// <p>The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>$LATEST</code> version.</p>
    /// <p>This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSlotTypeVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_slot_type_versions_input::Builder,
    }
    impl<C, M, R> GetSlotTypeVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSlotTypeVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSlotTypeVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSlotTypeVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSlotTypeVersionsInputOperationOutputAlias,
                crate::output::GetSlotTypeVersionsOutput,
                crate::error::GetSlotTypeVersionsError,
                crate::input::GetSlotTypeVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSlotTypeVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSlotTypeVersionsPaginator<C, M, R> {
            crate::paginator::GetSlotTypeVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the slot type for which versions should be returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type for which versions should be returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of slot type versions. If the response to this call is truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of slot type versions to return in the response. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of slot type versions to return in the response. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUtterancesView`.
    ///
    /// <p>Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have made to your bot. You can use this list to tune the utterances that your bot responds to.</p>
    /// <p>For example, say that you have created a bot to order flowers. After your users have used your bot for a while, use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.</p>
    /// <p>After you publish a new version of a bot, you can get information about the old version and the new so that you can compare the performance across the two versions. </p>
    /// <p>Utterance statistics are generated once a day. Data is available for the last 15 days. You can request information for up to 5 versions of your bot in each request. Amazon Lex returns the most frequent utterances received by the bot in the last 15 days. The response contains information about a maximum of 100 utterances for each version.</p>
    /// <p>If you set <code>childDirected</code> field to true when you created your bot, if you are using slot obfuscation with one or more slots, or if you opted out of participating in improving Amazon Lex, utterances are not available.</p>
    /// <p>This operation requires permissions for the <code>lex:GetUtterancesView</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUtterancesView<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_utterances_view_input::Builder,
    }
    impl<C, M, R> GetUtterancesView<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUtterancesView`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUtterancesViewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUtterancesViewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUtterancesViewInputOperationOutputAlias,
                crate::output::GetUtterancesViewOutput,
                crate::error::GetUtterancesViewError,
                crate::input::GetUtterancesViewInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot for which utterance information should be returned.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot for which utterance information should be returned.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// Appends an item to `botVersions`.
        ///
        /// To override the contents of this collection use [`set_bot_versions`](Self::set_bot_versions).
        ///
        /// <p>An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.</p>
        pub fn bot_versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_versions(input.into());
            self
        }
        /// <p>An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.</p>
        pub fn set_bot_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_bot_versions(input);
            self
        }
        /// <p>To return utterances that were recognized and handled, use <code>Detected</code>. To return utterances that were not recognized, use <code>Missed</code>.</p>
        pub fn status_type(mut self, input: crate::model::StatusType) -> Self {
            self.inner = self.inner.status_type(input);
            self
        }
        /// <p>To return utterances that were recognized and handled, use <code>Detected</code>. To return utterances that were not recognized, use <code>Missed</code>.</p>
        pub fn set_status_type(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.inner = self.inner.set_status_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of tags associated with the specified resource. Only bots, bot aliases, and bot channels can have tags associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBot`.
    ///
    /// <p>Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are only required to specify a name, a locale, and whether the bot is directed toward children under age 13. You can use this to add intents later, or to remove intents from an existing bot. When you create a bot with the minimum information, the bot is created or updated but Amazon Lex returns the <code></code> response <code>FAILED</code>. You can build the bot after you add one or more intents. For more information about Amazon Lex bots, see <code>how-it-works</code>. </p>
    /// <p>If you specify the name of an existing bot, the fields in the request replace the existing values in the <code>$LATEST</code> version of the bot. Amazon Lex removes any fields that you don't provide values for in the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set to their default values. If you don't specify values for required fields, Amazon Lex throws an exception.</p>
    /// <p>This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see <code>security-iam</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_bot_input::Builder,
    }
    impl<C, M, R> PutBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBotOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBotInputOperationOutputAlias,
                crate::output::PutBotOutput,
                crate::error::PutBotError,
                crate::input::PutBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bot. The name is <i>not</i> case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the bot. The name is <i>not</i> case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a pizza ordering bot might support an OrderPizza intent. For more information, see <code>how-it-works</code>.</p>
        pub fn intents(mut self, input: crate::model::Intent) -> Self {
            self.inner = self.inner.intents(input);
            self
        }
        /// <p>An array of <code>Intent</code> objects. Each intent represents a command that a user can express. For example, a pizza ordering bot might support an OrderPizza intent. For more information, see <code>how-it-works</code>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        ) -> Self {
            self.inner = self.inner.set_intents(input);
            self
        }
        /// <p>Set to <code>true</code> to enable access to natural language understanding improvements. </p>
        /// <p>When you set the <code>enableModelImprovements</code> parameter to <code>true</code> you can use the <code>nluIntentConfidenceThreshold</code> parameter to configure confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>You can only set the <code>enableModelImprovements</code> parameter in certain Regions. If you set the parameter to <code>true</code>, your bot has access to accuracy improvements.</p>
        /// <p>The Regions where you can set the <code>enableModelImprovements</code> parameter to <code>true</code> are:</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (us-east-1)</p> </li>
        /// <li> <p>US West (Oregon) (us-west-2)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>
        /// <li> <p>EU (Ireland) (eu-west-1)</p> </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default. In these Regions setting the parameter to <code>false</code> throws a <code>ValidationException</code> exception.</p>
        pub fn enable_model_improvements(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_model_improvements(input);
            self
        }
        /// <p>Set to <code>true</code> to enable access to natural language understanding improvements. </p>
        /// <p>When you set the <code>enableModelImprovements</code> parameter to <code>true</code> you can use the <code>nluIntentConfidenceThreshold</code> parameter to configure confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>You can only set the <code>enableModelImprovements</code> parameter in certain Regions. If you set the parameter to <code>true</code>, your bot has access to accuracy improvements.</p>
        /// <p>The Regions where you can set the <code>enableModelImprovements</code> parameter to <code>true</code> are:</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (us-east-1)</p> </li>
        /// <li> <p>US West (Oregon) (us-west-2)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>
        /// <li> <p>EU (Ireland) (eu-west-1)</p> </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default. In these Regions setting the parameter to <code>false</code> throws a <code>ValidationException</code> exception.</p>
        pub fn set_enable_model_improvements(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_model_improvements(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>You must set the <code>enableModelImprovements</code> parameter to <code>true</code> to use confidence scores in the following regions.</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (us-east-1)</p> </li>
        /// <li> <p>US West (Oregon) (us-west-2)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>
        /// <li> <p>EU (Ireland) (eu-west-1)</p> </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.inner = self.inner.nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the <code>AMAZON.FallbackIntent</code>, <code>AMAZON.KendraSearchIntent</code>, or both when returning alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response. <code>AMAZON.FallbackIntent</code> and <code>AMAZON.KendraSearchIntent</code> are only inserted if they are configured for the bot.</p>
        /// <p>You must set the <code>enableModelImprovements</code> parameter to <code>true</code> to use confidence scores in the following regions.</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (us-east-1)</p> </li>
        /// <li> <p>US West (Oregon) (us-west-2)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (ap-southeast-2)</p> </li>
        /// <li> <p>EU (Ireland) (eu-west-1)</p> </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter is set to <code>true</code> by default.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three alternative intents with the following confidence scores: IntentA (0.70), IntentB (0.60), IntentC (0.50). The response from the <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li> <p>AMAZON.FallbackIntent</p> </li>
        /// <li> <p>IntentA</p> </li>
        /// <li> <p>IntentB</p> </li>
        /// <li> <p>IntentC</p> </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.inner = self.inner.set_nlu_intent_confidence_threshold(input);
            self
        }
        /// <p>When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If Amazon Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field. </p>
        /// <p>When you create a clarification prompt, make sure that it suggests the correct response from the user. for example, for a bot that orders pizza and drinks, you might create this clarification prompt: "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
        /// <p>If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number of times defined in the <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>
        /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in three cases: </p>
        /// <ul>
        /// <li> <p>Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example, in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the user to get an intent.</p> </li>
        /// <li> <p>Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>
        /// <li> <p>PutSession operation - When using the <code>PutSession</code> operation, you send an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>
        /// </ul>
        pub fn clarification_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.inner = self.inner.clarification_prompt(input);
            self
        }
        /// <p>When Amazon Lex doesn't understand the user's intent, it uses this message to get clarification. To specify how many times Amazon Lex should repeat the clarification prompt, use the <code>maxAttempts</code> field. If Amazon Lex still doesn't understand, it sends the message in the <code>abortStatement</code> field. </p>
        /// <p>When you create a clarification prompt, make sure that it suggests the correct response from the user. for example, for a bot that orders pizza and drinks, you might create this clarification prompt: "What would you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
        /// <p>If you have defined a fallback intent, it will be invoked if the clarification prompt is repeated the number of times defined in the <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>
        /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will return a 400 Bad Request exception in three cases: </p>
        /// <ul>
        /// <li> <p>Follow-up prompt - When the user responds to a follow-up prompt but does not provide an intent. For example, in response to a follow-up prompt that says "Would you like anything else today?" the user says "Yes." Amazon Lex will return a 400 Bad Request exception because it does not have a clarification prompt to send to the user to get an intent.</p> </li>
        /// <li> <p>Lambda function - When using a Lambda function, you return an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>
        /// <li> <p>PutSession operation - When using the <code>PutSession</code> operation, you send an <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a clarification prompt to get an intent from the user, it returns a 400 Bad Request exception.</p> </li>
        /// </ul>
        pub fn set_clarification_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.inner = self.inner.set_clarification_prompt(input);
            self
        }
        /// <p>When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then cancels the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type. </p>
        /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries to elicit a correct response a few more times. </p>
        /// <p>For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.</p>
        /// <p>If you have defined a fallback intent the cancel statement will not be sent to the user, the fallback intent is used instead. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>
        pub fn abort_statement(mut self, input: crate::model::Statement) -> Self {
            self.inner = self.inner.abort_statement(input);
            self
        }
        /// <p>When Amazon Lex can't understand the user's input in context, it tries to elicit the information a few times. After that, Amazon Lex sends the message defined in <code>abortStatement</code> to the user, and then cancels the conversation. To set the number of retries, use the <code>valueElicitationPrompt</code> field for the slot type. </p>
        /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What type of crust would you like?" If the user's response is not one of the expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex tries to elicit a correct response a few more times. </p>
        /// <p>For example, in a pizza ordering application, <code>OrderPizza</code> might be one of the intents. This intent might require the <code>CrustType</code> slot. You specify the <code>valueElicitationPrompt</code> field when you create the <code>CrustType</code> slot.</p>
        /// <p>If you have defined a fallback intent the cancel statement will not be sent to the user, the fallback intent is used instead. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html"> AMAZON.FallbackIntent</a>.</p>
        pub fn set_abort_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.inner = self.inner.set_abort_statement(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
        /// <p>A user interaction session remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user doesn't complete the order within the specified time, Amazon Lex discards the slot information that it gathered, and the user must start over.</p>
        /// <p>If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.</p>
        /// <p>The default is 300 seconds (5 minutes).</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.idle_session_ttl_in_seconds(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.</p>
        /// <p>A user interaction session remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>For example, suppose that a user chooses the OrderPizza intent, but gets sidetracked halfway through placing an order. If the user doesn't complete the order within the specified time, Amazon Lex discards the slot information that it gathered, and the user must start over.</p>
        /// <p>If you don't include the <code>idleSessionTTLInSeconds</code> element in a <code>PutBot</code> operation request, Amazon Lex uses the default value. This is also true if the request replaces an existing bot.</p>
        /// <p>The default is 300 seconds (5 minutes).</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_idle_session_ttl_in_seconds(input);
            self
        }
        /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon Polly Developer Guide</i>.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voice_id(input.into());
            self
        }
        /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices in Amazon Polly</a> in the <i>Amazon Polly Developer Guide</i>.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_voice_id(input);
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new bot, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
        /// <p>If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it. </p>
        /// <p>If you don't specify this value, the default value is <code>BUILD</code>.</p>
        pub fn process_behavior(mut self, input: crate::model::ProcessBehavior) -> Self {
            self.inner = self.inner.process_behavior(input);
            self
        }
        /// <p>If you set the <code>processBehavior</code> element to <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't build it. </p>
        /// <p>If you don't specify this value, the default value is <code>BUILD</code>.</p>
        pub fn set_process_behavior(
            mut self,
            input: std::option::Option<crate::model::ProcessBehavior>,
        ) -> Self {
            self.inner = self.inner.set_process_behavior(input);
            self
        }
        /// <p> Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. </p>
        /// <p>The default is <code>en-US</code>.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p> Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. </p>
        /// <p>The default is <code>en-US</code>.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.inner = self.inner.child_directed(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying <code>true</code> or <code>false</code> in the <code>childDirected</code> field. By specifying <code>true</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. By specifying <code>false</code> in the <code>childDirected</code> field, you confirm that your use of Amazon Lex <b>is not</b> related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. You may not specify a default value for the <code>childDirected</code> field that does not accurately reflect whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other application that is directed in whole or in part, to children under age 13, you must obtain any required verifiable parental consent under COPPA. For information regarding the use of Amazon Lex in connection with websites, programs, or other applications that are directed or targeted, in whole or in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a> </p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_child_directed(input);
            self
        }
        /// <p>When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify <code>detectSentiment</code>, the default is <code>false</code>.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.inner = self.inner.detect_sentiment(input);
            self
        }
        /// <p>When set to <code>true</code> user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify <code>detectSentiment</code>, the default is <code>false</code>.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_detect_sentiment(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_version(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the bot is created. This is the same as calling the <code>CreateBotVersion</code> operation. If you don't specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_version(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you create a bot, you can't use the <code>PutBot</code> operation to update the tags on a bot. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutBotAlias`.
    ///
    /// <p>Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the version of the bot that the alias points to, replace the alias. For more information about aliases, see <code>versioning-aliases</code>.</p>
    /// <p>This operation requires permissions for the <code>lex:PutBotAlias</code> action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutBotAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_bot_alias_input::Builder,
    }
    impl<C, M, R> PutBotAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutBotAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutBotAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::PutBotAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutBotAliasInputOperationOutputAlias,
                crate::output::PutBotAliasOutput,
                crate::error::PutBotAliasError,
                crate::input::PutBotAliasInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alias. The name is <i>not</i> case sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias. The name is <i>not</i> case sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_version(input.into());
            self
        }
        /// <p>The version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_version(input);
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new bot alias, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot alias, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
        /// <p>Settings for conversation logs for the alias.</p>
        pub fn conversation_logs(mut self, input: crate::model::ConversationLogsRequest) -> Self {
            self.inner = self.inner.conversation_logs(input);
            self
        }
        /// <p>Settings for conversation logs for the alias.</p>
        pub fn set_conversation_logs(
            mut self,
            input: std::option::Option<crate::model::ConversationLogsRequest>,
        ) -> Self {
            self.inner = self.inner.set_conversation_logs(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the bot alias. You can only add tags when you create an alias, you can't use the <code>PutBotAlias</code> operation to update the tags on a bot alias. To update tags, use the <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntent`.
    ///
    /// <p>Creates an intent or replaces an existing intent.</p>
    /// <p>To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot, for example, you would create an <code>OrderPizza</code> intent. </p>
    /// <p>To create an intent or replace an existing intent, you must provide the following:</p>
    /// <ul>
    /// <li> <p>Intent name. For example, <code>OrderPizza</code>.</p> </li>
    /// <li> <p>Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."</p> </li>
    /// <li> <p>Information to be gathered. You specify slot types for the information that your bot will request from the user. You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of a pizza.</p> </li>
    /// <li> <p>How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent information to the client application. If you use a Lambda function, when all of the intent information is available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information to the client application. </p> </li>
    /// </ul>
    /// <p>You can specify other optional information in the request, such as:</p>
    /// <ul>
    /// <li> <p>A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"</p> </li>
    /// <li> <p>A conclusion statement to send to the user after the intent has been fulfilled. For example, "I placed your pizza order."</p> </li>
    /// <li> <p>A follow-up prompt that asks the user for additional activity. For example, asking "Do you want to order a drink with your pizza?"</p> </li>
    /// </ul>
    /// <p>If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the <code>$LATEST</code> version of the intent with the values in the request. Amazon Lex removes fields that you don't provide in the request. If you don't specify the required fields, Amazon Lex throws an exception. When you update the <code>$LATEST</code> version of an intent, the <code>status</code> field of any bot that uses the <code>$LATEST</code> version of the intent is set to <code>NOT_BUILT</code>.</p>
    /// <p>For more information, see <code>how-it-works</code>.</p>
    /// <p>This operation requires permissions for the <code>lex:PutIntent</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutIntent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_intent_input::Builder,
    }
    impl<C, M, R> PutIntent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntentOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntentInputOperationOutputAlias,
                crate::output::PutIntentOutput,
                crate::error::PutIntentError,
                crate::input::PutIntentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the intent. The name is <i>not</i> case sensitive. </p>
        /// <p>The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent called <code>HelpIntent</code>.</p>
        /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the intent. The name is <i>not</i> case sensitive. </p>
        /// <p>The name can't match a built-in intent name, or a built-in intent name with "AMAZON." removed. For example, because there is a built-in intent called <code>AMAZON.HelpIntent</code>, you can't create a custom intent called <code>HelpIntent</code>.</p>
        /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined in the slots. For more information, see <code>how-it-works</code>. </p>
        pub fn slots(mut self, input: crate::model::Slot) -> Self {
            self.inner = self.inner.slots(input);
            self
        }
        /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot values from the user using prompts defined in the slots. For more information, see <code>how-it-works</code>. </p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.inner = self.inner.set_slots(input);
            self
        }
        /// Appends an item to `sampleUtterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of utterances (strings) that a user might say to signal the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
        /// <p>In each utterance, a slot name is enclosed in curly braces. </p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_utterances(input.into());
            self
        }
        /// <p>An array of utterances (strings) that a user might say to signal the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas". </p>
        /// <p>In each utterance, a slot name is enclosed in curly braces. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_sample_utterances(input);
            self
        }
        /// <p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p> <note>
        /// <p>You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn confirmation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.inner = self.inner.confirmation_prompt(input);
            self
        }
        /// <p>Prompts the user to confirm the intent. This question should have a yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. For example, with the <code>OrderPizza</code> intent, you might want to confirm that the order is correct before placing it. For other intents, such as intents that simply respond to user questions, you might not need to ask the user for confirmation before providing the information. </p> <note>
        /// <p>You you must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn set_confirmation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.inner = self.inner.set_confirmation_prompt(input);
            self
        }
        /// <p>When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p> <note>
        /// <p>You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.inner = self.inner.rejection_statement(input);
            self
        }
        /// <p>When the user answers "no" to the question defined in <code>confirmationPrompt</code>, Amazon Lex responds with this statement to acknowledge that the intent was canceled. </p> <note>
        /// <p>You must provide both the <code>rejectionStatement</code> and the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.inner = self.inner.set_rejection_statement(input);
            self
        }
        /// <p>Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p>
        /// <p>The action that Amazon Lex takes depends on the user's response, as follows:</p>
        /// <ul>
        /// <li> <p>If the user says "Yes" it responds with the clarification prompt that is configured for the bot.</p> </li>
        /// <li> <p>if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the intent.</p> </li>
        /// <li> <p>If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.</p> </li>
        /// <li> <p>If it doesn't recognize the utterance it repeats the follow-up prompt again.</p> </li>
        /// </ul>
        /// <p>The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You can specify only one. </p>
        pub fn follow_up_prompt(mut self, input: crate::model::FollowUpPrompt) -> Self {
            self.inner = self.inner.follow_up_prompt(input);
            self
        }
        /// <p>Amazon Lex uses this prompt to solicit additional activity after fulfilling an intent. For example, after the <code>OrderPizza</code> intent is fulfilled, you might prompt the user to order a drink.</p>
        /// <p>The action that Amazon Lex takes depends on the user's response, as follows:</p>
        /// <ul>
        /// <li> <p>If the user says "Yes" it responds with the clarification prompt that is configured for the bot.</p> </li>
        /// <li> <p>if the user says "Yes" and continues with an utterance that triggers an intent it starts a conversation for the intent.</p> </li>
        /// <li> <p>If the user says "No" it responds with the rejection statement configured for the the follow-up prompt.</p> </li>
        /// <li> <p>If it doesn't recognize the utterance it repeats the follow-up prompt again.</p> </li>
        /// </ul>
        /// <p>The <code>followUpPrompt</code> field and the <code>conclusionStatement</code> field are mutually exclusive. You can specify only one. </p>
        pub fn set_follow_up_prompt(
            mut self,
            input: std::option::Option<crate::model::FollowUpPrompt>,
        ) -> Self {
            self.inner = self.inner.set_follow_up_prompt(input);
            self
        }
        /// <p> The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the Lambda function. </p>
        /// <p>This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you return the intent to the client application, you can't specify this element.</p> <note>
        /// <p>The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only one.</p>
        /// </note>
        pub fn conclusion_statement(mut self, input: crate::model::Statement) -> Self {
            self.inner = self.inner.conclusion_statement(input);
            self
        }
        /// <p> The statement that you want Amazon Lex to convey to the user after the intent is successfully fulfilled by the Lambda function. </p>
        /// <p>This element is relevant only if you provide a Lambda function in the <code>fulfillmentActivity</code>. If you return the intent to the client application, you can't specify this element.</p> <note>
        /// <p>The <code>followUpPrompt</code> and <code>conclusionStatement</code> are mutually exclusive. You can specify only one.</p>
        /// </note>
        pub fn set_conclusion_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.inner = self.inner.set_conclusion_statement(input);
            self
        }
        /// <p> Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize user interaction. </p>
        /// <p>For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding session attribute. </p>
        pub fn dialog_code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.inner = self.inner.dialog_code_hook(input);
            self
        }
        /// <p> Specifies a Lambda function to invoke for each user input. You can invoke this Lambda function to personalize user interaction. </p>
        /// <p>For example, suppose your bot determines that the user is John. Your Lambda function might retrieve John's information from a backend database and prepopulate some of the values. For example, if you find that John is gluten intolerant, you might set the corresponding intent slot, <code>GlutenIntolerant</code>, to true. You might find John's phone number and set the corresponding session attribute. </p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::CodeHook>,
        ) -> Self {
            self.inner = self.inner.set_dialog_code_hook(input);
            self
        }
        /// <p>Required. Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store. </p>
        /// <p> You might configure Amazon Lex to return all of the intent information to the client application, or direct it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria). </p>
        pub fn fulfillment_activity(mut self, input: crate::model::FulfillmentActivity) -> Self {
            self.inner = self.inner.fulfillment_activity(input);
            self
        }
        /// <p>Required. Describes how the intent is fulfilled. For example, after a user provides all of the information for a pizza order, <code>fulfillmentActivity</code> defines how the bot places an order with a local pizza store. </p>
        /// <p> You might configure Amazon Lex to return all of the intent information to the client application, or direct it to invoke a Lambda function that can process the intent (for example, place an order with a pizzeria). </p>
        pub fn set_fulfillment_activity(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivity>,
        ) -> Self {
            self.inner = self.inner.set_fulfillment_activity(input);
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_intent_signature(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on. To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_intent_signature(input);
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new intent, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a intent, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_version(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the intent is created. This is the same as calling the <code>CreateIntentVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_version(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html"> AMAZON.KendraSearchIntent</a>.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.inner = self.inner.kendra_configuration(input);
            self
        }
        /// <p>Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html"> AMAZON.KendraSearchIntent</a>.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_kendra_configuration(input);
            self
        }
        /// Appends an item to `inputContexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
        pub fn input_contexts(mut self, input: crate::model::InputContext) -> Self {
            self.inner = self.inner.input_contexts(input);
            self
        }
        /// <p>An array of <code>InputContext</code> objects that lists the contexts that must be active for Amazon Lex to choose the intent in a conversation with the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.inner = self.inner.set_input_contexts(input);
            self
        }
        /// Appends an item to `outputContexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: crate::model::OutputContext) -> Self {
            self.inner = self.inner.output_contexts(input);
            self
        }
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts that the intent activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.inner = self.inner.set_output_contexts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSlotType`.
    ///
    /// <p>Creates a custom slot type or replaces an existing custom slot type.</p>
    /// <p>To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the values that a slot of this type can assume. For more information, see <code>how-it-works</code>.</p>
    /// <p>If you specify the name of an existing slot type, the fields in the request replace the existing values in the <code>$LATEST</code> version of the slot type. Amazon Lex removes the fields that you don't provide in the request. If you don't specify required fields, Amazon Lex throws an exception. When you update the <code>$LATEST</code> version of a slot type, if a bot uses the <code>$LATEST</code> version of an intent that contains the slot type, the bot's <code>status</code> field is set to <code>NOT_BUILT</code>.</p>
    /// <p>This operation requires permissions for the <code>lex:PutSlotType</code> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSlotType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_slot_type_input::Builder,
    }
    impl<C, M, R> PutSlotType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutSlotType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSlotTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSlotTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutSlotTypeInputOperationOutputAlias,
                crate::output::PutSlotTypeOutput,
                crate::error::PutSlotTypeError,
                crate::input::PutSlotTypeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the slot type. The name is <i>not</i> case sensitive. </p>
        /// <p>The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called <code>DATE</code>.</p>
        /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the slot type. The name is <i>not</i> case sensitive. </p>
        /// <p>The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called <code>DATE</code>.</p>
        /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `enumerationValues`.
        ///
        /// To override the contents of this collection use [`set_enumeration_values`](Self::set_enumeration_values).
        ///
        /// <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model about the values that it resolves for a slot. </p>
        /// <p>A regular expression slot type doesn't require enumeration values. All other slot types require a list of enumeration values.</p>
        /// <p>When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not using a Lambda function you can choose to return the value that the user entered or the first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use. </p>
        pub fn enumeration_values(mut self, input: crate::model::EnumerationValue) -> Self {
            self.inner = self.inner.enumeration_values(input);
            self
        }
        /// <p>A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take. Each value can have a list of <code>synonyms</code>, which are additional values that help train the machine learning model about the values that it resolves for a slot. </p>
        /// <p>A regular expression slot type doesn't require enumeration values. All other slot types require a list of enumeration values.</p>
        /// <p>When Amazon Lex resolves a slot value, it generates a resolution list that contains up to five possible values for the slot. If you are using a Lambda function, this resolution list is passed to the function. If you are not using a Lambda function you can choose to return the value that the user entered or the first value in the resolution list as the slot value. The <code>valueSelectionStrategy</code> field indicates the option to use. </p>
        pub fn set_enumeration_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        ) -> Self {
            self.inner = self.inner.set_enumeration_values(input);
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.checksum(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version.</p>
        /// <p>When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_checksum(input);
            self
        }
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>
        pub fn value_selection_strategy(
            mut self,
            input: crate::model::SlotValueSelectionStrategy,
        ) -> Self {
            self.inner = self.inner.value_selection_strategy(input);
            self
        }
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ORIGINAL_VALUE</code> - Returns the value entered by the user, if the user value is similar to the slot value.</p> </li>
        /// <li> <p> <code>TOP_RESOLUTION</code> - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</p> </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the default is <code>ORIGINAL_VALUE</code>.</p>
        pub fn set_value_selection_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionStrategy>,
        ) -> Self {
            self.inner = self.inner.set_value_selection_strategy(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.inner = self.inner.create_version(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the slot type is created. This is the same as calling the <code>CreateSlotTypeVersion</code> operation. If you do not specify <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_create_version(input);
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type has all of the same configuration as the parent.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_slot_type_signature(input.into());
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type. When you define a parent slot type, the new slot type has all of the same configuration as the parent.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_slot_type_signature(input);
            self
        }
        /// Appends an item to `slotTypeConfigurations`.
        ///
        /// To override the contents of this collection use [`set_slot_type_configurations`](Self::set_slot_type_configurations).
        ///
        /// <p>Configuration information that extends the parent built-in slot type. The configuration is added to the settings for the parent slot type.</p>
        pub fn slot_type_configurations(
            mut self,
            input: crate::model::SlotTypeConfiguration,
        ) -> Self {
            self.inner = self.inner.slot_type_configurations(input);
            self
        }
        /// <p>Configuration information that extends the parent built-in slot type. The configuration is added to the settings for the parent slot type.</p>
        pub fn set_slot_type_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_slot_type_configurations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImport`.
    ///
    /// <p>Starts a job to import a resource to Amazon Lex.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImport<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_import_input::Builder,
    }
    impl<C, M, R> StartImport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImportOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImportInputOperationOutputAlias,
                crate::output::StartImportOutput,
                crate::error::StartImportError,
                crate::input::StartImportInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to import. The resource should match the type specified in the <code>resourceType</code> field.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.payload(input);
            self
        }
        /// <p>A zip archive in binary format. The archive should contain one file, a JSON file containing the resource to import. The resource should match the type specified in the <code>resourceType</code> field.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_payload(input);
            self
        }
        /// <p>Specifies the type of resource to export. Each resource also exports any resources that it depends on. </p>
        /// <ul>
        /// <li> <p>A bot exports dependent intents.</p> </li>
        /// <li> <p>An intent exports dependent slot types.</p> </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>Specifies the type of resource to export. Each resource also exports any resources that it depends on. </p>
        /// <ul>
        /// <li> <p>A bot exports dependent intents.</p> </li>
        /// <li> <p>An intent exports dependent slot types.</p> </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource with the same name.</p>
        /// <ul>
        /// <li> <p>FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code> field of the response to the <code>GetImport</code> operation.</p> <p>OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The $LASTEST version of the existing resource is overwritten with the data from the import file.</p> </li>
        /// </ul>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.inner = self.inner.merge_strategy(input);
            self
        }
        /// <p>Specifies the action that the <code>StartImport</code> operation should take when there is an existing resource with the same name.</p>
        /// <ul>
        /// <li> <p>FAIL_ON_CONFLICT - The import operation is stopped on the first conflict between a resource in the import file and an existing resource. The name of the resource causing the conflict is in the <code>failureReason</code> field of the response to the <code>GetImport</code> operation.</p> <p>OVERWRITE_LATEST - The import operation proceeds even if there is a conflict with an existing resource. The $LASTEST version of the existing resource is overwritten with the data from the import file.</p> </li>
        /// </ul>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.inner = self.inner.set_merge_strategy(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to an intent or slot type.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags to add to the imported bot. You can only add tags when you import a bot, you can't add tags to an intent or slot type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMigration`.
    ///
    /// <p>Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want to take advantage of the new features of Amazon Lex V2.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex developer guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartMigration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_migration_input::Builder,
    }
    impl<C, M, R> StartMigration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMigration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMigrationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMigrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMigrationInputOperationOutputAlias,
                crate::output::StartMigrationOutput,
                crate::error::StartMigrationError,
                crate::input::StartMigrationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn v1_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.v1_bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn set_v1_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_v1_bot_name(input);
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well as any numbered version.</p>
        pub fn v1_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.v1_bot_version(input.into());
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the <code>$LATEST</code> version as well as any numbered version.</p>
        pub fn set_v1_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_v1_bot_version(input);
            self
        }
        /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
        /// <ul>
        /// <li> <p>If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.</p> </li>
        /// <li> <p>If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change the contents of the Amazon Lex V2 bot.</p> </li>
        /// </ul>
        pub fn v2_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.v2_bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
        /// <ul>
        /// <li> <p>If the Amazon Lex V2 bot doesn't exist, you must use the <code>CREATE_NEW</code> migration strategy.</p> </li>
        /// <li> <p>If the Amazon Lex V2 bot exists, you must use the <code>UPDATE_EXISTING</code> migration strategy to change the contents of the Amazon Lex V2 bot.</p> </li>
        /// </ul>
        pub fn set_v2_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_v2_bot_name(input);
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn v2_bot_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.v2_bot_role(input.into());
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn set_v2_bot_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_v2_bot_role(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li>
        /// <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is created in the Amazon Lex V2 bot.</p> </li>
        /// </ul>
        pub fn migration_strategy(mut self, input: crate::model::MigrationStrategy) -> Self {
            self.inner = self.inner.migration_strategy(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates the Amazon Lex V1 bot to the new bot.</p> </li>
        /// <li> <p> <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot metadata and the locale being migrated. It doesn't change any other locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale is created in the Amazon Lex V2 bot.</p> </li>
        /// </ul>
        pub fn set_migration_strategy(
            mut self,
            input: std::option::Option<crate::model::MigrationStrategy>,
        ) -> Self {
            self.inner = self.inner.set_migration_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag keys to add to the resource. If a tag key already exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a bot, bot alias or bot channel.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to remove from the resource. If a tag key does not exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
