// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A list of key/value pairs that identify a bot, bot alias, or bot
/// channel. Tag keys and values can consist of Unicode letters, digits, white
/// space, and any of the following symbols: _ . : / = + - @. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key for the tag. Keys are not case-sensitive and must be
    /// unique.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with a key. The value may be an empty string but
    /// it can't be null.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key for the tag. Keys are not case-sensitive and must be
    /// unique.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value associated with a key. The value may be an empty string but
    /// it can't be null.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key for the tag. Keys are not case-sensitive and must be
        /// unique.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag. Keys are not case-sensitive and must be
        /// unique.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with a key. The value may be an empty string but
        /// it can't be null.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with a key. The value may be an empty string but
        /// it can't be null.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationStrategy {
    #[allow(missing_docs)] // documentation missing in model
    CreateNew,
    #[allow(missing_docs)] // documentation missing in model
    UpdateExisting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationStrategy {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_NEW" => MigrationStrategy::CreateNew,
            "UPDATE_EXISTING" => MigrationStrategy::UpdateExisting,
            other => MigrationStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationStrategy::from(s))
    }
}
impl MigrationStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationStrategy::CreateNew => "CREATE_NEW",
            MigrationStrategy::UpdateExisting => "UPDATE_EXISTING",
            MigrationStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE_NEW", "UPDATE_EXISTING"]
    }
}
impl AsRef<str> for MigrationStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Locale {
    #[allow(missing_docs)] // documentation missing in model
    DeDe,
    #[allow(missing_docs)] // documentation missing in model
    EnAu,
    #[allow(missing_docs)] // documentation missing in model
    EnGb,
    #[allow(missing_docs)] // documentation missing in model
    EnIn,
    #[allow(missing_docs)] // documentation missing in model
    EnUs,
    #[allow(missing_docs)] // documentation missing in model
    Es419,
    #[allow(missing_docs)] // documentation missing in model
    EsEs,
    #[allow(missing_docs)] // documentation missing in model
    EsUs,
    #[allow(missing_docs)] // documentation missing in model
    FrCa,
    #[allow(missing_docs)] // documentation missing in model
    FrFr,
    #[allow(missing_docs)] // documentation missing in model
    ItIt,
    #[allow(missing_docs)] // documentation missing in model
    JaJp,
    #[allow(missing_docs)] // documentation missing in model
    KoKr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Locale {
    fn from(s: &str) -> Self {
        match s {
            "de-DE" => Locale::DeDe,
            "en-AU" => Locale::EnAu,
            "en-GB" => Locale::EnGb,
            "en-IN" => Locale::EnIn,
            "en-US" => Locale::EnUs,
            "es-419" => Locale::Es419,
            "es-ES" => Locale::EsEs,
            "es-US" => Locale::EsUs,
            "fr-CA" => Locale::FrCa,
            "fr-FR" => Locale::FrFr,
            "it-IT" => Locale::ItIt,
            "ja-JP" => Locale::JaJp,
            "ko-KR" => Locale::KoKr,
            other => Locale::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Locale {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Locale::from(s))
    }
}
impl Locale {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Locale::DeDe => "de-DE",
            Locale::EnAu => "en-AU",
            Locale::EnGb => "en-GB",
            Locale::EnIn => "en-IN",
            Locale::EnUs => "en-US",
            Locale::Es419 => "es-419",
            Locale::EsEs => "es-ES",
            Locale::EsUs => "es-US",
            Locale::FrCa => "fr-CA",
            Locale::FrFr => "fr-FR",
            Locale::ItIt => "it-IT",
            Locale::JaJp => "ja-JP",
            Locale::KoKr => "ko-KR",
            Locale::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "de-DE", "en-AU", "en-GB", "en-IN", "en-US", "es-419", "es-ES", "es-US", "fr-CA",
            "fr-FR", "it-IT", "ja-JP", "ko-KR",
        ]
    }
}
impl AsRef<str> for Locale {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ImportStatus::Complete,
            "FAILED" => ImportStatus::Failed,
            "IN_PROGRESS" => ImportStatus::InProgress,
            other => ImportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportStatus::from(s))
    }
}
impl ImportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportStatus::Complete => "COMPLETE",
            ImportStatus::Failed => "FAILED",
            ImportStatus::InProgress => "IN_PROGRESS",
            ImportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for ImportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MergeStrategy {
    #[allow(missing_docs)] // documentation missing in model
    FailOnConflict,
    #[allow(missing_docs)] // documentation missing in model
    OverwriteLatest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MergeStrategy {
    fn from(s: &str) -> Self {
        match s {
            "FAIL_ON_CONFLICT" => MergeStrategy::FailOnConflict,
            "OVERWRITE_LATEST" => MergeStrategy::OverwriteLatest,
            other => MergeStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MergeStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MergeStrategy::from(s))
    }
}
impl MergeStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MergeStrategy::FailOnConflict => "FAIL_ON_CONFLICT",
            MergeStrategy::OverwriteLatest => "OVERWRITE_LATEST",
            MergeStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAIL_ON_CONFLICT", "OVERWRITE_LATEST"]
    }
}
impl AsRef<str> for MergeStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Bot,
    #[allow(missing_docs)] // documentation missing in model
    Intent,
    #[allow(missing_docs)] // documentation missing in model
    SlotType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "BOT" => ResourceType::Bot,
            "INTENT" => ResourceType::Intent,
            "SLOT_TYPE" => ResourceType::SlotType,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Bot => "BOT",
            ResourceType::Intent => "INTENT",
            ResourceType::SlotType => "SLOT_TYPE",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BOT", "INTENT", "SLOT_TYPE"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides configuration information for a slot type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeConfiguration {
    /// <p>A regular expression used to validate the value of a slot.</p>
    pub regex_configuration: std::option::Option<crate::model::SlotTypeRegexConfiguration>,
}
impl SlotTypeConfiguration {
    /// <p>A regular expression used to validate the value of a slot.</p>
    pub fn regex_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SlotTypeRegexConfiguration> {
        self.regex_configuration.as_ref()
    }
}
impl std::fmt::Debug for SlotTypeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeConfiguration");
        formatter.field("regex_configuration", &self.regex_configuration);
        formatter.finish()
    }
}
/// See [`SlotTypeConfiguration`](crate::model::SlotTypeConfiguration)
pub mod slot_type_configuration {
    /// A builder for [`SlotTypeConfiguration`](crate::model::SlotTypeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) regex_configuration:
            std::option::Option<crate::model::SlotTypeRegexConfiguration>,
    }
    impl Builder {
        /// <p>A regular expression used to validate the value of a slot.</p>
        pub fn regex_configuration(
            mut self,
            input: crate::model::SlotTypeRegexConfiguration,
        ) -> Self {
            self.regex_configuration = Some(input);
            self
        }
        /// <p>A regular expression used to validate the value of a slot.</p>
        pub fn set_regex_configuration(
            mut self,
            input: std::option::Option<crate::model::SlotTypeRegexConfiguration>,
        ) -> Self {
            self.regex_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeConfiguration`](crate::model::SlotTypeConfiguration)
        pub fn build(self) -> crate::model::SlotTypeConfiguration {
            crate::model::SlotTypeConfiguration {
                regex_configuration: self.regex_configuration,
            }
        }
    }
}
impl SlotTypeConfiguration {
    /// Creates a new builder-style object to manufacture [`SlotTypeConfiguration`](crate::model::SlotTypeConfiguration)
    pub fn builder() -> crate::model::slot_type_configuration::Builder {
        crate::model::slot_type_configuration::Builder::default()
    }
}

/// <p>Provides a regular expression used to validate the value of a
/// slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeRegexConfiguration {
    /// <p>A regular expression used to validate the value of a slot. </p>
    /// <p>Use a standard regular expression. Amazon Lex supports the following
    /// characters in the regular expression:</p>
    /// <ul>
    /// <li>
    /// <p>A-Z, a-z</p>
    /// </li>
    /// <li>
    /// <p>0-9</p>
    /// </li>
    /// <li>
    /// <p>Unicode characters ("\ u<Unicode>")</p>
    /// </li>
    /// </ul>
    /// <p>Represent Unicode characters with four digits, for example
    /// "\u0041" or "\u005A".</p>
    /// <p>The following regular expression operators are not supported:</p>
    /// <ul>
    /// <li>
    /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
    /// </li>
    /// <li>
    /// <p>Wild card (.)</p>
    /// </li>
    /// </ul>
    pub pattern: std::option::Option<std::string::String>,
}
impl SlotTypeRegexConfiguration {
    /// <p>A regular expression used to validate the value of a slot. </p>
    /// <p>Use a standard regular expression. Amazon Lex supports the following
    /// characters in the regular expression:</p>
    /// <ul>
    /// <li>
    /// <p>A-Z, a-z</p>
    /// </li>
    /// <li>
    /// <p>0-9</p>
    /// </li>
    /// <li>
    /// <p>Unicode characters ("\ u<Unicode>")</p>
    /// </li>
    /// </ul>
    /// <p>Represent Unicode characters with four digits, for example
    /// "\u0041" or "\u005A".</p>
    /// <p>The following regular expression operators are not supported:</p>
    /// <ul>
    /// <li>
    /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
    /// </li>
    /// <li>
    /// <p>Wild card (.)</p>
    /// </li>
    /// </ul>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
}
impl std::fmt::Debug for SlotTypeRegexConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeRegexConfiguration");
        formatter.field("pattern", &self.pattern);
        formatter.finish()
    }
}
/// See [`SlotTypeRegexConfiguration`](crate::model::SlotTypeRegexConfiguration)
pub mod slot_type_regex_configuration {
    /// A builder for [`SlotTypeRegexConfiguration`](crate::model::SlotTypeRegexConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pattern: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A regular expression used to validate the value of a slot. </p>
        /// <p>Use a standard regular expression. Amazon Lex supports the following
        /// characters in the regular expression:</p>
        /// <ul>
        /// <li>
        /// <p>A-Z, a-z</p>
        /// </li>
        /// <li>
        /// <p>0-9</p>
        /// </li>
        /// <li>
        /// <p>Unicode characters ("\ u<Unicode>")</p>
        /// </li>
        /// </ul>
        /// <p>Represent Unicode characters with four digits, for example
        /// "\u0041" or "\u005A".</p>
        /// <p>The following regular expression operators are not supported:</p>
        /// <ul>
        /// <li>
        /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
        /// </li>
        /// <li>
        /// <p>Wild card (.)</p>
        /// </li>
        /// </ul>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p>A regular expression used to validate the value of a slot. </p>
        /// <p>Use a standard regular expression. Amazon Lex supports the following
        /// characters in the regular expression:</p>
        /// <ul>
        /// <li>
        /// <p>A-Z, a-z</p>
        /// </li>
        /// <li>
        /// <p>0-9</p>
        /// </li>
        /// <li>
        /// <p>Unicode characters ("\ u<Unicode>")</p>
        /// </li>
        /// </ul>
        /// <p>Represent Unicode characters with four digits, for example
        /// "\u0041" or "\u005A".</p>
        /// <p>The following regular expression operators are not supported:</p>
        /// <ul>
        /// <li>
        /// <p>Infinite repeaters: *, +, or {x,} with no upper bound.</p>
        /// </li>
        /// <li>
        /// <p>Wild card (.)</p>
        /// </li>
        /// </ul>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeRegexConfiguration`](crate::model::SlotTypeRegexConfiguration)
        pub fn build(self) -> crate::model::SlotTypeRegexConfiguration {
            crate::model::SlotTypeRegexConfiguration {
                pattern: self.pattern,
            }
        }
    }
}
impl SlotTypeRegexConfiguration {
    /// Creates a new builder-style object to manufacture [`SlotTypeRegexConfiguration`](crate::model::SlotTypeRegexConfiguration)
    pub fn builder() -> crate::model::slot_type_regex_configuration::Builder {
        crate::model::slot_type_regex_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotValueSelectionStrategy {
    #[allow(missing_docs)] // documentation missing in model
    OriginalValue,
    #[allow(missing_docs)] // documentation missing in model
    TopResolution,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotValueSelectionStrategy {
    fn from(s: &str) -> Self {
        match s {
            "ORIGINAL_VALUE" => SlotValueSelectionStrategy::OriginalValue,
            "TOP_RESOLUTION" => SlotValueSelectionStrategy::TopResolution,
            other => SlotValueSelectionStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotValueSelectionStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotValueSelectionStrategy::from(s))
    }
}
impl SlotValueSelectionStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotValueSelectionStrategy::OriginalValue => "ORIGINAL_VALUE",
            SlotValueSelectionStrategy::TopResolution => "TOP_RESOLUTION",
            SlotValueSelectionStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ORIGINAL_VALUE", "TOP_RESOLUTION"]
    }
}
impl AsRef<str> for SlotValueSelectionStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Each slot type can have a set of values. Each enumeration value
/// represents a value the slot type can take. </p>
/// <p>For example, a pizza ordering bot could have a slot type that
/// specifies the type of crust that the pizza should have. The slot type
/// could include the values </p>
/// <ul>
/// <li>
/// <p>thick</p>
/// </li>
/// <li>
/// <p>thin</p>
/// </li>
/// <li>
/// <p>stuffed</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnumerationValue {
    /// <p>The value of the slot type.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Additional values related to the slot type value.</p>
    pub synonyms: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EnumerationValue {
    /// <p>The value of the slot type.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Additional values related to the slot type value.</p>
    pub fn synonyms(&self) -> std::option::Option<&[std::string::String]> {
        self.synonyms.as_deref()
    }
}
impl std::fmt::Debug for EnumerationValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnumerationValue");
        formatter.field("value", &self.value);
        formatter.field("synonyms", &self.synonyms);
        formatter.finish()
    }
}
/// See [`EnumerationValue`](crate::model::EnumerationValue)
pub mod enumeration_value {
    /// A builder for [`EnumerationValue`](crate::model::EnumerationValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) synonyms: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The value of the slot type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the slot type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Appends an item to `synonyms`.
        ///
        /// To override the contents of this collection use [`set_synonyms`](Self::set_synonyms).
        ///
        /// <p>Additional values related to the slot type value.</p>
        pub fn synonyms(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.synonyms.unwrap_or_default();
            v.push(input.into());
            self.synonyms = Some(v);
            self
        }
        /// <p>Additional values related to the slot type value.</p>
        pub fn set_synonyms(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.synonyms = input;
            self
        }
        /// Consumes the builder and constructs a [`EnumerationValue`](crate::model::EnumerationValue)
        pub fn build(self) -> crate::model::EnumerationValue {
            crate::model::EnumerationValue {
                value: self.value,
                synonyms: self.synonyms,
            }
        }
    }
}
impl EnumerationValue {
    /// Creates a new builder-style object to manufacture [`EnumerationValue`](crate::model::EnumerationValue)
    pub fn builder() -> crate::model::enumeration_value::Builder {
        crate::model::enumeration_value::Builder::default()
    }
}

/// <p>The specification of an output context that is set when an intent is
/// fulfilled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputContext {
    /// <p>The name of the context.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The number of seconds that the context should be active after it is
    /// first sent in a <code>PostContent</code> or <code>PostText</code>
    /// response. You can set the value between 5 and 86,400 seconds (24
    /// hours).</p>
    pub time_to_live_in_seconds: std::option::Option<i32>,
    /// <p>The number of conversation turns that the context should be active. A
    /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
    /// request and the corresponding response from Amazon Lex.</p>
    pub turns_to_live: std::option::Option<i32>,
}
impl OutputContext {
    /// <p>The name of the context.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The number of seconds that the context should be active after it is
    /// first sent in a <code>PostContent</code> or <code>PostText</code>
    /// response. You can set the value between 5 and 86,400 seconds (24
    /// hours).</p>
    pub fn time_to_live_in_seconds(&self) -> std::option::Option<i32> {
        self.time_to_live_in_seconds
    }
    /// <p>The number of conversation turns that the context should be active. A
    /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
    /// request and the corresponding response from Amazon Lex.</p>
    pub fn turns_to_live(&self) -> std::option::Option<i32> {
        self.turns_to_live
    }
}
impl std::fmt::Debug for OutputContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputContext");
        formatter.field("name", &self.name);
        formatter.field("time_to_live_in_seconds", &self.time_to_live_in_seconds);
        formatter.field("turns_to_live", &self.turns_to_live);
        formatter.finish()
    }
}
/// See [`OutputContext`](crate::model::OutputContext)
pub mod output_context {
    /// A builder for [`OutputContext`](crate::model::OutputContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) time_to_live_in_seconds: std::option::Option<i32>,
        pub(crate) turns_to_live: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The number of seconds that the context should be active after it is
        /// first sent in a <code>PostContent</code> or <code>PostText</code>
        /// response. You can set the value between 5 and 86,400 seconds (24
        /// hours).</p>
        pub fn time_to_live_in_seconds(mut self, input: i32) -> Self {
            self.time_to_live_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds that the context should be active after it is
        /// first sent in a <code>PostContent</code> or <code>PostText</code>
        /// response. You can set the value between 5 and 86,400 seconds (24
        /// hours).</p>
        pub fn set_time_to_live_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.time_to_live_in_seconds = input;
            self
        }
        /// <p>The number of conversation turns that the context should be active. A
        /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
        /// request and the corresponding response from Amazon Lex.</p>
        pub fn turns_to_live(mut self, input: i32) -> Self {
            self.turns_to_live = Some(input);
            self
        }
        /// <p>The number of conversation turns that the context should be active. A
        /// conversation turn is one <code>PostContent</code> or <code>PostText</code>
        /// request and the corresponding response from Amazon Lex.</p>
        pub fn set_turns_to_live(mut self, input: std::option::Option<i32>) -> Self {
            self.turns_to_live = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputContext`](crate::model::OutputContext)
        pub fn build(self) -> crate::model::OutputContext {
            crate::model::OutputContext {
                name: self.name,
                time_to_live_in_seconds: self.time_to_live_in_seconds,
                turns_to_live: self.turns_to_live,
            }
        }
    }
}
impl OutputContext {
    /// Creates a new builder-style object to manufacture [`OutputContext`](crate::model::OutputContext)
    pub fn builder() -> crate::model::output_context::Builder {
        crate::model::output_context::Builder::default()
    }
}

/// <p>The name of a context that must be active for an intent to be selected
/// by Amazon Lex.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputContext {
    /// <p>The name of the context.</p>
    pub name: std::option::Option<std::string::String>,
}
impl InputContext {
    /// <p>The name of the context.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for InputContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputContext");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InputContext`](crate::model::InputContext)
pub mod input_context {
    /// A builder for [`InputContext`](crate::model::InputContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the context.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the context.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InputContext`](crate::model::InputContext)
        pub fn build(self) -> crate::model::InputContext {
            crate::model::InputContext { name: self.name }
        }
    }
}
impl InputContext {
    /// Creates a new builder-style object to manufacture [`InputContext`](crate::model::InputContext)
    pub fn builder() -> crate::model::input_context::Builder {
        crate::model::input_context::Builder::default()
    }
}

/// <p>Provides configuration information for the AMAZON.KendraSearchIntent
/// intent. When you use this intent, Amazon Lex searches the specified Amazon
/// Kendra index and returns documents from the index that match the user's
/// utterance. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
/// AMAZON.KendraSearchIntent</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KendraConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you
    /// want the AMAZON.KendraSearchIntent intent to search. The index must be in
    /// the same account and Region as the Amazon Lex bot. If the Amazon Kendra index
    /// does not exist, you get an exception when you call the
    /// <code>PutIntent</code> operation.</p>
    pub kendra_index: std::option::Option<std::string::String>,
    /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the
    /// response from the query. The filter is in the format defined by Amazon
    /// Kendra. For more information, see <a href="http://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
    /// queries</a>.</p>
    /// <p>You can override this filter string with a new filter string at
    /// runtime.</p>
    pub query_filter_string: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
    /// search the Amazon Kendra index. The role must be in the same account and
    /// Region as the Amazon Lex bot. If the role does not exist, you get an exception
    /// when you call the <code>PutIntent</code> operation.</p>
    pub role: std::option::Option<std::string::String>,
}
impl KendraConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you
    /// want the AMAZON.KendraSearchIntent intent to search. The index must be in
    /// the same account and Region as the Amazon Lex bot. If the Amazon Kendra index
    /// does not exist, you get an exception when you call the
    /// <code>PutIntent</code> operation.</p>
    pub fn kendra_index(&self) -> std::option::Option<&str> {
        self.kendra_index.as_deref()
    }
    /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the
    /// response from the query. The filter is in the format defined by Amazon
    /// Kendra. For more information, see <a href="http://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
    /// queries</a>.</p>
    /// <p>You can override this filter string with a new filter string at
    /// runtime.</p>
    pub fn query_filter_string(&self) -> std::option::Option<&str> {
        self.query_filter_string.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
    /// search the Amazon Kendra index. The role must be in the same account and
    /// Region as the Amazon Lex bot. If the role does not exist, you get an exception
    /// when you call the <code>PutIntent</code> operation.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
}
impl std::fmt::Debug for KendraConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KendraConfiguration");
        formatter.field("kendra_index", &self.kendra_index);
        formatter.field("query_filter_string", &self.query_filter_string);
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`KendraConfiguration`](crate::model::KendraConfiguration)
pub mod kendra_configuration {
    /// A builder for [`KendraConfiguration`](crate::model::KendraConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kendra_index: std::option::Option<std::string::String>,
        pub(crate) query_filter_string: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you
        /// want the AMAZON.KendraSearchIntent intent to search. The index must be in
        /// the same account and Region as the Amazon Lex bot. If the Amazon Kendra index
        /// does not exist, you get an exception when you call the
        /// <code>PutIntent</code> operation.</p>
        pub fn kendra_index(mut self, input: impl Into<std::string::String>) -> Self {
            self.kendra_index = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Kendra index that you
        /// want the AMAZON.KendraSearchIntent intent to search. The index must be in
        /// the same account and Region as the Amazon Lex bot. If the Amazon Kendra index
        /// does not exist, you get an exception when you call the
        /// <code>PutIntent</code> operation.</p>
        pub fn set_kendra_index(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kendra_index = input;
            self
        }
        /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the
        /// response from the query. The filter is in the format defined by Amazon
        /// Kendra. For more information, see <a href="http://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
        /// queries</a>.</p>
        /// <p>You can override this filter string with a new filter string at
        /// runtime.</p>
        pub fn query_filter_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_filter_string = Some(input.into());
            self
        }
        /// <p>A query filter that Amazon Lex sends to Amazon Kendra to filter the
        /// response from the query. The filter is in the format defined by Amazon
        /// Kendra. For more information, see <a href="http://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering
        /// queries</a>.</p>
        /// <p>You can override this filter string with a new filter string at
        /// runtime.</p>
        pub fn set_query_filter_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_filter_string = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
        /// search the Amazon Kendra index. The role must be in the same account and
        /// Region as the Amazon Lex bot. If the role does not exist, you get an exception
        /// when you call the <code>PutIntent</code> operation.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that has permission to
        /// search the Amazon Kendra index. The role must be in the same account and
        /// Region as the Amazon Lex bot. If the role does not exist, you get an exception
        /// when you call the <code>PutIntent</code> operation.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`KendraConfiguration`](crate::model::KendraConfiguration)
        pub fn build(self) -> crate::model::KendraConfiguration {
            crate::model::KendraConfiguration {
                kendra_index: self.kendra_index,
                query_filter_string: self.query_filter_string,
                role: self.role,
            }
        }
    }
}
impl KendraConfiguration {
    /// Creates a new builder-style object to manufacture [`KendraConfiguration`](crate::model::KendraConfiguration)
    pub fn builder() -> crate::model::kendra_configuration::Builder {
        crate::model::kendra_configuration::Builder::default()
    }
}

/// <p> Describes how the intent is fulfilled after the user provides all
/// of the information required for the intent. You can provide a Lambda
/// function to process the intent, or you can return the intent information
/// to the client application. We recommend that you use a Lambda function so
/// that the relevant logic lives in the Cloud and limit the client-side code
/// primarily to presentation. If you need to update the logic, you only
/// update the Lambda function; you don't need to upgrade your client
/// application. </p>
///
///
/// <p>Consider the following examples:</p>
/// <ul>
/// <li>
/// <p>In a pizza ordering application, after the user provides all of
/// the information for placing an order, you use a Lambda function to
/// place an order with a pizzeria. </p>
/// </li>
/// <li>
/// <p>In a gaming application, when a user says "pick up a rock,"
/// this information must go back to the client application so that it can
/// perform the operation and update the graphics. In this case, you want
/// Amazon Lex to return the intent data to the client. </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FulfillmentActivity {
    /// <p> How the intent should be fulfilled, either by running a Lambda
    /// function or by returning the slot data to the client application.
    /// </p>
    pub r#type: std::option::Option<crate::model::FulfillmentActivityType>,
    /// <p> A description of the Lambda function that is run to fulfill the
    /// intent. </p>
    pub code_hook: std::option::Option<crate::model::CodeHook>,
}
impl FulfillmentActivity {
    /// <p> How the intent should be fulfilled, either by running a Lambda
    /// function or by returning the slot data to the client application.
    /// </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FulfillmentActivityType> {
        self.r#type.as_ref()
    }
    /// <p> A description of the Lambda function that is run to fulfill the
    /// intent. </p>
    pub fn code_hook(&self) -> std::option::Option<&crate::model::CodeHook> {
        self.code_hook.as_ref()
    }
}
impl std::fmt::Debug for FulfillmentActivity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FulfillmentActivity");
        formatter.field("r#type", &self.r#type);
        formatter.field("code_hook", &self.code_hook);
        formatter.finish()
    }
}
/// See [`FulfillmentActivity`](crate::model::FulfillmentActivity)
pub mod fulfillment_activity {
    /// A builder for [`FulfillmentActivity`](crate::model::FulfillmentActivity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FulfillmentActivityType>,
        pub(crate) code_hook: std::option::Option<crate::model::CodeHook>,
    }
    impl Builder {
        /// <p> How the intent should be fulfilled, either by running a Lambda
        /// function or by returning the slot data to the client application.
        /// </p>
        pub fn r#type(mut self, input: crate::model::FulfillmentActivityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> How the intent should be fulfilled, either by running a Lambda
        /// function or by returning the slot data to the client application.
        /// </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivityType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> A description of the Lambda function that is run to fulfill the
        /// intent. </p>
        pub fn code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.code_hook = Some(input);
            self
        }
        /// <p> A description of the Lambda function that is run to fulfill the
        /// intent. </p>
        pub fn set_code_hook(mut self, input: std::option::Option<crate::model::CodeHook>) -> Self {
            self.code_hook = input;
            self
        }
        /// Consumes the builder and constructs a [`FulfillmentActivity`](crate::model::FulfillmentActivity)
        pub fn build(self) -> crate::model::FulfillmentActivity {
            crate::model::FulfillmentActivity {
                r#type: self.r#type,
                code_hook: self.code_hook,
            }
        }
    }
}
impl FulfillmentActivity {
    /// Creates a new builder-style object to manufacture [`FulfillmentActivity`](crate::model::FulfillmentActivity)
    pub fn builder() -> crate::model::fulfillment_activity::Builder {
        crate::model::fulfillment_activity::Builder::default()
    }
}

/// <p>Specifies a Lambda function that verifies requests to a bot or
/// fulfills the user's request to a bot..</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeHook {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The version of the request-response that you want Amazon Lex to use to
    /// invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>
    pub message_version: std::option::Option<std::string::String>,
}
impl CodeHook {
    /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The version of the request-response that you want Amazon Lex to use to
    /// invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>
    pub fn message_version(&self) -> std::option::Option<&str> {
        self.message_version.as_deref()
    }
}
impl std::fmt::Debug for CodeHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeHook");
        formatter.field("uri", &self.uri);
        formatter.field("message_version", &self.message_version);
        formatter.finish()
    }
}
/// See [`CodeHook`](crate::model::CodeHook)
pub mod code_hook {
    /// A builder for [`CodeHook`](crate::model::CodeHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) message_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The version of the request-response that you want Amazon Lex to use to
        /// invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>
        pub fn message_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_version = Some(input.into());
            self
        }
        /// <p>The version of the request-response that you want Amazon Lex to use to
        /// invoke your Lambda function. For more information, see <a>using-lambda</a>.</p>
        pub fn set_message_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeHook`](crate::model::CodeHook)
        pub fn build(self) -> crate::model::CodeHook {
            crate::model::CodeHook {
                uri: self.uri,
                message_version: self.message_version,
            }
        }
    }
}
impl CodeHook {
    /// Creates a new builder-style object to manufacture [`CodeHook`](crate::model::CodeHook)
    pub fn builder() -> crate::model::code_hook::Builder {
        crate::model::code_hook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FulfillmentActivityType {
    #[allow(missing_docs)] // documentation missing in model
    CodeHook,
    #[allow(missing_docs)] // documentation missing in model
    ReturnIntent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FulfillmentActivityType {
    fn from(s: &str) -> Self {
        match s {
            "CodeHook" => FulfillmentActivityType::CodeHook,
            "ReturnIntent" => FulfillmentActivityType::ReturnIntent,
            other => FulfillmentActivityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FulfillmentActivityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FulfillmentActivityType::from(s))
    }
}
impl FulfillmentActivityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FulfillmentActivityType::CodeHook => "CodeHook",
            FulfillmentActivityType::ReturnIntent => "ReturnIntent",
            FulfillmentActivityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CodeHook", "ReturnIntent"]
    }
}
impl AsRef<str> for FulfillmentActivityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A collection of messages that convey information to the user. At
/// runtime, Amazon Lex selects the message to convey. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Statement {
    /// <p>A collection of message objects.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    /// <p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response.
    /// It substitutes all of the session attributes and slot values for
    /// placeholders in the response card. </p>
    pub response_card: std::option::Option<std::string::String>,
}
impl Statement {
    /// <p>A collection of message objects.</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
    /// <p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response.
    /// It substitutes all of the session attributes and slot values for
    /// placeholders in the response card. </p>
    pub fn response_card(&self) -> std::option::Option<&str> {
        self.response_card.as_deref()
    }
}
impl std::fmt::Debug for Statement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Statement");
        formatter.field("messages", &self.messages);
        formatter.field("response_card", &self.response_card);
        formatter.finish()
    }
}
/// See [`Statement`](crate::model::Statement)
pub mod statement {
    /// A builder for [`Statement`](crate::model::Statement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
        pub(crate) response_card: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A collection of message objects.</p>
        pub fn messages(mut self, input: impl Into<crate::model::Message>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>A collection of message objects.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response.
        /// It substitutes all of the session attributes and slot values for
        /// placeholders in the response card. </p>
        pub fn response_card(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_card = Some(input.into());
            self
        }
        /// <p> At runtime, if the client is using the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> API, Amazon Lex includes the response card in the response.
        /// It substitutes all of the session attributes and slot values for
        /// placeholders in the response card. </p>
        pub fn set_response_card(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_card = input;
            self
        }
        /// Consumes the builder and constructs a [`Statement`](crate::model::Statement)
        pub fn build(self) -> crate::model::Statement {
            crate::model::Statement {
                messages: self.messages,
                response_card: self.response_card,
            }
        }
    }
}
impl Statement {
    /// Creates a new builder-style object to manufacture [`Statement`](crate::model::Statement)
    pub fn builder() -> crate::model::statement::Builder {
        crate::model::statement::Builder::default()
    }
}

/// <p>The message object that provides the message text and its
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Message {
    /// <p>The content type of the message string.</p>
    pub content_type: std::option::Option<crate::model::ContentType>,
    /// <p>The text of the message.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>Identifies the message group that the message belongs to. When a group
    /// is assigned to a message, Amazon Lex returns one message from each group in the
    /// response.</p>
    pub group_number: std::option::Option<i32>,
}
impl Message {
    /// <p>The content type of the message string.</p>
    pub fn content_type(&self) -> std::option::Option<&crate::model::ContentType> {
        self.content_type.as_ref()
    }
    /// <p>The text of the message.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>Identifies the message group that the message belongs to. When a group
    /// is assigned to a message, Amazon Lex returns one message from each group in the
    /// response.</p>
    pub fn group_number(&self) -> std::option::Option<i32> {
        self.group_number
    }
}
impl std::fmt::Debug for Message {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Message");
        formatter.field("content_type", &self.content_type);
        formatter.field("content", &self.content);
        formatter.field("group_number", &self.group_number);
        formatter.finish()
    }
}
/// See [`Message`](crate::model::Message)
pub mod message {
    /// A builder for [`Message`](crate::model::Message)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content_type: std::option::Option<crate::model::ContentType>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) group_number: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The content type of the message string.</p>
        pub fn content_type(mut self, input: crate::model::ContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The content type of the message string.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::ContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// <p>The text of the message.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The text of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>Identifies the message group that the message belongs to. When a group
        /// is assigned to a message, Amazon Lex returns one message from each group in the
        /// response.</p>
        pub fn group_number(mut self, input: i32) -> Self {
            self.group_number = Some(input);
            self
        }
        /// <p>Identifies the message group that the message belongs to. When a group
        /// is assigned to a message, Amazon Lex returns one message from each group in the
        /// response.</p>
        pub fn set_group_number(mut self, input: std::option::Option<i32>) -> Self {
            self.group_number = input;
            self
        }
        /// Consumes the builder and constructs a [`Message`](crate::model::Message)
        pub fn build(self) -> crate::model::Message {
            crate::model::Message {
                content_type: self.content_type,
                content: self.content,
                group_number: self.group_number,
            }
        }
    }
}
impl Message {
    /// Creates a new builder-style object to manufacture [`Message`](crate::model::Message)
    pub fn builder() -> crate::model::message::Builder {
        crate::model::message::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContentType {
    #[allow(missing_docs)] // documentation missing in model
    CustomPayload,
    #[allow(missing_docs)] // documentation missing in model
    PlainText,
    #[allow(missing_docs)] // documentation missing in model
    Ssml,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContentType {
    fn from(s: &str) -> Self {
        match s {
            "CustomPayload" => ContentType::CustomPayload,
            "PlainText" => ContentType::PlainText,
            "SSML" => ContentType::Ssml,
            other => ContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContentType::from(s))
    }
}
impl ContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContentType::CustomPayload => "CustomPayload",
            ContentType::PlainText => "PlainText",
            ContentType::Ssml => "SSML",
            ContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CustomPayload", "PlainText", "SSML"]
    }
}
impl AsRef<str> for ContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A prompt for additional activity after an intent is fulfilled. For
/// example, after the <code>OrderPizza</code> intent is fulfilled, you might
/// prompt the user to find out whether the user wants to order
/// drinks.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FollowUpPrompt {
    /// <p>Prompts for information from the user. </p>
    pub prompt: std::option::Option<crate::model::Prompt>,
    /// <p>If the user answers "no" to the question defined in the
    /// <code>prompt</code> field, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub rejection_statement: std::option::Option<crate::model::Statement>,
}
impl FollowUpPrompt {
    /// <p>Prompts for information from the user. </p>
    pub fn prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.prompt.as_ref()
    }
    /// <p>If the user answers "no" to the question defined in the
    /// <code>prompt</code> field, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub fn rejection_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.rejection_statement.as_ref()
    }
}
impl std::fmt::Debug for FollowUpPrompt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FollowUpPrompt");
        formatter.field("prompt", &self.prompt);
        formatter.field("rejection_statement", &self.rejection_statement);
        formatter.finish()
    }
}
/// See [`FollowUpPrompt`](crate::model::FollowUpPrompt)
pub mod follow_up_prompt {
    /// A builder for [`FollowUpPrompt`](crate::model::FollowUpPrompt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) rejection_statement: std::option::Option<crate::model::Statement>,
    }
    impl Builder {
        /// <p>Prompts for information from the user. </p>
        pub fn prompt(mut self, input: crate::model::Prompt) -> Self {
            self.prompt = Some(input);
            self
        }
        /// <p>Prompts for information from the user. </p>
        pub fn set_prompt(mut self, input: std::option::Option<crate::model::Prompt>) -> Self {
            self.prompt = input;
            self
        }
        /// <p>If the user answers "no" to the question defined in the
        /// <code>prompt</code> field, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.rejection_statement = Some(input);
            self
        }
        /// <p>If the user answers "no" to the question defined in the
        /// <code>prompt</code> field, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.rejection_statement = input;
            self
        }
        /// Consumes the builder and constructs a [`FollowUpPrompt`](crate::model::FollowUpPrompt)
        pub fn build(self) -> crate::model::FollowUpPrompt {
            crate::model::FollowUpPrompt {
                prompt: self.prompt,
                rejection_statement: self.rejection_statement,
            }
        }
    }
}
impl FollowUpPrompt {
    /// Creates a new builder-style object to manufacture [`FollowUpPrompt`](crate::model::FollowUpPrompt)
    pub fn builder() -> crate::model::follow_up_prompt::Builder {
        crate::model::follow_up_prompt::Builder::default()
    }
}

/// <p>Obtains information from the user. To define a prompt, provide one
/// or more messages and specify the number of attempts to get information
/// from the user. If you provide more than one message, Amazon Lex chooses one of
/// the messages to use to prompt the user. For more information, see <a>how-it-works</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Prompt {
    /// <p>An array of objects, each of which provides a message string and
    /// its type. You can specify the message string in plain text or in Speech
    /// Synthesis Markup Language (SSML).</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
    /// <p>The number of times to prompt the user for information.</p>
    pub max_attempts: std::option::Option<i32>,
    /// <p>A response card. Amazon Lex uses this prompt at runtime, in the
    /// <code>PostText</code> API response. It substitutes session attributes
    /// and slot values for placeholders in the response card. For more
    /// information, see <a>ex-resp-card</a>. </p>
    pub response_card: std::option::Option<std::string::String>,
}
impl Prompt {
    /// <p>An array of objects, each of which provides a message string and
    /// its type. You can specify the message string in plain text or in Speech
    /// Synthesis Markup Language (SSML).</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::Message]> {
        self.messages.as_deref()
    }
    /// <p>The number of times to prompt the user for information.</p>
    pub fn max_attempts(&self) -> std::option::Option<i32> {
        self.max_attempts
    }
    /// <p>A response card. Amazon Lex uses this prompt at runtime, in the
    /// <code>PostText</code> API response. It substitutes session attributes
    /// and slot values for placeholders in the response card. For more
    /// information, see <a>ex-resp-card</a>. </p>
    pub fn response_card(&self) -> std::option::Option<&str> {
        self.response_card.as_deref()
    }
}
impl std::fmt::Debug for Prompt {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Prompt");
        formatter.field("messages", &self.messages);
        formatter.field("max_attempts", &self.max_attempts);
        formatter.field("response_card", &self.response_card);
        formatter.finish()
    }
}
/// See [`Prompt`](crate::model::Prompt)
pub mod prompt {
    /// A builder for [`Prompt`](crate::model::Prompt)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::Message>>,
        pub(crate) max_attempts: std::option::Option<i32>,
        pub(crate) response_card: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>An array of objects, each of which provides a message string and
        /// its type. You can specify the message string in plain text or in Speech
        /// Synthesis Markup Language (SSML).</p>
        pub fn messages(mut self, input: impl Into<crate::model::Message>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>An array of objects, each of which provides a message string and
        /// its type. You can specify the message string in plain text or in Speech
        /// Synthesis Markup Language (SSML).</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Message>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// <p>The number of times to prompt the user for information.</p>
        pub fn max_attempts(mut self, input: i32) -> Self {
            self.max_attempts = Some(input);
            self
        }
        /// <p>The number of times to prompt the user for information.</p>
        pub fn set_max_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_attempts = input;
            self
        }
        /// <p>A response card. Amazon Lex uses this prompt at runtime, in the
        /// <code>PostText</code> API response. It substitutes session attributes
        /// and slot values for placeholders in the response card. For more
        /// information, see <a>ex-resp-card</a>. </p>
        pub fn response_card(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_card = Some(input.into());
            self
        }
        /// <p>A response card. Amazon Lex uses this prompt at runtime, in the
        /// <code>PostText</code> API response. It substitutes session attributes
        /// and slot values for placeholders in the response card. For more
        /// information, see <a>ex-resp-card</a>. </p>
        pub fn set_response_card(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_card = input;
            self
        }
        /// Consumes the builder and constructs a [`Prompt`](crate::model::Prompt)
        pub fn build(self) -> crate::model::Prompt {
            crate::model::Prompt {
                messages: self.messages,
                max_attempts: self.max_attempts,
                response_card: self.response_card,
            }
        }
    }
}
impl Prompt {
    /// Creates a new builder-style object to manufacture [`Prompt`](crate::model::Prompt)
    pub fn builder() -> crate::model::prompt::Builder {
        crate::model::prompt::Builder::default()
    }
}

/// <p>Identifies the version of a specific slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Slot {
    /// <p>The name of the slot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether the slot is required or optional. </p>
    pub slot_constraint: std::option::Option<crate::model::SlotConstraint>,
    /// <p>The type of the slot, either a custom slot type that you defined or
    /// one of the built-in slot types.</p>
    pub slot_type: std::option::Option<std::string::String>,
    /// <p>The version of the slot type.</p>
    pub slot_type_version: std::option::Option<std::string::String>,
    /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
    /// user.</p>
    pub value_elicitation_prompt: std::option::Option<crate::model::Prompt>,
    /// <p> Directs Amazon Lex the order in which to elicit this slot value from
    /// the user. For example, if the intent has two slots with priorities 1 and
    /// 2, AWS Amazon Lex first elicits a value for the slot with priority 1.</p>
    /// <p>If multiple slots share the same priority, the order in which Amazon Lex
    /// elicits values is arbitrary.</p>
    pub priority: std::option::Option<i32>,
    /// <p> If you know a specific pattern with which users might respond to
    /// an Amazon Lex request for a slot value, you can provide those utterances to
    /// improve accuracy. This is optional. In most cases, Amazon Lex is capable of
    /// understanding user utterances. </p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A set of possible responses for the slot type used by text-based
    /// clients. A user chooses an option from the response card, instead of using
    /// text to reply. </p>
    pub response_card: std::option::Option<std::string::String>,
    /// <p>Determines whether a slot is obfuscated in conversation logs and
    /// stored utterances. When you obfuscate a slot, the value is replaced by the
    /// slot name in curly braces ({}). For example, if the slot name is
    /// "full_name", obfuscated values are replaced with "{full_name}". For more
    /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html"> Slot Obfuscation </a>.
    /// </p>
    pub obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
    /// <p>A list of default values for the slot. Default values are used when
    /// Amazon Lex hasn't determined a value for a slot. You can specify default values
    /// from context variables, session attributes, and defined values.</p>
    pub default_value_spec: std::option::Option<crate::model::SlotDefaultValueSpec>,
}
impl Slot {
    /// <p>The name of the slot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether the slot is required or optional. </p>
    pub fn slot_constraint(&self) -> std::option::Option<&crate::model::SlotConstraint> {
        self.slot_constraint.as_ref()
    }
    /// <p>The type of the slot, either a custom slot type that you defined or
    /// one of the built-in slot types.</p>
    pub fn slot_type(&self) -> std::option::Option<&str> {
        self.slot_type.as_deref()
    }
    /// <p>The version of the slot type.</p>
    pub fn slot_type_version(&self) -> std::option::Option<&str> {
        self.slot_type_version.as_deref()
    }
    /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
    /// user.</p>
    pub fn value_elicitation_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.value_elicitation_prompt.as_ref()
    }
    /// <p> Directs Amazon Lex the order in which to elicit this slot value from
    /// the user. For example, if the intent has two slots with priorities 1 and
    /// 2, AWS Amazon Lex first elicits a value for the slot with priority 1.</p>
    /// <p>If multiple slots share the same priority, the order in which Amazon Lex
    /// elicits values is arbitrary.</p>
    pub fn priority(&self) -> std::option::Option<i32> {
        self.priority
    }
    /// <p> If you know a specific pattern with which users might respond to
    /// an Amazon Lex request for a slot value, you can provide those utterances to
    /// improve accuracy. This is optional. In most cases, Amazon Lex is capable of
    /// understanding user utterances. </p>
    pub fn sample_utterances(&self) -> std::option::Option<&[std::string::String]> {
        self.sample_utterances.as_deref()
    }
    /// <p> A set of possible responses for the slot type used by text-based
    /// clients. A user chooses an option from the response card, instead of using
    /// text to reply. </p>
    pub fn response_card(&self) -> std::option::Option<&str> {
        self.response_card.as_deref()
    }
    /// <p>Determines whether a slot is obfuscated in conversation logs and
    /// stored utterances. When you obfuscate a slot, the value is replaced by the
    /// slot name in curly braces ({}). For example, if the slot name is
    /// "full_name", obfuscated values are replaced with "{full_name}". For more
    /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html"> Slot Obfuscation </a>.
    /// </p>
    pub fn obfuscation_setting(&self) -> std::option::Option<&crate::model::ObfuscationSetting> {
        self.obfuscation_setting.as_ref()
    }
    /// <p>A list of default values for the slot. Default values are used when
    /// Amazon Lex hasn't determined a value for a slot. You can specify default values
    /// from context variables, session attributes, and defined values.</p>
    pub fn default_value_spec(&self) -> std::option::Option<&crate::model::SlotDefaultValueSpec> {
        self.default_value_spec.as_ref()
    }
}
impl std::fmt::Debug for Slot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Slot");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("slot_constraint", &self.slot_constraint);
        formatter.field("slot_type", &self.slot_type);
        formatter.field("slot_type_version", &self.slot_type_version);
        formatter.field("value_elicitation_prompt", &self.value_elicitation_prompt);
        formatter.field("priority", &self.priority);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("response_card", &self.response_card);
        formatter.field("obfuscation_setting", &self.obfuscation_setting);
        formatter.field("default_value_spec", &self.default_value_spec);
        formatter.finish()
    }
}
/// See [`Slot`](crate::model::Slot)
pub mod slot {
    /// A builder for [`Slot`](crate::model::Slot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slot_constraint: std::option::Option<crate::model::SlotConstraint>,
        pub(crate) slot_type: std::option::Option<std::string::String>,
        pub(crate) slot_type_version: std::option::Option<std::string::String>,
        pub(crate) value_elicitation_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) priority: std::option::Option<i32>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) response_card: std::option::Option<std::string::String>,
        pub(crate) obfuscation_setting: std::option::Option<crate::model::ObfuscationSetting>,
        pub(crate) default_value_spec: std::option::Option<crate::model::SlotDefaultValueSpec>,
    }
    impl Builder {
        /// <p>The name of the slot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether the slot is required or optional. </p>
        pub fn slot_constraint(mut self, input: crate::model::SlotConstraint) -> Self {
            self.slot_constraint = Some(input);
            self
        }
        /// <p>Specifies whether the slot is required or optional. </p>
        pub fn set_slot_constraint(
            mut self,
            input: std::option::Option<crate::model::SlotConstraint>,
        ) -> Self {
            self.slot_constraint = input;
            self
        }
        /// <p>The type of the slot, either a custom slot type that you defined or
        /// one of the built-in slot types.</p>
        pub fn slot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type = Some(input.into());
            self
        }
        /// <p>The type of the slot, either a custom slot type that you defined or
        /// one of the built-in slot types.</p>
        pub fn set_slot_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_type = input;
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn slot_type_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_type_version = Some(input.into());
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn set_slot_type_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.slot_type_version = input;
            self
        }
        /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
        /// user.</p>
        pub fn value_elicitation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.value_elicitation_prompt = Some(input);
            self
        }
        /// <p>The prompt that Amazon Lex uses to elicit the slot value from the
        /// user.</p>
        pub fn set_value_elicitation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.value_elicitation_prompt = input;
            self
        }
        /// <p> Directs Amazon Lex the order in which to elicit this slot value from
        /// the user. For example, if the intent has two slots with priorities 1 and
        /// 2, AWS Amazon Lex first elicits a value for the slot with priority 1.</p>
        /// <p>If multiple slots share the same priority, the order in which Amazon Lex
        /// elicits values is arbitrary.</p>
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// <p> Directs Amazon Lex the order in which to elicit this slot value from
        /// the user. For example, if the intent has two slots with priorities 1 and
        /// 2, AWS Amazon Lex first elicits a value for the slot with priority 1.</p>
        /// <p>If multiple slots share the same priority, the order in which Amazon Lex
        /// elicits values is arbitrary.</p>
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p> If you know a specific pattern with which users might respond to
        /// an Amazon Lex request for a slot value, you can provide those utterances to
        /// improve accuracy. This is optional. In most cases, Amazon Lex is capable of
        /// understanding user utterances. </p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p> If you know a specific pattern with which users might respond to
        /// an Amazon Lex request for a slot value, you can provide those utterances to
        /// improve accuracy. This is optional. In most cases, Amazon Lex is capable of
        /// understanding user utterances. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p> A set of possible responses for the slot type used by text-based
        /// clients. A user chooses an option from the response card, instead of using
        /// text to reply. </p>
        pub fn response_card(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_card = Some(input.into());
            self
        }
        /// <p> A set of possible responses for the slot type used by text-based
        /// clients. A user chooses an option from the response card, instead of using
        /// text to reply. </p>
        pub fn set_response_card(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_card = input;
            self
        }
        /// <p>Determines whether a slot is obfuscated in conversation logs and
        /// stored utterances. When you obfuscate a slot, the value is replaced by the
        /// slot name in curly braces ({}). For example, if the slot name is
        /// "full_name", obfuscated values are replaced with "{full_name}". For more
        /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html"> Slot Obfuscation </a>.
        /// </p>
        pub fn obfuscation_setting(mut self, input: crate::model::ObfuscationSetting) -> Self {
            self.obfuscation_setting = Some(input);
            self
        }
        /// <p>Determines whether a slot is obfuscated in conversation logs and
        /// stored utterances. When you obfuscate a slot, the value is replaced by the
        /// slot name in curly braces ({}). For example, if the slot name is
        /// "full_name", obfuscated values are replaced with "{full_name}". For more
        /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/how-obfuscate.html"> Slot Obfuscation </a>.
        /// </p>
        pub fn set_obfuscation_setting(
            mut self,
            input: std::option::Option<crate::model::ObfuscationSetting>,
        ) -> Self {
            self.obfuscation_setting = input;
            self
        }
        /// <p>A list of default values for the slot. Default values are used when
        /// Amazon Lex hasn't determined a value for a slot. You can specify default values
        /// from context variables, session attributes, and defined values.</p>
        pub fn default_value_spec(mut self, input: crate::model::SlotDefaultValueSpec) -> Self {
            self.default_value_spec = Some(input);
            self
        }
        /// <p>A list of default values for the slot. Default values are used when
        /// Amazon Lex hasn't determined a value for a slot. You can specify default values
        /// from context variables, session attributes, and defined values.</p>
        pub fn set_default_value_spec(
            mut self,
            input: std::option::Option<crate::model::SlotDefaultValueSpec>,
        ) -> Self {
            self.default_value_spec = input;
            self
        }
        /// Consumes the builder and constructs a [`Slot`](crate::model::Slot)
        pub fn build(self) -> crate::model::Slot {
            crate::model::Slot {
                name: self.name,
                description: self.description,
                slot_constraint: self.slot_constraint,
                slot_type: self.slot_type,
                slot_type_version: self.slot_type_version,
                value_elicitation_prompt: self.value_elicitation_prompt,
                priority: self.priority,
                sample_utterances: self.sample_utterances,
                response_card: self.response_card,
                obfuscation_setting: self.obfuscation_setting,
                default_value_spec: self.default_value_spec,
            }
        }
    }
}
impl Slot {
    /// Creates a new builder-style object to manufacture [`Slot`](crate::model::Slot)
    pub fn builder() -> crate::model::slot::Builder {
        crate::model::slot::Builder::default()
    }
}

/// <p>Contains the default values for a slot. Default values are used when
/// Amazon Lex hasn't determined a value for a slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotDefaultValueSpec {
    /// <p>The default values for a slot. You can specify more than one default.
    /// For example, you can specify a default value to use from a matching
    /// context variable, a session attribute, or a fixed value.</p>
    /// <p>The default value chosen is selected based on the order that you
    /// specify them in the list. For example, if you specify a context variable
    /// and a fixed value in that order, Amazon Lex uses the context variable if it is
    /// available, else it uses the fixed value.</p>
    pub default_value_list: std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
}
impl SlotDefaultValueSpec {
    /// <p>The default values for a slot. You can specify more than one default.
    /// For example, you can specify a default value to use from a matching
    /// context variable, a session attribute, or a fixed value.</p>
    /// <p>The default value chosen is selected based on the order that you
    /// specify them in the list. For example, if you specify a context variable
    /// and a fixed value in that order, Amazon Lex uses the context variable if it is
    /// available, else it uses the fixed value.</p>
    pub fn default_value_list(&self) -> std::option::Option<&[crate::model::SlotDefaultValue]> {
        self.default_value_list.as_deref()
    }
}
impl std::fmt::Debug for SlotDefaultValueSpec {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotDefaultValueSpec");
        formatter.field("default_value_list", &self.default_value_list);
        formatter.finish()
    }
}
/// See [`SlotDefaultValueSpec`](crate::model::SlotDefaultValueSpec)
pub mod slot_default_value_spec {
    /// A builder for [`SlotDefaultValueSpec`](crate::model::SlotDefaultValueSpec)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value_list:
            std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
    }
    impl Builder {
        /// Appends an item to `default_value_list`.
        ///
        /// To override the contents of this collection use [`set_default_value_list`](Self::set_default_value_list).
        ///
        /// <p>The default values for a slot. You can specify more than one default.
        /// For example, you can specify a default value to use from a matching
        /// context variable, a session attribute, or a fixed value.</p>
        /// <p>The default value chosen is selected based on the order that you
        /// specify them in the list. For example, if you specify a context variable
        /// and a fixed value in that order, Amazon Lex uses the context variable if it is
        /// available, else it uses the fixed value.</p>
        pub fn default_value_list(
            mut self,
            input: impl Into<crate::model::SlotDefaultValue>,
        ) -> Self {
            let mut v = self.default_value_list.unwrap_or_default();
            v.push(input.into());
            self.default_value_list = Some(v);
            self
        }
        /// <p>The default values for a slot. You can specify more than one default.
        /// For example, you can specify a default value to use from a matching
        /// context variable, a session attribute, or a fixed value.</p>
        /// <p>The default value chosen is selected based on the order that you
        /// specify them in the list. For example, if you specify a context variable
        /// and a fixed value in that order, Amazon Lex uses the context variable if it is
        /// available, else it uses the fixed value.</p>
        pub fn set_default_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotDefaultValue>>,
        ) -> Self {
            self.default_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotDefaultValueSpec`](crate::model::SlotDefaultValueSpec)
        pub fn build(self) -> crate::model::SlotDefaultValueSpec {
            crate::model::SlotDefaultValueSpec {
                default_value_list: self.default_value_list,
            }
        }
    }
}
impl SlotDefaultValueSpec {
    /// Creates a new builder-style object to manufacture [`SlotDefaultValueSpec`](crate::model::SlotDefaultValueSpec)
    pub fn builder() -> crate::model::slot_default_value_spec::Builder {
        crate::model::slot_default_value_spec::Builder::default()
    }
}

/// <p>A default value for a slot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotDefaultValue {
    /// <p>The default value for the slot. You can specify one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#context-name.slot-name</code> - The slot value "slot-name"
    /// in the context "context-name."</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>{attribute}</code> - The slot value of the session attribute
    /// "attribute."</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>'value'</code> - The discrete value "value."</p>
    /// </li>
    /// </ul>
    pub default_value: std::option::Option<std::string::String>,
}
impl SlotDefaultValue {
    /// <p>The default value for the slot. You can specify one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>#context-name.slot-name</code> - The slot value "slot-name"
    /// in the context "context-name."</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>{attribute}</code> - The slot value of the session attribute
    /// "attribute."</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>'value'</code> - The discrete value "value."</p>
    /// </li>
    /// </ul>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for SlotDefaultValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotDefaultValue");
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`SlotDefaultValue`](crate::model::SlotDefaultValue)
pub mod slot_default_value {
    /// A builder for [`SlotDefaultValue`](crate::model::SlotDefaultValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The default value for the slot. You can specify one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#context-name.slot-name</code> - The slot value "slot-name"
        /// in the context "context-name."</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>{attribute}</code> - The slot value of the session attribute
        /// "attribute."</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>'value'</code> - The discrete value "value."</p>
        /// </li>
        /// </ul>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the slot. You can specify one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>#context-name.slot-name</code> - The slot value "slot-name"
        /// in the context "context-name."</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>{attribute}</code> - The slot value of the session attribute
        /// "attribute."</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>'value'</code> - The discrete value "value."</p>
        /// </li>
        /// </ul>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotDefaultValue`](crate::model::SlotDefaultValue)
        pub fn build(self) -> crate::model::SlotDefaultValue {
            crate::model::SlotDefaultValue {
                default_value: self.default_value,
            }
        }
    }
}
impl SlotDefaultValue {
    /// Creates a new builder-style object to manufacture [`SlotDefaultValue`](crate::model::SlotDefaultValue)
    pub fn builder() -> crate::model::slot_default_value::Builder {
        crate::model::slot_default_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObfuscationSetting {
    #[allow(missing_docs)] // documentation missing in model
    DefaultObfuscation,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObfuscationSetting {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT_OBFUSCATION" => ObfuscationSetting::DefaultObfuscation,
            "NONE" => ObfuscationSetting::None,
            other => ObfuscationSetting::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObfuscationSetting {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObfuscationSetting::from(s))
    }
}
impl ObfuscationSetting {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObfuscationSetting::DefaultObfuscation => "DEFAULT_OBFUSCATION",
            ObfuscationSetting::None => "NONE",
            ObfuscationSetting::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT_OBFUSCATION", "NONE"]
    }
}
impl AsRef<str> for ObfuscationSetting {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SlotConstraint {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SlotConstraint {
    fn from(s: &str) -> Self {
        match s {
            "Optional" => SlotConstraint::Optional,
            "Required" => SlotConstraint::Required,
            other => SlotConstraint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SlotConstraint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SlotConstraint::from(s))
    }
}
impl SlotConstraint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SlotConstraint::Optional => "Optional",
            SlotConstraint::Required => "Required",
            SlotConstraint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Optional", "Required"]
    }
}
impl AsRef<str> for SlotConstraint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about conversation log settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConversationLogsResponse {
    /// <p>The settings for your conversation logs. You can log text, audio, or
    /// both.</p>
    pub log_settings: std::option::Option<std::vec::Vec<crate::model::LogSettingsResponse>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role used to write your logs
    /// to CloudWatch Logs or an S3 bucket.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
}
impl ConversationLogsResponse {
    /// <p>The settings for your conversation logs. You can log text, audio, or
    /// both.</p>
    pub fn log_settings(&self) -> std::option::Option<&[crate::model::LogSettingsResponse]> {
        self.log_settings.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role used to write your logs
    /// to CloudWatch Logs or an S3 bucket.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
}
impl std::fmt::Debug for ConversationLogsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConversationLogsResponse");
        formatter.field("log_settings", &self.log_settings);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.finish()
    }
}
/// See [`ConversationLogsResponse`](crate::model::ConversationLogsResponse)
pub mod conversation_logs_response {
    /// A builder for [`ConversationLogsResponse`](crate::model::ConversationLogsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_settings:
            std::option::Option<std::vec::Vec<crate::model::LogSettingsResponse>>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `log_settings`.
        ///
        /// To override the contents of this collection use [`set_log_settings`](Self::set_log_settings).
        ///
        /// <p>The settings for your conversation logs. You can log text, audio, or
        /// both.</p>
        pub fn log_settings(mut self, input: impl Into<crate::model::LogSettingsResponse>) -> Self {
            let mut v = self.log_settings.unwrap_or_default();
            v.push(input.into());
            self.log_settings = Some(v);
            self
        }
        /// <p>The settings for your conversation logs. You can log text, audio, or
        /// both.</p>
        pub fn set_log_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogSettingsResponse>>,
        ) -> Self {
            self.log_settings = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to write your logs
        /// to CloudWatch Logs or an S3 bucket.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role used to write your logs
        /// to CloudWatch Logs or an S3 bucket.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConversationLogsResponse`](crate::model::ConversationLogsResponse)
        pub fn build(self) -> crate::model::ConversationLogsResponse {
            crate::model::ConversationLogsResponse {
                log_settings: self.log_settings,
                iam_role_arn: self.iam_role_arn,
            }
        }
    }
}
impl ConversationLogsResponse {
    /// Creates a new builder-style object to manufacture [`ConversationLogsResponse`](crate::model::ConversationLogsResponse)
    pub fn builder() -> crate::model::conversation_logs_response::Builder {
        crate::model::conversation_logs_response::Builder::default()
    }
}

/// <p>The settings for conversation logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogSettingsResponse {
    /// <p>The type of logging that is enabled.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>The destination where logs are delivered.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The Amazon Resource Name (ARN) of the key used to encrypt audio logs
    /// in an S3 bucket.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
    /// bucket where the logs are delivered.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The resource prefix is the first part of the S3 object key within the
    /// S3 bucket that you specified to contain audio logs. For CloudWatch Logs it
    /// is the prefix of the log stream name within the log group that you
    /// specified. </p>
    pub resource_prefix: std::option::Option<std::string::String>,
}
impl LogSettingsResponse {
    /// <p>The type of logging that is enabled.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>The destination where logs are delivered.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the key used to encrypt audio logs
    /// in an S3 bucket.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
    /// bucket where the logs are delivered.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The resource prefix is the first part of the S3 object key within the
    /// S3 bucket that you specified to contain audio logs. For CloudWatch Logs it
    /// is the prefix of the log stream name within the log group that you
    /// specified. </p>
    pub fn resource_prefix(&self) -> std::option::Option<&str> {
        self.resource_prefix.as_deref()
    }
}
impl std::fmt::Debug for LogSettingsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogSettingsResponse");
        formatter.field("log_type", &self.log_type);
        formatter.field("destination", &self.destination);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_prefix", &self.resource_prefix);
        formatter.finish()
    }
}
/// See [`LogSettingsResponse`](crate::model::LogSettingsResponse)
pub mod log_settings_response {
    /// A builder for [`LogSettingsResponse`](crate::model::LogSettingsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of logging that is enabled.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>The type of logging that is enabled.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>The destination where logs are delivered.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The destination where logs are delivered.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key used to encrypt audio logs
        /// in an S3 bucket.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key used to encrypt audio logs
        /// in an S3 bucket.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
        /// bucket where the logs are delivered.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
        /// bucket where the logs are delivered.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The resource prefix is the first part of the S3 object key within the
        /// S3 bucket that you specified to contain audio logs. For CloudWatch Logs it
        /// is the prefix of the log stream name within the log group that you
        /// specified. </p>
        pub fn resource_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_prefix = Some(input.into());
            self
        }
        /// <p>The resource prefix is the first part of the S3 object key within the
        /// S3 bucket that you specified to contain audio logs. For CloudWatch Logs it
        /// is the prefix of the log stream name within the log group that you
        /// specified. </p>
        pub fn set_resource_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`LogSettingsResponse`](crate::model::LogSettingsResponse)
        pub fn build(self) -> crate::model::LogSettingsResponse {
            crate::model::LogSettingsResponse {
                log_type: self.log_type,
                destination: self.destination,
                kms_key_arn: self.kms_key_arn,
                resource_arn: self.resource_arn,
                resource_prefix: self.resource_prefix,
            }
        }
    }
}
impl LogSettingsResponse {
    /// Creates a new builder-style object to manufacture [`LogSettingsResponse`](crate::model::LogSettingsResponse)
    pub fn builder() -> crate::model::log_settings_response::Builder {
        crate::model::log_settings_response::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Destination {
    #[allow(missing_docs)] // documentation missing in model
    CloudwatchLogs,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Destination {
    fn from(s: &str) -> Self {
        match s {
            "CLOUDWATCH_LOGS" => Destination::CloudwatchLogs,
            "S3" => Destination::S3,
            other => Destination::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Destination {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Destination::from(s))
    }
}
impl Destination {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Destination::CloudwatchLogs => "CLOUDWATCH_LOGS",
            Destination::S3 => "S3",
            Destination::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOUDWATCH_LOGS", "S3"]
    }
}
impl AsRef<str> for Destination {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogType {
    #[allow(missing_docs)] // documentation missing in model
    Audio,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogType {
    fn from(s: &str) -> Self {
        match s {
            "AUDIO" => LogType::Audio,
            "TEXT" => LogType::Text,
            other => LogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogType::from(s))
    }
}
impl LogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogType::Audio => "AUDIO",
            LogType::Text => "TEXT",
            LogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUDIO", "TEXT"]
    }
}
impl AsRef<str> for LogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the settings needed for conversation logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConversationLogsRequest {
    /// <p>The settings for your conversation logs. You can log the conversation
    /// text, conversation audio, or both.</p>
    pub log_settings: std::option::Option<std::vec::Vec<crate::model::LogSettingsRequest>>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role with permission to write
    /// to your CloudWatch Logs for text logs and your S3 bucket for audio logs.
    /// If audio encryption is enabled, this role also provides access permission
    /// for the AWS KMS key used for encrypting audio logs. For more information,
    /// see <a href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an
    /// IAM Role and Policy for Conversation Logs</a>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
}
impl ConversationLogsRequest {
    /// <p>The settings for your conversation logs. You can log the conversation
    /// text, conversation audio, or both.</p>
    pub fn log_settings(&self) -> std::option::Option<&[crate::model::LogSettingsRequest]> {
        self.log_settings.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role with permission to write
    /// to your CloudWatch Logs for text logs and your S3 bucket for audio logs.
    /// If audio encryption is enabled, this role also provides access permission
    /// for the AWS KMS key used for encrypting audio logs. For more information,
    /// see <a href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an
    /// IAM Role and Policy for Conversation Logs</a>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
}
impl std::fmt::Debug for ConversationLogsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConversationLogsRequest");
        formatter.field("log_settings", &self.log_settings);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.finish()
    }
}
/// See [`ConversationLogsRequest`](crate::model::ConversationLogsRequest)
pub mod conversation_logs_request {
    /// A builder for [`ConversationLogsRequest`](crate::model::ConversationLogsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_settings:
            std::option::Option<std::vec::Vec<crate::model::LogSettingsRequest>>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `log_settings`.
        ///
        /// To override the contents of this collection use [`set_log_settings`](Self::set_log_settings).
        ///
        /// <p>The settings for your conversation logs. You can log the conversation
        /// text, conversation audio, or both.</p>
        pub fn log_settings(mut self, input: impl Into<crate::model::LogSettingsRequest>) -> Self {
            let mut v = self.log_settings.unwrap_or_default();
            v.push(input.into());
            self.log_settings = Some(v);
            self
        }
        /// <p>The settings for your conversation logs. You can log the conversation
        /// text, conversation audio, or both.</p>
        pub fn set_log_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LogSettingsRequest>>,
        ) -> Self {
            self.log_settings = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role with permission to write
        /// to your CloudWatch Logs for text logs and your S3 bucket for audio logs.
        /// If audio encryption is enabled, this role also provides access permission
        /// for the AWS KMS key used for encrypting audio logs. For more information,
        /// see <a href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an
        /// IAM Role and Policy for Conversation Logs</a>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role with permission to write
        /// to your CloudWatch Logs for text logs and your S3 bucket for audio logs.
        /// If audio encryption is enabled, this role also provides access permission
        /// for the AWS KMS key used for encrypting audio logs. For more information,
        /// see <a href="https://docs.aws.amazon.com/lex/latest/dg/conversation-logs-role-and-policy.html">Creating an
        /// IAM Role and Policy for Conversation Logs</a>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ConversationLogsRequest`](crate::model::ConversationLogsRequest)
        pub fn build(self) -> crate::model::ConversationLogsRequest {
            crate::model::ConversationLogsRequest {
                log_settings: self.log_settings,
                iam_role_arn: self.iam_role_arn,
            }
        }
    }
}
impl ConversationLogsRequest {
    /// Creates a new builder-style object to manufacture [`ConversationLogsRequest`](crate::model::ConversationLogsRequest)
    pub fn builder() -> crate::model::conversation_logs_request::Builder {
        crate::model::conversation_logs_request::Builder::default()
    }
}

/// <p>Settings used to configure delivery mode and destination for
/// conversation logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogSettingsRequest {
    /// <p>The type of logging to enable. Text logs are delivered to a CloudWatch
    /// Logs log group. Audio logs are delivered to an S3 bucket.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>Where the logs will be delivered. Text logs are delivered to a
    /// CloudWatch Logs log group. Audio logs are delivered to an S3
    /// bucket.</p>
    pub destination: std::option::Option<crate::model::Destination>,
    /// <p>The Amazon Resource Name (ARN) of the AWS KMS customer managed key for
    /// encrypting audio logs delivered to an S3 bucket. The key does not apply to
    /// CloudWatch Logs and is optional for S3 buckets.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
    /// bucket where the logs should be delivered.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl LogSettingsRequest {
    /// <p>The type of logging to enable. Text logs are delivered to a CloudWatch
    /// Logs log group. Audio logs are delivered to an S3 bucket.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>Where the logs will be delivered. Text logs are delivered to a
    /// CloudWatch Logs log group. Audio logs are delivered to an S3
    /// bucket.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::Destination> {
        self.destination.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS KMS customer managed key for
    /// encrypting audio logs delivered to an S3 bucket. The key does not apply to
    /// CloudWatch Logs and is optional for S3 buckets.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
    /// bucket where the logs should be delivered.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for LogSettingsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogSettingsRequest");
        formatter.field("log_type", &self.log_type);
        formatter.field("destination", &self.destination);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`LogSettingsRequest`](crate::model::LogSettingsRequest)
pub mod log_settings_request {
    /// A builder for [`LogSettingsRequest`](crate::model::LogSettingsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) destination: std::option::Option<crate::model::Destination>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of logging to enable. Text logs are delivered to a CloudWatch
        /// Logs log group. Audio logs are delivered to an S3 bucket.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>The type of logging to enable. Text logs are delivered to a CloudWatch
        /// Logs log group. Audio logs are delivered to an S3 bucket.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>Where the logs will be delivered. Text logs are delivered to a
        /// CloudWatch Logs log group. Audio logs are delivered to an S3
        /// bucket.</p>
        pub fn destination(mut self, input: crate::model::Destination) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Where the logs will be delivered. Text logs are delivered to a
        /// CloudWatch Logs log group. Audio logs are delivered to an S3
        /// bucket.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::Destination>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS KMS customer managed key for
        /// encrypting audio logs delivered to an S3 bucket. The key does not apply to
        /// CloudWatch Logs and is optional for S3 buckets.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS KMS customer managed key for
        /// encrypting audio logs delivered to an S3 bucket. The key does not apply to
        /// CloudWatch Logs and is optional for S3 buckets.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
        /// bucket where the logs should be delivered.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3
        /// bucket where the logs should be delivered.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LogSettingsRequest`](crate::model::LogSettingsRequest)
        pub fn build(self) -> crate::model::LogSettingsRequest {
            crate::model::LogSettingsRequest {
                log_type: self.log_type,
                destination: self.destination,
                kms_key_arn: self.kms_key_arn,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl LogSettingsRequest {
    /// Creates a new builder-style object to manufacture [`LogSettingsRequest`](crate::model::LogSettingsRequest)
    pub fn builder() -> crate::model::log_settings_request::Builder {
        crate::model::log_settings_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotBuilt,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    ReadyBasicTesting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "BUILDING" => Status::Building,
            "FAILED" => Status::Failed,
            "NOT_BUILT" => Status::NotBuilt,
            "READY" => Status::Ready,
            "READY_BASIC_TESTING" => Status::ReadyBasicTesting,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Building => "BUILDING",
            Status::Failed => "FAILED",
            Status::NotBuilt => "NOT_BUILT",
            Status::Ready => "READY",
            Status::ReadyBasicTesting => "READY_BASIC_TESTING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUILDING",
            "FAILED",
            "NOT_BUILT",
            "READY",
            "READY_BASIC_TESTING",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies the specific version of an intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Intent {
    /// <p>The name of the intent.</p>
    pub intent_name: std::option::Option<std::string::String>,
    /// <p>The version of the intent.</p>
    pub intent_version: std::option::Option<std::string::String>,
}
impl Intent {
    /// <p>The name of the intent.</p>
    pub fn intent_name(&self) -> std::option::Option<&str> {
        self.intent_name.as_deref()
    }
    /// <p>The version of the intent.</p>
    pub fn intent_version(&self) -> std::option::Option<&str> {
        self.intent_version.as_deref()
    }
}
impl std::fmt::Debug for Intent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Intent");
        formatter.field("intent_name", &self.intent_name);
        formatter.field("intent_version", &self.intent_version);
        formatter.finish()
    }
}
/// See [`Intent`](crate::model::Intent)
pub mod intent {
    /// A builder for [`Intent`](crate::model::Intent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intent_name: std::option::Option<std::string::String>,
        pub(crate) intent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn intent_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_intent_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.intent_name = input;
            self
        }
        /// <p>The version of the intent.</p>
        pub fn intent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.intent_version = Some(input.into());
            self
        }
        /// <p>The version of the intent.</p>
        pub fn set_intent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.intent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Intent`](crate::model::Intent)
        pub fn build(self) -> crate::model::Intent {
            crate::model::Intent {
                intent_name: self.intent_name,
                intent_version: self.intent_version,
            }
        }
    }
}
impl Intent {
    /// Creates a new builder-style object to manufacture [`Intent`](crate::model::Intent)
    pub fn builder() -> crate::model::intent::Builder {
        crate::model::intent::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProcessBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Build,
    #[allow(missing_docs)] // documentation missing in model
    Save,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProcessBehavior {
    fn from(s: &str) -> Self {
        match s {
            "BUILD" => ProcessBehavior::Build,
            "SAVE" => ProcessBehavior::Save,
            other => ProcessBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProcessBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProcessBehavior::from(s))
    }
}
impl ProcessBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProcessBehavior::Build => "BUILD",
            ProcessBehavior::Save => "SAVE",
            ProcessBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUILD", "SAVE"]
    }
}
impl AsRef<str> for ProcessBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a list of utterances that have been made to a specific
/// version of your bot. The list contains a maximum of 100
/// utterances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UtteranceList {
    /// <p>The version of the bot that processed the list.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>One or more <a>UtteranceData</a> objects that contain
    /// information about the utterances that have been made to a bot. The maximum
    /// number of object is 100.</p>
    pub utterances: std::option::Option<std::vec::Vec<crate::model::UtteranceData>>,
}
impl UtteranceList {
    /// <p>The version of the bot that processed the list.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>One or more <a>UtteranceData</a> objects that contain
    /// information about the utterances that have been made to a bot. The maximum
    /// number of object is 100.</p>
    pub fn utterances(&self) -> std::option::Option<&[crate::model::UtteranceData]> {
        self.utterances.as_deref()
    }
}
impl std::fmt::Debug for UtteranceList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UtteranceList");
        formatter.field("bot_version", &self.bot_version);
        formatter.field("utterances", &self.utterances);
        formatter.finish()
    }
}
/// See [`UtteranceList`](crate::model::UtteranceList)
pub mod utterance_list {
    /// A builder for [`UtteranceList`](crate::model::UtteranceList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) utterances: std::option::Option<std::vec::Vec<crate::model::UtteranceData>>,
    }
    impl Builder {
        /// <p>The version of the bot that processed the list.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that processed the list.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// Appends an item to `utterances`.
        ///
        /// To override the contents of this collection use [`set_utterances`](Self::set_utterances).
        ///
        /// <p>One or more <a>UtteranceData</a> objects that contain
        /// information about the utterances that have been made to a bot. The maximum
        /// number of object is 100.</p>
        pub fn utterances(mut self, input: impl Into<crate::model::UtteranceData>) -> Self {
            let mut v = self.utterances.unwrap_or_default();
            v.push(input.into());
            self.utterances = Some(v);
            self
        }
        /// <p>One or more <a>UtteranceData</a> objects that contain
        /// information about the utterances that have been made to a bot. The maximum
        /// number of object is 100.</p>
        pub fn set_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtteranceData>>,
        ) -> Self {
            self.utterances = input;
            self
        }
        /// Consumes the builder and constructs a [`UtteranceList`](crate::model::UtteranceList)
        pub fn build(self) -> crate::model::UtteranceList {
            crate::model::UtteranceList {
                bot_version: self.bot_version,
                utterances: self.utterances,
            }
        }
    }
}
impl UtteranceList {
    /// Creates a new builder-style object to manufacture [`UtteranceList`](crate::model::UtteranceList)
    pub fn builder() -> crate::model::utterance_list::Builder {
        crate::model::utterance_list::Builder::default()
    }
}

/// <p>Provides information about a single utterance that was made to your
/// bot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UtteranceData {
    /// <p>The text that was entered by the user or the text representation of
    /// an audio clip.</p>
    pub utterance_string: std::option::Option<std::string::String>,
    /// <p>The number of times that the utterance was processed.</p>
    pub count: std::option::Option<i32>,
    /// <p>The total number of individuals that used the utterance.</p>
    pub distinct_users: std::option::Option<i32>,
    /// <p>The date that the utterance was first recorded.</p>
    pub first_uttered_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the utterance was last recorded.</p>
    pub last_uttered_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl UtteranceData {
    /// <p>The text that was entered by the user or the text representation of
    /// an audio clip.</p>
    pub fn utterance_string(&self) -> std::option::Option<&str> {
        self.utterance_string.as_deref()
    }
    /// <p>The number of times that the utterance was processed.</p>
    pub fn count(&self) -> std::option::Option<i32> {
        self.count
    }
    /// <p>The total number of individuals that used the utterance.</p>
    pub fn distinct_users(&self) -> std::option::Option<i32> {
        self.distinct_users
    }
    /// <p>The date that the utterance was first recorded.</p>
    pub fn first_uttered_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_uttered_date.as_ref()
    }
    /// <p>The date that the utterance was last recorded.</p>
    pub fn last_uttered_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_uttered_date.as_ref()
    }
}
impl std::fmt::Debug for UtteranceData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UtteranceData");
        formatter.field("utterance_string", &self.utterance_string);
        formatter.field("count", &self.count);
        formatter.field("distinct_users", &self.distinct_users);
        formatter.field("first_uttered_date", &self.first_uttered_date);
        formatter.field("last_uttered_date", &self.last_uttered_date);
        formatter.finish()
    }
}
/// See [`UtteranceData`](crate::model::UtteranceData)
pub mod utterance_data {
    /// A builder for [`UtteranceData`](crate::model::UtteranceData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utterance_string: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) distinct_users: std::option::Option<i32>,
        pub(crate) first_uttered_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_uttered_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The text that was entered by the user or the text representation of
        /// an audio clip.</p>
        pub fn utterance_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.utterance_string = Some(input.into());
            self
        }
        /// <p>The text that was entered by the user or the text representation of
        /// an audio clip.</p>
        pub fn set_utterance_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.utterance_string = input;
            self
        }
        /// <p>The number of times that the utterance was processed.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of times that the utterance was processed.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// <p>The total number of individuals that used the utterance.</p>
        pub fn distinct_users(mut self, input: i32) -> Self {
            self.distinct_users = Some(input);
            self
        }
        /// <p>The total number of individuals that used the utterance.</p>
        pub fn set_distinct_users(mut self, input: std::option::Option<i32>) -> Self {
            self.distinct_users = input;
            self
        }
        /// <p>The date that the utterance was first recorded.</p>
        pub fn first_uttered_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_uttered_date = Some(input);
            self
        }
        /// <p>The date that the utterance was first recorded.</p>
        pub fn set_first_uttered_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_uttered_date = input;
            self
        }
        /// <p>The date that the utterance was last recorded.</p>
        pub fn last_uttered_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_uttered_date = Some(input);
            self
        }
        /// <p>The date that the utterance was last recorded.</p>
        pub fn set_last_uttered_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_uttered_date = input;
            self
        }
        /// Consumes the builder and constructs a [`UtteranceData`](crate::model::UtteranceData)
        pub fn build(self) -> crate::model::UtteranceData {
            crate::model::UtteranceData {
                utterance_string: self.utterance_string,
                count: self.count,
                distinct_users: self.distinct_users,
                first_uttered_date: self.first_uttered_date,
                last_uttered_date: self.last_uttered_date,
            }
        }
    }
}
impl UtteranceData {
    /// Creates a new builder-style object to manufacture [`UtteranceData`](crate::model::UtteranceData)
    pub fn builder() -> crate::model::utterance_data::Builder {
        crate::model::utterance_data::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Detected,
    #[allow(missing_docs)] // documentation missing in model
    Missed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "Detected" => StatusType::Detected,
            "Missed" => StatusType::Missed,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Detected => "Detected",
            StatusType::Missed => "Missed",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Detected", "Missed"]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a slot type..</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SlotTypeMetadata {
    /// <p>The name of the slot type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last updated date are the same. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the slot type was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version of the slot type.</p>
    pub version: std::option::Option<std::string::String>,
}
impl SlotTypeMetadata {
    /// <p>The name of the slot type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last updated date are the same. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the slot type was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The version of the slot type.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for SlotTypeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SlotTypeMetadata");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`SlotTypeMetadata`](crate::model::SlotTypeMetadata)
pub mod slot_type_metadata {
    /// A builder for [`SlotTypeMetadata`](crate::model::SlotTypeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last updated date are the same. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last updated date are the same. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`SlotTypeMetadata`](crate::model::SlotTypeMetadata)
        pub fn build(self) -> crate::model::SlotTypeMetadata {
            crate::model::SlotTypeMetadata {
                name: self.name,
                description: self.description,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
            }
        }
    }
}
impl SlotTypeMetadata {
    /// Creates a new builder-style object to manufacture [`SlotTypeMetadata`](crate::model::SlotTypeMetadata)
    pub fn builder() -> crate::model::slot_type_metadata::Builder {
        crate::model::slot_type_metadata::Builder::default()
    }
}

/// <p>Provides information about migrating a bot from Amazon Lex V1 to Amazon Lex V2.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MigrationSummary {
    /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
    pub migration_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub v1_bot_name: std::option::Option<std::string::String>,
    /// <p>The version of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub v1_bot_version: std::option::Option<std::string::String>,
    /// <p>The locale of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub v1_bot_locale: std::option::Option<crate::model::Locale>,
    /// <p>The unique identifier of the Amazon Lex V2 that is the destination of the migration.</p>
    pub v2_bot_id: std::option::Option<std::string::String>,
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub v2_bot_role: std::option::Option<std::string::String>,
    /// <p>The status of the operation. When the status is <code>COMPLETE</code>
    /// the bot is available in Amazon Lex V2. There may be alerts and warnings that
    /// need to be resolved to complete the migration.</p>
    pub migration_status: std::option::Option<crate::model::MigrationStatus>,
    /// <p>The strategy used to conduct the migration.</p>
    pub migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
    /// <p>The date and time that the migration started.</p>
    pub migration_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl MigrationSummary {
    /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
    pub fn migration_id(&self) -> std::option::Option<&str> {
        self.migration_id.as_deref()
    }
    /// <p>The name of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub fn v1_bot_name(&self) -> std::option::Option<&str> {
        self.v1_bot_name.as_deref()
    }
    /// <p>The version of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub fn v1_bot_version(&self) -> std::option::Option<&str> {
        self.v1_bot_version.as_deref()
    }
    /// <p>The locale of the Amazon Lex V1 bot that is the source of the migration.</p>
    pub fn v1_bot_locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.v1_bot_locale.as_ref()
    }
    /// <p>The unique identifier of the Amazon Lex V2 that is the destination of the migration.</p>
    pub fn v2_bot_id(&self) -> std::option::Option<&str> {
        self.v2_bot_id.as_deref()
    }
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub fn v2_bot_role(&self) -> std::option::Option<&str> {
        self.v2_bot_role.as_deref()
    }
    /// <p>The status of the operation. When the status is <code>COMPLETE</code>
    /// the bot is available in Amazon Lex V2. There may be alerts and warnings that
    /// need to be resolved to complete the migration.</p>
    pub fn migration_status(&self) -> std::option::Option<&crate::model::MigrationStatus> {
        self.migration_status.as_ref()
    }
    /// <p>The strategy used to conduct the migration.</p>
    pub fn migration_strategy(&self) -> std::option::Option<&crate::model::MigrationStrategy> {
        self.migration_strategy.as_ref()
    }
    /// <p>The date and time that the migration started.</p>
    pub fn migration_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.migration_timestamp.as_ref()
    }
}
impl std::fmt::Debug for MigrationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MigrationSummary");
        formatter.field("migration_id", &self.migration_id);
        formatter.field("v1_bot_name", &self.v1_bot_name);
        formatter.field("v1_bot_version", &self.v1_bot_version);
        formatter.field("v1_bot_locale", &self.v1_bot_locale);
        formatter.field("v2_bot_id", &self.v2_bot_id);
        formatter.field("v2_bot_role", &self.v2_bot_role);
        formatter.field("migration_status", &self.migration_status);
        formatter.field("migration_strategy", &self.migration_strategy);
        formatter.field("migration_timestamp", &self.migration_timestamp);
        formatter.finish()
    }
}
/// See [`MigrationSummary`](crate::model::MigrationSummary)
pub mod migration_summary {
    /// A builder for [`MigrationSummary`](crate::model::MigrationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) migration_id: std::option::Option<std::string::String>,
        pub(crate) v1_bot_name: std::option::Option<std::string::String>,
        pub(crate) v1_bot_version: std::option::Option<std::string::String>,
        pub(crate) v1_bot_locale: std::option::Option<crate::model::Locale>,
        pub(crate) v2_bot_id: std::option::Option<std::string::String>,
        pub(crate) v2_bot_role: std::option::Option<std::string::String>,
        pub(crate) migration_status: std::option::Option<crate::model::MigrationStatus>,
        pub(crate) migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
        pub(crate) migration_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
        pub fn migration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
        pub fn set_migration_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.migration_id = input;
            self
        }
        /// <p>The name of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn v1_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn set_v1_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v1_bot_name = input;
            self
        }
        /// <p>The version of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn v1_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn set_v1_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.v1_bot_version = input;
            self
        }
        /// <p>The locale of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn v1_bot_locale(mut self, input: crate::model::Locale) -> Self {
            self.v1_bot_locale = Some(input);
            self
        }
        /// <p>The locale of the Amazon Lex V1 bot that is the source of the migration.</p>
        pub fn set_v1_bot_locale(
            mut self,
            input: std::option::Option<crate::model::Locale>,
        ) -> Self {
            self.v1_bot_locale = input;
            self
        }
        /// <p>The unique identifier of the Amazon Lex V2 that is the destination of the migration.</p>
        pub fn v2_bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon Lex V2 that is the destination of the migration.</p>
        pub fn set_v2_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_id = input;
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn v2_bot_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn set_v2_bot_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_role = input;
            self
        }
        /// <p>The status of the operation. When the status is <code>COMPLETE</code>
        /// the bot is available in Amazon Lex V2. There may be alerts and warnings that
        /// need to be resolved to complete the migration.</p>
        pub fn migration_status(mut self, input: crate::model::MigrationStatus) -> Self {
            self.migration_status = Some(input);
            self
        }
        /// <p>The status of the operation. When the status is <code>COMPLETE</code>
        /// the bot is available in Amazon Lex V2. There may be alerts and warnings that
        /// need to be resolved to complete the migration.</p>
        pub fn set_migration_status(
            mut self,
            input: std::option::Option<crate::model::MigrationStatus>,
        ) -> Self {
            self.migration_status = input;
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        pub fn migration_strategy(mut self, input: crate::model::MigrationStrategy) -> Self {
            self.migration_strategy = Some(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        pub fn set_migration_strategy(
            mut self,
            input: std::option::Option<crate::model::MigrationStrategy>,
        ) -> Self {
            self.migration_strategy = input;
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn migration_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.migration_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn set_migration_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.migration_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`MigrationSummary`](crate::model::MigrationSummary)
        pub fn build(self) -> crate::model::MigrationSummary {
            crate::model::MigrationSummary {
                migration_id: self.migration_id,
                v1_bot_name: self.v1_bot_name,
                v1_bot_version: self.v1_bot_version,
                v1_bot_locale: self.v1_bot_locale,
                v2_bot_id: self.v2_bot_id,
                v2_bot_role: self.v2_bot_role,
                migration_status: self.migration_status,
                migration_strategy: self.migration_strategy,
                migration_timestamp: self.migration_timestamp,
            }
        }
    }
}
impl MigrationSummary {
    /// Creates a new builder-style object to manufacture [`MigrationSummary`](crate::model::MigrationSummary)
    pub fn builder() -> crate::model::migration_summary::Builder {
        crate::model::migration_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => MigrationStatus::Completed,
            "FAILED" => MigrationStatus::Failed,
            "IN_PROGRESS" => MigrationStatus::InProgress,
            other => MigrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationStatus::from(s))
    }
}
impl MigrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationStatus::Completed => "COMPLETED",
            MigrationStatus::Failed => "FAILED",
            MigrationStatus::InProgress => "IN_PROGRESS",
            MigrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for MigrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationSortAttribute {
    #[allow(missing_docs)] // documentation missing in model
    MigrationDateTime,
    #[allow(missing_docs)] // documentation missing in model
    V1BotName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationSortAttribute {
    fn from(s: &str) -> Self {
        match s {
            "MIGRATION_DATE_TIME" => MigrationSortAttribute::MigrationDateTime,
            "V1_BOT_NAME" => MigrationSortAttribute::V1BotName,
            other => MigrationSortAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationSortAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationSortAttribute::from(s))
    }
}
impl MigrationSortAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationSortAttribute::MigrationDateTime => "MIGRATION_DATE_TIME",
            MigrationSortAttribute::V1BotName => "V1_BOT_NAME",
            MigrationSortAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MIGRATION_DATE_TIME", "V1_BOT_NAME"]
    }
}
impl AsRef<str> for MigrationSortAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about alerts and warnings that Amazon Lex sends during
/// a migration. The alerts include information about how to resolve the
/// issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MigrationAlert {
    /// <p>The type of alert. There are two kinds of alerts:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - There was an issue with the migration that
    /// can't be resolved. The migration stops.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WARN</code> - There was an issue with the migration that
    /// requires manual changes to the new Amazon Lex V2 bot. The migration
    /// continues.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::MigrationAlertType>,
    /// <p>A message that describes why the alert was issued.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Additional details about the alert.</p>
    pub details: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A link to the Amazon Lex documentation that describes how to resolve
    /// the alert.</p>
    pub reference_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl MigrationAlert {
    /// <p>The type of alert. There are two kinds of alerts:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ERROR</code> - There was an issue with the migration that
    /// can't be resolved. The migration stops.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WARN</code> - There was an issue with the migration that
    /// requires manual changes to the new Amazon Lex V2 bot. The migration
    /// continues.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::MigrationAlertType> {
        self.r#type.as_ref()
    }
    /// <p>A message that describes why the alert was issued.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Additional details about the alert.</p>
    pub fn details(&self) -> std::option::Option<&[std::string::String]> {
        self.details.as_deref()
    }
    /// <p>A link to the Amazon Lex documentation that describes how to resolve
    /// the alert.</p>
    pub fn reference_ur_ls(&self) -> std::option::Option<&[std::string::String]> {
        self.reference_ur_ls.as_deref()
    }
}
impl std::fmt::Debug for MigrationAlert {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MigrationAlert");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.field("details", &self.details);
        formatter.field("reference_ur_ls", &self.reference_ur_ls);
        formatter.finish()
    }
}
/// See [`MigrationAlert`](crate::model::MigrationAlert)
pub mod migration_alert {
    /// A builder for [`MigrationAlert`](crate::model::MigrationAlert)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::MigrationAlertType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) details: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reference_ur_ls: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of alert. There are two kinds of alerts:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - There was an issue with the migration that
        /// can't be resolved. The migration stops.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WARN</code> - There was an issue with the migration that
        /// requires manual changes to the new Amazon Lex V2 bot. The migration
        /// continues.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::MigrationAlertType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of alert. There are two kinds of alerts:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ERROR</code> - There was an issue with the migration that
        /// can't be resolved. The migration stops.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WARN</code> - There was an issue with the migration that
        /// requires manual changes to the new Amazon Lex V2 bot. The migration
        /// continues.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::MigrationAlertType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A message that describes why the alert was issued.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that describes why the alert was issued.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `details`.
        ///
        /// To override the contents of this collection use [`set_details`](Self::set_details).
        ///
        /// <p>Additional details about the alert.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.details.unwrap_or_default();
            v.push(input.into());
            self.details = Some(v);
            self
        }
        /// <p>Additional details about the alert.</p>
        pub fn set_details(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.details = input;
            self
        }
        /// Appends an item to `reference_ur_ls`.
        ///
        /// To override the contents of this collection use [`set_reference_ur_ls`](Self::set_reference_ur_ls).
        ///
        /// <p>A link to the Amazon Lex documentation that describes how to resolve
        /// the alert.</p>
        pub fn reference_ur_ls(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reference_ur_ls.unwrap_or_default();
            v.push(input.into());
            self.reference_ur_ls = Some(v);
            self
        }
        /// <p>A link to the Amazon Lex documentation that describes how to resolve
        /// the alert.</p>
        pub fn set_reference_ur_ls(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reference_ur_ls = input;
            self
        }
        /// Consumes the builder and constructs a [`MigrationAlert`](crate::model::MigrationAlert)
        pub fn build(self) -> crate::model::MigrationAlert {
            crate::model::MigrationAlert {
                r#type: self.r#type,
                message: self.message,
                details: self.details,
                reference_ur_ls: self.reference_ur_ls,
            }
        }
    }
}
impl MigrationAlert {
    /// Creates a new builder-style object to manufacture [`MigrationAlert`](crate::model::MigrationAlert)
    pub fn builder() -> crate::model::migration_alert::Builder {
        crate::model::migration_alert::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationAlertType {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Warn,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationAlertType {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => MigrationAlertType::Error,
            "WARN" => MigrationAlertType::Warn,
            other => MigrationAlertType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationAlertType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationAlertType::from(s))
    }
}
impl MigrationAlertType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationAlertType::Error => "ERROR",
            MigrationAlertType::Warn => "WARN",
            MigrationAlertType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "WARN"]
    }
}
impl AsRef<str> for MigrationAlertType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about an intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IntentMetadata {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the intent was updated. When you create an intent,
    /// the creation date and last updated date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the intent was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version of the intent.</p>
    pub version: std::option::Option<std::string::String>,
}
impl IntentMetadata {
    /// <p>The name of the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the intent was updated. When you create an intent,
    /// the creation date and last updated date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the intent was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The version of the intent.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for IntentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IntentMetadata");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`IntentMetadata`](crate::model::IntentMetadata)
pub mod intent_metadata {
    /// A builder for [`IntentMetadata`](crate::model::IntentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the intent was updated. When you create an intent,
        /// the creation date and last updated date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the intent was updated. When you create an intent,
        /// the creation date and last updated date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the intent.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the intent.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`IntentMetadata`](crate::model::IntentMetadata)
        pub fn build(self) -> crate::model::IntentMetadata {
            crate::model::IntentMetadata {
                name: self.name,
                description: self.description,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
            }
        }
    }
}
impl IntentMetadata {
    /// Creates a new builder-style object to manufacture [`IntentMetadata`](crate::model::IntentMetadata)
    pub fn builder() -> crate::model::intent_metadata::Builder {
        crate::model::intent_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ExportStatus::Failed,
            "IN_PROGRESS" => ExportStatus::InProgress,
            "READY" => ExportStatus::Ready,
            other => ExportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportStatus::from(s))
    }
}
impl ExportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportStatus::Failed => "FAILED",
            ExportStatus::InProgress => "IN_PROGRESS",
            ExportStatus::Ready => "READY",
            ExportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "READY"]
    }
}
impl AsRef<str> for ExportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportType {
    #[allow(missing_docs)] // documentation missing in model
    AlexaSkillsKit,
    #[allow(missing_docs)] // documentation missing in model
    Lex,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportType {
    fn from(s: &str) -> Self {
        match s {
            "ALEXA_SKILLS_KIT" => ExportType::AlexaSkillsKit,
            "LEX" => ExportType::Lex,
            other => ExportType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportType::from(s))
    }
}
impl ExportType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportType::AlexaSkillsKit => "ALEXA_SKILLS_KIT",
            ExportType::Lex => "LEX",
            ExportType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALEXA_SKILLS_KIT", "LEX"]
    }
}
impl AsRef<str> for ExportType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a built in slot type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltinSlotTypeMetadata {
    /// <p>A unique identifier for the built-in slot type. To find the
    /// signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub signature: std::option::Option<std::string::String>,
    /// <p>A list of target locales for the slot. </p>
    pub supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
}
impl BuiltinSlotTypeMetadata {
    /// <p>A unique identifier for the built-in slot type. To find the
    /// signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
    /// <p>A list of target locales for the slot. </p>
    pub fn supported_locales(&self) -> std::option::Option<&[crate::model::Locale]> {
        self.supported_locales.as_deref()
    }
}
impl std::fmt::Debug for BuiltinSlotTypeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltinSlotTypeMetadata");
        formatter.field("signature", &self.signature);
        formatter.field("supported_locales", &self.supported_locales);
        formatter.finish()
    }
}
/// See [`BuiltinSlotTypeMetadata`](crate::model::BuiltinSlotTypeMetadata)
pub mod builtin_slot_type_metadata {
    /// A builder for [`BuiltinSlotTypeMetadata`](crate::model::BuiltinSlotTypeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature: std::option::Option<std::string::String>,
        pub(crate) supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
    }
    impl Builder {
        /// <p>A unique identifier for the built-in slot type. To find the
        /// signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for the built-in slot type. To find the
        /// signature for a slot type, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Appends an item to `supported_locales`.
        ///
        /// To override the contents of this collection use [`set_supported_locales`](Self::set_supported_locales).
        ///
        /// <p>A list of target locales for the slot. </p>
        pub fn supported_locales(mut self, input: impl Into<crate::model::Locale>) -> Self {
            let mut v = self.supported_locales.unwrap_or_default();
            v.push(input.into());
            self.supported_locales = Some(v);
            self
        }
        /// <p>A list of target locales for the slot. </p>
        pub fn set_supported_locales(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        ) -> Self {
            self.supported_locales = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltinSlotTypeMetadata`](crate::model::BuiltinSlotTypeMetadata)
        pub fn build(self) -> crate::model::BuiltinSlotTypeMetadata {
            crate::model::BuiltinSlotTypeMetadata {
                signature: self.signature,
                supported_locales: self.supported_locales,
            }
        }
    }
}
impl BuiltinSlotTypeMetadata {
    /// Creates a new builder-style object to manufacture [`BuiltinSlotTypeMetadata`](crate::model::BuiltinSlotTypeMetadata)
    pub fn builder() -> crate::model::builtin_slot_type_metadata::Builder {
        crate::model::builtin_slot_type_metadata::Builder::default()
    }
}

/// <p>Provides metadata for a built-in intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltinIntentMetadata {
    /// <p>A unique identifier for the built-in intent. To find the signature
    /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub signature: std::option::Option<std::string::String>,
    /// <p>A list of identifiers for the locales that the intent
    /// supports.</p>
    pub supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
}
impl BuiltinIntentMetadata {
    /// <p>A unique identifier for the built-in intent. To find the signature
    /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
    /// <p>A list of identifiers for the locales that the intent
    /// supports.</p>
    pub fn supported_locales(&self) -> std::option::Option<&[crate::model::Locale]> {
        self.supported_locales.as_deref()
    }
}
impl std::fmt::Debug for BuiltinIntentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltinIntentMetadata");
        formatter.field("signature", &self.signature);
        formatter.field("supported_locales", &self.supported_locales);
        formatter.finish()
    }
}
/// See [`BuiltinIntentMetadata`](crate::model::BuiltinIntentMetadata)
pub mod builtin_intent_metadata {
    /// A builder for [`BuiltinIntentMetadata`](crate::model::BuiltinIntentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature: std::option::Option<std::string::String>,
        pub(crate) supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
    }
    impl Builder {
        /// <p>A unique identifier for the built-in intent. To find the signature
        /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent. To find the signature
        /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Appends an item to `supported_locales`.
        ///
        /// To override the contents of this collection use [`set_supported_locales`](Self::set_supported_locales).
        ///
        /// <p>A list of identifiers for the locales that the intent
        /// supports.</p>
        pub fn supported_locales(mut self, input: impl Into<crate::model::Locale>) -> Self {
            let mut v = self.supported_locales.unwrap_or_default();
            v.push(input.into());
            self.supported_locales = Some(v);
            self
        }
        /// <p>A list of identifiers for the locales that the intent
        /// supports.</p>
        pub fn set_supported_locales(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        ) -> Self {
            self.supported_locales = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltinIntentMetadata`](crate::model::BuiltinIntentMetadata)
        pub fn build(self) -> crate::model::BuiltinIntentMetadata {
            crate::model::BuiltinIntentMetadata {
                signature: self.signature,
                supported_locales: self.supported_locales,
            }
        }
    }
}
impl BuiltinIntentMetadata {
    /// Creates a new builder-style object to manufacture [`BuiltinIntentMetadata`](crate::model::BuiltinIntentMetadata)
    pub fn builder() -> crate::model::builtin_intent_metadata::Builder {
        crate::model::builtin_intent_metadata::Builder::default()
    }
}

/// <p>Provides information about a slot used in a built-in
/// intent.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuiltinIntentSlot {
    /// <p>A list of the slots defined for the intent.</p>
    pub name: std::option::Option<std::string::String>,
}
impl BuiltinIntentSlot {
    /// <p>A list of the slots defined for the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for BuiltinIntentSlot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuiltinIntentSlot");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`BuiltinIntentSlot`](crate::model::BuiltinIntentSlot)
pub mod builtin_intent_slot {
    /// A builder for [`BuiltinIntentSlot`](crate::model::BuiltinIntentSlot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of the slots defined for the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A list of the slots defined for the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`BuiltinIntentSlot`](crate::model::BuiltinIntentSlot)
        pub fn build(self) -> crate::model::BuiltinIntentSlot {
            crate::model::BuiltinIntentSlot { name: self.name }
        }
    }
}
impl BuiltinIntentSlot {
    /// Creates a new builder-style object to manufacture [`BuiltinIntentSlot`](crate::model::BuiltinIntentSlot)
    pub fn builder() -> crate::model::builtin_intent_slot::Builder {
        crate::model::builtin_intent_slot::Builder::default()
    }
}

/// <p>Provides information about a bot. .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotMetadata {
    /// <p>The name of the bot. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the bot.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>The date that the bot was updated. When you create a bot, the
    /// creation date and last updated date are the same. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the bot was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub version: std::option::Option<std::string::String>,
}
impl BotMetadata {
    /// <p>The name of the bot. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The status of the bot.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>The date that the bot was updated. When you create a bot, the
    /// creation date and last updated date are the same. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for BotMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotMetadata");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`BotMetadata`](crate::model::BotMetadata)
pub mod bot_metadata {
    /// A builder for [`BotMetadata`](crate::model::BotMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the bot.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the bot.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date that the bot was updated. When you create a bot, the
        /// creation date and last updated date are the same. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot was updated. When you create a bot, the
        /// creation date and last updated date are the same. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`BotMetadata`](crate::model::BotMetadata)
        pub fn build(self) -> crate::model::BotMetadata {
            crate::model::BotMetadata {
                name: self.name,
                description: self.description,
                status: self.status,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
            }
        }
    }
}
impl BotMetadata {
    /// Creates a new builder-style object to manufacture [`BotMetadata`](crate::model::BotMetadata)
    pub fn builder() -> crate::model::bot_metadata::Builder {
        crate::model::bot_metadata::Builder::default()
    }
}

/// <p>Represents an association between an Amazon Lex bot and an external
/// messaging platform.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotChannelAssociation {
    /// <p>The name of the association between the bot and the channel.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A text description of the association you are creating. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made. </p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex bot to which this association is being made. </p>
    /// <note>
    /// <p>Currently, Amazon Lex supports associations with Facebook and Slack,
    /// and Twilio.</p>
    ///
    /// </note>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The date that the association between the Amazon Lex bot and the channel
    /// was created. </p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the type of association by indicating the type of channel
    /// being established between the Amazon Lex bot and the external messaging
    /// platform.</p>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>Provides information necessary to communicate with the messaging
    /// platform. </p>
    pub bot_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the bot channel. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The channel has been created and is
    /// ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Channel creation is in
    /// progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - There was an error creating the channel.
    /// For information about the reason for the failure, see the
    /// <code>failureReason</code> field.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ChannelStatus>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to create the association.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl BotChannelAssociation {
    /// <p>The name of the association between the bot and the channel.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A text description of the association you are creating. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made. </p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
    /// <p>The name of the Amazon Lex bot to which this association is being made. </p>
    /// <note>
    /// <p>Currently, Amazon Lex supports associations with Facebook and Slack,
    /// and Twilio.</p>
    ///
    /// </note>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The date that the association between the Amazon Lex bot and the channel
    /// was created. </p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>Specifies the type of association by indicating the type of channel
    /// being established between the Amazon Lex bot and the external messaging
    /// platform.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.r#type.as_ref()
    }
    /// <p>Provides information necessary to communicate with the messaging
    /// platform. </p>
    pub fn bot_configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.bot_configuration.as_ref()
    }
    /// <p>The status of the bot channel. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The channel has been created and is
    /// ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Channel creation is in
    /// progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - There was an error creating the channel.
    /// For information about the reason for the failure, see the
    /// <code>failureReason</code> field.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ChannelStatus> {
        self.status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to create the association.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for BotChannelAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotChannelAssociation");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("created_date", &self.created_date);
        formatter.field("r#type", &self.r#type);
        formatter.field("bot_configuration", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`BotChannelAssociation`](crate::model::BotChannelAssociation)
pub mod bot_channel_association {
    /// A builder for [`BotChannelAssociation`](crate::model::BotChannelAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) bot_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::ChannelStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the association between the bot and the channel.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the association between the bot and the channel.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A text description of the association you are creating. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A text description of the association you are creating. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made. </p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made. </p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The name of the Amazon Lex bot to which this association is being made. </p>
        /// <note>
        /// <p>Currently, Amazon Lex supports associations with Facebook and Slack,
        /// and Twilio.</p>
        ///
        /// </note>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot to which this association is being made. </p>
        /// <note>
        /// <p>Currently, Amazon Lex supports associations with Facebook and Slack,
        /// and Twilio.</p>
        ///
        /// </note>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The date that the association between the Amazon Lex bot and the channel
        /// was created. </p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the association between the Amazon Lex bot and the channel
        /// was created. </p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Specifies the type of association by indicating the type of channel
        /// being established between the Amazon Lex bot and the external messaging
        /// platform.</p>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of association by indicating the type of channel
        /// being established between the Amazon Lex bot and the external messaging
        /// platform.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `bot_configuration`.
        ///
        /// To override the contents of this collection use [`set_bot_configuration`](Self::set_bot_configuration).
        ///
        /// <p>Provides information necessary to communicate with the messaging
        /// platform. </p>
        pub fn bot_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.bot_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.bot_configuration = Some(hash_map);
            self
        }
        /// <p>Provides information necessary to communicate with the messaging
        /// platform. </p>
        pub fn set_bot_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.bot_configuration = input;
            self
        }
        /// <p>The status of the bot channel. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The channel has been created and is
        /// ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Channel creation is in
        /// progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - There was an error creating the channel.
        /// For information about the reason for the failure, see the
        /// <code>failureReason</code> field.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ChannelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the bot channel. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The channel has been created and is
        /// ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Channel creation is in
        /// progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - There was an error creating the channel.
        /// For information about the reason for the failure, see the
        /// <code>failureReason</code> field.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to create the association.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to create the association.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`BotChannelAssociation`](crate::model::BotChannelAssociation)
        pub fn build(self) -> crate::model::BotChannelAssociation {
            crate::model::BotChannelAssociation {
                name: self.name,
                description: self.description,
                bot_alias: self.bot_alias,
                bot_name: self.bot_name,
                created_date: self.created_date,
                r#type: self.r#type,
                bot_configuration: self.bot_configuration,
                status: self.status,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl BotChannelAssociation {
    /// Creates a new builder-style object to manufacture [`BotChannelAssociation`](crate::model::BotChannelAssociation)
    pub fn builder() -> crate::model::bot_channel_association::Builder {
        crate::model::bot_channel_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelStatus {
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATED" => ChannelStatus::Created,
            "FAILED" => ChannelStatus::Failed,
            "IN_PROGRESS" => ChannelStatus::InProgress,
            other => ChannelStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelStatus::from(s))
    }
}
impl ChannelStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelStatus::Created => "CREATED",
            ChannelStatus::Failed => "FAILED",
            ChannelStatus::InProgress => "IN_PROGRESS",
            ChannelStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for ChannelStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelType {
    #[allow(missing_docs)] // documentation missing in model
    Facebook,
    #[allow(missing_docs)] // documentation missing in model
    Kik,
    #[allow(missing_docs)] // documentation missing in model
    Slack,
    #[allow(missing_docs)] // documentation missing in model
    TwilioSms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelType {
    fn from(s: &str) -> Self {
        match s {
            "Facebook" => ChannelType::Facebook,
            "Kik" => ChannelType::Kik,
            "Slack" => ChannelType::Slack,
            "Twilio-Sms" => ChannelType::TwilioSms,
            other => ChannelType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelType::from(s))
    }
}
impl ChannelType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelType::Facebook => "Facebook",
            ChannelType::Kik => "Kik",
            ChannelType::Slack => "Slack",
            ChannelType::TwilioSms => "Twilio-Sms",
            ChannelType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Facebook", "Kik", "Slack", "Twilio-Sms"]
    }
}
impl AsRef<str> for ChannelType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a bot alias.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BotAliasMetadata {
    /// <p>The name of the bot alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the Amazon Lex bot to which the alias points.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The name of the bot to which the alias points.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and last updated date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date that the bot alias was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Checksum of the bot alias.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
}
impl BotAliasMetadata {
    /// <p>The name of the bot alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the Amazon Lex bot to which the alias points.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The name of the bot to which the alias points.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and last updated date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot alias was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>Checksum of the bot alias.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub fn conversation_logs(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogsResponse> {
        self.conversation_logs.as_ref()
    }
}
impl std::fmt::Debug for BotAliasMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BotAliasMetadata");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("checksum", &self.checksum);
        formatter.field("conversation_logs", &self.conversation_logs);
        formatter.finish()
    }
}
/// See [`BotAliasMetadata`](crate::model::BotAliasMetadata)
pub mod bot_alias_metadata {
    /// A builder for [`BotAliasMetadata`](crate::model::BotAliasMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
    }
    impl Builder {
        /// <p>The name of the bot alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the Amazon Lex bot to which the alias points.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon Lex bot to which the alias points.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The name of the bot to which the alias points.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot to which the alias points.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and last updated date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and last updated date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Checksum of the bot alias.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the bot alias.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn conversation_logs(mut self, input: crate::model::ConversationLogsResponse) -> Self {
            self.conversation_logs = Some(input);
            self
        }
        /// <p>Settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn set_conversation_logs(
            mut self,
            input: std::option::Option<crate::model::ConversationLogsResponse>,
        ) -> Self {
            self.conversation_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`BotAliasMetadata`](crate::model::BotAliasMetadata)
        pub fn build(self) -> crate::model::BotAliasMetadata {
            crate::model::BotAliasMetadata {
                name: self.name,
                description: self.description,
                bot_version: self.bot_version,
                bot_name: self.bot_name,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                checksum: self.checksum,
                conversation_logs: self.conversation_logs,
            }
        }
    }
}
impl BotAliasMetadata {
    /// Creates a new builder-style object to manufacture [`BotAliasMetadata`](crate::model::BotAliasMetadata)
    pub fn builder() -> crate::model::bot_alias_metadata::Builder {
        crate::model::bot_alias_metadata::Builder::default()
    }
}

/// <p>Describes the resource that refers to the resource that you are
/// attempting to delete. This object is returned as part of the
/// <code>ResourceInUseException</code> exception. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceReference {
    /// <p>The name of the resource that is using the resource that you are
    /// trying to delete.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the resource that is using the resource that you are
    /// trying to delete.</p>
    pub version: std::option::Option<std::string::String>,
}
impl ResourceReference {
    /// <p>The name of the resource that is using the resource that you are
    /// trying to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the resource that is using the resource that you are
    /// trying to delete.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for ResourceReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceReference");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`ResourceReference`](crate::model::ResourceReference)
pub mod resource_reference {
    /// A builder for [`ResourceReference`](crate::model::ResourceReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource that is using the resource that you are
        /// trying to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the resource that is using the resource that you are
        /// trying to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the resource that is using the resource that you are
        /// trying to delete.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the resource that is using the resource that you are
        /// trying to delete.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceReference`](crate::model::ResourceReference)
        pub fn build(self) -> crate::model::ResourceReference {
            crate::model::ResourceReference {
                name: self.name,
                version: self.version,
            }
        }
    }
}
impl ResourceReference {
    /// Creates a new builder-style object to manufacture [`ResourceReference`](crate::model::ResourceReference)
    pub fn builder() -> crate::model::resource_reference::Builder {
        crate::model::resource_reference::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReferenceType {
    #[allow(missing_docs)] // documentation missing in model
    Bot,
    #[allow(missing_docs)] // documentation missing in model
    Botalias,
    #[allow(missing_docs)] // documentation missing in model
    Botchannel,
    #[allow(missing_docs)] // documentation missing in model
    Intent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReferenceType {
    fn from(s: &str) -> Self {
        match s {
            "Bot" => ReferenceType::Bot,
            "BotAlias" => ReferenceType::Botalias,
            "BotChannel" => ReferenceType::Botchannel,
            "Intent" => ReferenceType::Intent,
            other => ReferenceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReferenceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReferenceType::from(s))
    }
}
impl ReferenceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReferenceType::Bot => "Bot",
            ReferenceType::Botalias => "BotAlias",
            ReferenceType::Botchannel => "BotChannel",
            ReferenceType::Intent => "Intent",
            ReferenceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Bot", "BotAlias", "BotChannel", "Intent"]
    }
}
impl AsRef<str> for ReferenceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
