// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateBotVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bot_version`](crate::client::Client::create_bot_version).
///
/// See [`crate::client::fluent_builders::CreateBotVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBotVersion {
    _private: (),
}
impl CreateBotVersion {
    /// Creates a new builder-style object to manufacture [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    pub fn builder() -> crate::input::create_bot_version_input::Builder {
        crate::input::create_bot_version_input::Builder::default()
    }
    /// Creates a new `CreateBotVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBotVersion {
    type Output = std::result::Result<
        crate::output::CreateBotVersionOutput,
        crate::error::CreateBotVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_bot_version_error(response)
        } else {
            crate::operation_deser::parse_create_bot_version_response(response)
        }
    }
}

/// Operation shape for `CreateIntentVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_intent_version`](crate::client::Client::create_intent_version).
///
/// See [`crate::client::fluent_builders::CreateIntentVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIntentVersion {
    _private: (),
}
impl CreateIntentVersion {
    /// Creates a new builder-style object to manufacture [`CreateIntentVersionInput`](crate::input::CreateIntentVersionInput)
    pub fn builder() -> crate::input::create_intent_version_input::Builder {
        crate::input::create_intent_version_input::Builder::default()
    }
    /// Creates a new `CreateIntentVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIntentVersion {
    type Output = std::result::Result<
        crate::output::CreateIntentVersionOutput,
        crate::error::CreateIntentVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_intent_version_error(response)
        } else {
            crate::operation_deser::parse_create_intent_version_response(response)
        }
    }
}

/// Operation shape for `CreateSlotTypeVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_slot_type_version`](crate::client::Client::create_slot_type_version).
///
/// See [`crate::client::fluent_builders::CreateSlotTypeVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSlotTypeVersion {
    _private: (),
}
impl CreateSlotTypeVersion {
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeVersionInput`](crate::input::CreateSlotTypeVersionInput)
    pub fn builder() -> crate::input::create_slot_type_version_input::Builder {
        crate::input::create_slot_type_version_input::Builder::default()
    }
    /// Creates a new `CreateSlotTypeVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSlotTypeVersion {
    type Output = std::result::Result<
        crate::output::CreateSlotTypeVersionOutput,
        crate::error::CreateSlotTypeVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_slot_type_version_error(response)
        } else {
            crate::operation_deser::parse_create_slot_type_version_response(response)
        }
    }
}

/// Operation shape for `DeleteBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot`](crate::client::Client::delete_bot).
///
/// See [`crate::client::fluent_builders::DeleteBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBot {
    _private: (),
}
impl DeleteBot {
    /// Creates a new builder-style object to manufacture [`DeleteBotInput`](crate::input::DeleteBotInput)
    pub fn builder() -> crate::input::delete_bot_input::Builder {
        crate::input::delete_bot_input::Builder::default()
    }
    /// Creates a new `DeleteBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBot {
    type Output = std::result::Result<crate::output::DeleteBotOutput, crate::error::DeleteBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bot_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_response(response)
        }
    }
}

/// Operation shape for `DeleteBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_alias`](crate::client::Client::delete_bot_alias).
///
/// See [`crate::client::fluent_builders::DeleteBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotAlias {
    _private: (),
}
impl DeleteBotAlias {
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    pub fn builder() -> crate::input::delete_bot_alias_input::Builder {
        crate::input::delete_bot_alias_input::Builder::default()
    }
    /// Creates a new `DeleteBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotAlias {
    type Output =
        std::result::Result<crate::output::DeleteBotAliasOutput, crate::error::DeleteBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteBotChannelAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_channel_association`](crate::client::Client::delete_bot_channel_association).
///
/// See [`crate::client::fluent_builders::DeleteBotChannelAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotChannelAssociation {
    _private: (),
}
impl DeleteBotChannelAssociation {
    /// Creates a new builder-style object to manufacture [`DeleteBotChannelAssociationInput`](crate::input::DeleteBotChannelAssociationInput)
    pub fn builder() -> crate::input::delete_bot_channel_association_input::Builder {
        crate::input::delete_bot_channel_association_input::Builder::default()
    }
    /// Creates a new `DeleteBotChannelAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotChannelAssociation {
    type Output = std::result::Result<
        crate::output::DeleteBotChannelAssociationOutput,
        crate::error::DeleteBotChannelAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bot_channel_association_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_channel_association_response(response)
        }
    }
}

/// Operation shape for `DeleteBotVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bot_version`](crate::client::Client::delete_bot_version).
///
/// See [`crate::client::fluent_builders::DeleteBotVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBotVersion {
    _private: (),
}
impl DeleteBotVersion {
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    pub fn builder() -> crate::input::delete_bot_version_input::Builder {
        crate::input::delete_bot_version_input::Builder::default()
    }
    /// Creates a new `DeleteBotVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBotVersion {
    type Output = std::result::Result<
        crate::output::DeleteBotVersionOutput,
        crate::error::DeleteBotVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_bot_version_error(response)
        } else {
            crate::operation_deser::parse_delete_bot_version_response(response)
        }
    }
}

/// Operation shape for `DeleteIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_intent`](crate::client::Client::delete_intent).
///
/// See [`crate::client::fluent_builders::DeleteIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntent {
    _private: (),
}
impl DeleteIntent {
    /// Creates a new builder-style object to manufacture [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    pub fn builder() -> crate::input::delete_intent_input::Builder {
        crate::input::delete_intent_input::Builder::default()
    }
    /// Creates a new `DeleteIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntent {
    type Output =
        std::result::Result<crate::output::DeleteIntentOutput, crate::error::DeleteIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_intent_error(response)
        } else {
            crate::operation_deser::parse_delete_intent_response(response)
        }
    }
}

/// Operation shape for `DeleteIntentVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_intent_version`](crate::client::Client::delete_intent_version).
///
/// See [`crate::client::fluent_builders::DeleteIntentVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntentVersion {
    _private: (),
}
impl DeleteIntentVersion {
    /// Creates a new builder-style object to manufacture [`DeleteIntentVersionInput`](crate::input::DeleteIntentVersionInput)
    pub fn builder() -> crate::input::delete_intent_version_input::Builder {
        crate::input::delete_intent_version_input::Builder::default()
    }
    /// Creates a new `DeleteIntentVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntentVersion {
    type Output = std::result::Result<
        crate::output::DeleteIntentVersionOutput,
        crate::error::DeleteIntentVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_intent_version_error(response)
        } else {
            crate::operation_deser::parse_delete_intent_version_response(response)
        }
    }
}

/// Operation shape for `DeleteSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_slot_type`](crate::client::Client::delete_slot_type).
///
/// See [`crate::client::fluent_builders::DeleteSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSlotType {
    _private: (),
}
impl DeleteSlotType {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    pub fn builder() -> crate::input::delete_slot_type_input::Builder {
        crate::input::delete_slot_type_input::Builder::default()
    }
    /// Creates a new `DeleteSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSlotType {
    type Output =
        std::result::Result<crate::output::DeleteSlotTypeOutput, crate::error::DeleteSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_slot_type_error(response)
        } else {
            crate::operation_deser::parse_delete_slot_type_response(response)
        }
    }
}

/// Operation shape for `DeleteSlotTypeVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_slot_type_version`](crate::client::Client::delete_slot_type_version).
///
/// See [`crate::client::fluent_builders::DeleteSlotTypeVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSlotTypeVersion {
    _private: (),
}
impl DeleteSlotTypeVersion {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeVersionInput`](crate::input::DeleteSlotTypeVersionInput)
    pub fn builder() -> crate::input::delete_slot_type_version_input::Builder {
        crate::input::delete_slot_type_version_input::Builder::default()
    }
    /// Creates a new `DeleteSlotTypeVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSlotTypeVersion {
    type Output = std::result::Result<
        crate::output::DeleteSlotTypeVersionOutput,
        crate::error::DeleteSlotTypeVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_slot_type_version_error(response)
        } else {
            crate::operation_deser::parse_delete_slot_type_version_response(response)
        }
    }
}

/// Operation shape for `DeleteUtterances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_utterances`](crate::client::Client::delete_utterances).
///
/// See [`crate::client::fluent_builders::DeleteUtterances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUtterances {
    _private: (),
}
impl DeleteUtterances {
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    pub fn builder() -> crate::input::delete_utterances_input::Builder {
        crate::input::delete_utterances_input::Builder::default()
    }
    /// Creates a new `DeleteUtterances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUtterances {
    type Output = std::result::Result<
        crate::output::DeleteUtterancesOutput,
        crate::error::DeleteUtterancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_utterances_error(response)
        } else {
            crate::operation_deser::parse_delete_utterances_response(response)
        }
    }
}

/// Operation shape for `GetBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot`](crate::client::Client::get_bot).
///
/// See [`crate::client::fluent_builders::GetBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBot {
    _private: (),
}
impl GetBot {
    /// Creates a new builder-style object to manufacture [`GetBotInput`](crate::input::GetBotInput)
    pub fn builder() -> crate::input::get_bot_input::Builder {
        crate::input::get_bot_input::Builder::default()
    }
    /// Creates a new `GetBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBot {
    type Output = std::result::Result<crate::output::GetBotOutput, crate::error::GetBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_error(response)
        } else {
            crate::operation_deser::parse_get_bot_response(response)
        }
    }
}

/// Operation shape for `GetBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot_alias`](crate::client::Client::get_bot_alias).
///
/// See [`crate::client::fluent_builders::GetBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBotAlias {
    _private: (),
}
impl GetBotAlias {
    /// Creates a new builder-style object to manufacture [`GetBotAliasInput`](crate::input::GetBotAliasInput)
    pub fn builder() -> crate::input::get_bot_alias_input::Builder {
        crate::input::get_bot_alias_input::Builder::default()
    }
    /// Creates a new `GetBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBotAlias {
    type Output =
        std::result::Result<crate::output::GetBotAliasOutput, crate::error::GetBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_get_bot_alias_response(response)
        }
    }
}

/// Operation shape for `GetBotAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot_aliases`](crate::client::Client::get_bot_aliases).
///
/// See [`crate::client::fluent_builders::GetBotAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBotAliases {
    _private: (),
}
impl GetBotAliases {
    /// Creates a new builder-style object to manufacture [`GetBotAliasesInput`](crate::input::GetBotAliasesInput)
    pub fn builder() -> crate::input::get_bot_aliases_input::Builder {
        crate::input::get_bot_aliases_input::Builder::default()
    }
    /// Creates a new `GetBotAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBotAliases {
    type Output =
        std::result::Result<crate::output::GetBotAliasesOutput, crate::error::GetBotAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_aliases_error(response)
        } else {
            crate::operation_deser::parse_get_bot_aliases_response(response)
        }
    }
}

/// Operation shape for `GetBotChannelAssociation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot_channel_association`](crate::client::Client::get_bot_channel_association).
///
/// See [`crate::client::fluent_builders::GetBotChannelAssociation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBotChannelAssociation {
    _private: (),
}
impl GetBotChannelAssociation {
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationInput`](crate::input::GetBotChannelAssociationInput)
    pub fn builder() -> crate::input::get_bot_channel_association_input::Builder {
        crate::input::get_bot_channel_association_input::Builder::default()
    }
    /// Creates a new `GetBotChannelAssociation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBotChannelAssociation {
    type Output = std::result::Result<
        crate::output::GetBotChannelAssociationOutput,
        crate::error::GetBotChannelAssociationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_channel_association_error(response)
        } else {
            crate::operation_deser::parse_get_bot_channel_association_response(response)
        }
    }
}

/// Operation shape for `GetBotChannelAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot_channel_associations`](crate::client::Client::get_bot_channel_associations).
///
/// See [`crate::client::fluent_builders::GetBotChannelAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBotChannelAssociations {
    _private: (),
}
impl GetBotChannelAssociations {
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationsInput`](crate::input::GetBotChannelAssociationsInput)
    pub fn builder() -> crate::input::get_bot_channel_associations_input::Builder {
        crate::input::get_bot_channel_associations_input::Builder::default()
    }
    /// Creates a new `GetBotChannelAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBotChannelAssociations {
    type Output = std::result::Result<
        crate::output::GetBotChannelAssociationsOutput,
        crate::error::GetBotChannelAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_channel_associations_error(response)
        } else {
            crate::operation_deser::parse_get_bot_channel_associations_response(response)
        }
    }
}

/// Operation shape for `GetBots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bots`](crate::client::Client::get_bots).
///
/// See [`crate::client::fluent_builders::GetBots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBots {
    _private: (),
}
impl GetBots {
    /// Creates a new builder-style object to manufacture [`GetBotsInput`](crate::input::GetBotsInput)
    pub fn builder() -> crate::input::get_bots_input::Builder {
        crate::input::get_bots_input::Builder::default()
    }
    /// Creates a new `GetBots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBots {
    type Output = std::result::Result<crate::output::GetBotsOutput, crate::error::GetBotsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bots_error(response)
        } else {
            crate::operation_deser::parse_get_bots_response(response)
        }
    }
}

/// Operation shape for `GetBotVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bot_versions`](crate::client::Client::get_bot_versions).
///
/// See [`crate::client::fluent_builders::GetBotVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBotVersions {
    _private: (),
}
impl GetBotVersions {
    /// Creates a new builder-style object to manufacture [`GetBotVersionsInput`](crate::input::GetBotVersionsInput)
    pub fn builder() -> crate::input::get_bot_versions_input::Builder {
        crate::input::get_bot_versions_input::Builder::default()
    }
    /// Creates a new `GetBotVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBotVersions {
    type Output =
        std::result::Result<crate::output::GetBotVersionsOutput, crate::error::GetBotVersionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bot_versions_error(response)
        } else {
            crate::operation_deser::parse_get_bot_versions_response(response)
        }
    }
}

/// Operation shape for `GetBuiltinIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_builtin_intent`](crate::client::Client::get_builtin_intent).
///
/// See [`crate::client::fluent_builders::GetBuiltinIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBuiltinIntent {
    _private: (),
}
impl GetBuiltinIntent {
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentInput`](crate::input::GetBuiltinIntentInput)
    pub fn builder() -> crate::input::get_builtin_intent_input::Builder {
        crate::input::get_builtin_intent_input::Builder::default()
    }
    /// Creates a new `GetBuiltinIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBuiltinIntent {
    type Output = std::result::Result<
        crate::output::GetBuiltinIntentOutput,
        crate::error::GetBuiltinIntentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_builtin_intent_error(response)
        } else {
            crate::operation_deser::parse_get_builtin_intent_response(response)
        }
    }
}

/// Operation shape for `GetBuiltinIntents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_builtin_intents`](crate::client::Client::get_builtin_intents).
///
/// See [`crate::client::fluent_builders::GetBuiltinIntents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBuiltinIntents {
    _private: (),
}
impl GetBuiltinIntents {
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentsInput`](crate::input::GetBuiltinIntentsInput)
    pub fn builder() -> crate::input::get_builtin_intents_input::Builder {
        crate::input::get_builtin_intents_input::Builder::default()
    }
    /// Creates a new `GetBuiltinIntents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBuiltinIntents {
    type Output = std::result::Result<
        crate::output::GetBuiltinIntentsOutput,
        crate::error::GetBuiltinIntentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_builtin_intents_error(response)
        } else {
            crate::operation_deser::parse_get_builtin_intents_response(response)
        }
    }
}

/// Operation shape for `GetBuiltinSlotTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_builtin_slot_types`](crate::client::Client::get_builtin_slot_types).
///
/// See [`crate::client::fluent_builders::GetBuiltinSlotTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBuiltinSlotTypes {
    _private: (),
}
impl GetBuiltinSlotTypes {
    /// Creates a new builder-style object to manufacture [`GetBuiltinSlotTypesInput`](crate::input::GetBuiltinSlotTypesInput)
    pub fn builder() -> crate::input::get_builtin_slot_types_input::Builder {
        crate::input::get_builtin_slot_types_input::Builder::default()
    }
    /// Creates a new `GetBuiltinSlotTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBuiltinSlotTypes {
    type Output = std::result::Result<
        crate::output::GetBuiltinSlotTypesOutput,
        crate::error::GetBuiltinSlotTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_builtin_slot_types_error(response)
        } else {
            crate::operation_deser::parse_get_builtin_slot_types_response(response)
        }
    }
}

/// Operation shape for `GetExport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_export`](crate::client::Client::get_export).
///
/// See [`crate::client::fluent_builders::GetExport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExport {
    _private: (),
}
impl GetExport {
    /// Creates a new builder-style object to manufacture [`GetExportInput`](crate::input::GetExportInput)
    pub fn builder() -> crate::input::get_export_input::Builder {
        crate::input::get_export_input::Builder::default()
    }
    /// Creates a new `GetExport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExport {
    type Output = std::result::Result<crate::output::GetExportOutput, crate::error::GetExportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_export_error(response)
        } else {
            crate::operation_deser::parse_get_export_response(response)
        }
    }
}

/// Operation shape for `GetImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_import`](crate::client::Client::get_import).
///
/// See [`crate::client::fluent_builders::GetImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImport {
    _private: (),
}
impl GetImport {
    /// Creates a new builder-style object to manufacture [`GetImportInput`](crate::input::GetImportInput)
    pub fn builder() -> crate::input::get_import_input::Builder {
        crate::input::get_import_input::Builder::default()
    }
    /// Creates a new `GetImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImport {
    type Output = std::result::Result<crate::output::GetImportOutput, crate::error::GetImportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_import_error(response)
        } else {
            crate::operation_deser::parse_get_import_response(response)
        }
    }
}

/// Operation shape for `GetIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_intent`](crate::client::Client::get_intent).
///
/// See [`crate::client::fluent_builders::GetIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntent {
    _private: (),
}
impl GetIntent {
    /// Creates a new builder-style object to manufacture [`GetIntentInput`](crate::input::GetIntentInput)
    pub fn builder() -> crate::input::get_intent_input::Builder {
        crate::input::get_intent_input::Builder::default()
    }
    /// Creates a new `GetIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntent {
    type Output = std::result::Result<crate::output::GetIntentOutput, crate::error::GetIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_intent_error(response)
        } else {
            crate::operation_deser::parse_get_intent_response(response)
        }
    }
}

/// Operation shape for `GetIntents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_intents`](crate::client::Client::get_intents).
///
/// See [`crate::client::fluent_builders::GetIntents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntents {
    _private: (),
}
impl GetIntents {
    /// Creates a new builder-style object to manufacture [`GetIntentsInput`](crate::input::GetIntentsInput)
    pub fn builder() -> crate::input::get_intents_input::Builder {
        crate::input::get_intents_input::Builder::default()
    }
    /// Creates a new `GetIntents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntents {
    type Output =
        std::result::Result<crate::output::GetIntentsOutput, crate::error::GetIntentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_intents_error(response)
        } else {
            crate::operation_deser::parse_get_intents_response(response)
        }
    }
}

/// Operation shape for `GetIntentVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_intent_versions`](crate::client::Client::get_intent_versions).
///
/// See [`crate::client::fluent_builders::GetIntentVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntentVersions {
    _private: (),
}
impl GetIntentVersions {
    /// Creates a new builder-style object to manufacture [`GetIntentVersionsInput`](crate::input::GetIntentVersionsInput)
    pub fn builder() -> crate::input::get_intent_versions_input::Builder {
        crate::input::get_intent_versions_input::Builder::default()
    }
    /// Creates a new `GetIntentVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntentVersions {
    type Output = std::result::Result<
        crate::output::GetIntentVersionsOutput,
        crate::error::GetIntentVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_intent_versions_error(response)
        } else {
            crate::operation_deser::parse_get_intent_versions_response(response)
        }
    }
}

/// Operation shape for `GetMigration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_migration`](crate::client::Client::get_migration).
///
/// See [`crate::client::fluent_builders::GetMigration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMigration {
    _private: (),
}
impl GetMigration {
    /// Creates a new builder-style object to manufacture [`GetMigrationInput`](crate::input::GetMigrationInput)
    pub fn builder() -> crate::input::get_migration_input::Builder {
        crate::input::get_migration_input::Builder::default()
    }
    /// Creates a new `GetMigration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMigration {
    type Output =
        std::result::Result<crate::output::GetMigrationOutput, crate::error::GetMigrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_migration_error(response)
        } else {
            crate::operation_deser::parse_get_migration_response(response)
        }
    }
}

/// Operation shape for `GetMigrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_migrations`](crate::client::Client::get_migrations).
///
/// See [`crate::client::fluent_builders::GetMigrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMigrations {
    _private: (),
}
impl GetMigrations {
    /// Creates a new builder-style object to manufacture [`GetMigrationsInput`](crate::input::GetMigrationsInput)
    pub fn builder() -> crate::input::get_migrations_input::Builder {
        crate::input::get_migrations_input::Builder::default()
    }
    /// Creates a new `GetMigrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMigrations {
    type Output =
        std::result::Result<crate::output::GetMigrationsOutput, crate::error::GetMigrationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_migrations_error(response)
        } else {
            crate::operation_deser::parse_get_migrations_response(response)
        }
    }
}

/// Operation shape for `GetSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_slot_type`](crate::client::Client::get_slot_type).
///
/// See [`crate::client::fluent_builders::GetSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSlotType {
    _private: (),
}
impl GetSlotType {
    /// Creates a new builder-style object to manufacture [`GetSlotTypeInput`](crate::input::GetSlotTypeInput)
    pub fn builder() -> crate::input::get_slot_type_input::Builder {
        crate::input::get_slot_type_input::Builder::default()
    }
    /// Creates a new `GetSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSlotType {
    type Output =
        std::result::Result<crate::output::GetSlotTypeOutput, crate::error::GetSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_slot_type_error(response)
        } else {
            crate::operation_deser::parse_get_slot_type_response(response)
        }
    }
}

/// Operation shape for `GetSlotTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_slot_types`](crate::client::Client::get_slot_types).
///
/// See [`crate::client::fluent_builders::GetSlotTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSlotTypes {
    _private: (),
}
impl GetSlotTypes {
    /// Creates a new builder-style object to manufacture [`GetSlotTypesInput`](crate::input::GetSlotTypesInput)
    pub fn builder() -> crate::input::get_slot_types_input::Builder {
        crate::input::get_slot_types_input::Builder::default()
    }
    /// Creates a new `GetSlotTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSlotTypes {
    type Output =
        std::result::Result<crate::output::GetSlotTypesOutput, crate::error::GetSlotTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_slot_types_error(response)
        } else {
            crate::operation_deser::parse_get_slot_types_response(response)
        }
    }
}

/// Operation shape for `GetSlotTypeVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_slot_type_versions`](crate::client::Client::get_slot_type_versions).
///
/// See [`crate::client::fluent_builders::GetSlotTypeVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSlotTypeVersions {
    _private: (),
}
impl GetSlotTypeVersions {
    /// Creates a new builder-style object to manufacture [`GetSlotTypeVersionsInput`](crate::input::GetSlotTypeVersionsInput)
    pub fn builder() -> crate::input::get_slot_type_versions_input::Builder {
        crate::input::get_slot_type_versions_input::Builder::default()
    }
    /// Creates a new `GetSlotTypeVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSlotTypeVersions {
    type Output = std::result::Result<
        crate::output::GetSlotTypeVersionsOutput,
        crate::error::GetSlotTypeVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_slot_type_versions_error(response)
        } else {
            crate::operation_deser::parse_get_slot_type_versions_response(response)
        }
    }
}

/// Operation shape for `GetUtterancesView`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_utterances_view`](crate::client::Client::get_utterances_view).
///
/// See [`crate::client::fluent_builders::GetUtterancesView`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUtterancesView {
    _private: (),
}
impl GetUtterancesView {
    /// Creates a new builder-style object to manufacture [`GetUtterancesViewInput`](crate::input::GetUtterancesViewInput)
    pub fn builder() -> crate::input::get_utterances_view_input::Builder {
        crate::input::get_utterances_view_input::Builder::default()
    }
    /// Creates a new `GetUtterancesView` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUtterancesView {
    type Output = std::result::Result<
        crate::output::GetUtterancesViewOutput,
        crate::error::GetUtterancesViewError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_utterances_view_error(response)
        } else {
            crate::operation_deser::parse_get_utterances_view_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutBot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bot`](crate::client::Client::put_bot).
///
/// See [`crate::client::fluent_builders::PutBot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBot {
    _private: (),
}
impl PutBot {
    /// Creates a new builder-style object to manufacture [`PutBotInput`](crate::input::PutBotInput)
    pub fn builder() -> crate::input::put_bot_input::Builder {
        crate::input::put_bot_input::Builder::default()
    }
    /// Creates a new `PutBot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBot {
    type Output = std::result::Result<crate::output::PutBotOutput, crate::error::PutBotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bot_error(response)
        } else {
            crate::operation_deser::parse_put_bot_response(response)
        }
    }
}

/// Operation shape for `PutBotAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_bot_alias`](crate::client::Client::put_bot_alias).
///
/// See [`crate::client::fluent_builders::PutBotAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutBotAlias {
    _private: (),
}
impl PutBotAlias {
    /// Creates a new builder-style object to manufacture [`PutBotAliasInput`](crate::input::PutBotAliasInput)
    pub fn builder() -> crate::input::put_bot_alias_input::Builder {
        crate::input::put_bot_alias_input::Builder::default()
    }
    /// Creates a new `PutBotAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutBotAlias {
    type Output =
        std::result::Result<crate::output::PutBotAliasOutput, crate::error::PutBotAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_bot_alias_error(response)
        } else {
            crate::operation_deser::parse_put_bot_alias_response(response)
        }
    }
}

/// Operation shape for `PutIntent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_intent`](crate::client::Client::put_intent).
///
/// See [`crate::client::fluent_builders::PutIntent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutIntent {
    _private: (),
}
impl PutIntent {
    /// Creates a new builder-style object to manufacture [`PutIntentInput`](crate::input::PutIntentInput)
    pub fn builder() -> crate::input::put_intent_input::Builder {
        crate::input::put_intent_input::Builder::default()
    }
    /// Creates a new `PutIntent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutIntent {
    type Output = std::result::Result<crate::output::PutIntentOutput, crate::error::PutIntentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_intent_error(response)
        } else {
            crate::operation_deser::parse_put_intent_response(response)
        }
    }
}

/// Operation shape for `PutSlotType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_slot_type`](crate::client::Client::put_slot_type).
///
/// See [`crate::client::fluent_builders::PutSlotType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSlotType {
    _private: (),
}
impl PutSlotType {
    /// Creates a new builder-style object to manufacture [`PutSlotTypeInput`](crate::input::PutSlotTypeInput)
    pub fn builder() -> crate::input::put_slot_type_input::Builder {
        crate::input::put_slot_type_input::Builder::default()
    }
    /// Creates a new `PutSlotType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSlotType {
    type Output =
        std::result::Result<crate::output::PutSlotTypeOutput, crate::error::PutSlotTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_slot_type_error(response)
        } else {
            crate::operation_deser::parse_put_slot_type_response(response)
        }
    }
}

/// Operation shape for `StartImport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_import`](crate::client::Client::start_import).
///
/// See [`crate::client::fluent_builders::StartImport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImport {
    _private: (),
}
impl StartImport {
    /// Creates a new builder-style object to manufacture [`StartImportInput`](crate::input::StartImportInput)
    pub fn builder() -> crate::input::start_import_input::Builder {
        crate::input::start_import_input::Builder::default()
    }
    /// Creates a new `StartImport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImport {
    type Output =
        std::result::Result<crate::output::StartImportOutput, crate::error::StartImportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_start_import_error(response)
        } else {
            crate::operation_deser::parse_start_import_response(response)
        }
    }
}

/// Operation shape for `StartMigration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_migration`](crate::client::Client::start_migration).
///
/// See [`crate::client::fluent_builders::StartMigration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMigration {
    _private: (),
}
impl StartMigration {
    /// Creates a new builder-style object to manufacture [`StartMigrationInput`](crate::input::StartMigrationInput)
    pub fn builder() -> crate::input::start_migration_input::Builder {
        crate::input::start_migration_input::Builder::default()
    }
    /// Creates a new `StartMigration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMigration {
    type Output =
        std::result::Result<crate::output::StartMigrationOutput, crate::error::StartMigrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_migration_error(response)
        } else {
            crate::operation_deser::parse_start_migration_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
