// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBotVersionError {
    /// Kind of error that occurred.
    pub kind: CreateBotVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBotVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBotVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBotVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateBotVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBotVersionError {
    fn code(&self) -> Option<&str> {
        CreateBotVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBotVersionError {
    /// Creates a new `CreateBotVersionError`.
    pub fn new(kind: CreateBotVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBotVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBotVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBotVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBotVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateBotVersionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateBotVersionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateBotVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBotVersionErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for CreateBotVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBotVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateBotVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIntentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIntentVersionError {
    /// Kind of error that occurred.
    pub kind: CreateIntentVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIntentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIntentVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIntentVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIntentVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateIntentVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIntentVersionError {
    fn code(&self) -> Option<&str> {
        CreateIntentVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIntentVersionError {
    /// Creates a new `CreateIntentVersionError`.
    pub fn new(kind: CreateIntentVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIntentVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIntentVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIntentVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIntentVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntentVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntentVersionErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for CreateIntentVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIntentVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateIntentVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSlotTypeVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSlotTypeVersionError {
    /// Kind of error that occurred.
    pub kind: CreateSlotTypeVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSlotTypeVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSlotTypeVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSlotTypeVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSlotTypeVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            CreateSlotTypeVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSlotTypeVersionError {
    fn code(&self) -> Option<&str> {
        CreateSlotTypeVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSlotTypeVersionError {
    /// Creates a new `CreateSlotTypeVersionError`.
    pub fn new(kind: CreateSlotTypeVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSlotTypeVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSlotTypeVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSlotTypeVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSlotTypeVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSlotTypeVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSlotTypeVersionErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for CreateSlotTypeVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSlotTypeVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            CreateSlotTypeVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotError {
    /// Kind of error that occurred.
    pub kind: DeleteBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotError {
    fn code(&self) -> Option<&str> {
        DeleteBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotError {
    /// Creates a new `DeleteBotError`.
    pub fn new(kind: DeleteBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotErrorKind::ResourceInUseException(_))
    }
}
impl std::error::Error for DeleteBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBotErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBotErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteBotErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBotErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotAliasErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotAliasErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotAliasError {
    fn code(&self) -> Option<&str> {
        DeleteBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotAliasError {
    /// Creates a new `DeleteBotAliasError`.
    pub fn new(kind: DeleteBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotAliasErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotAliasErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotAliasErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotAliasErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotChannelAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotChannelAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteBotChannelAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotChannelAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotChannelAssociationErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotChannelAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotChannelAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBotChannelAssociationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotChannelAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBotChannelAssociationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteBotChannelAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBotChannelAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotChannelAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteBotChannelAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotChannelAssociationError {
    /// Creates a new `DeleteBotChannelAssociationError`.
    pub fn new(kind: DeleteBotChannelAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotChannelAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotChannelAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotChannelAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotChannelAssociationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotChannelAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotChannelAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotChannelAssociationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotChannelAssociationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotChannelAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotChannelAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotChannelAssociationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotChannelAssociationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotChannelAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotChannelAssociationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteBotChannelAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotChannelAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBotChannelAssociationErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotChannelAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBotChannelAssociationErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteBotChannelAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBotChannelAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBotVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteBotVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBotVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBotVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBotVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBotVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteBotVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBotVersionError {
    fn code(&self) -> Option<&str> {
        DeleteBotVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBotVersionError {
    /// Creates a new `DeleteBotVersionError`.
    pub fn new(kind: DeleteBotVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBotVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBotVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBotVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBotVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotVersionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBotVersionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBotVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBotVersionErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteBotVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBotVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteBotVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntentError {
    /// Kind of error that occurred.
    pub kind: DeleteIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntentErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntentError {
    fn code(&self) -> Option<&str> {
        DeleteIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntentError {
    /// Creates a new `DeleteIntentError`.
    pub fn new(kind: DeleteIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteIntentErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteIntentErrorKind::ResourceInUseException(_))
    }
}
impl std::error::Error for DeleteIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntentErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIntentErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIntentErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteIntentErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteIntentErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntentErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntentVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteIntentVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntentVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntentVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntentVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntentVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteIntentVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntentVersionError {
    fn code(&self) -> Option<&str> {
        DeleteIntentVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntentVersionError {
    /// Creates a new `DeleteIntentVersionError`.
    pub fn new(kind: DeleteIntentVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntentVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntentVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntentVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntentVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntentVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntentVersionErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteIntentVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntentVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteIntentVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSlotTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSlotTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSlotTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSlotTypeError {
    fn code(&self) -> Option<&str> {
        DeleteSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSlotTypeError {
    /// Creates a new `DeleteSlotTypeError`.
    pub fn new(kind: DeleteSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteSlotTypeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSlotTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSlotTypeVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSlotTypeVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteSlotTypeVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSlotTypeVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSlotTypeVersionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
    /// <p>The body of the exception contains a JSON object that describes the resource.</p>
    /// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
    /// <p> <code>"resourceReference": {</code> </p>
    /// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSlotTypeVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSlotTypeVersionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSlotTypeVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSlotTypeVersionError {
    fn code(&self) -> Option<&str> {
        DeleteSlotTypeVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSlotTypeVersionError {
    /// Creates a new `DeleteSlotTypeVersionError`.
    pub fn new(kind: DeleteSlotTypeVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSlotTypeVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSlotTypeVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSlotTypeVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSlotTypeVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSlotTypeVersionErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSlotTypeVersionErrorKind::ResourceInUseException(_)
        )
    }
}
impl std::error::Error for DeleteSlotTypeVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSlotTypeVersionErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSlotTypeVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUtterancesError {
    /// Kind of error that occurred.
    pub kind: DeleteUtterancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUtterances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUtterancesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUtterancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUtterancesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteUtterancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUtterancesError {
    fn code(&self) -> Option<&str> {
        DeleteUtterancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUtterancesError {
    /// Creates a new `DeleteUtterancesError`.
    pub fn new(kind: DeleteUtterancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUtterancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUtterancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUtterancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUtterancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUtterancesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUtterancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteUtterancesErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for DeleteUtterancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUtterancesErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteUtterancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotError {
    /// Kind of error that occurred.
    pub kind: GetBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotError {
    fn code(&self) -> Option<&str> {
        GetBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotError {
    /// Creates a new `GetBotError`.
    pub fn new(kind: GetBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetBotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBotErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotAliasError {
    /// Kind of error that occurred.
    pub kind: GetBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotAliasErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotAliasErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotAliasErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotAliasError {
    fn code(&self) -> Option<&str> {
        GetBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotAliasError {
    /// Creates a new `GetBotAliasError`.
    pub fn new(kind: GetBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotAliasErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotAliasErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetBotAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetBotAliasErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBotAliasErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotAliasErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotAliasErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBotAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotAliasesError {
    /// Kind of error that occurred.
    pub kind: GetBotAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBotAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotAliasesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotAliasesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotAliasesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotAliasesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotAliasesError {
    fn code(&self) -> Option<&str> {
        GetBotAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotAliasesError {
    /// Creates a new `GetBotAliasesError`.
    pub fn new(kind: GetBotAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotAliasesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotAliasesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotAliasesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotAliasesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotAliasesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotAliasesErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetBotAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotAliasesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotAliasesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotAliasesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBotChannelAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotChannelAssociationError {
    /// Kind of error that occurred.
    pub kind: GetBotChannelAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBotChannelAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotChannelAssociationErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotChannelAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotChannelAssociationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotChannelAssociationError {
    fn code(&self) -> Option<&str> {
        GetBotChannelAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotChannelAssociationError {
    /// Creates a new `GetBotChannelAssociationError`.
    pub fn new(kind: GetBotChannelAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotChannelAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotChannelAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotChannelAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotChannelAssociationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetBotChannelAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotChannelAssociationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotChannelAssociationErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotChannelAssociationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotChannelAssociationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotChannelAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBotChannelAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotChannelAssociationsError {
    /// Kind of error that occurred.
    pub kind: GetBotChannelAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBotChannelAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotChannelAssociationsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotChannelAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotChannelAssociationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotChannelAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotChannelAssociationsError {
    fn code(&self) -> Option<&str> {
        GetBotChannelAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotChannelAssociationsError {
    /// Creates a new `GetBotChannelAssociationsError`.
    pub fn new(kind: GetBotChannelAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotChannelAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotChannelAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotChannelAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotChannelAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotChannelAssociationsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotChannelAssociationsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetBotChannelAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotChannelAssociationsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotChannelAssociationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotChannelAssociationsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotChannelAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotsError {
    /// Kind of error that occurred.
    pub kind: GetBotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotsError {
    fn code(&self) -> Option<&str> {
        GetBotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotsError {
    /// Creates a new `GetBotsError`.
    pub fn new(kind: GetBotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetBotsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetBotsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetBotsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetBotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBotsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetBotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBotVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBotVersionsError {
    /// Kind of error that occurred.
    pub kind: GetBotVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBotVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBotVersionsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBotVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBotVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBotVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBotVersionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBotVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBotVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBotVersionsError {
    fn code(&self) -> Option<&str> {
        GetBotVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBotVersionsError {
    /// Creates a new `GetBotVersionsError`.
    pub fn new(kind: GetBotVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBotVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBotVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBotVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBotVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBotVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetBotVersionsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetBotVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotVersionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBotVersionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBotVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBotVersionsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetBotVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBotVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBotVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBotVersionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBotVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBotVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBuiltinIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBuiltinIntentError {
    /// Kind of error that occurred.
    pub kind: GetBuiltinIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBuiltinIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBuiltinIntentErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBuiltinIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBuiltinIntentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBuiltinIntentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBuiltinIntentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBuiltinIntentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBuiltinIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBuiltinIntentError {
    fn code(&self) -> Option<&str> {
        GetBuiltinIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBuiltinIntentError {
    /// Creates a new `GetBuiltinIntentError`.
    pub fn new(kind: GetBuiltinIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBuiltinIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBuiltinIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBuiltinIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBuiltinIntentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBuiltinIntentErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetBuiltinIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBuiltinIntentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBuiltinIntentErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBuiltinIntentErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBuiltinIntentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBuiltinIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBuiltinIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBuiltinIntentsError {
    /// Kind of error that occurred.
    pub kind: GetBuiltinIntentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBuiltinIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBuiltinIntentsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBuiltinIntentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBuiltinIntentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBuiltinIntentsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBuiltinIntentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBuiltinIntentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBuiltinIntentsError {
    fn code(&self) -> Option<&str> {
        GetBuiltinIntentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBuiltinIntentsError {
    /// Creates a new `GetBuiltinIntentsError`.
    pub fn new(kind: GetBuiltinIntentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBuiltinIntentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBuiltinIntentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBuiltinIntentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBuiltinIntentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinIntentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinIntentsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetBuiltinIntentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBuiltinIntentsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBuiltinIntentsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBuiltinIntentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBuiltinIntentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBuiltinSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBuiltinSlotTypesError {
    /// Kind of error that occurred.
    pub kind: GetBuiltinSlotTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBuiltinSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBuiltinSlotTypesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBuiltinSlotTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBuiltinSlotTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetBuiltinSlotTypesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetBuiltinSlotTypesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetBuiltinSlotTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBuiltinSlotTypesError {
    fn code(&self) -> Option<&str> {
        GetBuiltinSlotTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBuiltinSlotTypesError {
    /// Creates a new `GetBuiltinSlotTypesError`.
    pub fn new(kind: GetBuiltinSlotTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBuiltinSlotTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBuiltinSlotTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBuiltinSlotTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBuiltinSlotTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBuiltinSlotTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinSlotTypesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinSlotTypesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinSlotTypesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBuiltinSlotTypesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBuiltinSlotTypesErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetBuiltinSlotTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBuiltinSlotTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetBuiltinSlotTypesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetBuiltinSlotTypesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetBuiltinSlotTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExportError {
    /// Kind of error that occurred.
    pub kind: GetExportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExportErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetExportErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetExportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetExportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetExportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExportError {
    fn code(&self) -> Option<&str> {
        GetExportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExportError {
    /// Creates a new `GetExportError`.
    pub fn new(kind: GetExportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetExportErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetExportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetExportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetExportErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetExportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExportErrorKind::BadRequestException(_inner) => Some(_inner),
            GetExportErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetExportErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetExportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetExportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetImportError {
    /// Kind of error that occurred.
    pub kind: GetImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetImportErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetImportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetImportErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetImportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetImportErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetImportError {
    fn code(&self) -> Option<&str> {
        GetImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetImportError {
    /// Creates a new `GetImportError`.
    pub fn new(kind: GetImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetImportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetImportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetImportErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetImportErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetImportErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetImportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetImportErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetImportErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetImportErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetImportErrorKind::BadRequestException(_inner) => Some(_inner),
            GetImportErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetImportErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetImportErrorKind::NotFoundException(_inner) => Some(_inner),
            GetImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntentError {
    /// Kind of error that occurred.
    pub kind: GetIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntentErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetIntentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetIntentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntentError {
    fn code(&self) -> Option<&str> {
        GetIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntentError {
    /// Creates a new `GetIntentError`.
    pub fn new(kind: GetIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIntentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIntentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetIntentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetIntentErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetIntentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetIntentErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetIntentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntentErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntentErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntentErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetIntentErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetIntentErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntentsError {
    /// Kind of error that occurred.
    pub kind: GetIntentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntentsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntentsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntentsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetIntentsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetIntentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntentsError {
    fn code(&self) -> Option<&str> {
        GetIntentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntentsError {
    /// Creates a new `GetIntentsError`.
    pub fn new(kind: GetIntentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntentsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIntentsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIntentsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetIntentsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetIntentsErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `GetIntentsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetIntentsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetIntentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntentsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetIntentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntentsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntentsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetIntentsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetIntentsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntentVersionsError {
    /// Kind of error that occurred.
    pub kind: GetIntentVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntentVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntentVersionsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntentVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntentVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntentVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetIntentVersionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetIntentVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntentVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntentVersionsError {
    fn code(&self) -> Option<&str> {
        GetIntentVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntentVersionsError {
    /// Creates a new `GetIntentVersionsError`.
    pub fn new(kind: GetIntentVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntentVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntentVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntentVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntentVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetIntentVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntentVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIntentVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntentVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIntentVersionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntentVersionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetIntentVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetIntentVersionsErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetIntentVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntentVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntentVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetIntentVersionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetIntentVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntentVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMigration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMigrationError {
    /// Kind of error that occurred.
    pub kind: GetMigrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMigration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMigrationErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMigrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMigrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMigrationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetMigrationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetMigrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetMigrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMigrationError {
    fn code(&self) -> Option<&str> {
        GetMigrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMigrationError {
    /// Creates a new `GetMigrationError`.
    pub fn new(kind: GetMigrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMigrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMigrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMigrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMigrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMigrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMigrationErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMigrationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMigrationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMigrationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetMigrationErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetMigrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMigrationErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetMigrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMigrationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMigrationErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetMigrationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetMigrationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetMigrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMigrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMigrationsError {
    /// Kind of error that occurred.
    pub kind: GetMigrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMigrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMigrationsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMigrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMigrationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMigrationsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetMigrationsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetMigrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMigrationsError {
    fn code(&self) -> Option<&str> {
        GetMigrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMigrationsError {
    /// Creates a new `GetMigrationsError`.
    pub fn new(kind: GetMigrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMigrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMigrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMigrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMigrationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMigrationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMigrationsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMigrationsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMigrationsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMigrationsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMigrationsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetMigrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMigrationsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMigrationsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetMigrationsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetMigrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSlotTypeError {
    /// Kind of error that occurred.
    pub kind: GetSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSlotTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSlotTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSlotTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSlotTypeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSlotTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSlotTypeError {
    fn code(&self) -> Option<&str> {
        GetSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSlotTypeError {
    /// Creates a new `GetSlotTypeError`.
    pub fn new(kind: GetSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSlotTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSlotTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSlotTypeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypeErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetSlotTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypeErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSlotTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSlotTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSlotTypeErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSlotTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSlotTypesError {
    /// Kind of error that occurred.
    pub kind: GetSlotTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSlotTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSlotTypesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSlotTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSlotTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSlotTypesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSlotTypesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSlotTypesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSlotTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSlotTypesError {
    fn code(&self) -> Option<&str> {
        GetSlotTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSlotTypesError {
    /// Creates a new `GetSlotTypesError`.
    pub fn new(kind: GetSlotTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSlotTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSlotTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSlotTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSlotTypesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSlotTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetSlotTypesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSlotTypesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypesErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetSlotTypesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetSlotTypesErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for GetSlotTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSlotTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSlotTypesErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSlotTypesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSlotTypesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSlotTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSlotTypeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSlotTypeVersionsError {
    /// Kind of error that occurred.
    pub kind: GetSlotTypeVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSlotTypeVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSlotTypeVersionsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSlotTypeVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSlotTypeVersionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSlotTypeVersionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSlotTypeVersionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSlotTypeVersionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSlotTypeVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSlotTypeVersionsError {
    fn code(&self) -> Option<&str> {
        GetSlotTypeVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSlotTypeVersionsError {
    /// Creates a new `GetSlotTypeVersionsError`.
    pub fn new(kind: GetSlotTypeVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSlotTypeVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSlotTypeVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSlotTypeVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSlotTypeVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSlotTypeVersionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypeVersionsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSlotTypeVersionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypeVersionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSlotTypeVersionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypeVersionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSlotTypeVersionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSlotTypeVersionsErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for GetSlotTypeVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSlotTypeVersionsErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSlotTypeVersionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSlotTypeVersionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSlotTypeVersionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSlotTypeVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUtterancesView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUtterancesViewError {
    /// Kind of error that occurred.
    pub kind: GetUtterancesViewErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUtterancesView` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUtterancesViewErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUtterancesViewError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUtterancesViewErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetUtterancesViewErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetUtterancesViewErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetUtterancesViewErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUtterancesViewError {
    fn code(&self) -> Option<&str> {
        GetUtterancesViewError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUtterancesViewError {
    /// Creates a new `GetUtterancesViewError`.
    pub fn new(kind: GetUtterancesViewErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUtterancesViewError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUtterancesViewErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUtterancesViewError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUtterancesViewErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUtterancesViewErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUtterancesViewErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUtterancesViewErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUtterancesViewErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUtterancesViewErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUtterancesViewErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetUtterancesViewError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUtterancesViewErrorKind::BadRequestException(_inner) => Some(_inner),
            GetUtterancesViewErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetUtterancesViewErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetUtterancesViewErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBotError {
    /// Kind of error that occurred.
    pub kind: PutBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBotErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBotErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutBotErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutBotErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutBotErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutBotErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PutBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBotError {
    fn code(&self) -> Option<&str> {
        PutBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBotError {
    /// Creates a new `PutBotError`.
    pub fn new(kind: PutBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBotErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutBotErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutBotErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutBotErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutBotErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, PutBotErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `PutBotErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutBotErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutBotErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(&self.kind, PutBotErrorKind::PreconditionFailedException(_))
    }
}
impl std::error::Error for PutBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBotErrorKind::BadRequestException(_inner) => Some(_inner),
            PutBotErrorKind::ConflictException(_inner) => Some(_inner),
            PutBotErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutBotErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutBotErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PutBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutBotAliasError {
    /// Kind of error that occurred.
    pub kind: PutBotAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutBotAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutBotAliasErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutBotAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutBotAliasErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutBotAliasErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutBotAliasErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutBotAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutBotAliasErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PutBotAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutBotAliasError {
    fn code(&self) -> Option<&str> {
        PutBotAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutBotAliasError {
    /// Creates a new `PutBotAliasError`.
    pub fn new(kind: PutBotAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutBotAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutBotAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutBotAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutBotAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutBotAliasErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutBotAliasErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutBotAliasErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutBotAliasErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutBotAliasErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBotAliasErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutBotAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutBotAliasErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutBotAliasErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutBotAliasErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for PutBotAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutBotAliasErrorKind::BadRequestException(_inner) => Some(_inner),
            PutBotAliasErrorKind::ConflictException(_inner) => Some(_inner),
            PutBotAliasErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutBotAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutBotAliasErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PutBotAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutIntentError {
    /// Kind of error that occurred.
    pub kind: PutIntentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutIntent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutIntentErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutIntentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutIntentErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutIntentErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutIntentErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutIntentErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutIntentErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PutIntentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutIntentError {
    fn code(&self) -> Option<&str> {
        PutIntentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutIntentError {
    /// Creates a new `PutIntentError`.
    pub fn new(kind: PutIntentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutIntentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutIntentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutIntentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutIntentErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutIntentErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutIntentErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutIntentErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutIntentErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutIntentErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, PutIntentErrorKind::InternalFailureException(_))
    }
    /// Returns `true` if the error kind is `PutIntentErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutIntentErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutIntentErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntentErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for PutIntentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutIntentErrorKind::BadRequestException(_inner) => Some(_inner),
            PutIntentErrorKind::ConflictException(_inner) => Some(_inner),
            PutIntentErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutIntentErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutIntentErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PutIntentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSlotTypeError {
    /// Kind of error that occurred.
    pub kind: PutSlotTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSlotType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSlotTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSlotTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSlotTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutSlotTypeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutSlotTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            PutSlotTypeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutSlotTypeErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PutSlotTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSlotTypeError {
    fn code(&self) -> Option<&str> {
        PutSlotTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSlotTypeError {
    /// Creates a new `PutSlotTypeError`.
    pub fn new(kind: PutSlotTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSlotTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSlotTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSlotTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSlotTypeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutSlotTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutSlotTypeErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutSlotTypeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutSlotTypeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutSlotTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSlotTypeErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSlotTypeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutSlotTypeErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutSlotTypeErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSlotTypeErrorKind::PreconditionFailedException(_)
        )
    }
}
impl std::error::Error for PutSlotTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSlotTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            PutSlotTypeErrorKind::ConflictException(_inner) => Some(_inner),
            PutSlotTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            PutSlotTypeErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutSlotTypeErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PutSlotTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImportError {
    /// Kind of error that occurred.
    pub kind: StartImportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImportErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImportErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartImportErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartImportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartImportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImportError {
    fn code(&self) -> Option<&str> {
        StartImportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImportError {
    /// Creates a new `StartImportError`.
    pub fn new(kind: StartImportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImportErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartImportErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for StartImportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImportErrorKind::BadRequestException(_inner) => Some(_inner),
            StartImportErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartImportErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartImportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMigration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMigrationError {
    /// Kind of error that occurred.
    pub kind: StartMigrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMigration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMigrationErrorKind {
    /// <p>Your IAM user or role does not have permission to call the Amazon Lex V2 APIs required to migrate your bot.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMigrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMigrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartMigrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartMigrationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartMigrationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartMigrationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartMigrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMigrationError {
    fn code(&self) -> Option<&str> {
        StartMigrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMigrationError {
    /// Creates a new `StartMigrationError`.
    pub fn new(kind: StartMigrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMigrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMigrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMigrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMigrationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMigrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMigrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMigrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartMigrationErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartMigrationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMigrationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMigrationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMigrationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMigrationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartMigrationErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for StartMigrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMigrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartMigrationErrorKind::BadRequestException(_inner) => Some(_inner),
            StartMigrationErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartMigrationErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartMigrationErrorKind::NotFoundException(_inner) => Some(_inner),
            StartMigrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p> There was a conflict processing the request. Try your request again. </p>
    ConflictException(crate::error::ConflictException),
    /// <p>An internal Amazon Lex error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The resource specified in the request was not found. Check the resource and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request exceeded a limit. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                retry_after_seconds: self.retry_after_seconds,
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>An internal Amazon Lex error occurred. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p> There was a conflict processing the request. Try your request again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The request is not well formed. For example, a value is invalid or a required field is missing. Check the field values, and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>Your IAM user or role does not have permission to call the Amazon Lex V2 APIs required to migrate your bot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p> The checksum of the resource that you are trying to change does not match the checksum in the request. Check the resource's checksum and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailedException {}
/// See [`PreconditionFailedException`](crate::error::PreconditionFailedException)
pub mod precondition_failed_exception {
    /// A builder for [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailedException`](crate::error::PreconditionFailedException)
        pub fn build(self) -> crate::error::PreconditionFailedException {
            crate::error::PreconditionFailedException {
                message: self.message,
            }
        }
    }
}
impl PreconditionFailedException {
    /// Creates a new builder-style object to manufacture [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    pub fn builder() -> crate::error::precondition_failed_exception::Builder {
        crate::error::precondition_failed_exception::Builder::default()
    }
}

/// <p>The resource that you are attempting to delete is referred to by another resource. Use this information to remove references to the resource that you are trying to delete.</p>
/// <p>The body of the exception contains a JSON object that describes the resource.</p>
/// <p> <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code> </p>
/// <p> <code>"resourceReference": {</code> </p>
/// <p> <code>"name": <i>string</i>, "version": <i>string</i> } }</code> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub reference_type: std::option::Option<crate::model::ReferenceType>,
    /// <p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>
    pub example_reference: std::option::Option<crate::model::ResourceReference>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn reference_type(&self) -> std::option::Option<&crate::model::ReferenceType> {
        self.reference_type.as_ref()
    }
    /// <p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>
    pub fn example_reference(&self) -> std::option::Option<&crate::model::ResourceReference> {
        self.example_reference.as_ref()
    }
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("reference_type", &self.reference_type);
        formatter.field("example_reference", &self.example_reference);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reference_type: std::option::Option<crate::model::ReferenceType>,
        pub(crate) example_reference: std::option::Option<crate::model::ResourceReference>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn reference_type(mut self, input: crate::model::ReferenceType) -> Self {
            self.reference_type = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reference_type(
            mut self,
            input: std::option::Option<crate::model::ReferenceType>,
        ) -> Self {
            self.reference_type = input;
            self
        }
        /// <p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>
        pub fn example_reference(mut self, input: crate::model::ResourceReference) -> Self {
            self.example_reference = Some(input);
            self
        }
        /// <p>Describes the resource that refers to the resource that you are attempting to delete. This object is returned as part of the <code>ResourceInUseException</code> exception. </p>
        pub fn set_example_reference(
            mut self,
            input: std::option::Option<crate::model::ResourceReference>,
        ) -> Self {
            self.example_reference = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                reference_type: self.reference_type,
                example_reference: self.example_reference,
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}
