// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMigrationOutput {
    /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    pub v1_bot_name: std::option::Option<std::string::String>,
    /// <p>The version of the bot to migrate to Amazon Lex V2. </p>
    pub v1_bot_version: std::option::Option<std::string::String>,
    /// <p>The locale used for the Amazon Lex V1 bot. </p>
    pub v1_bot_locale: std::option::Option<crate::model::Locale>,
    /// <p>The unique identifier for the Amazon Lex V2 bot. </p>
    pub v2_bot_id: std::option::Option<std::string::String>,
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub v2_bot_role: std::option::Option<std::string::String>,
    /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
    pub migration_id: std::option::Option<std::string::String>,
    /// <p>The strategy used to conduct the migration.</p>
    pub migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
    /// <p>The date and time that the migration started.</p>
    pub migration_timestamp: std::option::Option<aws_smithy_types::Instant>,
}
impl StartMigrationOutput {
    /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    pub fn v1_bot_name(&self) -> std::option::Option<&str> {
        self.v1_bot_name.as_deref()
    }
    /// <p>The version of the bot to migrate to Amazon Lex V2. </p>
    pub fn v1_bot_version(&self) -> std::option::Option<&str> {
        self.v1_bot_version.as_deref()
    }
    /// <p>The locale used for the Amazon Lex V1 bot. </p>
    pub fn v1_bot_locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.v1_bot_locale.as_ref()
    }
    /// <p>The unique identifier for the Amazon Lex V2 bot. </p>
    pub fn v2_bot_id(&self) -> std::option::Option<&str> {
        self.v2_bot_id.as_deref()
    }
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub fn v2_bot_role(&self) -> std::option::Option<&str> {
        self.v2_bot_role.as_deref()
    }
    /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
    pub fn migration_id(&self) -> std::option::Option<&str> {
        self.migration_id.as_deref()
    }
    /// <p>The strategy used to conduct the migration.</p>
    pub fn migration_strategy(&self) -> std::option::Option<&crate::model::MigrationStrategy> {
        self.migration_strategy.as_ref()
    }
    /// <p>The date and time that the migration started.</p>
    pub fn migration_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.migration_timestamp.as_ref()
    }
}
impl std::fmt::Debug for StartMigrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMigrationOutput");
        formatter.field("v1_bot_name", &self.v1_bot_name);
        formatter.field("v1_bot_version", &self.v1_bot_version);
        formatter.field("v1_bot_locale", &self.v1_bot_locale);
        formatter.field("v2_bot_id", &self.v2_bot_id);
        formatter.field("v2_bot_role", &self.v2_bot_role);
        formatter.field("migration_id", &self.migration_id);
        formatter.field("migration_strategy", &self.migration_strategy);
        formatter.field("migration_timestamp", &self.migration_timestamp);
        formatter.finish()
    }
}
/// See [`StartMigrationOutput`](crate::output::StartMigrationOutput)
pub mod start_migration_output {
    /// A builder for [`StartMigrationOutput`](crate::output::StartMigrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) v1_bot_name: std::option::Option<std::string::String>,
        pub(crate) v1_bot_version: std::option::Option<std::string::String>,
        pub(crate) v1_bot_locale: std::option::Option<crate::model::Locale>,
        pub(crate) v2_bot_id: std::option::Option<std::string::String>,
        pub(crate) v2_bot_role: std::option::Option<std::string::String>,
        pub(crate) migration_id: std::option::Option<std::string::String>,
        pub(crate) migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
        pub(crate) migration_timestamp: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn v1_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn set_v1_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v1_bot_name = input;
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. </p>
        pub fn v1_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. </p>
        pub fn set_v1_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.v1_bot_version = input;
            self
        }
        /// <p>The locale used for the Amazon Lex V1 bot. </p>
        pub fn v1_bot_locale(mut self, input: crate::model::Locale) -> Self {
            self.v1_bot_locale = Some(input);
            self
        }
        /// <p>The locale used for the Amazon Lex V1 bot. </p>
        pub fn set_v1_bot_locale(
            mut self,
            input: std::option::Option<crate::model::Locale>,
        ) -> Self {
            self.v1_bot_locale = input;
            self
        }
        /// <p>The unique identifier for the Amazon Lex V2 bot. </p>
        pub fn v2_bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Lex V2 bot. </p>
        pub fn set_v2_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_id = input;
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn v2_bot_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn set_v2_bot_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_role = input;
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
        pub fn migration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_id = Some(input.into());
            self
        }
        /// <p>The unique identifier that Amazon Lex assigned to the migration.</p>
        pub fn set_migration_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.migration_id = input;
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        pub fn migration_strategy(mut self, input: crate::model::MigrationStrategy) -> Self {
            self.migration_strategy = Some(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        pub fn set_migration_strategy(
            mut self,
            input: std::option::Option<crate::model::MigrationStrategy>,
        ) -> Self {
            self.migration_strategy = input;
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn migration_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.migration_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn set_migration_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.migration_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMigrationOutput`](crate::output::StartMigrationOutput)
        pub fn build(self) -> crate::output::StartMigrationOutput {
            crate::output::StartMigrationOutput {
                v1_bot_name: self.v1_bot_name,
                v1_bot_version: self.v1_bot_version,
                v1_bot_locale: self.v1_bot_locale,
                v2_bot_id: self.v2_bot_id,
                v2_bot_role: self.v2_bot_role,
                migration_id: self.migration_id,
                migration_strategy: self.migration_strategy,
                migration_timestamp: self.migration_timestamp,
            }
        }
    }
}
impl StartMigrationOutput {
    /// Creates a new builder-style object to manufacture [`StartMigrationOutput`](crate::output::StartMigrationOutput)
    pub fn builder() -> crate::output::start_migration_output::Builder {
        crate::output::start_migration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportOutput {
    /// <p>The name given to the import job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of resource to import.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The action to take when there is a merge conflict.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The identifier for the specific import job.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The status of the import job. If the status is <code>FAILED</code>,
    /// you can get the reason for the failure using the <code>GetImport</code>
    /// operation.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
    /// <p>A list of tags added to the imported bot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A timestamp for the date and time that the import job was
    /// requested.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl StartImportOutput {
    /// <p>The name given to the import job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of resource to import.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The action to take when there is a merge conflict.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The identifier for the specific import job.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>The status of the import job. If the status is <code>FAILED</code>,
    /// you can get the reason for the failure using the <code>GetImport</code>
    /// operation.</p>
    pub fn import_status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.import_status.as_ref()
    }
    /// <p>A list of tags added to the imported bot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A timestamp for the date and time that the import job was
    /// requested.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for StartImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportOutput");
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("import_id", &self.import_id);
        formatter.field("import_status", &self.import_status);
        formatter.field("tags", &self.tags);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`StartImportOutput`](crate::output::StartImportOutput)
pub mod start_import_output {
    /// A builder for [`StartImportOutput`](crate::output::StartImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name given to the import job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name given to the import job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of resource to import.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource to import.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The action to take when there is a merge conflict.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The action to take when there is a merge conflict.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The identifier for the specific import job.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The identifier for the specific import job.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The status of the import job. If the status is <code>FAILED</code>,
        /// you can get the reason for the failure using the <code>GetImport</code>
        /// operation.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The status of the import job. If the status is <code>FAILED</code>,
        /// you can get the reason for the failure using the <code>GetImport</code>
        /// operation.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags added to the imported bot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags added to the imported bot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A timestamp for the date and time that the import job was
        /// requested.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>A timestamp for the date and time that the import job was
        /// requested.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportOutput`](crate::output::StartImportOutput)
        pub fn build(self) -> crate::output::StartImportOutput {
            crate::output::StartImportOutput {
                name: self.name,
                resource_type: self.resource_type,
                merge_strategy: self.merge_strategy,
                import_id: self.import_id,
                import_status: self.import_status,
                tags: self.tags,
                created_date: self.created_date,
            }
        }
    }
}
impl StartImportOutput {
    /// Creates a new builder-style object to manufacture [`StartImportOutput`](crate::output::StartImportOutput)
    pub fn builder() -> crate::output::start_import_output::Builder {
        crate::output::start_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSlotTypeOutput {
    /// <p>The name of the slot type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub enumeration_values: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
    /// <p>The date that the slot type was updated. When you create a slot
    /// type, the creation date and last update date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the slot type was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of the slot type. For a new slot type, the version is
    /// always <code>$LATEST</code>. </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The slot resolution strategy that Amazon Lex uses to determine the value
    /// of the slot. For more information, see <a>PutSlotType</a>.</p>
    pub value_selection_strategy: std::option::Option<crate::model::SlotValueSelectionStrategy>,
    /// <p>
    /// <code>True</code> if a new version of the slot type was created. If
    /// the <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>The built-in slot type used as the parent of the slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub slot_type_configurations:
        std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
}
impl PutSlotTypeOutput {
    /// <p>The name of the slot type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub fn enumeration_values(&self) -> std::option::Option<&[crate::model::EnumerationValue]> {
        self.enumeration_values.as_deref()
    }
    /// <p>The date that the slot type was updated. When you create a slot
    /// type, the creation date and last update date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the slot type was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version of the slot type. For a new slot type, the version is
    /// always <code>$LATEST</code>. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The slot resolution strategy that Amazon Lex uses to determine the value
    /// of the slot. For more information, see <a>PutSlotType</a>.</p>
    pub fn value_selection_strategy(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionStrategy> {
        self.value_selection_strategy.as_ref()
    }
    /// <p>
    /// <code>True</code> if a new version of the slot type was created. If
    /// the <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>The built-in slot type used as the parent of the slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub fn slot_type_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SlotTypeConfiguration]> {
        self.slot_type_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSlotTypeOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("enumeration_values", &self.enumeration_values);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("value_selection_strategy", &self.value_selection_strategy);
        formatter.field("create_version", &self.create_version);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("slot_type_configurations", &self.slot_type_configurations);
        formatter.finish()
    }
}
/// See [`PutSlotTypeOutput`](crate::output::PutSlotTypeOutput)
pub mod put_slot_type_output {
    /// A builder for [`PutSlotTypeOutput`](crate::output::PutSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enumeration_values:
            std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) value_selection_strategy:
            std::option::Option<crate::model::SlotValueSelectionStrategy>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) slot_type_configurations:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
    }
    impl Builder {
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `enumeration_values`.
        ///
        /// To override the contents of this collection use [`set_enumeration_values`](Self::set_enumeration_values).
        ///
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn enumeration_values(
            mut self,
            input: impl Into<crate::model::EnumerationValue>,
        ) -> Self {
            let mut v = self.enumeration_values.unwrap_or_default();
            v.push(input.into());
            self.enumeration_values = Some(v);
            self
        }
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn set_enumeration_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        ) -> Self {
            self.enumeration_values = input;
            self
        }
        /// <p>The date that the slot type was updated. When you create a slot
        /// type, the creation date and last update date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the slot type was updated. When you create a slot
        /// type, the creation date and last update date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the slot type. For a new slot type, the version is
        /// always <code>$LATEST</code>. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the slot type. For a new slot type, the version is
        /// always <code>$LATEST</code>. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The slot resolution strategy that Amazon Lex uses to determine the value
        /// of the slot. For more information, see <a>PutSlotType</a>.</p>
        pub fn value_selection_strategy(
            mut self,
            input: crate::model::SlotValueSelectionStrategy,
        ) -> Self {
            self.value_selection_strategy = Some(input);
            self
        }
        /// <p>The slot resolution strategy that Amazon Lex uses to determine the value
        /// of the slot. For more information, see <a>PutSlotType</a>.</p>
        pub fn set_value_selection_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionStrategy>,
        ) -> Self {
            self.value_selection_strategy = input;
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the slot type was created. If
        /// the <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the slot type was created. If
        /// the <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// Appends an item to `slot_type_configurations`.
        ///
        /// To override the contents of this collection use [`set_slot_type_configurations`](Self::set_slot_type_configurations).
        ///
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn slot_type_configurations(
            mut self,
            input: impl Into<crate::model::SlotTypeConfiguration>,
        ) -> Self {
            let mut v = self.slot_type_configurations.unwrap_or_default();
            v.push(input.into());
            self.slot_type_configurations = Some(v);
            self
        }
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn set_slot_type_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
        ) -> Self {
            self.slot_type_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSlotTypeOutput`](crate::output::PutSlotTypeOutput)
        pub fn build(self) -> crate::output::PutSlotTypeOutput {
            crate::output::PutSlotTypeOutput {
                name: self.name,
                description: self.description,
                enumeration_values: self.enumeration_values,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                value_selection_strategy: self.value_selection_strategy,
                create_version: self.create_version,
                parent_slot_type_signature: self.parent_slot_type_signature,
                slot_type_configurations: self.slot_type_configurations,
            }
        }
    }
}
impl PutSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`PutSlotTypeOutput`](crate::output::PutSlotTypeOutput)
    pub fn builder() -> crate::output::put_slot_type_output::Builder {
        crate::output::put_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntentOutput {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of intent slots that are configured for the
    /// intent.</p>
    pub slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
    /// <p> An array of sample utterances that are configured for the intent.
    /// </p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If defined in the intent, Amazon Lex prompts the user to confirm the
    /// intent before fulfilling it.</p>
    pub confirmation_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code> Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub rejection_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined in the intent, Amazon Lex uses this prompt to solicit
    /// additional user activity after the intent is fulfilled.</p>
    pub follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
    /// <p>After the Lambda function specified in
    /// the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex
    /// conveys this statement to the user.</p>
    pub conclusion_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined in the intent, Amazon Lex invokes this Lambda function for
    /// each user input.</p>
    pub dialog_code_hook: std::option::Option<crate::model::CodeHook>,
    /// <p>If defined in the intent, Amazon Lex invokes this Lambda function to
    /// fulfill the intent after the user provides all of the information required
    /// by the intent.</p>
    pub fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
    /// <p>A unique identifier for the built-in intent that this intent is
    /// based on.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The date that the intent was updated. When you create a resource,
    /// the creation date and last update dates are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the intent was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of the intent. For a new intent, the version is always
    /// <code>$LATEST</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the <code>$LATEST</code>version of the intent created
    /// or updated.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>
    /// <code>True</code> if a new version of the intent was created. If
    /// the <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>Configuration information, if any, required to connect to an Amazon
    /// Kendra index and use the <code>AMAZON.KendraSearchIntent</code>
    /// intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
}
impl PutIntentOutput {
    /// <p>The name of the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of intent slots that are configured for the
    /// intent.</p>
    pub fn slots(&self) -> std::option::Option<&[crate::model::Slot]> {
        self.slots.as_deref()
    }
    /// <p> An array of sample utterances that are configured for the intent.
    /// </p>
    pub fn sample_utterances(&self) -> std::option::Option<&[std::string::String]> {
        self.sample_utterances.as_deref()
    }
    /// <p>If defined in the intent, Amazon Lex prompts the user to confirm the
    /// intent before fulfilling it.</p>
    pub fn confirmation_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.confirmation_prompt.as_ref()
    }
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code> Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub fn rejection_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.rejection_statement.as_ref()
    }
    /// <p>If defined in the intent, Amazon Lex uses this prompt to solicit
    /// additional user activity after the intent is fulfilled.</p>
    pub fn follow_up_prompt(&self) -> std::option::Option<&crate::model::FollowUpPrompt> {
        self.follow_up_prompt.as_ref()
    }
    /// <p>After the Lambda function specified in
    /// the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex
    /// conveys this statement to the user.</p>
    pub fn conclusion_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.conclusion_statement.as_ref()
    }
    /// <p>If defined in the intent, Amazon Lex invokes this Lambda function for
    /// each user input.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::CodeHook> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>If defined in the intent, Amazon Lex invokes this Lambda function to
    /// fulfill the intent after the user provides all of the information required
    /// by the intent.</p>
    pub fn fulfillment_activity(&self) -> std::option::Option<&crate::model::FulfillmentActivity> {
        self.fulfillment_activity.as_ref()
    }
    /// <p>A unique identifier for the built-in intent that this intent is
    /// based on.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>The date that the intent was updated. When you create a resource,
    /// the creation date and last update dates are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the intent was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version of the intent. For a new intent, the version is always
    /// <code>$LATEST</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the <code>$LATEST</code>version of the intent created
    /// or updated.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>
    /// <code>True</code> if a new version of the intent was created. If
    /// the <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>Configuration information, if any, required to connect to an Amazon
    /// Kendra index and use the <code>AMAZON.KendraSearchIntent</code>
    /// intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
}
impl std::fmt::Debug for PutIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntentOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("slots", &self.slots);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("confirmation_prompt", &self.confirmation_prompt);
        formatter.field("rejection_statement", &self.rejection_statement);
        formatter.field("follow_up_prompt", &self.follow_up_prompt);
        formatter.field("conclusion_statement", &self.conclusion_statement);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_activity", &self.fulfillment_activity);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("create_version", &self.create_version);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.finish()
    }
}
/// See [`PutIntentOutput`](crate::output::PutIntentOutput)
pub mod put_intent_output {
    /// A builder for [`PutIntentOutput`](crate::output::PutIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) confirmation_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) rejection_statement: std::option::Option<crate::model::Statement>,
        pub(crate) follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
        pub(crate) conclusion_statement: std::option::Option<crate::model::Statement>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::CodeHook>,
        pub(crate) fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of intent slots that are configured for the
        /// intent.</p>
        pub fn slots(mut self, input: impl Into<crate::model::Slot>) -> Self {
            let mut v = self.slots.unwrap_or_default();
            v.push(input.into());
            self.slots = Some(v);
            self
        }
        /// <p>An array of intent slots that are configured for the
        /// intent.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p> An array of sample utterances that are configured for the intent.
        /// </p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p> An array of sample utterances that are configured for the intent.
        /// </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>If defined in the intent, Amazon Lex prompts the user to confirm the
        /// intent before fulfilling it.</p>
        pub fn confirmation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.confirmation_prompt = Some(input);
            self
        }
        /// <p>If defined in the intent, Amazon Lex prompts the user to confirm the
        /// intent before fulfilling it.</p>
        pub fn set_confirmation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.confirmation_prompt = input;
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code> Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.rejection_statement = Some(input);
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code> Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.rejection_statement = input;
            self
        }
        /// <p>If defined in the intent, Amazon Lex uses this prompt to solicit
        /// additional user activity after the intent is fulfilled.</p>
        pub fn follow_up_prompt(mut self, input: crate::model::FollowUpPrompt) -> Self {
            self.follow_up_prompt = Some(input);
            self
        }
        /// <p>If defined in the intent, Amazon Lex uses this prompt to solicit
        /// additional user activity after the intent is fulfilled.</p>
        pub fn set_follow_up_prompt(
            mut self,
            input: std::option::Option<crate::model::FollowUpPrompt>,
        ) -> Self {
            self.follow_up_prompt = input;
            self
        }
        /// <p>After the Lambda function specified in
        /// the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex
        /// conveys this statement to the user.</p>
        pub fn conclusion_statement(mut self, input: crate::model::Statement) -> Self {
            self.conclusion_statement = Some(input);
            self
        }
        /// <p>After the Lambda function specified in
        /// the<code>fulfillmentActivity</code>intent fulfills the intent, Amazon Lex
        /// conveys this statement to the user.</p>
        pub fn set_conclusion_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.conclusion_statement = input;
            self
        }
        /// <p>If defined in the intent, Amazon Lex invokes this Lambda function for
        /// each user input.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>If defined in the intent, Amazon Lex invokes this Lambda function for
        /// each user input.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::CodeHook>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>If defined in the intent, Amazon Lex invokes this Lambda function to
        /// fulfill the intent after the user provides all of the information required
        /// by the intent.</p>
        pub fn fulfillment_activity(mut self, input: crate::model::FulfillmentActivity) -> Self {
            self.fulfillment_activity = Some(input);
            self
        }
        /// <p>If defined in the intent, Amazon Lex invokes this Lambda function to
        /// fulfill the intent after the user provides all of the information required
        /// by the intent.</p>
        pub fn set_fulfillment_activity(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivity>,
        ) -> Self {
            self.fulfillment_activity = input;
            self
        }
        /// <p>A unique identifier for the built-in intent that this intent is
        /// based on.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent that this intent is
        /// based on.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// <p>The date that the intent was updated. When you create a resource,
        /// the creation date and last update dates are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the intent was updated. When you create a resource,
        /// the creation date and last update dates are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the intent. For a new intent, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the intent. For a new intent, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the <code>$LATEST</code>version of the intent created
        /// or updated.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code>version of the intent created
        /// or updated.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the intent was created. If
        /// the <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the intent was created. If
        /// the <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// <p>Configuration information, if any, required to connect to an Amazon
        /// Kendra index and use the <code>AMAZON.KendraSearchIntent</code>
        /// intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information, if any, required to connect to an Amazon
        /// Kendra index and use the <code>AMAZON.KendraSearchIntent</code>
        /// intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn input_contexts(mut self, input: impl Into<crate::model::InputContext>) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input.into());
            self.input_contexts = Some(v);
            self
        }
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: impl Into<crate::model::OutputContext>) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input.into());
            self.output_contexts = Some(v);
            self
        }
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntentOutput`](crate::output::PutIntentOutput)
        pub fn build(self) -> crate::output::PutIntentOutput {
            crate::output::PutIntentOutput {
                name: self.name,
                description: self.description,
                slots: self.slots,
                sample_utterances: self.sample_utterances,
                confirmation_prompt: self.confirmation_prompt,
                rejection_statement: self.rejection_statement,
                follow_up_prompt: self.follow_up_prompt,
                conclusion_statement: self.conclusion_statement,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_activity: self.fulfillment_activity,
                parent_intent_signature: self.parent_intent_signature,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                create_version: self.create_version,
                kendra_configuration: self.kendra_configuration,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
            }
        }
    }
}
impl PutIntentOutput {
    /// Creates a new builder-style object to manufacture [`PutIntentOutput`](crate::output::PutIntentOutput)
    pub fn builder() -> crate::output::put_intent_output::Builder {
        crate::output::put_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBotAliasOutput {
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot that the alias points to.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The name of the bot that the alias points to.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and the last updated date are the
    /// same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the bot alias was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The checksum for the current version of the alias.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
    /// <p>A list of tags associated with a bot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutBotAliasOutput {
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot that the alias points to.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The name of the bot that the alias points to.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and the last updated date are the
    /// same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot alias was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The checksum for the current version of the alias.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub fn conversation_logs(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogsResponse> {
        self.conversation_logs.as_ref()
    }
    /// <p>A list of tags associated with a bot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBotAliasOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("checksum", &self.checksum);
        formatter.field("conversation_logs", &self.conversation_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PutBotAliasOutput`](crate::output::PutBotAliasOutput)
pub mod put_bot_alias_output {
    /// A builder for [`PutBotAliasOutput`](crate::output::PutBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot that the alias points to.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that the alias points to.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and the last updated date are the
        /// same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and the last updated date are the
        /// same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The checksum for the current version of the alias.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>The checksum for the current version of the alias.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn conversation_logs(mut self, input: crate::model::ConversationLogsResponse) -> Self {
            self.conversation_logs = Some(input);
            self
        }
        /// <p>The settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn set_conversation_logs(
            mut self,
            input: std::option::Option<crate::model::ConversationLogsResponse>,
        ) -> Self {
            self.conversation_logs = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with a bot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with a bot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBotAliasOutput`](crate::output::PutBotAliasOutput)
        pub fn build(self) -> crate::output::PutBotAliasOutput {
            crate::output::PutBotAliasOutput {
                name: self.name,
                description: self.description,
                bot_version: self.bot_version,
                bot_name: self.bot_name,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                checksum: self.checksum,
                conversation_logs: self.conversation_logs,
                tags: self.tags,
            }
        }
    }
}
impl PutBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`PutBotAliasOutput`](crate::output::PutBotAliasOutput)
    pub fn builder() -> crate::output::put_bot_alias_output::Builder {
        crate::output::put_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBotOutput {
    /// <p>The name of the bot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub enable_model_improvements: std::option::Option<bool>,
    /// <p>The score that determines where Amazon Lex inserts the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
    /// for all intents is below this value.
    /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
    /// configured for the bot.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p> The prompts that Amazon Lex uses when it doesn't understand the user's
    /// intent. For more information, see <a>PutBot</a>. </p>
    pub clarification_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>The message that Amazon Lex uses to cancel a conversation. For more
    /// information, see <a>PutBot</a>.</p>
    pub abort_statement: std::option::Option<crate::model::Statement>,
    /// <p> When you send a request to create a bot with
    /// <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the
    /// <code>status</code> response element to <code>BUILDING</code>.</p>
    /// <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot
    /// with user inputs that exactly match the utterances configured for the
    /// bot's intents and values in the slot types.</p>
    /// <p>If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to
    /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
    /// <code>failureReason</code> response element. </p>
    /// <p>When you set <code>processBehavior</code> to <code>SAVE</code>,
    /// Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>
    /// <p>When the bot is in the <code>READY</code> state you can test and
    /// publish the bot.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to build the bot.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date that the bot was updated. When you create a resource, the
    /// creation date and last updated date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the bot was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum length of time that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
    /// with the user. For more information, see <a>PutBot</a>.</p>
    pub voice_id: std::option::Option<std::string::String>,
    /// <p>Checksum of the bot that you created.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p> The target locale for the bot. </p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub child_directed: std::option::Option<bool>,
    /// <p>
    /// <code>True</code> if a new version of the bot was created. If the
    /// <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>
    /// <code>true</code> if the bot is configured to send user utterances to
    /// Amazon Comprehend for sentiment analysis. If the
    /// <code>detectSentiment</code> field was not specified in the request, the
    /// <code>detectSentiment</code> field is <code>false</code> in the
    /// response.</p>
    pub detect_sentiment: std::option::Option<bool>,
    /// <p>A list of tags associated with the bot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutBotOutput {
    /// <p>The name of the bot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::Intent]> {
        self.intents.as_deref()
    }
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub fn enable_model_improvements(&self) -> std::option::Option<bool> {
        self.enable_model_improvements
    }
    /// <p>The score that determines where Amazon Lex inserts the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
    /// for all intents is below this value.
    /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
    /// configured for the bot.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p> The prompts that Amazon Lex uses when it doesn't understand the user's
    /// intent. For more information, see <a>PutBot</a>. </p>
    pub fn clarification_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.clarification_prompt.as_ref()
    }
    /// <p>The message that Amazon Lex uses to cancel a conversation. For more
    /// information, see <a>PutBot</a>.</p>
    pub fn abort_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.abort_statement.as_ref()
    }
    /// <p> When you send a request to create a bot with
    /// <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the
    /// <code>status</code> response element to <code>BUILDING</code>.</p>
    /// <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot
    /// with user inputs that exactly match the utterances configured for the
    /// bot's intents and values in the slot types.</p>
    /// <p>If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to
    /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
    /// <code>failureReason</code> response element. </p>
    /// <p>When you set <code>processBehavior</code> to <code>SAVE</code>,
    /// Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>
    /// <p>When the bot is in the <code>READY</code> state you can test and
    /// publish the bot.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to build the bot.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date that the bot was updated. When you create a resource, the
    /// creation date and last updated date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The maximum length of time that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
    /// with the user. For more information, see <a>PutBot</a>.</p>
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
    /// <p>Checksum of the bot that you created.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p> The target locale for the bot. </p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub fn child_directed(&self) -> std::option::Option<bool> {
        self.child_directed
    }
    /// <p>
    /// <code>True</code> if a new version of the bot was created. If the
    /// <code>createVersion</code> field was not specified in the request, the
    /// <code>createVersion</code> field is set to false in the
    /// response.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>
    /// <code>true</code> if the bot is configured to send user utterances to
    /// Amazon Comprehend for sentiment analysis. If the
    /// <code>detectSentiment</code> field was not specified in the request, the
    /// <code>detectSentiment</code> field is <code>false</code> in the
    /// response.</p>
    pub fn detect_sentiment(&self) -> std::option::Option<bool> {
        self.detect_sentiment
    }
    /// <p>A list of tags associated with the bot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBotOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("intents", &self.intents);
        formatter.field("enable_model_improvements", &self.enable_model_improvements);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("clarification_prompt", &self.clarification_prompt);
        formatter.field("abort_statement", &self.abort_statement);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("voice_id", &self.voice_id);
        formatter.field("checksum", &self.checksum);
        formatter.field("version", &self.version);
        formatter.field("locale", &self.locale);
        formatter.field("child_directed", &self.child_directed);
        formatter.field("create_version", &self.create_version);
        formatter.field("detect_sentiment", &self.detect_sentiment);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PutBotOutput`](crate::output::PutBotOutput)
pub mod put_bot_output {
    /// A builder for [`PutBotOutput`](crate::output::PutBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        pub(crate) enable_model_improvements: std::option::Option<bool>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) clarification_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) abort_statement: std::option::Option<crate::model::Statement>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) child_directed: std::option::Option<bool>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) detect_sentiment: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn intents(mut self, input: impl Into<crate::model::Intent>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn enable_model_improvements(mut self, input: bool) -> Self {
            self.enable_model_improvements = Some(input);
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn set_enable_model_improvements(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_model_improvements = input;
            self
        }
        /// <p>The score that determines where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
        /// for all intents is below this value.
        /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
        /// configured for the bot.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The score that determines where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
        /// for all intents is below this value.
        /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
        /// configured for the bot.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p> The prompts that Amazon Lex uses when it doesn't understand the user's
        /// intent. For more information, see <a>PutBot</a>. </p>
        pub fn clarification_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.clarification_prompt = Some(input);
            self
        }
        /// <p> The prompts that Amazon Lex uses when it doesn't understand the user's
        /// intent. For more information, see <a>PutBot</a>. </p>
        pub fn set_clarification_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.clarification_prompt = input;
            self
        }
        /// <p>The message that Amazon Lex uses to cancel a conversation. For more
        /// information, see <a>PutBot</a>.</p>
        pub fn abort_statement(mut self, input: crate::model::Statement) -> Self {
            self.abort_statement = Some(input);
            self
        }
        /// <p>The message that Amazon Lex uses to cancel a conversation. For more
        /// information, see <a>PutBot</a>.</p>
        pub fn set_abort_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.abort_statement = input;
            self
        }
        /// <p> When you send a request to create a bot with
        /// <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the
        /// <code>status</code> response element to <code>BUILDING</code>.</p>
        /// <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot
        /// with user inputs that exactly match the utterances configured for the
        /// bot's intents and values in the slot types.</p>
        /// <p>If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to
        /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
        /// <code>failureReason</code> response element. </p>
        /// <p>When you set <code>processBehavior</code> to <code>SAVE</code>,
        /// Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>
        /// <p>When the bot is in the <code>READY</code> state you can test and
        /// publish the bot.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> When you send a request to create a bot with
        /// <code>processBehavior</code> set to <code>BUILD</code>, Amazon Lex sets the
        /// <code>status</code> response element to <code>BUILDING</code>.</p>
        /// <p>In the <code>READY_BASIC_TESTING</code> state you can test the bot
        /// with user inputs that exactly match the utterances configured for the
        /// bot's intents and values in the slot types.</p>
        /// <p>If Amazon Lex can't build the bot, Amazon Lex sets <code>status</code> to
        /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
        /// <code>failureReason</code> response element. </p>
        /// <p>When you set <code>processBehavior</code> to <code>SAVE</code>,
        /// Amazon Lex sets the status code to <code>NOT BUILT</code>.</p>
        /// <p>When the bot is in the <code>READY</code> state you can test and
        /// publish the bot.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to build the bot.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to build the bot.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date that the bot was updated. When you create a resource, the
        /// creation date and last updated date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot was updated. When you create a resource, the
        /// creation date and last updated date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The maximum length of time that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The maximum length of time that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
        /// with the user. For more information, see <a>PutBot</a>.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
        /// with the user. For more information, see <a>PutBot</a>.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// <p>Checksum of the bot that you created.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the bot that you created.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p> The target locale for the bot. </p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p> The target locale for the bot. </p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.child_directed = Some(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.child_directed = input;
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the bot was created. If the
        /// <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>
        /// <code>True</code> if a new version of the bot was created. If the
        /// <code>createVersion</code> field was not specified in the request, the
        /// <code>createVersion</code> field is set to false in the
        /// response.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// <p>
        /// <code>true</code> if the bot is configured to send user utterances to
        /// Amazon Comprehend for sentiment analysis. If the
        /// <code>detectSentiment</code> field was not specified in the request, the
        /// <code>detectSentiment</code> field is <code>false</code> in the
        /// response.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.detect_sentiment = Some(input);
            self
        }
        /// <p>
        /// <code>true</code> if the bot is configured to send user utterances to
        /// Amazon Comprehend for sentiment analysis. If the
        /// <code>detectSentiment</code> field was not specified in the request, the
        /// <code>detectSentiment</code> field is <code>false</code> in the
        /// response.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.detect_sentiment = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the bot.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with the bot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBotOutput`](crate::output::PutBotOutput)
        pub fn build(self) -> crate::output::PutBotOutput {
            crate::output::PutBotOutput {
                name: self.name,
                description: self.description,
                intents: self.intents,
                enable_model_improvements: self.enable_model_improvements,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                clarification_prompt: self.clarification_prompt,
                abort_statement: self.abort_statement,
                status: self.status,
                failure_reason: self.failure_reason,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                voice_id: self.voice_id,
                checksum: self.checksum,
                version: self.version,
                locale: self.locale,
                child_directed: self.child_directed,
                create_version: self.create_version,
                detect_sentiment: self.detect_sentiment,
                tags: self.tags,
            }
        }
    }
}
impl PutBotOutput {
    /// Creates a new builder-style object to manufacture [`PutBotOutput`](crate::output::PutBotOutput)
    pub fn builder() -> crate::output::put_bot_output::Builder {
        crate::output::put_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags associated with a resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags associated with a resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with a resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUtterancesViewOutput {
    /// <p>The name of the bot for which utterance information was
    /// returned.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>An array of <a>UtteranceList</a> objects, each
    /// containing a list of <a>UtteranceData</a> objects describing
    /// the utterances that were processed by your bot. The response contains a
    /// maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex
    /// returns the most frequent utterances received by the bot in the last 15
    /// days.</p>
    pub utterances: std::option::Option<std::vec::Vec<crate::model::UtteranceList>>,
}
impl GetUtterancesViewOutput {
    /// <p>The name of the bot for which utterance information was
    /// returned.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>An array of <a>UtteranceList</a> objects, each
    /// containing a list of <a>UtteranceData</a> objects describing
    /// the utterances that were processed by your bot. The response contains a
    /// maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex
    /// returns the most frequent utterances received by the bot in the last 15
    /// days.</p>
    pub fn utterances(&self) -> std::option::Option<&[crate::model::UtteranceList]> {
        self.utterances.as_deref()
    }
}
impl std::fmt::Debug for GetUtterancesViewOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUtterancesViewOutput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("utterances", &self.utterances);
        formatter.finish()
    }
}
/// See [`GetUtterancesViewOutput`](crate::output::GetUtterancesViewOutput)
pub mod get_utterances_view_output {
    /// A builder for [`GetUtterancesViewOutput`](crate::output::GetUtterancesViewOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) utterances: std::option::Option<std::vec::Vec<crate::model::UtteranceList>>,
    }
    impl Builder {
        /// <p>The name of the bot for which utterance information was
        /// returned.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot for which utterance information was
        /// returned.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// Appends an item to `utterances`.
        ///
        /// To override the contents of this collection use [`set_utterances`](Self::set_utterances).
        ///
        /// <p>An array of <a>UtteranceList</a> objects, each
        /// containing a list of <a>UtteranceData</a> objects describing
        /// the utterances that were processed by your bot. The response contains a
        /// maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex
        /// returns the most frequent utterances received by the bot in the last 15
        /// days.</p>
        pub fn utterances(mut self, input: impl Into<crate::model::UtteranceList>) -> Self {
            let mut v = self.utterances.unwrap_or_default();
            v.push(input.into());
            self.utterances = Some(v);
            self
        }
        /// <p>An array of <a>UtteranceList</a> objects, each
        /// containing a list of <a>UtteranceData</a> objects describing
        /// the utterances that were processed by your bot. The response contains a
        /// maximum of 100 <code>UtteranceData</code> objects for each version. Amazon Lex
        /// returns the most frequent utterances received by the bot in the last 15
        /// days.</p>
        pub fn set_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtteranceList>>,
        ) -> Self {
            self.utterances = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUtterancesViewOutput`](crate::output::GetUtterancesViewOutput)
        pub fn build(self) -> crate::output::GetUtterancesViewOutput {
            crate::output::GetUtterancesViewOutput {
                bot_name: self.bot_name,
                utterances: self.utterances,
            }
        }
    }
}
impl GetUtterancesViewOutput {
    /// Creates a new builder-style object to manufacture [`GetUtterancesViewOutput`](crate::output::GetUtterancesViewOutput)
    pub fn builder() -> crate::output::get_utterances_view_output::Builder {
        crate::output::get_utterances_view_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypeVersionsOutput {
    /// <p>An array of <code>SlotTypeMetadata</code> objects, one for each
    /// numbered version of the slot type plus one for the <code>$LATEST</code>
    /// version.</p>
    pub slot_types: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
    /// <p>A pagination token for fetching the next page of slot type
    /// versions. If the response to this call is truncated, Amazon Lex returns a
    /// pagination token in the response. To fetch the next page of versions,
    /// specify the pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSlotTypeVersionsOutput {
    /// <p>An array of <code>SlotTypeMetadata</code> objects, one for each
    /// numbered version of the slot type plus one for the <code>$LATEST</code>
    /// version.</p>
    pub fn slot_types(&self) -> std::option::Option<&[crate::model::SlotTypeMetadata]> {
        self.slot_types.as_deref()
    }
    /// <p>A pagination token for fetching the next page of slot type
    /// versions. If the response to this call is truncated, Amazon Lex returns a
    /// pagination token in the response. To fetch the next page of versions,
    /// specify the pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSlotTypeVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypeVersionsOutput");
        formatter.field("slot_types", &self.slot_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSlotTypeVersionsOutput`](crate::output::GetSlotTypeVersionsOutput)
pub mod get_slot_type_versions_output {
    /// A builder for [`GetSlotTypeVersionsOutput`](crate::output::GetSlotTypeVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_types: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `slot_types`.
        ///
        /// To override the contents of this collection use [`set_slot_types`](Self::set_slot_types).
        ///
        /// <p>An array of <code>SlotTypeMetadata</code> objects, one for each
        /// numbered version of the slot type plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn slot_types(mut self, input: impl Into<crate::model::SlotTypeMetadata>) -> Self {
            let mut v = self.slot_types.unwrap_or_default();
            v.push(input.into());
            self.slot_types = Some(v);
            self
        }
        /// <p>An array of <code>SlotTypeMetadata</code> objects, one for each
        /// numbered version of the slot type plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn set_slot_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
        ) -> Self {
            self.slot_types = input;
            self
        }
        /// <p>A pagination token for fetching the next page of slot type
        /// versions. If the response to this call is truncated, Amazon Lex returns a
        /// pagination token in the response. To fetch the next page of versions,
        /// specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of slot type
        /// versions. If the response to this call is truncated, Amazon Lex returns a
        /// pagination token in the response. To fetch the next page of versions,
        /// specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypeVersionsOutput`](crate::output::GetSlotTypeVersionsOutput)
        pub fn build(self) -> crate::output::GetSlotTypeVersionsOutput {
            crate::output::GetSlotTypeVersionsOutput {
                slot_types: self.slot_types,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSlotTypeVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetSlotTypeVersionsOutput`](crate::output::GetSlotTypeVersionsOutput)
    pub fn builder() -> crate::output::get_slot_type_versions_output::Builder {
        crate::output::get_slot_type_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypesOutput {
    /// <p>An array of objects, one for each slot type, that provides
    /// information such as the name of the slot type, the version, and a
    /// description.</p>
    pub slot_types: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
    /// <p>If the response is truncated, it includes a pagination token that
    /// you can specify in your next request to fetch the next page of slot
    /// types.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetSlotTypesOutput {
    /// <p>An array of objects, one for each slot type, that provides
    /// information such as the name of the slot type, the version, and a
    /// description.</p>
    pub fn slot_types(&self) -> std::option::Option<&[crate::model::SlotTypeMetadata]> {
        self.slot_types.as_deref()
    }
    /// <p>If the response is truncated, it includes a pagination token that
    /// you can specify in your next request to fetch the next page of slot
    /// types.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetSlotTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypesOutput");
        formatter.field("slot_types", &self.slot_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSlotTypesOutput`](crate::output::GetSlotTypesOutput)
pub mod get_slot_types_output {
    /// A builder for [`GetSlotTypesOutput`](crate::output::GetSlotTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_types: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `slot_types`.
        ///
        /// To override the contents of this collection use [`set_slot_types`](Self::set_slot_types).
        ///
        /// <p>An array of objects, one for each slot type, that provides
        /// information such as the name of the slot type, the version, and a
        /// description.</p>
        pub fn slot_types(mut self, input: impl Into<crate::model::SlotTypeMetadata>) -> Self {
            let mut v = self.slot_types.unwrap_or_default();
            v.push(input.into());
            self.slot_types = Some(v);
            self
        }
        /// <p>An array of objects, one for each slot type, that provides
        /// information such as the name of the slot type, the version, and a
        /// description.</p>
        pub fn set_slot_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeMetadata>>,
        ) -> Self {
            self.slot_types = input;
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that
        /// you can specify in your next request to fetch the next page of slot
        /// types.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that
        /// you can specify in your next request to fetch the next page of slot
        /// types.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypesOutput`](crate::output::GetSlotTypesOutput)
        pub fn build(self) -> crate::output::GetSlotTypesOutput {
            crate::output::GetSlotTypesOutput {
                slot_types: self.slot_types,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSlotTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetSlotTypesOutput`](crate::output::GetSlotTypesOutput)
    pub fn builder() -> crate::output::get_slot_types_output::Builder {
        crate::output::get_slot_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypeOutput {
    /// <p>The name of the slot type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub enumeration_values: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last update date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the slot type was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of the slot type.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
    /// For more information, see <a>PutSlotType</a>.</p>
    pub value_selection_strategy: std::option::Option<crate::model::SlotValueSelectionStrategy>,
    /// <p>The built-in slot type used as a parent for the slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub slot_type_configurations:
        std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
}
impl GetSlotTypeOutput {
    /// <p>The name of the slot type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub fn enumeration_values(&self) -> std::option::Option<&[crate::model::EnumerationValue]> {
        self.enumeration_values.as_deref()
    }
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last update date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the slot type was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version of the slot type.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
    /// For more information, see <a>PutSlotType</a>.</p>
    pub fn value_selection_strategy(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionStrategy> {
        self.value_selection_strategy.as_ref()
    }
    /// <p>The built-in slot type used as a parent for the slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub fn slot_type_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SlotTypeConfiguration]> {
        self.slot_type_configurations.as_deref()
    }
}
impl std::fmt::Debug for GetSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypeOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("enumeration_values", &self.enumeration_values);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("value_selection_strategy", &self.value_selection_strategy);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("slot_type_configurations", &self.slot_type_configurations);
        formatter.finish()
    }
}
/// See [`GetSlotTypeOutput`](crate::output::GetSlotTypeOutput)
pub mod get_slot_type_output {
    /// A builder for [`GetSlotTypeOutput`](crate::output::GetSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enumeration_values:
            std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) value_selection_strategy:
            std::option::Option<crate::model::SlotValueSelectionStrategy>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) slot_type_configurations:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
    }
    impl Builder {
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `enumeration_values`.
        ///
        /// To override the contents of this collection use [`set_enumeration_values`](Self::set_enumeration_values).
        ///
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn enumeration_values(
            mut self,
            input: impl Into<crate::model::EnumerationValue>,
        ) -> Self {
            let mut v = self.enumeration_values.unwrap_or_default();
            v.push(input.into());
            self.enumeration_values = Some(v);
            self
        }
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn set_enumeration_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        ) -> Self {
            self.enumeration_values = input;
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last update date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last update date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the slot type.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
        /// For more information, see <a>PutSlotType</a>.</p>
        pub fn value_selection_strategy(
            mut self,
            input: crate::model::SlotValueSelectionStrategy,
        ) -> Self {
            self.value_selection_strategy = Some(input);
            self
        }
        /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
        /// For more information, see <a>PutSlotType</a>.</p>
        pub fn set_value_selection_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionStrategy>,
        ) -> Self {
            self.value_selection_strategy = input;
            self
        }
        /// <p>The built-in slot type used as a parent for the slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built-in slot type used as a parent for the slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// Appends an item to `slot_type_configurations`.
        ///
        /// To override the contents of this collection use [`set_slot_type_configurations`](Self::set_slot_type_configurations).
        ///
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn slot_type_configurations(
            mut self,
            input: impl Into<crate::model::SlotTypeConfiguration>,
        ) -> Self {
            let mut v = self.slot_type_configurations.unwrap_or_default();
            v.push(input.into());
            self.slot_type_configurations = Some(v);
            self
        }
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn set_slot_type_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
        ) -> Self {
            self.slot_type_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypeOutput`](crate::output::GetSlotTypeOutput)
        pub fn build(self) -> crate::output::GetSlotTypeOutput {
            crate::output::GetSlotTypeOutput {
                name: self.name,
                description: self.description,
                enumeration_values: self.enumeration_values,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                value_selection_strategy: self.value_selection_strategy,
                parent_slot_type_signature: self.parent_slot_type_signature,
                slot_type_configurations: self.slot_type_configurations,
            }
        }
    }
}
impl GetSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`GetSlotTypeOutput`](crate::output::GetSlotTypeOutput)
    pub fn builder() -> crate::output::get_slot_type_output::Builder {
        crate::output::get_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMigrationsOutput {
    /// <p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see
    /// details of the migration, use the <code>migrationId</code> from the
    /// summary in a call to the
    /// operation.</p>
    pub migration_summaries: std::option::Option<std::vec::Vec<crate::model::MigrationSummary>>,
    /// <p>If the response is truncated, it includes a pagination token that you
    /// can specify in your next request to fetch the next page of
    /// migrations.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetMigrationsOutput {
    /// <p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see
    /// details of the migration, use the <code>migrationId</code> from the
    /// summary in a call to the
    /// operation.</p>
    pub fn migration_summaries(&self) -> std::option::Option<&[crate::model::MigrationSummary]> {
        self.migration_summaries.as_deref()
    }
    /// <p>If the response is truncated, it includes a pagination token that you
    /// can specify in your next request to fetch the next page of
    /// migrations.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetMigrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMigrationsOutput");
        formatter.field("migration_summaries", &self.migration_summaries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetMigrationsOutput`](crate::output::GetMigrationsOutput)
pub mod get_migrations_output {
    /// A builder for [`GetMigrationsOutput`](crate::output::GetMigrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) migration_summaries:
            std::option::Option<std::vec::Vec<crate::model::MigrationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `migration_summaries`.
        ///
        /// To override the contents of this collection use [`set_migration_summaries`](Self::set_migration_summaries).
        ///
        /// <p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see
        /// details of the migration, use the <code>migrationId</code> from the
        /// summary in a call to the
        /// operation.</p>
        pub fn migration_summaries(
            mut self,
            input: impl Into<crate::model::MigrationSummary>,
        ) -> Self {
            let mut v = self.migration_summaries.unwrap_or_default();
            v.push(input.into());
            self.migration_summaries = Some(v);
            self
        }
        /// <p>An array of summaries for migrations from Amazon Lex V1 to Amazon Lex V2. To see
        /// details of the migration, use the <code>migrationId</code> from the
        /// summary in a call to the
        /// operation.</p>
        pub fn set_migration_summaries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MigrationSummary>>,
        ) -> Self {
            self.migration_summaries = input;
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that you
        /// can specify in your next request to fetch the next page of
        /// migrations.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that you
        /// can specify in your next request to fetch the next page of
        /// migrations.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMigrationsOutput`](crate::output::GetMigrationsOutput)
        pub fn build(self) -> crate::output::GetMigrationsOutput {
            crate::output::GetMigrationsOutput {
                migration_summaries: self.migration_summaries,
                next_token: self.next_token,
            }
        }
    }
}
impl GetMigrationsOutput {
    /// Creates a new builder-style object to manufacture [`GetMigrationsOutput`](crate::output::GetMigrationsOutput)
    pub fn builder() -> crate::output::get_migrations_output::Builder {
        crate::output::get_migrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMigrationOutput {
    /// <p>The unique identifier of the migration. This is the same as the
    /// identifier used when calling the <code>GetMigration</code>
    /// operation.</p>
    pub migration_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub v1_bot_name: std::option::Option<std::string::String>,
    /// <p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub v1_bot_version: std::option::Option<std::string::String>,
    /// <p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub v1_bot_locale: std::option::Option<crate::model::Locale>,
    /// <p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being
    /// migrated to.</p>
    pub v2_bot_id: std::option::Option<std::string::String>,
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub v2_bot_role: std::option::Option<std::string::String>,
    /// <p>Indicates the status of the migration. When the status is
    /// <code>COMPLETE</code> the migration is finished and the bot is available
    /// in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
    /// complete the migration.</p>
    pub migration_status: std::option::Option<crate::model::MigrationStatus>,
    /// <p>The strategy used to conduct the migration.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
    /// the Amazon Lex V1 bot to the new bot.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
    /// metadata and the locale being migrated. It doesn't change any other
    /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
    /// is created in the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
    /// <p>The date and time that the migration started.</p>
    pub migration_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of alerts and warnings that indicate issues with the migration
    /// for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1
    /// feature has a different implementation if Amazon Lex V2.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2
    /// developer guide</i>.</p>
    pub alerts: std::option::Option<std::vec::Vec<crate::model::MigrationAlert>>,
}
impl GetMigrationOutput {
    /// <p>The unique identifier of the migration. This is the same as the
    /// identifier used when calling the <code>GetMigration</code>
    /// operation.</p>
    pub fn migration_id(&self) -> std::option::Option<&str> {
        self.migration_id.as_deref()
    }
    /// <p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub fn v1_bot_name(&self) -> std::option::Option<&str> {
        self.v1_bot_name.as_deref()
    }
    /// <p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub fn v1_bot_version(&self) -> std::option::Option<&str> {
        self.v1_bot_version.as_deref()
    }
    /// <p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
    pub fn v1_bot_locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.v1_bot_locale.as_ref()
    }
    /// <p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being
    /// migrated to.</p>
    pub fn v2_bot_id(&self) -> std::option::Option<&str> {
        self.v2_bot_id.as_deref()
    }
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub fn v2_bot_role(&self) -> std::option::Option<&str> {
        self.v2_bot_role.as_deref()
    }
    /// <p>Indicates the status of the migration. When the status is
    /// <code>COMPLETE</code> the migration is finished and the bot is available
    /// in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
    /// complete the migration.</p>
    pub fn migration_status(&self) -> std::option::Option<&crate::model::MigrationStatus> {
        self.migration_status.as_ref()
    }
    /// <p>The strategy used to conduct the migration.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
    /// the Amazon Lex V1 bot to the new bot.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
    /// metadata and the locale being migrated. It doesn't change any other
    /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
    /// is created in the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub fn migration_strategy(&self) -> std::option::Option<&crate::model::MigrationStrategy> {
        self.migration_strategy.as_ref()
    }
    /// <p>The date and time that the migration started.</p>
    pub fn migration_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.migration_timestamp.as_ref()
    }
    /// <p>A list of alerts and warnings that indicate issues with the migration
    /// for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1
    /// feature has a different implementation if Amazon Lex V2.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2
    /// developer guide</i>.</p>
    pub fn alerts(&self) -> std::option::Option<&[crate::model::MigrationAlert]> {
        self.alerts.as_deref()
    }
}
impl std::fmt::Debug for GetMigrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMigrationOutput");
        formatter.field("migration_id", &self.migration_id);
        formatter.field("v1_bot_name", &self.v1_bot_name);
        formatter.field("v1_bot_version", &self.v1_bot_version);
        formatter.field("v1_bot_locale", &self.v1_bot_locale);
        formatter.field("v2_bot_id", &self.v2_bot_id);
        formatter.field("v2_bot_role", &self.v2_bot_role);
        formatter.field("migration_status", &self.migration_status);
        formatter.field("migration_strategy", &self.migration_strategy);
        formatter.field("migration_timestamp", &self.migration_timestamp);
        formatter.field("alerts", &self.alerts);
        formatter.finish()
    }
}
/// See [`GetMigrationOutput`](crate::output::GetMigrationOutput)
pub mod get_migration_output {
    /// A builder for [`GetMigrationOutput`](crate::output::GetMigrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) migration_id: std::option::Option<std::string::String>,
        pub(crate) v1_bot_name: std::option::Option<std::string::String>,
        pub(crate) v1_bot_version: std::option::Option<std::string::String>,
        pub(crate) v1_bot_locale: std::option::Option<crate::model::Locale>,
        pub(crate) v2_bot_id: std::option::Option<std::string::String>,
        pub(crate) v2_bot_role: std::option::Option<std::string::String>,
        pub(crate) migration_status: std::option::Option<crate::model::MigrationStatus>,
        pub(crate) migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
        pub(crate) migration_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alerts: std::option::Option<std::vec::Vec<crate::model::MigrationAlert>>,
    }
    impl Builder {
        /// <p>The unique identifier of the migration. This is the same as the
        /// identifier used when calling the <code>GetMigration</code>
        /// operation.</p>
        pub fn migration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the migration. This is the same as the
        /// identifier used when calling the <code>GetMigration</code>
        /// operation.</p>
        pub fn set_migration_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.migration_id = input;
            self
        }
        /// <p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn v1_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn set_v1_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v1_bot_name = input;
            self
        }
        /// <p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn v1_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_version = Some(input.into());
            self
        }
        /// <p>The version of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn set_v1_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.v1_bot_version = input;
            self
        }
        /// <p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn v1_bot_locale(mut self, input: crate::model::Locale) -> Self {
            self.v1_bot_locale = Some(input);
            self
        }
        /// <p>The locale of the Amazon Lex V1 bot migrated to Amazon Lex V2.</p>
        pub fn set_v1_bot_locale(
            mut self,
            input: std::option::Option<crate::model::Locale>,
        ) -> Self {
            self.v1_bot_locale = input;
            self
        }
        /// <p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being
        /// migrated to.</p>
        pub fn v2_bot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Amazon Lex V2 bot that the Amazon Lex V1 is being
        /// migrated to.</p>
        pub fn set_v2_bot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_id = input;
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn v2_bot_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn set_v2_bot_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_role = input;
            self
        }
        /// <p>Indicates the status of the migration. When the status is
        /// <code>COMPLETE</code> the migration is finished and the bot is available
        /// in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
        /// complete the migration.</p>
        pub fn migration_status(mut self, input: crate::model::MigrationStatus) -> Self {
            self.migration_status = Some(input);
            self
        }
        /// <p>Indicates the status of the migration. When the status is
        /// <code>COMPLETE</code> the migration is finished and the bot is available
        /// in Amazon Lex V2. There may be alerts and warnings that need to be resolved to
        /// complete the migration.</p>
        pub fn set_migration_status(
            mut self,
            input: std::option::Option<crate::model::MigrationStatus>,
        ) -> Self {
            self.migration_status = input;
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
        /// the Amazon Lex V1 bot to the new bot.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
        /// metadata and the locale being migrated. It doesn't change any other
        /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
        /// is created in the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn migration_strategy(mut self, input: crate::model::MigrationStrategy) -> Self {
            self.migration_strategy = Some(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
        /// the Amazon Lex V1 bot to the new bot.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
        /// metadata and the locale being migrated. It doesn't change any other
        /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
        /// is created in the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn set_migration_strategy(
            mut self,
            input: std::option::Option<crate::model::MigrationStrategy>,
        ) -> Self {
            self.migration_strategy = input;
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn migration_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.migration_timestamp = Some(input);
            self
        }
        /// <p>The date and time that the migration started.</p>
        pub fn set_migration_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.migration_timestamp = input;
            self
        }
        /// Appends an item to `alerts`.
        ///
        /// To override the contents of this collection use [`set_alerts`](Self::set_alerts).
        ///
        /// <p>A list of alerts and warnings that indicate issues with the migration
        /// for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1
        /// feature has a different implementation if Amazon Lex V2.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2
        /// developer guide</i>.</p>
        pub fn alerts(mut self, input: impl Into<crate::model::MigrationAlert>) -> Self {
            let mut v = self.alerts.unwrap_or_default();
            v.push(input.into());
            self.alerts = Some(v);
            self
        }
        /// <p>A list of alerts and warnings that indicate issues with the migration
        /// for the Amazon Lex V1 bot to Amazon Lex V2. You receive a warning when an Amazon Lex V1
        /// feature has a different implementation if Amazon Lex V2.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/migrate.html">Migrating a bot</a> in the <i>Amazon Lex V2
        /// developer guide</i>.</p>
        pub fn set_alerts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MigrationAlert>>,
        ) -> Self {
            self.alerts = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMigrationOutput`](crate::output::GetMigrationOutput)
        pub fn build(self) -> crate::output::GetMigrationOutput {
            crate::output::GetMigrationOutput {
                migration_id: self.migration_id,
                v1_bot_name: self.v1_bot_name,
                v1_bot_version: self.v1_bot_version,
                v1_bot_locale: self.v1_bot_locale,
                v2_bot_id: self.v2_bot_id,
                v2_bot_role: self.v2_bot_role,
                migration_status: self.migration_status,
                migration_strategy: self.migration_strategy,
                migration_timestamp: self.migration_timestamp,
                alerts: self.alerts,
            }
        }
    }
}
impl GetMigrationOutput {
    /// Creates a new builder-style object to manufacture [`GetMigrationOutput`](crate::output::GetMigrationOutput)
    pub fn builder() -> crate::output::get_migration_output::Builder {
        crate::output::get_migration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentVersionsOutput {
    /// <p>An array of <code>IntentMetadata</code> objects, one for each
    /// numbered version of the intent plus one for the <code>$LATEST</code>
    /// version.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
    /// <p>A pagination token for fetching the next page of intent versions.
    /// If the response to this call is truncated, Amazon Lex returns a pagination
    /// token in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntentVersionsOutput {
    /// <p>An array of <code>IntentMetadata</code> objects, one for each
    /// numbered version of the intent plus one for the <code>$LATEST</code>
    /// version.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::IntentMetadata]> {
        self.intents.as_deref()
    }
    /// <p>A pagination token for fetching the next page of intent versions.
    /// If the response to this call is truncated, Amazon Lex returns a pagination
    /// token in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntentVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentVersionsOutput");
        formatter.field("intents", &self.intents);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetIntentVersionsOutput`](crate::output::GetIntentVersionsOutput)
pub mod get_intent_versions_output {
    /// A builder for [`GetIntentVersionsOutput`](crate::output::GetIntentVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>IntentMetadata</code> objects, one for each
        /// numbered version of the intent plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn intents(mut self, input: impl Into<crate::model::IntentMetadata>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>IntentMetadata</code> objects, one for each
        /// numbered version of the intent plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions.
        /// If the response to this call is truncated, Amazon Lex returns a pagination
        /// token in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions.
        /// If the response to this call is truncated, Amazon Lex returns a pagination
        /// token in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentVersionsOutput`](crate::output::GetIntentVersionsOutput)
        pub fn build(self) -> crate::output::GetIntentVersionsOutput {
            crate::output::GetIntentVersionsOutput {
                intents: self.intents,
                next_token: self.next_token,
            }
        }
    }
}
impl GetIntentVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetIntentVersionsOutput`](crate::output::GetIntentVersionsOutput)
    pub fn builder() -> crate::output::get_intent_versions_output::Builder {
        crate::output::get_intent_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentsOutput {
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
    /// <p>If the response is truncated, the response includes a pagination
    /// token that you can specify in your next request to fetch the next page of
    /// intents. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetIntentsOutput {
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::IntentMetadata]> {
        self.intents.as_deref()
    }
    /// <p>If the response is truncated, the response includes a pagination
    /// token that you can specify in your next request to fetch the next page of
    /// intents. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetIntentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentsOutput");
        formatter.field("intents", &self.intents);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetIntentsOutput`](crate::output::GetIntentsOutput)
pub mod get_intents_output {
    /// A builder for [`GetIntentsOutput`](crate::output::GetIntentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn intents(mut self, input: impl Into<crate::model::IntentMetadata>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IntentMetadata>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>If the response is truncated, the response includes a pagination
        /// token that you can specify in your next request to fetch the next page of
        /// intents. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, the response includes a pagination
        /// token that you can specify in your next request to fetch the next page of
        /// intents. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentsOutput`](crate::output::GetIntentsOutput)
        pub fn build(self) -> crate::output::GetIntentsOutput {
            crate::output::GetIntentsOutput {
                intents: self.intents,
                next_token: self.next_token,
            }
        }
    }
}
impl GetIntentsOutput {
    /// Creates a new builder-style object to manufacture [`GetIntentsOutput`](crate::output::GetIntentsOutput)
    pub fn builder() -> crate::output::get_intents_output::Builder {
        crate::output::get_intents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentOutput {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of intent slots configured for the intent.</p>
    pub slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
    /// <p>An array of sample utterances configured for the intent.</p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If defined in the bot, Amazon Lex uses prompt to confirm the intent
    /// before fulfilling the user's request. For more information, see <a>PutIntent</a>. </p>
    pub confirmation_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub rejection_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined in the bot, Amazon Lex uses this prompt to solicit additional
    /// user activity after the intent is fulfilled. For more information, see
    /// <a>PutIntent</a>.</p>
    pub follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
    /// <p>After the Lambda function specified in the
    /// <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex
    /// conveys this statement to the user.</p>
    pub conclusion_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function
    /// for each user input. For more information, see <a>PutIntent</a>. </p>
    pub dialog_code_hook: std::option::Option<crate::model::CodeHook>,
    /// <p>Describes how the intent is fulfilled. For more information, see
    /// <a>PutIntent</a>. </p>
    pub fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
    /// <p>A unique identifier for a built-in intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The date that the intent was updated. When you create a resource,
    /// the creation date and the last updated date are the same. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the intent was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version of the intent.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the intent.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Configuration information, if any, to connect to an Amazon Kendra
    /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
}
impl GetIntentOutput {
    /// <p>The name of the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of intent slots configured for the intent.</p>
    pub fn slots(&self) -> std::option::Option<&[crate::model::Slot]> {
        self.slots.as_deref()
    }
    /// <p>An array of sample utterances configured for the intent.</p>
    pub fn sample_utterances(&self) -> std::option::Option<&[std::string::String]> {
        self.sample_utterances.as_deref()
    }
    /// <p>If defined in the bot, Amazon Lex uses prompt to confirm the intent
    /// before fulfilling the user's request. For more information, see <a>PutIntent</a>. </p>
    pub fn confirmation_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.confirmation_prompt.as_ref()
    }
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub fn rejection_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.rejection_statement.as_ref()
    }
    /// <p>If defined in the bot, Amazon Lex uses this prompt to solicit additional
    /// user activity after the intent is fulfilled. For more information, see
    /// <a>PutIntent</a>.</p>
    pub fn follow_up_prompt(&self) -> std::option::Option<&crate::model::FollowUpPrompt> {
        self.follow_up_prompt.as_ref()
    }
    /// <p>After the Lambda function specified in the
    /// <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex
    /// conveys this statement to the user.</p>
    pub fn conclusion_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.conclusion_statement.as_ref()
    }
    /// <p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function
    /// for each user input. For more information, see <a>PutIntent</a>. </p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::CodeHook> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>Describes how the intent is fulfilled. For more information, see
    /// <a>PutIntent</a>. </p>
    pub fn fulfillment_activity(&self) -> std::option::Option<&crate::model::FulfillmentActivity> {
        self.fulfillment_activity.as_ref()
    }
    /// <p>A unique identifier for a built-in intent.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>The date that the intent was updated. When you create a resource,
    /// the creation date and the last updated date are the same. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the intent was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version of the intent.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the intent.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Configuration information, if any, to connect to an Amazon Kendra
    /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
}
impl std::fmt::Debug for GetIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("slots", &self.slots);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("confirmation_prompt", &self.confirmation_prompt);
        formatter.field("rejection_statement", &self.rejection_statement);
        formatter.field("follow_up_prompt", &self.follow_up_prompt);
        formatter.field("conclusion_statement", &self.conclusion_statement);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_activity", &self.fulfillment_activity);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.finish()
    }
}
/// See [`GetIntentOutput`](crate::output::GetIntentOutput)
pub mod get_intent_output {
    /// A builder for [`GetIntentOutput`](crate::output::GetIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) confirmation_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) rejection_statement: std::option::Option<crate::model::Statement>,
        pub(crate) follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
        pub(crate) conclusion_statement: std::option::Option<crate::model::Statement>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::CodeHook>,
        pub(crate) fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of intent slots configured for the intent.</p>
        pub fn slots(mut self, input: impl Into<crate::model::Slot>) -> Self {
            let mut v = self.slots.unwrap_or_default();
            v.push(input.into());
            self.slots = Some(v);
            self
        }
        /// <p>An array of intent slots configured for the intent.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of sample utterances configured for the intent.</p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p>An array of sample utterances configured for the intent.</p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>If defined in the bot, Amazon Lex uses prompt to confirm the intent
        /// before fulfilling the user's request. For more information, see <a>PutIntent</a>. </p>
        pub fn confirmation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.confirmation_prompt = Some(input);
            self
        }
        /// <p>If defined in the bot, Amazon Lex uses prompt to confirm the intent
        /// before fulfilling the user's request. For more information, see <a>PutIntent</a>. </p>
        pub fn set_confirmation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.confirmation_prompt = input;
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.rejection_statement = Some(input);
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.rejection_statement = input;
            self
        }
        /// <p>If defined in the bot, Amazon Lex uses this prompt to solicit additional
        /// user activity after the intent is fulfilled. For more information, see
        /// <a>PutIntent</a>.</p>
        pub fn follow_up_prompt(mut self, input: crate::model::FollowUpPrompt) -> Self {
            self.follow_up_prompt = Some(input);
            self
        }
        /// <p>If defined in the bot, Amazon Lex uses this prompt to solicit additional
        /// user activity after the intent is fulfilled. For more information, see
        /// <a>PutIntent</a>.</p>
        pub fn set_follow_up_prompt(
            mut self,
            input: std::option::Option<crate::model::FollowUpPrompt>,
        ) -> Self {
            self.follow_up_prompt = input;
            self
        }
        /// <p>After the Lambda function specified in the
        /// <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex
        /// conveys this statement to the user.</p>
        pub fn conclusion_statement(mut self, input: crate::model::Statement) -> Self {
            self.conclusion_statement = Some(input);
            self
        }
        /// <p>After the Lambda function specified in the
        /// <code>fulfillmentActivity</code> element fulfills the intent, Amazon Lex
        /// conveys this statement to the user.</p>
        pub fn set_conclusion_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.conclusion_statement = input;
            self
        }
        /// <p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function
        /// for each user input. For more information, see <a>PutIntent</a>. </p>
        pub fn dialog_code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>If defined in the bot, Amazon Amazon Lex invokes this Lambda function
        /// for each user input. For more information, see <a>PutIntent</a>. </p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::CodeHook>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>Describes how the intent is fulfilled. For more information, see
        /// <a>PutIntent</a>. </p>
        pub fn fulfillment_activity(mut self, input: crate::model::FulfillmentActivity) -> Self {
            self.fulfillment_activity = Some(input);
            self
        }
        /// <p>Describes how the intent is fulfilled. For more information, see
        /// <a>PutIntent</a>. </p>
        pub fn set_fulfillment_activity(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivity>,
        ) -> Self {
            self.fulfillment_activity = input;
            self
        }
        /// <p>A unique identifier for a built-in intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for a built-in intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// <p>The date that the intent was updated. When you create a resource,
        /// the creation date and the last updated date are the same. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the intent was updated. When you create a resource,
        /// the creation date and the last updated date are the same. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version of the intent.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the intent.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the intent.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the intent.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Configuration information, if any, to connect to an Amazon Kendra
        /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information, if any, to connect to an Amazon Kendra
        /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn input_contexts(mut self, input: impl Into<crate::model::InputContext>) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input.into());
            self.input_contexts = Some(v);
            self
        }
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: impl Into<crate::model::OutputContext>) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input.into());
            self.output_contexts = Some(v);
            self
        }
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentOutput`](crate::output::GetIntentOutput)
        pub fn build(self) -> crate::output::GetIntentOutput {
            crate::output::GetIntentOutput {
                name: self.name,
                description: self.description,
                slots: self.slots,
                sample_utterances: self.sample_utterances,
                confirmation_prompt: self.confirmation_prompt,
                rejection_statement: self.rejection_statement,
                follow_up_prompt: self.follow_up_prompt,
                conclusion_statement: self.conclusion_statement,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_activity: self.fulfillment_activity,
                parent_intent_signature: self.parent_intent_signature,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                kendra_configuration: self.kendra_configuration,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
            }
        }
    }
}
impl GetIntentOutput {
    /// Creates a new builder-style object to manufacture [`GetIntentOutput`](crate::output::GetIntentOutput)
    pub fn builder() -> crate::output::get_intent_output::Builder {
        crate::output::get_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImportOutput {
    /// <p>The name given to the import job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of resource imported.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The action taken when there was a conflict between an existing
    /// resource and a resource in the import file.</p>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>The identifier for the specific import job.</p>
    pub import_id: std::option::Option<std::string::String>,
    /// <p>The status of the import job. If the status is <code>FAILED</code>,
    /// you can get the reason for the failure from the <code>failureReason</code>
    /// field.</p>
    pub import_status: std::option::Option<crate::model::ImportStatus>,
    /// <p>A string that describes why an import job failed to
    /// complete.</p>
    pub failure_reason: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A timestamp for the date and time that the import job was
    /// created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
}
impl GetImportOutput {
    /// <p>The name given to the import job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of resource imported.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The action taken when there was a conflict between an existing
    /// resource and a resource in the import file.</p>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>The identifier for the specific import job.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
    /// <p>The status of the import job. If the status is <code>FAILED</code>,
    /// you can get the reason for the failure from the <code>failureReason</code>
    /// field.</p>
    pub fn import_status(&self) -> std::option::Option<&crate::model::ImportStatus> {
        self.import_status.as_ref()
    }
    /// <p>A string that describes why an import job failed to
    /// complete.</p>
    pub fn failure_reason(&self) -> std::option::Option<&[std::string::String]> {
        self.failure_reason.as_deref()
    }
    /// <p>A timestamp for the date and time that the import job was
    /// created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
}
impl std::fmt::Debug for GetImportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImportOutput");
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("import_id", &self.import_id);
        formatter.field("import_status", &self.import_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("created_date", &self.created_date);
        formatter.finish()
    }
}
/// See [`GetImportOutput`](crate::output::GetImportOutput)
pub mod get_import_output {
    /// A builder for [`GetImportOutput`](crate::output::GetImportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) import_id: std::option::Option<std::string::String>,
        pub(crate) import_status: std::option::Option<crate::model::ImportStatus>,
        pub(crate) failure_reason: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name given to the import job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name given to the import job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of resource imported.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource imported.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The action taken when there was a conflict between an existing
        /// resource and a resource in the import file.</p>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>The action taken when there was a conflict between an existing
        /// resource and a resource in the import file.</p>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// <p>The identifier for the specific import job.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The identifier for the specific import job.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// <p>The status of the import job. If the status is <code>FAILED</code>,
        /// you can get the reason for the failure from the <code>failureReason</code>
        /// field.</p>
        pub fn import_status(mut self, input: crate::model::ImportStatus) -> Self {
            self.import_status = Some(input);
            self
        }
        /// <p>The status of the import job. If the status is <code>FAILED</code>,
        /// you can get the reason for the failure from the <code>failureReason</code>
        /// field.</p>
        pub fn set_import_status(
            mut self,
            input: std::option::Option<crate::model::ImportStatus>,
        ) -> Self {
            self.import_status = input;
            self
        }
        /// Appends an item to `failure_reason`.
        ///
        /// To override the contents of this collection use [`set_failure_reason`](Self::set_failure_reason).
        ///
        /// <p>A string that describes why an import job failed to
        /// complete.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.failure_reason.unwrap_or_default();
            v.push(input.into());
            self.failure_reason = Some(v);
            self
        }
        /// <p>A string that describes why an import job failed to
        /// complete.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>A timestamp for the date and time that the import job was
        /// created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>A timestamp for the date and time that the import job was
        /// created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImportOutput`](crate::output::GetImportOutput)
        pub fn build(self) -> crate::output::GetImportOutput {
            crate::output::GetImportOutput {
                name: self.name,
                resource_type: self.resource_type,
                merge_strategy: self.merge_strategy,
                import_id: self.import_id,
                import_status: self.import_status,
                failure_reason: self.failure_reason,
                created_date: self.created_date,
            }
        }
    }
}
impl GetImportOutput {
    /// Creates a new builder-style object to manufacture [`GetImportOutput`](crate::output::GetImportOutput)
    pub fn builder() -> crate::output::get_import_output::Builder {
        crate::output::get_import_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExportOutput {
    /// <p>The name of the bot being exported.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the bot being exported.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The type of the exported resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The format of the exported data.</p>
    pub export_type: std::option::Option<crate::model::ExportType>,
    /// <p>The status of the export. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The export is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>READY</code> - The export is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The export could not be
    /// completed.</p>
    /// </li>
    /// </ul>
    pub export_status: std::option::Option<crate::model::ExportStatus>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to export the resource.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>An S3 pre-signed URL that provides the location of the exported
    /// resource. The exported resource is a ZIP archive that contains the
    /// exported resource in JSON format. The structure of the archive may change.
    /// Your code should not rely on the archive structure.</p>
    pub url: std::option::Option<std::string::String>,
}
impl GetExportOutput {
    /// <p>The name of the bot being exported.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the bot being exported.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The type of the exported resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The format of the exported data.</p>
    pub fn export_type(&self) -> std::option::Option<&crate::model::ExportType> {
        self.export_type.as_ref()
    }
    /// <p>The status of the export. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The export is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>READY</code> - The export is complete.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The export could not be
    /// completed.</p>
    /// </li>
    /// </ul>
    pub fn export_status(&self) -> std::option::Option<&crate::model::ExportStatus> {
        self.export_status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to export the resource.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>An S3 pre-signed URL that provides the location of the exported
    /// resource. The exported resource is a ZIP archive that contains the
    /// exported resource in JSON format. The structure of the archive may change.
    /// Your code should not rely on the archive structure.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for GetExportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExportOutput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("export_type", &self.export_type);
        formatter.field("export_status", &self.export_status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`GetExportOutput`](crate::output::GetExportOutput)
pub mod get_export_output {
    /// A builder for [`GetExportOutput`](crate::output::GetExportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) export_type: std::option::Option<crate::model::ExportType>,
        pub(crate) export_status: std::option::Option<crate::model::ExportStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot being exported.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot being exported.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the bot being exported.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot being exported.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The type of the exported resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the exported resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn export_type(mut self, input: crate::model::ExportType) -> Self {
            self.export_type = Some(input);
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn set_export_type(
            mut self,
            input: std::option::Option<crate::model::ExportType>,
        ) -> Self {
            self.export_type = input;
            self
        }
        /// <p>The status of the export. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The export is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>READY</code> - The export is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The export could not be
        /// completed.</p>
        /// </li>
        /// </ul>
        pub fn export_status(mut self, input: crate::model::ExportStatus) -> Self {
            self.export_status = Some(input);
            self
        }
        /// <p>The status of the export. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The export is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>READY</code> - The export is complete.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The export could not be
        /// completed.</p>
        /// </li>
        /// </ul>
        pub fn set_export_status(
            mut self,
            input: std::option::Option<crate::model::ExportStatus>,
        ) -> Self {
            self.export_status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to export the resource.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to export the resource.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>An S3 pre-signed URL that provides the location of the exported
        /// resource. The exported resource is a ZIP archive that contains the
        /// exported resource in JSON format. The structure of the archive may change.
        /// Your code should not rely on the archive structure.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>An S3 pre-signed URL that provides the location of the exported
        /// resource. The exported resource is a ZIP archive that contains the
        /// exported resource in JSON format. The structure of the archive may change.
        /// Your code should not rely on the archive structure.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportOutput`](crate::output::GetExportOutput)
        pub fn build(self) -> crate::output::GetExportOutput {
            crate::output::GetExportOutput {
                name: self.name,
                version: self.version,
                resource_type: self.resource_type,
                export_type: self.export_type,
                export_status: self.export_status,
                failure_reason: self.failure_reason,
                url: self.url,
            }
        }
    }
}
impl GetExportOutput {
    /// Creates a new builder-style object to manufacture [`GetExportOutput`](crate::output::GetExportOutput)
    pub fn builder() -> crate::output::get_export_output::Builder {
        crate::output::get_export_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinSlotTypesOutput {
    /// <p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry
    /// for each slot type returned.</p>
    pub slot_types: std::option::Option<std::vec::Vec<crate::model::BuiltinSlotTypeMetadata>>,
    /// <p>If the response is truncated, the response includes a pagination
    /// token that you can use in your next request to fetch the next page of slot
    /// types.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBuiltinSlotTypesOutput {
    /// <p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry
    /// for each slot type returned.</p>
    pub fn slot_types(&self) -> std::option::Option<&[crate::model::BuiltinSlotTypeMetadata]> {
        self.slot_types.as_deref()
    }
    /// <p>If the response is truncated, the response includes a pagination
    /// token that you can use in your next request to fetch the next page of slot
    /// types.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBuiltinSlotTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinSlotTypesOutput");
        formatter.field("slot_types", &self.slot_types);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBuiltinSlotTypesOutput`](crate::output::GetBuiltinSlotTypesOutput)
pub mod get_builtin_slot_types_output {
    /// A builder for [`GetBuiltinSlotTypesOutput`](crate::output::GetBuiltinSlotTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) slot_types:
            std::option::Option<std::vec::Vec<crate::model::BuiltinSlotTypeMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `slot_types`.
        ///
        /// To override the contents of this collection use [`set_slot_types`](Self::set_slot_types).
        ///
        /// <p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry
        /// for each slot type returned.</p>
        pub fn slot_types(
            mut self,
            input: impl Into<crate::model::BuiltinSlotTypeMetadata>,
        ) -> Self {
            let mut v = self.slot_types.unwrap_or_default();
            v.push(input.into());
            self.slot_types = Some(v);
            self
        }
        /// <p>An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry
        /// for each slot type returned.</p>
        pub fn set_slot_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuiltinSlotTypeMetadata>>,
        ) -> Self {
            self.slot_types = input;
            self
        }
        /// <p>If the response is truncated, the response includes a pagination
        /// token that you can use in your next request to fetch the next page of slot
        /// types.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, the response includes a pagination
        /// token that you can use in your next request to fetch the next page of slot
        /// types.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinSlotTypesOutput`](crate::output::GetBuiltinSlotTypesOutput)
        pub fn build(self) -> crate::output::GetBuiltinSlotTypesOutput {
            crate::output::GetBuiltinSlotTypesOutput {
                slot_types: self.slot_types,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBuiltinSlotTypesOutput {
    /// Creates a new builder-style object to manufacture [`GetBuiltinSlotTypesOutput`](crate::output::GetBuiltinSlotTypesOutput)
    pub fn builder() -> crate::output::get_builtin_slot_types_output::Builder {
        crate::output::get_builtin_slot_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinIntentsOutput {
    /// <p>An array of <code>builtinIntentMetadata</code> objects, one for
    /// each intent in the response.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentMetadata>>,
    /// <p>A pagination token that fetches the next page of intents. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of intents, specify the pagination
    /// token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBuiltinIntentsOutput {
    /// <p>An array of <code>builtinIntentMetadata</code> objects, one for
    /// each intent in the response.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::BuiltinIntentMetadata]> {
        self.intents.as_deref()
    }
    /// <p>A pagination token that fetches the next page of intents. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of intents, specify the pagination
    /// token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBuiltinIntentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinIntentsOutput");
        formatter.field("intents", &self.intents);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBuiltinIntentsOutput`](crate::output::GetBuiltinIntentsOutput)
pub mod get_builtin_intents_output {
    /// A builder for [`GetBuiltinIntentsOutput`](crate::output::GetBuiltinIntentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>builtinIntentMetadata</code> objects, one for
        /// each intent in the response.</p>
        pub fn intents(mut self, input: impl Into<crate::model::BuiltinIntentMetadata>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>builtinIntentMetadata</code> objects, one for
        /// each intent in the response.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentMetadata>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of intents, specify the pagination
        /// token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of intents, specify the pagination
        /// token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinIntentsOutput`](crate::output::GetBuiltinIntentsOutput)
        pub fn build(self) -> crate::output::GetBuiltinIntentsOutput {
            crate::output::GetBuiltinIntentsOutput {
                intents: self.intents,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBuiltinIntentsOutput {
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentsOutput`](crate::output::GetBuiltinIntentsOutput)
    pub fn builder() -> crate::output::get_builtin_intents_output::Builder {
        crate::output::get_builtin_intents_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinIntentOutput {
    /// <p>The unique identifier for a built-in intent.</p>
    pub signature: std::option::Option<std::string::String>,
    /// <p>A list of locales that the intent supports.</p>
    pub supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
    /// <p>An array of <code>BuiltinIntentSlot</code> objects, one entry for
    /// each slot type in the intent.</p>
    pub slots: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentSlot>>,
}
impl GetBuiltinIntentOutput {
    /// <p>The unique identifier for a built-in intent.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
    /// <p>A list of locales that the intent supports.</p>
    pub fn supported_locales(&self) -> std::option::Option<&[crate::model::Locale]> {
        self.supported_locales.as_deref()
    }
    /// <p>An array of <code>BuiltinIntentSlot</code> objects, one entry for
    /// each slot type in the intent.</p>
    pub fn slots(&self) -> std::option::Option<&[crate::model::BuiltinIntentSlot]> {
        self.slots.as_deref()
    }
}
impl std::fmt::Debug for GetBuiltinIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinIntentOutput");
        formatter.field("signature", &self.signature);
        formatter.field("supported_locales", &self.supported_locales);
        formatter.field("slots", &self.slots);
        formatter.finish()
    }
}
/// See [`GetBuiltinIntentOutput`](crate::output::GetBuiltinIntentOutput)
pub mod get_builtin_intent_output {
    /// A builder for [`GetBuiltinIntentOutput`](crate::output::GetBuiltinIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature: std::option::Option<std::string::String>,
        pub(crate) supported_locales: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        pub(crate) slots: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentSlot>>,
    }
    impl Builder {
        /// <p>The unique identifier for a built-in intent.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>The unique identifier for a built-in intent.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Appends an item to `supported_locales`.
        ///
        /// To override the contents of this collection use [`set_supported_locales`](Self::set_supported_locales).
        ///
        /// <p>A list of locales that the intent supports.</p>
        pub fn supported_locales(mut self, input: impl Into<crate::model::Locale>) -> Self {
            let mut v = self.supported_locales.unwrap_or_default();
            v.push(input.into());
            self.supported_locales = Some(v);
            self
        }
        /// <p>A list of locales that the intent supports.</p>
        pub fn set_supported_locales(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Locale>>,
        ) -> Self {
            self.supported_locales = input;
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of <code>BuiltinIntentSlot</code> objects, one entry for
        /// each slot type in the intent.</p>
        pub fn slots(mut self, input: impl Into<crate::model::BuiltinIntentSlot>) -> Self {
            let mut v = self.slots.unwrap_or_default();
            v.push(input.into());
            self.slots = Some(v);
            self
        }
        /// <p>An array of <code>BuiltinIntentSlot</code> objects, one entry for
        /// each slot type in the intent.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuiltinIntentSlot>>,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinIntentOutput`](crate::output::GetBuiltinIntentOutput)
        pub fn build(self) -> crate::output::GetBuiltinIntentOutput {
            crate::output::GetBuiltinIntentOutput {
                signature: self.signature,
                supported_locales: self.supported_locales,
                slots: self.slots,
            }
        }
    }
}
impl GetBuiltinIntentOutput {
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentOutput`](crate::output::GetBuiltinIntentOutput)
    pub fn builder() -> crate::output::get_builtin_intent_output::Builder {
        crate::output::get_builtin_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotVersionsOutput {
    /// <p>An array of <code>BotMetadata</code> objects, one for each numbered
    /// version of the bot plus one for the <code>$LATEST</code>
    /// version.</p>
    pub bots: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
    /// <p>A pagination token for fetching the next page of bot versions. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBotVersionsOutput {
    /// <p>An array of <code>BotMetadata</code> objects, one for each numbered
    /// version of the bot plus one for the <code>$LATEST</code>
    /// version.</p>
    pub fn bots(&self) -> std::option::Option<&[crate::model::BotMetadata]> {
        self.bots.as_deref()
    }
    /// <p>A pagination token for fetching the next page of bot versions. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBotVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotVersionsOutput");
        formatter.field("bots", &self.bots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBotVersionsOutput`](crate::output::GetBotVersionsOutput)
pub mod get_bot_versions_output {
    /// A builder for [`GetBotVersionsOutput`](crate::output::GetBotVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bots: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bots`.
        ///
        /// To override the contents of this collection use [`set_bots`](Self::set_bots).
        ///
        /// <p>An array of <code>BotMetadata</code> objects, one for each numbered
        /// version of the bot plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn bots(mut self, input: impl Into<crate::model::BotMetadata>) -> Self {
            let mut v = self.bots.unwrap_or_default();
            v.push(input.into());
            self.bots = Some(v);
            self
        }
        /// <p>An array of <code>BotMetadata</code> objects, one for each numbered
        /// version of the bot plus one for the <code>$LATEST</code>
        /// version.</p>
        pub fn set_bots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
        ) -> Self {
            self.bots = input;
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotVersionsOutput`](crate::output::GetBotVersionsOutput)
        pub fn build(self) -> crate::output::GetBotVersionsOutput {
            crate::output::GetBotVersionsOutput {
                bots: self.bots,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBotVersionsOutput {
    /// Creates a new builder-style object to manufacture [`GetBotVersionsOutput`](crate::output::GetBotVersionsOutput)
    pub fn builder() -> crate::output::get_bot_versions_output::Builder {
        crate::output::get_bot_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotsOutput {
    /// <p>An array of <code>botMetadata</code> objects, with one entry for
    /// each bot. </p>
    pub bots: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
    /// <p>If the response is truncated, it includes a pagination token that
    /// you can specify in your next request to fetch the next page of bots.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBotsOutput {
    /// <p>An array of <code>botMetadata</code> objects, with one entry for
    /// each bot. </p>
    pub fn bots(&self) -> std::option::Option<&[crate::model::BotMetadata]> {
        self.bots.as_deref()
    }
    /// <p>If the response is truncated, it includes a pagination token that
    /// you can specify in your next request to fetch the next page of bots.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotsOutput");
        formatter.field("bots", &self.bots);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBotsOutput`](crate::output::GetBotsOutput)
pub mod get_bots_output {
    /// A builder for [`GetBotsOutput`](crate::output::GetBotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bots: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bots`.
        ///
        /// To override the contents of this collection use [`set_bots`](Self::set_bots).
        ///
        /// <p>An array of <code>botMetadata</code> objects, with one entry for
        /// each bot. </p>
        pub fn bots(mut self, input: impl Into<crate::model::BotMetadata>) -> Self {
            let mut v = self.bots.unwrap_or_default();
            v.push(input.into());
            self.bots = Some(v);
            self
        }
        /// <p>An array of <code>botMetadata</code> objects, with one entry for
        /// each bot. </p>
        pub fn set_bots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotMetadata>>,
        ) -> Self {
            self.bots = input;
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that
        /// you can specify in your next request to fetch the next page of bots.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, it includes a pagination token that
        /// you can specify in your next request to fetch the next page of bots.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotsOutput`](crate::output::GetBotsOutput)
        pub fn build(self) -> crate::output::GetBotsOutput {
            crate::output::GetBotsOutput {
                bots: self.bots,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBotsOutput {
    /// Creates a new builder-style object to manufacture [`GetBotsOutput`](crate::output::GetBotsOutput)
    pub fn builder() -> crate::output::get_bots_output::Builder {
        crate::output::get_bots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotChannelAssociationsOutput {
    /// <p>An array of objects, one for each association, that provides
    /// information about the Amazon Lex bot and its association with the channel.
    /// </p>
    pub bot_channel_associations:
        std::option::Option<std::vec::Vec<crate::model::BotChannelAssociation>>,
    /// <p>A pagination token that fetches the next page of associations. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of associations, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBotChannelAssociationsOutput {
    /// <p>An array of objects, one for each association, that provides
    /// information about the Amazon Lex bot and its association with the channel.
    /// </p>
    pub fn bot_channel_associations(
        &self,
    ) -> std::option::Option<&[crate::model::BotChannelAssociation]> {
        self.bot_channel_associations.as_deref()
    }
    /// <p>A pagination token that fetches the next page of associations. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of associations, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBotChannelAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotChannelAssociationsOutput");
        formatter.field("bot_channel_associations", &self.bot_channel_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBotChannelAssociationsOutput`](crate::output::GetBotChannelAssociationsOutput)
pub mod get_bot_channel_associations_output {
    /// A builder for [`GetBotChannelAssociationsOutput`](crate::output::GetBotChannelAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_channel_associations:
            std::option::Option<std::vec::Vec<crate::model::BotChannelAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bot_channel_associations`.
        ///
        /// To override the contents of this collection use [`set_bot_channel_associations`](Self::set_bot_channel_associations).
        ///
        /// <p>An array of objects, one for each association, that provides
        /// information about the Amazon Lex bot and its association with the channel.
        /// </p>
        pub fn bot_channel_associations(
            mut self,
            input: impl Into<crate::model::BotChannelAssociation>,
        ) -> Self {
            let mut v = self.bot_channel_associations.unwrap_or_default();
            v.push(input.into());
            self.bot_channel_associations = Some(v);
            self
        }
        /// <p>An array of objects, one for each association, that provides
        /// information about the Amazon Lex bot and its association with the channel.
        /// </p>
        pub fn set_bot_channel_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotChannelAssociation>>,
        ) -> Self {
            self.bot_channel_associations = input;
            self
        }
        /// <p>A pagination token that fetches the next page of associations. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of associations, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of associations. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of associations, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotChannelAssociationsOutput`](crate::output::GetBotChannelAssociationsOutput)
        pub fn build(self) -> crate::output::GetBotChannelAssociationsOutput {
            crate::output::GetBotChannelAssociationsOutput {
                bot_channel_associations: self.bot_channel_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBotChannelAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationsOutput`](crate::output::GetBotChannelAssociationsOutput)
    pub fn builder() -> crate::output::get_bot_channel_associations_output::Builder {
        crate::output::get_bot_channel_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotChannelAssociationOutput {
    /// <p>The name of the association between the bot and the
    /// channel.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the association between the bot and the
    /// channel.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The date that the association between the bot and the channel was
    /// created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of the messaging platform.</p>
    pub r#type: std::option::Option<crate::model::ChannelType>,
    /// <p>Provides information that the messaging platform needs to
    /// communicate with the Amazon Lex bot.</p>
    pub bot_configuration:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The status of the bot channel. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The channel has been created and is
    /// ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Channel creation is in
    /// progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - There was an error creating the channel.
    /// For information about the reason for the failure, see the
    /// <code>failureReason</code> field.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ChannelStatus>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to create the association.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl GetBotChannelAssociationOutput {
    /// <p>The name of the association between the bot and the
    /// channel.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the association between the bot and the
    /// channel.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
    /// <p>The name of the Amazon Lex bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The date that the association between the bot and the channel was
    /// created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The type of the messaging platform.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ChannelType> {
        self.r#type.as_ref()
    }
    /// <p>Provides information that the messaging platform needs to
    /// communicate with the Amazon Lex bot.</p>
    pub fn bot_configuration(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.bot_configuration.as_ref()
    }
    /// <p>The status of the bot channel. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATED</code> - The channel has been created and is
    /// ready for use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - Channel creation is in
    /// progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - There was an error creating the channel.
    /// For information about the reason for the failure, see the
    /// <code>failureReason</code> field.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ChannelStatus> {
        self.status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to create the association.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for GetBotChannelAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotChannelAssociationOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("created_date", &self.created_date);
        formatter.field("r#type", &self.r#type);
        formatter.field("bot_configuration", &"*** Sensitive Data Redacted ***");
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`GetBotChannelAssociationOutput`](crate::output::GetBotChannelAssociationOutput)
pub mod get_bot_channel_association_output {
    /// A builder for [`GetBotChannelAssociationOutput`](crate::output::GetBotChannelAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) r#type: std::option::Option<crate::model::ChannelType>,
        pub(crate) bot_configuration: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) status: std::option::Option<crate::model::ChannelStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the association between the bot and the
        /// channel.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the association between the bot and the
        /// channel.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the association between the bot and the
        /// channel.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the association between the bot and the
        /// channel.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The date that the association between the bot and the channel was
        /// created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the association between the bot and the channel was
        /// created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The type of the messaging platform.</p>
        pub fn r#type(mut self, input: crate::model::ChannelType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the messaging platform.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ChannelType>) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `bot_configuration`.
        ///
        /// To override the contents of this collection use [`set_bot_configuration`](Self::set_bot_configuration).
        ///
        /// <p>Provides information that the messaging platform needs to
        /// communicate with the Amazon Lex bot.</p>
        pub fn bot_configuration(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.bot_configuration.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.bot_configuration = Some(hash_map);
            self
        }
        /// <p>Provides information that the messaging platform needs to
        /// communicate with the Amazon Lex bot.</p>
        pub fn set_bot_configuration(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.bot_configuration = input;
            self
        }
        /// <p>The status of the bot channel. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The channel has been created and is
        /// ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Channel creation is in
        /// progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - There was an error creating the channel.
        /// For information about the reason for the failure, see the
        /// <code>failureReason</code> field.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ChannelStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the bot channel. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED</code> - The channel has been created and is
        /// ready for use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - Channel creation is in
        /// progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - There was an error creating the channel.
        /// For information about the reason for the failure, see the
        /// <code>failureReason</code> field.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChannelStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to create the association.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to create the association.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotChannelAssociationOutput`](crate::output::GetBotChannelAssociationOutput)
        pub fn build(self) -> crate::output::GetBotChannelAssociationOutput {
            crate::output::GetBotChannelAssociationOutput {
                name: self.name,
                description: self.description,
                bot_alias: self.bot_alias,
                bot_name: self.bot_name,
                created_date: self.created_date,
                r#type: self.r#type,
                bot_configuration: self.bot_configuration,
                status: self.status,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl GetBotChannelAssociationOutput {
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationOutput`](crate::output::GetBotChannelAssociationOutput)
    pub fn builder() -> crate::output::get_bot_channel_association_output::Builder {
        crate::output::get_bot_channel_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotAliasesOutput {
    /// <p>An array of <code>BotAliasMetadata</code> objects, each describing
    /// a bot alias.</p>
    pub bot_aliases: std::option::Option<std::vec::Vec<crate::model::BotAliasMetadata>>,
    /// <p>A pagination token for fetching next page of aliases. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of aliases, specify the pagination
    /// token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetBotAliasesOutput {
    /// <p>An array of <code>BotAliasMetadata</code> objects, each describing
    /// a bot alias.</p>
    pub fn bot_aliases(&self) -> std::option::Option<&[crate::model::BotAliasMetadata]> {
        self.bot_aliases.as_deref()
    }
    /// <p>A pagination token for fetching next page of aliases. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of aliases, specify the pagination
    /// token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetBotAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotAliasesOutput");
        formatter.field("bot_aliases", &self.bot_aliases);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetBotAliasesOutput`](crate::output::GetBotAliasesOutput)
pub mod get_bot_aliases_output {
    /// A builder for [`GetBotAliasesOutput`](crate::output::GetBotAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_aliases: std::option::Option<std::vec::Vec<crate::model::BotAliasMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `bot_aliases`.
        ///
        /// To override the contents of this collection use [`set_bot_aliases`](Self::set_bot_aliases).
        ///
        /// <p>An array of <code>BotAliasMetadata</code> objects, each describing
        /// a bot alias.</p>
        pub fn bot_aliases(mut self, input: impl Into<crate::model::BotAliasMetadata>) -> Self {
            let mut v = self.bot_aliases.unwrap_or_default();
            v.push(input.into());
            self.bot_aliases = Some(v);
            self
        }
        /// <p>An array of <code>BotAliasMetadata</code> objects, each describing
        /// a bot alias.</p>
        pub fn set_bot_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BotAliasMetadata>>,
        ) -> Self {
            self.bot_aliases = input;
            self
        }
        /// <p>A pagination token for fetching next page of aliases. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of aliases, specify the pagination
        /// token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching next page of aliases. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of aliases, specify the pagination
        /// token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotAliasesOutput`](crate::output::GetBotAliasesOutput)
        pub fn build(self) -> crate::output::GetBotAliasesOutput {
            crate::output::GetBotAliasesOutput {
                bot_aliases: self.bot_aliases,
                next_token: self.next_token,
            }
        }
    }
}
impl GetBotAliasesOutput {
    /// Creates a new builder-style object to manufacture [`GetBotAliasesOutput`](crate::output::GetBotAliasesOutput)
    pub fn builder() -> crate::output::get_bot_aliases_output::Builder {
        crate::output::get_bot_aliases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotAliasOutput {
    /// <p>The name of the bot alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot that the alias points to.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The name of the bot that the alias points to.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and the last updated date are the
    /// same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the bot alias was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Checksum of the bot alias.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
}
impl GetBotAliasOutput {
    /// <p>The name of the bot alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot that the alias points to.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The name of the bot that the alias points to.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>The date that the bot alias was updated. When you create a
    /// resource, the creation date and the last updated date are the
    /// same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot alias was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>Checksum of the bot alias.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The settings that determine how Amazon Lex uses conversation logs for the
    /// alias.</p>
    pub fn conversation_logs(
        &self,
    ) -> std::option::Option<&crate::model::ConversationLogsResponse> {
        self.conversation_logs.as_ref()
    }
}
impl std::fmt::Debug for GetBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotAliasOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("checksum", &self.checksum);
        formatter.field("conversation_logs", &self.conversation_logs);
        formatter.finish()
    }
}
/// See [`GetBotAliasOutput`](crate::output::GetBotAliasOutput)
pub mod get_bot_alias_output {
    /// A builder for [`GetBotAliasOutput`](crate::output::GetBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) conversation_logs: std::option::Option<crate::model::ConversationLogsResponse>,
    }
    impl Builder {
        /// <p>The name of the bot alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot that the alias points to.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot that the alias points to.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and the last updated date are the
        /// same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was updated. When you create a
        /// resource, the creation date and the last updated date are the
        /// same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot alias was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>Checksum of the bot alias.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the bot alias.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn conversation_logs(mut self, input: crate::model::ConversationLogsResponse) -> Self {
            self.conversation_logs = Some(input);
            self
        }
        /// <p>The settings that determine how Amazon Lex uses conversation logs for the
        /// alias.</p>
        pub fn set_conversation_logs(
            mut self,
            input: std::option::Option<crate::model::ConversationLogsResponse>,
        ) -> Self {
            self.conversation_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotAliasOutput`](crate::output::GetBotAliasOutput)
        pub fn build(self) -> crate::output::GetBotAliasOutput {
            crate::output::GetBotAliasOutput {
                name: self.name,
                description: self.description,
                bot_version: self.bot_version,
                bot_name: self.bot_name,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                checksum: self.checksum,
                conversation_logs: self.conversation_logs,
            }
        }
    }
}
impl GetBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`GetBotAliasOutput`](crate::output::GetBotAliasOutput)
    pub fn builder() -> crate::output::get_bot_alias_output::Builder {
        crate::output::get_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotOutput {
    /// <p>The name of the bot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of <code>intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub enable_model_improvements: std::option::Option<bool>,
    /// <p>The score that determines where Amazon Lex inserts the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
    /// for all intents is below this value.
    /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
    /// configured for the bot.</p>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>The message Amazon Lex uses when it doesn't understand the user's
    /// request. For more information, see <a>PutBot</a>. </p>
    pub clarification_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>The message that Amazon Lex returns when the user elects to end the
    /// conversation without completing it. For more information, see <a>PutBot</a>.</p>
    pub abort_statement: std::option::Option<crate::model::Statement>,
    /// <p>The status of the bot. </p>
    /// <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot
    /// for testing and use.</p>
    /// <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you
    /// can test the bot using the exact utterances specified in the bot's
    /// intents. When the bot is ready for full testing or to run, the status is
    /// <code>READY</code>.</p>
    /// <p>If there was a problem with building the bot, the status is
    /// <code>FAILED</code> and the <code>failureReason</code> field explains
    /// why the bot did not build.</p>
    /// <p>If the bot was saved but not built, the status is
    /// <code>NOT_BUILT</code>.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why
    /// it failed to build the bot.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date that the bot was updated. When you create a resource, the
    /// creation date and last updated date are the same. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the bot was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
    /// with the user. For more information, see <a>PutBot</a>.</p>
    pub voice_id: std::option::Option<std::string::String>,
    /// <p>Checksum of the bot used to identify a specific revision of the
    /// bot's <code>$LATEST</code> version.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p> The target locale for the bot. </p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub child_directed: std::option::Option<bool>,
    /// <p>Indicates whether user utterances should be sent to Amazon Comprehend
    /// for sentiment analysis.</p>
    pub detect_sentiment: std::option::Option<bool>,
}
impl GetBotOutput {
    /// <p>The name of the bot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of <code>intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::Intent]> {
        self.intents.as_deref()
    }
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub fn enable_model_improvements(&self) -> std::option::Option<bool> {
        self.enable_model_improvements
    }
    /// <p>The score that determines where Amazon Lex inserts the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
    /// for all intents is below this value.
    /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
    /// configured for the bot.</p>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>The message Amazon Lex uses when it doesn't understand the user's
    /// request. For more information, see <a>PutBot</a>. </p>
    pub fn clarification_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.clarification_prompt.as_ref()
    }
    /// <p>The message that Amazon Lex returns when the user elects to end the
    /// conversation without completing it. For more information, see <a>PutBot</a>.</p>
    pub fn abort_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.abort_statement.as_ref()
    }
    /// <p>The status of the bot. </p>
    /// <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot
    /// for testing and use.</p>
    /// <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you
    /// can test the bot using the exact utterances specified in the bot's
    /// intents. When the bot is ready for full testing or to run, the status is
    /// <code>READY</code>.</p>
    /// <p>If there was a problem with building the bot, the status is
    /// <code>FAILED</code> and the <code>failureReason</code> field explains
    /// why the bot did not build.</p>
    /// <p>If the bot was saved but not built, the status is
    /// <code>NOT_BUILT</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why
    /// it failed to build the bot.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date that the bot was updated. When you create a resource, the
    /// creation date and last updated date are the same. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the bot was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
    /// with the user. For more information, see <a>PutBot</a>.</p>
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
    /// <p>Checksum of the bot used to identify a specific revision of the
    /// bot's <code>$LATEST</code> version.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The version of the bot. For a new bot, the version is always
    /// <code>$LATEST</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p> The target locale for the bot. </p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub fn child_directed(&self) -> std::option::Option<bool> {
        self.child_directed
    }
    /// <p>Indicates whether user utterances should be sent to Amazon Comprehend
    /// for sentiment analysis.</p>
    pub fn detect_sentiment(&self) -> std::option::Option<bool> {
        self.detect_sentiment
    }
}
impl std::fmt::Debug for GetBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("intents", &self.intents);
        formatter.field("enable_model_improvements", &self.enable_model_improvements);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("clarification_prompt", &self.clarification_prompt);
        formatter.field("abort_statement", &self.abort_statement);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("voice_id", &self.voice_id);
        formatter.field("checksum", &self.checksum);
        formatter.field("version", &self.version);
        formatter.field("locale", &self.locale);
        formatter.field("child_directed", &self.child_directed);
        formatter.field("detect_sentiment", &self.detect_sentiment);
        formatter.finish()
    }
}
/// See [`GetBotOutput`](crate::output::GetBotOutput)
pub mod get_bot_output {
    /// A builder for [`GetBotOutput`](crate::output::GetBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        pub(crate) enable_model_improvements: std::option::Option<bool>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) clarification_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) abort_statement: std::option::Option<crate::model::Statement>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) child_directed: std::option::Option<bool>,
        pub(crate) detect_sentiment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn intents(mut self, input: impl Into<crate::model::Intent>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn enable_model_improvements(mut self, input: bool) -> Self {
            self.enable_model_improvements = Some(input);
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn set_enable_model_improvements(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_model_improvements = input;
            self
        }
        /// <p>The score that determines where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
        /// for all intents is below this value.
        /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
        /// configured for the bot.</p>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>The score that determines where Amazon Lex inserts the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> is inserted if the confidence score
        /// for all intents is below this value.
        /// <code>AMAZON.KendraSearchIntent</code> is only inserted if it is
        /// configured for the bot.</p>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>The message Amazon Lex uses when it doesn't understand the user's
        /// request. For more information, see <a>PutBot</a>. </p>
        pub fn clarification_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.clarification_prompt = Some(input);
            self
        }
        /// <p>The message Amazon Lex uses when it doesn't understand the user's
        /// request. For more information, see <a>PutBot</a>. </p>
        pub fn set_clarification_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.clarification_prompt = input;
            self
        }
        /// <p>The message that Amazon Lex returns when the user elects to end the
        /// conversation without completing it. For more information, see <a>PutBot</a>.</p>
        pub fn abort_statement(mut self, input: crate::model::Statement) -> Self {
            self.abort_statement = Some(input);
            self
        }
        /// <p>The message that Amazon Lex returns when the user elects to end the
        /// conversation without completing it. For more information, see <a>PutBot</a>.</p>
        pub fn set_abort_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.abort_statement = input;
            self
        }
        /// <p>The status of the bot. </p>
        /// <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot
        /// for testing and use.</p>
        /// <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you
        /// can test the bot using the exact utterances specified in the bot's
        /// intents. When the bot is ready for full testing or to run, the status is
        /// <code>READY</code>.</p>
        /// <p>If there was a problem with building the bot, the status is
        /// <code>FAILED</code> and the <code>failureReason</code> field explains
        /// why the bot did not build.</p>
        /// <p>If the bot was saved but not built, the status is
        /// <code>NOT_BUILT</code>.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the bot. </p>
        /// <p>When the status is <code>BUILDING</code> Amazon Lex is building the bot
        /// for testing and use.</p>
        /// <p>If the status of the bot is <code>READY_BASIC_TESTING</code>, you
        /// can test the bot using the exact utterances specified in the bot's
        /// intents. When the bot is ready for full testing or to run, the status is
        /// <code>READY</code>.</p>
        /// <p>If there was a problem with building the bot, the status is
        /// <code>FAILED</code> and the <code>failureReason</code> field explains
        /// why the bot did not build.</p>
        /// <p>If the bot was saved but not built, the status is
        /// <code>NOT_BUILT</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why
        /// it failed to build the bot.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex explains why
        /// it failed to build the bot.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date that the bot was updated. When you create a resource, the
        /// creation date and last updated date are the same. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the bot was updated. When you create a resource, the
        /// creation date and last updated date are the same. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the bot was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
        /// with the user. For more information, see <a>PutBot</a>.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interaction
        /// with the user. For more information, see <a>PutBot</a>.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// <p>Checksum of the bot used to identify a specific revision of the
        /// bot's <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the bot used to identify a specific revision of the
        /// bot's <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot. For a new bot, the version is always
        /// <code>$LATEST</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p> The target locale for the bot. </p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p> The target locale for the bot. </p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.child_directed = Some(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.child_directed = input;
            self
        }
        /// <p>Indicates whether user utterances should be sent to Amazon Comprehend
        /// for sentiment analysis.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.detect_sentiment = Some(input);
            self
        }
        /// <p>Indicates whether user utterances should be sent to Amazon Comprehend
        /// for sentiment analysis.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.detect_sentiment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotOutput`](crate::output::GetBotOutput)
        pub fn build(self) -> crate::output::GetBotOutput {
            crate::output::GetBotOutput {
                name: self.name,
                description: self.description,
                intents: self.intents,
                enable_model_improvements: self.enable_model_improvements,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                clarification_prompt: self.clarification_prompt,
                abort_statement: self.abort_statement,
                status: self.status,
                failure_reason: self.failure_reason,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                voice_id: self.voice_id,
                checksum: self.checksum,
                version: self.version,
                locale: self.locale,
                child_directed: self.child_directed,
                detect_sentiment: self.detect_sentiment,
            }
        }
    }
}
impl GetBotOutput {
    /// Creates a new builder-style object to manufacture [`GetBotOutput`](crate::output::GetBotOutput)
    pub fn builder() -> crate::output::get_bot_output::Builder {
        crate::output::get_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUtterancesOutput {}
impl std::fmt::Debug for DeleteUtterancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUtterancesOutput");
        formatter.finish()
    }
}
/// See [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
pub mod delete_utterances_output {
    /// A builder for [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
        pub fn build(self) -> crate::output::DeleteUtterancesOutput {
            crate::output::DeleteUtterancesOutput {}
        }
    }
}
impl DeleteUtterancesOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesOutput`](crate::output::DeleteUtterancesOutput)
    pub fn builder() -> crate::output::delete_utterances_output::Builder {
        crate::output::delete_utterances_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeVersionOutput {}
impl std::fmt::Debug for DeleteSlotTypeVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteSlotTypeVersionOutput`](crate::output::DeleteSlotTypeVersionOutput)
pub mod delete_slot_type_version_output {
    /// A builder for [`DeleteSlotTypeVersionOutput`](crate::output::DeleteSlotTypeVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSlotTypeVersionOutput`](crate::output::DeleteSlotTypeVersionOutput)
        pub fn build(self) -> crate::output::DeleteSlotTypeVersionOutput {
            crate::output::DeleteSlotTypeVersionOutput {}
        }
    }
}
impl DeleteSlotTypeVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeVersionOutput`](crate::output::DeleteSlotTypeVersionOutput)
    pub fn builder() -> crate::output::delete_slot_type_version_output::Builder {
        crate::output::delete_slot_type_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeOutput {}
impl std::fmt::Debug for DeleteSlotTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeOutput");
        formatter.finish()
    }
}
/// See [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
pub mod delete_slot_type_output {
    /// A builder for [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
        pub fn build(self) -> crate::output::DeleteSlotTypeOutput {
            crate::output::DeleteSlotTypeOutput {}
        }
    }
}
impl DeleteSlotTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeOutput`](crate::output::DeleteSlotTypeOutput)
    pub fn builder() -> crate::output::delete_slot_type_output::Builder {
        crate::output::delete_slot_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentVersionOutput {}
impl std::fmt::Debug for DeleteIntentVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteIntentVersionOutput`](crate::output::DeleteIntentVersionOutput)
pub mod delete_intent_version_output {
    /// A builder for [`DeleteIntentVersionOutput`](crate::output::DeleteIntentVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIntentVersionOutput`](crate::output::DeleteIntentVersionOutput)
        pub fn build(self) -> crate::output::DeleteIntentVersionOutput {
            crate::output::DeleteIntentVersionOutput {}
        }
    }
}
impl DeleteIntentVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntentVersionOutput`](crate::output::DeleteIntentVersionOutput)
    pub fn builder() -> crate::output::delete_intent_version_output::Builder {
        crate::output::delete_intent_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentOutput {}
impl std::fmt::Debug for DeleteIntentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentOutput");
        formatter.finish()
    }
}
/// See [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
pub mod delete_intent_output {
    /// A builder for [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
        pub fn build(self) -> crate::output::DeleteIntentOutput {
            crate::output::DeleteIntentOutput {}
        }
    }
}
impl DeleteIntentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntentOutput`](crate::output::DeleteIntentOutput)
    pub fn builder() -> crate::output::delete_intent_output::Builder {
        crate::output::delete_intent_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotVersionOutput {}
impl std::fmt::Debug for DeleteBotVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
pub mod delete_bot_version_output {
    /// A builder for [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
        pub fn build(self) -> crate::output::DeleteBotVersionOutput {
            crate::output::DeleteBotVersionOutput {}
        }
    }
}
impl DeleteBotVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionOutput`](crate::output::DeleteBotVersionOutput)
    pub fn builder() -> crate::output::delete_bot_version_output::Builder {
        crate::output::delete_bot_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotChannelAssociationOutput {}
impl std::fmt::Debug for DeleteBotChannelAssociationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotChannelAssociationOutput");
        formatter.finish()
    }
}
/// See [`DeleteBotChannelAssociationOutput`](crate::output::DeleteBotChannelAssociationOutput)
pub mod delete_bot_channel_association_output {
    /// A builder for [`DeleteBotChannelAssociationOutput`](crate::output::DeleteBotChannelAssociationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBotChannelAssociationOutput`](crate::output::DeleteBotChannelAssociationOutput)
        pub fn build(self) -> crate::output::DeleteBotChannelAssociationOutput {
            crate::output::DeleteBotChannelAssociationOutput {}
        }
    }
}
impl DeleteBotChannelAssociationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotChannelAssociationOutput`](crate::output::DeleteBotChannelAssociationOutput)
    pub fn builder() -> crate::output::delete_bot_channel_association_output::Builder {
        crate::output::delete_bot_channel_association_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotAliasOutput {}
impl std::fmt::Debug for DeleteBotAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
pub mod delete_bot_alias_output {
    /// A builder for [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
        pub fn build(self) -> crate::output::DeleteBotAliasOutput {
            crate::output::DeleteBotAliasOutput {}
        }
    }
}
impl DeleteBotAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasOutput`](crate::output::DeleteBotAliasOutput)
    pub fn builder() -> crate::output::delete_bot_alias_output::Builder {
        crate::output::delete_bot_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotOutput {}
impl std::fmt::Debug for DeleteBotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotOutput");
        formatter.finish()
    }
}
/// See [`DeleteBotOutput`](crate::output::DeleteBotOutput)
pub mod delete_bot_output {
    /// A builder for [`DeleteBotOutput`](crate::output::DeleteBotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteBotOutput`](crate::output::DeleteBotOutput)
        pub fn build(self) -> crate::output::DeleteBotOutput {
            crate::output::DeleteBotOutput {}
        }
    }
}
impl DeleteBotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBotOutput`](crate::output::DeleteBotOutput)
    pub fn builder() -> crate::output::delete_bot_output::Builder {
        crate::output::delete_bot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotTypeVersionOutput {
    /// <p>The name of the slot type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub enumeration_values: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last update date are the same.</p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the slot type was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version assigned to the new slot type version. </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
    /// For more information, see <a>PutSlotType</a>.</p>
    pub value_selection_strategy: std::option::Option<crate::model::SlotValueSelectionStrategy>,
    /// <p>The built-in slot type used a the parent of the slot type.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub slot_type_configurations:
        std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
}
impl CreateSlotTypeVersionOutput {
    /// <p>The name of the slot type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take.</p>
    pub fn enumeration_values(&self) -> std::option::Option<&[crate::model::EnumerationValue]> {
        self.enumeration_values.as_deref()
    }
    /// <p>The date that the slot type was updated. When you create a
    /// resource, the creation date and last update date are the same.</p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the slot type was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version assigned to the new slot type version. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the <code>$LATEST</code> version of the slot
    /// type.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
    /// For more information, see <a>PutSlotType</a>.</p>
    pub fn value_selection_strategy(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionStrategy> {
        self.value_selection_strategy.as_ref()
    }
    /// <p>The built-in slot type used a the parent of the slot type.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>Configuration information that extends the parent built-in slot
    /// type.</p>
    pub fn slot_type_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SlotTypeConfiguration]> {
        self.slot_type_configurations.as_deref()
    }
}
impl std::fmt::Debug for CreateSlotTypeVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotTypeVersionOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("enumeration_values", &self.enumeration_values);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("value_selection_strategy", &self.value_selection_strategy);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("slot_type_configurations", &self.slot_type_configurations);
        formatter.finish()
    }
}
/// See [`CreateSlotTypeVersionOutput`](crate::output::CreateSlotTypeVersionOutput)
pub mod create_slot_type_version_output {
    /// A builder for [`CreateSlotTypeVersionOutput`](crate::output::CreateSlotTypeVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enumeration_values:
            std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) value_selection_strategy:
            std::option::Option<crate::model::SlotValueSelectionStrategy>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) slot_type_configurations:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
    }
    impl Builder {
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `enumeration_values`.
        ///
        /// To override the contents of this collection use [`set_enumeration_values`](Self::set_enumeration_values).
        ///
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn enumeration_values(
            mut self,
            input: impl Into<crate::model::EnumerationValue>,
        ) -> Self {
            let mut v = self.enumeration_values.unwrap_or_default();
            v.push(input.into());
            self.enumeration_values = Some(v);
            self
        }
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take.</p>
        pub fn set_enumeration_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        ) -> Self {
            self.enumeration_values = input;
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last update date are the same.</p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the slot type was updated. When you create a
        /// resource, the creation date and last update date are the same.</p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the slot type was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version assigned to the new slot type version. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version assigned to the new slot type version. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the slot
        /// type.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
        /// For more information, see <a>PutSlotType</a>.</p>
        pub fn value_selection_strategy(
            mut self,
            input: crate::model::SlotValueSelectionStrategy,
        ) -> Self {
            self.value_selection_strategy = Some(input);
            self
        }
        /// <p>The strategy that Amazon Lex uses to determine the value of the slot.
        /// For more information, see <a>PutSlotType</a>.</p>
        pub fn set_value_selection_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionStrategy>,
        ) -> Self {
            self.value_selection_strategy = input;
            self
        }
        /// <p>The built-in slot type used a the parent of the slot type.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built-in slot type used a the parent of the slot type.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// Appends an item to `slot_type_configurations`.
        ///
        /// To override the contents of this collection use [`set_slot_type_configurations`](Self::set_slot_type_configurations).
        ///
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn slot_type_configurations(
            mut self,
            input: impl Into<crate::model::SlotTypeConfiguration>,
        ) -> Self {
            let mut v = self.slot_type_configurations.unwrap_or_default();
            v.push(input.into());
            self.slot_type_configurations = Some(v);
            self
        }
        /// <p>Configuration information that extends the parent built-in slot
        /// type.</p>
        pub fn set_slot_type_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
        ) -> Self {
            self.slot_type_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotTypeVersionOutput`](crate::output::CreateSlotTypeVersionOutput)
        pub fn build(self) -> crate::output::CreateSlotTypeVersionOutput {
            crate::output::CreateSlotTypeVersionOutput {
                name: self.name,
                description: self.description,
                enumeration_values: self.enumeration_values,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                value_selection_strategy: self.value_selection_strategy,
                parent_slot_type_signature: self.parent_slot_type_signature,
                slot_type_configurations: self.slot_type_configurations,
            }
        }
    }
}
impl CreateSlotTypeVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeVersionOutput`](crate::output::CreateSlotTypeVersionOutput)
    pub fn builder() -> crate::output::create_slot_type_version_output::Builder {
        crate::output::create_slot_type_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntentVersionOutput {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of slot types that defines the information required to
    /// fulfill the intent.</p>
    pub slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
    /// <p>An array of sample utterances configured for the intent. </p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If defined, the prompt that Amazon Lex uses to confirm the user's
    /// intent before fulfilling it. </p>
    pub confirmation_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub rejection_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined, Amazon Lex uses this prompt to solicit additional user
    /// activity after the intent is fulfilled. </p>
    pub follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
    /// <p>After the Lambda function specified in the
    /// <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex
    /// conveys this statement to the user. </p>
    pub conclusion_statement: std::option::Option<crate::model::Statement>,
    /// <p>If defined, Amazon Lex invokes this Lambda function for each user
    /// input.</p>
    pub dialog_code_hook: std::option::Option<crate::model::CodeHook>,
    /// <p> Describes how the intent is fulfilled. </p>
    pub fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
    /// <p>A unique identifier for a built-in intent.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>The date that the intent was updated. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the intent was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The version number assigned to the new version of the
    /// intent.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>Checksum of the intent version created.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Configuration information, if any, for connecting an Amazon Kendra
    /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
}
impl CreateIntentVersionOutput {
    /// <p>The name of the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of slot types that defines the information required to
    /// fulfill the intent.</p>
    pub fn slots(&self) -> std::option::Option<&[crate::model::Slot]> {
        self.slots.as_deref()
    }
    /// <p>An array of sample utterances configured for the intent. </p>
    pub fn sample_utterances(&self) -> std::option::Option<&[std::string::String]> {
        self.sample_utterances.as_deref()
    }
    /// <p>If defined, the prompt that Amazon Lex uses to confirm the user's
    /// intent before fulfilling it. </p>
    pub fn confirmation_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.confirmation_prompt.as_ref()
    }
    /// <p>If the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    pub fn rejection_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.rejection_statement.as_ref()
    }
    /// <p>If defined, Amazon Lex uses this prompt to solicit additional user
    /// activity after the intent is fulfilled. </p>
    pub fn follow_up_prompt(&self) -> std::option::Option<&crate::model::FollowUpPrompt> {
        self.follow_up_prompt.as_ref()
    }
    /// <p>After the Lambda function specified in the
    /// <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex
    /// conveys this statement to the user. </p>
    pub fn conclusion_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.conclusion_statement.as_ref()
    }
    /// <p>If defined, Amazon Lex invokes this Lambda function for each user
    /// input.</p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::CodeHook> {
        self.dialog_code_hook.as_ref()
    }
    /// <p> Describes how the intent is fulfilled. </p>
    pub fn fulfillment_activity(&self) -> std::option::Option<&crate::model::FulfillmentActivity> {
        self.fulfillment_activity.as_ref()
    }
    /// <p>A unique identifier for a built-in intent.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>The date that the intent was updated. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date that the intent was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The version number assigned to the new version of the
    /// intent.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>Checksum of the intent version created.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Configuration information, if any, for connecting an Amazon Kendra
    /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
}
impl std::fmt::Debug for CreateIntentVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntentVersionOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("slots", &self.slots);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("confirmation_prompt", &self.confirmation_prompt);
        formatter.field("rejection_statement", &self.rejection_statement);
        formatter.field("follow_up_prompt", &self.follow_up_prompt);
        formatter.field("conclusion_statement", &self.conclusion_statement);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_activity", &self.fulfillment_activity);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("checksum", &self.checksum);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.finish()
    }
}
/// See [`CreateIntentVersionOutput`](crate::output::CreateIntentVersionOutput)
pub mod create_intent_version_output {
    /// A builder for [`CreateIntentVersionOutput`](crate::output::CreateIntentVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) confirmation_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) rejection_statement: std::option::Option<crate::model::Statement>,
        pub(crate) follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
        pub(crate) conclusion_statement: std::option::Option<crate::model::Statement>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::CodeHook>,
        pub(crate) fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of slot types that defines the information required to
        /// fulfill the intent.</p>
        pub fn slots(mut self, input: impl Into<crate::model::Slot>) -> Self {
            let mut v = self.slots.unwrap_or_default();
            v.push(input.into());
            self.slots = Some(v);
            self
        }
        /// <p>An array of slot types that defines the information required to
        /// fulfill the intent.</p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of sample utterances configured for the intent. </p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p>An array of sample utterances configured for the intent. </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>If defined, the prompt that Amazon Lex uses to confirm the user's
        /// intent before fulfilling it. </p>
        pub fn confirmation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.confirmation_prompt = Some(input);
            self
        }
        /// <p>If defined, the prompt that Amazon Lex uses to confirm the user's
        /// intent before fulfilling it. </p>
        pub fn set_confirmation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.confirmation_prompt = input;
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.rejection_statement = Some(input);
            self
        }
        /// <p>If the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.rejection_statement = input;
            self
        }
        /// <p>If defined, Amazon Lex uses this prompt to solicit additional user
        /// activity after the intent is fulfilled. </p>
        pub fn follow_up_prompt(mut self, input: crate::model::FollowUpPrompt) -> Self {
            self.follow_up_prompt = Some(input);
            self
        }
        /// <p>If defined, Amazon Lex uses this prompt to solicit additional user
        /// activity after the intent is fulfilled. </p>
        pub fn set_follow_up_prompt(
            mut self,
            input: std::option::Option<crate::model::FollowUpPrompt>,
        ) -> Self {
            self.follow_up_prompt = input;
            self
        }
        /// <p>After the Lambda function specified in the
        /// <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex
        /// conveys this statement to the user. </p>
        pub fn conclusion_statement(mut self, input: crate::model::Statement) -> Self {
            self.conclusion_statement = Some(input);
            self
        }
        /// <p>After the Lambda function specified in the
        /// <code>fulfillmentActivity</code> field fulfills the intent, Amazon Lex
        /// conveys this statement to the user. </p>
        pub fn set_conclusion_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.conclusion_statement = input;
            self
        }
        /// <p>If defined, Amazon Lex invokes this Lambda function for each user
        /// input.</p>
        pub fn dialog_code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p>If defined, Amazon Lex invokes this Lambda function for each user
        /// input.</p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::CodeHook>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p> Describes how the intent is fulfilled. </p>
        pub fn fulfillment_activity(mut self, input: crate::model::FulfillmentActivity) -> Self {
            self.fulfillment_activity = Some(input);
            self
        }
        /// <p> Describes how the intent is fulfilled. </p>
        pub fn set_fulfillment_activity(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivity>,
        ) -> Self {
            self.fulfillment_activity = input;
            self
        }
        /// <p>A unique identifier for a built-in intent.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for a built-in intent.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// <p>The date that the intent was updated. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date that the intent was updated. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date that the intent was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version number assigned to the new version of the
        /// intent.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number assigned to the new version of the
        /// intent.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>Checksum of the intent version created.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the intent version created.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Configuration information, if any, for connecting an Amazon Kendra
        /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information, if any, for connecting an Amazon Kendra
        /// index with the <code>AMAZON.KendraSearchIntent</code> intent.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn input_contexts(mut self, input: impl Into<crate::model::InputContext>) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input.into());
            self.input_contexts = Some(v);
            self
        }
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: impl Into<crate::model::OutputContext>) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input.into());
            self.output_contexts = Some(v);
            self
        }
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntentVersionOutput`](crate::output::CreateIntentVersionOutput)
        pub fn build(self) -> crate::output::CreateIntentVersionOutput {
            crate::output::CreateIntentVersionOutput {
                name: self.name,
                description: self.description,
                slots: self.slots,
                sample_utterances: self.sample_utterances,
                confirmation_prompt: self.confirmation_prompt,
                rejection_statement: self.rejection_statement,
                follow_up_prompt: self.follow_up_prompt,
                conclusion_statement: self.conclusion_statement,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_activity: self.fulfillment_activity,
                parent_intent_signature: self.parent_intent_signature,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                version: self.version,
                checksum: self.checksum,
                kendra_configuration: self.kendra_configuration,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
            }
        }
    }
}
impl CreateIntentVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateIntentVersionOutput`](crate::output::CreateIntentVersionOutput)
    pub fn builder() -> crate::output::create_intent_version_output::Builder {
        crate::output::create_intent_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotVersionOutput {
    /// <p>The name of the bot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
    /// <p>The message that Amazon Lex uses when it doesn't understand the user's
    /// request. For more information, see <a>PutBot</a>. </p>
    pub clarification_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>The message that Amazon Lex uses to cancel a conversation. For more
    /// information, see <a>PutBot</a>.</p>
    pub abort_statement: std::option::Option<crate::model::Statement>,
    /// <p> When you send a request to create or update a bot, Amazon Lex sets the
    /// <code>status</code> response element to <code>BUILDING</code>. After
    /// Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
    /// If Amazon Lex can't build the bot, it sets <code>status</code> to
    /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
    /// <code>failureReason</code> response element. </p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to build the bot.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The date when the <code>$LATEST</code> version of this bot was
    /// updated. </p>
    pub last_updated_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date when the bot version was created.</p>
    pub created_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions
    /// with the user.</p>
    pub voice_id: std::option::Option<std::string::String>,
    /// <p>Checksum identifying the version of the bot that was
    /// created.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>The version of the bot. </p>
    pub version: std::option::Option<std::string::String>,
    /// <p> Specifies the target locale for the bot. </p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub child_directed: std::option::Option<bool>,
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub enable_model_improvements: std::option::Option<bool>,
    /// <p>Indicates whether utterances entered by the user should be sent to
    /// Amazon Comprehend for sentiment analysis.</p>
    pub detect_sentiment: std::option::Option<bool>,
}
impl CreateBotVersionOutput {
    /// <p>The name of the bot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of <code>Intent</code> objects. For more information, see
    /// <a>PutBot</a>.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::Intent]> {
        self.intents.as_deref()
    }
    /// <p>The message that Amazon Lex uses when it doesn't understand the user's
    /// request. For more information, see <a>PutBot</a>. </p>
    pub fn clarification_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.clarification_prompt.as_ref()
    }
    /// <p>The message that Amazon Lex uses to cancel a conversation. For more
    /// information, see <a>PutBot</a>.</p>
    pub fn abort_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.abort_statement.as_ref()
    }
    /// <p> When you send a request to create or update a bot, Amazon Lex sets the
    /// <code>status</code> response element to <code>BUILDING</code>. After
    /// Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
    /// If Amazon Lex can't build the bot, it sets <code>status</code> to
    /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
    /// <code>failureReason</code> response element. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
    /// reason that it failed to build the bot.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The date when the <code>$LATEST</code> version of this bot was
    /// updated. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_date.as_ref()
    }
    /// <p>The date when the bot version was created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_date.as_ref()
    }
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation. For more information, see <a>PutBot</a>.</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions
    /// with the user.</p>
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
    /// <p>Checksum identifying the version of the bot that was
    /// created.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>The version of the bot. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p> Specifies the target locale for the bot. </p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub fn child_directed(&self) -> std::option::Option<bool> {
        self.child_directed
    }
    /// <p>Indicates whether the bot uses accuracy improvements.
    /// <code>true</code> indicates that the bot is using the improvements,
    /// otherwise, <code>false</code>.</p>
    pub fn enable_model_improvements(&self) -> std::option::Option<bool> {
        self.enable_model_improvements
    }
    /// <p>Indicates whether utterances entered by the user should be sent to
    /// Amazon Comprehend for sentiment analysis.</p>
    pub fn detect_sentiment(&self) -> std::option::Option<bool> {
        self.detect_sentiment
    }
}
impl std::fmt::Debug for CreateBotVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotVersionOutput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("intents", &self.intents);
        formatter.field("clarification_prompt", &self.clarification_prompt);
        formatter.field("abort_statement", &self.abort_statement);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("created_date", &self.created_date);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("voice_id", &self.voice_id);
        formatter.field("checksum", &self.checksum);
        formatter.field("version", &self.version);
        formatter.field("locale", &self.locale);
        formatter.field("child_directed", &self.child_directed);
        formatter.field("enable_model_improvements", &self.enable_model_improvements);
        formatter.field("detect_sentiment", &self.detect_sentiment);
        formatter.finish()
    }
}
/// See [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
pub mod create_bot_version_output {
    /// A builder for [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        pub(crate) clarification_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) abort_statement: std::option::Option<crate::model::Statement>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) child_directed: std::option::Option<bool>,
        pub(crate) enable_model_improvements: std::option::Option<bool>,
        pub(crate) detect_sentiment: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn intents(mut self, input: impl Into<crate::model::Intent>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>Intent</code> objects. For more information, see
        /// <a>PutBot</a>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>The message that Amazon Lex uses when it doesn't understand the user's
        /// request. For more information, see <a>PutBot</a>. </p>
        pub fn clarification_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.clarification_prompt = Some(input);
            self
        }
        /// <p>The message that Amazon Lex uses when it doesn't understand the user's
        /// request. For more information, see <a>PutBot</a>. </p>
        pub fn set_clarification_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.clarification_prompt = input;
            self
        }
        /// <p>The message that Amazon Lex uses to cancel a conversation. For more
        /// information, see <a>PutBot</a>.</p>
        pub fn abort_statement(mut self, input: crate::model::Statement) -> Self {
            self.abort_statement = Some(input);
            self
        }
        /// <p>The message that Amazon Lex uses to cancel a conversation. For more
        /// information, see <a>PutBot</a>.</p>
        pub fn set_abort_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.abort_statement = input;
            self
        }
        /// <p> When you send a request to create or update a bot, Amazon Lex sets the
        /// <code>status</code> response element to <code>BUILDING</code>. After
        /// Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
        /// If Amazon Lex can't build the bot, it sets <code>status</code> to
        /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
        /// <code>failureReason</code> response element. </p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> When you send a request to create or update a bot, Amazon Lex sets the
        /// <code>status</code> response element to <code>BUILDING</code>. After
        /// Amazon Lex builds the bot, it sets <code>status</code> to <code>READY</code>.
        /// If Amazon Lex can't build the bot, it sets <code>status</code> to
        /// <code>FAILED</code>. Amazon Lex returns the reason for the failure in the
        /// <code>failureReason</code> response element. </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to build the bot.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>If <code>status</code> is <code>FAILED</code>, Amazon Lex provides the
        /// reason that it failed to build the bot.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The date when the <code>$LATEST</code> version of this bot was
        /// updated. </p>
        pub fn last_updated_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_date = Some(input);
            self
        }
        /// <p>The date when the <code>$LATEST</code> version of this bot was
        /// updated. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date when the bot version was created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date when the bot version was created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation. For more information, see <a>PutBot</a>.</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions
        /// with the user.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The Amazon Polly voice ID that Amazon Lex uses for voice interactions
        /// with the user.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// <p>Checksum identifying the version of the bot that was
        /// created.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum identifying the version of the bot that was
        /// created.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>The version of the bot. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p> Specifies the target locale for the bot. </p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p> Specifies the target locale for the bot. </p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.child_directed = Some(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.child_directed = input;
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn enable_model_improvements(mut self, input: bool) -> Self {
            self.enable_model_improvements = Some(input);
            self
        }
        /// <p>Indicates whether the bot uses accuracy improvements.
        /// <code>true</code> indicates that the bot is using the improvements,
        /// otherwise, <code>false</code>.</p>
        pub fn set_enable_model_improvements(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_model_improvements = input;
            self
        }
        /// <p>Indicates whether utterances entered by the user should be sent to
        /// Amazon Comprehend for sentiment analysis.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.detect_sentiment = Some(input);
            self
        }
        /// <p>Indicates whether utterances entered by the user should be sent to
        /// Amazon Comprehend for sentiment analysis.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.detect_sentiment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
        pub fn build(self) -> crate::output::CreateBotVersionOutput {
            crate::output::CreateBotVersionOutput {
                name: self.name,
                description: self.description,
                intents: self.intents,
                clarification_prompt: self.clarification_prompt,
                abort_statement: self.abort_statement,
                status: self.status,
                failure_reason: self.failure_reason,
                last_updated_date: self.last_updated_date,
                created_date: self.created_date,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                voice_id: self.voice_id,
                checksum: self.checksum,
                version: self.version,
                locale: self.locale,
                child_directed: self.child_directed,
                enable_model_improvements: self.enable_model_improvements,
                detect_sentiment: self.detect_sentiment,
            }
        }
    }
}
impl CreateBotVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateBotVersionOutput`](crate::output::CreateBotVersionOutput)
    pub fn builder() -> crate::output::create_bot_version_output::Builder {
        crate::output::create_bot_version_output::Builder::default()
    }
}
