// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
pub mod create_bot_version_input {
    /// A builder for [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot that you want to create a new version of. The
        /// name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot that you want to create a new version of. The
        /// name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version
        /// of the bot. If you specify a checksum and the <code>$LATEST</code> version
        /// of the bot has a different checksum, a
        /// <code>PreconditionFailedException</code> exception is returned and Amazon Lex
        /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code> version
        /// of the bot. If you specify a checksum and the <code>$LATEST</code> version
        /// of the bot has a different checksum, a
        /// <code>PreconditionFailedException</code> exception is returned and Amazon Lex
        /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBotVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBotVersionInput {
                name: self.name,
                checksum: self.checksum,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBotVersionInputOperationOutputAlias = crate::operation::CreateBotVersion;
#[doc(hidden)]
pub type CreateBotVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBotVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateBotVersion`](crate::operation::CreateBotVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBotVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBotVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.name;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_1, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBotVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBotVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_bot_version(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBotVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBotVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBotVersionInput`](crate::input::CreateBotVersionInput)
    pub fn builder() -> crate::input::create_bot_version_input::Builder {
        crate::input::create_bot_version_input::Builder::default()
    }
}

/// See [`CreateIntentVersionInput`](crate::input::CreateIntentVersionInput)
pub mod create_intent_version_input {
    /// A builder for [`CreateIntentVersionInput`](crate::input::CreateIntentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent that you want to create a new version of.
        /// The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent that you want to create a new version of.
        /// The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the intent that
        /// should be used to create the new version. If you specify a checksum and
        /// the <code>$LATEST</code> version of the intent has a different checksum,
        /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
        /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum of the <code>$LATEST</code> version of the intent that
        /// should be used to create the new version. If you specify a checksum and
        /// the <code>$LATEST</code> version of the intent has a different checksum,
        /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
        /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntentVersionInput`](crate::input::CreateIntentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntentVersionInput {
                name: self.name,
                checksum: self.checksum,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntentVersionInputOperationOutputAlias = crate::operation::CreateIntentVersion;
#[doc(hidden)]
pub type CreateIntentVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateIntentVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntentVersion`](crate::operation::CreateIntentVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntentVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIntentVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.name;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_2, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/intents/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIntentVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIntentVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_intent_version(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntentVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIntentVersionInput`](crate::input::CreateIntentVersionInput)
    pub fn builder() -> crate::input::create_intent_version_input::Builder {
        crate::input::create_intent_version_input::Builder::default()
    }
}

/// See [`CreateSlotTypeVersionInput`](crate::input::CreateSlotTypeVersionInput)
pub mod create_slot_type_version_input {
    /// A builder for [`CreateSlotTypeVersionInput`](crate::input::CreateSlotTypeVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the slot type that you want to create a new version
        /// for. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type that you want to create a new version
        /// for. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Checksum for the <code>$LATEST</code> version of the slot type that
        /// you want to publish. If you specify a checksum and the
        /// <code>$LATEST</code> version of the slot type has a different checksum,
        /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
        /// doesn't publish the new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Checksum for the <code>$LATEST</code> version of the slot type that
        /// you want to publish. If you specify a checksum and the
        /// <code>$LATEST</code> version of the slot type has a different checksum,
        /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
        /// doesn't publish the new version. If you don't specify a checksum, Amazon Lex
        /// publishes the <code>$LATEST</code> version.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSlotTypeVersionInput`](crate::input::CreateSlotTypeVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSlotTypeVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSlotTypeVersionInput {
                name: self.name,
                checksum: self.checksum,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSlotTypeVersionInputOperationOutputAlias = crate::operation::CreateSlotTypeVersion;
#[doc(hidden)]
pub type CreateSlotTypeVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSlotTypeVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateSlotTypeVersion`](crate::operation::CreateSlotTypeVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSlotTypeVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSlotTypeVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.name;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_3, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/slottypes/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSlotTypeVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSlotTypeVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_slot_type_version(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSlotTypeVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSlotTypeVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSlotTypeVersionInput`](crate::input::CreateSlotTypeVersionInput)
    pub fn builder() -> crate::input::create_slot_type_version_input::Builder {
        crate::input::create_slot_type_version_input::Builder::default()
    }
}

/// See [`DeleteBotInput`](crate::input::DeleteBotInput)
pub mod delete_bot_input {
    /// A builder for [`DeleteBotInput`](crate::input::DeleteBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotInput`](crate::input::DeleteBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteBotInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotInputOperationOutputAlias = crate::operation::DeleteBot;
#[doc(hidden)]
pub type DeleteBotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBot`](crate::operation::DeleteBot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.name;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_4, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{name}", name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteBot",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotInput`](crate::input::DeleteBotInput)
    pub fn builder() -> crate::input::delete_bot_input::Builder {
        crate::input::delete_bot_input::Builder::default()
    }
}

/// See [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
pub mod delete_bot_alias_input {
    /// A builder for [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alias to delete. The name is case sensitive.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias to delete. The name is case sensitive.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that the alias points to.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotAliasInput {
                name: self.name,
                bot_name: self.bot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotAliasInputOperationOutputAlias = crate::operation::DeleteBotAlias;
#[doc(hidden)]
pub type DeleteBotAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotAlias`](crate::operation::DeleteBotAlias)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.bot_name;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_5, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.name;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_6, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{name}",
                botName = bot_name,
                name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotAlias",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotAliasInput`](crate::input::DeleteBotAliasInput)
    pub fn builder() -> crate::input::delete_bot_alias_input::Builder {
        crate::input::delete_bot_alias_input::Builder::default()
    }
}

/// See [`DeleteBotChannelAssociationInput`](crate::input::DeleteBotChannelAssociationInput)
pub mod delete_bot_channel_association_input {
    /// A builder for [`DeleteBotChannelAssociationInput`](crate::input::DeleteBotChannelAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the association. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the association. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>An alias that points to the specific version of the Amazon Lex bot to
        /// which this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>An alias that points to the specific version of the Amazon Lex bot to
        /// which this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotChannelAssociationInput`](crate::input::DeleteBotChannelAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotChannelAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotChannelAssociationInput {
                name: self.name,
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotChannelAssociationInputOperationOutputAlias =
    crate::operation::DeleteBotChannelAssociation;
#[doc(hidden)]
pub type DeleteBotChannelAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBotChannelAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotChannelAssociation`](crate::operation::DeleteBotChannelAssociation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotChannelAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotChannelAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.bot_name;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_7, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.bot_alias;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_8, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.name;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_9, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{botAlias}/channels/{name}",
                botName = bot_name,
                botAlias = bot_alias,
                name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotChannelAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotChannelAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotChannelAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotChannelAssociation",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotChannelAssociationInput`](crate::input::DeleteBotChannelAssociationInput)
    pub fn builder() -> crate::input::delete_bot_channel_association_input::Builder {
        crate::input::delete_bot_channel_association_input::Builder::default()
    }
}

/// See [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
pub mod delete_bot_version_input {
    /// A builder for [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the bot to delete. You cannot delete the
        /// <code>$LATEST</code> version of the bot. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteBot</a>
        /// operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot to delete. You cannot delete the
        /// <code>$LATEST</code> version of the bot. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteBot</a>
        /// operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBotVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBotVersionInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBotVersionInputOperationOutputAlias = crate::operation::DeleteBotVersion;
#[doc(hidden)]
pub type DeleteBotVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBotVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBotVersion`](crate::operation::DeleteBotVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBotVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBotVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.name;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_10, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.version;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let version = aws_smithy_http::label::fmt_string(input_11, false);
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{name}/versions/{version}",
                name = name,
                version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBotVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBotVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBotVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBotVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBotVersionInput`](crate::input::DeleteBotVersionInput)
    pub fn builder() -> crate::input::delete_bot_version_input::Builder {
        crate::input::delete_bot_version_input::Builder::default()
    }
}

/// See [`DeleteIntentInput`](crate::input::DeleteIntentInput)
pub mod delete_intent_input {
    /// A builder for [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntentInput`](crate::input::DeleteIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntentInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntentInputOperationOutputAlias = crate::operation::DeleteIntent;
#[doc(hidden)]
pub type DeleteIntentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIntentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntent`](crate::operation::DeleteIntent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.name;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_12, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/intents/{name}", name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntent",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntentInput`](crate::input::DeleteIntentInput)
    pub fn builder() -> crate::input::delete_intent_input::Builder {
        crate::input::delete_intent_input::Builder::default()
    }
}

/// See [`DeleteIntentVersionInput`](crate::input::DeleteIntentVersionInput)
pub mod delete_intent_version_input {
    /// A builder for [`DeleteIntentVersionInput`](crate::input::DeleteIntentVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the intent to delete. You cannot delete the
        /// <code>$LATEST</code> version of the intent. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteIntent</a>
        /// operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the intent to delete. You cannot delete the
        /// <code>$LATEST</code> version of the intent. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteIntent</a>
        /// operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntentVersionInput`](crate::input::DeleteIntentVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntentVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntentVersionInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntentVersionInputOperationOutputAlias = crate::operation::DeleteIntentVersion;
#[doc(hidden)]
pub type DeleteIntentVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteIntentVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntentVersion`](crate::operation::DeleteIntentVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntentVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntentVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.name;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_13, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.version;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let version = aws_smithy_http::label::fmt_string(input_14, false);
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/intents/{name}/versions/{version}",
                name = name,
                version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntentVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntentVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntentVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntentVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntentVersionInput`](crate::input::DeleteIntentVersionInput)
    pub fn builder() -> crate::input::delete_intent_version_input::Builder {
        crate::input::delete_intent_version_input::Builder::default()
    }
}

/// See [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
pub mod delete_slot_type_input {
    /// A builder for [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSlotTypeInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteSlotTypeInputOperationOutputAlias = crate::operation::DeleteSlotType;
#[doc(hidden)]
pub type DeleteSlotTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSlotType`](crate::operation::DeleteSlotType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSlotType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.name;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_15, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/slottypes/{name}", name = name).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSlotType",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeInput`](crate::input::DeleteSlotTypeInput)
    pub fn builder() -> crate::input::delete_slot_type_input::Builder {
        crate::input::delete_slot_type_input::Builder::default()
    }
}

/// See [`DeleteSlotTypeVersionInput`](crate::input::DeleteSlotTypeVersionInput)
pub mod delete_slot_type_version_input {
    /// A builder for [`DeleteSlotTypeVersionInput`](crate::input::DeleteSlotTypeVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the slot type.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the slot type to delete. You cannot delete the
        /// <code>$LATEST</code> version of the slot type. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteSlotType</a>
        /// operation.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the slot type to delete. You cannot delete the
        /// <code>$LATEST</code> version of the slot type. To delete the
        /// <code>$LATEST</code> version, use the <a>DeleteSlotType</a>
        /// operation.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSlotTypeVersionInput`](crate::input::DeleteSlotTypeVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSlotTypeVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSlotTypeVersionInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSlotTypeVersionInputOperationOutputAlias = crate::operation::DeleteSlotTypeVersion;
#[doc(hidden)]
pub type DeleteSlotTypeVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSlotTypeVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSlotTypeVersion`](crate::operation::DeleteSlotTypeVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSlotTypeVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSlotTypeVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.name;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_16, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.version;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let version = aws_smithy_http::label::fmt_string(input_17, false);
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/slottypes/{name}/version/{version}",
                name = name,
                version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSlotTypeVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSlotTypeVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSlotTypeVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSlotTypeVersion",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSlotTypeVersionInput`](crate::input::DeleteSlotTypeVersionInput)
    pub fn builder() -> crate::input::delete_slot_type_version_input::Builder {
        crate::input::delete_slot_type_version_input::Builder::default()
    }
}

/// See [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
pub mod delete_utterances_input {
    /// A builder for [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot that stored the utterances.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot that stored the utterances.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p> The unique identifier for the user that made the utterances. This
        /// is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the
        /// utterance.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the user that made the utterances. This
        /// is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the
        /// utterance.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUtterancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUtterancesInput {
                bot_name: self.bot_name,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUtterancesInputOperationOutputAlias = crate::operation::DeleteUtterances;
#[doc(hidden)]
pub type DeleteUtterancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUtterancesInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUtterances`](crate::operation::DeleteUtterances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUtterances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUtterancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.bot_name;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_18, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.user_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_19, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/utterances/{userId}",
                botName = bot_name,
                userId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUtterancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUtterancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUtterances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUtterances",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUtterancesInput`](crate::input::DeleteUtterancesInput)
    pub fn builder() -> crate::input::delete_utterances_input::Builder {
        crate::input::delete_utterances_input::Builder::default()
    }
}

/// See [`GetBotInput`](crate::input::GetBotInput)
pub mod get_bot_input {
    /// A builder for [`GetBotInput`](crate::input::GetBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version_or_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version or alias of the bot.</p>
        pub fn version_or_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_or_alias = Some(input.into());
            self
        }
        /// <p>The version or alias of the bot.</p>
        pub fn set_version_or_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_or_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotInput`](crate::input::GetBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBotInput {
                name: self.name,
                version_or_alias: self.version_or_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotInputOperationOutputAlias = crate::operation::GetBot;
#[doc(hidden)]
pub type GetBotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotInput {
    /// Consumes the builder and constructs an Operation<[`GetBot`](crate::operation::GetBot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.name;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_20, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.version_or_alias;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_or_alias",
                        details: "cannot be empty or unset",
                    })?;
            let version_or_alias = aws_smithy_http::label::fmt_string(input_21, false);
            if version_or_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version_or_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{name}/versions/{versionOrAlias}",
                name = name,
                versionOrAlias = version_or_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBot",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotInput`](crate::input::GetBotInput)
    pub fn builder() -> crate::input::get_bot_input::Builder {
        crate::input::get_bot_input::Builder::default()
    }
}

/// See [`GetBotAliasInput`](crate::input::GetBotAliasInput)
pub mod get_bot_alias_input {
    /// A builder for [`GetBotAliasInput`](crate::input::GetBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot alias. The name is case sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot alias. The name is case sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotAliasInput`](crate::input::GetBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBotAliasInput {
                name: self.name,
                bot_name: self.bot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotAliasInputOperationOutputAlias = crate::operation::GetBotAlias;
#[doc(hidden)]
pub type GetBotAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`GetBotAlias`](crate::operation::GetBotAlias)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBotAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.bot_name;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_22, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.name;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_23, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{name}",
                botName = bot_name,
                name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBotAlias",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotAliasInput`](crate::input::GetBotAliasInput)
    pub fn builder() -> crate::input::get_bot_alias_input::Builder {
        crate::input::get_bot_alias_input::Builder::default()
    }
}

/// See [`GetBotAliasesInput`](crate::input::GetBotAliasesInput)
pub mod get_bot_aliases_input {
    /// A builder for [`GetBotAliasesInput`](crate::input::GetBotAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>A pagination token for fetching the next page of aliases. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of aliases, specify the pagination
        /// token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of aliases. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of aliases, specify the pagination
        /// token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of aliases to return in the response. The
        /// default is 50. . </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of aliases to return in the response. The
        /// default is 50. . </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Substring to match in bot alias names. An alias will be returned if
        /// any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in bot alias names. An alias will be returned if
        /// any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotAliasesInput`](crate::input::GetBotAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBotAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBotAliasesInput {
                bot_name: self.bot_name,
                next_token: self.next_token,
                max_results: self.max_results,
                name_contains: self.name_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotAliasesInputOperationOutputAlias = crate::operation::GetBotAliases;
#[doc(hidden)]
pub type GetBotAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotAliasesInput {
    /// Consumes the builder and constructs an Operation<[`GetBotAliases`](crate::operation::GetBotAliases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBotAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.bot_name;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_24, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botName}/aliases", botName = bot_name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBotAliasesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_26).encode(),
                );
            }
            if let Some(inner_27) = &_input.name_contains {
                query.push_kv(
                    "nameContains",
                    &aws_smithy_http::query::fmt_string(&inner_27),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBotAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBotAliases",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotAliasesInput`](crate::input::GetBotAliasesInput)
    pub fn builder() -> crate::input::get_bot_aliases_input::Builder {
        crate::input::get_bot_aliases_input::Builder::default()
    }
}

/// See [`GetBotChannelAssociationInput`](crate::input::GetBotChannelAssociationInput)
pub mod get_bot_channel_association_input {
    /// A builder for [`GetBotChannelAssociationInput`](crate::input::GetBotChannelAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the association between the bot and the channel. The
        /// name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the association between the bot and the channel. The
        /// name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotChannelAssociationInput`](crate::input::GetBotChannelAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBotChannelAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBotChannelAssociationInput {
                name: self.name,
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotChannelAssociationInputOperationOutputAlias =
    crate::operation::GetBotChannelAssociation;
#[doc(hidden)]
pub type GetBotChannelAssociationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotChannelAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetBotChannelAssociation`](crate::operation::GetBotChannelAssociation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBotChannelAssociation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotChannelAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.bot_name;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_28, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_29 = &_input.bot_alias;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_29, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.name;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_30, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{botAlias}/channels/{name}",
                botName = bot_name,
                botAlias = bot_alias,
                name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotChannelAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotChannelAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBotChannelAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBotChannelAssociation",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationInput`](crate::input::GetBotChannelAssociationInput)
    pub fn builder() -> crate::input::get_bot_channel_association_input::Builder {
        crate::input::get_bot_channel_association_input::Builder::default()
    }
}

/// See [`GetBotChannelAssociationsInput`](crate::input::GetBotChannelAssociationsInput)
pub mod get_bot_channel_associations_input {
    /// A builder for [`GetBotChannelAssociationsInput`](crate::input::GetBotChannelAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_alias: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Lex bot in the association.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot in the association.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn bot_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_alias = Some(input.into());
            self
        }
        /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
        /// this association is being made.</p>
        pub fn set_bot_alias(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_alias = input;
            self
        }
        /// <p>A pagination token for fetching the next page of associations. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of associations, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of associations. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of associations, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of associations to return in the response. The
        /// default is 50. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of associations to return in the response. The
        /// default is 50. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Substring to match in channel association names. An association
        /// will be returned if any part of its name matches the substring. For
        /// example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot
        /// channel associations, use a hyphen ("-") as the <code>nameContains</code>
        /// parameter.</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in channel association names. An association
        /// will be returned if any part of its name matches the substring. For
        /// example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot
        /// channel associations, use a hyphen ("-") as the <code>nameContains</code>
        /// parameter.</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotChannelAssociationsInput`](crate::input::GetBotChannelAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBotChannelAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBotChannelAssociationsInput {
                bot_name: self.bot_name,
                bot_alias: self.bot_alias,
                next_token: self.next_token,
                max_results: self.max_results,
                name_contains: self.name_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotChannelAssociationsInputOperationOutputAlias =
    crate::operation::GetBotChannelAssociations;
#[doc(hidden)]
pub type GetBotChannelAssociationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotChannelAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`GetBotChannelAssociations`](crate::operation::GetBotChannelAssociations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBotChannelAssociations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotChannelAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.bot_name;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_31, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.bot_alias;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_alias",
                        details: "cannot be empty or unset",
                    })?;
            let bot_alias = aws_smithy_http::label::fmt_string(input_32, false);
            if bot_alias.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_alias",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{botAlias}/channels",
                botName = bot_name,
                botAlias = bot_alias
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetBotChannelAssociationsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_33) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_33));
            }
            if let Some(inner_34) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_34).encode(),
                );
            }
            if let Some(inner_35) = &_input.name_contains {
                query.push_kv(
                    "nameContains",
                    &aws_smithy_http::query::fmt_string(&inner_35),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotChannelAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotChannelAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBotChannelAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBotChannelAssociations",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotChannelAssociationsInput`](crate::input::GetBotChannelAssociationsInput)
    pub fn builder() -> crate::input::get_bot_channel_associations_input::Builder {
        crate::input::get_bot_channel_associations_input::Builder::default()
    }
}

/// See [`GetBotsInput`](crate::input::GetBotsInput)
pub mod get_bots_input {
    /// A builder for [`GetBotsInput`](crate::input::GetBotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A pagination token that fetches the next page of bots. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of bots, specify the pagination token
        /// in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of bots. If the
        /// response to this call is truncated, Amazon Lex returns a pagination token in
        /// the response. To fetch the next page of bots, specify the pagination token
        /// in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of bots to return in the response that the
        /// request will return. The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bots to return in the response that the
        /// request will return. The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Substring to match in bot names. A bot will be returned if any part
        /// of its name matches the substring. For example, "xyz" matches both
        /// "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in bot names. A bot will be returned if any part
        /// of its name matches the substring. For example, "xyz" matches both
        /// "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotsInput`](crate::input::GetBotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBotsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBotsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                name_contains: self.name_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotsInputOperationOutputAlias = crate::operation::GetBots;
#[doc(hidden)]
pub type GetBotsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotsInput {
    /// Consumes the builder and constructs an Operation<[`GetBots`](crate::operation::GetBots)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBots,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/bots").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBotsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if let Some(inner_37) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_37).encode(),
                );
            }
            if let Some(inner_38) = &_input.name_contains {
                query.push_kv(
                    "nameContains",
                    &aws_smithy_http::query::fmt_string(&inner_38),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBots",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotsInput`](crate::input::GetBotsInput)
    pub fn builder() -> crate::input::get_bots_input::Builder {
        crate::input::get_bots_input::Builder::default()
    }
}

/// See [`GetBotVersionsInput`](crate::input::GetBotVersionsInput)
pub mod get_bot_versions_input {
    /// A builder for [`GetBotVersionsInput`](crate::input::GetBotVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the bot for which versions should be
        /// returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot for which versions should be
        /// returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of bot versions. If
        /// the response to this call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of bot versions to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of bot versions to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBotVersionsInput`](crate::input::GetBotVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBotVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBotVersionsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBotVersionsInputOperationOutputAlias = crate::operation::GetBotVersions;
#[doc(hidden)]
pub type GetBotVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBotVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetBotVersions`](crate::operation::GetBotVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBotVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBotVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.name;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_39, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBotVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            if let Some(inner_41) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBotVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBotVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBotVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBotVersions",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBotVersionsInput`](crate::input::GetBotVersionsInput)
    pub fn builder() -> crate::input::get_bot_versions_input::Builder {
        crate::input::get_bot_versions_input::Builder::default()
    }
}

/// See [`GetBuiltinIntentInput`](crate::input::GetBuiltinIntentInput)
pub mod get_builtin_intent_input {
    /// A builder for [`GetBuiltinIntentInput`](crate::input::GetBuiltinIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for a built-in intent. To find the signature
        /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature = Some(input.into());
            self
        }
        /// <p>The unique identifier for a built-in intent. To find the signature
        /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_signature(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.signature = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinIntentInput`](crate::input::GetBuiltinIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBuiltinIntentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBuiltinIntentInput {
                signature: self.signature,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBuiltinIntentInputOperationOutputAlias = crate::operation::GetBuiltinIntent;
#[doc(hidden)]
pub type GetBuiltinIntentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBuiltinIntentInput {
    /// Consumes the builder and constructs an Operation<[`GetBuiltinIntent`](crate::operation::GetBuiltinIntent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBuiltinIntent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBuiltinIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.signature;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "signature",
                        details: "cannot be empty or unset",
                    })?;
            let signature = aws_smithy_http::label::fmt_string(input_42, false);
            if signature.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "signature",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/builtins/intents/{signature}",
                signature = signature
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBuiltinIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBuiltinIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBuiltinIntent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBuiltinIntent",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentInput`](crate::input::GetBuiltinIntentInput)
    pub fn builder() -> crate::input::get_builtin_intent_input::Builder {
        crate::input::get_builtin_intent_input::Builder::default()
    }
}

/// See [`GetBuiltinIntentsInput`](crate::input::GetBuiltinIntentsInput)
pub mod get_builtin_intents_input {
    /// A builder for [`GetBuiltinIntentsInput`](crate::input::GetBuiltinIntentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) signature_contains: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A list of locales that the intent supports.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>A list of locales that the intent supports.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Substring to match in built-in intent signatures. An intent will be
        /// returned if any part of its signature matches the substring. For example,
        /// "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an
        /// intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn signature_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in built-in intent signatures. An intent will be
        /// returned if any part of its signature matches the substring. For example,
        /// "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an
        /// intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_signature_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_contains = input;
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If this
        /// API call is truncated, Amazon Lex returns a pagination token in the response.
        /// To fetch the next page of intents, use the pagination token in the next
        /// request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If this
        /// API call is truncated, Amazon Lex returns a pagination token in the response.
        /// To fetch the next page of intents, use the pagination token in the next
        /// request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of intents to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinIntentsInput`](crate::input::GetBuiltinIntentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBuiltinIntentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBuiltinIntentsInput {
                locale: self.locale,
                signature_contains: self.signature_contains,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBuiltinIntentsInputOperationOutputAlias = crate::operation::GetBuiltinIntents;
#[doc(hidden)]
pub type GetBuiltinIntentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBuiltinIntentsInput {
    /// Consumes the builder and constructs an Operation<[`GetBuiltinIntents`](crate::operation::GetBuiltinIntents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBuiltinIntents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBuiltinIntentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/builtins/intents").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBuiltinIntentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.locale {
                query.push_kv("locale", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            if let Some(inner_44) = &_input.signature_contains {
                query.push_kv(
                    "signatureContains",
                    &aws_smithy_http::query::fmt_string(&inner_44),
                );
            }
            if let Some(inner_45) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_45));
            }
            if let Some(inner_46) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_46).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBuiltinIntentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBuiltinIntentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBuiltinIntents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBuiltinIntents",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBuiltinIntentsInput`](crate::input::GetBuiltinIntentsInput)
    pub fn builder() -> crate::input::get_builtin_intents_input::Builder {
        crate::input::get_builtin_intents_input::Builder::default()
    }
}

/// See [`GetBuiltinSlotTypesInput`](crate::input::GetBuiltinSlotTypesInput)
pub mod get_builtin_slot_types_input {
    /// A builder for [`GetBuiltinSlotTypesInput`](crate::input::GetBuiltinSlotTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) signature_contains: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A list of locales that the slot type supports.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p>A list of locales that the slot type supports.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>Substring to match in built-in slot type signatures. A slot type
        /// will be returned if any part of its signature matches the substring. For
        /// example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn signature_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in built-in slot type signatures. A slot type
        /// will be returned if any part of its signature matches the substring. For
        /// example, "xyz" matches both "xyzabc" and "abcxyz."</p>
        pub fn set_signature_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_contains = input;
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of slot types, specify the
        /// pagination token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of slot types, specify the
        /// pagination token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of slot types to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBuiltinSlotTypesInput`](crate::input::GetBuiltinSlotTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBuiltinSlotTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBuiltinSlotTypesInput {
                locale: self.locale,
                signature_contains: self.signature_contains,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBuiltinSlotTypesInputOperationOutputAlias = crate::operation::GetBuiltinSlotTypes;
#[doc(hidden)]
pub type GetBuiltinSlotTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBuiltinSlotTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetBuiltinSlotTypes`](crate::operation::GetBuiltinSlotTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBuiltinSlotTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBuiltinSlotTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/builtins/slottypes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetBuiltinSlotTypesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_47) = &_input.locale {
                query.push_kv("locale", &aws_smithy_http::query::fmt_string(&inner_47));
            }
            if let Some(inner_48) = &_input.signature_contains {
                query.push_kv(
                    "signatureContains",
                    &aws_smithy_http::query::fmt_string(&inner_48),
                );
            }
            if let Some(inner_49) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_49));
            }
            if let Some(inner_50) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_50).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBuiltinSlotTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBuiltinSlotTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBuiltinSlotTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBuiltinSlotTypes",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBuiltinSlotTypesInput`](crate::input::GetBuiltinSlotTypesInput)
    pub fn builder() -> crate::input::get_builtin_slot_types_input::Builder {
        crate::input::get_builtin_slot_types_input::Builder::default()
    }
}

/// See [`GetExportInput`](crate::input::GetExportInput)
pub mod get_export_input {
    /// A builder for [`GetExportInput`](crate::input::GetExportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) export_type: std::option::Option<crate::model::ExportType>,
    }
    impl Builder {
        /// <p>The name of the bot to export.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot to export.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the bot to export.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The type of resource to export. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource to export. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn export_type(mut self, input: crate::model::ExportType) -> Self {
            self.export_type = Some(input);
            self
        }
        /// <p>The format of the exported data.</p>
        pub fn set_export_type(
            mut self,
            input: std::option::Option<crate::model::ExportType>,
        ) -> Self {
            self.export_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportInput`](crate::input::GetExportInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetExportInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetExportInput {
                name: self.name,
                version: self.version,
                resource_type: self.resource_type,
                export_type: self.export_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExportInputOperationOutputAlias = crate::operation::GetExport;
#[doc(hidden)]
pub type GetExportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetExportInput {
    /// Consumes the builder and constructs an Operation<[`GetExport`](crate::operation::GetExport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetExportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/exports").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetExportInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_51) = &_input.name {
                query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_51));
            }
            if let Some(inner_52) = &_input.version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_52));
            }
            if let Some(inner_53) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_53),
                );
            }
            if let Some(inner_54) = &_input.export_type {
                query.push_kv("exportType", &aws_smithy_http::query::fmt_string(&inner_54));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetExportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetExportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetExport::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetExport",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetExportInput`](crate::input::GetExportInput)
    pub fn builder() -> crate::input::get_export_input::Builder {
        crate::input::get_export_input::Builder::default()
    }
}

/// See [`GetImportInput`](crate::input::GetImportInput)
pub mod get_import_input {
    /// A builder for [`GetImportInput`](crate::input::GetImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the import job information to return.</p>
        pub fn import_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.import_id = Some(input.into());
            self
        }
        /// <p>The identifier of the import job information to return.</p>
        pub fn set_import_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.import_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImportInput`](crate::input::GetImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetImportInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetImportInput {
                import_id: self.import_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImportInputOperationOutputAlias = crate::operation::GetImport;
#[doc(hidden)]
pub type GetImportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetImportInput {
    /// Consumes the builder and constructs an Operation<[`GetImport`](crate::operation::GetImport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.import_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "import_id",
                        details: "cannot be empty or unset",
                    })?;
            let import_id = aws_smithy_http::label::fmt_string(input_55, false);
            if import_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "import_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/imports/{importId}", importId = import_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetImport::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetImport",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetImportInput`](crate::input::GetImportInput)
    pub fn builder() -> crate::input::get_import_input::Builder {
        crate::input::get_import_input::Builder::default()
    }
}

/// See [`GetIntentInput`](crate::input::GetIntentInput)
pub mod get_intent_input {
    /// A builder for [`GetIntentInput`](crate::input::GetIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the intent.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the intent.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentInput`](crate::input::GetIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetIntentInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetIntentInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntentInputOperationOutputAlias = crate::operation::GetIntent;
#[doc(hidden)]
pub type GetIntentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIntentInput {
    /// Consumes the builder and constructs an Operation<[`GetIntent`](crate::operation::GetIntent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.name;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_56, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_57 = &_input.version;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let version = aws_smithy_http::label::fmt_string(input_57, false);
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/intents/{name}/versions/{version}",
                name = name,
                version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetIntent::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetIntent",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIntentInput`](crate::input::GetIntentInput)
    pub fn builder() -> crate::input::get_intent_input::Builder {
        crate::input::get_intent_input::Builder::default()
    }
}

/// See [`GetIntentsInput`](crate::input::GetIntentsInput)
pub mod get_intents_input {
    /// A builder for [`GetIntentsInput`](crate::input::GetIntentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A pagination token that fetches the next page of intents. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of intents, specify the pagination
        /// token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of intents. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of intents, specify the pagination
        /// token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of intents to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of intents to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Substring to match in intent names. An intent will be returned if
        /// any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in intent names. An intent will be returned if
        /// any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentsInput`](crate::input::GetIntentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntentsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                name_contains: self.name_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntentsInputOperationOutputAlias = crate::operation::GetIntents;
#[doc(hidden)]
pub type GetIntentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIntentsInput {
    /// Consumes the builder and constructs an Operation<[`GetIntents`](crate::operation::GetIntents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIntentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/intents").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetIntentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_58) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_58));
            }
            if let Some(inner_59) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_59).encode(),
                );
            }
            if let Some(inner_60) = &_input.name_contains {
                query.push_kv(
                    "nameContains",
                    &aws_smithy_http::query::fmt_string(&inner_60),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIntentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIntentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntents",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIntentsInput`](crate::input::GetIntentsInput)
    pub fn builder() -> crate::input::get_intents_input::Builder {
        crate::input::get_intents_input::Builder::default()
    }
}

/// See [`GetIntentVersionsInput`](crate::input::GetIntentVersionsInput)
pub mod get_intent_versions_input {
    /// A builder for [`GetIntentVersionsInput`](crate::input::GetIntentVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the intent for which versions should be
        /// returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent for which versions should be
        /// returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions.
        /// If the response to this call is truncated, Amazon Lex returns a pagination
        /// token in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of intent versions.
        /// If the response to this call is truncated, Amazon Lex returns a pagination
        /// token in the response. To fetch the next page of versions, specify the
        /// pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of intent versions to return in the response.
        /// The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of intent versions to return in the response.
        /// The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntentVersionsInput`](crate::input::GetIntentVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntentVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntentVersionsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntentVersionsInputOperationOutputAlias = crate::operation::GetIntentVersions;
#[doc(hidden)]
pub type GetIntentVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetIntentVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetIntentVersions`](crate::operation::GetIntentVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntentVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIntentVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.name;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_61, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/intents/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetIntentVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_62) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_62));
            }
            if let Some(inner_63) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIntentVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIntentVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntentVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntentVersions",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIntentVersionsInput`](crate::input::GetIntentVersionsInput)
    pub fn builder() -> crate::input::get_intent_versions_input::Builder {
        crate::input::get_intent_versions_input::Builder::default()
    }
}

/// See [`GetMigrationInput`](crate::input::GetMigrationInput)
pub mod get_migration_input {
    /// A builder for [`GetMigrationInput`](crate::input::GetMigrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) migration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the migration to view. The
        /// <code>migrationID</code> is returned by the  operation.</p>
        pub fn migration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.migration_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the migration to view. The
        /// <code>migrationID</code> is returned by the  operation.</p>
        pub fn set_migration_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.migration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMigrationInput`](crate::input::GetMigrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMigrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMigrationInput {
                migration_id: self.migration_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMigrationInputOperationOutputAlias = crate::operation::GetMigration;
#[doc(hidden)]
pub type GetMigrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMigrationInput {
    /// Consumes the builder and constructs an Operation<[`GetMigration`](crate::operation::GetMigration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMigration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMigrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_64 = &_input.migration_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "migration_id",
                        details: "cannot be empty or unset",
                    })?;
            let migration_id = aws_smithy_http::label::fmt_string(input_64, false);
            if migration_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "migration_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/migrations/{migrationId}",
                migrationId = migration_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMigrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMigrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMigration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMigration",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMigrationInput`](crate::input::GetMigrationInput)
    pub fn builder() -> crate::input::get_migration_input::Builder {
        crate::input::get_migration_input::Builder::default()
    }
}

/// See [`GetMigrationsInput`](crate::input::GetMigrationsInput)
pub mod get_migrations_input {
    /// A builder for [`GetMigrationsInput`](crate::input::GetMigrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sort_by_attribute: std::option::Option<crate::model::MigrationSortAttribute>,
        pub(crate) sort_by_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) v1_bot_name_contains: std::option::Option<std::string::String>,
        pub(crate) migration_status_equals: std::option::Option<crate::model::MigrationStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field to sort the list of migrations by. You can sort by the
        /// Amazon Lex V1 bot name or the date and time that the migration was
        /// started.</p>
        pub fn sort_by_attribute(mut self, input: crate::model::MigrationSortAttribute) -> Self {
            self.sort_by_attribute = Some(input);
            self
        }
        /// <p>The field to sort the list of migrations by. You can sort by the
        /// Amazon Lex V1 bot name or the date and time that the migration was
        /// started.</p>
        pub fn set_sort_by_attribute(
            mut self,
            input: std::option::Option<crate::model::MigrationSortAttribute>,
        ) -> Self {
            self.sort_by_attribute = input;
            self
        }
        /// <p>The order so sort the list.</p>
        pub fn sort_by_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_by_order = Some(input);
            self
        }
        /// <p>The order so sort the list.</p>
        pub fn set_sort_by_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_by_order = input;
            self
        }
        /// <p>Filters the list to contain only bots whose name contains the
        /// specified string. The string is matched anywhere in bot name.</p>
        pub fn v1_bot_name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_name_contains = Some(input.into());
            self
        }
        /// <p>Filters the list to contain only bots whose name contains the
        /// specified string. The string is matched anywhere in bot name.</p>
        pub fn set_v1_bot_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.v1_bot_name_contains = input;
            self
        }
        /// <p>Filters the list to contain only migrations in the specified state.</p>
        pub fn migration_status_equals(mut self, input: crate::model::MigrationStatus) -> Self {
            self.migration_status_equals = Some(input);
            self
        }
        /// <p>Filters the list to contain only migrations in the specified state.</p>
        pub fn set_migration_status_equals(
            mut self,
            input: std::option::Option<crate::model::MigrationStatus>,
        ) -> Self {
            self.migration_status_equals = input;
            self
        }
        /// <p>The maximum number of migrations to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of migrations to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A pagination token that fetches the next page of migrations. If the
        /// response to this operation is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of migrations, specify the
        /// pagination token in the request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of migrations. If the
        /// response to this operation is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch the next page of migrations, specify the
        /// pagination token in the request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMigrationsInput`](crate::input::GetMigrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMigrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMigrationsInput {
                sort_by_attribute: self.sort_by_attribute,
                sort_by_order: self.sort_by_order,
                v1_bot_name_contains: self.v1_bot_name_contains,
                migration_status_equals: self.migration_status_equals,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMigrationsInputOperationOutputAlias = crate::operation::GetMigrations;
#[doc(hidden)]
pub type GetMigrationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMigrationsInput {
    /// Consumes the builder and constructs an Operation<[`GetMigrations`](crate::operation::GetMigrations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMigrations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMigrationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/migrations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetMigrationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_65) = &_input.sort_by_attribute {
                query.push_kv(
                    "sortByAttribute",
                    &aws_smithy_http::query::fmt_string(&inner_65),
                );
            }
            if let Some(inner_66) = &_input.sort_by_order {
                query.push_kv(
                    "sortByOrder",
                    &aws_smithy_http::query::fmt_string(&inner_66),
                );
            }
            if let Some(inner_67) = &_input.v1_bot_name_contains {
                query.push_kv(
                    "v1BotNameContains",
                    &aws_smithy_http::query::fmt_string(&inner_67),
                );
            }
            if let Some(inner_68) = &_input.migration_status_equals {
                query.push_kv(
                    "migrationStatusEquals",
                    &aws_smithy_http::query::fmt_string(&inner_68),
                );
            }
            if let Some(inner_69) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_69).encode(),
                );
            }
            if let Some(inner_70) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_70));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMigrationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMigrationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMigrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMigrations",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMigrationsInput`](crate::input::GetMigrationsInput)
    pub fn builder() -> crate::input::get_migrations_input::Builder {
        crate::input::get_migrations_input::Builder::default()
    }
}

/// See [`GetSlotTypeInput`](crate::input::GetSlotTypeInput)
pub mod get_slot_type_input {
    /// A builder for [`GetSlotTypeInput`](crate::input::GetSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type. The name is case sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the slot type. </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the slot type. </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypeInput`](crate::input::GetSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSlotTypeInput {
                name: self.name,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSlotTypeInputOperationOutputAlias = crate::operation::GetSlotType;
#[doc(hidden)]
pub type GetSlotTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetSlotType`](crate::operation::GetSlotType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSlotType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.name;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_71, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            let input_72 = &_input.version;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version",
                        details: "cannot be empty or unset",
                    })?;
            let version = aws_smithy_http::label::fmt_string(input_72, false);
            if version.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "version",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/slottypes/{name}/versions/{version}",
                name = name,
                version = version
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSlotType",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSlotTypeInput`](crate::input::GetSlotTypeInput)
    pub fn builder() -> crate::input::get_slot_type_input::Builder {
        crate::input::get_slot_type_input::Builder::default()
    }
}

/// See [`GetSlotTypesInput`](crate::input::GetSlotTypesInput)
pub mod get_slot_types_input {
    /// A builder for [`GetSlotTypesInput`](crate::input::GetSlotTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) name_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A pagination token that fetches the next page of slot types. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch next page of slot types, specify the pagination
        /// token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token that fetches the next page of slot types. If the
        /// response to this API call is truncated, Amazon Lex returns a pagination token
        /// in the response. To fetch next page of slot types, specify the pagination
        /// token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of slot types to return in the response. The
        /// default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of slot types to return in the response. The
        /// default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Substring to match in slot type names. A slot type will be returned
        /// if any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn name_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_contains = Some(input.into());
            self
        }
        /// <p>Substring to match in slot type names. A slot type will be returned
        /// if any part of its name matches the substring. For example, "xyz" matches
        /// both "xyzabc" and "abcxyz."</p>
        pub fn set_name_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypesInput`](crate::input::GetSlotTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSlotTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSlotTypesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                name_contains: self.name_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSlotTypesInputOperationOutputAlias = crate::operation::GetSlotTypes;
#[doc(hidden)]
pub type GetSlotTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSlotTypesInput {
    /// Consumes the builder and constructs an Operation<[`GetSlotTypes`](crate::operation::GetSlotTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSlotTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSlotTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/slottypes").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSlotTypesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_73) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_73));
            }
            if let Some(inner_74) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_74).encode(),
                );
            }
            if let Some(inner_75) = &_input.name_contains {
                query.push_kv(
                    "nameContains",
                    &aws_smithy_http::query::fmt_string(&inner_75),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSlotTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSlotTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSlotTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSlotTypes",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSlotTypesInput`](crate::input::GetSlotTypesInput)
    pub fn builder() -> crate::input::get_slot_types_input::Builder {
        crate::input::get_slot_types_input::Builder::default()
    }
}

/// See [`GetSlotTypeVersionsInput`](crate::input::GetSlotTypeVersionsInput)
pub mod get_slot_type_versions_input {
    /// A builder for [`GetSlotTypeVersionsInput`](crate::input::GetSlotTypeVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the slot type for which versions should be
        /// returned.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type for which versions should be
        /// returned.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A pagination token for fetching the next page of slot type
        /// versions. If the response to this call is truncated, Amazon Lex returns a
        /// pagination token in the response. To fetch the next page of versions,
        /// specify the pagination token in the next request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token for fetching the next page of slot type
        /// versions. If the response to this call is truncated, Amazon Lex returns a
        /// pagination token in the response. To fetch the next page of versions,
        /// specify the pagination token in the next request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of slot type versions to return in the response.
        /// The default is 10.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of slot type versions to return in the response.
        /// The default is 10.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSlotTypeVersionsInput`](crate::input::GetSlotTypeVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSlotTypeVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSlotTypeVersionsInput {
                name: self.name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSlotTypeVersionsInputOperationOutputAlias = crate::operation::GetSlotTypeVersions;
#[doc(hidden)]
pub type GetSlotTypeVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSlotTypeVersionsInput {
    /// Consumes the builder and constructs an Operation<[`GetSlotTypeVersions`](crate::operation::GetSlotTypeVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSlotTypeVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSlotTypeVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.name;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_76, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/slottypes/{name}/versions", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetSlotTypeVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_77) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_77));
            }
            if let Some(inner_78) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_78).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSlotTypeVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSlotTypeVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSlotTypeVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSlotTypeVersions",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSlotTypeVersionsInput`](crate::input::GetSlotTypeVersionsInput)
    pub fn builder() -> crate::input::get_slot_type_versions_input::Builder {
        crate::input::get_slot_type_versions_input::Builder::default()
    }
}

/// See [`GetUtterancesViewInput`](crate::input::GetUtterancesViewInput)
pub mod get_utterances_view_input {
    /// A builder for [`GetUtterancesViewInput`](crate::input::GetUtterancesViewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) bot_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status_type: std::option::Option<crate::model::StatusType>,
    }
    impl Builder {
        /// <p>The name of the bot for which utterance information should be
        /// returned.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot for which utterance information should be
        /// returned.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// Appends an item to `bot_versions`.
        ///
        /// To override the contents of this collection use [`set_bot_versions`](Self::set_bot_versions).
        ///
        /// <p>An array of bot versions for which utterance information should be
        /// returned. The limit is 5 versions per request.</p>
        pub fn bot_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.bot_versions.unwrap_or_default();
            v.push(input.into());
            self.bot_versions = Some(v);
            self
        }
        /// <p>An array of bot versions for which utterance information should be
        /// returned. The limit is 5 versions per request.</p>
        pub fn set_bot_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.bot_versions = input;
            self
        }
        /// <p>To return utterances that were recognized and handled, use
        /// <code>Detected</code>. To return utterances that were not recognized,
        /// use <code>Missed</code>.</p>
        pub fn status_type(mut self, input: crate::model::StatusType) -> Self {
            self.status_type = Some(input);
            self
        }
        /// <p>To return utterances that were recognized and handled, use
        /// <code>Detected</code>. To return utterances that were not recognized,
        /// use <code>Missed</code>.</p>
        pub fn set_status_type(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.status_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUtterancesViewInput`](crate::input::GetUtterancesViewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUtterancesViewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUtterancesViewInput {
                bot_name: self.bot_name,
                bot_versions: self.bot_versions,
                status_type: self.status_type,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUtterancesViewInputOperationOutputAlias = crate::operation::GetUtterancesView;
#[doc(hidden)]
pub type GetUtterancesViewInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUtterancesViewInput {
    /// Consumes the builder and constructs an Operation<[`GetUtterancesView`](crate::operation::GetUtterancesView)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUtterancesView,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUtterancesViewInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.bot_name;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_79, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{botName}/utterances", botName = bot_name)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetUtterancesViewInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            query.push_kv("view", "aggregation");
            if let Some(inner_80) = &_input.bot_versions {
                for inner_81 in inner_80 {
                    query.push_kv(
                        "bot_versions",
                        &aws_smithy_http::query::fmt_string(&inner_81),
                    );
                }
            }
            if let Some(inner_82) = &_input.status_type {
                query.push_kv(
                    "status_type",
                    &aws_smithy_http::query::fmt_string(&inner_82),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUtterancesViewInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUtterancesViewInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUtterancesView::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUtterancesView",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUtterancesViewInput`](crate::input::GetUtterancesViewInput)
    pub fn builder() -> crate::input::get_utterances_view_input::Builder {
        crate::input::get_utterances_view_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
        /// for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
        /// for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.resource_arn;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_83, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutBotInput`](crate::input::PutBotInput)
pub mod put_bot_input {
    /// A builder for [`PutBotInput`](crate::input::PutBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        pub(crate) enable_model_improvements: std::option::Option<bool>,
        pub(crate) nlu_intent_confidence_threshold: std::option::Option<f64>,
        pub(crate) clarification_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) abort_statement: std::option::Option<crate::model::Statement>,
        pub(crate) idle_session_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) voice_id: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) process_behavior: std::option::Option<crate::model::ProcessBehavior>,
        pub(crate) locale: std::option::Option<crate::model::Locale>,
        pub(crate) child_directed: std::option::Option<bool>,
        pub(crate) detect_sentiment: std::option::Option<bool>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the bot. The name is <i>not</i> case
        /// sensitive. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bot. The name is <i>not</i> case
        /// sensitive. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the bot.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the bot.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `intents`.
        ///
        /// To override the contents of this collection use [`set_intents`](Self::set_intents).
        ///
        /// <p>An array of <code>Intent</code> objects. Each intent represents a
        /// command that a user can express. For example, a pizza ordering bot might
        /// support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>
        pub fn intents(mut self, input: impl Into<crate::model::Intent>) -> Self {
            let mut v = self.intents.unwrap_or_default();
            v.push(input.into());
            self.intents = Some(v);
            self
        }
        /// <p>An array of <code>Intent</code> objects. Each intent represents a
        /// command that a user can express. For example, a pizza ordering bot might
        /// support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>
        pub fn set_intents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Intent>>,
        ) -> Self {
            self.intents = input;
            self
        }
        /// <p>Set to <code>true</code> to enable access to natural language
        /// understanding improvements. </p>
        /// <p>When you set the <code>enableModelImprovements</code> parameter to
        /// <code>true</code> you can use the
        /// <code>nluIntentConfidenceThreshold</code> parameter to configure
        /// confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>You can only set the <code>enableModelImprovements</code> parameter in
        /// certain Regions. If you set the parameter to <code>true</code>, your bot
        /// has access to accuracy improvements.</p>
        /// <p>The Regions where you can set the <code>enableModelImprovements</code>
        /// parameter to <code>true</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (us-east-1)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (us-west-2)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
        /// </li>
        /// <li>
        /// <p>EU (Ireland) (eu-west-1)</p>
        /// </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
        /// is set to <code>true</code> by default. In these Regions setting the
        /// parameter to <code>false</code> throws a <code>ValidationException</code>
        /// exception.</p>
        pub fn enable_model_improvements(mut self, input: bool) -> Self {
            self.enable_model_improvements = Some(input);
            self
        }
        /// <p>Set to <code>true</code> to enable access to natural language
        /// understanding improvements. </p>
        /// <p>When you set the <code>enableModelImprovements</code> parameter to
        /// <code>true</code> you can use the
        /// <code>nluIntentConfidenceThreshold</code> parameter to configure
        /// confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
        /// <p>You can only set the <code>enableModelImprovements</code> parameter in
        /// certain Regions. If you set the parameter to <code>true</code>, your bot
        /// has access to accuracy improvements.</p>
        /// <p>The Regions where you can set the <code>enableModelImprovements</code>
        /// parameter to <code>true</code> are:</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (us-east-1)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (us-west-2)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
        /// </li>
        /// <li>
        /// <p>EU (Ireland) (eu-west-1)</p>
        /// </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
        /// is set to <code>true</code> by default. In these Regions setting the
        /// parameter to <code>false</code> throws a <code>ValidationException</code>
        /// exception.</p>
        pub fn set_enable_model_improvements(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_model_improvements = input;
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot.</p>
        /// <p>You must set the <code>enableModelImprovements</code> parameter to
        /// <code>true</code> to use confidence scores in the following
        /// regions.</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (us-east-1)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (us-west-2)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
        /// </li>
        /// <li>
        /// <p>EU (Ireland) (eu-west-1)</p>
        /// </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
        /// is set to <code>true</code> by default.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold
        /// of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three
        /// alternative intents with the following confidence scores: IntentA (0.70),
        /// IntentB (0.60), IntentC (0.50). The response from the
        /// <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>AMAZON.FallbackIntent</p>
        /// </li>
        /// <li>
        /// <p>IntentA</p>
        /// </li>
        /// <li>
        /// <p>IntentB</p>
        /// </li>
        /// <li>
        /// <p>IntentC</p>
        /// </li>
        /// </ul>
        pub fn nlu_intent_confidence_threshold(mut self, input: f64) -> Self {
            self.nlu_intent_confidence_threshold = Some(input);
            self
        }
        /// <p>Determines the threshold where Amazon Lex will insert the
        /// <code>AMAZON.FallbackIntent</code>,
        /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
        /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
        /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
        /// <code>AMAZON.FallbackIntent</code> and
        /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
        /// configured for the bot.</p>
        /// <p>You must set the <code>enableModelImprovements</code> parameter to
        /// <code>true</code> to use confidence scores in the following
        /// regions.</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (us-east-1)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (us-west-2)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
        /// </li>
        /// <li>
        /// <p>EU (Ireland) (eu-west-1)</p>
        /// </li>
        /// </ul>
        /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
        /// is set to <code>true</code> by default.</p>
        /// <p>For example, suppose a bot is configured with the confidence threshold
        /// of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three
        /// alternative intents with the following confidence scores: IntentA (0.70),
        /// IntentB (0.60), IntentC (0.50). The response from the
        /// <code>PostText</code> operation would be:</p>
        /// <ul>
        /// <li>
        /// <p>AMAZON.FallbackIntent</p>
        /// </li>
        /// <li>
        /// <p>IntentA</p>
        /// </li>
        /// <li>
        /// <p>IntentB</p>
        /// </li>
        /// <li>
        /// <p>IntentC</p>
        /// </li>
        /// </ul>
        pub fn set_nlu_intent_confidence_threshold(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.nlu_intent_confidence_threshold = input;
            self
        }
        /// <p>When Amazon Lex doesn't understand the user's intent, it uses this
        /// message to get clarification. To specify how many times Amazon Lex should
        /// repeat the clarification prompt, use the <code>maxAttempts</code> field.
        /// If Amazon Lex still doesn't understand, it sends the message in the
        /// <code>abortStatement</code> field. </p>
        /// <p>When you create a clarification prompt, make sure that it suggests
        /// the correct response from the user. for example, for a bot that orders
        /// pizza and drinks, you might create this clarification prompt: "What would
        /// you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
        /// <p>If you have defined a fallback intent, it will be invoked if the
        /// clarification prompt is repeated the number of times defined in the
        /// <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
        /// AMAZON.FallbackIntent</a>.</p>
        /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will
        /// return a 400 Bad Request exception in three cases: </p>
        /// <ul>
        /// <li>
        /// <p>Follow-up prompt - When the user responds to a follow-up prompt
        /// but does not provide an intent. For example, in response to a
        /// follow-up prompt that says "Would you like anything else today?" the
        /// user says "Yes." Amazon Lex will return a 400 Bad Request exception because
        /// it does not have a clarification prompt to send to the user to get an
        /// intent.</p>
        /// </li>
        /// <li>
        /// <p>Lambda function - When using a Lambda function, you return an
        /// <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a
        /// clarification prompt to get an intent from the user, it returns a 400
        /// Bad Request exception.</p>
        /// </li>
        /// <li>
        /// <p>PutSession operation - When using the <code>PutSession</code>
        /// operation, you send an <code>ElicitIntent</code> dialog type. Since
        /// Amazon Lex does not have a clarification prompt to get an intent from the
        /// user, it returns a 400 Bad Request exception.</p>
        /// </li>
        /// </ul>
        pub fn clarification_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.clarification_prompt = Some(input);
            self
        }
        /// <p>When Amazon Lex doesn't understand the user's intent, it uses this
        /// message to get clarification. To specify how many times Amazon Lex should
        /// repeat the clarification prompt, use the <code>maxAttempts</code> field.
        /// If Amazon Lex still doesn't understand, it sends the message in the
        /// <code>abortStatement</code> field. </p>
        /// <p>When you create a clarification prompt, make sure that it suggests
        /// the correct response from the user. for example, for a bot that orders
        /// pizza and drinks, you might create this clarification prompt: "What would
        /// you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
        /// <p>If you have defined a fallback intent, it will be invoked if the
        /// clarification prompt is repeated the number of times defined in the
        /// <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
        /// AMAZON.FallbackIntent</a>.</p>
        /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will
        /// return a 400 Bad Request exception in three cases: </p>
        /// <ul>
        /// <li>
        /// <p>Follow-up prompt - When the user responds to a follow-up prompt
        /// but does not provide an intent. For example, in response to a
        /// follow-up prompt that says "Would you like anything else today?" the
        /// user says "Yes." Amazon Lex will return a 400 Bad Request exception because
        /// it does not have a clarification prompt to send to the user to get an
        /// intent.</p>
        /// </li>
        /// <li>
        /// <p>Lambda function - When using a Lambda function, you return an
        /// <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a
        /// clarification prompt to get an intent from the user, it returns a 400
        /// Bad Request exception.</p>
        /// </li>
        /// <li>
        /// <p>PutSession operation - When using the <code>PutSession</code>
        /// operation, you send an <code>ElicitIntent</code> dialog type. Since
        /// Amazon Lex does not have a clarification prompt to get an intent from the
        /// user, it returns a 400 Bad Request exception.</p>
        /// </li>
        /// </ul>
        pub fn set_clarification_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.clarification_prompt = input;
            self
        }
        /// <p>When Amazon Lex can't understand the user's input in context, it tries
        /// to elicit the information a few times. After that, Amazon Lex sends the message
        /// defined in <code>abortStatement</code> to the user, and then cancels the
        /// conversation. To set the number of retries, use the
        /// <code>valueElicitationPrompt</code> field for the slot type. </p>
        /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What
        /// type of crust would you like?" If the user's response is not one of the
        /// expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex
        /// tries to elicit a correct response a few more times. </p>
        /// <p>For example, in a pizza ordering application,
        /// <code>OrderPizza</code> might be one of the intents. This intent might
        /// require the <code>CrustType</code> slot. You specify the
        /// <code>valueElicitationPrompt</code> field when you create the
        /// <code>CrustType</code> slot.</p>
        /// <p>If you have defined a fallback intent the cancel statement will not be
        /// sent to the user, the fallback intent is used instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
        /// AMAZON.FallbackIntent</a>.</p>
        pub fn abort_statement(mut self, input: crate::model::Statement) -> Self {
            self.abort_statement = Some(input);
            self
        }
        /// <p>When Amazon Lex can't understand the user's input in context, it tries
        /// to elicit the information a few times. After that, Amazon Lex sends the message
        /// defined in <code>abortStatement</code> to the user, and then cancels the
        /// conversation. To set the number of retries, use the
        /// <code>valueElicitationPrompt</code> field for the slot type. </p>
        /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What
        /// type of crust would you like?" If the user's response is not one of the
        /// expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex
        /// tries to elicit a correct response a few more times. </p>
        /// <p>For example, in a pizza ordering application,
        /// <code>OrderPizza</code> might be one of the intents. This intent might
        /// require the <code>CrustType</code> slot. You specify the
        /// <code>valueElicitationPrompt</code> field when you create the
        /// <code>CrustType</code> slot.</p>
        /// <p>If you have defined a fallback intent the cancel statement will not be
        /// sent to the user, the fallback intent is used instead. For more
        /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
        /// AMAZON.FallbackIntent</a>.</p>
        pub fn set_abort_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.abort_statement = input;
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation.</p>
        /// <p>A user interaction session remains active for the amount of time
        /// specified. If no conversation occurs during this time, the session expires
        /// and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>For example, suppose that a user chooses the OrderPizza intent, but
        /// gets sidetracked halfway through placing an order. If the user doesn't
        /// complete the order within the specified time, Amazon Lex discards the slot
        /// information that it gathered, and the user must start over.</p>
        /// <p>If you don't include the <code>idleSessionTTLInSeconds</code>
        /// element in a <code>PutBot</code> operation request, Amazon Lex uses the default
        /// value. This is also true if the request replaces an existing
        /// bot.</p>
        /// <p>The default is 300 seconds (5 minutes).</p>
        pub fn idle_session_ttl_in_seconds(mut self, input: i32) -> Self {
            self.idle_session_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
        /// a conversation.</p>
        /// <p>A user interaction session remains active for the amount of time
        /// specified. If no conversation occurs during this time, the session expires
        /// and Amazon Lex deletes any data provided before the timeout.</p>
        /// <p>For example, suppose that a user chooses the OrderPizza intent, but
        /// gets sidetracked halfway through placing an order. If the user doesn't
        /// complete the order within the specified time, Amazon Lex discards the slot
        /// information that it gathered, and the user must start over.</p>
        /// <p>If you don't include the <code>idleSessionTTLInSeconds</code>
        /// element in a <code>PutBot</code> operation request, Amazon Lex uses the default
        /// value. This is also true if the request replaces an existing
        /// bot.</p>
        /// <p>The default is 300 seconds (5 minutes).</p>
        pub fn set_idle_session_ttl_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_session_ttl_in_seconds = input;
            self
        }
        /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice
        /// interactions with the user. The locale configured for the voice must match
        /// the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices
        /// in Amazon Polly</a> in the <i>Amazon Polly Developer
        /// Guide</i>.</p>
        pub fn voice_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voice_id = Some(input.into());
            self
        }
        /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice
        /// interactions with the user. The locale configured for the voice must match
        /// the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices
        /// in Amazon Polly</a> in the <i>Amazon Polly Developer
        /// Guide</i>.</p>
        pub fn set_voice_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.voice_id = input;
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new bot, leave the <code>checksum</code> field
        /// blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot, set the <code>checksum</code> field
        /// to the checksum of the most recent revision of the <code>$LATEST</code>
        /// version. If you don't specify the <code> checksum</code> field, or if the
        /// checksum does not match the <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new bot, leave the <code>checksum</code> field
        /// blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot, set the <code>checksum</code> field
        /// to the checksum of the most recent revision of the <code>$LATEST</code>
        /// version. If you don't specify the <code> checksum</code> field, or if the
        /// checksum does not match the <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>If you set the <code>processBehavior</code> element to
        /// <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you
        /// set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
        /// build it. </p>
        /// <p>If you don't specify this value, the default value is
        /// <code>BUILD</code>.</p>
        pub fn process_behavior(mut self, input: crate::model::ProcessBehavior) -> Self {
            self.process_behavior = Some(input);
            self
        }
        /// <p>If you set the <code>processBehavior</code> element to
        /// <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you
        /// set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
        /// build it. </p>
        /// <p>If you don't specify this value, the default value is
        /// <code>BUILD</code>.</p>
        pub fn set_process_behavior(
            mut self,
            input: std::option::Option<crate::model::ProcessBehavior>,
        ) -> Self {
            self.process_behavior = input;
            self
        }
        /// <p> Specifies the target locale for the bot. Any intent used in the
        /// bot must be compatible with the locale of the bot. </p>
        ///
        /// <p>The default is <code>en-US</code>.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.locale = Some(input);
            self
        }
        /// <p> Specifies the target locale for the bot. Any intent used in the
        /// bot must be compatible with the locale of the bot. </p>
        ///
        /// <p>The default is <code>en-US</code>.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.locale = input;
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn child_directed(mut self, input: bool) -> Self {
            self.child_directed = Some(input);
            self
        }
        /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
        /// you must specify whether your use of Amazon Lex is related to a website,
        /// program, or other application that is directed or targeted, in whole or in
        /// part, to children under age 13 and subject to the Children's Online
        /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
        /// <code>false</code> in the <code>childDirected</code> field. By
        /// specifying <code>true</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is</b> related
        /// to a website, program, or other application that is directed or targeted,
        /// in whole or in part, to children under age 13 and subject to COPPA. By
        /// specifying <code>false</code> in the <code>childDirected</code> field, you
        /// confirm that your use of Amazon Lex <b>is not</b>
        /// related to a website, program, or other application that is directed or
        /// targeted, in whole or in part, to children under age 13 and subject to
        /// COPPA. You may not specify a default value for the
        /// <code>childDirected</code> field that does not accurately reflect
        /// whether your use of Amazon Lex is related to a website, program, or other
        /// application that is directed or targeted, in whole or in part, to children
        /// under age 13 and subject to COPPA.</p>
        /// <p>If your use of Amazon Lex relates to a website, program, or other
        /// application that is directed in whole or in part, to children under age
        /// 13, you must obtain any required verifiable parental consent under COPPA.
        /// For information regarding the use of Amazon Lex in connection with websites,
        /// programs, or other applications that are directed or targeted, in whole or
        /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
        /// </p>
        pub fn set_child_directed(mut self, input: std::option::Option<bool>) -> Self {
            self.child_directed = input;
            self
        }
        /// <p>When set to <code>true</code> user utterances are sent to Amazon
        /// Comprehend for sentiment analysis. If you don't specify
        /// <code>detectSentiment</code>, the default is <code>false</code>.</p>
        pub fn detect_sentiment(mut self, input: bool) -> Self {
            self.detect_sentiment = Some(input);
            self
        }
        /// <p>When set to <code>true</code> user utterances are sent to Amazon
        /// Comprehend for sentiment analysis. If you don't specify
        /// <code>detectSentiment</code>, the default is <code>false</code>.</p>
        pub fn set_detect_sentiment(mut self, input: std::option::Option<bool>) -> Self {
            self.detect_sentiment = input;
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the bot is
        /// created. This is the same as calling the <code>CreateBotVersion</code>
        /// operation. If you don't specify <code>createVersion</code>, the default is
        /// <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the bot is
        /// created. This is the same as calling the <code>CreateBotVersion</code>
        /// operation. If you don't specify <code>createVersion</code>, the default is
        /// <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// create a bot, you can't use the <code>PutBot</code> operation to update
        /// the tags on a bot. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to add to the bot. You can only add tags when you
        /// create a bot, you can't use the <code>PutBot</code> operation to update
        /// the tags on a bot. To update tags, use the <code>TagResource</code>
        /// operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBotInput`](crate::input::PutBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutBotInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutBotInput {
                name: self.name,
                description: self.description,
                intents: self.intents,
                enable_model_improvements: self.enable_model_improvements,
                nlu_intent_confidence_threshold: self.nlu_intent_confidence_threshold,
                clarification_prompt: self.clarification_prompt,
                abort_statement: self.abort_statement,
                idle_session_ttl_in_seconds: self.idle_session_ttl_in_seconds,
                voice_id: self.voice_id,
                checksum: self.checksum,
                process_behavior: self.process_behavior,
                locale: self.locale,
                child_directed: self.child_directed,
                detect_sentiment: self.detect_sentiment,
                create_version: self.create_version,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBotInputOperationOutputAlias = crate::operation::PutBot;
#[doc(hidden)]
pub type PutBotInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBotInput {
    /// Consumes the builder and constructs an Operation<[`PutBot`](crate::operation::PutBot)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBot,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_84 = &_input.name;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_84, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/bots/{name}/versions/$LATEST", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_bot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutBot::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutBot",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBotInput`](crate::input::PutBotInput)
    pub fn builder() -> crate::input::put_bot_input::Builder {
        crate::input::put_bot_input::Builder::default()
    }
}

/// See [`PutBotAliasInput`](crate::input::PutBotAliasInput)
pub mod put_bot_alias_input {
    /// A builder for [`PutBotAliasInput`](crate::input::PutBotAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) bot_version: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) conversation_logs: std::option::Option<crate::model::ConversationLogsRequest>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the alias. The name is <i>not</i> case
        /// sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias. The name is <i>not</i> case
        /// sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The version of the bot.</p>
        pub fn bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot.</p>
        pub fn set_bot_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_version = input;
            self
        }
        /// <p>The name of the bot.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the bot.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new bot alias, leave the <code>checksum</code>
        /// field blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot alias, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new bot alias, leave the <code>checksum</code>
        /// field blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a bot alias, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Settings for conversation logs for the alias.</p>
        pub fn conversation_logs(mut self, input: crate::model::ConversationLogsRequest) -> Self {
            self.conversation_logs = Some(input);
            self
        }
        /// <p>Settings for conversation logs for the alias.</p>
        pub fn set_conversation_logs(
            mut self,
            input: std::option::Option<crate::model::ConversationLogsRequest>,
        ) -> Self {
            self.conversation_logs = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the bot alias. You can only add tags when you
        /// create an alias, you can't use the <code>PutBotAlias</code> operation to
        /// update the tags on a bot alias. To update tags, use the
        /// <code>TagResource</code> operation.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to add to the bot alias. You can only add tags when you
        /// create an alias, you can't use the <code>PutBotAlias</code> operation to
        /// update the tags on a bot alias. To update tags, use the
        /// <code>TagResource</code> operation.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutBotAliasInput`](crate::input::PutBotAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutBotAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutBotAliasInput {
                name: self.name,
                description: self.description,
                bot_version: self.bot_version,
                bot_name: self.bot_name,
                checksum: self.checksum,
                conversation_logs: self.conversation_logs,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutBotAliasInputOperationOutputAlias = crate::operation::PutBotAlias;
#[doc(hidden)]
pub type PutBotAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutBotAliasInput {
    /// Consumes the builder and constructs an Operation<[`PutBotAlias`](crate::operation::PutBotAlias)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutBotAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutBotAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_85 = &_input.bot_name;
            let input_85 =
                input_85
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "bot_name",
                        details: "cannot be empty or unset",
                    })?;
            let bot_name = aws_smithy_http::label::fmt_string(input_85, false);
            if bot_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "bot_name",
                    details: "cannot be empty or unset",
                });
            }
            let input_86 = &_input.name;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_86, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/bots/{botName}/aliases/{name}",
                botName = bot_name,
                name = name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutBotAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutBotAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_bot_alias(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutBotAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutBotAlias",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutBotAliasInput`](crate::input::PutBotAliasInput)
    pub fn builder() -> crate::input::put_bot_alias_input::Builder {
        crate::input::put_bot_alias_input::Builder::default()
    }
}

/// See [`PutIntentInput`](crate::input::PutIntentInput)
pub mod put_intent_input {
    /// A builder for [`PutIntentInput`](crate::input::PutIntentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        pub(crate) sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) confirmation_prompt: std::option::Option<crate::model::Prompt>,
        pub(crate) rejection_statement: std::option::Option<crate::model::Statement>,
        pub(crate) follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
        pub(crate) conclusion_statement: std::option::Option<crate::model::Statement>,
        pub(crate) dialog_code_hook: std::option::Option<crate::model::CodeHook>,
        pub(crate) fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
        pub(crate) parent_intent_signature: std::option::Option<std::string::String>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
        pub(crate) input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        pub(crate) output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
    }
    impl Builder {
        /// <p>The name of the intent. The name is <i>not</i> case
        /// sensitive. </p>
        /// <p>The name can't match a built-in intent name, or a built-in intent
        /// name with "AMAZON." removed. For example, because there is a built-in
        /// intent called <code>AMAZON.HelpIntent</code>, you can't create a custom
        /// intent called <code>HelpIntent</code>.</p>
        /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the intent. The name is <i>not</i> case
        /// sensitive. </p>
        /// <p>The name can't match a built-in intent name, or a built-in intent
        /// name with "AMAZON." removed. For example, because there is a built-in
        /// intent called <code>AMAZON.HelpIntent</code>, you can't create a custom
        /// intent called <code>HelpIntent</code>.</p>
        /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the intent.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the intent.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `slots`.
        ///
        /// To override the contents of this collection use [`set_slots`](Self::set_slots).
        ///
        /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot
        /// values from the user using prompts defined in the slots. For more
        /// information, see <a>how-it-works</a>. </p>
        pub fn slots(mut self, input: impl Into<crate::model::Slot>) -> Self {
            let mut v = self.slots.unwrap_or_default();
            v.push(input.into());
            self.slots = Some(v);
            self
        }
        /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot
        /// values from the user using prompts defined in the slots. For more
        /// information, see <a>how-it-works</a>. </p>
        pub fn set_slots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Slot>>,
        ) -> Self {
            self.slots = input;
            self
        }
        /// Appends an item to `sample_utterances`.
        ///
        /// To override the contents of this collection use [`set_sample_utterances`](Self::set_sample_utterances).
        ///
        /// <p>An array of utterances (strings) that a user might say to signal
        /// the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity}
        /// {PizzaSize} pizzas". </p>
        ///
        /// <p>In each utterance, a slot name is enclosed in curly braces.
        /// </p>
        pub fn sample_utterances(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.sample_utterances.unwrap_or_default();
            v.push(input.into());
            self.sample_utterances = Some(v);
            self
        }
        /// <p>An array of utterances (strings) that a user might say to signal
        /// the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity}
        /// {PizzaSize} pizzas". </p>
        ///
        /// <p>In each utterance, a slot name is enclosed in curly braces.
        /// </p>
        pub fn set_sample_utterances(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.sample_utterances = input;
            self
        }
        /// <p>Prompts the user to confirm the intent. This question should have a
        /// yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that
        /// the intent is ready for fulfillment. For example, with the
        /// <code>OrderPizza</code> intent, you might want to confirm that the order
        /// is correct before placing it. For other intents, such as intents that
        /// simply respond to user questions, you might not need to ask the user for
        /// confirmation before providing the information. </p>
        /// <note>
        /// <p>You you must provide both the <code>rejectionStatement</code> and
        /// the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn confirmation_prompt(mut self, input: crate::model::Prompt) -> Self {
            self.confirmation_prompt = Some(input);
            self
        }
        /// <p>Prompts the user to confirm the intent. This question should have a
        /// yes or no answer.</p>
        /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that
        /// the intent is ready for fulfillment. For example, with the
        /// <code>OrderPizza</code> intent, you might want to confirm that the order
        /// is correct before placing it. For other intents, such as intents that
        /// simply respond to user questions, you might not need to ask the user for
        /// confirmation before providing the information. </p>
        /// <note>
        /// <p>You you must provide both the <code>rejectionStatement</code> and
        /// the <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn set_confirmation_prompt(
            mut self,
            input: std::option::Option<crate::model::Prompt>,
        ) -> Self {
            self.confirmation_prompt = input;
            self
        }
        /// <p>When the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        /// <note>
        /// <p>You must provide both the <code>rejectionStatement</code> and the
        /// <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn rejection_statement(mut self, input: crate::model::Statement) -> Self {
            self.rejection_statement = Some(input);
            self
        }
        /// <p>When the user answers "no" to the question defined in
        /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
        /// acknowledge that the intent was canceled. </p>
        /// <note>
        /// <p>You must provide both the <code>rejectionStatement</code> and the
        /// <code>confirmationPrompt</code>, or neither.</p>
        /// </note>
        pub fn set_rejection_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.rejection_statement = input;
            self
        }
        /// <p>Amazon Lex uses this prompt to solicit additional activity after
        /// fulfilling an intent. For example, after the <code>OrderPizza</code>
        /// intent is fulfilled, you might prompt the user to order a drink.</p>
        /// <p>The action that Amazon Lex takes depends on the user's response, as
        /// follows:</p>
        /// <ul>
        /// <li>
        /// <p>If the user says "Yes" it responds with the clarification
        /// prompt that is configured for the bot.</p>
        /// </li>
        /// <li>
        /// <p>if the user says "Yes" and continues with an utterance that
        /// triggers an intent it starts a conversation for the intent.</p>
        /// </li>
        /// <li>
        /// <p>If the user says "No" it responds with the rejection statement
        /// configured for the the follow-up prompt.</p>
        /// </li>
        /// <li>
        /// <p>If it doesn't recognize the utterance it repeats the follow-up
        /// prompt again.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The <code>followUpPrompt</code> field and the
        /// <code>conclusionStatement</code> field are mutually exclusive. You can
        /// specify only one. </p>
        pub fn follow_up_prompt(mut self, input: crate::model::FollowUpPrompt) -> Self {
            self.follow_up_prompt = Some(input);
            self
        }
        /// <p>Amazon Lex uses this prompt to solicit additional activity after
        /// fulfilling an intent. For example, after the <code>OrderPizza</code>
        /// intent is fulfilled, you might prompt the user to order a drink.</p>
        /// <p>The action that Amazon Lex takes depends on the user's response, as
        /// follows:</p>
        /// <ul>
        /// <li>
        /// <p>If the user says "Yes" it responds with the clarification
        /// prompt that is configured for the bot.</p>
        /// </li>
        /// <li>
        /// <p>if the user says "Yes" and continues with an utterance that
        /// triggers an intent it starts a conversation for the intent.</p>
        /// </li>
        /// <li>
        /// <p>If the user says "No" it responds with the rejection statement
        /// configured for the the follow-up prompt.</p>
        /// </li>
        /// <li>
        /// <p>If it doesn't recognize the utterance it repeats the follow-up
        /// prompt again.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>The <code>followUpPrompt</code> field and the
        /// <code>conclusionStatement</code> field are mutually exclusive. You can
        /// specify only one. </p>
        pub fn set_follow_up_prompt(
            mut self,
            input: std::option::Option<crate::model::FollowUpPrompt>,
        ) -> Self {
            self.follow_up_prompt = input;
            self
        }
        /// <p> The statement that you want Amazon Lex to convey to the user after the
        /// intent is successfully fulfilled by the Lambda function. </p>
        /// <p>This element is relevant only if you provide a Lambda function in
        /// the <code>fulfillmentActivity</code>. If you return the intent to the
        /// client application, you can't specify this element.</p>
        /// <note>
        /// <p>The <code>followUpPrompt</code> and
        /// <code>conclusionStatement</code> are mutually exclusive. You can
        /// specify only one.</p>
        /// </note>
        pub fn conclusion_statement(mut self, input: crate::model::Statement) -> Self {
            self.conclusion_statement = Some(input);
            self
        }
        /// <p> The statement that you want Amazon Lex to convey to the user after the
        /// intent is successfully fulfilled by the Lambda function. </p>
        /// <p>This element is relevant only if you provide a Lambda function in
        /// the <code>fulfillmentActivity</code>. If you return the intent to the
        /// client application, you can't specify this element.</p>
        /// <note>
        /// <p>The <code>followUpPrompt</code> and
        /// <code>conclusionStatement</code> are mutually exclusive. You can
        /// specify only one.</p>
        /// </note>
        pub fn set_conclusion_statement(
            mut self,
            input: std::option::Option<crate::model::Statement>,
        ) -> Self {
            self.conclusion_statement = input;
            self
        }
        /// <p> Specifies a Lambda function to invoke for each user input. You can
        /// invoke this Lambda function to personalize user interaction. </p>
        /// <p>For example, suppose your bot determines that the user is John.
        /// Your Lambda function might retrieve John's information from a backend
        /// database and prepopulate some of the values. For example, if you find that
        /// John is gluten intolerant, you might set the corresponding intent slot,
        /// <code>GlutenIntolerant</code>, to true. You might find John's phone
        /// number and set the corresponding session attribute. </p>
        pub fn dialog_code_hook(mut self, input: crate::model::CodeHook) -> Self {
            self.dialog_code_hook = Some(input);
            self
        }
        /// <p> Specifies a Lambda function to invoke for each user input. You can
        /// invoke this Lambda function to personalize user interaction. </p>
        /// <p>For example, suppose your bot determines that the user is John.
        /// Your Lambda function might retrieve John's information from a backend
        /// database and prepopulate some of the values. For example, if you find that
        /// John is gluten intolerant, you might set the corresponding intent slot,
        /// <code>GlutenIntolerant</code>, to true. You might find John's phone
        /// number and set the corresponding session attribute. </p>
        pub fn set_dialog_code_hook(
            mut self,
            input: std::option::Option<crate::model::CodeHook>,
        ) -> Self {
            self.dialog_code_hook = input;
            self
        }
        /// <p>Required. Describes how the intent is fulfilled. For example, after
        /// a user provides all of the information for a pizza order,
        /// <code>fulfillmentActivity</code> defines how the bot places an order
        /// with a local pizza store. </p>
        /// <p> You might configure Amazon Lex to return all of the intent information
        /// to the client application, or direct it to invoke a Lambda function that
        /// can process the intent (for example, place an order with a pizzeria).
        /// </p>
        pub fn fulfillment_activity(mut self, input: crate::model::FulfillmentActivity) -> Self {
            self.fulfillment_activity = Some(input);
            self
        }
        /// <p>Required. Describes how the intent is fulfilled. For example, after
        /// a user provides all of the information for a pizza order,
        /// <code>fulfillmentActivity</code> defines how the bot places an order
        /// with a local pizza store. </p>
        /// <p> You might configure Amazon Lex to return all of the intent information
        /// to the client application, or direct it to invoke a Lambda function that
        /// can process the intent (for example, place an order with a pizzeria).
        /// </p>
        pub fn set_fulfillment_activity(
            mut self,
            input: std::option::Option<crate::model::FulfillmentActivity>,
        ) -> Self {
            self.fulfillment_activity = input;
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.
        /// To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn parent_intent_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_intent_signature = Some(input.into());
            self
        }
        /// <p>A unique identifier for the built-in intent to base this intent on.
        /// To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_parent_intent_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_intent_signature = input;
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new intent, leave the <code>checksum</code> field
        /// blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a intent, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new intent, leave the <code>checksum</code> field
        /// blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a intent, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the intent
        /// is created. This is the same as calling the
        /// <code>CreateIntentVersion</code> operation. If you do not specify
        /// <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the intent
        /// is created. This is the same as calling the
        /// <code>CreateIntentVersion</code> operation. If you do not specify
        /// <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// <p>Configuration information required to use the
        /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon
        /// Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
        /// AMAZON.KendraSearchIntent</a>.</p>
        pub fn kendra_configuration(mut self, input: crate::model::KendraConfiguration) -> Self {
            self.kendra_configuration = Some(input);
            self
        }
        /// <p>Configuration information required to use the
        /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon
        /// Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
        /// AMAZON.KendraSearchIntent</a>.</p>
        pub fn set_kendra_configuration(
            mut self,
            input: std::option::Option<crate::model::KendraConfiguration>,
        ) -> Self {
            self.kendra_configuration = input;
            self
        }
        /// Appends an item to `input_contexts`.
        ///
        /// To override the contents of this collection use [`set_input_contexts`](Self::set_input_contexts).
        ///
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn input_contexts(mut self, input: impl Into<crate::model::InputContext>) -> Self {
            let mut v = self.input_contexts.unwrap_or_default();
            v.push(input.into());
            self.input_contexts = Some(v);
            self
        }
        /// <p>An array of <code>InputContext</code> objects that lists the contexts
        /// that must be active for Amazon Lex to choose the intent in a conversation with
        /// the user.</p>
        pub fn set_input_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
        ) -> Self {
            self.input_contexts = input;
            self
        }
        /// Appends an item to `output_contexts`.
        ///
        /// To override the contents of this collection use [`set_output_contexts`](Self::set_output_contexts).
        ///
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn output_contexts(mut self, input: impl Into<crate::model::OutputContext>) -> Self {
            let mut v = self.output_contexts.unwrap_or_default();
            v.push(input.into());
            self.output_contexts = Some(v);
            self
        }
        /// <p>An array of <code>OutputContext</code> objects that lists the contexts
        /// that the intent activates when the intent is fulfilled.</p>
        pub fn set_output_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
        ) -> Self {
            self.output_contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntentInput`](crate::input::PutIntentInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutIntentInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutIntentInput {
                name: self.name,
                description: self.description,
                slots: self.slots,
                sample_utterances: self.sample_utterances,
                confirmation_prompt: self.confirmation_prompt,
                rejection_statement: self.rejection_statement,
                follow_up_prompt: self.follow_up_prompt,
                conclusion_statement: self.conclusion_statement,
                dialog_code_hook: self.dialog_code_hook,
                fulfillment_activity: self.fulfillment_activity,
                parent_intent_signature: self.parent_intent_signature,
                checksum: self.checksum,
                create_version: self.create_version,
                kendra_configuration: self.kendra_configuration,
                input_contexts: self.input_contexts,
                output_contexts: self.output_contexts,
            })
        }
    }
}
#[doc(hidden)]
pub type PutIntentInputOperationOutputAlias = crate::operation::PutIntent;
#[doc(hidden)]
pub type PutIntentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutIntentInput {
    /// Consumes the builder and constructs an Operation<[`PutIntent`](crate::operation::PutIntent)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutIntent,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutIntentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_87 = &_input.name;
            let input_87 =
                input_87
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_87, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/intents/{name}/versions/$LATEST", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutIntentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutIntentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_intent(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutIntent::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutIntent",
                    "lexmodelbuildingservice",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutIntentInput`](crate::input::PutIntentInput)
    pub fn builder() -> crate::input::put_intent_input::Builder {
        crate::input::put_intent_input::Builder::default()
    }
}

/// See [`PutSlotTypeInput`](crate::input::PutSlotTypeInput)
pub mod put_slot_type_input {
    /// A builder for [`PutSlotTypeInput`](crate::input::PutSlotTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) enumeration_values:
            std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        pub(crate) checksum: std::option::Option<std::string::String>,
        pub(crate) value_selection_strategy:
            std::option::Option<crate::model::SlotValueSelectionStrategy>,
        pub(crate) create_version: std::option::Option<bool>,
        pub(crate) parent_slot_type_signature: std::option::Option<std::string::String>,
        pub(crate) slot_type_configurations:
            std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
    }
    impl Builder {
        /// <p>The name of the slot type. The name is <i>not</i>
        /// case sensitive. </p>
        /// <p>The name can't match a built-in slot type name, or a built-in slot
        /// type name with "AMAZON." removed. For example, because there is a built-in
        /// slot type called <code>AMAZON.DATE</code>, you can't create a custom slot
        /// type called <code>DATE</code>.</p>
        /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the slot type. The name is <i>not</i>
        /// case sensitive. </p>
        /// <p>The name can't match a built-in slot type name, or a built-in slot
        /// type name with "AMAZON." removed. For example, because there is a built-in
        /// slot type called <code>AMAZON.DATE</code>, you can't create a custom slot
        /// type called <code>DATE</code>.</p>
        /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
        /// Kit</i>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the slot type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `enumeration_values`.
        ///
        /// To override the contents of this collection use [`set_enumeration_values`](Self::set_enumeration_values).
        ///
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take. Each value can have a list of
        /// <code>synonyms</code>, which are additional values that help train the
        /// machine learning model about the values that it resolves for a slot. </p>
        /// <p>A regular expression slot type doesn't require enumeration values.
        /// All other slot types require a list of enumeration values.</p>
        /// <p>When Amazon Lex resolves a slot value, it generates a resolution list
        /// that contains up to five possible values for the slot. If you are using a
        /// Lambda function, this resolution list is passed to the function. If you
        /// are not using a Lambda function you can choose to return the value that
        /// the user entered or the first value in the resolution list as the slot
        /// value. The <code>valueSelectionStrategy</code> field indicates the option
        /// to use. </p>
        pub fn enumeration_values(
            mut self,
            input: impl Into<crate::model::EnumerationValue>,
        ) -> Self {
            let mut v = self.enumeration_values.unwrap_or_default();
            v.push(input.into());
            self.enumeration_values = Some(v);
            self
        }
        /// <p>A list of <code>EnumerationValue</code> objects that defines the
        /// values that the slot type can take. Each value can have a list of
        /// <code>synonyms</code>, which are additional values that help train the
        /// machine learning model about the values that it resolves for a slot. </p>
        /// <p>A regular expression slot type doesn't require enumeration values.
        /// All other slot types require a list of enumeration values.</p>
        /// <p>When Amazon Lex resolves a slot value, it generates a resolution list
        /// that contains up to five possible values for the slot. If you are using a
        /// Lambda function, this resolution list is passed to the function. If you
        /// are not using a Lambda function you can choose to return the value that
        /// the user entered or the first value in the resolution list as the slot
        /// value. The <code>valueSelectionStrategy</code> field indicates the option
        /// to use. </p>
        pub fn set_enumeration_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
        ) -> Self {
            self.enumeration_values = input;
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new slot type, leave the <code>checksum</code>
        /// field blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a slot type, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn checksum(mut self, input: impl Into<std::string::String>) -> Self {
            self.checksum = Some(input.into());
            self
        }
        /// <p>Identifies a specific revision of the <code>$LATEST</code>
        /// version.</p>
        /// <p>When you create a new slot type, leave the <code>checksum</code>
        /// field blank. If you specify a checksum you get a
        /// <code>BadRequestException</code> exception.</p>
        /// <p>When you want to update a slot type, set the <code>checksum</code>
        /// field to the checksum of the most recent revision of the
        /// <code>$LATEST</code> version. If you don't specify the <code>
        /// checksum</code> field, or if the checksum does not match the
        /// <code>$LATEST</code> version, you get a
        /// <code>PreconditionFailedException</code> exception.</p>
        pub fn set_checksum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.checksum = input;
            self
        }
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to return
        /// slot type values. The field can be set to one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ORIGINAL_VALUE</code> - Returns the value entered by the
        /// user, if the user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_RESOLUTION</code> - If there is a resolution list for
        /// the slot, return the first value in the resolution list as the slot
        /// type value. If there is no resolution list, null is
        /// returned.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the
        /// default is <code>ORIGINAL_VALUE</code>.</p>
        pub fn value_selection_strategy(
            mut self,
            input: crate::model::SlotValueSelectionStrategy,
        ) -> Self {
            self.value_selection_strategy = Some(input);
            self
        }
        /// <p>Determines the slot resolution strategy that Amazon Lex uses to return
        /// slot type values. The field can be set to one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ORIGINAL_VALUE</code> - Returns the value entered by the
        /// user, if the user value is similar to the slot value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TOP_RESOLUTION</code> - If there is a resolution list for
        /// the slot, return the first value in the resolution list as the slot
        /// type value. If there is no resolution list, null is
        /// returned.</p>
        /// </li>
        /// </ul>
        /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the
        /// default is <code>ORIGINAL_VALUE</code>.</p>
        pub fn set_value_selection_strategy(
            mut self,
            input: std::option::Option<crate::model::SlotValueSelectionStrategy>,
        ) -> Self {
            self.value_selection_strategy = input;
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the slot
        /// type is created. This is the same as calling the
        /// <code>CreateSlotTypeVersion</code> operation. If you do not specify
        /// <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn create_version(mut self, input: bool) -> Self {
            self.create_version = Some(input);
            self
        }
        /// <p>When set to <code>true</code> a new numbered version of the slot
        /// type is created. This is the same as calling the
        /// <code>CreateSlotTypeVersion</code> operation. If you do not specify
        /// <code>createVersion</code>, the default is <code>false</code>.</p>
        pub fn set_create_version(mut self, input: std::option::Option<bool>) -> Self {
            self.create_version = input;
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type. When you
        /// define a parent slot type, the new slot type has all of the same
        /// configuration as the parent.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn parent_slot_type_signature(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_slot_type_signature = Some(input.into());
            self
        }
        /// <p>The built-in slot type used as the parent of the slot type. When you
        /// define a parent slot type, the new slot type has all of the same
        /// configuration as the parent.</p>
        /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
        pub fn set_parent_slot_type_signature(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_slot_type_signature = input;
            self
        }
        /// Appends an item to `slot_type_configurations`.
        ///
        /// To override the contents of this collection use [`set_slot_type_configurations`](Self::set_slot_type_configurations).
        ///
        /// <p>Configuration information that extends the parent built-in slot type.
        /// The configuration is added to the settings for the parent slot
        /// type.</p>
        pub fn slot_type_configurations(
            mut self,
            input: impl Into<crate::model::SlotTypeConfiguration>,
        ) -> Self {
            let mut v = self.slot_type_configurations.unwrap_or_default();
            v.push(input.into());
            self.slot_type_configurations = Some(v);
            self
        }
        /// <p>Configuration information that extends the parent built-in slot type.
        /// The configuration is added to the settings for the parent slot
        /// type.</p>
        pub fn set_slot_type_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
        ) -> Self {
            self.slot_type_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`PutSlotTypeInput`](crate::input::PutSlotTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutSlotTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutSlotTypeInput {
                name: self.name,
                description: self.description,
                enumeration_values: self.enumeration_values,
                checksum: self.checksum,
                value_selection_strategy: self.value_selection_strategy,
                create_version: self.create_version,
                parent_slot_type_signature: self.parent_slot_type_signature,
                slot_type_configurations: self.slot_type_configurations,
            })
        }
    }
}
#[doc(hidden)]
pub type PutSlotTypeInputOperationOutputAlias = crate::operation::PutSlotType;
#[doc(hidden)]
pub type PutSlotTypeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutSlotTypeInput {
    /// Consumes the builder and constructs an Operation<[`PutSlotType`](crate::operation::PutSlotType)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutSlotType,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutSlotTypeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.name;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    })?;
            let name = aws_smithy_http::label::fmt_string(input_88, false);
            if name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "name",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/slottypes/{name}/versions/$LATEST", name = name)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutSlotTypeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutSlotTypeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_slot_type(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutSlotType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutSlotType",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutSlotTypeInput`](crate::input::PutSlotTypeInput)
    pub fn builder() -> crate::input::put_slot_type_input::Builder {
        crate::input::put_slot_type_input::Builder::default()
    }
}

/// See [`StartImportInput`](crate::input::StartImportInput)
pub mod start_import_input {
    /// A builder for [`StartImportInput`](crate::input::StartImportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) merge_strategy: std::option::Option<crate::model::MergeStrategy>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A zip archive in binary format. The archive should contain one file, a
        /// JSON file containing the resource to import. The resource should match the
        /// type specified in the <code>resourceType</code> field.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>A zip archive in binary format. The archive should contain one file, a
        /// JSON file containing the resource to import. The resource should match the
        /// type specified in the <code>resourceType</code> field.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// <p>Specifies the type of resource to export. Each resource also
        /// exports any resources that it depends on. </p>
        /// <ul>
        /// <li>
        /// <p>A bot exports dependent intents.</p>
        /// </li>
        /// <li>
        /// <p>An intent exports dependent slot types.</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>Specifies the type of resource to export. Each resource also
        /// exports any resources that it depends on. </p>
        /// <ul>
        /// <li>
        /// <p>A bot exports dependent intents.</p>
        /// </li>
        /// <li>
        /// <p>An intent exports dependent slot types.</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>Specifies the action that the <code>StartImport</code> operation
        /// should take when there is an existing resource with the same
        /// name.</p>
        /// <ul>
        /// <li>
        /// <p>FAIL_ON_CONFLICT - The import operation is stopped on the first
        /// conflict between a resource in the import file and an existing
        /// resource. The name of the resource causing the conflict is in the
        /// <code>failureReason</code> field of the response to the
        /// <code>GetImport</code> operation.</p>
        /// <p>OVERWRITE_LATEST - The import operation proceeds even if there
        /// is a conflict with an existing resource. The $LASTEST version of the
        /// existing resource is overwritten with the data from the import
        /// file.</p>
        /// </li>
        /// </ul>
        pub fn merge_strategy(mut self, input: crate::model::MergeStrategy) -> Self {
            self.merge_strategy = Some(input);
            self
        }
        /// <p>Specifies the action that the <code>StartImport</code> operation
        /// should take when there is an existing resource with the same
        /// name.</p>
        /// <ul>
        /// <li>
        /// <p>FAIL_ON_CONFLICT - The import operation is stopped on the first
        /// conflict between a resource in the import file and an existing
        /// resource. The name of the resource causing the conflict is in the
        /// <code>failureReason</code> field of the response to the
        /// <code>GetImport</code> operation.</p>
        /// <p>OVERWRITE_LATEST - The import operation proceeds even if there
        /// is a conflict with an existing resource. The $LASTEST version of the
        /// existing resource is overwritten with the data from the import
        /// file.</p>
        /// </li>
        /// </ul>
        pub fn set_merge_strategy(
            mut self,
            input: std::option::Option<crate::model::MergeStrategy>,
        ) -> Self {
            self.merge_strategy = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to add to the imported bot. You can only add tags when
        /// you import a bot, you can't add tags to an intent or slot type.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags to add to the imported bot. You can only add tags when
        /// you import a bot, you can't add tags to an intent or slot type.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImportInput`](crate::input::StartImportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartImportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartImportInput {
                payload: self.payload,
                resource_type: self.resource_type,
                merge_strategy: self.merge_strategy,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type StartImportInputOperationOutputAlias = crate::operation::StartImport;
#[doc(hidden)]
pub type StartImportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartImportInput {
    /// Consumes the builder and constructs an Operation<[`StartImport`](crate::operation::StartImport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartImport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartImportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/imports").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartImportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartImportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_start_import(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartImport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartImport",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartImportInput`](crate::input::StartImportInput)
    pub fn builder() -> crate::input::start_import_input::Builder {
        crate::input::start_import_input::Builder::default()
    }
}

/// See [`StartMigrationInput`](crate::input::StartMigrationInput)
pub mod start_migration_input {
    /// A builder for [`StartMigrationInput`](crate::input::StartMigrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) v1_bot_name: std::option::Option<std::string::String>,
        pub(crate) v1_bot_version: std::option::Option<std::string::String>,
        pub(crate) v2_bot_name: std::option::Option<std::string::String>,
        pub(crate) v2_bot_role: std::option::Option<std::string::String>,
        pub(crate) migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
    }
    impl Builder {
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn v1_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
        pub fn set_v1_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v1_bot_name = input;
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the
        /// <code>$LATEST</code> version as well as any numbered version.</p>
        pub fn v1_bot_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.v1_bot_version = Some(input.into());
            self
        }
        /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the
        /// <code>$LATEST</code> version as well as any numbered version.</p>
        pub fn set_v1_bot_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.v1_bot_version = input;
            self
        }
        /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
        /// <ul>
        /// <li>
        /// <p>If the Amazon Lex V2 bot doesn't exist, you must use the
        /// <code>CREATE_NEW</code> migration strategy.</p>
        /// </li>
        /// <li>
        /// <p>If the Amazon Lex V2 bot exists, you must use the
        /// <code>UPDATE_EXISTING</code> migration strategy to change the
        /// contents of the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn v2_bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
        /// <ul>
        /// <li>
        /// <p>If the Amazon Lex V2 bot doesn't exist, you must use the
        /// <code>CREATE_NEW</code> migration strategy.</p>
        /// </li>
        /// <li>
        /// <p>If the Amazon Lex V2 bot exists, you must use the
        /// <code>UPDATE_EXISTING</code> migration strategy to change the
        /// contents of the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn set_v2_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_name = input;
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn v2_bot_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.v2_bot_role = Some(input.into());
            self
        }
        /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
        pub fn set_v2_bot_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.v2_bot_role = input;
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
        /// the Amazon Lex V1 bot to the new bot.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
        /// metadata and the locale being migrated. It doesn't change any other
        /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
        /// is created in the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn migration_strategy(mut self, input: crate::model::MigrationStrategy) -> Self {
            self.migration_strategy = Some(input);
            self
        }
        /// <p>The strategy used to conduct the migration.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
        /// the Amazon Lex V1 bot to the new bot.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
        /// metadata and the locale being migrated. It doesn't change any other
        /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
        /// is created in the Amazon Lex V2 bot.</p>
        /// </li>
        /// </ul>
        pub fn set_migration_strategy(
            mut self,
            input: std::option::Option<crate::model::MigrationStrategy>,
        ) -> Self {
            self.migration_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMigrationInput`](crate::input::StartMigrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMigrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMigrationInput {
                v1_bot_name: self.v1_bot_name,
                v1_bot_version: self.v1_bot_version,
                v2_bot_name: self.v2_bot_name,
                v2_bot_role: self.v2_bot_role,
                migration_strategy: self.migration_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMigrationInputOperationOutputAlias = crate::operation::StartMigration;
#[doc(hidden)]
pub type StartMigrationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartMigrationInput {
    /// Consumes the builder and constructs an Operation<[`StartMigration`](crate::operation::StartMigration)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMigration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMigrationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/migrations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMigrationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMigrationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_migration(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMigration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMigration",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMigrationInput`](crate::input::StartMigrationInput)
    pub fn builder() -> crate::input::start_migration_input::Builder {
        crate::input::start_migration_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
        /// to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
        /// to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag keys to add to the resource. If a tag key already
        /// exists, the existing value is replaced with the new value.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag keys to add to the resource. If a tag key already
        /// exists, the existing value is replaced with the new value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_89 = &_input.resource_arn;
            let input_89 =
                input_89
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_89, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
        /// from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
        /// from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource. If a tag key does not
        /// exist on the resource, it is ignored.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the resource. If a tag key does not
        /// exist on the resource, it is ignored.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_90 = &_input.resource_arn;
            let input_90 =
                input_90
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_90, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_91) = &_input.tag_keys {
                for inner_92 in inner_91 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_92));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "lexmodelbuildingservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
    /// from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the resource. If a tag key does not
    /// exist on the resource, it is ignored.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to remove the tags
    /// from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to remove from the resource. If a tag key does not
    /// exist on the resource, it is ignored.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
    /// to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to add to the resource. If a tag key already
    /// exists, the existing value is replaced with the new value.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel
    /// to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to add to the resource. If a tag key already
    /// exists, the existing value is replaced with the new value.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMigrationInput {
    /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    pub v1_bot_name: std::option::Option<std::string::String>,
    /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the
    /// <code>$LATEST</code> version as well as any numbered version.</p>
    pub v1_bot_version: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
    /// <ul>
    /// <li>
    /// <p>If the Amazon Lex V2 bot doesn't exist, you must use the
    /// <code>CREATE_NEW</code> migration strategy.</p>
    /// </li>
    /// <li>
    /// <p>If the Amazon Lex V2 bot exists, you must use the
    /// <code>UPDATE_EXISTING</code> migration strategy to change the
    /// contents of the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub v2_bot_name: std::option::Option<std::string::String>,
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub v2_bot_role: std::option::Option<std::string::String>,
    /// <p>The strategy used to conduct the migration.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
    /// the Amazon Lex V1 bot to the new bot.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
    /// metadata and the locale being migrated. It doesn't change any other
    /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
    /// is created in the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub migration_strategy: std::option::Option<crate::model::MigrationStrategy>,
}
impl StartMigrationInput {
    /// <p>The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex V2.</p>
    pub fn v1_bot_name(&self) -> std::option::Option<&str> {
        self.v1_bot_name.as_deref()
    }
    /// <p>The version of the bot to migrate to Amazon Lex V2. You can migrate the
    /// <code>$LATEST</code> version as well as any numbered version.</p>
    pub fn v1_bot_version(&self) -> std::option::Option<&str> {
        self.v1_bot_version.as_deref()
    }
    /// <p>The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex V1 bot to. </p>
    /// <ul>
    /// <li>
    /// <p>If the Amazon Lex V2 bot doesn't exist, you must use the
    /// <code>CREATE_NEW</code> migration strategy.</p>
    /// </li>
    /// <li>
    /// <p>If the Amazon Lex V2 bot exists, you must use the
    /// <code>UPDATE_EXISTING</code> migration strategy to change the
    /// contents of the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub fn v2_bot_name(&self) -> std::option::Option<&str> {
        self.v2_bot_name.as_deref()
    }
    /// <p>The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.</p>
    pub fn v2_bot_role(&self) -> std::option::Option<&str> {
        self.v2_bot_role.as_deref()
    }
    /// <p>The strategy used to conduct the migration.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATE_NEW</code> - Creates a new Amazon Lex V2 bot and migrates
    /// the Amazon Lex V1 bot to the new bot.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATE_EXISTING</code> - Overwrites the existing Amazon Lex V2 bot
    /// metadata and the locale being migrated. It doesn't change any other
    /// locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new locale
    /// is created in the Amazon Lex V2 bot.</p>
    /// </li>
    /// </ul>
    pub fn migration_strategy(&self) -> std::option::Option<&crate::model::MigrationStrategy> {
        self.migration_strategy.as_ref()
    }
}
impl std::fmt::Debug for StartMigrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMigrationInput");
        formatter.field("v1_bot_name", &self.v1_bot_name);
        formatter.field("v1_bot_version", &self.v1_bot_version);
        formatter.field("v2_bot_name", &self.v2_bot_name);
        formatter.field("v2_bot_role", &self.v2_bot_role);
        formatter.field("migration_strategy", &self.migration_strategy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImportInput {
    /// <p>A zip archive in binary format. The archive should contain one file, a
    /// JSON file containing the resource to import. The resource should match the
    /// type specified in the <code>resourceType</code> field.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Specifies the type of resource to export. Each resource also
    /// exports any resources that it depends on. </p>
    /// <ul>
    /// <li>
    /// <p>A bot exports dependent intents.</p>
    /// </li>
    /// <li>
    /// <p>An intent exports dependent slot types.</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>Specifies the action that the <code>StartImport</code> operation
    /// should take when there is an existing resource with the same
    /// name.</p>
    /// <ul>
    /// <li>
    /// <p>FAIL_ON_CONFLICT - The import operation is stopped on the first
    /// conflict between a resource in the import file and an existing
    /// resource. The name of the resource causing the conflict is in the
    /// <code>failureReason</code> field of the response to the
    /// <code>GetImport</code> operation.</p>
    /// <p>OVERWRITE_LATEST - The import operation proceeds even if there
    /// is a conflict with an existing resource. The $LASTEST version of the
    /// existing resource is overwritten with the data from the import
    /// file.</p>
    /// </li>
    /// </ul>
    pub merge_strategy: std::option::Option<crate::model::MergeStrategy>,
    /// <p>A list of tags to add to the imported bot. You can only add tags when
    /// you import a bot, you can't add tags to an intent or slot type.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl StartImportInput {
    /// <p>A zip archive in binary format. The archive should contain one file, a
    /// JSON file containing the resource to import. The resource should match the
    /// type specified in the <code>resourceType</code> field.</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
    /// <p>Specifies the type of resource to export. Each resource also
    /// exports any resources that it depends on. </p>
    /// <ul>
    /// <li>
    /// <p>A bot exports dependent intents.</p>
    /// </li>
    /// <li>
    /// <p>An intent exports dependent slot types.</p>
    /// </li>
    /// </ul>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>Specifies the action that the <code>StartImport</code> operation
    /// should take when there is an existing resource with the same
    /// name.</p>
    /// <ul>
    /// <li>
    /// <p>FAIL_ON_CONFLICT - The import operation is stopped on the first
    /// conflict between a resource in the import file and an existing
    /// resource. The name of the resource causing the conflict is in the
    /// <code>failureReason</code> field of the response to the
    /// <code>GetImport</code> operation.</p>
    /// <p>OVERWRITE_LATEST - The import operation proceeds even if there
    /// is a conflict with an existing resource. The $LASTEST version of the
    /// existing resource is overwritten with the data from the import
    /// file.</p>
    /// </li>
    /// </ul>
    pub fn merge_strategy(&self) -> std::option::Option<&crate::model::MergeStrategy> {
        self.merge_strategy.as_ref()
    }
    /// <p>A list of tags to add to the imported bot. You can only add tags when
    /// you import a bot, you can't add tags to an intent or slot type.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for StartImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImportInput");
        formatter.field("payload", &self.payload);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("merge_strategy", &self.merge_strategy);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutSlotTypeInput {
    /// <p>The name of the slot type. The name is <i>not</i>
    /// case sensitive. </p>
    /// <p>The name can't match a built-in slot type name, or a built-in slot
    /// type name with "AMAZON." removed. For example, because there is a built-in
    /// slot type called <code>AMAZON.DATE</code>, you can't create a custom slot
    /// type called <code>DATE</code>.</p>
    /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the slot type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take. Each value can have a list of
    /// <code>synonyms</code>, which are additional values that help train the
    /// machine learning model about the values that it resolves for a slot. </p>
    /// <p>A regular expression slot type doesn't require enumeration values.
    /// All other slot types require a list of enumeration values.</p>
    /// <p>When Amazon Lex resolves a slot value, it generates a resolution list
    /// that contains up to five possible values for the slot. If you are using a
    /// Lambda function, this resolution list is passed to the function. If you
    /// are not using a Lambda function you can choose to return the value that
    /// the user entered or the first value in the resolution list as the slot
    /// value. The <code>valueSelectionStrategy</code> field indicates the option
    /// to use. </p>
    pub enumeration_values: std::option::Option<std::vec::Vec<crate::model::EnumerationValue>>,
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new slot type, leave the <code>checksum</code>
    /// field blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a slot type, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Determines the slot resolution strategy that Amazon Lex uses to return
    /// slot type values. The field can be set to one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ORIGINAL_VALUE</code> - Returns the value entered by the
    /// user, if the user value is similar to the slot value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOP_RESOLUTION</code> - If there is a resolution list for
    /// the slot, return the first value in the resolution list as the slot
    /// type value. If there is no resolution list, null is
    /// returned.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the
    /// default is <code>ORIGINAL_VALUE</code>.</p>
    pub value_selection_strategy: std::option::Option<crate::model::SlotValueSelectionStrategy>,
    /// <p>When set to <code>true</code> a new numbered version of the slot
    /// type is created. This is the same as calling the
    /// <code>CreateSlotTypeVersion</code> operation. If you do not specify
    /// <code>createVersion</code>, the default is <code>false</code>.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>The built-in slot type used as the parent of the slot type. When you
    /// define a parent slot type, the new slot type has all of the same
    /// configuration as the parent.</p>
    /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    pub parent_slot_type_signature: std::option::Option<std::string::String>,
    /// <p>Configuration information that extends the parent built-in slot type.
    /// The configuration is added to the settings for the parent slot
    /// type.</p>
    pub slot_type_configurations:
        std::option::Option<std::vec::Vec<crate::model::SlotTypeConfiguration>>,
}
impl PutSlotTypeInput {
    /// <p>The name of the slot type. The name is <i>not</i>
    /// case sensitive. </p>
    /// <p>The name can't match a built-in slot type name, or a built-in slot
    /// type name with "AMAZON." removed. For example, because there is a built-in
    /// slot type called <code>AMAZON.DATE</code>, you can't create a custom slot
    /// type called <code>DATE</code>.</p>
    /// <p>For a list of built-in slot types, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference">Slot Type Reference</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the slot type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of <code>EnumerationValue</code> objects that defines the
    /// values that the slot type can take. Each value can have a list of
    /// <code>synonyms</code>, which are additional values that help train the
    /// machine learning model about the values that it resolves for a slot. </p>
    /// <p>A regular expression slot type doesn't require enumeration values.
    /// All other slot types require a list of enumeration values.</p>
    /// <p>When Amazon Lex resolves a slot value, it generates a resolution list
    /// that contains up to five possible values for the slot. If you are using a
    /// Lambda function, this resolution list is passed to the function. If you
    /// are not using a Lambda function you can choose to return the value that
    /// the user entered or the first value in the resolution list as the slot
    /// value. The <code>valueSelectionStrategy</code> field indicates the option
    /// to use. </p>
    pub fn enumeration_values(&self) -> std::option::Option<&[crate::model::EnumerationValue]> {
        self.enumeration_values.as_deref()
    }
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new slot type, leave the <code>checksum</code>
    /// field blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a slot type, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Determines the slot resolution strategy that Amazon Lex uses to return
    /// slot type values. The field can be set to one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ORIGINAL_VALUE</code> - Returns the value entered by the
    /// user, if the user value is similar to the slot value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TOP_RESOLUTION</code> - If there is a resolution list for
    /// the slot, return the first value in the resolution list as the slot
    /// type value. If there is no resolution list, null is
    /// returned.</p>
    /// </li>
    /// </ul>
    /// <p>If you don't specify the <code>valueSelectionStrategy</code>, the
    /// default is <code>ORIGINAL_VALUE</code>.</p>
    pub fn value_selection_strategy(
        &self,
    ) -> std::option::Option<&crate::model::SlotValueSelectionStrategy> {
        self.value_selection_strategy.as_ref()
    }
    /// <p>When set to <code>true</code> a new numbered version of the slot
    /// type is created. This is the same as calling the
    /// <code>CreateSlotTypeVersion</code> operation. If you do not specify
    /// <code>createVersion</code>, the default is <code>false</code>.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>The built-in slot type used as the parent of the slot type. When you
    /// define a parent slot type, the new slot type has all of the same
    /// configuration as the parent.</p>
    /// <p>Only <code>AMAZON.AlphaNumeric</code> is supported.</p>
    pub fn parent_slot_type_signature(&self) -> std::option::Option<&str> {
        self.parent_slot_type_signature.as_deref()
    }
    /// <p>Configuration information that extends the parent built-in slot type.
    /// The configuration is added to the settings for the parent slot
    /// type.</p>
    pub fn slot_type_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SlotTypeConfiguration]> {
        self.slot_type_configurations.as_deref()
    }
}
impl std::fmt::Debug for PutSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutSlotTypeInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("enumeration_values", &self.enumeration_values);
        formatter.field("checksum", &self.checksum);
        formatter.field("value_selection_strategy", &self.value_selection_strategy);
        formatter.field("create_version", &self.create_version);
        formatter.field(
            "parent_slot_type_signature",
            &self.parent_slot_type_signature,
        );
        formatter.field("slot_type_configurations", &self.slot_type_configurations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntentInput {
    /// <p>The name of the intent. The name is <i>not</i> case
    /// sensitive. </p>
    /// <p>The name can't match a built-in intent name, or a built-in intent
    /// name with "AMAZON." removed. For example, because there is a built-in
    /// intent called <code>AMAZON.HelpIntent</code>, you can't create a custom
    /// intent called <code>HelpIntent</code>.</p>
    /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the intent.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot
    /// values from the user using prompts defined in the slots. For more
    /// information, see <a>how-it-works</a>. </p>
    pub slots: std::option::Option<std::vec::Vec<crate::model::Slot>>,
    /// <p>An array of utterances (strings) that a user might say to signal
    /// the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity}
    /// {PizzaSize} pizzas". </p>
    ///
    /// <p>In each utterance, a slot name is enclosed in curly braces.
    /// </p>
    pub sample_utterances: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Prompts the user to confirm the intent. This question should have a
    /// yes or no answer.</p>
    /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that
    /// the intent is ready for fulfillment. For example, with the
    /// <code>OrderPizza</code> intent, you might want to confirm that the order
    /// is correct before placing it. For other intents, such as intents that
    /// simply respond to user questions, you might not need to ask the user for
    /// confirmation before providing the information. </p>
    /// <note>
    /// <p>You you must provide both the <code>rejectionStatement</code> and
    /// the <code>confirmationPrompt</code>, or neither.</p>
    /// </note>
    pub confirmation_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>When the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    /// <note>
    /// <p>You must provide both the <code>rejectionStatement</code> and the
    /// <code>confirmationPrompt</code>, or neither.</p>
    /// </note>
    pub rejection_statement: std::option::Option<crate::model::Statement>,
    /// <p>Amazon Lex uses this prompt to solicit additional activity after
    /// fulfilling an intent. For example, after the <code>OrderPizza</code>
    /// intent is fulfilled, you might prompt the user to order a drink.</p>
    /// <p>The action that Amazon Lex takes depends on the user's response, as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>If the user says "Yes" it responds with the clarification
    /// prompt that is configured for the bot.</p>
    /// </li>
    /// <li>
    /// <p>if the user says "Yes" and continues with an utterance that
    /// triggers an intent it starts a conversation for the intent.</p>
    /// </li>
    /// <li>
    /// <p>If the user says "No" it responds with the rejection statement
    /// configured for the the follow-up prompt.</p>
    /// </li>
    /// <li>
    /// <p>If it doesn't recognize the utterance it repeats the follow-up
    /// prompt again.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>The <code>followUpPrompt</code> field and the
    /// <code>conclusionStatement</code> field are mutually exclusive. You can
    /// specify only one. </p>
    pub follow_up_prompt: std::option::Option<crate::model::FollowUpPrompt>,
    /// <p> The statement that you want Amazon Lex to convey to the user after the
    /// intent is successfully fulfilled by the Lambda function. </p>
    /// <p>This element is relevant only if you provide a Lambda function in
    /// the <code>fulfillmentActivity</code>. If you return the intent to the
    /// client application, you can't specify this element.</p>
    /// <note>
    /// <p>The <code>followUpPrompt</code> and
    /// <code>conclusionStatement</code> are mutually exclusive. You can
    /// specify only one.</p>
    /// </note>
    pub conclusion_statement: std::option::Option<crate::model::Statement>,
    /// <p> Specifies a Lambda function to invoke for each user input. You can
    /// invoke this Lambda function to personalize user interaction. </p>
    /// <p>For example, suppose your bot determines that the user is John.
    /// Your Lambda function might retrieve John's information from a backend
    /// database and prepopulate some of the values. For example, if you find that
    /// John is gluten intolerant, you might set the corresponding intent slot,
    /// <code>GlutenIntolerant</code>, to true. You might find John's phone
    /// number and set the corresponding session attribute. </p>
    pub dialog_code_hook: std::option::Option<crate::model::CodeHook>,
    /// <p>Required. Describes how the intent is fulfilled. For example, after
    /// a user provides all of the information for a pizza order,
    /// <code>fulfillmentActivity</code> defines how the bot places an order
    /// with a local pizza store. </p>
    /// <p> You might configure Amazon Lex to return all of the intent information
    /// to the client application, or direct it to invoke a Lambda function that
    /// can process the intent (for example, place an order with a pizzeria).
    /// </p>
    pub fulfillment_activity: std::option::Option<crate::model::FulfillmentActivity>,
    /// <p>A unique identifier for the built-in intent to base this intent on.
    /// To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub parent_intent_signature: std::option::Option<std::string::String>,
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new intent, leave the <code>checksum</code> field
    /// blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a intent, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>When set to <code>true</code> a new numbered version of the intent
    /// is created. This is the same as calling the
    /// <code>CreateIntentVersion</code> operation. If you do not specify
    /// <code>createVersion</code>, the default is <code>false</code>.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>Configuration information required to use the
    /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon
    /// Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
    /// AMAZON.KendraSearchIntent</a>.</p>
    pub kendra_configuration: std::option::Option<crate::model::KendraConfiguration>,
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub input_contexts: std::option::Option<std::vec::Vec<crate::model::InputContext>>,
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub output_contexts: std::option::Option<std::vec::Vec<crate::model::OutputContext>>,
}
impl PutIntentInput {
    /// <p>The name of the intent. The name is <i>not</i> case
    /// sensitive. </p>
    /// <p>The name can't match a built-in intent name, or a built-in intent
    /// name with "AMAZON." removed. For example, because there is a built-in
    /// intent called <code>AMAZON.HelpIntent</code>, you can't create a custom
    /// intent called <code>HelpIntent</code>.</p>
    /// <p>For a list of built-in intents, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the intent.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of intent slots. At runtime, Amazon Lex elicits required slot
    /// values from the user using prompts defined in the slots. For more
    /// information, see <a>how-it-works</a>. </p>
    pub fn slots(&self) -> std::option::Option<&[crate::model::Slot]> {
        self.slots.as_deref()
    }
    /// <p>An array of utterances (strings) that a user might say to signal
    /// the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity}
    /// {PizzaSize} pizzas". </p>
    ///
    /// <p>In each utterance, a slot name is enclosed in curly braces.
    /// </p>
    pub fn sample_utterances(&self) -> std::option::Option<&[std::string::String]> {
        self.sample_utterances.as_deref()
    }
    /// <p>Prompts the user to confirm the intent. This question should have a
    /// yes or no answer.</p>
    /// <p>Amazon Lex uses this prompt to ensure that the user acknowledges that
    /// the intent is ready for fulfillment. For example, with the
    /// <code>OrderPizza</code> intent, you might want to confirm that the order
    /// is correct before placing it. For other intents, such as intents that
    /// simply respond to user questions, you might not need to ask the user for
    /// confirmation before providing the information. </p>
    /// <note>
    /// <p>You you must provide both the <code>rejectionStatement</code> and
    /// the <code>confirmationPrompt</code>, or neither.</p>
    /// </note>
    pub fn confirmation_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.confirmation_prompt.as_ref()
    }
    /// <p>When the user answers "no" to the question defined in
    /// <code>confirmationPrompt</code>, Amazon Lex responds with this statement to
    /// acknowledge that the intent was canceled. </p>
    /// <note>
    /// <p>You must provide both the <code>rejectionStatement</code> and the
    /// <code>confirmationPrompt</code>, or neither.</p>
    /// </note>
    pub fn rejection_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.rejection_statement.as_ref()
    }
    /// <p>Amazon Lex uses this prompt to solicit additional activity after
    /// fulfilling an intent. For example, after the <code>OrderPizza</code>
    /// intent is fulfilled, you might prompt the user to order a drink.</p>
    /// <p>The action that Amazon Lex takes depends on the user's response, as
    /// follows:</p>
    /// <ul>
    /// <li>
    /// <p>If the user says "Yes" it responds with the clarification
    /// prompt that is configured for the bot.</p>
    /// </li>
    /// <li>
    /// <p>if the user says "Yes" and continues with an utterance that
    /// triggers an intent it starts a conversation for the intent.</p>
    /// </li>
    /// <li>
    /// <p>If the user says "No" it responds with the rejection statement
    /// configured for the the follow-up prompt.</p>
    /// </li>
    /// <li>
    /// <p>If it doesn't recognize the utterance it repeats the follow-up
    /// prompt again.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>The <code>followUpPrompt</code> field and the
    /// <code>conclusionStatement</code> field are mutually exclusive. You can
    /// specify only one. </p>
    pub fn follow_up_prompt(&self) -> std::option::Option<&crate::model::FollowUpPrompt> {
        self.follow_up_prompt.as_ref()
    }
    /// <p> The statement that you want Amazon Lex to convey to the user after the
    /// intent is successfully fulfilled by the Lambda function. </p>
    /// <p>This element is relevant only if you provide a Lambda function in
    /// the <code>fulfillmentActivity</code>. If you return the intent to the
    /// client application, you can't specify this element.</p>
    /// <note>
    /// <p>The <code>followUpPrompt</code> and
    /// <code>conclusionStatement</code> are mutually exclusive. You can
    /// specify only one.</p>
    /// </note>
    pub fn conclusion_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.conclusion_statement.as_ref()
    }
    /// <p> Specifies a Lambda function to invoke for each user input. You can
    /// invoke this Lambda function to personalize user interaction. </p>
    /// <p>For example, suppose your bot determines that the user is John.
    /// Your Lambda function might retrieve John's information from a backend
    /// database and prepopulate some of the values. For example, if you find that
    /// John is gluten intolerant, you might set the corresponding intent slot,
    /// <code>GlutenIntolerant</code>, to true. You might find John's phone
    /// number and set the corresponding session attribute. </p>
    pub fn dialog_code_hook(&self) -> std::option::Option<&crate::model::CodeHook> {
        self.dialog_code_hook.as_ref()
    }
    /// <p>Required. Describes how the intent is fulfilled. For example, after
    /// a user provides all of the information for a pizza order,
    /// <code>fulfillmentActivity</code> defines how the bot places an order
    /// with a local pizza store. </p>
    /// <p> You might configure Amazon Lex to return all of the intent information
    /// to the client application, or direct it to invoke a Lambda function that
    /// can process the intent (for example, place an order with a pizzeria).
    /// </p>
    pub fn fulfillment_activity(&self) -> std::option::Option<&crate::model::FulfillmentActivity> {
        self.fulfillment_activity.as_ref()
    }
    /// <p>A unique identifier for the built-in intent to base this intent on.
    /// To find the signature for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn parent_intent_signature(&self) -> std::option::Option<&str> {
        self.parent_intent_signature.as_deref()
    }
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new intent, leave the <code>checksum</code> field
    /// blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a intent, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>When set to <code>true</code> a new numbered version of the intent
    /// is created. This is the same as calling the
    /// <code>CreateIntentVersion</code> operation. If you do not specify
    /// <code>createVersion</code>, the default is <code>false</code>.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>Configuration information required to use the
    /// <code>AMAZON.KendraSearchIntent</code> intent to connect to an Amazon
    /// Kendra index. For more information, see <a href="http://docs.aws.amazon.com/lex/latest/dg/built-in-intent-kendra-search.html">
    /// AMAZON.KendraSearchIntent</a>.</p>
    pub fn kendra_configuration(&self) -> std::option::Option<&crate::model::KendraConfiguration> {
        self.kendra_configuration.as_ref()
    }
    /// <p>An array of <code>InputContext</code> objects that lists the contexts
    /// that must be active for Amazon Lex to choose the intent in a conversation with
    /// the user.</p>
    pub fn input_contexts(&self) -> std::option::Option<&[crate::model::InputContext]> {
        self.input_contexts.as_deref()
    }
    /// <p>An array of <code>OutputContext</code> objects that lists the contexts
    /// that the intent activates when the intent is fulfilled.</p>
    pub fn output_contexts(&self) -> std::option::Option<&[crate::model::OutputContext]> {
        self.output_contexts.as_deref()
    }
}
impl std::fmt::Debug for PutIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntentInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("slots", &self.slots);
        formatter.field("sample_utterances", &self.sample_utterances);
        formatter.field("confirmation_prompt", &self.confirmation_prompt);
        formatter.field("rejection_statement", &self.rejection_statement);
        formatter.field("follow_up_prompt", &self.follow_up_prompt);
        formatter.field("conclusion_statement", &self.conclusion_statement);
        formatter.field("dialog_code_hook", &self.dialog_code_hook);
        formatter.field("fulfillment_activity", &self.fulfillment_activity);
        formatter.field("parent_intent_signature", &self.parent_intent_signature);
        formatter.field("checksum", &self.checksum);
        formatter.field("create_version", &self.create_version);
        formatter.field("kendra_configuration", &self.kendra_configuration);
        formatter.field("input_contexts", &self.input_contexts);
        formatter.field("output_contexts", &self.output_contexts);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBotAliasInput {
    /// <p>The name of the alias. The name is <i>not</i> case
    /// sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The version of the bot.</p>
    pub bot_version: std::option::Option<std::string::String>,
    /// <p>The name of the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new bot alias, leave the <code>checksum</code>
    /// field blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a bot alias, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>Settings for conversation logs for the alias.</p>
    pub conversation_logs: std::option::Option<crate::model::ConversationLogsRequest>,
    /// <p>A list of tags to add to the bot alias. You can only add tags when you
    /// create an alias, you can't use the <code>PutBotAlias</code> operation to
    /// update the tags on a bot alias. To update tags, use the
    /// <code>TagResource</code> operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutBotAliasInput {
    /// <p>The name of the alias. The name is <i>not</i> case
    /// sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The version of the bot.</p>
    pub fn bot_version(&self) -> std::option::Option<&str> {
        self.bot_version.as_deref()
    }
    /// <p>The name of the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new bot alias, leave the <code>checksum</code>
    /// field blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a bot alias, set the <code>checksum</code>
    /// field to the checksum of the most recent revision of the
    /// <code>$LATEST</code> version. If you don't specify the <code>
    /// checksum</code> field, or if the checksum does not match the
    /// <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>Settings for conversation logs for the alias.</p>
    pub fn conversation_logs(&self) -> std::option::Option<&crate::model::ConversationLogsRequest> {
        self.conversation_logs.as_ref()
    }
    /// <p>A list of tags to add to the bot alias. You can only add tags when you
    /// create an alias, you can't use the <code>PutBotAlias</code> operation to
    /// update the tags on a bot alias. To update tags, use the
    /// <code>TagResource</code> operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBotAliasInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("bot_version", &self.bot_version);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("checksum", &self.checksum);
        formatter.field("conversation_logs", &self.conversation_logs);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutBotInput {
    /// <p>The name of the bot. The name is <i>not</i> case
    /// sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the bot.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array of <code>Intent</code> objects. Each intent represents a
    /// command that a user can express. For example, a pizza ordering bot might
    /// support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>
    pub intents: std::option::Option<std::vec::Vec<crate::model::Intent>>,
    /// <p>Set to <code>true</code> to enable access to natural language
    /// understanding improvements. </p>
    /// <p>When you set the <code>enableModelImprovements</code> parameter to
    /// <code>true</code> you can use the
    /// <code>nluIntentConfidenceThreshold</code> parameter to configure
    /// confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
    /// <p>You can only set the <code>enableModelImprovements</code> parameter in
    /// certain Regions. If you set the parameter to <code>true</code>, your bot
    /// has access to accuracy improvements.</p>
    /// <p>The Regions where you can set the <code>enableModelImprovements</code>
    /// parameter to <code>true</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia) (us-east-1)</p>
    /// </li>
    /// <li>
    /// <p>US West (Oregon) (us-west-2)</p>
    /// </li>
    /// <li>
    /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
    /// </li>
    /// <li>
    /// <p>EU (Ireland) (eu-west-1)</p>
    /// </li>
    /// </ul>
    /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
    /// is set to <code>true</code> by default. In these Regions setting the
    /// parameter to <code>false</code> throws a <code>ValidationException</code>
    /// exception.</p>
    pub enable_model_improvements: std::option::Option<bool>,
    /// <p>Determines the threshold where Amazon Lex will insert the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> and
    /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
    /// configured for the bot.</p>
    /// <p>You must set the <code>enableModelImprovements</code> parameter to
    /// <code>true</code> to use confidence scores in the following
    /// regions.</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia) (us-east-1)</p>
    /// </li>
    /// <li>
    /// <p>US West (Oregon) (us-west-2)</p>
    /// </li>
    /// <li>
    /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
    /// </li>
    /// <li>
    /// <p>EU (Ireland) (eu-west-1)</p>
    /// </li>
    /// </ul>
    /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
    /// is set to <code>true</code> by default.</p>
    /// <p>For example, suppose a bot is configured with the confidence threshold
    /// of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three
    /// alternative intents with the following confidence scores: IntentA (0.70),
    /// IntentB (0.60), IntentC (0.50). The response from the
    /// <code>PostText</code> operation would be:</p>
    /// <ul>
    /// <li>
    /// <p>AMAZON.FallbackIntent</p>
    /// </li>
    /// <li>
    /// <p>IntentA</p>
    /// </li>
    /// <li>
    /// <p>IntentB</p>
    /// </li>
    /// <li>
    /// <p>IntentC</p>
    /// </li>
    /// </ul>
    pub nlu_intent_confidence_threshold: std::option::Option<f64>,
    /// <p>When Amazon Lex doesn't understand the user's intent, it uses this
    /// message to get clarification. To specify how many times Amazon Lex should
    /// repeat the clarification prompt, use the <code>maxAttempts</code> field.
    /// If Amazon Lex still doesn't understand, it sends the message in the
    /// <code>abortStatement</code> field. </p>
    /// <p>When you create a clarification prompt, make sure that it suggests
    /// the correct response from the user. for example, for a bot that orders
    /// pizza and drinks, you might create this clarification prompt: "What would
    /// you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
    /// <p>If you have defined a fallback intent, it will be invoked if the
    /// clarification prompt is repeated the number of times defined in the
    /// <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
    /// AMAZON.FallbackIntent</a>.</p>
    /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will
    /// return a 400 Bad Request exception in three cases: </p>
    /// <ul>
    /// <li>
    /// <p>Follow-up prompt - When the user responds to a follow-up prompt
    /// but does not provide an intent. For example, in response to a
    /// follow-up prompt that says "Would you like anything else today?" the
    /// user says "Yes." Amazon Lex will return a 400 Bad Request exception because
    /// it does not have a clarification prompt to send to the user to get an
    /// intent.</p>
    /// </li>
    /// <li>
    /// <p>Lambda function - When using a Lambda function, you return an
    /// <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a
    /// clarification prompt to get an intent from the user, it returns a 400
    /// Bad Request exception.</p>
    /// </li>
    /// <li>
    /// <p>PutSession operation - When using the <code>PutSession</code>
    /// operation, you send an <code>ElicitIntent</code> dialog type. Since
    /// Amazon Lex does not have a clarification prompt to get an intent from the
    /// user, it returns a 400 Bad Request exception.</p>
    /// </li>
    /// </ul>
    pub clarification_prompt: std::option::Option<crate::model::Prompt>,
    /// <p>When Amazon Lex can't understand the user's input in context, it tries
    /// to elicit the information a few times. After that, Amazon Lex sends the message
    /// defined in <code>abortStatement</code> to the user, and then cancels the
    /// conversation. To set the number of retries, use the
    /// <code>valueElicitationPrompt</code> field for the slot type. </p>
    /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What
    /// type of crust would you like?" If the user's response is not one of the
    /// expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex
    /// tries to elicit a correct response a few more times. </p>
    /// <p>For example, in a pizza ordering application,
    /// <code>OrderPizza</code> might be one of the intents. This intent might
    /// require the <code>CrustType</code> slot. You specify the
    /// <code>valueElicitationPrompt</code> field when you create the
    /// <code>CrustType</code> slot.</p>
    /// <p>If you have defined a fallback intent the cancel statement will not be
    /// sent to the user, the fallback intent is used instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
    /// AMAZON.FallbackIntent</a>.</p>
    pub abort_statement: std::option::Option<crate::model::Statement>,
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation.</p>
    /// <p>A user interaction session remains active for the amount of time
    /// specified. If no conversation occurs during this time, the session expires
    /// and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>For example, suppose that a user chooses the OrderPizza intent, but
    /// gets sidetracked halfway through placing an order. If the user doesn't
    /// complete the order within the specified time, Amazon Lex discards the slot
    /// information that it gathered, and the user must start over.</p>
    /// <p>If you don't include the <code>idleSessionTTLInSeconds</code>
    /// element in a <code>PutBot</code> operation request, Amazon Lex uses the default
    /// value. This is also true if the request replaces an existing
    /// bot.</p>
    /// <p>The default is 300 seconds (5 minutes).</p>
    pub idle_session_ttl_in_seconds: std::option::Option<i32>,
    /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice
    /// interactions with the user. The locale configured for the voice must match
    /// the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices
    /// in Amazon Polly</a> in the <i>Amazon Polly Developer
    /// Guide</i>.</p>
    pub voice_id: std::option::Option<std::string::String>,
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new bot, leave the <code>checksum</code> field
    /// blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a bot, set the <code>checksum</code> field
    /// to the checksum of the most recent revision of the <code>$LATEST</code>
    /// version. If you don't specify the <code> checksum</code> field, or if the
    /// checksum does not match the <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub checksum: std::option::Option<std::string::String>,
    /// <p>If you set the <code>processBehavior</code> element to
    /// <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you
    /// set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
    /// build it. </p>
    /// <p>If you don't specify this value, the default value is
    /// <code>BUILD</code>.</p>
    pub process_behavior: std::option::Option<crate::model::ProcessBehavior>,
    /// <p> Specifies the target locale for the bot. Any intent used in the
    /// bot must be compatible with the locale of the bot. </p>
    ///
    /// <p>The default is <code>en-US</code>.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub child_directed: std::option::Option<bool>,
    /// <p>When set to <code>true</code> user utterances are sent to Amazon
    /// Comprehend for sentiment analysis. If you don't specify
    /// <code>detectSentiment</code>, the default is <code>false</code>.</p>
    pub detect_sentiment: std::option::Option<bool>,
    /// <p>When set to <code>true</code> a new numbered version of the bot is
    /// created. This is the same as calling the <code>CreateBotVersion</code>
    /// operation. If you don't specify <code>createVersion</code>, the default is
    /// <code>false</code>.</p>
    pub create_version: std::option::Option<bool>,
    /// <p>A list of tags to add to the bot. You can only add tags when you
    /// create a bot, you can't use the <code>PutBot</code> operation to update
    /// the tags on a bot. To update tags, use the <code>TagResource</code>
    /// operation.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl PutBotInput {
    /// <p>The name of the bot. The name is <i>not</i> case
    /// sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the bot.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array of <code>Intent</code> objects. Each intent represents a
    /// command that a user can express. For example, a pizza ordering bot might
    /// support an OrderPizza intent. For more information, see <a>how-it-works</a>.</p>
    pub fn intents(&self) -> std::option::Option<&[crate::model::Intent]> {
        self.intents.as_deref()
    }
    /// <p>Set to <code>true</code> to enable access to natural language
    /// understanding improvements. </p>
    /// <p>When you set the <code>enableModelImprovements</code> parameter to
    /// <code>true</code> you can use the
    /// <code>nluIntentConfidenceThreshold</code> parameter to configure
    /// confidence scores. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html">Confidence Scores</a>.</p>
    /// <p>You can only set the <code>enableModelImprovements</code> parameter in
    /// certain Regions. If you set the parameter to <code>true</code>, your bot
    /// has access to accuracy improvements.</p>
    /// <p>The Regions where you can set the <code>enableModelImprovements</code>
    /// parameter to <code>true</code> are:</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia) (us-east-1)</p>
    /// </li>
    /// <li>
    /// <p>US West (Oregon) (us-west-2)</p>
    /// </li>
    /// <li>
    /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
    /// </li>
    /// <li>
    /// <p>EU (Ireland) (eu-west-1)</p>
    /// </li>
    /// </ul>
    /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
    /// is set to <code>true</code> by default. In these Regions setting the
    /// parameter to <code>false</code> throws a <code>ValidationException</code>
    /// exception.</p>
    pub fn enable_model_improvements(&self) -> std::option::Option<bool> {
        self.enable_model_improvements
    }
    /// <p>Determines the threshold where Amazon Lex will insert the
    /// <code>AMAZON.FallbackIntent</code>,
    /// <code>AMAZON.KendraSearchIntent</code>, or both when returning
    /// alternative intents in a <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or
    /// <a href="https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> response.
    /// <code>AMAZON.FallbackIntent</code> and
    /// <code>AMAZON.KendraSearchIntent</code> are only inserted if they are
    /// configured for the bot.</p>
    /// <p>You must set the <code>enableModelImprovements</code> parameter to
    /// <code>true</code> to use confidence scores in the following
    /// regions.</p>
    /// <ul>
    /// <li>
    /// <p>US East (N. Virginia) (us-east-1)</p>
    /// </li>
    /// <li>
    /// <p>US West (Oregon) (us-west-2)</p>
    /// </li>
    /// <li>
    /// <p>Asia Pacific (Sydney) (ap-southeast-2)</p>
    /// </li>
    /// <li>
    /// <p>EU (Ireland) (eu-west-1)</p>
    /// </li>
    /// </ul>
    /// <p>In other Regions, the <code>enableModelImprovements</code> parameter
    /// is set to <code>true</code> by default.</p>
    /// <p>For example, suppose a bot is configured with the confidence threshold
    /// of 0.80 and the <code>AMAZON.FallbackIntent</code>. Amazon Lex returns three
    /// alternative intents with the following confidence scores: IntentA (0.70),
    /// IntentB (0.60), IntentC (0.50). The response from the
    /// <code>PostText</code> operation would be:</p>
    /// <ul>
    /// <li>
    /// <p>AMAZON.FallbackIntent</p>
    /// </li>
    /// <li>
    /// <p>IntentA</p>
    /// </li>
    /// <li>
    /// <p>IntentB</p>
    /// </li>
    /// <li>
    /// <p>IntentC</p>
    /// </li>
    /// </ul>
    pub fn nlu_intent_confidence_threshold(&self) -> std::option::Option<f64> {
        self.nlu_intent_confidence_threshold
    }
    /// <p>When Amazon Lex doesn't understand the user's intent, it uses this
    /// message to get clarification. To specify how many times Amazon Lex should
    /// repeat the clarification prompt, use the <code>maxAttempts</code> field.
    /// If Amazon Lex still doesn't understand, it sends the message in the
    /// <code>abortStatement</code> field. </p>
    /// <p>When you create a clarification prompt, make sure that it suggests
    /// the correct response from the user. for example, for a bot that orders
    /// pizza and drinks, you might create this clarification prompt: "What would
    /// you like to do? You can say 'Order a pizza' or 'Order a drink.'"</p>
    /// <p>If you have defined a fallback intent, it will be invoked if the
    /// clarification prompt is repeated the number of times defined in the
    /// <code>maxAttempts</code> field. For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
    /// AMAZON.FallbackIntent</a>.</p>
    /// <p>If you don't define a clarification prompt, at runtime Amazon Lex will
    /// return a 400 Bad Request exception in three cases: </p>
    /// <ul>
    /// <li>
    /// <p>Follow-up prompt - When the user responds to a follow-up prompt
    /// but does not provide an intent. For example, in response to a
    /// follow-up prompt that says "Would you like anything else today?" the
    /// user says "Yes." Amazon Lex will return a 400 Bad Request exception because
    /// it does not have a clarification prompt to send to the user to get an
    /// intent.</p>
    /// </li>
    /// <li>
    /// <p>Lambda function - When using a Lambda function, you return an
    /// <code>ElicitIntent</code> dialog type. Since Amazon Lex does not have a
    /// clarification prompt to get an intent from the user, it returns a 400
    /// Bad Request exception.</p>
    /// </li>
    /// <li>
    /// <p>PutSession operation - When using the <code>PutSession</code>
    /// operation, you send an <code>ElicitIntent</code> dialog type. Since
    /// Amazon Lex does not have a clarification prompt to get an intent from the
    /// user, it returns a 400 Bad Request exception.</p>
    /// </li>
    /// </ul>
    pub fn clarification_prompt(&self) -> std::option::Option<&crate::model::Prompt> {
        self.clarification_prompt.as_ref()
    }
    /// <p>When Amazon Lex can't understand the user's input in context, it tries
    /// to elicit the information a few times. After that, Amazon Lex sends the message
    /// defined in <code>abortStatement</code> to the user, and then cancels the
    /// conversation. To set the number of retries, use the
    /// <code>valueElicitationPrompt</code> field for the slot type. </p>
    /// <p>For example, in a pizza ordering bot, Amazon Lex might ask a user "What
    /// type of crust would you like?" If the user's response is not one of the
    /// expected responses (for example, "thin crust, "deep dish," etc.), Amazon Lex
    /// tries to elicit a correct response a few more times. </p>
    /// <p>For example, in a pizza ordering application,
    /// <code>OrderPizza</code> might be one of the intents. This intent might
    /// require the <code>CrustType</code> slot. You specify the
    /// <code>valueElicitationPrompt</code> field when you create the
    /// <code>CrustType</code> slot.</p>
    /// <p>If you have defined a fallback intent the cancel statement will not be
    /// sent to the user, the fallback intent is used instead. For more
    /// information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html">
    /// AMAZON.FallbackIntent</a>.</p>
    pub fn abort_statement(&self) -> std::option::Option<&crate::model::Statement> {
        self.abort_statement.as_ref()
    }
    /// <p>The maximum time in seconds that Amazon Lex retains the data gathered in
    /// a conversation.</p>
    /// <p>A user interaction session remains active for the amount of time
    /// specified. If no conversation occurs during this time, the session expires
    /// and Amazon Lex deletes any data provided before the timeout.</p>
    /// <p>For example, suppose that a user chooses the OrderPizza intent, but
    /// gets sidetracked halfway through placing an order. If the user doesn't
    /// complete the order within the specified time, Amazon Lex discards the slot
    /// information that it gathered, and the user must start over.</p>
    /// <p>If you don't include the <code>idleSessionTTLInSeconds</code>
    /// element in a <code>PutBot</code> operation request, Amazon Lex uses the default
    /// value. This is also true if the request replaces an existing
    /// bot.</p>
    /// <p>The default is 300 seconds (5 minutes).</p>
    pub fn idle_session_ttl_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_session_ttl_in_seconds
    }
    /// <p>The Amazon Polly voice ID that you want Amazon Lex to use for voice
    /// interactions with the user. The locale configured for the voice must match
    /// the locale of the bot. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Voices
    /// in Amazon Polly</a> in the <i>Amazon Polly Developer
    /// Guide</i>.</p>
    pub fn voice_id(&self) -> std::option::Option<&str> {
        self.voice_id.as_deref()
    }
    /// <p>Identifies a specific revision of the <code>$LATEST</code>
    /// version.</p>
    /// <p>When you create a new bot, leave the <code>checksum</code> field
    /// blank. If you specify a checksum you get a
    /// <code>BadRequestException</code> exception.</p>
    /// <p>When you want to update a bot, set the <code>checksum</code> field
    /// to the checksum of the most recent revision of the <code>$LATEST</code>
    /// version. If you don't specify the <code> checksum</code> field, or if the
    /// checksum does not match the <code>$LATEST</code> version, you get a
    /// <code>PreconditionFailedException</code> exception.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
    /// <p>If you set the <code>processBehavior</code> element to
    /// <code>BUILD</code>, Amazon Lex builds the bot so that it can be run. If you
    /// set the element to <code>SAVE</code> Amazon Lex saves the bot, but doesn't
    /// build it. </p>
    /// <p>If you don't specify this value, the default value is
    /// <code>BUILD</code>.</p>
    pub fn process_behavior(&self) -> std::option::Option<&crate::model::ProcessBehavior> {
        self.process_behavior.as_ref()
    }
    /// <p> Specifies the target locale for the bot. Any intent used in the
    /// bot must be compatible with the locale of the bot. </p>
    ///
    /// <p>The default is <code>en-US</code>.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>For each Amazon Lex bot created with the Amazon Lex Model Building Service,
    /// you must specify whether your use of Amazon Lex is related to a website,
    /// program, or other application that is directed or targeted, in whole or in
    /// part, to children under age 13 and subject to the Children's Online
    /// Privacy Protection Act (COPPA) by specifying <code>true</code> or
    /// <code>false</code> in the <code>childDirected</code> field. By
    /// specifying <code>true</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is</b> related
    /// to a website, program, or other application that is directed or targeted,
    /// in whole or in part, to children under age 13 and subject to COPPA. By
    /// specifying <code>false</code> in the <code>childDirected</code> field, you
    /// confirm that your use of Amazon Lex <b>is not</b>
    /// related to a website, program, or other application that is directed or
    /// targeted, in whole or in part, to children under age 13 and subject to
    /// COPPA. You may not specify a default value for the
    /// <code>childDirected</code> field that does not accurately reflect
    /// whether your use of Amazon Lex is related to a website, program, or other
    /// application that is directed or targeted, in whole or in part, to children
    /// under age 13 and subject to COPPA.</p>
    /// <p>If your use of Amazon Lex relates to a website, program, or other
    /// application that is directed in whole or in part, to children under age
    /// 13, you must obtain any required verifiable parental consent under COPPA.
    /// For information regarding the use of Amazon Lex in connection with websites,
    /// programs, or other applications that are directed or targeted, in whole or
    /// in part, to children under age 13, see the <a href="https://aws.amazon.com/lex/faqs#data-security">Amazon Lex FAQ.</a>
    /// </p>
    pub fn child_directed(&self) -> std::option::Option<bool> {
        self.child_directed
    }
    /// <p>When set to <code>true</code> user utterances are sent to Amazon
    /// Comprehend for sentiment analysis. If you don't specify
    /// <code>detectSentiment</code>, the default is <code>false</code>.</p>
    pub fn detect_sentiment(&self) -> std::option::Option<bool> {
        self.detect_sentiment
    }
    /// <p>When set to <code>true</code> a new numbered version of the bot is
    /// created. This is the same as calling the <code>CreateBotVersion</code>
    /// operation. If you don't specify <code>createVersion</code>, the default is
    /// <code>false</code>.</p>
    pub fn create_version(&self) -> std::option::Option<bool> {
        self.create_version
    }
    /// <p>A list of tags to add to the bot. You can only add tags when you
    /// create a bot, you can't use the <code>PutBot</code> operation to update
    /// the tags on a bot. To update tags, use the <code>TagResource</code>
    /// operation.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for PutBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutBotInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("intents", &self.intents);
        formatter.field("enable_model_improvements", &self.enable_model_improvements);
        formatter.field(
            "nlu_intent_confidence_threshold",
            &self.nlu_intent_confidence_threshold,
        );
        formatter.field("clarification_prompt", &self.clarification_prompt);
        formatter.field("abort_statement", &self.abort_statement);
        formatter.field(
            "idle_session_ttl_in_seconds",
            &self.idle_session_ttl_in_seconds,
        );
        formatter.field("voice_id", &self.voice_id);
        formatter.field("checksum", &self.checksum);
        formatter.field("process_behavior", &self.process_behavior);
        formatter.field("locale", &self.locale);
        formatter.field("child_directed", &self.child_directed);
        formatter.field("detect_sentiment", &self.detect_sentiment);
        formatter.field("create_version", &self.create_version);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
    /// for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get a list of tags
    /// for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUtterancesViewInput {
    /// <p>The name of the bot for which utterance information should be
    /// returned.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>An array of bot versions for which utterance information should be
    /// returned. The limit is 5 versions per request.</p>
    pub bot_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>To return utterances that were recognized and handled, use
    /// <code>Detected</code>. To return utterances that were not recognized,
    /// use <code>Missed</code>.</p>
    pub status_type: std::option::Option<crate::model::StatusType>,
}
impl GetUtterancesViewInput {
    /// <p>The name of the bot for which utterance information should be
    /// returned.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>An array of bot versions for which utterance information should be
    /// returned. The limit is 5 versions per request.</p>
    pub fn bot_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.bot_versions.as_deref()
    }
    /// <p>To return utterances that were recognized and handled, use
    /// <code>Detected</code>. To return utterances that were not recognized,
    /// use <code>Missed</code>.</p>
    pub fn status_type(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status_type.as_ref()
    }
}
impl std::fmt::Debug for GetUtterancesViewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUtterancesViewInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_versions", &self.bot_versions);
        formatter.field("status_type", &self.status_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypeVersionsInput {
    /// <p>The name of the slot type for which versions should be
    /// returned.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A pagination token for fetching the next page of slot type
    /// versions. If the response to this call is truncated, Amazon Lex returns a
    /// pagination token in the response. To fetch the next page of versions,
    /// specify the pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of slot type versions to return in the response.
    /// The default is 10.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetSlotTypeVersionsInput {
    /// <p>The name of the slot type for which versions should be
    /// returned.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A pagination token for fetching the next page of slot type
    /// versions. If the response to this call is truncated, Amazon Lex returns a
    /// pagination token in the response. To fetch the next page of versions,
    /// specify the pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of slot type versions to return in the response.
    /// The default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetSlotTypeVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypeVersionsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypesInput {
    /// <p>A pagination token that fetches the next page of slot types. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch next page of slot types, specify the pagination
    /// token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of slot types to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Substring to match in slot type names. A slot type will be returned
    /// if any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub name_contains: std::option::Option<std::string::String>,
}
impl GetSlotTypesInput {
    /// <p>A pagination token that fetches the next page of slot types. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch next page of slot types, specify the pagination
    /// token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of slot types to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Substring to match in slot type names. A slot type will be returned
    /// if any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub fn name_contains(&self) -> std::option::Option<&str> {
        self.name_contains.as_deref()
    }
}
impl std::fmt::Debug for GetSlotTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name_contains", &self.name_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSlotTypeInput {
    /// <p>The name of the slot type. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the slot type. </p>
    pub version: std::option::Option<std::string::String>,
}
impl GetSlotTypeInput {
    /// <p>The name of the slot type. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the slot type. </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for GetSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSlotTypeInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMigrationsInput {
    /// <p>The field to sort the list of migrations by. You can sort by the
    /// Amazon Lex V1 bot name or the date and time that the migration was
    /// started.</p>
    pub sort_by_attribute: std::option::Option<crate::model::MigrationSortAttribute>,
    /// <p>The order so sort the list.</p>
    pub sort_by_order: std::option::Option<crate::model::SortOrder>,
    /// <p>Filters the list to contain only bots whose name contains the
    /// specified string. The string is matched anywhere in bot name.</p>
    pub v1_bot_name_contains: std::option::Option<std::string::String>,
    /// <p>Filters the list to contain only migrations in the specified state.</p>
    pub migration_status_equals: std::option::Option<crate::model::MigrationStatus>,
    /// <p>The maximum number of migrations to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A pagination token that fetches the next page of migrations. If the
    /// response to this operation is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of migrations, specify the
    /// pagination token in the request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetMigrationsInput {
    /// <p>The field to sort the list of migrations by. You can sort by the
    /// Amazon Lex V1 bot name or the date and time that the migration was
    /// started.</p>
    pub fn sort_by_attribute(&self) -> std::option::Option<&crate::model::MigrationSortAttribute> {
        self.sort_by_attribute.as_ref()
    }
    /// <p>The order so sort the list.</p>
    pub fn sort_by_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_by_order.as_ref()
    }
    /// <p>Filters the list to contain only bots whose name contains the
    /// specified string. The string is matched anywhere in bot name.</p>
    pub fn v1_bot_name_contains(&self) -> std::option::Option<&str> {
        self.v1_bot_name_contains.as_deref()
    }
    /// <p>Filters the list to contain only migrations in the specified state.</p>
    pub fn migration_status_equals(&self) -> std::option::Option<&crate::model::MigrationStatus> {
        self.migration_status_equals.as_ref()
    }
    /// <p>The maximum number of migrations to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A pagination token that fetches the next page of migrations. If the
    /// response to this operation is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of migrations, specify the
    /// pagination token in the request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetMigrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMigrationsInput");
        formatter.field("sort_by_attribute", &self.sort_by_attribute);
        formatter.field("sort_by_order", &self.sort_by_order);
        formatter.field("v1_bot_name_contains", &self.v1_bot_name_contains);
        formatter.field("migration_status_equals", &self.migration_status_equals);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMigrationInput {
    /// <p>The unique identifier of the migration to view. The
    /// <code>migrationID</code> is returned by the  operation.</p>
    pub migration_id: std::option::Option<std::string::String>,
}
impl GetMigrationInput {
    /// <p>The unique identifier of the migration to view. The
    /// <code>migrationID</code> is returned by the  operation.</p>
    pub fn migration_id(&self) -> std::option::Option<&str> {
        self.migration_id.as_deref()
    }
}
impl std::fmt::Debug for GetMigrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMigrationInput");
        formatter.field("migration_id", &self.migration_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentVersionsInput {
    /// <p>The name of the intent for which versions should be
    /// returned.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A pagination token for fetching the next page of intent versions.
    /// If the response to this call is truncated, Amazon Lex returns a pagination
    /// token in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of intent versions to return in the response.
    /// The default is 10.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetIntentVersionsInput {
    /// <p>The name of the intent for which versions should be
    /// returned.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A pagination token for fetching the next page of intent versions.
    /// If the response to this call is truncated, Amazon Lex returns a pagination
    /// token in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of intent versions to return in the response.
    /// The default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetIntentVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentVersionsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentsInput {
    /// <p>A pagination token that fetches the next page of intents. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of intents, specify the pagination
    /// token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of intents to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Substring to match in intent names. An intent will be returned if
    /// any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub name_contains: std::option::Option<std::string::String>,
}
impl GetIntentsInput {
    /// <p>A pagination token that fetches the next page of intents. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of intents, specify the pagination
    /// token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of intents to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Substring to match in intent names. An intent will be returned if
    /// any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub fn name_contains(&self) -> std::option::Option<&str> {
        self.name_contains.as_deref()
    }
}
impl std::fmt::Debug for GetIntentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name_contains", &self.name_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntentInput {
    /// <p>The name of the intent. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the intent.</p>
    pub version: std::option::Option<std::string::String>,
}
impl GetIntentInput {
    /// <p>The name of the intent. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the intent.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for GetIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntentInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImportInput {
    /// <p>The identifier of the import job information to return.</p>
    pub import_id: std::option::Option<std::string::String>,
}
impl GetImportInput {
    /// <p>The identifier of the import job information to return.</p>
    pub fn import_id(&self) -> std::option::Option<&str> {
        self.import_id.as_deref()
    }
}
impl std::fmt::Debug for GetImportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImportInput");
        formatter.field("import_id", &self.import_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetExportInput {
    /// <p>The name of the bot to export.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the bot to export.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The type of resource to export. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The format of the exported data.</p>
    pub export_type: std::option::Option<crate::model::ExportType>,
}
impl GetExportInput {
    /// <p>The name of the bot to export.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the bot to export.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The type of resource to export. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The format of the exported data.</p>
    pub fn export_type(&self) -> std::option::Option<&crate::model::ExportType> {
        self.export_type.as_ref()
    }
}
impl std::fmt::Debug for GetExportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetExportInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("export_type", &self.export_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinSlotTypesInput {
    /// <p>A list of locales that the slot type supports.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>Substring to match in built-in slot type signatures. A slot type
    /// will be returned if any part of its signature matches the substring. For
    /// example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    pub signature_contains: std::option::Option<std::string::String>,
    /// <p>A pagination token that fetches the next page of slot types. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of slot types, specify the
    /// pagination token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of slot types to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetBuiltinSlotTypesInput {
    /// <p>A list of locales that the slot type supports.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>Substring to match in built-in slot type signatures. A slot type
    /// will be returned if any part of its signature matches the substring. For
    /// example, "xyz" matches both "xyzabc" and "abcxyz."</p>
    pub fn signature_contains(&self) -> std::option::Option<&str> {
        self.signature_contains.as_deref()
    }
    /// <p>A pagination token that fetches the next page of slot types. If the
    /// response to this API call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of slot types, specify the
    /// pagination token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of slot types to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetBuiltinSlotTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinSlotTypesInput");
        formatter.field("locale", &self.locale);
        formatter.field("signature_contains", &self.signature_contains);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinIntentsInput {
    /// <p>A list of locales that the intent supports.</p>
    pub locale: std::option::Option<crate::model::Locale>,
    /// <p>Substring to match in built-in intent signatures. An intent will be
    /// returned if any part of its signature matches the substring. For example,
    /// "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an
    /// intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub signature_contains: std::option::Option<std::string::String>,
    /// <p>A pagination token that fetches the next page of intents. If this
    /// API call is truncated, Amazon Lex returns a pagination token in the response.
    /// To fetch the next page of intents, use the pagination token in the next
    /// request.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of intents to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetBuiltinIntentsInput {
    /// <p>A list of locales that the intent supports.</p>
    pub fn locale(&self) -> std::option::Option<&crate::model::Locale> {
        self.locale.as_ref()
    }
    /// <p>Substring to match in built-in intent signatures. An intent will be
    /// returned if any part of its signature matches the substring. For example,
    /// "xyz" matches both "xyzabc" and "abcxyz." To find the signature for an
    /// intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn signature_contains(&self) -> std::option::Option<&str> {
        self.signature_contains.as_deref()
    }
    /// <p>A pagination token that fetches the next page of intents. If this
    /// API call is truncated, Amazon Lex returns a pagination token in the response.
    /// To fetch the next page of intents, use the pagination token in the next
    /// request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of intents to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetBuiltinIntentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinIntentsInput");
        formatter.field("locale", &self.locale);
        formatter.field("signature_contains", &self.signature_contains);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBuiltinIntentInput {
    /// <p>The unique identifier for a built-in intent. To find the signature
    /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub signature: std::option::Option<std::string::String>,
}
impl GetBuiltinIntentInput {
    /// <p>The unique identifier for a built-in intent. To find the signature
    /// for an intent, see <a href="https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents">Standard Built-in Intents</a> in the <i>Alexa Skills
    /// Kit</i>.</p>
    pub fn signature(&self) -> std::option::Option<&str> {
        self.signature.as_deref()
    }
}
impl std::fmt::Debug for GetBuiltinIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBuiltinIntentInput");
        formatter.field("signature", &self.signature);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotVersionsInput {
    /// <p>The name of the bot for which versions should be
    /// returned.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A pagination token for fetching the next page of bot versions. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of bot versions to return in the response. The
    /// default is 10.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetBotVersionsInput {
    /// <p>The name of the bot for which versions should be
    /// returned.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A pagination token for fetching the next page of bot versions. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of versions, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of bot versions to return in the response. The
    /// default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetBotVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotVersionsInput");
        formatter.field("name", &self.name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotsInput {
    /// <p>A pagination token that fetches the next page of bots. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of bots, specify the pagination token
    /// in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of bots to return in the response that the
    /// request will return. The default is 10.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Substring to match in bot names. A bot will be returned if any part
    /// of its name matches the substring. For example, "xyz" matches both
    /// "xyzabc" and "abcxyz."</p>
    pub name_contains: std::option::Option<std::string::String>,
}
impl GetBotsInput {
    /// <p>A pagination token that fetches the next page of bots. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of bots, specify the pagination token
    /// in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of bots to return in the response that the
    /// request will return. The default is 10.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Substring to match in bot names. A bot will be returned if any part
    /// of its name matches the substring. For example, "xyz" matches both
    /// "xyzabc" and "abcxyz."</p>
    pub fn name_contains(&self) -> std::option::Option<&str> {
        self.name_contains.as_deref()
    }
}
impl std::fmt::Debug for GetBotsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name_contains", &self.name_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotChannelAssociationsInput {
    /// <p>The name of the Amazon Lex bot in the association.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub bot_alias: std::option::Option<std::string::String>,
    /// <p>A pagination token for fetching the next page of associations. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of associations, specify the
    /// pagination token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of associations to return in the response. The
    /// default is 50. </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Substring to match in channel association names. An association
    /// will be returned if any part of its name matches the substring. For
    /// example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot
    /// channel associations, use a hyphen ("-") as the <code>nameContains</code>
    /// parameter.</p>
    pub name_contains: std::option::Option<std::string::String>,
}
impl GetBotChannelAssociationsInput {
    /// <p>The name of the Amazon Lex bot in the association.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
    /// <p>A pagination token for fetching the next page of associations. If
    /// the response to this call is truncated, Amazon Lex returns a pagination token
    /// in the response. To fetch the next page of associations, specify the
    /// pagination token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of associations to return in the response. The
    /// default is 50. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Substring to match in channel association names. An association
    /// will be returned if any part of its name matches the substring. For
    /// example, "xyz" matches both "xyzabc" and "abcxyz." To return all bot
    /// channel associations, use a hyphen ("-") as the <code>nameContains</code>
    /// parameter.</p>
    pub fn name_contains(&self) -> std::option::Option<&str> {
        self.name_contains.as_deref()
    }
}
impl std::fmt::Debug for GetBotChannelAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotChannelAssociationsInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name_contains", &self.name_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotChannelAssociationInput {
    /// <p>The name of the association between the bot and the channel. The
    /// name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub bot_alias: std::option::Option<std::string::String>,
}
impl GetBotChannelAssociationInput {
    /// <p>The name of the association between the bot and the channel. The
    /// name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the Amazon Lex bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>An alias pointing to the specific version of the Amazon Lex bot to which
    /// this association is being made.</p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
}
impl std::fmt::Debug for GetBotChannelAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotChannelAssociationInput");
        formatter.field("name", &self.name);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotAliasesInput {
    /// <p>The name of the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>A pagination token for fetching the next page of aliases. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of aliases, specify the pagination
    /// token in the next request. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of aliases to return in the response. The
    /// default is 50. . </p>
    pub max_results: std::option::Option<i32>,
    /// <p>Substring to match in bot alias names. An alias will be returned if
    /// any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub name_contains: std::option::Option<std::string::String>,
}
impl GetBotAliasesInput {
    /// <p>The name of the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>A pagination token for fetching the next page of aliases. If the
    /// response to this call is truncated, Amazon Lex returns a pagination token in
    /// the response. To fetch the next page of aliases, specify the pagination
    /// token in the next request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of aliases to return in the response. The
    /// default is 50. . </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Substring to match in bot alias names. An alias will be returned if
    /// any part of its name matches the substring. For example, "xyz" matches
    /// both "xyzabc" and "abcxyz."</p>
    pub fn name_contains(&self) -> std::option::Option<&str> {
        self.name_contains.as_deref()
    }
}
impl std::fmt::Debug for GetBotAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotAliasesInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("name_contains", &self.name_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotAliasInput {
    /// <p>The name of the bot alias. The name is case sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
}
impl GetBotAliasInput {
    /// <p>The name of the bot alias. The name is case sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
}
impl std::fmt::Debug for GetBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotAliasInput");
        formatter.field("name", &self.name);
        formatter.field("bot_name", &self.bot_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBotInput {
    /// <p>The name of the bot. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version or alias of the bot.</p>
    pub version_or_alias: std::option::Option<std::string::String>,
}
impl GetBotInput {
    /// <p>The name of the bot. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version or alias of the bot.</p>
    pub fn version_or_alias(&self) -> std::option::Option<&str> {
        self.version_or_alias.as_deref()
    }
}
impl std::fmt::Debug for GetBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBotInput");
        formatter.field("name", &self.name);
        formatter.field("version_or_alias", &self.version_or_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUtterancesInput {
    /// <p>The name of the bot that stored the utterances.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the user that made the utterances. This
    /// is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the
    /// utterance.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl DeleteUtterancesInput {
    /// <p>The name of the bot that stored the utterances.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p> The unique identifier for the user that made the utterances. This
    /// is the user ID that was sent in the <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html">PostContent</a> or <a href="http://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html">PostText</a> operation request that contained the
    /// utterance.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteUtterancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUtterancesInput");
        formatter.field("bot_name", &self.bot_name);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeVersionInput {
    /// <p>The name of the slot type.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the slot type to delete. You cannot delete the
    /// <code>$LATEST</code> version of the slot type. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteSlotType</a>
    /// operation.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DeleteSlotTypeVersionInput {
    /// <p>The name of the slot type.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the slot type to delete. You cannot delete the
    /// <code>$LATEST</code> version of the slot type. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteSlotType</a>
    /// operation.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DeleteSlotTypeVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeVersionInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSlotTypeInput {
    /// <p>The name of the slot type. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteSlotTypeInput {
    /// <p>The name of the slot type. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteSlotTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSlotTypeInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentVersionInput {
    /// <p>The name of the intent.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the intent to delete. You cannot delete the
    /// <code>$LATEST</code> version of the intent. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteIntent</a>
    /// operation.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DeleteIntentVersionInput {
    /// <p>The name of the intent.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the intent to delete. You cannot delete the
    /// <code>$LATEST</code> version of the intent. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteIntent</a>
    /// operation.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentVersionInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntentInput {
    /// <p>The name of the intent. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteIntentInput {
    /// <p>The name of the intent. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntentInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotVersionInput {
    /// <p>The name of the bot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the bot to delete. You cannot delete the
    /// <code>$LATEST</code> version of the bot. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteBot</a>
    /// operation.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DeleteBotVersionInput {
    /// <p>The name of the bot.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the bot to delete. You cannot delete the
    /// <code>$LATEST</code> version of the bot. To delete the
    /// <code>$LATEST</code> version, use the <a>DeleteBot</a>
    /// operation.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DeleteBotVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotVersionInput");
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotChannelAssociationInput {
    /// <p>The name of the association. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Lex bot.</p>
    pub bot_name: std::option::Option<std::string::String>,
    /// <p>An alias that points to the specific version of the Amazon Lex bot to
    /// which this association is being made.</p>
    pub bot_alias: std::option::Option<std::string::String>,
}
impl DeleteBotChannelAssociationInput {
    /// <p>The name of the association. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the Amazon Lex bot.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
    /// <p>An alias that points to the specific version of the Amazon Lex bot to
    /// which this association is being made.</p>
    pub fn bot_alias(&self) -> std::option::Option<&str> {
        self.bot_alias.as_deref()
    }
}
impl std::fmt::Debug for DeleteBotChannelAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotChannelAssociationInput");
        formatter.field("name", &self.name);
        formatter.field("bot_name", &self.bot_name);
        formatter.field("bot_alias", &self.bot_alias);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotAliasInput {
    /// <p>The name of the alias to delete. The name is case sensitive.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the bot that the alias points to.</p>
    pub bot_name: std::option::Option<std::string::String>,
}
impl DeleteBotAliasInput {
    /// <p>The name of the alias to delete. The name is case sensitive.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the bot that the alias points to.</p>
    pub fn bot_name(&self) -> std::option::Option<&str> {
        self.bot_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBotAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotAliasInput");
        formatter.field("name", &self.name);
        formatter.field("bot_name", &self.bot_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBotInput {
    /// <p>The name of the bot. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteBotInput {
    /// <p>The name of the bot. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBotInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBotInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSlotTypeVersionInput {
    /// <p>The name of the slot type that you want to create a new version
    /// for. The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Checksum for the <code>$LATEST</code> version of the slot type that
    /// you want to publish. If you specify a checksum and the
    /// <code>$LATEST</code> version of the slot type has a different checksum,
    /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
    /// doesn't publish the new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub checksum: std::option::Option<std::string::String>,
}
impl CreateSlotTypeVersionInput {
    /// <p>The name of the slot type that you want to create a new version
    /// for. The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Checksum for the <code>$LATEST</code> version of the slot type that
    /// you want to publish. If you specify a checksum and the
    /// <code>$LATEST</code> version of the slot type has a different checksum,
    /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
    /// doesn't publish the new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
}
impl std::fmt::Debug for CreateSlotTypeVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSlotTypeVersionInput");
        formatter.field("name", &self.name);
        formatter.field("checksum", &self.checksum);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntentVersionInput {
    /// <p>The name of the intent that you want to create a new version of.
    /// The name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Checksum of the <code>$LATEST</code> version of the intent that
    /// should be used to create the new version. If you specify a checksum and
    /// the <code>$LATEST</code> version of the intent has a different checksum,
    /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
    /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub checksum: std::option::Option<std::string::String>,
}
impl CreateIntentVersionInput {
    /// <p>The name of the intent that you want to create a new version of.
    /// The name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Checksum of the <code>$LATEST</code> version of the intent that
    /// should be used to create the new version. If you specify a checksum and
    /// the <code>$LATEST</code> version of the intent has a different checksum,
    /// Amazon Lex returns a <code>PreconditionFailedException</code> exception and
    /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
}
impl std::fmt::Debug for CreateIntentVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntentVersionInput");
        formatter.field("name", &self.name);
        formatter.field("checksum", &self.checksum);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBotVersionInput {
    /// <p>The name of the bot that you want to create a new version of. The
    /// name is case sensitive. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Identifies a specific revision of the <code>$LATEST</code> version
    /// of the bot. If you specify a checksum and the <code>$LATEST</code> version
    /// of the bot has a different checksum, a
    /// <code>PreconditionFailedException</code> exception is returned and Amazon Lex
    /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub checksum: std::option::Option<std::string::String>,
}
impl CreateBotVersionInput {
    /// <p>The name of the bot that you want to create a new version of. The
    /// name is case sensitive. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Identifies a specific revision of the <code>$LATEST</code> version
    /// of the bot. If you specify a checksum and the <code>$LATEST</code> version
    /// of the bot has a different checksum, a
    /// <code>PreconditionFailedException</code> exception is returned and Amazon Lex
    /// doesn't publish a new version. If you don't specify a checksum, Amazon Lex
    /// publishes the <code>$LATEST</code> version.</p>
    pub fn checksum(&self) -> std::option::Option<&str> {
        self.checksum.as_deref()
    }
}
impl std::fmt::Debug for CreateBotVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBotVersionInput");
        formatter.field("name", &self.name);
        formatter.field("checksum", &self.checksum);
        formatter.finish()
    }
}
