// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Lambda
///
/// Client for invoking operations on AWS Lambda. Each operation on AWS Lambda is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lambda::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lambda::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lambda::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddLayerVersionPermission`](crate::client::fluent_builders::AddLayerVersionPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::AddLayerVersionPermission::version_number) / [`set_version_number(i64)`](crate::client::fluent_builders::AddLayerVersionPermission::set_version_number): <p>The version number.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_statement_id): <p>An identifier that distinguishes the policy from others on the same layer version.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_action): <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_principal): <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
    ///   - [`organization_id(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::organization_id) / [`set_organization_id(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_organization_id): <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::AddLayerVersionPermission::set_revision_id): <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    /// - On success, responds with [`AddLayerVersionPermissionOutput`](crate::output::AddLayerVersionPermissionOutput) with field(s):
    ///   - [`statement(Option<String>)`](crate::output::AddLayerVersionPermissionOutput::statement): <p>The permission statement.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::AddLayerVersionPermissionOutput::revision_id): <p>A unique identifier for the current revision of the policy.</p>
    /// - On failure, responds with [`SdkError<AddLayerVersionPermissionError>`](crate::error::AddLayerVersionPermissionError)
    pub fn add_layer_version_permission(&self) -> fluent_builders::AddLayerVersionPermission {
        fluent_builders::AddLayerVersionPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddPermission`](crate::client::fluent_builders::AddPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::AddPermission::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::AddPermission::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::AddPermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::AddPermission::set_statement_id): <p>A statement identifier that differentiates the statement from others in the same policy.</p>
    ///   - [`action(impl Into<String>)`](crate::client::fluent_builders::AddPermission::action) / [`set_action(Option<String>)`](crate::client::fluent_builders::AddPermission::set_action): <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
    ///   - [`principal(impl Into<String>)`](crate::client::fluent_builders::AddPermission::principal) / [`set_principal(Option<String>)`](crate::client::fluent_builders::AddPermission::set_principal): <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::AddPermission::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::AddPermission::set_source_arn): <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>  <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
    ///   - [`source_account(impl Into<String>)`](crate::client::fluent_builders::AddPermission::source_account) / [`set_source_account(Option<String>)`](crate::client::fluent_builders::AddPermission::set_source_account): <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
    ///   - [`event_source_token(impl Into<String>)`](crate::client::fluent_builders::AddPermission::event_source_token) / [`set_event_source_token(Option<String>)`](crate::client::fluent_builders::AddPermission::set_event_source_token): <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::AddPermission::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::AddPermission::set_qualifier): <p>Specify a version or alias to add permissions to a published version of the function.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::AddPermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::AddPermission::set_revision_id): <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    /// - On success, responds with [`AddPermissionOutput`](crate::output::AddPermissionOutput) with field(s):
    ///   - [`statement(Option<String>)`](crate::output::AddPermissionOutput::statement): <p>The permission statement that's added to the function policy.</p>
    /// - On failure, responds with [`SdkError<AddPermissionError>`](crate::error::AddPermissionError)
    pub fn add_permission(&self) -> fluent_builders::AddPermission {
        fluent_builders::AddPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAlias`](crate::client::fluent_builders::CreateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_name): <p>The name of the alias.</p>
    ///   - [`function_version(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::function_version) / [`set_function_version(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_function_version): <p>The function version that the alias invokes.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAlias::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAlias::set_description): <p>A description of the alias.</p>
    ///   - [`routing_config(AliasRoutingConfiguration)`](crate::client::fluent_builders::CreateAlias::routing_config) / [`set_routing_config(Option<AliasRoutingConfiguration>)`](crate::client::fluent_builders::CreateAlias::set_routing_config): <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    /// - On success, responds with [`CreateAliasOutput`](crate::output::CreateAliasOutput) with field(s):
    ///   - [`alias_arn(Option<String>)`](crate::output::CreateAliasOutput::alias_arn): <p>The Amazon Resource Name (ARN) of the alias.</p>
    ///   - [`name(Option<String>)`](crate::output::CreateAliasOutput::name): <p>The name of the alias.</p>
    ///   - [`function_version(Option<String>)`](crate::output::CreateAliasOutput::function_version): <p>The function version that the alias invokes.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateAliasOutput::description): <p>A description of the alias.</p>
    ///   - [`routing_config(Option<AliasRoutingConfiguration>)`](crate::output::CreateAliasOutput::routing_config): <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing configuration</a> of the alias.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::CreateAliasOutput::revision_id): <p>A unique identifier that changes when you update the alias.</p>
    /// - On failure, responds with [`SdkError<CreateAliasError>`](crate::error::CreateAliasError)
    pub fn create_alias(&self) -> fluent_builders::CreateAlias {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCodeSigningConfig`](crate::client::fluent_builders::CreateCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCodeSigningConfig::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCodeSigningConfig::set_description): <p>Descriptive name for this code signing configuration.</p>
    ///   - [`allowed_publishers(AllowedPublishers)`](crate::client::fluent_builders::CreateCodeSigningConfig::allowed_publishers) / [`set_allowed_publishers(Option<AllowedPublishers>)`](crate::client::fluent_builders::CreateCodeSigningConfig::set_allowed_publishers): <p>Signing profiles for this code signing configuration.</p>
    ///   - [`code_signing_policies(CodeSigningPolicies)`](crate::client::fluent_builders::CreateCodeSigningConfig::code_signing_policies) / [`set_code_signing_policies(Option<CodeSigningPolicies>)`](crate::client::fluent_builders::CreateCodeSigningConfig::set_code_signing_policies): <p>The code signing policies define the actions to take if the validation checks fail. </p>
    /// - On success, responds with [`CreateCodeSigningConfigOutput`](crate::output::CreateCodeSigningConfigOutput) with field(s):
    ///   - [`code_signing_config(Option<CodeSigningConfig>)`](crate::output::CreateCodeSigningConfigOutput::code_signing_config): <p>The code signing configuration.</p>
    /// - On failure, responds with [`SdkError<CreateCodeSigningConfigError>`](crate::error::CreateCodeSigningConfigError)
    pub fn create_code_signing_config(&self) -> fluent_builders::CreateCodeSigningConfig {
        fluent_builders::CreateCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventSourceMapping`](crate::client::fluent_builders::CreateEventSourceMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>  <ul>   <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>   <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>   <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>   <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>  </ul>
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateEventSourceMapping::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_enabled): <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>  <p>Default: True</p>
    ///   - [`batch_size(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::batch_size) / [`set_batch_size(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <ul>   <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>   <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>   <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>  </ul>
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::CreateEventSourceMapping::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`maximum_batching_window_in_seconds(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::maximum_batching_window_in_seconds) / [`set_maximum_batching_window_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`parallelization_factor(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::parallelization_factor) / [`set_parallelization_factor(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_parallelization_factor): <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    ///   - [`starting_position(EventSourcePosition)`](crate::client::fluent_builders::CreateEventSourceMapping::starting_position) / [`set_starting_position(Option<EventSourcePosition>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_starting_position): <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
    ///   - [`starting_position_timestamp(DateTime)`](crate::client::fluent_builders::CreateEventSourceMapping::starting_position_timestamp) / [`set_starting_position_timestamp(Option<DateTime>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_starting_position_timestamp): <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    ///   - [`destination_config(DestinationConfig)`](crate::client::fluent_builders::CreateEventSourceMapping::destination_config) / [`set_destination_config(Option<DestinationConfig>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`maximum_record_age_in_seconds(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::maximum_record_age_in_seconds) / [`set_maximum_record_age_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    ///   - [`bisect_batch_on_function_error(bool)`](crate::client::fluent_builders::CreateEventSourceMapping::bisect_batch_on_function_error) / [`set_bisect_batch_on_function_error(Option<bool>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    ///   - [`maximum_retry_attempts(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::maximum_retry_attempts) / [`set_maximum_retry_attempts(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    ///   - [`tumbling_window_in_seconds(i32)`](crate::client::fluent_builders::CreateEventSourceMapping::tumbling_window_in_seconds) / [`set_tumbling_window_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    ///   - [`topics(Vec<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::topics) / [`set_topics(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_topics): <p>The name of the Kafka topic.</p>
    ///   - [`queues(Vec<String>)`](crate::client::fluent_builders::CreateEventSourceMapping::queues) / [`set_queues(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_queues): <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
    ///   - [`source_access_configurations(Vec<SourceAccessConfiguration>)`](crate::client::fluent_builders::CreateEventSourceMapping::source_access_configurations) / [`set_source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_source_access_configurations): <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    ///   - [`self_managed_event_source(SelfManagedEventSource)`](crate::client::fluent_builders::CreateEventSourceMapping::self_managed_event_source) / [`set_self_managed_event_source(Option<SelfManagedEventSource>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_self_managed_event_source): <p>The Self-Managed Apache Kafka cluster to send records.</p>
    ///   - [`function_response_types(Vec<FunctionResponseType>)`](crate::client::fluent_builders::CreateEventSourceMapping::function_response_types) / [`set_function_response_types(Option<Vec<FunctionResponseType>>)`](crate::client::fluent_builders::CreateEventSourceMapping::set_function_response_types): <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    /// - On success, responds with [`CreateEventSourceMappingOutput`](crate::output::CreateEventSourceMappingOutput) with field(s):
    ///   - [`uuid(Option<String>)`](crate::output::CreateEventSourceMappingOutput::uuid): <p>The identifier of the event source mapping.</p>
    ///   - [`starting_position(Option<EventSourcePosition>)`](crate::output::CreateEventSourceMappingOutput::starting_position): <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams.</p>
    ///   - [`starting_position_timestamp(Option<DateTime>)`](crate::output::CreateEventSourceMappingOutput::starting_position_timestamp): <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    ///   - [`batch_size(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`maximum_batching_window_in_seconds(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`parallelization_factor(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::parallelization_factor): <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::CreateEventSourceMappingOutput::event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>
    ///   - [`filter_criteria(Option<FilterCriteria>)`](crate::output::CreateEventSourceMappingOutput::filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::CreateEventSourceMappingOutput::function_arn): <p>The ARN of the Lambda function.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::CreateEventSourceMappingOutput::last_modified): <p>The date that the event source mapping was last updated or that its state changed.</p>
    ///   - [`last_processing_result(Option<String>)`](crate::output::CreateEventSourceMappingOutput::last_processing_result): <p>The result of the last Lambda invocation of your function.</p>
    ///   - [`state(Option<String>)`](crate::output::CreateEventSourceMappingOutput::state): <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>, <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>, or <code>Deleting</code>.</p>
    ///   - [`state_transition_reason(Option<String>)`](crate::output::CreateEventSourceMappingOutput::state_transition_reason): <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::CreateEventSourceMappingOutput::destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`topics(Option<Vec<String>>)`](crate::output::CreateEventSourceMappingOutput::topics): <p>The name of the Kafka topic.</p>
    ///   - [`queues(Option<Vec<String>>)`](crate::output::CreateEventSourceMappingOutput::queues): <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    ///   - [`source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::output::CreateEventSourceMappingOutput::source_access_configurations): <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    ///   - [`self_managed_event_source(Option<SelfManagedEventSource>)`](crate::output::CreateEventSourceMappingOutput::self_managed_event_source): <p>The self-managed Apache Kafka cluster for your event source.</p>
    ///   - [`maximum_record_age_in_seconds(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records. </p>
    ///   - [`bisect_batch_on_function_error(Option<bool>)`](crate::output::CreateEventSourceMappingOutput::bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    ///   - [`tumbling_window_in_seconds(Option<i32>)`](crate::output::CreateEventSourceMappingOutput::tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    ///   - [`function_response_types(Option<Vec<FunctionResponseType>>)`](crate::output::CreateEventSourceMappingOutput::function_response_types): <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    /// - On failure, responds with [`SdkError<CreateEventSourceMappingError>`](crate::error::CreateEventSourceMappingError)
    pub fn create_event_source_mapping(&self) -> fluent_builders::CreateEventSourceMapping {
        fluent_builders::CreateEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFunction`](crate::client::fluent_builders::CreateFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`runtime(Runtime)`](crate::client::fluent_builders::CreateFunction::runtime) / [`set_runtime(Option<Runtime>)`](crate::client::fluent_builders::CreateFunction::set_runtime): <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_role): <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    ///   - [`handler(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::handler) / [`set_handler(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_handler): <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    ///   - [`code(FunctionCode)`](crate::client::fluent_builders::CreateFunction::code) / [`set_code(Option<FunctionCode>)`](crate::client::fluent_builders::CreateFunction::set_code): <p>The code for the function.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_description): <p>A description of the function.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::CreateFunction::timeout) / [`set_timeout(Option<i32>)`](crate::client::fluent_builders::CreateFunction::set_timeout): <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    ///   - [`memory_size(i32)`](crate::client::fluent_builders::CreateFunction::memory_size) / [`set_memory_size(Option<i32>)`](crate::client::fluent_builders::CreateFunction::set_memory_size): <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    ///   - [`publish(bool)`](crate::client::fluent_builders::CreateFunction::publish) / [`set_publish(bool)`](crate::client::fluent_builders::CreateFunction::set_publish): <p>Set to true to publish the first version of the function during creation.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateFunction::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateFunction::set_vpc_config): <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    ///   - [`package_type(PackageType)`](crate::client::fluent_builders::CreateFunction::package_type) / [`set_package_type(Option<PackageType>)`](crate::client::fluent_builders::CreateFunction::set_package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
    ///   - [`dead_letter_config(DeadLetterConfig)`](crate::client::fluent_builders::CreateFunction::dead_letter_config) / [`set_dead_letter_config(Option<DeadLetterConfig>)`](crate::client::fluent_builders::CreateFunction::set_dead_letter_config): <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    ///   - [`environment(Environment)`](crate::client::fluent_builders::CreateFunction::environment) / [`set_environment(Option<Environment>)`](crate::client::fluent_builders::CreateFunction::set_environment): <p>Environment variables that are accessible from function code during execution.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_kms_key_arn): <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    ///   - [`tracing_config(TracingConfig)`](crate::client::fluent_builders::CreateFunction::tracing_config) / [`set_tracing_config(Option<TracingConfig>)`](crate::client::fluent_builders::CreateFunction::set_tracing_config): <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFunction::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFunction::set_tags): <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
    ///   - [`layers(Vec<String>)`](crate::client::fluent_builders::CreateFunction::layers) / [`set_layers(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFunction::set_layers): <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    ///   - [`file_system_configs(Vec<FileSystemConfig>)`](crate::client::fluent_builders::CreateFunction::file_system_configs) / [`set_file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::client::fluent_builders::CreateFunction::set_file_system_configs): <p>Connection settings for an Amazon EFS file system.</p>
    ///   - [`image_config(ImageConfig)`](crate::client::fluent_builders::CreateFunction::image_config) / [`set_image_config(Option<ImageConfig>)`](crate::client::fluent_builders::CreateFunction::set_image_config): <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_code_signing_config_arn): <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
    ///   - [`architectures(Vec<Architecture>)`](crate::client::fluent_builders::CreateFunction::architectures) / [`set_architectures(Option<Vec<Architecture>>)`](crate::client::fluent_builders::CreateFunction::set_architectures): <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    /// - On success, responds with [`CreateFunctionOutput`](crate::output::CreateFunctionOutput) with field(s):
    ///   - [`function_name(Option<String>)`](crate::output::CreateFunctionOutput::function_name): <p>The name of the function.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::CreateFunctionOutput::function_arn): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`runtime(Option<Runtime>)`](crate::output::CreateFunctionOutput::runtime): <p>The runtime environment for the Lambda function.</p>
    ///   - [`role(Option<String>)`](crate::output::CreateFunctionOutput::role): <p>The function's execution role.</p>
    ///   - [`handler(Option<String>)`](crate::output::CreateFunctionOutput::handler): <p>The function that Lambda calls to begin executing your function.</p>
    ///   - [`code_size(i64)`](crate::output::CreateFunctionOutput::code_size): <p>The size of the function's deployment package, in bytes.</p>
    ///   - [`description(Option<String>)`](crate::output::CreateFunctionOutput::description): <p>The function's description.</p>
    ///   - [`timeout(Option<i32>)`](crate::output::CreateFunctionOutput::timeout): <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    ///   - [`memory_size(Option<i32>)`](crate::output::CreateFunctionOutput::memory_size): <p>The amount of memory available to the function at runtime. </p>
    ///   - [`last_modified(Option<String>)`](crate::output::CreateFunctionOutput::last_modified): <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`code_sha256(Option<String>)`](crate::output::CreateFunctionOutput::code_sha256): <p>The SHA256 hash of the function's deployment package.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateFunctionOutput::version): <p>The version of the Lambda function.</p>
    ///   - [`vpc_config(Option<VpcConfigResponse>)`](crate::output::CreateFunctionOutput::vpc_config): <p>The function's networking configuration.</p>
    ///   - [`dead_letter_config(Option<DeadLetterConfig>)`](crate::output::CreateFunctionOutput::dead_letter_config): <p>The function's dead letter queue.</p>
    ///   - [`environment(Option<EnvironmentResponse>)`](crate::output::CreateFunctionOutput::environment): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::CreateFunctionOutput::kms_key_arn): <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed key.</p>
    ///   - [`tracing_config(Option<TracingConfigResponse>)`](crate::output::CreateFunctionOutput::tracing_config): <p>The function's X-Ray tracing configuration.</p>
    ///   - [`master_arn(Option<String>)`](crate::output::CreateFunctionOutput::master_arn): <p>For Lambda@Edge functions, the ARN of the main function.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::CreateFunctionOutput::revision_id): <p>The latest updated revision of the function or alias.</p>
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::CreateFunctionOutput::layers): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.</p>
    ///   - [`state(Option<State>)`](crate::output::CreateFunctionOutput::state): <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::CreateFunctionOutput::state_reason): <p>The reason for the function's current state.</p>
    ///   - [`state_reason_code(Option<StateReasonCode>)`](crate::output::CreateFunctionOutput::state_reason_code): <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or modify the function.</p>
    ///   - [`last_update_status(Option<LastUpdateStatus>)`](crate::output::CreateFunctionOutput::last_update_status): <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>
    ///   - [`last_update_status_reason(Option<String>)`](crate::output::CreateFunctionOutput::last_update_status_reason): <p>The reason for the last update that was performed on the function.</p>
    ///   - [`last_update_status_reason_code(Option<LastUpdateStatusReasonCode>)`](crate::output::CreateFunctionOutput::last_update_status_reason_code): <p>The reason code for the last update that was performed on the function.</p>
    ///   - [`file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::output::CreateFunctionOutput::file_system_configs): <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    ///   - [`package_type(Option<PackageType>)`](crate::output::CreateFunctionOutput::package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    ///   - [`image_config_response(Option<ImageConfigResponse>)`](crate::output::CreateFunctionOutput::image_config_response): <p>The function's image configuration values.</p>
    ///   - [`signing_profile_version_arn(Option<String>)`](crate::output::CreateFunctionOutput::signing_profile_version_arn): <p>The ARN of the signing profile version.</p>
    ///   - [`signing_job_arn(Option<String>)`](crate::output::CreateFunctionOutput::signing_job_arn): <p>The ARN of the signing job.</p>
    ///   - [`architectures(Option<Vec<Architecture>>)`](crate::output::CreateFunctionOutput::architectures): <p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>
    /// - On failure, responds with [`SdkError<CreateFunctionError>`](crate::error::CreateFunctionError)
    pub fn create_function(&self) -> fluent_builders::CreateFunction {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAlias`](crate::client::fluent_builders::DeleteAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAlias::set_name): <p>The name of the alias.</p>
    /// - On success, responds with [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)

    /// - On failure, responds with [`SdkError<DeleteAliasError>`](crate::error::DeleteAliasError)
    pub fn delete_alias(&self) -> fluent_builders::DeleteAlias {
        fluent_builders::DeleteAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCodeSigningConfig`](crate::client::fluent_builders::DeleteCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCodeSigningConfig::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::DeleteCodeSigningConfig::set_code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    /// - On success, responds with [`DeleteCodeSigningConfigOutput`](crate::output::DeleteCodeSigningConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteCodeSigningConfigError>`](crate::error::DeleteCodeSigningConfigError)
    pub fn delete_code_signing_config(&self) -> fluent_builders::DeleteCodeSigningConfig {
        fluent_builders::DeleteCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventSourceMapping`](crate::client::fluent_builders::DeleteEventSourceMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`uuid(impl Into<String>)`](crate::client::fluent_builders::DeleteEventSourceMapping::uuid) / [`set_uuid(Option<String>)`](crate::client::fluent_builders::DeleteEventSourceMapping::set_uuid): <p>The identifier of the event source mapping.</p>
    /// - On success, responds with [`DeleteEventSourceMappingOutput`](crate::output::DeleteEventSourceMappingOutput) with field(s):
    ///   - [`uuid(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::uuid): <p>The identifier of the event source mapping.</p>
    ///   - [`starting_position(Option<EventSourcePosition>)`](crate::output::DeleteEventSourceMappingOutput::starting_position): <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams.</p>
    ///   - [`starting_position_timestamp(Option<DateTime>)`](crate::output::DeleteEventSourceMappingOutput::starting_position_timestamp): <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    ///   - [`batch_size(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`maximum_batching_window_in_seconds(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`parallelization_factor(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::parallelization_factor): <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>
    ///   - [`filter_criteria(Option<FilterCriteria>)`](crate::output::DeleteEventSourceMappingOutput::filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::function_arn): <p>The ARN of the Lambda function.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::DeleteEventSourceMappingOutput::last_modified): <p>The date that the event source mapping was last updated or that its state changed.</p>
    ///   - [`last_processing_result(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::last_processing_result): <p>The result of the last Lambda invocation of your function.</p>
    ///   - [`state(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::state): <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>, <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>, or <code>Deleting</code>.</p>
    ///   - [`state_transition_reason(Option<String>)`](crate::output::DeleteEventSourceMappingOutput::state_transition_reason): <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::DeleteEventSourceMappingOutput::destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`topics(Option<Vec<String>>)`](crate::output::DeleteEventSourceMappingOutput::topics): <p>The name of the Kafka topic.</p>
    ///   - [`queues(Option<Vec<String>>)`](crate::output::DeleteEventSourceMappingOutput::queues): <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    ///   - [`source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::output::DeleteEventSourceMappingOutput::source_access_configurations): <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    ///   - [`self_managed_event_source(Option<SelfManagedEventSource>)`](crate::output::DeleteEventSourceMappingOutput::self_managed_event_source): <p>The self-managed Apache Kafka cluster for your event source.</p>
    ///   - [`maximum_record_age_in_seconds(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records. </p>
    ///   - [`bisect_batch_on_function_error(Option<bool>)`](crate::output::DeleteEventSourceMappingOutput::bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    ///   - [`tumbling_window_in_seconds(Option<i32>)`](crate::output::DeleteEventSourceMappingOutput::tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    ///   - [`function_response_types(Option<Vec<FunctionResponseType>>)`](crate::output::DeleteEventSourceMappingOutput::function_response_types): <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    /// - On failure, responds with [`SdkError<DeleteEventSourceMappingError>`](crate::error::DeleteEventSourceMappingError)
    pub fn delete_event_source_mapping(&self) -> fluent_builders::DeleteEventSourceMapping {
        fluent_builders::DeleteEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_function_name): <p>The name of the Lambda function or version.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_qualifier): <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
    /// - On success, responds with [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionError>`](crate::error::DeleteFunctionError)
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunctionCodeSigningConfig`](crate::client::fluent_builders::DeleteFunctionCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFunctionCodeSigningConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteFunctionCodeSigningConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On success, responds with [`DeleteFunctionCodeSigningConfigOutput`](crate::output::DeleteFunctionCodeSigningConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionCodeSigningConfigError>`](crate::error::DeleteFunctionCodeSigningConfigError)
    pub fn delete_function_code_signing_config(
        &self,
    ) -> fluent_builders::DeleteFunctionCodeSigningConfig {
        fluent_builders::DeleteFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunctionConcurrency`](crate::client::fluent_builders::DeleteFunctionConcurrency) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFunctionConcurrency::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteFunctionConcurrency::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On success, responds with [`DeleteFunctionConcurrencyOutput`](crate::output::DeleteFunctionConcurrencyOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionConcurrencyError>`](crate::error::DeleteFunctionConcurrencyError)
    pub fn delete_function_concurrency(&self) -> fluent_builders::DeleteFunctionConcurrency {
        fluent_builders::DeleteFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunctionEventInvokeConfig`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig::set_qualifier): <p>A version number or alias name.</p>
    /// - On success, responds with [`DeleteFunctionEventInvokeConfigOutput`](crate::output::DeleteFunctionEventInvokeConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionEventInvokeConfigError>`](crate::error::DeleteFunctionEventInvokeConfigError)
    pub fn delete_function_event_invoke_config(
        &self,
    ) -> fluent_builders::DeleteFunctionEventInvokeConfig {
        fluent_builders::DeleteFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLayerVersion`](crate::client::fluent_builders::DeleteLayerVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLayerVersion::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::DeleteLayerVersion::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::DeleteLayerVersion::version_number) / [`set_version_number(i64)`](crate::client::fluent_builders::DeleteLayerVersion::set_version_number): <p>The version number.</p>
    /// - On success, responds with [`DeleteLayerVersionOutput`](crate::output::DeleteLayerVersionOutput)

    /// - On failure, responds with [`SdkError<DeleteLayerVersionError>`](crate::error::DeleteLayerVersionError)
    pub fn delete_layer_version(&self) -> fluent_builders::DeleteLayerVersion {
        fluent_builders::DeleteLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProvisionedConcurrencyConfig`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig::set_qualifier): <p>The version number or alias name.</p>
    /// - On success, responds with [`DeleteProvisionedConcurrencyConfigOutput`](crate::output::DeleteProvisionedConcurrencyConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteProvisionedConcurrencyConfigError>`](crate::error::DeleteProvisionedConcurrencyConfigError)
    pub fn delete_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::DeleteProvisionedConcurrencyConfig {
        fluent_builders::DeleteProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccountSettings::send) it.

    /// - On success, responds with [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput) with field(s):
    ///   - [`account_limit(Option<AccountLimit>)`](crate::output::GetAccountSettingsOutput::account_limit): <p>Limits that are related to concurrency and code storage.</p>
    ///   - [`account_usage(Option<AccountUsage>)`](crate::output::GetAccountSettingsOutput::account_usage): <p>The number of functions and amount of storage in use.</p>
    /// - On failure, responds with [`SdkError<GetAccountSettingsError>`](crate::error::GetAccountSettingsError)
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAlias`](crate::client::fluent_builders::GetAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetAlias::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetAlias::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetAlias::set_name): <p>The name of the alias.</p>
    /// - On success, responds with [`GetAliasOutput`](crate::output::GetAliasOutput) with field(s):
    ///   - [`alias_arn(Option<String>)`](crate::output::GetAliasOutput::alias_arn): <p>The Amazon Resource Name (ARN) of the alias.</p>
    ///   - [`name(Option<String>)`](crate::output::GetAliasOutput::name): <p>The name of the alias.</p>
    ///   - [`function_version(Option<String>)`](crate::output::GetAliasOutput::function_version): <p>The function version that the alias invokes.</p>
    ///   - [`description(Option<String>)`](crate::output::GetAliasOutput::description): <p>A description of the alias.</p>
    ///   - [`routing_config(Option<AliasRoutingConfiguration>)`](crate::output::GetAliasOutput::routing_config): <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing configuration</a> of the alias.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetAliasOutput::revision_id): <p>A unique identifier that changes when you update the alias.</p>
    /// - On failure, responds with [`SdkError<GetAliasError>`](crate::error::GetAliasError)
    pub fn get_alias(&self) -> fluent_builders::GetAlias {
        fluent_builders::GetAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCodeSigningConfig`](crate::client::fluent_builders::GetCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::GetCodeSigningConfig::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::GetCodeSigningConfig::set_code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
    /// - On success, responds with [`GetCodeSigningConfigOutput`](crate::output::GetCodeSigningConfigOutput) with field(s):
    ///   - [`code_signing_config(Option<CodeSigningConfig>)`](crate::output::GetCodeSigningConfigOutput::code_signing_config): <p>The code signing configuration</p>
    /// - On failure, responds with [`SdkError<GetCodeSigningConfigError>`](crate::error::GetCodeSigningConfigError)
    pub fn get_code_signing_config(&self) -> fluent_builders::GetCodeSigningConfig {
        fluent_builders::GetCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEventSourceMapping`](crate::client::fluent_builders::GetEventSourceMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`uuid(impl Into<String>)`](crate::client::fluent_builders::GetEventSourceMapping::uuid) / [`set_uuid(Option<String>)`](crate::client::fluent_builders::GetEventSourceMapping::set_uuid): <p>The identifier of the event source mapping.</p>
    /// - On success, responds with [`GetEventSourceMappingOutput`](crate::output::GetEventSourceMappingOutput) with field(s):
    ///   - [`uuid(Option<String>)`](crate::output::GetEventSourceMappingOutput::uuid): <p>The identifier of the event source mapping.</p>
    ///   - [`starting_position(Option<EventSourcePosition>)`](crate::output::GetEventSourceMappingOutput::starting_position): <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams.</p>
    ///   - [`starting_position_timestamp(Option<DateTime>)`](crate::output::GetEventSourceMappingOutput::starting_position_timestamp): <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    ///   - [`batch_size(Option<i32>)`](crate::output::GetEventSourceMappingOutput::batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`maximum_batching_window_in_seconds(Option<i32>)`](crate::output::GetEventSourceMappingOutput::maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`parallelization_factor(Option<i32>)`](crate::output::GetEventSourceMappingOutput::parallelization_factor): <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::GetEventSourceMappingOutput::event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>
    ///   - [`filter_criteria(Option<FilterCriteria>)`](crate::output::GetEventSourceMappingOutput::filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::GetEventSourceMappingOutput::function_arn): <p>The ARN of the Lambda function.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::GetEventSourceMappingOutput::last_modified): <p>The date that the event source mapping was last updated or that its state changed.</p>
    ///   - [`last_processing_result(Option<String>)`](crate::output::GetEventSourceMappingOutput::last_processing_result): <p>The result of the last Lambda invocation of your function.</p>
    ///   - [`state(Option<String>)`](crate::output::GetEventSourceMappingOutput::state): <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>, <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>, or <code>Deleting</code>.</p>
    ///   - [`state_transition_reason(Option<String>)`](crate::output::GetEventSourceMappingOutput::state_transition_reason): <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::GetEventSourceMappingOutput::destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`topics(Option<Vec<String>>)`](crate::output::GetEventSourceMappingOutput::topics): <p>The name of the Kafka topic.</p>
    ///   - [`queues(Option<Vec<String>>)`](crate::output::GetEventSourceMappingOutput::queues): <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    ///   - [`source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::output::GetEventSourceMappingOutput::source_access_configurations): <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    ///   - [`self_managed_event_source(Option<SelfManagedEventSource>)`](crate::output::GetEventSourceMappingOutput::self_managed_event_source): <p>The self-managed Apache Kafka cluster for your event source.</p>
    ///   - [`maximum_record_age_in_seconds(Option<i32>)`](crate::output::GetEventSourceMappingOutput::maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records. </p>
    ///   - [`bisect_batch_on_function_error(Option<bool>)`](crate::output::GetEventSourceMappingOutput::bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::GetEventSourceMappingOutput::maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    ///   - [`tumbling_window_in_seconds(Option<i32>)`](crate::output::GetEventSourceMappingOutput::tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    ///   - [`function_response_types(Option<Vec<FunctionResponseType>>)`](crate::output::GetEventSourceMappingOutput::function_response_types): <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    /// - On failure, responds with [`SdkError<GetEventSourceMappingError>`](crate::error::GetEventSourceMappingError)
    pub fn get_event_source_mapping(&self) -> fluent_builders::GetEventSourceMapping {
        fluent_builders::GetEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunction`](crate::client::fluent_builders::GetFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetFunction::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetFunction::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::GetFunction::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::GetFunction::set_qualifier): <p>Specify a version or alias to get details about a published version of the function.</p>
    /// - On success, responds with [`GetFunctionOutput`](crate::output::GetFunctionOutput) with field(s):
    ///   - [`configuration(Option<FunctionConfiguration>)`](crate::output::GetFunctionOutput::configuration): <p>The configuration of the function or version.</p>
    ///   - [`code(Option<FunctionCodeLocation>)`](crate::output::GetFunctionOutput::code): <p>The deployment package of the function or version.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetFunctionOutput::tags): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>
    ///   - [`concurrency(Option<Concurrency>)`](crate::output::GetFunctionOutput::concurrency): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved concurrency</a>.</p>
    /// - On failure, responds with [`SdkError<GetFunctionError>`](crate::error::GetFunctionError)
    pub fn get_function(&self) -> fluent_builders::GetFunction {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunctionCodeSigningConfig`](crate::client::fluent_builders::GetFunctionCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetFunctionCodeSigningConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetFunctionCodeSigningConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On success, responds with [`GetFunctionCodeSigningConfigOutput`](crate::output::GetFunctionCodeSigningConfigOutput) with field(s):
    ///   - [`code_signing_config_arn(Option<String>)`](crate::output::GetFunctionCodeSigningConfigOutput::code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    ///   - [`function_name(Option<String>)`](crate::output::GetFunctionCodeSigningConfigOutput::function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On failure, responds with [`SdkError<GetFunctionCodeSigningConfigError>`](crate::error::GetFunctionCodeSigningConfigError)
    pub fn get_function_code_signing_config(
        &self,
    ) -> fluent_builders::GetFunctionCodeSigningConfig {
        fluent_builders::GetFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunctionConcurrency`](crate::client::fluent_builders::GetFunctionConcurrency) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetFunctionConcurrency::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetFunctionConcurrency::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On success, responds with [`GetFunctionConcurrencyOutput`](crate::output::GetFunctionConcurrencyOutput) with field(s):
    ///   - [`reserved_concurrent_executions(Option<i32>)`](crate::output::GetFunctionConcurrencyOutput::reserved_concurrent_executions): <p>The number of simultaneous executions that are reserved for the function.</p>
    /// - On failure, responds with [`SdkError<GetFunctionConcurrencyError>`](crate::error::GetFunctionConcurrencyError)
    pub fn get_function_concurrency(&self) -> fluent_builders::GetFunctionConcurrency {
        fluent_builders::GetFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunctionConfiguration`](crate::client::fluent_builders::GetFunctionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetFunctionConfiguration::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetFunctionConfiguration::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::GetFunctionConfiguration::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::GetFunctionConfiguration::set_qualifier): <p>Specify a version or alias to get details about a published version of the function.</p>
    /// - On success, responds with [`GetFunctionConfigurationOutput`](crate::output::GetFunctionConfigurationOutput) with field(s):
    ///   - [`function_name(Option<String>)`](crate::output::GetFunctionConfigurationOutput::function_name): <p>The name of the function.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::GetFunctionConfigurationOutput::function_arn): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`runtime(Option<Runtime>)`](crate::output::GetFunctionConfigurationOutput::runtime): <p>The runtime environment for the Lambda function.</p>
    ///   - [`role(Option<String>)`](crate::output::GetFunctionConfigurationOutput::role): <p>The function's execution role.</p>
    ///   - [`handler(Option<String>)`](crate::output::GetFunctionConfigurationOutput::handler): <p>The function that Lambda calls to begin executing your function.</p>
    ///   - [`code_size(i64)`](crate::output::GetFunctionConfigurationOutput::code_size): <p>The size of the function's deployment package, in bytes.</p>
    ///   - [`description(Option<String>)`](crate::output::GetFunctionConfigurationOutput::description): <p>The function's description.</p>
    ///   - [`timeout(Option<i32>)`](crate::output::GetFunctionConfigurationOutput::timeout): <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    ///   - [`memory_size(Option<i32>)`](crate::output::GetFunctionConfigurationOutput::memory_size): <p>The amount of memory available to the function at runtime. </p>
    ///   - [`last_modified(Option<String>)`](crate::output::GetFunctionConfigurationOutput::last_modified): <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`code_sha256(Option<String>)`](crate::output::GetFunctionConfigurationOutput::code_sha256): <p>The SHA256 hash of the function's deployment package.</p>
    ///   - [`version(Option<String>)`](crate::output::GetFunctionConfigurationOutput::version): <p>The version of the Lambda function.</p>
    ///   - [`vpc_config(Option<VpcConfigResponse>)`](crate::output::GetFunctionConfigurationOutput::vpc_config): <p>The function's networking configuration.</p>
    ///   - [`dead_letter_config(Option<DeadLetterConfig>)`](crate::output::GetFunctionConfigurationOutput::dead_letter_config): <p>The function's dead letter queue.</p>
    ///   - [`environment(Option<EnvironmentResponse>)`](crate::output::GetFunctionConfigurationOutput::environment): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::GetFunctionConfigurationOutput::kms_key_arn): <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed key.</p>
    ///   - [`tracing_config(Option<TracingConfigResponse>)`](crate::output::GetFunctionConfigurationOutput::tracing_config): <p>The function's X-Ray tracing configuration.</p>
    ///   - [`master_arn(Option<String>)`](crate::output::GetFunctionConfigurationOutput::master_arn): <p>For Lambda@Edge functions, the ARN of the main function.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetFunctionConfigurationOutput::revision_id): <p>The latest updated revision of the function or alias.</p>
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::GetFunctionConfigurationOutput::layers): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.</p>
    ///   - [`state(Option<State>)`](crate::output::GetFunctionConfigurationOutput::state): <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::GetFunctionConfigurationOutput::state_reason): <p>The reason for the function's current state.</p>
    ///   - [`state_reason_code(Option<StateReasonCode>)`](crate::output::GetFunctionConfigurationOutput::state_reason_code): <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or modify the function.</p>
    ///   - [`last_update_status(Option<LastUpdateStatus>)`](crate::output::GetFunctionConfigurationOutput::last_update_status): <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>
    ///   - [`last_update_status_reason(Option<String>)`](crate::output::GetFunctionConfigurationOutput::last_update_status_reason): <p>The reason for the last update that was performed on the function.</p>
    ///   - [`last_update_status_reason_code(Option<LastUpdateStatusReasonCode>)`](crate::output::GetFunctionConfigurationOutput::last_update_status_reason_code): <p>The reason code for the last update that was performed on the function.</p>
    ///   - [`file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::output::GetFunctionConfigurationOutput::file_system_configs): <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    ///   - [`package_type(Option<PackageType>)`](crate::output::GetFunctionConfigurationOutput::package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    ///   - [`image_config_response(Option<ImageConfigResponse>)`](crate::output::GetFunctionConfigurationOutput::image_config_response): <p>The function's image configuration values.</p>
    ///   - [`signing_profile_version_arn(Option<String>)`](crate::output::GetFunctionConfigurationOutput::signing_profile_version_arn): <p>The ARN of the signing profile version.</p>
    ///   - [`signing_job_arn(Option<String>)`](crate::output::GetFunctionConfigurationOutput::signing_job_arn): <p>The ARN of the signing job.</p>
    ///   - [`architectures(Option<Vec<Architecture>>)`](crate::output::GetFunctionConfigurationOutput::architectures): <p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>
    /// - On failure, responds with [`SdkError<GetFunctionConfigurationError>`](crate::error::GetFunctionConfigurationError)
    pub fn get_function_configuration(&self) -> fluent_builders::GetFunctionConfiguration {
        fluent_builders::GetFunctionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunctionEventInvokeConfig`](crate::client::fluent_builders::GetFunctionEventInvokeConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetFunctionEventInvokeConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetFunctionEventInvokeConfig::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::GetFunctionEventInvokeConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::GetFunctionEventInvokeConfig::set_qualifier): <p>A version number or alias name.</p>
    /// - On success, responds with [`GetFunctionEventInvokeConfigOutput`](crate::output::GetFunctionEventInvokeConfigOutput) with field(s):
    ///   - [`last_modified(Option<DateTime>)`](crate::output::GetFunctionEventInvokeConfigOutput::last_modified): <p>The date and time that the configuration was last updated.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::GetFunctionEventInvokeConfigOutput::function_arn): <p>The Amazon Resource Name (ARN) of the function.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::GetFunctionEventInvokeConfigOutput::maximum_retry_attempts): <p>The maximum number of times to retry when the function returns an error.</p>
    ///   - [`maximum_event_age_in_seconds(Option<i32>)`](crate::output::GetFunctionEventInvokeConfigOutput::maximum_event_age_in_seconds): <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::GetFunctionEventInvokeConfigOutput::destination_config): <p>A destination for events after they have been sent to a function for processing.</p>  <p class="title"> <b>Destinations</b> </p>  <ul>   <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>   <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>   <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>   <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<GetFunctionEventInvokeConfigError>`](crate::error::GetFunctionEventInvokeConfigError)
    pub fn get_function_event_invoke_config(
        &self,
    ) -> fluent_builders::GetFunctionEventInvokeConfig {
        fluent_builders::GetFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLayerVersion`](crate::client::fluent_builders::GetLayerVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::GetLayerVersion::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::GetLayerVersion::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::GetLayerVersion::version_number) / [`set_version_number(i64)`](crate::client::fluent_builders::GetLayerVersion::set_version_number): <p>The version number.</p>
    /// - On success, responds with [`GetLayerVersionOutput`](crate::output::GetLayerVersionOutput) with field(s):
    ///   - [`content(Option<LayerVersionContentOutput>)`](crate::output::GetLayerVersionOutput::content): <p>Details about the layer version.</p>
    ///   - [`layer_arn(Option<String>)`](crate::output::GetLayerVersionOutput::layer_arn): <p>The ARN of the layer.</p>
    ///   - [`layer_version_arn(Option<String>)`](crate::output::GetLayerVersionOutput::layer_version_arn): <p>The ARN of the layer version.</p>
    ///   - [`description(Option<String>)`](crate::output::GetLayerVersionOutput::description): <p>The description of the version.</p>
    ///   - [`created_date(Option<String>)`](crate::output::GetLayerVersionOutput::created_date): <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`version(i64)`](crate::output::GetLayerVersionOutput::version): <p>The version number.</p>
    ///   - [`compatible_runtimes(Option<Vec<Runtime>>)`](crate::output::GetLayerVersionOutput::compatible_runtimes): <p>The layer's compatible runtimes.</p>
    ///   - [`license_info(Option<String>)`](crate::output::GetLayerVersionOutput::license_info): <p>The layer's software license.</p>
    ///   - [`compatible_architectures(Option<Vec<Architecture>>)`](crate::output::GetLayerVersionOutput::compatible_architectures): <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    /// - On failure, responds with [`SdkError<GetLayerVersionError>`](crate::error::GetLayerVersionError)
    pub fn get_layer_version(&self) -> fluent_builders::GetLayerVersion {
        fluent_builders::GetLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLayerVersionByArn`](crate::client::fluent_builders::GetLayerVersionByArn) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::GetLayerVersionByArn::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::GetLayerVersionByArn::set_arn): <p>The ARN of the layer version.</p>
    /// - On success, responds with [`GetLayerVersionByArnOutput`](crate::output::GetLayerVersionByArnOutput) with field(s):
    ///   - [`content(Option<LayerVersionContentOutput>)`](crate::output::GetLayerVersionByArnOutput::content): <p>Details about the layer version.</p>
    ///   - [`layer_arn(Option<String>)`](crate::output::GetLayerVersionByArnOutput::layer_arn): <p>The ARN of the layer.</p>
    ///   - [`layer_version_arn(Option<String>)`](crate::output::GetLayerVersionByArnOutput::layer_version_arn): <p>The ARN of the layer version.</p>
    ///   - [`description(Option<String>)`](crate::output::GetLayerVersionByArnOutput::description): <p>The description of the version.</p>
    ///   - [`created_date(Option<String>)`](crate::output::GetLayerVersionByArnOutput::created_date): <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`version(i64)`](crate::output::GetLayerVersionByArnOutput::version): <p>The version number.</p>
    ///   - [`compatible_runtimes(Option<Vec<Runtime>>)`](crate::output::GetLayerVersionByArnOutput::compatible_runtimes): <p>The layer's compatible runtimes.</p>
    ///   - [`license_info(Option<String>)`](crate::output::GetLayerVersionByArnOutput::license_info): <p>The layer's software license.</p>
    ///   - [`compatible_architectures(Option<Vec<Architecture>>)`](crate::output::GetLayerVersionByArnOutput::compatible_architectures): <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    /// - On failure, responds with [`SdkError<GetLayerVersionByArnError>`](crate::error::GetLayerVersionByArnError)
    pub fn get_layer_version_by_arn(&self) -> fluent_builders::GetLayerVersionByArn {
        fluent_builders::GetLayerVersionByArn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLayerVersionPolicy`](crate::client::fluent_builders::GetLayerVersionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::GetLayerVersionPolicy::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::GetLayerVersionPolicy::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::GetLayerVersionPolicy::version_number) / [`set_version_number(i64)`](crate::client::fluent_builders::GetLayerVersionPolicy::set_version_number): <p>The version number.</p>
    /// - On success, responds with [`GetLayerVersionPolicyOutput`](crate::output::GetLayerVersionPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetLayerVersionPolicyOutput::policy): <p>The policy document.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetLayerVersionPolicyOutput::revision_id): <p>A unique identifier for the current revision of the policy.</p>
    /// - On failure, responds with [`SdkError<GetLayerVersionPolicyError>`](crate::error::GetLayerVersionPolicyError)
    pub fn get_layer_version_policy(&self) -> fluent_builders::GetLayerVersionPolicy {
        fluent_builders::GetLayerVersionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPolicy`](crate::client::fluent_builders::GetPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetPolicy::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetPolicy::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::GetPolicy::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::GetPolicy::set_qualifier): <p>Specify a version or alias to get the policy for that resource.</p>
    /// - On success, responds with [`GetPolicyOutput`](crate::output::GetPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetPolicyOutput::policy): <p>The resource-based policy.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::GetPolicyOutput::revision_id): <p>A unique identifier for the current revision of the policy.</p>
    /// - On failure, responds with [`SdkError<GetPolicyError>`](crate::error::GetPolicyError)
    pub fn get_policy(&self) -> fluent_builders::GetPolicy {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProvisionedConcurrencyConfig`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig::set_qualifier): <p>The version number or alias name.</p>
    /// - On success, responds with [`GetProvisionedConcurrencyConfigOutput`](crate::output::GetProvisionedConcurrencyConfigOutput) with field(s):
    ///   - [`requested_provisioned_concurrent_executions(Option<i32>)`](crate::output::GetProvisionedConcurrencyConfigOutput::requested_provisioned_concurrent_executions): <p>The amount of provisioned concurrency requested.</p>
    ///   - [`available_provisioned_concurrent_executions(Option<i32>)`](crate::output::GetProvisionedConcurrencyConfigOutput::available_provisioned_concurrent_executions): <p>The amount of provisioned concurrency available.</p>
    ///   - [`allocated_provisioned_concurrent_executions(Option<i32>)`](crate::output::GetProvisionedConcurrencyConfigOutput::allocated_provisioned_concurrent_executions): <p>The amount of provisioned concurrency allocated.</p>
    ///   - [`status(Option<ProvisionedConcurrencyStatusEnum>)`](crate::output::GetProvisionedConcurrencyConfigOutput::status): <p>The status of the allocation process.</p>
    ///   - [`status_reason(Option<String>)`](crate::output::GetProvisionedConcurrencyConfigOutput::status_reason): <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    ///   - [`last_modified(Option<String>)`](crate::output::GetProvisionedConcurrencyConfigOutput::last_modified): <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    /// - On failure, responds with [`SdkError<GetProvisionedConcurrencyConfigError>`](crate::error::GetProvisionedConcurrencyConfigError)
    pub fn get_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::GetProvisionedConcurrencyConfig {
        fluent_builders::GetProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Invoke`](crate::client::fluent_builders::Invoke) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::Invoke::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::Invoke::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`invocation_type(InvocationType)`](crate::client::fluent_builders::Invoke::invocation_type) / [`set_invocation_type(Option<InvocationType>)`](crate::client::fluent_builders::Invoke::set_invocation_type): <p>Choose from the following options.</p>  <ul>   <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>   <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>   <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>  </ul>
    ///   - [`log_type(LogType)`](crate::client::fluent_builders::Invoke::log_type) / [`set_log_type(Option<LogType>)`](crate::client::fluent_builders::Invoke::set_log_type): <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
    ///   - [`client_context(impl Into<String>)`](crate::client::fluent_builders::Invoke::client_context) / [`set_client_context(Option<String>)`](crate::client::fluent_builders::Invoke::set_client_context): <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
    ///   - [`payload(Blob)`](crate::client::fluent_builders::Invoke::payload) / [`set_payload(Option<Blob>)`](crate::client::fluent_builders::Invoke::set_payload): <p>The JSON that you want to provide to your Lambda function as input.</p>  <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::Invoke::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::Invoke::set_qualifier): <p>Specify a version or alias to invoke a published version of the function.</p>
    /// - On success, responds with [`InvokeOutput`](crate::output::InvokeOutput) with field(s):
    ///   - [`status_code(i32)`](crate::output::InvokeOutput::status_code): <p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code> invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For the <code>DryRun</code> invocation type, the status code is 204.</p>
    ///   - [`function_error(Option<String>)`](crate::output::InvokeOutput::function_error): <p>If present, indicates that an error occurred during function execution. Details about the error are included in the response payload.</p>
    ///   - [`log_result(Option<String>)`](crate::output::InvokeOutput::log_result): <p>The last 4 KB of the execution log, which is base64 encoded.</p>
    ///   - [`payload(Option<Blob>)`](crate::output::InvokeOutput::payload): <p>The response from the function, or an error object.</p>
    ///   - [`executed_version(Option<String>)`](crate::output::InvokeOutput::executed_version): <p>The version of the function that executed. When you invoke a function with an alias, this indicates which version the alias resolved to.</p>
    /// - On failure, responds with [`SdkError<InvokeError>`](crate::error::InvokeError)
    pub fn invoke(&self) -> fluent_builders::Invoke {
        fluent_builders::Invoke::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InvokeAsync`](crate::client::fluent_builders::InvokeAsync) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::InvokeAsync::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::InvokeAsync::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`invoke_args(byte_stream::ByteStream)`](crate::client::fluent_builders::InvokeAsync::invoke_args) / [`set_invoke_args(byte_stream::ByteStream)`](crate::client::fluent_builders::InvokeAsync::set_invoke_args): <p>The JSON that you want to provide to your Lambda function as input.</p>
    /// - On success, responds with [`InvokeAsyncOutput`](crate::output::InvokeAsyncOutput) with field(s):
    ///   - [`status(i32)`](crate::output::InvokeAsyncOutput::status): <p>The status code.</p>
    /// - On failure, responds with [`SdkError<InvokeAsyncError>`](crate::error::InvokeAsyncError)
    pub fn invoke_async(&self) -> fluent_builders::InvokeAsync {
        fluent_builders::InvokeAsync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAliases`](crate::client::fluent_builders::ListAliases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAliases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::ListAliases::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::ListAliases::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`function_version(impl Into<String>)`](crate::client::fluent_builders::ListAliases::function_version) / [`set_function_version(Option<String>)`](crate::client::fluent_builders::ListAliases::set_function_version): <p>Specify a function version to only list aliases that invoke that version.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListAliases::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListAliases::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListAliases::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListAliases::set_max_items): <p>Limit the number of aliases returned.</p>
    /// - On success, responds with [`ListAliasesOutput`](crate::output::ListAliasesOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListAliasesOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    ///   - [`aliases(Option<Vec<AliasConfiguration>>)`](crate::output::ListAliasesOutput::aliases): <p>A list of aliases.</p>
    /// - On failure, responds with [`SdkError<ListAliasesError>`](crate::error::ListAliasesError)
    pub fn list_aliases(&self) -> fluent_builders::ListAliases {
        fluent_builders::ListAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCodeSigningConfigs`](crate::client::fluent_builders::ListCodeSigningConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCodeSigningConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListCodeSigningConfigs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListCodeSigningConfigs::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListCodeSigningConfigs::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListCodeSigningConfigs::set_max_items): <p>Maximum number of items to return.</p>
    /// - On success, responds with [`ListCodeSigningConfigsOutput`](crate::output::ListCodeSigningConfigsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListCodeSigningConfigsOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    ///   - [`code_signing_configs(Option<Vec<CodeSigningConfig>>)`](crate::output::ListCodeSigningConfigsOutput::code_signing_configs): <p>The code signing configurations</p>
    /// - On failure, responds with [`SdkError<ListCodeSigningConfigsError>`](crate::error::ListCodeSigningConfigsError)
    pub fn list_code_signing_configs(&self) -> fluent_builders::ListCodeSigningConfigs {
        fluent_builders::ListCodeSigningConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventSourceMappings`](crate::client::fluent_builders::ListEventSourceMappings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventSourceMappings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_source_arn(impl Into<String>)`](crate::client::fluent_builders::ListEventSourceMappings::event_source_arn) / [`set_event_source_arn(Option<String>)`](crate::client::fluent_builders::ListEventSourceMappings::set_event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>  <ul>   <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>   <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>   <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>   <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>  </ul>
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::ListEventSourceMappings::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::ListEventSourceMappings::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListEventSourceMappings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListEventSourceMappings::set_marker): <p>A pagination token returned by a previous call.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListEventSourceMappings::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListEventSourceMappings::set_max_items): <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
    /// - On success, responds with [`ListEventSourceMappingsOutput`](crate::output::ListEventSourceMappingsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListEventSourceMappingsOutput::next_marker): <p>A pagination token that's returned when the response doesn't contain all event source mappings.</p>
    ///   - [`event_source_mappings(Option<Vec<EventSourceMappingConfiguration>>)`](crate::output::ListEventSourceMappingsOutput::event_source_mappings): <p>A list of event source mappings.</p>
    /// - On failure, responds with [`SdkError<ListEventSourceMappingsError>`](crate::error::ListEventSourceMappingsError)
    pub fn list_event_source_mappings(&self) -> fluent_builders::ListEventSourceMappings {
        fluent_builders::ListEventSourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFunctionEventInvokeConfigs`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs::set_max_items): <p>The maximum number of configurations to return.</p>
    /// - On success, responds with [`ListFunctionEventInvokeConfigsOutput`](crate::output::ListFunctionEventInvokeConfigsOutput) with field(s):
    ///   - [`function_event_invoke_configs(Option<Vec<FunctionEventInvokeConfig>>)`](crate::output::ListFunctionEventInvokeConfigsOutput::function_event_invoke_configs): <p>A list of configurations.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListFunctionEventInvokeConfigsOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    /// - On failure, responds with [`SdkError<ListFunctionEventInvokeConfigsError>`](crate::error::ListFunctionEventInvokeConfigsError)
    pub fn list_function_event_invoke_configs(
        &self,
    ) -> fluent_builders::ListFunctionEventInvokeConfigs {
        fluent_builders::ListFunctionEventInvokeConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFunctions`](crate::client::fluent_builders::ListFunctions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFunctions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`master_region(impl Into<String>)`](crate::client::fluent_builders::ListFunctions::master_region) / [`set_master_region(Option<String>)`](crate::client::fluent_builders::ListFunctions::set_master_region): <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
    ///   - [`function_version(FunctionVersion)`](crate::client::fluent_builders::ListFunctions::function_version) / [`set_function_version(Option<FunctionVersion>)`](crate::client::fluent_builders::ListFunctions::set_function_version): <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFunctions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFunctions::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFunctions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFunctions::set_max_items): <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    /// - On success, responds with [`ListFunctionsOutput`](crate::output::ListFunctionsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListFunctionsOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    ///   - [`functions(Option<Vec<FunctionConfiguration>>)`](crate::output::ListFunctionsOutput::functions): <p>A list of Lambda functions.</p>
    /// - On failure, responds with [`SdkError<ListFunctionsError>`](crate::error::ListFunctionsError)
    pub fn list_functions(&self) -> fluent_builders::ListFunctions {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFunctionsByCodeSigningConfig`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::set_code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig::set_max_items): <p>Maximum number of items to return.</p>
    /// - On success, responds with [`ListFunctionsByCodeSigningConfigOutput`](crate::output::ListFunctionsByCodeSigningConfigOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListFunctionsByCodeSigningConfigOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    ///   - [`function_arns(Option<Vec<String>>)`](crate::output::ListFunctionsByCodeSigningConfigOutput::function_arns): <p>The function ARNs. </p>
    /// - On failure, responds with [`SdkError<ListFunctionsByCodeSigningConfigError>`](crate::error::ListFunctionsByCodeSigningConfigError)
    pub fn list_functions_by_code_signing_config(
        &self,
    ) -> fluent_builders::ListFunctionsByCodeSigningConfig {
        fluent_builders::ListFunctionsByCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLayers`](crate::client::fluent_builders::ListLayers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLayers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`compatible_runtime(Runtime)`](crate::client::fluent_builders::ListLayers::compatible_runtime) / [`set_compatible_runtime(Option<Runtime>)`](crate::client::fluent_builders::ListLayers::set_compatible_runtime): <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListLayers::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListLayers::set_marker): <p>A pagination token returned by a previous call.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListLayers::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListLayers::set_max_items): <p>The maximum number of layers to return.</p>
    ///   - [`compatible_architecture(Architecture)`](crate::client::fluent_builders::ListLayers::compatible_architecture) / [`set_compatible_architecture(Option<Architecture>)`](crate::client::fluent_builders::ListLayers::set_compatible_architecture): <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    /// - On success, responds with [`ListLayersOutput`](crate::output::ListLayersOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListLayersOutput::next_marker): <p>A pagination token returned when the response doesn't contain all layers.</p>
    ///   - [`layers(Option<Vec<LayersListItem>>)`](crate::output::ListLayersOutput::layers): <p>A list of function layers.</p>
    /// - On failure, responds with [`SdkError<ListLayersError>`](crate::error::ListLayersError)
    pub fn list_layers(&self) -> fluent_builders::ListLayers {
        fluent_builders::ListLayers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLayerVersions`](crate::client::fluent_builders::ListLayerVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLayerVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`compatible_runtime(Runtime)`](crate::client::fluent_builders::ListLayerVersions::compatible_runtime) / [`set_compatible_runtime(Option<Runtime>)`](crate::client::fluent_builders::ListLayerVersions::set_compatible_runtime): <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::ListLayerVersions::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::ListLayerVersions::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListLayerVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListLayerVersions::set_marker): <p>A pagination token returned by a previous call.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListLayerVersions::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListLayerVersions::set_max_items): <p>The maximum number of versions to return.</p>
    ///   - [`compatible_architecture(Architecture)`](crate::client::fluent_builders::ListLayerVersions::compatible_architecture) / [`set_compatible_architecture(Option<Architecture>)`](crate::client::fluent_builders::ListLayerVersions::set_compatible_architecture): <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    /// - On success, responds with [`ListLayerVersionsOutput`](crate::output::ListLayerVersionsOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListLayerVersionsOutput::next_marker): <p>A pagination token returned when the response doesn't contain all versions.</p>
    ///   - [`layer_versions(Option<Vec<LayerVersionsListItem>>)`](crate::output::ListLayerVersionsOutput::layer_versions): <p>A list of versions.</p>
    /// - On failure, responds with [`SdkError<ListLayerVersionsError>`](crate::error::ListLayerVersionsError)
    pub fn list_layer_versions(&self) -> fluent_builders::ListLayerVersions {
        fluent_builders::ListLayerVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProvisionedConcurrencyConfigs`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs::set_max_items): <p>Specify a number to limit the number of configurations returned.</p>
    /// - On success, responds with [`ListProvisionedConcurrencyConfigsOutput`](crate::output::ListProvisionedConcurrencyConfigsOutput) with field(s):
    ///   - [`provisioned_concurrency_configs(Option<Vec<ProvisionedConcurrencyConfigListItem>>)`](crate::output::ListProvisionedConcurrencyConfigsOutput::provisioned_concurrency_configs): <p>A list of provisioned concurrency configurations.</p>
    ///   - [`next_marker(Option<String>)`](crate::output::ListProvisionedConcurrencyConfigsOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    /// - On failure, responds with [`SdkError<ListProvisionedConcurrencyConfigsError>`](crate::error::ListProvisionedConcurrencyConfigsError)
    pub fn list_provisioned_concurrency_configs(
        &self,
    ) -> fluent_builders::ListProvisionedConcurrencyConfigs {
        fluent_builders::ListProvisionedConcurrencyConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTags`](crate::client::fluent_builders::ListTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::ListTags::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::ListTags::set_resource): <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
    /// - On success, responds with [`ListTagsOutput`](crate::output::ListTagsOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsOutput::tags): <p>The function's tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsError>`](crate::error::ListTagsError)
    pub fn list_tags(&self) -> fluent_builders::ListTags {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVersionsByFunction`](crate::client::fluent_builders::ListVersionsByFunction) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVersionsByFunction::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::ListVersionsByFunction::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::ListVersionsByFunction::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::ListVersionsByFunction::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::ListVersionsByFunction::set_marker): <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    ///   - [`max_items(i32)`](crate::client::fluent_builders::ListVersionsByFunction::max_items) / [`set_max_items(Option<i32>)`](crate::client::fluent_builders::ListVersionsByFunction::set_max_items): <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    /// - On success, responds with [`ListVersionsByFunctionOutput`](crate::output::ListVersionsByFunctionOutput) with field(s):
    ///   - [`next_marker(Option<String>)`](crate::output::ListVersionsByFunctionOutput::next_marker): <p>The pagination token that's included if more results are available.</p>
    ///   - [`versions(Option<Vec<FunctionConfiguration>>)`](crate::output::ListVersionsByFunctionOutput::versions): <p>A list of Lambda function versions.</p>
    /// - On failure, responds with [`SdkError<ListVersionsByFunctionError>`](crate::error::ListVersionsByFunctionError)
    pub fn list_versions_by_function(&self) -> fluent_builders::ListVersionsByFunction {
        fluent_builders::ListVersionsByFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishLayerVersion`](crate::client::fluent_builders::PublishLayerVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::PublishLayerVersion::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::PublishLayerVersion::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PublishLayerVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PublishLayerVersion::set_description): <p>The description of the version.</p>
    ///   - [`content(LayerVersionContentInput)`](crate::client::fluent_builders::PublishLayerVersion::content) / [`set_content(Option<LayerVersionContentInput>)`](crate::client::fluent_builders::PublishLayerVersion::set_content): <p>The function layer archive.</p>
    ///   - [`compatible_runtimes(Vec<Runtime>)`](crate::client::fluent_builders::PublishLayerVersion::compatible_runtimes) / [`set_compatible_runtimes(Option<Vec<Runtime>>)`](crate::client::fluent_builders::PublishLayerVersion::set_compatible_runtimes): <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
    ///   - [`license_info(impl Into<String>)`](crate::client::fluent_builders::PublishLayerVersion::license_info) / [`set_license_info(Option<String>)`](crate::client::fluent_builders::PublishLayerVersion::set_license_info): <p>The layer's software license. It can be any of the following:</p>  <ul>   <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>   <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>   <li> <p>The full text of the license.</p> </li>  </ul>
    ///   - [`compatible_architectures(Vec<Architecture>)`](crate::client::fluent_builders::PublishLayerVersion::compatible_architectures) / [`set_compatible_architectures(Option<Vec<Architecture>>)`](crate::client::fluent_builders::PublishLayerVersion::set_compatible_architectures): <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    /// - On success, responds with [`PublishLayerVersionOutput`](crate::output::PublishLayerVersionOutput) with field(s):
    ///   - [`content(Option<LayerVersionContentOutput>)`](crate::output::PublishLayerVersionOutput::content): <p>Details about the layer version.</p>
    ///   - [`layer_arn(Option<String>)`](crate::output::PublishLayerVersionOutput::layer_arn): <p>The ARN of the layer.</p>
    ///   - [`layer_version_arn(Option<String>)`](crate::output::PublishLayerVersionOutput::layer_version_arn): <p>The ARN of the layer version.</p>
    ///   - [`description(Option<String>)`](crate::output::PublishLayerVersionOutput::description): <p>The description of the version.</p>
    ///   - [`created_date(Option<String>)`](crate::output::PublishLayerVersionOutput::created_date): <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`version(i64)`](crate::output::PublishLayerVersionOutput::version): <p>The version number.</p>
    ///   - [`compatible_runtimes(Option<Vec<Runtime>>)`](crate::output::PublishLayerVersionOutput::compatible_runtimes): <p>The layer's compatible runtimes.</p>
    ///   - [`license_info(Option<String>)`](crate::output::PublishLayerVersionOutput::license_info): <p>The layer's software license.</p>
    ///   - [`compatible_architectures(Option<Vec<Architecture>>)`](crate::output::PublishLayerVersionOutput::compatible_architectures): <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    /// - On failure, responds with [`SdkError<PublishLayerVersionError>`](crate::error::PublishLayerVersionError)
    pub fn publish_layer_version(&self) -> fluent_builders::PublishLayerVersion {
        fluent_builders::PublishLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PublishVersion`](crate::client::fluent_builders::PublishVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::PublishVersion::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::PublishVersion::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`code_sha256(impl Into<String>)`](crate::client::fluent_builders::PublishVersion::code_sha256) / [`set_code_sha256(Option<String>)`](crate::client::fluent_builders::PublishVersion::set_code_sha256): <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PublishVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PublishVersion::set_description): <p>A description for the version to override the description in the function configuration.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::PublishVersion::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::PublishVersion::set_revision_id): <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
    /// - On success, responds with [`PublishVersionOutput`](crate::output::PublishVersionOutput) with field(s):
    ///   - [`function_name(Option<String>)`](crate::output::PublishVersionOutput::function_name): <p>The name of the function.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::PublishVersionOutput::function_arn): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`runtime(Option<Runtime>)`](crate::output::PublishVersionOutput::runtime): <p>The runtime environment for the Lambda function.</p>
    ///   - [`role(Option<String>)`](crate::output::PublishVersionOutput::role): <p>The function's execution role.</p>
    ///   - [`handler(Option<String>)`](crate::output::PublishVersionOutput::handler): <p>The function that Lambda calls to begin executing your function.</p>
    ///   - [`code_size(i64)`](crate::output::PublishVersionOutput::code_size): <p>The size of the function's deployment package, in bytes.</p>
    ///   - [`description(Option<String>)`](crate::output::PublishVersionOutput::description): <p>The function's description.</p>
    ///   - [`timeout(Option<i32>)`](crate::output::PublishVersionOutput::timeout): <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    ///   - [`memory_size(Option<i32>)`](crate::output::PublishVersionOutput::memory_size): <p>The amount of memory available to the function at runtime. </p>
    ///   - [`last_modified(Option<String>)`](crate::output::PublishVersionOutput::last_modified): <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`code_sha256(Option<String>)`](crate::output::PublishVersionOutput::code_sha256): <p>The SHA256 hash of the function's deployment package.</p>
    ///   - [`version(Option<String>)`](crate::output::PublishVersionOutput::version): <p>The version of the Lambda function.</p>
    ///   - [`vpc_config(Option<VpcConfigResponse>)`](crate::output::PublishVersionOutput::vpc_config): <p>The function's networking configuration.</p>
    ///   - [`dead_letter_config(Option<DeadLetterConfig>)`](crate::output::PublishVersionOutput::dead_letter_config): <p>The function's dead letter queue.</p>
    ///   - [`environment(Option<EnvironmentResponse>)`](crate::output::PublishVersionOutput::environment): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::PublishVersionOutput::kms_key_arn): <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed key.</p>
    ///   - [`tracing_config(Option<TracingConfigResponse>)`](crate::output::PublishVersionOutput::tracing_config): <p>The function's X-Ray tracing configuration.</p>
    ///   - [`master_arn(Option<String>)`](crate::output::PublishVersionOutput::master_arn): <p>For Lambda@Edge functions, the ARN of the main function.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::PublishVersionOutput::revision_id): <p>The latest updated revision of the function or alias.</p>
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::PublishVersionOutput::layers): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.</p>
    ///   - [`state(Option<State>)`](crate::output::PublishVersionOutput::state): <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::PublishVersionOutput::state_reason): <p>The reason for the function's current state.</p>
    ///   - [`state_reason_code(Option<StateReasonCode>)`](crate::output::PublishVersionOutput::state_reason_code): <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or modify the function.</p>
    ///   - [`last_update_status(Option<LastUpdateStatus>)`](crate::output::PublishVersionOutput::last_update_status): <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>
    ///   - [`last_update_status_reason(Option<String>)`](crate::output::PublishVersionOutput::last_update_status_reason): <p>The reason for the last update that was performed on the function.</p>
    ///   - [`last_update_status_reason_code(Option<LastUpdateStatusReasonCode>)`](crate::output::PublishVersionOutput::last_update_status_reason_code): <p>The reason code for the last update that was performed on the function.</p>
    ///   - [`file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::output::PublishVersionOutput::file_system_configs): <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    ///   - [`package_type(Option<PackageType>)`](crate::output::PublishVersionOutput::package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    ///   - [`image_config_response(Option<ImageConfigResponse>)`](crate::output::PublishVersionOutput::image_config_response): <p>The function's image configuration values.</p>
    ///   - [`signing_profile_version_arn(Option<String>)`](crate::output::PublishVersionOutput::signing_profile_version_arn): <p>The ARN of the signing profile version.</p>
    ///   - [`signing_job_arn(Option<String>)`](crate::output::PublishVersionOutput::signing_job_arn): <p>The ARN of the signing job.</p>
    ///   - [`architectures(Option<Vec<Architecture>>)`](crate::output::PublishVersionOutput::architectures): <p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>
    /// - On failure, responds with [`SdkError<PublishVersionError>`](crate::error::PublishVersionError)
    pub fn publish_version(&self) -> fluent_builders::PublishVersion {
        fluent_builders::PublishVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFunctionCodeSigningConfig`](crate::client::fluent_builders::PutFunctionCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::PutFunctionCodeSigningConfig::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::PutFunctionCodeSigningConfig::set_code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::PutFunctionCodeSigningConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::PutFunctionCodeSigningConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On success, responds with [`PutFunctionCodeSigningConfigOutput`](crate::output::PutFunctionCodeSigningConfigOutput) with field(s):
    ///   - [`code_signing_config_arn(Option<String>)`](crate::output::PutFunctionCodeSigningConfigOutput::code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    ///   - [`function_name(Option<String>)`](crate::output::PutFunctionCodeSigningConfigOutput::function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    /// - On failure, responds with [`SdkError<PutFunctionCodeSigningConfigError>`](crate::error::PutFunctionCodeSigningConfigError)
    pub fn put_function_code_signing_config(
        &self,
    ) -> fluent_builders::PutFunctionCodeSigningConfig {
        fluent_builders::PutFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFunctionConcurrency`](crate::client::fluent_builders::PutFunctionConcurrency) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::PutFunctionConcurrency::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::PutFunctionConcurrency::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`reserved_concurrent_executions(i32)`](crate::client::fluent_builders::PutFunctionConcurrency::reserved_concurrent_executions) / [`set_reserved_concurrent_executions(Option<i32>)`](crate::client::fluent_builders::PutFunctionConcurrency::set_reserved_concurrent_executions): <p>The number of simultaneous executions to reserve for the function.</p>
    /// - On success, responds with [`PutFunctionConcurrencyOutput`](crate::output::PutFunctionConcurrencyOutput) with field(s):
    ///   - [`reserved_concurrent_executions(Option<i32>)`](crate::output::PutFunctionConcurrencyOutput::reserved_concurrent_executions): <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
    /// - On failure, responds with [`SdkError<PutFunctionConcurrencyError>`](crate::error::PutFunctionConcurrencyError)
    pub fn put_function_concurrency(&self) -> fluent_builders::PutFunctionConcurrency {
        fluent_builders::PutFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFunctionEventInvokeConfig`](crate::client::fluent_builders::PutFunctionEventInvokeConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::set_qualifier): <p>A version number or alias name.</p>
    ///   - [`maximum_retry_attempts(i32)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::maximum_retry_attempts) / [`set_maximum_retry_attempts(Option<i32>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::set_maximum_retry_attempts): <p>The maximum number of times to retry when the function returns an error.</p>
    ///   - [`maximum_event_age_in_seconds(i32)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::maximum_event_age_in_seconds) / [`set_maximum_event_age_in_seconds(Option<i32>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::set_maximum_event_age_in_seconds): <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    ///   - [`destination_config(DestinationConfig)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::destination_config) / [`set_destination_config(Option<DestinationConfig>)`](crate::client::fluent_builders::PutFunctionEventInvokeConfig::set_destination_config): <p>A destination for events after they have been sent to a function for processing.</p>  <p class="title"> <b>Destinations</b> </p>  <ul>   <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>   <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>   <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>   <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>  </ul>
    /// - On success, responds with [`PutFunctionEventInvokeConfigOutput`](crate::output::PutFunctionEventInvokeConfigOutput) with field(s):
    ///   - [`last_modified(Option<DateTime>)`](crate::output::PutFunctionEventInvokeConfigOutput::last_modified): <p>The date and time that the configuration was last updated.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::PutFunctionEventInvokeConfigOutput::function_arn): <p>The Amazon Resource Name (ARN) of the function.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::PutFunctionEventInvokeConfigOutput::maximum_retry_attempts): <p>The maximum number of times to retry when the function returns an error.</p>
    ///   - [`maximum_event_age_in_seconds(Option<i32>)`](crate::output::PutFunctionEventInvokeConfigOutput::maximum_event_age_in_seconds): <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::PutFunctionEventInvokeConfigOutput::destination_config): <p>A destination for events after they have been sent to a function for processing.</p>  <p class="title"> <b>Destinations</b> </p>  <ul>   <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>   <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>   <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>   <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<PutFunctionEventInvokeConfigError>`](crate::error::PutFunctionEventInvokeConfigError)
    pub fn put_function_event_invoke_config(
        &self,
    ) -> fluent_builders::PutFunctionEventInvokeConfig {
        fluent_builders::PutFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutProvisionedConcurrencyConfig`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::set_qualifier): <p>The version number or alias name.</p>
    ///   - [`provisioned_concurrent_executions(i32)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::provisioned_concurrent_executions) / [`set_provisioned_concurrent_executions(Option<i32>)`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig::set_provisioned_concurrent_executions): <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
    /// - On success, responds with [`PutProvisionedConcurrencyConfigOutput`](crate::output::PutProvisionedConcurrencyConfigOutput) with field(s):
    ///   - [`requested_provisioned_concurrent_executions(Option<i32>)`](crate::output::PutProvisionedConcurrencyConfigOutput::requested_provisioned_concurrent_executions): <p>The amount of provisioned concurrency requested.</p>
    ///   - [`available_provisioned_concurrent_executions(Option<i32>)`](crate::output::PutProvisionedConcurrencyConfigOutput::available_provisioned_concurrent_executions): <p>The amount of provisioned concurrency available.</p>
    ///   - [`allocated_provisioned_concurrent_executions(Option<i32>)`](crate::output::PutProvisionedConcurrencyConfigOutput::allocated_provisioned_concurrent_executions): <p>The amount of provisioned concurrency allocated.</p>
    ///   - [`status(Option<ProvisionedConcurrencyStatusEnum>)`](crate::output::PutProvisionedConcurrencyConfigOutput::status): <p>The status of the allocation process.</p>
    ///   - [`status_reason(Option<String>)`](crate::output::PutProvisionedConcurrencyConfigOutput::status_reason): <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    ///   - [`last_modified(Option<String>)`](crate::output::PutProvisionedConcurrencyConfigOutput::last_modified): <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    /// - On failure, responds with [`SdkError<PutProvisionedConcurrencyConfigError>`](crate::error::PutProvisionedConcurrencyConfigError)
    pub fn put_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::PutProvisionedConcurrencyConfig {
        fluent_builders::PutProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveLayerVersionPermission`](crate::client::fluent_builders::RemoveLayerVersionPermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`layer_name(impl Into<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::layer_name) / [`set_layer_name(Option<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::set_layer_name): <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    ///   - [`version_number(i64)`](crate::client::fluent_builders::RemoveLayerVersionPermission::version_number) / [`set_version_number(i64)`](crate::client::fluent_builders::RemoveLayerVersionPermission::set_version_number): <p>The version number.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::set_statement_id): <p>The identifier that was specified when the statement was added.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::RemoveLayerVersionPermission::set_revision_id): <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    /// - On success, responds with [`RemoveLayerVersionPermissionOutput`](crate::output::RemoveLayerVersionPermissionOutput)

    /// - On failure, responds with [`SdkError<RemoveLayerVersionPermissionError>`](crate::error::RemoveLayerVersionPermissionError)
    pub fn remove_layer_version_permission(&self) -> fluent_builders::RemoveLayerVersionPermission {
        fluent_builders::RemoveLayerVersionPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemovePermission`](crate::client::fluent_builders::RemovePermission) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`statement_id(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::statement_id) / [`set_statement_id(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_statement_id): <p>Statement ID of the permission to remove.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_qualifier): <p>Specify a version or alias to remove permissions from a published version of the function.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::RemovePermission::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::RemovePermission::set_revision_id): <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    /// - On success, responds with [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)

    /// - On failure, responds with [`SdkError<RemovePermissionError>`](crate::error::RemovePermissionError)
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A list of tags to apply to the function.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource) / [`set_resource(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of tag keys to remove from the function.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAlias`](crate::client::fluent_builders::UpdateAlias) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_name): <p>The name of the alias.</p>
    ///   - [`function_version(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::function_version) / [`set_function_version(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_function_version): <p>The function version that the alias invokes.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_description): <p>A description of the alias.</p>
    ///   - [`routing_config(AliasRoutingConfiguration)`](crate::client::fluent_builders::UpdateAlias::routing_config) / [`set_routing_config(Option<AliasRoutingConfiguration>)`](crate::client::fluent_builders::UpdateAlias::set_routing_config): <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAlias::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateAlias::set_revision_id): <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
    /// - On success, responds with [`UpdateAliasOutput`](crate::output::UpdateAliasOutput) with field(s):
    ///   - [`alias_arn(Option<String>)`](crate::output::UpdateAliasOutput::alias_arn): <p>The Amazon Resource Name (ARN) of the alias.</p>
    ///   - [`name(Option<String>)`](crate::output::UpdateAliasOutput::name): <p>The name of the alias.</p>
    ///   - [`function_version(Option<String>)`](crate::output::UpdateAliasOutput::function_version): <p>The function version that the alias invokes.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateAliasOutput::description): <p>A description of the alias.</p>
    ///   - [`routing_config(Option<AliasRoutingConfiguration>)`](crate::output::UpdateAliasOutput::routing_config): <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing configuration</a> of the alias.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::UpdateAliasOutput::revision_id): <p>A unique identifier that changes when you update the alias.</p>
    /// - On failure, responds with [`SdkError<UpdateAliasError>`](crate::error::UpdateAliasError)
    pub fn update_alias(&self) -> fluent_builders::UpdateAlias {
        fluent_builders::UpdateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCodeSigningConfig`](crate::client::fluent_builders::UpdateCodeSigningConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`code_signing_config_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::code_signing_config_arn) / [`set_code_signing_config_arn(Option<String>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::set_code_signing_config_arn): <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::set_description): <p>Descriptive name for this code signing configuration.</p>
    ///   - [`allowed_publishers(AllowedPublishers)`](crate::client::fluent_builders::UpdateCodeSigningConfig::allowed_publishers) / [`set_allowed_publishers(Option<AllowedPublishers>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::set_allowed_publishers): <p>Signing profiles for this code signing configuration.</p>
    ///   - [`code_signing_policies(CodeSigningPolicies)`](crate::client::fluent_builders::UpdateCodeSigningConfig::code_signing_policies) / [`set_code_signing_policies(Option<CodeSigningPolicies>)`](crate::client::fluent_builders::UpdateCodeSigningConfig::set_code_signing_policies): <p>The code signing policy.</p>
    /// - On success, responds with [`UpdateCodeSigningConfigOutput`](crate::output::UpdateCodeSigningConfigOutput) with field(s):
    ///   - [`code_signing_config(Option<CodeSigningConfig>)`](crate::output::UpdateCodeSigningConfigOutput::code_signing_config): <p>The code signing configuration</p>
    /// - On failure, responds with [`SdkError<UpdateCodeSigningConfigError>`](crate::error::UpdateCodeSigningConfigError)
    pub fn update_code_signing_config(&self) -> fluent_builders::UpdateCodeSigningConfig {
        fluent_builders::UpdateCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEventSourceMapping`](crate::client::fluent_builders::UpdateEventSourceMapping) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`uuid(impl Into<String>)`](crate::client::fluent_builders::UpdateEventSourceMapping::uuid) / [`set_uuid(Option<String>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_uuid): <p>The identifier of the event source mapping.</p>
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEventSourceMapping::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>   <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::UpdateEventSourceMapping::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_enabled): <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>  <p>Default: True</p>
    ///   - [`batch_size(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::batch_size) / [`set_batch_size(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <ul>   <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>   <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>   <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>   <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>  </ul>
    ///   - [`filter_criteria(FilterCriteria)`](crate::client::fluent_builders::UpdateEventSourceMapping::filter_criteria) / [`set_filter_criteria(Option<FilterCriteria>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`maximum_batching_window_in_seconds(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::maximum_batching_window_in_seconds) / [`set_maximum_batching_window_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`destination_config(DestinationConfig)`](crate::client::fluent_builders::UpdateEventSourceMapping::destination_config) / [`set_destination_config(Option<DestinationConfig>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`maximum_record_age_in_seconds(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::maximum_record_age_in_seconds) / [`set_maximum_record_age_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    ///   - [`bisect_batch_on_function_error(bool)`](crate::client::fluent_builders::UpdateEventSourceMapping::bisect_batch_on_function_error) / [`set_bisect_batch_on_function_error(Option<bool>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    ///   - [`maximum_retry_attempts(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::maximum_retry_attempts) / [`set_maximum_retry_attempts(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    ///   - [`parallelization_factor(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::parallelization_factor) / [`set_parallelization_factor(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_parallelization_factor): <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    ///   - [`source_access_configurations(Vec<SourceAccessConfiguration>)`](crate::client::fluent_builders::UpdateEventSourceMapping::source_access_configurations) / [`set_source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_source_access_configurations): <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    ///   - [`tumbling_window_in_seconds(i32)`](crate::client::fluent_builders::UpdateEventSourceMapping::tumbling_window_in_seconds) / [`set_tumbling_window_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    ///   - [`function_response_types(Vec<FunctionResponseType>)`](crate::client::fluent_builders::UpdateEventSourceMapping::function_response_types) / [`set_function_response_types(Option<Vec<FunctionResponseType>>)`](crate::client::fluent_builders::UpdateEventSourceMapping::set_function_response_types): <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    /// - On success, responds with [`UpdateEventSourceMappingOutput`](crate::output::UpdateEventSourceMappingOutput) with field(s):
    ///   - [`uuid(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::uuid): <p>The identifier of the event source mapping.</p>
    ///   - [`starting_position(Option<EventSourcePosition>)`](crate::output::UpdateEventSourceMappingOutput::starting_position): <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis streams.</p>
    ///   - [`starting_position_timestamp(Option<DateTime>)`](crate::output::UpdateEventSourceMappingOutput::starting_position_timestamp): <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    ///   - [`batch_size(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::batch_size): <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>  <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`maximum_batching_window_in_seconds(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::maximum_batching_window_in_seconds): <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>  <p>Default: 0</p>  <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    ///   - [`parallelization_factor(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::parallelization_factor): <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    ///   - [`event_source_arn(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::event_source_arn): <p>The Amazon Resource Name (ARN) of the event source.</p>
    ///   - [`filter_criteria(Option<FilterCriteria>)`](crate::output::UpdateEventSourceMappingOutput::filter_criteria): <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::function_arn): <p>The ARN of the Lambda function.</p>
    ///   - [`last_modified(Option<DateTime>)`](crate::output::UpdateEventSourceMappingOutput::last_modified): <p>The date that the event source mapping was last updated or that its state changed.</p>
    ///   - [`last_processing_result(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::last_processing_result): <p>The result of the last Lambda invocation of your function.</p>
    ///   - [`state(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::state): <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>, <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>, or <code>Deleting</code>.</p>
    ///   - [`state_transition_reason(Option<String>)`](crate::output::UpdateEventSourceMappingOutput::state_transition_reason): <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::UpdateEventSourceMappingOutput::destination_config): <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    ///   - [`topics(Option<Vec<String>>)`](crate::output::UpdateEventSourceMappingOutput::topics): <p>The name of the Kafka topic.</p>
    ///   - [`queues(Option<Vec<String>>)`](crate::output::UpdateEventSourceMappingOutput::queues): <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    ///   - [`source_access_configurations(Option<Vec<SourceAccessConfiguration>>)`](crate::output::UpdateEventSourceMappingOutput::source_access_configurations): <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    ///   - [`self_managed_event_source(Option<SelfManagedEventSource>)`](crate::output::UpdateEventSourceMappingOutput::self_managed_event_source): <p>The self-managed Apache Kafka cluster for your event source.</p>
    ///   - [`maximum_record_age_in_seconds(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::maximum_record_age_in_seconds): <p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records. </p>
    ///   - [`bisect_batch_on_function_error(Option<bool>)`](crate::output::UpdateEventSourceMappingOutput::bisect_batch_on_function_error): <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::maximum_retry_attempts): <p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    ///   - [`tumbling_window_in_seconds(Option<i32>)`](crate::output::UpdateEventSourceMappingOutput::tumbling_window_in_seconds): <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    ///   - [`function_response_types(Option<Vec<FunctionResponseType>>)`](crate::output::UpdateEventSourceMappingOutput::function_response_types): <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    /// - On failure, responds with [`SdkError<UpdateEventSourceMappingError>`](crate::error::UpdateEventSourceMappingError)
    pub fn update_event_source_mapping(&self) -> fluent_builders::UpdateEventSourceMapping {
        fluent_builders::UpdateEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFunctionCode`](crate::client::fluent_builders::UpdateFunctionCode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`zip_file(Blob)`](crate::client::fluent_builders::UpdateFunctionCode::zip_file) / [`set_zip_file(Option<Blob>)`](crate::client::fluent_builders::UpdateFunctionCode::set_zip_file): <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.</p>
    ///   - [`s3_bucket(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::s3_bucket) / [`set_s3_bucket(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_s3_bucket): <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
    ///   - [`s3_key(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::s3_key) / [`set_s3_key(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_s3_key): <p>The Amazon S3 key of the deployment package.</p>
    ///   - [`s3_object_version(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::s3_object_version) / [`set_s3_object_version(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_s3_object_version): <p>For versioned objects, the version of the deployment package object to use.</p>
    ///   - [`image_uri(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::image_uri) / [`set_image_uri(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_image_uri): <p>URI of a container image in the Amazon ECR registry.</p>
    ///   - [`publish(bool)`](crate::client::fluent_builders::UpdateFunctionCode::publish) / [`set_publish(bool)`](crate::client::fluent_builders::UpdateFunctionCode::set_publish): <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::UpdateFunctionCode::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::UpdateFunctionCode::set_dry_run): <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionCode::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateFunctionCode::set_revision_id): <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    ///   - [`architectures(Vec<Architecture>)`](crate::client::fluent_builders::UpdateFunctionCode::architectures) / [`set_architectures(Option<Vec<Architecture>>)`](crate::client::fluent_builders::UpdateFunctionCode::set_architectures): <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    /// - On success, responds with [`UpdateFunctionCodeOutput`](crate::output::UpdateFunctionCodeOutput) with field(s):
    ///   - [`function_name(Option<String>)`](crate::output::UpdateFunctionCodeOutput::function_name): <p>The name of the function.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::UpdateFunctionCodeOutput::function_arn): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`runtime(Option<Runtime>)`](crate::output::UpdateFunctionCodeOutput::runtime): <p>The runtime environment for the Lambda function.</p>
    ///   - [`role(Option<String>)`](crate::output::UpdateFunctionCodeOutput::role): <p>The function's execution role.</p>
    ///   - [`handler(Option<String>)`](crate::output::UpdateFunctionCodeOutput::handler): <p>The function that Lambda calls to begin executing your function.</p>
    ///   - [`code_size(i64)`](crate::output::UpdateFunctionCodeOutput::code_size): <p>The size of the function's deployment package, in bytes.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateFunctionCodeOutput::description): <p>The function's description.</p>
    ///   - [`timeout(Option<i32>)`](crate::output::UpdateFunctionCodeOutput::timeout): <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    ///   - [`memory_size(Option<i32>)`](crate::output::UpdateFunctionCodeOutput::memory_size): <p>The amount of memory available to the function at runtime. </p>
    ///   - [`last_modified(Option<String>)`](crate::output::UpdateFunctionCodeOutput::last_modified): <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`code_sha256(Option<String>)`](crate::output::UpdateFunctionCodeOutput::code_sha256): <p>The SHA256 hash of the function's deployment package.</p>
    ///   - [`version(Option<String>)`](crate::output::UpdateFunctionCodeOutput::version): <p>The version of the Lambda function.</p>
    ///   - [`vpc_config(Option<VpcConfigResponse>)`](crate::output::UpdateFunctionCodeOutput::vpc_config): <p>The function's networking configuration.</p>
    ///   - [`dead_letter_config(Option<DeadLetterConfig>)`](crate::output::UpdateFunctionCodeOutput::dead_letter_config): <p>The function's dead letter queue.</p>
    ///   - [`environment(Option<EnvironmentResponse>)`](crate::output::UpdateFunctionCodeOutput::environment): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::UpdateFunctionCodeOutput::kms_key_arn): <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed key.</p>
    ///   - [`tracing_config(Option<TracingConfigResponse>)`](crate::output::UpdateFunctionCodeOutput::tracing_config): <p>The function's X-Ray tracing configuration.</p>
    ///   - [`master_arn(Option<String>)`](crate::output::UpdateFunctionCodeOutput::master_arn): <p>For Lambda@Edge functions, the ARN of the main function.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::UpdateFunctionCodeOutput::revision_id): <p>The latest updated revision of the function or alias.</p>
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::UpdateFunctionCodeOutput::layers): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.</p>
    ///   - [`state(Option<State>)`](crate::output::UpdateFunctionCodeOutput::state): <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::UpdateFunctionCodeOutput::state_reason): <p>The reason for the function's current state.</p>
    ///   - [`state_reason_code(Option<StateReasonCode>)`](crate::output::UpdateFunctionCodeOutput::state_reason_code): <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or modify the function.</p>
    ///   - [`last_update_status(Option<LastUpdateStatus>)`](crate::output::UpdateFunctionCodeOutput::last_update_status): <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>
    ///   - [`last_update_status_reason(Option<String>)`](crate::output::UpdateFunctionCodeOutput::last_update_status_reason): <p>The reason for the last update that was performed on the function.</p>
    ///   - [`last_update_status_reason_code(Option<LastUpdateStatusReasonCode>)`](crate::output::UpdateFunctionCodeOutput::last_update_status_reason_code): <p>The reason code for the last update that was performed on the function.</p>
    ///   - [`file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::output::UpdateFunctionCodeOutput::file_system_configs): <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    ///   - [`package_type(Option<PackageType>)`](crate::output::UpdateFunctionCodeOutput::package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    ///   - [`image_config_response(Option<ImageConfigResponse>)`](crate::output::UpdateFunctionCodeOutput::image_config_response): <p>The function's image configuration values.</p>
    ///   - [`signing_profile_version_arn(Option<String>)`](crate::output::UpdateFunctionCodeOutput::signing_profile_version_arn): <p>The ARN of the signing profile version.</p>
    ///   - [`signing_job_arn(Option<String>)`](crate::output::UpdateFunctionCodeOutput::signing_job_arn): <p>The ARN of the signing job.</p>
    ///   - [`architectures(Option<Vec<Architecture>>)`](crate::output::UpdateFunctionCodeOutput::architectures): <p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateFunctionCodeError>`](crate::error::UpdateFunctionCodeError)
    pub fn update_function_code(&self) -> fluent_builders::UpdateFunctionCode {
        fluent_builders::UpdateFunctionCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFunctionConfiguration`](crate::client::fluent_builders::UpdateFunctionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_function_name): <p>The name of the Lambda function.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`role(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::role) / [`set_role(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_role): <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    ///   - [`handler(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::handler) / [`set_handler(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_handler): <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_description): <p>A description of the function.</p>
    ///   - [`timeout(i32)`](crate::client::fluent_builders::UpdateFunctionConfiguration::timeout) / [`set_timeout(Option<i32>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_timeout): <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    ///   - [`memory_size(i32)`](crate::client::fluent_builders::UpdateFunctionConfiguration::memory_size) / [`set_memory_size(Option<i32>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_memory_size): <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::UpdateFunctionConfiguration::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_vpc_config): <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    ///   - [`environment(Environment)`](crate::client::fluent_builders::UpdateFunctionConfiguration::environment) / [`set_environment(Option<Environment>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_environment): <p>Environment variables that are accessible from function code during execution.</p>
    ///   - [`runtime(Runtime)`](crate::client::fluent_builders::UpdateFunctionConfiguration::runtime) / [`set_runtime(Option<Runtime>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_runtime): <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    ///   - [`dead_letter_config(DeadLetterConfig)`](crate::client::fluent_builders::UpdateFunctionConfiguration::dead_letter_config) / [`set_dead_letter_config(Option<DeadLetterConfig>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_dead_letter_config): <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    ///   - [`kms_key_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::kms_key_arn) / [`set_kms_key_arn(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_kms_key_arn): <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    ///   - [`tracing_config(TracingConfig)`](crate::client::fluent_builders::UpdateFunctionConfiguration::tracing_config) / [`set_tracing_config(Option<TracingConfig>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_tracing_config): <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_revision_id): <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    ///   - [`layers(Vec<String>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::layers) / [`set_layers(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_layers): <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    ///   - [`file_system_configs(Vec<FileSystemConfig>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::file_system_configs) / [`set_file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_file_system_configs): <p>Connection settings for an Amazon EFS file system.</p>
    ///   - [`image_config(ImageConfig)`](crate::client::fluent_builders::UpdateFunctionConfiguration::image_config) / [`set_image_config(Option<ImageConfig>)`](crate::client::fluent_builders::UpdateFunctionConfiguration::set_image_config): <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
    /// - On success, responds with [`UpdateFunctionConfigurationOutput`](crate::output::UpdateFunctionConfigurationOutput) with field(s):
    ///   - [`function_name(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::function_name): <p>The name of the function.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::function_arn): <p>The function's Amazon Resource Name (ARN).</p>
    ///   - [`runtime(Option<Runtime>)`](crate::output::UpdateFunctionConfigurationOutput::runtime): <p>The runtime environment for the Lambda function.</p>
    ///   - [`role(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::role): <p>The function's execution role.</p>
    ///   - [`handler(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::handler): <p>The function that Lambda calls to begin executing your function.</p>
    ///   - [`code_size(i64)`](crate::output::UpdateFunctionConfigurationOutput::code_size): <p>The size of the function's deployment package, in bytes.</p>
    ///   - [`description(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::description): <p>The function's description.</p>
    ///   - [`timeout(Option<i32>)`](crate::output::UpdateFunctionConfigurationOutput::timeout): <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    ///   - [`memory_size(Option<i32>)`](crate::output::UpdateFunctionConfigurationOutput::memory_size): <p>The amount of memory available to the function at runtime. </p>
    ///   - [`last_modified(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::last_modified): <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    ///   - [`code_sha256(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::code_sha256): <p>The SHA256 hash of the function's deployment package.</p>
    ///   - [`version(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::version): <p>The version of the Lambda function.</p>
    ///   - [`vpc_config(Option<VpcConfigResponse>)`](crate::output::UpdateFunctionConfigurationOutput::vpc_config): <p>The function's networking configuration.</p>
    ///   - [`dead_letter_config(Option<DeadLetterConfig>)`](crate::output::UpdateFunctionConfigurationOutput::dead_letter_config): <p>The function's dead letter queue.</p>
    ///   - [`environment(Option<EnvironmentResponse>)`](crate::output::UpdateFunctionConfigurationOutput::environment): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    ///   - [`kms_key_arn(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::kms_key_arn): <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed key.</p>
    ///   - [`tracing_config(Option<TracingConfigResponse>)`](crate::output::UpdateFunctionConfigurationOutput::tracing_config): <p>The function's X-Ray tracing configuration.</p>
    ///   - [`master_arn(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::master_arn): <p>For Lambda@Edge functions, the ARN of the main function.</p>
    ///   - [`revision_id(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::revision_id): <p>The latest updated revision of the function or alias.</p>
    ///   - [`layers(Option<Vec<Layer>>)`](crate::output::UpdateFunctionConfigurationOutput::layers): <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.</p>
    ///   - [`state(Option<State>)`](crate::output::UpdateFunctionConfigurationOutput::state): <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by invoking it.</p>
    ///   - [`state_reason(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::state_reason): <p>The reason for the function's current state.</p>
    ///   - [`state_reason_code(Option<StateReasonCode>)`](crate::output::UpdateFunctionConfigurationOutput::state_reason_code): <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or modify the function.</p>
    ///   - [`last_update_status(Option<LastUpdateStatus>)`](crate::output::UpdateFunctionConfigurationOutput::last_update_status): <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code> after function creation completes.</p>
    ///   - [`last_update_status_reason(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::last_update_status_reason): <p>The reason for the last update that was performed on the function.</p>
    ///   - [`last_update_status_reason_code(Option<LastUpdateStatusReasonCode>)`](crate::output::UpdateFunctionConfigurationOutput::last_update_status_reason_code): <p>The reason code for the last update that was performed on the function.</p>
    ///   - [`file_system_configs(Option<Vec<FileSystemConfig>>)`](crate::output::UpdateFunctionConfigurationOutput::file_system_configs): <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    ///   - [`package_type(Option<PackageType>)`](crate::output::UpdateFunctionConfigurationOutput::package_type): <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    ///   - [`image_config_response(Option<ImageConfigResponse>)`](crate::output::UpdateFunctionConfigurationOutput::image_config_response): <p>The function's image configuration values.</p>
    ///   - [`signing_profile_version_arn(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::signing_profile_version_arn): <p>The ARN of the signing profile version.</p>
    ///   - [`signing_job_arn(Option<String>)`](crate::output::UpdateFunctionConfigurationOutput::signing_job_arn): <p>The ARN of the signing job.</p>
    ///   - [`architectures(Option<Vec<Architecture>>)`](crate::output::UpdateFunctionConfigurationOutput::architectures): <p>The instruction set architecture that the function supports. Architecture is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateFunctionConfigurationError>`](crate::error::UpdateFunctionConfigurationError)
    pub fn update_function_configuration(&self) -> fluent_builders::UpdateFunctionConfiguration {
        fluent_builders::UpdateFunctionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFunctionEventInvokeConfig`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`function_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::function_name) / [`set_function_name(Option<String>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::set_function_name): <p>The name of the Lambda function, version, or alias.</p>  <p class="title"> <b>Name formats</b> </p>  <ul>   <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>   <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>   <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>  </ul>  <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    ///   - [`qualifier(impl Into<String>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::qualifier) / [`set_qualifier(Option<String>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::set_qualifier): <p>A version number or alias name.</p>
    ///   - [`maximum_retry_attempts(i32)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::maximum_retry_attempts) / [`set_maximum_retry_attempts(Option<i32>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::set_maximum_retry_attempts): <p>The maximum number of times to retry when the function returns an error.</p>
    ///   - [`maximum_event_age_in_seconds(i32)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::maximum_event_age_in_seconds) / [`set_maximum_event_age_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::set_maximum_event_age_in_seconds): <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    ///   - [`destination_config(DestinationConfig)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::destination_config) / [`set_destination_config(Option<DestinationConfig>)`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig::set_destination_config): <p>A destination for events after they have been sent to a function for processing.</p>  <p class="title"> <b>Destinations</b> </p>  <ul>   <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>   <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>   <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>   <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>  </ul>
    /// - On success, responds with [`UpdateFunctionEventInvokeConfigOutput`](crate::output::UpdateFunctionEventInvokeConfigOutput) with field(s):
    ///   - [`last_modified(Option<DateTime>)`](crate::output::UpdateFunctionEventInvokeConfigOutput::last_modified): <p>The date and time that the configuration was last updated.</p>
    ///   - [`function_arn(Option<String>)`](crate::output::UpdateFunctionEventInvokeConfigOutput::function_arn): <p>The Amazon Resource Name (ARN) of the function.</p>
    ///   - [`maximum_retry_attempts(Option<i32>)`](crate::output::UpdateFunctionEventInvokeConfigOutput::maximum_retry_attempts): <p>The maximum number of times to retry when the function returns an error.</p>
    ///   - [`maximum_event_age_in_seconds(Option<i32>)`](crate::output::UpdateFunctionEventInvokeConfigOutput::maximum_event_age_in_seconds): <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    ///   - [`destination_config(Option<DestinationConfig>)`](crate::output::UpdateFunctionEventInvokeConfigOutput::destination_config): <p>A destination for events after they have been sent to a function for processing.</p>  <p class="title"> <b>Destinations</b> </p>  <ul>   <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>   <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>   <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>   <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<UpdateFunctionEventInvokeConfigError>`](crate::error::UpdateFunctionEventInvokeConfigError)
    pub fn update_function_event_invoke_config(
        &self,
    ) -> fluent_builders::UpdateFunctionEventInvokeConfig {
        fluent_builders::UpdateFunctionEventInvokeConfig::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddLayerVersionPermission`.
    ///
    /// <p>Adds permissions to the resource-based policy of a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts. </p>
    /// <p>To revoke permission, call <code>RemoveLayerVersionPermission</code> with the statement ID that you specified when you added it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddLayerVersionPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_layer_version_permission_input::Builder,
    }
    impl AddLayerVersionPermission {
        /// Creates a new `AddLayerVersionPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddLayerVersionPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddLayerVersionPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(input.into());
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddPermission`.
    ///
    /// <p>Grants an Amazon Web Services service or another account permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding policies to version $LATEST.</p>
    /// <p>To grant permission to another account, specify the account ID as the <code>Principal</code>. For Amazon Web Services services, the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services services, you can also specify the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.</p>
    /// <p>This action adds a statement to a resource-based permissions policy for the function. For more information about function policies, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function Policies</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_permission_input::Builder,
    }
    impl AddPermission {
        /// Creates a new `AddPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_account(input.into());
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_account(input);
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn event_source_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_token(input.into());
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn set_event_source_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_token(input);
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.</p>
    /// <p>You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code> parameter to specify a second version and the percentage of invocation requests that it receives.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl CreateAlias {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.inner = self.inner.routing_config(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_routing_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCodeSigningConfig`.
    ///
    /// <p>Creates a code signing configuration. A <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html">code signing configuration</a> defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment validation checks fail). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_code_signing_config_input::Builder,
    }
    impl CreateCodeSigningConfig {
        /// Creates a new `CreateCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, input: crate::model::AllowedPublishers) -> Self {
            self.inner = self.inner.allowed_publishers(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.inner = self.inner.set_allowed_publishers(input);
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn code_signing_policies(mut self, input: crate::model::CodeSigningPolicies) -> Self {
            self.inner = self.inner.code_signing_policies(input);
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSourceMapping`.
    ///
    /// <p>Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and triggers the function.</p>
    /// <p>For details about how to configure different event sources, see the following topics. </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon DynamoDB Streams</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping"> Amazon Kinesis</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and RabbitMQ</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a> </p> </li>
    /// </ul>
    /// <p>The following error handling options are only available for stream sources (DynamoDB and Kinesis):</p>
    /// <ul>
    /// <li> <p> <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.</p> </li>
    /// <li> <p> <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p> </li>
    /// <li> <p> <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p> </li>
    /// <li> <p> <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p> </li>
    /// <li> <p> <code>ParallelizationFactor</code> - Process multiple batches from each shard concurrently.</p> </li>
    /// </ul>
    /// <p>For information about which configuration parameters apply to each event source, see the following topics.</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB Streams</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon Kinesis</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and RabbitMQ</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventSourceMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_source_mapping_input::Builder,
    }
    impl CreateEventSourceMapping {
        /// Creates a new `CreateEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSourceMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.batch_size(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_batch_size(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.parallelization_factor(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_parallelization_factor(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.inner = self.inner.starting_position(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.inner = self.inner.set_starting_position(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.starting_position_timestamp(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_starting_position_timestamp(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.inner = self.inner.bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.tumbling_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_tumbling_window_in_seconds(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topics(input.into());
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// Appends an item to `Queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queues(input.into());
            self
        }
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_queues(input);
            self
        }
        /// Appends an item to `SourceAccessConfigurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: crate::model::SourceAccessConfiguration,
        ) -> Self {
            self.inner = self.inner.source_access_configurations(input);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_source_access_configurations(input);
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.inner = self.inner.self_managed_event_source(input);
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.inner = self.inner.set_self_managed_event_source(input);
            self
        }
        /// Appends an item to `FunctionResponseTypes`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: crate::model::FunctionResponseType,
        ) -> Self {
            self.inner = self.inner.function_response_types(input);
            self
        }
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.inner = self.inner.set_function_response_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a Lambda function. To create a function, you need a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">execution role</a>. The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.</p>
    /// <p>You set the package type to <code>Image</code> if the deployment package is a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>. For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties. </p>
    /// <p>You set the package type to <code>Zip</code> if the deployment package is a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip file archive</a>. For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in the deployment package must be compatible with the target instruction set architecture of the function (<code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, the default value is <code>x86-64</code>.</p>
    /// <p>When you create a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the response from <code>GetFunctionConfiguration</code> indicate when the function is ready to invoke. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function States</a>.</p>
    /// <p>A function has an unpublished version, and can have published versions and aliases. The unpublished version changes when you update your function's code and configuration. A published version is a snapshot of your function code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be changed to map to a different version. Use the <code>Publish</code> parameter to create version <code>1</code> of your function from its initial configuration.</p>
    /// <p>The other parameters let you configure version-specific and function-level settings. You can modify version-specific settings later with <code>UpdateFunctionConfiguration</code>. Function-level settings apply to both the unpublished and published versions of the function, and include tags (<code>TagResource</code>) and per-function concurrency limits (<code>PutFunctionConcurrency</code>).</p>
    /// <p>You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with <code>UpdateFunctionCode</code>, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes set set of signing profiles, which define the trusted publishers for this function.</p>
    /// <p>If another account or an Amazon Web Services service invokes your function, use <code>AddPermission</code> to grant permission by creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an alias.</p>
    /// <p>To invoke your function directly, use <code>Invoke</code>. To invoke your function in response to events in other Amazon Web Services services, create an event source mapping (<code>CreateEventSourceMapping</code>), or configure a function trigger in the other service. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Functions</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_function_input::Builder,
    }
    impl CreateFunction {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.inner = self.inner.runtime(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.inner = self.inner.set_runtime(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handler(input.into());
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handler(input);
            self
        }
        /// <p>The code for the function.</p>
        pub fn code(mut self, input: crate::model::FunctionCode) -> Self {
            self.inner = self.inner.code(input);
            self
        }
        /// <p>The code for the function.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::FunctionCode>) -> Self {
            self.inner = self.inner.set_code(input);
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.inner = self.inner.memory_size(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_memory_size(input);
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn publish(mut self, input: bool) -> Self {
            self.inner = self.inner.publish(input);
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publish(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.inner = self.inner.dead_letter_config(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_config(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfig) -> Self {
            self.inner = self.inner.tracing_config(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.inner = self.inner.set_tracing_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layers(input.into());
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layers(input);
            self
        }
        /// Appends an item to `FileSystemConfigs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(mut self, input: crate::model::FileSystemConfig) -> Self {
            self.inner = self.inner.file_system_configs(input);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_configs(input);
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
        pub fn image_config(mut self, input: crate::model::ImageConfig) -> Self {
            self.inner = self.inner.image_config(input);
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.inner = self.inner.set_image_config(input);
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// Appends an item to `Architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.architectures(input);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlias`.
    ///
    /// <p>Deletes a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_alias_input::Builder,
    }
    impl DeleteAlias {
        /// Creates a new `DeleteAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCodeSigningConfig`.
    ///
    /// <p>Deletes the code signing configuration. You can delete the code signing configuration only if no function is using it. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_code_signing_config_input::Builder,
    }
    impl DeleteCodeSigningConfig {
        /// Creates a new `DeleteCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSourceMapping`.
    ///
    /// <p>Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source mapping</a>. You can get the identifier of a mapping from the output of <code>ListEventSourceMappings</code>.</p>
    /// <p>When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely deleted for several seconds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventSourceMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_source_mapping_input::Builder,
    }
    impl DeleteEventSourceMapping {
        /// Creates a new `DeleteEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSourceMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter. Otherwise, all versions and aliases are deleted.</p>
    /// <p>To delete Lambda event source mappings that invoke a function, use <code>DeleteEventSourceMapping</code>. For Amazon Web Services services and resources that invoke your function directly, delete the trigger in the service where you originally configured it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl DeleteFunction {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionCodeSigningConfig`.
    ///
    /// <p>Removes the code signing configuration from the function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunctionCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_code_signing_config_input::Builder,
    }
    impl DeleteFunctionCodeSigningConfig {
        /// Creates a new `DeleteFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionConcurrency`.
    ///
    /// <p>Removes a concurrent execution limit from a function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunctionConcurrency {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_concurrency_input::Builder,
    }
    impl DeleteFunctionConcurrency {
        /// Creates a new `DeleteFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionConcurrencyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionEventInvokeConfig`.
    ///
    /// <p>Deletes the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <code>PutFunctionEventInvokeConfig</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunctionEventInvokeConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_event_invoke_config_input::Builder,
    }
    impl DeleteFunctionEventInvokeConfig {
        /// Creates a new `DeleteFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionEventInvokeConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLayerVersion`.
    ///
    /// <p>Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of the version remains in Lambda until no functions refer to it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLayerVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_layer_version_input::Builder,
    }
    impl DeleteLayerVersion {
        /// Creates a new `DeleteLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLayerVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisionedConcurrencyConfig`.
    ///
    /// <p>Deletes the provisioned concurrency configuration for a function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProvisionedConcurrencyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_provisioned_concurrency_config_input::Builder,
    }
    impl DeleteProvisionedConcurrencyConfig {
        /// Creates a new `DeleteProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteProvisionedConcurrencyConfigError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Retrieves details about your account's <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl GetAccountSettings {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAlias`.
    ///
    /// <p>Returns details about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_alias_input::Builder,
    }
    impl GetAlias {
        /// Creates a new `GetAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCodeSigningConfig`.
    ///
    /// <p>Returns information about the specified code signing configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_code_signing_config_input::Builder,
    }
    impl GetCodeSigningConfig {
        /// Creates a new `GetCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventSourceMapping`.
    ///
    /// <p>Returns details about an event source mapping. You can get the identifier of a mapping from the output of <code>ListEventSourceMappings</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEventSourceMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_event_source_mapping_input::Builder,
    }
    impl GetEventSourceMapping {
        /// Creates a new `GetEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventSourceMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Returns information about the function or function version, with a link to download the deployment package that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_input::Builder,
    }
    impl GetFunction {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionCodeSigningConfig`.
    ///
    /// <p>Returns the code signing configuration for the specified function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunctionCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_code_signing_config_input::Builder,
    }
    impl GetFunctionCodeSigningConfig {
        /// Creates a new `GetFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionConcurrency`.
    ///
    /// <p>Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a function, use <code>PutFunctionConcurrency</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunctionConcurrency {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_concurrency_input::Builder,
    }
    impl GetFunctionConcurrency {
        /// Creates a new `GetFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionConcurrencyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionConfiguration`.
    ///
    /// <p>Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use <code>UpdateFunctionConfiguration</code>.</p>
    /// <p>To get all of a function's details, including function-level settings, use <code>GetFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunctionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_configuration_input::Builder,
    }
    impl GetFunctionConfiguration {
        /// Creates a new `GetFunctionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionEventInvokeConfig`.
    ///
    /// <p>Retrieves the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <code>PutFunctionEventInvokeConfig</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunctionEventInvokeConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_event_invoke_config_input::Builder,
    }
    impl GetFunctionEventInvokeConfig {
        /// Creates a new `GetFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionEventInvokeConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersion`.
    ///
    /// <p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to download the layer archive that's valid for 10 minutes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLayerVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_layer_version_input::Builder,
    }
    impl GetLayerVersion {
        /// Creates a new `GetLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersionByArn`.
    ///
    /// <p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to download the layer archive that's valid for 10 minutes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLayerVersionByArn {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_layer_version_by_arn_input::Builder,
    }
    impl GetLayerVersionByArn {
        /// Creates a new `GetLayerVersionByArn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionByArnOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionByArnError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the layer version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersionPolicy`.
    ///
    /// <p>Returns the permission policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more information, see <code>AddLayerVersionPermission</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLayerVersionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_layer_version_policy_input::Builder,
    }
    impl GetLayerVersionPolicy {
        /// Creates a new `GetLayerVersionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Returns the <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM policy</a> for a function, version, or alias.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl GetPolicy {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProvisionedConcurrencyConfig`.
    ///
    /// <p>Retrieves the provisioned concurrency configuration for a function's alias or version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProvisionedConcurrencyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_provisioned_concurrency_config_input::Builder,
    }
    impl GetProvisionedConcurrencyConfig {
        /// Creates a new `GetProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProvisionedConcurrencyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Invoke`.
    ///
    /// <p>Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>, details about the function response, including errors, are included in the response body and headers. For either invocation type, you can find more information in the <a href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.</p>
    /// <p>When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error, Lambda executes the function up to two more times. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html">Retry Behavior</a>.</p>
    /// <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>, Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple times, even if no error occurs. To retain events that were not processed, configure your function with a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">dead-letter queue</a>.</p>
    /// <p>The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that prevent your function from executing, such as permissions errors, <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if executing the function would cause you to exceed a concurrency limit at either the account level (<code>ConcurrentInvocationLimitExceeded</code>) or function level (<code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).</p>
    /// <p>For functions with a long timeout, your client might be disconnected during synchronous invocation while it waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections with timeout or keep-alive settings.</p>
    /// <p>This operation requires permission for the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Invoke {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::invoke_input::Builder,
    }
    impl Invoke {
        /// Creates a new `Invoke`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvokeOutput,
            aws_smithy_http::result::SdkError<crate::error::InvokeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
        /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
        /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
        /// </ul>
        pub fn invocation_type(mut self, input: crate::model::InvocationType) -> Self {
            self.inner = self.inner.invocation_type(input);
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
        /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
        /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
        /// </ul>
        pub fn set_invocation_type(
            mut self,
            input: std::option::Option<crate::model::InvocationType>,
        ) -> Self {
            self.inner = self.inner.set_invocation_type(input);
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.inner = self.inner.log_type(input);
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.inner = self.inner.set_log_type(input);
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
        pub fn client_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_context(input.into());
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_context(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.payload(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_payload(input);
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InvokeAsync`.
    ///
    /// <important>
    /// <p>For asynchronous function invocation, use <code>Invoke</code>.</p>
    /// </important>
    /// <p>Invokes a function asynchronously.</p>
    #[derive(std::fmt::Debug)]
    pub struct InvokeAsync {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::invoke_async_input::Builder,
    }
    impl InvokeAsync {
        /// Creates a new `InvokeAsync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvokeAsyncOutput,
            aws_smithy_http::result::SdkError<crate::error::InvokeAsyncError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn invoke_args(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.invoke_args(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn set_invoke_args(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_invoke_args(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAliases`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for a Lambda function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAliases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_aliases_input::Builder,
    }
    impl ListAliases {
        /// Creates a new `ListAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAliasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAliasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAliasesPaginator {
            crate::paginator::ListAliasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(input.into());
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCodeSigningConfigs`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the <code>MaxItems</code> parameter to return fewer configurations per call. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCodeSigningConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_code_signing_configs_input::Builder,
    }
    impl ListCodeSigningConfigs {
        /// Creates a new `ListCodeSigningConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCodeSigningConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCodeSigningConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCodeSigningConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListCodeSigningConfigsPaginator {
            crate::paginator::ListCodeSigningConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSourceMappings`.
    ///
    /// <p>Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a single event source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventSourceMappings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_source_mappings_input::Builder,
    }
    impl ListEventSourceMappings {
        /// Creates a new `ListEventSourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSourceMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSourceMappingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventSourceMappingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventSourceMappingsPaginator {
            crate::paginator::ListEventSourceMappingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionEventInvokeConfigs`.
    ///
    /// <p>Retrieves a list of configurations for asynchronous invocation for a function.</p>
    /// <p>To configure options for asynchronous invocation, use <code>PutFunctionEventInvokeConfig</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFunctionEventInvokeConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_function_event_invoke_configs_input::Builder,
    }
    impl ListFunctionEventInvokeConfigs {
        /// Creates a new `ListFunctionEventInvokeConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionEventInvokeConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionEventInvokeConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFunctionEventInvokeConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFunctionEventInvokeConfigsPaginator {
            crate::paginator::ListFunctionEventInvokeConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.</p>
    /// <p>Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in addition to the unpublished version. </p> <note>
    /// <p>The <code>ListFunctions</code> action returns a subset of the <code>FunctionConfiguration</code> fields. To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode) for a function or version, use <code>GetFunction</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFunctions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl ListFunctions {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFunctionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFunctionsPaginator {
            crate::paginator::ListFunctionsPaginator::new(self.handle, self.inner)
        }
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn master_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_region(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn set_master_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_region(input);
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn function_version(mut self, input: crate::model::FunctionVersion) -> Self {
            self.inner = self.inner.function_version(input);
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<crate::model::FunctionVersion>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionsByCodeSigningConfig`.
    ///
    /// <p>List the functions that use the specified code signing configuration. You can use this method prior to deleting a code signing configuration, to verify that no functions are using it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFunctionsByCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_functions_by_code_signing_config_input::Builder,
    }
    impl ListFunctionsByCodeSigningConfig {
        /// Creates a new `ListFunctionsByCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsByCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsByCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFunctionsByCodeSigningConfigPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFunctionsByCodeSigningConfigPaginator {
            crate::paginator::ListFunctionsByCodeSigningConfigPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLayers`.
    ///
    /// <p>Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows information about the latest version of each. Specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layers that are compatible with that <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLayers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_layers_input::Builder,
    }
    impl ListLayers {
        /// Creates a new `ListLayers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLayersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLayersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLayersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLayersPaginator {
            crate::paginator::ListLayersPaginator::new(self.handle, self.inner)
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, input: crate::model::Runtime) -> Self {
            self.inner = self.inner.compatible_runtime(input);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtime(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.compatible_architecture(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architecture(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLayerVersions`.
    ///
    /// <p>Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only layer versions that are compatible with that architecture.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLayerVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_layer_versions_input::Builder,
    }
    impl ListLayerVersions {
        /// Creates a new `ListLayerVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLayerVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLayerVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLayerVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLayerVersionsPaginator {
            crate::paginator::ListLayerVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, input: crate::model::Runtime) -> Self {
            self.inner = self.inner.compatible_runtime(input);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtime(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.compatible_architecture(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architecture(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisionedConcurrencyConfigs`.
    ///
    /// <p>Retrieves a list of provisioned concurrency configurations for a function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProvisionedConcurrencyConfigs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_provisioned_concurrency_configs_input::Builder,
    }
    impl ListProvisionedConcurrencyConfigs {
        /// Creates a new `ListProvisionedConcurrencyConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisionedConcurrencyConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisionedConcurrencyConfigsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProvisionedConcurrencyConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListProvisionedConcurrencyConfigsPaginator {
            crate::paginator::ListProvisionedConcurrencyConfigsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also view tags with <code>GetFunction</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl ListTags {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVersionsByFunction`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>, with the version-specific configuration of each. Lambda returns up to 50 versions per call.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVersionsByFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_versions_by_function_input::Builder,
    }
    impl ListVersionsByFunction {
        /// Creates a new `ListVersionsByFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVersionsByFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVersionsByFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVersionsByFunctionPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVersionsByFunctionPaginator {
            crate::paginator::ListVersionsByFunctionPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.inner = self.inner.max_items(input);
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishLayerVersion`.
    ///
    /// <p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is created.</p>
    /// <p>Add layers to your function with <code>CreateFunction</code> or <code>UpdateFunctionConfiguration</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishLayerVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_layer_version_input::Builder,
    }
    impl PublishLayerVersion {
        /// Creates a new `PublishLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishLayerVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The function layer archive.</p>
        pub fn content(mut self, input: crate::model::LayerVersionContentInput) -> Self {
            self.inner = self.inner.content(input);
            self
        }
        /// <p>The function layer archive.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentInput>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `CompatibleRuntimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
        pub fn compatible_runtimes(mut self, input: crate::model::Runtime) -> Self {
            self.inner = self.inner.compatible_runtimes(input);
            self
        }
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtimes(input);
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
        /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
        /// <li> <p>The full text of the license.</p> </li>
        /// </ul>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_info(input.into());
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
        /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
        /// <li> <p>The full text of the license.</p> </li>
        /// </ul>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_info(input);
            self
        }
        /// Appends an item to `CompatibleArchitectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.compatible_architectures(input);
            self
        }
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishVersion`.
    ///
    /// <p>Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.</p>
    /// <p>Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version. Use <code>UpdateFunctionCode</code> or <code>UpdateFunctionConfiguration</code> to update the function before publishing a version.</p>
    /// <p>Clients can invoke versions directly or with an alias. To create an alias, use <code>CreateAlias</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PublishVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::publish_version_input::Builder,
    }
    impl PublishVersion {
        /// Creates a new `PublishVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_sha256(input.into());
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_code_sha256(input);
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionCodeSigningConfig`.
    ///
    /// <p>Update the code signing configuration for the function. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFunctionCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_function_code_signing_config_input::Builder,
    }
    impl PutFunctionCodeSigningConfig {
        /// Creates a new `PutFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionConcurrency`.
    ///
    /// <p>Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency level.</p>
    /// <p>Concurrency settings apply to the function as a whole, including all published versions and the unpublished version. Reserving concurrency both ensures that your function has capacity to process the specified number of events simultaneously, and prevents it from scaling beyond that level. Use <code>GetFunction</code> to see the current setting for a function.</p>
    /// <p>Use <code>GetAccountSettings</code> to see your Regional concurrency limit. You can reserve concurrency for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that aren't configured with a per-function limit. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFunctionConcurrency {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_function_concurrency_input::Builder,
    }
    impl PutFunctionConcurrency {
        /// Creates a new `PutFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionConcurrencyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn reserved_concurrent_executions(mut self, input: i32) -> Self {
            self.inner = self.inner.reserved_concurrent_executions(input);
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_reserved_concurrent_executions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionEventInvokeConfig`.
    ///
    /// <p>Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without affecting existing settings for other options, use <code>UpdateFunctionEventInvokeConfig</code>.</p>
    /// <p>By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with <code>UpdateFunctionConfiguration</code>.</p>
    /// <p>To send an invocation record to a queue, topic, function, or event bus, specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations">destination</a>. You can configure separate destinations for successful invocations (on-success) and events that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a dead-letter queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFunctionEventInvokeConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_function_event_invoke_config_input::Builder,
    }
    impl PutFunctionEventInvokeConfig {
        /// Creates a new `PutFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionEventInvokeConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_event_age_in_seconds(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_event_age_in_seconds(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProvisionedConcurrencyConfig`.
    ///
    /// <p>Adds a provisioned concurrency configuration to a function's alias or version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProvisionedConcurrencyConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_provisioned_concurrency_config_input::Builder,
    }
    impl PutProvisionedConcurrencyConfig {
        /// Creates a new `PutProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProvisionedConcurrencyConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.inner = self.inner.provisioned_concurrent_executions(input);
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn set_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_concurrent_executions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveLayerVersionPermission`.
    ///
    /// <p>Removes a statement from the permissions policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more information, see <code>AddLayerVersionPermission</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveLayerVersionPermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_layer_version_permission_input::Builder,
    }
    impl RemoveLayerVersionPermission {
        /// Creates a new `RemoveLayerVersionPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveLayerVersionPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveLayerVersionPermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.inner = self.inner.version_number(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p>Revokes function-use permission from an Amazon Web Services service or another account. You can get the ID of the statement from the output of <code>GetPolicy</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemovePermission {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl RemovePermission {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A list of tags to apply to the function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAlias`.
    ///
    /// <p>Updates the configuration of a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAlias {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_alias_input::Builder,
    }
    impl UpdateAlias {
        /// Creates a new `UpdateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAliasError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.inner = self.inner.routing_config(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_routing_config(input);
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCodeSigningConfig`.
    ///
    /// <p>Update the code signing configuration. Changes to the code signing configuration take effect the next time a user tries to deploy a code package to the function. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCodeSigningConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_code_signing_config_input::Builder,
    }
    impl UpdateCodeSigningConfig {
        /// Creates a new `UpdateCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCodeSigningConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, input: crate::model::AllowedPublishers) -> Self {
            self.inner = self.inner.allowed_publishers(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.inner = self.inner.set_allowed_publishers(input);
            self
        }
        /// <p>The code signing policy.</p>
        pub fn code_signing_policies(mut self, input: crate::model::CodeSigningPolicies) -> Self {
            self.inner = self.inner.code_signing_policies(input);
            self
        }
        /// <p>The code signing policy.</p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventSourceMapping`.
    ///
    /// <p>Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.</p>
    /// <p>For details about how to configure different event sources, see the following topics. </p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon DynamoDB Streams</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping"> Amazon Kinesis</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and RabbitMQ</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a> </p> </li>
    /// </ul>
    /// <p>The following error handling options are only available for stream sources (DynamoDB and Kinesis):</p>
    /// <ul>
    /// <li> <p> <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.</p> </li>
    /// <li> <p> <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p> </li>
    /// <li> <p> <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p> </li>
    /// <li> <p> <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p> </li>
    /// <li> <p> <code>ParallelizationFactor</code> - Process multiple batches from each shard concurrently.</p> </li>
    /// </ul>
    /// <p>For information about which configuration parameters apply to each event source, see the following topics.</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB Streams</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon Kinesis</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and RabbitMQ</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEventSourceMapping {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_event_source_mapping_input::Builder,
    }
    impl UpdateEventSourceMapping {
        /// Creates a new `UpdateEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventSourceMappingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.batch_size(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_batch_size(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.inner = self.inner.bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.inner = self.inner.parallelization_factor(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_parallelization_factor(input);
            self
        }
        /// Appends an item to `SourceAccessConfigurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: crate::model::SourceAccessConfiguration,
        ) -> Self {
            self.inner = self.inner.source_access_configurations(input);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_source_access_configurations(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.tumbling_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_tumbling_window_in_seconds(input);
            self
        }
        /// Appends an item to `FunctionResponseTypes`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: crate::model::FunctionResponseType,
        ) -> Self {
            self.inner = self.inner.function_response_types(input);
            self
        }
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.inner = self.inner.set_function_response_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionCode`.
    ///
    /// <p>Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by a trusted publisher. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html">Configuring code signing</a>.</p>
    /// <p>The function's code is locked when you publish a version. You can't modify the code of a published version, only the unpublished version.</p> <note>
    /// <p>For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if you update the image tag to a new image, Lambda does not automatically update the function.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFunctionCode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_function_code_input::Builder,
    }
    impl UpdateFunctionCode {
        /// Creates a new `UpdateFunctionCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionCodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.zip_file(input);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_zip_file(input);
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(input.into());
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key(input.into());
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_key(input);
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_object_version(input.into());
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn set_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_object_version(input);
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_uri(input.into());
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_uri(input);
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
        pub fn publish(mut self, input: bool) -> Self {
            self.inner = self.inner.publish(input);
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publish(input);
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// Appends an item to `Architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: crate::model::Architecture) -> Self {
            self.inner = self.inner.architectures(input);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionConfiguration`.
    ///
    /// <p>Modify the version-specific settings of a Lambda function.</p>
    /// <p>When you update a function, Lambda provisions an instance of the function and its supporting resources. If your function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and <code>LastUpdateStatusReasonCode</code> fields in the response from <code>GetFunctionConfiguration</code> indicate when the update is complete and the function is processing events with the new configuration. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function States</a>.</p>
    /// <p>These settings can vary between versions of a function and are locked when you publish a version. You can't modify the configuration of a published version, only the unpublished version.</p>
    /// <p>To configure function concurrency, use <code>PutFunctionConcurrency</code>. To grant invoke permissions to an account or Amazon Web Services service, use <code>AddPermission</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFunctionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_function_configuration_input::Builder,
    }
    impl UpdateFunctionConfiguration {
        /// Creates a new `UpdateFunctionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handler(input.into());
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handler(input);
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.inner = self.inner.memory_size(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_memory_size(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.inner = self.inner.runtime(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.inner = self.inner.set_runtime(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.inner = self.inner.dead_letter_config(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_config(input);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfig) -> Self {
            self.inner = self.inner.tracing_config(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.inner = self.inner.set_tracing_config(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// Appends an item to `Layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layers(input.into());
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layers(input);
            self
        }
        /// Appends an item to `FileSystemConfigs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(mut self, input: crate::model::FileSystemConfig) -> Self {
            self.inner = self.inner.file_system_configs(input);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_configs(input);
            self
        }
        /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
        pub fn image_config(mut self, input: crate::model::ImageConfig) -> Self {
            self.inner = self.inner.image_config(input);
            self
        }
        /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.inner = self.inner.set_image_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionEventInvokeConfig`.
    ///
    /// <p>Updates the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <code>PutFunctionEventInvokeConfig</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFunctionEventInvokeConfig {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_function_event_invoke_config_input::Builder,
    }
    impl UpdateFunctionEventInvokeConfig {
        /// Creates a new `UpdateFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionEventInvokeConfigError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_event_age_in_seconds(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_event_age_in_seconds(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
