// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddLayerVersionPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddLayerVersionPermissionError {
    /// Kind of error that occurred.
    pub kind: AddLayerVersionPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddLayerVersionPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddLayerVersionPermissionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The permissions policy for the resource is too large. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    PolicyLengthExceededException(crate::error::PolicyLengthExceededException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddLayerVersionPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddLayerVersionPermissionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            AddLayerVersionPermissionErrorKind::PolicyLengthExceededException(_inner) => {
                _inner.fmt(f)
            }
            AddLayerVersionPermissionErrorKind::PreconditionFailedException(_inner) => {
                _inner.fmt(f)
            }
            AddLayerVersionPermissionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AddLayerVersionPermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddLayerVersionPermissionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AddLayerVersionPermissionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddLayerVersionPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddLayerVersionPermissionError {
    fn code(&self) -> Option<&str> {
        AddLayerVersionPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddLayerVersionPermissionError {
    /// Creates a new `AddLayerVersionPermissionError`.
    pub fn new(kind: AddLayerVersionPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddLayerVersionPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddLayerVersionPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddLayerVersionPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddLayerVersionPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::PolicyLengthExceededException`.
    pub fn is_policy_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::PolicyLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AddLayerVersionPermissionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddLayerVersionPermissionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddLayerVersionPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddLayerVersionPermissionErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            AddLayerVersionPermissionErrorKind::PolicyLengthExceededException(_inner) => {
                Some(_inner)
            }
            AddLayerVersionPermissionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            AddLayerVersionPermissionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AddLayerVersionPermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddLayerVersionPermissionErrorKind::ServiceException(_inner) => Some(_inner),
            AddLayerVersionPermissionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddLayerVersionPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddPermissionError {
    /// Kind of error that occurred.
    pub kind: AddPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddPermissionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The permissions policy for the resource is too large. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    PolicyLengthExceededException(crate::error::PolicyLengthExceededException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddPermissionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::PolicyLengthExceededException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddPermissionError {
    fn code(&self) -> Option<&str> {
        AddPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddPermissionError {
    /// Creates a new `AddPermissionError`.
    pub fn new(kind: AddPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::PolicyLengthExceededException`.
    pub fn is_policy_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::PolicyLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AddPermissionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AddPermissionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddPermissionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddPermissionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            AddPermissionErrorKind::PolicyLengthExceededException(_inner) => Some(_inner),
            AddPermissionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            AddPermissionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AddPermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddPermissionErrorKind::ServiceException(_inner) => Some(_inner),
            AddPermissionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAliasErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAliasError {
    fn code(&self) -> Option<&str> {
        CreateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAliasError {
    /// Creates a new `CreateAliasError`.
    pub fn new(kind: CreateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateAliasErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateAliasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAliasErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateAliasErrorKind::ResourceConflictException(_inner) => Some(_inner),
            CreateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAliasErrorKind::ServiceException(_inner) => Some(_inner),
            CreateAliasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: CreateCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        CreateCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCodeSigningConfigError {
    /// Creates a new `CreateCodeSigningConfigError`.
    pub fn new(kind: CreateCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for CreateCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CreateCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            CreateCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventSourceMappingError {
    /// Kind of error that occurred.
    pub kind: CreateEventSourceMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventSourceMappingErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventSourceMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSourceMappingErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            CreateEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEventSourceMappingErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateEventSourceMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateEventSourceMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventSourceMappingError {
    fn code(&self) -> Option<&str> {
        CreateEventSourceMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventSourceMappingError {
    /// Creates a new `CreateEventSourceMappingError`.
    pub fn new(kind: CreateEventSourceMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventSourceMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventSourceMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventSourceMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventSourceMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventSourceMappingErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSourceMappingErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSourceMappingErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSourceMappingErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSourceMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSourceMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSourceMappingErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSourceMappingErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSourceMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSourceMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateEventSourceMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CreateEventSourceMappingErrorKind::ResourceConflictException(_inner) => Some(_inner),
            CreateEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEventSourceMappingErrorKind::ServiceException(_inner) => Some(_inner),
            CreateEventSourceMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateEventSourceMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFunctionError {
    /// Kind of error that occurred.
    pub kind: CreateFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFunctionErrorKind {
    /// <p>The specified code signing configuration does not exist.</p>
    CodeSigningConfigNotFoundException(crate::error::CodeSigningConfigNotFoundException),
    /// <p>You have exceeded your maximum total code size per account. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    CodeStorageExceededException(crate::error::CodeStorageExceededException),
    /// <p>The code signature failed one or more of the validation checks for signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the deployment. </p>
    CodeVerificationFailedException(crate::error::CodeVerificationFailedException),
    /// <p>The code signature failed the integrity check. Lambda always blocks deployment if the integrity check fails, even if code signing policy is set to WARN.</p>
    InvalidCodeSignatureException(crate::error::InvalidCodeSignatureException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFunctionErrorKind::CodeSigningConfigNotFoundException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::CodeStorageExceededException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::CodeVerificationFailedException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::InvalidCodeSignatureException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFunctionError {
    fn code(&self) -> Option<&str> {
        CreateFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFunctionError {
    /// Creates a new `CreateFunctionError`.
    pub fn new(kind: CreateFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::CodeSigningConfigNotFoundException`.
    pub fn is_code_signing_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::CodeSigningConfigNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::CodeStorageExceededException`.
    pub fn is_code_storage_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::CodeStorageExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::CodeVerificationFailedException`.
    pub fn is_code_verification_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::CodeVerificationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::InvalidCodeSignatureException`.
    pub fn is_invalid_code_signature_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::InvalidCodeSignatureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateFunctionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateFunctionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFunctionErrorKind::CodeSigningConfigNotFoundException(_inner) => Some(_inner),
            CreateFunctionErrorKind::CodeStorageExceededException(_inner) => Some(_inner),
            CreateFunctionErrorKind::CodeVerificationFailedException(_inner) => Some(_inner),
            CreateFunctionErrorKind::InvalidCodeSignatureException(_inner) => Some(_inner),
            CreateFunctionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateFunctionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            CreateFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFunctionErrorKind::ServiceException(_inner) => Some(_inner),
            CreateFunctionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAliasErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAliasError {
    fn code(&self) -> Option<&str> {
        DeleteAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAliasError {
    /// Creates a new `DeleteAliasError`.
    pub fn new(kind: DeleteAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteAliasErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteAliasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAliasErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteAliasErrorKind::ResourceConflictException(_inner) => Some(_inner),
            DeleteAliasErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteAliasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCodeSigningConfigErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            DeleteCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        DeleteCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCodeSigningConfigError {
    /// Creates a new `DeleteCodeSigningConfigError`.
    pub fn new(kind: DeleteCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCodeSigningConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCodeSigningConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for DeleteCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteCodeSigningConfigErrorKind::ResourceConflictException(_inner) => Some(_inner),
            DeleteCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventSourceMappingError {
    /// Kind of error that occurred.
    pub kind: DeleteEventSourceMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventSourceMappingErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to update an EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventSourceMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventSourceMappingErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEventSourceMappingErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteEventSourceMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteEventSourceMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventSourceMappingError {
    fn code(&self) -> Option<&str> {
        DeleteEventSourceMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventSourceMappingError {
    /// Creates a new `DeleteEventSourceMappingError`.
    pub fn new(kind: DeleteEventSourceMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventSourceMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventSourceMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventSourceMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventSourceMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventSourceMappingErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSourceMappingErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSourceMappingErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSourceMappingErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSourceMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSourceMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSourceMappingErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSourceMappingErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSourceMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSourceMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteEventSourceMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteEventSourceMappingErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEventSourceMappingErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteEventSourceMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteEventSourceMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionError {
    /// Creates a new `DeleteFunctionError`.
    pub fn new(kind: DeleteFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteFunctionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionCodeSigningConfigErrorKind {
    /// <p>The specified code signing configuration does not exist.</p>
    CodeSigningConfigNotFoundException(crate::error::CodeSigningConfigNotFoundException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DeleteFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionCodeSigningConfigError {
    /// Creates a new `DeleteFunctionCodeSigningConfigError`.
    pub fn new(
        kind: DeleteFunctionCodeSigningConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException`.
    pub fn is_code_signing_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionCodeSigningConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteFunctionCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(
                _inner,
            ) => Some(_inner),
            DeleteFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionConcurrencyError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionConcurrencyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionConcurrencyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionConcurrencyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionConcurrencyErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            DeleteFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFunctionConcurrencyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteFunctionConcurrencyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionConcurrencyError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionConcurrencyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionConcurrencyError {
    /// Creates a new `DeleteFunctionConcurrencyError`.
    pub fn new(kind: DeleteFunctionConcurrencyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionConcurrencyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionConcurrencyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionConcurrencyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionConcurrencyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFunctionConcurrencyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionConcurrencyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionConcurrencyErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionConcurrencyErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionConcurrencyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionConcurrencyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionConcurrencyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionConcurrencyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionConcurrencyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionConcurrencyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteFunctionConcurrencyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionConcurrencyErrorKind::ResourceConflictException(_inner) => Some(_inner),
            DeleteFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFunctionConcurrencyErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteFunctionConcurrencyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionEventInvokeConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionEventInvokeConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionEventInvokeConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionEventInvokeConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionEventInvokeConfigError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionEventInvokeConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionEventInvokeConfigError {
    /// Creates a new `DeleteFunctionEventInvokeConfigError`.
    pub fn new(
        kind: DeleteFunctionEventInvokeConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionEventInvokeConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionEventInvokeConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFunctionEventInvokeConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionEventInvokeConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionEventInvokeConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionEventInvokeConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionEventInvokeConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionEventInvokeConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFunctionEventInvokeConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteFunctionEventInvokeConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLayerVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteLayerVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLayerVersionErrorKind {
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLayerVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLayerVersionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteLayerVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteLayerVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLayerVersionError {
    fn code(&self) -> Option<&str> {
        DeleteLayerVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLayerVersionError {
    /// Creates a new `DeleteLayerVersionError`.
    pub fn new(kind: DeleteLayerVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLayerVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLayerVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLayerVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLayerVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLayerVersionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteLayerVersionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteLayerVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLayerVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteLayerVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLayerVersionErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteLayerVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteLayerVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProvisionedConcurrencyConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteProvisionedConcurrencyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProvisionedConcurrencyConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProvisionedConcurrencyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProvisionedConcurrencyConfigError {
    fn code(&self) -> Option<&str> {
        DeleteProvisionedConcurrencyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProvisionedConcurrencyConfigError {
    /// Creates a new `DeleteProvisionedConcurrencyConfigError`.
    pub fn new(
        kind: DeleteProvisionedConcurrencyConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProvisionedConcurrencyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProvisionedConcurrencyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisionedConcurrencyConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisionedConcurrencyConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedConcurrencyConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteProvisionedConcurrencyConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteProvisionedConcurrencyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DeleteProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSettingsError {
    /// Kind of error that occurred.
    pub kind: GetAccountSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSettingsErrorKind {
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSettingsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAccountSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSettingsError {
    fn code(&self) -> Option<&str> {
        GetAccountSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountSettingsError {
    /// Creates a new `GetAccountSettingsError`.
    pub fn new(kind: GetAccountSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSettingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetAccountSettingsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetAccountSettingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSettingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetAccountSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSettingsErrorKind::ServiceException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAccountSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAliasError {
    /// Kind of error that occurred.
    pub kind: GetAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAliasErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAliasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetAliasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAliasError {
    fn code(&self) -> Option<&str> {
        GetAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAliasError {
    /// Creates a new `GetAliasError`.
    pub fn new(kind: GetAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAliasErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAliasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetAliasErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetAliasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetAliasErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAliasErrorKind::ServiceException(_inner) => Some(_inner),
            GetAliasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: GetCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        GetCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCodeSigningConfigError {
    /// Creates a new `GetCodeSigningConfigError`.
    pub fn new(kind: GetCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for GetCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            GetCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEventSourceMappingError {
    /// Kind of error that occurred.
    pub kind: GetEventSourceMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEventSourceMappingErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEventSourceMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEventSourceMappingErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetEventSourceMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetEventSourceMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEventSourceMappingError {
    fn code(&self) -> Option<&str> {
        GetEventSourceMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEventSourceMappingError {
    /// Creates a new `GetEventSourceMappingError`.
    pub fn new(kind: GetEventSourceMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEventSourceMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEventSourceMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEventSourceMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEventSourceMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEventSourceMappingErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSourceMappingErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSourceMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSourceMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSourceMappingErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSourceMappingErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEventSourceMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEventSourceMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetEventSourceMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEventSourceMappingErrorKind::ServiceException(_inner) => Some(_inner),
            GetEventSourceMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetEventSourceMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionError {
    /// Kind of error that occurred.
    pub kind: GetFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionError {
    fn code(&self) -> Option<&str> {
        GetFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionError {
    /// Creates a new `GetFunctionError`.
    pub fn new(kind: GetFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetFunctionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetFunctionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFunctionErrorKind::ServiceException(_inner) => Some(_inner),
            GetFunctionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: GetFunctionCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        GetFunctionCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionCodeSigningConfigError {
    /// Creates a new `GetFunctionCodeSigningConfigError`.
    pub fn new(kind: GetFunctionCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionCodeSigningConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetFunctionCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            GetFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionConcurrencyError {
    /// Kind of error that occurred.
    pub kind: GetFunctionConcurrencyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionConcurrencyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionConcurrencyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFunctionConcurrencyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetFunctionConcurrencyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionConcurrencyError {
    fn code(&self) -> Option<&str> {
        GetFunctionConcurrencyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionConcurrencyError {
    /// Creates a new `GetFunctionConcurrencyError`.
    pub fn new(kind: GetFunctionConcurrencyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionConcurrencyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionConcurrencyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionConcurrencyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionConcurrencyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionConcurrencyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConcurrencyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConcurrencyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConcurrencyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConcurrencyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConcurrencyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConcurrencyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConcurrencyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetFunctionConcurrencyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFunctionConcurrencyErrorKind::ServiceException(_inner) => Some(_inner),
            GetFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFunctionConcurrencyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunctionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetFunctionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunctionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionConfigurationErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionConfigurationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFunctionConfigurationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetFunctionConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetFunctionConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionConfigurationError {
    fn code(&self) -> Option<&str> {
        GetFunctionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionConfigurationError {
    /// Creates a new `GetFunctionConfigurationError`.
    pub fn new(kind: GetFunctionConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConfigurationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConfigurationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetFunctionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetFunctionConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFunctionConfigurationErrorKind::ServiceException(_inner) => Some(_inner),
            GetFunctionConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFunctionConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionEventInvokeConfigError {
    /// Kind of error that occurred.
    pub kind: GetFunctionEventInvokeConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionEventInvokeConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionEventInvokeConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            GetFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionEventInvokeConfigError {
    fn code(&self) -> Option<&str> {
        GetFunctionEventInvokeConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionEventInvokeConfigError {
    /// Creates a new `GetFunctionEventInvokeConfigError`.
    pub fn new(kind: GetFunctionEventInvokeConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionEventInvokeConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionEventInvokeConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFunctionEventInvokeConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionEventInvokeConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionEventInvokeConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionEventInvokeConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFunctionEventInvokeConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetFunctionEventInvokeConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => Some(_inner),
            GetFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLayerVersionError {
    /// Kind of error that occurred.
    pub kind: GetLayerVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLayerVersionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLayerVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLayerVersionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetLayerVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLayerVersionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLayerVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetLayerVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLayerVersionError {
    fn code(&self) -> Option<&str> {
        GetLayerVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLayerVersionError {
    /// Creates a new `GetLayerVersionError`.
    pub fn new(kind: GetLayerVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLayerVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLayerVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLayerVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLayerVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLayerVersionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetLayerVersionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetLayerVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetLayerVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLayerVersionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetLayerVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLayerVersionErrorKind::ServiceException(_inner) => Some(_inner),
            GetLayerVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetLayerVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLayerVersionByArn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLayerVersionByArnError {
    /// Kind of error that occurred.
    pub kind: GetLayerVersionByArnErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLayerVersionByArn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLayerVersionByArnErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLayerVersionByArnError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLayerVersionByArnErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetLayerVersionByArnErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLayerVersionByArnErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLayerVersionByArnErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetLayerVersionByArnErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLayerVersionByArnError {
    fn code(&self) -> Option<&str> {
        GetLayerVersionByArnError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLayerVersionByArnError {
    /// Creates a new `GetLayerVersionByArnError`.
    pub fn new(kind: GetLayerVersionByArnErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLayerVersionByArnError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLayerVersionByArnErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLayerVersionByArnError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLayerVersionByArnErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLayerVersionByArnErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionByArnErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionByArnErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionByArnErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionByArnErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionByArnErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionByArnErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionByArnErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetLayerVersionByArnError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLayerVersionByArnErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetLayerVersionByArnErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLayerVersionByArnErrorKind::ServiceException(_inner) => Some(_inner),
            GetLayerVersionByArnErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetLayerVersionByArnErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLayerVersionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLayerVersionPolicyError {
    /// Kind of error that occurred.
    pub kind: GetLayerVersionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLayerVersionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLayerVersionPolicyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLayerVersionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLayerVersionPolicyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetLayerVersionPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLayerVersionPolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLayerVersionPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetLayerVersionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLayerVersionPolicyError {
    fn code(&self) -> Option<&str> {
        GetLayerVersionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLayerVersionPolicyError {
    /// Creates a new `GetLayerVersionPolicyError`.
    pub fn new(kind: GetLayerVersionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLayerVersionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLayerVersionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLayerVersionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLayerVersionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLayerVersionPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionPolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionPolicyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLayerVersionPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLayerVersionPolicyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetLayerVersionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLayerVersionPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetLayerVersionPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLayerVersionPolicyErrorKind::ServiceException(_inner) => Some(_inner),
            GetLayerVersionPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetLayerVersionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::ServiceException(_inner) => Some(_inner),
            GetPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProvisionedConcurrencyConfigError {
    /// Kind of error that occurred.
    pub kind: GetProvisionedConcurrencyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProvisionedConcurrencyConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The specified configuration does not exist.</p>
    ProvisionedConcurrencyConfigNotFoundException(
        crate::error::ProvisionedConcurrencyConfigNotFoundException,
    ),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProvisionedConcurrencyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ProvisionedConcurrencyConfigNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) =>
            _inner.fmt(f)
            ,
            GetProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) =>
            _inner.fmt(f)
            ,
            GetProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProvisionedConcurrencyConfigError {
    fn code(&self) -> Option<&str> {
        GetProvisionedConcurrencyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProvisionedConcurrencyConfigError {
    /// Creates a new `GetProvisionedConcurrencyConfigError`.
    pub fn new(
        kind: GetProvisionedConcurrencyConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProvisionedConcurrencyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProvisionedConcurrencyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProvisionedConcurrencyConfigErrorKind::ProvisionedConcurrencyConfigNotFoundException`.
    pub fn is_provisioned_concurrency_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedConcurrencyConfigErrorKind::ProvisionedConcurrencyConfigNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `GetProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProvisionedConcurrencyConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedConcurrencyConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProvisionedConcurrencyConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetProvisionedConcurrencyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ProvisionedConcurrencyConfigNotFoundException(_inner) =>
            Some(_inner)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) =>
            Some(_inner)
            ,
            GetProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) =>
            Some(_inner)
            ,
            GetProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) =>
            Some(_inner)
            ,
            GetProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `Invoke` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InvokeError {
    /// Kind of error that occurred.
    pub kind: InvokeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Invoke` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InvokeErrorKind {
    /// <p>Need additional permissions to configure VPC settings.</p>
    Ec2AccessDeniedException(crate::error::Ec2AccessDeniedException),
    /// <p>Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role provided for the Lambda function.</p>
    Ec2ThrottledException(crate::error::Ec2ThrottledException),
    /// <p>Lambda received an unexpected EC2 client exception while setting up for the Lambda function.</p>
    Ec2UnexpectedException(crate::error::Ec2UnexpectedException),
    /// <p>An error occurred when reading from or writing to a connected file system.</p>
    EfsioException(crate::error::EfsioException),
    /// <p>The function couldn't make a network connection to the configured file system.</p>
    EfsMountConnectivityException(crate::error::EfsMountConnectivityException),
    /// <p>The function couldn't mount the configured file system due to a permission or configuration issue.</p>
    EfsMountFailureException(crate::error::EfsMountFailureException),
    /// <p>The function was able to make a network connection to the configured file system, but the mount operation timed out.</p>
    EfsMountTimeoutException(crate::error::EfsMountTimeoutException),
    /// <p>Lambda was not able to create an elastic network interface in the VPC, specified as part of Lambda function configuration, because the limit for network interfaces has been reached.</p>
    EniLimitReachedException(crate::error::EniLimitReachedException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The request body could not be parsed as JSON.</p>
    InvalidRequestContentException(crate::error::InvalidRequestContentException),
    /// <p>The runtime or runtime version specified is not supported.</p>
    InvalidRuntimeException(crate::error::InvalidRuntimeException),
    /// <p>The Security Group ID provided in the Lambda function VPC configuration is invalid.</p>
    InvalidSecurityGroupIdException(crate::error::InvalidSecurityGroupIdException),
    /// <p>The Subnet ID provided in the Lambda function VPC configuration is invalid.</p>
    InvalidSubnetIdException(crate::error::InvalidSubnetIdException),
    /// <p>Lambda could not unzip the deployment package.</p>
    InvalidZipFileException(crate::error::InvalidZipFileException),
    /// <p>Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda function's KMS permissions.</p>
    KmsAccessDeniedException(crate::error::KmsAccessDeniedException),
    /// <p>Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the Lambda function's KMS key settings.</p>
    KmsDisabledException(crate::error::KmsDisabledException),
    /// <p>Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state for Decrypt. Check the function's KMS key settings.</p>
    KmsInvalidStateException(crate::error::KmsInvalidStateException),
    /// <p>Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the function's KMS key settings. </p>
    KmsNotFoundException(crate::error::KmsNotFoundException),
    /// <p>The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>. </p>
    RequestTooLargeException(crate::error::RequestTooLargeException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to reestablish and try again.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lambda was not able to set up VPC access for the Lambda function because one or more configured subnets has no available IP addresses.</p>
    SubnetIpAddressLimitReachedException(crate::error::SubnetIpAddressLimitReachedException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The content type of the <code>Invoke</code> request body is not JSON.</p>
    UnsupportedMediaTypeException(crate::error::UnsupportedMediaTypeException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InvokeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InvokeErrorKind::Ec2AccessDeniedException(_inner) => _inner.fmt(f),
            InvokeErrorKind::Ec2ThrottledException(_inner) => _inner.fmt(f),
            InvokeErrorKind::Ec2UnexpectedException(_inner) => _inner.fmt(f),
            InvokeErrorKind::EfsioException(_inner) => _inner.fmt(f),
            InvokeErrorKind::EfsMountConnectivityException(_inner) => _inner.fmt(f),
            InvokeErrorKind::EfsMountFailureException(_inner) => _inner.fmt(f),
            InvokeErrorKind::EfsMountTimeoutException(_inner) => _inner.fmt(f),
            InvokeErrorKind::EniLimitReachedException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidRequestContentException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidRuntimeException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidSecurityGroupIdException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidSubnetIdException(_inner) => _inner.fmt(f),
            InvokeErrorKind::InvalidZipFileException(_inner) => _inner.fmt(f),
            InvokeErrorKind::KmsAccessDeniedException(_inner) => _inner.fmt(f),
            InvokeErrorKind::KmsDisabledException(_inner) => _inner.fmt(f),
            InvokeErrorKind::KmsInvalidStateException(_inner) => _inner.fmt(f),
            InvokeErrorKind::KmsNotFoundException(_inner) => _inner.fmt(f),
            InvokeErrorKind::RequestTooLargeException(_inner) => _inner.fmt(f),
            InvokeErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            InvokeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InvokeErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            InvokeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            InvokeErrorKind::SubnetIpAddressLimitReachedException(_inner) => _inner.fmt(f),
            InvokeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            InvokeErrorKind::UnsupportedMediaTypeException(_inner) => _inner.fmt(f),
            InvokeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InvokeError {
    fn code(&self) -> Option<&str> {
        InvokeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InvokeError {
    /// Creates a new `InvokeError`.
    pub fn new(kind: InvokeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InvokeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InvokeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InvokeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InvokeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::Ec2AccessDeniedException`.
    pub fn is_ec2_access_denied_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::Ec2AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::Ec2ThrottledException`.
    pub fn is_ec2_throttled_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::Ec2ThrottledException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::Ec2UnexpectedException`.
    pub fn is_ec2_unexpected_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::Ec2UnexpectedException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::EfsioException`.
    pub fn is_efsio_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::EfsioException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::EfsMountConnectivityException`.
    pub fn is_efs_mount_connectivity_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::EfsMountConnectivityException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::EfsMountFailureException`.
    pub fn is_efs_mount_failure_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::EfsMountFailureException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::EfsMountTimeoutException`.
    pub fn is_efs_mount_timeout_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::EfsMountTimeoutException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::EniLimitReachedException`.
    pub fn is_eni_limit_reached_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::EniLimitReachedException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidRequestContentException`.
    pub fn is_invalid_request_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::InvalidRequestContentException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidRuntimeException`.
    pub fn is_invalid_runtime_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::InvalidRuntimeException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidSecurityGroupIdException`.
    pub fn is_invalid_security_group_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::InvalidSecurityGroupIdException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidSubnetIdException`.
    pub fn is_invalid_subnet_id_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::InvalidSubnetIdException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::InvalidZipFileException`.
    pub fn is_invalid_zip_file_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::InvalidZipFileException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::KmsAccessDeniedException`.
    pub fn is_kms_access_denied_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::KmsAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::KmsDisabledException`.
    pub fn is_kms_disabled_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::KmsDisabledException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::KmsInvalidStateException`.
    pub fn is_kms_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::KmsInvalidStateException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::KmsNotFoundException`.
    pub fn is_kms_not_found_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::KmsNotFoundException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::RequestTooLargeException`.
    pub fn is_request_too_large_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::RequestTooLargeException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::ResourceConflictException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::ResourceNotReadyException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::SubnetIpAddressLimitReachedException`.
    pub fn is_subnet_ip_address_limit_reached_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::SubnetIpAddressLimitReachedException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, InvokeErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `InvokeErrorKind::UnsupportedMediaTypeException`.
    pub fn is_unsupported_media_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeErrorKind::UnsupportedMediaTypeException(_)
        )
    }
}
impl std::error::Error for InvokeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InvokeErrorKind::Ec2AccessDeniedException(_inner) => Some(_inner),
            InvokeErrorKind::Ec2ThrottledException(_inner) => Some(_inner),
            InvokeErrorKind::Ec2UnexpectedException(_inner) => Some(_inner),
            InvokeErrorKind::EfsioException(_inner) => Some(_inner),
            InvokeErrorKind::EfsMountConnectivityException(_inner) => Some(_inner),
            InvokeErrorKind::EfsMountFailureException(_inner) => Some(_inner),
            InvokeErrorKind::EfsMountTimeoutException(_inner) => Some(_inner),
            InvokeErrorKind::EniLimitReachedException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidRequestContentException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidRuntimeException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidSecurityGroupIdException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidSubnetIdException(_inner) => Some(_inner),
            InvokeErrorKind::InvalidZipFileException(_inner) => Some(_inner),
            InvokeErrorKind::KmsAccessDeniedException(_inner) => Some(_inner),
            InvokeErrorKind::KmsDisabledException(_inner) => Some(_inner),
            InvokeErrorKind::KmsInvalidStateException(_inner) => Some(_inner),
            InvokeErrorKind::KmsNotFoundException(_inner) => Some(_inner),
            InvokeErrorKind::RequestTooLargeException(_inner) => Some(_inner),
            InvokeErrorKind::ResourceConflictException(_inner) => Some(_inner),
            InvokeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InvokeErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            InvokeErrorKind::ServiceException(_inner) => Some(_inner),
            InvokeErrorKind::SubnetIpAddressLimitReachedException(_inner) => Some(_inner),
            InvokeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            InvokeErrorKind::UnsupportedMediaTypeException(_inner) => Some(_inner),
            InvokeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InvokeAsync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InvokeAsyncError {
    /// Kind of error that occurred.
    pub kind: InvokeAsyncErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InvokeAsync` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InvokeAsyncErrorKind {
    /// <p>The request body could not be parsed as JSON.</p>
    InvalidRequestContentException(crate::error::InvalidRequestContentException),
    /// <p>The runtime or runtime version specified is not supported.</p>
    InvalidRuntimeException(crate::error::InvalidRuntimeException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InvokeAsyncError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InvokeAsyncErrorKind::InvalidRequestContentException(_inner) => _inner.fmt(f),
            InvokeAsyncErrorKind::InvalidRuntimeException(_inner) => _inner.fmt(f),
            InvokeAsyncErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            InvokeAsyncErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InvokeAsyncErrorKind::ServiceException(_inner) => _inner.fmt(f),
            InvokeAsyncErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InvokeAsyncError {
    fn code(&self) -> Option<&str> {
        InvokeAsyncError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InvokeAsyncError {
    /// Creates a new `InvokeAsyncError`.
    pub fn new(kind: InvokeAsyncErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InvokeAsyncError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InvokeAsyncErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InvokeAsyncError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InvokeAsyncErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InvokeAsyncErrorKind::InvalidRequestContentException`.
    pub fn is_invalid_request_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeAsyncErrorKind::InvalidRequestContentException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeAsyncErrorKind::InvalidRuntimeException`.
    pub fn is_invalid_runtime_exception(&self) -> bool {
        matches!(&self.kind, InvokeAsyncErrorKind::InvalidRuntimeException(_))
    }
    /// Returns `true` if the error kind is `InvokeAsyncErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeAsyncErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeAsyncErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvokeAsyncErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `InvokeAsyncErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, InvokeAsyncErrorKind::ServiceException(_))
    }
}
impl std::error::Error for InvokeAsyncError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InvokeAsyncErrorKind::InvalidRequestContentException(_inner) => Some(_inner),
            InvokeAsyncErrorKind::InvalidRuntimeException(_inner) => Some(_inner),
            InvokeAsyncErrorKind::ResourceConflictException(_inner) => Some(_inner),
            InvokeAsyncErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InvokeAsyncErrorKind::ServiceException(_inner) => Some(_inner),
            InvokeAsyncErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAliasesError {
    /// Kind of error that occurred.
    pub kind: ListAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAliasesErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAliasesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAliasesError {
    fn code(&self) -> Option<&str> {
        ListAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAliasesError {
    /// Creates a new `ListAliasesError`.
    pub fn new(kind: ListAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAliasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListAliasesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListAliasesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAliasesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAliasesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListAliasesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAliasesErrorKind::ServiceException(_inner) => Some(_inner),
            ListAliasesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCodeSigningConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCodeSigningConfigsError {
    /// Kind of error that occurred.
    pub kind: ListCodeSigningConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCodeSigningConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCodeSigningConfigsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCodeSigningConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCodeSigningConfigsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListCodeSigningConfigsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListCodeSigningConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCodeSigningConfigsError {
    fn code(&self) -> Option<&str> {
        ListCodeSigningConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCodeSigningConfigsError {
    /// Creates a new `ListCodeSigningConfigsError`.
    pub fn new(kind: ListCodeSigningConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCodeSigningConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCodeSigningConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCodeSigningConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCodeSigningConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCodeSigningConfigsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCodeSigningConfigsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCodeSigningConfigsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCodeSigningConfigsErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for ListCodeSigningConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCodeSigningConfigsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListCodeSigningConfigsErrorKind::ServiceException(_inner) => Some(_inner),
            ListCodeSigningConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventSourceMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventSourceMappingsError {
    /// Kind of error that occurred.
    pub kind: ListEventSourceMappingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventSourceMappings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventSourceMappingsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventSourceMappingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventSourceMappingsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListEventSourceMappingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListEventSourceMappingsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListEventSourceMappingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEventSourceMappingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventSourceMappingsError {
    fn code(&self) -> Option<&str> {
        ListEventSourceMappingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventSourceMappingsError {
    /// Creates a new `ListEventSourceMappingsError`.
    pub fn new(kind: ListEventSourceMappingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventSourceMappingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventSourceMappingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventSourceMappingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventSourceMappingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventSourceMappingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSourceMappingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSourceMappingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSourceMappingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSourceMappingsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSourceMappingsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEventSourceMappingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSourceMappingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEventSourceMappingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventSourceMappingsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListEventSourceMappingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListEventSourceMappingsErrorKind::ServiceException(_inner) => Some(_inner),
            ListEventSourceMappingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEventSourceMappingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFunctionEventInvokeConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFunctionEventInvokeConfigsError {
    /// Kind of error that occurred.
    pub kind: ListFunctionEventInvokeConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFunctionEventInvokeConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFunctionEventInvokeConfigsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFunctionEventInvokeConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFunctionEventInvokeConfigsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListFunctionEventInvokeConfigsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListFunctionEventInvokeConfigsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListFunctionEventInvokeConfigsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListFunctionEventInvokeConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFunctionEventInvokeConfigsError {
    fn code(&self) -> Option<&str> {
        ListFunctionEventInvokeConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFunctionEventInvokeConfigsError {
    /// Creates a new `ListFunctionEventInvokeConfigsError`.
    pub fn new(
        kind: ListFunctionEventInvokeConfigsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFunctionEventInvokeConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFunctionEventInvokeConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFunctionEventInvokeConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFunctionEventInvokeConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFunctionEventInvokeConfigsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionEventInvokeConfigsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionEventInvokeConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionEventInvokeConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionEventInvokeConfigsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionEventInvokeConfigsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionEventInvokeConfigsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionEventInvokeConfigsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListFunctionEventInvokeConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFunctionEventInvokeConfigsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListFunctionEventInvokeConfigsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListFunctionEventInvokeConfigsErrorKind::ServiceException(_inner) => Some(_inner),
            ListFunctionEventInvokeConfigsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListFunctionEventInvokeConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFunctionsError {
    /// Kind of error that occurred.
    pub kind: ListFunctionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFunctionsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFunctionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFunctionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFunctionsError {
    fn code(&self) -> Option<&str> {
        ListFunctionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFunctionsError {
    /// Creates a new `ListFunctionsError`.
    pub fn new(kind: ListFunctionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFunctionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListFunctionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListFunctionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFunctionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListFunctionsErrorKind::ServiceException(_inner) => Some(_inner),
            ListFunctionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListFunctionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFunctionsByCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFunctionsByCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: ListFunctionsByCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFunctionsByCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFunctionsByCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFunctionsByCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFunctionsByCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListFunctionsByCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListFunctionsByCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListFunctionsByCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFunctionsByCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        ListFunctionsByCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFunctionsByCodeSigningConfigError {
    /// Creates a new `ListFunctionsByCodeSigningConfigError`.
    pub fn new(
        kind: ListFunctionsByCodeSigningConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFunctionsByCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFunctionsByCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFunctionsByCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFunctionsByCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFunctionsByCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsByCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionsByCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsByCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFunctionsByCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsByCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for ListFunctionsByCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFunctionsByCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListFunctionsByCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListFunctionsByCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            ListFunctionsByCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLayers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLayersError {
    /// Kind of error that occurred.
    pub kind: ListLayersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLayers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLayersErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLayersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLayersErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListLayersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListLayersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListLayersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLayersError {
    fn code(&self) -> Option<&str> {
        ListLayersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLayersError {
    /// Creates a new `ListLayersError`.
    pub fn new(kind: ListLayersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLayersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLayersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLayersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLayersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLayersErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLayersErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLayersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListLayersErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListLayersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListLayersErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListLayersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLayersErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListLayersErrorKind::ServiceException(_inner) => Some(_inner),
            ListLayersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListLayersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLayerVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLayerVersionsError {
    /// Kind of error that occurred.
    pub kind: ListLayerVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLayerVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLayerVersionsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLayerVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLayerVersionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListLayerVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLayerVersionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListLayerVersionsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListLayerVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLayerVersionsError {
    fn code(&self) -> Option<&str> {
        ListLayerVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLayerVersionsError {
    /// Creates a new `ListLayerVersionsError`.
    pub fn new(kind: ListLayerVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLayerVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLayerVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLayerVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLayerVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLayerVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLayerVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLayerVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLayerVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLayerVersionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListLayerVersionsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListLayerVersionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLayerVersionsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListLayerVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLayerVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListLayerVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLayerVersionsErrorKind::ServiceException(_inner) => Some(_inner),
            ListLayerVersionsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListLayerVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProvisionedConcurrencyConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProvisionedConcurrencyConfigsError {
    /// Kind of error that occurred.
    pub kind: ListProvisionedConcurrencyConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProvisionedConcurrencyConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProvisionedConcurrencyConfigsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProvisionedConcurrencyConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProvisionedConcurrencyConfigsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedConcurrencyConfigsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedConcurrencyConfigsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListProvisionedConcurrencyConfigsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListProvisionedConcurrencyConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProvisionedConcurrencyConfigsError {
    fn code(&self) -> Option<&str> {
        ListProvisionedConcurrencyConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProvisionedConcurrencyConfigsError {
    /// Creates a new `ListProvisionedConcurrencyConfigsError`.
    pub fn new(
        kind: ListProvisionedConcurrencyConfigsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProvisionedConcurrencyConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProvisionedConcurrencyConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProvisionedConcurrencyConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProvisionedConcurrencyConfigsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProvisionedConcurrencyConfigsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedConcurrencyConfigsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisionedConcurrencyConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedConcurrencyConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisionedConcurrencyConfigsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedConcurrencyConfigsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProvisionedConcurrencyConfigsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProvisionedConcurrencyConfigsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListProvisionedConcurrencyConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProvisionedConcurrencyConfigsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListProvisionedConcurrencyConfigsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListProvisionedConcurrencyConfigsErrorKind::ServiceException(_inner) => Some(_inner),
            ListProvisionedConcurrencyConfigsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListProvisionedConcurrencyConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsError {
    /// Kind of error that occurred.
    pub kind: ListTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsError {
    fn code(&self) -> Option<&str> {
        ListTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsError {
    /// Creates a new `ListTagsError`.
    pub fn new(kind: ListTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ListTagsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListTagsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsErrorKind::ServiceException(_inner) => Some(_inner),
            ListTagsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVersionsByFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVersionsByFunctionError {
    /// Kind of error that occurred.
    pub kind: ListVersionsByFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVersionsByFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVersionsByFunctionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVersionsByFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVersionsByFunctionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListVersionsByFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListVersionsByFunctionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ListVersionsByFunctionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListVersionsByFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVersionsByFunctionError {
    fn code(&self) -> Option<&str> {
        ListVersionsByFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVersionsByFunctionError {
    /// Creates a new `ListVersionsByFunctionError`.
    pub fn new(kind: ListVersionsByFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVersionsByFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVersionsByFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVersionsByFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVersionsByFunctionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVersionsByFunctionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVersionsByFunctionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVersionsByFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVersionsByFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVersionsByFunctionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVersionsByFunctionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVersionsByFunctionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVersionsByFunctionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListVersionsByFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVersionsByFunctionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListVersionsByFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListVersionsByFunctionErrorKind::ServiceException(_inner) => Some(_inner),
            ListVersionsByFunctionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListVersionsByFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PublishLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishLayerVersionError {
    /// Kind of error that occurred.
    pub kind: PublishLayerVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PublishLayerVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishLayerVersionErrorKind {
    /// <p>You have exceeded your maximum total code size per account. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    CodeStorageExceededException(crate::error::CodeStorageExceededException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishLayerVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishLayerVersionErrorKind::CodeStorageExceededException(_inner) => _inner.fmt(f),
            PublishLayerVersionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PublishLayerVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PublishLayerVersionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PublishLayerVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PublishLayerVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishLayerVersionError {
    fn code(&self) -> Option<&str> {
        PublishLayerVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishLayerVersionError {
    /// Creates a new `PublishLayerVersionError`.
    pub fn new(kind: PublishLayerVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishLayerVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishLayerVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishLayerVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishLayerVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PublishLayerVersionErrorKind::CodeStorageExceededException`.
    pub fn is_code_storage_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishLayerVersionErrorKind::CodeStorageExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishLayerVersionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishLayerVersionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishLayerVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishLayerVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishLayerVersionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishLayerVersionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishLayerVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishLayerVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PublishLayerVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishLayerVersionErrorKind::CodeStorageExceededException(_inner) => Some(_inner),
            PublishLayerVersionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PublishLayerVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PublishLayerVersionErrorKind::ServiceException(_inner) => Some(_inner),
            PublishLayerVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PublishLayerVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PublishVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PublishVersionError {
    /// Kind of error that occurred.
    pub kind: PublishVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PublishVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PublishVersionErrorKind {
    /// <p>You have exceeded your maximum total code size per account. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    CodeStorageExceededException(crate::error::CodeStorageExceededException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PublishVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PublishVersionErrorKind::CodeStorageExceededException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PublishVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PublishVersionError {
    fn code(&self) -> Option<&str> {
        PublishVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PublishVersionError {
    /// Creates a new `PublishVersionError`.
    pub fn new(kind: PublishVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PublishVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PublishVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PublishVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PublishVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::CodeStorageExceededException`.
    pub fn is_code_storage_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::CodeStorageExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, PublishVersionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `PublishVersionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PublishVersionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PublishVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PublishVersionErrorKind::CodeStorageExceededException(_inner) => Some(_inner),
            PublishVersionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PublishVersionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            PublishVersionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            PublishVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PublishVersionErrorKind::ServiceException(_inner) => Some(_inner),
            PublishVersionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PublishVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFunctionCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: PutFunctionCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFunctionCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFunctionCodeSigningConfigErrorKind {
    /// <p>The specified code signing configuration does not exist.</p>
    CodeSigningConfigNotFoundException(crate::error::CodeSigningConfigNotFoundException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFunctionCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionCodeSigningConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFunctionCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        PutFunctionCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFunctionCodeSigningConfigError {
    /// Creates a new `PutFunctionCodeSigningConfigError`.
    pub fn new(kind: PutFunctionCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFunctionCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFunctionCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFunctionCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException`.
    pub fn is_code_signing_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionCodeSigningConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutFunctionCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException(_inner) => {
                Some(_inner)
            }
            PutFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutFunctionCodeSigningConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            PutFunctionCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutFunctionCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            PutFunctionCodeSigningConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutFunctionCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFunctionConcurrencyError {
    /// Kind of error that occurred.
    pub kind: PutFunctionConcurrencyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFunctionConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFunctionConcurrencyErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFunctionConcurrencyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionConcurrencyErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            PutFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutFunctionConcurrencyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutFunctionConcurrencyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFunctionConcurrencyError {
    fn code(&self) -> Option<&str> {
        PutFunctionConcurrencyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFunctionConcurrencyError {
    /// Creates a new `PutFunctionConcurrencyError`.
    pub fn new(kind: PutFunctionConcurrencyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFunctionConcurrencyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFunctionConcurrencyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFunctionConcurrencyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFunctionConcurrencyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFunctionConcurrencyErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionConcurrencyErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionConcurrencyErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionConcurrencyErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionConcurrencyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionConcurrencyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionConcurrencyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionConcurrencyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionConcurrencyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionConcurrencyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutFunctionConcurrencyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFunctionConcurrencyErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutFunctionConcurrencyErrorKind::ResourceConflictException(_inner) => Some(_inner),
            PutFunctionConcurrencyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutFunctionConcurrencyErrorKind::ServiceException(_inner) => Some(_inner),
            PutFunctionConcurrencyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutFunctionConcurrencyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFunctionEventInvokeConfigError {
    /// Kind of error that occurred.
    pub kind: PutFunctionEventInvokeConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFunctionEventInvokeConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFunctionEventInvokeConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFunctionEventInvokeConfigError {
    fn code(&self) -> Option<&str> {
        PutFunctionEventInvokeConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFunctionEventInvokeConfigError {
    /// Creates a new `PutFunctionEventInvokeConfigError`.
    pub fn new(kind: PutFunctionEventInvokeConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFunctionEventInvokeConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFunctionEventInvokeConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFunctionEventInvokeConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionEventInvokeConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionEventInvokeConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionEventInvokeConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionEventInvokeConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionEventInvokeConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFunctionEventInvokeConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutFunctionEventInvokeConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            PutFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => Some(_inner),
            PutFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutProvisionedConcurrencyConfigError {
    /// Kind of error that occurred.
    pub kind: PutProvisionedConcurrencyConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutProvisionedConcurrencyConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutProvisionedConcurrencyConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutProvisionedConcurrencyConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            PutProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            PutProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            PutProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutProvisionedConcurrencyConfigError {
    fn code(&self) -> Option<&str> {
        PutProvisionedConcurrencyConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutProvisionedConcurrencyConfigError {
    /// Creates a new `PutProvisionedConcurrencyConfigError`.
    pub fn new(
        kind: PutProvisionedConcurrencyConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutProvisionedConcurrencyConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutProvisionedConcurrencyConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutProvisionedConcurrencyConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProvisionedConcurrencyConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProvisionedConcurrencyConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProvisionedConcurrencyConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutProvisionedConcurrencyConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PutProvisionedConcurrencyConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            PutProvisionedConcurrencyConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            PutProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutProvisionedConcurrencyConfigErrorKind::ServiceException(_inner) => Some(_inner),
            PutProvisionedConcurrencyConfigErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            PutProvisionedConcurrencyConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveLayerVersionPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveLayerVersionPermissionError {
    /// Kind of error that occurred.
    pub kind: RemoveLayerVersionPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveLayerVersionPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveLayerVersionPermissionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveLayerVersionPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveLayerVersionPermissionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            RemoveLayerVersionPermissionErrorKind::PreconditionFailedException(_inner) => {
                _inner.fmt(f)
            }
            RemoveLayerVersionPermissionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RemoveLayerVersionPermissionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemoveLayerVersionPermissionErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            RemoveLayerVersionPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveLayerVersionPermissionError {
    fn code(&self) -> Option<&str> {
        RemoveLayerVersionPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveLayerVersionPermissionError {
    /// Creates a new `RemoveLayerVersionPermissionError`.
    pub fn new(kind: RemoveLayerVersionPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveLayerVersionPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveLayerVersionPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveLayerVersionPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveLayerVersionPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveLayerVersionPermissionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLayerVersionPermissionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveLayerVersionPermissionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLayerVersionPermissionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveLayerVersionPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLayerVersionPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveLayerVersionPermissionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLayerVersionPermissionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveLayerVersionPermissionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveLayerVersionPermissionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveLayerVersionPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveLayerVersionPermissionErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            RemoveLayerVersionPermissionErrorKind::PreconditionFailedException(_inner) => {
                Some(_inner)
            }
            RemoveLayerVersionPermissionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            RemoveLayerVersionPermissionErrorKind::ServiceException(_inner) => Some(_inner),
            RemoveLayerVersionPermissionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveLayerVersionPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemovePermissionError {
    /// Kind of error that occurred.
    pub kind: RemovePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemovePermissionErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemovePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemovePermissionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemovePermissionError {
    fn code(&self) -> Option<&str> {
        RemovePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemovePermissionError {
    /// Creates a new `RemovePermissionError`.
    pub fn new(kind: RemovePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, RemovePermissionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemovePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemovePermissionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RemovePermissionErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ServiceException(_inner) => Some(_inner),
            RemovePermissionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemovePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAliasError {
    /// Kind of error that occurred.
    pub kind: UpdateAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAliasErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAliasErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAliasError {
    fn code(&self) -> Option<&str> {
        UpdateAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAliasError {
    /// Creates a new `UpdateAliasError`.
    pub fn new(kind: UpdateAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAliasErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UpdateAliasErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UpdateAliasErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAliasErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAliasErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateAliasErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateAliasErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UpdateAliasErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAliasErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateAliasErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCodeSigningConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateCodeSigningConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCodeSigningConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCodeSigningConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCodeSigningConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateCodeSigningConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateCodeSigningConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCodeSigningConfigError {
    fn code(&self) -> Option<&str> {
        UpdateCodeSigningConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCodeSigningConfigError {
    /// Creates a new `UpdateCodeSigningConfigError`.
    pub fn new(kind: UpdateCodeSigningConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCodeSigningConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCodeSigningConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCodeSigningConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCodeSigningConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCodeSigningConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCodeSigningConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCodeSigningConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCodeSigningConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCodeSigningConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCodeSigningConfigErrorKind::ServiceException(_)
        )
    }
}
impl std::error::Error for UpdateCodeSigningConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCodeSigningConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateCodeSigningConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateCodeSigningConfigErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateCodeSigningConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEventSourceMappingError {
    /// Kind of error that occurred.
    pub kind: UpdateEventSourceMappingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEventSourceMapping` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEventSourceMappingErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The operation conflicts with the resource's availability. For example, you attempted to update an EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING state.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEventSourceMappingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateEventSourceMappingErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            UpdateEventSourceMappingErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEventSourceMappingErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateEventSourceMappingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateEventSourceMappingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEventSourceMappingError {
    fn code(&self) -> Option<&str> {
        UpdateEventSourceMappingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEventSourceMappingError {
    /// Creates a new `UpdateEventSourceMappingError`.
    pub fn new(kind: UpdateEventSourceMappingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEventSourceMappingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEventSourceMappingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEventSourceMappingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEventSourceMappingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEventSourceMappingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEventSourceMappingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateEventSourceMappingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEventSourceMappingErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateEventSourceMappingErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UpdateEventSourceMappingErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateEventSourceMappingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEventSourceMappingErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateEventSourceMappingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateEventSourceMappingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFunctionCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFunctionCodeError {
    /// Kind of error that occurred.
    pub kind: UpdateFunctionCodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFunctionCode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFunctionCodeErrorKind {
    /// <p>The specified code signing configuration does not exist.</p>
    CodeSigningConfigNotFoundException(crate::error::CodeSigningConfigNotFoundException),
    /// <p>You have exceeded your maximum total code size per account. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
    CodeStorageExceededException(crate::error::CodeStorageExceededException),
    /// <p>The code signature failed one or more of the validation checks for signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the deployment. </p>
    CodeVerificationFailedException(crate::error::CodeVerificationFailedException),
    /// <p>The code signature failed the integrity check. Lambda always blocks deployment if the integrity check fails, even if code signing policy is set to WARN.</p>
    InvalidCodeSignatureException(crate::error::InvalidCodeSignatureException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFunctionCodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFunctionCodeErrorKind::CodeSigningConfigNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionCodeErrorKind::CodeStorageExceededException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::CodeVerificationFailedException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::InvalidCodeSignatureException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::PreconditionFailedException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFunctionCodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFunctionCodeError {
    fn code(&self) -> Option<&str> {
        UpdateFunctionCodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFunctionCodeError {
    /// Creates a new `UpdateFunctionCodeError`.
    pub fn new(kind: UpdateFunctionCodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFunctionCodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFunctionCodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFunctionCodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFunctionCodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::CodeSigningConfigNotFoundException`.
    pub fn is_code_signing_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::CodeSigningConfigNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::CodeStorageExceededException`.
    pub fn is_code_storage_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::CodeStorageExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::CodeVerificationFailedException`.
    pub fn is_code_verification_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::CodeVerificationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::InvalidCodeSignatureException`.
    pub fn is_invalid_code_signature_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::InvalidCodeSignatureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, UpdateFunctionCodeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `UpdateFunctionCodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionCodeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFunctionCodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFunctionCodeErrorKind::CodeSigningConfigNotFoundException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::CodeStorageExceededException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::CodeVerificationFailedException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::InvalidCodeSignatureException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::PreconditionFailedException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFunctionCodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFunctionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFunctionConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateFunctionConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFunctionConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFunctionConfigurationErrorKind {
    /// <p>The specified code signing configuration does not exist.</p>
    CodeSigningConfigNotFoundException(crate::error::CodeSigningConfigNotFoundException),
    /// <p>The code signature failed one or more of the validation checks for signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the deployment. </p>
    CodeVerificationFailedException(crate::error::CodeVerificationFailedException),
    /// <p>The code signature failed the integrity check. Lambda always blocks deployment if the integrity check fails, even if code signing policy is set to WARN.</p>
    InvalidCodeSignatureException(crate::error::InvalidCodeSignatureException),
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
    PreconditionFailedException(crate::error::PreconditionFailedException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFunctionConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFunctionConfigurationErrorKind::CodeSigningConfigNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::CodeVerificationFailedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::InvalidCodeSignatureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::PreconditionFailedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionConfigurationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateFunctionConfigurationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFunctionConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFunctionConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateFunctionConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFunctionConfigurationError {
    /// Creates a new `UpdateFunctionConfigurationError`.
    pub fn new(kind: UpdateFunctionConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFunctionConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFunctionConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFunctionConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFunctionConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::CodeSigningConfigNotFoundException`.
    pub fn is_code_signing_config_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::CodeSigningConfigNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::CodeVerificationFailedException`.
    pub fn is_code_verification_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::CodeVerificationFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::InvalidCodeSignatureException`.
    pub fn is_invalid_code_signature_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::InvalidCodeSignatureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::PreconditionFailedException`.
    pub fn is_precondition_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::PreconditionFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionConfigurationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionConfigurationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFunctionConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFunctionConfigurationErrorKind::CodeSigningConfigNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionConfigurationErrorKind::CodeVerificationFailedException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionConfigurationErrorKind::InvalidCodeSignatureException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionConfigurationErrorKind::PreconditionFailedException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionConfigurationErrorKind::ResourceConflictException(_inner) => Some(_inner),
            UpdateFunctionConfigurationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFunctionConfigurationErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateFunctionConfigurationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFunctionConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFunctionEventInvokeConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateFunctionEventInvokeConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFunctionEventInvokeConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFunctionEventInvokeConfigErrorKind {
    /// <p>One of the parameters in the request is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The resource already exists, or another operation is in progress.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The resource specified in the request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The Lambda service encountered an internal error.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>The request throughput limit was exceeded.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFunctionEventInvokeConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => _inner.fmt(f),
            UpdateFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            UpdateFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFunctionEventInvokeConfigError {
    fn code(&self) -> Option<&str> {
        UpdateFunctionEventInvokeConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFunctionEventInvokeConfigError {
    /// Creates a new `UpdateFunctionEventInvokeConfigError`.
    pub fn new(
        kind: UpdateFunctionEventInvokeConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFunctionEventInvokeConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFunctionEventInvokeConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFunctionEventInvokeConfigErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFunctionEventInvokeConfigErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionEventInvokeConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionEventInvokeConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionEventInvokeConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionEventInvokeConfigErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionEventInvokeConfigErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFunctionEventInvokeConfigErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFunctionEventInvokeConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionEventInvokeConfigErrorKind::ServiceException(_inner) => Some(_inner),
            UpdateFunctionEventInvokeConfigErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            UpdateFunctionEventInvokeConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request throughput limit was exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// <p>The number of seconds the caller should wait before retrying.</p>
    pub retry_after_seconds: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub reason: std::option::Option<crate::model::ThrottleReason>,
}
impl TooManyRequestsException {
    /// <p>The number of seconds the caller should wait before retrying.</p>
    pub fn retry_after_seconds(&self) -> std::option::Option<&str> {
        self.retry_after_seconds.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn reason(&self) -> std::option::Option<&crate::model::ThrottleReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) retry_after_seconds: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ThrottleReason>,
    }
    impl Builder {
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn retry_after_seconds(mut self, input: impl Into<std::string::String>) -> Self {
            self.retry_after_seconds = Some(input.into());
            self
        }
        /// <p>The number of seconds the caller should wait before retrying.</p>
        pub fn set_retry_after_seconds(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.retry_after_seconds = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn reason(mut self, input: crate::model::ThrottleReason) -> Self {
            self.reason = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ThrottleReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                retry_after_seconds: self.retry_after_seconds,
                r#type: self.r#type,
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The Lambda service encountered an internal error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ServiceException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceException {}
/// See [`ServiceException`](crate::error::ServiceException)
pub mod service_exception {
    /// A builder for [`ServiceException`](crate::error::ServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceException`](crate::error::ServiceException)
        pub fn build(self) -> crate::error::ServiceException {
            crate::error::ServiceException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ServiceException {
    /// Creates a new builder-style object to manufacture [`ServiceException`](crate::error::ServiceException)
    pub fn builder() -> crate::error::service_exception::Builder {
        crate::error::service_exception::Builder::default()
    }
}

/// <p>The resource specified in the request does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The resource already exists, or another operation is in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConflictException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceConflictException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConflictException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceConflictException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceConflictException {}
/// See [`ResourceConflictException`](crate::error::ResourceConflictException)
pub mod resource_conflict_exception {
    /// A builder for [`ResourceConflictException`](crate::error::ResourceConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConflictException`](crate::error::ResourceConflictException)
        pub fn build(self) -> crate::error::ResourceConflictException {
            crate::error::ResourceConflictException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ResourceConflictException {
    /// Creates a new builder-style object to manufacture [`ResourceConflictException`](crate::error::ResourceConflictException)
    pub fn builder() -> crate::error::resource_conflict_exception::Builder {
        crate::error::resource_conflict_exception::Builder::default()
    }
}

/// <p>One of the parameters in the request is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InvalidParameterValueException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreconditionFailedException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl PreconditionFailedException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreconditionFailedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PreconditionFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PreconditionFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PreconditionFailedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for PreconditionFailedException {}
/// See [`PreconditionFailedException`](crate::error::PreconditionFailedException)
pub mod precondition_failed_exception {
    /// A builder for [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PreconditionFailedException`](crate::error::PreconditionFailedException)
        pub fn build(self) -> crate::error::PreconditionFailedException {
            crate::error::PreconditionFailedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl PreconditionFailedException {
    /// Creates a new builder-style object to manufacture [`PreconditionFailedException`](crate::error::PreconditionFailedException)
    pub fn builder() -> crate::error::precondition_failed_exception::Builder {
        crate::error::precondition_failed_exception::Builder::default()
    }
}

/// <p>The code signature failed the integrity check. Lambda always blocks deployment if the integrity check fails, even if code signing policy is set to WARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCodeSignatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidCodeSignatureException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidCodeSignatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCodeSignatureException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCodeSignatureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCodeSignatureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCodeSignatureException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCodeSignatureException {}
/// See [`InvalidCodeSignatureException`](crate::error::InvalidCodeSignatureException)
pub mod invalid_code_signature_exception {
    /// A builder for [`InvalidCodeSignatureException`](crate::error::InvalidCodeSignatureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCodeSignatureException`](crate::error::InvalidCodeSignatureException)
        pub fn build(self) -> crate::error::InvalidCodeSignatureException {
            crate::error::InvalidCodeSignatureException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidCodeSignatureException {
    /// Creates a new builder-style object to manufacture [`InvalidCodeSignatureException`](crate::error::InvalidCodeSignatureException)
    pub fn builder() -> crate::error::invalid_code_signature_exception::Builder {
        crate::error::invalid_code_signature_exception::Builder::default()
    }
}

/// <p>The code signature failed one or more of the validation checks for signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the deployment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeVerificationFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl CodeVerificationFailedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for CodeVerificationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeVerificationFailedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeVerificationFailedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeVerificationFailedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeVerificationFailedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeVerificationFailedException {}
/// See [`CodeVerificationFailedException`](crate::error::CodeVerificationFailedException)
pub mod code_verification_failed_exception {
    /// A builder for [`CodeVerificationFailedException`](crate::error::CodeVerificationFailedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeVerificationFailedException`](crate::error::CodeVerificationFailedException)
        pub fn build(self) -> crate::error::CodeVerificationFailedException {
            crate::error::CodeVerificationFailedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl CodeVerificationFailedException {
    /// Creates a new builder-style object to manufacture [`CodeVerificationFailedException`](crate::error::CodeVerificationFailedException)
    pub fn builder() -> crate::error::code_verification_failed_exception::Builder {
        crate::error::code_verification_failed_exception::Builder::default()
    }
}

/// <p>The specified code signing configuration does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeSigningConfigNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl CodeSigningConfigNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for CodeSigningConfigNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeSigningConfigNotFoundException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeSigningConfigNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeSigningConfigNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeSigningConfigNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeSigningConfigNotFoundException {}
/// See [`CodeSigningConfigNotFoundException`](crate::error::CodeSigningConfigNotFoundException)
pub mod code_signing_config_not_found_exception {
    /// A builder for [`CodeSigningConfigNotFoundException`](crate::error::CodeSigningConfigNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeSigningConfigNotFoundException`](crate::error::CodeSigningConfigNotFoundException)
        pub fn build(self) -> crate::error::CodeSigningConfigNotFoundException {
            crate::error::CodeSigningConfigNotFoundException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl CodeSigningConfigNotFoundException {
    /// Creates a new builder-style object to manufacture [`CodeSigningConfigNotFoundException`](crate::error::CodeSigningConfigNotFoundException)
    pub fn builder() -> crate::error::code_signing_config_not_found_exception::Builder {
        crate::error::code_signing_config_not_found_exception::Builder::default()
    }
}

/// <p>You have exceeded your maximum total code size per account. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeStorageExceededException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl CodeStorageExceededException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for CodeStorageExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeStorageExceededException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CodeStorageExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CodeStorageExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CodeStorageExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for CodeStorageExceededException {}
/// See [`CodeStorageExceededException`](crate::error::CodeStorageExceededException)
pub mod code_storage_exceeded_exception {
    /// A builder for [`CodeStorageExceededException`](crate::error::CodeStorageExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeStorageExceededException`](crate::error::CodeStorageExceededException)
        pub fn build(self) -> crate::error::CodeStorageExceededException {
            crate::error::CodeStorageExceededException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl CodeStorageExceededException {
    /// Creates a new builder-style object to manufacture [`CodeStorageExceededException`](crate::error::CodeStorageExceededException)
    pub fn builder() -> crate::error::code_storage_exceeded_exception::Builder {
        crate::error::code_storage_exceeded_exception::Builder::default()
    }
}

/// <p>The operation conflicts with the resource's availability. For example, you attempted to update an EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The runtime or runtime version specified is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRuntimeException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidRuntimeException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidRuntimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRuntimeException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRuntimeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRuntimeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRuntimeException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRuntimeException {}
/// See [`InvalidRuntimeException`](crate::error::InvalidRuntimeException)
pub mod invalid_runtime_exception {
    /// A builder for [`InvalidRuntimeException`](crate::error::InvalidRuntimeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRuntimeException`](crate::error::InvalidRuntimeException)
        pub fn build(self) -> crate::error::InvalidRuntimeException {
            crate::error::InvalidRuntimeException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidRuntimeException {
    /// Creates a new builder-style object to manufacture [`InvalidRuntimeException`](crate::error::InvalidRuntimeException)
    pub fn builder() -> crate::error::invalid_runtime_exception::Builder {
        crate::error::invalid_runtime_exception::Builder::default()
    }
}

/// <p>The request body could not be parsed as JSON.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestContentException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InvalidRequestContentException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidRequestContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestContentException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestContentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestContentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestContentException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestContentException {}
/// See [`InvalidRequestContentException`](crate::error::InvalidRequestContentException)
pub mod invalid_request_content_exception {
    /// A builder for [`InvalidRequestContentException`](crate::error::InvalidRequestContentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestContentException`](crate::error::InvalidRequestContentException)
        pub fn build(self) -> crate::error::InvalidRequestContentException {
            crate::error::InvalidRequestContentException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestContentException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestContentException`](crate::error::InvalidRequestContentException)
    pub fn builder() -> crate::error::invalid_request_content_exception::Builder {
        crate::error::invalid_request_content_exception::Builder::default()
    }
}

/// <p>The content type of the <code>Invoke</code> request body is not JSON.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedMediaTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl UnsupportedMediaTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for UnsupportedMediaTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedMediaTypeException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedMediaTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedMediaTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedMediaTypeException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedMediaTypeException {}
/// See [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
pub mod unsupported_media_type_exception {
    /// A builder for [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
        pub fn build(self) -> crate::error::UnsupportedMediaTypeException {
            crate::error::UnsupportedMediaTypeException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl UnsupportedMediaTypeException {
    /// Creates a new builder-style object to manufacture [`UnsupportedMediaTypeException`](crate::error::UnsupportedMediaTypeException)
    pub fn builder() -> crate::error::unsupported_media_type_exception::Builder {
        crate::error::unsupported_media_type_exception::Builder::default()
    }
}

/// <p>Lambda was not able to set up VPC access for the Lambda function because one or more configured subnets has no available IP addresses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetIpAddressLimitReachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl SubnetIpAddressLimitReachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for SubnetIpAddressLimitReachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetIpAddressLimitReachedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetIpAddressLimitReachedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetIpAddressLimitReachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "SubnetIpAddressLimitReachedException [SubnetIPAddressLimitReachedException]"
        )?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetIpAddressLimitReachedException {}
/// See [`SubnetIpAddressLimitReachedException`](crate::error::SubnetIpAddressLimitReachedException)
pub mod subnet_ip_address_limit_reached_exception {
    /// A builder for [`SubnetIpAddressLimitReachedException`](crate::error::SubnetIpAddressLimitReachedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetIpAddressLimitReachedException`](crate::error::SubnetIpAddressLimitReachedException)
        pub fn build(self) -> crate::error::SubnetIpAddressLimitReachedException {
            crate::error::SubnetIpAddressLimitReachedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl SubnetIpAddressLimitReachedException {
    /// Creates a new builder-style object to manufacture [`SubnetIpAddressLimitReachedException`](crate::error::SubnetIpAddressLimitReachedException)
    pub fn builder() -> crate::error::subnet_ip_address_limit_reached_exception::Builder {
        crate::error::subnet_ip_address_limit_reached_exception::Builder::default()
    }
}

/// <p>The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to reestablish and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotReadyException {
    /// <p>The exception type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The exception message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotReadyException {
    /// <p>The exception type.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotReadyException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotReadyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotReadyException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotReadyException {}
/// See [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
pub mod resource_not_ready_exception {
    /// A builder for [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The exception type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The exception type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The exception message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The exception message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
        pub fn build(self) -> crate::error::ResourceNotReadyException {
            crate::error::ResourceNotReadyException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ResourceNotReadyException {
    /// Creates a new builder-style object to manufacture [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    pub fn builder() -> crate::error::resource_not_ready_exception::Builder {
        crate::error::resource_not_ready_exception::Builder::default()
    }
}

/// <p>The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl RequestTooLargeException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for RequestTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestTooLargeException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestTooLargeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestTooLargeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestTooLargeException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestTooLargeException {}
/// See [`RequestTooLargeException`](crate::error::RequestTooLargeException)
pub mod request_too_large_exception {
    /// A builder for [`RequestTooLargeException`](crate::error::RequestTooLargeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestTooLargeException`](crate::error::RequestTooLargeException)
        pub fn build(self) -> crate::error::RequestTooLargeException {
            crate::error::RequestTooLargeException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl RequestTooLargeException {
    /// Creates a new builder-style object to manufacture [`RequestTooLargeException`](crate::error::RequestTooLargeException)
    pub fn builder() -> crate::error::request_too_large_exception::Builder {
        crate::error::request_too_large_exception::Builder::default()
    }
}

/// <p>Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the function's KMS key settings. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl KmsNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsNotFoundException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsNotFoundException [KMSNotFoundException]")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsNotFoundException {}
/// See [`KmsNotFoundException`](crate::error::KmsNotFoundException)
pub mod kms_not_found_exception {
    /// A builder for [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsNotFoundException`](crate::error::KmsNotFoundException)
        pub fn build(self) -> crate::error::KmsNotFoundException {
            crate::error::KmsNotFoundException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl KmsNotFoundException {
    /// Creates a new builder-style object to manufacture [`KmsNotFoundException`](crate::error::KmsNotFoundException)
    pub fn builder() -> crate::error::kms_not_found_exception::Builder {
        crate::error::kms_not_found_exception::Builder::default()
    }
}

/// <p>Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state for Decrypt. Check the function's KMS key settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl KmsInvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidStateException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInvalidStateException [KMSInvalidStateException]")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidStateException {}
/// See [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
pub mod kms_invalid_state_exception {
    /// A builder for [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
        pub fn build(self) -> crate::error::KmsInvalidStateException {
            crate::error::KmsInvalidStateException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl KmsInvalidStateException {
    /// Creates a new builder-style object to manufacture [`KmsInvalidStateException`](crate::error::KmsInvalidStateException)
    pub fn builder() -> crate::error::kms_invalid_state_exception::Builder {
        crate::error::kms_invalid_state_exception::Builder::default()
    }
}

/// <p>Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the Lambda function's KMS key settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl KmsDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsDisabledException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsDisabledException [KMSDisabledException]")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsDisabledException {}
/// See [`KmsDisabledException`](crate::error::KmsDisabledException)
pub mod kms_disabled_exception {
    /// A builder for [`KmsDisabledException`](crate::error::KmsDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsDisabledException`](crate::error::KmsDisabledException)
        pub fn build(self) -> crate::error::KmsDisabledException {
            crate::error::KmsDisabledException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl KmsDisabledException {
    /// Creates a new builder-style object to manufacture [`KmsDisabledException`](crate::error::KmsDisabledException)
    pub fn builder() -> crate::error::kms_disabled_exception::Builder {
        crate::error::kms_disabled_exception::Builder::default()
    }
}

/// <p>Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda function's KMS permissions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsAccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl KmsAccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsAccessDeniedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsAccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsAccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsAccessDeniedException [KMSAccessDeniedException]")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsAccessDeniedException {}
/// See [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
pub mod kms_access_denied_exception {
    /// A builder for [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
        pub fn build(self) -> crate::error::KmsAccessDeniedException {
            crate::error::KmsAccessDeniedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl KmsAccessDeniedException {
    /// Creates a new builder-style object to manufacture [`KmsAccessDeniedException`](crate::error::KmsAccessDeniedException)
    pub fn builder() -> crate::error::kms_access_denied_exception::Builder {
        crate::error::kms_access_denied_exception::Builder::default()
    }
}

/// <p>Lambda could not unzip the deployment package.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidZipFileException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidZipFileException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidZipFileException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidZipFileException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidZipFileException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidZipFileException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidZipFileException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidZipFileException {}
/// See [`InvalidZipFileException`](crate::error::InvalidZipFileException)
pub mod invalid_zip_file_exception {
    /// A builder for [`InvalidZipFileException`](crate::error::InvalidZipFileException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidZipFileException`](crate::error::InvalidZipFileException)
        pub fn build(self) -> crate::error::InvalidZipFileException {
            crate::error::InvalidZipFileException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidZipFileException {
    /// Creates a new builder-style object to manufacture [`InvalidZipFileException`](crate::error::InvalidZipFileException)
    pub fn builder() -> crate::error::invalid_zip_file_exception::Builder {
        crate::error::invalid_zip_file_exception::Builder::default()
    }
}

/// <p>The Subnet ID provided in the Lambda function VPC configuration is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnetIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidSubnetIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidSubnetIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnetIdException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnetIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnetIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnetIdException [InvalidSubnetIDException]")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnetIdException {}
/// See [`InvalidSubnetIdException`](crate::error::InvalidSubnetIdException)
pub mod invalid_subnet_id_exception {
    /// A builder for [`InvalidSubnetIdException`](crate::error::InvalidSubnetIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnetIdException`](crate::error::InvalidSubnetIdException)
        pub fn build(self) -> crate::error::InvalidSubnetIdException {
            crate::error::InvalidSubnetIdException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidSubnetIdException {
    /// Creates a new builder-style object to manufacture [`InvalidSubnetIdException`](crate::error::InvalidSubnetIdException)
    pub fn builder() -> crate::error::invalid_subnet_id_exception::Builder {
        crate::error::invalid_subnet_id_exception::Builder::default()
    }
}

/// <p>The Security Group ID provided in the Lambda function VPC configuration is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSecurityGroupIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidSecurityGroupIdException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for InvalidSecurityGroupIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSecurityGroupIdException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSecurityGroupIdException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSecurityGroupIdException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidSecurityGroupIdException [InvalidSecurityGroupIDException]"
        )?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSecurityGroupIdException {}
/// See [`InvalidSecurityGroupIdException`](crate::error::InvalidSecurityGroupIdException)
pub mod invalid_security_group_id_exception {
    /// A builder for [`InvalidSecurityGroupIdException`](crate::error::InvalidSecurityGroupIdException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSecurityGroupIdException`](crate::error::InvalidSecurityGroupIdException)
        pub fn build(self) -> crate::error::InvalidSecurityGroupIdException {
            crate::error::InvalidSecurityGroupIdException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl InvalidSecurityGroupIdException {
    /// Creates a new builder-style object to manufacture [`InvalidSecurityGroupIdException`](crate::error::InvalidSecurityGroupIdException)
    pub fn builder() -> crate::error::invalid_security_group_id_exception::Builder {
        crate::error::invalid_security_group_id_exception::Builder::default()
    }
}

/// <p>Lambda was not able to create an elastic network interface in the VPC, specified as part of Lambda function configuration, because the limit for network interfaces has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EniLimitReachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl EniLimitReachedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EniLimitReachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EniLimitReachedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EniLimitReachedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EniLimitReachedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EniLimitReachedException [ENILimitReachedException]")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for EniLimitReachedException {}
/// See [`EniLimitReachedException`](crate::error::EniLimitReachedException)
pub mod eni_limit_reached_exception {
    /// A builder for [`EniLimitReachedException`](crate::error::EniLimitReachedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EniLimitReachedException`](crate::error::EniLimitReachedException)
        pub fn build(self) -> crate::error::EniLimitReachedException {
            crate::error::EniLimitReachedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl EniLimitReachedException {
    /// Creates a new builder-style object to manufacture [`EniLimitReachedException`](crate::error::EniLimitReachedException)
    pub fn builder() -> crate::error::eni_limit_reached_exception::Builder {
        crate::error::eni_limit_reached_exception::Builder::default()
    }
}

/// <p>The function was able to make a network connection to the configured file system, but the mount operation timed out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsMountTimeoutException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl EfsMountTimeoutException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EfsMountTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsMountTimeoutException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EfsMountTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EfsMountTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EfsMountTimeoutException [EFSMountTimeoutException]")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for EfsMountTimeoutException {}
/// See [`EfsMountTimeoutException`](crate::error::EfsMountTimeoutException)
pub mod efs_mount_timeout_exception {
    /// A builder for [`EfsMountTimeoutException`](crate::error::EfsMountTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsMountTimeoutException`](crate::error::EfsMountTimeoutException)
        pub fn build(self) -> crate::error::EfsMountTimeoutException {
            crate::error::EfsMountTimeoutException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl EfsMountTimeoutException {
    /// Creates a new builder-style object to manufacture [`EfsMountTimeoutException`](crate::error::EfsMountTimeoutException)
    pub fn builder() -> crate::error::efs_mount_timeout_exception::Builder {
        crate::error::efs_mount_timeout_exception::Builder::default()
    }
}

/// <p>The function couldn't mount the configured file system due to a permission or configuration issue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsMountFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl EfsMountFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EfsMountFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsMountFailureException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EfsMountFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EfsMountFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EfsMountFailureException [EFSMountFailureException]")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for EfsMountFailureException {}
/// See [`EfsMountFailureException`](crate::error::EfsMountFailureException)
pub mod efs_mount_failure_exception {
    /// A builder for [`EfsMountFailureException`](crate::error::EfsMountFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsMountFailureException`](crate::error::EfsMountFailureException)
        pub fn build(self) -> crate::error::EfsMountFailureException {
            crate::error::EfsMountFailureException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl EfsMountFailureException {
    /// Creates a new builder-style object to manufacture [`EfsMountFailureException`](crate::error::EfsMountFailureException)
    pub fn builder() -> crate::error::efs_mount_failure_exception::Builder {
        crate::error::efs_mount_failure_exception::Builder::default()
    }
}

/// <p>The function couldn't make a network connection to the configured file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsMountConnectivityException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl EfsMountConnectivityException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EfsMountConnectivityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsMountConnectivityException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EfsMountConnectivityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EfsMountConnectivityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "EfsMountConnectivityException [EFSMountConnectivityException]"
        )?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for EfsMountConnectivityException {}
/// See [`EfsMountConnectivityException`](crate::error::EfsMountConnectivityException)
pub mod efs_mount_connectivity_exception {
    /// A builder for [`EfsMountConnectivityException`](crate::error::EfsMountConnectivityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsMountConnectivityException`](crate::error::EfsMountConnectivityException)
        pub fn build(self) -> crate::error::EfsMountConnectivityException {
            crate::error::EfsMountConnectivityException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl EfsMountConnectivityException {
    /// Creates a new builder-style object to manufacture [`EfsMountConnectivityException`](crate::error::EfsMountConnectivityException)
    pub fn builder() -> crate::error::efs_mount_connectivity_exception::Builder {
        crate::error::efs_mount_connectivity_exception::Builder::default()
    }
}

/// <p>An error occurred when reading from or writing to a connected file system.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EfsioException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl EfsioException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for EfsioException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EfsioException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EfsioException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EfsioException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EfsioException [EFSIOException]")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for EfsioException {}
/// See [`EfsioException`](crate::error::EfsioException)
pub mod efsio_exception {
    /// A builder for [`EfsioException`](crate::error::EfsioException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EfsioException`](crate::error::EfsioException)
        pub fn build(self) -> crate::error::EfsioException {
            crate::error::EfsioException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl EfsioException {
    /// Creates a new builder-style object to manufacture [`EfsioException`](crate::error::EfsioException)
    pub fn builder() -> crate::error::efsio_exception::Builder {
        crate::error::efsio_exception::Builder::default()
    }
}

/// <p>Lambda received an unexpected EC2 client exception while setting up for the Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2UnexpectedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub ec2_error_code: std::option::Option<std::string::String>,
}
impl Ec2UnexpectedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn ec2_error_code(&self) -> std::option::Option<&str> {
        self.ec2_error_code.as_deref()
    }
}
impl std::fmt::Debug for Ec2UnexpectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2UnexpectedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.field("ec2_error_code", &self.ec2_error_code);
        formatter.finish()
    }
}
impl Ec2UnexpectedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2UnexpectedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "Ec2UnexpectedException [EC2UnexpectedException]")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2UnexpectedException {}
/// See [`Ec2UnexpectedException`](crate::error::Ec2UnexpectedException)
pub mod ec2_unexpected_exception {
    /// A builder for [`Ec2UnexpectedException`](crate::error::Ec2UnexpectedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) ec2_error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn ec2_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_ec2_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2UnexpectedException`](crate::error::Ec2UnexpectedException)
        pub fn build(self) -> crate::error::Ec2UnexpectedException {
            crate::error::Ec2UnexpectedException {
                r#type: self.r#type,
                message: self.message,
                ec2_error_code: self.ec2_error_code,
            }
        }
    }
}
impl Ec2UnexpectedException {
    /// Creates a new builder-style object to manufacture [`Ec2UnexpectedException`](crate::error::Ec2UnexpectedException)
    pub fn builder() -> crate::error::ec2_unexpected_exception::Builder {
        crate::error::ec2_unexpected_exception::Builder::default()
    }
}

/// <p>Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role provided for the Lambda function.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2ThrottledException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl Ec2ThrottledException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Ec2ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2ThrottledException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl Ec2ThrottledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2ThrottledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "Ec2ThrottledException [EC2ThrottledException]")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2ThrottledException {}
/// See [`Ec2ThrottledException`](crate::error::Ec2ThrottledException)
pub mod ec2_throttled_exception {
    /// A builder for [`Ec2ThrottledException`](crate::error::Ec2ThrottledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2ThrottledException`](crate::error::Ec2ThrottledException)
        pub fn build(self) -> crate::error::Ec2ThrottledException {
            crate::error::Ec2ThrottledException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl Ec2ThrottledException {
    /// Creates a new builder-style object to manufacture [`Ec2ThrottledException`](crate::error::Ec2ThrottledException)
    pub fn builder() -> crate::error::ec2_throttled_exception::Builder {
        crate::error::ec2_throttled_exception::Builder::default()
    }
}

/// <p>Need additional permissions to configure VPC settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl Ec2AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for Ec2AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2AccessDeniedException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl Ec2AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for Ec2AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "Ec2AccessDeniedException [EC2AccessDeniedException]")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for Ec2AccessDeniedException {}
/// See [`Ec2AccessDeniedException`](crate::error::Ec2AccessDeniedException)
pub mod ec2_access_denied_exception {
    /// A builder for [`Ec2AccessDeniedException`](crate::error::Ec2AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2AccessDeniedException`](crate::error::Ec2AccessDeniedException)
        pub fn build(self) -> crate::error::Ec2AccessDeniedException {
            crate::error::Ec2AccessDeniedException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl Ec2AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`Ec2AccessDeniedException`](crate::error::Ec2AccessDeniedException)
    pub fn builder() -> crate::error::ec2_access_denied_exception::Builder {
        crate::error::ec2_access_denied_exception::Builder::default()
    }
}

/// <p>The specified configuration does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedConcurrencyConfigNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ProvisionedConcurrencyConfigNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for ProvisionedConcurrencyConfigNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedConcurrencyConfigNotFoundException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProvisionedConcurrencyConfigNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedConcurrencyConfigNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ProvisionedConcurrencyConfigNotFoundException")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedConcurrencyConfigNotFoundException {}
/// See [`ProvisionedConcurrencyConfigNotFoundException`](crate::error::ProvisionedConcurrencyConfigNotFoundException)
pub mod provisioned_concurrency_config_not_found_exception {
    /// A builder for [`ProvisionedConcurrencyConfigNotFoundException`](crate::error::ProvisionedConcurrencyConfigNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedConcurrencyConfigNotFoundException`](crate::error::ProvisionedConcurrencyConfigNotFoundException)
        pub fn build(self) -> crate::error::ProvisionedConcurrencyConfigNotFoundException {
            crate::error::ProvisionedConcurrencyConfigNotFoundException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl ProvisionedConcurrencyConfigNotFoundException {
    /// Creates a new builder-style object to manufacture [`ProvisionedConcurrencyConfigNotFoundException`](crate::error::ProvisionedConcurrencyConfigNotFoundException)
    pub fn builder() -> crate::error::provisioned_concurrency_config_not_found_exception::Builder {
        crate::error::provisioned_concurrency_config_not_found_exception::Builder::default()
    }
}

/// <p>The permissions policy for the resource is too large. <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyLengthExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub r#type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl PolicyLengthExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for PolicyLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyLengthExceededException");
        formatter.field("r#type", &self.r#type);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyLengthExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyLengthExceededException")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyLengthExceededException {}
/// See [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
pub mod policy_length_exceeded_exception {
    /// A builder for [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
        pub fn build(self) -> crate::error::PolicyLengthExceededException {
            crate::error::PolicyLengthExceededException {
                r#type: self.r#type,
                message: self.message,
            }
        }
    }
}
impl PolicyLengthExceededException {
    /// Creates a new builder-style object to manufacture [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
    pub fn builder() -> crate::error::policy_length_exceeded_exception::Builder {
        crate::error::policy_length_exceeded_exception::Builder::default()
    }
}
