// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl UpdateFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateFunctionEventInvokeConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionEventInvokeConfigOutput");
        formatter.field("last_modified", &self.last_modified);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}
/// See [`UpdateFunctionEventInvokeConfigOutput`](crate::output::UpdateFunctionEventInvokeConfigOutput)
pub mod update_function_event_invoke_config_output {
    /// A builder for [`UpdateFunctionEventInvokeConfigOutput`](crate::output::UpdateFunctionEventInvokeConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionEventInvokeConfigOutput`](crate::output::UpdateFunctionEventInvokeConfigOutput)
        pub fn build(self) -> crate::output::UpdateFunctionEventInvokeConfigOutput {
            crate::output::UpdateFunctionEventInvokeConfigOutput {
                last_modified: self.last_modified,
                function_arn: self.function_arn,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            }
        }
    }
}
impl UpdateFunctionEventInvokeConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionEventInvokeConfigOutput`](crate::output::UpdateFunctionEventInvokeConfigOutput)
    pub fn builder() -> crate::output::update_function_event_invoke_config_output::Builder {
        crate::output::update_function_event_invoke_config_output::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionConfigurationOutput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl UpdateFunctionConfigurationOutput {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for UpdateFunctionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionConfigurationOutput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`UpdateFunctionConfigurationOutput`](crate::output::UpdateFunctionConfigurationOutput)
pub mod update_function_configuration_output {
    /// A builder for [`UpdateFunctionConfigurationOutput`](crate::output::UpdateFunctionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionConfigurationOutput`](crate::output::UpdateFunctionConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateFunctionConfigurationOutput {
            crate::output::UpdateFunctionConfigurationOutput {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl UpdateFunctionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionConfigurationOutput`](crate::output::UpdateFunctionConfigurationOutput)
    pub fn builder() -> crate::output::update_function_configuration_output::Builder {
        crate::output::update_function_configuration_output::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionCodeOutput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl UpdateFunctionCodeOutput {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for UpdateFunctionCodeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionCodeOutput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`UpdateFunctionCodeOutput`](crate::output::UpdateFunctionCodeOutput)
pub mod update_function_code_output {
    /// A builder for [`UpdateFunctionCodeOutput`](crate::output::UpdateFunctionCodeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionCodeOutput`](crate::output::UpdateFunctionCodeOutput)
        pub fn build(self) -> crate::output::UpdateFunctionCodeOutput {
            crate::output::UpdateFunctionCodeOutput {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl UpdateFunctionCodeOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionCodeOutput`](crate::output::UpdateFunctionCodeOutput)
    pub fn builder() -> crate::output::update_function_code_output::Builder {
        crate::output::update_function_code_output::Builder::default()
    }
}

/// <p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub last_processing_result: std::option::Option<std::string::String>,
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl UpdateEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub fn last_processing_result(&self) -> std::option::Option<&str> {
        self.last_processing_result.as_deref()
    }
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for UpdateEventSourceMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventSourceMappingOutput");
        formatter.field("uuid", &self.uuid);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("batch_size", &self.batch_size);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_processing_result", &self.last_processing_result);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("destination_config", &self.destination_config);
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}
/// See [`UpdateEventSourceMappingOutput`](crate::output::UpdateEventSourceMappingOutput)
pub mod update_event_source_mapping_output {
    /// A builder for [`UpdateEventSourceMappingOutput`](crate::output::UpdateEventSourceMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_processing_result: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn last_processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_processing_result = Some(input.into());
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn set_last_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_processing_result = input;
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input.into());
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input.into());
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventSourceMappingOutput`](crate::output::UpdateEventSourceMappingOutput)
        pub fn build(self) -> crate::output::UpdateEventSourceMappingOutput {
            crate::output::UpdateEventSourceMappingOutput {
                uuid: self.uuid,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                batch_size: self.batch_size,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                event_source_arn: self.event_source_arn,
                function_arn: self.function_arn,
                last_modified: self.last_modified,
                last_processing_result: self.last_processing_result,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                destination_config: self.destination_config,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            }
        }
    }
}
impl UpdateEventSourceMappingOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEventSourceMappingOutput`](crate::output::UpdateEventSourceMappingOutput)
    pub fn builder() -> crate::output::update_event_source_mapping_output::Builder {
        crate::output::update_event_source_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCodeSigningConfigOutput {
    /// <p>The code signing configuration</p>
    pub code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
}
impl UpdateCodeSigningConfigOutput {
    /// <p>The code signing configuration</p>
    pub fn code_signing_config(&self) -> std::option::Option<&crate::model::CodeSigningConfig> {
        self.code_signing_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCodeSigningConfigOutput");
        formatter.field("code_signing_config", &self.code_signing_config);
        formatter.finish()
    }
}
/// See [`UpdateCodeSigningConfigOutput`](crate::output::UpdateCodeSigningConfigOutput)
pub mod update_code_signing_config_output {
    /// A builder for [`UpdateCodeSigningConfigOutput`](crate::output::UpdateCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
    }
    impl Builder {
        /// <p>The code signing configuration</p>
        pub fn code_signing_config(mut self, input: crate::model::CodeSigningConfig) -> Self {
            self.code_signing_config = Some(input);
            self
        }
        /// <p>The code signing configuration</p>
        pub fn set_code_signing_config(
            mut self,
            input: std::option::Option<crate::model::CodeSigningConfig>,
        ) -> Self {
            self.code_signing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCodeSigningConfigOutput`](crate::output::UpdateCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::UpdateCodeSigningConfigOutput {
            crate::output::UpdateCodeSigningConfigOutput {
                code_signing_config: self.code_signing_config,
            }
        }
    }
}
impl UpdateCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCodeSigningConfigOutput`](crate::output::UpdateCodeSigningConfigOutput)
    pub fn builder() -> crate::output::update_code_signing_config_output::Builder {
        crate::output::update_code_signing_config_output::Builder::default()
    }
}

/// <p>Provides configuration information about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl UpdateAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAliasOutput");
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
pub mod update_alias_output {
    /// A builder for [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
        pub fn build(self) -> crate::output::UpdateAliasOutput {
            crate::output::UpdateAliasOutput {
                alias_arn: self.alias_arn,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
                revision_id: self.revision_id,
            }
        }
    }
}
impl UpdateAliasOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAliasOutput`](crate::output::UpdateAliasOutput)
    pub fn builder() -> crate::output::update_alias_output::Builder {
        crate::output::update_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionOutput {}
impl std::fmt::Debug for RemovePermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionOutput");
        formatter.finish()
    }
}
/// See [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
pub mod remove_permission_output {
    /// A builder for [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
        pub fn build(self) -> crate::output::RemovePermissionOutput {
            crate::output::RemovePermissionOutput {}
        }
    }
}
impl RemovePermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemovePermissionOutput`](crate::output::RemovePermissionOutput)
    pub fn builder() -> crate::output::remove_permission_output::Builder {
        crate::output::remove_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveLayerVersionPermissionOutput {}
impl std::fmt::Debug for RemoveLayerVersionPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveLayerVersionPermissionOutput");
        formatter.finish()
    }
}
/// See [`RemoveLayerVersionPermissionOutput`](crate::output::RemoveLayerVersionPermissionOutput)
pub mod remove_layer_version_permission_output {
    /// A builder for [`RemoveLayerVersionPermissionOutput`](crate::output::RemoveLayerVersionPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveLayerVersionPermissionOutput`](crate::output::RemoveLayerVersionPermissionOutput)
        pub fn build(self) -> crate::output::RemoveLayerVersionPermissionOutput {
            crate::output::RemoveLayerVersionPermissionOutput {}
        }
    }
}
impl RemoveLayerVersionPermissionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveLayerVersionPermissionOutput`](crate::output::RemoveLayerVersionPermissionOutput)
    pub fn builder() -> crate::output::remove_layer_version_permission_output::Builder {
        crate::output::remove_layer_version_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProvisionedConcurrencyConfigOutput {
    /// <p>The amount of provisioned concurrency requested.</p>
    pub requested_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency available.</p>
    pub available_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub allocated_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The status of the allocation process.</p>
    pub status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub last_modified: std::option::Option<std::string::String>,
}
impl PutProvisionedConcurrencyConfigOutput {
    /// <p>The amount of provisioned concurrency requested.</p>
    pub fn requested_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.requested_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency available.</p>
    pub fn available_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.available_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub fn allocated_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.allocated_provisioned_concurrent_executions
    }
    /// <p>The status of the allocation process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProvisionedConcurrencyStatusEnum> {
        self.status.as_ref()
    }
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
}
impl std::fmt::Debug for PutProvisionedConcurrencyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProvisionedConcurrencyConfigOutput");
        formatter.field(
            "requested_provisioned_concurrent_executions",
            &self.requested_provisioned_concurrent_executions,
        );
        formatter.field(
            "available_provisioned_concurrent_executions",
            &self.available_provisioned_concurrent_executions,
        );
        formatter.field(
            "allocated_provisioned_concurrent_executions",
            &self.allocated_provisioned_concurrent_executions,
        );
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`PutProvisionedConcurrencyConfigOutput`](crate::output::PutProvisionedConcurrencyConfigOutput)
pub mod put_provisioned_concurrency_config_output {
    /// A builder for [`PutProvisionedConcurrencyConfigOutput`](crate::output::PutProvisionedConcurrencyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) requested_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) available_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) allocated_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn requested_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.requested_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn set_requested_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.requested_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn available_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.available_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn set_available_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.available_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn allocated_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.allocated_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn set_allocated_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocated_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn status(mut self, input: crate::model::ProvisionedConcurrencyStatusEnum) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProvisionedConcurrencyConfigOutput`](crate::output::PutProvisionedConcurrencyConfigOutput)
        pub fn build(self) -> crate::output::PutProvisionedConcurrencyConfigOutput {
            crate::output::PutProvisionedConcurrencyConfigOutput {
                requested_provisioned_concurrent_executions: self
                    .requested_provisioned_concurrent_executions,
                available_provisioned_concurrent_executions: self
                    .available_provisioned_concurrent_executions,
                allocated_provisioned_concurrent_executions: self
                    .allocated_provisioned_concurrent_executions,
                status: self.status,
                status_reason: self.status_reason,
                last_modified: self.last_modified,
            }
        }
    }
}
impl PutProvisionedConcurrencyConfigOutput {
    /// Creates a new builder-style object to manufacture [`PutProvisionedConcurrencyConfigOutput`](crate::output::PutProvisionedConcurrencyConfigOutput)
    pub fn builder() -> crate::output::put_provisioned_concurrency_config_output::Builder {
        crate::output::put_provisioned_concurrency_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl PutFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for PutFunctionEventInvokeConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionEventInvokeConfigOutput");
        formatter.field("last_modified", &self.last_modified);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}
/// See [`PutFunctionEventInvokeConfigOutput`](crate::output::PutFunctionEventInvokeConfigOutput)
pub mod put_function_event_invoke_config_output {
    /// A builder for [`PutFunctionEventInvokeConfigOutput`](crate::output::PutFunctionEventInvokeConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionEventInvokeConfigOutput`](crate::output::PutFunctionEventInvokeConfigOutput)
        pub fn build(self) -> crate::output::PutFunctionEventInvokeConfigOutput {
            crate::output::PutFunctionEventInvokeConfigOutput {
                last_modified: self.last_modified,
                function_arn: self.function_arn,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            }
        }
    }
}
impl PutFunctionEventInvokeConfigOutput {
    /// Creates a new builder-style object to manufacture [`PutFunctionEventInvokeConfigOutput`](crate::output::PutFunctionEventInvokeConfigOutput)
    pub fn builder() -> crate::output::put_function_event_invoke_config_output::Builder {
        crate::output::put_function_event_invoke_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionConcurrencyOutput {
    /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
    pub reserved_concurrent_executions: std::option::Option<i32>,
}
impl PutFunctionConcurrencyOutput {
    /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
    pub fn reserved_concurrent_executions(&self) -> std::option::Option<i32> {
        self.reserved_concurrent_executions
    }
}
impl std::fmt::Debug for PutFunctionConcurrencyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionConcurrencyOutput");
        formatter.field(
            "reserved_concurrent_executions",
            &self.reserved_concurrent_executions,
        );
        formatter.finish()
    }
}
/// See [`PutFunctionConcurrencyOutput`](crate::output::PutFunctionConcurrencyOutput)
pub mod put_function_concurrency_output {
    /// A builder for [`PutFunctionConcurrencyOutput`](crate::output::PutFunctionConcurrencyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
        pub fn reserved_concurrent_executions(mut self, input: i32) -> Self {
            self.reserved_concurrent_executions = Some(input);
            self
        }
        /// <p>The number of concurrent executions that are reserved for this function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-concurrency.html">Managing Concurrency</a>.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reserved_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionConcurrencyOutput`](crate::output::PutFunctionConcurrencyOutput)
        pub fn build(self) -> crate::output::PutFunctionConcurrencyOutput {
            crate::output::PutFunctionConcurrencyOutput {
                reserved_concurrent_executions: self.reserved_concurrent_executions,
            }
        }
    }
}
impl PutFunctionConcurrencyOutput {
    /// Creates a new builder-style object to manufacture [`PutFunctionConcurrencyOutput`](crate::output::PutFunctionConcurrencyOutput)
    pub fn builder() -> crate::output::put_function_concurrency_output::Builder {
        crate::output::put_function_concurrency_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionCodeSigningConfigOutput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title">
    /// <b>Name formats</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function name</b> - <code>MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
    /// characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl PutFunctionCodeSigningConfigOutput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title">
    /// <b>Name formats</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function name</b> - <code>MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
    /// characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for PutFunctionCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionCodeSigningConfigOutput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}
/// See [`PutFunctionCodeSigningConfigOutput`](crate::output::PutFunctionCodeSigningConfigOutput)
pub mod put_function_code_signing_config_output {
    /// A builder for [`PutFunctionCodeSigningConfigOutput`](crate::output::PutFunctionCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionCodeSigningConfigOutput`](crate::output::PutFunctionCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::PutFunctionCodeSigningConfigOutput {
            crate::output::PutFunctionCodeSigningConfigOutput {
                code_signing_config_arn: self.code_signing_config_arn,
                function_name: self.function_name,
            }
        }
    }
}
impl PutFunctionCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`PutFunctionCodeSigningConfigOutput`](crate::output::PutFunctionCodeSigningConfigOutput)
    pub fn builder() -> crate::output::put_function_code_signing_config_output::Builder {
        crate::output::put_function_code_signing_config_output::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishVersionOutput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl PublishVersionOutput {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for PublishVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishVersionOutput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`PublishVersionOutput`](crate::output::PublishVersionOutput)
pub mod publish_version_output {
    /// A builder for [`PublishVersionOutput`](crate::output::PublishVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishVersionOutput`](crate::output::PublishVersionOutput)
        pub fn build(self) -> crate::output::PublishVersionOutput {
            crate::output::PublishVersionOutput {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl PublishVersionOutput {
    /// Creates a new builder-style object to manufacture [`PublishVersionOutput`](crate::output::PublishVersionOutput)
    pub fn builder() -> crate::output::publish_version_output::Builder {
        crate::output::publish_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishLayerVersionOutput {
    /// <p>Details about the layer version.</p>
    pub content: std::option::Option<crate::model::LayerVersionContentOutput>,
    /// <p>The ARN of the layer.</p>
    pub layer_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the layer version.</p>
    pub layer_version_arn: std::option::Option<std::string::String>,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub created_date: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version: i64,
    /// <p>The layer's compatible runtimes.</p>
    pub compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
    /// <p>The layer's software license.</p>
    pub license_info: std::option::Option<std::string::String>,
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub compatible_architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl PublishLayerVersionOutput {
    /// <p>Details about the layer version.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::LayerVersionContentOutput> {
        self.content.as_ref()
    }
    /// <p>The ARN of the layer.</p>
    pub fn layer_arn(&self) -> std::option::Option<&str> {
        self.layer_arn.as_deref()
    }
    /// <p>The ARN of the layer version.</p>
    pub fn layer_version_arn(&self) -> std::option::Option<&str> {
        self.layer_version_arn.as_deref()
    }
    /// <p>The description of the version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn created_date(&self) -> std::option::Option<&str> {
        self.created_date.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The layer's compatible runtimes.</p>
    pub fn compatible_runtimes(&self) -> std::option::Option<&[crate::model::Runtime]> {
        self.compatible_runtimes.as_deref()
    }
    /// <p>The layer's software license.</p>
    pub fn license_info(&self) -> std::option::Option<&str> {
        self.license_info.as_deref()
    }
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub fn compatible_architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.compatible_architectures.as_deref()
    }
}
impl std::fmt::Debug for PublishLayerVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishLayerVersionOutput");
        formatter.field("content", &self.content);
        formatter.field("layer_arn", &self.layer_arn);
        formatter.field("layer_version_arn", &self.layer_version_arn);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("compatible_runtimes", &self.compatible_runtimes);
        formatter.field("license_info", &self.license_info);
        formatter.field("compatible_architectures", &self.compatible_architectures);
        formatter.finish()
    }
}
/// See [`PublishLayerVersionOutput`](crate::output::PublishLayerVersionOutput)
pub mod publish_layer_version_output {
    /// A builder for [`PublishLayerVersionOutput`](crate::output::PublishLayerVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::LayerVersionContentOutput>,
        pub(crate) layer_arn: std::option::Option<std::string::String>,
        pub(crate) layer_version_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        pub(crate) license_info: std::option::Option<std::string::String>,
        pub(crate) compatible_architectures:
            std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>Details about the layer version.</p>
        pub fn content(mut self, input: crate::model::LayerVersionContentOutput) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Details about the layer version.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentOutput>,
        ) -> Self {
            self.content = input;
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn layer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn set_layer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_arn = input;
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn layer_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_layer_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.layer_version_arn = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn created_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_date = Some(input.into());
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_created_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `compatible_runtimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>The layer's compatible runtimes.</p>
        pub fn compatible_runtimes(mut self, input: impl Into<crate::model::Runtime>) -> Self {
            let mut v = self.compatible_runtimes.unwrap_or_default();
            v.push(input.into());
            self.compatible_runtimes = Some(v);
            self
        }
        /// <p>The layer's compatible runtimes.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.compatible_runtimes = input;
            self
        }
        /// <p>The layer's software license.</p>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_info = Some(input.into());
            self
        }
        /// <p>The layer's software license.</p>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_info = input;
            self
        }
        /// Appends an item to `compatible_architectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(
            mut self,
            input: impl Into<crate::model::Architecture>,
        ) -> Self {
            let mut v = self.compatible_architectures.unwrap_or_default();
            v.push(input.into());
            self.compatible_architectures = Some(v);
            self
        }
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.compatible_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishLayerVersionOutput`](crate::output::PublishLayerVersionOutput)
        pub fn build(self) -> crate::output::PublishLayerVersionOutput {
            crate::output::PublishLayerVersionOutput {
                content: self.content,
                layer_arn: self.layer_arn,
                layer_version_arn: self.layer_version_arn,
                description: self.description,
                created_date: self.created_date,
                version: self.version.unwrap_or_default(),
                compatible_runtimes: self.compatible_runtimes,
                license_info: self.license_info,
                compatible_architectures: self.compatible_architectures,
            }
        }
    }
}
impl PublishLayerVersionOutput {
    /// Creates a new builder-style object to manufacture [`PublishLayerVersionOutput`](crate::output::PublishLayerVersionOutput)
    pub fn builder() -> crate::output::publish_layer_version_output::Builder {
        crate::output::publish_layer_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVersionsByFunctionOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of Lambda function versions.</p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
}
impl ListVersionsByFunctionOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of Lambda function versions.</p>
    pub fn versions(&self) -> std::option::Option<&[crate::model::FunctionConfiguration]> {
        self.versions.as_deref()
    }
}
impl std::fmt::Debug for ListVersionsByFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVersionsByFunctionOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("versions", &self.versions);
        formatter.finish()
    }
}
/// See [`ListVersionsByFunctionOutput`](crate::output::ListVersionsByFunctionOutput)
pub mod list_versions_by_function_output {
    /// A builder for [`ListVersionsByFunctionOutput`](crate::output::ListVersionsByFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) versions:
            std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
    }
    impl Builder {
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>A list of Lambda function versions.</p>
        pub fn versions(mut self, input: impl Into<crate::model::FunctionConfiguration>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>A list of Lambda function versions.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVersionsByFunctionOutput`](crate::output::ListVersionsByFunctionOutput)
        pub fn build(self) -> crate::output::ListVersionsByFunctionOutput {
            crate::output::ListVersionsByFunctionOutput {
                next_marker: self.next_marker,
                versions: self.versions,
            }
        }
    }
}
impl ListVersionsByFunctionOutput {
    /// Creates a new builder-style object to manufacture [`ListVersionsByFunctionOutput`](crate::output::ListVersionsByFunctionOutput)
    pub fn builder() -> crate::output::list_versions_by_function_output::Builder {
        crate::output::list_versions_by_function_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsOutput {
    /// <p>The function's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsOutput {
    /// <p>The function's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsOutput`](crate::output::ListTagsOutput)
pub mod list_tags_output {
    /// A builder for [`ListTagsOutput`](crate::output::ListTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The function's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The function's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsOutput`](crate::output::ListTagsOutput)
        pub fn build(self) -> crate::output::ListTagsOutput {
            crate::output::ListTagsOutput { tags: self.tags }
        }
    }
}
impl ListTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsOutput`](crate::output::ListTagsOutput)
    pub fn builder() -> crate::output::list_tags_output::Builder {
        crate::output::list_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedConcurrencyConfigsOutput {
    /// <p>A list of provisioned concurrency configurations.</p>
    pub provisioned_concurrency_configs:
        std::option::Option<std::vec::Vec<crate::model::ProvisionedConcurrencyConfigListItem>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListProvisionedConcurrencyConfigsOutput {
    /// <p>A list of provisioned concurrency configurations.</p>
    pub fn provisioned_concurrency_configs(
        &self,
    ) -> std::option::Option<&[crate::model::ProvisionedConcurrencyConfigListItem]> {
        self.provisioned_concurrency_configs.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListProvisionedConcurrencyConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedConcurrencyConfigsOutput");
        formatter.field(
            "provisioned_concurrency_configs",
            &self.provisioned_concurrency_configs,
        );
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListProvisionedConcurrencyConfigsOutput`](crate::output::ListProvisionedConcurrencyConfigsOutput)
pub mod list_provisioned_concurrency_configs_output {
    /// A builder for [`ListProvisionedConcurrencyConfigsOutput`](crate::output::ListProvisionedConcurrencyConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provisioned_concurrency_configs:
            std::option::Option<std::vec::Vec<crate::model::ProvisionedConcurrencyConfigListItem>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `provisioned_concurrency_configs`.
        ///
        /// To override the contents of this collection use [`set_provisioned_concurrency_configs`](Self::set_provisioned_concurrency_configs).
        ///
        /// <p>A list of provisioned concurrency configurations.</p>
        pub fn provisioned_concurrency_configs(
            mut self,
            input: impl Into<crate::model::ProvisionedConcurrencyConfigListItem>,
        ) -> Self {
            let mut v = self.provisioned_concurrency_configs.unwrap_or_default();
            v.push(input.into());
            self.provisioned_concurrency_configs = Some(v);
            self
        }
        /// <p>A list of provisioned concurrency configurations.</p>
        pub fn set_provisioned_concurrency_configs(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ProvisionedConcurrencyConfigListItem>,
            >,
        ) -> Self {
            self.provisioned_concurrency_configs = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedConcurrencyConfigsOutput`](crate::output::ListProvisionedConcurrencyConfigsOutput)
        pub fn build(self) -> crate::output::ListProvisionedConcurrencyConfigsOutput {
            crate::output::ListProvisionedConcurrencyConfigsOutput {
                provisioned_concurrency_configs: self.provisioned_concurrency_configs,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListProvisionedConcurrencyConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListProvisionedConcurrencyConfigsOutput`](crate::output::ListProvisionedConcurrencyConfigsOutput)
    pub fn builder() -> crate::output::list_provisioned_concurrency_configs_output::Builder {
        crate::output::list_provisioned_concurrency_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLayerVersionsOutput {
    /// <p>A pagination token returned when the response doesn't contain all versions.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of versions.</p>
    pub layer_versions: std::option::Option<std::vec::Vec<crate::model::LayerVersionsListItem>>,
}
impl ListLayerVersionsOutput {
    /// <p>A pagination token returned when the response doesn't contain all versions.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of versions.</p>
    pub fn layer_versions(&self) -> std::option::Option<&[crate::model::LayerVersionsListItem]> {
        self.layer_versions.as_deref()
    }
}
impl std::fmt::Debug for ListLayerVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLayerVersionsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("layer_versions", &self.layer_versions);
        formatter.finish()
    }
}
/// See [`ListLayerVersionsOutput`](crate::output::ListLayerVersionsOutput)
pub mod list_layer_versions_output {
    /// A builder for [`ListLayerVersionsOutput`](crate::output::ListLayerVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) layer_versions:
            std::option::Option<std::vec::Vec<crate::model::LayerVersionsListItem>>,
    }
    impl Builder {
        /// <p>A pagination token returned when the response doesn't contain all versions.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A pagination token returned when the response doesn't contain all versions.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `layer_versions`.
        ///
        /// To override the contents of this collection use [`set_layer_versions`](Self::set_layer_versions).
        ///
        /// <p>A list of versions.</p>
        pub fn layer_versions(
            mut self,
            input: impl Into<crate::model::LayerVersionsListItem>,
        ) -> Self {
            let mut v = self.layer_versions.unwrap_or_default();
            v.push(input.into());
            self.layer_versions = Some(v);
            self
        }
        /// <p>A list of versions.</p>
        pub fn set_layer_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LayerVersionsListItem>>,
        ) -> Self {
            self.layer_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLayerVersionsOutput`](crate::output::ListLayerVersionsOutput)
        pub fn build(self) -> crate::output::ListLayerVersionsOutput {
            crate::output::ListLayerVersionsOutput {
                next_marker: self.next_marker,
                layer_versions: self.layer_versions,
            }
        }
    }
}
impl ListLayerVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListLayerVersionsOutput`](crate::output::ListLayerVersionsOutput)
    pub fn builder() -> crate::output::list_layer_versions_output::Builder {
        crate::output::list_layer_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLayersOutput {
    /// <p>A pagination token returned when the response doesn't contain all layers.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of function layers.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::LayersListItem>>,
}
impl ListLayersOutput {
    /// <p>A pagination token returned when the response doesn't contain all layers.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of function layers.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::LayersListItem]> {
        self.layers.as_deref()
    }
}
impl std::fmt::Debug for ListLayersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLayersOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("layers", &self.layers);
        formatter.finish()
    }
}
/// See [`ListLayersOutput`](crate::output::ListLayersOutput)
pub mod list_layers_output {
    /// A builder for [`ListLayersOutput`](crate::output::ListLayersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::LayersListItem>>,
    }
    impl Builder {
        /// <p>A pagination token returned when the response doesn't contain all layers.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A pagination token returned when the response doesn't contain all layers.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of function layers.</p>
        pub fn layers(mut self, input: impl Into<crate::model::LayersListItem>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>A list of function layers.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LayersListItem>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLayersOutput`](crate::output::ListLayersOutput)
        pub fn build(self) -> crate::output::ListLayersOutput {
            crate::output::ListLayersOutput {
                next_marker: self.next_marker,
                layers: self.layers,
            }
        }
    }
}
impl ListLayersOutput {
    /// Creates a new builder-style object to manufacture [`ListLayersOutput`](crate::output::ListLayersOutput)
    pub fn builder() -> crate::output::list_layers_output::Builder {
        crate::output::list_layers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsByCodeSigningConfigOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>The function ARNs. </p>
    pub function_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListFunctionsByCodeSigningConfigOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>The function ARNs. </p>
    pub fn function_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.function_arns.as_deref()
    }
}
impl std::fmt::Debug for ListFunctionsByCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsByCodeSigningConfigOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("function_arns", &self.function_arns);
        formatter.finish()
    }
}
/// See [`ListFunctionsByCodeSigningConfigOutput`](crate::output::ListFunctionsByCodeSigningConfigOutput)
pub mod list_functions_by_code_signing_config_output {
    /// A builder for [`ListFunctionsByCodeSigningConfigOutput`](crate::output::ListFunctionsByCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) function_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `function_arns`.
        ///
        /// To override the contents of this collection use [`set_function_arns`](Self::set_function_arns).
        ///
        /// <p>The function ARNs. </p>
        pub fn function_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.function_arns.unwrap_or_default();
            v.push(input.into());
            self.function_arns = Some(v);
            self
        }
        /// <p>The function ARNs. </p>
        pub fn set_function_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.function_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsByCodeSigningConfigOutput`](crate::output::ListFunctionsByCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::ListFunctionsByCodeSigningConfigOutput {
            crate::output::ListFunctionsByCodeSigningConfigOutput {
                next_marker: self.next_marker,
                function_arns: self.function_arns,
            }
        }
    }
}
impl ListFunctionsByCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`ListFunctionsByCodeSigningConfigOutput`](crate::output::ListFunctionsByCodeSigningConfigOutput)
    pub fn builder() -> crate::output::list_functions_by_code_signing_config_output::Builder {
        crate::output::list_functions_by_code_signing_config_output::Builder::default()
    }
}

/// <p>A list of Lambda functions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of Lambda functions.</p>
    pub functions: std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
}
impl ListFunctionsOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of Lambda functions.</p>
    pub fn functions(&self) -> std::option::Option<&[crate::model::FunctionConfiguration]> {
        self.functions.as_deref()
    }
}
impl std::fmt::Debug for ListFunctionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("functions", &self.functions);
        formatter.finish()
    }
}
/// See [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
pub mod list_functions_output {
    /// A builder for [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) functions:
            std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
    }
    impl Builder {
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>A list of Lambda functions.</p>
        pub fn functions(mut self, input: impl Into<crate::model::FunctionConfiguration>) -> Self {
            let mut v = self.functions.unwrap_or_default();
            v.push(input.into());
            self.functions = Some(v);
            self
        }
        /// <p>A list of Lambda functions.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionConfiguration>>,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
        pub fn build(self) -> crate::output::ListFunctionsOutput {
            crate::output::ListFunctionsOutput {
                next_marker: self.next_marker,
                functions: self.functions,
            }
        }
    }
}
impl ListFunctionsOutput {
    /// Creates a new builder-style object to manufacture [`ListFunctionsOutput`](crate::output::ListFunctionsOutput)
    pub fn builder() -> crate::output::list_functions_output::Builder {
        crate::output::list_functions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionEventInvokeConfigsOutput {
    /// <p>A list of configurations.</p>
    pub function_event_invoke_configs:
        std::option::Option<std::vec::Vec<crate::model::FunctionEventInvokeConfig>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
}
impl ListFunctionEventInvokeConfigsOutput {
    /// <p>A list of configurations.</p>
    pub fn function_event_invoke_configs(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionEventInvokeConfig]> {
        self.function_event_invoke_configs.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
}
impl std::fmt::Debug for ListFunctionEventInvokeConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionEventInvokeConfigsOutput");
        formatter.field(
            "function_event_invoke_configs",
            &self.function_event_invoke_configs,
        );
        formatter.field("next_marker", &self.next_marker);
        formatter.finish()
    }
}
/// See [`ListFunctionEventInvokeConfigsOutput`](crate::output::ListFunctionEventInvokeConfigsOutput)
pub mod list_function_event_invoke_configs_output {
    /// A builder for [`ListFunctionEventInvokeConfigsOutput`](crate::output::ListFunctionEventInvokeConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_event_invoke_configs:
            std::option::Option<std::vec::Vec<crate::model::FunctionEventInvokeConfig>>,
        pub(crate) next_marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `function_event_invoke_configs`.
        ///
        /// To override the contents of this collection use [`set_function_event_invoke_configs`](Self::set_function_event_invoke_configs).
        ///
        /// <p>A list of configurations.</p>
        pub fn function_event_invoke_configs(
            mut self,
            input: impl Into<crate::model::FunctionEventInvokeConfig>,
        ) -> Self {
            let mut v = self.function_event_invoke_configs.unwrap_or_default();
            v.push(input.into());
            self.function_event_invoke_configs = Some(v);
            self
        }
        /// <p>A list of configurations.</p>
        pub fn set_function_event_invoke_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionEventInvokeConfig>>,
        ) -> Self {
            self.function_event_invoke_configs = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionEventInvokeConfigsOutput`](crate::output::ListFunctionEventInvokeConfigsOutput)
        pub fn build(self) -> crate::output::ListFunctionEventInvokeConfigsOutput {
            crate::output::ListFunctionEventInvokeConfigsOutput {
                function_event_invoke_configs: self.function_event_invoke_configs,
                next_marker: self.next_marker,
            }
        }
    }
}
impl ListFunctionEventInvokeConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListFunctionEventInvokeConfigsOutput`](crate::output::ListFunctionEventInvokeConfigsOutput)
    pub fn builder() -> crate::output::list_function_event_invoke_configs_output::Builder {
        crate::output::list_function_event_invoke_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventSourceMappingsOutput {
    /// <p>A pagination token that's returned when the response doesn't contain all event source mappings.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of event source mappings.</p>
    pub event_source_mappings:
        std::option::Option<std::vec::Vec<crate::model::EventSourceMappingConfiguration>>,
}
impl ListEventSourceMappingsOutput {
    /// <p>A pagination token that's returned when the response doesn't contain all event source mappings.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of event source mappings.</p>
    pub fn event_source_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::EventSourceMappingConfiguration]> {
        self.event_source_mappings.as_deref()
    }
}
impl std::fmt::Debug for ListEventSourceMappingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventSourceMappingsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("event_source_mappings", &self.event_source_mappings);
        formatter.finish()
    }
}
/// See [`ListEventSourceMappingsOutput`](crate::output::ListEventSourceMappingsOutput)
pub mod list_event_source_mappings_output {
    /// A builder for [`ListEventSourceMappingsOutput`](crate::output::ListEventSourceMappingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) event_source_mappings:
            std::option::Option<std::vec::Vec<crate::model::EventSourceMappingConfiguration>>,
    }
    impl Builder {
        /// <p>A pagination token that's returned when the response doesn't contain all event source mappings.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>A pagination token that's returned when the response doesn't contain all event source mappings.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `event_source_mappings`.
        ///
        /// To override the contents of this collection use [`set_event_source_mappings`](Self::set_event_source_mappings).
        ///
        /// <p>A list of event source mappings.</p>
        pub fn event_source_mappings(
            mut self,
            input: impl Into<crate::model::EventSourceMappingConfiguration>,
        ) -> Self {
            let mut v = self.event_source_mappings.unwrap_or_default();
            v.push(input.into());
            self.event_source_mappings = Some(v);
            self
        }
        /// <p>A list of event source mappings.</p>
        pub fn set_event_source_mappings(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::EventSourceMappingConfiguration>,
            >,
        ) -> Self {
            self.event_source_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventSourceMappingsOutput`](crate::output::ListEventSourceMappingsOutput)
        pub fn build(self) -> crate::output::ListEventSourceMappingsOutput {
            crate::output::ListEventSourceMappingsOutput {
                next_marker: self.next_marker,
                event_source_mappings: self.event_source_mappings,
            }
        }
    }
}
impl ListEventSourceMappingsOutput {
    /// Creates a new builder-style object to manufacture [`ListEventSourceMappingsOutput`](crate::output::ListEventSourceMappingsOutput)
    pub fn builder() -> crate::output::list_event_source_mappings_output::Builder {
        crate::output::list_event_source_mappings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCodeSigningConfigsOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>The code signing configurations</p>
    pub code_signing_configs: std::option::Option<std::vec::Vec<crate::model::CodeSigningConfig>>,
}
impl ListCodeSigningConfigsOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>The code signing configurations</p>
    pub fn code_signing_configs(&self) -> std::option::Option<&[crate::model::CodeSigningConfig]> {
        self.code_signing_configs.as_deref()
    }
}
impl std::fmt::Debug for ListCodeSigningConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCodeSigningConfigsOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("code_signing_configs", &self.code_signing_configs);
        formatter.finish()
    }
}
/// See [`ListCodeSigningConfigsOutput`](crate::output::ListCodeSigningConfigsOutput)
pub mod list_code_signing_configs_output {
    /// A builder for [`ListCodeSigningConfigsOutput`](crate::output::ListCodeSigningConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) code_signing_configs:
            std::option::Option<std::vec::Vec<crate::model::CodeSigningConfig>>,
    }
    impl Builder {
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `code_signing_configs`.
        ///
        /// To override the contents of this collection use [`set_code_signing_configs`](Self::set_code_signing_configs).
        ///
        /// <p>The code signing configurations</p>
        pub fn code_signing_configs(
            mut self,
            input: impl Into<crate::model::CodeSigningConfig>,
        ) -> Self {
            let mut v = self.code_signing_configs.unwrap_or_default();
            v.push(input.into());
            self.code_signing_configs = Some(v);
            self
        }
        /// <p>The code signing configurations</p>
        pub fn set_code_signing_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeSigningConfig>>,
        ) -> Self {
            self.code_signing_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCodeSigningConfigsOutput`](crate::output::ListCodeSigningConfigsOutput)
        pub fn build(self) -> crate::output::ListCodeSigningConfigsOutput {
            crate::output::ListCodeSigningConfigsOutput {
                next_marker: self.next_marker,
                code_signing_configs: self.code_signing_configs,
            }
        }
    }
}
impl ListCodeSigningConfigsOutput {
    /// Creates a new builder-style object to manufacture [`ListCodeSigningConfigsOutput`](crate::output::ListCodeSigningConfigsOutput)
    pub fn builder() -> crate::output::list_code_signing_configs_output::Builder {
        crate::output::list_code_signing_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAliasesOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_marker: std::option::Option<std::string::String>,
    /// <p>A list of aliases.</p>
    pub aliases: std::option::Option<std::vec::Vec<crate::model::AliasConfiguration>>,
}
impl ListAliasesOutput {
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_marker(&self) -> std::option::Option<&str> {
        self.next_marker.as_deref()
    }
    /// <p>A list of aliases.</p>
    pub fn aliases(&self) -> std::option::Option<&[crate::model::AliasConfiguration]> {
        self.aliases.as_deref()
    }
}
impl std::fmt::Debug for ListAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAliasesOutput");
        formatter.field("next_marker", &self.next_marker);
        formatter.field("aliases", &self.aliases);
        formatter.finish()
    }
}
/// See [`ListAliasesOutput`](crate::output::ListAliasesOutput)
pub mod list_aliases_output {
    /// A builder for [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_marker: std::option::Option<std::string::String>,
        pub(crate) aliases: std::option::Option<std::vec::Vec<crate::model::AliasConfiguration>>,
    }
    impl Builder {
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_marker = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_marker = input;
            self
        }
        /// Appends an item to `aliases`.
        ///
        /// To override the contents of this collection use [`set_aliases`](Self::set_aliases).
        ///
        /// <p>A list of aliases.</p>
        pub fn aliases(mut self, input: impl Into<crate::model::AliasConfiguration>) -> Self {
            let mut v = self.aliases.unwrap_or_default();
            v.push(input.into());
            self.aliases = Some(v);
            self
        }
        /// <p>A list of aliases.</p>
        pub fn set_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AliasConfiguration>>,
        ) -> Self {
            self.aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesOutput`](crate::output::ListAliasesOutput)
        pub fn build(self) -> crate::output::ListAliasesOutput {
            crate::output::ListAliasesOutput {
                next_marker: self.next_marker,
                aliases: self.aliases,
            }
        }
    }
}
impl ListAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListAliasesOutput`](crate::output::ListAliasesOutput)
    pub fn builder() -> crate::output::list_aliases_output::Builder {
        crate::output::list_aliases_output::Builder::default()
    }
}

/// <p>A success response (<code>202 Accepted</code>) indicates that the request is queued for invocation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeAsyncOutput {
    /// <p>The status code.</p>
    pub status: i32,
}
impl InvokeAsyncOutput {
    /// <p>The status code.</p>
    pub fn status(&self) -> i32 {
        self.status
    }
}
impl std::fmt::Debug for InvokeAsyncOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeAsyncOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`InvokeAsyncOutput`](crate::output::InvokeAsyncOutput)
pub mod invoke_async_output {
    /// A builder for [`InvokeAsyncOutput`](crate::output::InvokeAsyncOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The status code.</p>
        pub fn status(mut self, input: i32) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status code.</p>
        pub fn set_status(mut self, input: std::option::Option<i32>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeAsyncOutput`](crate::output::InvokeAsyncOutput)
        pub fn build(self) -> crate::output::InvokeAsyncOutput {
            crate::output::InvokeAsyncOutput {
                status: self.status.unwrap_or_default(),
            }
        }
    }
}
impl InvokeAsyncOutput {
    /// Creates a new builder-style object to manufacture [`InvokeAsyncOutput`](crate::output::InvokeAsyncOutput)
    pub fn builder() -> crate::output::invoke_async_output::Builder {
        crate::output::invoke_async_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeOutput {
    /// <p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code>
    /// invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For
    /// the <code>DryRun</code> invocation type, the status code is 204.</p>
    pub status_code: i32,
    /// <p>If present, indicates that an error occurred during function execution. Details about the error are included
    /// in the response payload.</p>
    pub function_error: std::option::Option<std::string::String>,
    /// <p>The last 4 KB of the execution log, which is base64 encoded.</p>
    pub log_result: std::option::Option<std::string::String>,
    /// <p>The response from the function, or an error object.</p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The version of the function that executed. When you invoke a function with an alias, this indicates which
    /// version the alias resolved to.</p>
    pub executed_version: std::option::Option<std::string::String>,
}
impl InvokeOutput {
    /// <p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code>
    /// invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For
    /// the <code>DryRun</code> invocation type, the status code is 204.</p>
    pub fn status_code(&self) -> i32 {
        self.status_code
    }
    /// <p>If present, indicates that an error occurred during function execution. Details about the error are included
    /// in the response payload.</p>
    pub fn function_error(&self) -> std::option::Option<&str> {
        self.function_error.as_deref()
    }
    /// <p>The last 4 KB of the execution log, which is base64 encoded.</p>
    pub fn log_result(&self) -> std::option::Option<&str> {
        self.log_result.as_deref()
    }
    /// <p>The response from the function, or an error object.</p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
    /// <p>The version of the function that executed. When you invoke a function with an alias, this indicates which
    /// version the alias resolved to.</p>
    pub fn executed_version(&self) -> std::option::Option<&str> {
        self.executed_version.as_deref()
    }
}
impl std::fmt::Debug for InvokeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("function_error", &self.function_error);
        formatter.field("log_result", &self.log_result);
        formatter.field("payload", &"*** Sensitive Data Redacted ***");
        formatter.field("executed_version", &self.executed_version);
        formatter.finish()
    }
}
/// See [`InvokeOutput`](crate::output::InvokeOutput)
pub mod invoke_output {
    /// A builder for [`InvokeOutput`](crate::output::InvokeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<i32>,
        pub(crate) function_error: std::option::Option<std::string::String>,
        pub(crate) log_result: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) executed_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code>
        /// invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For
        /// the <code>DryRun</code> invocation type, the status code is 204.</p>
        pub fn status_code(mut self, input: i32) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The HTTP status code is in the 200 range for a successful request. For the <code>RequestResponse</code>
        /// invocation type, this status code is 200. For the <code>Event</code> invocation type, this status code is 202. For
        /// the <code>DryRun</code> invocation type, the status code is 204.</p>
        pub fn set_status_code(mut self, input: std::option::Option<i32>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>If present, indicates that an error occurred during function execution. Details about the error are included
        /// in the response payload.</p>
        pub fn function_error(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_error = Some(input.into());
            self
        }
        /// <p>If present, indicates that an error occurred during function execution. Details about the error are included
        /// in the response payload.</p>
        pub fn set_function_error(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_error = input;
            self
        }
        /// <p>The last 4 KB of the execution log, which is base64 encoded.</p>
        pub fn log_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_result = Some(input.into());
            self
        }
        /// <p>The last 4 KB of the execution log, which is base64 encoded.</p>
        pub fn set_log_result(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_result = input;
            self
        }
        /// <p>The response from the function, or an error object.</p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The response from the function, or an error object.</p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// <p>The version of the function that executed. When you invoke a function with an alias, this indicates which
        /// version the alias resolved to.</p>
        pub fn executed_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.executed_version = Some(input.into());
            self
        }
        /// <p>The version of the function that executed. When you invoke a function with an alias, this indicates which
        /// version the alias resolved to.</p>
        pub fn set_executed_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.executed_version = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeOutput`](crate::output::InvokeOutput)
        pub fn build(self) -> crate::output::InvokeOutput {
            crate::output::InvokeOutput {
                status_code: self.status_code.unwrap_or_default(),
                function_error: self.function_error,
                log_result: self.log_result,
                payload: self.payload,
                executed_version: self.executed_version,
            }
        }
    }
}
impl InvokeOutput {
    /// Creates a new builder-style object to manufacture [`InvokeOutput`](crate::output::InvokeOutput)
    pub fn builder() -> crate::output::invoke_output::Builder {
        crate::output::invoke_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProvisionedConcurrencyConfigOutput {
    /// <p>The amount of provisioned concurrency requested.</p>
    pub requested_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency available.</p>
    pub available_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub allocated_provisioned_concurrent_executions: std::option::Option<i32>,
    /// <p>The status of the allocation process.</p>
    pub status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub last_modified: std::option::Option<std::string::String>,
}
impl GetProvisionedConcurrencyConfigOutput {
    /// <p>The amount of provisioned concurrency requested.</p>
    pub fn requested_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.requested_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency available.</p>
    pub fn available_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.available_provisioned_concurrent_executions
    }
    /// <p>The amount of provisioned concurrency allocated.</p>
    pub fn allocated_provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.allocated_provisioned_concurrent_executions
    }
    /// <p>The status of the allocation process.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ProvisionedConcurrencyStatusEnum> {
        self.status.as_ref()
    }
    /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
}
impl std::fmt::Debug for GetProvisionedConcurrencyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProvisionedConcurrencyConfigOutput");
        formatter.field(
            "requested_provisioned_concurrent_executions",
            &self.requested_provisioned_concurrent_executions,
        );
        formatter.field(
            "available_provisioned_concurrent_executions",
            &self.available_provisioned_concurrent_executions,
        );
        formatter.field(
            "allocated_provisioned_concurrent_executions",
            &self.allocated_provisioned_concurrent_executions,
        );
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("last_modified", &self.last_modified);
        formatter.finish()
    }
}
/// See [`GetProvisionedConcurrencyConfigOutput`](crate::output::GetProvisionedConcurrencyConfigOutput)
pub mod get_provisioned_concurrency_config_output {
    /// A builder for [`GetProvisionedConcurrencyConfigOutput`](crate::output::GetProvisionedConcurrencyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) requested_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) available_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) allocated_provisioned_concurrent_executions: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn requested_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.requested_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency requested.</p>
        pub fn set_requested_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.requested_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn available_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.available_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency available.</p>
        pub fn set_available_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.available_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn allocated_provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.allocated_provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency allocated.</p>
        pub fn set_allocated_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.allocated_provisioned_concurrent_executions = input;
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn status(mut self, input: crate::model::ProvisionedConcurrencyStatusEnum) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the allocation process.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProvisionedConcurrencyStatusEnum>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>For failed allocations, the reason that provisioned concurrency could not be allocated.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that a user last updated the configuration, in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProvisionedConcurrencyConfigOutput`](crate::output::GetProvisionedConcurrencyConfigOutput)
        pub fn build(self) -> crate::output::GetProvisionedConcurrencyConfigOutput {
            crate::output::GetProvisionedConcurrencyConfigOutput {
                requested_provisioned_concurrent_executions: self
                    .requested_provisioned_concurrent_executions,
                available_provisioned_concurrent_executions: self
                    .available_provisioned_concurrent_executions,
                allocated_provisioned_concurrent_executions: self
                    .allocated_provisioned_concurrent_executions,
                status: self.status,
                status_reason: self.status_reason,
                last_modified: self.last_modified,
            }
        }
    }
}
impl GetProvisionedConcurrencyConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetProvisionedConcurrencyConfigOutput`](crate::output::GetProvisionedConcurrencyConfigOutput)
    pub fn builder() -> crate::output::get_provisioned_concurrency_config_output::Builder {
        crate::output::get_provisioned_concurrency_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyOutput {
    /// <p>The resource-based policy.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetPolicyOutput {
    /// <p>The resource-based policy.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`GetPolicyOutput`](crate::output::GetPolicyOutput)
pub mod get_policy_output {
    /// A builder for [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource-based policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The resource-based policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyOutput`](crate::output::GetPolicyOutput)
        pub fn build(self) -> crate::output::GetPolicyOutput {
            crate::output::GetPolicyOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl GetPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    pub fn builder() -> crate::output::get_policy_output::Builder {
        crate::output::get_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionPolicyOutput {
    /// <p>The policy document.</p>
    pub policy: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetLayerVersionPolicyOutput {
    /// <p>The policy document.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetLayerVersionPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`GetLayerVersionPolicyOutput`](crate::output::GetLayerVersionPolicyOutput)
pub mod get_layer_version_policy_output {
    /// A builder for [`GetLayerVersionPolicyOutput`](crate::output::GetLayerVersionPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy document.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionPolicyOutput`](crate::output::GetLayerVersionPolicyOutput)
        pub fn build(self) -> crate::output::GetLayerVersionPolicyOutput {
            crate::output::GetLayerVersionPolicyOutput {
                policy: self.policy,
                revision_id: self.revision_id,
            }
        }
    }
}
impl GetLayerVersionPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionPolicyOutput`](crate::output::GetLayerVersionPolicyOutput)
    pub fn builder() -> crate::output::get_layer_version_policy_output::Builder {
        crate::output::get_layer_version_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionByArnOutput {
    /// <p>Details about the layer version.</p>
    pub content: std::option::Option<crate::model::LayerVersionContentOutput>,
    /// <p>The ARN of the layer.</p>
    pub layer_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the layer version.</p>
    pub layer_version_arn: std::option::Option<std::string::String>,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub created_date: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version: i64,
    /// <p>The layer's compatible runtimes.</p>
    pub compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
    /// <p>The layer's software license.</p>
    pub license_info: std::option::Option<std::string::String>,
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub compatible_architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl GetLayerVersionByArnOutput {
    /// <p>Details about the layer version.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::LayerVersionContentOutput> {
        self.content.as_ref()
    }
    /// <p>The ARN of the layer.</p>
    pub fn layer_arn(&self) -> std::option::Option<&str> {
        self.layer_arn.as_deref()
    }
    /// <p>The ARN of the layer version.</p>
    pub fn layer_version_arn(&self) -> std::option::Option<&str> {
        self.layer_version_arn.as_deref()
    }
    /// <p>The description of the version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn created_date(&self) -> std::option::Option<&str> {
        self.created_date.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The layer's compatible runtimes.</p>
    pub fn compatible_runtimes(&self) -> std::option::Option<&[crate::model::Runtime]> {
        self.compatible_runtimes.as_deref()
    }
    /// <p>The layer's software license.</p>
    pub fn license_info(&self) -> std::option::Option<&str> {
        self.license_info.as_deref()
    }
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub fn compatible_architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.compatible_architectures.as_deref()
    }
}
impl std::fmt::Debug for GetLayerVersionByArnOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionByArnOutput");
        formatter.field("content", &self.content);
        formatter.field("layer_arn", &self.layer_arn);
        formatter.field("layer_version_arn", &self.layer_version_arn);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("compatible_runtimes", &self.compatible_runtimes);
        formatter.field("license_info", &self.license_info);
        formatter.field("compatible_architectures", &self.compatible_architectures);
        formatter.finish()
    }
}
/// See [`GetLayerVersionByArnOutput`](crate::output::GetLayerVersionByArnOutput)
pub mod get_layer_version_by_arn_output {
    /// A builder for [`GetLayerVersionByArnOutput`](crate::output::GetLayerVersionByArnOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::LayerVersionContentOutput>,
        pub(crate) layer_arn: std::option::Option<std::string::String>,
        pub(crate) layer_version_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        pub(crate) license_info: std::option::Option<std::string::String>,
        pub(crate) compatible_architectures:
            std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>Details about the layer version.</p>
        pub fn content(mut self, input: crate::model::LayerVersionContentOutput) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Details about the layer version.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentOutput>,
        ) -> Self {
            self.content = input;
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn layer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn set_layer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_arn = input;
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn layer_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_layer_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.layer_version_arn = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn created_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_date = Some(input.into());
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_created_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `compatible_runtimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>The layer's compatible runtimes.</p>
        pub fn compatible_runtimes(mut self, input: impl Into<crate::model::Runtime>) -> Self {
            let mut v = self.compatible_runtimes.unwrap_or_default();
            v.push(input.into());
            self.compatible_runtimes = Some(v);
            self
        }
        /// <p>The layer's compatible runtimes.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.compatible_runtimes = input;
            self
        }
        /// <p>The layer's software license.</p>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_info = Some(input.into());
            self
        }
        /// <p>The layer's software license.</p>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_info = input;
            self
        }
        /// Appends an item to `compatible_architectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(
            mut self,
            input: impl Into<crate::model::Architecture>,
        ) -> Self {
            let mut v = self.compatible_architectures.unwrap_or_default();
            v.push(input.into());
            self.compatible_architectures = Some(v);
            self
        }
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.compatible_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionByArnOutput`](crate::output::GetLayerVersionByArnOutput)
        pub fn build(self) -> crate::output::GetLayerVersionByArnOutput {
            crate::output::GetLayerVersionByArnOutput {
                content: self.content,
                layer_arn: self.layer_arn,
                layer_version_arn: self.layer_version_arn,
                description: self.description,
                created_date: self.created_date,
                version: self.version.unwrap_or_default(),
                compatible_runtimes: self.compatible_runtimes,
                license_info: self.license_info,
                compatible_architectures: self.compatible_architectures,
            }
        }
    }
}
impl GetLayerVersionByArnOutput {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionByArnOutput`](crate::output::GetLayerVersionByArnOutput)
    pub fn builder() -> crate::output::get_layer_version_by_arn_output::Builder {
        crate::output::get_layer_version_by_arn_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionOutput {
    /// <p>Details about the layer version.</p>
    pub content: std::option::Option<crate::model::LayerVersionContentOutput>,
    /// <p>The ARN of the layer.</p>
    pub layer_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the layer version.</p>
    pub layer_version_arn: std::option::Option<std::string::String>,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub created_date: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version: i64,
    /// <p>The layer's compatible runtimes.</p>
    pub compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
    /// <p>The layer's software license.</p>
    pub license_info: std::option::Option<std::string::String>,
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub compatible_architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl GetLayerVersionOutput {
    /// <p>Details about the layer version.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::LayerVersionContentOutput> {
        self.content.as_ref()
    }
    /// <p>The ARN of the layer.</p>
    pub fn layer_arn(&self) -> std::option::Option<&str> {
        self.layer_arn.as_deref()
    }
    /// <p>The ARN of the layer version.</p>
    pub fn layer_version_arn(&self) -> std::option::Option<&str> {
        self.layer_version_arn.as_deref()
    }
    /// <p>The description of the version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn created_date(&self) -> std::option::Option<&str> {
        self.created_date.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version(&self) -> i64 {
        self.version
    }
    /// <p>The layer's compatible runtimes.</p>
    pub fn compatible_runtimes(&self) -> std::option::Option<&[crate::model::Runtime]> {
        self.compatible_runtimes.as_deref()
    }
    /// <p>The layer's software license.</p>
    pub fn license_info(&self) -> std::option::Option<&str> {
        self.license_info.as_deref()
    }
    /// <p>A list of compatible  
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub fn compatible_architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.compatible_architectures.as_deref()
    }
}
impl std::fmt::Debug for GetLayerVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionOutput");
        formatter.field("content", &self.content);
        formatter.field("layer_arn", &self.layer_arn);
        formatter.field("layer_version_arn", &self.layer_version_arn);
        formatter.field("description", &self.description);
        formatter.field("created_date", &self.created_date);
        formatter.field("version", &self.version);
        formatter.field("compatible_runtimes", &self.compatible_runtimes);
        formatter.field("license_info", &self.license_info);
        formatter.field("compatible_architectures", &self.compatible_architectures);
        formatter.finish()
    }
}
/// See [`GetLayerVersionOutput`](crate::output::GetLayerVersionOutput)
pub mod get_layer_version_output {
    /// A builder for [`GetLayerVersionOutput`](crate::output::GetLayerVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<crate::model::LayerVersionContentOutput>,
        pub(crate) layer_arn: std::option::Option<std::string::String>,
        pub(crate) layer_version_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<i64>,
        pub(crate) compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        pub(crate) license_info: std::option::Option<std::string::String>,
        pub(crate) compatible_architectures:
            std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>Details about the layer version.</p>
        pub fn content(mut self, input: crate::model::LayerVersionContentOutput) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Details about the layer version.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentOutput>,
        ) -> Self {
            self.content = input;
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn layer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer.</p>
        pub fn set_layer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_arn = input;
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn layer_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_layer_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.layer_version_arn = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn created_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_date = Some(input.into());
            self
        }
        /// <p>The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_created_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version(mut self, input: i64) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version(mut self, input: std::option::Option<i64>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `compatible_runtimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>The layer's compatible runtimes.</p>
        pub fn compatible_runtimes(mut self, input: impl Into<crate::model::Runtime>) -> Self {
            let mut v = self.compatible_runtimes.unwrap_or_default();
            v.push(input.into());
            self.compatible_runtimes = Some(v);
            self
        }
        /// <p>The layer's compatible runtimes.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.compatible_runtimes = input;
            self
        }
        /// <p>The layer's software license.</p>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_info = Some(input.into());
            self
        }
        /// <p>The layer's software license.</p>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_info = input;
            self
        }
        /// Appends an item to `compatible_architectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(
            mut self,
            input: impl Into<crate::model::Architecture>,
        ) -> Self {
            let mut v = self.compatible_architectures.unwrap_or_default();
            v.push(input.into());
            self.compatible_architectures = Some(v);
            self
        }
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.compatible_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionOutput`](crate::output::GetLayerVersionOutput)
        pub fn build(self) -> crate::output::GetLayerVersionOutput {
            crate::output::GetLayerVersionOutput {
                content: self.content,
                layer_arn: self.layer_arn,
                layer_version_arn: self.layer_version_arn,
                description: self.description,
                created_date: self.created_date,
                version: self.version.unwrap_or_default(),
                compatible_runtimes: self.compatible_runtimes,
                license_info: self.license_info,
                compatible_architectures: self.compatible_architectures,
            }
        }
    }
}
impl GetLayerVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionOutput`](crate::output::GetLayerVersionOutput)
    pub fn builder() -> crate::output::get_layer_version_output::Builder {
        crate::output::get_layer_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl GetFunctionEventInvokeConfigOutput {
    /// <p>The date and time that the configuration was last updated.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title">
    /// <b>Destinations</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Queue</b> - The ARN of an SQS queue.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Topic</b> - The ARN of an SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
    /// </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for GetFunctionEventInvokeConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionEventInvokeConfigOutput");
        formatter.field("last_modified", &self.last_modified);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}
/// See [`GetFunctionEventInvokeConfigOutput`](crate::output::GetFunctionEventInvokeConfigOutput)
pub mod get_function_event_invoke_config_output {
    /// A builder for [`GetFunctionEventInvokeConfigOutput`](crate::output::GetFunctionEventInvokeConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time that the configuration was last updated.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionEventInvokeConfigOutput`](crate::output::GetFunctionEventInvokeConfigOutput)
        pub fn build(self) -> crate::output::GetFunctionEventInvokeConfigOutput {
            crate::output::GetFunctionEventInvokeConfigOutput {
                last_modified: self.last_modified,
                function_arn: self.function_arn,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            }
        }
    }
}
impl GetFunctionEventInvokeConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionEventInvokeConfigOutput`](crate::output::GetFunctionEventInvokeConfigOutput)
    pub fn builder() -> crate::output::get_function_event_invoke_config_output::Builder {
        crate::output::get_function_event_invoke_config_output::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionConfigurationOutput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl GetFunctionConfigurationOutput {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionConfigurationOutput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`GetFunctionConfigurationOutput`](crate::output::GetFunctionConfigurationOutput)
pub mod get_function_configuration_output {
    /// A builder for [`GetFunctionConfigurationOutput`](crate::output::GetFunctionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionConfigurationOutput`](crate::output::GetFunctionConfigurationOutput)
        pub fn build(self) -> crate::output::GetFunctionConfigurationOutput {
            crate::output::GetFunctionConfigurationOutput {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl GetFunctionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionConfigurationOutput`](crate::output::GetFunctionConfigurationOutput)
    pub fn builder() -> crate::output::get_function_configuration_output::Builder {
        crate::output::get_function_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionConcurrencyOutput {
    /// <p>The number of simultaneous executions that are reserved for the function.</p>
    pub reserved_concurrent_executions: std::option::Option<i32>,
}
impl GetFunctionConcurrencyOutput {
    /// <p>The number of simultaneous executions that are reserved for the function.</p>
    pub fn reserved_concurrent_executions(&self) -> std::option::Option<i32> {
        self.reserved_concurrent_executions
    }
}
impl std::fmt::Debug for GetFunctionConcurrencyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionConcurrencyOutput");
        formatter.field(
            "reserved_concurrent_executions",
            &self.reserved_concurrent_executions,
        );
        formatter.finish()
    }
}
/// See [`GetFunctionConcurrencyOutput`](crate::output::GetFunctionConcurrencyOutput)
pub mod get_function_concurrency_output {
    /// A builder for [`GetFunctionConcurrencyOutput`](crate::output::GetFunctionConcurrencyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of simultaneous executions that are reserved for the function.</p>
        pub fn reserved_concurrent_executions(mut self, input: i32) -> Self {
            self.reserved_concurrent_executions = Some(input);
            self
        }
        /// <p>The number of simultaneous executions that are reserved for the function.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reserved_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionConcurrencyOutput`](crate::output::GetFunctionConcurrencyOutput)
        pub fn build(self) -> crate::output::GetFunctionConcurrencyOutput {
            crate::output::GetFunctionConcurrencyOutput {
                reserved_concurrent_executions: self.reserved_concurrent_executions,
            }
        }
    }
}
impl GetFunctionConcurrencyOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionConcurrencyOutput`](crate::output::GetFunctionConcurrencyOutput)
    pub fn builder() -> crate::output::get_function_concurrency_output::Builder {
        crate::output::get_function_concurrency_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionCodeSigningConfigOutput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title">
    /// <b>Name formats</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function name</b> - <code>MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
    /// characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl GetFunctionCodeSigningConfigOutput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title">
    /// <b>Name formats</b>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Function name</b> - <code>MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
    /// </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
    /// characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionCodeSigningConfigOutput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}
/// See [`GetFunctionCodeSigningConfigOutput`](crate::output::GetFunctionCodeSigningConfigOutput)
pub mod get_function_code_signing_config_output {
    /// A builder for [`GetFunctionCodeSigningConfigOutput`](crate::output::GetFunctionCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionCodeSigningConfigOutput`](crate::output::GetFunctionCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::GetFunctionCodeSigningConfigOutput {
            crate::output::GetFunctionCodeSigningConfigOutput {
                code_signing_config_arn: self.code_signing_config_arn,
                function_name: self.function_name,
            }
        }
    }
}
impl GetFunctionCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionCodeSigningConfigOutput`](crate::output::GetFunctionCodeSigningConfigOutput)
    pub fn builder() -> crate::output::get_function_code_signing_config_output::Builder {
        crate::output::get_function_code_signing_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionOutput {
    /// <p>The configuration of the function or version.</p>
    pub configuration: std::option::Option<crate::model::FunctionConfiguration>,
    /// <p>The deployment package of the function or version.</p>
    pub code: std::option::Option<crate::model::FunctionCodeLocation>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
    /// concurrency</a>.</p>
    pub concurrency: std::option::Option<crate::model::Concurrency>,
}
impl GetFunctionOutput {
    /// <p>The configuration of the function or version.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::FunctionConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The deployment package of the function or version.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::FunctionCodeLocation> {
        self.code.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
    /// concurrency</a>.</p>
    pub fn concurrency(&self) -> std::option::Option<&crate::model::Concurrency> {
        self.concurrency.as_ref()
    }
}
impl std::fmt::Debug for GetFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionOutput");
        formatter.field("configuration", &self.configuration);
        formatter.field("code", &self.code);
        formatter.field("tags", &self.tags);
        formatter.field("concurrency", &self.concurrency);
        formatter.finish()
    }
}
/// See [`GetFunctionOutput`](crate::output::GetFunctionOutput)
pub mod get_function_output {
    /// A builder for [`GetFunctionOutput`](crate::output::GetFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration: std::option::Option<crate::model::FunctionConfiguration>,
        pub(crate) code: std::option::Option<crate::model::FunctionCodeLocation>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) concurrency: std::option::Option<crate::model::Concurrency>,
    }
    impl Builder {
        /// <p>The configuration of the function or version.</p>
        pub fn configuration(mut self, input: crate::model::FunctionConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the function or version.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::FunctionConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The deployment package of the function or version.</p>
        pub fn code(mut self, input: crate::model::FunctionCodeLocation) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The deployment package of the function or version.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::FunctionCodeLocation>,
        ) -> Self {
            self.code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
        /// concurrency</a>.</p>
        pub fn concurrency(mut self, input: crate::model::Concurrency) -> Self {
            self.concurrency = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">reserved
        /// concurrency</a>.</p>
        pub fn set_concurrency(
            mut self,
            input: std::option::Option<crate::model::Concurrency>,
        ) -> Self {
            self.concurrency = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionOutput`](crate::output::GetFunctionOutput)
        pub fn build(self) -> crate::output::GetFunctionOutput {
            crate::output::GetFunctionOutput {
                configuration: self.configuration,
                code: self.code,
                tags: self.tags,
                concurrency: self.concurrency,
            }
        }
    }
}
impl GetFunctionOutput {
    /// Creates a new builder-style object to manufacture [`GetFunctionOutput`](crate::output::GetFunctionOutput)
    pub fn builder() -> crate::output::get_function_output::Builder {
        crate::output::get_function_output::Builder::default()
    }
}

/// <p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub last_processing_result: std::option::Option<std::string::String>,
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl GetEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub fn last_processing_result(&self) -> std::option::Option<&str> {
        self.last_processing_result.as_deref()
    }
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for GetEventSourceMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSourceMappingOutput");
        formatter.field("uuid", &self.uuid);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("batch_size", &self.batch_size);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_processing_result", &self.last_processing_result);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("destination_config", &self.destination_config);
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}
/// See [`GetEventSourceMappingOutput`](crate::output::GetEventSourceMappingOutput)
pub mod get_event_source_mapping_output {
    /// A builder for [`GetEventSourceMappingOutput`](crate::output::GetEventSourceMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_processing_result: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn last_processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_processing_result = Some(input.into());
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn set_last_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_processing_result = input;
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input.into());
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input.into());
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSourceMappingOutput`](crate::output::GetEventSourceMappingOutput)
        pub fn build(self) -> crate::output::GetEventSourceMappingOutput {
            crate::output::GetEventSourceMappingOutput {
                uuid: self.uuid,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                batch_size: self.batch_size,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                event_source_arn: self.event_source_arn,
                function_arn: self.function_arn,
                last_modified: self.last_modified,
                last_processing_result: self.last_processing_result,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                destination_config: self.destination_config,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            }
        }
    }
}
impl GetEventSourceMappingOutput {
    /// Creates a new builder-style object to manufacture [`GetEventSourceMappingOutput`](crate::output::GetEventSourceMappingOutput)
    pub fn builder() -> crate::output::get_event_source_mapping_output::Builder {
        crate::output::get_event_source_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCodeSigningConfigOutput {
    /// <p>The code signing configuration</p>
    pub code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
}
impl GetCodeSigningConfigOutput {
    /// <p>The code signing configuration</p>
    pub fn code_signing_config(&self) -> std::option::Option<&crate::model::CodeSigningConfig> {
        self.code_signing_config.as_ref()
    }
}
impl std::fmt::Debug for GetCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCodeSigningConfigOutput");
        formatter.field("code_signing_config", &self.code_signing_config);
        formatter.finish()
    }
}
/// See [`GetCodeSigningConfigOutput`](crate::output::GetCodeSigningConfigOutput)
pub mod get_code_signing_config_output {
    /// A builder for [`GetCodeSigningConfigOutput`](crate::output::GetCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
    }
    impl Builder {
        /// <p>The code signing configuration</p>
        pub fn code_signing_config(mut self, input: crate::model::CodeSigningConfig) -> Self {
            self.code_signing_config = Some(input);
            self
        }
        /// <p>The code signing configuration</p>
        pub fn set_code_signing_config(
            mut self,
            input: std::option::Option<crate::model::CodeSigningConfig>,
        ) -> Self {
            self.code_signing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCodeSigningConfigOutput`](crate::output::GetCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::GetCodeSigningConfigOutput {
            crate::output::GetCodeSigningConfigOutput {
                code_signing_config: self.code_signing_config,
            }
        }
    }
}
impl GetCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`GetCodeSigningConfigOutput`](crate::output::GetCodeSigningConfigOutput)
    pub fn builder() -> crate::output::get_code_signing_config_output::Builder {
        crate::output::get_code_signing_config_output::Builder::default()
    }
}

/// <p>Provides configuration information about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAliasOutput");
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`GetAliasOutput`](crate::output::GetAliasOutput)
pub mod get_alias_output {
    /// A builder for [`GetAliasOutput`](crate::output::GetAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAliasOutput`](crate::output::GetAliasOutput)
        pub fn build(self) -> crate::output::GetAliasOutput {
            crate::output::GetAliasOutput {
                alias_arn: self.alias_arn,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
                revision_id: self.revision_id,
            }
        }
    }
}
impl GetAliasOutput {
    /// Creates a new builder-style object to manufacture [`GetAliasOutput`](crate::output::GetAliasOutput)
    pub fn builder() -> crate::output::get_alias_output::Builder {
        crate::output::get_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsOutput {
    /// <p>Limits that are related to concurrency and code storage.</p>
    pub account_limit: std::option::Option<crate::model::AccountLimit>,
    /// <p>The number of functions and amount of storage in use.</p>
    pub account_usage: std::option::Option<crate::model::AccountUsage>,
}
impl GetAccountSettingsOutput {
    /// <p>Limits that are related to concurrency and code storage.</p>
    pub fn account_limit(&self) -> std::option::Option<&crate::model::AccountLimit> {
        self.account_limit.as_ref()
    }
    /// <p>The number of functions and amount of storage in use.</p>
    pub fn account_usage(&self) -> std::option::Option<&crate::model::AccountUsage> {
        self.account_usage.as_ref()
    }
}
impl std::fmt::Debug for GetAccountSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsOutput");
        formatter.field("account_limit", &self.account_limit);
        formatter.field("account_usage", &self.account_usage);
        formatter.finish()
    }
}
/// See [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
pub mod get_account_settings_output {
    /// A builder for [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_limit: std::option::Option<crate::model::AccountLimit>,
        pub(crate) account_usage: std::option::Option<crate::model::AccountUsage>,
    }
    impl Builder {
        /// <p>Limits that are related to concurrency and code storage.</p>
        pub fn account_limit(mut self, input: crate::model::AccountLimit) -> Self {
            self.account_limit = Some(input);
            self
        }
        /// <p>Limits that are related to concurrency and code storage.</p>
        pub fn set_account_limit(
            mut self,
            input: std::option::Option<crate::model::AccountLimit>,
        ) -> Self {
            self.account_limit = input;
            self
        }
        /// <p>The number of functions and amount of storage in use.</p>
        pub fn account_usage(mut self, input: crate::model::AccountUsage) -> Self {
            self.account_usage = Some(input);
            self
        }
        /// <p>The number of functions and amount of storage in use.</p>
        pub fn set_account_usage(
            mut self,
            input: std::option::Option<crate::model::AccountUsage>,
        ) -> Self {
            self.account_usage = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
        pub fn build(self) -> crate::output::GetAccountSettingsOutput {
            crate::output::GetAccountSettingsOutput {
                account_limit: self.account_limit,
                account_usage: self.account_usage,
            }
        }
    }
}
impl GetAccountSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsOutput`](crate::output::GetAccountSettingsOutput)
    pub fn builder() -> crate::output::get_account_settings_output::Builder {
        crate::output::get_account_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisionedConcurrencyConfigOutput {}
impl std::fmt::Debug for DeleteProvisionedConcurrencyConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisionedConcurrencyConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteProvisionedConcurrencyConfigOutput`](crate::output::DeleteProvisionedConcurrencyConfigOutput)
pub mod delete_provisioned_concurrency_config_output {
    /// A builder for [`DeleteProvisionedConcurrencyConfigOutput`](crate::output::DeleteProvisionedConcurrencyConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProvisionedConcurrencyConfigOutput`](crate::output::DeleteProvisionedConcurrencyConfigOutput)
        pub fn build(self) -> crate::output::DeleteProvisionedConcurrencyConfigOutput {
            crate::output::DeleteProvisionedConcurrencyConfigOutput {}
        }
    }
}
impl DeleteProvisionedConcurrencyConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedConcurrencyConfigOutput`](crate::output::DeleteProvisionedConcurrencyConfigOutput)
    pub fn builder() -> crate::output::delete_provisioned_concurrency_config_output::Builder {
        crate::output::delete_provisioned_concurrency_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLayerVersionOutput {}
impl std::fmt::Debug for DeleteLayerVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLayerVersionOutput");
        formatter.finish()
    }
}
/// See [`DeleteLayerVersionOutput`](crate::output::DeleteLayerVersionOutput)
pub mod delete_layer_version_output {
    /// A builder for [`DeleteLayerVersionOutput`](crate::output::DeleteLayerVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLayerVersionOutput`](crate::output::DeleteLayerVersionOutput)
        pub fn build(self) -> crate::output::DeleteLayerVersionOutput {
            crate::output::DeleteLayerVersionOutput {}
        }
    }
}
impl DeleteLayerVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLayerVersionOutput`](crate::output::DeleteLayerVersionOutput)
    pub fn builder() -> crate::output::delete_layer_version_output::Builder {
        crate::output::delete_layer_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionEventInvokeConfigOutput {}
impl std::fmt::Debug for DeleteFunctionEventInvokeConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionEventInvokeConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteFunctionEventInvokeConfigOutput`](crate::output::DeleteFunctionEventInvokeConfigOutput)
pub mod delete_function_event_invoke_config_output {
    /// A builder for [`DeleteFunctionEventInvokeConfigOutput`](crate::output::DeleteFunctionEventInvokeConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFunctionEventInvokeConfigOutput`](crate::output::DeleteFunctionEventInvokeConfigOutput)
        pub fn build(self) -> crate::output::DeleteFunctionEventInvokeConfigOutput {
            crate::output::DeleteFunctionEventInvokeConfigOutput {}
        }
    }
}
impl DeleteFunctionEventInvokeConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionEventInvokeConfigOutput`](crate::output::DeleteFunctionEventInvokeConfigOutput)
    pub fn builder() -> crate::output::delete_function_event_invoke_config_output::Builder {
        crate::output::delete_function_event_invoke_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionConcurrencyOutput {}
impl std::fmt::Debug for DeleteFunctionConcurrencyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionConcurrencyOutput");
        formatter.finish()
    }
}
/// See [`DeleteFunctionConcurrencyOutput`](crate::output::DeleteFunctionConcurrencyOutput)
pub mod delete_function_concurrency_output {
    /// A builder for [`DeleteFunctionConcurrencyOutput`](crate::output::DeleteFunctionConcurrencyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFunctionConcurrencyOutput`](crate::output::DeleteFunctionConcurrencyOutput)
        pub fn build(self) -> crate::output::DeleteFunctionConcurrencyOutput {
            crate::output::DeleteFunctionConcurrencyOutput {}
        }
    }
}
impl DeleteFunctionConcurrencyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionConcurrencyOutput`](crate::output::DeleteFunctionConcurrencyOutput)
    pub fn builder() -> crate::output::delete_function_concurrency_output::Builder {
        crate::output::delete_function_concurrency_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionCodeSigningConfigOutput {}
impl std::fmt::Debug for DeleteFunctionCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionCodeSigningConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteFunctionCodeSigningConfigOutput`](crate::output::DeleteFunctionCodeSigningConfigOutput)
pub mod delete_function_code_signing_config_output {
    /// A builder for [`DeleteFunctionCodeSigningConfigOutput`](crate::output::DeleteFunctionCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFunctionCodeSigningConfigOutput`](crate::output::DeleteFunctionCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::DeleteFunctionCodeSigningConfigOutput {
            crate::output::DeleteFunctionCodeSigningConfigOutput {}
        }
    }
}
impl DeleteFunctionCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionCodeSigningConfigOutput`](crate::output::DeleteFunctionCodeSigningConfigOutput)
    pub fn builder() -> crate::output::delete_function_code_signing_config_output::Builder {
        crate::output::delete_function_code_signing_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionOutput {}
impl std::fmt::Debug for DeleteFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionOutput");
        formatter.finish()
    }
}
/// See [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
pub mod delete_function_output {
    /// A builder for [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
        pub fn build(self) -> crate::output::DeleteFunctionOutput {
            crate::output::DeleteFunctionOutput {}
        }
    }
}
impl DeleteFunctionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)
    pub fn builder() -> crate::output::delete_function_output::Builder {
        crate::output::delete_function_output::Builder::default()
    }
}

/// <p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub last_processing_result: std::option::Option<std::string::String>,
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl DeleteEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub fn last_processing_result(&self) -> std::option::Option<&str> {
        self.last_processing_result.as_deref()
    }
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventSourceMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSourceMappingOutput");
        formatter.field("uuid", &self.uuid);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("batch_size", &self.batch_size);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_processing_result", &self.last_processing_result);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("destination_config", &self.destination_config);
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}
/// See [`DeleteEventSourceMappingOutput`](crate::output::DeleteEventSourceMappingOutput)
pub mod delete_event_source_mapping_output {
    /// A builder for [`DeleteEventSourceMappingOutput`](crate::output::DeleteEventSourceMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_processing_result: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn last_processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_processing_result = Some(input.into());
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn set_last_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_processing_result = input;
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input.into());
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input.into());
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSourceMappingOutput`](crate::output::DeleteEventSourceMappingOutput)
        pub fn build(self) -> crate::output::DeleteEventSourceMappingOutput {
            crate::output::DeleteEventSourceMappingOutput {
                uuid: self.uuid,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                batch_size: self.batch_size,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                event_source_arn: self.event_source_arn,
                function_arn: self.function_arn,
                last_modified: self.last_modified,
                last_processing_result: self.last_processing_result,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                destination_config: self.destination_config,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            }
        }
    }
}
impl DeleteEventSourceMappingOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventSourceMappingOutput`](crate::output::DeleteEventSourceMappingOutput)
    pub fn builder() -> crate::output::delete_event_source_mapping_output::Builder {
        crate::output::delete_event_source_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCodeSigningConfigOutput {}
impl std::fmt::Debug for DeleteCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCodeSigningConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteCodeSigningConfigOutput`](crate::output::DeleteCodeSigningConfigOutput)
pub mod delete_code_signing_config_output {
    /// A builder for [`DeleteCodeSigningConfigOutput`](crate::output::DeleteCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteCodeSigningConfigOutput`](crate::output::DeleteCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::DeleteCodeSigningConfigOutput {
            crate::output::DeleteCodeSigningConfigOutput {}
        }
    }
}
impl DeleteCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCodeSigningConfigOutput`](crate::output::DeleteCodeSigningConfigOutput)
    pub fn builder() -> crate::output::delete_code_signing_config_output::Builder {
        crate::output::delete_code_signing_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAliasOutput {}
impl std::fmt::Debug for DeleteAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
pub mod delete_alias_output {
    /// A builder for [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
        pub fn build(self) -> crate::output::DeleteAliasOutput {
            crate::output::DeleteAliasOutput {}
        }
    }
}
impl DeleteAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAliasOutput`](crate::output::DeleteAliasOutput)
    pub fn builder() -> crate::output::delete_alias_output::Builder {
        crate::output::delete_alias_output::Builder::default()
    }
}

/// <p>Details about a function's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionOutput {
    /// <p>The name of the function.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The runtime environment for the Lambda function.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub code_size: i64,
    /// <p>The function's description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of memory available to the function at runtime. </p>
    pub memory_size: std::option::Option<i32>,
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub last_modified: std::option::Option<std::string::String>,
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>The version of the Lambda function.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The function's networking configuration.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
    /// <p>The function's dead letter queue.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub environment: std::option::Option<crate::model::EnvironmentResponse>,
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The function's X-Ray tracing configuration.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub master_arn: std::option::Option<std::string::String>,
    /// <p>The latest updated revision of the function or alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub state: std::option::Option<crate::model::State>,
    /// <p>The reason for the function's current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub state_reason_code: std::option::Option<crate::model::StateReasonCode>,
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
    /// <p>The reason for the last update that was performed on the function.</p>
    pub last_update_status_reason: std::option::Option<std::string::String>,
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub last_update_status_reason_code:
        std::option::Option<crate::model::LastUpdateStatusReasonCode>,
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>The function's image configuration values.</p>
    pub image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
    /// <p>The ARN of the signing profile version.</p>
    pub signing_profile_version_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the signing job.</p>
    pub signing_job_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl CreateFunctionOutput {
    /// <p>The name of the function.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The runtime environment for the Lambda function.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The function that Lambda calls to begin executing your function.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The size of the function's deployment package, in bytes.</p>
    pub fn code_size(&self) -> i64 {
        self.code_size
    }
    /// <p>The function's description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of memory available to the function at runtime. </p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
    pub fn last_modified(&self) -> std::option::Option<&str> {
        self.last_modified.as_deref()
    }
    /// <p>The SHA256 hash of the function's deployment package.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>The version of the Lambda function.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>The function's networking configuration.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfigResponse> {
        self.vpc_config.as_ref()
    }
    /// <p>The function's dead letter queue.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::EnvironmentResponse> {
        self.environment.as_ref()
    }
    /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
    /// configured a customer managed key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The function's X-Ray tracing configuration.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfigResponse> {
        self.tracing_config.as_ref()
    }
    /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
    pub fn master_arn(&self) -> std::option::Option<&str> {
        self.master_arn.as_deref()
    }
    /// <p>The latest updated revision of the function or alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
    /// layers</a>.</p>
    pub fn layers(&self) -> std::option::Option<&[crate::model::Layer]> {
        self.layers.as_deref()
    }
    /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
    /// invoking it.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::State> {
        self.state.as_ref()
    }
    /// <p>The reason for the function's current state.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
    /// modify the function.</p>
    pub fn state_reason_code(&self) -> std::option::Option<&crate::model::StateReasonCode> {
        self.state_reason_code.as_ref()
    }
    /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
    /// after function creation completes.</p>
    pub fn last_update_status(&self) -> std::option::Option<&crate::model::LastUpdateStatus> {
        self.last_update_status.as_ref()
    }
    /// <p>The reason for the last update that was performed on the function.</p>
    pub fn last_update_status_reason(&self) -> std::option::Option<&str> {
        self.last_update_status_reason.as_deref()
    }
    /// <p>The reason code for the last update that was performed on the function.</p>
    pub fn last_update_status_reason_code(
        &self,
    ) -> std::option::Option<&crate::model::LastUpdateStatusReasonCode> {
        self.last_update_status_reason_code.as_ref()
    }
    /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>The function's image configuration values.</p>
    pub fn image_config_response(&self) -> std::option::Option<&crate::model::ImageConfigResponse> {
        self.image_config_response.as_ref()
    }
    /// <p>The ARN of the signing profile version.</p>
    pub fn signing_profile_version_arn(&self) -> std::option::Option<&str> {
        self.signing_profile_version_arn.as_deref()
    }
    /// <p>The ARN of the signing job.</p>
    pub fn signing_job_arn(&self) -> std::option::Option<&str> {
        self.signing_job_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
    /// valid values. The default architecture value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for CreateFunctionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionOutput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code_size", &self.code_size);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("version", &self.version);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("master_arn", &self.master_arn);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_code", &self.state_reason_code);
        formatter.field("last_update_status", &self.last_update_status);
        formatter.field("last_update_status_reason", &self.last_update_status_reason);
        formatter.field(
            "last_update_status_reason_code",
            &self.last_update_status_reason_code,
        );
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("package_type", &self.package_type);
        formatter.field("image_config_response", &self.image_config_response);
        formatter.field(
            "signing_profile_version_arn",
            &self.signing_profile_version_arn,
        );
        formatter.field("signing_job_arn", &self.signing_job_arn);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}
/// See [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
pub mod create_function_output {
    /// A builder for [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code_size: std::option::Option<i64>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) last_modified: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfigResponse>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::EnvironmentResponse>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfigResponse>,
        pub(crate) master_arn: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        pub(crate) state: std::option::Option<crate::model::State>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_code: std::option::Option<crate::model::StateReasonCode>,
        pub(crate) last_update_status: std::option::Option<crate::model::LastUpdateStatus>,
        pub(crate) last_update_status_reason: std::option::Option<std::string::String>,
        pub(crate) last_update_status_reason_code:
            std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) image_config_response: std::option::Option<crate::model::ImageConfigResponse>,
        pub(crate) signing_profile_version_arn: std::option::Option<std::string::String>,
        pub(crate) signing_job_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the function.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the function.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The runtime environment for the Lambda function.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The function that Lambda calls to begin executing your function.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn code_size(mut self, input: i64) -> Self {
            self.code_size = Some(input);
            self
        }
        /// <p>The size of the function's deployment package, in bytes.</p>
        pub fn set_code_size(mut self, input: std::option::Option<i64>) -> Self {
            self.code_size = input;
            self
        }
        /// <p>The function's description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The function's description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time in seconds that Lambda allows a function to run before stopping it.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of memory available to the function at runtime. </p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn last_modified(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified = Some(input.into());
            self
        }
        /// <p>The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA256 hash of the function's deployment package.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the Lambda function.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfigResponse) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The function's networking configuration.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfigResponse>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The function's dead letter queue.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn environment(mut self, input: crate::model::EnvironmentResponse) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">environment variables</a>.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::EnvironmentResponse>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
        /// configured a customer managed key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfigResponse) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>The function's X-Ray tracing configuration.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfigResponse>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn master_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_arn = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the ARN of the main function.</p>
        pub fn set_master_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_arn = input;
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The latest updated revision of the function or alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn layers(mut self, input: impl Into<crate::model::Layer>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
        /// layers</a>.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Layer>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
        /// invoking it.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason for the function's current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn state_reason_code(mut self, input: crate::model::StateReasonCode) -> Self {
            self.state_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
        /// modify the function.</p>
        pub fn set_state_reason_code(
            mut self,
            input: std::option::Option<crate::model::StateReasonCode>,
        ) -> Self {
            self.state_reason_code = input;
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn last_update_status(mut self, input: crate::model::LastUpdateStatus) -> Self {
            self.last_update_status = Some(input);
            self
        }
        /// <p>The status of the last update that was performed on the function. This is first set to <code>Successful</code>
        /// after function creation completes.</p>
        pub fn set_last_update_status(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatus>,
        ) -> Self {
            self.last_update_status = input;
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn last_update_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_update_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_update_status_reason = input;
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn last_update_status_reason_code(
            mut self,
            input: crate::model::LastUpdateStatusReasonCode,
        ) -> Self {
            self.last_update_status_reason_code = Some(input);
            self
        }
        /// <p>The reason code for the last update that was performed on the function.</p>
        pub fn set_last_update_status_reason_code(
            mut self,
            input: std::option::Option<crate::model::LastUpdateStatusReasonCode>,
        ) -> Self {
            self.last_update_status_reason_code = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn file_system_configs(
            mut self,
            input: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input.into());
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html">Amazon EFS file system</a>.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip file archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn image_config_response(mut self, input: crate::model::ImageConfigResponse) -> Self {
            self.image_config_response = Some(input);
            self
        }
        /// <p>The function's image configuration values.</p>
        pub fn set_image_config_response(
            mut self,
            input: std::option::Option<crate::model::ImageConfigResponse>,
        ) -> Self {
            self.image_config_response = input;
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn signing_profile_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing profile version.</p>
        pub fn set_signing_profile_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_profile_version_arn = input;
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn signing_job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_job_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the signing job.</p>
        pub fn set_signing_job_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_job_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: impl Into<crate::model::Architecture>) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input.into());
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Architecture is a string array with one of the
        /// valid values. The default architecture value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
        pub fn build(self) -> crate::output::CreateFunctionOutput {
            crate::output::CreateFunctionOutput {
                function_name: self.function_name,
                function_arn: self.function_arn,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code_size: self.code_size.unwrap_or_default(),
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                last_modified: self.last_modified,
                code_sha256: self.code_sha256,
                version: self.version,
                vpc_config: self.vpc_config,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                master_arn: self.master_arn,
                revision_id: self.revision_id,
                layers: self.layers,
                state: self.state,
                state_reason: self.state_reason,
                state_reason_code: self.state_reason_code,
                last_update_status: self.last_update_status,
                last_update_status_reason: self.last_update_status_reason,
                last_update_status_reason_code: self.last_update_status_reason_code,
                file_system_configs: self.file_system_configs,
                package_type: self.package_type,
                image_config_response: self.image_config_response,
                signing_profile_version_arn: self.signing_profile_version_arn,
                signing_job_arn: self.signing_job_arn,
                architectures: self.architectures,
            }
        }
    }
}
impl CreateFunctionOutput {
    /// Creates a new builder-style object to manufacture [`CreateFunctionOutput`](crate::output::CreateFunctionOutput)
    pub fn builder() -> crate::output::create_function_output::Builder {
        crate::output::create_function_output::Builder::default()
    }
}

/// <p>A mapping between an Amazon Web Services resource and a Lambda function. For details, see <a>CreateEventSourceMapping</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub last_processing_result: std::option::Option<std::string::String>,
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub state_transition_reason: std::option::Option<std::string::String>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl CreateEventSourceMappingOutput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
    /// streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
    /// reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The date that the event source mapping was last updated or that its state changed.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The result of the last Lambda invocation of your function.</p>
    pub fn last_processing_result(&self) -> std::option::Option<&str> {
        self.last_processing_result.as_deref()
    }
    /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
    /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
    /// <code>Updating</code>, or <code>Deleting</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
    pub fn state_transition_reason(&self) -> std::option::Option<&str> {
        self.state_transition_reason.as_deref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The self-managed Apache Kafka cluster for your event source.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
    /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
    /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for CreateEventSourceMappingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSourceMappingOutput");
        formatter.field("uuid", &self.uuid);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("batch_size", &self.batch_size);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("last_processing_result", &self.last_processing_result);
        formatter.field("state", &self.state);
        formatter.field("state_transition_reason", &self.state_transition_reason);
        formatter.field("destination_config", &self.destination_config);
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}
/// See [`CreateEventSourceMappingOutput`](crate::output::CreateEventSourceMappingOutput)
pub mod create_event_source_mapping_output {
    /// A builder for [`CreateEventSourceMappingOutput`](crate::output::CreateEventSourceMappingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_processing_result: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) state_transition_reason: std::option::Option<std::string::String>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK stream sources. <code>AT_TIMESTAMP</code> is supported only for Amazon Kinesis
        /// streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <p>Default value: Varies by service. For Amazon SQS, the default is 10. For all other services, the default is 100.</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the event source mapping was last updated or that its state changed.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn last_processing_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_processing_result = Some(input.into());
            self
        }
        /// <p>The result of the last Lambda invocation of your function.</p>
        pub fn set_last_processing_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_processing_result = input;
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the event source mapping. It can be one of the following: <code>Creating</code>,
        /// <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
        /// <code>Updating</code>, or <code>Deleting</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn state_transition_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_transition_reason = Some(input.into());
            self
        }
        /// <p>Indicates whether a user or Lambda made the last change to the event source mapping.</p>
        pub fn set_state_transition_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_transition_reason = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.</p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input.into());
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The self-managed Apache Kafka cluster for your event source.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is -1,
        /// which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.  </p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry. The default value is false.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is -1,
        /// which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is 1–900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input.into());
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSourceMappingOutput`](crate::output::CreateEventSourceMappingOutput)
        pub fn build(self) -> crate::output::CreateEventSourceMappingOutput {
            crate::output::CreateEventSourceMappingOutput {
                uuid: self.uuid,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                batch_size: self.batch_size,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                event_source_arn: self.event_source_arn,
                function_arn: self.function_arn,
                last_modified: self.last_modified,
                last_processing_result: self.last_processing_result,
                state: self.state,
                state_transition_reason: self.state_transition_reason,
                destination_config: self.destination_config,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            }
        }
    }
}
impl CreateEventSourceMappingOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventSourceMappingOutput`](crate::output::CreateEventSourceMappingOutput)
    pub fn builder() -> crate::output::create_event_source_mapping_output::Builder {
        crate::output::create_event_source_mapping_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCodeSigningConfigOutput {
    /// <p>The code signing configuration.</p>
    pub code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
}
impl CreateCodeSigningConfigOutput {
    /// <p>The code signing configuration.</p>
    pub fn code_signing_config(&self) -> std::option::Option<&crate::model::CodeSigningConfig> {
        self.code_signing_config.as_ref()
    }
}
impl std::fmt::Debug for CreateCodeSigningConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCodeSigningConfigOutput");
        formatter.field("code_signing_config", &self.code_signing_config);
        formatter.finish()
    }
}
/// See [`CreateCodeSigningConfigOutput`](crate::output::CreateCodeSigningConfigOutput)
pub mod create_code_signing_config_output {
    /// A builder for [`CreateCodeSigningConfigOutput`](crate::output::CreateCodeSigningConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config: std::option::Option<crate::model::CodeSigningConfig>,
    }
    impl Builder {
        /// <p>The code signing configuration.</p>
        pub fn code_signing_config(mut self, input: crate::model::CodeSigningConfig) -> Self {
            self.code_signing_config = Some(input);
            self
        }
        /// <p>The code signing configuration.</p>
        pub fn set_code_signing_config(
            mut self,
            input: std::option::Option<crate::model::CodeSigningConfig>,
        ) -> Self {
            self.code_signing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCodeSigningConfigOutput`](crate::output::CreateCodeSigningConfigOutput)
        pub fn build(self) -> crate::output::CreateCodeSigningConfigOutput {
            crate::output::CreateCodeSigningConfigOutput {
                code_signing_config: self.code_signing_config,
            }
        }
    }
}
impl CreateCodeSigningConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateCodeSigningConfigOutput`](crate::output::CreateCodeSigningConfigOutput)
    pub fn builder() -> crate::output::create_code_signing_config_output::Builder {
        crate::output::create_code_signing_config_output::Builder::default()
    }
}

/// <p>Provides configuration information about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub alias_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl CreateAliasOutput {
    /// <p>The Amazon Resource Name (ARN) of the alias.</p>
    pub fn alias_arn(&self) -> std::option::Option<&str> {
        self.alias_arn.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
    /// configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
    /// <p>A unique identifier that changes when you update the alias.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for CreateAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasOutput");
        formatter.field("alias_arn", &self.alias_arn);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`CreateAliasOutput`](crate::output::CreateAliasOutput)
pub mod create_alias_output {
    /// A builder for [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alias_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn alias_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alias_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alias.</p>
        pub fn set_alias_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alias_arn = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier that changes when you update the alias.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasOutput`](crate::output::CreateAliasOutput)
        pub fn build(self) -> crate::output::CreateAliasOutput {
            crate::output::CreateAliasOutput {
                alias_arn: self.alias_arn,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
                revision_id: self.revision_id,
            }
        }
    }
}
impl CreateAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateAliasOutput`](crate::output::CreateAliasOutput)
    pub fn builder() -> crate::output::create_alias_output::Builder {
        crate::output::create_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddPermissionOutput {
    /// <p>The permission statement that's added to the function policy.</p>
    pub statement: std::option::Option<std::string::String>,
}
impl AddPermissionOutput {
    /// <p>The permission statement that's added to the function policy.</p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
}
impl std::fmt::Debug for AddPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddPermissionOutput");
        formatter.field("statement", &self.statement);
        formatter.finish()
    }
}
/// See [`AddPermissionOutput`](crate::output::AddPermissionOutput)
pub mod add_permission_output {
    /// A builder for [`AddPermissionOutput`](crate::output::AddPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The permission statement that's added to the function policy.</p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p>The permission statement that's added to the function policy.</p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// Consumes the builder and constructs a [`AddPermissionOutput`](crate::output::AddPermissionOutput)
        pub fn build(self) -> crate::output::AddPermissionOutput {
            crate::output::AddPermissionOutput {
                statement: self.statement,
            }
        }
    }
}
impl AddPermissionOutput {
    /// Creates a new builder-style object to manufacture [`AddPermissionOutput`](crate::output::AddPermissionOutput)
    pub fn builder() -> crate::output::add_permission_output::Builder {
        crate::output::add_permission_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddLayerVersionPermissionOutput {
    /// <p>The permission statement.</p>
    pub statement: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl AddLayerVersionPermissionOutput {
    /// <p>The permission statement.</p>
    pub fn statement(&self) -> std::option::Option<&str> {
        self.statement.as_deref()
    }
    /// <p>A unique identifier for the current revision of the policy.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for AddLayerVersionPermissionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddLayerVersionPermissionOutput");
        formatter.field("statement", &self.statement);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
/// See [`AddLayerVersionPermissionOutput`](crate::output::AddLayerVersionPermissionOutput)
pub mod add_layer_version_permission_output {
    /// A builder for [`AddLayerVersionPermissionOutput`](crate::output::AddLayerVersionPermissionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The permission statement.</p>
        pub fn statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement = Some(input.into());
            self
        }
        /// <p>The permission statement.</p>
        pub fn set_statement(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement = input;
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the current revision of the policy.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddLayerVersionPermissionOutput`](crate::output::AddLayerVersionPermissionOutput)
        pub fn build(self) -> crate::output::AddLayerVersionPermissionOutput {
            crate::output::AddLayerVersionPermissionOutput {
                statement: self.statement,
                revision_id: self.revision_id,
            }
        }
    }
}
impl AddLayerVersionPermissionOutput {
    /// Creates a new builder-style object to manufacture [`AddLayerVersionPermissionOutput`](crate::output::AddLayerVersionPermissionOutput)
    pub fn builder() -> crate::output::add_layer_version_permission_output::Builder {
        crate::output::add_layer_version_permission_output::Builder::default()
    }
}
