// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddLayerVersionPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_layer_version_permission`](crate::client::Client::add_layer_version_permission).
///
/// See [`crate::client::fluent_builders::AddLayerVersionPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddLayerVersionPermission {
    _private: (),
}
impl AddLayerVersionPermission {
    /// Creates a new builder-style object to manufacture [`AddLayerVersionPermissionInput`](crate::input::AddLayerVersionPermissionInput)
    pub fn builder() -> crate::input::add_layer_version_permission_input::Builder {
        crate::input::add_layer_version_permission_input::Builder::default()
    }
    /// Creates a new `AddLayerVersionPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddLayerVersionPermission {
    type Output = std::result::Result<
        crate::output::AddLayerVersionPermissionOutput,
        crate::error::AddLayerVersionPermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_layer_version_permission_error(response)
        } else {
            crate::operation_deser::parse_add_layer_version_permission_response(response)
        }
    }
}

/// Operation shape for `AddPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_permission`](crate::client::Client::add_permission).
///
/// See [`crate::client::fluent_builders::AddPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddPermission {
    _private: (),
}
impl AddPermission {
    /// Creates a new builder-style object to manufacture [`AddPermissionInput`](crate::input::AddPermissionInput)
    pub fn builder() -> crate::input::add_permission_input::Builder {
        crate::input::add_permission_input::Builder::default()
    }
    /// Creates a new `AddPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddPermission {
    type Output =
        std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_permission_error(response)
        } else {
            crate::operation_deser::parse_add_permission_response(response)
        }
    }
}

/// Operation shape for `CreateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alias`](crate::client::Client::create_alias).
///
/// See [`crate::client::fluent_builders::CreateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlias {
    _private: (),
}
impl CreateAlias {
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
    /// Creates a new `CreateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlias {
    type Output =
        std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_alias_error(response)
        } else {
            crate::operation_deser::parse_create_alias_response(response)
        }
    }
}

/// Operation shape for `CreateCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_code_signing_config`](crate::client::Client::create_code_signing_config).
///
/// See [`crate::client::fluent_builders::CreateCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCodeSigningConfig {
    _private: (),
}
impl CreateCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`CreateCodeSigningConfigInput`](crate::input::CreateCodeSigningConfigInput)
    pub fn builder() -> crate::input::create_code_signing_config_input::Builder {
        crate::input::create_code_signing_config_input::Builder::default()
    }
    /// Creates a new `CreateCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::CreateCodeSigningConfigOutput,
        crate::error::CreateCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_create_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `CreateEventSourceMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_event_source_mapping`](crate::client::Client::create_event_source_mapping).
///
/// See [`crate::client::fluent_builders::CreateEventSourceMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateEventSourceMapping {
    _private: (),
}
impl CreateEventSourceMapping {
    /// Creates a new builder-style object to manufacture [`CreateEventSourceMappingInput`](crate::input::CreateEventSourceMappingInput)
    pub fn builder() -> crate::input::create_event_source_mapping_input::Builder {
        crate::input::create_event_source_mapping_input::Builder::default()
    }
    /// Creates a new `CreateEventSourceMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateEventSourceMapping {
    type Output = std::result::Result<
        crate::output::CreateEventSourceMappingOutput,
        crate::error::CreateEventSourceMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_event_source_mapping_error(response)
        } else {
            crate::operation_deser::parse_create_event_source_mapping_response(response)
        }
    }
}

/// Operation shape for `CreateFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_function`](crate::client::Client::create_function).
///
/// See [`crate::client::fluent_builders::CreateFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFunction {
    _private: (),
}
impl CreateFunction {
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
    /// Creates a new `CreateFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFunction {
    type Output =
        std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_function_error(response)
        } else {
            crate::operation_deser::parse_create_function_response(response)
        }
    }
}

/// Operation shape for `DeleteAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alias`](crate::client::Client::delete_alias).
///
/// See [`crate::client::fluent_builders::DeleteAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlias {
    _private: (),
}
impl DeleteAlias {
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
    /// Creates a new `DeleteAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlias {
    type Output =
        std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_alias_error(response)
        } else {
            crate::operation_deser::parse_delete_alias_response(response)
        }
    }
}

/// Operation shape for `DeleteCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_code_signing_config`](crate::client::Client::delete_code_signing_config).
///
/// See [`crate::client::fluent_builders::DeleteCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCodeSigningConfig {
    _private: (),
}
impl DeleteCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`DeleteCodeSigningConfigInput`](crate::input::DeleteCodeSigningConfigInput)
    pub fn builder() -> crate::input::delete_code_signing_config_input::Builder {
        crate::input::delete_code_signing_config_input::Builder::default()
    }
    /// Creates a new `DeleteCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::DeleteCodeSigningConfigOutput,
        crate::error::DeleteCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_delete_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `DeleteEventSourceMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_event_source_mapping`](crate::client::Client::delete_event_source_mapping).
///
/// See [`crate::client::fluent_builders::DeleteEventSourceMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteEventSourceMapping {
    _private: (),
}
impl DeleteEventSourceMapping {
    /// Creates a new builder-style object to manufacture [`DeleteEventSourceMappingInput`](crate::input::DeleteEventSourceMappingInput)
    pub fn builder() -> crate::input::delete_event_source_mapping_input::Builder {
        crate::input::delete_event_source_mapping_input::Builder::default()
    }
    /// Creates a new `DeleteEventSourceMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteEventSourceMapping {
    type Output = std::result::Result<
        crate::output::DeleteEventSourceMappingOutput,
        crate::error::DeleteEventSourceMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_event_source_mapping_error(response)
        } else {
            crate::operation_deser::parse_delete_event_source_mapping_response(response)
        }
    }
}

/// Operation shape for `DeleteFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function`](crate::client::Client::delete_function).
///
/// See [`crate::client::fluent_builders::DeleteFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunction {
    _private: (),
}
impl DeleteFunction {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
    /// Creates a new `DeleteFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunction {
    type Output =
        std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_function_error(response)
        } else {
            crate::operation_deser::parse_delete_function_response(response)
        }
    }
}

/// Operation shape for `DeleteFunctionCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function_code_signing_config`](crate::client::Client::delete_function_code_signing_config).
///
/// See [`crate::client::fluent_builders::DeleteFunctionCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunctionCodeSigningConfig {
    _private: (),
}
impl DeleteFunctionCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionCodeSigningConfigInput`](crate::input::DeleteFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::delete_function_code_signing_config_input::Builder {
        crate::input::delete_function_code_signing_config_input::Builder::default()
    }
    /// Creates a new `DeleteFunctionCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunctionCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::DeleteFunctionCodeSigningConfigOutput,
        crate::error::DeleteFunctionCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_function_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_delete_function_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `DeleteFunctionConcurrency`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function_concurrency`](crate::client::Client::delete_function_concurrency).
///
/// See [`crate::client::fluent_builders::DeleteFunctionConcurrency`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunctionConcurrency {
    _private: (),
}
impl DeleteFunctionConcurrency {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionConcurrencyInput`](crate::input::DeleteFunctionConcurrencyInput)
    pub fn builder() -> crate::input::delete_function_concurrency_input::Builder {
        crate::input::delete_function_concurrency_input::Builder::default()
    }
    /// Creates a new `DeleteFunctionConcurrency` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunctionConcurrency {
    type Output = std::result::Result<
        crate::output::DeleteFunctionConcurrencyOutput,
        crate::error::DeleteFunctionConcurrencyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_function_concurrency_error(response)
        } else {
            crate::operation_deser::parse_delete_function_concurrency_response(response)
        }
    }
}

/// Operation shape for `DeleteFunctionEventInvokeConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function_event_invoke_config`](crate::client::Client::delete_function_event_invoke_config).
///
/// See [`crate::client::fluent_builders::DeleteFunctionEventInvokeConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunctionEventInvokeConfig {
    _private: (),
}
impl DeleteFunctionEventInvokeConfig {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionEventInvokeConfigInput`](crate::input::DeleteFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::delete_function_event_invoke_config_input::Builder {
        crate::input::delete_function_event_invoke_config_input::Builder::default()
    }
    /// Creates a new `DeleteFunctionEventInvokeConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunctionEventInvokeConfig {
    type Output = std::result::Result<
        crate::output::DeleteFunctionEventInvokeConfigOutput,
        crate::error::DeleteFunctionEventInvokeConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_function_event_invoke_config_error(response)
        } else {
            crate::operation_deser::parse_delete_function_event_invoke_config_response(response)
        }
    }
}

/// Operation shape for `DeleteLayerVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_layer_version`](crate::client::Client::delete_layer_version).
///
/// See [`crate::client::fluent_builders::DeleteLayerVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLayerVersion {
    _private: (),
}
impl DeleteLayerVersion {
    /// Creates a new builder-style object to manufacture [`DeleteLayerVersionInput`](crate::input::DeleteLayerVersionInput)
    pub fn builder() -> crate::input::delete_layer_version_input::Builder {
        crate::input::delete_layer_version_input::Builder::default()
    }
    /// Creates a new `DeleteLayerVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLayerVersion {
    type Output = std::result::Result<
        crate::output::DeleteLayerVersionOutput,
        crate::error::DeleteLayerVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_layer_version_error(response)
        } else {
            crate::operation_deser::parse_delete_layer_version_response(response)
        }
    }
}

/// Operation shape for `DeleteProvisionedConcurrencyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_provisioned_concurrency_config`](crate::client::Client::delete_provisioned_concurrency_config).
///
/// See [`crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProvisionedConcurrencyConfig {
    _private: (),
}
impl DeleteProvisionedConcurrencyConfig {
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedConcurrencyConfigInput`](crate::input::DeleteProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::delete_provisioned_concurrency_config_input::Builder {
        crate::input::delete_provisioned_concurrency_config_input::Builder::default()
    }
    /// Creates a new `DeleteProvisionedConcurrencyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProvisionedConcurrencyConfig {
    type Output = std::result::Result<
        crate::output::DeleteProvisionedConcurrencyConfigOutput,
        crate::error::DeleteProvisionedConcurrencyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_provisioned_concurrency_config_error(response)
        } else {
            crate::operation_deser::parse_delete_provisioned_concurrency_config_response(response)
        }
    }
}

/// Operation shape for `GetAccountSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_settings`](crate::client::Client::get_account_settings).
///
/// See [`crate::client::fluent_builders::GetAccountSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountSettings {
    _private: (),
}
impl GetAccountSettings {
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
    /// Creates a new `GetAccountSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountSettings {
    type Output = std::result::Result<
        crate::output::GetAccountSettingsOutput,
        crate::error::GetAccountSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_settings_error(response)
        } else {
            crate::operation_deser::parse_get_account_settings_response(response)
        }
    }
}

/// Operation shape for `GetAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_alias`](crate::client::Client::get_alias).
///
/// See [`crate::client::fluent_builders::GetAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAlias {
    _private: (),
}
impl GetAlias {
    /// Creates a new builder-style object to manufacture [`GetAliasInput`](crate::input::GetAliasInput)
    pub fn builder() -> crate::input::get_alias_input::Builder {
        crate::input::get_alias_input::Builder::default()
    }
    /// Creates a new `GetAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAlias {
    type Output = std::result::Result<crate::output::GetAliasOutput, crate::error::GetAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_alias_error(response)
        } else {
            crate::operation_deser::parse_get_alias_response(response)
        }
    }
}

/// Operation shape for `GetCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_code_signing_config`](crate::client::Client::get_code_signing_config).
///
/// See [`crate::client::fluent_builders::GetCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCodeSigningConfig {
    _private: (),
}
impl GetCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`GetCodeSigningConfigInput`](crate::input::GetCodeSigningConfigInput)
    pub fn builder() -> crate::input::get_code_signing_config_input::Builder {
        crate::input::get_code_signing_config_input::Builder::default()
    }
    /// Creates a new `GetCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::GetCodeSigningConfigOutput,
        crate::error::GetCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_get_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `GetEventSourceMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_event_source_mapping`](crate::client::Client::get_event_source_mapping).
///
/// See [`crate::client::fluent_builders::GetEventSourceMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEventSourceMapping {
    _private: (),
}
impl GetEventSourceMapping {
    /// Creates a new builder-style object to manufacture [`GetEventSourceMappingInput`](crate::input::GetEventSourceMappingInput)
    pub fn builder() -> crate::input::get_event_source_mapping_input::Builder {
        crate::input::get_event_source_mapping_input::Builder::default()
    }
    /// Creates a new `GetEventSourceMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEventSourceMapping {
    type Output = std::result::Result<
        crate::output::GetEventSourceMappingOutput,
        crate::error::GetEventSourceMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_event_source_mapping_error(response)
        } else {
            crate::operation_deser::parse_get_event_source_mapping_response(response)
        }
    }
}

/// Operation shape for `GetFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function`](crate::client::Client::get_function).
///
/// See [`crate::client::fluent_builders::GetFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunction {
    _private: (),
}
impl GetFunction {
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
    /// Creates a new `GetFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunction {
    type Output =
        std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_error(response)
        } else {
            crate::operation_deser::parse_get_function_response(response)
        }
    }
}

/// Operation shape for `GetFunctionCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_code_signing_config`](crate::client::Client::get_function_code_signing_config).
///
/// See [`crate::client::fluent_builders::GetFunctionCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionCodeSigningConfig {
    _private: (),
}
impl GetFunctionCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`GetFunctionCodeSigningConfigInput`](crate::input::GetFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::get_function_code_signing_config_input::Builder {
        crate::input::get_function_code_signing_config_input::Builder::default()
    }
    /// Creates a new `GetFunctionCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::GetFunctionCodeSigningConfigOutput,
        crate::error::GetFunctionCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_get_function_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `GetFunctionConcurrency`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_concurrency`](crate::client::Client::get_function_concurrency).
///
/// See [`crate::client::fluent_builders::GetFunctionConcurrency`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionConcurrency {
    _private: (),
}
impl GetFunctionConcurrency {
    /// Creates a new builder-style object to manufacture [`GetFunctionConcurrencyInput`](crate::input::GetFunctionConcurrencyInput)
    pub fn builder() -> crate::input::get_function_concurrency_input::Builder {
        crate::input::get_function_concurrency_input::Builder::default()
    }
    /// Creates a new `GetFunctionConcurrency` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionConcurrency {
    type Output = std::result::Result<
        crate::output::GetFunctionConcurrencyOutput,
        crate::error::GetFunctionConcurrencyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_concurrency_error(response)
        } else {
            crate::operation_deser::parse_get_function_concurrency_response(response)
        }
    }
}

/// Operation shape for `GetFunctionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_configuration`](crate::client::Client::get_function_configuration).
///
/// See [`crate::client::fluent_builders::GetFunctionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionConfiguration {
    _private: (),
}
impl GetFunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`GetFunctionConfigurationInput`](crate::input::GetFunctionConfigurationInput)
    pub fn builder() -> crate::input::get_function_configuration_input::Builder {
        crate::input::get_function_configuration_input::Builder::default()
    }
    /// Creates a new `GetFunctionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionConfiguration {
    type Output = std::result::Result<
        crate::output::GetFunctionConfigurationOutput,
        crate::error::GetFunctionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_function_configuration_response(response)
        }
    }
}

/// Operation shape for `GetFunctionEventInvokeConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function_event_invoke_config`](crate::client::Client::get_function_event_invoke_config).
///
/// See [`crate::client::fluent_builders::GetFunctionEventInvokeConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunctionEventInvokeConfig {
    _private: (),
}
impl GetFunctionEventInvokeConfig {
    /// Creates a new builder-style object to manufacture [`GetFunctionEventInvokeConfigInput`](crate::input::GetFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::get_function_event_invoke_config_input::Builder {
        crate::input::get_function_event_invoke_config_input::Builder::default()
    }
    /// Creates a new `GetFunctionEventInvokeConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunctionEventInvokeConfig {
    type Output = std::result::Result<
        crate::output::GetFunctionEventInvokeConfigOutput,
        crate::error::GetFunctionEventInvokeConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_event_invoke_config_error(response)
        } else {
            crate::operation_deser::parse_get_function_event_invoke_config_response(response)
        }
    }
}

/// Operation shape for `GetLayerVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_layer_version`](crate::client::Client::get_layer_version).
///
/// See [`crate::client::fluent_builders::GetLayerVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLayerVersion {
    _private: (),
}
impl GetLayerVersion {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionInput`](crate::input::GetLayerVersionInput)
    pub fn builder() -> crate::input::get_layer_version_input::Builder {
        crate::input::get_layer_version_input::Builder::default()
    }
    /// Creates a new `GetLayerVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLayerVersion {
    type Output = std::result::Result<
        crate::output::GetLayerVersionOutput,
        crate::error::GetLayerVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_layer_version_error(response)
        } else {
            crate::operation_deser::parse_get_layer_version_response(response)
        }
    }
}

/// Operation shape for `GetLayerVersionByArn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_layer_version_by_arn`](crate::client::Client::get_layer_version_by_arn).
///
/// See [`crate::client::fluent_builders::GetLayerVersionByArn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLayerVersionByArn {
    _private: (),
}
impl GetLayerVersionByArn {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionByArnInput`](crate::input::GetLayerVersionByArnInput)
    pub fn builder() -> crate::input::get_layer_version_by_arn_input::Builder {
        crate::input::get_layer_version_by_arn_input::Builder::default()
    }
    /// Creates a new `GetLayerVersionByArn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLayerVersionByArn {
    type Output = std::result::Result<
        crate::output::GetLayerVersionByArnOutput,
        crate::error::GetLayerVersionByArnError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_layer_version_by_arn_error(response)
        } else {
            crate::operation_deser::parse_get_layer_version_by_arn_response(response)
        }
    }
}

/// Operation shape for `GetLayerVersionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_layer_version_policy`](crate::client::Client::get_layer_version_policy).
///
/// See [`crate::client::fluent_builders::GetLayerVersionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLayerVersionPolicy {
    _private: (),
}
impl GetLayerVersionPolicy {
    /// Creates a new builder-style object to manufacture [`GetLayerVersionPolicyInput`](crate::input::GetLayerVersionPolicyInput)
    pub fn builder() -> crate::input::get_layer_version_policy_input::Builder {
        crate::input::get_layer_version_policy_input::Builder::default()
    }
    /// Creates a new `GetLayerVersionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLayerVersionPolicy {
    type Output = std::result::Result<
        crate::output::GetLayerVersionPolicyOutput,
        crate::error::GetLayerVersionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_layer_version_policy_error(response)
        } else {
            crate::operation_deser::parse_get_layer_version_policy_response(response)
        }
    }
}

/// Operation shape for `GetPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy`](crate::client::Client::get_policy).
///
/// See [`crate::client::fluent_builders::GetPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicy {
    _private: (),
}
impl GetPolicy {
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
    /// Creates a new `GetPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicy {
    type Output = std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_error(response)
        } else {
            crate::operation_deser::parse_get_policy_response(response)
        }
    }
}

/// Operation shape for `GetProvisionedConcurrencyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_provisioned_concurrency_config`](crate::client::Client::get_provisioned_concurrency_config).
///
/// See [`crate::client::fluent_builders::GetProvisionedConcurrencyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProvisionedConcurrencyConfig {
    _private: (),
}
impl GetProvisionedConcurrencyConfig {
    /// Creates a new builder-style object to manufacture [`GetProvisionedConcurrencyConfigInput`](crate::input::GetProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::get_provisioned_concurrency_config_input::Builder {
        crate::input::get_provisioned_concurrency_config_input::Builder::default()
    }
    /// Creates a new `GetProvisionedConcurrencyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProvisionedConcurrencyConfig {
    type Output = std::result::Result<
        crate::output::GetProvisionedConcurrencyConfigOutput,
        crate::error::GetProvisionedConcurrencyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_provisioned_concurrency_config_error(response)
        } else {
            crate::operation_deser::parse_get_provisioned_concurrency_config_response(response)
        }
    }
}

/// Operation shape for `Invoke`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invoke`](crate::client::Client::invoke).
///
/// See [`crate::client::fluent_builders::Invoke`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct Invoke {
    _private: (),
}
impl Invoke {
    /// Creates a new builder-style object to manufacture [`InvokeInput`](crate::input::InvokeInput)
    pub fn builder() -> crate::input::invoke_input::Builder {
        crate::input::invoke_input::Builder::default()
    }
    /// Creates a new `Invoke` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for Invoke {
    type Output = std::result::Result<crate::output::InvokeOutput, crate::error::InvokeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invoke_error(response)
        } else {
            crate::operation_deser::parse_invoke_response(response)
        }
    }
}

/// Operation shape for `InvokeAsync`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invoke_async`](crate::client::Client::invoke_async).
///
/// See [`crate::client::fluent_builders::InvokeAsync`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InvokeAsync {
    _private: (),
}
impl InvokeAsync {
    /// Creates a new builder-style object to manufacture [`InvokeAsyncInput`](crate::input::InvokeAsyncInput)
    pub fn builder() -> crate::input::invoke_async_input::Builder {
        crate::input::invoke_async_input::Builder::default()
    }
    /// Creates a new `InvokeAsync` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InvokeAsync {
    type Output =
        std::result::Result<crate::output::InvokeAsyncOutput, crate::error::InvokeAsyncError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_invoke_async_error(response)
        } else {
            crate::operation_deser::parse_invoke_async_response(response)
        }
    }
}

/// Operation shape for `ListAliases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_aliases`](crate::client::Client::list_aliases).
///
/// See [`crate::client::fluent_builders::ListAliases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAliases {
    _private: (),
}
impl ListAliases {
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
    /// Creates a new `ListAliases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAliases {
    type Output =
        std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_aliases_error(response)
        } else {
            crate::operation_deser::parse_list_aliases_response(response)
        }
    }
}

/// Operation shape for `ListCodeSigningConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_code_signing_configs`](crate::client::Client::list_code_signing_configs).
///
/// See [`crate::client::fluent_builders::ListCodeSigningConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCodeSigningConfigs {
    _private: (),
}
impl ListCodeSigningConfigs {
    /// Creates a new builder-style object to manufacture [`ListCodeSigningConfigsInput`](crate::input::ListCodeSigningConfigsInput)
    pub fn builder() -> crate::input::list_code_signing_configs_input::Builder {
        crate::input::list_code_signing_configs_input::Builder::default()
    }
    /// Creates a new `ListCodeSigningConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCodeSigningConfigs {
    type Output = std::result::Result<
        crate::output::ListCodeSigningConfigsOutput,
        crate::error::ListCodeSigningConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_code_signing_configs_error(response)
        } else {
            crate::operation_deser::parse_list_code_signing_configs_response(response)
        }
    }
}

/// Operation shape for `ListEventSourceMappings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_event_source_mappings`](crate::client::Client::list_event_source_mappings).
///
/// See [`crate::client::fluent_builders::ListEventSourceMappings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEventSourceMappings {
    _private: (),
}
impl ListEventSourceMappings {
    /// Creates a new builder-style object to manufacture [`ListEventSourceMappingsInput`](crate::input::ListEventSourceMappingsInput)
    pub fn builder() -> crate::input::list_event_source_mappings_input::Builder {
        crate::input::list_event_source_mappings_input::Builder::default()
    }
    /// Creates a new `ListEventSourceMappings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEventSourceMappings {
    type Output = std::result::Result<
        crate::output::ListEventSourceMappingsOutput,
        crate::error::ListEventSourceMappingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_event_source_mappings_error(response)
        } else {
            crate::operation_deser::parse_list_event_source_mappings_response(response)
        }
    }
}

/// Operation shape for `ListFunctionEventInvokeConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_function_event_invoke_configs`](crate::client::Client::list_function_event_invoke_configs).
///
/// See [`crate::client::fluent_builders::ListFunctionEventInvokeConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctionEventInvokeConfigs {
    _private: (),
}
impl ListFunctionEventInvokeConfigs {
    /// Creates a new builder-style object to manufacture [`ListFunctionEventInvokeConfigsInput`](crate::input::ListFunctionEventInvokeConfigsInput)
    pub fn builder() -> crate::input::list_function_event_invoke_configs_input::Builder {
        crate::input::list_function_event_invoke_configs_input::Builder::default()
    }
    /// Creates a new `ListFunctionEventInvokeConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctionEventInvokeConfigs {
    type Output = std::result::Result<
        crate::output::ListFunctionEventInvokeConfigsOutput,
        crate::error::ListFunctionEventInvokeConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_function_event_invoke_configs_error(response)
        } else {
            crate::operation_deser::parse_list_function_event_invoke_configs_response(response)
        }
    }
}

/// Operation shape for `ListFunctions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_functions`](crate::client::Client::list_functions).
///
/// See [`crate::client::fluent_builders::ListFunctions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctions {
    _private: (),
}
impl ListFunctions {
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
    /// Creates a new `ListFunctions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctions {
    type Output =
        std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_functions_error(response)
        } else {
            crate::operation_deser::parse_list_functions_response(response)
        }
    }
}

/// Operation shape for `ListFunctionsByCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_functions_by_code_signing_config`](crate::client::Client::list_functions_by_code_signing_config).
///
/// See [`crate::client::fluent_builders::ListFunctionsByCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctionsByCodeSigningConfig {
    _private: (),
}
impl ListFunctionsByCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`ListFunctionsByCodeSigningConfigInput`](crate::input::ListFunctionsByCodeSigningConfigInput)
    pub fn builder() -> crate::input::list_functions_by_code_signing_config_input::Builder {
        crate::input::list_functions_by_code_signing_config_input::Builder::default()
    }
    /// Creates a new `ListFunctionsByCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctionsByCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::ListFunctionsByCodeSigningConfigOutput,
        crate::error::ListFunctionsByCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_functions_by_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_list_functions_by_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `ListLayers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_layers`](crate::client::Client::list_layers).
///
/// See [`crate::client::fluent_builders::ListLayers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLayers {
    _private: (),
}
impl ListLayers {
    /// Creates a new builder-style object to manufacture [`ListLayersInput`](crate::input::ListLayersInput)
    pub fn builder() -> crate::input::list_layers_input::Builder {
        crate::input::list_layers_input::Builder::default()
    }
    /// Creates a new `ListLayers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLayers {
    type Output =
        std::result::Result<crate::output::ListLayersOutput, crate::error::ListLayersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_layers_error(response)
        } else {
            crate::operation_deser::parse_list_layers_response(response)
        }
    }
}

/// Operation shape for `ListLayerVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_layer_versions`](crate::client::Client::list_layer_versions).
///
/// See [`crate::client::fluent_builders::ListLayerVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLayerVersions {
    _private: (),
}
impl ListLayerVersions {
    /// Creates a new builder-style object to manufacture [`ListLayerVersionsInput`](crate::input::ListLayerVersionsInput)
    pub fn builder() -> crate::input::list_layer_versions_input::Builder {
        crate::input::list_layer_versions_input::Builder::default()
    }
    /// Creates a new `ListLayerVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLayerVersions {
    type Output = std::result::Result<
        crate::output::ListLayerVersionsOutput,
        crate::error::ListLayerVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_layer_versions_error(response)
        } else {
            crate::operation_deser::parse_list_layer_versions_response(response)
        }
    }
}

/// Operation shape for `ListProvisionedConcurrencyConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_provisioned_concurrency_configs`](crate::client::Client::list_provisioned_concurrency_configs).
///
/// See [`crate::client::fluent_builders::ListProvisionedConcurrencyConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProvisionedConcurrencyConfigs {
    _private: (),
}
impl ListProvisionedConcurrencyConfigs {
    /// Creates a new builder-style object to manufacture [`ListProvisionedConcurrencyConfigsInput`](crate::input::ListProvisionedConcurrencyConfigsInput)
    pub fn builder() -> crate::input::list_provisioned_concurrency_configs_input::Builder {
        crate::input::list_provisioned_concurrency_configs_input::Builder::default()
    }
    /// Creates a new `ListProvisionedConcurrencyConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProvisionedConcurrencyConfigs {
    type Output = std::result::Result<
        crate::output::ListProvisionedConcurrencyConfigsOutput,
        crate::error::ListProvisionedConcurrencyConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_provisioned_concurrency_configs_error(response)
        } else {
            crate::operation_deser::parse_list_provisioned_concurrency_configs_response(response)
        }
    }
}

/// Operation shape for `ListTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags`](crate::client::Client::list_tags).
///
/// See [`crate::client::fluent_builders::ListTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTags {
    _private: (),
}
impl ListTags {
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
    /// Creates a new `ListTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTags {
    type Output = std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_error(response)
        } else {
            crate::operation_deser::parse_list_tags_response(response)
        }
    }
}

/// Operation shape for `ListVersionsByFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_versions_by_function`](crate::client::Client::list_versions_by_function).
///
/// See [`crate::client::fluent_builders::ListVersionsByFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVersionsByFunction {
    _private: (),
}
impl ListVersionsByFunction {
    /// Creates a new builder-style object to manufacture [`ListVersionsByFunctionInput`](crate::input::ListVersionsByFunctionInput)
    pub fn builder() -> crate::input::list_versions_by_function_input::Builder {
        crate::input::list_versions_by_function_input::Builder::default()
    }
    /// Creates a new `ListVersionsByFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVersionsByFunction {
    type Output = std::result::Result<
        crate::output::ListVersionsByFunctionOutput,
        crate::error::ListVersionsByFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_versions_by_function_error(response)
        } else {
            crate::operation_deser::parse_list_versions_by_function_response(response)
        }
    }
}

/// Operation shape for `PublishLayerVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_layer_version`](crate::client::Client::publish_layer_version).
///
/// See [`crate::client::fluent_builders::PublishLayerVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishLayerVersion {
    _private: (),
}
impl PublishLayerVersion {
    /// Creates a new builder-style object to manufacture [`PublishLayerVersionInput`](crate::input::PublishLayerVersionInput)
    pub fn builder() -> crate::input::publish_layer_version_input::Builder {
        crate::input::publish_layer_version_input::Builder::default()
    }
    /// Creates a new `PublishLayerVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishLayerVersion {
    type Output = std::result::Result<
        crate::output::PublishLayerVersionOutput,
        crate::error::PublishLayerVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_publish_layer_version_error(response)
        } else {
            crate::operation_deser::parse_publish_layer_version_response(response)
        }
    }
}

/// Operation shape for `PublishVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`publish_version`](crate::client::Client::publish_version).
///
/// See [`crate::client::fluent_builders::PublishVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PublishVersion {
    _private: (),
}
impl PublishVersion {
    /// Creates a new builder-style object to manufacture [`PublishVersionInput`](crate::input::PublishVersionInput)
    pub fn builder() -> crate::input::publish_version_input::Builder {
        crate::input::publish_version_input::Builder::default()
    }
    /// Creates a new `PublishVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PublishVersion {
    type Output =
        std::result::Result<crate::output::PublishVersionOutput, crate::error::PublishVersionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_publish_version_error(response)
        } else {
            crate::operation_deser::parse_publish_version_response(response)
        }
    }
}

/// Operation shape for `PutFunctionCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_function_code_signing_config`](crate::client::Client::put_function_code_signing_config).
///
/// See [`crate::client::fluent_builders::PutFunctionCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFunctionCodeSigningConfig {
    _private: (),
}
impl PutFunctionCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`PutFunctionCodeSigningConfigInput`](crate::input::PutFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::put_function_code_signing_config_input::Builder {
        crate::input::put_function_code_signing_config_input::Builder::default()
    }
    /// Creates a new `PutFunctionCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFunctionCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::PutFunctionCodeSigningConfigOutput,
        crate::error::PutFunctionCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_function_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_put_function_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `PutFunctionConcurrency`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_function_concurrency`](crate::client::Client::put_function_concurrency).
///
/// See [`crate::client::fluent_builders::PutFunctionConcurrency`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFunctionConcurrency {
    _private: (),
}
impl PutFunctionConcurrency {
    /// Creates a new builder-style object to manufacture [`PutFunctionConcurrencyInput`](crate::input::PutFunctionConcurrencyInput)
    pub fn builder() -> crate::input::put_function_concurrency_input::Builder {
        crate::input::put_function_concurrency_input::Builder::default()
    }
    /// Creates a new `PutFunctionConcurrency` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFunctionConcurrency {
    type Output = std::result::Result<
        crate::output::PutFunctionConcurrencyOutput,
        crate::error::PutFunctionConcurrencyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_function_concurrency_error(response)
        } else {
            crate::operation_deser::parse_put_function_concurrency_response(response)
        }
    }
}

/// Operation shape for `PutFunctionEventInvokeConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_function_event_invoke_config`](crate::client::Client::put_function_event_invoke_config).
///
/// See [`crate::client::fluent_builders::PutFunctionEventInvokeConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFunctionEventInvokeConfig {
    _private: (),
}
impl PutFunctionEventInvokeConfig {
    /// Creates a new builder-style object to manufacture [`PutFunctionEventInvokeConfigInput`](crate::input::PutFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::put_function_event_invoke_config_input::Builder {
        crate::input::put_function_event_invoke_config_input::Builder::default()
    }
    /// Creates a new `PutFunctionEventInvokeConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFunctionEventInvokeConfig {
    type Output = std::result::Result<
        crate::output::PutFunctionEventInvokeConfigOutput,
        crate::error::PutFunctionEventInvokeConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_function_event_invoke_config_error(response)
        } else {
            crate::operation_deser::parse_put_function_event_invoke_config_response(response)
        }
    }
}

/// Operation shape for `PutProvisionedConcurrencyConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_provisioned_concurrency_config`](crate::client::Client::put_provisioned_concurrency_config).
///
/// See [`crate::client::fluent_builders::PutProvisionedConcurrencyConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutProvisionedConcurrencyConfig {
    _private: (),
}
impl PutProvisionedConcurrencyConfig {
    /// Creates a new builder-style object to manufacture [`PutProvisionedConcurrencyConfigInput`](crate::input::PutProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::put_provisioned_concurrency_config_input::Builder {
        crate::input::put_provisioned_concurrency_config_input::Builder::default()
    }
    /// Creates a new `PutProvisionedConcurrencyConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutProvisionedConcurrencyConfig {
    type Output = std::result::Result<
        crate::output::PutProvisionedConcurrencyConfigOutput,
        crate::error::PutProvisionedConcurrencyConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_put_provisioned_concurrency_config_error(response)
        } else {
            crate::operation_deser::parse_put_provisioned_concurrency_config_response(response)
        }
    }
}

/// Operation shape for `RemoveLayerVersionPermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_layer_version_permission`](crate::client::Client::remove_layer_version_permission).
///
/// See [`crate::client::fluent_builders::RemoveLayerVersionPermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveLayerVersionPermission {
    _private: (),
}
impl RemoveLayerVersionPermission {
    /// Creates a new builder-style object to manufacture [`RemoveLayerVersionPermissionInput`](crate::input::RemoveLayerVersionPermissionInput)
    pub fn builder() -> crate::input::remove_layer_version_permission_input::Builder {
        crate::input::remove_layer_version_permission_input::Builder::default()
    }
    /// Creates a new `RemoveLayerVersionPermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveLayerVersionPermission {
    type Output = std::result::Result<
        crate::output::RemoveLayerVersionPermissionOutput,
        crate::error::RemoveLayerVersionPermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_layer_version_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_layer_version_permission_response(response)
        }
    }
}

/// Operation shape for `RemovePermission`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_permission`](crate::client::Client::remove_permission).
///
/// See [`crate::client::fluent_builders::RemovePermission`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemovePermission {
    _private: (),
}
impl RemovePermission {
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
    /// Creates a new `RemovePermission` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemovePermission {
    type Output = std::result::Result<
        crate::output::RemovePermissionOutput,
        crate::error::RemovePermissionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_remove_permission_error(response)
        } else {
            crate::operation_deser::parse_remove_permission_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAlias`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_alias`](crate::client::Client::update_alias).
///
/// See [`crate::client::fluent_builders::UpdateAlias`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAlias {
    _private: (),
}
impl UpdateAlias {
    /// Creates a new builder-style object to manufacture [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    pub fn builder() -> crate::input::update_alias_input::Builder {
        crate::input::update_alias_input::Builder::default()
    }
    /// Creates a new `UpdateAlias` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAlias {
    type Output =
        std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_alias_error(response)
        } else {
            crate::operation_deser::parse_update_alias_response(response)
        }
    }
}

/// Operation shape for `UpdateCodeSigningConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_code_signing_config`](crate::client::Client::update_code_signing_config).
///
/// See [`crate::client::fluent_builders::UpdateCodeSigningConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCodeSigningConfig {
    _private: (),
}
impl UpdateCodeSigningConfig {
    /// Creates a new builder-style object to manufacture [`UpdateCodeSigningConfigInput`](crate::input::UpdateCodeSigningConfigInput)
    pub fn builder() -> crate::input::update_code_signing_config_input::Builder {
        crate::input::update_code_signing_config_input::Builder::default()
    }
    /// Creates a new `UpdateCodeSigningConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCodeSigningConfig {
    type Output = std::result::Result<
        crate::output::UpdateCodeSigningConfigOutput,
        crate::error::UpdateCodeSigningConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_code_signing_config_error(response)
        } else {
            crate::operation_deser::parse_update_code_signing_config_response(response)
        }
    }
}

/// Operation shape for `UpdateEventSourceMapping`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_event_source_mapping`](crate::client::Client::update_event_source_mapping).
///
/// See [`crate::client::fluent_builders::UpdateEventSourceMapping`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateEventSourceMapping {
    _private: (),
}
impl UpdateEventSourceMapping {
    /// Creates a new builder-style object to manufacture [`UpdateEventSourceMappingInput`](crate::input::UpdateEventSourceMappingInput)
    pub fn builder() -> crate::input::update_event_source_mapping_input::Builder {
        crate::input::update_event_source_mapping_input::Builder::default()
    }
    /// Creates a new `UpdateEventSourceMapping` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateEventSourceMapping {
    type Output = std::result::Result<
        crate::output::UpdateEventSourceMappingOutput,
        crate::error::UpdateEventSourceMappingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_event_source_mapping_error(response)
        } else {
            crate::operation_deser::parse_update_event_source_mapping_response(response)
        }
    }
}

/// Operation shape for `UpdateFunctionCode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function_code`](crate::client::Client::update_function_code).
///
/// See [`crate::client::fluent_builders::UpdateFunctionCode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunctionCode {
    _private: (),
}
impl UpdateFunctionCode {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionCodeInput`](crate::input::UpdateFunctionCodeInput)
    pub fn builder() -> crate::input::update_function_code_input::Builder {
        crate::input::update_function_code_input::Builder::default()
    }
    /// Creates a new `UpdateFunctionCode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunctionCode {
    type Output = std::result::Result<
        crate::output::UpdateFunctionCodeOutput,
        crate::error::UpdateFunctionCodeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_code_error(response)
        } else {
            crate::operation_deser::parse_update_function_code_response(response)
        }
    }
}

/// Operation shape for `UpdateFunctionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function_configuration`](crate::client::Client::update_function_configuration).
///
/// See [`crate::client::fluent_builders::UpdateFunctionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunctionConfiguration {
    _private: (),
}
impl UpdateFunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionConfigurationInput`](crate::input::UpdateFunctionConfigurationInput)
    pub fn builder() -> crate::input::update_function_configuration_input::Builder {
        crate::input::update_function_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateFunctionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunctionConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateFunctionConfigurationOutput,
        crate::error::UpdateFunctionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_function_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateFunctionEventInvokeConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function_event_invoke_config`](crate::client::Client::update_function_event_invoke_config).
///
/// See [`crate::client::fluent_builders::UpdateFunctionEventInvokeConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunctionEventInvokeConfig {
    _private: (),
}
impl UpdateFunctionEventInvokeConfig {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionEventInvokeConfigInput`](crate::input::UpdateFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::update_function_event_invoke_config_input::Builder {
        crate::input::update_function_event_invoke_config_input::Builder::default()
    }
    /// Creates a new `UpdateFunctionEventInvokeConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunctionEventInvokeConfig {
    type Output = std::result::Result<
        crate::output::UpdateFunctionEventInvokeConfigOutput,
        crate::error::UpdateFunctionEventInvokeConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_event_invoke_config_error(response)
        } else {
            crate::operation_deser::parse_update_function_event_invoke_config_response(response)
        }
    }
}
