// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS Lambda
///
/// Client for invoking operations on AWS Lambda. Each operation on AWS Lambda is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lambda::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lambda::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lambda::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddLayerVersionPermission` operation.
    ///
    /// See [`AddLayerVersionPermission`](crate::client::fluent_builders::AddLayerVersionPermission) for more information about the
    /// operation and its arguments.
    pub fn add_layer_version_permission(
        &self,
    ) -> fluent_builders::AddLayerVersionPermission<C, M, R> {
        fluent_builders::AddLayerVersionPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddPermission` operation.
    ///
    /// See [`AddPermission`](crate::client::fluent_builders::AddPermission) for more information about the
    /// operation and its arguments.
    pub fn add_permission(&self) -> fluent_builders::AddPermission<C, M, R> {
        fluent_builders::AddPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAlias` operation.
    ///
    /// See [`CreateAlias`](crate::client::fluent_builders::CreateAlias) for more information about the
    /// operation and its arguments.
    pub fn create_alias(&self) -> fluent_builders::CreateAlias<C, M, R> {
        fluent_builders::CreateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCodeSigningConfig` operation.
    ///
    /// See [`CreateCodeSigningConfig`](crate::client::fluent_builders::CreateCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn create_code_signing_config(&self) -> fluent_builders::CreateCodeSigningConfig<C, M, R> {
        fluent_builders::CreateCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSourceMapping` operation.
    ///
    /// See [`CreateEventSourceMapping`](crate::client::fluent_builders::CreateEventSourceMapping) for more information about the
    /// operation and its arguments.
    pub fn create_event_source_mapping(
        &self,
    ) -> fluent_builders::CreateEventSourceMapping<C, M, R> {
        fluent_builders::CreateEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFunction` operation.
    ///
    /// See [`CreateFunction`](crate::client::fluent_builders::CreateFunction) for more information about the
    /// operation and its arguments.
    pub fn create_function(&self) -> fluent_builders::CreateFunction<C, M, R> {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlias` operation.
    ///
    /// See [`DeleteAlias`](crate::client::fluent_builders::DeleteAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_alias(&self) -> fluent_builders::DeleteAlias<C, M, R> {
        fluent_builders::DeleteAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCodeSigningConfig` operation.
    ///
    /// See [`DeleteCodeSigningConfig`](crate::client::fluent_builders::DeleteCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_code_signing_config(&self) -> fluent_builders::DeleteCodeSigningConfig<C, M, R> {
        fluent_builders::DeleteCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSourceMapping` operation.
    ///
    /// See [`DeleteEventSourceMapping`](crate::client::fluent_builders::DeleteEventSourceMapping) for more information about the
    /// operation and its arguments.
    pub fn delete_event_source_mapping(
        &self,
    ) -> fluent_builders::DeleteEventSourceMapping<C, M, R> {
        fluent_builders::DeleteEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunction` operation.
    ///
    /// See [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) for more information about the
    /// operation and its arguments.
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction<C, M, R> {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunctionCodeSigningConfig` operation.
    ///
    /// See [`DeleteFunctionCodeSigningConfig`](crate::client::fluent_builders::DeleteFunctionCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_function_code_signing_config(
        &self,
    ) -> fluent_builders::DeleteFunctionCodeSigningConfig<C, M, R> {
        fluent_builders::DeleteFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunctionConcurrency` operation.
    ///
    /// See [`DeleteFunctionConcurrency`](crate::client::fluent_builders::DeleteFunctionConcurrency) for more information about the
    /// operation and its arguments.
    pub fn delete_function_concurrency(
        &self,
    ) -> fluent_builders::DeleteFunctionConcurrency<C, M, R> {
        fluent_builders::DeleteFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunctionEventInvokeConfig` operation.
    ///
    /// See [`DeleteFunctionEventInvokeConfig`](crate::client::fluent_builders::DeleteFunctionEventInvokeConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_function_event_invoke_config(
        &self,
    ) -> fluent_builders::DeleteFunctionEventInvokeConfig<C, M, R> {
        fluent_builders::DeleteFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLayerVersion` operation.
    ///
    /// See [`DeleteLayerVersion`](crate::client::fluent_builders::DeleteLayerVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_layer_version(&self) -> fluent_builders::DeleteLayerVersion<C, M, R> {
        fluent_builders::DeleteLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProvisionedConcurrencyConfig` operation.
    ///
    /// See [`DeleteProvisionedConcurrencyConfig`](crate::client::fluent_builders::DeleteProvisionedConcurrencyConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::DeleteProvisionedConcurrencyConfig<C, M, R> {
        fluent_builders::DeleteProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSettings` operation.
    ///
    /// See [`GetAccountSettings`](crate::client::fluent_builders::GetAccountSettings) for more information about the
    /// operation and its arguments.
    pub fn get_account_settings(&self) -> fluent_builders::GetAccountSettings<C, M, R> {
        fluent_builders::GetAccountSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAlias` operation.
    ///
    /// See [`GetAlias`](crate::client::fluent_builders::GetAlias) for more information about the
    /// operation and its arguments.
    pub fn get_alias(&self) -> fluent_builders::GetAlias<C, M, R> {
        fluent_builders::GetAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCodeSigningConfig` operation.
    ///
    /// See [`GetCodeSigningConfig`](crate::client::fluent_builders::GetCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn get_code_signing_config(&self) -> fluent_builders::GetCodeSigningConfig<C, M, R> {
        fluent_builders::GetCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEventSourceMapping` operation.
    ///
    /// See [`GetEventSourceMapping`](crate::client::fluent_builders::GetEventSourceMapping) for more information about the
    /// operation and its arguments.
    pub fn get_event_source_mapping(&self) -> fluent_builders::GetEventSourceMapping<C, M, R> {
        fluent_builders::GetEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunction` operation.
    ///
    /// See [`GetFunction`](crate::client::fluent_builders::GetFunction) for more information about the
    /// operation and its arguments.
    pub fn get_function(&self) -> fluent_builders::GetFunction<C, M, R> {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionCodeSigningConfig` operation.
    ///
    /// See [`GetFunctionCodeSigningConfig`](crate::client::fluent_builders::GetFunctionCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn get_function_code_signing_config(
        &self,
    ) -> fluent_builders::GetFunctionCodeSigningConfig<C, M, R> {
        fluent_builders::GetFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionConcurrency` operation.
    ///
    /// See [`GetFunctionConcurrency`](crate::client::fluent_builders::GetFunctionConcurrency) for more information about the
    /// operation and its arguments.
    pub fn get_function_concurrency(&self) -> fluent_builders::GetFunctionConcurrency<C, M, R> {
        fluent_builders::GetFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionConfiguration` operation.
    ///
    /// See [`GetFunctionConfiguration`](crate::client::fluent_builders::GetFunctionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_function_configuration(&self) -> fluent_builders::GetFunctionConfiguration<C, M, R> {
        fluent_builders::GetFunctionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunctionEventInvokeConfig` operation.
    ///
    /// See [`GetFunctionEventInvokeConfig`](crate::client::fluent_builders::GetFunctionEventInvokeConfig) for more information about the
    /// operation and its arguments.
    pub fn get_function_event_invoke_config(
        &self,
    ) -> fluent_builders::GetFunctionEventInvokeConfig<C, M, R> {
        fluent_builders::GetFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLayerVersion` operation.
    ///
    /// See [`GetLayerVersion`](crate::client::fluent_builders::GetLayerVersion) for more information about the
    /// operation and its arguments.
    pub fn get_layer_version(&self) -> fluent_builders::GetLayerVersion<C, M, R> {
        fluent_builders::GetLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLayerVersionByArn` operation.
    ///
    /// See [`GetLayerVersionByArn`](crate::client::fluent_builders::GetLayerVersionByArn) for more information about the
    /// operation and its arguments.
    pub fn get_layer_version_by_arn(&self) -> fluent_builders::GetLayerVersionByArn<C, M, R> {
        fluent_builders::GetLayerVersionByArn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLayerVersionPolicy` operation.
    ///
    /// See [`GetLayerVersionPolicy`](crate::client::fluent_builders::GetLayerVersionPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_layer_version_policy(&self) -> fluent_builders::GetLayerVersionPolicy<C, M, R> {
        fluent_builders::GetLayerVersionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicy` operation.
    ///
    /// See [`GetPolicy`](crate::client::fluent_builders::GetPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProvisionedConcurrencyConfig` operation.
    ///
    /// See [`GetProvisionedConcurrencyConfig`](crate::client::fluent_builders::GetProvisionedConcurrencyConfig) for more information about the
    /// operation and its arguments.
    pub fn get_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::GetProvisionedConcurrencyConfig<C, M, R> {
        fluent_builders::GetProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Invoke` operation.
    ///
    /// See [`Invoke`](crate::client::fluent_builders::Invoke) for more information about the
    /// operation and its arguments.
    pub fn invoke(&self) -> fluent_builders::Invoke<C, M, R> {
        fluent_builders::Invoke::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InvokeAsync` operation.
    ///
    /// See [`InvokeAsync`](crate::client::fluent_builders::InvokeAsync) for more information about the
    /// operation and its arguments.
    pub fn invoke_async(&self) -> fluent_builders::InvokeAsync<C, M, R> {
        fluent_builders::InvokeAsync::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAliases` operation.
    ///
    /// See [`ListAliases`](crate::client::fluent_builders::ListAliases) for more information about the
    /// operation and its arguments.
    pub fn list_aliases(&self) -> fluent_builders::ListAliases<C, M, R> {
        fluent_builders::ListAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCodeSigningConfigs` operation.
    ///
    /// See [`ListCodeSigningConfigs`](crate::client::fluent_builders::ListCodeSigningConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_code_signing_configs(&self) -> fluent_builders::ListCodeSigningConfigs<C, M, R> {
        fluent_builders::ListCodeSigningConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventSourceMappings` operation.
    ///
    /// See [`ListEventSourceMappings`](crate::client::fluent_builders::ListEventSourceMappings) for more information about the
    /// operation and its arguments.
    pub fn list_event_source_mappings(&self) -> fluent_builders::ListEventSourceMappings<C, M, R> {
        fluent_builders::ListEventSourceMappings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctionEventInvokeConfigs` operation.
    ///
    /// See [`ListFunctionEventInvokeConfigs`](crate::client::fluent_builders::ListFunctionEventInvokeConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_function_event_invoke_configs(
        &self,
    ) -> fluent_builders::ListFunctionEventInvokeConfigs<C, M, R> {
        fluent_builders::ListFunctionEventInvokeConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctions` operation.
    ///
    /// See [`ListFunctions`](crate::client::fluent_builders::ListFunctions) for more information about the
    /// operation and its arguments.
    pub fn list_functions(&self) -> fluent_builders::ListFunctions<C, M, R> {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctionsByCodeSigningConfig` operation.
    ///
    /// See [`ListFunctionsByCodeSigningConfig`](crate::client::fluent_builders::ListFunctionsByCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn list_functions_by_code_signing_config(
        &self,
    ) -> fluent_builders::ListFunctionsByCodeSigningConfig<C, M, R> {
        fluent_builders::ListFunctionsByCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLayers` operation.
    ///
    /// See [`ListLayers`](crate::client::fluent_builders::ListLayers) for more information about the
    /// operation and its arguments.
    pub fn list_layers(&self) -> fluent_builders::ListLayers<C, M, R> {
        fluent_builders::ListLayers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLayerVersions` operation.
    ///
    /// See [`ListLayerVersions`](crate::client::fluent_builders::ListLayerVersions) for more information about the
    /// operation and its arguments.
    pub fn list_layer_versions(&self) -> fluent_builders::ListLayerVersions<C, M, R> {
        fluent_builders::ListLayerVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProvisionedConcurrencyConfigs` operation.
    ///
    /// See [`ListProvisionedConcurrencyConfigs`](crate::client::fluent_builders::ListProvisionedConcurrencyConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_provisioned_concurrency_configs(
        &self,
    ) -> fluent_builders::ListProvisionedConcurrencyConfigs<C, M, R> {
        fluent_builders::ListProvisionedConcurrencyConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTags` operation.
    ///
    /// See [`ListTags`](crate::client::fluent_builders::ListTags) for more information about the
    /// operation and its arguments.
    pub fn list_tags(&self) -> fluent_builders::ListTags<C, M, R> {
        fluent_builders::ListTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVersionsByFunction` operation.
    ///
    /// See [`ListVersionsByFunction`](crate::client::fluent_builders::ListVersionsByFunction) for more information about the
    /// operation and its arguments.
    pub fn list_versions_by_function(&self) -> fluent_builders::ListVersionsByFunction<C, M, R> {
        fluent_builders::ListVersionsByFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishLayerVersion` operation.
    ///
    /// See [`PublishLayerVersion`](crate::client::fluent_builders::PublishLayerVersion) for more information about the
    /// operation and its arguments.
    pub fn publish_layer_version(&self) -> fluent_builders::PublishLayerVersion<C, M, R> {
        fluent_builders::PublishLayerVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PublishVersion` operation.
    ///
    /// See [`PublishVersion`](crate::client::fluent_builders::PublishVersion) for more information about the
    /// operation and its arguments.
    pub fn publish_version(&self) -> fluent_builders::PublishVersion<C, M, R> {
        fluent_builders::PublishVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFunctionCodeSigningConfig` operation.
    ///
    /// See [`PutFunctionCodeSigningConfig`](crate::client::fluent_builders::PutFunctionCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn put_function_code_signing_config(
        &self,
    ) -> fluent_builders::PutFunctionCodeSigningConfig<C, M, R> {
        fluent_builders::PutFunctionCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFunctionConcurrency` operation.
    ///
    /// See [`PutFunctionConcurrency`](crate::client::fluent_builders::PutFunctionConcurrency) for more information about the
    /// operation and its arguments.
    pub fn put_function_concurrency(&self) -> fluent_builders::PutFunctionConcurrency<C, M, R> {
        fluent_builders::PutFunctionConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFunctionEventInvokeConfig` operation.
    ///
    /// See [`PutFunctionEventInvokeConfig`](crate::client::fluent_builders::PutFunctionEventInvokeConfig) for more information about the
    /// operation and its arguments.
    pub fn put_function_event_invoke_config(
        &self,
    ) -> fluent_builders::PutFunctionEventInvokeConfig<C, M, R> {
        fluent_builders::PutFunctionEventInvokeConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutProvisionedConcurrencyConfig` operation.
    ///
    /// See [`PutProvisionedConcurrencyConfig`](crate::client::fluent_builders::PutProvisionedConcurrencyConfig) for more information about the
    /// operation and its arguments.
    pub fn put_provisioned_concurrency_config(
        &self,
    ) -> fluent_builders::PutProvisionedConcurrencyConfig<C, M, R> {
        fluent_builders::PutProvisionedConcurrencyConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveLayerVersionPermission` operation.
    ///
    /// See [`RemoveLayerVersionPermission`](crate::client::fluent_builders::RemoveLayerVersionPermission) for more information about the
    /// operation and its arguments.
    pub fn remove_layer_version_permission(
        &self,
    ) -> fluent_builders::RemoveLayerVersionPermission<C, M, R> {
        fluent_builders::RemoveLayerVersionPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemovePermission` operation.
    ///
    /// See [`RemovePermission`](crate::client::fluent_builders::RemovePermission) for more information about the
    /// operation and its arguments.
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission<C, M, R> {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAlias` operation.
    ///
    /// See [`UpdateAlias`](crate::client::fluent_builders::UpdateAlias) for more information about the
    /// operation and its arguments.
    pub fn update_alias(&self) -> fluent_builders::UpdateAlias<C, M, R> {
        fluent_builders::UpdateAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateCodeSigningConfig` operation.
    ///
    /// See [`UpdateCodeSigningConfig`](crate::client::fluent_builders::UpdateCodeSigningConfig) for more information about the
    /// operation and its arguments.
    pub fn update_code_signing_config(&self) -> fluent_builders::UpdateCodeSigningConfig<C, M, R> {
        fluent_builders::UpdateCodeSigningConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEventSourceMapping` operation.
    ///
    /// See [`UpdateEventSourceMapping`](crate::client::fluent_builders::UpdateEventSourceMapping) for more information about the
    /// operation and its arguments.
    pub fn update_event_source_mapping(
        &self,
    ) -> fluent_builders::UpdateEventSourceMapping<C, M, R> {
        fluent_builders::UpdateEventSourceMapping::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunctionCode` operation.
    ///
    /// See [`UpdateFunctionCode`](crate::client::fluent_builders::UpdateFunctionCode) for more information about the
    /// operation and its arguments.
    pub fn update_function_code(&self) -> fluent_builders::UpdateFunctionCode<C, M, R> {
        fluent_builders::UpdateFunctionCode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunctionConfiguration` operation.
    ///
    /// See [`UpdateFunctionConfiguration`](crate::client::fluent_builders::UpdateFunctionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_function_configuration(
        &self,
    ) -> fluent_builders::UpdateFunctionConfiguration<C, M, R> {
        fluent_builders::UpdateFunctionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunctionEventInvokeConfig` operation.
    ///
    /// See [`UpdateFunctionEventInvokeConfig`](crate::client::fluent_builders::UpdateFunctionEventInvokeConfig) for more information about the
    /// operation and its arguments.
    pub fn update_function_event_invoke_config(
        &self,
    ) -> fluent_builders::UpdateFunctionEventInvokeConfig<C, M, R> {
        fluent_builders::UpdateFunctionEventInvokeConfig::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddLayerVersionPermission`.
    ///
    /// <p>Adds permissions to the resource-based policy of a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>. Use this action to grant layer
    /// usage permission to other accounts. You can grant permission to a single account, all accounts in an organization,
    /// or all Amazon Web Services accounts.  </p>
    /// <p>To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you
    /// specified when you added it.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddLayerVersionPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_layer_version_permission_input::Builder,
    }
    impl<C, M, R> AddLayerVersionPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddLayerVersionPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddLayerVersionPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddLayerVersionPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddLayerVersionPermissionInputOperationOutputAlias,
                crate::output::AddLayerVersionPermissionOutput,
                crate::error::AddLayerVersionPermissionError,
                crate::input::AddLayerVersionPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all
        /// accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified).
        /// For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer.
        /// </p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all
        /// accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified).
        /// For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer.
        /// </p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified
        /// organization.</p>
        pub fn organization_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organization_id(inp);
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified
        /// organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organization_id(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddPermission`.
    ///
    /// <p>Grants an Amazon Web Services service or another account permission to use a function. You can apply the policy at the
    /// function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier,
    /// the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
    /// Note: Lambda does not support adding policies to version $LATEST.</p>
    ///
    /// <p>To grant permission to another account, specify the account ID as the <code>Principal</code>. For Amazon Web Services
    /// services, the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or
    /// <code>sns.amazonaws.com</code>. For Amazon Web Services services, you can also specify the ARN of the associated resource as the
    /// <code>SourceArn</code>. If you grant permission to a service principal without specifying the source, other
    /// accounts could potentially configure resources in their account to invoke your Lambda function.</p>
    ///
    /// <p>This action adds a statement to a resource-based permissions policy for the function. For more information
    /// about function policies, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function Policies</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct AddPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_permission_input::Builder,
    }
    impl<C, M, R> AddPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddPermissionInputOperationOutputAlias,
                crate::output::AddPermissionOutput,
                crate::error::AddPermissionError,
                crate::input::AddPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or
        /// <code>lambda:GetFunction</code>.</p>
        pub fn action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or
        /// <code>lambda:GetFunction</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or
        /// <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn principal(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(inp);
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or
        /// <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or
        /// Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or
        /// Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to
        /// ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted
        /// by its owner and recreated by another account.</p>
        pub fn source_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_account(inp);
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to
        /// ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted
        /// by its owner and recreated by another account.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_account(input);
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn event_source_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_token(inp);
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn set_event_source_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_token(input);
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlias`.
    ///
    /// <p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a
    /// Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a
    /// different version.</p>
    /// <p>You can also map an alias to split invocation requests between two versions. Use the
    /// <code>RoutingConfig</code> parameter to specify a second version and the percentage of invocation requests that
    /// it receives.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alias_input::Builder,
    }
    impl<C, M, R> CreateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAliasInputOperationOutputAlias,
                crate::output::CreateAliasOutput,
                crate::error::CreateAliasError,
                crate::input::CreateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, inp: crate::model::AliasRoutingConfiguration) -> Self {
            self.inner = self.inner.routing_config(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_routing_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCodeSigningConfig`.
    ///
    /// <p>Creates a code signing configuration. A <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html">code signing configuration</a> defines a list of
    /// allowed signing profiles and defines the code-signing validation policy (action to be taken if deployment
    /// validation checks fail). </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_code_signing_config_input::Builder,
    }
    impl<C, M, R> CreateCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCodeSigningConfigInputOperationOutputAlias,
                crate::output::CreateCodeSigningConfigOutput,
                crate::error::CreateCodeSigningConfigError,
                crate::input::CreateCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, inp: crate::model::AllowedPublishers) -> Self {
            self.inner = self.inner.allowed_publishers(inp);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.inner = self.inner.set_allowed_publishers(input);
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn code_signing_policies(mut self, inp: crate::model::CodeSigningPolicies) -> Self {
            self.inner = self.inner.code_signing_policies(inp);
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSourceMapping`.
    ///
    /// <p>Creates a mapping between an event source and an Lambda function. Lambda reads items from the
    /// event source and triggers the function.</p>
    /// <p>For details about how to configure different event sources, see the following topics. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping">
    /// Amazon DynamoDB Streams</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
    /// Amazon Kinesis</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource">
    /// Amazon SQS</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping">
    /// Amazon MQ and RabbitMQ</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html">
    /// Amazon MSK</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html">
    /// Apache Kafka</a>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>The following error handling options are only available for stream sources (DynamoDB and Kinesis):</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ParallelizationFactor</code> - Process multiple batches from each shard concurrently.</p>
    /// </li>
    /// </ul>
    /// <p>For information about which configuration parameters apply to each event source, see the following topics.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params">
    /// Amazon DynamoDB Streams</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params">
    /// Amazon Kinesis</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params">
    /// Amazon SQS</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params">
    /// Amazon MQ and RabbitMQ</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms">
    /// Amazon MSK</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms">
    /// Apache Kafka</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSourceMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_source_mapping_input::Builder,
    }
    impl<C, M, R> CreateEventSourceMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSourceMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSourceMappingInputOperationOutputAlias,
                crate::output::CreateEventSourceMappingOutput,
                crate::error::CreateEventSourceMappingError,
                crate::input::CreateEventSourceMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p>
        /// </li>
        /// </ul>
        pub fn event_source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation
        /// (6 MB).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// </ul>
        pub fn batch_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.batch_size(inp);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation
        /// (6 MB).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_batch_size(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_batching_window_in_seconds(inp);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, inp: i32) -> Self {
            self.inner = self.inner.parallelization_factor(inp);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_parallelization_factor(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon
        /// MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn starting_position(mut self, inp: crate::model::EventSourcePosition) -> Self {
            self.inner = self.inner.starting_position(inp);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon
        /// MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.inner = self.inner.set_starting_position(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn starting_position_timestamp(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.starting_position_timestamp(inp);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start
        /// reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_starting_position_timestamp(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, inp: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(inp);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_record_age_in_seconds(inp);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, inp: bool) -> Self {
            self.inner = self.inner.bisect_batch_on_function_error(inp);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(inp);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.tumbling_window_in_seconds(inp);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_tumbling_window_in_seconds(input);
            self
        }
        /// Appends an item to `Topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topics(inp);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_topics(input);
            self
        }
        /// Appends an item to `Queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn queues(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queues(inp);
            self
        }
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_queues(input);
            self
        }
        /// Appends an item to `SourceAccessConfigurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            inp: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            self.inner = self.inner.source_access_configurations(inp);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_source_access_configurations(input);
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn self_managed_event_source(
            mut self,
            inp: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.inner = self.inner.self_managed_event_source(inp);
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.inner = self.inner.set_self_managed_event_source(input);
            self
        }
        /// Appends an item to `FunctionResponseTypes`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            inp: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            self.inner = self.inner.function_response_types(inp);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.inner = self.inner.set_function_response_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a Lambda function. To create a function, you need a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">execution role</a>. The
    /// deployment package is a .zip file  archive or container image that contains your function code. The execution role grants the function permission to use Amazon Web Services
    /// services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request tracing.</p>
    ///
    /// <p>You set the package type to <code>Image</code> if the deployment package is a
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>. For a container image,
    /// the code property must include the URI of a container image in the Amazon ECR registry.
    /// You do not need to specify the handler and runtime properties. </p>
    ///
    /// <p>You set the package type to <code>Zip</code> if the deployment package is a <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip file
    /// archive</a>. For a .zip file archive, the code property specifies the location of the
    /// .zip file. You must also specify the handler and runtime properties. The code in the
    /// deployment package must be compatible with the target instruction set architecture of the
    /// function (<code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, the default value is
    /// <code>x86-64</code>.</p>
    ///
    /// <p>When you create a function, Lambda provisions an instance of the function and its supporting resources. If
    /// your function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or
    /// modify the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in
    /// the response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For
    /// more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function
    /// States</a>.</p>
    ///
    /// <p>A function has an unpublished version, and can have published versions and aliases. The unpublished version
    /// changes when you update your function's code and configuration. A published version is a snapshot of your function
    /// code and configuration that can't be changed. An alias is a named resource that maps to a version, and can be
    /// changed to map to a different version. Use the <code>Publish</code> parameter to create version <code>1</code> of
    /// your function from its initial configuration.</p>
    ///
    /// <p>The other parameters let you configure version-specific and function-level settings. You can modify
    /// version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply
    /// to both the unpublished and published versions of the function, and include tags (<a>TagResource</a>)
    /// and per-function concurrency limits (<a>PutFunctionConcurrency</a>).</p>
    ///
    /// <p>You can use code signing if your deployment package is a .zip file archive. To enable code signing for this function,
    /// specify the ARN of a code-signing configuration. When a user
    /// attempts to deploy a code package with <a>UpdateFunctionCode</a>, Lambda checks that the code
    /// package has a valid signature from a trusted publisher. The code-signing configuration
    /// includes set set of signing profiles, which define the trusted publishers for this function.</p>
    ///
    /// <p>If another account or an Amazon Web Services service invokes your function, use <a>AddPermission</a> to grant
    /// permission by creating a resource-based IAM policy. You can grant permissions at the function level, on a version,
    /// or on an alias.</p>
    ///
    /// <p>To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events
    /// in other Amazon Web Services services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a
    /// function trigger in the other service. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Functions</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_function_input::Builder,
    }
    impl<C, M, R> CreateFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFunctionInputOperationOutputAlias,
                crate::output::CreateFunctionOutput,
                crate::error::CreateFunctionError,
                crate::input::CreateFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.</p>
        pub fn runtime(mut self, inp: crate::model::Runtime) -> Self {
            self.inner = self.inner.runtime(inp);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.inner = self.inner.set_runtime(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. The format includes the
        /// file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information,
        /// see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handler(inp);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. The format includes the
        /// file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information,
        /// see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handler(input);
            self
        }
        /// <p>The code for the function.</p>
        pub fn code(mut self, inp: crate::model::FunctionCode) -> Self {
            self.inner = self.inner.code(inp);
            self
        }
        /// <p>The code for the function.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::FunctionCode>) -> Self {
            self.inner = self.inner.set_code(input);
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The
        /// maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The
        /// maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The amount of  <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime.
        /// Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.memory_size(inp);
            self
        }
        /// <p>The amount of  <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime.
        /// Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_memory_size(input);
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn publish(mut self, inp: bool) -> Self {
            self.inner = self.inner.publish(inp);
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publish(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC.
        /// When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC.
        /// When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn package_type(mut self, inp: crate::model::PackageType) -> Self {
            self.inner = self.inner.package_type(inp);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.inner = self.inner.set_package_type(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
        /// when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, inp: crate::model::DeadLetterConfig) -> Self {
            self.inner = self.inner.dead_letter_config(inp);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
        /// when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_config(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, inp: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment
        /// variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment
        /// variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, inp: crate::model::TracingConfig) -> Self {
            self.inner = self.inner.tracing_config(inp);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.inner = self.inner.set_tracing_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
        /// function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
        /// function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `Layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a>
        /// to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layers(inp);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a>
        /// to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layers(input);
            self
        }
        /// Appends an item to `FileSystemConfigs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(
            mut self,
            inp: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            self.inner = self.inner.file_system_configs(inp);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_configs(input);
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration
        /// values</a> that override the values in the container image Dockerfile.</p>
        pub fn image_config(mut self, inp: crate::model::ImageConfig) -> Self {
            self.inner = self.inner.image_config(inp);
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration
        /// values</a> that override the values in the container image Dockerfile.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.inner = self.inner.set_image_config(input);
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration
        /// includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration
        /// includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// Appends an item to `Architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64).
        /// The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, inp: impl Into<crate::model::Architecture>) -> Self {
            self.inner = self.inner.architectures(inp);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64).
        /// The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlias`.
    ///
    /// <p>Deletes a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alias_input::Builder,
    }
    impl<C, M, R> DeleteAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAliasInputOperationOutputAlias,
                crate::output::DeleteAliasOutput,
                crate::error::DeleteAliasError,
                crate::input::DeleteAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCodeSigningConfig`.
    ///
    /// <p>Deletes the code signing configuration. You can delete the code signing configuration only if no function is
    /// using it. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_code_signing_config_input::Builder,
    }
    impl<C, M, R> DeleteCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCodeSigningConfigInputOperationOutputAlias,
                crate::output::DeleteCodeSigningConfigOutput,
                crate::error::DeleteCodeSigningConfigError,
                crate::input::DeleteCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSourceMapping`.
    ///
    /// <p>Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
    /// mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.</p>
    /// <p>When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
    /// deleted for several seconds.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSourceMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_source_mapping_input::Builder,
    }
    impl<C, M, R> DeleteEventSourceMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSourceMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSourceMappingInputOperationOutputAlias,
                crate::output::DeleteEventSourceMappingOutput,
                crate::error::DeleteEventSourceMappingError,
                crate::input::DeleteEventSourceMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(inp);
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
    /// Otherwise, all versions and aliases are deleted.</p>
    ///
    /// <p>To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>.
    /// For Amazon Web Services services and resources that invoke your function directly, delete the trigger in the service where you
    /// originally configured it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl<C, M, R> DeleteFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionInputOperationOutputAlias,
                crate::output::DeleteFunctionOutput,
                crate::error::DeleteFunctionError,
                crate::input::DeleteFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionCodeSigningConfig`.
    ///
    /// <p>Removes the code signing configuration from the function.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunctionCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_code_signing_config_input::Builder,
    }
    impl<C, M, R> DeleteFunctionCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionCodeSigningConfigInputOperationOutputAlias,
                crate::output::DeleteFunctionCodeSigningConfigOutput,
                crate::error::DeleteFunctionCodeSigningConfigError,
                crate::input::DeleteFunctionCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionConcurrency`.
    ///
    /// <p>Removes a concurrent execution limit from a function.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunctionConcurrency<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_concurrency_input::Builder,
    }
    impl<C, M, R> DeleteFunctionConcurrency<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionConcurrencyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionConcurrencyInputOperationOutputAlias,
                crate::output::DeleteFunctionConcurrencyOutput,
                crate::error::DeleteFunctionConcurrencyError,
                crate::input::DeleteFunctionConcurrencyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunctionEventInvokeConfig`.
    ///
    /// <p>Deletes the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunctionEventInvokeConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_event_invoke_config_input::Builder,
    }
    impl<C, M, R> DeleteFunctionEventInvokeConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionEventInvokeConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionEventInvokeConfigInputOperationOutputAlias,
                crate::output::DeleteFunctionEventInvokeConfigOutput,
                crate::error::DeleteFunctionEventInvokeConfigError,
                crate::input::DeleteFunctionEventInvokeConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLayerVersion`.
    ///
    /// <p>Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid
    /// breaking functions, a copy of the version remains in Lambda until no functions refer to it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLayerVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_layer_version_input::Builder,
    }
    impl<C, M, R> DeleteLayerVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLayerVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLayerVersionInputOperationOutputAlias,
                crate::output::DeleteLayerVersionOutput,
                crate::error::DeleteLayerVersionError,
                crate::input::DeleteLayerVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProvisionedConcurrencyConfig`.
    ///
    /// <p>Deletes the provisioned concurrency configuration for a function.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProvisionedConcurrencyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_provisioned_concurrency_config_input::Builder,
    }
    impl<C, M, R> DeleteProvisionedConcurrencyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteProvisionedConcurrencyConfigError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProvisionedConcurrencyConfigInputOperationOutputAlias,
                crate::output::DeleteProvisionedConcurrencyConfigOutput,
                crate::error::DeleteProvisionedConcurrencyConfigError,
                crate::input::DeleteProvisionedConcurrencyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountSettings`.
    ///
    /// <p>Retrieves details about your account's <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_settings_input::Builder,
    }
    impl<C, M, R> GetAccountSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSettingsInputOperationOutputAlias,
                crate::output::GetAccountSettingsOutput,
                crate::error::GetAccountSettingsError,
                crate::input::GetAccountSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAlias`.
    ///
    /// <p>Returns details about a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_alias_input::Builder,
    }
    impl<C, M, R> GetAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAliasInputOperationOutputAlias,
                crate::output::GetAliasOutput,
                crate::error::GetAliasError,
                crate::input::GetAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCodeSigningConfig`.
    ///
    /// <p>Returns information about the specified code signing configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_code_signing_config_input::Builder,
    }
    impl<C, M, R> GetCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCodeSigningConfigInputOperationOutputAlias,
                crate::output::GetCodeSigningConfigOutput,
                crate::error::GetCodeSigningConfigError,
                crate::input::GetCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEventSourceMapping`.
    ///
    /// <p>Returns details about an event source mapping. You can get the identifier of a mapping from the output of
    /// <a>ListEventSourceMappings</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEventSourceMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_event_source_mapping_input::Builder,
    }
    impl<C, M, R> GetEventSourceMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEventSourceMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEventSourceMappingInputOperationOutputAlias,
                crate::output::GetEventSourceMappingOutput,
                crate::error::GetEventSourceMappingError,
                crate::input::GetEventSourceMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(inp);
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Returns information about the function or function version, with a link to download the deployment package
    /// that's valid for 10 minutes. If you specify a function version, only details that are specific to that version are
    /// returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_input::Builder,
    }
    impl<C, M, R> GetFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionInputOperationOutputAlias,
                crate::output::GetFunctionOutput,
                crate::error::GetFunctionError,
                crate::input::GetFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionCodeSigningConfig`.
    ///
    /// <p>Returns the code signing configuration for the specified function.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_code_signing_config_input::Builder,
    }
    impl<C, M, R> GetFunctionCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionCodeSigningConfigInputOperationOutputAlias,
                crate::output::GetFunctionCodeSigningConfigOutput,
                crate::error::GetFunctionCodeSigningConfigError,
                crate::input::GetFunctionCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionConcurrency`.
    ///
    /// <p>Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
    /// function, use <a>PutFunctionConcurrency</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionConcurrency<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_concurrency_input::Builder,
    }
    impl<C, M, R> GetFunctionConcurrency<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionConcurrencyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionConcurrencyInputOperationOutputAlias,
                crate::output::GetFunctionConcurrencyOutput,
                crate::error::GetFunctionConcurrencyError,
                crate::input::GetFunctionConcurrencyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionConfiguration`.
    ///
    /// <p>Returns the version-specific settings of a Lambda function or version. The output includes only options that
    /// can vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.</p>
    /// <p>To get all of a function's details, including function-level settings, use <a>GetFunction</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_configuration_input::Builder,
    }
    impl<C, M, R> GetFunctionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionConfigurationInputOperationOutputAlias,
                crate::output::GetFunctionConfigurationOutput,
                crate::error::GetFunctionConfigurationError,
                crate::input::GetFunctionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunctionEventInvokeConfig`.
    ///
    /// <p>Retrieves the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunctionEventInvokeConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_event_invoke_config_input::Builder,
    }
    impl<C, M, R> GetFunctionEventInvokeConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionEventInvokeConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionEventInvokeConfigInputOperationOutputAlias,
                crate::output::GetFunctionEventInvokeConfigOutput,
                crate::error::GetFunctionEventInvokeConfigError,
                crate::input::GetFunctionEventInvokeConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersion`.
    ///
    /// <p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>, with a link to download the layer archive
    /// that's valid for 10 minutes.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLayerVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_layer_version_input::Builder,
    }
    impl<C, M, R> GetLayerVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLayerVersionInputOperationOutputAlias,
                crate::output::GetLayerVersionOutput,
                crate::error::GetLayerVersionError,
                crate::input::GetLayerVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersionByArn`.
    ///
    /// <p>Returns information about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>, with a link to download the layer archive
    /// that's valid for 10 minutes.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLayerVersionByArn<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_layer_version_by_arn_input::Builder,
    }
    impl<C, M, R> GetLayerVersionByArn<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLayerVersionByArn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionByArnOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionByArnError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLayerVersionByArnInputOperationOutputAlias,
                crate::output::GetLayerVersionByArnOutput,
                crate::error::GetLayerVersionByArnError,
                crate::input::GetLayerVersionByArnInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the layer version.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLayerVersionPolicy`.
    ///
    /// <p>Returns the permission policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>. For more information, see <a>AddLayerVersionPermission</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLayerVersionPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_layer_version_policy_input::Builder,
    }
    impl<C, M, R> GetLayerVersionPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLayerVersionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLayerVersionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLayerVersionPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLayerVersionPolicyInputOperationOutputAlias,
                crate::output::GetLayerVersionPolicyOutput,
                crate::error::GetLayerVersionPolicyError,
                crate::input::GetLayerVersionPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Returns the <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM policy</a> for a function, version, or alias.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProvisionedConcurrencyConfig`.
    ///
    /// <p>Retrieves the provisioned concurrency configuration for a function's alias or version.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProvisionedConcurrencyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_provisioned_concurrency_config_input::Builder,
    }
    impl<C, M, R> GetProvisionedConcurrencyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProvisionedConcurrencyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProvisionedConcurrencyConfigInputOperationOutputAlias,
                crate::output::GetProvisionedConcurrencyConfigOutput,
                crate::error::GetProvisionedConcurrencyConfigError,
                crate::input::GetProvisionedConcurrencyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Invoke`.
    ///
    /// <p>Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
    /// asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.</p>
    ///
    /// <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
    /// details about the function response, including errors, are included in the response body and headers. For either
    /// invocation type, you can find more information in the <a href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.</p>
    ///
    /// <p>When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type,
    /// client, event source, and invocation type. For example, if you invoke a function asynchronously and it returns an
    /// error, Lambda executes the function up to two more times. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html">Retry Behavior</a>.</p>
    ///
    /// <p>For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
    /// Lambda adds events to a queue before sending them to your function. If your function does not have enough capacity
    /// to keep up with the queue, events may be lost. Occasionally, your function may receive the same event multiple
    /// times, even if no error occurs. To retain events that were not processed, configure your function with a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">dead-letter queue</a>.</p>
    ///
    /// <p>The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
    /// prevent your function from executing, such as permissions errors, <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's code and configuration.
    /// For example, Lambda returns <code>TooManyRequestsException</code> if executing the function would cause you to
    /// exceed a concurrency limit at either the account level (<code>ConcurrentInvocationLimitExceeded</code>) or
    /// function level (<code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).</p>
    ///
    /// <p>For functions with a long timeout, your client might be disconnected during synchronous invocation while it
    /// waits for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
    /// connections with timeout or keep-alive settings.</p>
    ///
    /// <p>This operation requires permission for the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct Invoke<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invoke_input::Builder,
    }
    impl<C, M, R> Invoke<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Invoke`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvokeOutput,
            aws_smithy_http::result::SdkError<crate::error::InvokeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InvokeInputOperationOutputAlias,
                crate::output::InvokeOutput,
                crate::error::InvokeError,
                crate::input::InvokeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until
        /// the function returns a response or times out. The API response includes the function response and additional
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
        /// function's dead-letter queue (if it's configured). The API response only includes a status code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke
        /// the function.</p>
        /// </li>
        /// </ul>
        pub fn invocation_type(mut self, inp: crate::model::InvocationType) -> Self {
            self.inner = self.inner.invocation_type(inp);
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until
        /// the function returns a response or times out. The API response includes the function response and additional
        /// data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
        /// function's dead-letter queue (if it's configured). The API response only includes a status code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke
        /// the function.</p>
        /// </li>
        /// </ul>
        pub fn set_invocation_type(
            mut self,
            input: std::option::Option<crate::model::InvocationType>,
        ) -> Self {
            self.inner = self.inner.set_invocation_type(input);
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn log_type(mut self, inp: crate::model::LogType) -> Self {
            self.inner = self.inner.log_type(inp);
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.inner = self.inner.set_log_type(input);
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context
        /// object.</p>
        pub fn client_context(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_context(inp);
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context
        /// object.</p>
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_context(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>.
        /// You can also specify a file path. For example, <code>--payload file://payload.json</code>.
        /// </p>
        pub fn payload(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.payload(inp);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>.
        /// You can also specify a file path. For example, <code>--payload file://payload.json</code>.
        /// </p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_payload(input);
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InvokeAsync`.
    ///
    /// <important>
    /// <p>For asynchronous function invocation, use <a>Invoke</a>.</p>
    /// </important>
    /// <p>Invokes a function asynchronously.</p>
    #[derive(std::fmt::Debug)]
    pub struct InvokeAsync<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invoke_async_input::Builder,
    }
    impl<C, M, R> InvokeAsync<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InvokeAsync`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvokeAsyncOutput,
            aws_smithy_http::result::SdkError<crate::error::InvokeAsyncError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InvokeAsyncInputOperationOutputAlias,
                crate::output::InvokeAsyncOutput,
                crate::error::InvokeAsyncError,
                crate::input::InvokeAsyncInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn invoke_args(mut self, inp: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.invoke_args(inp);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn set_invoke_args(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_invoke_args(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAliases`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a>
    /// for a Lambda function.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_aliases_input::Builder,
    }
    impl<C, M, R> ListAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAliasesInputOperationOutputAlias,
                crate::output::ListAliasesOutput,
                crate::error::ListAliasesError,
                crate::input::ListAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn function_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCodeSigningConfigs`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
    /// signing configurations</a>. A request returns up to 10,000 configurations per
    /// call. You can use the <code>MaxItems</code> parameter to return fewer configurations per call. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListCodeSigningConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_code_signing_configs_input::Builder,
    }
    impl<C, M, R> ListCodeSigningConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCodeSigningConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCodeSigningConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCodeSigningConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCodeSigningConfigsInputOperationOutputAlias,
                crate::output::ListCodeSigningConfigsOutput,
                crate::error::ListCodeSigningConfigsError,
                crate::input::ListCodeSigningConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSourceMappings`.
    ///
    /// <p>Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
    /// single event source.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEventSourceMappings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_source_mappings_input::Builder,
    }
    impl<C, M, R> ListEventSourceMappings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventSourceMappings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSourceMappingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSourceMappingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventSourceMappingsInputOperationOutputAlias,
                crate::output::ListEventSourceMappingsOutput,
                crate::error::ListEventSourceMappingsError,
                crate::input::ListEventSourceMappingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p>
        /// </li>
        /// </ul>
        pub fn event_source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of
        /// 100 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of
        /// 100 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionEventInvokeConfigs`.
    ///
    /// <p>Retrieves a list of configurations for asynchronous invocation for a function.</p>
    /// <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFunctionEventInvokeConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_function_event_invoke_configs_input::Builder,
    }
    impl<C, M, R> ListFunctionEventInvokeConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctionEventInvokeConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionEventInvokeConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionEventInvokeConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionEventInvokeConfigsInputOperationOutputAlias,
                crate::output::ListFunctionEventInvokeConfigsOutput,
                crate::error::ListFunctionEventInvokeConfigsError,
                crate::input::ListFunctionEventInvokeConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
    /// functions per call.</p>
    /// <p>Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
    /// addition to the unpublished version. </p>
    /// <note>
    /// <p>The <code>ListFunctions</code> action returns a subset of the <a>FunctionConfiguration</a> fields.
    /// To get the additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason, LastUpdateStatusReasonCode)
    /// for a function or version, use <a>GetFunction</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl<C, M, R> ListFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionsInputOperationOutputAlias,
                crate::output::ListFunctionsOutput,
                crate::error::ListFunctionsError,
                crate::input::ListFunctionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters
        /// the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N.
        /// Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn master_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_region(inp);
            self
        }
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters
        /// the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N.
        /// Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn set_master_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_region(input);
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn function_version(mut self, inp: crate::model::FunctionVersion) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<crate::model::FunctionVersion>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response,
        /// even if you set the number higher.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response,
        /// even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctionsByCodeSigningConfig`.
    ///
    /// <p>List the functions that use the specified code signing configuration. You can use this method prior to deleting a
    /// code signing configuration, to verify that no functions are using it.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFunctionsByCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_functions_by_code_signing_config_input::Builder,
    }
    impl<C, M, R> ListFunctionsByCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctionsByCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsByCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsByCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionsByCodeSigningConfigInputOperationOutputAlias,
                crate::output::ListFunctionsByCodeSigningConfigOutput,
                crate::error::ListFunctionsByCodeSigningConfigError,
                crate::input::ListFunctionsByCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLayers`.
    ///
    /// <p>Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda
    /// layers</a> and shows information about the latest version of each. Specify a
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime
    /// identifier</a> to list only layers that indicate that they're compatible with that
    /// runtime. Specify a compatible architecture to include only layers that are compatible with
    /// that  <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLayers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_layers_input::Builder,
    }
    impl<C, M, R> ListLayers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLayers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLayersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLayersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLayersInputOperationOutputAlias,
                crate::output::ListLayersOutput,
                crate::error::ListLayersError,
                crate::input::ListLayersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, inp: crate::model::Runtime) -> Self {
            self.inner = self.inner.compatible_runtime(inp);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtime(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The compatible
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, inp: crate::model::Architecture) -> Self {
            self.inner = self.inner.compatible_architecture(inp);
            self
        }
        /// <p>The compatible
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architecture(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLayerVersions`.
    ///
    /// <p>Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>. Versions that have been deleted aren't listed. Specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
    /// versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
    /// layer versions that are compatible with that architecture.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLayerVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_layer_versions_input::Builder,
    }
    impl<C, M, R> ListLayerVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLayerVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLayerVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLayerVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLayerVersionsInputOperationOutputAlias,
                crate::output::ListLayerVersionsOutput,
                crate::error::ListLayerVersionsError,
                crate::input::ListLayerVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, inp: crate::model::Runtime) -> Self {
            self.inner = self.inner.compatible_runtime(inp);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtime(input);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>The compatible
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, inp: crate::model::Architecture) -> Self {
            self.inner = self.inner.compatible_architecture(inp);
            self
        }
        /// <p>The compatible
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architecture(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProvisionedConcurrencyConfigs`.
    ///
    /// <p>Retrieves a list of provisioned concurrency configurations for a function.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProvisionedConcurrencyConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_provisioned_concurrency_configs_input::Builder,
    }
    impl<C, M, R> ListProvisionedConcurrencyConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProvisionedConcurrencyConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProvisionedConcurrencyConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProvisionedConcurrencyConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProvisionedConcurrencyConfigsInputOperationOutputAlias,
                crate::output::ListProvisionedConcurrencyConfigsOutput,
                crate::error::ListProvisionedConcurrencyConfigsError,
                crate::input::ListProvisionedConcurrencyConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTags`.
    ///
    /// <p>Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can
    /// also view tags with <a>GetFunction</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_input::Builder,
    }
    impl<C, M, R> ListTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsInputOperationOutputAlias,
                crate::output::ListTagsOutput,
                crate::error::ListTagsError,
                crate::input::ListTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN).
        /// Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).
        /// Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVersionsByFunction`.
    ///
    /// <p>Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
    /// with the version-specific configuration of each. Lambda returns up to 50 versions per call.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVersionsByFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_versions_by_function_input::Builder,
    }
    impl<C, M, R> ListVersionsByFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVersionsByFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVersionsByFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVersionsByFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVersionsByFunctionInputOperationOutputAlias,
                crate::output::ListVersionsByFunctionOutput,
                crate::error::ListVersionsByFunctionError,
                crate::input::ListVersionsByFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response,
        /// even if you set the number higher.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response,
        /// even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishLayerVersion`.
    ///
    /// <p>Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a> from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same
    /// layer name, a new version is created.</p>
    /// <p>Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishLayerVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_layer_version_input::Builder,
    }
    impl<C, M, R> PublishLayerVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishLayerVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishLayerVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishLayerVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishLayerVersionInputOperationOutputAlias,
                crate::output::PublishLayerVersionOutput,
                crate::error::PublishLayerVersionError,
                crate::input::PublishLayerVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The function layer archive.</p>
        pub fn content(mut self, inp: crate::model::LayerVersionContentInput) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The function layer archive.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentInput>,
        ) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Appends an item to `CompatibleRuntimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
        /// runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
        pub fn compatible_runtimes(mut self, inp: impl Into<crate::model::Runtime>) -> Self {
            self.inner = self.inner.compatible_runtimes(inp);
            self
        }
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
        /// runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.inner = self.inner.set_compatible_runtimes(input);
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example,
        /// <code>MIT</code>.</p>
        /// </li>
        /// <li>
        /// <p>The URL of a license hosted on the internet. For example,
        /// <code>https://opensource.org/licenses/MIT</code>.</p>
        /// </li>
        /// <li>
        /// <p>The full text of the license.</p>
        /// </li>
        /// </ul>
        pub fn license_info(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_info(inp);
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li>
        /// <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example,
        /// <code>MIT</code>.</p>
        /// </li>
        /// <li>
        /// <p>The URL of a license hosted on the internet. For example,
        /// <code>https://opensource.org/licenses/MIT</code>.</p>
        /// </li>
        /// <li>
        /// <p>The full text of the license.</p>
        /// </li>
        /// </ul>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_info(input);
            self
        }
        /// Appends an item to `CompatibleArchitectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(
            mut self,
            inp: impl Into<crate::model::Architecture>,
        ) -> Self {
            self.inner = self.inner.compatible_architectures(inp);
            self
        }
        /// <p>A list of compatible  
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_compatible_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PublishVersion`.
    ///
    /// <p>Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
    /// current code and configuration of a function. Use versions to create a snapshot of your function code and
    /// configuration that doesn't change.</p>
    ///
    /// <p>Lambda doesn't publish a version if the function's configuration and code haven't changed since the last
    /// version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the
    /// function before publishing a version.</p>
    ///
    /// <p>Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PublishVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::publish_version_input::Builder,
    }
    impl<C, M, R> PublishVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PublishVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PublishVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::PublishVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PublishVersionInputOperationOutputAlias,
                crate::output::PublishVersionOutput,
                crate::error::PublishVersionError,
                crate::input::PublishVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid
        /// publishing a version if the function code has changed since you last updated it. You can get the hash for the
        /// version that you uploaded from the output of <a>UpdateFunctionCode</a>.</p>
        pub fn code_sha256(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_sha256(inp);
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid
        /// publishing a version if the function code has changed since you last updated it. You can get the hash for the
        /// version that you uploaded from the output of <a>UpdateFunctionCode</a>.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_code_sha256(input);
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
        /// publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
        /// publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionCodeSigningConfig`.
    ///
    /// <p>Update the code signing configuration for the function. Changes to the code signing configuration take effect the
    /// next time a user tries to deploy a code package to the function. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutFunctionCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_function_code_signing_config_input::Builder,
    }
    impl<C, M, R> PutFunctionCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFunctionCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFunctionCodeSigningConfigInputOperationOutputAlias,
                crate::output::PutFunctionCodeSigningConfigOutput,
                crate::error::PutFunctionCodeSigningConfigError,
                crate::input::PutFunctionCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionConcurrency`.
    ///
    /// <p>Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
    /// level.</p>
    /// <p>Concurrency settings apply to the function as a whole, including all published versions and the unpublished
    /// version. Reserving concurrency both ensures that your function has capacity to process the specified number of
    /// events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see
    /// the current setting for a function.</p>
    /// <p>Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency
    /// for as many functions as you like, as long as you leave at least 100 simultaneous executions unreserved for
    /// functions that aren't configured with a per-function limit. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFunctionConcurrency<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_function_concurrency_input::Builder,
    }
    impl<C, M, R> PutFunctionConcurrency<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFunctionConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionConcurrencyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFunctionConcurrencyInputOperationOutputAlias,
                crate::output::PutFunctionConcurrencyOutput,
                crate::error::PutFunctionConcurrencyError,
                crate::input::PutFunctionConcurrencyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn reserved_concurrent_executions(mut self, inp: i32) -> Self {
            self.inner = self.inner.reserved_concurrent_executions(inp);
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_reserved_concurrent_executions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFunctionEventInvokeConfig`.
    ///
    /// <p>Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
    /// invocation</a> on a function, version, or alias. If a configuration already exists for a function, version,
    /// or alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
    /// affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.</p>
    /// <p>By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains
    /// events in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
    /// invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
    /// <a>UpdateFunctionConfiguration</a>.</p>
    /// <p>To send an invocation record to a queue, topic, function, or event bus, specify a <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations">destination</a>. You can configure separate destinations for successful invocations (on-success) and events
    /// that fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
    /// dead-letter queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFunctionEventInvokeConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_function_event_invoke_config_input::Builder,
    }
    impl<C, M, R> PutFunctionEventInvokeConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFunctionEventInvokeConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFunctionEventInvokeConfigInputOperationOutputAlias,
                crate::output::PutFunctionEventInvokeConfigOutput,
                crate::error::PutFunctionEventInvokeConfigError,
                crate::input::PutFunctionEventInvokeConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(inp);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_event_age_in_seconds(inp);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_event_age_in_seconds(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, inp: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(inp);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProvisionedConcurrencyConfig`.
    ///
    /// <p>Adds a provisioned concurrency configuration to a function's alias or version.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutProvisionedConcurrencyConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_provisioned_concurrency_config_input::Builder,
    }
    impl<C, M, R> PutProvisionedConcurrencyConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutProvisionedConcurrencyConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProvisionedConcurrencyConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProvisionedConcurrencyConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutProvisionedConcurrencyConfigInputOperationOutputAlias,
                crate::output::PutProvisionedConcurrencyConfigOutput,
                crate::error::PutProvisionedConcurrencyConfigError,
                crate::input::PutProvisionedConcurrencyConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn provisioned_concurrent_executions(mut self, inp: i32) -> Self {
            self.inner = self.inner.provisioned_concurrent_executions(inp);
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn set_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_provisioned_concurrent_executions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveLayerVersionPermission`.
    ///
    /// <p>Removes a statement from the permissions policy for a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
    /// layer</a>. For more information, see
    /// <a>AddLayerVersionPermission</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveLayerVersionPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_layer_version_permission_input::Builder,
    }
    impl<C, M, R> RemoveLayerVersionPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveLayerVersionPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveLayerVersionPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveLayerVersionPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveLayerVersionPermissionInputOperationOutputAlias,
                crate::output::RemoveLayerVersionPermissionOutput,
                crate::error::RemoveLayerVersionPermissionError,
                crate::input::RemoveLayerVersionPermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layer_name(inp);
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_layer_name(input);
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, inp: i64) -> Self {
            self.inner = self.inner.version_number(inp);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_version_number(input);
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p>Revokes function-use permission from an Amazon Web Services service or another account. You can get the ID of the statement
    /// from the output of <a>GetPolicy</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemovePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl<C, M, R> RemovePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemovePermissionInputOperationOutputAlias,
                crate::output::RemovePermissionOutput,
                crate::error::RemovePermissionError,
                crate::input::RemovePermissionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn statement_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(inp);
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of tags to apply to the function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource(inp);
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAlias`.
    ///
    /// <p>Updates the configuration of a Lambda function <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_alias_input::Builder,
    }
    impl<C, M, R> UpdateAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAliasInputOperationOutputAlias,
                crate::output::UpdateAliasOutput,
                crate::error::UpdateAliasError,
                crate::input::UpdateAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing
        /// configuration</a> of the alias.</p>
        pub fn routing_config(mut self, inp: crate::model::AliasRoutingConfiguration) -> Self {
            self.inner = self.inner.routing_config(inp);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing
        /// configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_routing_config(input);
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying
        /// an alias that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying
        /// an alias that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCodeSigningConfig`.
    ///
    /// <p>Update the code signing configuration. Changes to the code signing configuration take effect the next time a
    /// user tries to deploy a code package to the function. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateCodeSigningConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_code_signing_config_input::Builder,
    }
    impl<C, M, R> UpdateCodeSigningConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCodeSigningConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCodeSigningConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCodeSigningConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCodeSigningConfigInputOperationOutputAlias,
                crate::output::UpdateCodeSigningConfigOutput,
                crate::error::UpdateCodeSigningConfigError,
                crate::input::UpdateCodeSigningConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.code_signing_config_arn(inp);
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_config_arn(input);
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, inp: crate::model::AllowedPublishers) -> Self {
            self.inner = self.inner.allowed_publishers(inp);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.inner = self.inner.set_allowed_publishers(input);
            self
        }
        /// <p>The code signing policy.</p>
        pub fn code_signing_policies(mut self, inp: crate::model::CodeSigningPolicies) -> Self {
            self.inner = self.inner.code_signing_policies(inp);
            self
        }
        /// <p>The code signing policy.</p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.inner = self.inner.set_code_signing_policies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEventSourceMapping`.
    ///
    /// <p>Updates an event source mapping. You can change the function that Lambda invokes, or pause
    /// invocation and resume later from the same location.</p>
    /// <p>For details about how to configure different event sources, see the following topics. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping">
    /// Amazon DynamoDB Streams</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
    /// Amazon Kinesis</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource">
    /// Amazon SQS</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping">
    /// Amazon MQ and RabbitMQ</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html">
    /// Amazon MSK</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html">
    /// Apache Kafka</a>
    /// </p>
    /// </li>
    /// </ul>
    ///
    /// <p>The following error handling options are only available for stream sources (DynamoDB and Kinesis):</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ParallelizationFactor</code> - Process multiple batches from each shard concurrently.</p>
    /// </li>
    /// </ul>
    /// <p>For information about which configuration parameters apply to each event source, see the following topics.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params">
    /// Amazon DynamoDB Streams</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params">
    /// Amazon Kinesis</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params">
    /// Amazon SQS</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params">
    /// Amazon MQ and RabbitMQ</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms">
    /// Amazon MSK</a>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms">
    /// Apache Kafka</a>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEventSourceMapping<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_event_source_mapping_input::Builder,
    }
    impl<C, M, R> UpdateEventSourceMapping<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEventSourceMapping`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEventSourceMappingOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEventSourceMappingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEventSourceMappingInputOperationOutputAlias,
                crate::output::UpdateEventSourceMappingOutput,
                crate::error::UpdateEventSourceMappingError,
                crate::input::UpdateEventSourceMappingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uuid(inp);
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uuid(input);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation
        /// (6 MB).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// </ul>
        pub fn batch_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.batch_size(inp);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation
        /// (6 MB).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p>
        /// </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_batch_size(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_batching_window_in_seconds(inp);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_batching_window_in_seconds(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, inp: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(inp);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_record_age_in_seconds(inp);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_maximum_record_age_in_seconds(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, inp: bool) -> Self {
            self.inner = self.inner.bisect_batch_on_function_error(inp);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_bisect_batch_on_function_error(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(inp);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, inp: i32) -> Self {
            self.inner = self.inner.parallelization_factor(inp);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_parallelization_factor(input);
            self
        }
        /// Appends an item to `SourceAccessConfigurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            inp: impl Into<crate::model::SourceAccessConfiguration>,
        ) -> Self {
            self.inner = self.inner.source_access_configurations(inp);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_source_access_configurations(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.tumbling_window_in_seconds(inp);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_tumbling_window_in_seconds(input);
            self
        }
        /// Appends an item to `FunctionResponseTypes`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            inp: impl Into<crate::model::FunctionResponseType>,
        ) -> Self {
            self.inner = self.inner.function_response_types(inp);
            self
        }
        /// <p>(Streams only) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.inner = self.inner.set_function_response_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionCode`.
    ///
    /// <p>Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed
    /// by a trusted publisher. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-trustedcode.html">Configuring code signing</a>.</p>
    ///
    /// <p>The function's code is locked when you publish a version. You can't modify the code of a published version,
    /// only the unpublished version.</p>
    /// <note>
    /// <p>For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
    /// you update the image tag to a new image, Lambda does not automatically update the function.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunctionCode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_code_input::Builder,
    }
    impl<C, M, R> UpdateFunctionCode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunctionCode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionCodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionCodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionCodeInputOperationOutputAlias,
                crate::output::UpdateFunctionCodeOutput,
                crate::error::UpdateFunctionCodeError,
                crate::input::UpdateFunctionCodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn zip_file(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.zip_file(inp);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for
        /// you.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_zip_file(input);
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn s3_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket(inp);
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_bucket(input);
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn s3_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key(inp);
            self
        }
        /// <p>The Amazon S3 key of the deployment package.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_s3_key(input);
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn s3_object_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_object_version(inp);
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn set_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_object_version(input);
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn image_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_uri(inp);
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_uri(input);
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as
        /// calling <a>PublishVersion</a> separately.</p>
        pub fn publish(mut self, inp: bool) -> Self {
            self.inner = self.inner.publish(inp);
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as
        /// calling <a>PublishVersion</a> separately.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publish(input);
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function
        /// code.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function
        /// code.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// function that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// Appends an item to `Architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64).
        /// The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, inp: impl Into<crate::model::Architecture>) -> Self {
            self.inner = self.inner.architectures(inp);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64).
        /// The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.inner = self.inner.set_architectures(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionConfiguration`.
    ///
    /// <p>Modify the version-specific settings of a Lambda function.</p>
    ///
    /// <p>When you update a function, Lambda provisions an instance of the function and its supporting resources. If
    /// your function connects to a VPC, this process can take a minute. During this time, you can't modify the function,
    /// but you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
    /// <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a>
    /// indicate when the update is complete and the function is processing events with the new configuration. For more
    /// information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function
    /// States</a>.</p>
    ///
    /// <p>These settings can vary between versions of a function and are locked when you publish a version. You can't
    /// modify the configuration of a published version, only the unpublished version.</p>
    ///
    /// <p>To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions
    /// to an account or Amazon Web Services service, use <a>AddPermission</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunctionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_configuration_input::Builder,
    }
    impl<C, M, R> UpdateFunctionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunctionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionConfigurationInputOperationOutputAlias,
                crate::output::UpdateFunctionConfigurationOutput,
                crate::error::UpdateFunctionConfigurationError,
                crate::input::UpdateFunctionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
        /// characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. The format includes the
        /// file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information,
        /// see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.handler(inp);
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. The format includes the
        /// file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information,
        /// see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_handler(input);
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The
        /// maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout(inp);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The
        /// maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout(input);
            self
        }
        /// <p>The amount of  <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime.
        /// Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.memory_size(inp);
            self
        }
        /// <p>The amount of  <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime.
        /// Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_memory_size(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC.
        /// When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC.
        /// When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
        /// information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, inp: crate::model::Environment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.</p>
        pub fn runtime(mut self, inp: crate::model::Runtime) -> Self {
            self.inner = self.inner.runtime(inp);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.inner = self.inner.set_runtime(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
        /// when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, inp: crate::model::DeadLetterConfig) -> Self {
            self.inner = self.inner.dead_letter_config(inp);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
        /// when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_config(input);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment
        /// variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment
        /// variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, inp: crate::model::TracingConfig) -> Self {
            self.inner = self.inner.tracing_config(inp);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.inner = self.inner.set_tracing_config(input);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// function that has changed since you last read it.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
        /// function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// Appends an item to `Layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a>
        /// to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.layers(inp);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a>
        /// to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_layers(input);
            self
        }
        /// Appends an item to `FileSystemConfigs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(
            mut self,
            inp: impl Into<crate::model::FileSystemConfig>,
        ) -> Self {
            self.inner = self.inner.file_system_configs(inp);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_configs(input);
            self
        }
        /// <p>
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration
        /// values</a> that override the values in the container image Docker file.</p>
        pub fn image_config(mut self, inp: crate::model::ImageConfig) -> Self {
            self.inner = self.inner.image_config(inp);
            self
        }
        /// <p>
        /// <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration
        /// values</a> that override the values in the container image Docker file.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.inner = self.inner.set_image_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunctionEventInvokeConfig`.
    ///
    /// <p>Updates the configuration for asynchronous invocation for a function, version, or alias.</p>
    /// <p>To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunctionEventInvokeConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_event_invoke_config_input::Builder,
    }
    impl<C, M, R> UpdateFunctionEventInvokeConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunctionEventInvokeConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionEventInvokeConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionEventInvokeConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionEventInvokeConfigInputOperationOutputAlias,
                crate::output::UpdateFunctionEventInvokeConfigOutput,
                crate::error::UpdateFunctionEventInvokeConfigError,
                crate::input::UpdateFunctionEventInvokeConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_name(inp);
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title">
        /// <b>Name formats</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p>
        /// </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN.
        /// If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_name(input);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.qualifier(inp);
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_qualifier(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_retry_attempts(inp);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_retry_attempts(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_event_age_in_seconds(inp);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_event_age_in_seconds(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn destination_config(mut self, inp: crate::model::DestinationConfig) -> Self {
            self.inner = self.inner.destination_config(inp);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title">
        /// <b>Destinations</b>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Queue</b> - The ARN of an SQS queue.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Topic</b> - The ARN of an SNS topic.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p>
        /// </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.inner = self.inner.set_destination_config(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
