// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_layer_version_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddLayerVersionPermissionOutput,
    crate::error::AddLayerVersionPermissionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddLayerVersionPermissionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "PolicyLengthExceededException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::PolicyLengthExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::policy_length_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_policy_length_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "PreconditionFailedException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AddLayerVersionPermissionError {
                meta: generic,
                kind: crate::error::AddLayerVersionPermissionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::AddLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::AddLayerVersionPermissionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_add_layer_version_permission_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AddLayerVersionPermissionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddLayerVersionPermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_layer_version_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddLayerVersionPermissionOutput,
    crate::error::AddLayerVersionPermissionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_layer_version_permission_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_layer_version_permission(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddLayerVersionPermissionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddPermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyLengthExceededException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::PolicyLengthExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_length_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_policy_length_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailedException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AddPermissionError {
                meta: generic,
                kind: crate::error::AddPermissionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::AddPermissionError {
            meta: generic,
            kind: crate::error::AddPermissionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddPermissionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_add_permission_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::AddPermissionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddPermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddPermissionOutput, crate::error::AddPermissionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_permission_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_permission(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddPermissionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateAliasError {
                meta: generic,
                kind: crate::error::CreateAliasErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateAliasError {
            meta: generic,
            kind: crate::error::CreateAliasErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAliasError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_alias_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateAliasError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAliasOutput, crate::error::CreateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCodeSigningConfigOutput,
    crate::error::CreateCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCodeSigningConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CreateCodeSigningConfigError {
            meta: generic,
            kind: crate::error::CreateCodeSigningConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateCodeSigningConfigError {
                meta: generic,
                kind: crate::error::CreateCodeSigningConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCodeSigningConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::CreateCodeSigningConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCodeSigningConfigOutput,
    crate::error::CreateCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_code_signing_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_code_signing_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_source_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSourceMappingOutput,
    crate::error::CreateEventSourceMappingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEventSourceMappingError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CreateEventSourceMappingError {
            meta: generic,
            kind: crate::error::CreateEventSourceMappingErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceConflictException" => crate::error::CreateEventSourceMappingError {
            meta: generic,
            kind: crate::error::CreateEventSourceMappingErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateEventSourceMappingError {
            meta: generic,
            kind: crate::error::CreateEventSourceMappingErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateEventSourceMappingError {
                meta: generic,
                kind: crate::error::CreateEventSourceMappingErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateEventSourceMappingError {
            meta: generic,
            kind: crate::error::CreateEventSourceMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_event_source_mapping_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateEventSourceMappingError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEventSourceMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_source_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSourceMappingOutput,
    crate::error::CreateEventSourceMappingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_event_source_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_event_source_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEventSourceMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeSigningConfigNotFoundException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::CodeSigningConfigNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_signing_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_signing_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CodeStorageExceededException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::CodeStorageExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_storage_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_storage_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CodeVerificationFailedException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::CodeVerificationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_verification_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_verification_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCodeSignatureException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::InvalidCodeSignatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_code_signature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_code_signature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateFunctionError {
                meta: generic,
                kind: crate::error::CreateFunctionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateFunctionError {
            meta: generic,
            kind: crate::error::CreateFunctionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_function_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateFunctionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_function_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_function(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFunctionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_url_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFunctionUrlConfigOutput,
    crate::error::CreateFunctionUrlConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateFunctionUrlConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::CreateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::CreateFunctionUrlConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::CreateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::CreateFunctionUrlConfigErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::CreateFunctionUrlConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateFunctionUrlConfigError {
                meta: generic,
                kind: crate::error::CreateFunctionUrlConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::CreateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::CreateFunctionUrlConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_create_function_url_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::CreateFunctionUrlConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateFunctionUrlConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_function_url_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateFunctionUrlConfigOutput,
    crate::error::CreateFunctionUrlConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_function_url_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_function_url_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateFunctionUrlConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteAliasError {
                meta: generic,
                kind: crate::error::DeleteAliasErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteAliasError {
            meta: generic,
            kind: crate::error::DeleteAliasErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAliasError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_alias_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteAliasError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAliasOutput, crate::error::DeleteAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCodeSigningConfigOutput,
    crate::error::DeleteCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCodeSigningConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteCodeSigningConfigError {
            meta: generic,
            kind: crate::error::DeleteCodeSigningConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::DeleteCodeSigningConfigError {
            meta: generic,
            kind: crate::error::DeleteCodeSigningConfigErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteCodeSigningConfigError {
            meta: generic,
            kind: crate::error::DeleteCodeSigningConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteCodeSigningConfigError {
                meta: generic,
                kind: crate::error::DeleteCodeSigningConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCodeSigningConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteCodeSigningConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCodeSigningConfigOutput,
    crate::error::DeleteCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_code_signing_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_source_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSourceMappingOutput,
    crate::error::DeleteEventSourceMappingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteEventSourceMappingError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteEventSourceMappingError {
            meta: generic,
            kind: crate::error::DeleteEventSourceMappingErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceInUseException" => crate::error::DeleteEventSourceMappingError {
            meta: generic,
            kind: crate::error::DeleteEventSourceMappingErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteEventSourceMappingError {
            meta: generic,
            kind: crate::error::DeleteEventSourceMappingErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteEventSourceMappingError {
                meta: generic,
                kind: crate::error::DeleteEventSourceMappingErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteEventSourceMappingError {
            meta: generic,
            kind: crate::error::DeleteEventSourceMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_event_source_mapping_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteEventSourceMappingError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEventSourceMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_source_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSourceMappingOutput,
    crate::error::DeleteEventSourceMappingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_event_source_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_event_source_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEventSourceMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteFunctionError {
                meta: generic,
                kind: crate::error::DeleteFunctionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteFunctionError {
            meta: generic,
            kind: crate::error::DeleteFunctionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_function_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteFunctionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_function_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionCodeSigningConfigOutput,
    crate::error::DeleteFunctionCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeSigningConfigNotFoundException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_signing_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_signing_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValueException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DeleteFunctionCodeSigningConfigError { meta: generic, kind: crate::error::DeleteFunctionCodeSigningConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionCodeSigningConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_function_code_signing_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteFunctionCodeSigningConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteFunctionCodeSigningConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionCodeSigningConfigOutput,
    crate::error::DeleteFunctionCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_function_code_signing_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_concurrency_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionConcurrencyOutput,
    crate::error::DeleteFunctionConcurrencyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteFunctionConcurrencyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::DeleteFunctionConcurrencyErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceConflictException" => crate::error::DeleteFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::DeleteFunctionConcurrencyErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::DeleteFunctionConcurrencyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteFunctionConcurrencyError {
                meta: generic,
                kind: crate::error::DeleteFunctionConcurrencyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::DeleteFunctionConcurrencyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionConcurrencyError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_function_concurrency_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteFunctionConcurrencyError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFunctionConcurrencyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_concurrency_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionConcurrencyOutput,
    crate::error::DeleteFunctionConcurrencyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_function_concurrency_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_event_invoke_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionEventInvokeConfigOutput,
    crate::error::DeleteFunctionEventInvokeConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteFunctionEventInvokeConfigError { meta: generic, kind: crate::error::DeleteFunctionEventInvokeConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::DeleteFunctionEventInvokeConfigError { meta: generic, kind: crate::error::DeleteFunctionEventInvokeConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DeleteFunctionEventInvokeConfigError { meta: generic, kind: crate::error::DeleteFunctionEventInvokeConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeleteFunctionEventInvokeConfigError { meta: generic, kind: crate::error::DeleteFunctionEventInvokeConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DeleteFunctionEventInvokeConfigError { meta: generic, kind: crate::error::DeleteFunctionEventInvokeConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionEventInvokeConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_function_event_invoke_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteFunctionEventInvokeConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteFunctionEventInvokeConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_event_invoke_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionEventInvokeConfigOutput,
    crate::error::DeleteFunctionEventInvokeConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_function_event_invoke_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_url_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionUrlConfigOutput,
    crate::error::DeleteFunctionUrlConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteFunctionUrlConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteFunctionUrlConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceConflictException" => crate::error::DeleteFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::DeleteFunctionUrlConfigErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::DeleteFunctionUrlConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteFunctionUrlConfigError {
                meta: generic,
                kind: crate::error::DeleteFunctionUrlConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionUrlConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::DeleteFunctionUrlConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteFunctionUrlConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_function_url_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteFunctionUrlConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteFunctionUrlConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_function_url_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteFunctionUrlConfigOutput,
    crate::error::DeleteFunctionUrlConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_function_url_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_layer_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLayerVersionOutput,
    crate::error::DeleteLayerVersionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLayerVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLayerVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceException" => {
            crate::error::DeleteLayerVersionError {
                meta: generic,
                kind: crate::error::DeleteLayerVersionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLayerVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::DeleteLayerVersionError {
            meta: generic,
            kind: crate::error::DeleteLayerVersionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLayerVersionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_layer_version_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteLayerVersionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLayerVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_layer_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLayerVersionOutput,
    crate::error::DeleteLayerVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_layer_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioned_concurrency_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisionedConcurrencyConfigOutput,
    crate::error::DeleteProvisionedConcurrencyConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::DeleteProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::DeleteProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::DeleteProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::DeleteProvisionedConcurrencyConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::DeleteProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::DeleteProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeleteProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::DeleteProvisionedConcurrencyConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::DeleteProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::DeleteProvisionedConcurrencyConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteProvisionedConcurrencyConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_delete_provisioned_concurrency_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::DeleteProvisionedConcurrencyConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteProvisionedConcurrencyConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_provisioned_concurrency_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteProvisionedConcurrencyConfigOutput,
    crate::error::DeleteProvisionedConcurrencyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_provisioned_concurrency_config_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_settings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountSettingsOutput,
    crate::error::GetAccountSettingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountSettingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAccountSettingsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceException" => {
            crate::error::GetAccountSettingsError {
                meta: generic,
                kind: crate::error::GetAccountSettingsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAccountSettingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetAccountSettingsError {
            meta: generic,
            kind: crate::error::GetAccountSettingsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAccountSettingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_account_settings_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetAccountSettingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccountSettingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_settings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountSettingsOutput,
    crate::error::GetAccountSettingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_account_settings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_account_settings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccountSettingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAliasOutput, crate::error::GetAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetAliasError {
            meta: generic,
            kind: crate::error::GetAliasErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetAliasError {
            meta: generic,
            kind: crate::error::GetAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetAliasError {
                meta: generic,
                kind: crate::error::GetAliasErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetAliasError {
            meta: generic,
            kind: crate::error::GetAliasErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAliasError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_alias_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetAliasError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAliasOutput, crate::error::GetAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCodeSigningConfigOutput,
    crate::error::GetCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCodeSigningConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetCodeSigningConfigError {
            meta: generic,
            kind: crate::error::GetCodeSigningConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetCodeSigningConfigError {
            meta: generic,
            kind: crate::error::GetCodeSigningConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetCodeSigningConfigError {
                meta: generic,
                kind: crate::error::GetCodeSigningConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCodeSigningConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetCodeSigningConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCodeSigningConfigOutput,
    crate::error::GetCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_code_signing_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_code_signing_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_source_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetEventSourceMappingOutput,
    crate::error::GetEventSourceMappingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetEventSourceMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetEventSourceMappingError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetEventSourceMappingError {
            meta: generic,
            kind: crate::error::GetEventSourceMappingErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetEventSourceMappingError {
            meta: generic,
            kind: crate::error::GetEventSourceMappingErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetEventSourceMappingError {
                meta: generic,
                kind: crate::error::GetEventSourceMappingErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetEventSourceMappingError {
            meta: generic,
            kind: crate::error::GetEventSourceMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEventSourceMappingError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_event_source_mapping_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetEventSourceMappingError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetEventSourceMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_event_source_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetEventSourceMappingOutput,
    crate::error::GetEventSourceMappingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_event_source_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_event_source_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetEventSourceMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFunctionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionError {
            meta: generic,
            kind: crate::error::GetFunctionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionError {
            meta: generic,
            kind: crate::error::GetFunctionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionError {
                meta: generic,
                kind: crate::error::GetFunctionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionError {
            meta: generic,
            kind: crate::error::GetFunctionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_function(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFunctionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionCodeSigningConfigOutput,
    crate::error::GetFunctionCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFunctionCodeSigningConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionCodeSigningConfigError {
            meta: generic,
            kind:
                crate::error::GetFunctionCodeSigningConfigErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionCodeSigningConfigError {
            meta: generic,
            kind: crate::error::GetFunctionCodeSigningConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionCodeSigningConfigError {
                meta: generic,
                kind: crate::error::GetFunctionCodeSigningConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionCodeSigningConfigError {
            meta: generic,
            kind: crate::error::GetFunctionCodeSigningConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_code_signing_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionCodeSigningConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionCodeSigningConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionCodeSigningConfigOutput,
    crate::error::GetFunctionCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_code_signing_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_function_code_signing_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetFunctionCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_concurrency_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionConcurrencyOutput,
    crate::error::GetFunctionConcurrencyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFunctionConcurrencyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::GetFunctionConcurrencyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::GetFunctionConcurrencyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionConcurrencyError {
                meta: generic,
                kind: crate::error::GetFunctionConcurrencyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::GetFunctionConcurrencyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_concurrency_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionConcurrencyError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionConcurrencyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_concurrency_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionConcurrencyOutput,
    crate::error::GetFunctionConcurrencyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_concurrency_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_function_concurrency(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFunctionConcurrencyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionConfigurationOutput,
    crate::error::GetFunctionConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFunctionConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionConfigurationError {
            meta: generic,
            kind: crate::error::GetFunctionConfigurationErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionConfigurationError {
            meta: generic,
            kind: crate::error::GetFunctionConfigurationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionConfigurationError {
                meta: generic,
                kind: crate::error::GetFunctionConfigurationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionConfigurationError {
            meta: generic,
            kind: crate::error::GetFunctionConfigurationErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_configuration_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionConfigurationError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionConfigurationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionConfigurationOutput,
    crate::error::GetFunctionConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_function_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFunctionConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_event_invoke_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionEventInvokeConfigOutput,
    crate::error::GetFunctionEventInvokeConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetFunctionEventInvokeConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionEventInvokeConfigError {
            meta: generic,
            kind:
                crate::error::GetFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionEventInvokeConfigError {
            meta: generic,
            kind: crate::error::GetFunctionEventInvokeConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionEventInvokeConfigError {
                meta: generic,
                kind: crate::error::GetFunctionEventInvokeConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionEventInvokeConfigError {
            meta: generic,
            kind: crate::error::GetFunctionEventInvokeConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_event_invoke_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionEventInvokeConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionEventInvokeConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_event_invoke_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionEventInvokeConfigOutput,
    crate::error::GetFunctionEventInvokeConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_event_invoke_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_function_event_invoke_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetFunctionEventInvokeConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_url_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionUrlConfigOutput,
    crate::error::GetFunctionUrlConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetFunctionUrlConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::GetFunctionUrlConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::GetFunctionUrlConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetFunctionUrlConfigError {
                meta: generic,
                kind: crate::error::GetFunctionUrlConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::GetFunctionUrlConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_function_url_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetFunctionUrlConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetFunctionUrlConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_function_url_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetFunctionUrlConfigOutput,
    crate::error::GetFunctionUrlConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_function_url_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_function_url_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetFunctionUrlConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLayerVersionOutput, crate::error::GetLayerVersionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLayerVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLayerVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetLayerVersionError {
            meta: generic,
            kind: crate::error::GetLayerVersionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetLayerVersionError {
            meta: generic,
            kind: crate::error::GetLayerVersionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLayerVersionError {
                meta: generic,
                kind: crate::error::GetLayerVersionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetLayerVersionError {
            meta: generic,
            kind: crate::error::GetLayerVersionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_layer_version_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetLayerVersionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLayerVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLayerVersionOutput, crate::error::GetLayerVersionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_layer_version_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_layer_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLayerVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_by_arn_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLayerVersionByArnOutput,
    crate::error::GetLayerVersionByArnError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLayerVersionByArnError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetLayerVersionByArnError {
            meta: generic,
            kind: crate::error::GetLayerVersionByArnErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetLayerVersionByArnError {
            meta: generic,
            kind: crate::error::GetLayerVersionByArnErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLayerVersionByArnError {
                meta: generic,
                kind: crate::error::GetLayerVersionByArnErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetLayerVersionByArnError {
            meta: generic,
            kind: crate::error::GetLayerVersionByArnErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_layer_version_by_arn_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetLayerVersionByArnError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLayerVersionByArnError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_by_arn_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLayerVersionByArnOutput,
    crate::error::GetLayerVersionByArnError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_layer_version_by_arn_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_layer_version_by_arn(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLayerVersionByArnError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLayerVersionPolicyOutput,
    crate::error::GetLayerVersionPolicyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLayerVersionPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetLayerVersionPolicyError {
            meta: generic,
            kind: crate::error::GetLayerVersionPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetLayerVersionPolicyError {
            meta: generic,
            kind: crate::error::GetLayerVersionPolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLayerVersionPolicyError {
                meta: generic,
                kind: crate::error::GetLayerVersionPolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetLayerVersionPolicyError {
            meta: generic,
            kind: crate::error::GetLayerVersionPolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_layer_version_policy_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetLayerVersionPolicyError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLayerVersionPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_layer_version_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLayerVersionPolicyOutput,
    crate::error::GetLayerVersionPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_layer_version_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_layer_version_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLayerVersionPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetPolicyError {
                meta: generic,
                kind: crate::error::GetPolicyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_policy_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetPolicyError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_policy_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_provisioned_concurrency_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetProvisionedConcurrencyConfigOutput,
    crate::error::GetProvisionedConcurrencyConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetProvisionedConcurrencyConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::GetProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::GetProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ProvisionedConcurrencyConfigNotFoundException" => crate::error::GetProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::GetProvisionedConcurrencyConfigErrorKind::ProvisionedConcurrencyConfigNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::provisioned_concurrency_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_provisioned_concurrency_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::GetProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::GetProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::GetProvisionedConcurrencyConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::GetProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::GetProvisionedConcurrencyConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_get_provisioned_concurrency_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::GetProvisionedConcurrencyConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetProvisionedConcurrencyConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_provisioned_concurrency_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetProvisionedConcurrencyConfigOutput,
    crate::error::GetProvisionedConcurrencyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_provisioned_concurrency_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_provisioned_concurrency_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetProvisionedConcurrencyConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invoke_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InvokeOutput, crate::error::InvokeError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InvokeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InvokeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EC2AccessDeniedException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::Ec2AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EC2ThrottledException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::Ec2ThrottledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_throttled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_throttled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EC2UnexpectedException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::Ec2UnexpectedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::ec2_unexpected_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_ec2_unexpected_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EFSIOException" => {
            crate::error::InvokeError {
                meta: generic,
                kind: crate::error::InvokeErrorKind::EfsioException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::efsio_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_efsio_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "EFSMountConnectivityException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::EfsMountConnectivityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::efs_mount_connectivity_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_efs_mount_connectivity_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EFSMountFailureException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::EfsMountFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::efs_mount_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_efs_mount_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EFSMountTimeoutException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::EfsMountTimeoutException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::efs_mount_timeout_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_efs_mount_timeout_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ENILimitReachedException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::EniLimitReachedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::eni_limit_reached_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_eni_limit_reached_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRequestContentException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidRequestContentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_request_content_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_content_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRuntimeException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidRuntimeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_runtime_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_runtime_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSecurityGroupIDException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidSecurityGroupIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_security_group_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_security_group_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnetIDException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidSubnetIdException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet_id_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_subnet_id_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidZipFileException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::InvalidZipFileException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_zip_file_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_zip_file_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSAccessDeniedException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::KmsAccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSDisabledException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::KmsDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_disabled_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_disabled_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSInvalidStateException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::KmsInvalidStateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_invalid_state_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_invalid_state_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSNotFoundException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::KmsNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_kms_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestTooLargeException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::RequestTooLargeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_too_large_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_too_large_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotReadyException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::ResourceNotReadyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_ready_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_ready_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::InvokeError {
                meta: generic,
                kind: crate::error::InvokeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "SubnetIPAddressLimitReachedException" => {
            crate::error::InvokeError {
                meta: generic,
                kind: crate::error::InvokeErrorKind::SubnetIpAddressLimitReachedException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::subnet_ip_address_limit_reached_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_subnet_ip_address_limit_reached_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_invoke_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::InvokeError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnsupportedMediaTypeException" => crate::error::InvokeError {
            meta: generic,
            kind: crate::error::InvokeErrorKind::UnsupportedMediaTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unsupported_media_type_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unsupported_media_type_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::InvokeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invoke_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InvokeOutput, crate::error::InvokeError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::invoke_output::Builder::default();
        let _ = response;
        output = output.set_executed_version(
            crate::http_serde::deser_header_invoke_invoke_output_executed_version(
                response.headers(),
            )
            .map_err(|_| {
                crate::error::InvokeError::unhandled(
                    "Failed to parse ExecutedVersion from header `X-Amz-Executed-Version",
                )
            })?,
        );
        output = output.set_function_error(
            crate::http_serde::deser_header_invoke_invoke_output_function_error(response.headers())
                .map_err(|_| {
                    crate::error::InvokeError::unhandled(
                        "Failed to parse FunctionError from header `X-Amz-Function-Error",
                    )
                })?,
        );
        output = output.set_log_result(
            crate::http_serde::deser_header_invoke_invoke_output_log_result(response.headers())
                .map_err(|_| {
                    crate::error::InvokeError::unhandled(
                        "Failed to parse LogResult from header `X-Amz-Log-Result",
                    )
                })?,
        );
        output = output.set_payload(
            crate::http_serde::deser_payload_invoke_invoke_output_payload(
                response.body().as_ref(),
            )?,
        );
        output = output.set_status_code(Some(response.status().as_u16() as _));
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invoke_async_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InvokeAsyncOutput, crate::error::InvokeAsyncError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::InvokeAsyncError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::InvokeAsyncError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidRequestContentException" => crate::error::InvokeAsyncError {
            meta: generic,
            kind: crate::error::InvokeAsyncErrorKind::InvalidRequestContentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_request_content_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_request_content_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeAsyncError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidRuntimeException" => crate::error::InvokeAsyncError {
            meta: generic,
            kind: crate::error::InvokeAsyncErrorKind::InvalidRuntimeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_runtime_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_runtime_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeAsyncError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::InvokeAsyncError {
            meta: generic,
            kind: crate::error::InvokeAsyncErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeAsyncError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::InvokeAsyncError {
            meta: generic,
            kind: crate::error::InvokeAsyncErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeAsyncError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::InvokeAsyncError {
                meta: generic,
                kind: crate::error::InvokeAsyncErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::InvokeAsyncError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::InvokeAsyncError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_invoke_async_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::InvokeAsyncOutput, crate::error::InvokeAsyncError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::invoke_async_output::Builder::default();
        let _ = response;
        output = output.set_status(Some(response.status().as_u16() as _));
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAliasesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListAliasesError {
                meta: generic,
                kind: crate::error::ListAliasesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListAliasesError {
            meta: generic,
            kind: crate::error::ListAliasesErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListAliasesError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_aliases_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListAliasesError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAliasesOutput, crate::error::ListAliasesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_aliases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_code_signing_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCodeSigningConfigsOutput,
    crate::error::ListCodeSigningConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCodeSigningConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCodeSigningConfigsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListCodeSigningConfigsError {
            meta: generic,
            kind: crate::error::ListCodeSigningConfigsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCodeSigningConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListCodeSigningConfigsError {
                meta: generic,
                kind: crate::error::ListCodeSigningConfigsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCodeSigningConfigsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::ListCodeSigningConfigsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_code_signing_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCodeSigningConfigsOutput,
    crate::error::ListCodeSigningConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_code_signing_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_code_signing_configs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCodeSigningConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_event_source_mappings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventSourceMappingsOutput,
    crate::error::ListEventSourceMappingsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListEventSourceMappingsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListEventSourceMappingsError {
            meta: generic,
            kind: crate::error::ListEventSourceMappingsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListEventSourceMappingsError {
            meta: generic,
            kind: crate::error::ListEventSourceMappingsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListEventSourceMappingsError {
                meta: generic,
                kind: crate::error::ListEventSourceMappingsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListEventSourceMappingsError {
            meta: generic,
            kind: crate::error::ListEventSourceMappingsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_event_source_mappings_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListEventSourceMappingsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEventSourceMappingsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_event_source_mappings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEventSourceMappingsOutput,
    crate::error::ListEventSourceMappingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_event_source_mappings_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_event_source_mappings(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEventSourceMappingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_function_event_invoke_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionEventInvokeConfigsOutput,
    crate::error::ListFunctionEventInvokeConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListFunctionEventInvokeConfigsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListFunctionEventInvokeConfigsError { meta: generic, kind: crate::error::ListFunctionEventInvokeConfigsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListFunctionEventInvokeConfigsError { meta: generic, kind: crate::error::ListFunctionEventInvokeConfigsErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListFunctionEventInvokeConfigsError { meta: generic, kind: crate::error::ListFunctionEventInvokeConfigsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListFunctionEventInvokeConfigsError { meta: generic, kind: crate::error::ListFunctionEventInvokeConfigsErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_function_event_invoke_configs_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListFunctionEventInvokeConfigsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListFunctionEventInvokeConfigsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_function_event_invoke_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionEventInvokeConfigsOutput,
    crate::error::ListFunctionEventInvokeConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_function_event_invoke_configs_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_list_function_event_invoke_configs(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListFunctionEventInvokeConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFunctionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListFunctionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListFunctionsError {
            meta: generic,
            kind: crate::error::ListFunctionsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListFunctionsError {
                meta: generic,
                kind: crate::error::ListFunctionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListFunctionsError {
            meta: generic,
            kind: crate::error::ListFunctionsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_functions_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListFunctionsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFunctionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_functions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_functions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFunctionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_by_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionsByCodeSigningConfigOutput,
    crate::error::ListFunctionsByCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListFunctionsByCodeSigningConfigError { meta: generic, kind: crate::error::ListFunctionsByCodeSigningConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListFunctionsByCodeSigningConfigError { meta: generic, kind: crate::error::ListFunctionsByCodeSigningConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListFunctionsByCodeSigningConfigError { meta: generic, kind: crate::error::ListFunctionsByCodeSigningConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListFunctionsByCodeSigningConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_functions_by_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionsByCodeSigningConfigOutput,
    crate::error::ListFunctionsByCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_functions_by_code_signing_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_functions_by_code_signing_config(response.body().as_ref(), output).map_err(crate::error::ListFunctionsByCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_function_url_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionUrlConfigsOutput,
    crate::error::ListFunctionUrlConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListFunctionUrlConfigsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListFunctionUrlConfigsError {
            meta: generic,
            kind: crate::error::ListFunctionUrlConfigsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListFunctionUrlConfigsError {
            meta: generic,
            kind: crate::error::ListFunctionUrlConfigsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListFunctionUrlConfigsError {
                meta: generic,
                kind: crate::error::ListFunctionUrlConfigsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListFunctionUrlConfigsError {
            meta: generic,
            kind: crate::error::ListFunctionUrlConfigsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_function_url_configs_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListFunctionUrlConfigsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListFunctionUrlConfigsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_function_url_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListFunctionUrlConfigsOutput,
    crate::error::ListFunctionUrlConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_function_url_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_function_url_configs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListFunctionUrlConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_layers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLayersOutput, crate::error::ListLayersError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLayersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLayersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListLayersError {
            meta: generic,
            kind: crate::error::ListLayersErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListLayersError {
                meta: generic,
                kind: crate::error::ListLayersErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListLayersError {
            meta: generic,
            kind: crate::error::ListLayersErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayersError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_layers_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListLayersError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLayersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_layers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLayersOutput, crate::error::ListLayersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_layers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_layers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLayersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_layer_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLayerVersionsOutput, crate::error::ListLayerVersionsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListLayerVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListLayerVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListLayerVersionsError {
            meta: generic,
            kind: crate::error::ListLayerVersionsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayerVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListLayerVersionsError {
            meta: generic,
            kind: crate::error::ListLayerVersionsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayerVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListLayerVersionsError {
                meta: generic,
                kind: crate::error::ListLayerVersionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayerVersionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListLayerVersionsError {
            meta: generic,
            kind: crate::error::ListLayerVersionsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListLayerVersionsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_layer_versions_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListLayerVersionsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListLayerVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_layer_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListLayerVersionsOutput, crate::error::ListLayerVersionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_layer_versions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_layer_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListLayerVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_concurrency_configs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedConcurrencyConfigsOutput,
    crate::error::ListProvisionedConcurrencyConfigsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListProvisionedConcurrencyConfigsError { meta: generic, kind: crate::error::ListProvisionedConcurrencyConfigsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::ListProvisionedConcurrencyConfigsError { meta: generic, kind: crate::error::ListProvisionedConcurrencyConfigsErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::ListProvisionedConcurrencyConfigsError { meta: generic, kind: crate::error::ListProvisionedConcurrencyConfigsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::ListProvisionedConcurrencyConfigsError { meta: generic, kind: crate::error::ListProvisionedConcurrencyConfigsErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_provisioned_concurrency_configs_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListProvisionedConcurrencyConfigsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ListProvisionedConcurrencyConfigsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_provisioned_concurrency_configs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListProvisionedConcurrencyConfigsOutput,
    crate::error::ListProvisionedConcurrencyConfigsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_provisioned_concurrency_configs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_provisioned_concurrency_configs(response.body().as_ref(), output).map_err(crate::error::ListProvisionedConcurrencyConfigsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListTagsError {
                meta: generic,
                kind: crate::error::ListTagsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListTagsError {
            meta: generic,
            kind: crate::error::ListTagsErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_tags_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListTagsError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListTagsOutput, crate::error::ListTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_versions_by_function_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVersionsByFunctionOutput,
    crate::error::ListVersionsByFunctionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListVersionsByFunctionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::ListVersionsByFunctionError {
            meta: generic,
            kind: crate::error::ListVersionsByFunctionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListVersionsByFunctionError {
            meta: generic,
            kind: crate::error::ListVersionsByFunctionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ListVersionsByFunctionError {
                meta: generic,
                kind: crate::error::ListVersionsByFunctionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::ListVersionsByFunctionError {
            meta: generic,
            kind: crate::error::ListVersionsByFunctionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_list_versions_by_function_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::ListVersionsByFunctionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListVersionsByFunctionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_versions_by_function_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVersionsByFunctionOutput,
    crate::error::ListVersionsByFunctionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_versions_by_function_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_versions_by_function(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVersionsByFunctionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_layer_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PublishLayerVersionOutput,
    crate::error::PublishLayerVersionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishLayerVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishLayerVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeStorageExceededException" => crate::error::PublishLayerVersionError {
            meta: generic,
            kind: crate::error::PublishLayerVersionErrorKind::CodeStorageExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_storage_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_storage_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishLayerVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::PublishLayerVersionError {
            meta: generic,
            kind: crate::error::PublishLayerVersionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishLayerVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PublishLayerVersionError {
            meta: generic,
            kind: crate::error::PublishLayerVersionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishLayerVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PublishLayerVersionError {
                meta: generic,
                kind: crate::error::PublishLayerVersionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishLayerVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::PublishLayerVersionError {
            meta: generic,
            kind: crate::error::PublishLayerVersionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishLayerVersionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_publish_layer_version_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PublishLayerVersionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PublishLayerVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_layer_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PublishLayerVersionOutput,
    crate::error::PublishLayerVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_layer_version_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_publish_layer_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PublishLayerVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishVersionOutput, crate::error::PublishVersionError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PublishVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PublishVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeStorageExceededException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::CodeStorageExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_storage_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_storage_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailedException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PublishVersionError {
                meta: generic,
                kind: crate::error::PublishVersionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::PublishVersionError {
            meta: generic,
            kind: crate::error::PublishVersionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PublishVersionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_publish_version_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PublishVersionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PublishVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_publish_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PublishVersionOutput, crate::error::PublishVersionError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::publish_version_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_publish_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PublishVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionCodeSigningConfigOutput,
    crate::error::PutFunctionCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutFunctionCodeSigningConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeSigningConfigNotFoundException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::CodeSigningConfigNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_signing_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_signing_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValueException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::PutFunctionCodeSigningConfigError { meta: generic, kind: crate::error::PutFunctionCodeSigningConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_put_function_code_signing_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PutFunctionCodeSigningConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutFunctionCodeSigningConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionCodeSigningConfigOutput,
    crate::error::PutFunctionCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_function_code_signing_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_function_code_signing_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutFunctionCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_concurrency_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionConcurrencyOutput,
    crate::error::PutFunctionConcurrencyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutFunctionConcurrencyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::PutFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::PutFunctionConcurrencyErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::PutFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::PutFunctionConcurrencyErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::PutFunctionConcurrencyErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PutFunctionConcurrencyError {
                meta: generic,
                kind: crate::error::PutFunctionConcurrencyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::PutFunctionConcurrencyError {
            meta: generic,
            kind: crate::error::PutFunctionConcurrencyErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_put_function_concurrency_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PutFunctionConcurrencyError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutFunctionConcurrencyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_concurrency_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionConcurrencyOutput,
    crate::error::PutFunctionConcurrencyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_function_concurrency_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_function_concurrency(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutFunctionConcurrencyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_event_invoke_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionEventInvokeConfigOutput,
    crate::error::PutFunctionEventInvokeConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutFunctionEventInvokeConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::PutFunctionEventInvokeConfigError {
            meta: generic,
            kind:
                crate::error::PutFunctionEventInvokeConfigErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ResourceConflictException" => crate::error::PutFunctionEventInvokeConfigError {
            meta: generic,
            kind: crate::error::PutFunctionEventInvokeConfigErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PutFunctionEventInvokeConfigError {
            meta: generic,
            kind: crate::error::PutFunctionEventInvokeConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PutFunctionEventInvokeConfigError {
                meta: generic,
                kind: crate::error::PutFunctionEventInvokeConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::PutFunctionEventInvokeConfigError {
            meta: generic,
            kind: crate::error::PutFunctionEventInvokeConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_put_function_event_invoke_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PutFunctionEventInvokeConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutFunctionEventInvokeConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_function_event_invoke_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutFunctionEventInvokeConfigOutput,
    crate::error::PutFunctionEventInvokeConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_function_event_invoke_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_function_event_invoke_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutFunctionEventInvokeConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_provisioned_concurrency_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutProvisionedConcurrencyConfigOutput,
    crate::error::PutProvisionedConcurrencyConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutProvisionedConcurrencyConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::PutProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::PutProvisionedConcurrencyConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::PutProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::PutProvisionedConcurrencyConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::PutProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::PutProvisionedConcurrencyConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::PutProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::PutProvisionedConcurrencyConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::PutProvisionedConcurrencyConfigError { meta: generic, kind: crate::error::PutProvisionedConcurrencyConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_put_provisioned_concurrency_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::PutProvisionedConcurrencyConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PutProvisionedConcurrencyConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_provisioned_concurrency_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutProvisionedConcurrencyConfigOutput,
    crate::error::PutProvisionedConcurrencyConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::put_provisioned_concurrency_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_put_provisioned_concurrency_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::PutProvisionedConcurrencyConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_layer_version_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveLayerVersionPermissionOutput,
    crate::error::RemoveLayerVersionPermissionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveLayerVersionPermissionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::RemoveLayerVersionPermissionError {
            meta: generic,
            kind:
                crate::error::RemoveLayerVersionPermissionErrorKind::InvalidParameterValueException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_parameter_value_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "PreconditionFailedException" => crate::error::RemoveLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::RemoveLayerVersionPermissionErrorKind::PreconditionFailedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::precondition_failed_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::RemoveLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::RemoveLayerVersionPermissionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RemoveLayerVersionPermissionError {
                meta: generic,
                kind: crate::error::RemoveLayerVersionPermissionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::RemoveLayerVersionPermissionError {
            meta: generic,
            kind: crate::error::RemoveLayerVersionPermissionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemoveLayerVersionPermissionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_remove_layer_version_permission_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::RemoveLayerVersionPermissionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveLayerVersionPermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_layer_version_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveLayerVersionPermissionOutput,
    crate::error::RemoveLayerVersionPermissionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_layer_version_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemovePermissionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemovePermissionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailedException" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RemovePermissionError {
                meta: generic,
                kind: crate::error::RemovePermissionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::RemovePermissionError {
            meta: generic,
            kind: crate::error::RemovePermissionErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RemovePermissionError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_remove_permission_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::RemovePermissionError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemovePermissionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_permission_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RemovePermissionOutput, crate::error::RemovePermissionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_permission_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_tag_resource_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::TagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UntagResourceError {
                meta: generic,
                kind: crate::error::UntagResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_untag_resource_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UntagResourceError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailedException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateAliasError {
                meta: generic,
                kind: crate::error::UpdateAliasErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateAliasError {
            meta: generic,
            kind: crate::error::UpdateAliasErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAliasError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_alias_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateAliasError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAliasOutput, crate::error::UpdateAliasError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_alias_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_alias(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAliasError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_code_signing_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCodeSigningConfigOutput,
    crate::error::UpdateCodeSigningConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCodeSigningConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateCodeSigningConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UpdateCodeSigningConfigError {
            meta: generic,
            kind: crate::error::UpdateCodeSigningConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateCodeSigningConfigError {
            meta: generic,
            kind: crate::error::UpdateCodeSigningConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCodeSigningConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateCodeSigningConfigError {
                meta: generic,
                kind: crate::error::UpdateCodeSigningConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCodeSigningConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::UpdateCodeSigningConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_code_signing_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCodeSigningConfigOutput,
    crate::error::UpdateCodeSigningConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_code_signing_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_code_signing_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateCodeSigningConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_event_source_mapping_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEventSourceMappingOutput,
    crate::error::UpdateEventSourceMappingError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateEventSourceMappingError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UpdateEventSourceMappingError {
            meta: generic,
            kind: crate::error::UpdateEventSourceMappingErrorKind::InvalidParameterValueException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_parameter_value_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceConflictException" => crate::error::UpdateEventSourceMappingError {
            meta: generic,
            kind: crate::error::UpdateEventSourceMappingErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceInUseException" => crate::error::UpdateEventSourceMappingError {
            meta: generic,
            kind: crate::error::UpdateEventSourceMappingErrorKind::ResourceInUseException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_in_use_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_in_use_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateEventSourceMappingError {
            meta: generic,
            kind: crate::error::UpdateEventSourceMappingErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateEventSourceMappingError {
                meta: generic,
                kind: crate::error::UpdateEventSourceMappingErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateEventSourceMappingError {
            meta: generic,
            kind: crate::error::UpdateEventSourceMappingErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_event_source_mapping_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateEventSourceMappingError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEventSourceMappingError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_event_source_mapping_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateEventSourceMappingOutput,
    crate::error::UpdateEventSourceMappingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_event_source_mapping_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_event_source_mapping(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEventSourceMappingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_code_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionCodeOutput,
    crate::error::UpdateFunctionCodeError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateFunctionCodeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeSigningConfigNotFoundException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::CodeSigningConfigNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_signing_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_signing_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CodeStorageExceededException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::CodeStorageExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_storage_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_storage_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CodeVerificationFailedException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::CodeVerificationFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::code_verification_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_verification_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCodeSignatureException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::InvalidCodeSignatureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_code_signature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_code_signature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValueException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PreconditionFailedException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::PreconditionFailedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateFunctionCodeError {
                meta: generic,
                kind: crate::error::UpdateFunctionCodeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateFunctionCodeError {
            meta: generic,
            kind: crate::error::UpdateFunctionCodeErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_function_code_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateFunctionCodeError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateFunctionCodeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_code_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionCodeOutput,
    crate::error::UpdateFunctionCodeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_function_code_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_function_code(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFunctionCodeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_configuration_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionConfigurationOutput,
    crate::error::UpdateFunctionConfigurationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateFunctionConfigurationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CodeSigningConfigNotFoundException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::CodeSigningConfigNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_signing_config_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_signing_config_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CodeVerificationFailedException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::CodeVerificationFailedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::code_verification_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_code_verification_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCodeSignatureException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::InvalidCodeSignatureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_code_signature_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_code_signature_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValueException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PreconditionFailedException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::PreconditionFailedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::precondition_failed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_precondition_failed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::UpdateFunctionConfigurationError { meta: generic, kind: crate::error::UpdateFunctionConfigurationErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_function_configuration_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateFunctionConfigurationError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateFunctionConfigurationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_configuration_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionConfigurationOutput,
    crate::error::UpdateFunctionConfigurationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_function_configuration_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_function_configuration(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFunctionConfigurationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_event_invoke_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionEventInvokeConfigOutput,
    crate::error::UpdateFunctionEventInvokeConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UpdateFunctionEventInvokeConfigError { meta: generic, kind: crate::error::UpdateFunctionEventInvokeConfigErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceConflictException" => crate::error::UpdateFunctionEventInvokeConfigError { meta: generic, kind: crate::error::UpdateFunctionEventInvokeConfigErrorKind::ResourceConflictException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ResourceNotFoundException" => crate::error::UpdateFunctionEventInvokeConfigError { meta: generic, kind: crate::error::UpdateFunctionEventInvokeConfigErrorKind::ResourceNotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::UpdateFunctionEventInvokeConfigError { meta: generic, kind: crate::error::UpdateFunctionEventInvokeConfigErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "TooManyRequestsException" => crate::error::UpdateFunctionEventInvokeConfigError { meta: generic, kind: crate::error::UpdateFunctionEventInvokeConfigErrorKind::TooManyRequestsException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_function_event_invoke_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateFunctionEventInvokeConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateFunctionEventInvokeConfigError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_event_invoke_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionEventInvokeConfigOutput,
    crate::error::UpdateFunctionEventInvokeConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_function_event_invoke_config_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_function_event_invoke_config(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateFunctionEventInvokeConfigError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_url_config_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionUrlConfigOutput,
    crate::error::UpdateFunctionUrlConfigError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateFunctionUrlConfigError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValueException" => crate::error::UpdateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::UpdateFunctionUrlConfigErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_parameter_value_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceConflictException" => crate::error::UpdateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::UpdateFunctionUrlConfigErrorKind::ResourceConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::UpdateFunctionUrlConfigErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::UpdateFunctionUrlConfigError {
                meta: generic,
                kind: crate::error::UpdateFunctionUrlConfigErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "TooManyRequestsException" => crate::error::UpdateFunctionUrlConfigError {
            meta: generic,
            kind: crate::error::UpdateFunctionUrlConfigErrorKind::TooManyRequestsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_requests_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_requests_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
                    output = output.set_retry_after_seconds(
                        crate::http_serde::deser_header_update_function_url_config_too_many_requests_exception_retry_after_seconds(response.headers())
                                                .map_err(|_|crate::error::UpdateFunctionUrlConfigError::unhandled("Failed to parse retryAfterSeconds from header `Retry-After"))?
                    );
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateFunctionUrlConfigError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_function_url_config_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateFunctionUrlConfigOutput,
    crate::error::UpdateFunctionUrlConfigError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_function_url_config_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_function_url_config(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateFunctionUrlConfigError::unhandled)?;
        output.build()
    })
}
