// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddLayerVersionPermissionInput`](crate::input::AddLayerVersionPermissionInput)
pub mod add_layer_version_permission_input {
    /// A builder for [`AddLayerVersionPermissionInput`](crate::input::AddLayerVersionPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddLayerVersionPermissionInput`](crate::input::AddLayerVersionPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddLayerVersionPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddLayerVersionPermissionInput {
                layer_name: self.layer_name,
                version_number: self.version_number.unwrap_or_default(),
                statement_id: self.statement_id,
                action: self.action,
                principal: self.principal,
                organization_id: self.organization_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AddLayerVersionPermissionInputOperationOutputAlias =
    crate::operation::AddLayerVersionPermission;
#[doc(hidden)]
pub type AddLayerVersionPermissionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddLayerVersionPermissionInput {
    /// Consumes the builder and constructs an Operation<[`AddLayerVersionPermission`](crate::operation::AddLayerVersionPermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddLayerVersionPermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddLayerVersionPermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.layer_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_1, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.version_number;
                let mut version_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_2);
                let version_number = version_number_encoder.encode();
                if version_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_number",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
                    LayerName = layer_name,
                    VersionNumber = version_number
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AddLayerVersionPermissionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.revision_id {
                    query.push_kv("RevisionId", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddLayerVersionPermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_layer_version_permission(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddLayerVersionPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddLayerVersionPermission",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddLayerVersionPermissionInput`](crate::input::AddLayerVersionPermissionInput)
    pub fn builder() -> crate::input::add_layer_version_permission_input::Builder {
        crate::input::add_layer_version_permission_input::Builder::default()
    }
}

/// See [`AddPermissionInput`](crate::input::AddPermissionInput)
pub mod add_permission_input {
    /// A builder for [`AddPermissionInput`](crate::input::AddPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) principal: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) source_account: std::option::Option<std::string::String>,
        pub(crate) event_source_token: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) principal_org_id: std::option::Option<std::string::String>,
        pub(crate) function_url_auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
        /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account = Some(input.into());
            self
        }
        /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account = input;
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn event_source_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_token = Some(input.into());
            self
        }
        /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
        pub fn set_event_source_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_token = input;
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.</p>
        pub fn principal_org_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_org_id = Some(input.into());
            self
        }
        /// <p>The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.</p>
        pub fn set_principal_org_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_org_id = input;
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn function_url_auth_type(mut self, input: crate::model::FunctionUrlAuthType) -> Self {
            self.function_url_auth_type = Some(input);
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn set_function_url_auth_type(
            mut self,
            input: std::option::Option<crate::model::FunctionUrlAuthType>,
        ) -> Self {
            self.function_url_auth_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AddPermissionInput`](crate::input::AddPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddPermissionInput {
                function_name: self.function_name,
                statement_id: self.statement_id,
                action: self.action,
                principal: self.principal,
                source_arn: self.source_arn,
                source_account: self.source_account,
                event_source_token: self.event_source_token,
                qualifier: self.qualifier,
                revision_id: self.revision_id,
                principal_org_id: self.principal_org_id,
                function_url_auth_type: self.function_url_auth_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AddPermissionInputOperationOutputAlias = crate::operation::AddPermission;
#[doc(hidden)]
pub type AddPermissionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddPermissionInput {
    /// Consumes the builder and constructs an Operation<[`AddPermission`](crate::operation::AddPermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddPermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddPermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.function_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_4, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/policy",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::AddPermissionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_5) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_5));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddPermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_permission(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddPermission",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddPermissionInput`](crate::input::AddPermissionInput)
    pub fn builder() -> crate::input::add_permission_input::Builder {
        crate::input::add_permission_input::Builder::default()
    }
}

/// See [`CreateAliasInput`](crate::input::CreateAliasInput)
pub mod create_alias_input {
    /// A builder for [`CreateAliasInput`](crate::input::CreateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAliasInput`](crate::input::CreateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAliasInput {
                function_name: self.function_name,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAliasInputOperationOutputAlias = crate::operation::CreateAlias;
#[doc(hidden)]
pub type CreateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlias`](crate::operation::CreateAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.function_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_6, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/aliases",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_alias(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlias",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAliasInput`](crate::input::CreateAliasInput)
    pub fn builder() -> crate::input::create_alias_input::Builder {
        crate::input::create_alias_input::Builder::default()
    }
}

/// See [`CreateCodeSigningConfigInput`](crate::input::CreateCodeSigningConfigInput)
pub mod create_code_signing_config_input {
    /// A builder for [`CreateCodeSigningConfigInput`](crate::input::CreateCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
        pub(crate) code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
    }
    impl Builder {
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, input: crate::model::AllowedPublishers) -> Self {
            self.allowed_publishers = Some(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.allowed_publishers = input;
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn code_signing_policies(mut self, input: crate::model::CodeSigningPolicies) -> Self {
            self.code_signing_policies = Some(input);
            self
        }
        /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.code_signing_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCodeSigningConfigInput`](crate::input::CreateCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCodeSigningConfigInput {
                description: self.description,
                allowed_publishers: self.allowed_publishers,
                code_signing_policies: self.code_signing_policies,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCodeSigningConfigInputOperationOutputAlias =
    crate::operation::CreateCodeSigningConfig;
#[doc(hidden)]
pub type CreateCodeSigningConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateCodeSigningConfig`](crate::operation::CreateCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-04-22/code-signing-configs")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_code_signing_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCodeSigningConfigInput`](crate::input::CreateCodeSigningConfigInput)
    pub fn builder() -> crate::input::create_code_signing_config_input::Builder {
        crate::input::create_code_signing_config_input::Builder::default()
    }
}

/// See [`CreateEventSourceMappingInput`](crate::input::CreateEventSourceMappingInput)
pub mod create_event_source_mapping_input {
    /// A builder for [`CreateEventSourceMappingInput`](crate::input::CreateEventSourceMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) filter_criteria: std::option::Option<crate::model::FilterCriteria>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) starting_position: std::option::Option<crate::model::EventSourcePosition>,
        pub(crate) starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) topics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) queues: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) self_managed_event_source:
            std::option::Option<crate::model::SelfManagedEventSource>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.filter_criteria = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.filter_criteria = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn starting_position(mut self, input: crate::model::EventSourcePosition) -> Self {
            self.starting_position = Some(input);
            self
        }
        /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
        pub fn set_starting_position(
            mut self,
            input: std::option::Option<crate::model::EventSourcePosition>,
        ) -> Self {
            self.starting_position = input;
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
        pub fn starting_position_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.starting_position_timestamp = Some(input);
            self
        }
        /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
        pub fn set_starting_position_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.starting_position_timestamp = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `topics`.
        ///
        /// To override the contents of this collection use [`set_topics`](Self::set_topics).
        ///
        /// <p>The name of the Kafka topic.</p>
        pub fn topics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.topics.unwrap_or_default();
            v.push(input.into());
            self.topics = Some(v);
            self
        }
        /// <p>The name of the Kafka topic.</p>
        pub fn set_topics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.topics = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn queues(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: crate::model::SourceAccessConfiguration,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input);
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn self_managed_event_source(
            mut self,
            input: crate::model::SelfManagedEventSource,
        ) -> Self {
            self.self_managed_event_source = Some(input);
            self
        }
        /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
        pub fn set_self_managed_event_source(
            mut self,
            input: std::option::Option<crate::model::SelfManagedEventSource>,
        ) -> Self {
            self.self_managed_event_source = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: crate::model::FunctionResponseType,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input);
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSourceMappingInput`](crate::input::CreateEventSourceMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSourceMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSourceMappingInput {
                event_source_arn: self.event_source_arn,
                function_name: self.function_name,
                enabled: self.enabled,
                batch_size: self.batch_size,
                filter_criteria: self.filter_criteria,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                parallelization_factor: self.parallelization_factor,
                starting_position: self.starting_position,
                starting_position_timestamp: self.starting_position_timestamp,
                destination_config: self.destination_config,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                topics: self.topics,
                queues: self.queues,
                source_access_configurations: self.source_access_configurations,
                self_managed_event_source: self.self_managed_event_source,
                function_response_types: self.function_response_types,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSourceMappingInputOperationOutputAlias =
    crate::operation::CreateEventSourceMapping;
#[doc(hidden)]
pub type CreateEventSourceMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEventSourceMappingInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSourceMapping`](crate::operation::CreateEventSourceMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSourceMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEventSourceMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-03-31/event-source-mappings")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEventSourceMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_event_source_mapping(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSourceMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSourceMapping",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSourceMappingInput`](crate::input::CreateEventSourceMappingInput)
    pub fn builder() -> crate::input::create_event_source_mapping_input::Builder {
        crate::input::create_event_source_mapping_input::Builder::default()
    }
}

/// See [`CreateFunctionInput`](crate::input::CreateFunctionInput)
pub mod create_function_input {
    /// A builder for [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<crate::model::FunctionCode>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) publish: std::option::Option<bool>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) package_type: std::option::Option<crate::model::PackageType>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) layers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) image_config: std::option::Option<crate::model::ImageConfig>,
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>The code for the function.</p>
        pub fn code(mut self, input: crate::model::FunctionCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The code for the function.</p>
        pub fn set_code(mut self, input: std::option::Option<crate::model::FunctionCode>) -> Self {
            self.code = input;
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn publish(mut self, input: bool) -> Self {
            self.publish = Some(input);
            self
        }
        /// <p>Set to true to publish the first version of the function during creation.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.publish = input;
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn package_type(mut self, input: crate::model::PackageType) -> Self {
            self.package_type = Some(input);
            self
        }
        /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
        pub fn set_package_type(
            mut self,
            input: std::option::Option<crate::model::PackageType>,
        ) -> Self {
            self.package_type = input;
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfig) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(mut self, input: crate::model::FileSystemConfig) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input);
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
        pub fn image_config(mut self, input: crate::model::ImageConfig) -> Self {
            self.image_config = Some(input);
            self
        }
        /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.image_config = input;
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: crate::model::Architecture) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input);
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionInput`](crate::input::CreateFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionInput {
                function_name: self.function_name,
                runtime: self.runtime,
                role: self.role,
                handler: self.handler,
                code: self.code,
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                publish: self.publish.unwrap_or_default(),
                vpc_config: self.vpc_config,
                package_type: self.package_type,
                dead_letter_config: self.dead_letter_config,
                environment: self.environment,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                tags: self.tags,
                layers: self.layers,
                file_system_configs: self.file_system_configs,
                image_config: self.image_config,
                code_signing_config_arn: self.code_signing_config_arn,
                architectures: self.architectures,
                ephemeral_storage: self.ephemeral_storage,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionInputOperationOutputAlias = crate::operation::CreateFunction;
#[doc(hidden)]
pub type CreateFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFunctionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunction`](crate::operation::CreateFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-03-31/functions").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunction",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
}

/// See [`CreateFunctionUrlConfigInput`](crate::input::CreateFunctionUrlConfigInput)
pub mod create_function_url_config_input {
    /// A builder for [`CreateFunctionUrlConfigInput`](crate::input::CreateFunctionUrlConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
        pub(crate) cors: std::option::Option<crate::model::Cors>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn auth_type(mut self, input: crate::model::FunctionUrlAuthType) -> Self {
            self.auth_type = Some(input);
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn set_auth_type(
            mut self,
            input: std::option::Option<crate::model::FunctionUrlAuthType>,
        ) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
        pub fn cors(mut self, input: crate::model::Cors) -> Self {
            self.cors = Some(input);
            self
        }
        /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
        pub fn set_cors(mut self, input: std::option::Option<crate::model::Cors>) -> Self {
            self.cors = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionUrlConfigInput`](crate::input::CreateFunctionUrlConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionUrlConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionUrlConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
                auth_type: self.auth_type,
                cors: self.cors,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionUrlConfigInputOperationOutputAlias =
    crate::operation::CreateFunctionUrlConfig;
#[doc(hidden)]
pub type CreateFunctionUrlConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFunctionUrlConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunctionUrlConfig`](crate::operation::CreateFunctionUrlConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunctionUrlConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFunctionUrlConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.function_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_7, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-10-31/functions/{FunctionName}/url",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateFunctionUrlConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFunctionUrlConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_function_url_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunctionUrlConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunctionUrlConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionUrlConfigInput`](crate::input::CreateFunctionUrlConfigInput)
    pub fn builder() -> crate::input::create_function_url_config_input::Builder {
        crate::input::create_function_url_config_input::Builder::default()
    }
}

/// See [`DeleteAliasInput`](crate::input::DeleteAliasInput)
pub mod delete_alias_input {
    /// A builder for [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAliasInput`](crate::input::DeleteAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAliasInput {
                function_name: self.function_name,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAliasInputOperationOutputAlias = crate::operation::DeleteAlias;
#[doc(hidden)]
pub type DeleteAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlias`](crate::operation::DeleteAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.function_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_9, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_10, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
                    FunctionName = function_name,
                    Name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlias",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAliasInput`](crate::input::DeleteAliasInput)
    pub fn builder() -> crate::input::delete_alias_input::Builder {
        crate::input::delete_alias_input::Builder::default()
    }
}

/// See [`DeleteCodeSigningConfigInput`](crate::input::DeleteCodeSigningConfigInput)
pub mod delete_code_signing_config_input {
    /// A builder for [`DeleteCodeSigningConfigInput`](crate::input::DeleteCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCodeSigningConfigInput`](crate::input::DeleteCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCodeSigningConfigInput {
                code_signing_config_arn: self.code_signing_config_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCodeSigningConfigInputOperationOutputAlias =
    crate::operation::DeleteCodeSigningConfig;
#[doc(hidden)]
pub type DeleteCodeSigningConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCodeSigningConfig`](crate::operation::DeleteCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.code_signing_config_arn;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let code_signing_config_arn = aws_smithy_http::label::fmt_string(input_11, false);
                if code_signing_config_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
                    CodeSigningConfigArn = code_signing_config_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCodeSigningConfigInput`](crate::input::DeleteCodeSigningConfigInput)
    pub fn builder() -> crate::input::delete_code_signing_config_input::Builder {
        crate::input::delete_code_signing_config_input::Builder::default()
    }
}

/// See [`DeleteEventSourceMappingInput`](crate::input::DeleteEventSourceMappingInput)
pub mod delete_event_source_mapping_input {
    /// A builder for [`DeleteEventSourceMappingInput`](crate::input::DeleteEventSourceMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSourceMappingInput`](crate::input::DeleteEventSourceMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSourceMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSourceMappingInput { uuid: self.uuid })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSourceMappingInputOperationOutputAlias =
    crate::operation::DeleteEventSourceMapping;
#[doc(hidden)]
pub type DeleteEventSourceMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventSourceMappingInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSourceMapping`](crate::operation::DeleteEventSourceMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSourceMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEventSourceMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.uuid;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    },
                )?;
                let uuid = aws_smithy_http::label::fmt_string(input_12, false);
                if uuid.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/event-source-mappings/{UUID}",
                    UUID = uuid
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEventSourceMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSourceMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSourceMapping",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSourceMappingInput`](crate::input::DeleteEventSourceMappingInput)
    pub fn builder() -> crate::input::delete_event_source_mapping_input::Builder {
        crate::input::delete_event_source_mapping_input::Builder::default()
    }
}

/// See [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
pub mod delete_function_input {
    /// A builder for [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function or version.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionInputOperationOutputAlias = crate::operation::DeleteFunction;
#[doc(hidden)]
pub type DeleteFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunction`](crate::operation::DeleteFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.function_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_13, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_14) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_14));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunction",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
}

/// See [`DeleteFunctionCodeSigningConfigInput`](crate::input::DeleteFunctionCodeSigningConfigInput)
pub mod delete_function_code_signing_config_input {
    /// A builder for [`DeleteFunctionCodeSigningConfigInput`](crate::input::DeleteFunctionCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionCodeSigningConfigInput`](crate::input::DeleteFunctionCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionCodeSigningConfigInput {
                function_name: self.function_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionCodeSigningConfigInputOperationOutputAlias =
    crate::operation::DeleteFunctionCodeSigningConfig;
#[doc(hidden)]
pub type DeleteFunctionCodeSigningConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunctionCodeSigningConfig`](crate::operation::DeleteFunctionCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunctionCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.function_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_15, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-06-30/functions/{FunctionName}/code-signing-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunctionCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunctionCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionCodeSigningConfigInput`](crate::input::DeleteFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::delete_function_code_signing_config_input::Builder {
        crate::input::delete_function_code_signing_config_input::Builder::default()
    }
}

/// See [`DeleteFunctionConcurrencyInput`](crate::input::DeleteFunctionConcurrencyInput)
pub mod delete_function_concurrency_input {
    /// A builder for [`DeleteFunctionConcurrencyInput`](crate::input::DeleteFunctionConcurrencyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionConcurrencyInput`](crate::input::DeleteFunctionConcurrencyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionConcurrencyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionConcurrencyInput {
                function_name: self.function_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionConcurrencyInputOperationOutputAlias =
    crate::operation::DeleteFunctionConcurrency;
#[doc(hidden)]
pub type DeleteFunctionConcurrencyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionConcurrencyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunctionConcurrency`](crate::operation::DeleteFunctionConcurrency)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunctionConcurrency,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionConcurrencyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.function_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_16, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2017-10-31/functions/{FunctionName}/concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionConcurrencyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunctionConcurrency::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunctionConcurrency",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionConcurrencyInput`](crate::input::DeleteFunctionConcurrencyInput)
    pub fn builder() -> crate::input::delete_function_concurrency_input::Builder {
        crate::input::delete_function_concurrency_input::Builder::default()
    }
}

/// See [`DeleteFunctionEventInvokeConfigInput`](crate::input::DeleteFunctionEventInvokeConfigInput)
pub mod delete_function_event_invoke_config_input {
    /// A builder for [`DeleteFunctionEventInvokeConfigInput`](crate::input::DeleteFunctionEventInvokeConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionEventInvokeConfigInput`](crate::input::DeleteFunctionEventInvokeConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionEventInvokeConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionEventInvokeConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionEventInvokeConfigInputOperationOutputAlias =
    crate::operation::DeleteFunctionEventInvokeConfig;
#[doc(hidden)]
pub type DeleteFunctionEventInvokeConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionEventInvokeConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunctionEventInvokeConfig`](crate::operation::DeleteFunctionEventInvokeConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunctionEventInvokeConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionEventInvokeConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.function_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_17, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-25/functions/{FunctionName}/event-invoke-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteFunctionEventInvokeConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionEventInvokeConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunctionEventInvokeConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunctionEventInvokeConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionEventInvokeConfigInput`](crate::input::DeleteFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::delete_function_event_invoke_config_input::Builder {
        crate::input::delete_function_event_invoke_config_input::Builder::default()
    }
}

/// See [`DeleteFunctionUrlConfigInput`](crate::input::DeleteFunctionUrlConfigInput)
pub mod delete_function_url_config_input {
    /// A builder for [`DeleteFunctionUrlConfigInput`](crate::input::DeleteFunctionUrlConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionUrlConfigInput`](crate::input::DeleteFunctionUrlConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionUrlConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionUrlConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionUrlConfigInputOperationOutputAlias =
    crate::operation::DeleteFunctionUrlConfig;
#[doc(hidden)]
pub type DeleteFunctionUrlConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionUrlConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunctionUrlConfig`](crate::operation::DeleteFunctionUrlConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunctionUrlConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionUrlConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.function_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_19, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-10-31/functions/{FunctionName}/url",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteFunctionUrlConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_20) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_20));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionUrlConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunctionUrlConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunctionUrlConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionUrlConfigInput`](crate::input::DeleteFunctionUrlConfigInput)
    pub fn builder() -> crate::input::delete_function_url_config_input::Builder {
        crate::input::delete_function_url_config_input::Builder::default()
    }
}

/// See [`DeleteLayerVersionInput`](crate::input::DeleteLayerVersionInput)
pub mod delete_layer_version_input {
    /// A builder for [`DeleteLayerVersionInput`](crate::input::DeleteLayerVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLayerVersionInput`](crate::input::DeleteLayerVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLayerVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLayerVersionInput {
                layer_name: self.layer_name,
                version_number: self.version_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLayerVersionInputOperationOutputAlias = crate::operation::DeleteLayerVersion;
#[doc(hidden)]
pub type DeleteLayerVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLayerVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLayerVersion`](crate::operation::DeleteLayerVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLayerVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLayerVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.layer_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_21, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.version_number;
                let mut version_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_22);
                let version_number = version_number_encoder.encode();
                if version_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_number",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
                    LayerName = layer_name,
                    VersionNumber = version_number
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLayerVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLayerVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLayerVersion",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLayerVersionInput`](crate::input::DeleteLayerVersionInput)
    pub fn builder() -> crate::input::delete_layer_version_input::Builder {
        crate::input::delete_layer_version_input::Builder::default()
    }
}

/// See [`DeleteProvisionedConcurrencyConfigInput`](crate::input::DeleteProvisionedConcurrencyConfigInput)
pub mod delete_provisioned_concurrency_config_input {
    /// A builder for [`DeleteProvisionedConcurrencyConfigInput`](crate::input::DeleteProvisionedConcurrencyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProvisionedConcurrencyConfigInput`](crate::input::DeleteProvisionedConcurrencyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProvisionedConcurrencyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProvisionedConcurrencyConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProvisionedConcurrencyConfigInputOperationOutputAlias =
    crate::operation::DeleteProvisionedConcurrencyConfig;
#[doc(hidden)]
pub type DeleteProvisionedConcurrencyConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProvisionedConcurrencyConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProvisionedConcurrencyConfig`](crate::operation::DeleteProvisionedConcurrencyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProvisionedConcurrencyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProvisionedConcurrencyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.function_name;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_23, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteProvisionedConcurrencyConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_24) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_24));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProvisionedConcurrencyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProvisionedConcurrencyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProvisionedConcurrencyConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProvisionedConcurrencyConfigInput`](crate::input::DeleteProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::delete_provisioned_concurrency_config_input::Builder {
        crate::input::delete_provisioned_concurrency_config_input::Builder::default()
    }
}

/// See [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
pub mod get_account_settings_input {
    /// A builder for [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountSettingsInputOperationOutputAlias = crate::operation::GetAccountSettings;
#[doc(hidden)]
pub type GetAccountSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccountSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSettings`](crate::operation::GetAccountSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAccountSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2016-08-19/account-settings").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAccountSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSettings",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSettingsInput`](crate::input::GetAccountSettingsInput)
    pub fn builder() -> crate::input::get_account_settings_input::Builder {
        crate::input::get_account_settings_input::Builder::default()
    }
}

/// See [`GetAliasInput`](crate::input::GetAliasInput)
pub mod get_alias_input {
    /// A builder for [`GetAliasInput`](crate::input::GetAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAliasInput`](crate::input::GetAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAliasInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAliasInput {
                function_name: self.function_name,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAliasInputOperationOutputAlias = crate::operation::GetAlias;
#[doc(hidden)]
pub type GetAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAliasInput {
    /// Consumes the builder and constructs an Operation<[`GetAlias`](crate::operation::GetAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.function_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_25, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_26, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
                    FunctionName = function_name,
                    Name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetAlias::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetAlias", "lambda",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAliasInput`](crate::input::GetAliasInput)
    pub fn builder() -> crate::input::get_alias_input::Builder {
        crate::input::get_alias_input::Builder::default()
    }
}

/// See [`GetCodeSigningConfigInput`](crate::input::GetCodeSigningConfigInput)
pub mod get_code_signing_config_input {
    /// A builder for [`GetCodeSigningConfigInput`](crate::input::GetCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCodeSigningConfigInput`](crate::input::GetCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCodeSigningConfigInput {
                code_signing_config_arn: self.code_signing_config_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCodeSigningConfigInputOperationOutputAlias = crate::operation::GetCodeSigningConfig;
#[doc(hidden)]
pub type GetCodeSigningConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetCodeSigningConfig`](crate::operation::GetCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.code_signing_config_arn;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let code_signing_config_arn = aws_smithy_http::label::fmt_string(input_27, false);
                if code_signing_config_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
                    CodeSigningConfigArn = code_signing_config_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCodeSigningConfigInput`](crate::input::GetCodeSigningConfigInput)
    pub fn builder() -> crate::input::get_code_signing_config_input::Builder {
        crate::input::get_code_signing_config_input::Builder::default()
    }
}

/// See [`GetEventSourceMappingInput`](crate::input::GetEventSourceMappingInput)
pub mod get_event_source_mapping_input {
    /// A builder for [`GetEventSourceMappingInput`](crate::input::GetEventSourceMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEventSourceMappingInput`](crate::input::GetEventSourceMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEventSourceMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEventSourceMappingInput { uuid: self.uuid })
        }
    }
}
#[doc(hidden)]
pub type GetEventSourceMappingInputOperationOutputAlias = crate::operation::GetEventSourceMapping;
#[doc(hidden)]
pub type GetEventSourceMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetEventSourceMappingInput {
    /// Consumes the builder and constructs an Operation<[`GetEventSourceMapping`](crate::operation::GetEventSourceMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEventSourceMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetEventSourceMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.uuid;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    },
                )?;
                let uuid = aws_smithy_http::label::fmt_string(input_28, false);
                if uuid.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/event-source-mappings/{UUID}",
                    UUID = uuid
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetEventSourceMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEventSourceMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEventSourceMapping",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetEventSourceMappingInput`](crate::input::GetEventSourceMappingInput)
    pub fn builder() -> crate::input::get_event_source_mapping_input::Builder {
        crate::input::get_event_source_mapping_input::Builder::default()
    }
}

/// See [`GetFunctionInput`](crate::input::GetFunctionInput)
pub mod get_function_input {
    /// A builder for [`GetFunctionInput`](crate::input::GetFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionInput`](crate::input::GetFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionInputOperationOutputAlias = crate::operation::GetFunction;
#[doc(hidden)]
pub type GetFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionInput {
    /// Consumes the builder and constructs an Operation<[`GetFunction`](crate::operation::GetFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.function_name;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_29, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_30) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_30));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunction",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
}

/// See [`GetFunctionCodeSigningConfigInput`](crate::input::GetFunctionCodeSigningConfigInput)
pub mod get_function_code_signing_config_input {
    /// A builder for [`GetFunctionCodeSigningConfigInput`](crate::input::GetFunctionCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionCodeSigningConfigInput`](crate::input::GetFunctionCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionCodeSigningConfigInput {
                function_name: self.function_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionCodeSigningConfigInputOperationOutputAlias =
    crate::operation::GetFunctionCodeSigningConfig;
#[doc(hidden)]
pub type GetFunctionCodeSigningConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionCodeSigningConfig`](crate::operation::GetFunctionCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.function_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_31, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-06-30/functions/{FunctionName}/code-signing-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionCodeSigningConfigInput`](crate::input::GetFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::get_function_code_signing_config_input::Builder {
        crate::input::get_function_code_signing_config_input::Builder::default()
    }
}

/// See [`GetFunctionConcurrencyInput`](crate::input::GetFunctionConcurrencyInput)
pub mod get_function_concurrency_input {
    /// A builder for [`GetFunctionConcurrencyInput`](crate::input::GetFunctionConcurrencyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionConcurrencyInput`](crate::input::GetFunctionConcurrencyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionConcurrencyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionConcurrencyInput {
                function_name: self.function_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionConcurrencyInputOperationOutputAlias = crate::operation::GetFunctionConcurrency;
#[doc(hidden)]
pub type GetFunctionConcurrencyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionConcurrencyInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionConcurrency`](crate::operation::GetFunctionConcurrency)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionConcurrency,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionConcurrencyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.function_name;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_32, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-30/functions/{FunctionName}/concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionConcurrencyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionConcurrency::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionConcurrency",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionConcurrencyInput`](crate::input::GetFunctionConcurrencyInput)
    pub fn builder() -> crate::input::get_function_concurrency_input::Builder {
        crate::input::get_function_concurrency_input::Builder::default()
    }
}

/// See [`GetFunctionConfigurationInput`](crate::input::GetFunctionConfigurationInput)
pub mod get_function_configuration_input {
    /// A builder for [`GetFunctionConfigurationInput`](crate::input::GetFunctionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to get details about a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionConfigurationInput`](crate::input::GetFunctionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionConfigurationInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionConfigurationInputOperationOutputAlias =
    crate::operation::GetFunctionConfiguration;
#[doc(hidden)]
pub type GetFunctionConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionConfiguration`](crate::operation::GetFunctionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.function_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_33, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/configuration",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFunctionConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_34) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionConfiguration",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionConfigurationInput`](crate::input::GetFunctionConfigurationInput)
    pub fn builder() -> crate::input::get_function_configuration_input::Builder {
        crate::input::get_function_configuration_input::Builder::default()
    }
}

/// See [`GetFunctionEventInvokeConfigInput`](crate::input::GetFunctionEventInvokeConfigInput)
pub mod get_function_event_invoke_config_input {
    /// A builder for [`GetFunctionEventInvokeConfigInput`](crate::input::GetFunctionEventInvokeConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionEventInvokeConfigInput`](crate::input::GetFunctionEventInvokeConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionEventInvokeConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionEventInvokeConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionEventInvokeConfigInputOperationOutputAlias =
    crate::operation::GetFunctionEventInvokeConfig;
#[doc(hidden)]
pub type GetFunctionEventInvokeConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionEventInvokeConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionEventInvokeConfig`](crate::operation::GetFunctionEventInvokeConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionEventInvokeConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionEventInvokeConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.function_name;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_35, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-25/functions/{FunctionName}/event-invoke-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFunctionEventInvokeConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_36) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_36));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionEventInvokeConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionEventInvokeConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionEventInvokeConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionEventInvokeConfigInput`](crate::input::GetFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::get_function_event_invoke_config_input::Builder {
        crate::input::get_function_event_invoke_config_input::Builder::default()
    }
}

/// See [`GetFunctionUrlConfigInput`](crate::input::GetFunctionUrlConfigInput)
pub mod get_function_url_config_input {
    /// A builder for [`GetFunctionUrlConfigInput`](crate::input::GetFunctionUrlConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionUrlConfigInput`](crate::input::GetFunctionUrlConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionUrlConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionUrlConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionUrlConfigInputOperationOutputAlias = crate::operation::GetFunctionUrlConfig;
#[doc(hidden)]
pub type GetFunctionUrlConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionUrlConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetFunctionUrlConfig`](crate::operation::GetFunctionUrlConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunctionUrlConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionUrlConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.function_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_37, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-10-31/functions/{FunctionName}/url",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetFunctionUrlConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_38) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_38));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionUrlConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunctionUrlConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunctionUrlConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionUrlConfigInput`](crate::input::GetFunctionUrlConfigInput)
    pub fn builder() -> crate::input::get_function_url_config_input::Builder {
        crate::input::get_function_url_config_input::Builder::default()
    }
}

/// See [`GetLayerVersionInput`](crate::input::GetLayerVersionInput)
pub mod get_layer_version_input {
    /// A builder for [`GetLayerVersionInput`](crate::input::GetLayerVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionInput`](crate::input::GetLayerVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLayerVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLayerVersionInput {
                layer_name: self.layer_name,
                version_number: self.version_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetLayerVersionInputOperationOutputAlias = crate::operation::GetLayerVersion;
#[doc(hidden)]
pub type GetLayerVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLayerVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetLayerVersion`](crate::operation::GetLayerVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLayerVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLayerVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.layer_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_39, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_40 = &_input.version_number;
                let mut version_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_40);
                let version_number = version_number_encoder.encode();
                if version_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_number",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
                    LayerName = layer_name,
                    VersionNumber = version_number
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLayerVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLayerVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLayerVersion",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLayerVersionInput`](crate::input::GetLayerVersionInput)
    pub fn builder() -> crate::input::get_layer_version_input::Builder {
        crate::input::get_layer_version_input::Builder::default()
    }
}

/// See [`GetLayerVersionByArnInput`](crate::input::GetLayerVersionByArnInput)
pub mod get_layer_version_by_arn_input {
    /// A builder for [`GetLayerVersionByArnInput`](crate::input::GetLayerVersionByArnInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the layer version.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the layer version.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionByArnInput`](crate::input::GetLayerVersionByArnInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLayerVersionByArnInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLayerVersionByArnInput { arn: self.arn })
        }
    }
}
#[doc(hidden)]
pub type GetLayerVersionByArnInputOperationOutputAlias = crate::operation::GetLayerVersionByArn;
#[doc(hidden)]
pub type GetLayerVersionByArnInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLayerVersionByArnInput {
    /// Consumes the builder and constructs an Operation<[`GetLayerVersionByArn`](crate::operation::GetLayerVersionByArn)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLayerVersionByArn,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLayerVersionByArnInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2018-10-31/layers").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetLayerVersionByArnInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("find", "LayerVersion");
                if let Some(inner_41) = &_input.arn {
                    query.push_kv("Arn", &aws_smithy_http::query::fmt_string(&inner_41));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLayerVersionByArnInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLayerVersionByArn::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLayerVersionByArn",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLayerVersionByArnInput`](crate::input::GetLayerVersionByArnInput)
    pub fn builder() -> crate::input::get_layer_version_by_arn_input::Builder {
        crate::input::get_layer_version_by_arn_input::Builder::default()
    }
}

/// See [`GetLayerVersionPolicyInput`](crate::input::GetLayerVersionPolicyInput)
pub mod get_layer_version_policy_input {
    /// A builder for [`GetLayerVersionPolicyInput`](crate::input::GetLayerVersionPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLayerVersionPolicyInput`](crate::input::GetLayerVersionPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLayerVersionPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLayerVersionPolicyInput {
                layer_name: self.layer_name,
                version_number: self.version_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetLayerVersionPolicyInputOperationOutputAlias = crate::operation::GetLayerVersionPolicy;
#[doc(hidden)]
pub type GetLayerVersionPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLayerVersionPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetLayerVersionPolicy`](crate::operation::GetLayerVersionPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLayerVersionPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLayerVersionPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.layer_name;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_42, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_43 = &_input.version_number;
                let mut version_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_43);
                let version_number = version_number_encoder.encode();
                if version_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_number",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
                    LayerName = layer_name,
                    VersionNumber = version_number
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLayerVersionPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLayerVersionPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLayerVersionPolicy",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLayerVersionPolicyInput`](crate::input::GetLayerVersionPolicyInput)
    pub fn builder() -> crate::input::get_layer_version_policy_input::Builder {
        crate::input::get_layer_version_policy_input::Builder::default()
    }
}

/// See [`GetPolicyInput`](crate::input::GetPolicyInput)
pub mod get_policy_input {
    /// A builder for [`GetPolicyInput`](crate::input::GetPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to get the policy for that resource.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyInput`](crate::input::GetPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPolicyInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyInputOperationOutputAlias = crate::operation::GetPolicy;
#[doc(hidden)]
pub type GetPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicy`](crate::operation::GetPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.function_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_44, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/policy",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetPolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_45) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_45));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPolicy",
                    "lambda",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
}

/// See [`GetProvisionedConcurrencyConfigInput`](crate::input::GetProvisionedConcurrencyConfigInput)
pub mod get_provisioned_concurrency_config_input {
    /// A builder for [`GetProvisionedConcurrencyConfigInput`](crate::input::GetProvisionedConcurrencyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProvisionedConcurrencyConfigInput`](crate::input::GetProvisionedConcurrencyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProvisionedConcurrencyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProvisionedConcurrencyConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProvisionedConcurrencyConfigInputOperationOutputAlias =
    crate::operation::GetProvisionedConcurrencyConfig;
#[doc(hidden)]
pub type GetProvisionedConcurrencyConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetProvisionedConcurrencyConfigInput {
    /// Consumes the builder and constructs an Operation<[`GetProvisionedConcurrencyConfig`](crate::operation::GetProvisionedConcurrencyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProvisionedConcurrencyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProvisionedConcurrencyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.function_name;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_46, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetProvisionedConcurrencyConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_47) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProvisionedConcurrencyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProvisionedConcurrencyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProvisionedConcurrencyConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProvisionedConcurrencyConfigInput`](crate::input::GetProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::get_provisioned_concurrency_config_input::Builder {
        crate::input::get_provisioned_concurrency_config_input::Builder::default()
    }
}

/// See [`InvokeInput`](crate::input::InvokeInput)
pub mod invoke_input {
    /// A builder for [`InvokeInput`](crate::input::InvokeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) invocation_type: std::option::Option<crate::model::InvocationType>,
        pub(crate) log_type: std::option::Option<crate::model::LogType>,
        pub(crate) client_context: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
        /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
        /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
        /// </ul>
        pub fn invocation_type(mut self, input: crate::model::InvocationType) -> Self {
            self.invocation_type = Some(input);
            self
        }
        /// <p>Choose from the following options.</p>
        /// <ul>
        /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
        /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
        /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
        /// </ul>
        pub fn set_invocation_type(
            mut self,
            input: std::option::Option<crate::model::InvocationType>,
        ) -> Self {
            self.invocation_type = input;
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn log_type(mut self, input: crate::model::LogType) -> Self {
            self.log_type = Some(input);
            self
        }
        /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
        pub fn set_log_type(mut self, input: std::option::Option<crate::model::LogType>) -> Self {
            self.log_type = input;
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
        pub fn client_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_context = Some(input.into());
            self
        }
        /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
        pub fn set_client_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_context = input;
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
        pub fn payload(mut self, input: aws_smithy_types::Blob) -> Self {
            self.payload = Some(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
        pub fn set_payload(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.payload = input;
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to invoke a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeInput`](crate::input::InvokeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::InvokeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::InvokeInput {
                function_name: self.function_name,
                invocation_type: self.invocation_type,
                log_type: self.log_type,
                client_context: self.client_context,
                payload: self.payload,
                qualifier: self.qualifier,
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeInputOperationOutputAlias = crate::operation::Invoke;
#[doc(hidden)]
pub type InvokeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InvokeInput {
    /// Consumes the builder and constructs an Operation<[`Invoke`](crate::operation::Invoke)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Invoke,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::InvokeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.function_name;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_48, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/invocations",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::InvokeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::InvokeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_invoke(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/octet-stream",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_invoke_input(self.payload)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Invoke::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Invoke", "lambda",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`InvokeInput`](crate::input::InvokeInput)
    pub fn builder() -> crate::input::invoke_input::Builder {
        crate::input::invoke_input::Builder::default()
    }
}

/// See [`InvokeAsyncInput`](crate::input::InvokeAsyncInput)
pub mod invoke_async_input {
    /// A builder for [`InvokeAsyncInput`](crate::input::InvokeAsyncInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) invoke_args: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn invoke_args(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.invoke_args = Some(input);
            self
        }
        /// <p>The JSON that you want to provide to your Lambda function as input.</p>
        pub fn set_invoke_args(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.invoke_args = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeAsyncInput`](crate::input::InvokeAsyncInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InvokeAsyncInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InvokeAsyncInput {
                function_name: self.function_name,
                invoke_args: self.invoke_args.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeAsyncInputOperationOutputAlias = crate::operation::InvokeAsync;
#[doc(hidden)]
pub type InvokeAsyncInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InvokeAsyncInput {
    /// Consumes the builder and constructs an Operation<[`InvokeAsync`](crate::operation::InvokeAsync)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InvokeAsync,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::InvokeAsyncInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.function_name;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_50, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2014-11-13/functions/{FunctionName}/invoke-async",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::InvokeAsyncInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/octet-stream",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_invoke_async_input(self.invoke_args)?
                .into_inner(),
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InvokeAsync::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InvokeAsync",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`InvokeAsyncInput`](crate::input::InvokeAsyncInput)
    pub fn builder() -> crate::input::invoke_async_input::Builder {
        crate::input::invoke_async_input::Builder::default()
    }
}

/// See [`ListAliasesInput`](crate::input::ListAliasesInput)
pub mod list_aliases_input {
    /// A builder for [`ListAliasesInput`](crate::input::ListAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>Specify a function version to only list aliases that invoke that version.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Limit the number of aliases returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAliasesInput`](crate::input::ListAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAliasesInput {
                function_name: self.function_name,
                function_version: self.function_version,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAliasesInputOperationOutputAlias = crate::operation::ListAliases;
#[doc(hidden)]
pub type ListAliasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListAliases`](crate::operation::ListAliases)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAliases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAliasesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.function_name;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_51, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/aliases",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAliasesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_52) = &_input.function_version {
                    query.push_kv(
                        "FunctionVersion",
                        &aws_smithy_http::query::fmt_string(&inner_52),
                    );
                }
                if let Some(inner_53) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_54).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAliasesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAliases",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAliasesInput`](crate::input::ListAliasesInput)
    pub fn builder() -> crate::input::list_aliases_input::Builder {
        crate::input::list_aliases_input::Builder::default()
    }
}

/// See [`ListCodeSigningConfigsInput`](crate::input::ListCodeSigningConfigsInput)
pub mod list_code_signing_configs_input {
    /// A builder for [`ListCodeSigningConfigsInput`](crate::input::ListCodeSigningConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCodeSigningConfigsInput`](crate::input::ListCodeSigningConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCodeSigningConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCodeSigningConfigsInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCodeSigningConfigsInputOperationOutputAlias = crate::operation::ListCodeSigningConfigs;
#[doc(hidden)]
pub type ListCodeSigningConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCodeSigningConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListCodeSigningConfigs`](crate::operation::ListCodeSigningConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCodeSigningConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListCodeSigningConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-04-22/code-signing-configs")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListCodeSigningConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_55) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_55));
                }
                if let Some(inner_56) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_56).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListCodeSigningConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCodeSigningConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCodeSigningConfigs",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListCodeSigningConfigsInput`](crate::input::ListCodeSigningConfigsInput)
    pub fn builder() -> crate::input::list_code_signing_configs_input::Builder {
        crate::input::list_code_signing_configs_input::Builder::default()
    }
}

/// See [`ListEventSourceMappingsInput`](crate::input::ListEventSourceMappingsInput)
pub mod list_event_source_mappings_input {
    /// A builder for [`ListEventSourceMappingsInput`](crate::input::ListEventSourceMappingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the event source.</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
        /// </ul>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEventSourceMappingsInput`](crate::input::ListEventSourceMappingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEventSourceMappingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEventSourceMappingsInput {
                event_source_arn: self.event_source_arn,
                function_name: self.function_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEventSourceMappingsInputOperationOutputAlias =
    crate::operation::ListEventSourceMappings;
#[doc(hidden)]
pub type ListEventSourceMappingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEventSourceMappingsInput {
    /// Consumes the builder and constructs an Operation<[`ListEventSourceMappings`](crate::operation::ListEventSourceMappings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEventSourceMappings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEventSourceMappingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-03-31/event-source-mappings")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListEventSourceMappingsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_57) = &_input.event_source_arn {
                    query.push_kv(
                        "EventSourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_57),
                    );
                }
                if let Some(inner_58) = &_input.function_name {
                    query.push_kv(
                        "FunctionName",
                        &aws_smithy_http::query::fmt_string(&inner_58),
                    );
                }
                if let Some(inner_59) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_59));
                }
                if let Some(inner_60) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_60).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEventSourceMappingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEventSourceMappings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEventSourceMappings",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEventSourceMappingsInput`](crate::input::ListEventSourceMappingsInput)
    pub fn builder() -> crate::input::list_event_source_mappings_input::Builder {
        crate::input::list_event_source_mappings_input::Builder::default()
    }
}

/// See [`ListFunctionEventInvokeConfigsInput`](crate::input::ListFunctionEventInvokeConfigsInput)
pub mod list_function_event_invoke_configs_input {
    /// A builder for [`ListFunctionEventInvokeConfigsInput`](crate::input::ListFunctionEventInvokeConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of configurations to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionEventInvokeConfigsInput`](crate::input::ListFunctionEventInvokeConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionEventInvokeConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionEventInvokeConfigsInput {
                function_name: self.function_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionEventInvokeConfigsInputOperationOutputAlias =
    crate::operation::ListFunctionEventInvokeConfigs;
#[doc(hidden)]
pub type ListFunctionEventInvokeConfigsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionEventInvokeConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctionEventInvokeConfigs`](crate::operation::ListFunctionEventInvokeConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctionEventInvokeConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionEventInvokeConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.function_name;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_61, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-25/functions/{FunctionName}/event-invoke-config/list",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionEventInvokeConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_62) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_62));
                }
                if let Some(inner_63) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionEventInvokeConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctionEventInvokeConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctionEventInvokeConfigs",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionEventInvokeConfigsInput`](crate::input::ListFunctionEventInvokeConfigsInput)
    pub fn builder() -> crate::input::list_function_event_invoke_configs_input::Builder {
        crate::input::list_function_event_invoke_configs_input::Builder::default()
    }
}

/// See [`ListFunctionsInput`](crate::input::ListFunctionsInput)
pub mod list_functions_input {
    /// A builder for [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_region: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<crate::model::FunctionVersion>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn master_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_region = Some(input.into());
            self
        }
        /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
        pub fn set_master_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_region = input;
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn function_version(mut self, input: crate::model::FunctionVersion) -> Self {
            self.function_version = Some(input);
            self
        }
        /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<crate::model::FunctionVersion>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsInput`](crate::input::ListFunctionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionsInput {
                master_region: self.master_region,
                function_version: self.function_version,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionsInputOperationOutputAlias = crate::operation::ListFunctions;
#[doc(hidden)]
pub type ListFunctionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctions`](crate::operation::ListFunctions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2015-03-31/functions").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_64) = &_input.master_region {
                    query.push_kv(
                        "MasterRegion",
                        &aws_smithy_http::query::fmt_string(&inner_64),
                    );
                }
                if let Some(inner_65) = &_input.function_version {
                    query.push_kv(
                        "FunctionVersion",
                        &aws_smithy_http::query::fmt_string(&inner_65),
                    );
                }
                if let Some(inner_66) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_66));
                }
                if let Some(inner_67) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_67).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctions",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
}

/// See [`ListFunctionsByCodeSigningConfigInput`](crate::input::ListFunctionsByCodeSigningConfigInput)
pub mod list_functions_by_code_signing_config_input {
    /// A builder for [`ListFunctionsByCodeSigningConfigInput`](crate::input::ListFunctionsByCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Maximum number of items to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsByCodeSigningConfigInput`](crate::input::ListFunctionsByCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionsByCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionsByCodeSigningConfigInput {
                code_signing_config_arn: self.code_signing_config_arn,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionsByCodeSigningConfigInputOperationOutputAlias =
    crate::operation::ListFunctionsByCodeSigningConfig;
#[doc(hidden)]
pub type ListFunctionsByCodeSigningConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionsByCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctionsByCodeSigningConfig`](crate::operation::ListFunctionsByCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctionsByCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionsByCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_68 = &_input.code_signing_config_arn;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let code_signing_config_arn = aws_smithy_http::label::fmt_string(input_68, false);
                if code_signing_config_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}/functions",
                    CodeSigningConfigArn = code_signing_config_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionsByCodeSigningConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_69) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_69));
                }
                if let Some(inner_70) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_70).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionsByCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctionsByCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctionsByCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionsByCodeSigningConfigInput`](crate::input::ListFunctionsByCodeSigningConfigInput)
    pub fn builder() -> crate::input::list_functions_by_code_signing_config_input::Builder {
        crate::input::list_functions_by_code_signing_config_input::Builder::default()
    }
}

/// See [`ListFunctionUrlConfigsInput`](crate::input::ListFunctionUrlConfigsInput)
pub mod list_function_url_configs_input {
    /// A builder for [`ListFunctionUrlConfigsInput`](crate::input::ListFunctionUrlConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of function URLs to return in the response. Note that <code>ListFunctionUrlConfigs</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of function URLs to return in the response. Note that <code>ListFunctionUrlConfigs</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionUrlConfigsInput`](crate::input::ListFunctionUrlConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionUrlConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionUrlConfigsInput {
                function_name: self.function_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionUrlConfigsInputOperationOutputAlias = crate::operation::ListFunctionUrlConfigs;
#[doc(hidden)]
pub type ListFunctionUrlConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionUrlConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctionUrlConfigs`](crate::operation::ListFunctionUrlConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctionUrlConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionUrlConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.function_name;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_71, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-10-31/functions/{FunctionName}/urls",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionUrlConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_72) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_72));
                }
                if let Some(inner_73) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_73).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionUrlConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctionUrlConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctionUrlConfigs",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionUrlConfigsInput`](crate::input::ListFunctionUrlConfigsInput)
    pub fn builder() -> crate::input::list_function_url_configs_input::Builder {
        crate::input::list_function_url_configs_input::Builder::default()
    }
}

/// See [`ListLayersInput`](crate::input::ListLayersInput)
pub mod list_layers_input {
    /// A builder for [`ListLayersInput`](crate::input::ListLayersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compatible_runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) compatible_architecture: std::option::Option<crate::model::Architecture>,
    }
    impl Builder {
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, input: crate::model::Runtime) -> Self {
            self.compatible_runtime = Some(input);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.compatible_runtime = input;
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of layers to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, input: crate::model::Architecture) -> Self {
            self.compatible_architecture = Some(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.compatible_architecture = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLayersInput`](crate::input::ListLayersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLayersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLayersInput {
                compatible_runtime: self.compatible_runtime,
                marker: self.marker,
                max_items: self.max_items,
                compatible_architecture: self.compatible_architecture,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLayersInputOperationOutputAlias = crate::operation::ListLayers;
#[doc(hidden)]
pub type ListLayersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLayersInput {
    /// Consumes the builder and constructs an Operation<[`ListLayers`](crate::operation::ListLayers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLayers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLayersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2018-10-31/layers").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListLayersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_74) = &_input.compatible_runtime {
                    query.push_kv(
                        "CompatibleRuntime",
                        &aws_smithy_http::query::fmt_string(&inner_74),
                    );
                }
                if let Some(inner_75) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_75));
                }
                if let Some(inner_76) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_76).encode(),
                    );
                }
                if let Some(inner_77) = &_input.compatible_architecture {
                    query.push_kv(
                        "CompatibleArchitecture",
                        &aws_smithy_http::query::fmt_string(&inner_77),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLayersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLayers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLayers",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLayersInput`](crate::input::ListLayersInput)
    pub fn builder() -> crate::input::list_layers_input::Builder {
        crate::input::list_layers_input::Builder::default()
    }
}

/// See [`ListLayerVersionsInput`](crate::input::ListLayerVersionsInput)
pub mod list_layer_versions_input {
    /// A builder for [`ListLayerVersionsInput`](crate::input::ListLayerVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compatible_runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) compatible_architecture: std::option::Option<crate::model::Architecture>,
    }
    impl Builder {
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn compatible_runtime(mut self, input: crate::model::Runtime) -> Self {
            self.compatible_runtime = Some(input);
            self
        }
        /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
        pub fn set_compatible_runtime(
            mut self,
            input: std::option::Option<crate::model::Runtime>,
        ) -> Self {
            self.compatible_runtime = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token returned by a previous call.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of versions to return.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn compatible_architecture(mut self, input: crate::model::Architecture) -> Self {
            self.compatible_architecture = Some(input);
            self
        }
        /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
        pub fn set_compatible_architecture(
            mut self,
            input: std::option::Option<crate::model::Architecture>,
        ) -> Self {
            self.compatible_architecture = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLayerVersionsInput`](crate::input::ListLayerVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLayerVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLayerVersionsInput {
                compatible_runtime: self.compatible_runtime,
                layer_name: self.layer_name,
                marker: self.marker,
                max_items: self.max_items,
                compatible_architecture: self.compatible_architecture,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLayerVersionsInputOperationOutputAlias = crate::operation::ListLayerVersions;
#[doc(hidden)]
pub type ListLayerVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLayerVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLayerVersions`](crate::operation::ListLayerVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLayerVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLayerVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_78 = &_input.layer_name;
                let input_78 = input_78.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_78, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions",
                    LayerName = layer_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListLayerVersionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_79) = &_input.compatible_runtime {
                    query.push_kv(
                        "CompatibleRuntime",
                        &aws_smithy_http::query::fmt_string(&inner_79),
                    );
                }
                if let Some(inner_80) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_80));
                }
                if let Some(inner_81) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_81).encode(),
                    );
                }
                if let Some(inner_82) = &_input.compatible_architecture {
                    query.push_kv(
                        "CompatibleArchitecture",
                        &aws_smithy_http::query::fmt_string(&inner_82),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLayerVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLayerVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLayerVersions",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLayerVersionsInput`](crate::input::ListLayerVersionsInput)
    pub fn builder() -> crate::input::list_layer_versions_input::Builder {
        crate::input::list_layer_versions_input::Builder::default()
    }
}

/// See [`ListProvisionedConcurrencyConfigsInput`](crate::input::ListProvisionedConcurrencyConfigsInput)
pub mod list_provisioned_concurrency_configs_input {
    /// A builder for [`ListProvisionedConcurrencyConfigsInput`](crate::input::ListProvisionedConcurrencyConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Specify a number to limit the number of configurations returned.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProvisionedConcurrencyConfigsInput`](crate::input::ListProvisionedConcurrencyConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProvisionedConcurrencyConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProvisionedConcurrencyConfigsInput {
                function_name: self.function_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProvisionedConcurrencyConfigsInputOperationOutputAlias =
    crate::operation::ListProvisionedConcurrencyConfigs;
#[doc(hidden)]
pub type ListProvisionedConcurrencyConfigsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListProvisionedConcurrencyConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListProvisionedConcurrencyConfigs`](crate::operation::ListProvisionedConcurrencyConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProvisionedConcurrencyConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProvisionedConcurrencyConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_83 = &_input.function_name;
                let input_83 = input_83.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_83, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProvisionedConcurrencyConfigsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                query.push_kv("List", "ALL");
                if let Some(inner_84) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_84));
                }
                if let Some(inner_85) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_85).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProvisionedConcurrencyConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProvisionedConcurrencyConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProvisionedConcurrencyConfigs",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProvisionedConcurrencyConfigsInput`](crate::input::ListProvisionedConcurrencyConfigsInput)
    pub fn builder() -> crate::input::list_provisioned_concurrency_configs_input::Builder {
        crate::input::list_provisioned_concurrency_configs_input::Builder::default()
    }
}

/// See [`ListTagsInput`](crate::input::ListTagsInput)
pub mod list_tags_input {
    /// A builder for [`ListTagsInput`](crate::input::ListTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsInput`](crate::input::ListTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTagsInput {
                resource: self.resource,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsInputOperationOutputAlias = crate::operation::ListTags;
#[doc(hidden)]
pub type ListTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListTags`](crate::operation::ListTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_86 = &_input.resource;
                let input_86 = input_86.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource = aws_smithy_http::label::fmt_string(input_86, false);
                if resource.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2017-03-31/tags/{Resource}", Resource = resource)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTags", "lambda",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsInput`](crate::input::ListTagsInput)
    pub fn builder() -> crate::input::list_tags_input::Builder {
        crate::input::list_tags_input::Builder::default()
    }
}

/// See [`ListVersionsByFunctionInput`](crate::input::ListVersionsByFunctionInput)
pub mod list_versions_by_function_input {
    /// A builder for [`ListVersionsByFunctionInput`](crate::input::ListVersionsByFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVersionsByFunctionInput`](crate::input::ListVersionsByFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVersionsByFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVersionsByFunctionInput {
                function_name: self.function_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVersionsByFunctionInputOperationOutputAlias = crate::operation::ListVersionsByFunction;
#[doc(hidden)]
pub type ListVersionsByFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVersionsByFunctionInput {
    /// Consumes the builder and constructs an Operation<[`ListVersionsByFunction`](crate::operation::ListVersionsByFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVersionsByFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVersionsByFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_87 = &_input.function_name;
                let input_87 = input_87.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_87, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/versions",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVersionsByFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_88) = &_input.marker {
                    query.push_kv("Marker", &aws_smithy_http::query::fmt_string(&inner_88));
                }
                if let Some(inner_89) = &_input.max_items {
                    query.push_kv(
                        "MaxItems",
                        aws_smithy_types::primitive::Encoder::from(*inner_89).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVersionsByFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVersionsByFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVersionsByFunction",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVersionsByFunctionInput`](crate::input::ListVersionsByFunctionInput)
    pub fn builder() -> crate::input::list_versions_by_function_input::Builder {
        crate::input::list_versions_by_function_input::Builder::default()
    }
}

/// See [`PublishLayerVersionInput`](crate::input::PublishLayerVersionInput)
pub mod publish_layer_version_input {
    /// A builder for [`PublishLayerVersionInput`](crate::input::PublishLayerVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<crate::model::LayerVersionContentInput>,
        pub(crate) compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        pub(crate) license_info: std::option::Option<std::string::String>,
        pub(crate) compatible_architectures:
            std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The description of the version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The function layer archive.</p>
        pub fn content(mut self, input: crate::model::LayerVersionContentInput) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The function layer archive.</p>
        pub fn set_content(
            mut self,
            input: std::option::Option<crate::model::LayerVersionContentInput>,
        ) -> Self {
            self.content = input;
            self
        }
        /// Appends an item to `compatible_runtimes`.
        ///
        /// To override the contents of this collection use [`set_compatible_runtimes`](Self::set_compatible_runtimes).
        ///
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
        pub fn compatible_runtimes(mut self, input: crate::model::Runtime) -> Self {
            let mut v = self.compatible_runtimes.unwrap_or_default();
            v.push(input);
            self.compatible_runtimes = Some(v);
            self
        }
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
        pub fn set_compatible_runtimes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
        ) -> Self {
            self.compatible_runtimes = input;
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
        /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
        /// <li> <p>The full text of the license.</p> </li>
        /// </ul>
        pub fn license_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_info = Some(input.into());
            self
        }
        /// <p>The layer's software license. It can be any of the following:</p>
        /// <ul>
        /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
        /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
        /// <li> <p>The full text of the license.</p> </li>
        /// </ul>
        pub fn set_license_info(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_info = input;
            self
        }
        /// Appends an item to `compatible_architectures`.
        ///
        /// To override the contents of this collection use [`set_compatible_architectures`](Self::set_compatible_architectures).
        ///
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn compatible_architectures(mut self, input: crate::model::Architecture) -> Self {
            let mut v = self.compatible_architectures.unwrap_or_default();
            v.push(input);
            self.compatible_architectures = Some(v);
            self
        }
        /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
        pub fn set_compatible_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.compatible_architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishLayerVersionInput`](crate::input::PublishLayerVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishLayerVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishLayerVersionInput {
                layer_name: self.layer_name,
                description: self.description,
                content: self.content,
                compatible_runtimes: self.compatible_runtimes,
                license_info: self.license_info,
                compatible_architectures: self.compatible_architectures,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishLayerVersionInputOperationOutputAlias = crate::operation::PublishLayerVersion;
#[doc(hidden)]
pub type PublishLayerVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PublishLayerVersionInput {
    /// Consumes the builder and constructs an Operation<[`PublishLayerVersion`](crate::operation::PublishLayerVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishLayerVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PublishLayerVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_90 = &_input.layer_name;
                let input_90 = input_90.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_90, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions",
                    LayerName = layer_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PublishLayerVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_publish_layer_version(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishLayerVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishLayerVersion",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PublishLayerVersionInput`](crate::input::PublishLayerVersionInput)
    pub fn builder() -> crate::input::publish_layer_version_input::Builder {
        crate::input::publish_layer_version_input::Builder::default()
    }
}

/// See [`PublishVersionInput`](crate::input::PublishVersionInput)
pub mod publish_version_input {
    /// A builder for [`PublishVersionInput`](crate::input::PublishVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) code_sha256: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
        pub fn code_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_sha256 = Some(input.into());
            self
        }
        /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
        pub fn set_code_sha256(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code_sha256 = input;
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the version to override the description in the function configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PublishVersionInput`](crate::input::PublishVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PublishVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PublishVersionInput {
                function_name: self.function_name,
                code_sha256: self.code_sha256,
                description: self.description,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type PublishVersionInputOperationOutputAlias = crate::operation::PublishVersion;
#[doc(hidden)]
pub type PublishVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PublishVersionInput {
    /// Consumes the builder and constructs an Operation<[`PublishVersion`](crate::operation::PublishVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PublishVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PublishVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.function_name;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_91, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/versions",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PublishVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_publish_version(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PublishVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PublishVersion",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PublishVersionInput`](crate::input::PublishVersionInput)
    pub fn builder() -> crate::input::publish_version_input::Builder {
        crate::input::publish_version_input::Builder::default()
    }
}

/// See [`PutFunctionCodeSigningConfigInput`](crate::input::PutFunctionCodeSigningConfigInput)
pub mod put_function_code_signing_config_input {
    /// A builder for [`PutFunctionCodeSigningConfigInput`](crate::input::PutFunctionCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionCodeSigningConfigInput`](crate::input::PutFunctionCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFunctionCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFunctionCodeSigningConfigInput {
                code_signing_config_arn: self.code_signing_config_arn,
                function_name: self.function_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFunctionCodeSigningConfigInputOperationOutputAlias =
    crate::operation::PutFunctionCodeSigningConfig;
#[doc(hidden)]
pub type PutFunctionCodeSigningConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutFunctionCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`PutFunctionCodeSigningConfig`](crate::operation::PutFunctionCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFunctionCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutFunctionCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_92 = &_input.function_name;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_92, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-06-30/functions/{FunctionName}/code-signing-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutFunctionCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_function_code_signing_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFunctionCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFunctionCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutFunctionCodeSigningConfigInput`](crate::input::PutFunctionCodeSigningConfigInput)
    pub fn builder() -> crate::input::put_function_code_signing_config_input::Builder {
        crate::input::put_function_code_signing_config_input::Builder::default()
    }
}

/// See [`PutFunctionConcurrencyInput`](crate::input::PutFunctionConcurrencyInput)
pub mod put_function_concurrency_input {
    /// A builder for [`PutFunctionConcurrencyInput`](crate::input::PutFunctionConcurrencyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) reserved_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn reserved_concurrent_executions(mut self, input: i32) -> Self {
            self.reserved_concurrent_executions = Some(input);
            self
        }
        /// <p>The number of simultaneous executions to reserve for the function.</p>
        pub fn set_reserved_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reserved_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionConcurrencyInput`](crate::input::PutFunctionConcurrencyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFunctionConcurrencyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFunctionConcurrencyInput {
                function_name: self.function_name,
                reserved_concurrent_executions: self.reserved_concurrent_executions,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFunctionConcurrencyInputOperationOutputAlias = crate::operation::PutFunctionConcurrency;
#[doc(hidden)]
pub type PutFunctionConcurrencyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutFunctionConcurrencyInput {
    /// Consumes the builder and constructs an Operation<[`PutFunctionConcurrency`](crate::operation::PutFunctionConcurrency)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFunctionConcurrency,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutFunctionConcurrencyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_93 = &_input.function_name;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_93, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2017-10-31/functions/{FunctionName}/concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutFunctionConcurrencyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_function_concurrency(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFunctionConcurrency::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFunctionConcurrency",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutFunctionConcurrencyInput`](crate::input::PutFunctionConcurrencyInput)
    pub fn builder() -> crate::input::put_function_concurrency_input::Builder {
        crate::input::put_function_concurrency_input::Builder::default()
    }
}

/// See [`PutFunctionEventInvokeConfigInput`](crate::input::PutFunctionEventInvokeConfigInput)
pub mod put_function_event_invoke_config_input {
    /// A builder for [`PutFunctionEventInvokeConfigInput`](crate::input::PutFunctionEventInvokeConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFunctionEventInvokeConfigInput`](crate::input::PutFunctionEventInvokeConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFunctionEventInvokeConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFunctionEventInvokeConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFunctionEventInvokeConfigInputOperationOutputAlias =
    crate::operation::PutFunctionEventInvokeConfig;
#[doc(hidden)]
pub type PutFunctionEventInvokeConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutFunctionEventInvokeConfigInput {
    /// Consumes the builder and constructs an Operation<[`PutFunctionEventInvokeConfig`](crate::operation::PutFunctionEventInvokeConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFunctionEventInvokeConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutFunctionEventInvokeConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_94 = &_input.function_name;
                let input_94 = input_94.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_94, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-25/functions/{FunctionName}/event-invoke-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutFunctionEventInvokeConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_95) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_95));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutFunctionEventInvokeConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_function_event_invoke_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFunctionEventInvokeConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFunctionEventInvokeConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutFunctionEventInvokeConfigInput`](crate::input::PutFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::put_function_event_invoke_config_input::Builder {
        crate::input::put_function_event_invoke_config_input::Builder::default()
    }
}

/// See [`PutProvisionedConcurrencyConfigInput`](crate::input::PutProvisionedConcurrencyConfigInput)
pub mod put_provisioned_concurrency_config_input {
    /// A builder for [`PutProvisionedConcurrencyConfigInput`](crate::input::PutProvisionedConcurrencyConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) provisioned_concurrent_executions: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn provisioned_concurrent_executions(mut self, input: i32) -> Self {
            self.provisioned_concurrent_executions = Some(input);
            self
        }
        /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
        pub fn set_provisioned_concurrent_executions(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.provisioned_concurrent_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProvisionedConcurrencyConfigInput`](crate::input::PutProvisionedConcurrencyConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutProvisionedConcurrencyConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutProvisionedConcurrencyConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
                provisioned_concurrent_executions: self.provisioned_concurrent_executions,
            })
        }
    }
}
#[doc(hidden)]
pub type PutProvisionedConcurrencyConfigInputOperationOutputAlias =
    crate::operation::PutProvisionedConcurrencyConfig;
#[doc(hidden)]
pub type PutProvisionedConcurrencyConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutProvisionedConcurrencyConfigInput {
    /// Consumes the builder and constructs an Operation<[`PutProvisionedConcurrencyConfig`](crate::operation::PutProvisionedConcurrencyConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutProvisionedConcurrencyConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutProvisionedConcurrencyConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_96 = &_input.function_name;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_96, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::PutProvisionedConcurrencyConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_97) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_97));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutProvisionedConcurrencyConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_provisioned_concurrency_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutProvisionedConcurrencyConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutProvisionedConcurrencyConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutProvisionedConcurrencyConfigInput`](crate::input::PutProvisionedConcurrencyConfigInput)
    pub fn builder() -> crate::input::put_provisioned_concurrency_config_input::Builder {
        crate::input::put_provisioned_concurrency_config_input::Builder::default()
    }
}

/// See [`RemoveLayerVersionPermissionInput`](crate::input::RemoveLayerVersionPermissionInput)
pub mod remove_layer_version_permission_input {
    /// A builder for [`RemoveLayerVersionPermissionInput`](crate::input::RemoveLayerVersionPermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) layer_name: std::option::Option<std::string::String>,
        pub(crate) version_number: std::option::Option<i64>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn layer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.layer_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
        pub fn set_layer_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.layer_name = input;
            self
        }
        /// <p>The version number.</p>
        pub fn version_number(mut self, input: i64) -> Self {
            self.version_number = Some(input);
            self
        }
        /// <p>The version number.</p>
        pub fn set_version_number(mut self, input: std::option::Option<i64>) -> Self {
            self.version_number = input;
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>The identifier that was specified when the statement was added.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveLayerVersionPermissionInput`](crate::input::RemoveLayerVersionPermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveLayerVersionPermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveLayerVersionPermissionInput {
                layer_name: self.layer_name,
                version_number: self.version_number.unwrap_or_default(),
                statement_id: self.statement_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveLayerVersionPermissionInputOperationOutputAlias =
    crate::operation::RemoveLayerVersionPermission;
#[doc(hidden)]
pub type RemoveLayerVersionPermissionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RemoveLayerVersionPermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemoveLayerVersionPermission`](crate::operation::RemoveLayerVersionPermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveLayerVersionPermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemoveLayerVersionPermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_98 = &_input.layer_name;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let layer_name = aws_smithy_http::label::fmt_string(input_98, false);
                if layer_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "layer_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_99 = &_input.version_number;
                let mut version_number_encoder =
                    aws_smithy_types::primitive::Encoder::from(*input_99);
                let version_number = version_number_encoder.encode();
                if version_number.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "version_number",
                        details: "cannot be empty or unset",
                    });
                }
                let input_100 = &_input.statement_id;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let statement_id = aws_smithy_http::label::fmt_string(input_100, false);
                if statement_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}",
                    LayerName = layer_name,
                    VersionNumber = version_number,
                    StatementId = statement_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::RemoveLayerVersionPermissionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_101) = &_input.revision_id {
                    query.push_kv(
                        "RevisionId",
                        &aws_smithy_http::query::fmt_string(&inner_101),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemoveLayerVersionPermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveLayerVersionPermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveLayerVersionPermission",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemoveLayerVersionPermissionInput`](crate::input::RemoveLayerVersionPermissionInput)
    pub fn builder() -> crate::input::remove_layer_version_permission_input::Builder {
        crate::input::remove_layer_version_permission_input::Builder::default()
    }
}

/// See [`RemovePermissionInput`](crate::input::RemovePermissionInput)
pub mod remove_permission_input {
    /// A builder for [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) statement_id: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_id = Some(input.into());
            self
        }
        /// <p>Statement ID of the permission to remove.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.statement_id = input;
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemovePermissionInput`](crate::input::RemovePermissionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemovePermissionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemovePermissionInput {
                function_name: self.function_name,
                statement_id: self.statement_id,
                qualifier: self.qualifier,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RemovePermissionInputOperationOutputAlias = crate::operation::RemovePermission;
#[doc(hidden)]
pub type RemovePermissionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RemovePermissionInput {
    /// Consumes the builder and constructs an Operation<[`RemovePermission`](crate::operation::RemovePermission)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemovePermission,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RemovePermissionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_102 = &_input.function_name;
                let input_102 = input_102.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_102, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_103 = &_input.statement_id;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let statement_id = aws_smithy_http::label::fmt_string(input_103, false);
                if statement_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "statement_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
                    FunctionName = function_name,
                    StatementId = statement_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::RemovePermissionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_104) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_104));
                }
                if let Some(inner_105) = &_input.revision_id {
                    query.push_kv(
                        "RevisionId",
                        &aws_smithy_http::query::fmt_string(&inner_105),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RemovePermissionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemovePermission::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemovePermission",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RemovePermissionInput`](crate::input::RemovePermissionInput)
    pub fn builder() -> crate::input::remove_permission_input::Builder {
        crate::input::remove_permission_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the function.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to apply to the function.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource: self.resource,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_106 = &_input.resource;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource = aws_smithy_http::label::fmt_string(input_106, false);
                if resource.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2017-03-31/tags/{Resource}", Resource = resource)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The function's Amazon Resource Name (ARN).</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the function.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource: self.resource,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_107 = &_input.resource;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource = aws_smithy_http::label::fmt_string(input_107, false);
                if resource.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/2017-03-31/tags/{Resource}", Resource = resource)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_108) = &_input.tag_keys {
                    for inner_109 in inner_108 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_109));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAliasInput`](crate::input::UpdateAliasInput)
pub mod update_alias_input {
    /// A builder for [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The name of the alias.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the alias.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The function version that the alias invokes.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>A description of the alias.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the alias.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn routing_config(mut self, input: crate::model::AliasRoutingConfiguration) -> Self {
            self.routing_config = Some(input);
            self
        }
        /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
        pub fn set_routing_config(
            mut self,
            input: std::option::Option<crate::model::AliasRoutingConfiguration>,
        ) -> Self {
            self.routing_config = input;
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAliasInput`](crate::input::UpdateAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAliasInput {
                function_name: self.function_name,
                name: self.name,
                function_version: self.function_version,
                description: self.description,
                routing_config: self.routing_config,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAliasInputOperationOutputAlias = crate::operation::UpdateAlias;
#[doc(hidden)]
pub type UpdateAliasInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAliasInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAlias`](crate::operation::UpdateAlias)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAlias,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAliasInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_110 = &_input.function_name;
                let input_110 = input_110.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_110, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_111 = &_input.name;
                let input_111 = input_111.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_111, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
                    FunctionName = function_name,
                    Name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAliasInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_alias(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAlias",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAliasInput`](crate::input::UpdateAliasInput)
    pub fn builder() -> crate::input::update_alias_input::Builder {
        crate::input::update_alias_input::Builder::default()
    }
}

/// See [`UpdateCodeSigningConfigInput`](crate::input::UpdateCodeSigningConfigInput)
pub mod update_code_signing_config_input {
    /// A builder for [`UpdateCodeSigningConfigInput`](crate::input::UpdateCodeSigningConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_signing_config_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
        pub(crate) code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
    }
    impl Builder {
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn code_signing_config_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.code_signing_config_arn = Some(input.into());
            self
        }
        /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
        pub fn set_code_signing_config_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.code_signing_config_arn = input;
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Descriptive name for this code signing configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn allowed_publishers(mut self, input: crate::model::AllowedPublishers) -> Self {
            self.allowed_publishers = Some(input);
            self
        }
        /// <p>Signing profiles for this code signing configuration.</p>
        pub fn set_allowed_publishers(
            mut self,
            input: std::option::Option<crate::model::AllowedPublishers>,
        ) -> Self {
            self.allowed_publishers = input;
            self
        }
        /// <p>The code signing policy.</p>
        pub fn code_signing_policies(mut self, input: crate::model::CodeSigningPolicies) -> Self {
            self.code_signing_policies = Some(input);
            self
        }
        /// <p>The code signing policy.</p>
        pub fn set_code_signing_policies(
            mut self,
            input: std::option::Option<crate::model::CodeSigningPolicies>,
        ) -> Self {
            self.code_signing_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCodeSigningConfigInput`](crate::input::UpdateCodeSigningConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCodeSigningConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCodeSigningConfigInput {
                code_signing_config_arn: self.code_signing_config_arn,
                description: self.description,
                allowed_publishers: self.allowed_publishers,
                code_signing_policies: self.code_signing_policies,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCodeSigningConfigInputOperationOutputAlias =
    crate::operation::UpdateCodeSigningConfig;
#[doc(hidden)]
pub type UpdateCodeSigningConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCodeSigningConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCodeSigningConfig`](crate::operation::UpdateCodeSigningConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCodeSigningConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateCodeSigningConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_112 = &_input.code_signing_config_arn;
                let input_112 = input_112.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let code_signing_config_arn = aws_smithy_http::label::fmt_string(input_112, false);
                if code_signing_config_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "code_signing_config_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-04-22/code-signing-configs/{CodeSigningConfigArn}",
                    CodeSigningConfigArn = code_signing_config_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateCodeSigningConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_code_signing_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCodeSigningConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCodeSigningConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateCodeSigningConfigInput`](crate::input::UpdateCodeSigningConfigInput)
    pub fn builder() -> crate::input::update_code_signing_config_input::Builder {
        crate::input::update_code_signing_config_input::Builder::default()
    }
}

/// See [`UpdateEventSourceMappingInput`](crate::input::UpdateEventSourceMappingInput)
pub mod update_event_source_mapping_input {
    /// A builder for [`UpdateEventSourceMappingInput`](crate::input::UpdateEventSourceMappingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uuid: std::option::Option<std::string::String>,
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) batch_size: std::option::Option<i32>,
        pub(crate) filter_criteria: std::option::Option<crate::model::FilterCriteria>,
        pub(crate) maximum_batching_window_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
        pub(crate) maximum_record_age_in_seconds: std::option::Option<i32>,
        pub(crate) bisect_batch_on_function_error: std::option::Option<bool>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) parallelization_factor: std::option::Option<i32>,
        pub(crate) source_access_configurations:
            std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        pub(crate) tumbling_window_in_seconds: std::option::Option<i32>,
        pub(crate) function_response_types:
            std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
    }
    impl Builder {
        /// <p>The identifier of the event source mapping.</p>
        pub fn uuid(mut self, input: impl Into<std::string::String>) -> Self {
            self.uuid = Some(input.into());
            self
        }
        /// <p>The identifier of the event source mapping.</p>
        pub fn set_uuid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uuid = input;
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
        /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
        /// <p>Default: True</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn batch_size(mut self, input: i32) -> Self {
            self.batch_size = Some(input);
            self
        }
        /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
        /// <ul>
        /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
        /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
        /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
        /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
        /// </ul>
        pub fn set_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.batch_size = input;
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn filter_criteria(mut self, input: crate::model::FilterCriteria) -> Self {
            self.filter_criteria = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::FilterCriteria>,
        ) -> Self {
            self.filter_criteria = input;
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn maximum_batching_window_in_seconds(mut self, input: i32) -> Self {
            self.maximum_batching_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
        /// <p>Default: 0</p>
        /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
        pub fn set_maximum_batching_window_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_batching_window_in_seconds = input;
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn maximum_record_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_record_age_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
        pub fn set_maximum_record_age_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_record_age_in_seconds = input;
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn bisect_batch_on_function_error(mut self, input: bool) -> Self {
            self.bisect_batch_on_function_error = Some(input);
            self
        }
        /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
        pub fn set_bisect_batch_on_function_error(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.bisect_batch_on_function_error = input;
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn parallelization_factor(mut self, input: i32) -> Self {
            self.parallelization_factor = Some(input);
            self
        }
        /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
        pub fn set_parallelization_factor(mut self, input: std::option::Option<i32>) -> Self {
            self.parallelization_factor = input;
            self
        }
        /// Appends an item to `source_access_configurations`.
        ///
        /// To override the contents of this collection use [`set_source_access_configurations`](Self::set_source_access_configurations).
        ///
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn source_access_configurations(
            mut self,
            input: crate::model::SourceAccessConfiguration,
        ) -> Self {
            let mut v = self.source_access_configurations.unwrap_or_default();
            v.push(input);
            self.source_access_configurations = Some(v);
            self
        }
        /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
        pub fn set_source_access_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
        ) -> Self {
            self.source_access_configurations = input;
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn tumbling_window_in_seconds(mut self, input: i32) -> Self {
            self.tumbling_window_in_seconds = Some(input);
            self
        }
        /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
        pub fn set_tumbling_window_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.tumbling_window_in_seconds = input;
            self
        }
        /// Appends an item to `function_response_types`.
        ///
        /// To override the contents of this collection use [`set_function_response_types`](Self::set_function_response_types).
        ///
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn function_response_types(
            mut self,
            input: crate::model::FunctionResponseType,
        ) -> Self {
            let mut v = self.function_response_types.unwrap_or_default();
            v.push(input);
            self.function_response_types = Some(v);
            self
        }
        /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
        pub fn set_function_response_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
        ) -> Self {
            self.function_response_types = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEventSourceMappingInput`](crate::input::UpdateEventSourceMappingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEventSourceMappingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEventSourceMappingInput {
                uuid: self.uuid,
                function_name: self.function_name,
                enabled: self.enabled,
                batch_size: self.batch_size,
                filter_criteria: self.filter_criteria,
                maximum_batching_window_in_seconds: self.maximum_batching_window_in_seconds,
                destination_config: self.destination_config,
                maximum_record_age_in_seconds: self.maximum_record_age_in_seconds,
                bisect_batch_on_function_error: self.bisect_batch_on_function_error,
                maximum_retry_attempts: self.maximum_retry_attempts,
                parallelization_factor: self.parallelization_factor,
                source_access_configurations: self.source_access_configurations,
                tumbling_window_in_seconds: self.tumbling_window_in_seconds,
                function_response_types: self.function_response_types,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEventSourceMappingInputOperationOutputAlias =
    crate::operation::UpdateEventSourceMapping;
#[doc(hidden)]
pub type UpdateEventSourceMappingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEventSourceMappingInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEventSourceMapping`](crate::operation::UpdateEventSourceMapping)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEventSourceMapping,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEventSourceMappingInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_113 = &_input.uuid;
                let input_113 = input_113.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    },
                )?;
                let uuid = aws_smithy_http::label::fmt_string(input_113, false);
                if uuid.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "uuid",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/event-source-mappings/{UUID}",
                    UUID = uuid
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEventSourceMappingInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_event_source_mapping(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEventSourceMapping::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEventSourceMapping",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEventSourceMappingInput`](crate::input::UpdateEventSourceMappingInput)
    pub fn builder() -> crate::input::update_event_source_mapping_input::Builder {
        crate::input::update_event_source_mapping_input::Builder::default()
    }
}

/// See [`UpdateFunctionCodeInput`](crate::input::UpdateFunctionCodeInput)
pub mod update_function_code_input {
    /// A builder for [`UpdateFunctionCodeInput`](crate::input::UpdateFunctionCodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) zip_file: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_key: std::option::Option<std::string::String>,
        pub(crate) s3_object_version: std::option::Option<std::string::String>,
        pub(crate) image_uri: std::option::Option<std::string::String>,
        pub(crate) publish: std::option::Option<bool>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn zip_file(mut self, input: aws_smithy_types::Blob) -> Self {
            self.zip_file = Some(input);
            self
        }
        /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn set_zip_file(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.zip_file = input;
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn s3_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key = Some(input.into());
            self
        }
        /// <p>The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.</p>
        pub fn set_s3_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_key = input;
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn s3_object_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_object_version = Some(input.into());
            self
        }
        /// <p>For versioned objects, the version of the deployment package object to use.</p>
        pub fn set_s3_object_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_object_version = input;
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.</p>
        pub fn image_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_uri = Some(input.into());
            self
        }
        /// <p>URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.</p>
        pub fn set_image_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_uri = input;
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
        pub fn publish(mut self, input: bool) -> Self {
            self.publish = Some(input);
            self
        }
        /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
        pub fn set_publish(mut self, input: std::option::Option<bool>) -> Self {
            self.publish = input;
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `architectures`.
        ///
        /// To override the contents of this collection use [`set_architectures`](Self::set_architectures).
        ///
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn architectures(mut self, input: crate::model::Architecture) -> Self {
            let mut v = self.architectures.unwrap_or_default();
            v.push(input);
            self.architectures = Some(v);
            self
        }
        /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
        pub fn set_architectures(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
        ) -> Self {
            self.architectures = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionCodeInput`](crate::input::UpdateFunctionCodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionCodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionCodeInput {
                function_name: self.function_name,
                zip_file: self.zip_file,
                s3_bucket: self.s3_bucket,
                s3_key: self.s3_key,
                s3_object_version: self.s3_object_version,
                image_uri: self.image_uri,
                publish: self.publish.unwrap_or_default(),
                dry_run: self.dry_run.unwrap_or_default(),
                revision_id: self.revision_id,
                architectures: self.architectures,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionCodeInputOperationOutputAlias = crate::operation::UpdateFunctionCode;
#[doc(hidden)]
pub type UpdateFunctionCodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionCodeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunctionCode`](crate::operation::UpdateFunctionCode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunctionCode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionCodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_114 = &_input.function_name;
                let input_114 = input_114.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_114, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/code",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionCodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function_code(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunctionCode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunctionCode",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionCodeInput`](crate::input::UpdateFunctionCodeInput)
    pub fn builder() -> crate::input::update_function_code_input::Builder {
        crate::input::update_function_code_input::Builder::default()
    }
}

/// See [`UpdateFunctionConfigurationInput`](crate::input::UpdateFunctionConfigurationInput)
pub mod update_function_configuration_input {
    /// A builder for [`UpdateFunctionConfigurationInput`](crate::input::UpdateFunctionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) role: std::option::Option<std::string::String>,
        pub(crate) handler: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) memory_size: std::option::Option<i32>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) environment: std::option::Option<crate::model::Environment>,
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tracing_config: std::option::Option<crate::model::TracingConfig>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) layers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_system_configs:
            std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        pub(crate) image_config: std::option::Option<crate::model::ImageConfig>,
        pub(crate) ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn role(mut self, input: impl Into<std::string::String>) -> Self {
            self.role = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role = input;
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn handler(mut self, input: impl Into<std::string::String>) -> Self {
            self.handler = Some(input.into());
            self
        }
        /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
        pub fn set_handler(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.handler = input;
            self
        }
        /// <p>A description of the function.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the function.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn memory_size(mut self, input: i32) -> Self {
            self.memory_size = Some(input);
            self
        }
        /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
        pub fn set_memory_size(mut self, input: std::option::Option<i32>) -> Self {
            self.memory_size = input;
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn environment(mut self, input: crate::model::Environment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Environment variables that are accessible from function code during execution.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::Environment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn tracing_config(mut self, input: crate::model::TracingConfig) -> Self {
            self.tracing_config = Some(input);
            self
        }
        /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
        pub fn set_tracing_config(
            mut self,
            input: std::option::Option<crate::model::TracingConfig>,
        ) -> Self {
            self.tracing_config = input;
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `layers`.
        ///
        /// To override the contents of this collection use [`set_layers`](Self::set_layers).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn layers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.layers.unwrap_or_default();
            v.push(input.into());
            self.layers = Some(v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
        pub fn set_layers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.layers = input;
            self
        }
        /// Appends an item to `file_system_configs`.
        ///
        /// To override the contents of this collection use [`set_file_system_configs`](Self::set_file_system_configs).
        ///
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn file_system_configs(mut self, input: crate::model::FileSystemConfig) -> Self {
            let mut v = self.file_system_configs.unwrap_or_default();
            v.push(input);
            self.file_system_configs = Some(v);
            self
        }
        /// <p>Connection settings for an Amazon EFS file system.</p>
        pub fn set_file_system_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
        ) -> Self {
            self.file_system_configs = input;
            self
        }
        /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
        pub fn image_config(mut self, input: crate::model::ImageConfig) -> Self {
            self.image_config = Some(input);
            self
        }
        /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
        pub fn set_image_config(
            mut self,
            input: std::option::Option<crate::model::ImageConfig>,
        ) -> Self {
            self.image_config = input;
            self
        }
        /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
        pub fn ephemeral_storage(mut self, input: crate::model::EphemeralStorage) -> Self {
            self.ephemeral_storage = Some(input);
            self
        }
        /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
        pub fn set_ephemeral_storage(
            mut self,
            input: std::option::Option<crate::model::EphemeralStorage>,
        ) -> Self {
            self.ephemeral_storage = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionConfigurationInput`](crate::input::UpdateFunctionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionConfigurationInput {
                function_name: self.function_name,
                role: self.role,
                handler: self.handler,
                description: self.description,
                timeout: self.timeout,
                memory_size: self.memory_size,
                vpc_config: self.vpc_config,
                environment: self.environment,
                runtime: self.runtime,
                dead_letter_config: self.dead_letter_config,
                kms_key_arn: self.kms_key_arn,
                tracing_config: self.tracing_config,
                revision_id: self.revision_id,
                layers: self.layers,
                file_system_configs: self.file_system_configs,
                image_config: self.image_config,
                ephemeral_storage: self.ephemeral_storage,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionConfigurationInputOperationOutputAlias =
    crate::operation::UpdateFunctionConfiguration;
#[doc(hidden)]
pub type UpdateFunctionConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunctionConfiguration`](crate::operation::UpdateFunctionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunctionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_115 = &_input.function_name;
                let input_115 = input_115.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_115, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2015-03-31/functions/{FunctionName}/configuration",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunctionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunctionConfiguration",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionConfigurationInput`](crate::input::UpdateFunctionConfigurationInput)
    pub fn builder() -> crate::input::update_function_configuration_input::Builder {
        crate::input::update_function_configuration_input::Builder::default()
    }
}

/// See [`UpdateFunctionEventInvokeConfigInput`](crate::input::UpdateFunctionEventInvokeConfigInput)
pub mod update_function_event_invoke_config_input {
    /// A builder for [`UpdateFunctionEventInvokeConfigInput`](crate::input::UpdateFunctionEventInvokeConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
        pub(crate) destination_config: std::option::Option<crate::model::DestinationConfig>,
    }
    impl Builder {
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function, version, or alias.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>A version number or alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of times to retry when the function returns an error.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn destination_config(mut self, input: crate::model::DestinationConfig) -> Self {
            self.destination_config = Some(input);
            self
        }
        /// <p>A destination for events after they have been sent to a function for processing.</p>
        /// <p class="title"> <b>Destinations</b> </p>
        /// <ul>
        /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
        /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
        /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
        /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
        /// </ul>
        pub fn set_destination_config(
            mut self,
            input: std::option::Option<crate::model::DestinationConfig>,
        ) -> Self {
            self.destination_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionEventInvokeConfigInput`](crate::input::UpdateFunctionEventInvokeConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionEventInvokeConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionEventInvokeConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
                destination_config: self.destination_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionEventInvokeConfigInputOperationOutputAlias =
    crate::operation::UpdateFunctionEventInvokeConfig;
#[doc(hidden)]
pub type UpdateFunctionEventInvokeConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionEventInvokeConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunctionEventInvokeConfig`](crate::operation::UpdateFunctionEventInvokeConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunctionEventInvokeConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionEventInvokeConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_116 = &_input.function_name;
                let input_116 = input_116.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_116, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2019-09-25/functions/{FunctionName}/event-invoke-config",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateFunctionEventInvokeConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_117) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_117));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionEventInvokeConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function_event_invoke_config(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunctionEventInvokeConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunctionEventInvokeConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionEventInvokeConfigInput`](crate::input::UpdateFunctionEventInvokeConfigInput)
    pub fn builder() -> crate::input::update_function_event_invoke_config_input::Builder {
        crate::input::update_function_event_invoke_config_input::Builder::default()
    }
}

/// See [`UpdateFunctionUrlConfigInput`](crate::input::UpdateFunctionUrlConfigInput)
pub mod update_function_url_config_input {
    /// A builder for [`UpdateFunctionUrlConfigInput`](crate::input::UpdateFunctionUrlConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_name: std::option::Option<std::string::String>,
        pub(crate) qualifier: std::option::Option<std::string::String>,
        pub(crate) auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
        pub(crate) cors: std::option::Option<crate::model::Cors>,
    }
    impl Builder {
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn function_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_name = Some(input.into());
            self
        }
        /// <p>The name of the Lambda function.</p>
        /// <p class="title"> <b>Name formats</b> </p>
        /// <ul>
        /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
        /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
        /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
        /// </ul>
        /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
        pub fn set_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_name = input;
            self
        }
        /// <p>The alias name.</p>
        pub fn qualifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.qualifier = Some(input.into());
            self
        }
        /// <p>The alias name.</p>
        pub fn set_qualifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.qualifier = input;
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn auth_type(mut self, input: crate::model::FunctionUrlAuthType) -> Self {
            self.auth_type = Some(input);
            self
        }
        /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
        pub fn set_auth_type(
            mut self,
            input: std::option::Option<crate::model::FunctionUrlAuthType>,
        ) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
        pub fn cors(mut self, input: crate::model::Cors) -> Self {
            self.cors = Some(input);
            self
        }
        /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
        pub fn set_cors(mut self, input: std::option::Option<crate::model::Cors>) -> Self {
            self.cors = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionUrlConfigInput`](crate::input::UpdateFunctionUrlConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionUrlConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionUrlConfigInput {
                function_name: self.function_name,
                qualifier: self.qualifier,
                auth_type: self.auth_type,
                cors: self.cors,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionUrlConfigInputOperationOutputAlias =
    crate::operation::UpdateFunctionUrlConfig;
#[doc(hidden)]
pub type UpdateFunctionUrlConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionUrlConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunctionUrlConfig`](crate::operation::UpdateFunctionUrlConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunctionUrlConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionUrlConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_118 = &_input.function_name;
                let input_118 = input_118.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_name = aws_smithy_http::label::fmt_string(input_118, false);
                if function_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2021-10-31/functions/{FunctionName}/url",
                    FunctionName = function_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateFunctionUrlConfigInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_119) = &_input.qualifier {
                    query.push_kv("Qualifier", &aws_smithy_http::query::fmt_string(&inner_119));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionUrlConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function_url_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunctionUrlConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunctionUrlConfig",
            "lambda",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionUrlConfigInput`](crate::input::UpdateFunctionUrlConfigInput)
    pub fn builder() -> crate::input::update_function_url_config_input::Builder {
        crate::input::update_function_url_config_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
    /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
    pub cors: std::option::Option<crate::model::Cors>,
}
impl UpdateFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub fn auth_type(&self) -> std::option::Option<&crate::model::FunctionUrlAuthType> {
        self.auth_type.as_ref()
    }
    /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
    pub fn cors(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors.as_ref()
    }
}
impl std::fmt::Debug for UpdateFunctionUrlConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionUrlConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("cors", &self.cors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title"> <b>Destinations</b> </p>
    /// <ul>
    /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
    /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
    /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
    /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl UpdateFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title"> <b>Destinations</b> </p>
    /// <ul>
    /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
    /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
    /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
    /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateFunctionEventInvokeConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionEventInvokeConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionConfigurationInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>A description of the function.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    pub memory_size: std::option::Option<i32>,
    /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Environment variables that are accessible from function code during execution.</p>
    pub environment: std::option::Option<crate::model::Environment>,
    /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfig>,
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    pub layers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Connection settings for an Amazon EFS file system.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
    pub image_config: std::option::Option<crate::model::ImageConfig>,
    /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
}
impl UpdateFunctionConfigurationInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>A description of the function.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Environment variables that are accessible from function code during execution.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
    /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfig> {
        self.tracing_config.as_ref()
    }
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    pub fn layers(&self) -> std::option::Option<&[std::string::String]> {
        self.layers.as_deref()
    }
    /// <p>Connection settings for an Amazon EFS file system.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p> <a href="https://docs.aws.amazon.com/lambda/latest/dg/images-parms.html">Container image configuration values</a> that override the values in the container image Docker file.</p>
    pub fn image_config(&self) -> std::option::Option<&crate::model::ImageConfig> {
        self.image_config.as_ref()
    }
    /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
    pub fn ephemeral_storage(&self) -> std::option::Option<&crate::model::EphemeralStorage> {
        self.ephemeral_storage.as_ref()
    }
}
impl std::fmt::Debug for UpdateFunctionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionConfigurationInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("environment", &self.environment);
        formatter.field("runtime", &self.runtime);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("layers", &self.layers);
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("image_config", &self.image_config);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionCodeInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.</p>
    pub zip_file: std::option::Option<aws_smithy_types::Blob>,
    /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.</p>
    pub s3_key: std::option::Option<std::string::String>,
    /// <p>For versioned objects, the version of the deployment package object to use.</p>
    pub s3_object_version: std::option::Option<std::string::String>,
    /// <p>URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.</p>
    pub image_uri: std::option::Option<std::string::String>,
    /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
    pub publish: bool,
    /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
    pub dry_run: bool,
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl UpdateFunctionCodeInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment package.</p>
    pub fn zip_file(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.zip_file.as_ref()
    }
    /// <p>An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment package.</p>
    pub fn s3_key(&self) -> std::option::Option<&str> {
        self.s3_key.as_deref()
    }
    /// <p>For versioned objects, the version of the deployment package object to use.</p>
    pub fn s3_object_version(&self) -> std::option::Option<&str> {
        self.s3_object_version.as_deref()
    }
    /// <p>URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.</p>
    pub fn image_uri(&self) -> std::option::Option<&str> {
        self.image_uri.as_deref()
    }
    /// <p>Set to true to publish a new version of the function after updating the code. This has the same effect as calling <code>PublishVersion</code> separately.</p>
    pub fn publish(&self) -> bool {
        self.publish
    }
    /// <p>Set to true to validate the request parameters and access permissions without modifying the function code.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a function that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
}
impl std::fmt::Debug for UpdateFunctionCodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionCodeInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("zip_file", &"*** Sensitive Data Redacted ***");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_key", &self.s3_key);
        formatter.field("s3_object_version", &self.s3_object_version);
        formatter.field("image_uri", &self.image_uri);
        formatter.field("publish", &self.publish);
        formatter.field("dry_run", &self.dry_run);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("architectures", &self.architectures);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
    /// <p>Default: True</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
    /// </ul>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    pub filter_criteria: std::option::Option<crate::model::FilterCriteria>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl UpdateEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
    /// <p>Default: True</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
    /// </ul>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    pub fn filter_criteria(&self) -> std::option::Option<&crate::model::FilterCriteria> {
        self.filter_criteria.as_ref()
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for UpdateEventSourceMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEventSourceMappingInput");
        formatter.field("uuid", &self.uuid);
        formatter.field("function_name", &self.function_name);
        formatter.field("enabled", &self.enabled);
        formatter.field("batch_size", &self.batch_size);
        formatter.field("filter_criteria", &self.filter_criteria);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>Descriptive name for this code signing configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Signing profiles for this code signing configuration.</p>
    pub allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
    /// <p>The code signing policy.</p>
    pub code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
}
impl UpdateCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>Descriptive name for this code signing configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Signing profiles for this code signing configuration.</p>
    pub fn allowed_publishers(&self) -> std::option::Option<&crate::model::AllowedPublishers> {
        self.allowed_publishers.as_ref()
    }
    /// <p>The code signing policy.</p>
    pub fn code_signing_policies(&self) -> std::option::Option<&crate::model::CodeSigningPolicies> {
        self.code_signing_policies.as_ref()
    }
}
impl std::fmt::Debug for UpdateCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCodeSigningConfigInput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("description", &self.description);
        formatter.field("allowed_publishers", &self.allowed_publishers);
        formatter.field("code_signing_policies", &self.code_signing_policies);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
    /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl UpdateAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
    /// <p>Only update the alias if the revision ID matches the ID that's specified. Use this option to avoid modifying an alias that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAliasInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the function.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>A list of tag keys to remove from the function.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource", &self.resource);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>A list of tags to apply to the function.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The function's Amazon Resource Name (ARN).</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
    /// <p>A list of tags to apply to the function.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource", &self.resource);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemovePermissionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Statement ID of the permission to remove.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl RemovePermissionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Statement ID of the permission to remove.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>Specify a version or alias to remove permissions from a published version of the function.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for RemovePermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemovePermissionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveLayerVersionPermissionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version_number: i64,
    /// <p>The identifier that was specified when the statement was added.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl RemoveLayerVersionPermissionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version_number(&self) -> i64 {
        self.version_number
    }
    /// <p>The identifier that was specified when the statement was added.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for RemoveLayerVersionPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveLayerVersionPermissionInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("version_number", &self.version_number);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
    pub provisioned_concurrent_executions: std::option::Option<i32>,
}
impl PutProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>The amount of provisioned concurrency to allocate for the version or alias.</p>
    pub fn provisioned_concurrent_executions(&self) -> std::option::Option<i32> {
        self.provisioned_concurrent_executions
    }
}
impl std::fmt::Debug for PutProvisionedConcurrencyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProvisionedConcurrencyConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.field(
            "provisioned_concurrent_executions",
            &self.provisioned_concurrent_executions,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title"> <b>Destinations</b> </p>
    /// <ul>
    /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
    /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
    /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
    /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
    /// </ul>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
}
impl PutFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>The maximum number of times to retry when the function returns an error.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>The maximum age of a request that Lambda sends to a function for processing.</p>
    pub fn maximum_event_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_event_age_in_seconds
    }
    /// <p>A destination for events after they have been sent to a function for processing.</p>
    /// <p class="title"> <b>Destinations</b> </p>
    /// <ul>
    /// <li> <p> <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.</p> </li>
    /// <li> <p> <b>Queue</b> - The ARN of an SQS queue.</p> </li>
    /// <li> <p> <b>Topic</b> - The ARN of an SNS topic.</p> </li>
    /// <li> <p> <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.</p> </li>
    /// </ul>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
}
impl std::fmt::Debug for PutFunctionEventInvokeConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionEventInvokeConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The number of simultaneous executions to reserve for the function.</p>
    pub reserved_concurrent_executions: std::option::Option<i32>,
}
impl PutFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The number of simultaneous executions to reserve for the function.</p>
    pub fn reserved_concurrent_executions(&self) -> std::option::Option<i32> {
        self.reserved_concurrent_executions
    }
}
impl std::fmt::Debug for PutFunctionConcurrencyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionConcurrencyInput");
        formatter.field("function_name", &self.function_name);
        formatter.field(
            "reserved_concurrent_executions",
            &self.reserved_concurrent_executions,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFunctionCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl PutFunctionCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for PutFunctionCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFunctionCodeSigningConfigInput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishVersionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
    pub code_sha256: std::option::Option<std::string::String>,
    /// <p>A description for the version to override the description in the function configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl PublishVersionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Only publish a version if the hash value matches the value that's specified. Use this option to avoid publishing a version if the function code has changed since you last updated it. You can get the hash for the version that you uploaded from the output of <code>UpdateFunctionCode</code>.</p>
    pub fn code_sha256(&self) -> std::option::Option<&str> {
        self.code_sha256.as_deref()
    }
    /// <p>A description for the version to override the description in the function configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Only update the function if the revision ID matches the ID that's specified. Use this option to avoid publishing a version if the function configuration has changed since you last updated it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for PublishVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishVersionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("code_sha256", &self.code_sha256);
        formatter.field("description", &self.description);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PublishLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The description of the version.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The function layer archive.</p>
    pub content: std::option::Option<crate::model::LayerVersionContentInput>,
    /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
    pub compatible_runtimes: std::option::Option<std::vec::Vec<crate::model::Runtime>>,
    /// <p>The layer's software license. It can be any of the following:</p>
    /// <ul>
    /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
    /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
    /// <li> <p>The full text of the license.</p> </li>
    /// </ul>
    pub license_info: std::option::Option<std::string::String>,
    /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub compatible_architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
}
impl PublishLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The description of the version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The function layer archive.</p>
    pub fn content(&self) -> std::option::Option<&crate::model::LayerVersionContentInput> {
        self.content.as_ref()
    }
    /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used for filtering with <code>ListLayers</code> and <code>ListLayerVersions</code>.</p>
    pub fn compatible_runtimes(&self) -> std::option::Option<&[crate::model::Runtime]> {
        self.compatible_runtimes.as_deref()
    }
    /// <p>The layer's software license. It can be any of the following:</p>
    /// <ul>
    /// <li> <p>An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.</p> </li>
    /// <li> <p>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.</p> </li>
    /// <li> <p>The full text of the license.</p> </li>
    /// </ul>
    pub fn license_info(&self) -> std::option::Option<&str> {
        self.license_info.as_deref()
    }
    /// <p>A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architectures</a>.</p>
    pub fn compatible_architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.compatible_architectures.as_deref()
    }
}
impl std::fmt::Debug for PublishLayerVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PublishLayerVersionInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("description", &self.description);
        formatter.field("content", &self.content);
        formatter.field("compatible_runtimes", &self.compatible_runtimes);
        formatter.field("license_info", &self.license_info);
        formatter.field("compatible_architectures", &self.compatible_architectures);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVersionsByFunctionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListVersionsByFunctionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of versions to return. Note that <code>ListVersionsByFunction</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListVersionsByFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVersionsByFunctionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsInput {
    /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
    pub resource: std::option::Option<std::string::String>,
}
impl ListTagsInput {
    /// <p>The function's Amazon Resource Name (ARN). Note: Lambda does not support adding tags to aliases or versions.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
}
impl std::fmt::Debug for ListTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsInput");
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProvisionedConcurrencyConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Specify a number to limit the number of configurations returned.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListProvisionedConcurrencyConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Specify a number to limit the number of configurations returned.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListProvisionedConcurrencyConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProvisionedConcurrencyConfigsInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLayerVersionsInput {
    /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    pub compatible_runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>A pagination token returned by a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of versions to return.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    pub compatible_architecture: std::option::Option<crate::model::Architecture>,
}
impl ListLayerVersionsInput {
    /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    pub fn compatible_runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.compatible_runtime.as_ref()
    }
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>A pagination token returned by a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of versions to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    pub fn compatible_architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.compatible_architecture.as_ref()
    }
}
impl std::fmt::Debug for ListLayerVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLayerVersionsInput");
        formatter.field("compatible_runtime", &self.compatible_runtime);
        formatter.field("layer_name", &self.layer_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("compatible_architecture", &self.compatible_architecture);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLayersInput {
    /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    pub compatible_runtime: std::option::Option<crate::model::Runtime>,
    /// <p>A pagination token returned by a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of layers to return.</p>
    pub max_items: std::option::Option<i32>,
    /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    pub compatible_architecture: std::option::Option<crate::model::Architecture>,
}
impl ListLayersInput {
    /// <p>A runtime identifier. For example, <code>go1.x</code>.</p>
    pub fn compatible_runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.compatible_runtime.as_ref()
    }
    /// <p>A pagination token returned by a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of layers to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
    /// <p>The compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.</p>
    pub fn compatible_architecture(&self) -> std::option::Option<&crate::model::Architecture> {
        self.compatible_architecture.as_ref()
    }
}
impl std::fmt::Debug for ListLayersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLayersInput");
        formatter.field("compatible_runtime", &self.compatible_runtime);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.field("compatible_architecture", &self.compatible_architecture);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionUrlConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of function URLs to return in the response. Note that <code>ListFunctionUrlConfigs</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListFunctionUrlConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of function URLs to return in the response. Note that <code>ListFunctionUrlConfigs</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFunctionUrlConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionUrlConfigsInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsByCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Maximum number of items to return.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListFunctionsByCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Maximum number of items to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFunctionsByCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsByCodeSigningConfigInput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsInput {
    /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
    pub master_region: std::option::Option<std::string::String>,
    /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
    pub function_version: std::option::Option<crate::model::FunctionVersion>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListFunctionsInput {
    /// <p>For Lambda@Edge functions, the Amazon Web Services Region of the master function. For example, <code>us-east-1</code> filters the list of functions to only include Lambda@Edge functions replicated from a master function in US East (N. Virginia). If specified, you must set <code>FunctionVersion</code> to <code>ALL</code>.</p>
    pub fn master_region(&self) -> std::option::Option<&str> {
        self.master_region.as_deref()
    }
    /// <p>Set to <code>ALL</code> to include entries for all published versions of each function.</p>
    pub fn function_version(&self) -> std::option::Option<&crate::model::FunctionVersion> {
        self.function_version.as_ref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of functions to return in the response. Note that <code>ListFunctions</code> returns a maximum of 50 items in each response, even if you set the number higher.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFunctionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsInput");
        formatter.field("master_region", &self.master_region);
        formatter.field("function_version", &self.function_version);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionEventInvokeConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of configurations to return.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListFunctionEventInvokeConfigsInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of configurations to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListFunctionEventInvokeConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionEventInvokeConfigsInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEventSourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
    /// </ul>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A pagination token returned by a previous call.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListEventSourceMappingsInput {
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
    /// </ul>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A pagination token returned by a previous call.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The maximum number of event source mappings to return. Note that ListEventSourceMappings returns a maximum of 100 items in each response, even if you set the number higher.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListEventSourceMappingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEventSourceMappingsInput");
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_name", &self.function_name);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCodeSigningConfigsInput {
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Maximum number of items to return.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListCodeSigningConfigsInput {
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Maximum number of items to return.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListCodeSigningConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCodeSigningConfigsInput");
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAliasesInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify a function version to only list aliases that invoke that version.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Limit the number of aliases returned.</p>
    pub max_items: std::option::Option<i32>,
}
impl ListAliasesInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify a function version to only list aliases that invoke that version.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Limit the number of aliases returned.</p>
    pub fn max_items(&self) -> std::option::Option<i32> {
        self.max_items
    }
}
impl std::fmt::Debug for ListAliasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAliasesInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("function_version", &self.function_version);
        formatter.field("marker", &self.marker);
        formatter.field("max_items", &self.max_items);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct InvokeAsyncInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The JSON that you want to provide to your Lambda function as input.</p>
    pub invoke_args: aws_smithy_http::byte_stream::ByteStream,
}
impl InvokeAsyncInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The JSON that you want to provide to your Lambda function as input.</p>
    pub fn invoke_args(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.invoke_args
    }
}
impl std::fmt::Debug for InvokeAsyncInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeAsyncInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("invoke_args", &self.invoke_args);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Choose from the following options.</p>
    /// <ul>
    /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
    /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
    /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
    /// </ul>
    pub invocation_type: std::option::Option<crate::model::InvocationType>,
    /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
    pub log_type: std::option::Option<crate::model::LogType>,
    /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
    pub client_context: std::option::Option<std::string::String>,
    /// <p>The JSON that you want to provide to your Lambda function as input.</p>
    /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
    pub payload: std::option::Option<aws_smithy_types::Blob>,
    /// <p>Specify a version or alias to invoke a published version of the function.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl InvokeInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Choose from the following options.</p>
    /// <ul>
    /// <li> <p> <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the function returns a response or times out. The API response includes the function response and additional data.</p> </li>
    /// <li> <p> <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's dead-letter queue (if it's configured). The API response only includes a status code.</p> </li>
    /// <li> <p> <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the function.</p> </li>
    /// </ul>
    pub fn invocation_type(&self) -> std::option::Option<&crate::model::InvocationType> {
        self.invocation_type.as_ref()
    }
    /// <p>Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions only.</p>
    pub fn log_type(&self) -> std::option::Option<&crate::model::LogType> {
        self.log_type.as_ref()
    }
    /// <p>Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.</p>
    pub fn client_context(&self) -> std::option::Option<&str> {
        self.client_context.as_deref()
    }
    /// <p>The JSON that you want to provide to your Lambda function as input.</p>
    /// <p>You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a file path. For example, <code>--payload file://payload.json</code>. </p>
    pub fn payload(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.payload.as_ref()
    }
    /// <p>Specify a version or alias to invoke a published version of the function.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for InvokeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("invocation_type", &self.invocation_type);
        formatter.field("log_type", &self.log_type);
        formatter.field("client_context", &self.client_context);
        formatter.field("payload", &"*** Sensitive Data Redacted ***");
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetProvisionedConcurrencyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProvisionedConcurrencyConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify a version or alias to get the policy for that resource.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetPolicyInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify a version or alias to get the policy for that resource.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionPolicyInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version_number: i64,
}
impl GetLayerVersionPolicyInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version_number(&self) -> i64 {
        self.version_number
    }
}
impl std::fmt::Debug for GetLayerVersionPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionPolicyInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionByArnInput {
    /// <p>The ARN of the layer version.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl GetLayerVersionByArnInput {
    /// <p>The ARN of the layer version.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for GetLayerVersionByArnInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionByArnInput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version_number: i64,
}
impl GetLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version_number(&self) -> i64 {
        self.version_number
    }
}
impl std::fmt::Debug for GetLayerVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLayerVersionInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionUrlConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionUrlConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionEventInvokeConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionEventInvokeConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionConfigurationInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify a version or alias to get details about a published version of the function.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetFunctionConfigurationInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify a version or alias to get details about a published version of the function.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionConfigurationInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl GetFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionConcurrencyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionConcurrencyInput");
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionCodeSigningConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl GetFunctionCodeSigningConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionCodeSigningConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify a version or alias to get details about a published version of the function.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl GetFunctionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify a version or alias to get details about a published version of the function.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
}
impl GetEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
}
impl std::fmt::Debug for GetEventSourceMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEventSourceMappingInput");
        formatter.field("uuid", &self.uuid);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
}
impl GetCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration. </p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
}
impl std::fmt::Debug for GetCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCodeSigningConfigInput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAliasInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSettingsInput {}
impl std::fmt::Debug for GetAccountSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl DeleteProvisionedConcurrencyConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteProvisionedConcurrencyConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProvisionedConcurrencyConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version_number: i64,
}
impl DeleteLayerVersionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version_number(&self) -> i64 {
        self.version_number
    }
}
impl std::fmt::Debug for DeleteLayerVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLayerVersionInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("version_number", &self.version_number);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl DeleteFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionUrlConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionUrlConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A version number or alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl DeleteFunctionEventInvokeConfigInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A version number or alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionEventInvokeConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionEventInvokeConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl DeleteFunctionConcurrencyInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionConcurrencyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionConcurrencyInput");
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionCodeSigningConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
}
impl DeleteFunctionCodeSigningConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionCodeSigningConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionInput {
    /// <p>The name of the Lambda function or version.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
    pub qualifier: std::option::Option<std::string::String>,
}
impl DeleteFunctionInput {
    /// <p>The name of the Lambda function or version.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:1</code> (with version).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>Specify a version to delete. You can't delete a version that's referenced by an alias.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub uuid: std::option::Option<std::string::String>,
}
impl DeleteEventSourceMappingInput {
    /// <p>The identifier of the event source mapping.</p>
    pub fn uuid(&self) -> std::option::Option<&str> {
        self.uuid.as_deref()
    }
}
impl std::fmt::Debug for DeleteEventSourceMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSourceMappingInput");
        formatter.field("uuid", &self.uuid);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
}
impl DeleteCodeSigningConfigInput {
    /// <p>The The Amazon Resource Name (ARN) of the code signing configuration.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCodeSigningConfigInput");
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAliasInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The alias name.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
    /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
    pub cors: std::option::Option<crate::model::Cors>,
}
impl CreateFunctionUrlConfigInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The alias name.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub fn auth_type(&self) -> std::option::Option<&crate::model::FunctionUrlAuthType> {
        self.auth_type.as_ref()
    }
    /// <p>The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a> settings for your function URL.</p>
    pub fn cors(&self) -> std::option::Option<&crate::model::Cors> {
        self.cors.as_ref()
    }
}
impl std::fmt::Debug for CreateFunctionUrlConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionUrlConfigInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("cors", &self.cors);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    pub role: std::option::Option<std::string::String>,
    /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    pub handler: std::option::Option<std::string::String>,
    /// <p>The code for the function.</p>
    pub code: std::option::Option<crate::model::FunctionCode>,
    /// <p>A description of the function.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    pub timeout: std::option::Option<i32>,
    /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    pub memory_size: std::option::Option<i32>,
    /// <p>Set to true to publish the first version of the function during creation.</p>
    pub publish: bool,
    /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
    pub package_type: std::option::Option<crate::model::PackageType>,
    /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>Environment variables that are accessible from function code during execution.</p>
    pub environment: std::option::Option<crate::model::Environment>,
    /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    pub tracing_config: std::option::Option<crate::model::TracingConfig>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    pub layers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Connection settings for an Amazon EFS file system.</p>
    pub file_system_configs: std::option::Option<std::vec::Vec<crate::model::FileSystemConfig>>,
    /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
    pub image_config: std::option::Option<crate::model::ImageConfig>,
    /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
    pub code_signing_config_arn: std::option::Option<std::string::String>,
    /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    pub architectures: std::option::Option<std::vec::Vec<crate::model::Architecture>>,
    /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
    pub ephemeral_storage: std::option::Option<crate::model::EphemeralStorage>,
}
impl CreateFunctionInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The identifier of the function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the deployment package is a .zip file archive. </p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the function's execution role.</p>
    pub fn role(&self) -> std::option::Option<&str> {
        self.role.as_deref()
    }
    /// <p>The name of the method within your code that Lambda calls to execute your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.</p>
    pub fn handler(&self) -> std::option::Option<&str> {
        self.handler.as_deref()
    }
    /// <p>The code for the function.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::FunctionCode> {
        self.code.as_ref()
    }
    /// <p>A description of the function.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.</p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.</p>
    pub fn memory_size(&self) -> std::option::Option<i32> {
        self.memory_size
    }
    /// <p>Set to true to publish the first version of the function during creation.</p>
    pub fn publish(&self) -> bool {
        self.publish
    }
    /// <p>For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP archive.</p>
    pub fn package_type(&self) -> std::option::Option<&crate::model::PackageType> {
        self.package_type.as_ref()
    }
    /// <p>A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.</p>
    pub fn dead_letter_config(&self) -> std::option::Option<&crate::model::DeadLetterConfig> {
        self.dead_letter_config.as_ref()
    }
    /// <p>Environment variables that are accessible from function code during execution.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::Environment> {
        self.environment.as_ref()
    }
    /// <p>The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's environment variables. If it's not provided, Lambda uses a default service key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.</p>
    pub fn tracing_config(&self) -> std::option::Option<&crate::model::TracingConfig> {
        self.tracing_config.as_ref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the version.</p>
    pub fn layers(&self) -> std::option::Option<&[std::string::String]> {
        self.layers.as_deref()
    }
    /// <p>Connection settings for an Amazon EFS file system.</p>
    pub fn file_system_configs(&self) -> std::option::Option<&[crate::model::FileSystemConfig]> {
        self.file_system_configs.as_deref()
    }
    /// <p>Container image <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings">configuration values</a> that override the values in the container image Dockerfile.</p>
    pub fn image_config(&self) -> std::option::Option<&crate::model::ImageConfig> {
        self.image_config.as_ref()
    }
    /// <p>To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.</p>
    pub fn code_signing_config_arn(&self) -> std::option::Option<&str> {
        self.code_signing_config_arn.as_deref()
    }
    /// <p>The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is <code>x86_64</code>.</p>
    pub fn architectures(&self) -> std::option::Option<&[crate::model::Architecture]> {
        self.architectures.as_deref()
    }
    /// <p>The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between 512 and 10240 MB.</p>
    pub fn ephemeral_storage(&self) -> std::option::Option<&crate::model::EphemeralStorage> {
        self.ephemeral_storage.as_ref()
    }
}
impl std::fmt::Debug for CreateFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("runtime", &self.runtime);
        formatter.field("role", &self.role);
        formatter.field("handler", &self.handler);
        formatter.field("code", &self.code);
        formatter.field("description", &self.description);
        formatter.field("timeout", &self.timeout);
        formatter.field("memory_size", &self.memory_size);
        formatter.field("publish", &self.publish);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("package_type", &self.package_type);
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("environment", &self.environment);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tracing_config", &self.tracing_config);
        formatter.field("tags", &self.tags);
        formatter.field("layers", &self.layers);
        formatter.field("file_system_configs", &self.file_system_configs);
        formatter.field("image_config", &self.image_config);
        formatter.field("code_signing_config_arn", &self.code_signing_config_arn);
        formatter.field("architectures", &self.architectures);
        formatter.field("ephemeral_storage", &self.ephemeral_storage);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSourceMappingInput {
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
    /// </ul>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
    /// <p>Default: True</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
    /// </ul>
    pub batch_size: std::option::Option<i32>,
    /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    pub filter_criteria: std::option::Option<crate::model::FilterCriteria>,
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub maximum_batching_window_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    pub parallelization_factor: std::option::Option<i32>,
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
    pub starting_position: std::option::Option<crate::model::EventSourcePosition>,
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    pub starting_position_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub destination_config: std::option::Option<crate::model::DestinationConfig>,
    /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    pub maximum_record_age_in_seconds: std::option::Option<i32>,
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    pub bisect_batch_on_function_error: std::option::Option<bool>,
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    pub tumbling_window_in_seconds: std::option::Option<i32>,
    /// <p>The name of the Kafka topic.</p>
    pub topics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
    pub queues: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    pub source_access_configurations:
        std::option::Option<std::vec::Vec<crate::model::SourceAccessConfiguration>>,
    /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
    pub self_managed_event_source: std::option::Option<crate::model::SelfManagedEventSource>,
    /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    pub function_response_types:
        std::option::Option<std::vec::Vec<crate::model::FunctionResponseType>>,
}
impl CreateEventSourceMappingInput {
    /// <p>The Amazon Resource Name (ARN) of the event source.</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - The ARN of the data stream or a stream consumer.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - The ARN of the stream.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - The ARN of the queue.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - The ARN of the cluster.</p> </li>
    /// </ul>
    pub fn event_source_arn(&self) -> std::option::Option<&str> {
        self.event_source_arn.as_deref()
    }
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
    /// <p>Default: True</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).</p>
    /// <ul>
    /// <li> <p> <b>Amazon Kinesis</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.</p> </li>
    /// <li> <p> <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</p> </li>
    /// <li> <p> <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.</p> </li>
    /// <li> <p> <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> - Default 100. Max 10,000.</p> </li>
    /// </ul>
    pub fn batch_size(&self) -> std::option::Option<i32> {
        self.batch_size
    }
    /// <p>(Streams and Amazon SQS) An object that defines the filter criteria that determine whether Lambda should process an event. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a>.</p>
    pub fn filter_criteria(&self) -> std::option::Option<&crate::model::FilterCriteria> {
        self.filter_criteria.as_ref()
    }
    /// <p>(Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.</p>
    /// <p>Default: 0</p>
    /// <p>Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.</p>
    pub fn maximum_batching_window_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_batching_window_in_seconds
    }
    /// <p>(Streams only) The number of batches to process from each shard concurrently.</p>
    pub fn parallelization_factor(&self) -> std::option::Option<i32> {
        self.parallelization_factor
    }
    /// <p>The position in a stream from which to start reading. Required for Amazon Kinesis, Amazon DynamoDB, and Amazon MSK Streams sources. <code>AT_TIMESTAMP</code> is only supported for Amazon Kinesis streams.</p>
    pub fn starting_position(&self) -> std::option::Option<&crate::model::EventSourcePosition> {
        self.starting_position.as_ref()
    }
    /// <p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading.</p>
    pub fn starting_position_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.starting_position_timestamp.as_ref()
    }
    /// <p>(Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.</p>
    pub fn destination_config(&self) -> std::option::Option<&crate::model::DestinationConfig> {
        self.destination_config.as_ref()
    }
    /// <p>(Streams only) Discard records older than the specified age. The default value is infinite (-1).</p>
    pub fn maximum_record_age_in_seconds(&self) -> std::option::Option<i32> {
        self.maximum_record_age_in_seconds
    }
    /// <p>(Streams only) If the function returns an error, split the batch in two and retry.</p>
    pub fn bisect_batch_on_function_error(&self) -> std::option::Option<bool> {
        self.bisect_batch_on_function_error
    }
    /// <p>(Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When set to infinite (-1), failed records will be retried until the record expires.</p>
    pub fn maximum_retry_attempts(&self) -> std::option::Option<i32> {
        self.maximum_retry_attempts
    }
    /// <p>(Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.</p>
    pub fn tumbling_window_in_seconds(&self) -> std::option::Option<i32> {
        self.tumbling_window_in_seconds
    }
    /// <p>The name of the Kafka topic.</p>
    pub fn topics(&self) -> std::option::Option<&[std::string::String]> {
        self.topics.as_deref()
    }
    /// <p> (MQ) The name of the Amazon MQ broker destination queue to consume. </p>
    pub fn queues(&self) -> std::option::Option<&[std::string::String]> {
        self.queues.as_deref()
    }
    /// <p>An array of authentication protocols or VPC components required to secure your event source.</p>
    pub fn source_access_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::SourceAccessConfiguration]> {
        self.source_access_configurations.as_deref()
    }
    /// <p>The Self-Managed Apache Kafka cluster to send records.</p>
    pub fn self_managed_event_source(
        &self,
    ) -> std::option::Option<&crate::model::SelfManagedEventSource> {
        self.self_managed_event_source.as_ref()
    }
    /// <p>(Streams and Amazon SQS) A list of current response type enums applied to the event source mapping.</p>
    pub fn function_response_types(
        &self,
    ) -> std::option::Option<&[crate::model::FunctionResponseType]> {
        self.function_response_types.as_deref()
    }
}
impl std::fmt::Debug for CreateEventSourceMappingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSourceMappingInput");
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("function_name", &self.function_name);
        formatter.field("enabled", &self.enabled);
        formatter.field("batch_size", &self.batch_size);
        formatter.field("filter_criteria", &self.filter_criteria);
        formatter.field(
            "maximum_batching_window_in_seconds",
            &self.maximum_batching_window_in_seconds,
        );
        formatter.field("parallelization_factor", &self.parallelization_factor);
        formatter.field("starting_position", &self.starting_position);
        formatter.field(
            "starting_position_timestamp",
            &self.starting_position_timestamp,
        );
        formatter.field("destination_config", &self.destination_config);
        formatter.field(
            "maximum_record_age_in_seconds",
            &self.maximum_record_age_in_seconds,
        );
        formatter.field(
            "bisect_batch_on_function_error",
            &self.bisect_batch_on_function_error,
        );
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "tumbling_window_in_seconds",
            &self.tumbling_window_in_seconds,
        );
        formatter.field("topics", &self.topics);
        formatter.field("queues", &self.queues);
        formatter.field(
            "source_access_configurations",
            &self.source_access_configurations,
        );
        formatter.field("self_managed_event_source", &self.self_managed_event_source);
        formatter.field("function_response_types", &self.function_response_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCodeSigningConfigInput {
    /// <p>Descriptive name for this code signing configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Signing profiles for this code signing configuration.</p>
    pub allowed_publishers: std::option::Option<crate::model::AllowedPublishers>,
    /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
    pub code_signing_policies: std::option::Option<crate::model::CodeSigningPolicies>,
}
impl CreateCodeSigningConfigInput {
    /// <p>Descriptive name for this code signing configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Signing profiles for this code signing configuration.</p>
    pub fn allowed_publishers(&self) -> std::option::Option<&crate::model::AllowedPublishers> {
        self.allowed_publishers.as_ref()
    }
    /// <p>The code signing policies define the actions to take if the validation checks fail. </p>
    pub fn code_signing_policies(&self) -> std::option::Option<&crate::model::CodeSigningPolicies> {
        self.code_signing_policies.as_ref()
    }
}
impl std::fmt::Debug for CreateCodeSigningConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCodeSigningConfigInput");
        formatter.field("description", &self.description);
        formatter.field("allowed_publishers", &self.allowed_publishers);
        formatter.field("code_signing_policies", &self.code_signing_policies);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>The name of the alias.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The function version that the alias invokes.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>A description of the alias.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    pub routing_config: std::option::Option<crate::model::AliasRoutingConfiguration>,
}
impl CreateAliasInput {
    /// <p>The name of the Lambda function.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>MyFunction</code>.</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.</p> </li>
    /// </ul>
    /// <p>The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>The name of the alias.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The function version that the alias invokes.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>A description of the alias.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing">routing configuration</a> of the alias.</p>
    pub fn routing_config(&self) -> std::option::Option<&crate::model::AliasRoutingConfiguration> {
        self.routing_config.as_ref()
    }
}
impl std::fmt::Debug for CreateAliasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAliasInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("name", &self.name);
        formatter.field("function_version", &self.function_version);
        formatter.field("description", &self.description);
        formatter.field("routing_config", &self.routing_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddPermissionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub function_name: std::option::Option<std::string::String>,
    /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
    /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
    pub source_account: std::option::Option<std::string::String>,
    /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
    pub event_source_token: std::option::Option<std::string::String>,
    /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
    pub qualifier: std::option::Option<std::string::String>,
    /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.</p>
    pub principal_org_id: std::option::Option<std::string::String>,
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub function_url_auth_type: std::option::Option<crate::model::FunctionUrlAuthType>,
}
impl AddPermissionInput {
    /// <p>The name of the Lambda function, version, or alias.</p>
    /// <p class="title"> <b>Name formats</b> </p>
    /// <ul>
    /// <li> <p> <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).</p> </li>
    /// <li> <p> <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.</p> </li>
    /// <li> <p> <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.</p> </li>
    /// </ul>
    /// <p>You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.</p>
    pub fn function_name(&self) -> std::option::Option<&str> {
        self.function_name.as_deref()
    }
    /// <p>A statement identifier that differentiates the statement from others in the same policy.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code>.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The Amazon Web Services service or account that invokes the function. If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.</p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
    /// <p>Note that Lambda configures the comparison using the <code>StringLike</code> operator.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.</p>
    pub fn source_account(&self) -> std::option::Option<&str> {
        self.source_account.as_deref()
    }
    /// <p>For Alexa Smart Home functions, a token that must be supplied by the invoker.</p>
    pub fn event_source_token(&self) -> std::option::Option<&str> {
        self.event_source_token.as_deref()
    }
    /// <p>Specify a version or alias to add permissions to a published version of the function.</p>
    pub fn qualifier(&self) -> std::option::Option<&str> {
        self.qualifier.as_deref()
    }
    /// <p>Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The identifier for your organization in Organizations. Use this to grant permissions to all the Amazon Web Services accounts under this organization.</p>
    pub fn principal_org_id(&self) -> std::option::Option<&str> {
        self.principal_org_id.as_deref()
    }
    /// <p>The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict access to authenticated <code>IAM</code> users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html"> Security and auth model for Lambda function URLs</a>.</p>
    pub fn function_url_auth_type(
        &self,
    ) -> std::option::Option<&crate::model::FunctionUrlAuthType> {
        self.function_url_auth_type.as_ref()
    }
}
impl std::fmt::Debug for AddPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddPermissionInput");
        formatter.field("function_name", &self.function_name);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("action", &self.action);
        formatter.field("principal", &self.principal);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("source_account", &self.source_account);
        formatter.field("event_source_token", &self.event_source_token);
        formatter.field("qualifier", &self.qualifier);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("principal_org_id", &self.principal_org_id);
        formatter.field("function_url_auth_type", &self.function_url_auth_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddLayerVersionPermissionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub layer_name: std::option::Option<std::string::String>,
    /// <p>The version number.</p>
    pub version_number: i64,
    /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
    pub statement_id: std::option::Option<std::string::String>,
    /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
    pub principal: std::option::Option<std::string::String>,
    /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
    pub organization_id: std::option::Option<std::string::String>,
    /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl AddLayerVersionPermissionInput {
    /// <p>The name or Amazon Resource Name (ARN) of the layer.</p>
    pub fn layer_name(&self) -> std::option::Option<&str> {
        self.layer_name.as_deref()
    }
    /// <p>The version number.</p>
    pub fn version_number(&self) -> i64 {
        self.version_number
    }
    /// <p>An identifier that distinguishes the policy from others on the same layer version.</p>
    pub fn statement_id(&self) -> std::option::Option<&str> {
        self.statement_id.as_deref()
    }
    /// <p>The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>An account ID, or <code>*</code> to grant layer usage permission to all accounts in an organization, or all Amazon Web Services accounts (if <code>organizationId</code> is not specified). For the last case, make sure that you really do want all Amazon Web Services accounts to have usage permission to this layer. </p>
    pub fn principal(&self) -> std::option::Option<&str> {
        self.principal.as_deref()
    }
    /// <p>With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.</p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
    /// <p>Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy that has changed since you last read it.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for AddLayerVersionPermissionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddLayerVersionPermissionInput");
        formatter.field("layer_name", &self.layer_name);
        formatter.field("version_number", &self.version_number);
        formatter.field("statement_id", &self.statement_id);
        formatter.field("action", &self.action);
        formatter.field("principal", &self.principal);
        formatter.field("organization_id", &self.organization_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}
